/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.thetadata.generated.Price;
import net.thetadata.generated.ZonedDateTime;
import net.thetadata.types.tick.QuoteTick;
import net.thetadata.types.tick.Tick;
import net.thetadata.types.tick.TradeQuoteTick;
import net.thetadata.types.tick.TradeTick;
import net.thetadata.utils.TimeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StreamUtils {
    private static final Logger logger = LogManager.getLogger(StreamUtils.class);
    private static final Price ZERO_PRICE = Price.newBuilder().setValue(0).setType(0).build();

    public static <T extends Tick> Stream<T> aggregateTicks(Stream<T> quoteStream, int intervalInMs) {
        if (intervalInMs == 0) {
            return quoteStream;
        }
        Map intervalTickMap = quoteStream.collect(Collectors.groupingBy(tick -> tick.time() / intervalInMs, Collectors.reducing((t1, t2) -> t1.time() > t2.time() ? t1 : t2)));
        return intervalTickMap.values().stream().filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparingInt(Tick::time));
    }

    public static <T extends Tick> Stream<T> aggregateTicks(Stream<T> tickStream, int intervalInMs, int startMsInDay, int endMsInDay, int dataInterval, Function<Integer, T> zeroTickFunction) {
        if (intervalInMs == 0) {
            return tickStream.filter(t2 -> t2.time() >= startMsInDay && t2.time() <= endMsInDay);
        }
        ArrayList<Tick> results = new ArrayList<Tick>((endMsInDay - startMsInDay) / intervalInMs);
        int curMsOfDay = startMsInDay;
        Iterator tickIterator = tickStream.iterator();
        if (!tickIterator.hasNext()) {
            return Stream.empty();
        }
        Tick tick = (Tick)tickIterator.next();
        Tick lastTick = (Tick)zeroTickFunction.apply(startMsInDay);
        int curTime = -dataInterval;
        while (tickIterator.hasNext() && curMsOfDay <= endMsInDay) {
            curTime = dataInterval == 0 ? tick.time() : (curTime += dataInterval);
            if (curTime > curMsOfDay) {
                lastTick.setTime(curMsOfDay);
                results.add(lastTick.clone());
                curMsOfDay += intervalInMs;
                curTime -= dataInterval;
                continue;
            }
            lastTick = tick;
            tick = (Tick)tickIterator.next();
        }
        curTime = dataInterval == 0 ? tick.time() : (curTime += dataInterval);
        while (curMsOfDay <= endMsInDay) {
            if (curTime > curMsOfDay) {
                lastTick.setTime(curMsOfDay);
                results.add(lastTick.clone());
            } else {
                tick.setTime(curMsOfDay);
                results.add(tick.clone());
            }
            curMsOfDay += intervalInMs;
        }
        return results.stream();
    }

    private static boolean compareMsOfDay(int quote_ms, int trade_ms, boolean exclusive) {
        if (exclusive) {
            return quote_ms < trade_ms;
        }
        return quote_ms <= trade_ms;
    }

    public static Stream<TradeQuoteTick> generateTradeQuoteStream(Iterator<TradeTick> tradeIterator, Iterator<QuoteTick> quoteIterator, boolean exclusive) {
        QuoteTick curQuote;
        QuoteTick lastQuote = curQuote = quoteIterator.next();
        ArrayList<TradeQuoteTick> res = new ArrayList<TradeQuoteTick>();
        if (curQuote == null) {
            throw new IllegalArgumentException("No quotes!");
        }
        while (tradeIterator.hasNext()) {
            TradeTick curTrade = tradeIterator.next();
            while (StreamUtils.compareMsOfDay(curQuote.msOfDay(), curTrade.msOfDay(), exclusive)) {
                lastQuote = curQuote;
                curQuote = quoteIterator.next();
                if (curQuote != null) continue;
                logger.warn("End of quote stream");
                break;
            }
            res.add(new TradeQuoteTick(curTrade, lastQuote));
        }
        return res.stream();
    }

    public static <S extends Tick, O extends Tick> Stream<Pair<S, O>> combineStockOptionTicks(List<S> stockTicks, Stream<O> optionTicks) {
        Tick curStock;
        Iterator<S> stockIterator = stockTicks.iterator();
        Iterator optionIterator = optionTicks.iterator();
        Tick lastStock = curStock = (Tick)stockIterator.next();
        ArrayList<Pair<Tick, Tick>> results = new ArrayList<Pair<Tick, Tick>>();
        while (optionIterator.hasNext()) {
            Tick curOption = (Tick)optionIterator.next();
            while (curStock.time() <= curOption.time() && stockIterator.hasNext()) {
                lastStock = curStock;
                curStock = (Tick)stockIterator.next();
            }
            if (!stockIterator.hasNext()) {
                lastStock = curStock;
            }
            results.add(Pair.of(lastStock, curOption));
        }
        return results.stream();
    }

    public static <T> net.thetadata.types.Price[] minMaxPrice(List<T> ticks, Function<T, net.thetadata.types.Price> toPrice) {
        if (ticks.isEmpty()) {
            throw new IllegalArgumentException("Empty ticks");
        }
        net.thetadata.types.Price[] ret = new net.thetadata.types.Price[]{toPrice.apply(ticks.get(0)), toPrice.apply(ticks.get(0))};
        for (int i = 1; i < ticks.size(); ++i) {
            net.thetadata.types.Price price = toPrice.apply(ticks.get(i));
            if (price.compareTo(ret[0]) < 0) {
                ret[0] = price;
                continue;
            }
            if (price.compareTo(ret[1]) <= 0) continue;
            ret[1] = price;
        }
        return ret;
    }

    public static Stream<OHLC> computeOHLC(Stream<TradeTick> tradeStream, int date, int intervalMs, int startMs, int endMs) {
        Preconditions.checkArgument(startMs < endMs, "Start must be before end");
        Preconditions.checkArgument(intervalMs > 0, "Interval must be positive");
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("America/New_York"));
        if (date == TimeUtils.calendar2Int(now)) {
            endMs = TimeUtils.msOfDay(now);
        }
        Map<Integer, List<TradeTick>> groupedTradeStream = tradeStream.filter(trade -> !trade.isCancelled() && trade.priceType() != 0).collect(Collectors.groupingBy(trade -> trade.msOfDay() / intervalMs * intervalMs));
        int finalEndMs = endMs;
        return IntStream.iterate(startMs, t2 -> t2 < finalEndMs, t2 -> t2 + intervalMs).mapToObj(i -> {
            List unfilteredTradeTicks = (List)groupedTradeStream.get(i);
            if (unfilteredTradeTicks == null || unfilteredTradeTicks.isEmpty()) {
                return new OHLC(TimeUtils.toZonedDateTimeMessage(TimeUtils.getZonedDateTime(date, i, ZoneId.of("America/New_York"))), ZERO_PRICE, ZERO_PRICE, ZERO_PRICE, ZERO_PRICE, 0, 0);
            }
            List<TradeTick> ohlcTradeTicks = unfilteredTradeTicks.stream().filter(tt -> {
                boolean tradePriceConditions = !tt.tradeConditionNoLast() && tt.priceConditionSetLast();
                boolean volumeHours = tt.isIncrementalVolume() && !tt.regularTradingHours() && !tt.isSeller();
                return tradePriceConditions || volumeHours;
            }).sorted((t1, t2) -> Ints.compare(t1.msOfDay(), t2.msOfDay())).toList();
            List<TradeTick> sizeVolumeTradeTicks = unfilteredTradeTicks.stream().filter(TradeTick::isIncrementalVolume).toList();
            Price open = ZERO_PRICE;
            Price high = ZERO_PRICE;
            Price low = ZERO_PRICE;
            Price close = ZERO_PRICE;
            if (!ohlcTradeTicks.isEmpty()) {
                TradeTick firstTrade = ohlcTradeTicks.get(0);
                TradeTick lastTrade = ohlcTradeTicks.get(ohlcTradeTicks.size() - 1);
                net.thetadata.types.Price[] minMaxPrices = StreamUtils.minMaxPrice(ohlcTradeTicks, TradeTick::getPrice);
                open = firstTrade.getPriceMessage();
                high = minMaxPrices[1].toPriceMessage();
                low = minMaxPrices[0].toPriceMessage();
                close = lastTrade.getPriceMessage();
            }
            int volume = sizeVolumeTradeTicks.stream().mapToInt(TradeTick::size).sum();
            return new OHLC(TimeUtils.toZonedDateTimeMessage(TimeUtils.getZonedDateTime(date, i, ZoneId.of("America/New_York"))), open, high, low, close, volume, sizeVolumeTradeTicks.size());
        });
    }

    public static <T> Stream<List<T>> batch(Stream<T> stream, int batchSize) {
        Stream<Integer> indexStream = Stream.iterate(0, i -> i + 1);
        return Streams.zip(indexStream, stream, Pair::of).collect(Collectors.groupingBy(p -> (Integer)p.getLeft() / batchSize, Collectors.mapping(Pair::getRight, Collectors.toList()))).values().stream();
    }

    public record OHLC(ZonedDateTime timestamp, Price open, Price high, Price low, Price close, int volume, int count) {
    }
}

