# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CheckRestApiArgs', 'CheckRestApi']

@pulumi.input_type
class CheckRestApiArgs:
    def __init__(__self__, *,
                 connected_service_name: pulumi.Input[_builtins.str],
                 connected_service_name_selector: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 method: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 target_resource_id: pulumi.Input[_builtins.str],
                 target_resource_type: pulumi.Input[_builtins.str],
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 completion_event: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 success_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CheckRestApi resource.
        :param pulumi.Input[_builtins.str] connected_service_name: The name of the Service Connection.
        :param pulumi.Input[_builtins.str] connected_service_name_selector: The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        :param pulumi.Input[_builtins.str] display_name: The Name of the Rest API check.
        :param pulumi.Input[_builtins.str] method: The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        :param pulumi.Input[_builtins.str] project_id: The ID of the project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the resource being protected by the check. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] target_resource_type: The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] body: The Rest API request body.
        :param pulumi.Input[_builtins.str] completion_event: The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        :param pulumi.Input[_builtins.str] headers: The headers of the request in JSON format.
        :param pulumi.Input[_builtins.int] retry_interval: The time between evaluations (minutes). 
               
               ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
               <br>2. `retry_interval` is not required when `completion_event=Callback`.
        :param pulumi.Input[_builtins.str] success_criteria: The Criteria which defines when to pass the task. No criteria means response content does not influence the result.
               
               ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        :param pulumi.Input[_builtins.int] timeout: The timeout in minutes for the Rest API check. Defaults to `1440`.
        :param pulumi.Input[_builtins.str] url_suffix: The URL suffix and parameters.
        :param pulumi.Input[_builtins.str] variable_group_name: The name of the Variable Group.
        """
        pulumi.set(__self__, "connected_service_name", connected_service_name)
        pulumi.set(__self__, "connected_service_name_selector", connected_service_name_selector)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        pulumi.set(__self__, "target_resource_type", target_resource_type)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if completion_event is not None:
            pulumi.set(__self__, "completion_event", completion_event)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if success_criteria is not None:
            pulumi.set(__self__, "success_criteria", success_criteria)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_suffix is not None:
            pulumi.set(__self__, "url_suffix", url_suffix)
        if variable_group_name is not None:
            pulumi.set(__self__, "variable_group_name", variable_group_name)

    @_builtins.property
    @pulumi.getter(name="connectedServiceName")
    def connected_service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Service Connection.
        """
        return pulumi.get(self, "connected_service_name")

    @connected_service_name.setter
    def connected_service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connected_service_name", value)

    @_builtins.property
    @pulumi.getter(name="connectedServiceNameSelector")
    def connected_service_name_selector(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        """
        return pulumi.get(self, "connected_service_name_selector")

    @connected_service_name_selector.setter
    def connected_service_name_selector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connected_service_name_selector", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Rest API check.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Input[_builtins.str]:
        """
        The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource being protected by the check. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rest API request body.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="completionEvent")
    def completion_event(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        """
        return pulumi.get(self, "completion_event")

    @completion_event.setter
    def completion_event(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "completion_event", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The headers of the request in JSON format.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time between evaluations (minutes). 

        ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
        <br>2. `retry_interval` is not required when `completion_event=Callback`.
        """
        return pulumi.get(self, "retry_interval")

    @retry_interval.setter
    def retry_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_interval", value)

    @_builtins.property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Criteria which defines when to pass the task. No criteria means response content does not influence the result.

        ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        """
        return pulumi.get(self, "success_criteria")

    @success_criteria.setter
    def success_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "success_criteria", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in minutes for the Rest API check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="urlSuffix")
    def url_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL suffix and parameters.
        """
        return pulumi.get(self, "url_suffix")

    @url_suffix.setter
    def url_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_suffix", value)

    @_builtins.property
    @pulumi.getter(name="variableGroupName")
    def variable_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Variable Group.
        """
        return pulumi.get(self, "variable_group_name")

    @variable_group_name.setter
    def variable_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_group_name", value)


@pulumi.input_type
class _CheckRestApiState:
    def __init__(__self__, *,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 completion_event: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 success_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering CheckRestApi resources.
        :param pulumi.Input[_builtins.str] body: The Rest API request body.
        :param pulumi.Input[_builtins.str] completion_event: The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        :param pulumi.Input[_builtins.str] connected_service_name: The name of the Service Connection.
        :param pulumi.Input[_builtins.str] connected_service_name_selector: The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        :param pulumi.Input[_builtins.str] display_name: The Name of the Rest API check.
        :param pulumi.Input[_builtins.str] headers: The headers of the request in JSON format.
        :param pulumi.Input[_builtins.str] method: The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        :param pulumi.Input[_builtins.str] project_id: The ID of the project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retry_interval: The time between evaluations (minutes). 
               
               ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
               <br>2. `retry_interval` is not required when `completion_event=Callback`.
        :param pulumi.Input[_builtins.str] success_criteria: The Criteria which defines when to pass the task. No criteria means response content does not influence the result.
               
               ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the resource being protected by the check. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] target_resource_type: The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] timeout: The timeout in minutes for the Rest API check. Defaults to `1440`.
        :param pulumi.Input[_builtins.str] url_suffix: The URL suffix and parameters.
        :param pulumi.Input[_builtins.str] variable_group_name: The name of the Variable Group.
        :param pulumi.Input[_builtins.int] version: The version of the Rest API check.
        """
        if body is not None:
            pulumi.set(__self__, "body", body)
        if completion_event is not None:
            pulumi.set(__self__, "completion_event", completion_event)
        if connected_service_name is not None:
            pulumi.set(__self__, "connected_service_name", connected_service_name)
        if connected_service_name_selector is not None:
            pulumi.set(__self__, "connected_service_name_selector", connected_service_name_selector)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if retry_interval is not None:
            pulumi.set(__self__, "retry_interval", retry_interval)
        if success_criteria is not None:
            pulumi.set(__self__, "success_criteria", success_criteria)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_suffix is not None:
            pulumi.set(__self__, "url_suffix", url_suffix)
        if variable_group_name is not None:
            pulumi.set(__self__, "variable_group_name", variable_group_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Rest API request body.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="completionEvent")
    def completion_event(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        """
        return pulumi.get(self, "completion_event")

    @completion_event.setter
    def completion_event(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "completion_event", value)

    @_builtins.property
    @pulumi.getter(name="connectedServiceName")
    def connected_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Connection.
        """
        return pulumi.get(self, "connected_service_name")

    @connected_service_name.setter
    def connected_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connected_service_name", value)

    @_builtins.property
    @pulumi.getter(name="connectedServiceNameSelector")
    def connected_service_name_selector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        """
        return pulumi.get(self, "connected_service_name_selector")

    @connected_service_name_selector.setter
    def connected_service_name_selector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connected_service_name_selector", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Rest API check.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The headers of the request in JSON format.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "headers", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time between evaluations (minutes). 

        ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
        <br>2. `retry_interval` is not required when `completion_event=Callback`.
        """
        return pulumi.get(self, "retry_interval")

    @retry_interval.setter
    def retry_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_interval", value)

    @_builtins.property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Criteria which defines when to pass the task. No criteria means response content does not influence the result.

        ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        """
        return pulumi.get(self, "success_criteria")

    @success_criteria.setter
    def success_criteria(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "success_criteria", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource being protected by the check. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout in minutes for the Rest API check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter(name="urlSuffix")
    def url_suffix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL suffix and parameters.
        """
        return pulumi.get(self, "url_suffix")

    @url_suffix.setter
    def url_suffix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_suffix", value)

    @_builtins.property
    @pulumi.getter(name="variableGroupName")
    def variable_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Variable Group.
        """
        return pulumi.get(self, "variable_group_name")

    @variable_group_name.setter
    def variable_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "variable_group_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Rest API check.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azuredevops:index/checkRestApi:CheckRestApi")
class CheckRestApi(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 completion_event: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 success_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Rest API check on a resource within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_service_endpoint_generic = azuredevops.ServiceEndpointGeneric("example",
            project_id=example.id,
            server_url="https://some-server.example.com",
            service_endpoint_name="Example Generic",
            username="username",
            password="password",
            description="Managed by Pulumi")
        example_azure = azuredevops.ServiceEndpointGeneric("example_azure",
            project_id=example.id,
            server_url="https://dev.azure.com/",
            service_endpoint_name="Example Generic Azure",
            username="username",
            password="dummy")
        example_variable_group = azuredevops.VariableGroup("example",
            project_id=example.id,
            name="Example Variable Group",
            allow_access=True,
            variables=[{
                "name": "FOO",
                "value": "BAR",
            }])
        example_check_rest_api = azuredevops.CheckRestApi("example",
            project_id=example.id,
            target_resource_id=example_service_endpoint_generic.id,
            target_resource_type="endpoint",
            display_name="Example REST API Check",
            connected_service_name_selector="connectedServiceName",
            connected_service_name=example_azure.service_endpoint_name,
            method="POST",
            headers="{\\"contentType\\":\\"application/json\\"}",
            body="{\\"params\\":\\"value\\"}",
            completion_event="ApiResponse",
            success_criteria="eq(root['status'], '200')",
            url_suffix="user/1",
            retry_interval=4000,
            variable_group_name=example_variable_group.name,
            timeout=40000)
        ```

        ## Relevant Links

        - [Define approvals and checks](https://learn.microsoft.com/en-us/azure/devops/pipelines/process/approvals?view=azure-devops&tabs=check-pass)

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: The Rest API request body.
        :param pulumi.Input[_builtins.str] completion_event: The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        :param pulumi.Input[_builtins.str] connected_service_name: The name of the Service Connection.
        :param pulumi.Input[_builtins.str] connected_service_name_selector: The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        :param pulumi.Input[_builtins.str] display_name: The Name of the Rest API check.
        :param pulumi.Input[_builtins.str] headers: The headers of the request in JSON format.
        :param pulumi.Input[_builtins.str] method: The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        :param pulumi.Input[_builtins.str] project_id: The ID of the project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retry_interval: The time between evaluations (minutes). 
               
               ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
               <br>2. `retry_interval` is not required when `completion_event=Callback`.
        :param pulumi.Input[_builtins.str] success_criteria: The Criteria which defines when to pass the task. No criteria means response content does not influence the result.
               
               ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the resource being protected by the check. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] target_resource_type: The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] timeout: The timeout in minutes for the Rest API check. Defaults to `1440`.
        :param pulumi.Input[_builtins.str] url_suffix: The URL suffix and parameters.
        :param pulumi.Input[_builtins.str] variable_group_name: The name of the Variable Group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckRestApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Rest API check on a resource within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example", name="Example Project")
        example_service_endpoint_generic = azuredevops.ServiceEndpointGeneric("example",
            project_id=example.id,
            server_url="https://some-server.example.com",
            service_endpoint_name="Example Generic",
            username="username",
            password="password",
            description="Managed by Pulumi")
        example_azure = azuredevops.ServiceEndpointGeneric("example_azure",
            project_id=example.id,
            server_url="https://dev.azure.com/",
            service_endpoint_name="Example Generic Azure",
            username="username",
            password="dummy")
        example_variable_group = azuredevops.VariableGroup("example",
            project_id=example.id,
            name="Example Variable Group",
            allow_access=True,
            variables=[{
                "name": "FOO",
                "value": "BAR",
            }])
        example_check_rest_api = azuredevops.CheckRestApi("example",
            project_id=example.id,
            target_resource_id=example_service_endpoint_generic.id,
            target_resource_type="endpoint",
            display_name="Example REST API Check",
            connected_service_name_selector="connectedServiceName",
            connected_service_name=example_azure.service_endpoint_name,
            method="POST",
            headers="{\\"contentType\\":\\"application/json\\"}",
            body="{\\"params\\":\\"value\\"}",
            completion_event="ApiResponse",
            success_criteria="eq(root['status'], '200')",
            url_suffix="user/1",
            retry_interval=4000,
            variable_group_name=example_variable_group.name,
            timeout=40000)
        ```

        ## Relevant Links

        - [Define approvals and checks](https://learn.microsoft.com/en-us/azure/devops/pipelines/process/approvals?view=azure-devops&tabs=check-pass)

        ## Import

        Importing this resource is not supported.

        :param str resource_name: The name of the resource.
        :param CheckRestApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckRestApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 completion_event: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 connected_service_name_selector: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 headers: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 success_criteria: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 url_suffix: Optional[pulumi.Input[_builtins.str]] = None,
                 variable_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckRestApiArgs.__new__(CheckRestApiArgs)

            __props__.__dict__["body"] = body
            __props__.__dict__["completion_event"] = completion_event
            if connected_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'connected_service_name'")
            __props__.__dict__["connected_service_name"] = connected_service_name
            if connected_service_name_selector is None and not opts.urn:
                raise TypeError("Missing required property 'connected_service_name_selector'")
            __props__.__dict__["connected_service_name_selector"] = connected_service_name_selector
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["headers"] = headers
            if method is None and not opts.urn:
                raise TypeError("Missing required property 'method'")
            __props__.__dict__["method"] = method
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["retry_interval"] = retry_interval
            __props__.__dict__["success_criteria"] = success_criteria
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
            if target_resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_type'")
            __props__.__dict__["target_resource_type"] = target_resource_type
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["url_suffix"] = url_suffix
            __props__.__dict__["variable_group_name"] = variable_group_name
            __props__.__dict__["version"] = None
        super(CheckRestApi, __self__).__init__(
            'azuredevops:index/checkRestApi:CheckRestApi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            completion_event: Optional[pulumi.Input[_builtins.str]] = None,
            connected_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            connected_service_name_selector: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            headers: Optional[pulumi.Input[_builtins.str]] = None,
            method: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            retry_interval: Optional[pulumi.Input[_builtins.int]] = None,
            success_criteria: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            url_suffix: Optional[pulumi.Input[_builtins.str]] = None,
            variable_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'CheckRestApi':
        """
        Get an existing CheckRestApi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] body: The Rest API request body.
        :param pulumi.Input[_builtins.str] completion_event: The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        :param pulumi.Input[_builtins.str] connected_service_name: The name of the Service Connection.
        :param pulumi.Input[_builtins.str] connected_service_name_selector: The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        :param pulumi.Input[_builtins.str] display_name: The Name of the Rest API check.
        :param pulumi.Input[_builtins.str] headers: The headers of the request in JSON format.
        :param pulumi.Input[_builtins.str] method: The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        :param pulumi.Input[_builtins.str] project_id: The ID of the project. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retry_interval: The time between evaluations (minutes). 
               
               ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
               <br>2. `retry_interval` is not required when `completion_event=Callback`.
        :param pulumi.Input[_builtins.str] success_criteria: The Criteria which defines when to pass the task. No criteria means response content does not influence the result.
               
               ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the resource being protected by the check. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] target_resource_type: The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] timeout: The timeout in minutes for the Rest API check. Defaults to `1440`.
        :param pulumi.Input[_builtins.str] url_suffix: The URL suffix and parameters.
        :param pulumi.Input[_builtins.str] variable_group_name: The name of the Variable Group.
        :param pulumi.Input[_builtins.int] version: The version of the Rest API check.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckRestApiState.__new__(_CheckRestApiState)

        __props__.__dict__["body"] = body
        __props__.__dict__["completion_event"] = completion_event
        __props__.__dict__["connected_service_name"] = connected_service_name
        __props__.__dict__["connected_service_name_selector"] = connected_service_name_selector
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["headers"] = headers
        __props__.__dict__["method"] = method
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["retry_interval"] = retry_interval
        __props__.__dict__["success_criteria"] = success_criteria
        __props__.__dict__["target_resource_id"] = target_resource_id
        __props__.__dict__["target_resource_type"] = target_resource_type
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["url_suffix"] = url_suffix
        __props__.__dict__["variable_group_name"] = variable_group_name
        __props__.__dict__["version"] = version
        return CheckRestApi(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Rest API request body.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="completionEvent")
    def completion_event(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The completion event of the Rest API call. Possible values: `Callback`, `ApiResponse`. Defaults to `Callback`.
        """
        return pulumi.get(self, "completion_event")

    @_builtins.property
    @pulumi.getter(name="connectedServiceName")
    def connected_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Connection.
        """
        return pulumi.get(self, "connected_service_name")

    @_builtins.property
    @pulumi.getter(name="connectedServiceNameSelector")
    def connected_service_name_selector(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Service Connection used to invoke the REST API. Possible values: `connectedServiceName`(**Generic** type service connection) and `connectedServiceNameARM`(**Azure Resource Manager** type service connection).
        """
        return pulumi.get(self, "connected_service_name_selector")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Rest API check.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The headers of the request in JSON format.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Output[_builtins.str]:
        """
        The HTTP method of the request. Possible values: `OPTIONS`, `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `TRACE`, `PATCH`
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time between evaluations (minutes). 

        ~>**NOTE** 1. The retry times should less them 10 based on the timeout. For example: `timeout` is `4000` then `retry_interval` should be `0` or no less then `400`.
        <br>2. `retry_interval` is not required when `completion_event=Callback`.
        """
        return pulumi.get(self, "retry_interval")

    @_builtins.property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Criteria which defines when to pass the task. No criteria means response content does not influence the result.

        ~>**NOTE** `success_criteria` is used when `completion_event=ApiResponse`
        """
        return pulumi.get(self, "success_criteria")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource being protected by the check. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "target_resource_id")

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of resource being protected by the check. Possible values: `endpoint`, `environment`, `queue`, `repository`, `securefile`, `variablegroup`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_type")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timeout in minutes for the Rest API check. Defaults to `1440`.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="urlSuffix")
    def url_suffix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URL suffix and parameters.
        """
        return pulumi.get(self, "url_suffix")

    @_builtins.property
    @pulumi.getter(name="variableGroupName")
    def variable_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Variable Group.
        """
        return pulumi.get(self, "variable_group_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Rest API check.
        """
        return pulumi.get(self, "version")

