# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetPoolsResult',
    'AwaitableGetPoolsResult',
    'get_pools',
    'get_pools_output',
]

@pulumi.output_type
class GetPoolsResult:
    """
    A collection of values returned by getPools.
    """
    def __init__(__self__, agent_pools=None, id=None):
        if agent_pools and not isinstance(agent_pools, list):
            raise TypeError("Expected argument 'agent_pools' to be a list")
        pulumi.set(__self__, "agent_pools", agent_pools)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="agentPools")
    def agent_pools(self) -> Sequence['outputs.GetPoolsAgentPoolResult']:
        """
        An `agent_pools` blocks as documented below. A list of existing agent pools in your Azure DevOps Organization with the following details about every agent pool:
        """
        return pulumi.get(self, "agent_pools")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetPoolsResult(GetPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPoolsResult(
            agent_pools=self.agent_pools,
            id=self.id)


def get_pools(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPoolsResult:
    """
    Use this data source to access information about existing Agent Pools within Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_pools()
    pulumi.export("agentPoolName", [__item.name for __item in example.agent_pools])
    pulumi.export("autoProvision", [__item.auto_provision for __item in example.agent_pools])
    pulumi.export("autoUpdate", [__item.auto_update for __item in example.agent_pools])
    pulumi.export("poolType", [__item.pool_type for __item in example.agent_pools])
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Agent Pools - Get](https://docs.microsoft.com/en-us/rest/api/azure/devops/distributedtask/pools/get?view=azure-devops-rest-7.1)
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getPools:getPools', __args__, opts=opts, typ=GetPoolsResult).value

    return AwaitableGetPoolsResult(
        agent_pools=pulumi.get(__ret__, 'agent_pools'),
        id=pulumi.get(__ret__, 'id'))
def get_pools_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPoolsResult]:
    """
    Use this data source to access information about existing Agent Pools within Azure DevOps.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_pools()
    pulumi.export("agentPoolName", [__item.name for __item in example.agent_pools])
    pulumi.export("autoProvision", [__item.auto_provision for __item in example.agent_pools])
    pulumi.export("autoUpdate", [__item.auto_update for __item in example.agent_pools])
    pulumi.export("poolType", [__item.pool_type for __item in example.agent_pools])
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Agent Pools - Get](https://docs.microsoft.com/en-us/rest/api/azure/devops/distributedtask/pools/get?view=azure-devops-rest-7.1)
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getPools:getPools', __args__, opts=opts, typ=GetPoolsResult)
    return __ret__.apply(lambda __response__: GetPoolsResult(
        agent_pools=pulumi.get(__response__, 'agent_pools'),
        id=pulumi.get(__response__, 'id')))
