# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetServiceendpointDockerregistryResult',
    'AwaitableGetServiceendpointDockerregistryResult',
    'get_serviceendpoint_dockerregistry',
    'get_serviceendpoint_dockerregistry_output',
]

@pulumi.output_type
class GetServiceendpointDockerregistryResult:
    """
    A collection of values returned by getServiceendpointDockerregistry.
    """
    def __init__(__self__, authorization=None, description=None, docker_email=None, docker_password=None, docker_registry=None, docker_username=None, id=None, project_id=None, registry_type=None, service_endpoint_id=None, service_endpoint_name=None):
        if authorization and not isinstance(authorization, dict):
            raise TypeError("Expected argument 'authorization' to be a dict")
        pulumi.set(__self__, "authorization", authorization)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if docker_email and not isinstance(docker_email, str):
            raise TypeError("Expected argument 'docker_email' to be a str")
        pulumi.set(__self__, "docker_email", docker_email)
        if docker_password and not isinstance(docker_password, str):
            raise TypeError("Expected argument 'docker_password' to be a str")
        pulumi.set(__self__, "docker_password", docker_password)
        if docker_registry and not isinstance(docker_registry, str):
            raise TypeError("Expected argument 'docker_registry' to be a str")
        pulumi.set(__self__, "docker_registry", docker_registry)
        if docker_username and not isinstance(docker_username, str):
            raise TypeError("Expected argument 'docker_username' to be a str")
        pulumi.set(__self__, "docker_username", docker_username)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if registry_type and not isinstance(registry_type, str):
            raise TypeError("Expected argument 'registry_type' to be a str")
        pulumi.set(__self__, "registry_type", registry_type)
        if service_endpoint_id and not isinstance(service_endpoint_id, str):
            raise TypeError("Expected argument 'service_endpoint_id' to be a str")
        pulumi.set(__self__, "service_endpoint_id", service_endpoint_id)
        if service_endpoint_name and not isinstance(service_endpoint_name, str):
            raise TypeError("Expected argument 'service_endpoint_name' to be a str")
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Mapping[str, _builtins.str]:
        """
        The Authorization scheme.
        """
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The Service Endpoint description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dockerEmail")
    def docker_email(self) -> _builtins.str:
        """
        The email for Docker account user.
        """
        return pulumi.get(self, "docker_email")

    @_builtins.property
    @pulumi.getter(name="dockerPassword")
    def docker_password(self) -> _builtins.str:
        """
        The password for the account user identified above.
        """
        return pulumi.get(self, "docker_password")

    @_builtins.property
    @pulumi.getter(name="dockerRegistry")
    def docker_registry(self) -> _builtins.str:
        """
        The URL of the Docker registry.
        """
        return pulumi.get(self, "docker_registry")

    @_builtins.property
    @pulumi.getter(name="dockerUsername")
    def docker_username(self) -> _builtins.str:
        """
        The identifier of the Docker account user.
        """
        return pulumi.get(self, "docker_username")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> _builtins.str:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> _builtins.str:
        """
        Can be "DockerHub" or "Others" (Default "DockerHub")
        """
        return pulumi.get(self, "registry_type")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointId")
    def service_endpoint_id(self) -> _builtins.str:
        return pulumi.get(self, "service_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> _builtins.str:
        return pulumi.get(self, "service_endpoint_name")


class AwaitableGetServiceendpointDockerregistryResult(GetServiceendpointDockerregistryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceendpointDockerregistryResult(
            authorization=self.authorization,
            description=self.description,
            docker_email=self.docker_email,
            docker_password=self.docker_password,
            docker_registry=self.docker_registry,
            docker_username=self.docker_username,
            id=self.id,
            project_id=self.project_id,
            registry_type=self.registry_type,
            service_endpoint_id=self.service_endpoint_id,
            service_endpoint_name=self.service_endpoint_name)


def get_serviceendpoint_dockerregistry(project_id: Optional[_builtins.str] = None,
                                       service_endpoint_id: Optional[_builtins.str] = None,
                                       service_endpoint_name: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceendpointDockerregistryResult:
    """
    Use this data source to access information about an existing Docker Registry Service Endpoint.

    ## Example Usage

    ### By Service Endpoint ID

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_serviceendpoint_dockerregistry = azuredevops.get_serviceendpoint_dockerregistry(project_id=example.id,
        service_endpoint_id="00000000-0000-0000-0000-000000000000")
    pulumi.export("serviceEndpointName", example_get_serviceendpoint_dockerregistry.service_endpoint_name)
    ```

    ### By Service Endpoint Name

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_serviceendpoint_dockerregistry = azuredevops.get_serviceendpoint_dockerregistry(project_id=example.id,
        service_endpoint_name="Example-Service-Endpoint")
    pulumi.export("serviceEndpointId", serviceendpoint["id"])
    ```


    :param _builtins.str project_id: The ID of the project.
    :param _builtins.str service_endpoint_id: the ID of the Service Endpoint.
    :param _builtins.str service_endpoint_name: the Name of the Service Endpoint.
           
           > **NOTE:** 1. One of either `service_endpoint_id` or `service_endpoint_name` must be specified.
           <br>2. When supplying `service_endpoint_name`, take care to ensure that this is a unique name.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['serviceEndpointId'] = service_endpoint_id
    __args__['serviceEndpointName'] = service_endpoint_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getServiceendpointDockerregistry:getServiceendpointDockerregistry', __args__, opts=opts, typ=GetServiceendpointDockerregistryResult).value

    return AwaitableGetServiceendpointDockerregistryResult(
        authorization=pulumi.get(__ret__, 'authorization'),
        description=pulumi.get(__ret__, 'description'),
        docker_email=pulumi.get(__ret__, 'docker_email'),
        docker_password=pulumi.get(__ret__, 'docker_password'),
        docker_registry=pulumi.get(__ret__, 'docker_registry'),
        docker_username=pulumi.get(__ret__, 'docker_username'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        registry_type=pulumi.get(__ret__, 'registry_type'),
        service_endpoint_id=pulumi.get(__ret__, 'service_endpoint_id'),
        service_endpoint_name=pulumi.get(__ret__, 'service_endpoint_name'))
def get_serviceendpoint_dockerregistry_output(project_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              service_endpoint_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              service_endpoint_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceendpointDockerregistryResult]:
    """
    Use this data source to access information about an existing Docker Registry Service Endpoint.

    ## Example Usage

    ### By Service Endpoint ID

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_serviceendpoint_dockerregistry = azuredevops.get_serviceendpoint_dockerregistry(project_id=example.id,
        service_endpoint_id="00000000-0000-0000-0000-000000000000")
    pulumi.export("serviceEndpointName", example_get_serviceendpoint_dockerregistry.service_endpoint_name)
    ```

    ### By Service Endpoint Name

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_project(name="Example Project")
    example_get_serviceendpoint_dockerregistry = azuredevops.get_serviceendpoint_dockerregistry(project_id=example.id,
        service_endpoint_name="Example-Service-Endpoint")
    pulumi.export("serviceEndpointId", serviceendpoint["id"])
    ```


    :param _builtins.str project_id: The ID of the project.
    :param _builtins.str service_endpoint_id: the ID of the Service Endpoint.
    :param _builtins.str service_endpoint_name: the Name of the Service Endpoint.
           
           > **NOTE:** 1. One of either `service_endpoint_id` or `service_endpoint_name` must be specified.
           <br>2. When supplying `service_endpoint_name`, take care to ensure that this is a unique name.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    __args__['serviceEndpointId'] = service_endpoint_id
    __args__['serviceEndpointName'] = service_endpoint_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getServiceendpointDockerregistry:getServiceendpointDockerregistry', __args__, opts=opts, typ=GetServiceendpointDockerregistryResult)
    return __ret__.apply(lambda __response__: GetServiceendpointDockerregistryResult(
        authorization=pulumi.get(__response__, 'authorization'),
        description=pulumi.get(__response__, 'description'),
        docker_email=pulumi.get(__response__, 'docker_email'),
        docker_password=pulumi.get(__response__, 'docker_password'),
        docker_registry=pulumi.get(__response__, 'docker_registry'),
        docker_username=pulumi.get(__response__, 'docker_username'),
        id=pulumi.get(__response__, 'id'),
        project_id=pulumi.get(__response__, 'project_id'),
        registry_type=pulumi.get(__response__, 'registry_type'),
        service_endpoint_id=pulumi.get(__response__, 'service_endpoint_id'),
        service_endpoint_name=pulumi.get(__response__, 'service_endpoint_name')))
