# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, descriptor=None, display_name=None, domain=None, id=None, mail_address=None, origin=None, origin_id=None, principal_name=None, subject_kind=None):
        if descriptor and not isinstance(descriptor, str):
            raise TypeError("Expected argument 'descriptor' to be a str")
        pulumi.set(__self__, "descriptor", descriptor)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mail_address and not isinstance(mail_address, str):
            raise TypeError("Expected argument 'mail_address' to be a str")
        pulumi.set(__self__, "mail_address", mail_address)
        if origin and not isinstance(origin, str):
            raise TypeError("Expected argument 'origin' to be a str")
        pulumi.set(__self__, "origin", origin)
        if origin_id and not isinstance(origin_id, str):
            raise TypeError("Expected argument 'origin_id' to be a str")
        pulumi.set(__self__, "origin_id", origin_id)
        if principal_name and not isinstance(principal_name, str):
            raise TypeError("Expected argument 'principal_name' to be a str")
        pulumi.set(__self__, "principal_name", principal_name)
        if subject_kind and not isinstance(subject_kind, str):
            raise TypeError("Expected argument 'subject_kind' to be a str")
        pulumi.set(__self__, "subject_kind", subject_kind)

    @_builtins.property
    @pulumi.getter
    def descriptor(self) -> _builtins.str:
        return pulumi.get(self, "descriptor")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the User.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        The domain of the user.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="mailAddress")
    def mail_address(self) -> _builtins.str:
        """
        The email address of the user.
        """
        return pulumi.get(self, "mail_address")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> _builtins.str:
        """
        The type of source provider for the origin identifier (ex:`AD`, `AAD`, `MSA`).
        """
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="originId")
    def origin_id(self) -> _builtins.str:
        """
        The origin ID of the user.
        """
        return pulumi.get(self, "origin_id")

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> _builtins.str:
        """
        The principal name of the user.
        """
        return pulumi.get(self, "principal_name")

    @_builtins.property
    @pulumi.getter(name="subjectKind")
    def subject_kind(self) -> _builtins.str:
        """
        The subject kind of the user (ex: `Group`, `Scope`, `User`).
        """
        return pulumi.get(self, "subject_kind")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            descriptor=self.descriptor,
            display_name=self.display_name,
            domain=self.domain,
            id=self.id,
            mail_address=self.mail_address,
            origin=self.origin,
            origin_id=self.origin_id,
            principal_name=self.principal_name,
            subject_kind=self.subject_kind)


def get_user(descriptor: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to access information about an existing user within Azure DevOps.

    ~>**NOTE:** If you only have the Storage Key(UUID) of the user, you can use `get_descriptor` to resolve the Storage Key(UUID) to a `descriptor`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_user(descriptor="descriptor")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Graph Users API](https://learn.microsoft.com/en-us/rest/api/azure/devops/graph/users/get?view=azure-devops-rest-7.1)


    :param _builtins.str descriptor: The descriptor of the user.
    """
    __args__ = dict()
    __args__['descriptor'] = descriptor
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuredevops:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        descriptor=pulumi.get(__ret__, 'descriptor'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        id=pulumi.get(__ret__, 'id'),
        mail_address=pulumi.get(__ret__, 'mail_address'),
        origin=pulumi.get(__ret__, 'origin'),
        origin_id=pulumi.get(__ret__, 'origin_id'),
        principal_name=pulumi.get(__ret__, 'principal_name'),
        subject_kind=pulumi.get(__ret__, 'subject_kind'))
def get_user_output(descriptor: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to access information about an existing user within Azure DevOps.

    ~>**NOTE:** If you only have the Storage Key(UUID) of the user, you can use `get_descriptor` to resolve the Storage Key(UUID) to a `descriptor`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuredevops as azuredevops

    example = azuredevops.get_user(descriptor="descriptor")
    ```

    ## Relevant Links

    - [Azure DevOps Service REST API 7.1 - Graph Users API](https://learn.microsoft.com/en-us/rest/api/azure/devops/graph/users/get?view=azure-devops-rest-7.1)


    :param _builtins.str descriptor: The descriptor of the user.
    """
    __args__ = dict()
    __args__['descriptor'] = descriptor
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuredevops:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult)
    return __ret__.apply(lambda __response__: GetUserResult(
        descriptor=pulumi.get(__response__, 'descriptor'),
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        id=pulumi.get(__response__, 'id'),
        mail_address=pulumi.get(__response__, 'mail_address'),
        origin=pulumi.get(__response__, 'origin'),
        origin_id=pulumi.get(__response__, 'origin_id'),
        principal_name=pulumi.get(__response__, 'principal_name'),
        subject_kind=pulumi.get(__response__, 'subject_kind')))
