# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitPermissionsArgs', 'GitPermissions']

@pulumi.input_type
class GitPermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 principal: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 branch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GitPermissions resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available
               
               | Permissions             | Description                                            |
               |-------------------------|--------------------------------------------------------|
               | Administer              | Administer                                             |
               | GenericRead             | Read                                                   |
               | GenericContribute       | Contribute                                             |
               | ForcePush               | Force push (rewrite history, delete branches and tags) |
               | CreateBranch            | Create branch                                          |
               | CreateTag               | Create tag                                             |
               | ManageNote              | Manage notes                                           |
               | PolicyExempt            | Bypass policies when pushing                           |
               | CreateRepository        | Create repository                                      |
               | DeleteRepository        | Delete repository                                      |
               | RenameRepository        | Rename repository                                      |
               | EditPolicies            | Edit policies                                          |
               | RemoveOthersLocks       | Remove others' locks                                   |
               | ManagePermissions       | Manage permissions                                     |
               | PullRequestContribute   | Contribute to pull requests                            |
               | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
               
               > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
               as resource ID. It is recommended to check before use.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project to assign the permissions.
        :param pulumi.Input[_builtins.str] branch_name: The name of the branch to assign the permissions.
               
               > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] repository_id: The ID of the GIT repository to assign the permissions
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "project_id", project_id)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        the permissions to assign. The following permissions are available

        | Permissions             | Description                                            |
        |-------------------------|--------------------------------------------------------|
        | Administer              | Administer                                             |
        | GenericRead             | Read                                                   |
        | GenericContribute       | Contribute                                             |
        | ForcePush               | Force push (rewrite history, delete branches and tags) |
        | CreateBranch            | Create branch                                          |
        | CreateTag               | Create tag                                             |
        | ManageNote              | Manage notes                                           |
        | PolicyExempt            | Bypass policies when pushing                           |
        | CreateRepository        | Create repository                                      |
        | DeleteRepository        | Delete repository                                      |
        | RenameRepository        | Rename repository                                      |
        | EditPolicies            | Edit policies                                          |
        | RemoveOthersLocks       | Remove others' locks                                   |
        | ManagePermissions       | Manage permissions                                     |
        | PullRequestContribute   | Contribute to pull requests                            |
        | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        The **group** principal to assign the permissions.

        > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
        as resource ID. It is recommended to check before use.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project to assign the permissions.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the branch to assign the permissions.

        > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch_name", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the GIT repository to assign the permissions
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.input_type
class _GitPermissionsState:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitPermissions resources.
        :param pulumi.Input[_builtins.str] branch_name: The name of the branch to assign the permissions.
               
               > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available
               
               | Permissions             | Description                                            |
               |-------------------------|--------------------------------------------------------|
               | Administer              | Administer                                             |
               | GenericRead             | Read                                                   |
               | GenericContribute       | Contribute                                             |
               | ForcePush               | Force push (rewrite history, delete branches and tags) |
               | CreateBranch            | Create branch                                          |
               | CreateTag               | Create tag                                             |
               | ManageNote              | Manage notes                                           |
               | PolicyExempt            | Bypass policies when pushing                           |
               | CreateRepository        | Create repository                                      |
               | DeleteRepository        | Delete repository                                      |
               | RenameRepository        | Rename repository                                      |
               | EditPolicies            | Edit policies                                          |
               | RemoveOthersLocks       | Remove others' locks                                   |
               | ManagePermissions       | Manage permissions                                     |
               | PullRequestContribute   | Contribute to pull requests                            |
               | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
               
               > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
               as resource ID. It is recommended to check before use.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project to assign the permissions.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] repository_id: The ID of the GIT repository to assign the permissions
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the branch to assign the permissions.

        > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch_name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        the permissions to assign. The following permissions are available

        | Permissions             | Description                                            |
        |-------------------------|--------------------------------------------------------|
        | Administer              | Administer                                             |
        | GenericRead             | Read                                                   |
        | GenericContribute       | Contribute                                             |
        | ForcePush               | Force push (rewrite history, delete branches and tags) |
        | CreateBranch            | Create branch                                          |
        | CreateTag               | Create tag                                             |
        | ManageNote              | Manage notes                                           |
        | PolicyExempt            | Bypass policies when pushing                           |
        | CreateRepository        | Create repository                                      |
        | DeleteRepository        | Delete repository                                      |
        | RenameRepository        | Rename repository                                      |
        | EditPolicies            | Edit policies                                          |
        | RemoveOthersLocks       | Remove others' locks                                   |
        | ManagePermissions       | Manage permissions                                     |
        | PullRequestContribute   | Contribute to pull requests                            |
        | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **group** principal to assign the permissions.

        > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
        as resource ID. It is recommended to check before use.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project to assign the permissions.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the GIT repository to assign the permissions
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("azuredevops:index/gitPermissions:GitPermissions")
class GitPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages permissions for Git repositories.

        > **Note** Permissions can be assigned to group principals and not to single user principals.

        ## Permission levels

        Permission for Git Repositories within Azure DevOps can be applied on three different levels.
        Those levels are reflected by specifying (or omitting) values for the arguments `project_id`, `repository_id` and `branch_name`.

        ### Project level

        Permissions for all Git Repositories inside a project (existing or newly created ones) are specified, if only the argument `project_id` has a value.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example.id,
            principal=example_readers.id,
            permissions={
                "CreateRepository": "Deny",
                "DeleteRepository": "Deny",
                "RenameRepository": "NotSet",
            })
        ```

        ### Repository level

        Permissions for a specific Git Repository and all existing or newly created branches are specified if the arguments `project_id` and `repository_id` are set.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_group = azuredevops.get_group(name="Project Collection Administrators")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            principal=example_group.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ManagePermissions": "Deny",
                "CreateTag": "Deny",
                "CreateBranch": "NotSet",
            })
        ```

        ### Branch level

        Permissions for a specific branch inside a Git Repository are specified if all above mentioned the arguments are set.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_group = azuredevops.get_group(name="Project Collection Administrators")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            branch_name="refs/heads/master",
            principal=example_group.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ForcePush": "Deny",
            })
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_project_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_project_contributors = azuredevops.get_group_output(project_id=example.id,
            name="Contributors")
        example_project_administrators = azuredevops.get_group_output(project_id=example.id,
            name="Project administrators")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example.id,
            principal=example_project_readers.id,
            permissions={
                "CreateRepository": "Deny",
                "DeleteRepository": "Deny",
                "RenameRepository": "NotSet",
            })
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="TestRepo",
            default_branch="refs/heads/master",
            initialization={
                "init_type": "Clean",
            })
        example_repo_permissions = azuredevops.GitPermissions("example-repo-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            principal=example_project_administrators.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ManagePermissions": "Deny",
                "CreateTag": "Deny",
                "CreateBranch": "NotSet",
            })
        example_branch_permissions = azuredevops.GitPermissions("example-branch-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            branch_name="master",
            principal=example_project_contributors.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ForcePush": "Deny",
            })
        ```

        ## Relevant Links

        * [Azure DevOps Service REST API 7.0 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] branch_name: The name of the branch to assign the permissions.
               
               > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available
               
               | Permissions             | Description                                            |
               |-------------------------|--------------------------------------------------------|
               | Administer              | Administer                                             |
               | GenericRead             | Read                                                   |
               | GenericContribute       | Contribute                                             |
               | ForcePush               | Force push (rewrite history, delete branches and tags) |
               | CreateBranch            | Create branch                                          |
               | CreateTag               | Create tag                                             |
               | ManageNote              | Manage notes                                           |
               | PolicyExempt            | Bypass policies when pushing                           |
               | CreateRepository        | Create repository                                      |
               | DeleteRepository        | Delete repository                                      |
               | RenameRepository        | Rename repository                                      |
               | EditPolicies            | Edit policies                                          |
               | RemoveOthersLocks       | Remove others' locks                                   |
               | ManagePermissions       | Manage permissions                                     |
               | PullRequestContribute   | Contribute to pull requests                            |
               | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
               
               > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
               as resource ID. It is recommended to check before use.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project to assign the permissions.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] repository_id: The ID of the GIT repository to assign the permissions
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages permissions for Git repositories.

        > **Note** Permissions can be assigned to group principals and not to single user principals.

        ## Permission levels

        Permission for Git Repositories within Azure DevOps can be applied on three different levels.
        Those levels are reflected by specifying (or omitting) values for the arguments `project_id`, `repository_id` and `branch_name`.

        ### Project level

        Permissions for all Git Repositories inside a project (existing or newly created ones) are specified, if only the argument `project_id` has a value.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example.id,
            principal=example_readers.id,
            permissions={
                "CreateRepository": "Deny",
                "DeleteRepository": "Deny",
                "RenameRepository": "NotSet",
            })
        ```

        ### Repository level

        Permissions for a specific Git Repository and all existing or newly created branches are specified if the arguments `project_id` and `repository_id` are set.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_group = azuredevops.get_group(name="Project Collection Administrators")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            principal=example_group.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ManagePermissions": "Deny",
                "CreateTag": "Deny",
                "CreateBranch": "NotSet",
            })
        ```

        ### Branch level

        Permissions for a specific branch inside a Git Repository are specified if all above mentioned the arguments are set.

        #### Example usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Empty Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_group = azuredevops.get_group(name="Project Collection Administrators")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            branch_name="refs/heads/master",
            principal=example_group.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ForcePush": "Deny",
            })
        ```

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_project_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_project_contributors = azuredevops.get_group_output(project_id=example.id,
            name="Contributors")
        example_project_administrators = azuredevops.get_group_output(project_id=example.id,
            name="Project administrators")
        example_permissions = azuredevops.GitPermissions("example-permissions",
            project_id=example.id,
            principal=example_project_readers.id,
            permissions={
                "CreateRepository": "Deny",
                "DeleteRepository": "Deny",
                "RenameRepository": "NotSet",
            })
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="TestRepo",
            default_branch="refs/heads/master",
            initialization={
                "init_type": "Clean",
            })
        example_repo_permissions = azuredevops.GitPermissions("example-repo-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            principal=example_project_administrators.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ManagePermissions": "Deny",
                "CreateTag": "Deny",
                "CreateBranch": "NotSet",
            })
        example_branch_permissions = azuredevops.GitPermissions("example-branch-permissions",
            project_id=example_git.project_id,
            repository_id=example_git.id,
            branch_name="master",
            principal=example_project_contributors.id,
            permissions={
                "RemoveOthersLocks": "Allow",
                "ForcePush": "Deny",
            })
        ```

        ## Relevant Links

        * [Azure DevOps Service REST API 7.0 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param GitPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitPermissionsArgs.__new__(GitPermissionsArgs)

            __props__.__dict__["branch_name"] = branch_name
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["replace"] = replace
            __props__.__dict__["repository_id"] = repository_id
        super(GitPermissions, __self__).__init__(
            'azuredevops:index/gitPermissions:GitPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch_name: Optional[pulumi.Input[_builtins.str]] = None,
            permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            replace: Optional[pulumi.Input[_builtins.bool]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GitPermissions':
        """
        Get an existing GitPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] branch_name: The name of the branch to assign the permissions.
               
               > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available
               
               | Permissions             | Description                                            |
               |-------------------------|--------------------------------------------------------|
               | Administer              | Administer                                             |
               | GenericRead             | Read                                                   |
               | GenericContribute       | Contribute                                             |
               | ForcePush               | Force push (rewrite history, delete branches and tags) |
               | CreateBranch            | Create branch                                          |
               | CreateTag               | Create tag                                             |
               | ManageNote              | Manage notes                                           |
               | PolicyExempt            | Bypass policies when pushing                           |
               | CreateRepository        | Create repository                                      |
               | DeleteRepository        | Delete repository                                      |
               | RenameRepository        | Rename repository                                      |
               | EditPolicies            | Edit policies                                          |
               | RemoveOthersLocks       | Remove others' locks                                   |
               | ManagePermissions       | Manage permissions                                     |
               | PullRequestContribute   | Contribute to pull requests                            |
               | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
               
               > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
               as resource ID. It is recommended to check before use.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project to assign the permissions.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        :param pulumi.Input[_builtins.str] repository_id: The ID of the GIT repository to assign the permissions
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitPermissionsState.__new__(_GitPermissionsState)

        __props__.__dict__["branch_name"] = branch_name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["principal"] = principal
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["replace"] = replace
        __props__.__dict__["repository_id"] = repository_id
        return GitPermissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the branch to assign the permissions.

        > **Note** To assign permissions to a branch, the `repository_id` must be set as well.
        """
        return pulumi.get(self, "branch_name")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        the permissions to assign. The following permissions are available

        | Permissions             | Description                                            |
        |-------------------------|--------------------------------------------------------|
        | Administer              | Administer                                             |
        | GenericRead             | Read                                                   |
        | GenericContribute       | Contribute                                             |
        | ForcePush               | Force push (rewrite history, delete branches and tags) |
        | CreateBranch            | Create branch                                          |
        | CreateTag               | Create tag                                             |
        | ManageNote              | Manage notes                                           |
        | PolicyExempt            | Bypass policies when pushing                           |
        | CreateRepository        | Create repository                                      |
        | DeleteRepository        | Delete repository                                      |
        | RenameRepository        | Rename repository                                      |
        | EditPolicies            | Edit policies                                          |
        | RemoveOthersLocks       | Remove others' locks                                   |
        | ManagePermissions       | Manage permissions                                     |
        | PullRequestContribute   | Contribute to pull requests                            |
        | PullRequestBypassPolicy | Bypass policies when completing pull requests          |
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The **group** principal to assign the permissions.

        > **Note**  The `descriptor` of the user/group not the `ID`. Some resources in this provider use the `descriptor`
        as resource ID. It is recommended to check before use.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project to assign the permissions.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the GIT repository to assign the permissions
        """
        return pulumi.get(self, "repository_id")

