# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitRepositoryFileArgs', 'GitRepositoryFile']

@pulumi.input_type
class GitRepositoryFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 file: pulumi.Input[_builtins.str],
                 repository_id: pulumi.Input[_builtins.str],
                 author_email: Optional[pulumi.Input[_builtins.str]] = None,
                 author_name: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GitRepositoryFile resource.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.str] repository_id: The ID of the Git repository.
        :param pulumi.Input[_builtins.str] author_email: The email of the author.
        :param pulumi.Input[_builtins.str] author_name: The name of the author.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[_builtins.str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[_builtins.str] committer_email: The email of the committer.
        :param pulumi.Input[_builtins.str] committer_name: The name of the committer.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files (defaults to `false`).
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "repository_id", repository_id)
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if committer_email is not None:
            pulumi.set(__self__, "committer_email", committer_email)
        if committer_name is not None:
            pulumi.set(__self__, "committer_name", committer_name)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Input[_builtins.str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Git repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "repository_id", value)

    @_builtins.property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the author.
        """
        return pulumi.get(self, "author_email")

    @author_email.setter
    def author_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_email", value)

    @_builtins.property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the author.
        """
        return pulumi.get(self, "author_name")

    @author_name.setter
    def author_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_name", value)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_message", value)

    @_builtins.property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the committer.
        """
        return pulumi.get(self, "committer_email")

    @committer_email.setter
    def committer_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "committer_email", value)

    @_builtins.property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the committer.
        """
        return pulumi.get(self, "committer_name")

    @committer_name.setter
    def committer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "committer_name", value)

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overwriting existing files (defaults to `false`).
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_on_create", value)


@pulumi.input_type
class _GitRepositoryFileState:
    def __init__(__self__, *,
                 author_email: Optional[pulumi.Input[_builtins.str]] = None,
                 author_name: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitRepositoryFile resources.
        :param pulumi.Input[_builtins.str] author_email: The email of the author.
        :param pulumi.Input[_builtins.str] author_name: The name of the author.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[_builtins.str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[_builtins.str] committer_email: The email of the committer.
        :param pulumi.Input[_builtins.str] committer_name: The name of the committer.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files (defaults to `false`).
        :param pulumi.Input[_builtins.str] repository_id: The ID of the Git repository.
        """
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if commit_message is not None:
            pulumi.set(__self__, "commit_message", commit_message)
        if committer_email is not None:
            pulumi.set(__self__, "committer_email", committer_email)
        if committer_name is not None:
            pulumi.set(__self__, "committer_name", committer_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if overwrite_on_create is not None:
            pulumi.set(__self__, "overwrite_on_create", overwrite_on_create)
        if repository_id is not None:
            pulumi.set(__self__, "repository_id", repository_id)

    @_builtins.property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the author.
        """
        return pulumi.get(self, "author_email")

    @author_email.setter
    def author_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_email", value)

    @_builtins.property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the author.
        """
        return pulumi.get(self, "author_name")

    @author_name.setter
    def author_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "author_name", value)

    @_builtins.property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "branch", value)

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @commit_message.setter
    def commit_message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commit_message", value)

    @_builtins.property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the committer.
        """
        return pulumi.get(self, "committer_email")

    @committer_email.setter
    def committer_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "committer_email", value)

    @_builtins.property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the committer.
        """
        return pulumi.get(self, "committer_name")

    @committer_name.setter
    def committer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "committer_name", value)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @file.setter
    def file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file", value)

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable overwriting existing files (defaults to `false`).
        """
        return pulumi.get(self, "overwrite_on_create")

    @overwrite_on_create.setter
    def overwrite_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overwrite_on_create", value)

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Git repository.
        """
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_id", value)


@pulumi.type_token("azuredevops:index/gitRepositoryFile:GitRepositoryFile")
class GitRepositoryFile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author_email: Optional[pulumi.Input[_builtins.str]] = None,
                 author_name: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage files within an Azure DevOps Git repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_git_repository_file = azuredevops.GitRepositoryFile("example",
            repository_id=example_git.id,
            file=".gitignore",
            content="**/*.tfstate",
            branch="refs/heads/master",
            commit_message="First commit",
            overwrite_on_create=False)
        ```

        ### Author Email Pattern
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_repository_policy_author_email_pattern = azuredevops.RepositoryPolicyAuthorEmailPattern("example",
            project_id=example.id,
            enabled=True,
            blocking=True,
            author_email_patterns=["auhtor@test.com"],
            repository_ids=[example_git.id])
        example_git_repository_file = azuredevops.GitRepositoryFile("example",
            repository_id=example_git.id,
            file=".gitignore",
            content="**/*.tfstate",
            branch="refs/heads/master",
            commit_message="First commit",
            overwrite_on_create=False,
            author_name="authorname",
            author_email="auhtor@test.com",
            opts = pulumi.ResourceOptions(depends_on=[example_repository_policy_author_email_pattern]))
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Git API](https://docs.microsoft.com/en-us/rest/api/azure/devops/git/?view=azure-devops-rest-7.0)

        ## Import

        Repository files can be imported using a combination of the `repository ID` and `file`, e.g.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryFile:GitRepositoryFile example 00000000-0000-0000-0000-000000000000/.gitignore
        ```

        To import a file from a branch other than `master`, append `:` and the branch name, e.g.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryFile:GitRepositoryFile example 00000000-0000-0000-0000-000000000000/.gitignore:refs/heads/master
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] author_email: The email of the author.
        :param pulumi.Input[_builtins.str] author_name: The name of the author.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[_builtins.str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[_builtins.str] committer_email: The email of the committer.
        :param pulumi.Input[_builtins.str] committer_name: The name of the committer.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files (defaults to `false`).
        :param pulumi.Input[_builtins.str] repository_id: The ID of the Git repository.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitRepositoryFileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage files within an Azure DevOps Git repository.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_git_repository_file = azuredevops.GitRepositoryFile("example",
            repository_id=example_git.id,
            file=".gitignore",
            content="**/*.tfstate",
            branch="refs/heads/master",
            commit_message="First commit",
            overwrite_on_create=False)
        ```

        ### Author Email Pattern
        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_git = azuredevops.Git("example",
            project_id=example.id,
            name="Example Git Repository",
            initialization={
                "init_type": "Clean",
            })
        example_repository_policy_author_email_pattern = azuredevops.RepositoryPolicyAuthorEmailPattern("example",
            project_id=example.id,
            enabled=True,
            blocking=True,
            author_email_patterns=["auhtor@test.com"],
            repository_ids=[example_git.id])
        example_git_repository_file = azuredevops.GitRepositoryFile("example",
            repository_id=example_git.id,
            file=".gitignore",
            content="**/*.tfstate",
            branch="refs/heads/master",
            commit_message="First commit",
            overwrite_on_create=False,
            author_name="authorname",
            author_email="auhtor@test.com",
            opts = pulumi.ResourceOptions(depends_on=[example_repository_policy_author_email_pattern]))
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Git API](https://docs.microsoft.com/en-us/rest/api/azure/devops/git/?view=azure-devops-rest-7.0)

        ## Import

        Repository files can be imported using a combination of the `repository ID` and `file`, e.g.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryFile:GitRepositoryFile example 00000000-0000-0000-0000-000000000000/.gitignore
        ```

        To import a file from a branch other than `master`, append `:` and the branch name, e.g.

        ```sh
        $ pulumi import azuredevops:index/gitRepositoryFile:GitRepositoryFile example 00000000-0000-0000-0000-000000000000/.gitignore:refs/heads/master
        ```

        :param str resource_name: The name of the resource.
        :param GitRepositoryFileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitRepositoryFileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 author_email: Optional[pulumi.Input[_builtins.str]] = None,
                 author_name: Optional[pulumi.Input[_builtins.str]] = None,
                 branch: Optional[pulumi.Input[_builtins.str]] = None,
                 commit_message: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_email: Optional[pulumi.Input[_builtins.str]] = None,
                 committer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 file: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 repository_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitRepositoryFileArgs.__new__(GitRepositoryFileArgs)

            __props__.__dict__["author_email"] = author_email
            __props__.__dict__["author_name"] = author_name
            __props__.__dict__["branch"] = branch
            __props__.__dict__["commit_message"] = commit_message
            __props__.__dict__["committer_email"] = committer_email
            __props__.__dict__["committer_name"] = committer_name
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            if file is None and not opts.urn:
                raise TypeError("Missing required property 'file'")
            __props__.__dict__["file"] = file
            __props__.__dict__["overwrite_on_create"] = overwrite_on_create
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
        super(GitRepositoryFile, __self__).__init__(
            'azuredevops:index/gitRepositoryFile:GitRepositoryFile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author_email: Optional[pulumi.Input[_builtins.str]] = None,
            author_name: Optional[pulumi.Input[_builtins.str]] = None,
            branch: Optional[pulumi.Input[_builtins.str]] = None,
            commit_message: Optional[pulumi.Input[_builtins.str]] = None,
            committer_email: Optional[pulumi.Input[_builtins.str]] = None,
            committer_name: Optional[pulumi.Input[_builtins.str]] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            file: Optional[pulumi.Input[_builtins.str]] = None,
            overwrite_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            repository_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'GitRepositoryFile':
        """
        Get an existing GitRepositoryFile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] author_email: The email of the author.
        :param pulumi.Input[_builtins.str] author_name: The name of the author.
        :param pulumi.Input[_builtins.str] branch: Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        :param pulumi.Input[_builtins.str] commit_message: Commit message when adding or updating the managed file.
        :param pulumi.Input[_builtins.str] committer_email: The email of the committer.
        :param pulumi.Input[_builtins.str] committer_name: The name of the committer.
        :param pulumi.Input[_builtins.str] content: The file content.
        :param pulumi.Input[_builtins.str] file: The path of the file to manage.
        :param pulumi.Input[_builtins.bool] overwrite_on_create: Enable overwriting existing files (defaults to `false`).
        :param pulumi.Input[_builtins.str] repository_id: The ID of the Git repository.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitRepositoryFileState.__new__(_GitRepositoryFileState)

        __props__.__dict__["author_email"] = author_email
        __props__.__dict__["author_name"] = author_name
        __props__.__dict__["branch"] = branch
        __props__.__dict__["commit_message"] = commit_message
        __props__.__dict__["committer_email"] = committer_email
        __props__.__dict__["committer_name"] = committer_name
        __props__.__dict__["content"] = content
        __props__.__dict__["file"] = file
        __props__.__dict__["overwrite_on_create"] = overwrite_on_create
        __props__.__dict__["repository_id"] = repository_id
        return GitRepositoryFile(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the author.
        """
        return pulumi.get(self, "author_email")

    @_builtins.property
    @pulumi.getter(name="authorName")
    def author_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the author.
        """
        return pulumi.get(self, "author_name")

    @_builtins.property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Git branch (defaults to `refs/heads/master`). The branch must already exist, it will not be created if it does not already exist.
        """
        return pulumi.get(self, "branch")

    @_builtins.property
    @pulumi.getter(name="commitMessage")
    def commit_message(self) -> pulumi.Output[_builtins.str]:
        """
        Commit message when adding or updating the managed file.
        """
        return pulumi.get(self, "commit_message")

    @_builtins.property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the committer.
        """
        return pulumi.get(self, "committer_email")

    @_builtins.property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the committer.
        """
        return pulumi.get(self, "committer_name")

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The file content.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def file(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the file to manage.
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter(name="overwriteOnCreate")
    def overwrite_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable overwriting existing files (defaults to `false`).
        """
        return pulumi.get(self, "overwrite_on_create")

    @_builtins.property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Git repository.
        """
        return pulumi.get(self, "repository_id")

