# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupMembershipArgs', 'GroupMembership']

@pulumi.input_type
class GroupMembershipArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[_builtins.str],
                 members: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a GroupMembership resource.
        :param pulumi.Input[_builtins.str] group: The descriptor of the group being managed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A list of user or group descriptors that will become members of the group.
               
               > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
               <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        :param pulumi.Input[_builtins.str] mode: The mode how the resource manages group members.
               
               ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
               <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
               <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "members", members)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Input[_builtins.str]:
        """
        The descriptor of the group being managed.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of user or group descriptors that will become members of the group.

        > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
        <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode how the resource manages group members.

        ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
        <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
        <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class _GroupMembershipState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering GroupMembership resources.
        :param pulumi.Input[_builtins.str] group: The descriptor of the group being managed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A list of user or group descriptors that will become members of the group.
               
               > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
               <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        :param pulumi.Input[_builtins.str] mode: The mode how the resource manages group members.
               
               ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
               <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
               <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The descriptor of the group being managed.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of user or group descriptors that will become members of the group.

        > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
        <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode how the resource manages group members.

        ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
        <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
        <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)


@pulumi.type_token("azuredevops:index/groupMembership:GroupMembership")
class GroupMembership(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages group membership within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example_project = azuredevops.Project("example", name="Example Project")
        example_user = azuredevops.User("example", principal_name="foo@contoso.com")
        example = azuredevops.get_group_output(project_id=example_project.id,
            name="Build Administrators")
        example_group_membership = azuredevops.GroupMembership("example",
            group=example.descriptor,
            members=[example_user.descriptor])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Memberships](https://docs.microsoft.com/en-us/rest/api/azure/devops/graph/memberships?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Deployment Groups**: Read & Manage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The descriptor of the group being managed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A list of user or group descriptors that will become members of the group.
               
               > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
               <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        :param pulumi.Input[_builtins.str] mode: The mode how the resource manages group members.
               
               ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
               <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
               <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupMembershipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages group membership within Azure DevOps.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example_project = azuredevops.Project("example", name="Example Project")
        example_user = azuredevops.User("example", principal_name="foo@contoso.com")
        example = azuredevops.get_group_output(project_id=example_project.id,
            name="Build Administrators")
        example_group_membership = azuredevops.GroupMembership("example",
            group=example.descriptor,
            members=[example_user.descriptor])
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Memberships](https://docs.microsoft.com/en-us/rest/api/azure/devops/graph/memberships?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Deployment Groups**: Read & Manage

        :param str resource_name: The name of the resource.
        :param GroupMembershipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupMembershipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupMembershipArgs.__new__(GroupMembershipArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["mode"] = mode
        super(GroupMembership, __self__).__init__(
            'azuredevops:index/groupMembership:GroupMembership',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'GroupMembership':
        """
        Get an existing GroupMembership resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The descriptor of the group being managed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A list of user or group descriptors that will become members of the group.
               
               > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
               <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        :param pulumi.Input[_builtins.str] mode: The mode how the resource manages group members.
               
               ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
               <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
               <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupMembershipState.__new__(_GroupMembershipState)

        __props__.__dict__["group"] = group
        __props__.__dict__["members"] = members
        __props__.__dict__["mode"] = mode
        return GroupMembership(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        The descriptor of the group being managed.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of user or group descriptors that will become members of the group.

        > **NOTE** 1. It's possible to define group members both within the `GroupMembership resource` via the members block and by using the `Group` resource. However it's not possible to use both methods to manage group members, since there'll be conflicts.
        <br>2. The `members` uses `descriptor` as the identifier not Resource ID or others.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode how the resource manages group members.

        ~>**NOTE** 1. `mode = add`: the resource will ensure that all specified members will be part of the referenced group
        <br>2. `mode = overwrite`: the resource will replace all existing members with the members specified within the `members` block
        <br>3. To clear all members from a group, specify an empty list of descriptors in the `members` attribute and set the `mode` member to `overwrite`.
        """
        return pulumi.get(self, "mode")

