# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SecurityroleAssignmentArgs', 'SecurityroleAssignment']

@pulumi.input_type
class SecurityroleAssignmentArgs:
    def __init__(__self__, *,
                 identity_id: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 role_name: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a SecurityroleAssignment resource.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the identity to authorize.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_name: Name of the role to assign.
        :param pulumi.Input[_builtins.str] scope: The scope in which this assignment should exist.
        """
        pulumi.set(__self__, "identity_id", identity_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_name", role_name)
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the identity to authorize.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the role to assign.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        The scope in which this assignment should exist.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _SecurityroleAssignmentState:
    def __init__(__self__, *,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityroleAssignment resources.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the identity to authorize.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_name: Name of the role to assign.
        :param pulumi.Input[_builtins.str] scope: The scope in which this assignment should exist.
        """
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the identity to authorize.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the role to assign.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope in which this assignment should exist.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.type_token("azuredevops:index/securityroleAssignment:SecurityroleAssignment")
class SecurityroleAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages assignment of security roles to various resources within Azure DevOps organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops
        import pulumi_std as std

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_environment = azuredevops.Environment("example",
            project_id=example.id,
            name="Example Environment",
            description="Example pipeline deployment environment")
        example_group = azuredevops.Group("example",
            scope=example.id,
            display_name="Example group",
            description="Description of example group")
        example_securityrole_assignment = azuredevops.SecurityroleAssignment("example",
            scope="distributedtask.environmentreferencerole",
            resource_id=std.index.format(input="%s_%s",
                args=[
                    example.id,
                    example_environment.id,
                ])["result"],
            identity_id=example_group.origin_id,
            role_name="Administrator")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Authorize Definition Resource](https://docs.microsoft.com/en-us/rest/api/azure/devops/build/resources/authorize%20definition%20resources?view=azure-devops-rest-7.0)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the identity to authorize.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_name: Name of the role to assign.
        :param pulumi.Input[_builtins.str] scope: The scope in which this assignment should exist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityroleAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages assignment of security roles to various resources within Azure DevOps organization.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops
        import pulumi_std as std

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_environment = azuredevops.Environment("example",
            project_id=example.id,
            name="Example Environment",
            description="Example pipeline deployment environment")
        example_group = azuredevops.Group("example",
            scope=example.id,
            display_name="Example group",
            description="Description of example group")
        example_securityrole_assignment = azuredevops.SecurityroleAssignment("example",
            scope="distributedtask.environmentreferencerole",
            resource_id=std.index.format(input="%s_%s",
                args=[
                    example.id,
                    example_environment.id,
                ])["result"],
            identity_id=example_group.origin_id,
            role_name="Administrator")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Authorize Definition Resource](https://docs.microsoft.com/en-us/rest/api/azure/devops/build/resources/authorize%20definition%20resources?view=azure-devops-rest-7.0)

        :param str resource_name: The name of the resource.
        :param SecurityroleAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityroleAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityroleAssignmentArgs.__new__(SecurityroleAssignmentArgs)

            if identity_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_id'")
            __props__.__dict__["identity_id"] = identity_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
        super(SecurityroleAssignment, __self__).__init__(
            'azuredevops:index/securityroleAssignment:SecurityroleAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            role_name: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityroleAssignment':
        """
        Get an existing SecurityroleAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the identity to authorize.
        :param pulumi.Input[_builtins.str] resource_id: The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role_name: Name of the role to assign.
        :param pulumi.Input[_builtins.str] scope: The scope in which this assignment should exist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityroleAssignmentState.__new__(_SecurityroleAssignmentState)

        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["scope"] = scope
        return SecurityroleAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the identity to authorize.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource on which the role is to be assigned. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the role to assign.
        """
        return pulumi.get(self, "role_name")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope in which this assignment should exist.
        """
        return pulumi.get(self, "scope")

