# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceEndpointAzureRMArgs', 'ServiceEndpointAzureRM']

@pulumi.input_type
class ServiceEndpointAzureRMArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 service_endpoint_name: pulumi.Input[_builtins.str],
                 azurerm_management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_management_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_spn_tenantid: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceEndpointAzureRM resource.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint Name.
        :param pulumi.Input[_builtins.str] azurerm_management_group_id: The Management group ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_management_group_name: The Management group Name of the targets.
        :param pulumi.Input[_builtins.str] azurerm_spn_tenantid: The Tenant ID of the service principal.
        :param pulumi.Input[_builtins.str] azurerm_subscription_id: The Subscription ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_subscription_name: The Subscription Name of the targets.
        :param pulumi.Input['ServiceEndpointAzureRMCredentialsArgs'] credentials: A `credentials` block as defined below.
        :param pulumi.Input[_builtins.str] description: Service connection description.
        :param pulumi.Input[_builtins.str] environment: The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceEndpointAzureRMFeaturesArgs'] features: A `features` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group: The resource group used for scope of automatic service endpoint.
        :param pulumi.Input[_builtins.str] server_url: The server URL of the service endpoint. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        :param pulumi.Input[_builtins.str] service_endpoint_authentication_scheme: Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.
               
               > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if azurerm_management_group_id is not None:
            pulumi.set(__self__, "azurerm_management_group_id", azurerm_management_group_id)
        if azurerm_management_group_name is not None:
            pulumi.set(__self__, "azurerm_management_group_name", azurerm_management_group_name)
        if azurerm_spn_tenantid is not None:
            pulumi.set(__self__, "azurerm_spn_tenantid", azurerm_spn_tenantid)
        if azurerm_subscription_id is not None:
            pulumi.set(__self__, "azurerm_subscription_id", azurerm_subscription_id)
        if azurerm_subscription_name is not None:
            pulumi.set(__self__, "azurerm_subscription_name", azurerm_subscription_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_endpoint_authentication_scheme is not None:
            pulumi.set(__self__, "service_endpoint_authentication_scheme", service_endpoint_authentication_scheme)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Service Endpoint Name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupId")
    def azurerm_management_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management group ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_management_group_id")

    @azurerm_management_group_id.setter
    def azurerm_management_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_management_group_id", value)

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupName")
    def azurerm_management_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management group Name of the targets.
        """
        return pulumi.get(self, "azurerm_management_group_name")

    @azurerm_management_group_name.setter
    def azurerm_management_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_management_group_name", value)

    @_builtins.property
    @pulumi.getter(name="azurermSpnTenantid")
    def azurerm_spn_tenantid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the service principal.
        """
        return pulumi.get(self, "azurerm_spn_tenantid")

    @azurerm_spn_tenantid.setter
    def azurerm_spn_tenantid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_spn_tenantid", value)

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionId")
    def azurerm_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subscription ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_subscription_id")

    @azurerm_subscription_id.setter
    def azurerm_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionName")
    def azurerm_subscription_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subscription Name of the targets.
        """
        return pulumi.get(self, "azurerm_subscription_name")

    @azurerm_subscription_name.setter
    def azurerm_subscription_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_subscription_name", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']]:
        """
        A `credentials` block as defined below.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']]:
        """
        A `features` block as defined below.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group used for scope of automatic service endpoint.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server URL of the service endpoint. Changing this forces a new resource to be created.

        > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.

        > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @service_endpoint_authentication_scheme.setter
    def service_endpoint_authentication_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_authentication_scheme", value)


@pulumi.input_type
class _ServiceEndpointAzureRMState:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 azurerm_management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_management_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_spn_tenantid: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation_issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 workload_identity_federation_subject: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceEndpointAzureRM resources.
        :param pulumi.Input[_builtins.str] azurerm_management_group_id: The Management group ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_management_group_name: The Management group Name of the targets.
        :param pulumi.Input[_builtins.str] azurerm_spn_tenantid: The Tenant ID of the service principal.
        :param pulumi.Input[_builtins.str] azurerm_subscription_id: The Subscription ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_subscription_name: The Subscription Name of the targets.
        :param pulumi.Input['ServiceEndpointAzureRMCredentialsArgs'] credentials: A `credentials` block as defined below.
        :param pulumi.Input[_builtins.str] description: Service connection description.
        :param pulumi.Input[_builtins.str] environment: The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        :param pulumi.Input['ServiceEndpointAzureRMFeaturesArgs'] features: A `features` block as defined below.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] resource_group: The resource group used for scope of automatic service endpoint.
        :param pulumi.Input[_builtins.str] server_url: The server URL of the service endpoint. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        :param pulumi.Input[_builtins.str] service_endpoint_authentication_scheme: Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.
               
               > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint Name.
        :param pulumi.Input[_builtins.str] service_principal_id: The Application(Client) ID of the Service Principal.
        :param pulumi.Input[_builtins.str] workload_identity_federation_issuer: The issuer if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `https://vstoken.dev.azure.com/00000000-0000-0000-0000-000000000000`, where the GUID is the Organization ID of your Azure DevOps Organisation.
        :param pulumi.Input[_builtins.str] workload_identity_federation_subject: The subject if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `sc://<organisation>/<project>/<service-connection-name>`.
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if azurerm_management_group_id is not None:
            pulumi.set(__self__, "azurerm_management_group_id", azurerm_management_group_id)
        if azurerm_management_group_name is not None:
            pulumi.set(__self__, "azurerm_management_group_name", azurerm_management_group_name)
        if azurerm_spn_tenantid is not None:
            pulumi.set(__self__, "azurerm_spn_tenantid", azurerm_spn_tenantid)
        if azurerm_subscription_id is not None:
            pulumi.set(__self__, "azurerm_subscription_id", azurerm_subscription_id)
        if azurerm_subscription_name is not None:
            pulumi.set(__self__, "azurerm_subscription_name", azurerm_subscription_name)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resource_group is not None:
            pulumi.set(__self__, "resource_group", resource_group)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_endpoint_authentication_scheme is not None:
            pulumi.set(__self__, "service_endpoint_authentication_scheme", service_endpoint_authentication_scheme)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if workload_identity_federation_issuer is not None:
            pulumi.set(__self__, "workload_identity_federation_issuer", workload_identity_federation_issuer)
        if workload_identity_federation_subject is not None:
            pulumi.set(__self__, "workload_identity_federation_subject", workload_identity_federation_subject)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupId")
    def azurerm_management_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management group ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_management_group_id")

    @azurerm_management_group_id.setter
    def azurerm_management_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_management_group_id", value)

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupName")
    def azurerm_management_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management group Name of the targets.
        """
        return pulumi.get(self, "azurerm_management_group_name")

    @azurerm_management_group_name.setter
    def azurerm_management_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_management_group_name", value)

    @_builtins.property
    @pulumi.getter(name="azurermSpnTenantid")
    def azurerm_spn_tenantid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the service principal.
        """
        return pulumi.get(self, "azurerm_spn_tenantid")

    @azurerm_spn_tenantid.setter
    def azurerm_spn_tenantid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_spn_tenantid", value)

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionId")
    def azurerm_subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subscription ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_subscription_id")

    @azurerm_subscription_id.setter
    def azurerm_subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionName")
    def azurerm_subscription_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subscription Name of the targets.
        """
        return pulumi.get(self, "azurerm_subscription_name")

    @azurerm_subscription_name.setter
    def azurerm_subscription_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "azurerm_subscription_name", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']]:
        """
        A `credentials` block as defined below.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['ServiceEndpointAzureRMCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service connection description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']]:
        """
        A `features` block as defined below.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input['ServiceEndpointAzureRMFeaturesArgs']]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group used for scope of automatic service endpoint.
        """
        return pulumi.get(self, "resource_group")

    @resource_group.setter
    def resource_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group", value)

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server URL of the service endpoint. Changing this forces a new resource to be created.

        > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.

        > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @service_endpoint_authentication_scheme.setter
    def service_endpoint_authentication_scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_authentication_scheme", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service Endpoint Name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Application(Client) ID of the Service Principal.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationIssuer")
    def workload_identity_federation_issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The issuer if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `https://vstoken.dev.azure.com/00000000-0000-0000-0000-000000000000`, where the GUID is the Organization ID of your Azure DevOps Organisation.
        """
        return pulumi.get(self, "workload_identity_federation_issuer")

    @workload_identity_federation_issuer.setter
    def workload_identity_federation_issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_federation_issuer", value)

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationSubject")
    def workload_identity_federation_subject(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subject if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `sc://<organisation>/<project>/<service-connection-name>`.
        """
        return pulumi.get(self, "workload_identity_federation_subject")

    @workload_identity_federation_subject.setter
    def workload_identity_federation_subject(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workload_identity_federation_subject", value)


@pulumi.type_token("azuredevops:index/serviceEndpointAzureRM:ServiceEndpointAzureRM")
class ServiceEndpointAzureRM(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azurerm_management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_management_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_spn_tenantid: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureRMCredentialsArgs', 'ServiceEndpointAzureRMCredentialsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Union['ServiceEndpointAzureRMFeaturesArgs', 'ServiceEndpointAzureRMFeaturesArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Manual or Automatic Azure Resource Manager service endpoint within Azure DevOps.

        ~>**NOTE:**
        If you receive an error message like:```Failed to obtain the Json Web Token(JWT) using service principal client ID. Exception message: A configuration issue is preventing authentication - check the error message from the server for details.```
        You should check the secret of this Application or if you recently rotate the secret, wait a few minutes for Azure to propagate the secret.

        ## Requirements (Manual AzureRM Service Endpoint)

        Before to create a service end point in Azure DevOps, you need to create a Service Principal in your Azure subscription.

        For detailed steps to create a service principal with Azure cli see the [documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli?view=azure-cli-latest)

        ## Example Usage

        ### Service Principal Manual AzureRM Service Endpoint (Subscription Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Service Principal Manual AzureRM Service Endpoint (ManagementGroup Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_management_group_id="managementGroup",
            azurerm_management_group_name="managementGroup")
        ```

        ### Service Principal Automatic AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="ServicePrincipal",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Workload Identity Federation Manual AzureRM Service Endpoint (Subscription Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops
        import pulumi_azurerm as azurerm

        service_connection_name = "example-federated-sc"
        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        identity = azurerm.index.ResourceGroup("identity",
            name=identity,
            location=UK South)
        example_user_assigned_identity = azurerm.index.UserAssignedIdentity("example",
            location=identity.location,
            name=example-identity,
            resource_group_name=azurerm_resource_group.identity.name)
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name=service_connection_name,
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            credentials={
                "serviceprincipalid": example_user_assigned_identity["clientId"],
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        example_federated_identity_credential = azurerm.index.FederatedIdentityCredential("example",
            name=example-federated-credential,
            resource_group_name=identity.name,
            parent_id=example_user_assigned_identity.id,
            audience=[api://AzureADTokenExchange],
            issuer=example_service_endpoint_azure_rm.workload_identity_federation_issuer,
            subject=example_service_endpoint_azure_rm.workload_identity_federation_subject)
        ```

        ### Workload Identity Federation Automatic AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Managed Identity AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="ManagedServiceIdentity",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service End points](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Azure Resource Manager Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAzureRM:ServiceEndpointAzureRM example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] azurerm_management_group_id: The Management group ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_management_group_name: The Management group Name of the targets.
        :param pulumi.Input[_builtins.str] azurerm_spn_tenantid: The Tenant ID of the service principal.
        :param pulumi.Input[_builtins.str] azurerm_subscription_id: The Subscription ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_subscription_name: The Subscription Name of the targets.
        :param pulumi.Input[Union['ServiceEndpointAzureRMCredentialsArgs', 'ServiceEndpointAzureRMCredentialsArgsDict']] credentials: A `credentials` block as defined below.
        :param pulumi.Input[_builtins.str] description: Service connection description.
        :param pulumi.Input[_builtins.str] environment: The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceEndpointAzureRMFeaturesArgs', 'ServiceEndpointAzureRMFeaturesArgsDict']] features: A `features` block as defined below.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] resource_group: The resource group used for scope of automatic service endpoint.
        :param pulumi.Input[_builtins.str] server_url: The server URL of the service endpoint. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        :param pulumi.Input[_builtins.str] service_endpoint_authentication_scheme: Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.
               
               > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint Name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEndpointAzureRMArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Manual or Automatic Azure Resource Manager service endpoint within Azure DevOps.

        ~>**NOTE:**
        If you receive an error message like:```Failed to obtain the Json Web Token(JWT) using service principal client ID. Exception message: A configuration issue is preventing authentication - check the error message from the server for details.```
        You should check the secret of this Application or if you recently rotate the secret, wait a few minutes for Azure to propagate the secret.

        ## Requirements (Manual AzureRM Service Endpoint)

        Before to create a service end point in Azure DevOps, you need to create a Service Principal in your Azure subscription.

        For detailed steps to create a service principal with Azure cli see the [documentation](https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli?view=azure-cli-latest)

        ## Example Usage

        ### Service Principal Manual AzureRM Service Endpoint (Subscription Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Service Principal Manual AzureRM Service Endpoint (ManagementGroup Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="ServicePrincipal",
            credentials={
                "serviceprincipalid": "00000000-0000-0000-0000-000000000000",
                "serviceprincipalkey": "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_management_group_id="managementGroup",
            azurerm_management_group_name="managementGroup")
        ```

        ### Service Principal Automatic AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="ServicePrincipal",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Workload Identity Federation Manual AzureRM Service Endpoint (Subscription Scoped)

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops
        import pulumi_azurerm as azurerm

        service_connection_name = "example-federated-sc"
        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        identity = azurerm.index.ResourceGroup("identity",
            name=identity,
            location=UK South)
        example_user_assigned_identity = azurerm.index.UserAssignedIdentity("example",
            location=identity.location,
            name=example-identity,
            resource_group_name=azurerm_resource_group.identity.name)
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name=service_connection_name,
            description="Managed by Pulumi",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            credentials={
                "serviceprincipalid": example_user_assigned_identity["clientId"],
            },
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        example_federated_identity_credential = azurerm.index.FederatedIdentityCredential("example",
            name=example-federated-credential,
            resource_group_name=identity.name,
            parent_id=example_user_assigned_identity.id,
            audience=[api://AzureADTokenExchange],
            issuer=example_service_endpoint_azure_rm.workload_identity_federation_issuer,
            subject=example_service_endpoint_azure_rm.workload_identity_federation_subject)
        ```

        ### Workload Identity Federation Automatic AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="WorkloadIdentityFederation",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ### Managed Identity AzureRM Service Endpoint

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile")
        example_service_endpoint_azure_rm = azuredevops.ServiceEndpointAzureRM("example",
            project_id=example.id,
            service_endpoint_name="Example AzureRM",
            service_endpoint_authentication_scheme="ManagedServiceIdentity",
            azurerm_spn_tenantid="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_id="00000000-0000-0000-0000-000000000000",
            azurerm_subscription_name="Example Subscription Name")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service End points](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Azure Resource Manager Service Endpoint can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceEndpointAzureRM:ServiceEndpointAzureRM example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEndpointAzureRMArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEndpointAzureRMArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azurerm_management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_management_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_spn_tenantid: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 azurerm_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureRMCredentialsArgs', 'ServiceEndpointAzureRMCredentialsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Union['ServiceEndpointAzureRMFeaturesArgs', 'ServiceEndpointAzureRMFeaturesArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_authentication_scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEndpointAzureRMArgs.__new__(ServiceEndpointAzureRMArgs)

            __props__.__dict__["azurerm_management_group_id"] = azurerm_management_group_id
            __props__.__dict__["azurerm_management_group_name"] = azurerm_management_group_name
            __props__.__dict__["azurerm_spn_tenantid"] = azurerm_spn_tenantid
            __props__.__dict__["azurerm_subscription_id"] = azurerm_subscription_id
            __props__.__dict__["azurerm_subscription_name"] = azurerm_subscription_name
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["features"] = features
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["resource_group"] = resource_group
            __props__.__dict__["server_url"] = server_url
            __props__.__dict__["service_endpoint_authentication_scheme"] = service_endpoint_authentication_scheme
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["authorization"] = None
            __props__.__dict__["service_principal_id"] = None
            __props__.__dict__["workload_identity_federation_issuer"] = None
            __props__.__dict__["workload_identity_federation_subject"] = None
        super(ServiceEndpointAzureRM, __self__).__init__(
            'azuredevops:index/serviceEndpointAzureRM:ServiceEndpointAzureRM',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            azurerm_management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            azurerm_management_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            azurerm_spn_tenantid: Optional[pulumi.Input[_builtins.str]] = None,
            azurerm_subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
            azurerm_subscription_name: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Union['ServiceEndpointAzureRMCredentialsArgs', 'ServiceEndpointAzureRMCredentialsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            features: Optional[pulumi.Input[Union['ServiceEndpointAzureRMFeaturesArgs', 'ServiceEndpointAzureRMFeaturesArgsDict']]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group: Optional[pulumi.Input[_builtins.str]] = None,
            server_url: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint_authentication_scheme: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            workload_identity_federation_issuer: Optional[pulumi.Input[_builtins.str]] = None,
            workload_identity_federation_subject: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceEndpointAzureRM':
        """
        Get an existing ServiceEndpointAzureRM resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] azurerm_management_group_id: The Management group ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_management_group_name: The Management group Name of the targets.
        :param pulumi.Input[_builtins.str] azurerm_spn_tenantid: The Tenant ID of the service principal.
        :param pulumi.Input[_builtins.str] azurerm_subscription_id: The Subscription ID of the Azure targets.
        :param pulumi.Input[_builtins.str] azurerm_subscription_name: The Subscription Name of the targets.
        :param pulumi.Input[Union['ServiceEndpointAzureRMCredentialsArgs', 'ServiceEndpointAzureRMCredentialsArgsDict']] credentials: A `credentials` block as defined below.
        :param pulumi.Input[_builtins.str] description: Service connection description.
        :param pulumi.Input[_builtins.str] environment: The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceEndpointAzureRMFeaturesArgs', 'ServiceEndpointAzureRMFeaturesArgsDict']] features: A `features` block as defined below.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] resource_group: The resource group used for scope of automatic service endpoint.
        :param pulumi.Input[_builtins.str] server_url: The server URL of the service endpoint. Changing this forces a new resource to be created.
               
               > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        :param pulumi.Input[_builtins.str] service_endpoint_authentication_scheme: Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.
               
               > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint Name.
        :param pulumi.Input[_builtins.str] service_principal_id: The Application(Client) ID of the Service Principal.
        :param pulumi.Input[_builtins.str] workload_identity_federation_issuer: The issuer if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `https://vstoken.dev.azure.com/00000000-0000-0000-0000-000000000000`, where the GUID is the Organization ID of your Azure DevOps Organisation.
        :param pulumi.Input[_builtins.str] workload_identity_federation_subject: The subject if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `sc://<organisation>/<project>/<service-connection-name>`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEndpointAzureRMState.__new__(_ServiceEndpointAzureRMState)

        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["azurerm_management_group_id"] = azurerm_management_group_id
        __props__.__dict__["azurerm_management_group_name"] = azurerm_management_group_name
        __props__.__dict__["azurerm_spn_tenantid"] = azurerm_spn_tenantid
        __props__.__dict__["azurerm_subscription_id"] = azurerm_subscription_id
        __props__.__dict__["azurerm_subscription_name"] = azurerm_subscription_name
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["features"] = features
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resource_group"] = resource_group
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["service_endpoint_authentication_scheme"] = service_endpoint_authentication_scheme
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["workload_identity_federation_issuer"] = workload_identity_federation_issuer
        __props__.__dict__["workload_identity_federation_subject"] = workload_identity_federation_subject
        return ServiceEndpointAzureRM(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupId")
    def azurerm_management_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Management group ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_management_group_id")

    @_builtins.property
    @pulumi.getter(name="azurermManagementGroupName")
    def azurerm_management_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Management group Name of the targets.
        """
        return pulumi.get(self, "azurerm_management_group_name")

    @_builtins.property
    @pulumi.getter(name="azurermSpnTenantid")
    def azurerm_spn_tenantid(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenant ID of the service principal.
        """
        return pulumi.get(self, "azurerm_spn_tenantid")

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionId")
    def azurerm_subscription_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Subscription ID of the Azure targets.
        """
        return pulumi.get(self, "azurerm_subscription_id")

    @_builtins.property
    @pulumi.getter(name="azurermSubscriptionName")
    def azurerm_subscription_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Subscription Name of the targets.
        """
        return pulumi.get(self, "azurerm_subscription_name")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.ServiceEndpointAzureRMCredentials']]:
        """
        A `credentials` block as defined below.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service connection description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Cloud Environment to use. Defaults to `AzureCloud`. Possible values are `AzureCloud`, `AzureChinaCloud`, `AzureUSGovernment`, `AzureGermanCloud` and `AzureStack`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Output[Optional['outputs.ServiceEndpointAzureRMFeatures']]:
        """
        A `features` block as defined below.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource group used for scope of automatic service endpoint.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[_builtins.str]:
        """
        The server URL of the service endpoint. Changing this forces a new resource to be created.

        > **NOTE:** One of either `Subscription` scoped i.e. `azurerm_subscription_id`, `azurerm_subscription_name` or `ManagementGroup` scoped i.e. `azurerm_management_group_id`, `azurerm_management_group_name` values must be specified.
        """
        return pulumi.get(self, "server_url")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointAuthenticationScheme")
    def service_endpoint_authentication_scheme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of Azure Resource Manager Service Endpoint. Possible values are `WorkloadIdentityFederation`, `ManagedServiceIdentity` or `ServicePrincipal`. Defaults to `ServicePrincipal` for backwards compatibility.

        > **NOTE:** The `WorkloadIdentityFederation` authentication scheme is currently in private preview. Your organisation must be part of the preview and the feature toggle must be turned on to use it. More details can be found [here](https://aka.ms/azdo-rm-workload-identity).
        """
        return pulumi.get(self, "service_endpoint_authentication_scheme")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Service Endpoint Name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Application(Client) ID of the Service Principal.
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationIssuer")
    def workload_identity_federation_issuer(self) -> pulumi.Output[_builtins.str]:
        """
        The issuer if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `https://vstoken.dev.azure.com/00000000-0000-0000-0000-000000000000`, where the GUID is the Organization ID of your Azure DevOps Organisation.
        """
        return pulumi.get(self, "workload_identity_federation_issuer")

    @_builtins.property
    @pulumi.getter(name="workloadIdentityFederationSubject")
    def workload_identity_federation_subject(self) -> pulumi.Output[_builtins.str]:
        """
        The subject if `service_endpoint_authentication_scheme` is set to `WorkloadIdentityFederation`. This looks like `sc://<organisation>/<project>/<service-connection-name>`.
        """
        return pulumi.get(self, "workload_identity_federation_subject")

