# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceendpointCheckmarxScaArgs', 'ServiceendpointCheckmarxSca']

@pulumi.input_type
class ServiceendpointCheckmarxScaArgs:
    def __init__(__self__, *,
                 access_control_url: pulumi.Input[_builtins.str],
                 account: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 server_url: pulumi.Input[_builtins.str],
                 service_endpoint_name: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 web_app_url: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceendpointCheckmarxSca resource.
        :param pulumi.Input[_builtins.str] access_control_url: The Access Control URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] account: The account of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] password: The password of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] server_url: The Server URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[_builtins.str] username: The username of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] web_app_url: The Web App URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] team: The full team name of the Checkmarx.
        """
        pulumi.set(__self__, "access_control_url", access_control_url)
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "server_url", server_url)
        pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "web_app_url", web_app_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @_builtins.property
    @pulumi.getter(name="accessControlUrl")
    def access_control_url(self) -> pulumi.Input[_builtins.str]:
        """
        The Access Control URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "access_control_url")

    @access_control_url.setter
    def access_control_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_control_url", value)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Input[_builtins.str]:
        """
        The account of the Checkmarx SCA.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The password of the Checkmarx SCA.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Input[_builtins.str]:
        """
        The Server URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the Checkmarx SCA.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> pulumi.Input[_builtins.str]:
        """
        The Web App URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "web_app_url")

    @web_app_url.setter
    def web_app_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "web_app_url", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full team name of the Checkmarx.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class _ServiceendpointCheckmarxScaState:
    def __init__(__self__, *,
                 access_control_url: Optional[pulumi.Input[_builtins.str]] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceendpointCheckmarxSca resources.
        :param pulumi.Input[_builtins.str] access_control_url: The Access Control URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] account: The account of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] password: The password of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] server_url: The Server URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[_builtins.str] team: The full team name of the Checkmarx.
        :param pulumi.Input[_builtins.str] username: The username of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] web_app_url: The Web App URL of the Checkmarx SCA.
        """
        if access_control_url is not None:
            pulumi.set(__self__, "access_control_url", access_control_url)
        if account is not None:
            pulumi.set(__self__, "account", account)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if server_url is not None:
            pulumi.set(__self__, "server_url", server_url)
        if service_endpoint_name is not None:
            pulumi.set(__self__, "service_endpoint_name", service_endpoint_name)
        if team is not None:
            pulumi.set(__self__, "team", team)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if web_app_url is not None:
            pulumi.set(__self__, "web_app_url", web_app_url)

    @_builtins.property
    @pulumi.getter(name="accessControlUrl")
    def access_control_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access Control URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "access_control_url")

    @access_control_url.setter
    def access_control_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_control_url", value)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The account of the Checkmarx SCA.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorization", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the Checkmarx SCA.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Server URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "server_url")

    @server_url.setter
    def server_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_url", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @service_endpoint_name.setter
    def service_endpoint_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint_name", value)

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full team name of the Checkmarx.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Checkmarx SCA.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Web App URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "web_app_url")

    @web_app_url.setter
    def web_app_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_app_url", value)


@pulumi.type_token("azuredevops:index/serviceendpointCheckmarxSca:ServiceendpointCheckmarxSca")
class ServiceendpointCheckmarxSca(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_url: Optional[pulumi.Input[_builtins.str]] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Checkmarx SCA service endpoint within Azure DevOps. Using this service endpoint requires you to install: [Checkmarx SAST](https://marketplace.visualstudio.com/items?itemName=checkmarx.cxsast)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_sca = azuredevops.ServiceendpointCheckmarxSca("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx SCA",
            access_control_url="https://accesscontrol.com",
            server_url="https://server.com",
            web_app_url="https://webapp.com",
            account="account",
            username="username",
            password="password")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Service Endpoint Check Marx SCA can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointCheckmarxSca:ServiceendpointCheckmarxSca example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_control_url: The Access Control URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] account: The account of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] password: The password of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] server_url: The Server URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[_builtins.str] team: The full team name of the Checkmarx.
        :param pulumi.Input[_builtins.str] username: The username of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] web_app_url: The Web App URL of the Checkmarx SCA.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceendpointCheckmarxScaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Checkmarx SCA service endpoint within Azure DevOps. Using this service endpoint requires you to install: [Checkmarx SAST](https://marketplace.visualstudio.com/items?itemName=checkmarx.cxsast)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            visibility="private",
            version_control="Git",
            work_item_template="Agile",
            description="Managed by Pulumi")
        example_serviceendpoint_checkmarx_sca = azuredevops.ServiceendpointCheckmarxSca("example",
            project_id=example.id,
            service_endpoint_name="Example Checkmarx SCA",
            access_control_url="https://accesscontrol.com",
            server_url="https://server.com",
            web_app_url="https://webapp.com",
            account="account",
            username="username",
            password="password")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.0 - Service Endpoints](https://docs.microsoft.com/en-us/rest/api/azure/devops/serviceendpoint/endpoints?view=azure-devops-rest-7.0)

        ## Import

        Azure DevOps Service Endpoint Check Marx SCA can be imported using **projectID/serviceEndpointID** or **projectName/serviceEndpointID**

        ```sh
        $ pulumi import azuredevops:index/serviceendpointCheckmarxSca:ServiceendpointCheckmarxSca example 00000000-0000-0000-0000-000000000000/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param ServiceendpointCheckmarxScaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceendpointCheckmarxScaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_url: Optional[pulumi.Input[_builtins.str]] = None,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_url: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
                 team: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 web_app_url: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceendpointCheckmarxScaArgs.__new__(ServiceendpointCheckmarxScaArgs)

            if access_control_url is None and not opts.urn:
                raise TypeError("Missing required property 'access_control_url'")
            __props__.__dict__["access_control_url"] = access_control_url
            if account is None and not opts.urn:
                raise TypeError("Missing required property 'account'")
            __props__.__dict__["account"] = account
            __props__.__dict__["description"] = description
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if server_url is None and not opts.urn:
                raise TypeError("Missing required property 'server_url'")
            __props__.__dict__["server_url"] = server_url
            if service_endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_endpoint_name'")
            __props__.__dict__["service_endpoint_name"] = service_endpoint_name
            __props__.__dict__["team"] = team
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            if web_app_url is None and not opts.urn:
                raise TypeError("Missing required property 'web_app_url'")
            __props__.__dict__["web_app_url"] = web_app_url
            __props__.__dict__["authorization"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceendpointCheckmarxSca, __self__).__init__(
            'azuredevops:index/serviceendpointCheckmarxSca:ServiceendpointCheckmarxSca',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control_url: Optional[pulumi.Input[_builtins.str]] = None,
            account: Optional[pulumi.Input[_builtins.str]] = None,
            authorization: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_url: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint_name: Optional[pulumi.Input[_builtins.str]] = None,
            team: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            web_app_url: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceendpointCheckmarxSca':
        """
        Get an existing ServiceendpointCheckmarxSca resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_control_url: The Access Control URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] account: The account of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] password: The password of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.str] server_url: The Server URL of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] service_endpoint_name: The Service Endpoint name.
        :param pulumi.Input[_builtins.str] team: The full team name of the Checkmarx.
        :param pulumi.Input[_builtins.str] username: The username of the Checkmarx SCA.
        :param pulumi.Input[_builtins.str] web_app_url: The Web App URL of the Checkmarx SCA.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceendpointCheckmarxScaState.__new__(_ServiceendpointCheckmarxScaState)

        __props__.__dict__["access_control_url"] = access_control_url
        __props__.__dict__["account"] = account
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["description"] = description
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["server_url"] = server_url
        __props__.__dict__["service_endpoint_name"] = service_endpoint_name
        __props__.__dict__["team"] = team
        __props__.__dict__["username"] = username
        __props__.__dict__["web_app_url"] = web_app_url
        return ServiceendpointCheckmarxSca(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControlUrl")
    def access_control_url(self) -> pulumi.Output[_builtins.str]:
        """
        The Access Control URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "access_control_url")

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output[_builtins.str]:
        """
        The account of the Checkmarx SCA.
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "authorization")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the Checkmarx SCA.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serverUrl")
    def server_url(self) -> pulumi.Output[_builtins.str]:
        """
        The Server URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "server_url")

    @_builtins.property
    @pulumi.getter(name="serviceEndpointName")
    def service_endpoint_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Service Endpoint name.
        """
        return pulumi.get(self, "service_endpoint_name")

    @_builtins.property
    @pulumi.getter
    def team(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The full team name of the Checkmarx.
        """
        return pulumi.get(self, "team")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the Checkmarx SCA.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="webAppUrl")
    def web_app_url(self) -> pulumi.Output[_builtins.str]:
        """
        The Web App URL of the Checkmarx SCA.
        """
        return pulumi.get(self, "web_app_url")

