# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServicehookPermissionsArgs', 'ServicehookPermissions']

@pulumi.input_type
class ServicehookPermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 principal: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ServicehookPermissions resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Name                | Permission Description |
               |---------------------|------------------------|
               | ViewSubscriptions   | View Subscriptions     |
               | EditSubscriptions   | Edit Subscription      |
               | DeleteSubscriptions | Delete Subscriptions   |
               | PublishEvents       | Publish Events         |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "principal", principal)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        the permissions to assign. The following permissions are available.

        | Name                | Permission Description |
        |---------------------|------------------------|
        | ViewSubscriptions   | View Subscriptions     |
        | EditSubscriptions   | Edit Subscription      |
        | DeleteSubscriptions | Delete Subscriptions   |
        | PublishEvents       | Publish Events         |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)


@pulumi.input_type
class _ServicehookPermissionsState:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ServicehookPermissions resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Name                | Permission Description |
               |---------------------|------------------------|
               | ViewSubscriptions   | View Subscriptions     |
               | EditSubscriptions   | Edit Subscription      |
               | DeleteSubscriptions | Delete Subscriptions   |
               | PublishEvents       | Publish Events         |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if replace is not None:
            pulumi.set(__self__, "replace", replace)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        the permissions to assign. The following permissions are available.

        | Name                | Permission Description |
        |---------------------|------------------------|
        | ViewSubscriptions   | View Subscriptions     |
        | EditSubscriptions   | Edit Subscription      |
        | DeleteSubscriptions | Delete Subscriptions   |
        | PublishEvents       | Publish Events         |
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def replace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

    @replace.setter
    def replace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "replace", value)


@pulumi.type_token("azuredevops:index/servicehookPermissions:ServicehookPermissions")
class ServicehookPermissions(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages permissions for Service Hook permissions.

        ## Permission levels

        Permissions for service hooks within Azure DevOps can be applied on the Organizational level or, if the optional attribute `project_id` is specified, on Project level.
        Those levels are reflected by specifying (or omitting) values for the argument `project_id`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_permissions = azuredevops.ServicehookPermissions("example-permissions",
            project_id=example.id,
            principal=example_readers.id,
            permissions={
                "ViewSubscriptions": "allow",
                "EditSubscriptions": "allow",
                "DeleteSubscriptions": "allow",
                "PublishEvents": "allow",
            })
        ```

        ## Relevant Links

        * [Azure DevOps Service REST API 7.0 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Name                | Permission Description |
               |---------------------|------------------------|
               | ViewSubscriptions   | View Subscriptions     |
               | EditSubscriptions   | Edit Subscription      |
               | DeleteSubscriptions | Delete Subscriptions   |
               | PublishEvents       | Publish Events         |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicehookPermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages permissions for Service Hook permissions.

        ## Permission levels

        Permissions for service hooks within Azure DevOps can be applied on the Organizational level or, if the optional attribute `project_id` is specified, on Project level.
        Those levels are reflected by specifying (or omitting) values for the argument `project_id`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            work_item_template="Agile",
            version_control="Git",
            visibility="private",
            description="Managed by Pulumi")
        example_readers = azuredevops.get_group_output(project_id=example.id,
            name="Readers")
        example_permissions = azuredevops.ServicehookPermissions("example-permissions",
            project_id=example.id,
            principal=example_readers.id,
            permissions={
                "ViewSubscriptions": "allow",
                "EditSubscriptions": "allow",
                "DeleteSubscriptions": "allow",
                "PublishEvents": "allow",
            })
        ```

        ## Relevant Links

        * [Azure DevOps Service REST API 7.0 - Security](https://docs.microsoft.com/en-us/rest/api/azure/devops/security/?view=azure-devops-rest-7.0)

        ## PAT Permissions Required

        - **Project & Team**: vso.security_manage - Grants the ability to read, write, and manage security permissions.

        ## Import

        The resource does not support import.

        :param str resource_name: The name of the resource.
        :param ServicehookPermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicehookPermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replace: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicehookPermissionsArgs.__new__(ServicehookPermissionsArgs)

            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["replace"] = replace
        super(ServicehookPermissions, __self__).__init__(
            'azuredevops:index/servicehookPermissions:ServicehookPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            permissions: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            replace: Optional[pulumi.Input[_builtins.bool]] = None) -> 'ServicehookPermissions':
        """
        Get an existing ServicehookPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] permissions: the permissions to assign. The following permissions are available.
               
               | Name                | Permission Description |
               |---------------------|------------------------|
               | ViewSubscriptions   | View Subscriptions     |
               | EditSubscriptions   | Edit Subscription      |
               | DeleteSubscriptions | Delete Subscriptions   |
               | PublishEvents       | Publish Events         |
        :param pulumi.Input[_builtins.str] principal: The **group** principal to assign the permissions.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project.
        :param pulumi.Input[_builtins.bool] replace: Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicehookPermissionsState.__new__(_ServicehookPermissionsState)

        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["principal"] = principal
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["replace"] = replace
        return ServicehookPermissions(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        the permissions to assign. The following permissions are available.

        | Name                | Permission Description |
        |---------------------|------------------------|
        | ViewSubscriptions   | View Subscriptions     |
        | EditSubscriptions   | Edit Subscription      |
        | DeleteSubscriptions | Delete Subscriptions   |
        | PublishEvents       | Publish Events         |
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The **group** principal to assign the permissions.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Replace (`true`) or merge (`false`) the permissions. Default: `true`
        """
        return pulumi.get(self, "replace")

