# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WikiPageArgs', 'WikiPage']

@pulumi.input_type
class WikiPageArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[_builtins.str],
                 path: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 wiki_id: pulumi.Input[_builtins.str],
                 etag: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a WikiPage resource.
        :param pulumi.Input[_builtins.str] content: The content of the wiki page.
        :param pulumi.Input[_builtins.str] path: The path of the wiki page.
        :param pulumi.Input[_builtins.str] project_id: The ID of the Project.
        :param pulumi.Input[_builtins.str] wiki_id: The ID of the Wiki.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "wiki_id", wiki_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the wiki page.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Input[_builtins.str]:
        """
        The path of the wiki page.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="wikiId")
    def wiki_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Wiki.
        """
        return pulumi.get(self, "wiki_id")

    @wiki_id.setter
    def wiki_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "wiki_id", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)


@pulumi.input_type
class _WikiPageState:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WikiPage resources.
        :param pulumi.Input[_builtins.str] content: The content of the wiki page.
        :param pulumi.Input[_builtins.str] path: The path of the wiki page.
        :param pulumi.Input[_builtins.str] project_id: The ID of the Project.
        :param pulumi.Input[_builtins.str] wiki_id: The ID of the Wiki.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if wiki_id is not None:
            pulumi.set(__self__, "wiki_id", wiki_id)

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the wiki page.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The path of the wiki page.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="wikiId")
    def wiki_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Wiki.
        """
        return pulumi.get(self, "wiki_id")

    @wiki_id.setter
    def wiki_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wiki_id", value)


@pulumi.type_token("azuredevops:index/wikiPage:WikiPage")
class WikiPage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Wiki pages within Azure DevOps project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_wiki = azuredevops.Wiki("example",
            project_id=example.id,
            name="Example project wiki ",
            type="projectWiki")
        example_wiki_page = azuredevops.WikiPage("example",
            project_id=example.id,
            wiki_id=example_wiki.id,
            path="/page",
            content="content")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Wiki Page](https://learn.microsoft.com/en-us/rest/api/azure/devops/wiki/pages?view=azure-devops-rest-7.1)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The content of the wiki page.
        :param pulumi.Input[_builtins.str] path: The path of the wiki page.
        :param pulumi.Input[_builtins.str] project_id: The ID of the Project.
        :param pulumi.Input[_builtins.str] wiki_id: The ID of the Wiki.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WikiPageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Wiki pages within Azure DevOps project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azuredevops as azuredevops

        example = azuredevops.Project("example",
            name="Example Project",
            description="Managed by Pulumi")
        example_wiki = azuredevops.Wiki("example",
            project_id=example.id,
            name="Example project wiki ",
            type="projectWiki")
        example_wiki_page = azuredevops.WikiPage("example",
            project_id=example.id,
            wiki_id=example_wiki.id,
            path="/page",
            content="content")
        ```

        ## Relevant Links

        - [Azure DevOps Service REST API 7.1 - Wiki Page](https://learn.microsoft.com/en-us/rest/api/azure/devops/wiki/pages?view=azure-devops-rest-7.1)

        :param str resource_name: The name of the resource.
        :param WikiPageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WikiPageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wiki_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WikiPageArgs.__new__(WikiPageArgs)

            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["etag"] = etag
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if wiki_id is None and not opts.urn:
                raise TypeError("Missing required property 'wiki_id'")
            __props__.__dict__["wiki_id"] = wiki_id
        super(WikiPage, __self__).__init__(
            'azuredevops:index/wikiPage:WikiPage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            wiki_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WikiPage':
        """
        Get an existing WikiPage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] content: The content of the wiki page.
        :param pulumi.Input[_builtins.str] path: The path of the wiki page.
        :param pulumi.Input[_builtins.str] project_id: The ID of the Project.
        :param pulumi.Input[_builtins.str] wiki_id: The ID of the Wiki.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WikiPageState.__new__(_WikiPageState)

        __props__.__dict__["content"] = content
        __props__.__dict__["etag"] = etag
        __props__.__dict__["path"] = path
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["wiki_id"] = wiki_id
        return WikiPage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def content(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the wiki page.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The path of the wiki page.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Project.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="wikiId")
    def wiki_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Wiki.
        """
        return pulumi.get(self, "wiki_id")

