"""
Qnty - High-Performance Unit System for Engineering
====================================================

A fast, type-safe unit system library for Python with dimensional safety and optimized unit conversions for engineering calculations.
"""

# from . import (quantity, expressions)

from .expressions import (
    abs_expr,
    cond_expr,
    cos,
    exp,
    ln,
    log10,
    max_expr,
    min_expr,
    sin,
    sqrt,
    tan,
)
from .problems import Problem
from .quantities.field_vars import (
    AbsorbedDose,
    Acceleration,
    ActivationEnergy,
    AmountOfSubstance,
    AnglePlane,
    AngleSolid,
    AngularAcceleration,
    AngularMomentum,
    Area,
    AreaPerUnitVolume,
    AtomicWeight,
    Concentration,
    Dimensionless,
    DynamicFluidity,
    ElectricalConductance,
    ElectricalPermittivity,
    ElectricalResistivity,
    ElectricCapacitance,
    ElectricCharge,
    ElectricCurrentIntensity,
    ElectricDipoleMoment,
    ElectricFieldStrength,
    ElectricInductance,
    ElectricPotential,
    ElectricResistance,
    EnergyFlux,
    EnergyHeatWork,
    EnergyPerUnitArea,
    Force,
    ForceBody,
    ForcePerUnitMass,
    FrequencyVoltageRatio,
    FuelConsumption,
    HeatOfCombustion,
    HeatOfFusion,
    HeatOfVaporization,
    HeatTransferCoefficient,
    Illuminance,
    KineticEnergyOfTurbulence,
    Length,
    LinearMassDensity,
    LinearMomentum,
    LuminanceSelf,
    LuminousFlux,
    LuminousIntensity,
    MagneticField,
    MagneticFlux,
    MagneticInductionFieldStrength,
    MagneticMoment,
    MagneticPermeability,
    MagnetomotiveForce,
    Mass,
    MassDensity,
    MassFlowRate,
    MassFlux,
    MassFractionOfI,
    MassTransferCoefficient,
    MolalityOfSoluteI,
    MolarConcentrationByMass,
    MolarFlowRate,
    MolarFlux,
    MolarHeatCapacity,
    MolarityOfI,
    MoleFractionOfI,
    MomentOfInertia,
    MomentumFlowRate,
    MomentumFlux,
    NormalityOfSolution,
    ParticleDensity,
    Percent,
    Permeability,
    PhotonEmissionRate,
    PowerPerUnitMass,
    PowerPerUnitVolume,
    PowerThermalDuty,
    Pressure,
    RadiationDoseEquivalent,
    RadiationExposure,
    Radioactivity,
    SecondMomentOfArea,
    SecondRadiationConstantPlanck,
    SpecificEnthalpy,
    SpecificGravity,
    SpecificHeatCapacityConstantPressure,
    SpecificLength,
    SpecificSurface,
    SpecificVolume,
    Stress,
    SurfaceMassDensity,
    SurfaceTension,
    Temperature,
    ThermalConductivity,
    Time,
    Torque,
    TurbulenceEnergyDissipationRate,
    VelocityAngular,
    VelocityLinear,
    ViscosityDynamic,
    ViscosityKinematic,
    Volume,
    VolumeFractionOfI,
    VolumetricCalorificHeatingValue,
    VolumetricCoefficientOfExpansion,
    VolumetricFlowRate,
    VolumetricFlux,
    VolumetricMassFlowRate,
    Wavenumber,
)

# Define public API
__all__ = [
    "abs_expr",
    "min_expr",
    "max_expr",
    "cond_expr",
    "sin",
    "cos",
    "tan",
    "sqrt",
    "ln",
    "log10",
    "exp",
    "Problem",
    "AbsorbedDose",
    "Acceleration",
    "ActivationEnergy",
    "AmountOfSubstance",
    "AnglePlane",
    "AngleSolid",
    "AngularAcceleration",
    "AngularMomentum",
    "Area",
    "AreaPerUnitVolume",
    "AtomicWeight",
    "Concentration",
    "Dimensionless",
    "DynamicFluidity",
    "ElectricalConductance",
    "ElectricalPermittivity",
    "ElectricalResistivity",
    "ElectricCapacitance",
    "ElectricCharge",
    "ElectricCurrentIntensity",
    "ElectricDipoleMoment",
    "ElectricFieldStrength",
    "ElectricInductance",
    "ElectricPotential",
    "ElectricResistance",
    "EnergyFlux",
    "EnergyHeatWork",
    "EnergyPerUnitArea",
    "Force",
    "ForceBody",
    "ForcePerUnitMass",
    "FrequencyVoltageRatio",
    "FuelConsumption",
    "HeatOfCombustion",
    "HeatOfFusion",
    "HeatOfVaporization",
    "HeatTransferCoefficient",
    "Illuminance",
    "KineticEnergyOfTurbulence",
    "Length",
    "LinearMassDensity",
    "LinearMomentum",
    "LuminanceSelf",
    "LuminousFlux",
    "LuminousIntensity",
    "MagneticField",
    "MagneticFlux",
    "MagneticInductionFieldStrength",
    "MagneticMoment",
    "MagneticPermeability",
    "MagnetomotiveForce",
    "Mass",
    "MassDensity",
    "MassFlowRate",
    "MassFlux",
    "MassFractionOfI",
    "MassTransferCoefficient",
    "MolalityOfSoluteI",
    "MolarConcentrationByMass",
    "MolarFlowRate",
    "MolarFlux",
    "MolarHeatCapacity",
    "MolarityOfI",
    "MoleFractionOfI",
    "MomentOfInertia",
    "MomentumFlowRate",
    "MomentumFlux",
    "NormalityOfSolution",
    "ParticleDensity",
    "Percent",
    "Permeability",
    "PhotonEmissionRate",
    "PowerPerUnitMass",
    "PowerPerUnitVolume",
    "PowerThermalDuty",
    "Pressure",
    "RadiationDoseEquivalent",
    "RadiationExposure",
    "Radioactivity",
    "SecondMomentOfArea",
    "SecondRadiationConstantPlanck",
    "SpecificEnthalpy",
    "SpecificGravity",
    "SpecificHeatCapacityConstantPressure",
    "SpecificLength",
    "SpecificSurface",
    "SpecificVolume",
    "Stress",
    "SurfaceMassDensity",
    "SurfaceTension",
    "Temperature",
    "ThermalConductivity",
    "Time",
    "Torque",
    "TurbulenceEnergyDissipationRate",
    "VelocityAngular",
    "VelocityLinear",
    "ViscosityDynamic",
    "ViscosityKinematic",
    "Volume",
    "VolumeFractionOfI",
    "VolumetricCalorificHeatingValue",
    "VolumetricCoefficientOfExpansion",
    "VolumetricFlowRate",
    "VolumetricFlux",
    "VolumetricMassFlowRate",
    "Wavenumber",
]
