"""
Converter Classes Module - Static Edition
========================================

Static converter class definitions for maximum import performance.
Provides fluent API unit properties for ToUnit and AsUnit converters.
Auto-generated by codegen/generators/field_converters.py
DO NOT EDIT MANUALLY - changes will be overwritten.
"""

from typing import TYPE_CHECKING, Final

if TYPE_CHECKING:
    from ..quantities.field_qnty import FieldQnty

from ..units import field_units
from .base_qnty import Quantity

# ===== BASE CONVERTER CLASSES =====

class UnitConverter:
    """Base unit converter class."""

    def __init__(self, variable: 'FieldQnty') -> None:
        self.variable = variable

    def _get_unit_constant(self, unit_name: str):
        """Get unit constant from field_units."""
        if hasattr(self.variable, '_dimension') and self.variable._dimension:
            # Get the dimension-specific units class
            class_name = self.variable.__class__.__name__
            units_class_name = f'{class_name}Units'
            units_class = getattr(field_units, units_class_name, None)
            if units_class and hasattr(units_class, unit_name):
                return getattr(units_class, unit_name)
        raise ValueError(f'Unknown unit: {unit_name} for {self.variable.__class__.__name__}')

    def _convert_quantity(self, unit_constant, modify_original: bool = False):
        """Convert quantity to specified unit."""
        if self.variable.quantity is None:
            raise ValueError('Cannot convert variable with no quantity')
        
        # Convert to the target unit
        converted_quantity = self.variable.quantity.to(unit_constant)
        converted_value = converted_quantity.value
        
        if modify_original:
            # Modify the original variable
            self.variable.quantity = Quantity(converted_value, unit_constant)
            return self.variable
        else:
            # Return a new variable representation
            new_var = self.variable.__class__(converted_value, unit_constant.name, f'{self.variable.name}_converted')
            return new_var

# ===== TO_UNIT CONVERTER CLASSES =====
# Converter classes that modify the original variable

class ToUnitAbsorbedDoseConverter(UnitConverter):
    """AbsorbedDose-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def erg_per_gram(self) -> 'FieldQnty':
        """Convert to erg per gram units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.erg_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def erg_g(self) -> 'FieldQnty':
        """Convert to erg_g units (alias for erg_per_gram)."""
        return self.erg_per_gram

    @property
    def erg_per_g(self) -> 'FieldQnty':
        """Convert to erg_per_g units (alias for erg_per_gram)."""
        return self.erg_per_gram

    @property
    def gram_rad(self) -> 'FieldQnty':
        """Convert to gram-rad units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.gram_rad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def g_rad(self) -> 'FieldQnty':
        """Convert to g_rad units (alias for gram_rad)."""
        return self.gram_rad

    @property
    def gray(self) -> 'FieldQnty':
        """Convert to gray units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.gray
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Gy(self) -> 'FieldQnty':
        """Convert to Gy units (alias for gray)."""
        return self.gray

    @property
    def rad(self) -> 'FieldQnty':
        """Convert to rad units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.rad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def milligray(self) -> 'FieldQnty':
        """Convert to milligray units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.milligray
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mGy(self) -> 'FieldQnty':
        """Convert to mGy units (alias for milligray)."""
        return self.milligray

    @property
    def microgray(self) -> 'FieldQnty':
        """Convert to microgray units."""
        unit_const: Final = field_units.AbsorbedDoseUnits.microgray
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitAccelerationConverter(UnitConverter):
    """Acceleration-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def meter_per_second_squared(self) -> 'FieldQnty':
        """Convert to meter per second squared units."""
        unit_const: Final = field_units.AccelerationUnits.meter_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_s_2 units (alias for meter_per_second_squared)."""
        return self.meter_per_second_squared

    @property
    def m_per_s2(self) -> 'FieldQnty':
        """Convert to m_per_s2 units (alias for meter_per_second_squared)."""
        return self.meter_per_second_squared

    @property
    def foot_per_second_squared(self) -> 'FieldQnty':
        """Convert to foot per second squared units."""
        unit_const: Final = field_units.AccelerationUnits.foot_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_s_2_or_mathrm_ft_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_s_2_or_mathrm_ft_mathrm_sec_2 units (alias for foot_per_second_squared)."""
        return self.foot_per_second_squared

    @property
    def ft_per_s2(self) -> 'FieldQnty':
        """Convert to ft_per_s2 units (alias for foot_per_second_squared)."""
        return self.foot_per_second_squared

    @property
    def fps2(self) -> 'FieldQnty':
        """Convert to fps2 units (alias for foot_per_second_squared)."""
        return self.foot_per_second_squared


class ToUnitActivationEnergyConverter(UnitConverter):
    """ActivationEnergy-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_per_pound_mole(self) -> 'FieldQnty':
        """Convert to Btu per pound mole units."""
        unit_const: Final = field_units.ActivationEnergyUnits.btu_per_pound_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb_mol(self) -> 'FieldQnty':
        """Convert to Btu_lb_mol units (alias for btu_per_pound_mole)."""
        return self.btu_per_pound_mole

    @property
    def btu_per_lbmol(self) -> 'FieldQnty':
        """Convert to btu_per_lbmol units (alias for btu_per_pound_mole)."""
        return self.btu_per_pound_mole

    @property
    def calorie_mean_per_gram_mole(self) -> 'FieldQnty':
        """Convert to calorie (mean) per gram mole units."""
        unit_const: Final = field_units.ActivationEnergyUnits.calorie_mean_per_gram_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_mol(self) -> 'FieldQnty':
        """Convert to cal_mol units (alias for calorie_mean_per_gram_mole)."""
        return self.calorie_mean_per_gram_mole

    @property
    def cal_mean_per_gmol(self) -> 'FieldQnty':
        """Convert to cal_mean_per_gmol units (alias for calorie_mean_per_gram_mole)."""
        return self.calorie_mean_per_gram_mole

    @property
    def joule_per_gram_mole(self) -> 'FieldQnty':
        """Convert to joule per gram mole units."""
        unit_const: Final = field_units.ActivationEnergyUnits.joule_per_gram_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_mol(self) -> 'FieldQnty':
        """Convert to J_mol units (alias for joule_per_gram_mole)."""
        return self.joule_per_gram_mole

    @property
    def joule_per_kilogram_mole(self) -> 'FieldQnty':
        """Convert to joule per kilogram mole units."""
        unit_const: Final = field_units.ActivationEnergyUnits.joule_per_kilogram_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kmol(self) -> 'FieldQnty':
        """Convert to J_kmol units (alias for joule_per_kilogram_mole)."""
        return self.joule_per_kilogram_mole

    @property
    def kilocalorie_per_kilogram_mole(self) -> 'FieldQnty':
        """Convert to kilocalorie per kilogram mole units."""
        unit_const: Final = field_units.ActivationEnergyUnits.kilocalorie_per_kilogram_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kcal_kmol(self) -> 'FieldQnty':
        """Convert to kcal_kmol units (alias for kilocalorie_per_kilogram_mole)."""
        return self.kilocalorie_per_kilogram_mole


class ToUnitAmountOfSubstanceConverter(UnitConverter):
    """AmountOfSubstance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def kilogram_mol(self) -> 'FieldQnty':
        """Convert to kilogram mol or kmol units."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.kilogram_mol
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol(self) -> 'FieldQnty':
        """Convert to kmol units (alias for kilogram_mol)."""
        return self.kilogram_mol

    @property
    def mole(self) -> 'FieldQnty':
        """Convert to mole (gram) units."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol(self) -> 'FieldQnty':
        """Convert to mol units (alias for mole)."""
        return self.mole

    @property
    def pound_mole(self) -> 'FieldQnty':
        """Convert to pound-mole units."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.pound_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mol_or_mole(self) -> 'FieldQnty':
        """Convert to lb_mol_or_mole units (alias for pound_mole)."""
        return self.pound_mole

    @property
    def lb_mol(self) -> 'FieldQnty':
        """Convert to lb_mol units (alias for pound_mole)."""
        return self.pound_mole

    @property
    def millimole(self) -> 'FieldQnty':
        """Convert to millimole (gram) units."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.millimole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mmol(self) -> 'FieldQnty':
        """Convert to mmol units (alias for millimole)."""
        return self.millimole

    @property
    def micromole(self) -> 'FieldQnty':
        """Convert to micromole (gram) units."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.micromole
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitAnglePlaneConverter(UnitConverter):
    """AnglePlane-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def degree(self) -> 'FieldQnty':
        """Convert to degree units."""
        unit_const: Final = field_units.AnglePlaneUnits.degree
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def circ(self) -> 'FieldQnty':
        """Convert to circ units (alias for degree)."""
        return self.degree

    @property
    def gon(self) -> 'FieldQnty':
        """Convert to gon units."""
        unit_const: Final = field_units.AnglePlaneUnits.gon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def grade(self) -> 'FieldQnty':
        """Convert to grade units."""
        unit_const: Final = field_units.AnglePlaneUnits.grade
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def minute_new(self) -> 'FieldQnty':
        """Convert to minute (new) units."""
        unit_const: Final = field_units.AnglePlaneUnits.minute_new
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def c(self) -> 'FieldQnty':
        """Convert to c units (alias for minute_new)."""
        return self.minute_new

    @property
    def minute_of_angle(self) -> 'FieldQnty':
        """Convert to minute of angle units."""
        unit_const: Final = field_units.AnglePlaneUnits.minute_of_angle
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for minute_of_angle)."""
        return self.minute_of_angle

    @property
    def percent(self) -> 'FieldQnty':
        """Convert to percent units."""
        unit_const: Final = field_units.AnglePlaneUnits.percent
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def plane_angle(self) -> 'FieldQnty':
        """Convert to plane angle units."""
        unit_const: Final = field_units.AnglePlaneUnits.plane_angle
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def quadrant(self) -> 'FieldQnty':
        """Convert to quadrant units."""
        unit_const: Final = field_units.AnglePlaneUnits.quadrant
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def quadr(self) -> 'FieldQnty':
        """Convert to quadr units (alias for quadrant)."""
        return self.quadrant

    @property
    def radian(self) -> 'FieldQnty':
        """Convert to radian units."""
        unit_const: Final = field_units.AnglePlaneUnits.radian
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def rad(self) -> 'FieldQnty':
        """Convert to rad units (alias for radian)."""
        return self.radian

    @property
    def right_angle(self) -> 'FieldQnty':
        """Convert to right angle units."""
        unit_const: Final = field_units.AnglePlaneUnits.right_angle
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def perp(self) -> 'FieldQnty':
        """Convert to perp units (alias for right_angle)."""
        return self.right_angle

    @property
    def round(self) -> 'FieldQnty':
        """Convert to round units."""
        unit_const: Final = field_units.AnglePlaneUnits.round
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tr_or_r(self) -> 'FieldQnty':
        """Convert to tr_or_r units (alias for round)."""
        return self.round

    @property
    def tr(self) -> 'FieldQnty':
        """Convert to tr units (alias for round)."""
        return self.round

    @property
    def r(self) -> 'FieldQnty':
        """Convert to r units (alias for round)."""
        return self.round

    @property
    def second_new(self) -> 'FieldQnty':
        """Convert to second (new) units."""
        unit_const: Final = field_units.AnglePlaneUnits.second_new
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for second_new)."""
        return self.second_new

    @property
    def second_of_angle(self) -> 'FieldQnty':
        """Convert to second of angle units."""
        unit_const: Final = field_units.AnglePlaneUnits.second_of_angle
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def thousandth_us(self) -> 'FieldQnty':
        """Convert to thousandth (US) units."""
        unit_const: Final = field_units.AnglePlaneUnits.thousandth_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def US(self) -> 'FieldQnty':
        """Convert to US units (alias for thousandth_us)."""
        return self.thousandth_us

    @property
    def turn(self) -> 'FieldQnty':
        """Convert to turn units."""
        unit_const: Final = field_units.AnglePlaneUnits.turn
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def turn_or_rev(self) -> 'FieldQnty':
        """Convert to turn_or_rev units (alias for turn)."""
        return self.turn

    @property
    def rev(self) -> 'FieldQnty':
        """Convert to rev units (alias for turn)."""
        return self.turn


class ToUnitAngleSolidConverter(UnitConverter):
    """AngleSolid-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def spat(self) -> 'FieldQnty':
        """Convert to spat units."""
        unit_const: Final = field_units.AngleSolidUnits.spat
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def square_degree(self) -> 'FieldQnty':
        """Convert to square degree units."""
        unit_const: Final = field_units.AngleSolidUnits.square_degree
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def left_circ_right_2(self) -> 'FieldQnty':
        """Convert to left_circ_right_2 units (alias for square_degree)."""
        return self.square_degree

    @property
    def square_gon(self) -> 'FieldQnty':
        """Convert to square gon units."""
        unit_const: Final = field_units.AngleSolidUnits.square_gon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def g_2(self) -> 'FieldQnty':
        """Convert to g_2 units (alias for square_gon)."""
        return self.square_gon

    @property
    def steradian(self) -> 'FieldQnty':
        """Convert to steradian units."""
        unit_const: Final = field_units.AngleSolidUnits.steradian
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sr(self) -> 'FieldQnty':
        """Convert to sr units (alias for steradian)."""
        return self.steradian


class ToUnitAngularAccelerationConverter(UnitConverter):
    """AngularAcceleration-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def radian_per_second_squared(self) -> 'FieldQnty':
        """Convert to radian per second squared units."""
        unit_const: Final = field_units.AngularAccelerationUnits.radian_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_rad_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_s_2 units (alias for radian_per_second_squared)."""
        return self.radian_per_second_squared

    @property
    def revolution_per_second_squared(self) -> 'FieldQnty':
        """Convert to revolution per second squared units."""
        unit_const: Final = field_units.AngularAccelerationUnits.revolution_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_rev_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_rev_mathrm_sec_2 units (alias for revolution_per_second_squared)."""
        return self.revolution_per_second_squared

    @property
    def rpm_or_revolution_per_minute(self) -> 'FieldQnty':
        """Convert to rpm (or revolution per minute) per minute units."""
        unit_const: Final = field_units.AngularAccelerationUnits.rpm_or_revolution_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_rev_mathrm_min_2_or_rpm_min(self) -> 'FieldQnty':
        """Convert to mathrm_rev_mathrm_min_2_or_rpm_min units (alias for rpm_or_revolution_per_minute)."""
        return self.rpm_or_revolution_per_minute

    @property
    def rev_min_2(self) -> 'FieldQnty':
        """Convert to rev_min_2 units (alias for rpm_or_revolution_per_minute)."""
        return self.rpm_or_revolution_per_minute

    @property
    def rpm_min(self) -> 'FieldQnty':
        """Convert to rpm_min units (alias for rpm_or_revolution_per_minute)."""
        return self.rpm_or_revolution_per_minute


class ToUnitAngularMomentumConverter(UnitConverter):
    """AngularMomentum-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_centimeter_squared_per_second(self) -> 'FieldQnty':
        """Convert to gram centimeter squared per second units."""
        unit_const: Final = field_units.AngularMomentumUnits.gram_centimeter_squared_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2_mathrm_s units (alias for gram_centimeter_squared_per_second)."""
        return self.gram_centimeter_squared_per_second

    @property
    def kilogram_meter_squared_per_second(self) -> 'FieldQnty':
        """Convert to kilogram meter squared per second units."""
        unit_const: Final = field_units.AngularMomentumUnits.kilogram_meter_squared_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2_mathrm_s units (alias for kilogram_meter_squared_per_second)."""
        return self.kilogram_meter_squared_per_second

    @property
    def pound_force_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound force square foot per second units."""
        unit_const: Final = field_units.AngularMomentumUnits.pound_force_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_ft_2_mathrm_sec(self) -> 'FieldQnty':
        """Convert to lb_ft_2_mathrm_sec units (alias for pound_force_square_foot_per_second)."""
        return self.pound_force_square_foot_per_second


class ToUnitAreaConverter(UnitConverter):
    """Area-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def acre_general(self) -> 'FieldQnty':
        """Convert to acre (general) units."""
        unit_const: Final = field_units.AreaUnits.acre_general
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ac(self) -> 'FieldQnty':
        """Convert to ac units (alias for acre_general)."""
        return self.acre_general

    @property
    def are(self) -> 'FieldQnty':
        """Convert to are units."""
        unit_const: Final = field_units.AreaUnits.are
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def a(self) -> 'FieldQnty':
        """Convert to a units (alias for are)."""
        return self.are

    @property
    def arpent_quebec(self) -> 'FieldQnty':
        """Convert to arpent (Quebec) units."""
        unit_const: Final = field_units.AreaUnits.arpent_quebec
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def arp(self) -> 'FieldQnty':
        """Convert to arp units (alias for arpent_quebec)."""
        return self.arpent_quebec

    @property
    def barn(self) -> 'FieldQnty':
        """Convert to barn units."""
        unit_const: Final = field_units.AreaUnits.barn
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def b(self) -> 'FieldQnty':
        """Convert to b units (alias for barn)."""
        return self.barn

    @property
    def circular_inch(self) -> 'FieldQnty':
        """Convert to circular inch units."""
        unit_const: Final = field_units.AreaUnits.circular_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cin(self) -> 'FieldQnty':
        """Convert to cin units (alias for circular_inch)."""
        return self.circular_inch

    @property
    def circular_mil(self) -> 'FieldQnty':
        """Convert to circular mil units."""
        unit_const: Final = field_units.AreaUnits.circular_mil
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cmil(self) -> 'FieldQnty':
        """Convert to cmil units (alias for circular_mil)."""
        return self.circular_mil

    @property
    def hectare(self) -> 'FieldQnty':
        """Convert to hectare units."""
        unit_const: Final = field_units.AreaUnits.hectare
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ha(self) -> 'FieldQnty':
        """Convert to ha units (alias for hectare)."""
        return self.hectare

    @property
    def shed(self) -> 'FieldQnty':
        """Convert to shed units."""
        unit_const: Final = field_units.AreaUnits.shed
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def square_centimeter(self) -> 'FieldQnty':
        """Convert to square centimeter units."""
        unit_const: Final = field_units.AreaUnits.square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2 units (alias for square_centimeter)."""
        return self.square_centimeter

    @property
    def square_chain_ramsden(self) -> 'FieldQnty':
        """Convert to square chain (Ramsden) units."""
        unit_const: Final = field_units.AreaUnits.square_chain_ramsden
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_ch_Rams(self) -> 'FieldQnty':
        """Convert to sq_ch_Rams units (alias for square_chain_ramsden)."""
        return self.square_chain_ramsden

    @property
    def square_chain_survey_gunters(self) -> 'FieldQnty':
        """Convert to square chain (Survey, Gunter's) units."""
        unit_const: Final = field_units.AreaUnits.square_chain_survey_gunters
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_ch_surv(self) -> 'FieldQnty':
        """Convert to sq_ch_surv units (alias for square_chain_survey_gunters)."""
        return self.square_chain_survey_gunters

    @property
    def square_decimeter(self) -> 'FieldQnty':
        """Convert to square decimeter units."""
        unit_const: Final = field_units.AreaUnits.square_decimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_dm_2(self) -> 'FieldQnty':
        """Convert to mathrm_dm_2 units (alias for square_decimeter)."""
        return self.square_decimeter

    @property
    def square_fermi(self) -> 'FieldQnty':
        """Convert to square fermi units."""
        unit_const: Final = field_units.AreaUnits.square_fermi
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_F_2(self) -> 'FieldQnty':
        """Convert to mathrm_F_2 units (alias for square_fermi)."""
        return self.square_fermi

    @property
    def square_foot(self) -> 'FieldQnty':
        """Convert to square foot units."""
        unit_const: Final = field_units.AreaUnits.square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_ft_or_ft_2(self) -> 'FieldQnty':
        """Convert to sq_ft_or_ft_2 units (alias for square_foot)."""
        return self.square_foot

    @property
    def sq_ft(self) -> 'FieldQnty':
        """Convert to sq_ft units (alias for square_foot)."""
        return self.square_foot

    @property
    def ft_2(self) -> 'FieldQnty':
        """Convert to ft_2 units (alias for square_foot)."""
        return self.square_foot

    @property
    def square_hectometer(self) -> 'FieldQnty':
        """Convert to square hectometer units."""
        unit_const: Final = field_units.AreaUnits.square_hectometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_hm_2(self) -> 'FieldQnty':
        """Convert to mathrm_hm_2 units (alias for square_hectometer)."""
        return self.square_hectometer

    @property
    def square_inch(self) -> 'FieldQnty':
        """Convert to square inch units."""
        unit_const: Final = field_units.AreaUnits.square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_in_or_in_2(self) -> 'FieldQnty':
        """Convert to sq_in_or_in_2 units (alias for square_inch)."""
        return self.square_inch

    @property
    def sq_in(self) -> 'FieldQnty':
        """Convert to sq_in units (alias for square_inch)."""
        return self.square_inch

    @property
    def in_2(self) -> 'FieldQnty':
        """Convert to in_2 units (alias for square_inch)."""
        return self.square_inch

    @property
    def square_kilometer(self) -> 'FieldQnty':
        """Convert to square kilometer units."""
        unit_const: Final = field_units.AreaUnits.square_kilometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_km_2(self) -> 'FieldQnty':
        """Convert to mathrm_km_2 units (alias for square_kilometer)."""
        return self.square_kilometer

    @property
    def square_league_statute(self) -> 'FieldQnty':
        """Convert to square league (statute) units."""
        unit_const: Final = field_units.AreaUnits.square_league_statute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_lg_stat(self) -> 'FieldQnty':
        """Convert to sq_lg_stat units (alias for square_league_statute)."""
        return self.square_league_statute

    @property
    def square_meter(self) -> 'FieldQnty':
        """Convert to square meter units."""
        unit_const: Final = field_units.AreaUnits.square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2 units (alias for square_meter)."""
        return self.square_meter

    @property
    def square_micron(self) -> 'FieldQnty':
        """Convert to square micron units."""
        unit_const: Final = field_units.AreaUnits.square_micron
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_m_2_or_mu_2(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m_2_or_mu_2 units (alias for square_micron)."""
        return self.square_micron

    @property
    def mu_m_2(self) -> 'FieldQnty':
        """Convert to mu_m_2 units (alias for square_micron)."""
        return self.square_micron

    @property
    def mu_2(self) -> 'FieldQnty':
        """Convert to mu_2 units (alias for square_micron)."""
        return self.square_micron

    @property
    def square_mile_statute(self) -> 'FieldQnty':
        """Convert to square mile (statute) units."""
        unit_const: Final = field_units.AreaUnits.square_mile_statute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_mi_stat(self) -> 'FieldQnty':
        """Convert to sq_mi_stat units (alias for square_mile_statute)."""
        return self.square_mile_statute

    @property
    def square_mile_us_survey(self) -> 'FieldQnty':
        """Convert to square mile (US survey) units."""
        unit_const: Final = field_units.AreaUnits.square_mile_us_survey
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_mi_US_Surv(self) -> 'FieldQnty':
        """Convert to sq_mi_US_Surv units (alias for square_mile_us_survey)."""
        return self.square_mile_us_survey

    @property
    def square_millimeter(self) -> 'FieldQnty':
        """Convert to square millimeter units."""
        unit_const: Final = field_units.AreaUnits.square_millimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mm_2(self) -> 'FieldQnty':
        """Convert to mathrm_mm_2 units (alias for square_millimeter)."""
        return self.square_millimeter

    @property
    def square_nanometer(self) -> 'FieldQnty':
        """Convert to square nanometer units."""
        unit_const: Final = field_units.AreaUnits.square_nanometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_nm_2(self) -> 'FieldQnty':
        """Convert to mathrm_nm_2 units (alias for square_nanometer)."""
        return self.square_nanometer

    @property
    def square_yard(self) -> 'FieldQnty':
        """Convert to square yard units."""
        unit_const: Final = field_units.AreaUnits.square_yard
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sq_yd(self) -> 'FieldQnty':
        """Convert to sq_yd units (alias for square_yard)."""
        return self.square_yard

    @property
    def township_us(self) -> 'FieldQnty':
        """Convert to township (US) units."""
        unit_const: Final = field_units.AreaUnits.township_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def twshp(self) -> 'FieldQnty':
        """Convert to twshp units (alias for township_us)."""
        return self.township_us


class ToUnitAreaPerUnitVolumeConverter(UnitConverter):
    """AreaPerUnitVolume-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def square_centimeter_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to square centimeter per cubic centimeter units."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_centimeter_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_2_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_cc units (alias for square_centimeter_per_cubic_centimeter)."""
        return self.square_centimeter_per_cubic_centimeter

    @property
    def square_foot_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to square foot per cubic foot units."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_foot_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_ft_3_or_sqft_cft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_ft_3_or_sqft_cft units (alias for square_foot_per_cubic_foot)."""
        return self.square_foot_per_cubic_foot

    @property
    def ft_2_ft_3(self) -> 'FieldQnty':
        """Convert to ft_2_ft_3 units (alias for square_foot_per_cubic_foot)."""
        return self.square_foot_per_cubic_foot

    @property
    def sqft_cft(self) -> 'FieldQnty':
        """Convert to sqft_cft units (alias for square_foot_per_cubic_foot)."""
        return self.square_foot_per_cubic_foot

    @property
    def square_inch_per_cubic_inch(self) -> 'FieldQnty':
        """Convert to square inch per cubic inch units."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_inch_per_cubic_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_in_2_mathrm_in_3_or_sq_in_cu_in(self) -> 'FieldQnty':
        """Convert to mathrm_in_2_mathrm_in_3_or_sq_in_cu_in units (alias for square_inch_per_cubic_inch)."""
        return self.square_inch_per_cubic_inch

    @property
    def in_2_in_3(self) -> 'FieldQnty':
        """Convert to in_2_in_3 units (alias for square_inch_per_cubic_inch)."""
        return self.square_inch_per_cubic_inch

    @property
    def sq_in_cu_in(self) -> 'FieldQnty':
        """Convert to sq_in_cu_in units (alias for square_inch_per_cubic_inch)."""
        return self.square_inch_per_cubic_inch

    @property
    def square_meter_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to square meter per cubic meter units."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_meter_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_m_3_or_1_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_m_3_or_1_mathrm_m_3 units (alias for square_meter_per_cubic_meter)."""
        return self.square_meter_per_cubic_meter

    @property
    def m_2_m_3(self) -> 'FieldQnty':
        """Convert to m_2_m_3 units (alias for square_meter_per_cubic_meter)."""
        return self.square_meter_per_cubic_meter

    @property
    def unit_1_m_3(self) -> 'FieldQnty':
        """Convert to unit_1_m_3 units (alias for square_meter_per_cubic_meter)."""
        return self.square_meter_per_cubic_meter


class ToUnitAtomicWeightConverter(UnitConverter):
    """AtomicWeight-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def atomic_mass_unit_12c(self) -> 'FieldQnty':
        """Convert to atomic mass unit (12C) units."""
        unit_const: Final = field_units.AtomicWeightUnits.atomic_mass_unit_12c
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def amu(self) -> 'FieldQnty':
        """Convert to amu units (alias for atomic_mass_unit_12c)."""
        return self.atomic_mass_unit_12c

    @property
    def grams_per_mole(self) -> 'FieldQnty':
        """Convert to grams per mole units."""
        unit_const: Final = field_units.AtomicWeightUnits.grams_per_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def g_mol(self) -> 'FieldQnty':
        """Convert to g_mol units (alias for grams_per_mole)."""
        return self.grams_per_mole

    @property
    def kilograms_per_kilomole(self) -> 'FieldQnty':
        """Convert to kilograms per kilomole units."""
        unit_const: Final = field_units.AtomicWeightUnits.kilograms_per_kilomole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_kmol(self) -> 'FieldQnty':
        """Convert to kg_kmol units (alias for kilograms_per_kilomole)."""
        return self.kilograms_per_kilomole

    @property
    def pounds_per_pound_mole(self) -> 'FieldQnty':
        """Convert to pounds per pound mole units."""
        unit_const: Final = field_units.AtomicWeightUnits.pounds_per_pound_mole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_lb_mol_or_mathrm_lb_mole(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_lb_mol_or_mathrm_lb_mole units (alias for pounds_per_pound_mole)."""
        return self.pounds_per_pound_mole

    @property
    def lb_lb_mol(self) -> 'FieldQnty':
        """Convert to lb_lb_mol units (alias for pounds_per_pound_mole)."""
        return self.pounds_per_pound_mole

    @property
    def lb_mole(self) -> 'FieldQnty':
        """Convert to lb_mole units (alias for pounds_per_pound_mole)."""
        return self.pounds_per_pound_mole


class ToUnitConcentrationConverter(UnitConverter):
    """Concentration-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def grains_of_i_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to grains of "i" per cubic foot units."""
        unit_const: Final = field_units.ConcentrationUnits.grains_of_i_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gr_mathrm_ft_3_or_gr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_gr_mathrm_ft_3_or_gr_cft units (alias for grains_of_i_per_cubic_foot)."""
        return self.grains_of_i_per_cubic_foot

    @property
    def gr_ft_3(self) -> 'FieldQnty':
        """Convert to gr_ft_3 units (alias for grains_of_i_per_cubic_foot)."""
        return self.grains_of_i_per_cubic_foot

    @property
    def gr_cft(self) -> 'FieldQnty':
        """Convert to gr_cft units (alias for grains_of_i_per_cubic_foot)."""
        return self.grains_of_i_per_cubic_foot

    @property
    def grains_of_i_per_gallon_us(self) -> 'FieldQnty':
        """Convert to grains of "i" per gallon (US) units."""
        unit_const: Final = field_units.ConcentrationUnits.grains_of_i_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gr_gal(self) -> 'FieldQnty':
        """Convert to gr_gal units (alias for grains_of_i_per_gallon_us)."""
        return self.grains_of_i_per_gallon_us


class ToUnitDimensionlessConverter(UnitConverter):
    """Dimensionless-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dimensionless(self) -> 'FieldQnty':
        """Convert to dimensionless units."""
        unit_const: Final = field_units.DimensionlessUnits.dimensionless
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ratio(self) -> 'FieldQnty':
        """Convert to ratio units."""
        unit_const: Final = field_units.DimensionlessUnits.ratio
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def parts_per_million(self) -> 'FieldQnty':
        """Convert to parts per million units."""
        unit_const: Final = field_units.DimensionlessUnits.parts_per_million
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ppm(self) -> 'FieldQnty':
        """Convert to ppm units (alias for parts_per_million)."""
        return self.parts_per_million

    @property
    def parts_per_billion(self) -> 'FieldQnty':
        """Convert to parts per billion units."""
        unit_const: Final = field_units.DimensionlessUnits.parts_per_billion
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ppb(self) -> 'FieldQnty':
        """Convert to ppb units (alias for parts_per_billion)."""
        return self.parts_per_billion


class ToUnitDynamicFluidityConverter(UnitConverter):
    """DynamicFluidity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def meter_seconds_per_kilogram(self) -> 'FieldQnty':
        """Convert to meter-seconds per kilogram units."""
        unit_const: Final = field_units.DynamicFluidityUnits.meter_seconds_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m_s_kg(self) -> 'FieldQnty':
        """Convert to m_s_kg units (alias for meter_seconds_per_kilogram)."""
        return self.meter_seconds_per_kilogram

    @property
    def rhe(self) -> 'FieldQnty':
        """Convert to rhe units."""
        unit_const: Final = field_units.DynamicFluidityUnits.rhe
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def square_foot_per_pound_second(self) -> 'FieldQnty':
        """Convert to square foot per pound second units."""
        unit_const: Final = field_units.DynamicFluidityUnits.square_foot_per_pound_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_lb_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_lb_sec units (alias for square_foot_per_pound_second)."""
        return self.square_foot_per_pound_second

    @property
    def square_meters_per_newton_per_second(self) -> 'FieldQnty':
        """Convert to square meters per newton per second units."""
        unit_const: Final = field_units.DynamicFluidityUnits.square_meters_per_newton_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_N_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_N_mathrm_s units (alias for square_meters_per_newton_per_second)."""
        return self.square_meters_per_newton_per_second


class ToUnitElectricCapacitanceConverter(UnitConverter):
    """ElectricCapacitance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to "cm" units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.cm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def abfarad(self) -> 'FieldQnty':
        """Convert to abfarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.abfarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abfarad)."""
        return self.abfarad

    @property
    def farad(self) -> 'FieldQnty':
        """Convert to farad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.farad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for farad)."""
        return self.farad

    @property
    def farad_intl(self) -> 'FieldQnty':
        """Convert to farad (intl) units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.farad_intl
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def F_int(self) -> 'FieldQnty':
        """Convert to F_int units (alias for farad_intl)."""
        return self.farad_intl

    @property
    def jar(self) -> 'FieldQnty':
        """Convert to jar units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.jar
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def puff(self) -> 'FieldQnty':
        """Convert to puff units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.puff
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def statfarad(self) -> 'FieldQnty':
        """Convert to statfarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.statfarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statfarad)."""
        return self.statfarad

    @property
    def millifarad(self) -> 'FieldQnty':
        """Convert to millifarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.millifarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mF(self) -> 'FieldQnty':
        """Convert to mF units (alias for millifarad)."""
        return self.millifarad

    @property
    def microfarad(self) -> 'FieldQnty':
        """Convert to microfarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.microfarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanofarad(self) -> 'FieldQnty':
        """Convert to nanofarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.nanofarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nF(self) -> 'FieldQnty':
        """Convert to nF units (alias for nanofarad)."""
        return self.nanofarad

    @property
    def picofarad(self) -> 'FieldQnty':
        """Convert to picofarad units."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.picofarad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pF(self) -> 'FieldQnty':
        """Convert to pF units (alias for picofarad)."""
        return self.picofarad


class ToUnitElectricChargeConverter(UnitConverter):
    """ElectricCharge-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abcoulomb(self) -> 'FieldQnty':
        """Convert to abcoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.abcoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abcoulomb)."""
        return self.abcoulomb

    @property
    def ampere_hour(self) -> 'FieldQnty':
        """Convert to ampere-hour units."""
        unit_const: Final = field_units.ElectricChargeUnits.ampere_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Ah(self) -> 'FieldQnty':
        """Convert to Ah units (alias for ampere_hour)."""
        return self.ampere_hour

    @property
    def coulomb(self) -> 'FieldQnty':
        """Convert to coulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.coulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def C(self) -> 'FieldQnty':
        """Convert to C units (alias for coulomb)."""
        return self.coulomb

    @property
    def faraday_c12(self) -> 'FieldQnty':
        """Convert to faraday (C12) units."""
        unit_const: Final = field_units.ElectricChargeUnits.faraday_c12
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for faraday_c12)."""
        return self.faraday_c12

    @property
    def franklin(self) -> 'FieldQnty':
        """Convert to franklin units."""
        unit_const: Final = field_units.ElectricChargeUnits.franklin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Fr(self) -> 'FieldQnty':
        """Convert to Fr units (alias for franklin)."""
        return self.franklin

    @property
    def statcoulomb(self) -> 'FieldQnty':
        """Convert to statcoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.statcoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statcoulomb)."""
        return self.statcoulomb

    @property
    def u_a_charge(self) -> 'FieldQnty':
        """Convert to u.a. charge units."""
        unit_const: Final = field_units.ElectricChargeUnits.u_a_charge
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_charge)."""
        return self.u_a_charge

    @property
    def kilocoulomb(self) -> 'FieldQnty':
        """Convert to kilocoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.kilocoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kC(self) -> 'FieldQnty':
        """Convert to kC units (alias for kilocoulomb)."""
        return self.kilocoulomb

    @property
    def millicoulomb(self) -> 'FieldQnty':
        """Convert to millicoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.millicoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mC(self) -> 'FieldQnty':
        """Convert to mC units (alias for millicoulomb)."""
        return self.millicoulomb

    @property
    def microcoulomb(self) -> 'FieldQnty':
        """Convert to microcoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.microcoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanocoulomb(self) -> 'FieldQnty':
        """Convert to nanocoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.nanocoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nC(self) -> 'FieldQnty':
        """Convert to nC units (alias for nanocoulomb)."""
        return self.nanocoulomb

    @property
    def picocoulomb(self) -> 'FieldQnty':
        """Convert to picocoulomb units."""
        unit_const: Final = field_units.ElectricChargeUnits.picocoulomb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pC(self) -> 'FieldQnty':
        """Convert to pC units (alias for picocoulomb)."""
        return self.picocoulomb


class ToUnitElectricCurrentIntensityConverter(UnitConverter):
    """ElectricCurrentIntensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abampere(self) -> 'FieldQnty':
        """Convert to abampere units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.abampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abampere)."""
        return self.abampere

    @property
    def ampere_intl_mean(self) -> 'FieldQnty':
        """Convert to ampere (intl mean) units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_intl_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A_int_mean(self) -> 'FieldQnty':
        """Convert to A_int_mean units (alias for ampere_intl_mean)."""
        return self.ampere_intl_mean

    @property
    def ampere_intl_us(self) -> 'FieldQnty':
        """Convert to ampere (intl US) units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_intl_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A_int_US(self) -> 'FieldQnty':
        """Convert to A_int_US units (alias for ampere_intl_us)."""
        return self.ampere_intl_us

    @property
    def ampere_or_amp(self) -> 'FieldQnty':
        """Convert to ampere or amp units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_or_amp
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A(self) -> 'FieldQnty':
        """Convert to A units (alias for ampere_or_amp)."""
        return self.ampere_or_amp

    @property
    def biot(self) -> 'FieldQnty':
        """Convert to biot units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.biot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def statampere(self) -> 'FieldQnty':
        """Convert to statampere units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.statampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statampere)."""
        return self.statampere

    @property
    def u_a_or_current(self) -> 'FieldQnty':
        """Convert to u.a. or current units."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.u_a_or_current
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_or_current)."""
        return self.u_a_or_current


class ToUnitElectricDipoleMomentConverter(UnitConverter):
    """ElectricDipoleMoment-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def ampere_meter_second(self) -> 'FieldQnty':
        """Convert to ampere meter second units."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.ampere_meter_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A_m_s(self) -> 'FieldQnty':
        """Convert to A_m_s units (alias for ampere_meter_second)."""
        return self.ampere_meter_second

    @property
    def coulomb_meter(self) -> 'FieldQnty':
        """Convert to coulomb meter units."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.coulomb_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def C_m(self) -> 'FieldQnty':
        """Convert to C_m units (alias for coulomb_meter)."""
        return self.coulomb_meter

    @property
    def debye(self) -> 'FieldQnty':
        """Convert to debye units."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.debye
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def D(self) -> 'FieldQnty':
        """Convert to D units (alias for debye)."""
        return self.debye

    @property
    def electron_meter(self) -> 'FieldQnty':
        """Convert to electron meter units."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.electron_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def e_m(self) -> 'FieldQnty':
        """Convert to e_m units (alias for electron_meter)."""
        return self.electron_meter


class ToUnitElectricFieldStrengthConverter(UnitConverter):
    """ElectricFieldStrength-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def volt_per_centimeter(self) -> 'FieldQnty':
        """Convert to volt per centimeter units."""
        unit_const: Final = field_units.ElectricFieldStrengthUnits.volt_per_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def V_cm(self) -> 'FieldQnty':
        """Convert to V_cm units (alias for volt_per_centimeter)."""
        return self.volt_per_centimeter

    @property
    def volt_per_meter(self) -> 'FieldQnty':
        """Convert to volt per meter units."""
        unit_const: Final = field_units.ElectricFieldStrengthUnits.volt_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def V_m(self) -> 'FieldQnty':
        """Convert to V_m units (alias for volt_per_meter)."""
        return self.volt_per_meter


class ToUnitElectricInductanceConverter(UnitConverter):
    """ElectricInductance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abhenry(self) -> 'FieldQnty':
        """Convert to abhenry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.abhenry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abhenry)."""
        return self.abhenry

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to cm units."""
        unit_const: Final = field_units.ElectricInductanceUnits.cm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def henry(self) -> 'FieldQnty':
        """Convert to henry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def H(self) -> 'FieldQnty':
        """Convert to H units (alias for henry)."""
        return self.henry

    @property
    def henry_intl_mean(self) -> 'FieldQnty':
        """Convert to henry (intl mean) units."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry_intl_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def H_int_mean(self) -> 'FieldQnty':
        """Convert to H_int_mean units (alias for henry_intl_mean)."""
        return self.henry_intl_mean

    @property
    def henry_intl_us(self) -> 'FieldQnty':
        """Convert to henry (intl US) units."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry_intl_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def H_int_US(self) -> 'FieldQnty':
        """Convert to H_int_US units (alias for henry_intl_us)."""
        return self.henry_intl_us

    @property
    def mic(self) -> 'FieldQnty':
        """Convert to mic units."""
        unit_const: Final = field_units.ElectricInductanceUnits.mic
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def stathenry(self) -> 'FieldQnty':
        """Convert to stathenry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.stathenry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for stathenry)."""
        return self.stathenry

    @property
    def millihenry(self) -> 'FieldQnty':
        """Convert to millihenry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.millihenry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mH(self) -> 'FieldQnty':
        """Convert to mH units (alias for millihenry)."""
        return self.millihenry

    @property
    def microhenry(self) -> 'FieldQnty':
        """Convert to microhenry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.microhenry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanohenry(self) -> 'FieldQnty':
        """Convert to nanohenry units."""
        unit_const: Final = field_units.ElectricInductanceUnits.nanohenry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nH(self) -> 'FieldQnty':
        """Convert to nH units (alias for nanohenry)."""
        return self.nanohenry


class ToUnitElectricPotentialConverter(UnitConverter):
    """ElectricPotential-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abvolt(self) -> 'FieldQnty':
        """Convert to abvolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.abvolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abvolt)."""
        return self.abvolt

    @property
    def statvolt(self) -> 'FieldQnty':
        """Convert to statvolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.statvolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statvolt)."""
        return self.statvolt

    @property
    def u_a_potential(self) -> 'FieldQnty':
        """Convert to u.a. potential units."""
        unit_const: Final = field_units.ElectricPotentialUnits.u_a_potential
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_potential)."""
        return self.u_a_potential

    @property
    def volt(self) -> 'FieldQnty':
        """Convert to volt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def V(self) -> 'FieldQnty':
        """Convert to V units (alias for volt)."""
        return self.volt

    @property
    def volt_intl_mean(self) -> 'FieldQnty':
        """Convert to volt (intl mean) units."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt_intl_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def V_int_mean(self) -> 'FieldQnty':
        """Convert to V_int_mean units (alias for volt_intl_mean)."""
        return self.volt_intl_mean

    @property
    def volt_us(self) -> 'FieldQnty':
        """Convert to volt (US) units."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def V_int_US(self) -> 'FieldQnty':
        """Convert to V_int_US units (alias for volt_us)."""
        return self.volt_us

    @property
    def kilovolt(self) -> 'FieldQnty':
        """Convert to kilovolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.kilovolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kV(self) -> 'FieldQnty':
        """Convert to kV units (alias for kilovolt)."""
        return self.kilovolt

    @property
    def millivolt(self) -> 'FieldQnty':
        """Convert to millivolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.millivolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mV(self) -> 'FieldQnty':
        """Convert to mV units (alias for millivolt)."""
        return self.millivolt

    @property
    def microvolt(self) -> 'FieldQnty':
        """Convert to microvolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.microvolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanovolt(self) -> 'FieldQnty':
        """Convert to nanovolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.nanovolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nV(self) -> 'FieldQnty':
        """Convert to nV units (alias for nanovolt)."""
        return self.nanovolt

    @property
    def picovolt(self) -> 'FieldQnty':
        """Convert to picovolt units."""
        unit_const: Final = field_units.ElectricPotentialUnits.picovolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pV(self) -> 'FieldQnty':
        """Convert to pV units (alias for picovolt)."""
        return self.picovolt


class ToUnitElectricResistanceConverter(UnitConverter):
    """ElectricResistance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abohm(self) -> 'FieldQnty':
        """Convert to abohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.abohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abohm)."""
        return self.abohm

    @property
    def jacobi(self) -> 'FieldQnty':
        """Convert to jacobi units."""
        unit_const: Final = field_units.ElectricResistanceUnits.jacobi
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for jacobi)."""
        return self.jacobi

    @property
    def lenz(self) -> 'FieldQnty':
        """Convert to lenz units."""
        unit_const: Final = field_units.ElectricResistanceUnits.lenz
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Metric(self) -> 'FieldQnty':
        """Convert to Metric units (alias for lenz)."""
        return self.lenz

    @property
    def ohm(self) -> 'FieldQnty':
        """Convert to ohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Omega(self) -> 'FieldQnty':
        """Convert to Omega units (alias for ohm)."""
        return self.ohm

    @property
    def ohm_intl_mean(self) -> 'FieldQnty':
        """Convert to ohm (intl mean) units."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_intl_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Omega_int_mean(self) -> 'FieldQnty':
        """Convert to Omega_int_mean units (alias for ohm_intl_mean)."""
        return self.ohm_intl_mean

    @property
    def ohm_intl_us(self) -> 'FieldQnty':
        """Convert to ohm (intl US) units."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_intl_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Omega_int_US(self) -> 'FieldQnty':
        """Convert to Omega_int_US units (alias for ohm_intl_us)."""
        return self.ohm_intl_us

    @property
    def ohm_legal(self) -> 'FieldQnty':
        """Convert to ohm (legal) units."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_legal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Omega_legal(self) -> 'FieldQnty':
        """Convert to Omega_legal units (alias for ohm_legal)."""
        return self.ohm_legal

    @property
    def preece(self) -> 'FieldQnty':
        """Convert to preece units."""
        unit_const: Final = field_units.ElectricResistanceUnits.preece
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def statohm(self) -> 'FieldQnty':
        """Convert to statohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.statohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def csu_cgs(self) -> 'FieldQnty':
        """Convert to csu_cgs units (alias for statohm)."""
        return self.statohm

    @property
    def wheatstone(self) -> 'FieldQnty':
        """Convert to wheatstone units."""
        unit_const: Final = field_units.ElectricResistanceUnits.wheatstone
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kiloohm(self) -> 'FieldQnty':
        """Convert to kiloohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.kiloohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def k_Omega(self) -> 'FieldQnty':
        """Convert to k_Omega units (alias for kiloohm)."""
        return self.kiloohm

    @property
    def megaohm(self) -> 'FieldQnty':
        """Convert to megaohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.megaohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def M_Omega(self) -> 'FieldQnty':
        """Convert to M_Omega units (alias for megaohm)."""
        return self.megaohm

    @property
    def milliohm(self) -> 'FieldQnty':
        """Convert to milliohm units."""
        unit_const: Final = field_units.ElectricResistanceUnits.milliohm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m_Omega(self) -> 'FieldQnty':
        """Convert to m_Omega units (alias for milliohm)."""
        return self.milliohm


class ToUnitElectricalConductanceConverter(UnitConverter):
    """ElectricalConductance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu cgs units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.emu_cgs
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def abmho(self) -> 'FieldQnty':
        """Convert to abmho units (alias for emu_cgs)."""
        return self.emu_cgs

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu cgs units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.esu_cgs
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def statmho(self) -> 'FieldQnty':
        """Convert to statmho units (alias for esu_cgs)."""
        return self.esu_cgs

    @property
    def mho(self) -> 'FieldQnty':
        """Convert to mho units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.mho
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def microsiemens(self) -> 'FieldQnty':
        """Convert to microsiemens units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.microsiemens
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_S(self) -> 'FieldQnty':
        """Convert to mu_mathrm_S units (alias for microsiemens)."""
        return self.microsiemens

    @property
    def siemens(self) -> 'FieldQnty':
        """Convert to siemens units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.siemens
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def S(self) -> 'FieldQnty':
        """Convert to S units (alias for siemens)."""
        return self.siemens

    @property
    def millisiemens(self) -> 'FieldQnty':
        """Convert to millisiemens units."""
        unit_const: Final = field_units.ElectricalConductanceUnits.millisiemens
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mS(self) -> 'FieldQnty':
        """Convert to mS units (alias for millisiemens)."""
        return self.millisiemens


class ToUnitElectricalPermittivityConverter(UnitConverter):
    """ElectricalPermittivity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def farad_per_meter(self) -> 'FieldQnty':
        """Convert to farad per meter units."""
        unit_const: Final = field_units.ElectricalPermittivityUnits.farad_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def F_m(self) -> 'FieldQnty':
        """Convert to F_m units (alias for farad_per_meter)."""
        return self.farad_per_meter


class ToUnitElectricalResistivityConverter(UnitConverter):
    """ElectricalResistivity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def circular_mil_ohm_per_foot(self) -> 'FieldQnty':
        """Convert to circular mil-ohm per foot units."""
        unit_const: Final = field_units.ElectricalResistivityUnits.circular_mil_ohm_per_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def circmil_Omega_mathrm_ft(self) -> 'FieldQnty':
        """Convert to circmil_Omega_mathrm_ft units (alias for circular_mil_ohm_per_foot)."""
        return self.circular_mil_ohm_per_foot

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu cgs units."""
        unit_const: Final = field_units.ElectricalResistivityUnits.emu_cgs
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def abohm_cm(self) -> 'FieldQnty':
        """Convert to abohm_cm units (alias for emu_cgs)."""
        return self.emu_cgs

    @property
    def microhm_inch(self) -> 'FieldQnty':
        """Convert to microhm-inch units."""
        unit_const: Final = field_units.ElectricalResistivityUnits.microhm_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_Omega_in(self) -> 'FieldQnty':
        """Convert to mu_Omega_in units (alias for microhm_inch)."""
        return self.microhm_inch

    @property
    def ohm_centimeter(self) -> 'FieldQnty':
        """Convert to ohm-centimeter units."""
        unit_const: Final = field_units.ElectricalResistivityUnits.ohm_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def boldsymbol_Omega_mathbf_c_m(self) -> 'FieldQnty':
        """Convert to boldsymbol_Omega_mathbf_c_m units (alias for ohm_centimeter)."""
        return self.ohm_centimeter

    @property
    def ohm_meter(self) -> 'FieldQnty':
        """Convert to ohm-meter units."""
        unit_const: Final = field_units.ElectricalResistivityUnits.ohm_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Omega_mathrm_m(self) -> 'FieldQnty':
        """Convert to Omega_mathrm_m units (alias for ohm_meter)."""
        return self.ohm_meter


class ToUnitEnergyFluxConverter(UnitConverter):
    """EnergyFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to Btu per square foot per hour units."""
        unit_const: Final = field_units.EnergyFluxUnits.btu_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_2_mathrm_hr units (alias for btu_per_square_foot_per_hour)."""
        return self.btu_per_square_foot_per_hour

    @property
    def calorie_per_square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to calorie per square centimeter per second units."""
        unit_const: Final = field_units.EnergyFluxUnits.calorie_per_square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_cm_2_mathrm_s_or_mathrm_cal_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_cm_2_mathrm_s_or_mathrm_cal_mathrm_cm_2_mathrm_s units (alias for calorie_per_square_centimeter_per_second)."""
        return self.calorie_per_square_centimeter_per_second

    @property
    def cal_cm_2_s(self) -> 'FieldQnty':
        """Convert to cal_cm_2_s units (alias for calorie_per_square_centimeter_per_second)."""
        return self.calorie_per_square_centimeter_per_second

    @property
    def celsius_heat_units_chu(self) -> 'FieldQnty':
        """Convert to Celsius heat units (Chu) per square foot per hour units."""
        unit_const: Final = field_units.EnergyFluxUnits.celsius_heat_units_chu
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Chu_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_Chu_mathrm_ft_2_mathrm_hr units (alias for celsius_heat_units_chu)."""
        return self.celsius_heat_units_chu

    @property
    def kilocalorie_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to kilocalorie per square foot per hour units."""
        unit_const: Final = field_units.EnergyFluxUnits.kilocalorie_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_left_mathrm_ft_2_mathrm_hr_right(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_left_mathrm_ft_2_mathrm_hr_right units (alias for kilocalorie_per_square_foot_per_hour)."""
        return self.kilocalorie_per_square_foot_per_hour

    @property
    def kilocalorie_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kilocalorie per square meter per hour units."""
        unit_const: Final = field_units.EnergyFluxUnits.kilocalorie_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_left_mathrm_m_2_mathrm_hr_right(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_left_mathrm_m_2_mathrm_hr_right units (alias for kilocalorie_per_square_meter_per_hour)."""
        return self.kilocalorie_per_square_meter_per_hour

    @property
    def watt_per_square_meter(self) -> 'FieldQnty':
        """Convert to watt per square meter units."""
        unit_const: Final = field_units.EnergyFluxUnits.watt_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_W_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_W_mathrm_m_2 units (alias for watt_per_square_meter)."""
        return self.watt_per_square_meter


class ToUnitEnergyHeatWorkConverter(UnitConverter):
    """EnergyHeatWork-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def barrel_oil_equivalent_or_equivalent_barrel(self) -> 'FieldQnty':
        """Convert to barrel oil equivalent or equivalent barrel units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.barrel_oil_equivalent_or_equivalent_barrel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def bboe_or_boe(self) -> 'FieldQnty':
        """Convert to bboe_or_boe units (alias for barrel_oil_equivalent_or_equivalent_barrel)."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def bboe(self) -> 'FieldQnty':
        """Convert to bboe units (alias for barrel_oil_equivalent_or_equivalent_barrel)."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def boe(self) -> 'FieldQnty':
        """Convert to boe units (alias for barrel_oil_equivalent_or_equivalent_barrel)."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def billion_electronvolt(self) -> 'FieldQnty':
        """Convert to billion electronvolt units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.billion_electronvolt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def BeV(self) -> 'FieldQnty':
        """Convert to BeV units (alias for billion_electronvolt)."""
        return self.billion_electronvolt

    @property
    def british_thermal_unit_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to British thermal unit ( $4^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_39_2_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_39_2_circ_mathrm_F units (alias for british_thermal_unit_4circ_mathrmc)."""
        return self.british_thermal_unit_4circ_mathrmc

    @property
    def british_thermal_unit_60circ_mathrmf(self) -> 'FieldQnty':
        """Convert to British thermal unit ( $60^{\\circ} \\mathrm{F}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_60circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_60_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_60_circ_mathrm_F units (alias for british_thermal_unit_60circ_mathrmf)."""
        return self.british_thermal_unit_60circ_mathrmf

    @property
    def british_thermal_unit_international_steam_tables(self) -> 'FieldQnty':
        """Convert to British thermal unit (international steam tables) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_international_steam_tables
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_IT(self) -> 'FieldQnty':
        """Convert to Btu_IT units (alias for british_thermal_unit_international_steam_tables)."""
        return self.british_thermal_unit_international_steam_tables

    @property
    def british_thermal_unit_isotc_12(self) -> 'FieldQnty':
        """Convert to British thermal unit (ISO/TC 12) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_isotc_12
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_ISO(self) -> 'FieldQnty':
        """Convert to Btu_ISO units (alias for british_thermal_unit_isotc_12)."""
        return self.british_thermal_unit_isotc_12

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_mean_or_Btu(self) -> 'FieldQnty':
        """Convert to Btu_mean_or_Btu units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def Btu_mean(self) -> 'FieldQnty':
        """Convert to Btu_mean units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def Btu(self) -> 'FieldQnty':
        """Convert to Btu units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_thermochemical(self) -> 'FieldQnty':
        """Convert to British thermal unit (thermochemical) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_thermochemical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_therm(self) -> 'FieldQnty':
        """Convert to Btu_therm units (alias for british_thermal_unit_thermochemical)."""
        return self.british_thermal_unit_thermochemical

    @property
    def calorie_20circ_mathrmc(self) -> 'FieldQnty':
        """Convert to calorie ( $20^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_20circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_20_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to cal_20_circ_mathrm_C units (alias for calorie_20circ_mathrmc)."""
        return self.calorie_20circ_mathrmc

    @property
    def calorie_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to calorie ( $4^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_4_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to cal_4_circ_mathrm_C units (alias for calorie_4circ_mathrmc)."""
        return self.calorie_4circ_mathrmc

    @property
    def calorie_international_steam_tables(self) -> 'FieldQnty':
        """Convert to calorie (international steam tables) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_international_steam_tables
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_IT(self) -> 'FieldQnty':
        """Convert to cal_IT units (alias for calorie_international_steam_tables)."""
        return self.calorie_international_steam_tables

    @property
    def calorie_mean(self) -> 'FieldQnty':
        """Convert to calorie (mean) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_mean(self) -> 'FieldQnty':
        """Convert to cal_mean units (alias for calorie_mean)."""
        return self.calorie_mean

    @property
    def calorie_nutritional(self) -> 'FieldQnty':
        """Convert to Calorie (nutritional) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_nutritional
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Cal_nutr(self) -> 'FieldQnty':
        """Convert to Cal_nutr units (alias for calorie_nutritional)."""
        return self.calorie_nutritional

    @property
    def calorie_thermochemical(self) -> 'FieldQnty':
        """Convert to calorie (thermochemical) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_thermochemical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_therm(self) -> 'FieldQnty':
        """Convert to cal_therm units (alias for calorie_thermochemical)."""
        return self.calorie_thermochemical

    @property
    def celsius_heat_unit(self) -> 'FieldQnty':
        """Convert to Celsius heat unit units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.celsius_heat_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu(self) -> 'FieldQnty':
        """Convert to Chu units (alias for celsius_heat_unit)."""
        return self.celsius_heat_unit

    @property
    def celsius_heat_unit_15_circ_mathrmc(self) -> 'FieldQnty':
        """Convert to Celsius heat unit ( $15{ }^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.celsius_heat_unit_15_circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_15_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to Chu_15_circ_mathrm_C units (alias for celsius_heat_unit_15_circ_mathrmc)."""
        return self.celsius_heat_unit_15_circ_mathrmc

    @property
    def electron_volt(self) -> 'FieldQnty':
        """Convert to electron volt units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.electron_volt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def eV(self) -> 'FieldQnty':
        """Convert to eV units (alias for electron_volt)."""
        return self.electron_volt

    @property
    def erg(self) -> 'FieldQnty':
        """Convert to erg units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.erg
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def foot_pound_force_duty(self) -> 'FieldQnty':
        """Convert to foot pound force (duty) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.foot_pound_force_duty
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to ft_mathrm_lb_mathrm_f units (alias for foot_pound_force_duty)."""
        return self.foot_pound_force_duty

    @property
    def foot_poundal(self) -> 'FieldQnty':
        """Convert to foot-poundal units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.foot_poundal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_pdl(self) -> 'FieldQnty':
        """Convert to ft_pdl units (alias for foot_poundal)."""
        return self.foot_poundal

    @property
    def frigorie(self) -> 'FieldQnty':
        """Convert to frigorie units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.frigorie
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fg(self) -> 'FieldQnty':
        """Convert to fg units (alias for frigorie)."""
        return self.frigorie

    @property
    def hartree_atomic_unit_of_energy(self) -> 'FieldQnty':
        """Convert to hartree (atomic unit of energy) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.hartree_atomic_unit_of_energy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_E_mathrm_H_a_u(self) -> 'FieldQnty':
        """Convert to mathrm_E_mathrm_H_a_u units (alias for hartree_atomic_unit_of_energy)."""
        return self.hartree_atomic_unit_of_energy

    @property
    def joule(self) -> 'FieldQnty':
        """Convert to joule units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.joule
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J(self) -> 'FieldQnty':
        """Convert to J units (alias for joule)."""
        return self.joule

    @property
    def joule_international(self) -> 'FieldQnty':
        """Convert to joule (international) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.joule_international
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_intl(self) -> 'FieldQnty':
        """Convert to J_intl units (alias for joule_international)."""
        return self.joule_international

    @property
    def kilocalorie_thermal(self) -> 'FieldQnty':
        """Convert to kilocalorie (thermal) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilocalorie_thermal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kcal_therm(self) -> 'FieldQnty':
        """Convert to kcal_therm units (alias for kilocalorie_thermal)."""
        return self.kilocalorie_thermal

    @property
    def kilogram_force_meter(self) -> 'FieldQnty':
        """Convert to kilogram force meter units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilogram_force_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_m(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_m units (alias for kilogram_force_meter)."""
        return self.kilogram_force_meter

    @property
    def kiloton_tnt(self) -> 'FieldQnty':
        """Convert to kiloton (TNT) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kiloton_tnt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kt_TNT(self) -> 'FieldQnty':
        """Convert to kt_TNT units (alias for kiloton_tnt)."""
        return self.kiloton_tnt

    @property
    def kilowatt_hour(self) -> 'FieldQnty':
        """Convert to kilowatt hour units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilowatt_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kWh(self) -> 'FieldQnty':
        """Convert to kWh units (alias for kilowatt_hour)."""
        return self.kilowatt_hour

    @property
    def liter_atmosphere(self) -> 'FieldQnty':
        """Convert to liter atmosphere units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.liter_atmosphere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def L_atm(self) -> 'FieldQnty':
        """Convert to L_atm units (alias for liter_atmosphere)."""
        return self.liter_atmosphere

    @property
    def megaton_tnt(self) -> 'FieldQnty':
        """Convert to megaton (TNT) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.megaton_tnt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Mt_TNT(self) -> 'FieldQnty':
        """Convert to Mt_TNT units (alias for megaton_tnt)."""
        return self.megaton_tnt

    @property
    def pound_centigrade_unit_15circ_mathrmc(self) -> 'FieldQnty':
        """Convert to pound centigrade unit ( $15^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.pound_centigrade_unit_15circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pcu_15_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to pcu_15_circ_mathrm_C units (alias for pound_centigrade_unit_15circ_mathrmc)."""
        return self.pound_centigrade_unit_15circ_mathrmc

    @property
    def prout(self) -> 'FieldQnty':
        """Convert to prout units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.prout
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def q_unit(self) -> 'FieldQnty':
        """Convert to Q unit units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.q_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Q(self) -> 'FieldQnty':
        """Convert to Q units (alias for q_unit)."""
        return self.q_unit

    @property
    def quad_quadrillion_btu(self) -> 'FieldQnty':
        """Convert to quad (quadrillion Btu) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.quad_quadrillion_btu
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def quad(self) -> 'FieldQnty':
        """Convert to quad units (alias for quad_quadrillion_btu)."""
        return self.quad_quadrillion_btu

    @property
    def rydberg(self) -> 'FieldQnty':
        """Convert to rydberg units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.rydberg
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Ry(self) -> 'FieldQnty':
        """Convert to Ry units (alias for rydberg)."""
        return self.rydberg

    @property
    def therm_eeg(self) -> 'FieldQnty':
        """Convert to therm (EEG) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_eeg
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def therm_EEG(self) -> 'FieldQnty':
        """Convert to therm_EEG units (alias for therm_eeg)."""
        return self.therm_eeg

    @property
    def therm_refineries(self) -> 'FieldQnty':
        """Convert to therm (refineries) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_refineries
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def therm_refy_or_therm(self) -> 'FieldQnty':
        """Convert to therm_refy_or_therm units (alias for therm_refineries)."""
        return self.therm_refineries

    @property
    def therm_refy(self) -> 'FieldQnty':
        """Convert to therm_refy units (alias for therm_refineries)."""
        return self.therm_refineries

    @property
    def therm(self) -> 'FieldQnty':
        """Convert to therm units (alias for therm_refineries)."""
        return self.therm_refineries

    @property
    def therm_us(self) -> 'FieldQnty':
        """Convert to therm (US) units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def therm_US_or_therm(self) -> 'FieldQnty':
        """Convert to therm_US_or_therm units (alias for therm_us)."""
        return self.therm_us

    @property
    def ton_coal_equivalent(self) -> 'FieldQnty':
        """Convert to ton coal equivalent units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.ton_coal_equivalent
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tce_tec(self) -> 'FieldQnty':
        """Convert to tce_tec units (alias for ton_coal_equivalent)."""
        return self.ton_coal_equivalent

    @property
    def ton_oil_equivalent(self) -> 'FieldQnty':
        """Convert to ton oil equivalent units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.ton_oil_equivalent
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def toe_tep(self) -> 'FieldQnty':
        """Convert to toe_tep units (alias for ton_oil_equivalent)."""
        return self.ton_oil_equivalent

    @property
    def kilojoule(self) -> 'FieldQnty':
        """Convert to kilojoule units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilojoule
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kJ(self) -> 'FieldQnty':
        """Convert to kJ units (alias for kilojoule)."""
        return self.kilojoule

    @property
    def megajoule(self) -> 'FieldQnty':
        """Convert to megajoule units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.megajoule
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MJ(self) -> 'FieldQnty':
        """Convert to MJ units (alias for megajoule)."""
        return self.megajoule

    @property
    def gigajoule(self) -> 'FieldQnty':
        """Convert to gigajoule units."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.gigajoule
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def GJ(self) -> 'FieldQnty':
        """Convert to GJ units (alias for gigajoule)."""
        return self.gigajoule


class ToUnitEnergyPerUnitAreaConverter(UnitConverter):
    """EnergyPerUnitArea-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_square_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per square foot units."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.british_thermal_unit_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_mathrm_ft_2_or_Btu_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_2_or_Btu_sq_ft units (alias for british_thermal_unit_per_square_foot)."""
        return self.british_thermal_unit_per_square_foot

    @property
    def Btu_ft_2(self) -> 'FieldQnty':
        """Convert to Btu_ft_2 units (alias for british_thermal_unit_per_square_foot)."""
        return self.british_thermal_unit_per_square_foot

    @property
    def Btu_sq_ft(self) -> 'FieldQnty':
        """Convert to Btu_sq_ft units (alias for british_thermal_unit_per_square_foot)."""
        return self.british_thermal_unit_per_square_foot

    @property
    def joule_per_square_meter(self) -> 'FieldQnty':
        """Convert to joule per square meter units."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.joule_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_J_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_J_mathrm_m_2 units (alias for joule_per_square_meter)."""
        return self.joule_per_square_meter

    @property
    def langley(self) -> 'FieldQnty':
        """Convert to Langley units."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.langley
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Ly(self) -> 'FieldQnty':
        """Convert to Ly units (alias for langley)."""
        return self.langley


class ToUnitForceConverter(UnitConverter):
    """Force-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def crinal(self) -> 'FieldQnty':
        """Convert to crinal units."""
        unit_const: Final = field_units.ForceUnits.crinal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyne(self) -> 'FieldQnty':
        """Convert to dyne units."""
        unit_const: Final = field_units.ForceUnits.dyne
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn(self) -> 'FieldQnty':
        """Convert to dyn units (alias for dyne)."""
        return self.dyne

    @property
    def funal(self) -> 'FieldQnty':
        """Convert to funal units."""
        unit_const: Final = field_units.ForceUnits.funal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kilogram_force(self) -> 'FieldQnty':
        """Convert to kilogram force units."""
        unit_const: Final = field_units.ForceUnits.kilogram_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f units (alias for kilogram_force)."""
        return self.kilogram_force

    @property
    def kip_force(self) -> 'FieldQnty':
        """Convert to kip force units."""
        unit_const: Final = field_units.ForceUnits.kip_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def operatorname_kip_mathrm_f(self) -> 'FieldQnty':
        """Convert to operatorname_kip_mathrm_f units (alias for kip_force)."""
        return self.kip_force

    @property
    def newton(self) -> 'FieldQnty':
        """Convert to newton units."""
        unit_const: Final = field_units.ForceUnits.newton
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N(self) -> 'FieldQnty':
        """Convert to N units (alias for newton)."""
        return self.newton

    @property
    def ounce_force(self) -> 'FieldQnty':
        """Convert to ounce force units."""
        unit_const: Final = field_units.ForceUnits.ounce_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_oz_mathrm_f_or_oz(self) -> 'FieldQnty':
        """Convert to mathrm_oz_mathrm_f_or_oz units (alias for ounce_force)."""
        return self.ounce_force

    @property
    def oz_f(self) -> 'FieldQnty':
        """Convert to oz_f units (alias for ounce_force)."""
        return self.ounce_force

    @property
    def oz(self) -> 'FieldQnty':
        """Convert to oz units (alias for ounce_force)."""
        return self.ounce_force

    @property
    def pond(self) -> 'FieldQnty':
        """Convert to pond units."""
        unit_const: Final = field_units.ForceUnits.pond
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def p(self) -> 'FieldQnty':
        """Convert to p units (alias for pond)."""
        return self.pond

    @property
    def pound_force(self) -> 'FieldQnty':
        """Convert to pound force units."""
        unit_const: Final = field_units.ForceUnits.pound_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_or_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_or_lb units (alias for pound_force)."""
        return self.pound_force

    @property
    def lb_f(self) -> 'FieldQnty':
        """Convert to lb_f units (alias for pound_force)."""
        return self.pound_force

    @property
    def lb(self) -> 'FieldQnty':
        """Convert to lb units (alias for pound_force)."""
        return self.pound_force

    @property
    def poundal(self) -> 'FieldQnty':
        """Convert to poundal units."""
        unit_const: Final = field_units.ForceUnits.poundal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pdl(self) -> 'FieldQnty':
        """Convert to pdl units (alias for poundal)."""
        return self.poundal

    @property
    def slug_force(self) -> 'FieldQnty':
        """Convert to slug force units."""
        unit_const: Final = field_units.ForceUnits.slug_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def operatorname_slug_f(self) -> 'FieldQnty':
        """Convert to operatorname_slug_f units (alias for slug_force)."""
        return self.slug_force

    @property
    def sth_ne(self) -> 'FieldQnty':
        """Convert to sthène units."""
        unit_const: Final = field_units.ForceUnits.sth_ne
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sn(self) -> 'FieldQnty':
        """Convert to sn units (alias for sth_ne)."""
        return self.sth_ne

    @property
    def ton_force_long(self) -> 'FieldQnty':
        """Convert to ton (force, long) units."""
        unit_const: Final = field_units.ForceUnits.ton_force_long
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def LT(self) -> 'FieldQnty':
        """Convert to LT units (alias for ton_force_long)."""
        return self.ton_force_long

    @property
    def ton_force_metric(self) -> 'FieldQnty':
        """Convert to ton (force, metric) units."""
        unit_const: Final = field_units.ForceUnits.ton_force_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MT(self) -> 'FieldQnty':
        """Convert to MT units (alias for ton_force_metric)."""
        return self.ton_force_metric

    @property
    def ton_force_short(self) -> 'FieldQnty':
        """Convert to ton (force, short) units."""
        unit_const: Final = field_units.ForceUnits.ton_force_short
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def T(self) -> 'FieldQnty':
        """Convert to T units (alias for ton_force_short)."""
        return self.ton_force_short

    @property
    def kilonewton(self) -> 'FieldQnty':
        """Convert to kilonewton units."""
        unit_const: Final = field_units.ForceUnits.kilonewton
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kN(self) -> 'FieldQnty':
        """Convert to kN units (alias for kilonewton)."""
        return self.kilonewton

    @property
    def millinewton(self) -> 'FieldQnty':
        """Convert to millinewton units."""
        unit_const: Final = field_units.ForceUnits.millinewton
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mN(self) -> 'FieldQnty':
        """Convert to mN units (alias for millinewton)."""
        return self.millinewton


class ToUnitForceBodyConverter(UnitConverter):
    """ForceBody-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dyne_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per cubic centimeter units."""
        unit_const: Final = field_units.ForceBodyUnits.dyne_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_cc_or_dyn_mathrm_cm_3(self) -> 'FieldQnty':
        """Convert to dyn_cc_or_dyn_mathrm_cm_3 units (alias for dyne_per_cubic_centimeter)."""
        return self.dyne_per_cubic_centimeter

    @property
    def dyn_cc(self) -> 'FieldQnty':
        """Convert to dyn_cc units (alias for dyne_per_cubic_centimeter)."""
        return self.dyne_per_cubic_centimeter

    @property
    def dyn_cm_3(self) -> 'FieldQnty':
        """Convert to dyn_cm_3 units (alias for dyne_per_cubic_centimeter)."""
        return self.dyne_per_cubic_centimeter

    @property
    def kilogram_force_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per cubic centimeter units."""
        unit_const: Final = field_units.ForceBodyUnits.kilogram_force_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_cm_3 units (alias for kilogram_force_per_cubic_centimeter)."""
        return self.kilogram_force_per_cubic_centimeter

    @property
    def kilogram_force_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per cubic meter units."""
        unit_const: Final = field_units.ForceBodyUnits.kilogram_force_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_3 units (alias for kilogram_force_per_cubic_meter)."""
        return self.kilogram_force_per_cubic_meter

    @property
    def newton_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to newton per cubic meter units."""
        unit_const: Final = field_units.ForceBodyUnits.newton_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_N_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_3 units (alias for newton_per_cubic_meter)."""
        return self.newton_per_cubic_meter

    @property
    def pound_force_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound force per cubic foot units."""
        unit_const: Final = field_units.ForceBodyUnits.pound_force_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_cft units (alias for pound_force_per_cubic_foot)."""
        return self.pound_force_per_cubic_foot

    @property
    def pound_force_per_cubic_inch(self) -> 'FieldQnty':
        """Convert to pound force per cubic inch units."""
        unit_const: Final = field_units.ForceBodyUnits.pound_force_per_cubic_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_cu_mathrm_in(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_cu_mathrm_in units (alias for pound_force_per_cubic_inch)."""
        return self.pound_force_per_cubic_inch

    @property
    def ton_force_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to ton force per cubic foot units."""
        unit_const: Final = field_units.ForceBodyUnits.ton_force_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ton_mathrm_f_mathrm_cft(self) -> 'FieldQnty':
        """Convert to ton_mathrm_f_mathrm_cft units (alias for ton_force_per_cubic_foot)."""
        return self.ton_force_per_cubic_foot


class ToUnitForcePerUnitMassConverter(UnitConverter):
    """ForcePerUnitMass-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dyne_per_gram(self) -> 'FieldQnty':
        """Convert to dyne per gram units."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.dyne_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_g(self) -> 'FieldQnty':
        """Convert to dyn_g units (alias for dyne_per_gram)."""
        return self.dyne_per_gram

    @property
    def kilogram_force_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram force per kilogram units."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.kilogram_force_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_kg units (alias for kilogram_force_per_kilogram)."""
        return self.kilogram_force_per_kilogram

    @property
    def newton_per_kilogram(self) -> 'FieldQnty':
        """Convert to newton per kilogram units."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.newton_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N_kg(self) -> 'FieldQnty':
        """Convert to N_kg units (alias for newton_per_kilogram)."""
        return self.newton_per_kilogram

    @property
    def pound_force_per_pound_mass(self) -> 'FieldQnty':
        """Convert to pound force per pound mass units."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.pound_force_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_lb_or_mathrm_lb_mathrm_f_mathrm_lb_mathrm_m(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_lb_or_mathrm_lb_mathrm_f_mathrm_lb_mathrm_m units (alias for pound_force_per_pound_mass)."""
        return self.pound_force_per_pound_mass

    @property
    def lb_f_lb(self) -> 'FieldQnty':
        """Convert to lb_f_lb units (alias for pound_force_per_pound_mass)."""
        return self.pound_force_per_pound_mass

    @property
    def lb_f_lb_m(self) -> 'FieldQnty':
        """Convert to lb_f_lb_m units (alias for pound_force_per_pound_mass)."""
        return self.pound_force_per_pound_mass

    @property
    def pound_force_per_slug(self) -> 'FieldQnty':
        """Convert to pound force per slug units."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.pound_force_per_slug
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_slug(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_slug units (alias for pound_force_per_slug)."""
        return self.pound_force_per_slug


class ToUnitFrequencyVoltageRatioConverter(UnitConverter):
    """FrequencyVoltageRatio-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cycles_per_second_per_volt(self) -> 'FieldQnty':
        """Convert to cycles per second per volt units."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.cycles_per_second_per_volt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cycle_sec_V(self) -> 'FieldQnty':
        """Convert to cycle_sec_V units (alias for cycles_per_second_per_volt)."""
        return self.cycles_per_second_per_volt

    @property
    def hertz_per_volt(self) -> 'FieldQnty':
        """Convert to hertz per volt units."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.hertz_per_volt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Hz_V(self) -> 'FieldQnty':
        """Convert to Hz_V units (alias for hertz_per_volt)."""
        return self.hertz_per_volt

    @property
    def terahertz_per_volt(self) -> 'FieldQnty':
        """Convert to terahertz per volt units."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.terahertz_per_volt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def THz_V(self) -> 'FieldQnty':
        """Convert to THz_V units (alias for terahertz_per_volt)."""
        return self.terahertz_per_volt


class ToUnitFuelConsumptionConverter(UnitConverter):
    """FuelConsumption-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def unit_100_km_per_liter(self) -> 'FieldQnty':
        """Convert to 100 km per liter units."""
        unit_const: Final = field_units.FuelConsumptionUnits.unit_100_km_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gallons_uk(self) -> 'FieldQnty':
        """Convert to gallons (UK) per 100 miles units."""
        unit_const: Final = field_units.FuelConsumptionUnits.gallons_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_UK_100_mi(self) -> 'FieldQnty':
        """Convert to gal_UK_100_mi units (alias for gallons_uk)."""
        return self.gallons_uk

    @property
    def gallons_us(self) -> 'FieldQnty':
        """Convert to gallons (US) per 100 miles units."""
        unit_const: Final = field_units.FuelConsumptionUnits.gallons_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_US_100_mi(self) -> 'FieldQnty':
        """Convert to gal_US_100_mi units (alias for gallons_us)."""
        return self.gallons_us

    @property
    def kilometers_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to kilometers per gallon (UK) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km_gal_UK(self) -> 'FieldQnty':
        """Convert to km_gal_UK units (alias for kilometers_per_gallon_uk)."""
        return self.kilometers_per_gallon_uk

    @property
    def kilometers_per_gallon_us(self) -> 'FieldQnty':
        """Convert to kilometers per gallon (US) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km_gal_US(self) -> 'FieldQnty':
        """Convert to km_gal_US units (alias for kilometers_per_gallon_us)."""
        return self.kilometers_per_gallon_us

    @property
    def kilometers_per_liter(self) -> 'FieldQnty':
        """Convert to kilometers per liter units."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km_l(self) -> 'FieldQnty':
        """Convert to km_l units (alias for kilometers_per_liter)."""
        return self.kilometers_per_liter

    @property
    def liters_per_100_km(self) -> 'FieldQnty':
        """Convert to liters per 100 km units."""
        unit_const: Final = field_units.FuelConsumptionUnits.liters_per_100_km
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liters_per_kilometer(self) -> 'FieldQnty':
        """Convert to liters per kilometer units."""
        unit_const: Final = field_units.FuelConsumptionUnits.liters_per_kilometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_km(self) -> 'FieldQnty':
        """Convert to unit_1_km units (alias for liters_per_kilometer)."""
        return self.liters_per_kilometer

    @property
    def meters_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to meters per gallon (UK) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.meters_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m_gal_UK(self) -> 'FieldQnty':
        """Convert to m_gal_UK units (alias for meters_per_gallon_uk)."""
        return self.meters_per_gallon_uk

    @property
    def meters_per_gallon_us(self) -> 'FieldQnty':
        """Convert to meters per gallon (US) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.meters_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_gal_US(self) -> 'FieldQnty':
        """Convert to unit_1_gal_US units (alias for meters_per_gallon_us)."""
        return self.meters_per_gallon_us

    @property
    def miles_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to miles per gallon (UK) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi_gal_UK_or_mpg_UK(self) -> 'FieldQnty':
        """Convert to mi_gal_UK_or_mpg_UK units (alias for miles_per_gallon_uk)."""
        return self.miles_per_gallon_uk

    @property
    def mi_gal_UK(self) -> 'FieldQnty':
        """Convert to mi_gal_UK units (alias for miles_per_gallon_uk)."""
        return self.miles_per_gallon_uk

    @property
    def mpg_UK(self) -> 'FieldQnty':
        """Convert to mpg_UK units (alias for miles_per_gallon_uk)."""
        return self.miles_per_gallon_uk

    @property
    def miles_per_gallon_us(self) -> 'FieldQnty':
        """Convert to miles per gallon (US) units."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi_gal_US_or_mpg_US(self) -> 'FieldQnty':
        """Convert to mi_gal_US_or_mpg_US units (alias for miles_per_gallon_us)."""
        return self.miles_per_gallon_us

    @property
    def mi_gal_US(self) -> 'FieldQnty':
        """Convert to mi_gal_US units (alias for miles_per_gallon_us)."""
        return self.miles_per_gallon_us

    @property
    def mpg_US(self) -> 'FieldQnty':
        """Convert to mpg_US units (alias for miles_per_gallon_us)."""
        return self.miles_per_gallon_us

    @property
    def miles_per_liter(self) -> 'FieldQnty':
        """Convert to miles per liter units."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi_l(self) -> 'FieldQnty':
        """Convert to mi_l units (alias for miles_per_liter)."""
        return self.miles_per_liter


class ToUnitHeatOfCombustionConverter(UnitConverter):
    """HeatOfCombustion-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units."""
        unit_const: Final = field_units.HeatOfCombustionUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound)."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units."""
        unit_const: Final = field_units.HeatOfCombustionUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram)."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units."""
        unit_const: Final = field_units.HeatOfCombustionUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound)."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units."""
        unit_const: Final = field_units.HeatOfCombustionUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram)."""
        return self.joule_per_kilogram


class ToUnitHeatOfFusionConverter(UnitConverter):
    """HeatOfFusion-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per pound units."""
        unit_const: Final = field_units.HeatOfFusionUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_mean_lb(self) -> 'FieldQnty':
        """Convert to Btu_mean_lb units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units."""
        unit_const: Final = field_units.HeatOfFusionUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound)."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units."""
        unit_const: Final = field_units.HeatOfFusionUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram)."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units."""
        unit_const: Final = field_units.HeatOfFusionUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound)."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units."""
        unit_const: Final = field_units.HeatOfFusionUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram)."""
        return self.joule_per_kilogram


class ToUnitHeatOfVaporizationConverter(UnitConverter):
    """HeatOfVaporization-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound)."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram)."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound)."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram)."""
        return self.joule_per_kilogram


class ToUnitHeatTransferCoefficientConverter(UnitConverter):
    """HeatTransferCoefficient-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine(self) -> 'FieldQnty':
        """Convert to Btu per square foot per hour per degree Fahrenheit (or Rankine) units."""
        unit_const: Final = field_units.HeatTransferCoefficientUnits.btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_left_mathrm_ft_2_mathrm_h_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_left_mathrm_ft_2_mathrm_h_circ_mathrm_F_right units (alias for btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine)."""
        return self.btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine

    @property
    def watt_per_square_meter_per_degree_celsius_or_kelvin(self) -> 'FieldQnty':
        """Convert to watt per square meter per degree Celsius (or kelvin) units."""
        unit_const: Final = field_units.HeatTransferCoefficientUnits.watt_per_square_meter_per_degree_celsius_or_kelvin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_W_left_mathrm_m_2_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_W_left_mathrm_m_2_circ_mathrm_C_right units (alias for watt_per_square_meter_per_degree_celsius_or_kelvin)."""
        return self.watt_per_square_meter_per_degree_celsius_or_kelvin


class ToUnitIlluminanceConverter(UnitConverter):
    """Illuminance-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def foot_candle(self) -> 'FieldQnty':
        """Convert to foot-candle units."""
        unit_const: Final = field_units.IlluminanceUnits.foot_candle
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_C_or_mathrm_ft_mathrm_Cd(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_C_or_mathrm_ft_mathrm_Cd units (alias for foot_candle)."""
        return self.foot_candle

    @property
    def ft_C(self) -> 'FieldQnty':
        """Convert to ft_C units (alias for foot_candle)."""
        return self.foot_candle

    @property
    def ft_Cd(self) -> 'FieldQnty':
        """Convert to ft_Cd units (alias for foot_candle)."""
        return self.foot_candle

    @property
    def lux(self) -> 'FieldQnty':
        """Convert to lux units."""
        unit_const: Final = field_units.IlluminanceUnits.lux
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lx(self) -> 'FieldQnty':
        """Convert to lx units (alias for lux)."""
        return self.lux

    @property
    def nox(self) -> 'FieldQnty':
        """Convert to nox units."""
        unit_const: Final = field_units.IlluminanceUnits.nox
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def phot(self) -> 'FieldQnty':
        """Convert to phot units."""
        unit_const: Final = field_units.IlluminanceUnits.phot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ph(self) -> 'FieldQnty':
        """Convert to ph units (alias for phot)."""
        return self.phot

    @property
    def skot(self) -> 'FieldQnty':
        """Convert to skot units."""
        unit_const: Final = field_units.IlluminanceUnits.skot
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitKineticEnergyOfTurbulenceConverter(UnitConverter):
    """KineticEnergyOfTurbulence-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def square_foot_per_second_squared(self) -> 'FieldQnty':
        """Convert to square foot per second squared units."""
        unit_const: Final = field_units.KineticEnergyOfTurbulenceUnits.square_foot_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_s_2_or_sqft_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s_2_or_sqft_sec_2 units (alias for square_foot_per_second_squared)."""
        return self.square_foot_per_second_squared

    @property
    def ft_2_s_2(self) -> 'FieldQnty':
        """Convert to ft_2_s_2 units (alias for square_foot_per_second_squared)."""
        return self.square_foot_per_second_squared

    @property
    def sqft_sec_2(self) -> 'FieldQnty':
        """Convert to sqft_sec_2 units (alias for square_foot_per_second_squared)."""
        return self.square_foot_per_second_squared

    @property
    def square_meters_per_second_squared(self) -> 'FieldQnty':
        """Convert to square meters per second squared units."""
        unit_const: Final = field_units.KineticEnergyOfTurbulenceUnits.square_meters_per_second_squared
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s_2 units (alias for square_meters_per_second_squared)."""
        return self.square_meters_per_second_squared


class ToUnitLengthConverter(UnitConverter):
    """Length-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def ngstr_m(self) -> 'FieldQnty':
        """Convert to ångström units."""
        unit_const: Final = field_units.LengthUnits.ngstr_m
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def AA(self) -> 'FieldQnty':
        """Convert to AA units (alias for ngstr_m)."""
        return self.ngstr_m

    @property
    def arpent_quebec(self) -> 'FieldQnty':
        """Convert to arpent (Quebec) units."""
        unit_const: Final = field_units.LengthUnits.arpent_quebec
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def arp(self) -> 'FieldQnty':
        """Convert to arp units (alias for arpent_quebec)."""
        return self.arpent_quebec

    @property
    def astronomic_unit(self) -> 'FieldQnty':
        """Convert to astronomic unit units."""
        unit_const: Final = field_units.LengthUnits.astronomic_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def AU(self) -> 'FieldQnty':
        """Convert to AU units (alias for astronomic_unit)."""
        return self.astronomic_unit

    @property
    def attometer(self) -> 'FieldQnty':
        """Convert to attometer units."""
        unit_const: Final = field_units.LengthUnits.attometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def am(self) -> 'FieldQnty':
        """Convert to am units (alias for attometer)."""
        return self.attometer

    @property
    def calibre_centinch(self) -> 'FieldQnty':
        """Convert to calibre (centinch) units."""
        unit_const: Final = field_units.LengthUnits.calibre_centinch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cin(self) -> 'FieldQnty':
        """Convert to cin units (alias for calibre_centinch)."""
        return self.calibre_centinch

    @property
    def centimeter(self) -> 'FieldQnty':
        """Convert to centimeter units."""
        unit_const: Final = field_units.LengthUnits.centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to cm units (alias for centimeter)."""
        return self.centimeter

    @property
    def chain_engrs_or_ramsden(self) -> 'FieldQnty':
        """Convert to chain (Engr's or Ramsden) units."""
        unit_const: Final = field_units.LengthUnits.chain_engrs_or_ramsden
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ch_eng_or_Rams(self) -> 'FieldQnty':
        """Convert to ch_eng_or_Rams units (alias for chain_engrs_or_ramsden)."""
        return self.chain_engrs_or_ramsden

    @property
    def ch_eng(self) -> 'FieldQnty':
        """Convert to ch_eng units (alias for chain_engrs_or_ramsden)."""
        return self.chain_engrs_or_ramsden

    @property
    def Rams(self) -> 'FieldQnty':
        """Convert to Rams units (alias for chain_engrs_or_ramsden)."""
        return self.chain_engrs_or_ramsden

    @property
    def chain_gunters(self) -> 'FieldQnty':
        """Convert to chain (Gunter's) units."""
        unit_const: Final = field_units.LengthUnits.chain_gunters
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ch_Gunt(self) -> 'FieldQnty':
        """Convert to ch_Gunt units (alias for chain_gunters)."""
        return self.chain_gunters

    @property
    def chain_surveyors(self) -> 'FieldQnty':
        """Convert to chain (surveyors) units."""
        unit_const: Final = field_units.LengthUnits.chain_surveyors
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ch_surv(self) -> 'FieldQnty':
        """Convert to ch_surv units (alias for chain_surveyors)."""
        return self.chain_surveyors

    @property
    def cubit_uk(self) -> 'FieldQnty':
        """Convert to cubit (UK) units."""
        unit_const: Final = field_units.LengthUnits.cubit_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cu_UK(self) -> 'FieldQnty':
        """Convert to cu_UK units (alias for cubit_uk)."""
        return self.cubit_uk

    @property
    def ell(self) -> 'FieldQnty':
        """Convert to ell units."""
        unit_const: Final = field_units.LengthUnits.ell
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fathom(self) -> 'FieldQnty':
        """Convert to fathom units."""
        unit_const: Final = field_units.LengthUnits.fathom
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fath(self) -> 'FieldQnty':
        """Convert to fath units (alias for fathom)."""
        return self.fathom

    @property
    def femtometre(self) -> 'FieldQnty':
        """Convert to femtometre units."""
        unit_const: Final = field_units.LengthUnits.femtometre
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fm(self) -> 'FieldQnty':
        """Convert to fm units (alias for femtometre)."""
        return self.femtometre

    @property
    def fermi(self) -> 'FieldQnty':
        """Convert to fermi units."""
        unit_const: Final = field_units.LengthUnits.fermi
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for fermi)."""
        return self.fermi

    @property
    def foot(self) -> 'FieldQnty':
        """Convert to foot units."""
        unit_const: Final = field_units.LengthUnits.foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft(self) -> 'FieldQnty':
        """Convert to ft units (alias for foot)."""
        return self.foot

    @property
    def furlong_uk_and_us(self) -> 'FieldQnty':
        """Convert to furlong (UK and US) units."""
        unit_const: Final = field_units.LengthUnits.furlong_uk_and_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fur(self) -> 'FieldQnty':
        """Convert to fur units (alias for furlong_uk_and_us)."""
        return self.furlong_uk_and_us

    @property
    def inch(self) -> 'FieldQnty':
        """Convert to inch units."""
        unit_const: Final = field_units.LengthUnits.inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_unit(self) -> 'FieldQnty':
        """Convert to in_unit units (alias for inch)."""
        return self.inch

    @property
    def kilometer(self) -> 'FieldQnty':
        """Convert to kilometer units."""
        unit_const: Final = field_units.LengthUnits.kilometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km(self) -> 'FieldQnty':
        """Convert to km units (alias for kilometer)."""
        return self.kilometer

    @property
    def league_us_statute(self) -> 'FieldQnty':
        """Convert to league (US, statute) units."""
        unit_const: Final = field_units.LengthUnits.league_us_statute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lg_US_stat(self) -> 'FieldQnty':
        """Convert to lg_US_stat units (alias for league_us_statute)."""
        return self.league_us_statute

    @property
    def lieue_metric(self) -> 'FieldQnty':
        """Convert to lieue (metric) units."""
        unit_const: Final = field_units.LengthUnits.lieue_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ligne_metric(self) -> 'FieldQnty':
        """Convert to ligne (metric) units."""
        unit_const: Final = field_units.LengthUnits.ligne_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def line_us(self) -> 'FieldQnty':
        """Convert to line (US) units."""
        unit_const: Final = field_units.LengthUnits.line_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def li_US(self) -> 'FieldQnty':
        """Convert to li_US units (alias for line_us)."""
        return self.line_us

    @property
    def link_surveyors(self) -> 'FieldQnty':
        """Convert to link (surveyors) units."""
        unit_const: Final = field_units.LengthUnits.link_surveyors
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def li_surv(self) -> 'FieldQnty':
        """Convert to li_surv units (alias for link_surveyors)."""
        return self.link_surveyors

    @property
    def meter(self) -> 'FieldQnty':
        """Convert to meter units."""
        unit_const: Final = field_units.LengthUnits.meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m(self) -> 'FieldQnty':
        """Convert to m units (alias for meter)."""
        return self.meter

    @property
    def micrometer(self) -> 'FieldQnty':
        """Convert to micrometer units."""
        unit_const: Final = field_units.LengthUnits.micrometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_m(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m units (alias for micrometer)."""
        return self.micrometer

    @property
    def micron(self) -> 'FieldQnty':
        """Convert to micron units."""
        unit_const: Final = field_units.LengthUnits.micron
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu(self) -> 'FieldQnty':
        """Convert to mu units (alias for micron)."""
        return self.micron

    @property
    def mil(self) -> 'FieldQnty':
        """Convert to mil units."""
        unit_const: Final = field_units.LengthUnits.mil
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mile_geographical(self) -> 'FieldQnty':
        """Convert to mile (geographical) units."""
        unit_const: Final = field_units.LengthUnits.mile_geographical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi(self) -> 'FieldQnty':
        """Convert to mi units (alias for mile_geographical)."""
        return self.mile_geographical

    @property
    def mile_us_nautical(self) -> 'FieldQnty':
        """Convert to mile (US, nautical) units."""
        unit_const: Final = field_units.LengthUnits.mile_us_nautical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi_US_naut(self) -> 'FieldQnty':
        """Convert to mi_US_naut units (alias for mile_us_nautical)."""
        return self.mile_us_nautical

    @property
    def mile_us_statute(self) -> 'FieldQnty':
        """Convert to mile (US, statute) units."""
        unit_const: Final = field_units.LengthUnits.mile_us_statute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mile_us_survey(self) -> 'FieldQnty':
        """Convert to mile (US, survey) units."""
        unit_const: Final = field_units.LengthUnits.mile_us_survey
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mi_US_surv(self) -> 'FieldQnty':
        """Convert to mi_US_surv units (alias for mile_us_survey)."""
        return self.mile_us_survey

    @property
    def millimeter(self) -> 'FieldQnty':
        """Convert to millimeter units."""
        unit_const: Final = field_units.LengthUnits.millimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mm(self) -> 'FieldQnty':
        """Convert to mm units (alias for millimeter)."""
        return self.millimeter

    @property
    def millimicron(self) -> 'FieldQnty':
        """Convert to millimicron units."""
        unit_const: Final = field_units.LengthUnits.millimicron
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mu(self) -> 'FieldQnty':
        """Convert to mathrm_m_mu units (alias for millimicron)."""
        return self.millimicron

    @property
    def nanometer_or_nanon(self) -> 'FieldQnty':
        """Convert to nanometer or nanon units."""
        unit_const: Final = field_units.LengthUnits.nanometer_or_nanon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nm(self) -> 'FieldQnty':
        """Convert to nm units (alias for nanometer_or_nanon)."""
        return self.nanometer_or_nanon

    @property
    def parsec(self) -> 'FieldQnty':
        """Convert to parsec units."""
        unit_const: Final = field_units.LengthUnits.parsec
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pc(self) -> 'FieldQnty':
        """Convert to pc units (alias for parsec)."""
        return self.parsec

    @property
    def perche(self) -> 'FieldQnty':
        """Convert to perche units."""
        unit_const: Final = field_units.LengthUnits.perche
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def rod(self) -> 'FieldQnty':
        """Convert to rod units (alias for perche)."""
        return self.perche

    @property
    def pica(self) -> 'FieldQnty':
        """Convert to pica units."""
        unit_const: Final = field_units.LengthUnits.pica
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def picometer(self) -> 'FieldQnty':
        """Convert to picometer units."""
        unit_const: Final = field_units.LengthUnits.picometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pm(self) -> 'FieldQnty':
        """Convert to pm units (alias for picometer)."""
        return self.picometer

    @property
    def point_didot(self) -> 'FieldQnty':
        """Convert to point (Didot) units."""
        unit_const: Final = field_units.LengthUnits.point_didot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pt_Didot(self) -> 'FieldQnty':
        """Convert to pt_Didot units (alias for point_didot)."""
        return self.point_didot

    @property
    def point_us(self) -> 'FieldQnty':
        """Convert to point (US) units."""
        unit_const: Final = field_units.LengthUnits.point_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pt_US(self) -> 'FieldQnty':
        """Convert to pt_US units (alias for point_us)."""
        return self.point_us

    @property
    def rod_or_pole(self) -> 'FieldQnty':
        """Convert to rod or pole units."""
        unit_const: Final = field_units.LengthUnits.rod_or_pole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def span(self) -> 'FieldQnty':
        """Convert to span units."""
        unit_const: Final = field_units.LengthUnits.span
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def thou_millinch(self) -> 'FieldQnty':
        """Convert to thou (millinch) units."""
        unit_const: Final = field_units.LengthUnits.thou_millinch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def thou(self) -> 'FieldQnty':
        """Convert to thou units (alias for thou_millinch)."""
        return self.thou_millinch

    @property
    def toise_metric(self) -> 'FieldQnty':
        """Convert to toise (metric) units."""
        unit_const: Final = field_units.LengthUnits.toise_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def yard(self) -> 'FieldQnty':
        """Convert to yard units."""
        unit_const: Final = field_units.LengthUnits.yard
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def yd(self) -> 'FieldQnty':
        """Convert to yd units (alias for yard)."""
        return self.yard

    @property
    def nanometer(self) -> 'FieldQnty':
        """Convert to nanometer units."""
        unit_const: Final = field_units.LengthUnits.nanometer
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitLinearMassDensityConverter(UnitConverter):
    """LinearMassDensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def denier(self) -> 'FieldQnty':
        """Convert to denier units."""
        unit_const: Final = field_units.LinearMassDensityUnits.denier
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kilogram_per_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram per centimeter units."""
        unit_const: Final = field_units.LinearMassDensityUnits.kilogram_per_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_cm(self) -> 'FieldQnty':
        """Convert to kg_cm units (alias for kilogram_per_centimeter)."""
        return self.kilogram_per_centimeter

    @property
    def kilogram_per_meter(self) -> 'FieldQnty':
        """Convert to kilogram per meter units."""
        unit_const: Final = field_units.LinearMassDensityUnits.kilogram_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_m(self) -> 'FieldQnty':
        """Convert to kg_m units (alias for kilogram_per_meter)."""
        return self.kilogram_per_meter

    @property
    def pound_per_foot(self) -> 'FieldQnty':
        """Convert to pound per foot units."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_ft(self) -> 'FieldQnty':
        """Convert to lb_ft units (alias for pound_per_foot)."""
        return self.pound_per_foot

    @property
    def pound_per_inch(self) -> 'FieldQnty':
        """Convert to pound per inch units."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_in(self) -> 'FieldQnty':
        """Convert to lb_in units (alias for pound_per_inch)."""
        return self.pound_per_inch

    @property
    def pound_per_yard(self) -> 'FieldQnty':
        """Convert to pound per yard units."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_yard
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_yd(self) -> 'FieldQnty':
        """Convert to lb_yd units (alias for pound_per_yard)."""
        return self.pound_per_yard

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton (metric) per kilometer units."""
        unit_const: Final = field_units.LinearMassDensityUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def t_km_or_MT_km(self) -> 'FieldQnty':
        """Convert to t_km_or_MT_km units (alias for ton_metric)."""
        return self.ton_metric

    @property
    def t_km(self) -> 'FieldQnty':
        """Convert to t_km units (alias for ton_metric)."""
        return self.ton_metric

    @property
    def MT_km(self) -> 'FieldQnty':
        """Convert to MT_km units (alias for ton_metric)."""
        return self.ton_metric


class ToUnitLinearMomentumConverter(UnitConverter):
    """LinearMomentum-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def foot_pounds_force_per_hour(self) -> 'FieldQnty':
        """Convert to foot pounds force per hour units."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_h_or_mathrm_ft_mathrm_lb_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_h_or_mathrm_ft_mathrm_lb_mathrm_hr units (alias for foot_pounds_force_per_hour)."""
        return self.foot_pounds_force_per_hour

    @property
    def ft_lb_f_h(self) -> 'FieldQnty':
        """Convert to ft_lb_f_h units (alias for foot_pounds_force_per_hour)."""
        return self.foot_pounds_force_per_hour

    @property
    def ft_lb_hr(self) -> 'FieldQnty':
        """Convert to ft_lb_hr units (alias for foot_pounds_force_per_hour)."""
        return self.foot_pounds_force_per_hour

    @property
    def foot_pounds_force_per_minute(self) -> 'FieldQnty':
        """Convert to foot pounds force per minute units."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min_or_mathrm_ft_mathrm_lb_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_min_or_mathrm_ft_mathrm_lb_min units (alias for foot_pounds_force_per_minute)."""
        return self.foot_pounds_force_per_minute

    @property
    def ft_lb_f_min(self) -> 'FieldQnty':
        """Convert to ft_lb_f_min units (alias for foot_pounds_force_per_minute)."""
        return self.foot_pounds_force_per_minute

    @property
    def ft_lb_min(self) -> 'FieldQnty':
        """Convert to ft_lb_min units (alias for foot_pounds_force_per_minute)."""
        return self.foot_pounds_force_per_minute

    @property
    def foot_pounds_force_per_second(self) -> 'FieldQnty':
        """Convert to foot pounds force per second units."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s_or_ft_lb_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_s_or_ft_lb_sec units (alias for foot_pounds_force_per_second)."""
        return self.foot_pounds_force_per_second

    @property
    def ft_lb_f_s(self) -> 'FieldQnty':
        """Convert to ft_lb_f_s units (alias for foot_pounds_force_per_second)."""
        return self.foot_pounds_force_per_second

    @property
    def ft_lb_sec(self) -> 'FieldQnty':
        """Convert to ft_lb_sec units (alias for foot_pounds_force_per_second)."""
        return self.foot_pounds_force_per_second

    @property
    def gram_centimeters_per_second(self) -> 'FieldQnty':
        """Convert to gram centimeters per second units."""
        unit_const: Final = field_units.LinearMomentumUnits.gram_centimeters_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s units (alias for gram_centimeters_per_second)."""
        return self.gram_centimeters_per_second

    @property
    def kilogram_meters_per_second(self) -> 'FieldQnty':
        """Convert to kilogram meters per second units."""
        unit_const: Final = field_units.LinearMomentumUnits.kilogram_meters_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_mathrm_s units (alias for kilogram_meters_per_second)."""
        return self.kilogram_meters_per_second


class ToUnitLuminanceSelfConverter(UnitConverter):
    """LuminanceSelf-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def apostilb(self) -> 'FieldQnty':
        """Convert to apostilb units."""
        unit_const: Final = field_units.LuminanceSelfUnits.apostilb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def asb(self) -> 'FieldQnty':
        """Convert to asb units (alias for apostilb)."""
        return self.apostilb

    @property
    def blondel(self) -> 'FieldQnty':
        """Convert to blondel units."""
        unit_const: Final = field_units.LuminanceSelfUnits.blondel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def B1(self) -> 'FieldQnty':
        """Convert to B1 units (alias for blondel)."""
        return self.blondel

    @property
    def candela_per_square_meter(self) -> 'FieldQnty':
        """Convert to candela per square meter units."""
        unit_const: Final = field_units.LuminanceSelfUnits.candela_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cd_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_cd_mathrm_m_2 units (alias for candela_per_square_meter)."""
        return self.candela_per_square_meter

    @property
    def foot_lambert(self) -> 'FieldQnty':
        """Convert to foot-lambert units."""
        unit_const: Final = field_units.LuminanceSelfUnits.foot_lambert
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_L(self) -> 'FieldQnty':
        """Convert to ft_L units (alias for foot_lambert)."""
        return self.foot_lambert

    @property
    def lambert(self) -> 'FieldQnty':
        """Convert to lambert units."""
        unit_const: Final = field_units.LuminanceSelfUnits.lambert
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def L(self) -> 'FieldQnty':
        """Convert to L units (alias for lambert)."""
        return self.lambert

    @property
    def luxon(self) -> 'FieldQnty':
        """Convert to luxon units."""
        unit_const: Final = field_units.LuminanceSelfUnits.luxon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nit(self) -> 'FieldQnty':
        """Convert to nit units."""
        unit_const: Final = field_units.LuminanceSelfUnits.nit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def stilb(self) -> 'FieldQnty':
        """Convert to stilb units."""
        unit_const: Final = field_units.LuminanceSelfUnits.stilb
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sb(self) -> 'FieldQnty':
        """Convert to sb units (alias for stilb)."""
        return self.stilb

    @property
    def troland(self) -> 'FieldQnty':
        """Convert to troland units."""
        unit_const: Final = field_units.LuminanceSelfUnits.troland
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitLuminousFluxConverter(UnitConverter):
    """LuminousFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def candela_steradian(self) -> 'FieldQnty':
        """Convert to candela steradian units."""
        unit_const: Final = field_units.LuminousFluxUnits.candela_steradian
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cd_sr(self) -> 'FieldQnty':
        """Convert to cd_sr units (alias for candela_steradian)."""
        return self.candela_steradian

    @property
    def lumen(self) -> 'FieldQnty':
        """Convert to lumen units."""
        unit_const: Final = field_units.LuminousFluxUnits.lumen
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitLuminousIntensityConverter(UnitConverter):
    """LuminousIntensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def candela(self) -> 'FieldQnty':
        """Convert to candela units."""
        unit_const: Final = field_units.LuminousIntensityUnits.candela
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cd(self) -> 'FieldQnty':
        """Convert to cd units (alias for candela)."""
        return self.candela

    @property
    def candle_international(self) -> 'FieldQnty':
        """Convert to candle (international) units."""
        unit_const: Final = field_units.LuminousIntensityUnits.candle_international
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Cd_int(self) -> 'FieldQnty':
        """Convert to Cd_int units (alias for candle_international)."""
        return self.candle_international

    @property
    def carcel(self) -> 'FieldQnty':
        """Convert to carcel units."""
        unit_const: Final = field_units.LuminousIntensityUnits.carcel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def hefner_unit(self) -> 'FieldQnty':
        """Convert to Hefner unit units."""
        unit_const: Final = field_units.LuminousIntensityUnits.hefner_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HK(self) -> 'FieldQnty':
        """Convert to HK units (alias for hefner_unit)."""
        return self.hefner_unit


class ToUnitMagneticFieldConverter(UnitConverter):
    """MagneticField-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def ampere_per_meter(self) -> 'FieldQnty':
        """Convert to ampere per meter units."""
        unit_const: Final = field_units.MagneticFieldUnits.ampere_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A_m(self) -> 'FieldQnty':
        """Convert to A_m units (alias for ampere_per_meter)."""
        return self.ampere_per_meter

    @property
    def lenz(self) -> 'FieldQnty':
        """Convert to lenz units."""
        unit_const: Final = field_units.MagneticFieldUnits.lenz
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oersted(self) -> 'FieldQnty':
        """Convert to oersted units."""
        unit_const: Final = field_units.MagneticFieldUnits.oersted
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Oe(self) -> 'FieldQnty':
        """Convert to Oe units (alias for oersted)."""
        return self.oersted

    @property
    def praoersted(self) -> 'FieldQnty':
        """Convert to praoersted units."""
        unit_const: Final = field_units.MagneticFieldUnits.praoersted
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for praoersted)."""
        return self.praoersted


class ToUnitMagneticFluxConverter(UnitConverter):
    """MagneticFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def kapp_line(self) -> 'FieldQnty':
        """Convert to kapp line units."""
        unit_const: Final = field_units.MagneticFluxUnits.kapp_line
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for kapp_line)."""
        return self.kapp_line

    @property
    def line(self) -> 'FieldQnty':
        """Convert to line units."""
        unit_const: Final = field_units.MagneticFluxUnits.line
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def maxwell(self) -> 'FieldQnty':
        """Convert to maxwell units."""
        unit_const: Final = field_units.MagneticFluxUnits.maxwell
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Mx(self) -> 'FieldQnty':
        """Convert to Mx units (alias for maxwell)."""
        return self.maxwell

    @property
    def unit_pole(self) -> 'FieldQnty':
        """Convert to unit pole units."""
        unit_const: Final = field_units.MagneticFluxUnits.unit_pole
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def weber(self) -> 'FieldQnty':
        """Convert to weber units."""
        unit_const: Final = field_units.MagneticFluxUnits.weber
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Wb(self) -> 'FieldQnty':
        """Convert to Wb units (alias for weber)."""
        return self.weber

    @property
    def milliweber(self) -> 'FieldQnty':
        """Convert to milliweber units."""
        unit_const: Final = field_units.MagneticFluxUnits.milliweber
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mWb(self) -> 'FieldQnty':
        """Convert to mWb units (alias for milliweber)."""
        return self.milliweber

    @property
    def microweber(self) -> 'FieldQnty':
        """Convert to microweber units."""
        unit_const: Final = field_units.MagneticFluxUnits.microweber
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitMagneticInductionFieldStrengthConverter(UnitConverter):
    """MagneticInductionFieldStrength-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gamma(self) -> 'FieldQnty':
        """Convert to gamma units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.gamma
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gauss(self) -> 'FieldQnty':
        """Convert to gauss units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.gauss
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def G(self) -> 'FieldQnty':
        """Convert to G units (alias for gauss)."""
        return self.gauss

    @property
    def line_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to line per square centimeter units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.line_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def line_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to line_mathrm_cm_2 units (alias for line_per_square_centimeter)."""
        return self.line_per_square_centimeter

    @property
    def maxwell_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to maxwell per square centimeter units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.maxwell_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Mx_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_Mx_mathrm_cm_2 units (alias for maxwell_per_square_centimeter)."""
        return self.maxwell_per_square_centimeter

    @property
    def tesla(self) -> 'FieldQnty':
        """Convert to tesla units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.tesla
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def T(self) -> 'FieldQnty':
        """Convert to T units (alias for tesla)."""
        return self.tesla

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u.a. units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.u_a
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def weber_per_square_meter(self) -> 'FieldQnty':
        """Convert to weber per square meter units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.weber_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Wb_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_Wb_mathrm_m_2 units (alias for weber_per_square_meter)."""
        return self.weber_per_square_meter

    @property
    def millitesla(self) -> 'FieldQnty':
        """Convert to millitesla units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.millitesla
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mT(self) -> 'FieldQnty':
        """Convert to mT units (alias for millitesla)."""
        return self.millitesla

    @property
    def microtesla(self) -> 'FieldQnty':
        """Convert to microtesla units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.microtesla
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanotesla(self) -> 'FieldQnty':
        """Convert to nanotesla units."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.nanotesla
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nT(self) -> 'FieldQnty':
        """Convert to nT units (alias for nanotesla)."""
        return self.nanotesla


class ToUnitMagneticMomentConverter(UnitConverter):
    """MagneticMoment-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def bohr_magneton(self) -> 'FieldQnty':
        """Convert to Bohr magneton units."""
        unit_const: Final = field_units.MagneticMomentUnits.bohr_magneton
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Bohr_magneton(self) -> 'FieldQnty':
        """Convert to Bohr_magneton units (alias for bohr_magneton)."""
        return self.bohr_magneton

    @property
    def joule_per_tesla(self) -> 'FieldQnty':
        """Convert to joule per tesla units."""
        unit_const: Final = field_units.MagneticMomentUnits.joule_per_tesla
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_T(self) -> 'FieldQnty':
        """Convert to J_T units (alias for joule_per_tesla)."""
        return self.joule_per_tesla

    @property
    def nuclear_magneton(self) -> 'FieldQnty':
        """Convert to nuclear magneton units."""
        unit_const: Final = field_units.MagneticMomentUnits.nuclear_magneton
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nucl_Magneton(self) -> 'FieldQnty':
        """Convert to nucl_Magneton units (alias for nuclear_magneton)."""
        return self.nuclear_magneton


class ToUnitMagneticPermeabilityConverter(UnitConverter):
    """MagneticPermeability-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def henrys_per_meter(self) -> 'FieldQnty':
        """Convert to henrys per meter units."""
        unit_const: Final = field_units.MagneticPermeabilityUnits.henrys_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def H_m(self) -> 'FieldQnty':
        """Convert to H_m units (alias for henrys_per_meter)."""
        return self.henrys_per_meter

    @property
    def newton_per_square_ampere(self) -> 'FieldQnty':
        """Convert to newton per square ampere units."""
        unit_const: Final = field_units.MagneticPermeabilityUnits.newton_per_square_ampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N_A_2(self) -> 'FieldQnty':
        """Convert to N_A_2 units (alias for newton_per_square_ampere)."""
        return self.newton_per_square_ampere


class ToUnitMagnetomotiveForceConverter(UnitConverter):
    """MagnetomotiveForce-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abampere_turn(self) -> 'FieldQnty':
        """Convert to abampere-turn units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.abampere_turn
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abampere_turn)."""
        return self.abampere_turn

    @property
    def ampere(self) -> 'FieldQnty':
        """Convert to ampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.ampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A(self) -> 'FieldQnty':
        """Convert to A units (alias for ampere)."""
        return self.ampere

    @property
    def ampere_turn(self) -> 'FieldQnty':
        """Convert to ampere-turn units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.ampere_turn
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def A_turn(self) -> 'FieldQnty':
        """Convert to A_turn units (alias for ampere_turn)."""
        return self.ampere_turn

    @property
    def gilbert(self) -> 'FieldQnty':
        """Convert to gilbert units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.gilbert
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Gb(self) -> 'FieldQnty':
        """Convert to Gb units (alias for gilbert)."""
        return self.gilbert

    @property
    def kiloampere(self) -> 'FieldQnty':
        """Convert to kiloampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.kiloampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kA(self) -> 'FieldQnty':
        """Convert to kA units (alias for kiloampere)."""
        return self.kiloampere

    @property
    def milliampere(self) -> 'FieldQnty':
        """Convert to milliampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.milliampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mA(self) -> 'FieldQnty':
        """Convert to mA units (alias for milliampere)."""
        return self.milliampere

    @property
    def microampere(self) -> 'FieldQnty':
        """Convert to microampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.microampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanoampere(self) -> 'FieldQnty':
        """Convert to nanoampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.nanoampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nA(self) -> 'FieldQnty':
        """Convert to nA units (alias for nanoampere)."""
        return self.nanoampere

    @property
    def picoampere(self) -> 'FieldQnty':
        """Convert to picoampere units."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.picoampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pA(self) -> 'FieldQnty':
        """Convert to pA units (alias for picoampere)."""
        return self.picoampere


class ToUnitMassConverter(UnitConverter):
    """Mass-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def slug(self) -> 'FieldQnty':
        """Convert to slug units."""
        unit_const: Final = field_units.MassUnits.slug
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sl(self) -> 'FieldQnty':
        """Convert to sl units (alias for slug)."""
        return self.slug

    @property
    def atomic_mass_unit_12_mathrmc(self) -> 'FieldQnty':
        """Convert to atomic mass unit ( ${ }^{12} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.MassUnits.atomic_mass_unit_12_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_u_left_12_mathrm_C_right_or_amu(self) -> 'FieldQnty':
        """Convert to mathrm_u_left_12_mathrm_C_right_or_amu units (alias for atomic_mass_unit_12_mathrmc)."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def uleft_12_Cright(self) -> 'FieldQnty':
        """Convert to uleft_12_Cright units (alias for atomic_mass_unit_12_mathrmc)."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def amu(self) -> 'FieldQnty':
        """Convert to amu units (alias for atomic_mass_unit_12_mathrmc)."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def carat_metric(self) -> 'FieldQnty':
        """Convert to carat (metric) units."""
        unit_const: Final = field_units.MassUnits.carat_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ct(self) -> 'FieldQnty':
        """Convert to ct units (alias for carat_metric)."""
        return self.carat_metric

    @property
    def cental(self) -> 'FieldQnty':
        """Convert to cental units."""
        unit_const: Final = field_units.MassUnits.cental
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sh_cwt_cH(self) -> 'FieldQnty':
        """Convert to sh_cwt_cH units (alias for cental)."""
        return self.cental

    @property
    def centigram(self) -> 'FieldQnty':
        """Convert to centigram units."""
        unit_const: Final = field_units.MassUnits.centigram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cg(self) -> 'FieldQnty':
        """Convert to cg units (alias for centigram)."""
        return self.centigram

    @property
    def clove_uk(self) -> 'FieldQnty':
        """Convert to clove (UK) units."""
        unit_const: Final = field_units.MassUnits.clove_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cl(self) -> 'FieldQnty':
        """Convert to cl units (alias for clove_uk)."""
        return self.clove_uk

    @property
    def drachm_apothecary(self) -> 'FieldQnty':
        """Convert to drachm (apothecary) units."""
        unit_const: Final = field_units.MassUnits.drachm_apothecary
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dr_ap(self) -> 'FieldQnty':
        """Convert to dr_ap units (alias for drachm_apothecary)."""
        return self.drachm_apothecary

    @property
    def dram_avoirdupois(self) -> 'FieldQnty':
        """Convert to dram (avoirdupois) units."""
        unit_const: Final = field_units.MassUnits.dram_avoirdupois
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dr_av(self) -> 'FieldQnty':
        """Convert to dr_av units (alias for dram_avoirdupois)."""
        return self.dram_avoirdupois

    @property
    def dram_troy(self) -> 'FieldQnty':
        """Convert to dram (troy) units."""
        unit_const: Final = field_units.MassUnits.dram_troy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dr_troy(self) -> 'FieldQnty':
        """Convert to dr_troy units (alias for dram_troy)."""
        return self.dram_troy

    @property
    def grain(self) -> 'FieldQnty':
        """Convert to grain units."""
        unit_const: Final = field_units.MassUnits.grain
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gr(self) -> 'FieldQnty':
        """Convert to gr units (alias for grain)."""
        return self.grain

    @property
    def gram(self) -> 'FieldQnty':
        """Convert to gram units."""
        unit_const: Final = field_units.MassUnits.gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def g(self) -> 'FieldQnty':
        """Convert to g units (alias for gram)."""
        return self.gram

    @property
    def hundredweight_long_or_gross(self) -> 'FieldQnty':
        """Convert to hundredweight, long or gross units."""
        unit_const: Final = field_units.MassUnits.hundredweight_long_or_gross
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cwt_lg_cwt(self) -> 'FieldQnty':
        """Convert to cwt_lg_cwt units (alias for hundredweight_long_or_gross)."""
        return self.hundredweight_long_or_gross

    @property
    def hundredweight_short_or_net(self) -> 'FieldQnty':
        """Convert to hundredweight, short or net units."""
        unit_const: Final = field_units.MassUnits.hundredweight_short_or_net
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sh_cwt(self) -> 'FieldQnty':
        """Convert to sh_cwt units (alias for hundredweight_short_or_net)."""
        return self.hundredweight_short_or_net

    @property
    def kilogram(self) -> 'FieldQnty':
        """Convert to kilogram units."""
        unit_const: Final = field_units.MassUnits.kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg(self) -> 'FieldQnty':
        """Convert to kg units (alias for kilogram)."""
        return self.kilogram

    @property
    def kip(self) -> 'FieldQnty':
        """Convert to kip units."""
        unit_const: Final = field_units.MassUnits.kip
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def microgram(self) -> 'FieldQnty':
        """Convert to microgram units."""
        unit_const: Final = field_units.MassUnits.microgram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_g(self) -> 'FieldQnty':
        """Convert to mu_mathrm_g units (alias for microgram)."""
        return self.microgram

    @property
    def milligram(self) -> 'FieldQnty':
        """Convert to milligram units."""
        unit_const: Final = field_units.MassUnits.milligram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mg(self) -> 'FieldQnty':
        """Convert to mg units (alias for milligram)."""
        return self.milligram

    @property
    def ounce_apothecary(self) -> 'FieldQnty':
        """Convert to ounce (apothecary) units."""
        unit_const: Final = field_units.MassUnits.ounce_apothecary
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oz_ap(self) -> 'FieldQnty':
        """Convert to oz_ap units (alias for ounce_apothecary)."""
        return self.ounce_apothecary

    @property
    def ounce_avoirdupois(self) -> 'FieldQnty':
        """Convert to ounce (avoirdupois) units."""
        unit_const: Final = field_units.MassUnits.ounce_avoirdupois
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oz(self) -> 'FieldQnty':
        """Convert to oz units (alias for ounce_avoirdupois)."""
        return self.ounce_avoirdupois

    @property
    def ounce_troy(self) -> 'FieldQnty':
        """Convert to ounce (troy) units."""
        unit_const: Final = field_units.MassUnits.ounce_troy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oz_troy(self) -> 'FieldQnty':
        """Convert to oz_troy units (alias for ounce_troy)."""
        return self.ounce_troy

    @property
    def pennyweight_troy(self) -> 'FieldQnty':
        """Convert to pennyweight (troy) units."""
        unit_const: Final = field_units.MassUnits.pennyweight_troy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dwt_troy(self) -> 'FieldQnty':
        """Convert to dwt_troy units (alias for pennyweight_troy)."""
        return self.pennyweight_troy

    @property
    def pood_russia(self) -> 'FieldQnty':
        """Convert to pood, (Russia) units."""
        unit_const: Final = field_units.MassUnits.pood_russia
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pood(self) -> 'FieldQnty':
        """Convert to pood units (alias for pood_russia)."""
        return self.pood_russia

    @property
    def pound_apothecary(self) -> 'FieldQnty':
        """Convert to pound (apothecary) units."""
        unit_const: Final = field_units.MassUnits.pound_apothecary
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_ap(self) -> 'FieldQnty':
        """Convert to lb_ap units (alias for pound_apothecary)."""
        return self.pound_apothecary

    @property
    def pound_avoirdupois(self) -> 'FieldQnty':
        """Convert to pound (avoirdupois) units."""
        unit_const: Final = field_units.MassUnits.pound_avoirdupois
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_av(self) -> 'FieldQnty':
        """Convert to lb_av units (alias for pound_avoirdupois)."""
        return self.pound_avoirdupois

    @property
    def pound_troy(self) -> 'FieldQnty':
        """Convert to pound (troy) units."""
        unit_const: Final = field_units.MassUnits.pound_troy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_troy(self) -> 'FieldQnty':
        """Convert to lb_troy units (alias for pound_troy)."""
        return self.pound_troy

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound mass units."""
        unit_const: Final = field_units.MassUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_m(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_m units (alias for pound_mass)."""
        return self.pound_mass

    @property
    def quarter_uk(self) -> 'FieldQnty':
        """Convert to quarter (UK) units."""
        unit_const: Final = field_units.MassUnits.quarter_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def qt(self) -> 'FieldQnty':
        """Convert to qt units (alias for quarter_uk)."""
        return self.quarter_uk

    @property
    def quintal_metric(self) -> 'FieldQnty':
        """Convert to quintal, metric units."""
        unit_const: Final = field_units.MassUnits.quintal_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def q_dt(self) -> 'FieldQnty':
        """Convert to q_dt units (alias for quintal_metric)."""
        return self.quintal_metric

    @property
    def quital_us(self) -> 'FieldQnty':
        """Convert to quital, US units."""
        unit_const: Final = field_units.MassUnits.quital_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def quint_US(self) -> 'FieldQnty':
        """Convert to quint_US units (alias for quital_us)."""
        return self.quital_us

    @property
    def scruple_avoirdupois(self) -> 'FieldQnty':
        """Convert to scruple (avoirdupois) units."""
        unit_const: Final = field_units.MassUnits.scruple_avoirdupois
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def scf(self) -> 'FieldQnty':
        """Convert to scf units (alias for scruple_avoirdupois)."""
        return self.scruple_avoirdupois

    @property
    def stone_uk(self) -> 'FieldQnty':
        """Convert to stone (UK) units."""
        unit_const: Final = field_units.MassUnits.stone_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def st(self) -> 'FieldQnty':
        """Convert to st units (alias for stone_uk)."""
        return self.stone_uk

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton, metric units."""
        unit_const: Final = field_units.MassUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def t(self) -> 'FieldQnty':
        """Convert to t units (alias for ton_metric)."""
        return self.ton_metric

    @property
    def ton_us_long(self) -> 'FieldQnty':
        """Convert to ton, US, long units."""
        unit_const: Final = field_units.MassUnits.ton_us_long
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lg_ton(self) -> 'FieldQnty':
        """Convert to lg_ton units (alias for ton_us_long)."""
        return self.ton_us_long

    @property
    def ton_us_short(self) -> 'FieldQnty':
        """Convert to ton, US, short units."""
        unit_const: Final = field_units.MassUnits.ton_us_short
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sh_ton(self) -> 'FieldQnty':
        """Convert to sh_ton units (alias for ton_us_short)."""
        return self.ton_us_short


class ToUnitMassDensityConverter(UnitConverter):
    """MassDensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to gram per cubic centimeter units."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def g_cc_or_g_ml(self) -> 'FieldQnty':
        """Convert to g_cc_or_g_ml units (alias for gram_per_cubic_centimeter)."""
        return self.gram_per_cubic_centimeter

    @property
    def g_cc(self) -> 'FieldQnty':
        """Convert to g_cc units (alias for gram_per_cubic_centimeter)."""
        return self.gram_per_cubic_centimeter

    @property
    def g_ml(self) -> 'FieldQnty':
        """Convert to g_ml units (alias for gram_per_cubic_centimeter)."""
        return self.gram_per_cubic_centimeter

    @property
    def gram_per_cubic_decimeter(self) -> 'FieldQnty':
        """Convert to gram per cubic decimeter units."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_decimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_dm_3(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_dm_3 units (alias for gram_per_cubic_decimeter)."""
        return self.gram_per_cubic_decimeter

    @property
    def gram_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram per cubic meter units."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_m_3 units (alias for gram_per_cubic_meter)."""
        return self.gram_per_cubic_meter

    @property
    def gram_per_liter(self) -> 'FieldQnty':
        """Convert to gram per liter units."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_l_or_g_L(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_l_or_g_L units (alias for gram_per_liter)."""
        return self.gram_per_liter

    @property
    def g_l(self) -> 'FieldQnty':
        """Convert to g_l units (alias for gram_per_liter)."""
        return self.gram_per_liter

    @property
    def g_L(self) -> 'FieldQnty':
        """Convert to g_L units (alias for gram_per_liter)."""
        return self.gram_per_liter

    @property
    def kilogram_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram per cubic meter units."""
        unit_const: Final = field_units.MassDensityUnits.kilogram_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_3 units (alias for kilogram_per_cubic_meter)."""
        return self.kilogram_per_cubic_meter

    @property
    def ounce_avdp(self) -> 'FieldQnty':
        """Convert to ounce (avdp) per US gallon units."""
        unit_const: Final = field_units.MassDensityUnits.ounce_avdp
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oz_gal(self) -> 'FieldQnty':
        """Convert to oz_gal units (alias for ounce_avdp)."""
        return self.ounce_avdp

    @property
    def pound_avdp(self) -> 'FieldQnty':
        """Convert to pound (avdp) per cubic foot units."""
        unit_const: Final = field_units.MassDensityUnits.pound_avdp
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_cu_mathrm_ft_or_lb_ft_3(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_cu_mathrm_ft_or_lb_ft_3 units (alias for pound_avdp)."""
        return self.pound_avdp

    @property
    def lb_cu_ft(self) -> 'FieldQnty':
        """Convert to lb_cu_ft units (alias for pound_avdp)."""
        return self.pound_avdp

    @property
    def lb_ft_3(self) -> 'FieldQnty':
        """Convert to lb_ft_3 units (alias for pound_avdp)."""
        return self.pound_avdp

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound (mass) per cubic inch units."""
        unit_const: Final = field_units.MassDensityUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_cu_in_or_mathrm_lb_mathrm_in_3(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_cu_in_or_mathrm_lb_mathrm_in_3 units (alias for pound_mass)."""
        return self.pound_mass

    @property
    def lb_cu_in(self) -> 'FieldQnty':
        """Convert to lb_cu_in units (alias for pound_mass)."""
        return self.pound_mass

    @property
    def lb_in_3(self) -> 'FieldQnty':
        """Convert to lb_in_3 units (alias for pound_mass)."""
        return self.pound_mass

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton (metric) per cubic meter units."""
        unit_const: Final = field_units.MassDensityUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_t_mathrm_m_3_or_MT_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_t_mathrm_m_3_or_MT_mathrm_m_3 units (alias for ton_metric)."""
        return self.ton_metric

    @property
    def t_m_3(self) -> 'FieldQnty':
        """Convert to t_m_3 units (alias for ton_metric)."""
        return self.ton_metric

    @property
    def MT_m_3(self) -> 'FieldQnty':
        """Convert to MT_m_3 units (alias for ton_metric)."""
        return self.ton_metric


class ToUnitMassFlowRateConverter(UnitConverter):
    """MassFlowRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def kilograms_per_day(self) -> 'FieldQnty':
        """Convert to kilograms per day units."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_d(self) -> 'FieldQnty':
        """Convert to kg_d units (alias for kilograms_per_day)."""
        return self.kilograms_per_day

    @property
    def kilograms_per_hour(self) -> 'FieldQnty':
        """Convert to kilograms per hour units."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_h(self) -> 'FieldQnty':
        """Convert to kg_h units (alias for kilograms_per_hour)."""
        return self.kilograms_per_hour

    @property
    def kilograms_per_minute(self) -> 'FieldQnty':
        """Convert to kilograms per minute units."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_min(self) -> 'FieldQnty':
        """Convert to kg_min units (alias for kilograms_per_minute)."""
        return self.kilograms_per_minute

    @property
    def kilograms_per_second(self) -> 'FieldQnty':
        """Convert to kilograms per second units."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_s(self) -> 'FieldQnty':
        """Convert to kg_s units (alias for kilograms_per_second)."""
        return self.kilograms_per_second

    @property
    def metric_tons_per_day(self) -> 'FieldQnty':
        """Convert to metric tons per day units."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MT_d_or_MTD(self) -> 'FieldQnty':
        """Convert to MT_d_or_MTD units (alias for metric_tons_per_day)."""
        return self.metric_tons_per_day

    @property
    def MT_d(self) -> 'FieldQnty':
        """Convert to MT_d units (alias for metric_tons_per_day)."""
        return self.metric_tons_per_day

    @property
    def MTD(self) -> 'FieldQnty':
        """Convert to MTD units (alias for metric_tons_per_day)."""
        return self.metric_tons_per_day

    @property
    def metric_tons_per_hour(self) -> 'FieldQnty':
        """Convert to metric tons per hour units."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MT_h_or_MTD(self) -> 'FieldQnty':
        """Convert to MT_h_or_MTD units (alias for metric_tons_per_hour)."""
        return self.metric_tons_per_hour

    @property
    def MT_h(self) -> 'FieldQnty':
        """Convert to MT_h units (alias for metric_tons_per_hour)."""
        return self.metric_tons_per_hour

    @property
    def metric_tons_per_minute(self) -> 'FieldQnty':
        """Convert to metric tons per minute units."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def metric_tons_per_second(self) -> 'FieldQnty':
        """Convert to metric tons per second units."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MT_s(self) -> 'FieldQnty':
        """Convert to MT_s units (alias for metric_tons_per_second)."""
        return self.metric_tons_per_second

    @property
    def metric_tons_per_year_365_d(self) -> 'FieldQnty':
        """Convert to metric tons per year (365 d) units."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_year_365_d
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MT_yr_or_MTY(self) -> 'FieldQnty':
        """Convert to MT_yr_or_MTY units (alias for metric_tons_per_year_365_d)."""
        return self.metric_tons_per_year_365_d

    @property
    def MT_yr(self) -> 'FieldQnty':
        """Convert to MT_yr units (alias for metric_tons_per_year_365_d)."""
        return self.metric_tons_per_year_365_d

    @property
    def MTY(self) -> 'FieldQnty':
        """Convert to MTY units (alias for metric_tons_per_year_365_d)."""
        return self.metric_tons_per_year_365_d

    @property
    def pounds_per_day(self) -> 'FieldQnty':
        """Convert to pounds per day units."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_d_or_mathrm_lb_mathrm_da_or_PPD(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_d_or_mathrm_lb_mathrm_da_or_PPD units (alias for pounds_per_day)."""
        return self.pounds_per_day

    @property
    def lb_d(self) -> 'FieldQnty':
        """Convert to lb_d units (alias for pounds_per_day)."""
        return self.pounds_per_day

    @property
    def lb_da(self) -> 'FieldQnty':
        """Convert to lb_da units (alias for pounds_per_day)."""
        return self.pounds_per_day

    @property
    def PPD(self) -> 'FieldQnty':
        """Convert to PPD units (alias for pounds_per_day)."""
        return self.pounds_per_day

    @property
    def pounds_per_hour(self) -> 'FieldQnty':
        """Convert to pounds per hour units."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_h_or_lb_hr_or_PPH(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_h_or_lb_hr_or_PPH units (alias for pounds_per_hour)."""
        return self.pounds_per_hour

    @property
    def lb_h(self) -> 'FieldQnty':
        """Convert to lb_h units (alias for pounds_per_hour)."""
        return self.pounds_per_hour

    @property
    def lb_hr(self) -> 'FieldQnty':
        """Convert to lb_hr units (alias for pounds_per_hour)."""
        return self.pounds_per_hour

    @property
    def PPH(self) -> 'FieldQnty':
        """Convert to PPH units (alias for pounds_per_hour)."""
        return self.pounds_per_hour

    @property
    def pounds_per_minute(self) -> 'FieldQnty':
        """Convert to pounds per minute units."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_min_or_PPM(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_min_or_PPM units (alias for pounds_per_minute)."""
        return self.pounds_per_minute

    @property
    def lb_min(self) -> 'FieldQnty':
        """Convert to lb_min units (alias for pounds_per_minute)."""
        return self.pounds_per_minute

    @property
    def PPM(self) -> 'FieldQnty':
        """Convert to PPM units (alias for pounds_per_minute)."""
        return self.pounds_per_minute

    @property
    def pounds_per_second(self) -> 'FieldQnty':
        """Convert to pounds per second units."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_s_or_lb_sec_or_PPS(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_s_or_lb_sec_or_PPS units (alias for pounds_per_second)."""
        return self.pounds_per_second

    @property
    def lb_s(self) -> 'FieldQnty':
        """Convert to lb_s units (alias for pounds_per_second)."""
        return self.pounds_per_second

    @property
    def lb_sec(self) -> 'FieldQnty':
        """Convert to lb_sec units (alias for pounds_per_second)."""
        return self.pounds_per_second

    @property
    def PPS(self) -> 'FieldQnty':
        """Convert to PPS units (alias for pounds_per_second)."""
        return self.pounds_per_second


class ToUnitMassFluxConverter(UnitConverter):
    """MassFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def kilogram_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per day units."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_d_right units (alias for kilogram_per_square_meter_per_day)."""
        return self.kilogram_per_square_meter_per_day

    @property
    def kilogram_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per hour units."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_h_right units (alias for kilogram_per_square_meter_per_hour)."""
        return self.kilogram_per_square_meter_per_hour

    @property
    def kilogram_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per minute units."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_min_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_min_right units (alias for kilogram_per_square_meter_per_minute)."""
        return self.kilogram_per_square_meter_per_minute

    @property
    def kilogram_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per second units."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_s_right units (alias for kilogram_per_square_meter_per_second)."""
        return self.kilogram_per_square_meter_per_second

    @property
    def pound_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to pound per square foot per day units."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_d_right_or_lb_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_d_right_or_lb_sqft_da units (alias for pound_per_square_foot_per_day)."""
        return self.pound_per_square_foot_per_day

    @property
    def lb_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_dright units (alias for pound_per_square_foot_per_day)."""
        return self.pound_per_square_foot_per_day

    @property
    def lb_sqft_da(self) -> 'FieldQnty':
        """Convert to lb_sqft_da units (alias for pound_per_square_foot_per_day)."""
        return self.pound_per_square_foot_per_day

    @property
    def pound_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pound per square foot per hour units."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_h_right_or_lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_h_right_or_lb_sqft_hr units (alias for pound_per_square_foot_per_hour)."""
        return self.pound_per_square_foot_per_hour

    @property
    def lb_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_hright units (alias for pound_per_square_foot_per_hour)."""
        return self.pound_per_square_foot_per_hour

    @property
    def lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_sqft_hr units (alias for pound_per_square_foot_per_hour)."""
        return self.pound_per_square_foot_per_hour

    @property
    def pound_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to pound per square foot per minute units."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_ft_2_min_right_or_lb_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_min_right_or_lb_sqft_min units (alias for pound_per_square_foot_per_minute)."""
        return self.pound_per_square_foot_per_minute

    @property
    def lb_left_ft_2_min_right(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_min_right units (alias for pound_per_square_foot_per_minute)."""
        return self.pound_per_square_foot_per_minute

    @property
    def lb_sqft_min(self) -> 'FieldQnty':
        """Convert to lb_sqft_min units (alias for pound_per_square_foot_per_minute)."""
        return self.pound_per_square_foot_per_minute

    @property
    def pound_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound per square foot per second units."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec units (alias for pound_per_square_foot_per_second)."""
        return self.pound_per_square_foot_per_second

    @property
    def lb_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_sright units (alias for pound_per_square_foot_per_second)."""
        return self.pound_per_square_foot_per_second

    @property
    def lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to lb_sqft_sec units (alias for pound_per_square_foot_per_second)."""
        return self.pound_per_square_foot_per_second


class ToUnitMassFractionOfIConverter(UnitConverter):
    """MassFractionOfI-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def grains_of_i_per_pound_total(self) -> 'FieldQnty':
        """Convert to grains of "i" per pound total units."""
        unit_const: Final = field_units.MassFractionOfIUnits.grains_of_i_per_pound_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gr_mathrm_i_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_gr_mathrm_i_mathrm_lb units (alias for grains_of_i_per_pound_total)."""
        return self.grains_of_i_per_pound_total

    @property
    def gram_of_i_per_kilogram_total(self) -> 'FieldQnty':
        """Convert to gram of "i" per kilogram total units."""
        unit_const: Final = field_units.MassFractionOfIUnits.gram_of_i_per_kilogram_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_i_mathrm_kg units (alias for gram_of_i_per_kilogram_total)."""
        return self.gram_of_i_per_kilogram_total

    @property
    def kilogram_of_i_per_kilogram_total(self) -> 'FieldQnty':
        """Convert to kilogram of "i" per kilogram total units."""
        unit_const: Final = field_units.MassFractionOfIUnits.kilogram_of_i_per_kilogram_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_i_mathrm_kg units (alias for kilogram_of_i_per_kilogram_total)."""
        return self.kilogram_of_i_per_kilogram_total

    @property
    def pound_of_i_per_pound_total(self) -> 'FieldQnty':
        """Convert to pound of "i" per pound total units."""
        unit_const: Final = field_units.MassFractionOfIUnits.pound_of_i_per_pound_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_i_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_i_mathrm_lb units (alias for pound_of_i_per_pound_total)."""
        return self.pound_of_i_per_pound_total


class ToUnitMassTransferCoefficientConverter(UnitConverter):
    """MassTransferCoefficient-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_per_square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to gram per square centimeter per second units."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.gram_per_square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2_mathrm_s units (alias for gram_per_square_centimeter_per_second)."""
        return self.gram_per_square_centimeter_per_second

    @property
    def kilogram_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per second units."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.kilogram_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2_mathrm_s units (alias for kilogram_per_square_meter_per_second)."""
        return self.kilogram_per_square_meter_per_second

    @property
    def pounds_force_per_cubic_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pounds force per cubic foot per hour units."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_force_per_cubic_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_ft_3_mathrm_h_or_mathrm_lb_mathrm_f_mathrm_cft_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_ft_3_mathrm_h_or_mathrm_lb_mathrm_f_mathrm_cft_mathrm_hr units (alias for pounds_force_per_cubic_foot_per_hour)."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def lb_f_ft_3_h(self) -> 'FieldQnty':
        """Convert to lb_f_ft_3_h units (alias for pounds_force_per_cubic_foot_per_hour)."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def lb_f_cft_hr(self) -> 'FieldQnty':
        """Convert to lb_f_cft_hr units (alias for pounds_force_per_cubic_foot_per_hour)."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def pounds_mass_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pounds mass per square foot per hour units."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_mass_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_ft_2_mathrm_hr_or_lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_ft_2_mathrm_hr_or_lb_sqft_hr units (alias for pounds_mass_per_square_foot_per_hour)."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def lb_ft_2_hr(self) -> 'FieldQnty':
        """Convert to lb_ft_2_hr units (alias for pounds_mass_per_square_foot_per_hour)."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_sqft_hr units (alias for pounds_mass_per_square_foot_per_hour)."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def pounds_mass_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pounds mass per square foot per second units."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_mass_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec units (alias for pounds_mass_per_square_foot_per_second)."""
        return self.pounds_mass_per_square_foot_per_second

    @property
    def lb_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_sright units (alias for pounds_mass_per_square_foot_per_second)."""
        return self.pounds_mass_per_square_foot_per_second

    @property
    def lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to lb_sqft_sec units (alias for pounds_mass_per_square_foot_per_second)."""
        return self.pounds_mass_per_square_foot_per_second


class ToUnitMolalityOfSoluteIConverter(UnitConverter):
    """MolalityOfSoluteI-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_moles_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per kilogram units."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.gram_moles_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mol_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_kg units (alias for gram_moles_of_i_per_kilogram)."""
        return self.gram_moles_of_i_per_kilogram

    @property
    def kilogram_mols_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram mols of "i" per kilogram units."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.kilogram_mols_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_kg units (alias for kilogram_mols_of_i_per_kilogram)."""
        return self.kilogram_mols_of_i_per_kilogram

    @property
    def kmols_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to kmols of "i" per kilogram units."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.kmols_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mols_of_i_per_gram(self) -> 'FieldQnty':
        """Convert to mols of "i" per gram units."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.mols_of_i_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mol_mathrm_i_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_g units (alias for mols_of_i_per_gram)."""
        return self.mols_of_i_per_gram

    @property
    def pound_moles_of_i_per_pound_mass(self) -> 'FieldQnty':
        """Convert to pound moles of "i" per pound mass units."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.pound_moles_of_i_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mole_mathrm_i_mathrm_lb_mass(self) -> 'FieldQnty':
        """Convert to mole_mathrm_i_mathrm_lb_mass units (alias for pound_moles_of_i_per_pound_mass)."""
        return self.pound_moles_of_i_per_pound_mass


class ToUnitMolarConcentrationByMassConverter(UnitConverter):
    """MolarConcentrationByMass-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_mole_or_mole_per_gram(self) -> 'FieldQnty':
        """Convert to gram mole or mole per gram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.gram_mole_or_mole_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_g(self) -> 'FieldQnty':
        """Convert to mol_g units (alias for gram_mole_or_mole_per_gram)."""
        return self.gram_mole_or_mole_per_gram

    @property
    def gram_mole_or_mole_per_kilogram(self) -> 'FieldQnty':
        """Convert to gram mole or mole per kilogram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.gram_mole_or_mole_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_kg(self) -> 'FieldQnty':
        """Convert to mol_kg units (alias for gram_mole_or_mole_per_kilogram)."""
        return self.gram_mole_or_mole_per_kilogram

    @property
    def kilogram_mole_or_kmol_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per kilogram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.kilogram_mole_or_kmol_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol_kg(self) -> 'FieldQnty':
        """Convert to kmol_kg units (alias for kilogram_mole_or_kmol_per_kilogram)."""
        return self.kilogram_mole_or_kmol_per_kilogram

    @property
    def micromole_per_gram(self) -> 'FieldQnty':
        """Convert to micromole per gram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.micromole_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_mol_mathrm_g(self) -> 'FieldQnty':
        """Convert to mu_mathrm_mol_mathrm_g units (alias for micromole_per_gram)."""
        return self.micromole_per_gram

    @property
    def millimole_per_gram(self) -> 'FieldQnty':
        """Convert to millimole per gram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.millimole_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mmol_g(self) -> 'FieldQnty':
        """Convert to mmol_g units (alias for millimole_per_gram)."""
        return self.millimole_per_gram

    @property
    def picomole_per_gram(self) -> 'FieldQnty':
        """Convert to picomole per gram units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.picomole_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pmol_g(self) -> 'FieldQnty':
        """Convert to pmol_g units (alias for picomole_per_gram)."""
        return self.picomole_per_gram

    @property
    def pound_mole_per_pound(self) -> 'FieldQnty':
        """Convert to pound mole per pound units."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.pound_mole_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_mathrm_lb_or_mole_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_mathrm_lb_or_mole_lb units (alias for pound_mole_per_pound)."""
        return self.pound_mole_per_pound

    @property
    def lb_mol_lb(self) -> 'FieldQnty':
        """Convert to lb_mol_lb units (alias for pound_mole_per_pound)."""
        return self.pound_mole_per_pound

    @property
    def mole_lb(self) -> 'FieldQnty':
        """Convert to mole_lb units (alias for pound_mole_per_pound)."""
        return self.pound_mole_per_pound


class ToUnitMolarFlowRateConverter(UnitConverter):
    """MolarFlowRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_mole_per_day(self) -> 'FieldQnty':
        """Convert to gram mole per day units."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_d(self) -> 'FieldQnty':
        """Convert to mol_d units (alias for gram_mole_per_day)."""
        return self.gram_mole_per_day

    @property
    def gram_mole_per_hour(self) -> 'FieldQnty':
        """Convert to gram mole per hour units."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_h(self) -> 'FieldQnty':
        """Convert to mol_h units (alias for gram_mole_per_hour)."""
        return self.gram_mole_per_hour

    @property
    def gram_mole_per_minute(self) -> 'FieldQnty':
        """Convert to gram mole per minute units."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_min(self) -> 'FieldQnty':
        """Convert to mol_min units (alias for gram_mole_per_minute)."""
        return self.gram_mole_per_minute

    @property
    def gram_mole_per_second(self) -> 'FieldQnty':
        """Convert to gram mole per second units."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mol_s(self) -> 'FieldQnty':
        """Convert to mol_s units (alias for gram_mole_per_second)."""
        return self.gram_mole_per_second

    @property
    def kilogram_mole_or_kmol_per_day(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per day units."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol_d(self) -> 'FieldQnty':
        """Convert to kmol_d units (alias for kilogram_mole_or_kmol_per_day)."""
        return self.kilogram_mole_or_kmol_per_day

    @property
    def kilogram_mole_or_kmol_per_hour(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per hour units."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol_h(self) -> 'FieldQnty':
        """Convert to kmol_h units (alias for kilogram_mole_or_kmol_per_hour)."""
        return self.kilogram_mole_or_kmol_per_hour

    @property
    def kilogram_mole_or_kmol_per_minute(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per minute units."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol_min(self) -> 'FieldQnty':
        """Convert to kmol_min units (alias for kilogram_mole_or_kmol_per_minute)."""
        return self.kilogram_mole_or_kmol_per_minute

    @property
    def kilogram_mole_or_kmol_per_second(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per second units."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kmol_s(self) -> 'FieldQnty':
        """Convert to kmol_s units (alias for kilogram_mole_or_kmol_per_second)."""
        return self.kilogram_mole_or_kmol_per_second

    @property
    def pound_mole_or_lb_mol_per_day(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per day units."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mol_d_or_mole_da(self) -> 'FieldQnty':
        """Convert to lb_mol_d_or_mole_da units (alias for pound_mole_or_lb_mol_per_day)."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def lb_mol_d(self) -> 'FieldQnty':
        """Convert to lb_mol_d units (alias for pound_mole_or_lb_mol_per_day)."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def mole_da(self) -> 'FieldQnty':
        """Convert to mole_da units (alias for pound_mole_or_lb_mol_per_day)."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def pound_mole_or_lb_mol_per_hour(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per hour units."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mol_h_or_mole_hr(self) -> 'FieldQnty':
        """Convert to lb_mol_h_or_mole_hr units (alias for pound_mole_or_lb_mol_per_hour)."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def lb_mol_h(self) -> 'FieldQnty':
        """Convert to lb_mol_h units (alias for pound_mole_or_lb_mol_per_hour)."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def mole_hr(self) -> 'FieldQnty':
        """Convert to mole_hr units (alias for pound_mole_or_lb_mol_per_hour)."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def pound_mole_or_lb_mol_per_minute(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per minute units."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mol_min_or_mole_min(self) -> 'FieldQnty':
        """Convert to lb_mol_min_or_mole_min units (alias for pound_mole_or_lb_mol_per_minute)."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def lb_mol_min(self) -> 'FieldQnty':
        """Convert to lb_mol_min units (alias for pound_mole_or_lb_mol_per_minute)."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def mole_min(self) -> 'FieldQnty':
        """Convert to mole_min units (alias for pound_mole_or_lb_mol_per_minute)."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def pound_mole_or_lb_mol_per_second(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per second units."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_mathrm_s_or_mole_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_mathrm_s_or_mole_sec units (alias for pound_mole_or_lb_mol_per_second)."""
        return self.pound_mole_or_lb_mol_per_second

    @property
    def lb_mol_s(self) -> 'FieldQnty':
        """Convert to lb_mol_s units (alias for pound_mole_or_lb_mol_per_second)."""
        return self.pound_mole_or_lb_mol_per_second

    @property
    def mole_sec(self) -> 'FieldQnty':
        """Convert to mole_sec units (alias for pound_mole_or_lb_mol_per_second)."""
        return self.pound_mole_or_lb_mol_per_second


class ToUnitMolarFluxConverter(UnitConverter):
    """MolarFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def kmol_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to kmol per square meter per day units."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_d_right units (alias for kmol_per_square_meter_per_day)."""
        return self.kmol_per_square_meter_per_day

    @property
    def kmol_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kmol per square meter per hour units."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_h_right units (alias for kmol_per_square_meter_per_hour)."""
        return self.kmol_per_square_meter_per_hour

    @property
    def kmol_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to kmol per square meter per minute units."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_left_mathrm_m_2_right_amin(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_right_amin units (alias for kmol_per_square_meter_per_minute)."""
        return self.kmol_per_square_meter_per_minute

    @property
    def kmol_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kmol per square meter per second units."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_s_right units (alias for kmol_per_square_meter_per_second)."""
        return self.kmol_per_square_meter_per_second

    @property
    def pound_mole_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per day units."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_d_right_or_mole_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_d_right_or_mole_sqft_da units (alias for pound_mole_per_square_foot_per_day)."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def lb_mol_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_dright units (alias for pound_mole_per_square_foot_per_day)."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def mole_sqft_da(self) -> 'FieldQnty':
        """Convert to mole_sqft_da units (alias for pound_mole_per_square_foot_per_day)."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def pound_mole_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per hour units."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_h_right_or_mole_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_h_right_or_mole_sqft_hr units (alias for pound_mole_per_square_foot_per_hour)."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def lb_mol_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_hright units (alias for pound_mole_per_square_foot_per_hour)."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def mole_sqft_hr(self) -> 'FieldQnty':
        """Convert to mole_sqft_hr units (alias for pound_mole_per_square_foot_per_hour)."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def pound_mole_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per minute units."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_min_right_or_mole_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_min_right_or_mole_sqft_min units (alias for pound_mole_per_square_foot_per_minute)."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def lb_mol_left_ft_2_minright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_minright units (alias for pound_mole_per_square_foot_per_minute)."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def mole_sqft_min(self) -> 'FieldQnty':
        """Convert to mole_sqft_min units (alias for pound_mole_per_square_foot_per_minute)."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def pound_mole_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per second units."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_s_right_or_mole_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_s_right_or_mole_sqft_sec units (alias for pound_mole_per_square_foot_per_second)."""
        return self.pound_mole_per_square_foot_per_second

    @property
    def lb_mol_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_sright units (alias for pound_mole_per_square_foot_per_second)."""
        return self.pound_mole_per_square_foot_per_second

    @property
    def mole_sqft_sec(self) -> 'FieldQnty':
        """Convert to mole_sqft_sec units (alias for pound_mole_per_square_foot_per_second)."""
        return self.pound_mole_per_square_foot_per_second


class ToUnitMolarHeatCapacityConverter(UnitConverter):
    """MolarHeatCapacity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to Btu per pound mole per degree Fahrenheit (or degree Rankine) units."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb_mol_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_lb_mol_circ_mathrm_F units (alias for btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine)."""
        return self.btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine

    @property
    def calories_per_gram_mole_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to calories per gram mole per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.calories_per_gram_mole_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_mol_K(self) -> 'FieldQnty':
        """Convert to cal_mol_K units (alias for calories_per_gram_mole_per_kelvin_or_degree_celsius)."""
        return self.calories_per_gram_mole_per_kelvin_or_degree_celsius

    @property
    def joule_per_gram_mole_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to joule per gram mole per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.joule_per_gram_mole_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_mol_K(self) -> 'FieldQnty':
        """Convert to J_mol_K units (alias for joule_per_gram_mole_per_kelvin_or_degree_celsius)."""
        return self.joule_per_gram_mole_per_kelvin_or_degree_celsius


class ToUnitMolarityOfIConverter(UnitConverter):
    """MolarityOfI-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_moles_of_i_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per cubic meter units."""
        unit_const: Final = field_units.MolarityOfIUnits.gram_moles_of_i_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mol_mathrm_i_mathrm_m_3_or_mathrm_c_mathrm_i(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_m_3_or_mathrm_c_mathrm_i units (alias for gram_moles_of_i_per_cubic_meter)."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def mol_i_m_3(self) -> 'FieldQnty':
        """Convert to mol_i_m_3 units (alias for gram_moles_of_i_per_cubic_meter)."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def c_i(self) -> 'FieldQnty':
        """Convert to c_i units (alias for gram_moles_of_i_per_cubic_meter)."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def gram_moles_of_i_per_liter(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per liter units."""
        unit_const: Final = field_units.MolarityOfIUnits.gram_moles_of_i_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mol_mathrm_i_mathrm_l(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_l units (alias for gram_moles_of_i_per_liter)."""
        return self.gram_moles_of_i_per_liter

    @property
    def kilogram_moles_of_i_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram moles of "i" per cubic meter units."""
        unit_const: Final = field_units.MolarityOfIUnits.kilogram_moles_of_i_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_mathrm_i_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_m_3 units (alias for kilogram_moles_of_i_per_cubic_meter)."""
        return self.kilogram_moles_of_i_per_cubic_meter

    @property
    def kilogram_moles_of_i_per_liter(self) -> 'FieldQnty':
        """Convert to kilogram moles of "i" per liter units."""
        unit_const: Final = field_units.MolarityOfIUnits.kilogram_moles_of_i_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_mathrm_i_mathrm_l(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_l units (alias for kilogram_moles_of_i_per_liter)."""
        return self.kilogram_moles_of_i_per_liter

    @property
    def pound_moles_of_i_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound moles of "i" per cubic foot units."""
        unit_const: Final = field_units.MolarityOfIUnits.pound_moles_of_i_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_ft_3_or_mathrm_mole_mathrm_i_cft(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_ft_3_or_mathrm_mole_mathrm_i_cft units (alias for pound_moles_of_i_per_cubic_foot)."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def lb_mol_i_ft_3(self) -> 'FieldQnty':
        """Convert to lb_mol_i_ft_3 units (alias for pound_moles_of_i_per_cubic_foot)."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def mole_i_cft(self) -> 'FieldQnty':
        """Convert to mole_i_cft units (alias for pound_moles_of_i_per_cubic_foot)."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def pound_moles_of_i_per_gallon_us(self) -> 'FieldQnty':
        """Convert to pound moles of " $i$ " per gallon (US) units."""
        unit_const: Final = field_units.MolarityOfIUnits.pound_moles_of_i_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_gal_or_mathrm_mole_mathrm_i_gal(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_gal_or_mathrm_mole_mathrm_i_gal units (alias for pound_moles_of_i_per_gallon_us)."""
        return self.pound_moles_of_i_per_gallon_us

    @property
    def lb_mol_i_gal(self) -> 'FieldQnty':
        """Convert to lb_mol_i_gal units (alias for pound_moles_of_i_per_gallon_us)."""
        return self.pound_moles_of_i_per_gallon_us

    @property
    def mole_i_gal(self) -> 'FieldQnty':
        """Convert to mole_i_gal units (alias for pound_moles_of_i_per_gallon_us)."""
        return self.pound_moles_of_i_per_gallon_us


class ToUnitMoleFractionOfIConverter(UnitConverter):
    """MoleFractionOfI-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_mole_of_i_per_gram_mole_total(self) -> 'FieldQnty':
        """Convert to gram mole of "i" per gram mole total units."""
        unit_const: Final = field_units.MoleFractionOfIUnits.gram_mole_of_i_per_gram_mole_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mol_mathrm_i_mathrm_mol(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_mol units (alias for gram_mole_of_i_per_gram_mole_total)."""
        return self.gram_mole_of_i_per_gram_mole_total

    @property
    def kilogram_mole_of_i_per_kilogram_mole_total(self) -> 'FieldQnty':
        """Convert to kilogram mole of "i" per kilogram mole total units."""
        unit_const: Final = field_units.MoleFractionOfIUnits.kilogram_mole_of_i_per_kilogram_mole_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kmol_mathrm_i_mathrm_kmol(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_kmol units (alias for kilogram_mole_of_i_per_kilogram_mole_total)."""
        return self.kilogram_mole_of_i_per_kilogram_mole_total

    @property
    def kilomole_of_i_per_kilomole_total(self) -> 'FieldQnty':
        """Convert to kilomole of "i" per kilomole total units."""
        unit_const: Final = field_units.MoleFractionOfIUnits.kilomole_of_i_per_kilomole_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pound_mole_of_i_per_pound_mole_total(self) -> 'FieldQnty':
        """Convert to pound mole of "i" per pound mole total units."""
        unit_const: Final = field_units.MoleFractionOfIUnits.pound_mole_of_i_per_pound_mole_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_lb_mathrm_mol(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_lb_mathrm_mol units (alias for pound_mole_of_i_per_pound_mole_total)."""
        return self.pound_mole_of_i_per_pound_mole_total


class ToUnitMomentOfInertiaConverter(UnitConverter):
    """MomentOfInertia-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_force_centimeter_square_second(self) -> 'FieldQnty':
        """Convert to gram force centimeter square second units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.gram_force_centimeter_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_f_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_f_mathrm_cm_mathrm_s_2 units (alias for gram_force_centimeter_square_second)."""
        return self.gram_force_centimeter_square_second

    @property
    def gram_square_centimeter(self) -> 'FieldQnty':
        """Convert to gram square centimeter units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.gram_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2 units (alias for gram_square_centimeter)."""
        return self.gram_square_centimeter

    @property
    def kilogram_force_centimeter_square_second(self) -> 'FieldQnty':
        """Convert to kilogram force centimeter square second units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_force_centimeter_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_cm_mathrm_s_2 units (alias for kilogram_force_centimeter_square_second)."""
        return self.kilogram_force_centimeter_square_second

    @property
    def kilogram_force_meter_square_second(self) -> 'FieldQnty':
        """Convert to kilogram force meter square second units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_force_meter_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_mathrm_s_2 units (alias for kilogram_force_meter_square_second)."""
        return self.kilogram_force_meter_square_second

    @property
    def kilogram_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram square centimeter units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_cm_2 units (alias for kilogram_square_centimeter)."""
        return self.kilogram_square_centimeter

    @property
    def kilogram_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram square meter units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2 units (alias for kilogram_square_meter)."""
        return self.kilogram_square_meter

    @property
    def ounce_force_inch_square_second(self) -> 'FieldQnty':
        """Convert to ounce force inch square second units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.ounce_force_inch_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_oz_mathrm_f_in_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_oz_mathrm_f_in_mathrm_s_2 units (alias for ounce_force_inch_square_second)."""
        return self.ounce_force_inch_square_second

    @property
    def ounce_mass_square_inch(self) -> 'FieldQnty':
        """Convert to ounce mass square inch units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.ounce_mass_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def oz_in_2(self) -> 'FieldQnty':
        """Convert to oz_in_2 units (alias for ounce_mass_square_inch)."""
        return self.ounce_mass_square_inch

    @property
    def pound_mass_square_foot(self) -> 'FieldQnty':
        """Convert to pound mass square foot units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.pound_mass_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_ft_2_or_lb_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_ft_2_or_lb_sq_ft units (alias for pound_mass_square_foot)."""
        return self.pound_mass_square_foot

    @property
    def lb_ft_2(self) -> 'FieldQnty':
        """Convert to lb_ft_2 units (alias for pound_mass_square_foot)."""
        return self.pound_mass_square_foot

    @property
    def lb_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_sq_ft units (alias for pound_mass_square_foot)."""
        return self.pound_mass_square_foot

    @property
    def pound_mass_square_inch(self) -> 'FieldQnty':
        """Convert to pound mass square inch units."""
        unit_const: Final = field_units.MomentOfInertiaUnits.pound_mass_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_in_2 units (alias for pound_mass_square_inch)."""
        return self.pound_mass_square_inch


class ToUnitMomentumFlowRateConverter(UnitConverter):
    """MomentumFlowRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def foot_pounds_per_square_hour(self) -> 'FieldQnty':
        """Convert to foot pounds per square hour units."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_h_2_or_mathrm_ft_mathrm_lb_mathrm_hr_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_h_2_or_mathrm_ft_mathrm_lb_mathrm_hr_2 units (alias for foot_pounds_per_square_hour)."""
        return self.foot_pounds_per_square_hour

    @property
    def ft_lb_h_2(self) -> 'FieldQnty':
        """Convert to ft_lb_h_2 units (alias for foot_pounds_per_square_hour)."""
        return self.foot_pounds_per_square_hour

    @property
    def ft_lb_hr_2(self) -> 'FieldQnty':
        """Convert to ft_lb_hr_2 units (alias for foot_pounds_per_square_hour)."""
        return self.foot_pounds_per_square_hour

    @property
    def foot_pounds_per_square_minute(self) -> 'FieldQnty':
        """Convert to foot pounds per square minute units."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_min_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_min_2 units (alias for foot_pounds_per_square_minute)."""
        return self.foot_pounds_per_square_minute

    @property
    def foot_pounds_per_square_second(self) -> 'FieldQnty':
        """Convert to foot pounds per square second units."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_s_2_or_ft_lb_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_s_2_or_ft_lb_sec_2 units (alias for foot_pounds_per_square_second)."""
        return self.foot_pounds_per_square_second

    @property
    def ft_lb_s_2(self) -> 'FieldQnty':
        """Convert to ft_lb_s_2 units (alias for foot_pounds_per_square_second)."""
        return self.foot_pounds_per_square_second

    @property
    def ft_lb_sec_2(self) -> 'FieldQnty':
        """Convert to ft_lb_sec_2 units (alias for foot_pounds_per_square_second)."""
        return self.foot_pounds_per_square_second

    @property
    def gram_centimeters_per_square_second(self) -> 'FieldQnty':
        """Convert to gram centimeters per square second units."""
        unit_const: Final = field_units.MomentumFlowRateUnits.gram_centimeters_per_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s_2 units (alias for gram_centimeters_per_square_second)."""
        return self.gram_centimeters_per_square_second

    @property
    def kilogram_meters_per_square_second(self) -> 'FieldQnty':
        """Convert to kilogram meters per square second units."""
        unit_const: Final = field_units.MomentumFlowRateUnits.kilogram_meters_per_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_mathrm_s_2 units (alias for kilogram_meters_per_square_second)."""
        return self.kilogram_meters_per_square_second


class ToUnitMomentumFluxConverter(UnitConverter):
    """MomentumFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units."""
        unit_const: Final = field_units.MomentumFluxUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter)."""
        return self.dyne_per_square_centimeter

    @property
    def gram_per_centimeter_per_square_second(self) -> 'FieldQnty':
        """Convert to gram per centimeter per square second units."""
        unit_const: Final = field_units.MomentumFluxUnits.gram_per_centimeter_per_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s_2 units (alias for gram_per_centimeter_per_square_second)."""
        return self.gram_per_centimeter_per_square_second

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units."""
        unit_const: Final = field_units.MomentumFluxUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter)."""
        return self.newton_per_square_meter

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units."""
        unit_const: Final = field_units.MomentumFluxUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_sq_mathrm_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_sq_mathrm_ft units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def pound_mass_per_foot_per_square_second(self) -> 'FieldQnty':
        """Convert to pound mass per foot per square second units."""
        unit_const: Final = field_units.MomentumFluxUnits.pound_mass_per_foot_per_square_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_m_mathrm_ft_mathrm_s_2_or_mathrm_lb_mathrm_ft_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_m_mathrm_ft_mathrm_s_2_or_mathrm_lb_mathrm_ft_mathrm_sec_2 units (alias for pound_mass_per_foot_per_square_second)."""
        return self.pound_mass_per_foot_per_square_second

    @property
    def lb_m_ft_s_2(self) -> 'FieldQnty':
        """Convert to lb_m_ft_s_2 units (alias for pound_mass_per_foot_per_square_second)."""
        return self.pound_mass_per_foot_per_square_second

    @property
    def lb_ft_sec_2(self) -> 'FieldQnty':
        """Convert to lb_ft_sec_2 units (alias for pound_mass_per_foot_per_square_second)."""
        return self.pound_mass_per_foot_per_square_second


class ToUnitNormalityOfSolutionConverter(UnitConverter):
    """NormalityOfSolution-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_equivalents_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram equivalents per cubic meter units."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.gram_equivalents_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_eq_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_eq_mathrm_m_3 units (alias for gram_equivalents_per_cubic_meter)."""
        return self.gram_equivalents_per_cubic_meter

    @property
    def gram_equivalents_per_liter(self) -> 'FieldQnty':
        """Convert to gram equivalents per liter units."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.gram_equivalents_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def eq_l(self) -> 'FieldQnty':
        """Convert to eq_l units (alias for gram_equivalents_per_liter)."""
        return self.gram_equivalents_per_liter

    @property
    def pound_equivalents_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound equivalents per cubic foot units."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.pound_equivalents_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_eq_mathrm_ft_3_or_lb_eq_cft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_eq_mathrm_ft_3_or_lb_eq_cft units (alias for pound_equivalents_per_cubic_foot)."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def lb_eq_ft_3(self) -> 'FieldQnty':
        """Convert to lb_eq_ft_3 units (alias for pound_equivalents_per_cubic_foot)."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def lb_eq_cft(self) -> 'FieldQnty':
        """Convert to lb_eq_cft units (alias for pound_equivalents_per_cubic_foot)."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def pound_equivalents_per_gallon(self) -> 'FieldQnty':
        """Convert to pound equivalents per gallon units."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.pound_equivalents_per_gallon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_eq_gal_US(self) -> 'FieldQnty':
        """Convert to lb_eq_gal_US units (alias for pound_equivalents_per_gallon)."""
        return self.pound_equivalents_per_gallon


class ToUnitParticleDensityConverter(UnitConverter):
    """ParticleDensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def particles_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to particles per cubic centimeter units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_cm_3_or_part_cc(self) -> 'FieldQnty':
        """Convert to part_cm_3_or_part_cc units (alias for particles_per_cubic_centimeter)."""
        return self.particles_per_cubic_centimeter

    @property
    def part_cm_3(self) -> 'FieldQnty':
        """Convert to part_cm_3 units (alias for particles_per_cubic_centimeter)."""
        return self.particles_per_cubic_centimeter

    @property
    def part_cc(self) -> 'FieldQnty':
        """Convert to part_cc units (alias for particles_per_cubic_centimeter)."""
        return self.particles_per_cubic_centimeter

    @property
    def particles_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to particles per cubic foot units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_mathrm_ft_3_or_part_cft(self) -> 'FieldQnty':
        """Convert to part_mathrm_ft_3_or_part_cft units (alias for particles_per_cubic_foot)."""
        return self.particles_per_cubic_foot

    @property
    def part_ft_3(self) -> 'FieldQnty':
        """Convert to part_ft_3 units (alias for particles_per_cubic_foot)."""
        return self.particles_per_cubic_foot

    @property
    def part_cft(self) -> 'FieldQnty':
        """Convert to part_cft units (alias for particles_per_cubic_foot)."""
        return self.particles_per_cubic_foot

    @property
    def particles_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to particles per cubic meter units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to part_mathrm_m_3 units (alias for particles_per_cubic_meter)."""
        return self.particles_per_cubic_meter

    @property
    def particles_per_gallon_us(self) -> 'FieldQnty':
        """Convert to particles per gallon (US) units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_gal(self) -> 'FieldQnty':
        """Convert to part_gal units (alias for particles_per_gallon_us)."""
        return self.particles_per_gallon_us

    @property
    def particles_per_liter(self) -> 'FieldQnty':
        """Convert to particles per liter units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_l(self) -> 'FieldQnty':
        """Convert to part_l units (alias for particles_per_liter)."""
        return self.particles_per_liter

    @property
    def particles_per_milliliter(self) -> 'FieldQnty':
        """Convert to particles per milliliter units."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_milliliter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def part_ml(self) -> 'FieldQnty':
        """Convert to part_ml units (alias for particles_per_milliliter)."""
        return self.particles_per_milliliter


class ToUnitPercentConverter(UnitConverter):
    """Percent-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def percent(self) -> 'FieldQnty':
        """Convert to percent units."""
        unit_const: Final = field_units.PercentUnits.percent
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for percent)."""
        return self.percent

    @property
    def per_mille(self) -> 'FieldQnty':
        """Convert to per mille units."""
        unit_const: Final = field_units.PercentUnits.per_mille
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def basis_point(self) -> 'FieldQnty':
        """Convert to basis point units."""
        unit_const: Final = field_units.PercentUnits.basis_point
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def bp(self) -> 'FieldQnty':
        """Convert to bp units (alias for basis_point)."""
        return self.basis_point

    @property
    def bps(self) -> 'FieldQnty':
        """Convert to bps units (alias for basis_point)."""
        return self.basis_point


class ToUnitPermeabilityConverter(UnitConverter):
    """Permeability-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def darcy(self) -> 'FieldQnty':
        """Convert to darcy units."""
        unit_const: Final = field_units.PermeabilityUnits.darcy
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def square_feet(self) -> 'FieldQnty':
        """Convert to square feet units."""
        unit_const: Final = field_units.PermeabilityUnits.square_feet
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_or_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_or_sq_ft units (alias for square_feet)."""
        return self.square_feet

    @property
    def ft_2(self) -> 'FieldQnty':
        """Convert to ft_2 units (alias for square_feet)."""
        return self.square_feet

    @property
    def sq_ft(self) -> 'FieldQnty':
        """Convert to sq_ft units (alias for square_feet)."""
        return self.square_feet

    @property
    def square_meters(self) -> 'FieldQnty':
        """Convert to square meters units."""
        unit_const: Final = field_units.PermeabilityUnits.square_meters
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2 units (alias for square_meters)."""
        return self.square_meters


class ToUnitPhotonEmissionRateConverter(UnitConverter):
    """PhotonEmissionRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def rayleigh(self) -> 'FieldQnty':
        """Convert to rayleigh units."""
        unit_const: Final = field_units.PhotonEmissionRateUnits.rayleigh
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def R(self) -> 'FieldQnty':
        """Convert to R units (alias for rayleigh)."""
        return self.rayleigh

    @property
    def reciprocal_square_meter_second(self) -> 'FieldQnty':
        """Convert to reciprocal square meter second units."""
        unit_const: Final = field_units.PhotonEmissionRateUnits.reciprocal_square_meter_second
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitPowerPerUnitMassConverter(UnitConverter):
    """PowerPerUnitMass-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_hour_per_pound_mass(self) -> 'FieldQnty':
        """Convert to British thermal unit per hour per pound mass units."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.british_thermal_unit_per_hour_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_h_lb_or_Btu_lb_hr(self) -> 'FieldQnty':
        """Convert to Btu_h_lb_or_Btu_lb_hr units (alias for british_thermal_unit_per_hour_per_pound_mass)."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def Btu_h_lb(self) -> 'FieldQnty':
        """Convert to Btu_h_lb units (alias for british_thermal_unit_per_hour_per_pound_mass)."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def Btu_lb_hr(self) -> 'FieldQnty':
        """Convert to Btu_lb_hr units (alias for british_thermal_unit_per_hour_per_pound_mass)."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def calorie_per_second_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per second per gram units."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.calorie_per_second_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_s_g_or_cal_g_sec(self) -> 'FieldQnty':
        """Convert to cal_s_g_or_cal_g_sec units (alias for calorie_per_second_per_gram)."""
        return self.calorie_per_second_per_gram

    @property
    def cal_s_g(self) -> 'FieldQnty':
        """Convert to cal_s_g units (alias for calorie_per_second_per_gram)."""
        return self.calorie_per_second_per_gram

    @property
    def cal_g_sec(self) -> 'FieldQnty':
        """Convert to cal_g_sec units (alias for calorie_per_second_per_gram)."""
        return self.calorie_per_second_per_gram

    @property
    def kilocalorie_per_hour_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per kilogram units."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.kilocalorie_per_hour_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kcal_h_kg_or_kcal_kg_hr(self) -> 'FieldQnty':
        """Convert to kcal_h_kg_or_kcal_kg_hr units (alias for kilocalorie_per_hour_per_kilogram)."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def kcal_h_kg(self) -> 'FieldQnty':
        """Convert to kcal_h_kg units (alias for kilocalorie_per_hour_per_kilogram)."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def kcal_kg_hr(self) -> 'FieldQnty':
        """Convert to kcal_kg_hr units (alias for kilocalorie_per_hour_per_kilogram)."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def watt_per_kilogram(self) -> 'FieldQnty':
        """Convert to watt per kilogram units."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.watt_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def W_kg(self) -> 'FieldQnty':
        """Convert to W_kg units (alias for watt_per_kilogram)."""
        return self.watt_per_kilogram


class ToUnitPowerPerUnitVolumeConverter(UnitConverter):
    """PowerPerUnitVolume-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per hour per cubic foot units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.british_thermal_unit_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_mathrm_h_mathrm_ft_3_or_mathrm_Btu_mathrm_hr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_h_mathrm_ft_3_or_mathrm_Btu_mathrm_hr_cft units (alias for british_thermal_unit_per_hour_per_cubic_foot)."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def Btu_h_ft_3(self) -> 'FieldQnty':
        """Convert to Btu_h_ft_3 units (alias for british_thermal_unit_per_hour_per_cubic_foot)."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def Btu_hr_cft(self) -> 'FieldQnty':
        """Convert to Btu_hr_cft units (alias for british_thermal_unit_per_hour_per_cubic_foot)."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def calorie_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to calorie per second per cubic centimeter units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.calorie_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_s_mathrm_cm_3_or_mathrm_cal_mathrm_s_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_s_mathrm_cm_3_or_mathrm_cal_mathrm_s_mathrm_cc units (alias for calorie_per_second_per_cubic_centimeter)."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def cal_s_cm_3(self) -> 'FieldQnty':
        """Convert to cal_s_cm_3 units (alias for calorie_per_second_per_cubic_centimeter)."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def cal_s_cc(self) -> 'FieldQnty':
        """Convert to cal_s_cc units (alias for calorie_per_second_per_cubic_centimeter)."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def chu_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to Chu per hour per cubic foot units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.chu_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_h_ft3_or_Chu_hr_cft(self) -> 'FieldQnty':
        """Convert to Chu_h_ft3_or_Chu_hr_cft units (alias for chu_per_hour_per_cubic_foot)."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def Chu_h_ft3(self) -> 'FieldQnty':
        """Convert to Chu_h_ft3 units (alias for chu_per_hour_per_cubic_foot)."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def Chu_hr_cft(self) -> 'FieldQnty':
        """Convert to Chu_hr_cft units (alias for chu_per_hour_per_cubic_foot)."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def kilocalorie_per_hour_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per cubic centimeter units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_hour_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_mathrm_h_mathrm_cm_3_or_mathrm_kcal_hr_cc(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_h_mathrm_cm_3_or_mathrm_kcal_hr_cc units (alias for kilocalorie_per_hour_per_cubic_centimeter)."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kcal_h_cm_3(self) -> 'FieldQnty':
        """Convert to kcal_h_cm_3 units (alias for kilocalorie_per_hour_per_cubic_centimeter)."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kcal_hr_cc(self) -> 'FieldQnty':
        """Convert to kcal_hr_cc units (alias for kilocalorie_per_hour_per_cubic_centimeter)."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kilocalorie_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per cubic foot units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_mathrm_h_mathrm_ft_3_or_mathrm_kcal_mathrm_hr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_h_mathrm_ft_3_or_mathrm_kcal_mathrm_hr_cft units (alias for kilocalorie_per_hour_per_cubic_foot)."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kcal_h_ft_3(self) -> 'FieldQnty':
        """Convert to kcal_h_ft_3 units (alias for kilocalorie_per_hour_per_cubic_foot)."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kcal_hr_cft(self) -> 'FieldQnty':
        """Convert to kcal_hr_cft units (alias for kilocalorie_per_hour_per_cubic_foot)."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kilocalorie_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilocalorie per second per cubic centimeter units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kcal_s_cm_3_or_kcal_s_cc(self) -> 'FieldQnty':
        """Convert to kcal_s_cm_3_or_kcal_s_cc units (alias for kilocalorie_per_second_per_cubic_centimeter)."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def kcal_s_cm_3(self) -> 'FieldQnty':
        """Convert to kcal_s_cm_3 units (alias for kilocalorie_per_second_per_cubic_centimeter)."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def kcal_s_cc(self) -> 'FieldQnty':
        """Convert to kcal_s_cc units (alias for kilocalorie_per_second_per_cubic_centimeter)."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def watt_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to watt per cubic meter units."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.watt_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_W_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_W_mathrm_m_3 units (alias for watt_per_cubic_meter)."""
        return self.watt_per_cubic_meter


class ToUnitPowerThermalDutyConverter(UnitConverter):
    """PowerThermalDuty-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def abwatt_emu_of_power(self) -> 'FieldQnty':
        """Convert to abwatt (emu of power) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.abwatt_emu_of_power
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def emu(self) -> 'FieldQnty':
        """Convert to emu units (alias for abwatt_emu_of_power)."""
        return self.abwatt_emu_of_power

    @property
    def boiler_horsepower(self) -> 'FieldQnty':
        """Convert to boiler horsepower units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.boiler_horsepower
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP_boiler(self) -> 'FieldQnty':
        """Convert to HP_boiler units (alias for boiler_horsepower)."""
        return self.boiler_horsepower

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_mean_hr_or_Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_mean_hr_or_Btu_hr units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def Btu_mean_hr(self) -> 'FieldQnty':
        """Convert to Btu_mean_hr units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_hr units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_thermochemical(self) -> 'FieldQnty':
        """Convert to British thermal unit (thermochemical) per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.british_thermal_unit_thermochemical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_therm_hr_or_Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_therm_hr_or_Btu_hr units (alias for british_thermal_unit_thermochemical)."""
        return self.british_thermal_unit_thermochemical

    @property
    def Btu_therm_hr(self) -> 'FieldQnty':
        """Convert to Btu_therm_hr units (alias for british_thermal_unit_thermochemical)."""
        return self.british_thermal_unit_thermochemical

    @property
    def calorie_mean(self) -> 'FieldQnty':
        """Convert to calorie (mean) per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.calorie_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_mean_hr(self) -> 'FieldQnty':
        """Convert to cal_mean_hr units (alias for calorie_mean)."""
        return self.calorie_mean

    @property
    def calorie_thermochemical(self) -> 'FieldQnty':
        """Convert to calorie (thermochemical) per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.calorie_thermochemical
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_therm_hr(self) -> 'FieldQnty':
        """Convert to cal_therm_hr units (alias for calorie_thermochemical)."""
        return self.calorie_thermochemical

    @property
    def donkey(self) -> 'FieldQnty':
        """Convert to donkey units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.donkey
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def erg_per_second(self) -> 'FieldQnty':
        """Convert to erg per second units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.erg_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def erg_s(self) -> 'FieldQnty':
        """Convert to erg_s units (alias for erg_per_second)."""
        return self.erg_per_second

    @property
    def foot_pondal_per_second(self) -> 'FieldQnty':
        """Convert to foot pondal per second units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pondal_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_pdl_s(self) -> 'FieldQnty':
        """Convert to ft_pdl_s units (alias for foot_pondal_per_second)."""
        return self.foot_pondal_per_second

    @property
    def foot_pound_force_per_hour(self) -> 'FieldQnty':
        """Convert to foot pound force per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_hr units (alias for foot_pound_force_per_hour)."""
        return self.foot_pound_force_per_hour

    @property
    def foot_pound_force_per_minute(self) -> 'FieldQnty':
        """Convert to foot pound force per minute units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_min units (alias for foot_pound_force_per_minute)."""
        return self.foot_pound_force_per_minute

    @property
    def foot_pound_force_per_second(self) -> 'FieldQnty':
        """Convert to foot pound force per second units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_s units (alias for foot_pound_force_per_second)."""
        return self.foot_pound_force_per_second

    @property
    def horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms(self) -> 'FieldQnty':
        """Convert to horsepower ( $550 \\mathrm{ft} \\mathrm{lb}_{\\mathrm{f}} / \\mathrm{s}$ ) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP(self) -> 'FieldQnty':
        """Convert to HP units (alias for horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms)."""
        return self.horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms

    @property
    def horsepower_electric(self) -> 'FieldQnty':
        """Convert to horsepower (electric) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_electric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP_elect(self) -> 'FieldQnty':
        """Convert to HP_elect units (alias for horsepower_electric)."""
        return self.horsepower_electric

    @property
    def horsepower_uk(self) -> 'FieldQnty':
        """Convert to horsepower (UK) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP_UK(self) -> 'FieldQnty':
        """Convert to HP_UK units (alias for horsepower_uk)."""
        return self.horsepower_uk

    @property
    def kcal_per_hour(self) -> 'FieldQnty':
        """Convert to kcal per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kcal_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kcal_hr(self) -> 'FieldQnty':
        """Convert to kcal_hr units (alias for kcal_per_hour)."""
        return self.kcal_per_hour

    @property
    def kilogram_force_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram force meter per second units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kilogram_force_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_mathrm_s units (alias for kilogram_force_meter_per_second)."""
        return self.kilogram_force_meter_per_second

    @property
    def kilowatt(self) -> 'FieldQnty':
        """Convert to kilowatt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kilowatt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kW(self) -> 'FieldQnty':
        """Convert to kW units (alias for kilowatt)."""
        return self.kilowatt

    @property
    def megawatt(self) -> 'FieldQnty':
        """Convert to megawatt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.megawatt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MW(self) -> 'FieldQnty':
        """Convert to MW units (alias for megawatt)."""
        return self.megawatt

    @property
    def metric_horsepower(self) -> 'FieldQnty':
        """Convert to metric horsepower units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.metric_horsepower
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP_metric(self) -> 'FieldQnty':
        """Convert to HP_metric units (alias for metric_horsepower)."""
        return self.metric_horsepower

    @property
    def million_british_thermal_units_per_hour_petroleum(self) -> 'FieldQnty':
        """Convert to million British thermal units per hour (petroleum) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.million_british_thermal_units_per_hour_petroleum
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MMBtu_hr(self) -> 'FieldQnty':
        """Convert to MMBtu_hr units (alias for million_british_thermal_units_per_hour_petroleum)."""
        return self.million_british_thermal_units_per_hour_petroleum

    @property
    def million_kilocalorie_per_hour(self) -> 'FieldQnty':
        """Convert to million kilocalorie per hour units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.million_kilocalorie_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MM_kcal_hr(self) -> 'FieldQnty':
        """Convert to MM_kcal_hr units (alias for million_kilocalorie_per_hour)."""
        return self.million_kilocalorie_per_hour

    @property
    def prony(self) -> 'FieldQnty':
        """Convert to prony units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.prony
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ton_of_refrigeration_us(self) -> 'FieldQnty':
        """Convert to ton of refrigeration (US) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.ton_of_refrigeration_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def CTR_US(self) -> 'FieldQnty':
        """Convert to CTR_US units (alias for ton_of_refrigeration_us)."""
        return self.ton_of_refrigeration_us

    @property
    def ton_or_refrigeration_uk(self) -> 'FieldQnty':
        """Convert to ton or refrigeration (UK) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.ton_or_refrigeration_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def CTR_UK(self) -> 'FieldQnty':
        """Convert to CTR_UK units (alias for ton_or_refrigeration_uk)."""
        return self.ton_or_refrigeration_uk

    @property
    def volt_ampere(self) -> 'FieldQnty':
        """Convert to volt-ampere units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.volt_ampere
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def VA(self) -> 'FieldQnty':
        """Convert to VA units (alias for volt_ampere)."""
        return self.volt_ampere

    @property
    def water_horsepower(self) -> 'FieldQnty':
        """Convert to water horsepower units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.water_horsepower
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def HP_water(self) -> 'FieldQnty':
        """Convert to HP_water units (alias for water_horsepower)."""
        return self.water_horsepower

    @property
    def watt(self) -> 'FieldQnty':
        """Convert to watt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def W(self) -> 'FieldQnty':
        """Convert to W units (alias for watt)."""
        return self.watt

    @property
    def watt_international_mean(self) -> 'FieldQnty':
        """Convert to watt (international, mean) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt_international_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def W_int_mean(self) -> 'FieldQnty':
        """Convert to W_int_mean units (alias for watt_international_mean)."""
        return self.watt_international_mean

    @property
    def watt_international_us(self) -> 'FieldQnty':
        """Convert to watt (international, US) units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt_international_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def watt_int_US(self) -> 'FieldQnty':
        """Convert to watt_int_US units (alias for watt_international_us)."""
        return self.watt_international_us

    @property
    def gigawatt(self) -> 'FieldQnty':
        """Convert to gigawatt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.gigawatt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def GW(self) -> 'FieldQnty':
        """Convert to GW units (alias for gigawatt)."""
        return self.gigawatt

    @property
    def milliwatt(self) -> 'FieldQnty':
        """Convert to milliwatt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.milliwatt
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mW(self) -> 'FieldQnty':
        """Convert to mW units (alias for milliwatt)."""
        return self.milliwatt

    @property
    def microwatt(self) -> 'FieldQnty':
        """Convert to microwatt units."""
        unit_const: Final = field_units.PowerThermalDutyUnits.microwatt
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitPressureConverter(UnitConverter):
    """Pressure-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def atmosphere_standard(self) -> 'FieldQnty':
        """Convert to atmosphere, standard units."""
        unit_const: Final = field_units.PressureUnits.atmosphere_standard
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def atm(self) -> 'FieldQnty':
        """Convert to atm units (alias for atmosphere_standard)."""
        return self.atmosphere_standard

    @property
    def bar(self) -> 'FieldQnty':
        """Convert to bar units."""
        unit_const: Final = field_units.PressureUnits.bar
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def barye(self) -> 'FieldQnty':
        """Convert to barye units."""
        unit_const: Final = field_units.PressureUnits.barye
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units."""
        unit_const: Final = field_units.PressureUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter)."""
        return self.dyne_per_square_centimeter

    @property
    def foot_of_mercury_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to foot of mercury ( $60{ }^{\\circ} \\mathrm{F}$ ) units."""
        unit_const: Final = field_units.PressureUnits.foot_of_mercury_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_Hg_60_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to ft_Hg_60_circ_mathrm_F units (alias for foot_of_mercury_60_circ_mathrmf)."""
        return self.foot_of_mercury_60_circ_mathrmf

    @property
    def foot_of_water_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to foot of water ( $60{ }^{\\circ} \\mathrm{F}$ ) units."""
        unit_const: Final = field_units.PressureUnits.foot_of_water_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to ft_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right units (alias for foot_of_water_60_circ_mathrmf)."""
        return self.foot_of_water_60_circ_mathrmf

    @property
    def gigapascal(self) -> 'FieldQnty':
        """Convert to gigapascal units."""
        unit_const: Final = field_units.PressureUnits.gigapascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def GPa(self) -> 'FieldQnty':
        """Convert to GPa units (alias for gigapascal)."""
        return self.gigapascal

    @property
    def hectopascal(self) -> 'FieldQnty':
        """Convert to hectopascal units."""
        unit_const: Final = field_units.PressureUnits.hectopascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def hPa(self) -> 'FieldQnty':
        """Convert to hPa units (alias for hectopascal)."""
        return self.hectopascal

    @property
    def inch_of_mercury_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to inch of mercury ( $60{ }^{\\circ} \\mathrm{F}$ ) units."""
        unit_const: Final = field_units.PressureUnits.inch_of_mercury_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_mathrm_Hg_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to in_mathrm_Hg_left_60_circ_mathrm_F_right units (alias for inch_of_mercury_60_circ_mathrmf)."""
        return self.inch_of_mercury_60_circ_mathrmf

    @property
    def inch_of_water_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to inch of water ( $60{ }^{\\circ} \\mathrm{F}$ ) units."""
        unit_const: Final = field_units.PressureUnits.inch_of_water_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to in_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right units (alias for inch_of_water_60_circ_mathrmf)."""
        return self.inch_of_water_60_circ_mathrmf

    @property
    def kilogram_force_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per square centimeter units."""
        unit_const: Final = field_units.PressureUnits.kilogram_force_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to at_or_mathrm_kg_mathrm_f_mathrm_cm_2 units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def at(self) -> 'FieldQnty':
        """Convert to at units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kg_f_cm_2(self) -> 'FieldQnty':
        """Convert to kg_f_cm_2 units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kilogram_force_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per square meter units."""
        unit_const: Final = field_units.PressureUnits.kilogram_force_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_2 units (alias for kilogram_force_per_square_meter)."""
        return self.kilogram_force_per_square_meter

    @property
    def kip_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to kip force per square inch units."""
        unit_const: Final = field_units.PressureUnits.kip_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to KSI_or_ksi_or_kip_f_mathrm_in_2 units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def KSI(self) -> 'FieldQnty':
        """Convert to KSI units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def ksi(self) -> 'FieldQnty':
        """Convert to ksi units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def kip_f_in_2(self) -> 'FieldQnty':
        """Convert to kip_f_in_2 units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def megapascal(self) -> 'FieldQnty':
        """Convert to megapascal units."""
        unit_const: Final = field_units.PressureUnits.megapascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MPa(self) -> 'FieldQnty':
        """Convert to MPa units (alias for megapascal)."""
        return self.megapascal

    @property
    def meter_of_water_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to meter of water ( $4^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.PressureUnits.meter_of_water_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right units (alias for meter_of_water_4circ_mathrmc)."""
        return self.meter_of_water_4circ_mathrmc

    @property
    def microbar(self) -> 'FieldQnty':
        """Convert to microbar units."""
        unit_const: Final = field_units.PressureUnits.microbar
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_bar(self) -> 'FieldQnty':
        """Convert to mu_mathrm_bar units (alias for microbar)."""
        return self.microbar

    @property
    def millibar(self) -> 'FieldQnty':
        """Convert to millibar units."""
        unit_const: Final = field_units.PressureUnits.millibar
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mbar(self) -> 'FieldQnty':
        """Convert to mbar units (alias for millibar)."""
        return self.millibar

    @property
    def millimeter_of_mercury_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to millimeter of mercury ( $4^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.PressureUnits.millimeter_of_mercury_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mm_mathrm_Hg_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_mm_mathrm_Hg_left_4_circ_mathrm_C_right units (alias for millimeter_of_mercury_4circ_mathrmc)."""
        return self.millimeter_of_mercury_4circ_mathrmc

    @property
    def millimeter_of_water_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to millimeter of water ( $4^{\\circ} \\mathrm{C}$ ) units."""
        unit_const: Final = field_units.PressureUnits.millimeter_of_water_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mm_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_mm_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right units (alias for millimeter_of_water_4circ_mathrmc)."""
        return self.millimeter_of_water_4circ_mathrmc

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units."""
        unit_const: Final = field_units.PressureUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter)."""
        return self.newton_per_square_meter

    @property
    def ounce_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to ounce force per square inch units."""
        unit_const: Final = field_units.PressureUnits.ounce_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2 units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def OSI(self) -> 'FieldQnty':
        """Convert to OSI units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def osi(self) -> 'FieldQnty':
        """Convert to osi units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def pascal(self) -> 'FieldQnty':
        """Convert to pascal units."""
        unit_const: Final = field_units.PressureUnits.pascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Pa(self) -> 'FieldQnty':
        """Convert to Pa units (alias for pascal)."""
        return self.pascal

    @property
    def pi_ze(self) -> 'FieldQnty':
        """Convert to pièze units."""
        unit_const: Final = field_units.PressureUnits.pi_ze
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pz(self) -> 'FieldQnty':
        """Convert to pz units (alias for pi_ze)."""
        return self.pi_ze

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units."""
        unit_const: Final = field_units.PressureUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2 units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def psf(self) -> 'FieldQnty':
        """Convert to psf units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def pound_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to pound force per square inch units."""
        unit_const: Final = field_units.PressureUnits.pound_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def psi(self) -> 'FieldQnty':
        """Convert to psi units (alias for pound_force_per_square_inch)."""
        return self.pound_force_per_square_inch

    @property
    def torr(self) -> 'FieldQnty':
        """Convert to torr units."""
        unit_const: Final = field_units.PressureUnits.torr
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def torr_or_mm_Hg_0_circ_C(self) -> 'FieldQnty':
        """Convert to torr_or_mm_Hg_0_circ_C units (alias for torr)."""
        return self.torr

    @property
    def mm_Hg_0_circ_C(self) -> 'FieldQnty':
        """Convert to mm_Hg_0_circ_C units (alias for torr)."""
        return self.torr

    @property
    def kilopascal(self) -> 'FieldQnty':
        """Convert to kilopascal units."""
        unit_const: Final = field_units.PressureUnits.kilopascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kPa(self) -> 'FieldQnty':
        """Convert to kPa units (alias for kilopascal)."""
        return self.kilopascal


class ToUnitRadiationDoseEquivalentConverter(UnitConverter):
    """RadiationDoseEquivalent-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def rem(self) -> 'FieldQnty':
        """Convert to rem units."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.rem
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sievert(self) -> 'FieldQnty':
        """Convert to sievert units."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.sievert
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Sv(self) -> 'FieldQnty':
        """Convert to Sv units (alias for sievert)."""
        return self.sievert

    @property
    def millisievert(self) -> 'FieldQnty':
        """Convert to millisievert units."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.millisievert
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mSv(self) -> 'FieldQnty':
        """Convert to mSv units (alias for millisievert)."""
        return self.millisievert

    @property
    def microsievert(self) -> 'FieldQnty':
        """Convert to microsievert units."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.microsievert
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitRadiationExposureConverter(UnitConverter):
    """RadiationExposure-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def coulomb_per_kilogram(self) -> 'FieldQnty':
        """Convert to coulomb per kilogram units."""
        unit_const: Final = field_units.RadiationExposureUnits.coulomb_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def C_kg(self) -> 'FieldQnty':
        """Convert to C_kg units (alias for coulomb_per_kilogram)."""
        return self.coulomb_per_kilogram

    @property
    def d_unit(self) -> 'FieldQnty':
        """Convert to D unit units."""
        unit_const: Final = field_units.RadiationExposureUnits.d_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def D_unit(self) -> 'FieldQnty':
        """Convert to D_unit units (alias for d_unit)."""
        return self.d_unit

    @property
    def pastille_dose_b_unit(self) -> 'FieldQnty':
        """Convert to pastille dose (B unit) units."""
        unit_const: Final = field_units.RadiationExposureUnits.pastille_dose_b_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def B_unit(self) -> 'FieldQnty':
        """Convert to B_unit units (alias for pastille_dose_b_unit)."""
        return self.pastille_dose_b_unit

    @property
    def r_entgen(self) -> 'FieldQnty':
        """Convert to röentgen units."""
        unit_const: Final = field_units.RadiationExposureUnits.r_entgen
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def R(self) -> 'FieldQnty':
        """Convert to R units (alias for r_entgen)."""
        return self.r_entgen


class ToUnitRadioactivityConverter(UnitConverter):
    """Radioactivity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def becquerel(self) -> 'FieldQnty':
        """Convert to becquerel units."""
        unit_const: Final = field_units.RadioactivityUnits.becquerel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Bq(self) -> 'FieldQnty':
        """Convert to Bq units (alias for becquerel)."""
        return self.becquerel

    @property
    def curie(self) -> 'FieldQnty':
        """Convert to curie units."""
        unit_const: Final = field_units.RadioactivityUnits.curie
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Ci(self) -> 'FieldQnty':
        """Convert to Ci units (alias for curie)."""
        return self.curie

    @property
    def mache_unit(self) -> 'FieldQnty':
        """Convert to Mache unit units."""
        unit_const: Final = field_units.RadioactivityUnits.mache_unit
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Mache(self) -> 'FieldQnty':
        """Convert to Mache units (alias for mache_unit)."""
        return self.mache_unit

    @property
    def rutherford(self) -> 'FieldQnty':
        """Convert to rutherford units."""
        unit_const: Final = field_units.RadioactivityUnits.rutherford
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Rd(self) -> 'FieldQnty':
        """Convert to Rd units (alias for rutherford)."""
        return self.rutherford

    @property
    def stat(self) -> 'FieldQnty':
        """Convert to stat units."""
        unit_const: Final = field_units.RadioactivityUnits.stat
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kilobecquerel(self) -> 'FieldQnty':
        """Convert to kilobecquerel units."""
        unit_const: Final = field_units.RadioactivityUnits.kilobecquerel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kBq(self) -> 'FieldQnty':
        """Convert to kBq units (alias for kilobecquerel)."""
        return self.kilobecquerel

    @property
    def megabecquerel(self) -> 'FieldQnty':
        """Convert to megabecquerel units."""
        unit_const: Final = field_units.RadioactivityUnits.megabecquerel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MBq(self) -> 'FieldQnty':
        """Convert to MBq units (alias for megabecquerel)."""
        return self.megabecquerel

    @property
    def gigabecquerel(self) -> 'FieldQnty':
        """Convert to gigabecquerel units."""
        unit_const: Final = field_units.RadioactivityUnits.gigabecquerel
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def GBq(self) -> 'FieldQnty':
        """Convert to GBq units (alias for gigabecquerel)."""
        return self.gigabecquerel


class ToUnitSecondMomentOfAreaConverter(UnitConverter):
    """SecondMomentOfArea-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def inch_quadrupled(self) -> 'FieldQnty':
        """Convert to inch quadrupled units."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.inch_quadrupled
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_4(self) -> 'FieldQnty':
        """Convert to in_4 units (alias for inch_quadrupled)."""
        return self.inch_quadrupled

    @property
    def centimeter_quadrupled(self) -> 'FieldQnty':
        """Convert to centimeter quadrupled units."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.centimeter_quadrupled
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_4(self) -> 'FieldQnty':
        """Convert to mathrm_cm_4 units (alias for centimeter_quadrupled)."""
        return self.centimeter_quadrupled

    @property
    def foot_quadrupled(self) -> 'FieldQnty':
        """Convert to foot quadrupled units."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.foot_quadrupled
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_4(self) -> 'FieldQnty':
        """Convert to mathrm_ft_4 units (alias for foot_quadrupled)."""
        return self.foot_quadrupled

    @property
    def meter_quadrupled(self) -> 'FieldQnty':
        """Convert to meter quadrupled units."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.meter_quadrupled
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_4(self) -> 'FieldQnty':
        """Convert to mathrm_m_4 units (alias for meter_quadrupled)."""
        return self.meter_quadrupled


class ToUnitSecondRadiationConstantPlanckConverter(UnitConverter):
    """SecondRadiationConstantPlanck-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def meter_kelvin(self) -> 'FieldQnty':
        """Convert to meter kelvin units."""
        unit_const: Final = field_units.SecondRadiationConstantPlanckUnits.meter_kelvin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m_K(self) -> 'FieldQnty':
        """Convert to m_K units (alias for meter_kelvin)."""
        return self.meter_kelvin


class ToUnitSpecificEnthalpyConverter(UnitConverter):
    """SpecificEnthalpy-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per pound units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_mean_lb(self) -> 'FieldQnty':
        """Convert to Btu_mean_lb units (alias for british_thermal_unit_mean)."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound)."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram)."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound)."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram)."""
        return self.joule_per_kilogram

    @property
    def kilojoule_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilojoule per kilogram units."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.kilojoule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kJ_kg(self) -> 'FieldQnty':
        """Convert to kJ_kg units (alias for kilojoule_per_kilogram)."""
        return self.kilojoule_per_kilogram


class ToUnitSpecificGravityConverter(UnitConverter):
    """SpecificGravity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dimensionless(self) -> 'FieldQnty':
        """Convert to Dimensionless units."""
        unit_const: Final = field_units.SpecificGravityUnits.dimensionless
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Dmls(self) -> 'FieldQnty':
        """Convert to Dmls units (alias for dimensionless)."""
        return self.dimensionless


class ToUnitSpecificHeatCapacityConstantPressureConverter(UnitConverter):
    """SpecificHeatCapacityConstantPressure-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_per_pound_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to Btu per pound per degree Fahrenheit (or degree Rankine) units."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.btu_per_pound_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_lb_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_lb_circ_mathrm_F units (alias for btu_per_pound_per_degree_fahrenheit_or_degree_rankine)."""
        return self.btu_per_pound_per_degree_fahrenheit_or_degree_rankine

    @property
    def calories_per_gram_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to calories per gram per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.calories_per_gram_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cal_g_K(self) -> 'FieldQnty':
        """Convert to cal_g_K units (alias for calories_per_gram_per_kelvin_or_degree_celsius)."""
        return self.calories_per_gram_per_kelvin_or_degree_celsius

    @property
    def joules_per_kilogram_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to joules per kilogram per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.joules_per_kilogram_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_kg_K(self) -> 'FieldQnty':
        """Convert to J_kg_K units (alias for joules_per_kilogram_per_kelvin_or_degree_celsius)."""
        return self.joules_per_kilogram_per_kelvin_or_degree_celsius


class ToUnitSpecificLengthConverter(UnitConverter):
    """SpecificLength-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to centimeter per gram units."""
        unit_const: Final = field_units.SpecificLengthUnits.centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cm_g(self) -> 'FieldQnty':
        """Convert to cm_g units (alias for centimeter_per_gram)."""
        return self.centimeter_per_gram

    @property
    def cotton_count(self) -> 'FieldQnty':
        """Convert to cotton count units."""
        unit_const: Final = field_units.SpecificLengthUnits.cotton_count
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for cotton_count)."""
        return self.cotton_count

    @property
    def ft_per_pound(self) -> 'FieldQnty':
        """Convert to ft per pound units."""
        unit_const: Final = field_units.SpecificLengthUnits.ft_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_lb(self) -> 'FieldQnty':
        """Convert to ft_lb units (alias for ft_per_pound)."""
        return self.ft_per_pound

    @property
    def meters_per_kilogram(self) -> 'FieldQnty':
        """Convert to meters per kilogram units."""
        unit_const: Final = field_units.SpecificLengthUnits.meters_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def m_kg(self) -> 'FieldQnty':
        """Convert to m_kg units (alias for meters_per_kilogram)."""
        return self.meters_per_kilogram

    @property
    def newton_meter(self) -> 'FieldQnty':
        """Convert to newton meter units."""
        unit_const: Final = field_units.SpecificLengthUnits.newton_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Nm(self) -> 'FieldQnty':
        """Convert to Nm units (alias for newton_meter)."""
        return self.newton_meter

    @property
    def worsted(self) -> 'FieldQnty':
        """Convert to worsted units."""
        unit_const: Final = field_units.SpecificLengthUnits.worsted
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitSpecificSurfaceConverter(UnitConverter):
    """SpecificSurface-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def square_centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to square centimeter per gram units."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_2_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_g units (alias for square_centimeter_per_gram)."""
        return self.square_centimeter_per_gram

    @property
    def square_foot_per_kilogram(self) -> 'FieldQnty':
        """Convert to square foot per kilogram units."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_foot_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_kg_or_sq_ft_kg(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_kg_or_sq_ft_kg units (alias for square_foot_per_kilogram)."""
        return self.square_foot_per_kilogram

    @property
    def ft_2_kg(self) -> 'FieldQnty':
        """Convert to ft_2_kg units (alias for square_foot_per_kilogram)."""
        return self.square_foot_per_kilogram

    @property
    def sq_ft_kg(self) -> 'FieldQnty':
        """Convert to sq_ft_kg units (alias for square_foot_per_kilogram)."""
        return self.square_foot_per_kilogram

    @property
    def square_foot_per_pound(self) -> 'FieldQnty':
        """Convert to square foot per pound units."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_foot_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_lb_or_sq_ft_lb(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_lb_or_sq_ft_lb units (alias for square_foot_per_pound)."""
        return self.square_foot_per_pound

    @property
    def ft_2_lb(self) -> 'FieldQnty':
        """Convert to ft_2_lb units (alias for square_foot_per_pound)."""
        return self.square_foot_per_pound

    @property
    def sq_ft_lb(self) -> 'FieldQnty':
        """Convert to sq_ft_lb units (alias for square_foot_per_pound)."""
        return self.square_foot_per_pound

    @property
    def square_meter_per_gram(self) -> 'FieldQnty':
        """Convert to square meter per gram units."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_meter_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_g units (alias for square_meter_per_gram)."""
        return self.square_meter_per_gram

    @property
    def square_meter_per_kilogram(self) -> 'FieldQnty':
        """Convert to square meter per kilogram units."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_meter_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_kg units (alias for square_meter_per_kilogram)."""
        return self.square_meter_per_kilogram


class ToUnitSpecificVolumeConverter(UnitConverter):
    """SpecificVolume-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cubic_centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to cubic centimeter per gram units."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_3_mathrm_g_or_mathrm_cc_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cm_3_mathrm_g_or_mathrm_cc_mathrm_g units (alias for cubic_centimeter_per_gram)."""
        return self.cubic_centimeter_per_gram

    @property
    def cm_3_g(self) -> 'FieldQnty':
        """Convert to cm_3_g units (alias for cubic_centimeter_per_gram)."""
        return self.cubic_centimeter_per_gram

    @property
    def cc_g(self) -> 'FieldQnty':
        """Convert to cc_g units (alias for cubic_centimeter_per_gram)."""
        return self.cubic_centimeter_per_gram

    @property
    def cubic_foot_per_kilogram(self) -> 'FieldQnty':
        """Convert to cubic foot per kilogram units."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_foot_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_kg_or_mathrm_cft_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_kg_or_mathrm_cft_mathrm_kg units (alias for cubic_foot_per_kilogram)."""
        return self.cubic_foot_per_kilogram

    @property
    def ft_3_kg(self) -> 'FieldQnty':
        """Convert to ft_3_kg units (alias for cubic_foot_per_kilogram)."""
        return self.cubic_foot_per_kilogram

    @property
    def cft_kg(self) -> 'FieldQnty':
        """Convert to cft_kg units (alias for cubic_foot_per_kilogram)."""
        return self.cubic_foot_per_kilogram

    @property
    def cubic_foot_per_pound(self) -> 'FieldQnty':
        """Convert to cubic foot per pound units."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_foot_per_pound
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_lb_or_mathrm_cft_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_lb_or_mathrm_cft_mathrm_lb units (alias for cubic_foot_per_pound)."""
        return self.cubic_foot_per_pound

    @property
    def ft_3_lb(self) -> 'FieldQnty':
        """Convert to ft_3_lb units (alias for cubic_foot_per_pound)."""
        return self.cubic_foot_per_pound

    @property
    def cft_lb(self) -> 'FieldQnty':
        """Convert to cft_lb units (alias for cubic_foot_per_pound)."""
        return self.cubic_foot_per_pound

    @property
    def cubic_meter_per_kilogram(self) -> 'FieldQnty':
        """Convert to cubic meter per kilogram units."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_meter_per_kilogram
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_kg units (alias for cubic_meter_per_kilogram)."""
        return self.cubic_meter_per_kilogram


class ToUnitStressConverter(UnitConverter):
    """Stress-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units."""
        unit_const: Final = field_units.StressUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter)."""
        return self.dyne_per_square_centimeter

    @property
    def gigapascal(self) -> 'FieldQnty':
        """Convert to gigapascal units."""
        unit_const: Final = field_units.StressUnits.gigapascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def GPa(self) -> 'FieldQnty':
        """Convert to GPa units (alias for gigapascal)."""
        return self.gigapascal

    @property
    def hectopascal(self) -> 'FieldQnty':
        """Convert to hectopascal units."""
        unit_const: Final = field_units.StressUnits.hectopascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def hPa(self) -> 'FieldQnty':
        """Convert to hPa units (alias for hectopascal)."""
        return self.hectopascal

    @property
    def kilogram_force_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per square centimeter units."""
        unit_const: Final = field_units.StressUnits.kilogram_force_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to at_or_mathrm_kg_mathrm_f_mathrm_cm_2 units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def at(self) -> 'FieldQnty':
        """Convert to at units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kg_f_cm_2(self) -> 'FieldQnty':
        """Convert to kg_f_cm_2 units (alias for kilogram_force_per_square_centimeter)."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kilogram_force_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per square meter units."""
        unit_const: Final = field_units.StressUnits.kilogram_force_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_2 units (alias for kilogram_force_per_square_meter)."""
        return self.kilogram_force_per_square_meter

    @property
    def kip_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to kip force per square inch units."""
        unit_const: Final = field_units.StressUnits.kip_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to KSI_or_ksi_or_kip_f_mathrm_in_2 units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def KSI(self) -> 'FieldQnty':
        """Convert to KSI units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def ksi(self) -> 'FieldQnty':
        """Convert to ksi units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def kip_f_in_2(self) -> 'FieldQnty':
        """Convert to kip_f_in_2 units (alias for kip_force_per_square_inch)."""
        return self.kip_force_per_square_inch

    @property
    def megapascal(self) -> 'FieldQnty':
        """Convert to megapascal units."""
        unit_const: Final = field_units.StressUnits.megapascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def MPa(self) -> 'FieldQnty':
        """Convert to MPa units (alias for megapascal)."""
        return self.megapascal

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units."""
        unit_const: Final = field_units.StressUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter)."""
        return self.newton_per_square_meter

    @property
    def ounce_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to ounce force per square inch units."""
        unit_const: Final = field_units.StressUnits.ounce_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2 units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def OSI(self) -> 'FieldQnty':
        """Convert to OSI units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def osi(self) -> 'FieldQnty':
        """Convert to osi units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def oz_f_in_2(self) -> 'FieldQnty':
        """Convert to oz_f_in_2 units (alias for ounce_force_per_square_inch)."""
        return self.ounce_force_per_square_inch

    @property
    def pascal(self) -> 'FieldQnty':
        """Convert to pascal units."""
        unit_const: Final = field_units.StressUnits.pascal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Pa(self) -> 'FieldQnty':
        """Convert to Pa units (alias for pascal)."""
        return self.pascal

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units."""
        unit_const: Final = field_units.StressUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2 units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def PSF(self) -> 'FieldQnty':
        """Convert to PSF units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def psf(self) -> 'FieldQnty':
        """Convert to psf units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def lb_f_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_ft_2 units (alias for pound_force_per_square_foot)."""
        return self.pound_force_per_square_foot

    @property
    def pound_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to pound force per square inch units."""
        unit_const: Final = field_units.StressUnits.pound_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def psi(self) -> 'FieldQnty':
        """Convert to psi units (alias for pound_force_per_square_inch)."""
        return self.pound_force_per_square_inch


class ToUnitSurfaceMassDensityConverter(UnitConverter):
    """SurfaceMassDensity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to gram per square centimeter units."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.gram_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_cm_2 units (alias for gram_per_square_centimeter)."""
        return self.gram_per_square_centimeter

    @property
    def gram_per_square_meter(self) -> 'FieldQnty':
        """Convert to gram per square meter units."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.gram_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_m_2 units (alias for gram_per_square_meter)."""
        return self.gram_per_square_meter

    @property
    def kilogram_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram per square meter units."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.kilogram_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2 units (alias for kilogram_per_square_meter)."""
        return self.kilogram_per_square_meter

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound (mass) per square foot units."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_2 units (alias for pound_mass)."""
        return self.pound_mass


class ToUnitSurfaceTensionConverter(UnitConverter):
    """SurfaceTension-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def dyne_per_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per centimeter units."""
        unit_const: Final = field_units.SurfaceTensionUnits.dyne_per_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_cm(self) -> 'FieldQnty':
        """Convert to dyn_cm units (alias for dyne_per_centimeter)."""
        return self.dyne_per_centimeter

    @property
    def gram_force_per_centimeter(self) -> 'FieldQnty':
        """Convert to gram force per centimeter units."""
        unit_const: Final = field_units.SurfaceTensionUnits.gram_force_per_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_f_mathrm_cm(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_f_mathrm_cm units (alias for gram_force_per_centimeter)."""
        return self.gram_force_per_centimeter

    @property
    def newton_per_meter(self) -> 'FieldQnty':
        """Convert to newton per meter units."""
        unit_const: Final = field_units.SurfaceTensionUnits.newton_per_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N_m(self) -> 'FieldQnty':
        """Convert to N_m units (alias for newton_per_meter)."""
        return self.newton_per_meter

    @property
    def pound_force_per_foot(self) -> 'FieldQnty':
        """Convert to pound force per foot units."""
        unit_const: Final = field_units.SurfaceTensionUnits.pound_force_per_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_ft units (alias for pound_force_per_foot)."""
        return self.pound_force_per_foot

    @property
    def pound_force_per_inch(self) -> 'FieldQnty':
        """Convert to pound force per inch units."""
        unit_const: Final = field_units.SurfaceTensionUnits.pound_force_per_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_in(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_in units (alias for pound_force_per_inch)."""
        return self.pound_force_per_inch


class ToUnitTemperatureConverter(UnitConverter):
    """Temperature-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def degree_celsius_unit_size(self) -> 'FieldQnty':
        """Convert to degree Celsius (unit size) units."""
        unit_const: Final = field_units.TemperatureUnits.degree_celsius_unit_size
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_C_circ(self) -> 'FieldQnty':
        """Convert to mathrm_C_circ units (alias for degree_celsius_unit_size)."""
        return self.degree_celsius_unit_size

    @property
    def degree_fahrenheit_unit_size(self) -> 'FieldQnty':
        """Convert to degree Fahrenheit (unit size) units."""
        unit_const: Final = field_units.TemperatureUnits.degree_fahrenheit_unit_size
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_F_circ(self) -> 'FieldQnty':
        """Convert to mathrm_F_circ units (alias for degree_fahrenheit_unit_size)."""
        return self.degree_fahrenheit_unit_size

    @property
    def degree_r_aumur_unit_size(self) -> 'FieldQnty':
        """Convert to degree Réaumur (unit size) units."""
        unit_const: Final = field_units.TemperatureUnits.degree_r_aumur_unit_size
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def R_circ(self) -> 'FieldQnty':
        """Convert to R_circ units (alias for degree_r_aumur_unit_size)."""
        return self.degree_r_aumur_unit_size

    @property
    def kelvin_absolute_scale(self) -> 'FieldQnty':
        """Convert to kelvin (absolute scale) units."""
        unit_const: Final = field_units.TemperatureUnits.kelvin_absolute_scale
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def K(self) -> 'FieldQnty':
        """Convert to K units (alias for kelvin_absolute_scale)."""
        return self.kelvin_absolute_scale

    @property
    def rankine_absolute_scale(self) -> 'FieldQnty':
        """Convert to Rankine (absolute scale) units."""
        unit_const: Final = field_units.TemperatureUnits.rankine_absolute_scale
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def circ_mathrm_R(self) -> 'FieldQnty':
        """Convert to circ_mathrm_R units (alias for rankine_absolute_scale)."""
        return self.rankine_absolute_scale


class ToUnitThermalConductivityConverter(UnitConverter):
    """ThermalConductivity-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def btu_it(self) -> 'FieldQnty':
        """Convert to Btu (IT) per inch per hour per degree Fahrenheit units."""
        unit_const: Final = field_units.ThermalConductivityUnits.btu_it
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_IT_in_hr_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_IT_in_hr_circ_mathrm_F units (alias for btu_it)."""
        return self.btu_it

    @property
    def btu_therm(self) -> 'FieldQnty':
        """Convert to Btu (therm) per foot per hour per degree Fahrenheit units."""
        unit_const: Final = field_units.ThermalConductivityUnits.btu_therm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_left_mathrm_ft_mathrm_hr_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_left_mathrm_ft_mathrm_hr_circ_mathrm_F_right units (alias for btu_therm)."""
        return self.btu_therm

    @property
    def calorie_therm(self) -> 'FieldQnty':
        """Convert to calorie (therm) per centimeter per second per degree Celsius units."""
        unit_const: Final = field_units.ThermalConductivityUnits.calorie_therm
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def operatorname_cal_mathrm_IT_left_mathrm_cm_mathrm_s_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to operatorname_cal_mathrm_IT_left_mathrm_cm_mathrm_s_circ_mathrm_C_right units (alias for calorie_therm)."""
        return self.calorie_therm

    @property
    def joule_per_second_per_centimeter_per_kelvin(self) -> 'FieldQnty':
        """Convert to joule per second per centimeter per kelvin units."""
        unit_const: Final = field_units.ThermalConductivityUnits.joule_per_second_per_centimeter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def J_cm_s_K(self) -> 'FieldQnty':
        """Convert to J_cm_s_K units (alias for joule_per_second_per_centimeter_per_kelvin)."""
        return self.joule_per_second_per_centimeter_per_kelvin

    @property
    def watt_per_centimeter_per_kelvin(self) -> 'FieldQnty':
        """Convert to watt per centimeter per kelvin units."""
        unit_const: Final = field_units.ThermalConductivityUnits.watt_per_centimeter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def W_cm_K(self) -> 'FieldQnty':
        """Convert to W_cm_K units (alias for watt_per_centimeter_per_kelvin)."""
        return self.watt_per_centimeter_per_kelvin

    @property
    def watt_per_meter_per_kelvin(self) -> 'FieldQnty':
        """Convert to watt per meter per kelvin units."""
        unit_const: Final = field_units.ThermalConductivityUnits.watt_per_meter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def W_m_K(self) -> 'FieldQnty':
        """Convert to W_m_K units (alias for watt_per_meter_per_kelvin)."""
        return self.watt_per_meter_per_kelvin


class ToUnitTimeConverter(UnitConverter):
    """Time-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def blink(self) -> 'FieldQnty':
        """Convert to blink units."""
        unit_const: Final = field_units.TimeUnits.blink
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def century(self) -> 'FieldQnty':
        """Convert to century units."""
        unit_const: Final = field_units.TimeUnits.century
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for century)."""
        return self.century

    @property
    def chronon_or_tempon(self) -> 'FieldQnty':
        """Convert to chronon or tempon units."""
        unit_const: Final = field_units.TimeUnits.chronon_or_tempon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gigan_or_eon(self) -> 'FieldQnty':
        """Convert to gigan or eon units."""
        unit_const: Final = field_units.TimeUnits.gigan_or_eon
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Ga_or_eon(self) -> 'FieldQnty':
        """Convert to Ga_or_eon units (alias for gigan_or_eon)."""
        return self.gigan_or_eon

    @property
    def Ga(self) -> 'FieldQnty':
        """Convert to Ga units (alias for gigan_or_eon)."""
        return self.gigan_or_eon

    @property
    def eon(self) -> 'FieldQnty':
        """Convert to eon units (alias for gigan_or_eon)."""
        return self.gigan_or_eon

    @property
    def hour(self) -> 'FieldQnty':
        """Convert to hour units."""
        unit_const: Final = field_units.TimeUnits.hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def h_or_hr(self) -> 'FieldQnty':
        """Convert to h_or_hr units (alias for hour)."""
        return self.hour

    @property
    def h(self) -> 'FieldQnty':
        """Convert to h units (alias for hour)."""
        return self.hour

    @property
    def hr(self) -> 'FieldQnty':
        """Convert to hr units (alias for hour)."""
        return self.hour

    @property
    def julian_year(self) -> 'FieldQnty':
        """Convert to Julian year units."""
        unit_const: Final = field_units.TimeUnits.julian_year
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def a_jul_or_yr(self) -> 'FieldQnty':
        """Convert to a_jul_or_yr units (alias for julian_year)."""
        return self.julian_year

    @property
    def a_jul(self) -> 'FieldQnty':
        """Convert to a_jul units (alias for julian_year)."""
        return self.julian_year

    @property
    def yr(self) -> 'FieldQnty':
        """Convert to yr units (alias for julian_year)."""
        return self.julian_year

    @property
    def mean_solar_day(self) -> 'FieldQnty':
        """Convert to mean solar day units."""
        unit_const: Final = field_units.TimeUnits.mean_solar_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def da_or_d(self) -> 'FieldQnty':
        """Convert to da_or_d units (alias for mean_solar_day)."""
        return self.mean_solar_day

    @property
    def da(self) -> 'FieldQnty':
        """Convert to da units (alias for mean_solar_day)."""
        return self.mean_solar_day

    @property
    def d(self) -> 'FieldQnty':
        """Convert to d units (alias for mean_solar_day)."""
        return self.mean_solar_day

    @property
    def millenium(self) -> 'FieldQnty':
        """Convert to millenium units."""
        unit_const: Final = field_units.TimeUnits.millenium
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def minute(self) -> 'FieldQnty':
        """Convert to minute units."""
        unit_const: Final = field_units.TimeUnits.minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def min(self) -> 'FieldQnty':
        """Convert to min units (alias for minute)."""
        return self.minute

    @property
    def second(self) -> 'FieldQnty':
        """Convert to second units."""
        unit_const: Final = field_units.TimeUnits.second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def s(self) -> 'FieldQnty':
        """Convert to s units (alias for second)."""
        return self.second

    @property
    def shake(self) -> 'FieldQnty':
        """Convert to shake units."""
        unit_const: Final = field_units.TimeUnits.shake
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def sidereal_year_1900_ad(self) -> 'FieldQnty':
        """Convert to sidereal year (1900 AD) units."""
        unit_const: Final = field_units.TimeUnits.sidereal_year_1900_ad
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def a_sider_or_yr(self) -> 'FieldQnty':
        """Convert to a_sider_or_yr units (alias for sidereal_year_1900_ad)."""
        return self.sidereal_year_1900_ad

    @property
    def a_sider(self) -> 'FieldQnty':
        """Convert to a_sider units (alias for sidereal_year_1900_ad)."""
        return self.sidereal_year_1900_ad

    @property
    def tropical_year(self) -> 'FieldQnty':
        """Convert to tropical year units."""
        unit_const: Final = field_units.TimeUnits.tropical_year
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def a_trop(self) -> 'FieldQnty':
        """Convert to a_trop units (alias for tropical_year)."""
        return self.tropical_year

    @property
    def wink(self) -> 'FieldQnty':
        """Convert to wink units."""
        unit_const: Final = field_units.TimeUnits.wink
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def year(self) -> 'FieldQnty':
        """Convert to year units."""
        unit_const: Final = field_units.TimeUnits.year
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def a_or_y_or_yr(self) -> 'FieldQnty':
        """Convert to a_or_y_or_yr units (alias for year)."""
        return self.year

    @property
    def a(self) -> 'FieldQnty':
        """Convert to a units (alias for year)."""
        return self.year

    @property
    def y(self) -> 'FieldQnty':
        """Convert to y units (alias for year)."""
        return self.year

    @property
    def millisecond(self) -> 'FieldQnty':
        """Convert to millisecond units."""
        unit_const: Final = field_units.TimeUnits.millisecond
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ms(self) -> 'FieldQnty':
        """Convert to ms units (alias for millisecond)."""
        return self.millisecond

    @property
    def microsecond(self) -> 'FieldQnty':
        """Convert to microsecond units."""
        unit_const: Final = field_units.TimeUnits.microsecond
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def nanosecond(self) -> 'FieldQnty':
        """Convert to nanosecond units."""
        unit_const: Final = field_units.TimeUnits.nanosecond
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ns(self) -> 'FieldQnty':
        """Convert to ns units (alias for nanosecond)."""
        return self.nanosecond

    @property
    def picosecond(self) -> 'FieldQnty':
        """Convert to picosecond units."""
        unit_const: Final = field_units.TimeUnits.picosecond
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ps(self) -> 'FieldQnty':
        """Convert to ps units (alias for picosecond)."""
        return self.picosecond


class ToUnitTorqueConverter(UnitConverter):
    """Torque-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def centimeter_kilogram_force(self) -> 'FieldQnty':
        """Convert to centimeter kilogram force units."""
        unit_const: Final = field_units.TorqueUnits.centimeter_kilogram_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to cm_kg_mathrm_f units (alias for centimeter_kilogram_force)."""
        return self.centimeter_kilogram_force

    @property
    def dyne_centimeter(self) -> 'FieldQnty':
        """Convert to dyne centimeter units."""
        unit_const: Final = field_units.TorqueUnits.dyne_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_cm(self) -> 'FieldQnty':
        """Convert to dyn_cm units (alias for dyne_centimeter)."""
        return self.dyne_centimeter

    @property
    def foot_kilogram_force(self) -> 'FieldQnty':
        """Convert to foot kilogram force units."""
        unit_const: Final = field_units.TorqueUnits.foot_kilogram_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_kg_mathrm_f units (alias for foot_kilogram_force)."""
        return self.foot_kilogram_force

    @property
    def foot_pound_force(self) -> 'FieldQnty':
        """Convert to foot pound force units."""
        unit_const: Final = field_units.TorqueUnits.foot_pound_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f units (alias for foot_pound_force)."""
        return self.foot_pound_force

    @property
    def foot_poundal(self) -> 'FieldQnty':
        """Convert to foot poundal units."""
        unit_const: Final = field_units.TorqueUnits.foot_poundal
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_pdl(self) -> 'FieldQnty':
        """Convert to ft_pdl units (alias for foot_poundal)."""
        return self.foot_poundal

    @property
    def in_pound_force(self) -> 'FieldQnty':
        """Convert to in pound force units."""
        unit_const: Final = field_units.TorqueUnits.in_pound_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to in_mathrm_lb_mathrm_f units (alias for in_pound_force)."""
        return self.in_pound_force

    @property
    def inch_ounce_force(self) -> 'FieldQnty':
        """Convert to inch ounce force units."""
        unit_const: Final = field_units.TorqueUnits.inch_ounce_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_mathrm_OZ_mathrm_f(self) -> 'FieldQnty':
        """Convert to in_mathrm_OZ_mathrm_f units (alias for inch_ounce_force)."""
        return self.inch_ounce_force

    @property
    def meter_kilogram_force(self) -> 'FieldQnty':
        """Convert to meter kilogram force units."""
        unit_const: Final = field_units.TorqueUnits.meter_kilogram_force
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_kg_mathrm_f units (alias for meter_kilogram_force)."""
        return self.meter_kilogram_force

    @property
    def newton_centimeter(self) -> 'FieldQnty':
        """Convert to newton centimeter units."""
        unit_const: Final = field_units.TorqueUnits.newton_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N_cm(self) -> 'FieldQnty':
        """Convert to N_cm units (alias for newton_centimeter)."""
        return self.newton_centimeter

    @property
    def newton_meter(self) -> 'FieldQnty':
        """Convert to newton meter units."""
        unit_const: Final = field_units.TorqueUnits.newton_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def N_m(self) -> 'FieldQnty':
        """Convert to N_m units (alias for newton_meter)."""
        return self.newton_meter


class ToUnitTurbulenceEnergyDissipationRateConverter(UnitConverter):
    """TurbulenceEnergyDissipationRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def square_foot_per_cubic_second(self) -> 'FieldQnty':
        """Convert to square foot per cubic second units."""
        unit_const: Final = field_units.TurbulenceEnergyDissipationRateUnits.square_foot_per_cubic_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_s_3_or_sq_ft_sec_3(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s_3_or_sq_ft_sec_3 units (alias for square_foot_per_cubic_second)."""
        return self.square_foot_per_cubic_second

    @property
    def ft_2_s_3(self) -> 'FieldQnty':
        """Convert to ft_2_s_3 units (alias for square_foot_per_cubic_second)."""
        return self.square_foot_per_cubic_second

    @property
    def sq_ft_sec_3(self) -> 'FieldQnty':
        """Convert to sq_ft_sec_3 units (alias for square_foot_per_cubic_second)."""
        return self.square_foot_per_cubic_second

    @property
    def square_meter_per_cubic_second(self) -> 'FieldQnty':
        """Convert to square meter per cubic second units."""
        unit_const: Final = field_units.TurbulenceEnergyDissipationRateUnits.square_meter_per_cubic_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_s_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s_3 units (alias for square_meter_per_cubic_second)."""
        return self.square_meter_per_cubic_second


class ToUnitVelocityAngularConverter(UnitConverter):
    """VelocityAngular-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def degree_per_minute(self) -> 'FieldQnty':
        """Convert to degree per minute units."""
        unit_const: Final = field_units.VelocityAngularUnits.degree_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def deg_min_or_circ_mathrm_min(self) -> 'FieldQnty':
        """Convert to deg_min_or_circ_mathrm_min units (alias for degree_per_minute)."""
        return self.degree_per_minute

    @property
    def deg_min(self) -> 'FieldQnty':
        """Convert to deg_min units (alias for degree_per_minute)."""
        return self.degree_per_minute

    @property
    def circ_min(self) -> 'FieldQnty':
        """Convert to circ_min units (alias for degree_per_minute)."""
        return self.degree_per_minute

    @property
    def degree_per_second(self) -> 'FieldQnty':
        """Convert to degree per second units."""
        unit_const: Final = field_units.VelocityAngularUnits.degree_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def deg_s_or_circ_s(self) -> 'FieldQnty':
        """Convert to deg_s_or_circ_s units (alias for degree_per_second)."""
        return self.degree_per_second

    @property
    def deg_s(self) -> 'FieldQnty':
        """Convert to deg_s units (alias for degree_per_second)."""
        return self.degree_per_second

    @property
    def circ_s(self) -> 'FieldQnty':
        """Convert to circ_s units (alias for degree_per_second)."""
        return self.degree_per_second

    @property
    def grade_per_minute(self) -> 'FieldQnty':
        """Convert to grade per minute units."""
        unit_const: Final = field_units.VelocityAngularUnits.grade_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gon_min_or_grad_min(self) -> 'FieldQnty':
        """Convert to gon_min_or_grad_min units (alias for grade_per_minute)."""
        return self.grade_per_minute

    @property
    def gon_min(self) -> 'FieldQnty':
        """Convert to gon_min units (alias for grade_per_minute)."""
        return self.grade_per_minute

    @property
    def grad_min(self) -> 'FieldQnty':
        """Convert to grad_min units (alias for grade_per_minute)."""
        return self.grade_per_minute

    @property
    def radian_per_minute(self) -> 'FieldQnty':
        """Convert to radian per minute units."""
        unit_const: Final = field_units.VelocityAngularUnits.radian_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_rad_mathrm_min(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_min units (alias for radian_per_minute)."""
        return self.radian_per_minute

    @property
    def radian_per_second(self) -> 'FieldQnty':
        """Convert to radian per second units."""
        unit_const: Final = field_units.VelocityAngularUnits.radian_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_rad_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_s units (alias for radian_per_second)."""
        return self.radian_per_second

    @property
    def revolution_per_minute(self) -> 'FieldQnty':
        """Convert to revolution per minute units."""
        unit_const: Final = field_units.VelocityAngularUnits.revolution_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def rev_m_or_rpm(self) -> 'FieldQnty':
        """Convert to rev_m_or_rpm units (alias for revolution_per_minute)."""
        return self.revolution_per_minute

    @property
    def rev_m(self) -> 'FieldQnty':
        """Convert to rev_m units (alias for revolution_per_minute)."""
        return self.revolution_per_minute

    @property
    def rpm(self) -> 'FieldQnty':
        """Convert to rpm units (alias for revolution_per_minute)."""
        return self.revolution_per_minute

    @property
    def revolution_per_second(self) -> 'FieldQnty':
        """Convert to revolution per second units."""
        unit_const: Final = field_units.VelocityAngularUnits.revolution_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def rev_s_or_rps(self) -> 'FieldQnty':
        """Convert to rev_s_or_rps units (alias for revolution_per_second)."""
        return self.revolution_per_second

    @property
    def rev_s(self) -> 'FieldQnty':
        """Convert to rev_s units (alias for revolution_per_second)."""
        return self.revolution_per_second

    @property
    def rps(self) -> 'FieldQnty':
        """Convert to rps units (alias for revolution_per_second)."""
        return self.revolution_per_second

    @property
    def turn_per_minute(self) -> 'FieldQnty':
        """Convert to turn per minute units."""
        unit_const: Final = field_units.VelocityAngularUnits.turn_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tr_min(self) -> 'FieldQnty':
        """Convert to tr_min units (alias for turn_per_minute)."""
        return self.turn_per_minute


class ToUnitVelocityLinearConverter(UnitConverter):
    """VelocityLinear-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def foot_per_hour(self) -> 'FieldQnty':
        """Convert to foot per hour units."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_h_or_ft_hr_or_fph(self) -> 'FieldQnty':
        """Convert to ft_h_or_ft_hr_or_fph units (alias for foot_per_hour)."""
        return self.foot_per_hour

    @property
    def ft_h(self) -> 'FieldQnty':
        """Convert to ft_h units (alias for foot_per_hour)."""
        return self.foot_per_hour

    @property
    def ft_hr(self) -> 'FieldQnty':
        """Convert to ft_hr units (alias for foot_per_hour)."""
        return self.foot_per_hour

    @property
    def fph(self) -> 'FieldQnty':
        """Convert to fph units (alias for foot_per_hour)."""
        return self.foot_per_hour

    @property
    def foot_per_minute(self) -> 'FieldQnty':
        """Convert to foot per minute units."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_min_or_fpm(self) -> 'FieldQnty':
        """Convert to ft_min_or_fpm units (alias for foot_per_minute)."""
        return self.foot_per_minute

    @property
    def ft_min(self) -> 'FieldQnty':
        """Convert to ft_min units (alias for foot_per_minute)."""
        return self.foot_per_minute

    @property
    def fpm(self) -> 'FieldQnty':
        """Convert to fpm units (alias for foot_per_minute)."""
        return self.foot_per_minute

    @property
    def foot_per_second(self) -> 'FieldQnty':
        """Convert to foot per second units."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ft_s_or_fps(self) -> 'FieldQnty':
        """Convert to ft_s_or_fps units (alias for foot_per_second)."""
        return self.foot_per_second

    @property
    def ft_s(self) -> 'FieldQnty':
        """Convert to ft_s units (alias for foot_per_second)."""
        return self.foot_per_second

    @property
    def fps(self) -> 'FieldQnty':
        """Convert to fps units (alias for foot_per_second)."""
        return self.foot_per_second

    @property
    def inch_per_second(self) -> 'FieldQnty':
        """Convert to inch per second units."""
        unit_const: Final = field_units.VelocityLinearUnits.inch_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def in_s_or_ips(self) -> 'FieldQnty':
        """Convert to in_s_or_ips units (alias for inch_per_second)."""
        return self.inch_per_second

    @property
    def in_s(self) -> 'FieldQnty':
        """Convert to in_s units (alias for inch_per_second)."""
        return self.inch_per_second

    @property
    def ips(self) -> 'FieldQnty':
        """Convert to ips units (alias for inch_per_second)."""
        return self.inch_per_second

    @property
    def international_knot(self) -> 'FieldQnty':
        """Convert to international knot units."""
        unit_const: Final = field_units.VelocityLinearUnits.international_knot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def knot(self) -> 'FieldQnty':
        """Convert to knot units (alias for international_knot)."""
        return self.international_knot

    @property
    def kilometer_per_hour(self) -> 'FieldQnty':
        """Convert to kilometer per hour units."""
        unit_const: Final = field_units.VelocityLinearUnits.kilometer_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km_h_ot_kph(self) -> 'FieldQnty':
        """Convert to km_h_ot_kph units (alias for kilometer_per_hour)."""
        return self.kilometer_per_hour

    @property
    def kilometer_per_second(self) -> 'FieldQnty':
        """Convert to kilometer per second units."""
        unit_const: Final = field_units.VelocityLinearUnits.kilometer_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def km_s(self) -> 'FieldQnty':
        """Convert to km_s units (alias for kilometer_per_second)."""
        return self.kilometer_per_second

    @property
    def meter_per_second(self) -> 'FieldQnty':
        """Convert to meter per second units."""
        unit_const: Final = field_units.VelocityLinearUnits.meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_s units (alias for meter_per_second)."""
        return self.meter_per_second

    @property
    def mile_per_hour(self) -> 'FieldQnty':
        """Convert to mile per hour units."""
        unit_const: Final = field_units.VelocityLinearUnits.mile_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mi_mathrm_h_or_mathrm_mi_mathrm_hr_or_mph(self) -> 'FieldQnty':
        """Convert to mathrm_mi_mathrm_h_or_mathrm_mi_mathrm_hr_or_mph units (alias for mile_per_hour)."""
        return self.mile_per_hour

    @property
    def mi_h(self) -> 'FieldQnty':
        """Convert to mi_h units (alias for mile_per_hour)."""
        return self.mile_per_hour

    @property
    def mi_hr(self) -> 'FieldQnty':
        """Convert to mi_hr units (alias for mile_per_hour)."""
        return self.mile_per_hour

    @property
    def mph(self) -> 'FieldQnty':
        """Convert to mph units (alias for mile_per_hour)."""
        return self.mile_per_hour


class ToUnitViscosityDynamicConverter(UnitConverter):
    """ViscosityDynamic-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def centipoise(self) -> 'FieldQnty':
        """Convert to centipoise units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.centipoise
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cP_or_cPo(self) -> 'FieldQnty':
        """Convert to cP_or_cPo units (alias for centipoise)."""
        return self.centipoise

    @property
    def cP(self) -> 'FieldQnty':
        """Convert to cP units (alias for centipoise)."""
        return self.centipoise

    @property
    def cPo(self) -> 'FieldQnty':
        """Convert to cPo units (alias for centipoise)."""
        return self.centipoise

    @property
    def dyne_second_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne second per square centimeter units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.dyne_second_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dyn_s_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_s_mathrm_cm_2 units (alias for dyne_second_per_square_centimeter)."""
        return self.dyne_second_per_square_centimeter

    @property
    def kilopound_second_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilopound second per square meter units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.kilopound_second_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kip_mathrm_s_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to kip_mathrm_s_mathrm_m_2 units (alias for kilopound_second_per_square_meter)."""
        return self.kilopound_second_per_square_meter

    @property
    def millipoise(self) -> 'FieldQnty':
        """Convert to millipoise units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.millipoise
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mP_or_mPo(self) -> 'FieldQnty':
        """Convert to mP_or_mPo units (alias for millipoise)."""
        return self.millipoise

    @property
    def mP(self) -> 'FieldQnty':
        """Convert to mP units (alias for millipoise)."""
        return self.millipoise

    @property
    def mPo(self) -> 'FieldQnty':
        """Convert to mPo units (alias for millipoise)."""
        return self.millipoise

    @property
    def newton_second_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton second per square meter units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.newton_second_per_square_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_N_mathrm_s_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_s_mathrm_m_2 units (alias for newton_second_per_square_meter)."""
        return self.newton_second_per_square_meter

    @property
    def pascal_second(self) -> 'FieldQnty':
        """Convert to pascal second units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pascal_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Pa_s_or_PI(self) -> 'FieldQnty':
        """Convert to Pa_s_or_PI units (alias for pascal_second)."""
        return self.pascal_second

    @property
    def Pa_s(self) -> 'FieldQnty':
        """Convert to Pa_s units (alias for pascal_second)."""
        return self.pascal_second

    @property
    def PI(self) -> 'FieldQnty':
        """Convert to PI units (alias for pascal_second)."""
        return self.pascal_second

    @property
    def poise(self) -> 'FieldQnty':
        """Convert to poise units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.poise
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def P_or_Po(self) -> 'FieldQnty':
        """Convert to P_or_Po units (alias for poise)."""
        return self.poise

    @property
    def P(self) -> 'FieldQnty':
        """Convert to P units (alias for poise)."""
        return self.poise

    @property
    def Po(self) -> 'FieldQnty':
        """Convert to Po units (alias for poise)."""
        return self.poise

    @property
    def pound_force_hour_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force hour per square foot units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pound_force_hour_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_h_mathrm_ft_2_or_mathrm_lb_mathrm_hr_mathrm_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_h_mathrm_ft_2_or_mathrm_lb_mathrm_hr_mathrm_sq_ft units (alias for pound_force_hour_per_square_foot)."""
        return self.pound_force_hour_per_square_foot

    @property
    def lb_f_h_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_h_ft_2 units (alias for pound_force_hour_per_square_foot)."""
        return self.pound_force_hour_per_square_foot

    @property
    def lb_hr_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_hr_sq_ft units (alias for pound_force_hour_per_square_foot)."""
        return self.pound_force_hour_per_square_foot

    @property
    def pound_force_second_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force second per square foot units."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pound_force_second_per_square_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_f_mathrm_s_mathrm_ft_2_or_mathrm_lb_mathrm_sec_mathrm_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_s_mathrm_ft_2_or_mathrm_lb_mathrm_sec_mathrm_sq_ft units (alias for pound_force_second_per_square_foot)."""
        return self.pound_force_second_per_square_foot

    @property
    def lb_f_s_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_s_ft_2 units (alias for pound_force_second_per_square_foot)."""
        return self.pound_force_second_per_square_foot

    @property
    def lb_sec_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_sec_sq_ft units (alias for pound_force_second_per_square_foot)."""
        return self.pound_force_second_per_square_foot


class ToUnitViscosityKinematicConverter(UnitConverter):
    """ViscosityKinematic-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def centistokes(self) -> 'FieldQnty':
        """Convert to centistokes units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.centistokes
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cSt(self) -> 'FieldQnty':
        """Convert to cSt units (alias for centistokes)."""
        return self.centistokes

    @property
    def millistokes(self) -> 'FieldQnty':
        """Convert to millistokes units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.millistokes
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mSt(self) -> 'FieldQnty':
        """Convert to mSt units (alias for millistokes)."""
        return self.millistokes

    @property
    def square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to square centimeter per second units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_s units (alias for square_centimeter_per_second)."""
        return self.square_centimeter_per_second

    @property
    def square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to square foot per hour units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_h_or_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_h_or_mathrm_ft_2_mathrm_hr units (alias for square_foot_per_hour)."""
        return self.square_foot_per_hour

    @property
    def ft_2_h(self) -> 'FieldQnty':
        """Convert to ft_2_h units (alias for square_foot_per_hour)."""
        return self.square_foot_per_hour

    @property
    def ft_2_hr(self) -> 'FieldQnty':
        """Convert to ft_2_hr units (alias for square_foot_per_hour)."""
        return self.square_foot_per_hour

    @property
    def square_foot_per_second(self) -> 'FieldQnty':
        """Convert to square foot per second units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s units (alias for square_foot_per_second)."""
        return self.square_foot_per_second

    @property
    def square_meters_per_second(self) -> 'FieldQnty':
        """Convert to square meters per second units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_meters_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s units (alias for square_meters_per_second)."""
        return self.square_meters_per_second

    @property
    def stokes(self) -> 'FieldQnty':
        """Convert to stokes units."""
        unit_const: Final = field_units.ViscosityKinematicUnits.stokes
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def St(self) -> 'FieldQnty':
        """Convert to St units (alias for stokes)."""
        return self.stokes


class ToUnitVolumeConverter(UnitConverter):
    """Volume-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def acre_foot(self) -> 'FieldQnty':
        """Convert to acre foot units."""
        unit_const: Final = field_units.VolumeUnits.acre_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ac_ft(self) -> 'FieldQnty':
        """Convert to ac_ft units (alias for acre_foot)."""
        return self.acre_foot

    @property
    def acre_inch(self) -> 'FieldQnty':
        """Convert to acre inch units."""
        unit_const: Final = field_units.VolumeUnits.acre_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ac_in(self) -> 'FieldQnty':
        """Convert to ac_in units (alias for acre_inch)."""
        return self.acre_inch

    @property
    def barrel_us_liquid(self) -> 'FieldQnty':
        """Convert to barrel (US Liquid) units."""
        unit_const: Final = field_units.VolumeUnits.barrel_us_liquid
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def bbl_US_liq(self) -> 'FieldQnty':
        """Convert to bbl_US_liq units (alias for barrel_us_liquid)."""
        return self.barrel_us_liquid

    @property
    def barrel_us_petro(self) -> 'FieldQnty':
        """Convert to barrel (US, Petro) units."""
        unit_const: Final = field_units.VolumeUnits.barrel_us_petro
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def bbl(self) -> 'FieldQnty':
        """Convert to bbl units (alias for barrel_us_petro)."""
        return self.barrel_us_petro

    @property
    def board_foot_measure(self) -> 'FieldQnty':
        """Convert to board foot measure units."""
        unit_const: Final = field_units.VolumeUnits.board_foot_measure
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def BM_or_fbm(self) -> 'FieldQnty':
        """Convert to BM_or_fbm units (alias for board_foot_measure)."""
        return self.board_foot_measure

    @property
    def BM(self) -> 'FieldQnty':
        """Convert to BM units (alias for board_foot_measure)."""
        return self.board_foot_measure

    @property
    def fbm(self) -> 'FieldQnty':
        """Convert to fbm units (alias for board_foot_measure)."""
        return self.board_foot_measure

    @property
    def bushel_us_dry(self) -> 'FieldQnty':
        """Convert to bushel (US Dry) units."""
        unit_const: Final = field_units.VolumeUnits.bushel_us_dry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def bu_US_dry(self) -> 'FieldQnty':
        """Convert to bu_US_dry units (alias for bushel_us_dry)."""
        return self.bushel_us_dry

    @property
    def centiliter(self) -> 'FieldQnty':
        """Convert to centiliter units."""
        unit_const: Final = field_units.VolumeUnits.centiliter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cl_or_cL(self) -> 'FieldQnty':
        """Convert to cl_or_cL units (alias for centiliter)."""
        return self.centiliter

    @property
    def cl(self) -> 'FieldQnty':
        """Convert to cl units (alias for centiliter)."""
        return self.centiliter

    @property
    def cL(self) -> 'FieldQnty':
        """Convert to cL units (alias for centiliter)."""
        return self.centiliter

    @property
    def cord(self) -> 'FieldQnty':
        """Convert to cord units."""
        unit_const: Final = field_units.VolumeUnits.cord
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cord_or_cd(self) -> 'FieldQnty':
        """Convert to cord_or_cd units (alias for cord)."""
        return self.cord

    @property
    def cd(self) -> 'FieldQnty':
        """Convert to cd units (alias for cord)."""
        return self.cord

    @property
    def cord_foot(self) -> 'FieldQnty':
        """Convert to cord foot units."""
        unit_const: Final = field_units.VolumeUnits.cord_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cord_ft(self) -> 'FieldQnty':
        """Convert to cord_ft units (alias for cord_foot)."""
        return self.cord_foot

    @property
    def cubic_centimeter(self) -> 'FieldQnty':
        """Convert to cubic centimeter units."""
        unit_const: Final = field_units.VolumeUnits.cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_3_or_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cm_3_or_cc units (alias for cubic_centimeter)."""
        return self.cubic_centimeter

    @property
    def cm_3(self) -> 'FieldQnty':
        """Convert to cm_3 units (alias for cubic_centimeter)."""
        return self.cubic_centimeter

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for cubic_centimeter)."""
        return self.cubic_centimeter

    @property
    def cubic_decameter(self) -> 'FieldQnty':
        """Convert to cubic decameter units."""
        unit_const: Final = field_units.VolumeUnits.cubic_decameter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dam_3(self) -> 'FieldQnty':
        """Convert to dam_3 units (alias for cubic_decameter)."""
        return self.cubic_decameter

    @property
    def cubic_decimeter(self) -> 'FieldQnty':
        """Convert to cubic decimeter units."""
        unit_const: Final = field_units.VolumeUnits.cubic_decimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_dm_3(self) -> 'FieldQnty':
        """Convert to mathrm_dm_3 units (alias for cubic_decimeter)."""
        return self.cubic_decimeter

    @property
    def cubic_foot(self) -> 'FieldQnty':
        """Convert to cubic foot units."""
        unit_const: Final = field_units.VolumeUnits.cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cu_ft_or_ft_3(self) -> 'FieldQnty':
        """Convert to cu_ft_or_ft_3 units (alias for cubic_foot)."""
        return self.cubic_foot

    @property
    def cu_ft(self) -> 'FieldQnty':
        """Convert to cu_ft units (alias for cubic_foot)."""
        return self.cubic_foot

    @property
    def ft_3(self) -> 'FieldQnty':
        """Convert to ft_3 units (alias for cubic_foot)."""
        return self.cubic_foot

    @property
    def cubic_inch(self) -> 'FieldQnty':
        """Convert to cubic inch units."""
        unit_const: Final = field_units.VolumeUnits.cubic_inch
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cu_in_or_mathrm_in_3(self) -> 'FieldQnty':
        """Convert to cu_in_or_mathrm_in_3 units (alias for cubic_inch)."""
        return self.cubic_inch

    @property
    def cu_in(self) -> 'FieldQnty':
        """Convert to cu_in units (alias for cubic_inch)."""
        return self.cubic_inch

    @property
    def in_3(self) -> 'FieldQnty':
        """Convert to in_3 units (alias for cubic_inch)."""
        return self.cubic_inch

    @property
    def cubic_kilometer(self) -> 'FieldQnty':
        """Convert to cubic kilometer units."""
        unit_const: Final = field_units.VolumeUnits.cubic_kilometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_km_3(self) -> 'FieldQnty':
        """Convert to mathrm_km_3 units (alias for cubic_kilometer)."""
        return self.cubic_kilometer

    @property
    def cubic_meter(self) -> 'FieldQnty':
        """Convert to cubic meter units."""
        unit_const: Final = field_units.VolumeUnits.cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_3 units (alias for cubic_meter)."""
        return self.cubic_meter

    @property
    def cubic_micrometer(self) -> 'FieldQnty':
        """Convert to cubic micrometer units."""
        unit_const: Final = field_units.VolumeUnits.cubic_micrometer
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m_3 units (alias for cubic_micrometer)."""
        return self.cubic_micrometer

    @property
    def cubic_mile_us_intl(self) -> 'FieldQnty':
        """Convert to cubic mile (US, Intl) units."""
        unit_const: Final = field_units.VolumeUnits.cubic_mile_us_intl
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cu_mi(self) -> 'FieldQnty':
        """Convert to cu_mi units (alias for cubic_mile_us_intl)."""
        return self.cubic_mile_us_intl

    @property
    def cubic_millimeter(self) -> 'FieldQnty':
        """Convert to cubic millimeter units."""
        unit_const: Final = field_units.VolumeUnits.cubic_millimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_mm_3(self) -> 'FieldQnty':
        """Convert to mathrm_mm_3 units (alias for cubic_millimeter)."""
        return self.cubic_millimeter

    @property
    def cubic_yard(self) -> 'FieldQnty':
        """Convert to cubic yard units."""
        unit_const: Final = field_units.VolumeUnits.cubic_yard
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def cu_yd_or_mathrm_yd_3(self) -> 'FieldQnty':
        """Convert to cu_yd_or_mathrm_yd_3 units (alias for cubic_yard)."""
        return self.cubic_yard

    @property
    def cu_yd(self) -> 'FieldQnty':
        """Convert to cu_yd units (alias for cubic_yard)."""
        return self.cubic_yard

    @property
    def yd_3(self) -> 'FieldQnty':
        """Convert to yd_3 units (alias for cubic_yard)."""
        return self.cubic_yard

    @property
    def decast_re(self) -> 'FieldQnty':
        """Convert to decastére units."""
        unit_const: Final = field_units.VolumeUnits.decast_re
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dast(self) -> 'FieldQnty':
        """Convert to dast units (alias for decast_re)."""
        return self.decast_re

    @property
    def deciliter(self) -> 'FieldQnty':
        """Convert to deciliter units."""
        unit_const: Final = field_units.VolumeUnits.deciliter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def dl_or_dL(self) -> 'FieldQnty':
        """Convert to dl_or_dL units (alias for deciliter)."""
        return self.deciliter

    @property
    def dl(self) -> 'FieldQnty':
        """Convert to dl units (alias for deciliter)."""
        return self.deciliter

    @property
    def dL(self) -> 'FieldQnty':
        """Convert to dL units (alias for deciliter)."""
        return self.deciliter

    @property
    def fluid_drachm_uk(self) -> 'FieldQnty':
        """Convert to fluid drachm (UK) units."""
        unit_const: Final = field_units.VolumeUnits.fluid_drachm_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fl_dr_UK(self) -> 'FieldQnty':
        """Convert to fl_dr_UK units (alias for fluid_drachm_uk)."""
        return self.fluid_drachm_uk

    @property
    def fluid_dram_us(self) -> 'FieldQnty':
        """Convert to fluid dram (US) units."""
        unit_const: Final = field_units.VolumeUnits.fluid_dram_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fl_dr_US_liq(self) -> 'FieldQnty':
        """Convert to fl_dr_US_liq units (alias for fluid_dram_us)."""
        return self.fluid_dram_us

    @property
    def fluid_ounce_us(self) -> 'FieldQnty':
        """Convert to fluid ounce (US) units."""
        unit_const: Final = field_units.VolumeUnits.fluid_ounce_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def fl_oz(self) -> 'FieldQnty':
        """Convert to fl_oz units (alias for fluid_ounce_us)."""
        return self.fluid_ounce_us

    @property
    def gallon_imperial_uk(self) -> 'FieldQnty':
        """Convert to gallon (Imperial UK) units."""
        unit_const: Final = field_units.VolumeUnits.gallon_imperial_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_UK_or_Imp_gal(self) -> 'FieldQnty':
        """Convert to gal_UK_or_Imp_gal units (alias for gallon_imperial_uk)."""
        return self.gallon_imperial_uk

    @property
    def gal_UK(self) -> 'FieldQnty':
        """Convert to gal_UK units (alias for gallon_imperial_uk)."""
        return self.gallon_imperial_uk

    @property
    def Imp_gal(self) -> 'FieldQnty':
        """Convert to Imp_gal units (alias for gallon_imperial_uk)."""
        return self.gallon_imperial_uk

    @property
    def gallon_us_dry(self) -> 'FieldQnty':
        """Convert to gallon (US Dry) units."""
        unit_const: Final = field_units.VolumeUnits.gallon_us_dry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_US_dry(self) -> 'FieldQnty':
        """Convert to gal_US_dry units (alias for gallon_us_dry)."""
        return self.gallon_us_dry

    @property
    def gallon_us_liquid(self) -> 'FieldQnty':
        """Convert to gallon (US Liquid) units."""
        unit_const: Final = field_units.VolumeUnits.gallon_us_liquid
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal(self) -> 'FieldQnty':
        """Convert to gal units (alias for gallon_us_liquid)."""
        return self.gallon_us_liquid

    @property
    def last(self) -> 'FieldQnty':
        """Convert to last units."""
        unit_const: Final = field_units.VolumeUnits.last
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liter(self) -> 'FieldQnty':
        """Convert to liter units."""
        unit_const: Final = field_units.VolumeUnits.liter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_or_L(self) -> 'FieldQnty':
        """Convert to unit_1_or_L units (alias for liter)."""
        return self.liter

    @property
    def unit_1(self) -> 'FieldQnty':
        """Convert to unit_1 units (alias for liter)."""
        return self.liter

    @property
    def L(self) -> 'FieldQnty':
        """Convert to L units (alias for liter)."""
        return self.liter

    @property
    def microliter(self) -> 'FieldQnty':
        """Convert to microliter units."""
        unit_const: Final = field_units.VolumeUnits.microliter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mu_mathrm_l_or_mu_mathrm_L(self) -> 'FieldQnty':
        """Convert to mu_mathrm_l_or_mu_mathrm_L units (alias for microliter)."""
        return self.microliter

    @property
    def mu_l(self) -> 'FieldQnty':
        """Convert to mu_l units (alias for microliter)."""
        return self.microliter

    @property
    def mu_L(self) -> 'FieldQnty':
        """Convert to mu_L units (alias for microliter)."""
        return self.microliter

    @property
    def milliliter(self) -> 'FieldQnty':
        """Convert to milliliter units."""
        unit_const: Final = field_units.VolumeUnits.milliliter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def ml(self) -> 'FieldQnty':
        """Convert to ml units (alias for milliliter)."""
        return self.milliliter

    @property
    def mohr_centicube(self) -> 'FieldQnty':
        """Convert to Mohr centicube units."""
        unit_const: Final = field_units.VolumeUnits.mohr_centicube
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pint_uk(self) -> 'FieldQnty':
        """Convert to pint (UK) units."""
        unit_const: Final = field_units.VolumeUnits.pint_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pt_UK(self) -> 'FieldQnty':
        """Convert to pt_UK units (alias for pint_uk)."""
        return self.pint_uk

    @property
    def pint_us_dry(self) -> 'FieldQnty':
        """Convert to pint (US Dry) units."""
        unit_const: Final = field_units.VolumeUnits.pint_us_dry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pt_US_dry(self) -> 'FieldQnty':
        """Convert to pt_US_dry units (alias for pint_us_dry)."""
        return self.pint_us_dry

    @property
    def pint_us_liquid(self) -> 'FieldQnty':
        """Convert to pint (US Liquid) units."""
        unit_const: Final = field_units.VolumeUnits.pint_us_liquid
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def pt(self) -> 'FieldQnty':
        """Convert to pt units (alias for pint_us_liquid)."""
        return self.pint_us_liquid

    @property
    def quart_us_dry(self) -> 'FieldQnty':
        """Convert to quart (US Dry) units."""
        unit_const: Final = field_units.VolumeUnits.quart_us_dry
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def qt_US_dry(self) -> 'FieldQnty':
        """Convert to qt_US_dry units (alias for quart_us_dry)."""
        return self.quart_us_dry

    @property
    def st_re(self) -> 'FieldQnty':
        """Convert to stére units."""
        unit_const: Final = field_units.VolumeUnits.st_re
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def st(self) -> 'FieldQnty':
        """Convert to st units (alias for st_re)."""
        return self.st_re

    @property
    def tablespoon_metric(self) -> 'FieldQnty':
        """Convert to tablespoon (Metric) units."""
        unit_const: Final = field_units.VolumeUnits.tablespoon_metric
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tbsp_Metric(self) -> 'FieldQnty':
        """Convert to tbsp_Metric units (alias for tablespoon_metric)."""
        return self.tablespoon_metric

    @property
    def tablespoon_us(self) -> 'FieldQnty':
        """Convert to tablespoon (US) units."""
        unit_const: Final = field_units.VolumeUnits.tablespoon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tbsp(self) -> 'FieldQnty':
        """Convert to tbsp units (alias for tablespoon_us)."""
        return self.tablespoon_us

    @property
    def teaspoon_us(self) -> 'FieldQnty':
        """Convert to teaspoon (US) units."""
        unit_const: Final = field_units.VolumeUnits.teaspoon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def tsp(self) -> 'FieldQnty':
        """Convert to tsp units (alias for teaspoon_us)."""
        return self.teaspoon_us


class ToUnitVolumeFractionOfIConverter(UnitConverter):
    """VolumeFractionOfI-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cubic_centimeters_of_i_per_cubic_meter_total(self) -> 'FieldQnty':
        """Convert to cubic centimeters of "i" per cubic meter total units."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_centimeters_of_i_per_cubic_meter_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cm_mathrm_i_3_mathrm_m_3_or_mathrm_cc_mathrm_i_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_cm_mathrm_i_3_mathrm_m_3_or_mathrm_cc_mathrm_i_mathrm_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total)."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cm_i_3_m_3(self) -> 'FieldQnty':
        """Convert to cm_i_3_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total)."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cc_i_m_3(self) -> 'FieldQnty':
        """Convert to cc_i_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total)."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cubic_foot_of_i_per_cubic_foot_total(self) -> 'FieldQnty':
        """Convert to cubic foot of "i" per cubic foot total units."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_foot_of_i_per_cubic_foot_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_mathrm_i_3_mathrm_ft_3_or_mathrm_cft_mathrm_i_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_i_3_mathrm_ft_3_or_mathrm_cft_mathrm_i_mathrm_cft units (alias for cubic_foot_of_i_per_cubic_foot_total)."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def ft_i_3_ft_3(self) -> 'FieldQnty':
        """Convert to ft_i_3_ft_3 units (alias for cubic_foot_of_i_per_cubic_foot_total)."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def cft_i_cft(self) -> 'FieldQnty':
        """Convert to cft_i_cft units (alias for cubic_foot_of_i_per_cubic_foot_total)."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def cubic_meters_of_i_per_cubic_meter_total(self) -> 'FieldQnty':
        """Convert to cubic meters of " i " per cubic meter total units."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_meters_of_i_per_cubic_meter_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_mathrm_i_3_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_i_3_mathrm_m_3 units (alias for cubic_meters_of_i_per_cubic_meter_total)."""
        return self.cubic_meters_of_i_per_cubic_meter_total

    @property
    def gallons_of_i_per_gallon_total(self) -> 'FieldQnty':
        """Convert to gallons of "i" per gallon total units."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.gallons_of_i_per_gallon_total
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gal_mathrm_i_mathrm_gal(self) -> 'FieldQnty':
        """Convert to mathrm_gal_mathrm_i_mathrm_gal units (alias for gallons_of_i_per_gallon_total)."""
        return self.gallons_of_i_per_gallon_total


class ToUnitVolumetricCalorificHeatingValueConverter(UnitConverter):
    """VolumetricCalorificHeatingValue-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def british_thermal_unit_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per cubic foot units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Btu_mathrm_ft_3_or_Btu_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_3_or_Btu_cft units (alias for british_thermal_unit_per_cubic_foot)."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def Btu_ft_3(self) -> 'FieldQnty':
        """Convert to Btu_ft_3 units (alias for british_thermal_unit_per_cubic_foot)."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def Btu_cft(self) -> 'FieldQnty':
        """Convert to Btu_cft units (alias for british_thermal_unit_per_cubic_foot)."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def british_thermal_unit_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to British thermal unit per gallon (UK) units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_gal_UK(self) -> 'FieldQnty':
        """Convert to Btu_gal_UK units (alias for british_thermal_unit_per_gallon_uk)."""
        return self.british_thermal_unit_per_gallon_uk

    @property
    def british_thermal_unit_per_gallon_us(self) -> 'FieldQnty':
        """Convert to British thermal unit per gallon (US) units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def Btu_gal_US(self) -> 'FieldQnty':
        """Convert to Btu_gal_US units (alias for british_thermal_unit_per_gallon_us)."""
        return self.british_thermal_unit_per_gallon_us

    @property
    def calorie_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to calorie per cubic centimeter units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.calorie_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_cal_mathrm_cm_3_or_mathrm_cal_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_cm_3_or_mathrm_cal_mathrm_cc units (alias for calorie_per_cubic_centimeter)."""
        return self.calorie_per_cubic_centimeter

    @property
    def cal_cm_3(self) -> 'FieldQnty':
        """Convert to cal_cm_3 units (alias for calorie_per_cubic_centimeter)."""
        return self.calorie_per_cubic_centimeter

    @property
    def cal_cc(self) -> 'FieldQnty':
        """Convert to cal_cc units (alias for calorie_per_cubic_centimeter)."""
        return self.calorie_per_cubic_centimeter

    @property
    def chu_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to Chu per cubic foot units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.chu_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_Chu_mathrm_ft_3_or_mathrm_Chu_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Chu_mathrm_ft_3_or_mathrm_Chu_mathrm_cft units (alias for chu_per_cubic_foot)."""
        return self.chu_per_cubic_foot

    @property
    def Chu_ft_3(self) -> 'FieldQnty':
        """Convert to Chu_ft_3 units (alias for chu_per_cubic_foot)."""
        return self.chu_per_cubic_foot

    @property
    def Chu_cft(self) -> 'FieldQnty':
        """Convert to Chu_cft units (alias for chu_per_cubic_foot)."""
        return self.chu_per_cubic_foot

    @property
    def joule_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to joule per cubic meter units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.joule_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_J_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_J_mathrm_m_3 units (alias for joule_per_cubic_meter)."""
        return self.joule_per_cubic_meter

    @property
    def kilocalorie_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to kilocalorie per cubic foot units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.kilocalorie_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_mathrm_ft_3_or_mathrm_kcal_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_ft_3_or_mathrm_kcal_mathrm_cft units (alias for kilocalorie_per_cubic_foot)."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kcal_ft_3(self) -> 'FieldQnty':
        """Convert to kcal_ft_3 units (alias for kilocalorie_per_cubic_foot)."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kcal_cft(self) -> 'FieldQnty':
        """Convert to kcal_cft units (alias for kilocalorie_per_cubic_foot)."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kilocalorie_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilocalorie per cubic meter units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.kilocalorie_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kcal_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_m_3 units (alias for kilocalorie_per_cubic_meter)."""
        return self.kilocalorie_per_cubic_meter

    @property
    def therm_100_k_btu(self) -> 'FieldQnty':
        """Convert to therm ( 100 K Btu ) per cubic foot units."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.therm_100_k_btu
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def thm_cft(self) -> 'FieldQnty':
        """Convert to thm_cft units (alias for therm_100_k_btu)."""
        return self.therm_100_k_btu


class ToUnitVolumetricCoefficientOfExpansionConverter(UnitConverter):
    """VolumetricCoefficientOfExpansion-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_per_cubic_centimeter_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to gram per cubic centimeter per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_mathrm_cm_3_mathrm_K_or_g_cc_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_3_mathrm_K_or_g_cc_circ_mathrm_C units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius)."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def g_cm_3_K(self) -> 'FieldQnty':
        """Convert to g_cm_3_K units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius)."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def g_cc_circ_C(self) -> 'FieldQnty':
        """Convert to g_cc_circ_C units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius)."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def kilogram_per_cubic_meter_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to kilogram per cubic meter per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_mathrm_m_3_mathrm_K_or_mathrm_kg_mathrm_m_3_circ_C(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_3_mathrm_K_or_mathrm_kg_mathrm_m_3_circ_C units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius)."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def kg_m_3_K(self) -> 'FieldQnty':
        """Convert to kg_m_3_K units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius)."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def kg_m_3_circ_C(self) -> 'FieldQnty':
        """Convert to kg_m_3_circ_C units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius)."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to pound per cubic foot per degree Fahrenheit (or degree Rankine) units."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_ft_3_circ_mathrm_R_or_mathrm_lb_mathrm_cft_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_3_circ_mathrm_R_or_mathrm_lb_mathrm_cft_circ_mathrm_F units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine)."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def lb_ft_3_circ_R(self) -> 'FieldQnty':
        """Convert to lb_ft_3_circ_R units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine)."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def lb_cft_circ_F(self) -> 'FieldQnty':
        """Convert to lb_cft_circ_F units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine)."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def pound_per_cubic_foot_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to pound per cubic foot per kelvin (or degree Celsius) units."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.pound_per_cubic_foot_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_mathrm_ft_3_mathrm_K_or_mathrm_lb_mathrm_cft_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_3_mathrm_K_or_mathrm_lb_mathrm_cft_circ_mathrm_C units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius)."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius

    @property
    def lb_ft_3_K(self) -> 'FieldQnty':
        """Convert to lb_ft_3_K units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius)."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius

    @property
    def lb_cft_circ_C(self) -> 'FieldQnty':
        """Convert to lb_cft_circ_C units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius)."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius


class ToUnitVolumetricFlowRateConverter(UnitConverter):
    """VolumetricFlowRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cubic_feet_per_day(self) -> 'FieldQnty':
        """Convert to cubic feet per day units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_d_or_mathrm_cft_mathrm_da_or_cfd(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_d_or_mathrm_cft_mathrm_da_or_cfd units (alias for cubic_feet_per_day)."""
        return self.cubic_feet_per_day

    @property
    def ft_3_d(self) -> 'FieldQnty':
        """Convert to ft_3_d units (alias for cubic_feet_per_day)."""
        return self.cubic_feet_per_day

    @property
    def cft_da(self) -> 'FieldQnty':
        """Convert to cft_da units (alias for cubic_feet_per_day)."""
        return self.cubic_feet_per_day

    @property
    def cfd(self) -> 'FieldQnty':
        """Convert to cfd units (alias for cubic_feet_per_day)."""
        return self.cubic_feet_per_day

    @property
    def cubic_feet_per_hour(self) -> 'FieldQnty':
        """Convert to cubic feet per hour units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_h_or_mathrm_cft_mathrm_hr_or_cfh(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_h_or_mathrm_cft_mathrm_hr_or_cfh units (alias for cubic_feet_per_hour)."""
        return self.cubic_feet_per_hour

    @property
    def ft_3_h(self) -> 'FieldQnty':
        """Convert to ft_3_h units (alias for cubic_feet_per_hour)."""
        return self.cubic_feet_per_hour

    @property
    def cft_hr(self) -> 'FieldQnty':
        """Convert to cft_hr units (alias for cubic_feet_per_hour)."""
        return self.cubic_feet_per_hour

    @property
    def cfh(self) -> 'FieldQnty':
        """Convert to cfh units (alias for cubic_feet_per_hour)."""
        return self.cubic_feet_per_hour

    @property
    def cubic_feet_per_minute(self) -> 'FieldQnty':
        """Convert to cubic feet per minute units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_min_or_mathrm_cft_mathrm_min_or_cfm(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_min_or_mathrm_cft_mathrm_min_or_cfm units (alias for cubic_feet_per_minute)."""
        return self.cubic_feet_per_minute

    @property
    def ft_3_min(self) -> 'FieldQnty':
        """Convert to ft_3_min units (alias for cubic_feet_per_minute)."""
        return self.cubic_feet_per_minute

    @property
    def cft_min(self) -> 'FieldQnty':
        """Convert to cft_min units (alias for cubic_feet_per_minute)."""
        return self.cubic_feet_per_minute

    @property
    def cfm(self) -> 'FieldQnty':
        """Convert to cfm units (alias for cubic_feet_per_minute)."""
        return self.cubic_feet_per_minute

    @property
    def cubic_feet_per_second(self) -> 'FieldQnty':
        """Convert to cubic feet per second units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_mathrm_s_or_cft_sec_or_cfs(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_s_or_cft_sec_or_cfs units (alias for cubic_feet_per_second)."""
        return self.cubic_feet_per_second

    @property
    def ft_3_s(self) -> 'FieldQnty':
        """Convert to ft_3_s units (alias for cubic_feet_per_second)."""
        return self.cubic_feet_per_second

    @property
    def cft_sec(self) -> 'FieldQnty':
        """Convert to cft_sec units (alias for cubic_feet_per_second)."""
        return self.cubic_feet_per_second

    @property
    def cfs(self) -> 'FieldQnty':
        """Convert to cfs units (alias for cubic_feet_per_second)."""
        return self.cubic_feet_per_second

    @property
    def cubic_meters_per_day(self) -> 'FieldQnty':
        """Convert to cubic meters per day units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_mathrm_d(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_d units (alias for cubic_meters_per_day)."""
        return self.cubic_meters_per_day

    @property
    def cubic_meters_per_hour(self) -> 'FieldQnty':
        """Convert to cubic meters per hour units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_mathrm_h(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_h units (alias for cubic_meters_per_hour)."""
        return self.cubic_meters_per_hour

    @property
    def cubic_meters_per_minute(self) -> 'FieldQnty':
        """Convert to cubic meters per minute units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_min(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_min units (alias for cubic_meters_per_minute)."""
        return self.cubic_meters_per_minute

    @property
    def cubic_meters_per_second(self) -> 'FieldQnty':
        """Convert to cubic meters per second units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_s units (alias for cubic_meters_per_second)."""
        return self.cubic_meters_per_second

    @property
    def gallons_per_day(self) -> 'FieldQnty':
        """Convert to gallons per day units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_d_or_gpd_or_gal_da(self) -> 'FieldQnty':
        """Convert to gal_d_or_gpd_or_gal_da units (alias for gallons_per_day)."""
        return self.gallons_per_day

    @property
    def gal_d(self) -> 'FieldQnty':
        """Convert to gal_d units (alias for gallons_per_day)."""
        return self.gallons_per_day

    @property
    def gpd(self) -> 'FieldQnty':
        """Convert to gpd units (alias for gallons_per_day)."""
        return self.gallons_per_day

    @property
    def gal_da(self) -> 'FieldQnty':
        """Convert to gal_da units (alias for gallons_per_day)."""
        return self.gallons_per_day

    @property
    def gallons_per_hour(self) -> 'FieldQnty':
        """Convert to gallons per hour units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_h_or_gph_or_gal_hr(self) -> 'FieldQnty':
        """Convert to gal_h_or_gph_or_gal_hr units (alias for gallons_per_hour)."""
        return self.gallons_per_hour

    @property
    def gal_h(self) -> 'FieldQnty':
        """Convert to gal_h units (alias for gallons_per_hour)."""
        return self.gallons_per_hour

    @property
    def gph(self) -> 'FieldQnty':
        """Convert to gph units (alias for gallons_per_hour)."""
        return self.gallons_per_hour

    @property
    def gal_hr(self) -> 'FieldQnty':
        """Convert to gal_hr units (alias for gallons_per_hour)."""
        return self.gallons_per_hour

    @property
    def gallons_per_minute(self) -> 'FieldQnty':
        """Convert to gallons per minute units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_min_or_gpm(self) -> 'FieldQnty':
        """Convert to gal_min_or_gpm units (alias for gallons_per_minute)."""
        return self.gallons_per_minute

    @property
    def gal_min(self) -> 'FieldQnty':
        """Convert to gal_min units (alias for gallons_per_minute)."""
        return self.gallons_per_minute

    @property
    def gpm(self) -> 'FieldQnty':
        """Convert to gpm units (alias for gallons_per_minute)."""
        return self.gallons_per_minute

    @property
    def gallons_per_second(self) -> 'FieldQnty':
        """Convert to gallons per second units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def gal_s_or_gps_or_gal_sec(self) -> 'FieldQnty':
        """Convert to gal_s_or_gps_or_gal_sec units (alias for gallons_per_second)."""
        return self.gallons_per_second

    @property
    def gal_s(self) -> 'FieldQnty':
        """Convert to gal_s units (alias for gallons_per_second)."""
        return self.gallons_per_second

    @property
    def gps(self) -> 'FieldQnty':
        """Convert to gps units (alias for gallons_per_second)."""
        return self.gallons_per_second

    @property
    def gal_sec(self) -> 'FieldQnty':
        """Convert to gal_sec units (alias for gallons_per_second)."""
        return self.gallons_per_second

    @property
    def liters_per_day(self) -> 'FieldQnty':
        """Convert to liters per day units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_d(self) -> 'FieldQnty':
        """Convert to unit_1_d units (alias for liters_per_day)."""
        return self.liters_per_day

    @property
    def liters_per_hour(self) -> 'FieldQnty':
        """Convert to liters per hour units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_h(self) -> 'FieldQnty':
        """Convert to unit_1_h units (alias for liters_per_hour)."""
        return self.liters_per_hour

    @property
    def liters_per_minute(self) -> 'FieldQnty':
        """Convert to liters per minute units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liters_per_second(self) -> 'FieldQnty':
        """Convert to liters per second units."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_s(self) -> 'FieldQnty':
        """Convert to unit_1_s units (alias for liters_per_second)."""
        return self.liters_per_second


class ToUnitVolumetricFluxConverter(UnitConverter):
    """VolumetricFlux-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def cubic_feet_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per day units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_d_right_or_mathrm_cft_mathrm_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_d_right_or_mathrm_cft_mathrm_sqft_da units (alias for cubic_feet_per_square_foot_per_day)."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def ft_3_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_dright units (alias for cubic_feet_per_square_foot_per_day)."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def cft_sqft_da(self) -> 'FieldQnty':
        """Convert to cft_sqft_da units (alias for cubic_feet_per_square_foot_per_day)."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def cubic_feet_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per hour units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_h_right_or_mathrm_cft_mathrm_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_h_right_or_mathrm_cft_mathrm_sqft_hr units (alias for cubic_feet_per_square_foot_per_hour)."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def ft_3_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_hright units (alias for cubic_feet_per_square_foot_per_hour)."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def cft_sqft_hr(self) -> 'FieldQnty':
        """Convert to cft_sqft_hr units (alias for cubic_feet_per_square_foot_per_hour)."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def cubic_feet_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per minute units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_min_right_or_mathrm_cft_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_min_right_or_mathrm_cft_sqft_min units (alias for cubic_feet_per_square_foot_per_minute)."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def ft_3_left_ft_2_min_right(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_min_right units (alias for cubic_feet_per_square_foot_per_minute)."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def cft_sqft_min(self) -> 'FieldQnty':
        """Convert to cft_sqft_min units (alias for cubic_feet_per_square_foot_per_minute)."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def cubic_feet_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per second units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_s_right_or_cft_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_s_right_or_cft_sqft_sec units (alias for cubic_feet_per_square_foot_per_second)."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def ft_3_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_sright units (alias for cubic_feet_per_square_foot_per_second)."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def cft_sqft_sec(self) -> 'FieldQnty':
        """Convert to cft_sqft_sec units (alias for cubic_feet_per_square_foot_per_second)."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def cubic_meters_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per day units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_d_right units (alias for cubic_meters_per_square_meter_per_day)."""
        return self.cubic_meters_per_square_meter_per_day

    @property
    def cubic_meters_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per hour units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_h_right units (alias for cubic_meters_per_square_meter_per_hour)."""
        return self.cubic_meters_per_square_meter_per_hour

    @property
    def cubic_meters_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per minute units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_min_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_min_right units (alias for cubic_meters_per_square_meter_per_minute)."""
        return self.cubic_meters_per_square_meter_per_minute

    @property
    def cubic_meters_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per second units."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_s_right units (alias for cubic_meters_per_square_meter_per_second)."""
        return self.cubic_meters_per_square_meter_per_second

    @property
    def gallons_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to gallons per square foot per day units."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_d_right_or_gal_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_d_right_or_gal_sqft_da units (alias for gallons_per_square_foot_per_day)."""
        return self.gallons_per_square_foot_per_day

    @property
    def gal_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_dright units (alias for gallons_per_square_foot_per_day)."""
        return self.gallons_per_square_foot_per_day

    @property
    def gal_sqft_da(self) -> 'FieldQnty':
        """Convert to gal_sqft_da units (alias for gallons_per_square_foot_per_day)."""
        return self.gallons_per_square_foot_per_day

    @property
    def gallons_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to gallons per square foot per hour units."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_h_right_or_gal_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_h_right_or_gal_sqft_hr units (alias for gallons_per_square_foot_per_hour)."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gal_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_hright units (alias for gallons_per_square_foot_per_hour)."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gal_sqft_hr(self) -> 'FieldQnty':
        """Convert to gal_sqft_hr units (alias for gallons_per_square_foot_per_hour)."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gallons_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to gallons per square foot per minute units."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_min_right_or_gal_sqft_min_or_gpm_sqft(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_min_right_or_gal_sqft_min_or_gpm_sqft units (alias for gallons_per_square_foot_per_minute)."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gal_left_ft_2_minright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_minright units (alias for gallons_per_square_foot_per_minute)."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gal_sqft_min(self) -> 'FieldQnty':
        """Convert to gal_sqft_min units (alias for gallons_per_square_foot_per_minute)."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gpm_sqft(self) -> 'FieldQnty':
        """Convert to gpm_sqft units (alias for gallons_per_square_foot_per_minute)."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gallons_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to gallons per square foot per second units."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_s_right_or_gal_mathrm_sqft_mathrm_sec(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_s_right_or_gal_mathrm_sqft_mathrm_sec units (alias for gallons_per_square_foot_per_second)."""
        return self.gallons_per_square_foot_per_second

    @property
    def gal_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_sright units (alias for gallons_per_square_foot_per_second)."""
        return self.gallons_per_square_foot_per_second

    @property
    def gal_sqft_sec(self) -> 'FieldQnty':
        """Convert to gal_sqft_sec units (alias for gallons_per_square_foot_per_second)."""
        return self.gallons_per_square_foot_per_second

    @property
    def liters_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to liters per square meter per day units."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liters_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to liters per square meter per hour units."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liters_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to liters per square meter per minute units."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def liters_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to liters per square meter per second units."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=True)


class ToUnitVolumetricMassFlowRateConverter(UnitConverter):
    """VolumetricMassFlowRate-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def gram_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to gram per second per cubic centimeter units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.gram_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_g_left_mathrm_s_mathrm_cm_3_right_or_g_s_cc_or_mathrm_g_mathrm_cc_mathrm_sec(self) -> 'FieldQnty':
        """Convert to mathrm_g_left_mathrm_s_mathrm_cm_3_right_or_g_s_cc_or_mathrm_g_mathrm_cc_mathrm_sec units (alias for gram_per_second_per_cubic_centimeter)."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def g_left_s_cm_3right(self) -> 'FieldQnty':
        """Convert to g_left_s_cm_3right units (alias for gram_per_second_per_cubic_centimeter)."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def g_s_cc(self) -> 'FieldQnty':
        """Convert to g_s_cc units (alias for gram_per_second_per_cubic_centimeter)."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def g_cc_sec(self) -> 'FieldQnty':
        """Convert to g_cc_sec units (alias for gram_per_second_per_cubic_centimeter)."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def kilogram_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to kilogram per hour per cubic foot units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.kilogram_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_h_ft_3_or_kg_hr_cft(self) -> 'FieldQnty':
        """Convert to kg_h_ft_3_or_kg_hr_cft units (alias for kilogram_per_hour_per_cubic_foot)."""
        return self.kilogram_per_hour_per_cubic_foot

    @property
    def kg_h_ft_3(self) -> 'FieldQnty':
        """Convert to kg_h_ft_3 units (alias for kilogram_per_hour_per_cubic_foot)."""
        return self.kilogram_per_hour_per_cubic_foot

    @property
    def kg_hr_cft(self) -> 'FieldQnty':
        """Convert to kg_hr_cft units (alias for kilogram_per_hour_per_cubic_foot)."""
        return self.kilogram_per_hour_per_cubic_foot

    @property
    def kilogram_per_hour_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram per hour per cubic meter units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.kilogram_per_hour_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def kg_h_m3_or_kg_hr_cu_m(self) -> 'FieldQnty':
        """Convert to kg_h_m3_or_kg_hr_cu_m units (alias for kilogram_per_hour_per_cubic_meter)."""
        return self.kilogram_per_hour_per_cubic_meter

    @property
    def kg_h_m3(self) -> 'FieldQnty':
        """Convert to kg_h_m3 units (alias for kilogram_per_hour_per_cubic_meter)."""
        return self.kilogram_per_hour_per_cubic_meter

    @property
    def kg_hr_cu_m(self) -> 'FieldQnty':
        """Convert to kg_hr_cu_m units (alias for kilogram_per_hour_per_cubic_meter)."""
        return self.kilogram_per_hour_per_cubic_meter

    @property
    def kilogram_per_second_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram per second per cubic meter units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.kilogram_per_second_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_kg_left_mathrm_s_mathrm_m_3_right_or_kg_sec_cu_m(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_s_mathrm_m_3_right_or_kg_sec_cu_m units (alias for kilogram_per_second_per_cubic_meter)."""
        return self.kilogram_per_second_per_cubic_meter

    @property
    def kg_left_s_m_3right(self) -> 'FieldQnty':
        """Convert to kg_left_s_m_3right units (alias for kilogram_per_second_per_cubic_meter)."""
        return self.kilogram_per_second_per_cubic_meter

    @property
    def kg_sec_cu_m(self) -> 'FieldQnty':
        """Convert to kg_sec_cu_m units (alias for kilogram_per_second_per_cubic_meter)."""
        return self.kilogram_per_second_per_cubic_meter

    @property
    def pound_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound per hour per cubic foot units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.pound_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def mathrm_lb_left_mathrm_h_mathrm_ft_3_right_or_mathrm_lb_mathrm_hr_mathrm_cft_or_PPH_cft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_h_mathrm_ft_3_right_or_mathrm_lb_mathrm_hr_mathrm_cft_or_PPH_cft units (alias for pound_per_hour_per_cubic_foot)."""
        return self.pound_per_hour_per_cubic_foot

    @property
    def lb_left_h_ft_3right(self) -> 'FieldQnty':
        """Convert to lb_left_h_ft_3right units (alias for pound_per_hour_per_cubic_foot)."""
        return self.pound_per_hour_per_cubic_foot

    @property
    def lb_hr_cft(self) -> 'FieldQnty':
        """Convert to lb_hr_cft units (alias for pound_per_hour_per_cubic_foot)."""
        return self.pound_per_hour_per_cubic_foot

    @property
    def PPH_cft(self) -> 'FieldQnty':
        """Convert to PPH_cft units (alias for pound_per_hour_per_cubic_foot)."""
        return self.pound_per_hour_per_cubic_foot

    @property
    def pound_per_minute_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound per minute per cubic foot units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.pound_per_minute_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def lb_min_mathrm_ft_3_or_lb_mathrm_min_mathrm_cft(self) -> 'FieldQnty':
        """Convert to lb_min_mathrm_ft_3_or_lb_mathrm_min_mathrm_cft units (alias for pound_per_minute_per_cubic_foot)."""
        return self.pound_per_minute_per_cubic_foot

    @property
    def lb_min_ft_3(self) -> 'FieldQnty':
        """Convert to lb_min_ft_3 units (alias for pound_per_minute_per_cubic_foot)."""
        return self.pound_per_minute_per_cubic_foot

    @property
    def lb_min_cft(self) -> 'FieldQnty':
        """Convert to lb_min_cft units (alias for pound_per_minute_per_cubic_foot)."""
        return self.pound_per_minute_per_cubic_foot

    @property
    def pound_per_second_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound per second per cubic foot units."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.pound_per_second_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def b_s_ft_3_or_lb_sec_cft(self) -> 'FieldQnty':
        """Convert to b_s_ft_3_or_lb_sec_cft units (alias for pound_per_second_per_cubic_foot)."""
        return self.pound_per_second_per_cubic_foot

    @property
    def b_s_ft_3(self) -> 'FieldQnty':
        """Convert to b_s_ft_3 units (alias for pound_per_second_per_cubic_foot)."""
        return self.pound_per_second_per_cubic_foot

    @property
    def lb_sec_cft(self) -> 'FieldQnty':
        """Convert to lb_sec_cft units (alias for pound_per_second_per_cubic_foot)."""
        return self.pound_per_second_per_cubic_foot


class ToUnitWavenumberConverter(UnitConverter):
    """Wavenumber-specific ToUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=True)

    @property
    def diopter(self) -> 'FieldQnty':
        """Convert to diopter units."""
        unit_const: Final = field_units.WavenumberUnits.diopter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def D(self) -> 'FieldQnty':
        """Convert to D units (alias for diopter)."""
        return self.diopter

    @property
    def kayser(self) -> 'FieldQnty':
        """Convert to kayser units."""
        unit_const: Final = field_units.WavenumberUnits.kayser
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def K(self) -> 'FieldQnty':
        """Convert to K units (alias for kayser)."""
        return self.kayser

    @property
    def reciprocal_meter(self) -> 'FieldQnty':
        """Convert to reciprocal meter units."""
        unit_const: Final = field_units.WavenumberUnits.reciprocal_meter
        return self._convert_quantity(unit_const, modify_original=True)

    @property
    def unit_1_m(self) -> 'FieldQnty':
        """Convert to unit_1_m units (alias for reciprocal_meter)."""
        return self.reciprocal_meter


# ===== AS_UNIT CONVERTER CLASSES =====
# Converter classes that return a new variable representation

class AsUnitAbsorbedDoseConverter(UnitConverter):
    """AbsorbedDose-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def erg_per_gram(self) -> 'FieldQnty':
        """Convert to erg per gram units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.erg_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def erg_g(self) -> 'FieldQnty':
        """Convert to erg_g units (alias for erg_per_gram), returning new variable."""
        return self.erg_per_gram

    @property
    def erg_per_g(self) -> 'FieldQnty':
        """Convert to erg_per_g units (alias for erg_per_gram), returning new variable."""
        return self.erg_per_gram

    @property
    def gram_rad(self) -> 'FieldQnty':
        """Convert to gram-rad units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.gram_rad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def g_rad(self) -> 'FieldQnty':
        """Convert to g_rad units (alias for gram_rad), returning new variable."""
        return self.gram_rad

    @property
    def gray(self) -> 'FieldQnty':
        """Convert to gray units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.gray
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Gy(self) -> 'FieldQnty':
        """Convert to Gy units (alias for gray), returning new variable."""
        return self.gray

    @property
    def rad(self) -> 'FieldQnty':
        """Convert to rad units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.rad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def milligray(self) -> 'FieldQnty':
        """Convert to milligray units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.milligray
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mGy(self) -> 'FieldQnty':
        """Convert to mGy units (alias for milligray), returning new variable."""
        return self.milligray

    @property
    def microgray(self) -> 'FieldQnty':
        """Convert to microgray units, returning new variable."""
        unit_const: Final = field_units.AbsorbedDoseUnits.microgray
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitAccelerationConverter(UnitConverter):
    """Acceleration-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def meter_per_second_squared(self) -> 'FieldQnty':
        """Convert to meter per second squared units, returning new variable."""
        unit_const: Final = field_units.AccelerationUnits.meter_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_s_2 units (alias for meter_per_second_squared), returning new variable."""
        return self.meter_per_second_squared

    @property
    def m_per_s2(self) -> 'FieldQnty':
        """Convert to m_per_s2 units (alias for meter_per_second_squared), returning new variable."""
        return self.meter_per_second_squared

    @property
    def foot_per_second_squared(self) -> 'FieldQnty':
        """Convert to foot per second squared units, returning new variable."""
        unit_const: Final = field_units.AccelerationUnits.foot_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_s_2_or_mathrm_ft_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_s_2_or_mathrm_ft_mathrm_sec_2 units (alias for foot_per_second_squared), returning new variable."""
        return self.foot_per_second_squared

    @property
    def ft_per_s2(self) -> 'FieldQnty':
        """Convert to ft_per_s2 units (alias for foot_per_second_squared), returning new variable."""
        return self.foot_per_second_squared

    @property
    def fps2(self) -> 'FieldQnty':
        """Convert to fps2 units (alias for foot_per_second_squared), returning new variable."""
        return self.foot_per_second_squared


class AsUnitActivationEnergyConverter(UnitConverter):
    """ActivationEnergy-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_per_pound_mole(self) -> 'FieldQnty':
        """Convert to Btu per pound mole units, returning new variable."""
        unit_const: Final = field_units.ActivationEnergyUnits.btu_per_pound_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb_mol(self) -> 'FieldQnty':
        """Convert to Btu_lb_mol units (alias for btu_per_pound_mole), returning new variable."""
        return self.btu_per_pound_mole

    @property
    def btu_per_lbmol(self) -> 'FieldQnty':
        """Convert to btu_per_lbmol units (alias for btu_per_pound_mole), returning new variable."""
        return self.btu_per_pound_mole

    @property
    def calorie_mean_per_gram_mole(self) -> 'FieldQnty':
        """Convert to calorie (mean) per gram mole units, returning new variable."""
        unit_const: Final = field_units.ActivationEnergyUnits.calorie_mean_per_gram_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_mol(self) -> 'FieldQnty':
        """Convert to cal_mol units (alias for calorie_mean_per_gram_mole), returning new variable."""
        return self.calorie_mean_per_gram_mole

    @property
    def cal_mean_per_gmol(self) -> 'FieldQnty':
        """Convert to cal_mean_per_gmol units (alias for calorie_mean_per_gram_mole), returning new variable."""
        return self.calorie_mean_per_gram_mole

    @property
    def joule_per_gram_mole(self) -> 'FieldQnty':
        """Convert to joule per gram mole units, returning new variable."""
        unit_const: Final = field_units.ActivationEnergyUnits.joule_per_gram_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_mol(self) -> 'FieldQnty':
        """Convert to J_mol units (alias for joule_per_gram_mole), returning new variable."""
        return self.joule_per_gram_mole

    @property
    def joule_per_kilogram_mole(self) -> 'FieldQnty':
        """Convert to joule per kilogram mole units, returning new variable."""
        unit_const: Final = field_units.ActivationEnergyUnits.joule_per_kilogram_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kmol(self) -> 'FieldQnty':
        """Convert to J_kmol units (alias for joule_per_kilogram_mole), returning new variable."""
        return self.joule_per_kilogram_mole

    @property
    def kilocalorie_per_kilogram_mole(self) -> 'FieldQnty':
        """Convert to kilocalorie per kilogram mole units, returning new variable."""
        unit_const: Final = field_units.ActivationEnergyUnits.kilocalorie_per_kilogram_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kcal_kmol(self) -> 'FieldQnty':
        """Convert to kcal_kmol units (alias for kilocalorie_per_kilogram_mole), returning new variable."""
        return self.kilocalorie_per_kilogram_mole


class AsUnitAmountOfSubstanceConverter(UnitConverter):
    """AmountOfSubstance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def kilogram_mol(self) -> 'FieldQnty':
        """Convert to kilogram mol or kmol units, returning new variable."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.kilogram_mol
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol(self) -> 'FieldQnty':
        """Convert to kmol units (alias for kilogram_mol), returning new variable."""
        return self.kilogram_mol

    @property
    def mole(self) -> 'FieldQnty':
        """Convert to mole (gram) units, returning new variable."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol(self) -> 'FieldQnty':
        """Convert to mol units (alias for mole), returning new variable."""
        return self.mole

    @property
    def pound_mole(self) -> 'FieldQnty':
        """Convert to pound-mole units, returning new variable."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.pound_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mol_or_mole(self) -> 'FieldQnty':
        """Convert to lb_mol_or_mole units (alias for pound_mole), returning new variable."""
        return self.pound_mole

    @property
    def lb_mol(self) -> 'FieldQnty':
        """Convert to lb_mol units (alias for pound_mole), returning new variable."""
        return self.pound_mole

    @property
    def millimole(self) -> 'FieldQnty':
        """Convert to millimole (gram) units, returning new variable."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.millimole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mmol(self) -> 'FieldQnty':
        """Convert to mmol units (alias for millimole), returning new variable."""
        return self.millimole

    @property
    def micromole(self) -> 'FieldQnty':
        """Convert to micromole (gram) units, returning new variable."""
        unit_const: Final = field_units.AmountOfSubstanceUnits.micromole
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitAnglePlaneConverter(UnitConverter):
    """AnglePlane-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def degree(self) -> 'FieldQnty':
        """Convert to degree units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.degree
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def circ(self) -> 'FieldQnty':
        """Convert to circ units (alias for degree), returning new variable."""
        return self.degree

    @property
    def gon(self) -> 'FieldQnty':
        """Convert to gon units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.gon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def grade(self) -> 'FieldQnty':
        """Convert to grade units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.grade
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def minute_new(self) -> 'FieldQnty':
        """Convert to minute (new) units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.minute_new
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def c(self) -> 'FieldQnty':
        """Convert to c units (alias for minute_new), returning new variable."""
        return self.minute_new

    @property
    def minute_of_angle(self) -> 'FieldQnty':
        """Convert to minute of angle units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.minute_of_angle
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for minute_of_angle), returning new variable."""
        return self.minute_of_angle

    @property
    def percent(self) -> 'FieldQnty':
        """Convert to percent units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.percent
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def plane_angle(self) -> 'FieldQnty':
        """Convert to plane angle units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.plane_angle
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def quadrant(self) -> 'FieldQnty':
        """Convert to quadrant units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.quadrant
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def quadr(self) -> 'FieldQnty':
        """Convert to quadr units (alias for quadrant), returning new variable."""
        return self.quadrant

    @property
    def radian(self) -> 'FieldQnty':
        """Convert to radian units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.radian
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def rad(self) -> 'FieldQnty':
        """Convert to rad units (alias for radian), returning new variable."""
        return self.radian

    @property
    def right_angle(self) -> 'FieldQnty':
        """Convert to right angle units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.right_angle
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def perp(self) -> 'FieldQnty':
        """Convert to perp units (alias for right_angle), returning new variable."""
        return self.right_angle

    @property
    def round(self) -> 'FieldQnty':
        """Convert to round units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.round
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tr_or_r(self) -> 'FieldQnty':
        """Convert to tr_or_r units (alias for round), returning new variable."""
        return self.round

    @property
    def tr(self) -> 'FieldQnty':
        """Convert to tr units (alias for round), returning new variable."""
        return self.round

    @property
    def r(self) -> 'FieldQnty':
        """Convert to r units (alias for round), returning new variable."""
        return self.round

    @property
    def second_new(self) -> 'FieldQnty':
        """Convert to second (new) units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.second_new
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for second_new), returning new variable."""
        return self.second_new

    @property
    def second_of_angle(self) -> 'FieldQnty':
        """Convert to second of angle units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.second_of_angle
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def thousandth_us(self) -> 'FieldQnty':
        """Convert to thousandth (US) units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.thousandth_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def US(self) -> 'FieldQnty':
        """Convert to US units (alias for thousandth_us), returning new variable."""
        return self.thousandth_us

    @property
    def turn(self) -> 'FieldQnty':
        """Convert to turn units, returning new variable."""
        unit_const: Final = field_units.AnglePlaneUnits.turn
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def turn_or_rev(self) -> 'FieldQnty':
        """Convert to turn_or_rev units (alias for turn), returning new variable."""
        return self.turn

    @property
    def rev(self) -> 'FieldQnty':
        """Convert to rev units (alias for turn), returning new variable."""
        return self.turn


class AsUnitAngleSolidConverter(UnitConverter):
    """AngleSolid-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def spat(self) -> 'FieldQnty':
        """Convert to spat units, returning new variable."""
        unit_const: Final = field_units.AngleSolidUnits.spat
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def square_degree(self) -> 'FieldQnty':
        """Convert to square degree units, returning new variable."""
        unit_const: Final = field_units.AngleSolidUnits.square_degree
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def left_circ_right_2(self) -> 'FieldQnty':
        """Convert to left_circ_right_2 units (alias for square_degree), returning new variable."""
        return self.square_degree

    @property
    def square_gon(self) -> 'FieldQnty':
        """Convert to square gon units, returning new variable."""
        unit_const: Final = field_units.AngleSolidUnits.square_gon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def g_2(self) -> 'FieldQnty':
        """Convert to g_2 units (alias for square_gon), returning new variable."""
        return self.square_gon

    @property
    def steradian(self) -> 'FieldQnty':
        """Convert to steradian units, returning new variable."""
        unit_const: Final = field_units.AngleSolidUnits.steradian
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sr(self) -> 'FieldQnty':
        """Convert to sr units (alias for steradian), returning new variable."""
        return self.steradian


class AsUnitAngularAccelerationConverter(UnitConverter):
    """AngularAcceleration-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def radian_per_second_squared(self) -> 'FieldQnty':
        """Convert to radian per second squared units, returning new variable."""
        unit_const: Final = field_units.AngularAccelerationUnits.radian_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_rad_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_s_2 units (alias for radian_per_second_squared), returning new variable."""
        return self.radian_per_second_squared

    @property
    def revolution_per_second_squared(self) -> 'FieldQnty':
        """Convert to revolution per second squared units, returning new variable."""
        unit_const: Final = field_units.AngularAccelerationUnits.revolution_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_rev_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_rev_mathrm_sec_2 units (alias for revolution_per_second_squared), returning new variable."""
        return self.revolution_per_second_squared

    @property
    def rpm_or_revolution_per_minute(self) -> 'FieldQnty':
        """Convert to rpm (or revolution per minute) per minute units, returning new variable."""
        unit_const: Final = field_units.AngularAccelerationUnits.rpm_or_revolution_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_rev_mathrm_min_2_or_rpm_min(self) -> 'FieldQnty':
        """Convert to mathrm_rev_mathrm_min_2_or_rpm_min units (alias for rpm_or_revolution_per_minute), returning new variable."""
        return self.rpm_or_revolution_per_minute

    @property
    def rev_min_2(self) -> 'FieldQnty':
        """Convert to rev_min_2 units (alias for rpm_or_revolution_per_minute), returning new variable."""
        return self.rpm_or_revolution_per_minute

    @property
    def rpm_min(self) -> 'FieldQnty':
        """Convert to rpm_min units (alias for rpm_or_revolution_per_minute), returning new variable."""
        return self.rpm_or_revolution_per_minute


class AsUnitAngularMomentumConverter(UnitConverter):
    """AngularMomentum-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_centimeter_squared_per_second(self) -> 'FieldQnty':
        """Convert to gram centimeter squared per second units, returning new variable."""
        unit_const: Final = field_units.AngularMomentumUnits.gram_centimeter_squared_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2_mathrm_s units (alias for gram_centimeter_squared_per_second), returning new variable."""
        return self.gram_centimeter_squared_per_second

    @property
    def kilogram_meter_squared_per_second(self) -> 'FieldQnty':
        """Convert to kilogram meter squared per second units, returning new variable."""
        unit_const: Final = field_units.AngularMomentumUnits.kilogram_meter_squared_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2_mathrm_s units (alias for kilogram_meter_squared_per_second), returning new variable."""
        return self.kilogram_meter_squared_per_second

    @property
    def pound_force_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound force square foot per second units, returning new variable."""
        unit_const: Final = field_units.AngularMomentumUnits.pound_force_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_ft_2_mathrm_sec(self) -> 'FieldQnty':
        """Convert to lb_ft_2_mathrm_sec units (alias for pound_force_square_foot_per_second), returning new variable."""
        return self.pound_force_square_foot_per_second


class AsUnitAreaConverter(UnitConverter):
    """Area-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def acre_general(self) -> 'FieldQnty':
        """Convert to acre (general) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.acre_general
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ac(self) -> 'FieldQnty':
        """Convert to ac units (alias for acre_general), returning new variable."""
        return self.acre_general

    @property
    def are(self) -> 'FieldQnty':
        """Convert to are units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.are
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def a(self) -> 'FieldQnty':
        """Convert to a units (alias for are), returning new variable."""
        return self.are

    @property
    def arpent_quebec(self) -> 'FieldQnty':
        """Convert to arpent (Quebec) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.arpent_quebec
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def arp(self) -> 'FieldQnty':
        """Convert to arp units (alias for arpent_quebec), returning new variable."""
        return self.arpent_quebec

    @property
    def barn(self) -> 'FieldQnty':
        """Convert to barn units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.barn
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def b(self) -> 'FieldQnty':
        """Convert to b units (alias for barn), returning new variable."""
        return self.barn

    @property
    def circular_inch(self) -> 'FieldQnty':
        """Convert to circular inch units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.circular_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cin(self) -> 'FieldQnty':
        """Convert to cin units (alias for circular_inch), returning new variable."""
        return self.circular_inch

    @property
    def circular_mil(self) -> 'FieldQnty':
        """Convert to circular mil units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.circular_mil
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cmil(self) -> 'FieldQnty':
        """Convert to cmil units (alias for circular_mil), returning new variable."""
        return self.circular_mil

    @property
    def hectare(self) -> 'FieldQnty':
        """Convert to hectare units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.hectare
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ha(self) -> 'FieldQnty':
        """Convert to ha units (alias for hectare), returning new variable."""
        return self.hectare

    @property
    def shed(self) -> 'FieldQnty':
        """Convert to shed units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.shed
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def square_centimeter(self) -> 'FieldQnty':
        """Convert to square centimeter units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2 units (alias for square_centimeter), returning new variable."""
        return self.square_centimeter

    @property
    def square_chain_ramsden(self) -> 'FieldQnty':
        """Convert to square chain (Ramsden) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_chain_ramsden
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_ch_Rams(self) -> 'FieldQnty':
        """Convert to sq_ch_Rams units (alias for square_chain_ramsden), returning new variable."""
        return self.square_chain_ramsden

    @property
    def square_chain_survey_gunters(self) -> 'FieldQnty':
        """Convert to square chain (Survey, Gunter's) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_chain_survey_gunters
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_ch_surv(self) -> 'FieldQnty':
        """Convert to sq_ch_surv units (alias for square_chain_survey_gunters), returning new variable."""
        return self.square_chain_survey_gunters

    @property
    def square_decimeter(self) -> 'FieldQnty':
        """Convert to square decimeter units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_decimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_dm_2(self) -> 'FieldQnty':
        """Convert to mathrm_dm_2 units (alias for square_decimeter), returning new variable."""
        return self.square_decimeter

    @property
    def square_fermi(self) -> 'FieldQnty':
        """Convert to square fermi units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_fermi
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_F_2(self) -> 'FieldQnty':
        """Convert to mathrm_F_2 units (alias for square_fermi), returning new variable."""
        return self.square_fermi

    @property
    def square_foot(self) -> 'FieldQnty':
        """Convert to square foot units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_ft_or_ft_2(self) -> 'FieldQnty':
        """Convert to sq_ft_or_ft_2 units (alias for square_foot), returning new variable."""
        return self.square_foot

    @property
    def sq_ft(self) -> 'FieldQnty':
        """Convert to sq_ft units (alias for square_foot), returning new variable."""
        return self.square_foot

    @property
    def ft_2(self) -> 'FieldQnty':
        """Convert to ft_2 units (alias for square_foot), returning new variable."""
        return self.square_foot

    @property
    def square_hectometer(self) -> 'FieldQnty':
        """Convert to square hectometer units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_hectometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_hm_2(self) -> 'FieldQnty':
        """Convert to mathrm_hm_2 units (alias for square_hectometer), returning new variable."""
        return self.square_hectometer

    @property
    def square_inch(self) -> 'FieldQnty':
        """Convert to square inch units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_in_or_in_2(self) -> 'FieldQnty':
        """Convert to sq_in_or_in_2 units (alias for square_inch), returning new variable."""
        return self.square_inch

    @property
    def sq_in(self) -> 'FieldQnty':
        """Convert to sq_in units (alias for square_inch), returning new variable."""
        return self.square_inch

    @property
    def in_2(self) -> 'FieldQnty':
        """Convert to in_2 units (alias for square_inch), returning new variable."""
        return self.square_inch

    @property
    def square_kilometer(self) -> 'FieldQnty':
        """Convert to square kilometer units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_kilometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_km_2(self) -> 'FieldQnty':
        """Convert to mathrm_km_2 units (alias for square_kilometer), returning new variable."""
        return self.square_kilometer

    @property
    def square_league_statute(self) -> 'FieldQnty':
        """Convert to square league (statute) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_league_statute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_lg_stat(self) -> 'FieldQnty':
        """Convert to sq_lg_stat units (alias for square_league_statute), returning new variable."""
        return self.square_league_statute

    @property
    def square_meter(self) -> 'FieldQnty':
        """Convert to square meter units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2 units (alias for square_meter), returning new variable."""
        return self.square_meter

    @property
    def square_micron(self) -> 'FieldQnty':
        """Convert to square micron units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_micron
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_m_2_or_mu_2(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m_2_or_mu_2 units (alias for square_micron), returning new variable."""
        return self.square_micron

    @property
    def mu_m_2(self) -> 'FieldQnty':
        """Convert to mu_m_2 units (alias for square_micron), returning new variable."""
        return self.square_micron

    @property
    def mu_2(self) -> 'FieldQnty':
        """Convert to mu_2 units (alias for square_micron), returning new variable."""
        return self.square_micron

    @property
    def square_mile_statute(self) -> 'FieldQnty':
        """Convert to square mile (statute) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_mile_statute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_mi_stat(self) -> 'FieldQnty':
        """Convert to sq_mi_stat units (alias for square_mile_statute), returning new variable."""
        return self.square_mile_statute

    @property
    def square_mile_us_survey(self) -> 'FieldQnty':
        """Convert to square mile (US survey) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_mile_us_survey
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_mi_US_Surv(self) -> 'FieldQnty':
        """Convert to sq_mi_US_Surv units (alias for square_mile_us_survey), returning new variable."""
        return self.square_mile_us_survey

    @property
    def square_millimeter(self) -> 'FieldQnty':
        """Convert to square millimeter units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_millimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mm_2(self) -> 'FieldQnty':
        """Convert to mathrm_mm_2 units (alias for square_millimeter), returning new variable."""
        return self.square_millimeter

    @property
    def square_nanometer(self) -> 'FieldQnty':
        """Convert to square nanometer units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_nanometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_nm_2(self) -> 'FieldQnty':
        """Convert to mathrm_nm_2 units (alias for square_nanometer), returning new variable."""
        return self.square_nanometer

    @property
    def square_yard(self) -> 'FieldQnty':
        """Convert to square yard units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.square_yard
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sq_yd(self) -> 'FieldQnty':
        """Convert to sq_yd units (alias for square_yard), returning new variable."""
        return self.square_yard

    @property
    def township_us(self) -> 'FieldQnty':
        """Convert to township (US) units, returning new variable."""
        unit_const: Final = field_units.AreaUnits.township_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def twshp(self) -> 'FieldQnty':
        """Convert to twshp units (alias for township_us), returning new variable."""
        return self.township_us


class AsUnitAreaPerUnitVolumeConverter(UnitConverter):
    """AreaPerUnitVolume-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def square_centimeter_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to square centimeter per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_centimeter_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_2_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_cc units (alias for square_centimeter_per_cubic_centimeter), returning new variable."""
        return self.square_centimeter_per_cubic_centimeter

    @property
    def square_foot_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to square foot per cubic foot units, returning new variable."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_foot_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_ft_3_or_sqft_cft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_ft_3_or_sqft_cft units (alias for square_foot_per_cubic_foot), returning new variable."""
        return self.square_foot_per_cubic_foot

    @property
    def ft_2_ft_3(self) -> 'FieldQnty':
        """Convert to ft_2_ft_3 units (alias for square_foot_per_cubic_foot), returning new variable."""
        return self.square_foot_per_cubic_foot

    @property
    def sqft_cft(self) -> 'FieldQnty':
        """Convert to sqft_cft units (alias for square_foot_per_cubic_foot), returning new variable."""
        return self.square_foot_per_cubic_foot

    @property
    def square_inch_per_cubic_inch(self) -> 'FieldQnty':
        """Convert to square inch per cubic inch units, returning new variable."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_inch_per_cubic_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_in_2_mathrm_in_3_or_sq_in_cu_in(self) -> 'FieldQnty':
        """Convert to mathrm_in_2_mathrm_in_3_or_sq_in_cu_in units (alias for square_inch_per_cubic_inch), returning new variable."""
        return self.square_inch_per_cubic_inch

    @property
    def in_2_in_3(self) -> 'FieldQnty':
        """Convert to in_2_in_3 units (alias for square_inch_per_cubic_inch), returning new variable."""
        return self.square_inch_per_cubic_inch

    @property
    def sq_in_cu_in(self) -> 'FieldQnty':
        """Convert to sq_in_cu_in units (alias for square_inch_per_cubic_inch), returning new variable."""
        return self.square_inch_per_cubic_inch

    @property
    def square_meter_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to square meter per cubic meter units, returning new variable."""
        unit_const: Final = field_units.AreaPerUnitVolumeUnits.square_meter_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_m_3_or_1_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_m_3_or_1_mathrm_m_3 units (alias for square_meter_per_cubic_meter), returning new variable."""
        return self.square_meter_per_cubic_meter

    @property
    def m_2_m_3(self) -> 'FieldQnty':
        """Convert to m_2_m_3 units (alias for square_meter_per_cubic_meter), returning new variable."""
        return self.square_meter_per_cubic_meter

    @property
    def unit_1_m_3(self) -> 'FieldQnty':
        """Convert to unit_1_m_3 units (alias for square_meter_per_cubic_meter), returning new variable."""
        return self.square_meter_per_cubic_meter


class AsUnitAtomicWeightConverter(UnitConverter):
    """AtomicWeight-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def atomic_mass_unit_12c(self) -> 'FieldQnty':
        """Convert to atomic mass unit (12C) units, returning new variable."""
        unit_const: Final = field_units.AtomicWeightUnits.atomic_mass_unit_12c
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def amu(self) -> 'FieldQnty':
        """Convert to amu units (alias for atomic_mass_unit_12c), returning new variable."""
        return self.atomic_mass_unit_12c

    @property
    def grams_per_mole(self) -> 'FieldQnty':
        """Convert to grams per mole units, returning new variable."""
        unit_const: Final = field_units.AtomicWeightUnits.grams_per_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def g_mol(self) -> 'FieldQnty':
        """Convert to g_mol units (alias for grams_per_mole), returning new variable."""
        return self.grams_per_mole

    @property
    def kilograms_per_kilomole(self) -> 'FieldQnty':
        """Convert to kilograms per kilomole units, returning new variable."""
        unit_const: Final = field_units.AtomicWeightUnits.kilograms_per_kilomole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_kmol(self) -> 'FieldQnty':
        """Convert to kg_kmol units (alias for kilograms_per_kilomole), returning new variable."""
        return self.kilograms_per_kilomole

    @property
    def pounds_per_pound_mole(self) -> 'FieldQnty':
        """Convert to pounds per pound mole units, returning new variable."""
        unit_const: Final = field_units.AtomicWeightUnits.pounds_per_pound_mole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_lb_mol_or_mathrm_lb_mole(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_lb_mol_or_mathrm_lb_mole units (alias for pounds_per_pound_mole), returning new variable."""
        return self.pounds_per_pound_mole

    @property
    def lb_lb_mol(self) -> 'FieldQnty':
        """Convert to lb_lb_mol units (alias for pounds_per_pound_mole), returning new variable."""
        return self.pounds_per_pound_mole

    @property
    def lb_mole(self) -> 'FieldQnty':
        """Convert to lb_mole units (alias for pounds_per_pound_mole), returning new variable."""
        return self.pounds_per_pound_mole


class AsUnitConcentrationConverter(UnitConverter):
    """Concentration-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def grains_of_i_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to grains of "i" per cubic foot units, returning new variable."""
        unit_const: Final = field_units.ConcentrationUnits.grains_of_i_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gr_mathrm_ft_3_or_gr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_gr_mathrm_ft_3_or_gr_cft units (alias for grains_of_i_per_cubic_foot), returning new variable."""
        return self.grains_of_i_per_cubic_foot

    @property
    def gr_ft_3(self) -> 'FieldQnty':
        """Convert to gr_ft_3 units (alias for grains_of_i_per_cubic_foot), returning new variable."""
        return self.grains_of_i_per_cubic_foot

    @property
    def gr_cft(self) -> 'FieldQnty':
        """Convert to gr_cft units (alias for grains_of_i_per_cubic_foot), returning new variable."""
        return self.grains_of_i_per_cubic_foot

    @property
    def grains_of_i_per_gallon_us(self) -> 'FieldQnty':
        """Convert to grains of "i" per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.ConcentrationUnits.grains_of_i_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gr_gal(self) -> 'FieldQnty':
        """Convert to gr_gal units (alias for grains_of_i_per_gallon_us), returning new variable."""
        return self.grains_of_i_per_gallon_us


class AsUnitDimensionlessConverter(UnitConverter):
    """Dimensionless-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dimensionless(self) -> 'FieldQnty':
        """Convert to dimensionless units, returning new variable."""
        unit_const: Final = field_units.DimensionlessUnits.dimensionless
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ratio(self) -> 'FieldQnty':
        """Convert to ratio units, returning new variable."""
        unit_const: Final = field_units.DimensionlessUnits.ratio
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def parts_per_million(self) -> 'FieldQnty':
        """Convert to parts per million units, returning new variable."""
        unit_const: Final = field_units.DimensionlessUnits.parts_per_million
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ppm(self) -> 'FieldQnty':
        """Convert to ppm units (alias for parts_per_million), returning new variable."""
        return self.parts_per_million

    @property
    def parts_per_billion(self) -> 'FieldQnty':
        """Convert to parts per billion units, returning new variable."""
        unit_const: Final = field_units.DimensionlessUnits.parts_per_billion
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ppb(self) -> 'FieldQnty':
        """Convert to ppb units (alias for parts_per_billion), returning new variable."""
        return self.parts_per_billion


class AsUnitDynamicFluidityConverter(UnitConverter):
    """DynamicFluidity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def meter_seconds_per_kilogram(self) -> 'FieldQnty':
        """Convert to meter-seconds per kilogram units, returning new variable."""
        unit_const: Final = field_units.DynamicFluidityUnits.meter_seconds_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m_s_kg(self) -> 'FieldQnty':
        """Convert to m_s_kg units (alias for meter_seconds_per_kilogram), returning new variable."""
        return self.meter_seconds_per_kilogram

    @property
    def rhe(self) -> 'FieldQnty':
        """Convert to rhe units, returning new variable."""
        unit_const: Final = field_units.DynamicFluidityUnits.rhe
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def square_foot_per_pound_second(self) -> 'FieldQnty':
        """Convert to square foot per pound second units, returning new variable."""
        unit_const: Final = field_units.DynamicFluidityUnits.square_foot_per_pound_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_lb_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_lb_sec units (alias for square_foot_per_pound_second), returning new variable."""
        return self.square_foot_per_pound_second

    @property
    def square_meters_per_newton_per_second(self) -> 'FieldQnty':
        """Convert to square meters per newton per second units, returning new variable."""
        unit_const: Final = field_units.DynamicFluidityUnits.square_meters_per_newton_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_N_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_N_mathrm_s units (alias for square_meters_per_newton_per_second), returning new variable."""
        return self.square_meters_per_newton_per_second


class AsUnitElectricCapacitanceConverter(UnitConverter):
    """ElectricCapacitance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to "cm" units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.cm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def abfarad(self) -> 'FieldQnty':
        """Convert to abfarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.abfarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abfarad), returning new variable."""
        return self.abfarad

    @property
    def farad(self) -> 'FieldQnty':
        """Convert to farad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.farad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for farad), returning new variable."""
        return self.farad

    @property
    def farad_intl(self) -> 'FieldQnty':
        """Convert to farad (intl) units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.farad_intl
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def F_int(self) -> 'FieldQnty':
        """Convert to F_int units (alias for farad_intl), returning new variable."""
        return self.farad_intl

    @property
    def jar(self) -> 'FieldQnty':
        """Convert to jar units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.jar
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def puff(self) -> 'FieldQnty':
        """Convert to puff units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.puff
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def statfarad(self) -> 'FieldQnty':
        """Convert to statfarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.statfarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statfarad), returning new variable."""
        return self.statfarad

    @property
    def millifarad(self) -> 'FieldQnty':
        """Convert to millifarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.millifarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mF(self) -> 'FieldQnty':
        """Convert to mF units (alias for millifarad), returning new variable."""
        return self.millifarad

    @property
    def microfarad(self) -> 'FieldQnty':
        """Convert to microfarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.microfarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanofarad(self) -> 'FieldQnty':
        """Convert to nanofarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.nanofarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nF(self) -> 'FieldQnty':
        """Convert to nF units (alias for nanofarad), returning new variable."""
        return self.nanofarad

    @property
    def picofarad(self) -> 'FieldQnty':
        """Convert to picofarad units, returning new variable."""
        unit_const: Final = field_units.ElectricCapacitanceUnits.picofarad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pF(self) -> 'FieldQnty':
        """Convert to pF units (alias for picofarad), returning new variable."""
        return self.picofarad


class AsUnitElectricChargeConverter(UnitConverter):
    """ElectricCharge-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abcoulomb(self) -> 'FieldQnty':
        """Convert to abcoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.abcoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abcoulomb), returning new variable."""
        return self.abcoulomb

    @property
    def ampere_hour(self) -> 'FieldQnty':
        """Convert to ampere-hour units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.ampere_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Ah(self) -> 'FieldQnty':
        """Convert to Ah units (alias for ampere_hour), returning new variable."""
        return self.ampere_hour

    @property
    def coulomb(self) -> 'FieldQnty':
        """Convert to coulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.coulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def C(self) -> 'FieldQnty':
        """Convert to C units (alias for coulomb), returning new variable."""
        return self.coulomb

    @property
    def faraday_c12(self) -> 'FieldQnty':
        """Convert to faraday (C12) units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.faraday_c12
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for faraday_c12), returning new variable."""
        return self.faraday_c12

    @property
    def franklin(self) -> 'FieldQnty':
        """Convert to franklin units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.franklin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Fr(self) -> 'FieldQnty':
        """Convert to Fr units (alias for franklin), returning new variable."""
        return self.franklin

    @property
    def statcoulomb(self) -> 'FieldQnty':
        """Convert to statcoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.statcoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statcoulomb), returning new variable."""
        return self.statcoulomb

    @property
    def u_a_charge(self) -> 'FieldQnty':
        """Convert to u.a. charge units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.u_a_charge
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_charge), returning new variable."""
        return self.u_a_charge

    @property
    def kilocoulomb(self) -> 'FieldQnty':
        """Convert to kilocoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.kilocoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kC(self) -> 'FieldQnty':
        """Convert to kC units (alias for kilocoulomb), returning new variable."""
        return self.kilocoulomb

    @property
    def millicoulomb(self) -> 'FieldQnty':
        """Convert to millicoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.millicoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mC(self) -> 'FieldQnty':
        """Convert to mC units (alias for millicoulomb), returning new variable."""
        return self.millicoulomb

    @property
    def microcoulomb(self) -> 'FieldQnty':
        """Convert to microcoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.microcoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanocoulomb(self) -> 'FieldQnty':
        """Convert to nanocoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.nanocoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nC(self) -> 'FieldQnty':
        """Convert to nC units (alias for nanocoulomb), returning new variable."""
        return self.nanocoulomb

    @property
    def picocoulomb(self) -> 'FieldQnty':
        """Convert to picocoulomb units, returning new variable."""
        unit_const: Final = field_units.ElectricChargeUnits.picocoulomb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pC(self) -> 'FieldQnty':
        """Convert to pC units (alias for picocoulomb), returning new variable."""
        return self.picocoulomb


class AsUnitElectricCurrentIntensityConverter(UnitConverter):
    """ElectricCurrentIntensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abampere(self) -> 'FieldQnty':
        """Convert to abampere units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.abampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abampere), returning new variable."""
        return self.abampere

    @property
    def ampere_intl_mean(self) -> 'FieldQnty':
        """Convert to ampere (intl mean) units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_intl_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A_int_mean(self) -> 'FieldQnty':
        """Convert to A_int_mean units (alias for ampere_intl_mean), returning new variable."""
        return self.ampere_intl_mean

    @property
    def ampere_intl_us(self) -> 'FieldQnty':
        """Convert to ampere (intl US) units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_intl_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A_int_US(self) -> 'FieldQnty':
        """Convert to A_int_US units (alias for ampere_intl_us), returning new variable."""
        return self.ampere_intl_us

    @property
    def ampere_or_amp(self) -> 'FieldQnty':
        """Convert to ampere or amp units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.ampere_or_amp
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A(self) -> 'FieldQnty':
        """Convert to A units (alias for ampere_or_amp), returning new variable."""
        return self.ampere_or_amp

    @property
    def biot(self) -> 'FieldQnty':
        """Convert to biot units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.biot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def statampere(self) -> 'FieldQnty':
        """Convert to statampere units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.statampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statampere), returning new variable."""
        return self.statampere

    @property
    def u_a_or_current(self) -> 'FieldQnty':
        """Convert to u.a. or current units, returning new variable."""
        unit_const: Final = field_units.ElectricCurrentIntensityUnits.u_a_or_current
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_or_current), returning new variable."""
        return self.u_a_or_current


class AsUnitElectricDipoleMomentConverter(UnitConverter):
    """ElectricDipoleMoment-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def ampere_meter_second(self) -> 'FieldQnty':
        """Convert to ampere meter second units, returning new variable."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.ampere_meter_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A_m_s(self) -> 'FieldQnty':
        """Convert to A_m_s units (alias for ampere_meter_second), returning new variable."""
        return self.ampere_meter_second

    @property
    def coulomb_meter(self) -> 'FieldQnty':
        """Convert to coulomb meter units, returning new variable."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.coulomb_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def C_m(self) -> 'FieldQnty':
        """Convert to C_m units (alias for coulomb_meter), returning new variable."""
        return self.coulomb_meter

    @property
    def debye(self) -> 'FieldQnty':
        """Convert to debye units, returning new variable."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.debye
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def D(self) -> 'FieldQnty':
        """Convert to D units (alias for debye), returning new variable."""
        return self.debye

    @property
    def electron_meter(self) -> 'FieldQnty':
        """Convert to electron meter units, returning new variable."""
        unit_const: Final = field_units.ElectricDipoleMomentUnits.electron_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def e_m(self) -> 'FieldQnty':
        """Convert to e_m units (alias for electron_meter), returning new variable."""
        return self.electron_meter


class AsUnitElectricFieldStrengthConverter(UnitConverter):
    """ElectricFieldStrength-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def volt_per_centimeter(self) -> 'FieldQnty':
        """Convert to volt per centimeter units, returning new variable."""
        unit_const: Final = field_units.ElectricFieldStrengthUnits.volt_per_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def V_cm(self) -> 'FieldQnty':
        """Convert to V_cm units (alias for volt_per_centimeter), returning new variable."""
        return self.volt_per_centimeter

    @property
    def volt_per_meter(self) -> 'FieldQnty':
        """Convert to volt per meter units, returning new variable."""
        unit_const: Final = field_units.ElectricFieldStrengthUnits.volt_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def V_m(self) -> 'FieldQnty':
        """Convert to V_m units (alias for volt_per_meter), returning new variable."""
        return self.volt_per_meter


class AsUnitElectricInductanceConverter(UnitConverter):
    """ElectricInductance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abhenry(self) -> 'FieldQnty':
        """Convert to abhenry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.abhenry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abhenry), returning new variable."""
        return self.abhenry

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to cm units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.cm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def henry(self) -> 'FieldQnty':
        """Convert to henry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def H(self) -> 'FieldQnty':
        """Convert to H units (alias for henry), returning new variable."""
        return self.henry

    @property
    def henry_intl_mean(self) -> 'FieldQnty':
        """Convert to henry (intl mean) units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry_intl_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def H_int_mean(self) -> 'FieldQnty':
        """Convert to H_int_mean units (alias for henry_intl_mean), returning new variable."""
        return self.henry_intl_mean

    @property
    def henry_intl_us(self) -> 'FieldQnty':
        """Convert to henry (intl US) units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.henry_intl_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def H_int_US(self) -> 'FieldQnty':
        """Convert to H_int_US units (alias for henry_intl_us), returning new variable."""
        return self.henry_intl_us

    @property
    def mic(self) -> 'FieldQnty':
        """Convert to mic units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.mic
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def stathenry(self) -> 'FieldQnty':
        """Convert to stathenry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.stathenry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for stathenry), returning new variable."""
        return self.stathenry

    @property
    def millihenry(self) -> 'FieldQnty':
        """Convert to millihenry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.millihenry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mH(self) -> 'FieldQnty':
        """Convert to mH units (alias for millihenry), returning new variable."""
        return self.millihenry

    @property
    def microhenry(self) -> 'FieldQnty':
        """Convert to microhenry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.microhenry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanohenry(self) -> 'FieldQnty':
        """Convert to nanohenry units, returning new variable."""
        unit_const: Final = field_units.ElectricInductanceUnits.nanohenry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nH(self) -> 'FieldQnty':
        """Convert to nH units (alias for nanohenry), returning new variable."""
        return self.nanohenry


class AsUnitElectricPotentialConverter(UnitConverter):
    """ElectricPotential-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abvolt(self) -> 'FieldQnty':
        """Convert to abvolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.abvolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abvolt), returning new variable."""
        return self.abvolt

    @property
    def statvolt(self) -> 'FieldQnty':
        """Convert to statvolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.statvolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu_cgs units (alias for statvolt), returning new variable."""
        return self.statvolt

    @property
    def u_a_potential(self) -> 'FieldQnty':
        """Convert to u.a. potential units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.u_a_potential
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u_a units (alias for u_a_potential), returning new variable."""
        return self.u_a_potential

    @property
    def volt(self) -> 'FieldQnty':
        """Convert to volt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def V(self) -> 'FieldQnty':
        """Convert to V units (alias for volt), returning new variable."""
        return self.volt

    @property
    def volt_intl_mean(self) -> 'FieldQnty':
        """Convert to volt (intl mean) units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt_intl_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def V_int_mean(self) -> 'FieldQnty':
        """Convert to V_int_mean units (alias for volt_intl_mean), returning new variable."""
        return self.volt_intl_mean

    @property
    def volt_us(self) -> 'FieldQnty':
        """Convert to volt (US) units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.volt_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def V_int_US(self) -> 'FieldQnty':
        """Convert to V_int_US units (alias for volt_us), returning new variable."""
        return self.volt_us

    @property
    def kilovolt(self) -> 'FieldQnty':
        """Convert to kilovolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.kilovolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kV(self) -> 'FieldQnty':
        """Convert to kV units (alias for kilovolt), returning new variable."""
        return self.kilovolt

    @property
    def millivolt(self) -> 'FieldQnty':
        """Convert to millivolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.millivolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mV(self) -> 'FieldQnty':
        """Convert to mV units (alias for millivolt), returning new variable."""
        return self.millivolt

    @property
    def microvolt(self) -> 'FieldQnty':
        """Convert to microvolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.microvolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanovolt(self) -> 'FieldQnty':
        """Convert to nanovolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.nanovolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nV(self) -> 'FieldQnty':
        """Convert to nV units (alias for nanovolt), returning new variable."""
        return self.nanovolt

    @property
    def picovolt(self) -> 'FieldQnty':
        """Convert to picovolt units, returning new variable."""
        unit_const: Final = field_units.ElectricPotentialUnits.picovolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pV(self) -> 'FieldQnty':
        """Convert to pV units (alias for picovolt), returning new variable."""
        return self.picovolt


class AsUnitElectricResistanceConverter(UnitConverter):
    """ElectricResistance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abohm(self) -> 'FieldQnty':
        """Convert to abohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.abohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abohm), returning new variable."""
        return self.abohm

    @property
    def jacobi(self) -> 'FieldQnty':
        """Convert to jacobi units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.jacobi
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for jacobi), returning new variable."""
        return self.jacobi

    @property
    def lenz(self) -> 'FieldQnty':
        """Convert to lenz units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.lenz
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Metric(self) -> 'FieldQnty':
        """Convert to Metric units (alias for lenz), returning new variable."""
        return self.lenz

    @property
    def ohm(self) -> 'FieldQnty':
        """Convert to ohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Omega(self) -> 'FieldQnty':
        """Convert to Omega units (alias for ohm), returning new variable."""
        return self.ohm

    @property
    def ohm_intl_mean(self) -> 'FieldQnty':
        """Convert to ohm (intl mean) units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_intl_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Omega_int_mean(self) -> 'FieldQnty':
        """Convert to Omega_int_mean units (alias for ohm_intl_mean), returning new variable."""
        return self.ohm_intl_mean

    @property
    def ohm_intl_us(self) -> 'FieldQnty':
        """Convert to ohm (intl US) units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_intl_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Omega_int_US(self) -> 'FieldQnty':
        """Convert to Omega_int_US units (alias for ohm_intl_us), returning new variable."""
        return self.ohm_intl_us

    @property
    def ohm_legal(self) -> 'FieldQnty':
        """Convert to ohm (legal) units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.ohm_legal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Omega_legal(self) -> 'FieldQnty':
        """Convert to Omega_legal units (alias for ohm_legal), returning new variable."""
        return self.ohm_legal

    @property
    def preece(self) -> 'FieldQnty':
        """Convert to preece units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.preece
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def statohm(self) -> 'FieldQnty':
        """Convert to statohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.statohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def csu_cgs(self) -> 'FieldQnty':
        """Convert to csu_cgs units (alias for statohm), returning new variable."""
        return self.statohm

    @property
    def wheatstone(self) -> 'FieldQnty':
        """Convert to wheatstone units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.wheatstone
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kiloohm(self) -> 'FieldQnty':
        """Convert to kiloohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.kiloohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def k_Omega(self) -> 'FieldQnty':
        """Convert to k_Omega units (alias for kiloohm), returning new variable."""
        return self.kiloohm

    @property
    def megaohm(self) -> 'FieldQnty':
        """Convert to megaohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.megaohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def M_Omega(self) -> 'FieldQnty':
        """Convert to M_Omega units (alias for megaohm), returning new variable."""
        return self.megaohm

    @property
    def milliohm(self) -> 'FieldQnty':
        """Convert to milliohm units, returning new variable."""
        unit_const: Final = field_units.ElectricResistanceUnits.milliohm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m_Omega(self) -> 'FieldQnty':
        """Convert to m_Omega units (alias for milliohm), returning new variable."""
        return self.milliohm


class AsUnitElectricalConductanceConverter(UnitConverter):
    """ElectricalConductance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu cgs units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.emu_cgs
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def abmho(self) -> 'FieldQnty':
        """Convert to abmho units (alias for emu_cgs), returning new variable."""
        return self.emu_cgs

    @property
    def esu_cgs(self) -> 'FieldQnty':
        """Convert to esu cgs units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.esu_cgs
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def statmho(self) -> 'FieldQnty':
        """Convert to statmho units (alias for esu_cgs), returning new variable."""
        return self.esu_cgs

    @property
    def mho(self) -> 'FieldQnty':
        """Convert to mho units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.mho
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def microsiemens(self) -> 'FieldQnty':
        """Convert to microsiemens units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.microsiemens
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_S(self) -> 'FieldQnty':
        """Convert to mu_mathrm_S units (alias for microsiemens), returning new variable."""
        return self.microsiemens

    @property
    def siemens(self) -> 'FieldQnty':
        """Convert to siemens units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.siemens
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def S(self) -> 'FieldQnty':
        """Convert to S units (alias for siemens), returning new variable."""
        return self.siemens

    @property
    def millisiemens(self) -> 'FieldQnty':
        """Convert to millisiemens units, returning new variable."""
        unit_const: Final = field_units.ElectricalConductanceUnits.millisiemens
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mS(self) -> 'FieldQnty':
        """Convert to mS units (alias for millisiemens), returning new variable."""
        return self.millisiemens


class AsUnitElectricalPermittivityConverter(UnitConverter):
    """ElectricalPermittivity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def farad_per_meter(self) -> 'FieldQnty':
        """Convert to farad per meter units, returning new variable."""
        unit_const: Final = field_units.ElectricalPermittivityUnits.farad_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def F_m(self) -> 'FieldQnty':
        """Convert to F_m units (alias for farad_per_meter), returning new variable."""
        return self.farad_per_meter


class AsUnitElectricalResistivityConverter(UnitConverter):
    """ElectricalResistivity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def circular_mil_ohm_per_foot(self) -> 'FieldQnty':
        """Convert to circular mil-ohm per foot units, returning new variable."""
        unit_const: Final = field_units.ElectricalResistivityUnits.circular_mil_ohm_per_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def circmil_Omega_mathrm_ft(self) -> 'FieldQnty':
        """Convert to circmil_Omega_mathrm_ft units (alias for circular_mil_ohm_per_foot), returning new variable."""
        return self.circular_mil_ohm_per_foot

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu cgs units, returning new variable."""
        unit_const: Final = field_units.ElectricalResistivityUnits.emu_cgs
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def abohm_cm(self) -> 'FieldQnty':
        """Convert to abohm_cm units (alias for emu_cgs), returning new variable."""
        return self.emu_cgs

    @property
    def microhm_inch(self) -> 'FieldQnty':
        """Convert to microhm-inch units, returning new variable."""
        unit_const: Final = field_units.ElectricalResistivityUnits.microhm_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_Omega_in(self) -> 'FieldQnty':
        """Convert to mu_Omega_in units (alias for microhm_inch), returning new variable."""
        return self.microhm_inch

    @property
    def ohm_centimeter(self) -> 'FieldQnty':
        """Convert to ohm-centimeter units, returning new variable."""
        unit_const: Final = field_units.ElectricalResistivityUnits.ohm_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def boldsymbol_Omega_mathbf_c_m(self) -> 'FieldQnty':
        """Convert to boldsymbol_Omega_mathbf_c_m units (alias for ohm_centimeter), returning new variable."""
        return self.ohm_centimeter

    @property
    def ohm_meter(self) -> 'FieldQnty':
        """Convert to ohm-meter units, returning new variable."""
        unit_const: Final = field_units.ElectricalResistivityUnits.ohm_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Omega_mathrm_m(self) -> 'FieldQnty':
        """Convert to Omega_mathrm_m units (alias for ohm_meter), returning new variable."""
        return self.ohm_meter


class AsUnitEnergyFluxConverter(UnitConverter):
    """EnergyFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to Btu per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.btu_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_2_mathrm_hr units (alias for btu_per_square_foot_per_hour), returning new variable."""
        return self.btu_per_square_foot_per_hour

    @property
    def calorie_per_square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to calorie per square centimeter per second units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.calorie_per_square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_cm_2_mathrm_s_or_mathrm_cal_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_cm_2_mathrm_s_or_mathrm_cal_mathrm_cm_2_mathrm_s units (alias for calorie_per_square_centimeter_per_second), returning new variable."""
        return self.calorie_per_square_centimeter_per_second

    @property
    def cal_cm_2_s(self) -> 'FieldQnty':
        """Convert to cal_cm_2_s units (alias for calorie_per_square_centimeter_per_second), returning new variable."""
        return self.calorie_per_square_centimeter_per_second

    @property
    def celsius_heat_units_chu(self) -> 'FieldQnty':
        """Convert to Celsius heat units (Chu) per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.celsius_heat_units_chu
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Chu_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_Chu_mathrm_ft_2_mathrm_hr units (alias for celsius_heat_units_chu), returning new variable."""
        return self.celsius_heat_units_chu

    @property
    def kilocalorie_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to kilocalorie per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.kilocalorie_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_left_mathrm_ft_2_mathrm_hr_right(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_left_mathrm_ft_2_mathrm_hr_right units (alias for kilocalorie_per_square_foot_per_hour), returning new variable."""
        return self.kilocalorie_per_square_foot_per_hour

    @property
    def kilocalorie_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kilocalorie per square meter per hour units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.kilocalorie_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_left_mathrm_m_2_mathrm_hr_right(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_left_mathrm_m_2_mathrm_hr_right units (alias for kilocalorie_per_square_meter_per_hour), returning new variable."""
        return self.kilocalorie_per_square_meter_per_hour

    @property
    def watt_per_square_meter(self) -> 'FieldQnty':
        """Convert to watt per square meter units, returning new variable."""
        unit_const: Final = field_units.EnergyFluxUnits.watt_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_W_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_W_mathrm_m_2 units (alias for watt_per_square_meter), returning new variable."""
        return self.watt_per_square_meter


class AsUnitEnergyHeatWorkConverter(UnitConverter):
    """EnergyHeatWork-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def barrel_oil_equivalent_or_equivalent_barrel(self) -> 'FieldQnty':
        """Convert to barrel oil equivalent or equivalent barrel units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.barrel_oil_equivalent_or_equivalent_barrel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def bboe_or_boe(self) -> 'FieldQnty':
        """Convert to bboe_or_boe units (alias for barrel_oil_equivalent_or_equivalent_barrel), returning new variable."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def bboe(self) -> 'FieldQnty':
        """Convert to bboe units (alias for barrel_oil_equivalent_or_equivalent_barrel), returning new variable."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def boe(self) -> 'FieldQnty':
        """Convert to boe units (alias for barrel_oil_equivalent_or_equivalent_barrel), returning new variable."""
        return self.barrel_oil_equivalent_or_equivalent_barrel

    @property
    def billion_electronvolt(self) -> 'FieldQnty':
        """Convert to billion electronvolt units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.billion_electronvolt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def BeV(self) -> 'FieldQnty':
        """Convert to BeV units (alias for billion_electronvolt), returning new variable."""
        return self.billion_electronvolt

    @property
    def british_thermal_unit_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to British thermal unit ( $4^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_39_2_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_39_2_circ_mathrm_F units (alias for british_thermal_unit_4circ_mathrmc), returning new variable."""
        return self.british_thermal_unit_4circ_mathrmc

    @property
    def british_thermal_unit_60circ_mathrmf(self) -> 'FieldQnty':
        """Convert to British thermal unit ( $60^{\\circ} \\mathrm{F}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_60circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_60_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_60_circ_mathrm_F units (alias for british_thermal_unit_60circ_mathrmf), returning new variable."""
        return self.british_thermal_unit_60circ_mathrmf

    @property
    def british_thermal_unit_international_steam_tables(self) -> 'FieldQnty':
        """Convert to British thermal unit (international steam tables) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_international_steam_tables
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_IT(self) -> 'FieldQnty':
        """Convert to Btu_IT units (alias for british_thermal_unit_international_steam_tables), returning new variable."""
        return self.british_thermal_unit_international_steam_tables

    @property
    def british_thermal_unit_isotc_12(self) -> 'FieldQnty':
        """Convert to British thermal unit (ISO/TC 12) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_isotc_12
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_ISO(self) -> 'FieldQnty':
        """Convert to Btu_ISO units (alias for british_thermal_unit_isotc_12), returning new variable."""
        return self.british_thermal_unit_isotc_12

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_mean_or_Btu(self) -> 'FieldQnty':
        """Convert to Btu_mean_or_Btu units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def Btu_mean(self) -> 'FieldQnty':
        """Convert to Btu_mean units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def Btu(self) -> 'FieldQnty':
        """Convert to Btu units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_thermochemical(self) -> 'FieldQnty':
        """Convert to British thermal unit (thermochemical) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.british_thermal_unit_thermochemical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_therm(self) -> 'FieldQnty':
        """Convert to Btu_therm units (alias for british_thermal_unit_thermochemical), returning new variable."""
        return self.british_thermal_unit_thermochemical

    @property
    def calorie_20circ_mathrmc(self) -> 'FieldQnty':
        """Convert to calorie ( $20^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_20circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_20_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to cal_20_circ_mathrm_C units (alias for calorie_20circ_mathrmc), returning new variable."""
        return self.calorie_20circ_mathrmc

    @property
    def calorie_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to calorie ( $4^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_4_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to cal_4_circ_mathrm_C units (alias for calorie_4circ_mathrmc), returning new variable."""
        return self.calorie_4circ_mathrmc

    @property
    def calorie_international_steam_tables(self) -> 'FieldQnty':
        """Convert to calorie (international steam tables) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_international_steam_tables
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_IT(self) -> 'FieldQnty':
        """Convert to cal_IT units (alias for calorie_international_steam_tables), returning new variable."""
        return self.calorie_international_steam_tables

    @property
    def calorie_mean(self) -> 'FieldQnty':
        """Convert to calorie (mean) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_mean(self) -> 'FieldQnty':
        """Convert to cal_mean units (alias for calorie_mean), returning new variable."""
        return self.calorie_mean

    @property
    def calorie_nutritional(self) -> 'FieldQnty':
        """Convert to Calorie (nutritional) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_nutritional
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Cal_nutr(self) -> 'FieldQnty':
        """Convert to Cal_nutr units (alias for calorie_nutritional), returning new variable."""
        return self.calorie_nutritional

    @property
    def calorie_thermochemical(self) -> 'FieldQnty':
        """Convert to calorie (thermochemical) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.calorie_thermochemical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_therm(self) -> 'FieldQnty':
        """Convert to cal_therm units (alias for calorie_thermochemical), returning new variable."""
        return self.calorie_thermochemical

    @property
    def celsius_heat_unit(self) -> 'FieldQnty':
        """Convert to Celsius heat unit units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.celsius_heat_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu(self) -> 'FieldQnty':
        """Convert to Chu units (alias for celsius_heat_unit), returning new variable."""
        return self.celsius_heat_unit

    @property
    def celsius_heat_unit_15_circ_mathrmc(self) -> 'FieldQnty':
        """Convert to Celsius heat unit ( $15{ }^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.celsius_heat_unit_15_circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_15_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to Chu_15_circ_mathrm_C units (alias for celsius_heat_unit_15_circ_mathrmc), returning new variable."""
        return self.celsius_heat_unit_15_circ_mathrmc

    @property
    def electron_volt(self) -> 'FieldQnty':
        """Convert to electron volt units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.electron_volt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def eV(self) -> 'FieldQnty':
        """Convert to eV units (alias for electron_volt), returning new variable."""
        return self.electron_volt

    @property
    def erg(self) -> 'FieldQnty':
        """Convert to erg units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.erg
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def foot_pound_force_duty(self) -> 'FieldQnty':
        """Convert to foot pound force (duty) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.foot_pound_force_duty
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to ft_mathrm_lb_mathrm_f units (alias for foot_pound_force_duty), returning new variable."""
        return self.foot_pound_force_duty

    @property
    def foot_poundal(self) -> 'FieldQnty':
        """Convert to foot-poundal units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.foot_poundal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_pdl(self) -> 'FieldQnty':
        """Convert to ft_pdl units (alias for foot_poundal), returning new variable."""
        return self.foot_poundal

    @property
    def frigorie(self) -> 'FieldQnty':
        """Convert to frigorie units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.frigorie
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fg(self) -> 'FieldQnty':
        """Convert to fg units (alias for frigorie), returning new variable."""
        return self.frigorie

    @property
    def hartree_atomic_unit_of_energy(self) -> 'FieldQnty':
        """Convert to hartree (atomic unit of energy) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.hartree_atomic_unit_of_energy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_E_mathrm_H_a_u(self) -> 'FieldQnty':
        """Convert to mathrm_E_mathrm_H_a_u units (alias for hartree_atomic_unit_of_energy), returning new variable."""
        return self.hartree_atomic_unit_of_energy

    @property
    def joule(self) -> 'FieldQnty':
        """Convert to joule units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.joule
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J(self) -> 'FieldQnty':
        """Convert to J units (alias for joule), returning new variable."""
        return self.joule

    @property
    def joule_international(self) -> 'FieldQnty':
        """Convert to joule (international) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.joule_international
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_intl(self) -> 'FieldQnty':
        """Convert to J_intl units (alias for joule_international), returning new variable."""
        return self.joule_international

    @property
    def kilocalorie_thermal(self) -> 'FieldQnty':
        """Convert to kilocalorie (thermal) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilocalorie_thermal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kcal_therm(self) -> 'FieldQnty':
        """Convert to kcal_therm units (alias for kilocalorie_thermal), returning new variable."""
        return self.kilocalorie_thermal

    @property
    def kilogram_force_meter(self) -> 'FieldQnty':
        """Convert to kilogram force meter units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilogram_force_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_m(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_m units (alias for kilogram_force_meter), returning new variable."""
        return self.kilogram_force_meter

    @property
    def kiloton_tnt(self) -> 'FieldQnty':
        """Convert to kiloton (TNT) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kiloton_tnt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kt_TNT(self) -> 'FieldQnty':
        """Convert to kt_TNT units (alias for kiloton_tnt), returning new variable."""
        return self.kiloton_tnt

    @property
    def kilowatt_hour(self) -> 'FieldQnty':
        """Convert to kilowatt hour units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilowatt_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kWh(self) -> 'FieldQnty':
        """Convert to kWh units (alias for kilowatt_hour), returning new variable."""
        return self.kilowatt_hour

    @property
    def liter_atmosphere(self) -> 'FieldQnty':
        """Convert to liter atmosphere units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.liter_atmosphere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def L_atm(self) -> 'FieldQnty':
        """Convert to L_atm units (alias for liter_atmosphere), returning new variable."""
        return self.liter_atmosphere

    @property
    def megaton_tnt(self) -> 'FieldQnty':
        """Convert to megaton (TNT) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.megaton_tnt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Mt_TNT(self) -> 'FieldQnty':
        """Convert to Mt_TNT units (alias for megaton_tnt), returning new variable."""
        return self.megaton_tnt

    @property
    def pound_centigrade_unit_15circ_mathrmc(self) -> 'FieldQnty':
        """Convert to pound centigrade unit ( $15^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.pound_centigrade_unit_15circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pcu_15_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to pcu_15_circ_mathrm_C units (alias for pound_centigrade_unit_15circ_mathrmc), returning new variable."""
        return self.pound_centigrade_unit_15circ_mathrmc

    @property
    def prout(self) -> 'FieldQnty':
        """Convert to prout units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.prout
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def q_unit(self) -> 'FieldQnty':
        """Convert to Q unit units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.q_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Q(self) -> 'FieldQnty':
        """Convert to Q units (alias for q_unit), returning new variable."""
        return self.q_unit

    @property
    def quad_quadrillion_btu(self) -> 'FieldQnty':
        """Convert to quad (quadrillion Btu) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.quad_quadrillion_btu
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def quad(self) -> 'FieldQnty':
        """Convert to quad units (alias for quad_quadrillion_btu), returning new variable."""
        return self.quad_quadrillion_btu

    @property
    def rydberg(self) -> 'FieldQnty':
        """Convert to rydberg units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.rydberg
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Ry(self) -> 'FieldQnty':
        """Convert to Ry units (alias for rydberg), returning new variable."""
        return self.rydberg

    @property
    def therm_eeg(self) -> 'FieldQnty':
        """Convert to therm (EEG) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_eeg
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def therm_EEG(self) -> 'FieldQnty':
        """Convert to therm_EEG units (alias for therm_eeg), returning new variable."""
        return self.therm_eeg

    @property
    def therm_refineries(self) -> 'FieldQnty':
        """Convert to therm (refineries) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_refineries
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def therm_refy_or_therm(self) -> 'FieldQnty':
        """Convert to therm_refy_or_therm units (alias for therm_refineries), returning new variable."""
        return self.therm_refineries

    @property
    def therm_refy(self) -> 'FieldQnty':
        """Convert to therm_refy units (alias for therm_refineries), returning new variable."""
        return self.therm_refineries

    @property
    def therm(self) -> 'FieldQnty':
        """Convert to therm units (alias for therm_refineries), returning new variable."""
        return self.therm_refineries

    @property
    def therm_us(self) -> 'FieldQnty':
        """Convert to therm (US) units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.therm_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def therm_US_or_therm(self) -> 'FieldQnty':
        """Convert to therm_US_or_therm units (alias for therm_us), returning new variable."""
        return self.therm_us

    @property
    def ton_coal_equivalent(self) -> 'FieldQnty':
        """Convert to ton coal equivalent units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.ton_coal_equivalent
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tce_tec(self) -> 'FieldQnty':
        """Convert to tce_tec units (alias for ton_coal_equivalent), returning new variable."""
        return self.ton_coal_equivalent

    @property
    def ton_oil_equivalent(self) -> 'FieldQnty':
        """Convert to ton oil equivalent units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.ton_oil_equivalent
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def toe_tep(self) -> 'FieldQnty':
        """Convert to toe_tep units (alias for ton_oil_equivalent), returning new variable."""
        return self.ton_oil_equivalent

    @property
    def kilojoule(self) -> 'FieldQnty':
        """Convert to kilojoule units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.kilojoule
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kJ(self) -> 'FieldQnty':
        """Convert to kJ units (alias for kilojoule), returning new variable."""
        return self.kilojoule

    @property
    def megajoule(self) -> 'FieldQnty':
        """Convert to megajoule units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.megajoule
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MJ(self) -> 'FieldQnty':
        """Convert to MJ units (alias for megajoule), returning new variable."""
        return self.megajoule

    @property
    def gigajoule(self) -> 'FieldQnty':
        """Convert to gigajoule units, returning new variable."""
        unit_const: Final = field_units.EnergyHeatWorkUnits.gigajoule
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def GJ(self) -> 'FieldQnty':
        """Convert to GJ units (alias for gigajoule), returning new variable."""
        return self.gigajoule


class AsUnitEnergyPerUnitAreaConverter(UnitConverter):
    """EnergyPerUnitArea-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_square_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per square foot units, returning new variable."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.british_thermal_unit_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_mathrm_ft_2_or_Btu_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_2_or_Btu_sq_ft units (alias for british_thermal_unit_per_square_foot), returning new variable."""
        return self.british_thermal_unit_per_square_foot

    @property
    def Btu_ft_2(self) -> 'FieldQnty':
        """Convert to Btu_ft_2 units (alias for british_thermal_unit_per_square_foot), returning new variable."""
        return self.british_thermal_unit_per_square_foot

    @property
    def Btu_sq_ft(self) -> 'FieldQnty':
        """Convert to Btu_sq_ft units (alias for british_thermal_unit_per_square_foot), returning new variable."""
        return self.british_thermal_unit_per_square_foot

    @property
    def joule_per_square_meter(self) -> 'FieldQnty':
        """Convert to joule per square meter units, returning new variable."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.joule_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_J_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_J_mathrm_m_2 units (alias for joule_per_square_meter), returning new variable."""
        return self.joule_per_square_meter

    @property
    def langley(self) -> 'FieldQnty':
        """Convert to Langley units, returning new variable."""
        unit_const: Final = field_units.EnergyPerUnitAreaUnits.langley
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Ly(self) -> 'FieldQnty':
        """Convert to Ly units (alias for langley), returning new variable."""
        return self.langley


class AsUnitForceConverter(UnitConverter):
    """Force-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def crinal(self) -> 'FieldQnty':
        """Convert to crinal units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.crinal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyne(self) -> 'FieldQnty':
        """Convert to dyne units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.dyne
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn(self) -> 'FieldQnty':
        """Convert to dyn units (alias for dyne), returning new variable."""
        return self.dyne

    @property
    def funal(self) -> 'FieldQnty':
        """Convert to funal units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.funal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kilogram_force(self) -> 'FieldQnty':
        """Convert to kilogram force units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.kilogram_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f units (alias for kilogram_force), returning new variable."""
        return self.kilogram_force

    @property
    def kip_force(self) -> 'FieldQnty':
        """Convert to kip force units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.kip_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def operatorname_kip_mathrm_f(self) -> 'FieldQnty':
        """Convert to operatorname_kip_mathrm_f units (alias for kip_force), returning new variable."""
        return self.kip_force

    @property
    def newton(self) -> 'FieldQnty':
        """Convert to newton units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.newton
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N(self) -> 'FieldQnty':
        """Convert to N units (alias for newton), returning new variable."""
        return self.newton

    @property
    def ounce_force(self) -> 'FieldQnty':
        """Convert to ounce force units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.ounce_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_oz_mathrm_f_or_oz(self) -> 'FieldQnty':
        """Convert to mathrm_oz_mathrm_f_or_oz units (alias for ounce_force), returning new variable."""
        return self.ounce_force

    @property
    def oz_f(self) -> 'FieldQnty':
        """Convert to oz_f units (alias for ounce_force), returning new variable."""
        return self.ounce_force

    @property
    def oz(self) -> 'FieldQnty':
        """Convert to oz units (alias for ounce_force), returning new variable."""
        return self.ounce_force

    @property
    def pond(self) -> 'FieldQnty':
        """Convert to pond units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.pond
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def p(self) -> 'FieldQnty':
        """Convert to p units (alias for pond), returning new variable."""
        return self.pond

    @property
    def pound_force(self) -> 'FieldQnty':
        """Convert to pound force units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.pound_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_or_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_or_lb units (alias for pound_force), returning new variable."""
        return self.pound_force

    @property
    def lb_f(self) -> 'FieldQnty':
        """Convert to lb_f units (alias for pound_force), returning new variable."""
        return self.pound_force

    @property
    def lb(self) -> 'FieldQnty':
        """Convert to lb units (alias for pound_force), returning new variable."""
        return self.pound_force

    @property
    def poundal(self) -> 'FieldQnty':
        """Convert to poundal units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.poundal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pdl(self) -> 'FieldQnty':
        """Convert to pdl units (alias for poundal), returning new variable."""
        return self.poundal

    @property
    def slug_force(self) -> 'FieldQnty':
        """Convert to slug force units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.slug_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def operatorname_slug_f(self) -> 'FieldQnty':
        """Convert to operatorname_slug_f units (alias for slug_force), returning new variable."""
        return self.slug_force

    @property
    def sth_ne(self) -> 'FieldQnty':
        """Convert to sthène units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.sth_ne
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sn(self) -> 'FieldQnty':
        """Convert to sn units (alias for sth_ne), returning new variable."""
        return self.sth_ne

    @property
    def ton_force_long(self) -> 'FieldQnty':
        """Convert to ton (force, long) units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.ton_force_long
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def LT(self) -> 'FieldQnty':
        """Convert to LT units (alias for ton_force_long), returning new variable."""
        return self.ton_force_long

    @property
    def ton_force_metric(self) -> 'FieldQnty':
        """Convert to ton (force, metric) units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.ton_force_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MT(self) -> 'FieldQnty':
        """Convert to MT units (alias for ton_force_metric), returning new variable."""
        return self.ton_force_metric

    @property
    def ton_force_short(self) -> 'FieldQnty':
        """Convert to ton (force, short) units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.ton_force_short
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def T(self) -> 'FieldQnty':
        """Convert to T units (alias for ton_force_short), returning new variable."""
        return self.ton_force_short

    @property
    def kilonewton(self) -> 'FieldQnty':
        """Convert to kilonewton units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.kilonewton
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kN(self) -> 'FieldQnty':
        """Convert to kN units (alias for kilonewton), returning new variable."""
        return self.kilonewton

    @property
    def millinewton(self) -> 'FieldQnty':
        """Convert to millinewton units, returning new variable."""
        unit_const: Final = field_units.ForceUnits.millinewton
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mN(self) -> 'FieldQnty':
        """Convert to mN units (alias for millinewton), returning new variable."""
        return self.millinewton


class AsUnitForceBodyConverter(UnitConverter):
    """ForceBody-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dyne_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.dyne_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_cc_or_dyn_mathrm_cm_3(self) -> 'FieldQnty':
        """Convert to dyn_cc_or_dyn_mathrm_cm_3 units (alias for dyne_per_cubic_centimeter), returning new variable."""
        return self.dyne_per_cubic_centimeter

    @property
    def dyn_cc(self) -> 'FieldQnty':
        """Convert to dyn_cc units (alias for dyne_per_cubic_centimeter), returning new variable."""
        return self.dyne_per_cubic_centimeter

    @property
    def dyn_cm_3(self) -> 'FieldQnty':
        """Convert to dyn_cm_3 units (alias for dyne_per_cubic_centimeter), returning new variable."""
        return self.dyne_per_cubic_centimeter

    @property
    def kilogram_force_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.kilogram_force_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_cm_3 units (alias for kilogram_force_per_cubic_centimeter), returning new variable."""
        return self.kilogram_force_per_cubic_centimeter

    @property
    def kilogram_force_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per cubic meter units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.kilogram_force_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_3 units (alias for kilogram_force_per_cubic_meter), returning new variable."""
        return self.kilogram_force_per_cubic_meter

    @property
    def newton_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to newton per cubic meter units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.newton_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_N_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_3 units (alias for newton_per_cubic_meter), returning new variable."""
        return self.newton_per_cubic_meter

    @property
    def pound_force_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound force per cubic foot units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.pound_force_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_cft units (alias for pound_force_per_cubic_foot), returning new variable."""
        return self.pound_force_per_cubic_foot

    @property
    def pound_force_per_cubic_inch(self) -> 'FieldQnty':
        """Convert to pound force per cubic inch units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.pound_force_per_cubic_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_cu_mathrm_in(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_cu_mathrm_in units (alias for pound_force_per_cubic_inch), returning new variable."""
        return self.pound_force_per_cubic_inch

    @property
    def ton_force_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to ton force per cubic foot units, returning new variable."""
        unit_const: Final = field_units.ForceBodyUnits.ton_force_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ton_mathrm_f_mathrm_cft(self) -> 'FieldQnty':
        """Convert to ton_mathrm_f_mathrm_cft units (alias for ton_force_per_cubic_foot), returning new variable."""
        return self.ton_force_per_cubic_foot


class AsUnitForcePerUnitMassConverter(UnitConverter):
    """ForcePerUnitMass-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dyne_per_gram(self) -> 'FieldQnty':
        """Convert to dyne per gram units, returning new variable."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.dyne_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_g(self) -> 'FieldQnty':
        """Convert to dyn_g units (alias for dyne_per_gram), returning new variable."""
        return self.dyne_per_gram

    @property
    def kilogram_force_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram force per kilogram units, returning new variable."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.kilogram_force_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_kg units (alias for kilogram_force_per_kilogram), returning new variable."""
        return self.kilogram_force_per_kilogram

    @property
    def newton_per_kilogram(self) -> 'FieldQnty':
        """Convert to newton per kilogram units, returning new variable."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.newton_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N_kg(self) -> 'FieldQnty':
        """Convert to N_kg units (alias for newton_per_kilogram), returning new variable."""
        return self.newton_per_kilogram

    @property
    def pound_force_per_pound_mass(self) -> 'FieldQnty':
        """Convert to pound force per pound mass units, returning new variable."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.pound_force_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_lb_or_mathrm_lb_mathrm_f_mathrm_lb_mathrm_m(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_lb_or_mathrm_lb_mathrm_f_mathrm_lb_mathrm_m units (alias for pound_force_per_pound_mass), returning new variable."""
        return self.pound_force_per_pound_mass

    @property
    def lb_f_lb(self) -> 'FieldQnty':
        """Convert to lb_f_lb units (alias for pound_force_per_pound_mass), returning new variable."""
        return self.pound_force_per_pound_mass

    @property
    def lb_f_lb_m(self) -> 'FieldQnty':
        """Convert to lb_f_lb_m units (alias for pound_force_per_pound_mass), returning new variable."""
        return self.pound_force_per_pound_mass

    @property
    def pound_force_per_slug(self) -> 'FieldQnty':
        """Convert to pound force per slug units, returning new variable."""
        unit_const: Final = field_units.ForcePerUnitMassUnits.pound_force_per_slug
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_slug(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_slug units (alias for pound_force_per_slug), returning new variable."""
        return self.pound_force_per_slug


class AsUnitFrequencyVoltageRatioConverter(UnitConverter):
    """FrequencyVoltageRatio-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cycles_per_second_per_volt(self) -> 'FieldQnty':
        """Convert to cycles per second per volt units, returning new variable."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.cycles_per_second_per_volt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cycle_sec_V(self) -> 'FieldQnty':
        """Convert to cycle_sec_V units (alias for cycles_per_second_per_volt), returning new variable."""
        return self.cycles_per_second_per_volt

    @property
    def hertz_per_volt(self) -> 'FieldQnty':
        """Convert to hertz per volt units, returning new variable."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.hertz_per_volt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Hz_V(self) -> 'FieldQnty':
        """Convert to Hz_V units (alias for hertz_per_volt), returning new variable."""
        return self.hertz_per_volt

    @property
    def terahertz_per_volt(self) -> 'FieldQnty':
        """Convert to terahertz per volt units, returning new variable."""
        unit_const: Final = field_units.FrequencyVoltageRatioUnits.terahertz_per_volt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def THz_V(self) -> 'FieldQnty':
        """Convert to THz_V units (alias for terahertz_per_volt), returning new variable."""
        return self.terahertz_per_volt


class AsUnitFuelConsumptionConverter(UnitConverter):
    """FuelConsumption-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def unit_100_km_per_liter(self) -> 'FieldQnty':
        """Convert to 100 km per liter units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.unit_100_km_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gallons_uk(self) -> 'FieldQnty':
        """Convert to gallons (UK) per 100 miles units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.gallons_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_UK_100_mi(self) -> 'FieldQnty':
        """Convert to gal_UK_100_mi units (alias for gallons_uk), returning new variable."""
        return self.gallons_uk

    @property
    def gallons_us(self) -> 'FieldQnty':
        """Convert to gallons (US) per 100 miles units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.gallons_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_US_100_mi(self) -> 'FieldQnty':
        """Convert to gal_US_100_mi units (alias for gallons_us), returning new variable."""
        return self.gallons_us

    @property
    def kilometers_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to kilometers per gallon (UK) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km_gal_UK(self) -> 'FieldQnty':
        """Convert to km_gal_UK units (alias for kilometers_per_gallon_uk), returning new variable."""
        return self.kilometers_per_gallon_uk

    @property
    def kilometers_per_gallon_us(self) -> 'FieldQnty':
        """Convert to kilometers per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km_gal_US(self) -> 'FieldQnty':
        """Convert to km_gal_US units (alias for kilometers_per_gallon_us), returning new variable."""
        return self.kilometers_per_gallon_us

    @property
    def kilometers_per_liter(self) -> 'FieldQnty':
        """Convert to kilometers per liter units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.kilometers_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km_l(self) -> 'FieldQnty':
        """Convert to km_l units (alias for kilometers_per_liter), returning new variable."""
        return self.kilometers_per_liter

    @property
    def liters_per_100_km(self) -> 'FieldQnty':
        """Convert to liters per 100 km units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.liters_per_100_km
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liters_per_kilometer(self) -> 'FieldQnty':
        """Convert to liters per kilometer units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.liters_per_kilometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_km(self) -> 'FieldQnty':
        """Convert to unit_1_km units (alias for liters_per_kilometer), returning new variable."""
        return self.liters_per_kilometer

    @property
    def meters_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to meters per gallon (UK) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.meters_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m_gal_UK(self) -> 'FieldQnty':
        """Convert to m_gal_UK units (alias for meters_per_gallon_uk), returning new variable."""
        return self.meters_per_gallon_uk

    @property
    def meters_per_gallon_us(self) -> 'FieldQnty':
        """Convert to meters per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.meters_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_gal_US(self) -> 'FieldQnty':
        """Convert to unit_1_gal_US units (alias for meters_per_gallon_us), returning new variable."""
        return self.meters_per_gallon_us

    @property
    def miles_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to miles per gallon (UK) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi_gal_UK_or_mpg_UK(self) -> 'FieldQnty':
        """Convert to mi_gal_UK_or_mpg_UK units (alias for miles_per_gallon_uk), returning new variable."""
        return self.miles_per_gallon_uk

    @property
    def mi_gal_UK(self) -> 'FieldQnty':
        """Convert to mi_gal_UK units (alias for miles_per_gallon_uk), returning new variable."""
        return self.miles_per_gallon_uk

    @property
    def mpg_UK(self) -> 'FieldQnty':
        """Convert to mpg_UK units (alias for miles_per_gallon_uk), returning new variable."""
        return self.miles_per_gallon_uk

    @property
    def miles_per_gallon_us(self) -> 'FieldQnty':
        """Convert to miles per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi_gal_US_or_mpg_US(self) -> 'FieldQnty':
        """Convert to mi_gal_US_or_mpg_US units (alias for miles_per_gallon_us), returning new variable."""
        return self.miles_per_gallon_us

    @property
    def mi_gal_US(self) -> 'FieldQnty':
        """Convert to mi_gal_US units (alias for miles_per_gallon_us), returning new variable."""
        return self.miles_per_gallon_us

    @property
    def mpg_US(self) -> 'FieldQnty':
        """Convert to mpg_US units (alias for miles_per_gallon_us), returning new variable."""
        return self.miles_per_gallon_us

    @property
    def miles_per_liter(self) -> 'FieldQnty':
        """Convert to miles per liter units, returning new variable."""
        unit_const: Final = field_units.FuelConsumptionUnits.miles_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi_l(self) -> 'FieldQnty':
        """Convert to mi_l units (alias for miles_per_liter), returning new variable."""
        return self.miles_per_liter


class AsUnitHeatOfCombustionConverter(UnitConverter):
    """HeatOfCombustion-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfCombustionUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound), returning new variable."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units, returning new variable."""
        unit_const: Final = field_units.HeatOfCombustionUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram), returning new variable."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfCombustionUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound), returning new variable."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units, returning new variable."""
        unit_const: Final = field_units.HeatOfCombustionUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram), returning new variable."""
        return self.joule_per_kilogram


class AsUnitHeatOfFusionConverter(UnitConverter):
    """HeatOfFusion-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfFusionUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_mean_lb(self) -> 'FieldQnty':
        """Convert to Btu_mean_lb units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfFusionUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound), returning new variable."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units, returning new variable."""
        unit_const: Final = field_units.HeatOfFusionUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram), returning new variable."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfFusionUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound), returning new variable."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units, returning new variable."""
        unit_const: Final = field_units.HeatOfFusionUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram), returning new variable."""
        return self.joule_per_kilogram


class AsUnitHeatOfVaporizationConverter(UnitConverter):
    """HeatOfVaporization-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound), returning new variable."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units, returning new variable."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram), returning new variable."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units, returning new variable."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound), returning new variable."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units, returning new variable."""
        unit_const: Final = field_units.HeatOfVaporizationUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram), returning new variable."""
        return self.joule_per_kilogram


class AsUnitHeatTransferCoefficientConverter(UnitConverter):
    """HeatTransferCoefficient-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine(self) -> 'FieldQnty':
        """Convert to Btu per square foot per hour per degree Fahrenheit (or Rankine) units, returning new variable."""
        unit_const: Final = field_units.HeatTransferCoefficientUnits.btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_left_mathrm_ft_2_mathrm_h_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_left_mathrm_ft_2_mathrm_h_circ_mathrm_F_right units (alias for btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine), returning new variable."""
        return self.btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine

    @property
    def watt_per_square_meter_per_degree_celsius_or_kelvin(self) -> 'FieldQnty':
        """Convert to watt per square meter per degree Celsius (or kelvin) units, returning new variable."""
        unit_const: Final = field_units.HeatTransferCoefficientUnits.watt_per_square_meter_per_degree_celsius_or_kelvin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_W_left_mathrm_m_2_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_W_left_mathrm_m_2_circ_mathrm_C_right units (alias for watt_per_square_meter_per_degree_celsius_or_kelvin), returning new variable."""
        return self.watt_per_square_meter_per_degree_celsius_or_kelvin


class AsUnitIlluminanceConverter(UnitConverter):
    """Illuminance-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def foot_candle(self) -> 'FieldQnty':
        """Convert to foot-candle units, returning new variable."""
        unit_const: Final = field_units.IlluminanceUnits.foot_candle
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_C_or_mathrm_ft_mathrm_Cd(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_C_or_mathrm_ft_mathrm_Cd units (alias for foot_candle), returning new variable."""
        return self.foot_candle

    @property
    def ft_C(self) -> 'FieldQnty':
        """Convert to ft_C units (alias for foot_candle), returning new variable."""
        return self.foot_candle

    @property
    def ft_Cd(self) -> 'FieldQnty':
        """Convert to ft_Cd units (alias for foot_candle), returning new variable."""
        return self.foot_candle

    @property
    def lux(self) -> 'FieldQnty':
        """Convert to lux units, returning new variable."""
        unit_const: Final = field_units.IlluminanceUnits.lux
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lx(self) -> 'FieldQnty':
        """Convert to lx units (alias for lux), returning new variable."""
        return self.lux

    @property
    def nox(self) -> 'FieldQnty':
        """Convert to nox units, returning new variable."""
        unit_const: Final = field_units.IlluminanceUnits.nox
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def phot(self) -> 'FieldQnty':
        """Convert to phot units, returning new variable."""
        unit_const: Final = field_units.IlluminanceUnits.phot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ph(self) -> 'FieldQnty':
        """Convert to ph units (alias for phot), returning new variable."""
        return self.phot

    @property
    def skot(self) -> 'FieldQnty':
        """Convert to skot units, returning new variable."""
        unit_const: Final = field_units.IlluminanceUnits.skot
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitKineticEnergyOfTurbulenceConverter(UnitConverter):
    """KineticEnergyOfTurbulence-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def square_foot_per_second_squared(self) -> 'FieldQnty':
        """Convert to square foot per second squared units, returning new variable."""
        unit_const: Final = field_units.KineticEnergyOfTurbulenceUnits.square_foot_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_s_2_or_sqft_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s_2_or_sqft_sec_2 units (alias for square_foot_per_second_squared), returning new variable."""
        return self.square_foot_per_second_squared

    @property
    def ft_2_s_2(self) -> 'FieldQnty':
        """Convert to ft_2_s_2 units (alias for square_foot_per_second_squared), returning new variable."""
        return self.square_foot_per_second_squared

    @property
    def sqft_sec_2(self) -> 'FieldQnty':
        """Convert to sqft_sec_2 units (alias for square_foot_per_second_squared), returning new variable."""
        return self.square_foot_per_second_squared

    @property
    def square_meters_per_second_squared(self) -> 'FieldQnty':
        """Convert to square meters per second squared units, returning new variable."""
        unit_const: Final = field_units.KineticEnergyOfTurbulenceUnits.square_meters_per_second_squared
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s_2 units (alias for square_meters_per_second_squared), returning new variable."""
        return self.square_meters_per_second_squared


class AsUnitLengthConverter(UnitConverter):
    """Length-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def ngstr_m(self) -> 'FieldQnty':
        """Convert to ångström units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.ngstr_m
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def AA(self) -> 'FieldQnty':
        """Convert to AA units (alias for ngstr_m), returning new variable."""
        return self.ngstr_m

    @property
    def arpent_quebec(self) -> 'FieldQnty':
        """Convert to arpent (Quebec) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.arpent_quebec
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def arp(self) -> 'FieldQnty':
        """Convert to arp units (alias for arpent_quebec), returning new variable."""
        return self.arpent_quebec

    @property
    def astronomic_unit(self) -> 'FieldQnty':
        """Convert to astronomic unit units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.astronomic_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def AU(self) -> 'FieldQnty':
        """Convert to AU units (alias for astronomic_unit), returning new variable."""
        return self.astronomic_unit

    @property
    def attometer(self) -> 'FieldQnty':
        """Convert to attometer units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.attometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def am(self) -> 'FieldQnty':
        """Convert to am units (alias for attometer), returning new variable."""
        return self.attometer

    @property
    def calibre_centinch(self) -> 'FieldQnty':
        """Convert to calibre (centinch) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.calibre_centinch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cin(self) -> 'FieldQnty':
        """Convert to cin units (alias for calibre_centinch), returning new variable."""
        return self.calibre_centinch

    @property
    def centimeter(self) -> 'FieldQnty':
        """Convert to centimeter units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cm(self) -> 'FieldQnty':
        """Convert to cm units (alias for centimeter), returning new variable."""
        return self.centimeter

    @property
    def chain_engrs_or_ramsden(self) -> 'FieldQnty':
        """Convert to chain (Engr's or Ramsden) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.chain_engrs_or_ramsden
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ch_eng_or_Rams(self) -> 'FieldQnty':
        """Convert to ch_eng_or_Rams units (alias for chain_engrs_or_ramsden), returning new variable."""
        return self.chain_engrs_or_ramsden

    @property
    def ch_eng(self) -> 'FieldQnty':
        """Convert to ch_eng units (alias for chain_engrs_or_ramsden), returning new variable."""
        return self.chain_engrs_or_ramsden

    @property
    def Rams(self) -> 'FieldQnty':
        """Convert to Rams units (alias for chain_engrs_or_ramsden), returning new variable."""
        return self.chain_engrs_or_ramsden

    @property
    def chain_gunters(self) -> 'FieldQnty':
        """Convert to chain (Gunter's) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.chain_gunters
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ch_Gunt(self) -> 'FieldQnty':
        """Convert to ch_Gunt units (alias for chain_gunters), returning new variable."""
        return self.chain_gunters

    @property
    def chain_surveyors(self) -> 'FieldQnty':
        """Convert to chain (surveyors) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.chain_surveyors
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ch_surv(self) -> 'FieldQnty':
        """Convert to ch_surv units (alias for chain_surveyors), returning new variable."""
        return self.chain_surveyors

    @property
    def cubit_uk(self) -> 'FieldQnty':
        """Convert to cubit (UK) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.cubit_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cu_UK(self) -> 'FieldQnty':
        """Convert to cu_UK units (alias for cubit_uk), returning new variable."""
        return self.cubit_uk

    @property
    def ell(self) -> 'FieldQnty':
        """Convert to ell units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.ell
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fathom(self) -> 'FieldQnty':
        """Convert to fathom units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.fathom
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fath(self) -> 'FieldQnty':
        """Convert to fath units (alias for fathom), returning new variable."""
        return self.fathom

    @property
    def femtometre(self) -> 'FieldQnty':
        """Convert to femtometre units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.femtometre
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fm(self) -> 'FieldQnty':
        """Convert to fm units (alias for femtometre), returning new variable."""
        return self.femtometre

    @property
    def fermi(self) -> 'FieldQnty':
        """Convert to fermi units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.fermi
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def F(self) -> 'FieldQnty':
        """Convert to F units (alias for fermi), returning new variable."""
        return self.fermi

    @property
    def foot(self) -> 'FieldQnty':
        """Convert to foot units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft(self) -> 'FieldQnty':
        """Convert to ft units (alias for foot), returning new variable."""
        return self.foot

    @property
    def furlong_uk_and_us(self) -> 'FieldQnty':
        """Convert to furlong (UK and US) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.furlong_uk_and_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fur(self) -> 'FieldQnty':
        """Convert to fur units (alias for furlong_uk_and_us), returning new variable."""
        return self.furlong_uk_and_us

    @property
    def inch(self) -> 'FieldQnty':
        """Convert to inch units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_unit(self) -> 'FieldQnty':
        """Convert to in_unit units (alias for inch), returning new variable."""
        return self.inch

    @property
    def kilometer(self) -> 'FieldQnty':
        """Convert to kilometer units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.kilometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km(self) -> 'FieldQnty':
        """Convert to km units (alias for kilometer), returning new variable."""
        return self.kilometer

    @property
    def league_us_statute(self) -> 'FieldQnty':
        """Convert to league (US, statute) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.league_us_statute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lg_US_stat(self) -> 'FieldQnty':
        """Convert to lg_US_stat units (alias for league_us_statute), returning new variable."""
        return self.league_us_statute

    @property
    def lieue_metric(self) -> 'FieldQnty':
        """Convert to lieue (metric) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.lieue_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ligne_metric(self) -> 'FieldQnty':
        """Convert to ligne (metric) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.ligne_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def line_us(self) -> 'FieldQnty':
        """Convert to line (US) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.line_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def li_US(self) -> 'FieldQnty':
        """Convert to li_US units (alias for line_us), returning new variable."""
        return self.line_us

    @property
    def link_surveyors(self) -> 'FieldQnty':
        """Convert to link (surveyors) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.link_surveyors
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def li_surv(self) -> 'FieldQnty':
        """Convert to li_surv units (alias for link_surveyors), returning new variable."""
        return self.link_surveyors

    @property
    def meter(self) -> 'FieldQnty':
        """Convert to meter units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m(self) -> 'FieldQnty':
        """Convert to m units (alias for meter), returning new variable."""
        return self.meter

    @property
    def micrometer(self) -> 'FieldQnty':
        """Convert to micrometer units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.micrometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_m(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m units (alias for micrometer), returning new variable."""
        return self.micrometer

    @property
    def micron(self) -> 'FieldQnty':
        """Convert to micron units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.micron
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu(self) -> 'FieldQnty':
        """Convert to mu units (alias for micron), returning new variable."""
        return self.micron

    @property
    def mil(self) -> 'FieldQnty':
        """Convert to mil units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.mil
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mile_geographical(self) -> 'FieldQnty':
        """Convert to mile (geographical) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.mile_geographical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi(self) -> 'FieldQnty':
        """Convert to mi units (alias for mile_geographical), returning new variable."""
        return self.mile_geographical

    @property
    def mile_us_nautical(self) -> 'FieldQnty':
        """Convert to mile (US, nautical) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.mile_us_nautical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi_US_naut(self) -> 'FieldQnty':
        """Convert to mi_US_naut units (alias for mile_us_nautical), returning new variable."""
        return self.mile_us_nautical

    @property
    def mile_us_statute(self) -> 'FieldQnty':
        """Convert to mile (US, statute) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.mile_us_statute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mile_us_survey(self) -> 'FieldQnty':
        """Convert to mile (US, survey) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.mile_us_survey
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mi_US_surv(self) -> 'FieldQnty':
        """Convert to mi_US_surv units (alias for mile_us_survey), returning new variable."""
        return self.mile_us_survey

    @property
    def millimeter(self) -> 'FieldQnty':
        """Convert to millimeter units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.millimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mm(self) -> 'FieldQnty':
        """Convert to mm units (alias for millimeter), returning new variable."""
        return self.millimeter

    @property
    def millimicron(self) -> 'FieldQnty':
        """Convert to millimicron units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.millimicron
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mu(self) -> 'FieldQnty':
        """Convert to mathrm_m_mu units (alias for millimicron), returning new variable."""
        return self.millimicron

    @property
    def nanometer_or_nanon(self) -> 'FieldQnty':
        """Convert to nanometer or nanon units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.nanometer_or_nanon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nm(self) -> 'FieldQnty':
        """Convert to nm units (alias for nanometer_or_nanon), returning new variable."""
        return self.nanometer_or_nanon

    @property
    def parsec(self) -> 'FieldQnty':
        """Convert to parsec units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.parsec
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pc(self) -> 'FieldQnty':
        """Convert to pc units (alias for parsec), returning new variable."""
        return self.parsec

    @property
    def perche(self) -> 'FieldQnty':
        """Convert to perche units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.perche
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def rod(self) -> 'FieldQnty':
        """Convert to rod units (alias for perche), returning new variable."""
        return self.perche

    @property
    def pica(self) -> 'FieldQnty':
        """Convert to pica units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.pica
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def picometer(self) -> 'FieldQnty':
        """Convert to picometer units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.picometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pm(self) -> 'FieldQnty':
        """Convert to pm units (alias for picometer), returning new variable."""
        return self.picometer

    @property
    def point_didot(self) -> 'FieldQnty':
        """Convert to point (Didot) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.point_didot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pt_Didot(self) -> 'FieldQnty':
        """Convert to pt_Didot units (alias for point_didot), returning new variable."""
        return self.point_didot

    @property
    def point_us(self) -> 'FieldQnty':
        """Convert to point (US) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.point_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pt_US(self) -> 'FieldQnty':
        """Convert to pt_US units (alias for point_us), returning new variable."""
        return self.point_us

    @property
    def rod_or_pole(self) -> 'FieldQnty':
        """Convert to rod or pole units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.rod_or_pole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def span(self) -> 'FieldQnty':
        """Convert to span units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.span
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def thou_millinch(self) -> 'FieldQnty':
        """Convert to thou (millinch) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.thou_millinch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def thou(self) -> 'FieldQnty':
        """Convert to thou units (alias for thou_millinch), returning new variable."""
        return self.thou_millinch

    @property
    def toise_metric(self) -> 'FieldQnty':
        """Convert to toise (metric) units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.toise_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def yard(self) -> 'FieldQnty':
        """Convert to yard units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.yard
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def yd(self) -> 'FieldQnty':
        """Convert to yd units (alias for yard), returning new variable."""
        return self.yard

    @property
    def nanometer(self) -> 'FieldQnty':
        """Convert to nanometer units, returning new variable."""
        unit_const: Final = field_units.LengthUnits.nanometer
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitLinearMassDensityConverter(UnitConverter):
    """LinearMassDensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def denier(self) -> 'FieldQnty':
        """Convert to denier units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.denier
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kilogram_per_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram per centimeter units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.kilogram_per_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_cm(self) -> 'FieldQnty':
        """Convert to kg_cm units (alias for kilogram_per_centimeter), returning new variable."""
        return self.kilogram_per_centimeter

    @property
    def kilogram_per_meter(self) -> 'FieldQnty':
        """Convert to kilogram per meter units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.kilogram_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_m(self) -> 'FieldQnty':
        """Convert to kg_m units (alias for kilogram_per_meter), returning new variable."""
        return self.kilogram_per_meter

    @property
    def pound_per_foot(self) -> 'FieldQnty':
        """Convert to pound per foot units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_ft(self) -> 'FieldQnty':
        """Convert to lb_ft units (alias for pound_per_foot), returning new variable."""
        return self.pound_per_foot

    @property
    def pound_per_inch(self) -> 'FieldQnty':
        """Convert to pound per inch units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_in(self) -> 'FieldQnty':
        """Convert to lb_in units (alias for pound_per_inch), returning new variable."""
        return self.pound_per_inch

    @property
    def pound_per_yard(self) -> 'FieldQnty':
        """Convert to pound per yard units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.pound_per_yard
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_yd(self) -> 'FieldQnty':
        """Convert to lb_yd units (alias for pound_per_yard), returning new variable."""
        return self.pound_per_yard

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton (metric) per kilometer units, returning new variable."""
        unit_const: Final = field_units.LinearMassDensityUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def t_km_or_MT_km(self) -> 'FieldQnty':
        """Convert to t_km_or_MT_km units (alias for ton_metric), returning new variable."""
        return self.ton_metric

    @property
    def t_km(self) -> 'FieldQnty':
        """Convert to t_km units (alias for ton_metric), returning new variable."""
        return self.ton_metric

    @property
    def MT_km(self) -> 'FieldQnty':
        """Convert to MT_km units (alias for ton_metric), returning new variable."""
        return self.ton_metric


class AsUnitLinearMomentumConverter(UnitConverter):
    """LinearMomentum-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def foot_pounds_force_per_hour(self) -> 'FieldQnty':
        """Convert to foot pounds force per hour units, returning new variable."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_h_or_mathrm_ft_mathrm_lb_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_h_or_mathrm_ft_mathrm_lb_mathrm_hr units (alias for foot_pounds_force_per_hour), returning new variable."""
        return self.foot_pounds_force_per_hour

    @property
    def ft_lb_f_h(self) -> 'FieldQnty':
        """Convert to ft_lb_f_h units (alias for foot_pounds_force_per_hour), returning new variable."""
        return self.foot_pounds_force_per_hour

    @property
    def ft_lb_hr(self) -> 'FieldQnty':
        """Convert to ft_lb_hr units (alias for foot_pounds_force_per_hour), returning new variable."""
        return self.foot_pounds_force_per_hour

    @property
    def foot_pounds_force_per_minute(self) -> 'FieldQnty':
        """Convert to foot pounds force per minute units, returning new variable."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min_or_mathrm_ft_mathrm_lb_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_min_or_mathrm_ft_mathrm_lb_min units (alias for foot_pounds_force_per_minute), returning new variable."""
        return self.foot_pounds_force_per_minute

    @property
    def ft_lb_f_min(self) -> 'FieldQnty':
        """Convert to ft_lb_f_min units (alias for foot_pounds_force_per_minute), returning new variable."""
        return self.foot_pounds_force_per_minute

    @property
    def ft_lb_min(self) -> 'FieldQnty':
        """Convert to ft_lb_min units (alias for foot_pounds_force_per_minute), returning new variable."""
        return self.foot_pounds_force_per_minute

    @property
    def foot_pounds_force_per_second(self) -> 'FieldQnty':
        """Convert to foot pounds force per second units, returning new variable."""
        unit_const: Final = field_units.LinearMomentumUnits.foot_pounds_force_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s_or_ft_lb_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_s_or_ft_lb_sec units (alias for foot_pounds_force_per_second), returning new variable."""
        return self.foot_pounds_force_per_second

    @property
    def ft_lb_f_s(self) -> 'FieldQnty':
        """Convert to ft_lb_f_s units (alias for foot_pounds_force_per_second), returning new variable."""
        return self.foot_pounds_force_per_second

    @property
    def ft_lb_sec(self) -> 'FieldQnty':
        """Convert to ft_lb_sec units (alias for foot_pounds_force_per_second), returning new variable."""
        return self.foot_pounds_force_per_second

    @property
    def gram_centimeters_per_second(self) -> 'FieldQnty':
        """Convert to gram centimeters per second units, returning new variable."""
        unit_const: Final = field_units.LinearMomentumUnits.gram_centimeters_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s units (alias for gram_centimeters_per_second), returning new variable."""
        return self.gram_centimeters_per_second

    @property
    def kilogram_meters_per_second(self) -> 'FieldQnty':
        """Convert to kilogram meters per second units, returning new variable."""
        unit_const: Final = field_units.LinearMomentumUnits.kilogram_meters_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_mathrm_s units (alias for kilogram_meters_per_second), returning new variable."""
        return self.kilogram_meters_per_second


class AsUnitLuminanceSelfConverter(UnitConverter):
    """LuminanceSelf-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def apostilb(self) -> 'FieldQnty':
        """Convert to apostilb units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.apostilb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def asb(self) -> 'FieldQnty':
        """Convert to asb units (alias for apostilb), returning new variable."""
        return self.apostilb

    @property
    def blondel(self) -> 'FieldQnty':
        """Convert to blondel units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.blondel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def B1(self) -> 'FieldQnty':
        """Convert to B1 units (alias for blondel), returning new variable."""
        return self.blondel

    @property
    def candela_per_square_meter(self) -> 'FieldQnty':
        """Convert to candela per square meter units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.candela_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cd_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_cd_mathrm_m_2 units (alias for candela_per_square_meter), returning new variable."""
        return self.candela_per_square_meter

    @property
    def foot_lambert(self) -> 'FieldQnty':
        """Convert to foot-lambert units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.foot_lambert
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_L(self) -> 'FieldQnty':
        """Convert to ft_L units (alias for foot_lambert), returning new variable."""
        return self.foot_lambert

    @property
    def lambert(self) -> 'FieldQnty':
        """Convert to lambert units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.lambert
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def L(self) -> 'FieldQnty':
        """Convert to L units (alias for lambert), returning new variable."""
        return self.lambert

    @property
    def luxon(self) -> 'FieldQnty':
        """Convert to luxon units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.luxon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nit(self) -> 'FieldQnty':
        """Convert to nit units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.nit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def stilb(self) -> 'FieldQnty':
        """Convert to stilb units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.stilb
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sb(self) -> 'FieldQnty':
        """Convert to sb units (alias for stilb), returning new variable."""
        return self.stilb

    @property
    def troland(self) -> 'FieldQnty':
        """Convert to troland units, returning new variable."""
        unit_const: Final = field_units.LuminanceSelfUnits.troland
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitLuminousFluxConverter(UnitConverter):
    """LuminousFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def candela_steradian(self) -> 'FieldQnty':
        """Convert to candela steradian units, returning new variable."""
        unit_const: Final = field_units.LuminousFluxUnits.candela_steradian
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cd_sr(self) -> 'FieldQnty':
        """Convert to cd_sr units (alias for candela_steradian), returning new variable."""
        return self.candela_steradian

    @property
    def lumen(self) -> 'FieldQnty':
        """Convert to lumen units, returning new variable."""
        unit_const: Final = field_units.LuminousFluxUnits.lumen
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitLuminousIntensityConverter(UnitConverter):
    """LuminousIntensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def candela(self) -> 'FieldQnty':
        """Convert to candela units, returning new variable."""
        unit_const: Final = field_units.LuminousIntensityUnits.candela
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cd(self) -> 'FieldQnty':
        """Convert to cd units (alias for candela), returning new variable."""
        return self.candela

    @property
    def candle_international(self) -> 'FieldQnty':
        """Convert to candle (international) units, returning new variable."""
        unit_const: Final = field_units.LuminousIntensityUnits.candle_international
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Cd_int(self) -> 'FieldQnty':
        """Convert to Cd_int units (alias for candle_international), returning new variable."""
        return self.candle_international

    @property
    def carcel(self) -> 'FieldQnty':
        """Convert to carcel units, returning new variable."""
        unit_const: Final = field_units.LuminousIntensityUnits.carcel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def hefner_unit(self) -> 'FieldQnty':
        """Convert to Hefner unit units, returning new variable."""
        unit_const: Final = field_units.LuminousIntensityUnits.hefner_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HK(self) -> 'FieldQnty':
        """Convert to HK units (alias for hefner_unit), returning new variable."""
        return self.hefner_unit


class AsUnitMagneticFieldConverter(UnitConverter):
    """MagneticField-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def ampere_per_meter(self) -> 'FieldQnty':
        """Convert to ampere per meter units, returning new variable."""
        unit_const: Final = field_units.MagneticFieldUnits.ampere_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A_m(self) -> 'FieldQnty':
        """Convert to A_m units (alias for ampere_per_meter), returning new variable."""
        return self.ampere_per_meter

    @property
    def lenz(self) -> 'FieldQnty':
        """Convert to lenz units, returning new variable."""
        unit_const: Final = field_units.MagneticFieldUnits.lenz
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oersted(self) -> 'FieldQnty':
        """Convert to oersted units, returning new variable."""
        unit_const: Final = field_units.MagneticFieldUnits.oersted
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Oe(self) -> 'FieldQnty':
        """Convert to Oe units (alias for oersted), returning new variable."""
        return self.oersted

    @property
    def praoersted(self) -> 'FieldQnty':
        """Convert to praoersted units, returning new variable."""
        unit_const: Final = field_units.MagneticFieldUnits.praoersted
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for praoersted), returning new variable."""
        return self.praoersted


class AsUnitMagneticFluxConverter(UnitConverter):
    """MagneticFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def kapp_line(self) -> 'FieldQnty':
        """Convert to kapp line units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.kapp_line
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for kapp_line), returning new variable."""
        return self.kapp_line

    @property
    def line(self) -> 'FieldQnty':
        """Convert to line units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.line
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def maxwell(self) -> 'FieldQnty':
        """Convert to maxwell units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.maxwell
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Mx(self) -> 'FieldQnty':
        """Convert to Mx units (alias for maxwell), returning new variable."""
        return self.maxwell

    @property
    def unit_pole(self) -> 'FieldQnty':
        """Convert to unit pole units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.unit_pole
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def weber(self) -> 'FieldQnty':
        """Convert to weber units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.weber
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Wb(self) -> 'FieldQnty':
        """Convert to Wb units (alias for weber), returning new variable."""
        return self.weber

    @property
    def milliweber(self) -> 'FieldQnty':
        """Convert to milliweber units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.milliweber
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mWb(self) -> 'FieldQnty':
        """Convert to mWb units (alias for milliweber), returning new variable."""
        return self.milliweber

    @property
    def microweber(self) -> 'FieldQnty':
        """Convert to microweber units, returning new variable."""
        unit_const: Final = field_units.MagneticFluxUnits.microweber
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitMagneticInductionFieldStrengthConverter(UnitConverter):
    """MagneticInductionFieldStrength-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gamma(self) -> 'FieldQnty':
        """Convert to gamma units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.gamma
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gauss(self) -> 'FieldQnty':
        """Convert to gauss units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.gauss
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def G(self) -> 'FieldQnty':
        """Convert to G units (alias for gauss), returning new variable."""
        return self.gauss

    @property
    def line_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to line per square centimeter units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.line_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def line_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to line_mathrm_cm_2 units (alias for line_per_square_centimeter), returning new variable."""
        return self.line_per_square_centimeter

    @property
    def maxwell_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to maxwell per square centimeter units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.maxwell_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Mx_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_Mx_mathrm_cm_2 units (alias for maxwell_per_square_centimeter), returning new variable."""
        return self.maxwell_per_square_centimeter

    @property
    def tesla(self) -> 'FieldQnty':
        """Convert to tesla units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.tesla
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def T(self) -> 'FieldQnty':
        """Convert to T units (alias for tesla), returning new variable."""
        return self.tesla

    @property
    def u_a(self) -> 'FieldQnty':
        """Convert to u.a. units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.u_a
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def weber_per_square_meter(self) -> 'FieldQnty':
        """Convert to weber per square meter units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.weber_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Wb_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_Wb_mathrm_m_2 units (alias for weber_per_square_meter), returning new variable."""
        return self.weber_per_square_meter

    @property
    def millitesla(self) -> 'FieldQnty':
        """Convert to millitesla units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.millitesla
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mT(self) -> 'FieldQnty':
        """Convert to mT units (alias for millitesla), returning new variable."""
        return self.millitesla

    @property
    def microtesla(self) -> 'FieldQnty':
        """Convert to microtesla units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.microtesla
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanotesla(self) -> 'FieldQnty':
        """Convert to nanotesla units, returning new variable."""
        unit_const: Final = field_units.MagneticInductionFieldStrengthUnits.nanotesla
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nT(self) -> 'FieldQnty':
        """Convert to nT units (alias for nanotesla), returning new variable."""
        return self.nanotesla


class AsUnitMagneticMomentConverter(UnitConverter):
    """MagneticMoment-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def bohr_magneton(self) -> 'FieldQnty':
        """Convert to Bohr magneton units, returning new variable."""
        unit_const: Final = field_units.MagneticMomentUnits.bohr_magneton
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Bohr_magneton(self) -> 'FieldQnty':
        """Convert to Bohr_magneton units (alias for bohr_magneton), returning new variable."""
        return self.bohr_magneton

    @property
    def joule_per_tesla(self) -> 'FieldQnty':
        """Convert to joule per tesla units, returning new variable."""
        unit_const: Final = field_units.MagneticMomentUnits.joule_per_tesla
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_T(self) -> 'FieldQnty':
        """Convert to J_T units (alias for joule_per_tesla), returning new variable."""
        return self.joule_per_tesla

    @property
    def nuclear_magneton(self) -> 'FieldQnty':
        """Convert to nuclear magneton units, returning new variable."""
        unit_const: Final = field_units.MagneticMomentUnits.nuclear_magneton
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nucl_Magneton(self) -> 'FieldQnty':
        """Convert to nucl_Magneton units (alias for nuclear_magneton), returning new variable."""
        return self.nuclear_magneton


class AsUnitMagneticPermeabilityConverter(UnitConverter):
    """MagneticPermeability-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def henrys_per_meter(self) -> 'FieldQnty':
        """Convert to henrys per meter units, returning new variable."""
        unit_const: Final = field_units.MagneticPermeabilityUnits.henrys_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def H_m(self) -> 'FieldQnty':
        """Convert to H_m units (alias for henrys_per_meter), returning new variable."""
        return self.henrys_per_meter

    @property
    def newton_per_square_ampere(self) -> 'FieldQnty':
        """Convert to newton per square ampere units, returning new variable."""
        unit_const: Final = field_units.MagneticPermeabilityUnits.newton_per_square_ampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N_A_2(self) -> 'FieldQnty':
        """Convert to N_A_2 units (alias for newton_per_square_ampere), returning new variable."""
        return self.newton_per_square_ampere


class AsUnitMagnetomotiveForceConverter(UnitConverter):
    """MagnetomotiveForce-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abampere_turn(self) -> 'FieldQnty':
        """Convert to abampere-turn units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.abampere_turn
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu_cgs(self) -> 'FieldQnty':
        """Convert to emu_cgs units (alias for abampere_turn), returning new variable."""
        return self.abampere_turn

    @property
    def ampere(self) -> 'FieldQnty':
        """Convert to ampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.ampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A(self) -> 'FieldQnty':
        """Convert to A units (alias for ampere), returning new variable."""
        return self.ampere

    @property
    def ampere_turn(self) -> 'FieldQnty':
        """Convert to ampere-turn units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.ampere_turn
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def A_turn(self) -> 'FieldQnty':
        """Convert to A_turn units (alias for ampere_turn), returning new variable."""
        return self.ampere_turn

    @property
    def gilbert(self) -> 'FieldQnty':
        """Convert to gilbert units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.gilbert
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Gb(self) -> 'FieldQnty':
        """Convert to Gb units (alias for gilbert), returning new variable."""
        return self.gilbert

    @property
    def kiloampere(self) -> 'FieldQnty':
        """Convert to kiloampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.kiloampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kA(self) -> 'FieldQnty':
        """Convert to kA units (alias for kiloampere), returning new variable."""
        return self.kiloampere

    @property
    def milliampere(self) -> 'FieldQnty':
        """Convert to milliampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.milliampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mA(self) -> 'FieldQnty':
        """Convert to mA units (alias for milliampere), returning new variable."""
        return self.milliampere

    @property
    def microampere(self) -> 'FieldQnty':
        """Convert to microampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.microampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanoampere(self) -> 'FieldQnty':
        """Convert to nanoampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.nanoampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nA(self) -> 'FieldQnty':
        """Convert to nA units (alias for nanoampere), returning new variable."""
        return self.nanoampere

    @property
    def picoampere(self) -> 'FieldQnty':
        """Convert to picoampere units, returning new variable."""
        unit_const: Final = field_units.MagnetomotiveForceUnits.picoampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pA(self) -> 'FieldQnty':
        """Convert to pA units (alias for picoampere), returning new variable."""
        return self.picoampere


class AsUnitMassConverter(UnitConverter):
    """Mass-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def slug(self) -> 'FieldQnty':
        """Convert to slug units, returning new variable."""
        unit_const: Final = field_units.MassUnits.slug
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sl(self) -> 'FieldQnty':
        """Convert to sl units (alias for slug), returning new variable."""
        return self.slug

    @property
    def atomic_mass_unit_12_mathrmc(self) -> 'FieldQnty':
        """Convert to atomic mass unit ( ${ }^{12} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.atomic_mass_unit_12_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_u_left_12_mathrm_C_right_or_amu(self) -> 'FieldQnty':
        """Convert to mathrm_u_left_12_mathrm_C_right_or_amu units (alias for atomic_mass_unit_12_mathrmc), returning new variable."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def uleft_12_Cright(self) -> 'FieldQnty':
        """Convert to uleft_12_Cright units (alias for atomic_mass_unit_12_mathrmc), returning new variable."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def amu(self) -> 'FieldQnty':
        """Convert to amu units (alias for atomic_mass_unit_12_mathrmc), returning new variable."""
        return self.atomic_mass_unit_12_mathrmc

    @property
    def carat_metric(self) -> 'FieldQnty':
        """Convert to carat (metric) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.carat_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ct(self) -> 'FieldQnty':
        """Convert to ct units (alias for carat_metric), returning new variable."""
        return self.carat_metric

    @property
    def cental(self) -> 'FieldQnty':
        """Convert to cental units, returning new variable."""
        unit_const: Final = field_units.MassUnits.cental
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sh_cwt_cH(self) -> 'FieldQnty':
        """Convert to sh_cwt_cH units (alias for cental), returning new variable."""
        return self.cental

    @property
    def centigram(self) -> 'FieldQnty':
        """Convert to centigram units, returning new variable."""
        unit_const: Final = field_units.MassUnits.centigram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cg(self) -> 'FieldQnty':
        """Convert to cg units (alias for centigram), returning new variable."""
        return self.centigram

    @property
    def clove_uk(self) -> 'FieldQnty':
        """Convert to clove (UK) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.clove_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cl(self) -> 'FieldQnty':
        """Convert to cl units (alias for clove_uk), returning new variable."""
        return self.clove_uk

    @property
    def drachm_apothecary(self) -> 'FieldQnty':
        """Convert to drachm (apothecary) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.drachm_apothecary
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dr_ap(self) -> 'FieldQnty':
        """Convert to dr_ap units (alias for drachm_apothecary), returning new variable."""
        return self.drachm_apothecary

    @property
    def dram_avoirdupois(self) -> 'FieldQnty':
        """Convert to dram (avoirdupois) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.dram_avoirdupois
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dr_av(self) -> 'FieldQnty':
        """Convert to dr_av units (alias for dram_avoirdupois), returning new variable."""
        return self.dram_avoirdupois

    @property
    def dram_troy(self) -> 'FieldQnty':
        """Convert to dram (troy) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.dram_troy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dr_troy(self) -> 'FieldQnty':
        """Convert to dr_troy units (alias for dram_troy), returning new variable."""
        return self.dram_troy

    @property
    def grain(self) -> 'FieldQnty':
        """Convert to grain units, returning new variable."""
        unit_const: Final = field_units.MassUnits.grain
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gr(self) -> 'FieldQnty':
        """Convert to gr units (alias for grain), returning new variable."""
        return self.grain

    @property
    def gram(self) -> 'FieldQnty':
        """Convert to gram units, returning new variable."""
        unit_const: Final = field_units.MassUnits.gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def g(self) -> 'FieldQnty':
        """Convert to g units (alias for gram), returning new variable."""
        return self.gram

    @property
    def hundredweight_long_or_gross(self) -> 'FieldQnty':
        """Convert to hundredweight, long or gross units, returning new variable."""
        unit_const: Final = field_units.MassUnits.hundredweight_long_or_gross
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cwt_lg_cwt(self) -> 'FieldQnty':
        """Convert to cwt_lg_cwt units (alias for hundredweight_long_or_gross), returning new variable."""
        return self.hundredweight_long_or_gross

    @property
    def hundredweight_short_or_net(self) -> 'FieldQnty':
        """Convert to hundredweight, short or net units, returning new variable."""
        unit_const: Final = field_units.MassUnits.hundredweight_short_or_net
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sh_cwt(self) -> 'FieldQnty':
        """Convert to sh_cwt units (alias for hundredweight_short_or_net), returning new variable."""
        return self.hundredweight_short_or_net

    @property
    def kilogram(self) -> 'FieldQnty':
        """Convert to kilogram units, returning new variable."""
        unit_const: Final = field_units.MassUnits.kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg(self) -> 'FieldQnty':
        """Convert to kg units (alias for kilogram), returning new variable."""
        return self.kilogram

    @property
    def kip(self) -> 'FieldQnty':
        """Convert to kip units, returning new variable."""
        unit_const: Final = field_units.MassUnits.kip
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def microgram(self) -> 'FieldQnty':
        """Convert to microgram units, returning new variable."""
        unit_const: Final = field_units.MassUnits.microgram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_g(self) -> 'FieldQnty':
        """Convert to mu_mathrm_g units (alias for microgram), returning new variable."""
        return self.microgram

    @property
    def milligram(self) -> 'FieldQnty':
        """Convert to milligram units, returning new variable."""
        unit_const: Final = field_units.MassUnits.milligram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mg(self) -> 'FieldQnty':
        """Convert to mg units (alias for milligram), returning new variable."""
        return self.milligram

    @property
    def ounce_apothecary(self) -> 'FieldQnty':
        """Convert to ounce (apothecary) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ounce_apothecary
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oz_ap(self) -> 'FieldQnty':
        """Convert to oz_ap units (alias for ounce_apothecary), returning new variable."""
        return self.ounce_apothecary

    @property
    def ounce_avoirdupois(self) -> 'FieldQnty':
        """Convert to ounce (avoirdupois) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ounce_avoirdupois
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oz(self) -> 'FieldQnty':
        """Convert to oz units (alias for ounce_avoirdupois), returning new variable."""
        return self.ounce_avoirdupois

    @property
    def ounce_troy(self) -> 'FieldQnty':
        """Convert to ounce (troy) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ounce_troy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oz_troy(self) -> 'FieldQnty':
        """Convert to oz_troy units (alias for ounce_troy), returning new variable."""
        return self.ounce_troy

    @property
    def pennyweight_troy(self) -> 'FieldQnty':
        """Convert to pennyweight (troy) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pennyweight_troy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dwt_troy(self) -> 'FieldQnty':
        """Convert to dwt_troy units (alias for pennyweight_troy), returning new variable."""
        return self.pennyweight_troy

    @property
    def pood_russia(self) -> 'FieldQnty':
        """Convert to pood, (Russia) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pood_russia
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pood(self) -> 'FieldQnty':
        """Convert to pood units (alias for pood_russia), returning new variable."""
        return self.pood_russia

    @property
    def pound_apothecary(self) -> 'FieldQnty':
        """Convert to pound (apothecary) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pound_apothecary
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_ap(self) -> 'FieldQnty':
        """Convert to lb_ap units (alias for pound_apothecary), returning new variable."""
        return self.pound_apothecary

    @property
    def pound_avoirdupois(self) -> 'FieldQnty':
        """Convert to pound (avoirdupois) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pound_avoirdupois
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_av(self) -> 'FieldQnty':
        """Convert to lb_av units (alias for pound_avoirdupois), returning new variable."""
        return self.pound_avoirdupois

    @property
    def pound_troy(self) -> 'FieldQnty':
        """Convert to pound (troy) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pound_troy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_troy(self) -> 'FieldQnty':
        """Convert to lb_troy units (alias for pound_troy), returning new variable."""
        return self.pound_troy

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound mass units, returning new variable."""
        unit_const: Final = field_units.MassUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_m(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_m units (alias for pound_mass), returning new variable."""
        return self.pound_mass

    @property
    def quarter_uk(self) -> 'FieldQnty':
        """Convert to quarter (UK) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.quarter_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def qt(self) -> 'FieldQnty':
        """Convert to qt units (alias for quarter_uk), returning new variable."""
        return self.quarter_uk

    @property
    def quintal_metric(self) -> 'FieldQnty':
        """Convert to quintal, metric units, returning new variable."""
        unit_const: Final = field_units.MassUnits.quintal_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def q_dt(self) -> 'FieldQnty':
        """Convert to q_dt units (alias for quintal_metric), returning new variable."""
        return self.quintal_metric

    @property
    def quital_us(self) -> 'FieldQnty':
        """Convert to quital, US units, returning new variable."""
        unit_const: Final = field_units.MassUnits.quital_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def quint_US(self) -> 'FieldQnty':
        """Convert to quint_US units (alias for quital_us), returning new variable."""
        return self.quital_us

    @property
    def scruple_avoirdupois(self) -> 'FieldQnty':
        """Convert to scruple (avoirdupois) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.scruple_avoirdupois
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def scf(self) -> 'FieldQnty':
        """Convert to scf units (alias for scruple_avoirdupois), returning new variable."""
        return self.scruple_avoirdupois

    @property
    def stone_uk(self) -> 'FieldQnty':
        """Convert to stone (UK) units, returning new variable."""
        unit_const: Final = field_units.MassUnits.stone_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def st(self) -> 'FieldQnty':
        """Convert to st units (alias for stone_uk), returning new variable."""
        return self.stone_uk

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton, metric units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def t(self) -> 'FieldQnty':
        """Convert to t units (alias for ton_metric), returning new variable."""
        return self.ton_metric

    @property
    def ton_us_long(self) -> 'FieldQnty':
        """Convert to ton, US, long units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ton_us_long
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lg_ton(self) -> 'FieldQnty':
        """Convert to lg_ton units (alias for ton_us_long), returning new variable."""
        return self.ton_us_long

    @property
    def ton_us_short(self) -> 'FieldQnty':
        """Convert to ton, US, short units, returning new variable."""
        unit_const: Final = field_units.MassUnits.ton_us_short
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sh_ton(self) -> 'FieldQnty':
        """Convert to sh_ton units (alias for ton_us_short), returning new variable."""
        return self.ton_us_short


class AsUnitMassDensityConverter(UnitConverter):
    """MassDensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to gram per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def g_cc_or_g_ml(self) -> 'FieldQnty':
        """Convert to g_cc_or_g_ml units (alias for gram_per_cubic_centimeter), returning new variable."""
        return self.gram_per_cubic_centimeter

    @property
    def g_cc(self) -> 'FieldQnty':
        """Convert to g_cc units (alias for gram_per_cubic_centimeter), returning new variable."""
        return self.gram_per_cubic_centimeter

    @property
    def g_ml(self) -> 'FieldQnty':
        """Convert to g_ml units (alias for gram_per_cubic_centimeter), returning new variable."""
        return self.gram_per_cubic_centimeter

    @property
    def gram_per_cubic_decimeter(self) -> 'FieldQnty':
        """Convert to gram per cubic decimeter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_decimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_dm_3(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_dm_3 units (alias for gram_per_cubic_decimeter), returning new variable."""
        return self.gram_per_cubic_decimeter

    @property
    def gram_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram per cubic meter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_m_3 units (alias for gram_per_cubic_meter), returning new variable."""
        return self.gram_per_cubic_meter

    @property
    def gram_per_liter(self) -> 'FieldQnty':
        """Convert to gram per liter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.gram_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_l_or_g_L(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_l_or_g_L units (alias for gram_per_liter), returning new variable."""
        return self.gram_per_liter

    @property
    def g_l(self) -> 'FieldQnty':
        """Convert to g_l units (alias for gram_per_liter), returning new variable."""
        return self.gram_per_liter

    @property
    def g_L(self) -> 'FieldQnty':
        """Convert to g_L units (alias for gram_per_liter), returning new variable."""
        return self.gram_per_liter

    @property
    def kilogram_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram per cubic meter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.kilogram_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_3 units (alias for kilogram_per_cubic_meter), returning new variable."""
        return self.kilogram_per_cubic_meter

    @property
    def ounce_avdp(self) -> 'FieldQnty':
        """Convert to ounce (avdp) per US gallon units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.ounce_avdp
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oz_gal(self) -> 'FieldQnty':
        """Convert to oz_gal units (alias for ounce_avdp), returning new variable."""
        return self.ounce_avdp

    @property
    def pound_avdp(self) -> 'FieldQnty':
        """Convert to pound (avdp) per cubic foot units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.pound_avdp
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_cu_mathrm_ft_or_lb_ft_3(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_cu_mathrm_ft_or_lb_ft_3 units (alias for pound_avdp), returning new variable."""
        return self.pound_avdp

    @property
    def lb_cu_ft(self) -> 'FieldQnty':
        """Convert to lb_cu_ft units (alias for pound_avdp), returning new variable."""
        return self.pound_avdp

    @property
    def lb_ft_3(self) -> 'FieldQnty':
        """Convert to lb_ft_3 units (alias for pound_avdp), returning new variable."""
        return self.pound_avdp

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound (mass) per cubic inch units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_cu_in_or_mathrm_lb_mathrm_in_3(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_cu_in_or_mathrm_lb_mathrm_in_3 units (alias for pound_mass), returning new variable."""
        return self.pound_mass

    @property
    def lb_cu_in(self) -> 'FieldQnty':
        """Convert to lb_cu_in units (alias for pound_mass), returning new variable."""
        return self.pound_mass

    @property
    def lb_in_3(self) -> 'FieldQnty':
        """Convert to lb_in_3 units (alias for pound_mass), returning new variable."""
        return self.pound_mass

    @property
    def ton_metric(self) -> 'FieldQnty':
        """Convert to ton (metric) per cubic meter units, returning new variable."""
        unit_const: Final = field_units.MassDensityUnits.ton_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_t_mathrm_m_3_or_MT_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_t_mathrm_m_3_or_MT_mathrm_m_3 units (alias for ton_metric), returning new variable."""
        return self.ton_metric

    @property
    def t_m_3(self) -> 'FieldQnty':
        """Convert to t_m_3 units (alias for ton_metric), returning new variable."""
        return self.ton_metric

    @property
    def MT_m_3(self) -> 'FieldQnty':
        """Convert to MT_m_3 units (alias for ton_metric), returning new variable."""
        return self.ton_metric


class AsUnitMassFlowRateConverter(UnitConverter):
    """MassFlowRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def kilograms_per_day(self) -> 'FieldQnty':
        """Convert to kilograms per day units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_d(self) -> 'FieldQnty':
        """Convert to kg_d units (alias for kilograms_per_day), returning new variable."""
        return self.kilograms_per_day

    @property
    def kilograms_per_hour(self) -> 'FieldQnty':
        """Convert to kilograms per hour units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_h(self) -> 'FieldQnty':
        """Convert to kg_h units (alias for kilograms_per_hour), returning new variable."""
        return self.kilograms_per_hour

    @property
    def kilograms_per_minute(self) -> 'FieldQnty':
        """Convert to kilograms per minute units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_min(self) -> 'FieldQnty':
        """Convert to kg_min units (alias for kilograms_per_minute), returning new variable."""
        return self.kilograms_per_minute

    @property
    def kilograms_per_second(self) -> 'FieldQnty':
        """Convert to kilograms per second units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.kilograms_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kg_s(self) -> 'FieldQnty':
        """Convert to kg_s units (alias for kilograms_per_second), returning new variable."""
        return self.kilograms_per_second

    @property
    def metric_tons_per_day(self) -> 'FieldQnty':
        """Convert to metric tons per day units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MT_d_or_MTD(self) -> 'FieldQnty':
        """Convert to MT_d_or_MTD units (alias for metric_tons_per_day), returning new variable."""
        return self.metric_tons_per_day

    @property
    def MT_d(self) -> 'FieldQnty':
        """Convert to MT_d units (alias for metric_tons_per_day), returning new variable."""
        return self.metric_tons_per_day

    @property
    def MTD(self) -> 'FieldQnty':
        """Convert to MTD units (alias for metric_tons_per_day), returning new variable."""
        return self.metric_tons_per_day

    @property
    def metric_tons_per_hour(self) -> 'FieldQnty':
        """Convert to metric tons per hour units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MT_h_or_MTD(self) -> 'FieldQnty':
        """Convert to MT_h_or_MTD units (alias for metric_tons_per_hour), returning new variable."""
        return self.metric_tons_per_hour

    @property
    def MT_h(self) -> 'FieldQnty':
        """Convert to MT_h units (alias for metric_tons_per_hour), returning new variable."""
        return self.metric_tons_per_hour

    @property
    def metric_tons_per_minute(self) -> 'FieldQnty':
        """Convert to metric tons per minute units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def metric_tons_per_second(self) -> 'FieldQnty':
        """Convert to metric tons per second units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MT_s(self) -> 'FieldQnty':
        """Convert to MT_s units (alias for metric_tons_per_second), returning new variable."""
        return self.metric_tons_per_second

    @property
    def metric_tons_per_year_365_d(self) -> 'FieldQnty':
        """Convert to metric tons per year (365 d) units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.metric_tons_per_year_365_d
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MT_yr_or_MTY(self) -> 'FieldQnty':
        """Convert to MT_yr_or_MTY units (alias for metric_tons_per_year_365_d), returning new variable."""
        return self.metric_tons_per_year_365_d

    @property
    def MT_yr(self) -> 'FieldQnty':
        """Convert to MT_yr units (alias for metric_tons_per_year_365_d), returning new variable."""
        return self.metric_tons_per_year_365_d

    @property
    def MTY(self) -> 'FieldQnty':
        """Convert to MTY units (alias for metric_tons_per_year_365_d), returning new variable."""
        return self.metric_tons_per_year_365_d

    @property
    def pounds_per_day(self) -> 'FieldQnty':
        """Convert to pounds per day units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_d_or_mathrm_lb_mathrm_da_or_PPD(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_d_or_mathrm_lb_mathrm_da_or_PPD units (alias for pounds_per_day), returning new variable."""
        return self.pounds_per_day

    @property
    def lb_d(self) -> 'FieldQnty':
        """Convert to lb_d units (alias for pounds_per_day), returning new variable."""
        return self.pounds_per_day

    @property
    def lb_da(self) -> 'FieldQnty':
        """Convert to lb_da units (alias for pounds_per_day), returning new variable."""
        return self.pounds_per_day

    @property
    def PPD(self) -> 'FieldQnty':
        """Convert to PPD units (alias for pounds_per_day), returning new variable."""
        return self.pounds_per_day

    @property
    def pounds_per_hour(self) -> 'FieldQnty':
        """Convert to pounds per hour units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_h_or_lb_hr_or_PPH(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_h_or_lb_hr_or_PPH units (alias for pounds_per_hour), returning new variable."""
        return self.pounds_per_hour

    @property
    def lb_h(self) -> 'FieldQnty':
        """Convert to lb_h units (alias for pounds_per_hour), returning new variable."""
        return self.pounds_per_hour

    @property
    def lb_hr(self) -> 'FieldQnty':
        """Convert to lb_hr units (alias for pounds_per_hour), returning new variable."""
        return self.pounds_per_hour

    @property
    def PPH(self) -> 'FieldQnty':
        """Convert to PPH units (alias for pounds_per_hour), returning new variable."""
        return self.pounds_per_hour

    @property
    def pounds_per_minute(self) -> 'FieldQnty':
        """Convert to pounds per minute units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_min_or_PPM(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_min_or_PPM units (alias for pounds_per_minute), returning new variable."""
        return self.pounds_per_minute

    @property
    def lb_min(self) -> 'FieldQnty':
        """Convert to lb_min units (alias for pounds_per_minute), returning new variable."""
        return self.pounds_per_minute

    @property
    def PPM(self) -> 'FieldQnty':
        """Convert to PPM units (alias for pounds_per_minute), returning new variable."""
        return self.pounds_per_minute

    @property
    def pounds_per_second(self) -> 'FieldQnty':
        """Convert to pounds per second units, returning new variable."""
        unit_const: Final = field_units.MassFlowRateUnits.pounds_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_s_or_lb_sec_or_PPS(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_s_or_lb_sec_or_PPS units (alias for pounds_per_second), returning new variable."""
        return self.pounds_per_second

    @property
    def lb_s(self) -> 'FieldQnty':
        """Convert to lb_s units (alias for pounds_per_second), returning new variable."""
        return self.pounds_per_second

    @property
    def lb_sec(self) -> 'FieldQnty':
        """Convert to lb_sec units (alias for pounds_per_second), returning new variable."""
        return self.pounds_per_second

    @property
    def PPS(self) -> 'FieldQnty':
        """Convert to PPS units (alias for pounds_per_second), returning new variable."""
        return self.pounds_per_second


class AsUnitMassFluxConverter(UnitConverter):
    """MassFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def kilogram_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per day units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_d_right units (alias for kilogram_per_square_meter_per_day), returning new variable."""
        return self.kilogram_per_square_meter_per_day

    @property
    def kilogram_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per hour units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_h_right units (alias for kilogram_per_square_meter_per_hour), returning new variable."""
        return self.kilogram_per_square_meter_per_hour

    @property
    def kilogram_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per minute units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_min_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_min_right units (alias for kilogram_per_square_meter_per_minute), returning new variable."""
        return self.kilogram_per_square_meter_per_minute

    @property
    def kilogram_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per second units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.kilogram_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_kg_left_mathrm_m_2_mathrm_s_right units (alias for kilogram_per_square_meter_per_second), returning new variable."""
        return self.kilogram_per_square_meter_per_second

    @property
    def pound_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to pound per square foot per day units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_d_right_or_lb_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_d_right_or_lb_sqft_da units (alias for pound_per_square_foot_per_day), returning new variable."""
        return self.pound_per_square_foot_per_day

    @property
    def lb_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_dright units (alias for pound_per_square_foot_per_day), returning new variable."""
        return self.pound_per_square_foot_per_day

    @property
    def lb_sqft_da(self) -> 'FieldQnty':
        """Convert to lb_sqft_da units (alias for pound_per_square_foot_per_day), returning new variable."""
        return self.pound_per_square_foot_per_day

    @property
    def pound_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pound per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_h_right_or_lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_h_right_or_lb_sqft_hr units (alias for pound_per_square_foot_per_hour), returning new variable."""
        return self.pound_per_square_foot_per_hour

    @property
    def lb_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_hright units (alias for pound_per_square_foot_per_hour), returning new variable."""
        return self.pound_per_square_foot_per_hour

    @property
    def lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_sqft_hr units (alias for pound_per_square_foot_per_hour), returning new variable."""
        return self.pound_per_square_foot_per_hour

    @property
    def pound_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to pound per square foot per minute units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_left_mathrm_ft_2_min_right_or_lb_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_min_right_or_lb_sqft_min units (alias for pound_per_square_foot_per_minute), returning new variable."""
        return self.pound_per_square_foot_per_minute

    @property
    def lb_left_ft_2_min_right(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_min_right units (alias for pound_per_square_foot_per_minute), returning new variable."""
        return self.pound_per_square_foot_per_minute

    @property
    def lb_sqft_min(self) -> 'FieldQnty':
        """Convert to lb_sqft_min units (alias for pound_per_square_foot_per_minute), returning new variable."""
        return self.pound_per_square_foot_per_minute

    @property
    def pound_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound per square foot per second units, returning new variable."""
        unit_const: Final = field_units.MassFluxUnits.pound_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec units (alias for pound_per_square_foot_per_second), returning new variable."""
        return self.pound_per_square_foot_per_second

    @property
    def lb_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_sright units (alias for pound_per_square_foot_per_second), returning new variable."""
        return self.pound_per_square_foot_per_second

    @property
    def lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to lb_sqft_sec units (alias for pound_per_square_foot_per_second), returning new variable."""
        return self.pound_per_square_foot_per_second


class AsUnitMassFractionOfIConverter(UnitConverter):
    """MassFractionOfI-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def grains_of_i_per_pound_total(self) -> 'FieldQnty':
        """Convert to grains of "i" per pound total units, returning new variable."""
        unit_const: Final = field_units.MassFractionOfIUnits.grains_of_i_per_pound_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gr_mathrm_i_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_gr_mathrm_i_mathrm_lb units (alias for grains_of_i_per_pound_total), returning new variable."""
        return self.grains_of_i_per_pound_total

    @property
    def gram_of_i_per_kilogram_total(self) -> 'FieldQnty':
        """Convert to gram of "i" per kilogram total units, returning new variable."""
        unit_const: Final = field_units.MassFractionOfIUnits.gram_of_i_per_kilogram_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_i_mathrm_kg units (alias for gram_of_i_per_kilogram_total), returning new variable."""
        return self.gram_of_i_per_kilogram_total

    @property
    def kilogram_of_i_per_kilogram_total(self) -> 'FieldQnty':
        """Convert to kilogram of "i" per kilogram total units, returning new variable."""
        unit_const: Final = field_units.MassFractionOfIUnits.kilogram_of_i_per_kilogram_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_i_mathrm_kg units (alias for kilogram_of_i_per_kilogram_total), returning new variable."""
        return self.kilogram_of_i_per_kilogram_total

    @property
    def pound_of_i_per_pound_total(self) -> 'FieldQnty':
        """Convert to pound of "i" per pound total units, returning new variable."""
        unit_const: Final = field_units.MassFractionOfIUnits.pound_of_i_per_pound_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_i_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_i_mathrm_lb units (alias for pound_of_i_per_pound_total), returning new variable."""
        return self.pound_of_i_per_pound_total


class AsUnitMassTransferCoefficientConverter(UnitConverter):
    """MassTransferCoefficient-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_per_square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to gram per square centimeter per second units, returning new variable."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.gram_per_square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2_mathrm_s units (alias for gram_per_square_centimeter_per_second), returning new variable."""
        return self.gram_per_square_centimeter_per_second

    @property
    def kilogram_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram per square meter per second units, returning new variable."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.kilogram_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2_mathrm_s units (alias for kilogram_per_square_meter_per_second), returning new variable."""
        return self.kilogram_per_square_meter_per_second

    @property
    def pounds_force_per_cubic_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pounds force per cubic foot per hour units, returning new variable."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_force_per_cubic_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_ft_3_mathrm_h_or_mathrm_lb_mathrm_f_mathrm_cft_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_ft_3_mathrm_h_or_mathrm_lb_mathrm_f_mathrm_cft_mathrm_hr units (alias for pounds_force_per_cubic_foot_per_hour), returning new variable."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def lb_f_ft_3_h(self) -> 'FieldQnty':
        """Convert to lb_f_ft_3_h units (alias for pounds_force_per_cubic_foot_per_hour), returning new variable."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def lb_f_cft_hr(self) -> 'FieldQnty':
        """Convert to lb_f_cft_hr units (alias for pounds_force_per_cubic_foot_per_hour), returning new variable."""
        return self.pounds_force_per_cubic_foot_per_hour

    @property
    def pounds_mass_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pounds mass per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_mass_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_ft_2_mathrm_hr_or_lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_ft_2_mathrm_hr_or_lb_sqft_hr units (alias for pounds_mass_per_square_foot_per_hour), returning new variable."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def lb_ft_2_hr(self) -> 'FieldQnty':
        """Convert to lb_ft_2_hr units (alias for pounds_mass_per_square_foot_per_hour), returning new variable."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def lb_sqft_hr(self) -> 'FieldQnty':
        """Convert to lb_sqft_hr units (alias for pounds_mass_per_square_foot_per_hour), returning new variable."""
        return self.pounds_mass_per_square_foot_per_hour

    @property
    def pounds_mass_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pounds mass per square foot per second units, returning new variable."""
        unit_const: Final = field_units.MassTransferCoefficientUnits.pounds_mass_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec units (alias for pounds_mass_per_square_foot_per_second), returning new variable."""
        return self.pounds_mass_per_square_foot_per_second

    @property
    def lb_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_left_ft_2_sright units (alias for pounds_mass_per_square_foot_per_second), returning new variable."""
        return self.pounds_mass_per_square_foot_per_second

    @property
    def lb_sqft_sec(self) -> 'FieldQnty':
        """Convert to lb_sqft_sec units (alias for pounds_mass_per_square_foot_per_second), returning new variable."""
        return self.pounds_mass_per_square_foot_per_second


class AsUnitMolalityOfSoluteIConverter(UnitConverter):
    """MolalityOfSoluteI-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_moles_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per kilogram units, returning new variable."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.gram_moles_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mol_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_kg units (alias for gram_moles_of_i_per_kilogram), returning new variable."""
        return self.gram_moles_of_i_per_kilogram

    @property
    def kilogram_mols_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram mols of "i" per kilogram units, returning new variable."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.kilogram_mols_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_mathrm_i_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_kg units (alias for kilogram_mols_of_i_per_kilogram), returning new variable."""
        return self.kilogram_mols_of_i_per_kilogram

    @property
    def kmols_of_i_per_kilogram(self) -> 'FieldQnty':
        """Convert to kmols of "i" per kilogram units, returning new variable."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.kmols_of_i_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mols_of_i_per_gram(self) -> 'FieldQnty':
        """Convert to mols of "i" per gram units, returning new variable."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.mols_of_i_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mol_mathrm_i_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_g units (alias for mols_of_i_per_gram), returning new variable."""
        return self.mols_of_i_per_gram

    @property
    def pound_moles_of_i_per_pound_mass(self) -> 'FieldQnty':
        """Convert to pound moles of "i" per pound mass units, returning new variable."""
        unit_const: Final = field_units.MolalityOfSoluteIUnits.pound_moles_of_i_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mole_mathrm_i_mathrm_lb_mass(self) -> 'FieldQnty':
        """Convert to mole_mathrm_i_mathrm_lb_mass units (alias for pound_moles_of_i_per_pound_mass), returning new variable."""
        return self.pound_moles_of_i_per_pound_mass


class AsUnitMolarConcentrationByMassConverter(UnitConverter):
    """MolarConcentrationByMass-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_mole_or_mole_per_gram(self) -> 'FieldQnty':
        """Convert to gram mole or mole per gram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.gram_mole_or_mole_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_g(self) -> 'FieldQnty':
        """Convert to mol_g units (alias for gram_mole_or_mole_per_gram), returning new variable."""
        return self.gram_mole_or_mole_per_gram

    @property
    def gram_mole_or_mole_per_kilogram(self) -> 'FieldQnty':
        """Convert to gram mole or mole per kilogram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.gram_mole_or_mole_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_kg(self) -> 'FieldQnty':
        """Convert to mol_kg units (alias for gram_mole_or_mole_per_kilogram), returning new variable."""
        return self.gram_mole_or_mole_per_kilogram

    @property
    def kilogram_mole_or_kmol_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per kilogram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.kilogram_mole_or_kmol_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol_kg(self) -> 'FieldQnty':
        """Convert to kmol_kg units (alias for kilogram_mole_or_kmol_per_kilogram), returning new variable."""
        return self.kilogram_mole_or_kmol_per_kilogram

    @property
    def micromole_per_gram(self) -> 'FieldQnty':
        """Convert to micromole per gram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.micromole_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_mol_mathrm_g(self) -> 'FieldQnty':
        """Convert to mu_mathrm_mol_mathrm_g units (alias for micromole_per_gram), returning new variable."""
        return self.micromole_per_gram

    @property
    def millimole_per_gram(self) -> 'FieldQnty':
        """Convert to millimole per gram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.millimole_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mmol_g(self) -> 'FieldQnty':
        """Convert to mmol_g units (alias for millimole_per_gram), returning new variable."""
        return self.millimole_per_gram

    @property
    def picomole_per_gram(self) -> 'FieldQnty':
        """Convert to picomole per gram units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.picomole_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pmol_g(self) -> 'FieldQnty':
        """Convert to pmol_g units (alias for picomole_per_gram), returning new variable."""
        return self.picomole_per_gram

    @property
    def pound_mole_per_pound(self) -> 'FieldQnty':
        """Convert to pound mole per pound units, returning new variable."""
        unit_const: Final = field_units.MolarConcentrationByMassUnits.pound_mole_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_mathrm_lb_or_mole_lb(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_mathrm_lb_or_mole_lb units (alias for pound_mole_per_pound), returning new variable."""
        return self.pound_mole_per_pound

    @property
    def lb_mol_lb(self) -> 'FieldQnty':
        """Convert to lb_mol_lb units (alias for pound_mole_per_pound), returning new variable."""
        return self.pound_mole_per_pound

    @property
    def mole_lb(self) -> 'FieldQnty':
        """Convert to mole_lb units (alias for pound_mole_per_pound), returning new variable."""
        return self.pound_mole_per_pound


class AsUnitMolarFlowRateConverter(UnitConverter):
    """MolarFlowRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_mole_per_day(self) -> 'FieldQnty':
        """Convert to gram mole per day units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_d(self) -> 'FieldQnty':
        """Convert to mol_d units (alias for gram_mole_per_day), returning new variable."""
        return self.gram_mole_per_day

    @property
    def gram_mole_per_hour(self) -> 'FieldQnty':
        """Convert to gram mole per hour units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_h(self) -> 'FieldQnty':
        """Convert to mol_h units (alias for gram_mole_per_hour), returning new variable."""
        return self.gram_mole_per_hour

    @property
    def gram_mole_per_minute(self) -> 'FieldQnty':
        """Convert to gram mole per minute units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_min(self) -> 'FieldQnty':
        """Convert to mol_min units (alias for gram_mole_per_minute), returning new variable."""
        return self.gram_mole_per_minute

    @property
    def gram_mole_per_second(self) -> 'FieldQnty':
        """Convert to gram mole per second units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.gram_mole_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mol_s(self) -> 'FieldQnty':
        """Convert to mol_s units (alias for gram_mole_per_second), returning new variable."""
        return self.gram_mole_per_second

    @property
    def kilogram_mole_or_kmol_per_day(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per day units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol_d(self) -> 'FieldQnty':
        """Convert to kmol_d units (alias for kilogram_mole_or_kmol_per_day), returning new variable."""
        return self.kilogram_mole_or_kmol_per_day

    @property
    def kilogram_mole_or_kmol_per_hour(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per hour units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol_h(self) -> 'FieldQnty':
        """Convert to kmol_h units (alias for kilogram_mole_or_kmol_per_hour), returning new variable."""
        return self.kilogram_mole_or_kmol_per_hour

    @property
    def kilogram_mole_or_kmol_per_minute(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per minute units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol_min(self) -> 'FieldQnty':
        """Convert to kmol_min units (alias for kilogram_mole_or_kmol_per_minute), returning new variable."""
        return self.kilogram_mole_or_kmol_per_minute

    @property
    def kilogram_mole_or_kmol_per_second(self) -> 'FieldQnty':
        """Convert to kilogram mole or kmol per second units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.kilogram_mole_or_kmol_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kmol_s(self) -> 'FieldQnty':
        """Convert to kmol_s units (alias for kilogram_mole_or_kmol_per_second), returning new variable."""
        return self.kilogram_mole_or_kmol_per_second

    @property
    def pound_mole_or_lb_mol_per_day(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per day units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mol_d_or_mole_da(self) -> 'FieldQnty':
        """Convert to lb_mol_d_or_mole_da units (alias for pound_mole_or_lb_mol_per_day), returning new variable."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def lb_mol_d(self) -> 'FieldQnty':
        """Convert to lb_mol_d units (alias for pound_mole_or_lb_mol_per_day), returning new variable."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def mole_da(self) -> 'FieldQnty':
        """Convert to mole_da units (alias for pound_mole_or_lb_mol_per_day), returning new variable."""
        return self.pound_mole_or_lb_mol_per_day

    @property
    def pound_mole_or_lb_mol_per_hour(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per hour units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mol_h_or_mole_hr(self) -> 'FieldQnty':
        """Convert to lb_mol_h_or_mole_hr units (alias for pound_mole_or_lb_mol_per_hour), returning new variable."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def lb_mol_h(self) -> 'FieldQnty':
        """Convert to lb_mol_h units (alias for pound_mole_or_lb_mol_per_hour), returning new variable."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def mole_hr(self) -> 'FieldQnty':
        """Convert to mole_hr units (alias for pound_mole_or_lb_mol_per_hour), returning new variable."""
        return self.pound_mole_or_lb_mol_per_hour

    @property
    def pound_mole_or_lb_mol_per_minute(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per minute units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mol_min_or_mole_min(self) -> 'FieldQnty':
        """Convert to lb_mol_min_or_mole_min units (alias for pound_mole_or_lb_mol_per_minute), returning new variable."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def lb_mol_min(self) -> 'FieldQnty':
        """Convert to lb_mol_min units (alias for pound_mole_or_lb_mol_per_minute), returning new variable."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def mole_min(self) -> 'FieldQnty':
        """Convert to mole_min units (alias for pound_mole_or_lb_mol_per_minute), returning new variable."""
        return self.pound_mole_or_lb_mol_per_minute

    @property
    def pound_mole_or_lb_mol_per_second(self) -> 'FieldQnty':
        """Convert to pound mole or lb-mol per second units, returning new variable."""
        unit_const: Final = field_units.MolarFlowRateUnits.pound_mole_or_lb_mol_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_mathrm_s_or_mole_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_mathrm_s_or_mole_sec units (alias for pound_mole_or_lb_mol_per_second), returning new variable."""
        return self.pound_mole_or_lb_mol_per_second

    @property
    def lb_mol_s(self) -> 'FieldQnty':
        """Convert to lb_mol_s units (alias for pound_mole_or_lb_mol_per_second), returning new variable."""
        return self.pound_mole_or_lb_mol_per_second

    @property
    def mole_sec(self) -> 'FieldQnty':
        """Convert to mole_sec units (alias for pound_mole_or_lb_mol_per_second), returning new variable."""
        return self.pound_mole_or_lb_mol_per_second


class AsUnitMolarFluxConverter(UnitConverter):
    """MolarFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def kmol_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to kmol per square meter per day units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_d_right units (alias for kmol_per_square_meter_per_day), returning new variable."""
        return self.kmol_per_square_meter_per_day

    @property
    def kmol_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to kmol per square meter per hour units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_h_right units (alias for kmol_per_square_meter_per_hour), returning new variable."""
        return self.kmol_per_square_meter_per_hour

    @property
    def kmol_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to kmol per square meter per minute units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_left_mathrm_m_2_right_amin(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_right_amin units (alias for kmol_per_square_meter_per_minute), returning new variable."""
        return self.kmol_per_square_meter_per_minute

    @property
    def kmol_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to kmol per square meter per second units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.kmol_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_left_mathrm_m_2_mathrm_s_right units (alias for kmol_per_square_meter_per_second), returning new variable."""
        return self.kmol_per_square_meter_per_second

    @property
    def pound_mole_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per day units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_d_right_or_mole_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_d_right_or_mole_sqft_da units (alias for pound_mole_per_square_foot_per_day), returning new variable."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def lb_mol_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_dright units (alias for pound_mole_per_square_foot_per_day), returning new variable."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def mole_sqft_da(self) -> 'FieldQnty':
        """Convert to mole_sqft_da units (alias for pound_mole_per_square_foot_per_day), returning new variable."""
        return self.pound_mole_per_square_foot_per_day

    @property
    def pound_mole_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_h_right_or_mole_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_h_right_or_mole_sqft_hr units (alias for pound_mole_per_square_foot_per_hour), returning new variable."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def lb_mol_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_hright units (alias for pound_mole_per_square_foot_per_hour), returning new variable."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def mole_sqft_hr(self) -> 'FieldQnty':
        """Convert to mole_sqft_hr units (alias for pound_mole_per_square_foot_per_hour), returning new variable."""
        return self.pound_mole_per_square_foot_per_hour

    @property
    def pound_mole_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per minute units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_min_right_or_mole_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_min_right_or_mole_sqft_min units (alias for pound_mole_per_square_foot_per_minute), returning new variable."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def lb_mol_left_ft_2_minright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_minright units (alias for pound_mole_per_square_foot_per_minute), returning new variable."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def mole_sqft_min(self) -> 'FieldQnty':
        """Convert to mole_sqft_min units (alias for pound_mole_per_square_foot_per_minute), returning new variable."""
        return self.pound_mole_per_square_foot_per_minute

    @property
    def pound_mole_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to pound mole per square foot per second units, returning new variable."""
        unit_const: Final = field_units.MolarFluxUnits.pound_mole_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_s_right_or_mole_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_s_right_or_mole_sqft_sec units (alias for pound_mole_per_square_foot_per_second), returning new variable."""
        return self.pound_mole_per_square_foot_per_second

    @property
    def lb_mol_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to lb_mol_left_ft_2_sright units (alias for pound_mole_per_square_foot_per_second), returning new variable."""
        return self.pound_mole_per_square_foot_per_second

    @property
    def mole_sqft_sec(self) -> 'FieldQnty':
        """Convert to mole_sqft_sec units (alias for pound_mole_per_square_foot_per_second), returning new variable."""
        return self.pound_mole_per_square_foot_per_second


class AsUnitMolarHeatCapacityConverter(UnitConverter):
    """MolarHeatCapacity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to Btu per pound mole per degree Fahrenheit (or degree Rankine) units, returning new variable."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb_mol_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_lb_mol_circ_mathrm_F units (alias for btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine), returning new variable."""
        return self.btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine

    @property
    def calories_per_gram_mole_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to calories per gram mole per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.calories_per_gram_mole_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_mol_K(self) -> 'FieldQnty':
        """Convert to cal_mol_K units (alias for calories_per_gram_mole_per_kelvin_or_degree_celsius), returning new variable."""
        return self.calories_per_gram_mole_per_kelvin_or_degree_celsius

    @property
    def joule_per_gram_mole_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to joule per gram mole per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.MolarHeatCapacityUnits.joule_per_gram_mole_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_mol_K(self) -> 'FieldQnty':
        """Convert to J_mol_K units (alias for joule_per_gram_mole_per_kelvin_or_degree_celsius), returning new variable."""
        return self.joule_per_gram_mole_per_kelvin_or_degree_celsius


class AsUnitMolarityOfIConverter(UnitConverter):
    """MolarityOfI-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_moles_of_i_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per cubic meter units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.gram_moles_of_i_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mol_mathrm_i_mathrm_m_3_or_mathrm_c_mathrm_i(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_m_3_or_mathrm_c_mathrm_i units (alias for gram_moles_of_i_per_cubic_meter), returning new variable."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def mol_i_m_3(self) -> 'FieldQnty':
        """Convert to mol_i_m_3 units (alias for gram_moles_of_i_per_cubic_meter), returning new variable."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def c_i(self) -> 'FieldQnty':
        """Convert to c_i units (alias for gram_moles_of_i_per_cubic_meter), returning new variable."""
        return self.gram_moles_of_i_per_cubic_meter

    @property
    def gram_moles_of_i_per_liter(self) -> 'FieldQnty':
        """Convert to gram moles of "i" per liter units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.gram_moles_of_i_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mol_mathrm_i_mathrm_l(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_l units (alias for gram_moles_of_i_per_liter), returning new variable."""
        return self.gram_moles_of_i_per_liter

    @property
    def kilogram_moles_of_i_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilogram moles of "i" per cubic meter units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.kilogram_moles_of_i_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_mathrm_i_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_m_3 units (alias for kilogram_moles_of_i_per_cubic_meter), returning new variable."""
        return self.kilogram_moles_of_i_per_cubic_meter

    @property
    def kilogram_moles_of_i_per_liter(self) -> 'FieldQnty':
        """Convert to kilogram moles of "i" per liter units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.kilogram_moles_of_i_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_mathrm_i_mathrm_l(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_l units (alias for kilogram_moles_of_i_per_liter), returning new variable."""
        return self.kilogram_moles_of_i_per_liter

    @property
    def pound_moles_of_i_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound moles of "i" per cubic foot units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.pound_moles_of_i_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_ft_3_or_mathrm_mole_mathrm_i_cft(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_ft_3_or_mathrm_mole_mathrm_i_cft units (alias for pound_moles_of_i_per_cubic_foot), returning new variable."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def lb_mol_i_ft_3(self) -> 'FieldQnty':
        """Convert to lb_mol_i_ft_3 units (alias for pound_moles_of_i_per_cubic_foot), returning new variable."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def mole_i_cft(self) -> 'FieldQnty':
        """Convert to mole_i_cft units (alias for pound_moles_of_i_per_cubic_foot), returning new variable."""
        return self.pound_moles_of_i_per_cubic_foot

    @property
    def pound_moles_of_i_per_gallon_us(self) -> 'FieldQnty':
        """Convert to pound moles of " $i$ " per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.MolarityOfIUnits.pound_moles_of_i_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_gal_or_mathrm_mole_mathrm_i_gal(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_gal_or_mathrm_mole_mathrm_i_gal units (alias for pound_moles_of_i_per_gallon_us), returning new variable."""
        return self.pound_moles_of_i_per_gallon_us

    @property
    def lb_mol_i_gal(self) -> 'FieldQnty':
        """Convert to lb_mol_i_gal units (alias for pound_moles_of_i_per_gallon_us), returning new variable."""
        return self.pound_moles_of_i_per_gallon_us

    @property
    def mole_i_gal(self) -> 'FieldQnty':
        """Convert to mole_i_gal units (alias for pound_moles_of_i_per_gallon_us), returning new variable."""
        return self.pound_moles_of_i_per_gallon_us


class AsUnitMoleFractionOfIConverter(UnitConverter):
    """MoleFractionOfI-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_mole_of_i_per_gram_mole_total(self) -> 'FieldQnty':
        """Convert to gram mole of "i" per gram mole total units, returning new variable."""
        unit_const: Final = field_units.MoleFractionOfIUnits.gram_mole_of_i_per_gram_mole_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mol_mathrm_i_mathrm_mol(self) -> 'FieldQnty':
        """Convert to mathrm_mol_mathrm_i_mathrm_mol units (alias for gram_mole_of_i_per_gram_mole_total), returning new variable."""
        return self.gram_mole_of_i_per_gram_mole_total

    @property
    def kilogram_mole_of_i_per_kilogram_mole_total(self) -> 'FieldQnty':
        """Convert to kilogram mole of "i" per kilogram mole total units, returning new variable."""
        unit_const: Final = field_units.MoleFractionOfIUnits.kilogram_mole_of_i_per_kilogram_mole_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kmol_mathrm_i_mathrm_kmol(self) -> 'FieldQnty':
        """Convert to mathrm_kmol_mathrm_i_mathrm_kmol units (alias for kilogram_mole_of_i_per_kilogram_mole_total), returning new variable."""
        return self.kilogram_mole_of_i_per_kilogram_mole_total

    @property
    def kilomole_of_i_per_kilomole_total(self) -> 'FieldQnty':
        """Convert to kilomole of "i" per kilomole total units, returning new variable."""
        unit_const: Final = field_units.MoleFractionOfIUnits.kilomole_of_i_per_kilomole_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pound_mole_of_i_per_pound_mole_total(self) -> 'FieldQnty':
        """Convert to pound mole of "i" per pound mole total units, returning new variable."""
        unit_const: Final = field_units.MoleFractionOfIUnits.pound_mole_of_i_per_pound_mole_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_lb_mathrm_mol(self) -> 'FieldQnty':
        """Convert to lb_mathrm_mol_mathrm_i_mathrm_lb_mathrm_mol units (alias for pound_mole_of_i_per_pound_mole_total), returning new variable."""
        return self.pound_mole_of_i_per_pound_mole_total


class AsUnitMomentOfInertiaConverter(UnitConverter):
    """MomentOfInertia-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_force_centimeter_square_second(self) -> 'FieldQnty':
        """Convert to gram force centimeter square second units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.gram_force_centimeter_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_f_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_f_mathrm_cm_mathrm_s_2 units (alias for gram_force_centimeter_square_second), returning new variable."""
        return self.gram_force_centimeter_square_second

    @property
    def gram_square_centimeter(self) -> 'FieldQnty':
        """Convert to gram square centimeter units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.gram_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_2 units (alias for gram_square_centimeter), returning new variable."""
        return self.gram_square_centimeter

    @property
    def kilogram_force_centimeter_square_second(self) -> 'FieldQnty':
        """Convert to kilogram force centimeter square second units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_force_centimeter_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_cm_mathrm_s_2 units (alias for kilogram_force_centimeter_square_second), returning new variable."""
        return self.kilogram_force_centimeter_square_second

    @property
    def kilogram_force_meter_square_second(self) -> 'FieldQnty':
        """Convert to kilogram force meter square second units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_force_meter_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_mathrm_s_2 units (alias for kilogram_force_meter_square_second), returning new variable."""
        return self.kilogram_force_meter_square_second

    @property
    def kilogram_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram square centimeter units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_cm_2 units (alias for kilogram_square_centimeter), returning new variable."""
        return self.kilogram_square_centimeter

    @property
    def kilogram_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram square meter units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.kilogram_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2 units (alias for kilogram_square_meter), returning new variable."""
        return self.kilogram_square_meter

    @property
    def ounce_force_inch_square_second(self) -> 'FieldQnty':
        """Convert to ounce force inch square second units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.ounce_force_inch_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_oz_mathrm_f_in_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_oz_mathrm_f_in_mathrm_s_2 units (alias for ounce_force_inch_square_second), returning new variable."""
        return self.ounce_force_inch_square_second

    @property
    def ounce_mass_square_inch(self) -> 'FieldQnty':
        """Convert to ounce mass square inch units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.ounce_mass_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def oz_in_2(self) -> 'FieldQnty':
        """Convert to oz_in_2 units (alias for ounce_mass_square_inch), returning new variable."""
        return self.ounce_mass_square_inch

    @property
    def pound_mass_square_foot(self) -> 'FieldQnty':
        """Convert to pound mass square foot units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.pound_mass_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_ft_2_or_lb_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_ft_2_or_lb_sq_ft units (alias for pound_mass_square_foot), returning new variable."""
        return self.pound_mass_square_foot

    @property
    def lb_ft_2(self) -> 'FieldQnty':
        """Convert to lb_ft_2 units (alias for pound_mass_square_foot), returning new variable."""
        return self.pound_mass_square_foot

    @property
    def lb_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_sq_ft units (alias for pound_mass_square_foot), returning new variable."""
        return self.pound_mass_square_foot

    @property
    def pound_mass_square_inch(self) -> 'FieldQnty':
        """Convert to pound mass square inch units, returning new variable."""
        unit_const: Final = field_units.MomentOfInertiaUnits.pound_mass_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_in_2 units (alias for pound_mass_square_inch), returning new variable."""
        return self.pound_mass_square_inch


class AsUnitMomentumFlowRateConverter(UnitConverter):
    """MomentumFlowRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def foot_pounds_per_square_hour(self) -> 'FieldQnty':
        """Convert to foot pounds per square hour units, returning new variable."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_h_2_or_mathrm_ft_mathrm_lb_mathrm_hr_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_h_2_or_mathrm_ft_mathrm_lb_mathrm_hr_2 units (alias for foot_pounds_per_square_hour), returning new variable."""
        return self.foot_pounds_per_square_hour

    @property
    def ft_lb_h_2(self) -> 'FieldQnty':
        """Convert to ft_lb_h_2 units (alias for foot_pounds_per_square_hour), returning new variable."""
        return self.foot_pounds_per_square_hour

    @property
    def ft_lb_hr_2(self) -> 'FieldQnty':
        """Convert to ft_lb_hr_2 units (alias for foot_pounds_per_square_hour), returning new variable."""
        return self.foot_pounds_per_square_hour

    @property
    def foot_pounds_per_square_minute(self) -> 'FieldQnty':
        """Convert to foot pounds per square minute units, returning new variable."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_min_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_min_2 units (alias for foot_pounds_per_square_minute), returning new variable."""
        return self.foot_pounds_per_square_minute

    @property
    def foot_pounds_per_square_second(self) -> 'FieldQnty':
        """Convert to foot pounds per square second units, returning new variable."""
        unit_const: Final = field_units.MomentumFlowRateUnits.foot_pounds_per_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_s_2_or_ft_lb_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_s_2_or_ft_lb_sec_2 units (alias for foot_pounds_per_square_second), returning new variable."""
        return self.foot_pounds_per_square_second

    @property
    def ft_lb_s_2(self) -> 'FieldQnty':
        """Convert to ft_lb_s_2 units (alias for foot_pounds_per_square_second), returning new variable."""
        return self.foot_pounds_per_square_second

    @property
    def ft_lb_sec_2(self) -> 'FieldQnty':
        """Convert to ft_lb_sec_2 units (alias for foot_pounds_per_square_second), returning new variable."""
        return self.foot_pounds_per_square_second

    @property
    def gram_centimeters_per_square_second(self) -> 'FieldQnty':
        """Convert to gram centimeters per square second units, returning new variable."""
        unit_const: Final = field_units.MomentumFlowRateUnits.gram_centimeters_per_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s_2 units (alias for gram_centimeters_per_square_second), returning new variable."""
        return self.gram_centimeters_per_square_second

    @property
    def kilogram_meters_per_square_second(self) -> 'FieldQnty':
        """Convert to kilogram meters per square second units, returning new variable."""
        unit_const: Final = field_units.MomentumFlowRateUnits.kilogram_meters_per_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_mathrm_s_2 units (alias for kilogram_meters_per_square_second), returning new variable."""
        return self.kilogram_meters_per_square_second


class AsUnitMomentumFluxConverter(UnitConverter):
    """MomentumFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units, returning new variable."""
        unit_const: Final = field_units.MomentumFluxUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter), returning new variable."""
        return self.dyne_per_square_centimeter

    @property
    def gram_per_centimeter_per_square_second(self) -> 'FieldQnty':
        """Convert to gram per centimeter per square second units, returning new variable."""
        unit_const: Final = field_units.MomentumFluxUnits.gram_per_centimeter_per_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_mathrm_s_2 units (alias for gram_per_centimeter_per_square_second), returning new variable."""
        return self.gram_per_centimeter_per_square_second

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units, returning new variable."""
        unit_const: Final = field_units.MomentumFluxUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter), returning new variable."""
        return self.newton_per_square_meter

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units, returning new variable."""
        unit_const: Final = field_units.MomentumFluxUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_sq_mathrm_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_sq_mathrm_ft units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def pound_mass_per_foot_per_square_second(self) -> 'FieldQnty':
        """Convert to pound mass per foot per square second units, returning new variable."""
        unit_const: Final = field_units.MomentumFluxUnits.pound_mass_per_foot_per_square_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_m_mathrm_ft_mathrm_s_2_or_mathrm_lb_mathrm_ft_mathrm_sec_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_m_mathrm_ft_mathrm_s_2_or_mathrm_lb_mathrm_ft_mathrm_sec_2 units (alias for pound_mass_per_foot_per_square_second), returning new variable."""
        return self.pound_mass_per_foot_per_square_second

    @property
    def lb_m_ft_s_2(self) -> 'FieldQnty':
        """Convert to lb_m_ft_s_2 units (alias for pound_mass_per_foot_per_square_second), returning new variable."""
        return self.pound_mass_per_foot_per_square_second

    @property
    def lb_ft_sec_2(self) -> 'FieldQnty':
        """Convert to lb_ft_sec_2 units (alias for pound_mass_per_foot_per_square_second), returning new variable."""
        return self.pound_mass_per_foot_per_square_second


class AsUnitNormalityOfSolutionConverter(UnitConverter):
    """NormalityOfSolution-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_equivalents_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to gram equivalents per cubic meter units, returning new variable."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.gram_equivalents_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_eq_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_eq_mathrm_m_3 units (alias for gram_equivalents_per_cubic_meter), returning new variable."""
        return self.gram_equivalents_per_cubic_meter

    @property
    def gram_equivalents_per_liter(self) -> 'FieldQnty':
        """Convert to gram equivalents per liter units, returning new variable."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.gram_equivalents_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def eq_l(self) -> 'FieldQnty':
        """Convert to eq_l units (alias for gram_equivalents_per_liter), returning new variable."""
        return self.gram_equivalents_per_liter

    @property
    def pound_equivalents_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to pound equivalents per cubic foot units, returning new variable."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.pound_equivalents_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_eq_mathrm_ft_3_or_lb_eq_cft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_eq_mathrm_ft_3_or_lb_eq_cft units (alias for pound_equivalents_per_cubic_foot), returning new variable."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def lb_eq_ft_3(self) -> 'FieldQnty':
        """Convert to lb_eq_ft_3 units (alias for pound_equivalents_per_cubic_foot), returning new variable."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def lb_eq_cft(self) -> 'FieldQnty':
        """Convert to lb_eq_cft units (alias for pound_equivalents_per_cubic_foot), returning new variable."""
        return self.pound_equivalents_per_cubic_foot

    @property
    def pound_equivalents_per_gallon(self) -> 'FieldQnty':
        """Convert to pound equivalents per gallon units, returning new variable."""
        unit_const: Final = field_units.NormalityOfSolutionUnits.pound_equivalents_per_gallon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def lb_eq_gal_US(self) -> 'FieldQnty':
        """Convert to lb_eq_gal_US units (alias for pound_equivalents_per_gallon), returning new variable."""
        return self.pound_equivalents_per_gallon


class AsUnitParticleDensityConverter(UnitConverter):
    """ParticleDensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def particles_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to particles per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_cm_3_or_part_cc(self) -> 'FieldQnty':
        """Convert to part_cm_3_or_part_cc units (alias for particles_per_cubic_centimeter), returning new variable."""
        return self.particles_per_cubic_centimeter

    @property
    def part_cm_3(self) -> 'FieldQnty':
        """Convert to part_cm_3 units (alias for particles_per_cubic_centimeter), returning new variable."""
        return self.particles_per_cubic_centimeter

    @property
    def part_cc(self) -> 'FieldQnty':
        """Convert to part_cc units (alias for particles_per_cubic_centimeter), returning new variable."""
        return self.particles_per_cubic_centimeter

    @property
    def particles_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to particles per cubic foot units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_mathrm_ft_3_or_part_cft(self) -> 'FieldQnty':
        """Convert to part_mathrm_ft_3_or_part_cft units (alias for particles_per_cubic_foot), returning new variable."""
        return self.particles_per_cubic_foot

    @property
    def part_ft_3(self) -> 'FieldQnty':
        """Convert to part_ft_3 units (alias for particles_per_cubic_foot), returning new variable."""
        return self.particles_per_cubic_foot

    @property
    def part_cft(self) -> 'FieldQnty':
        """Convert to part_cft units (alias for particles_per_cubic_foot), returning new variable."""
        return self.particles_per_cubic_foot

    @property
    def particles_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to particles per cubic meter units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to part_mathrm_m_3 units (alias for particles_per_cubic_meter), returning new variable."""
        return self.particles_per_cubic_meter

    @property
    def particles_per_gallon_us(self) -> 'FieldQnty':
        """Convert to particles per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_gal(self) -> 'FieldQnty':
        """Convert to part_gal units (alias for particles_per_gallon_us), returning new variable."""
        return self.particles_per_gallon_us

    @property
    def particles_per_liter(self) -> 'FieldQnty':
        """Convert to particles per liter units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_l(self) -> 'FieldQnty':
        """Convert to part_l units (alias for particles_per_liter), returning new variable."""
        return self.particles_per_liter

    @property
    def particles_per_milliliter(self) -> 'FieldQnty':
        """Convert to particles per milliliter units, returning new variable."""
        unit_const: Final = field_units.ParticleDensityUnits.particles_per_milliliter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def part_ml(self) -> 'FieldQnty':
        """Convert to part_ml units (alias for particles_per_milliliter), returning new variable."""
        return self.particles_per_milliliter


class AsUnitPercentConverter(UnitConverter):
    """Percent-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def percent(self) -> 'FieldQnty':
        """Convert to percent units, returning new variable."""
        unit_const: Final = field_units.PercentUnits.percent
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for percent), returning new variable."""
        return self.percent

    @property
    def per_mille(self) -> 'FieldQnty':
        """Convert to per mille units, returning new variable."""
        unit_const: Final = field_units.PercentUnits.per_mille
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def basis_point(self) -> 'FieldQnty':
        """Convert to basis point units, returning new variable."""
        unit_const: Final = field_units.PercentUnits.basis_point
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def bp(self) -> 'FieldQnty':
        """Convert to bp units (alias for basis_point), returning new variable."""
        return self.basis_point

    @property
    def bps(self) -> 'FieldQnty':
        """Convert to bps units (alias for basis_point), returning new variable."""
        return self.basis_point


class AsUnitPermeabilityConverter(UnitConverter):
    """Permeability-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def darcy(self) -> 'FieldQnty':
        """Convert to darcy units, returning new variable."""
        unit_const: Final = field_units.PermeabilityUnits.darcy
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def square_feet(self) -> 'FieldQnty':
        """Convert to square feet units, returning new variable."""
        unit_const: Final = field_units.PermeabilityUnits.square_feet
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_or_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_or_sq_ft units (alias for square_feet), returning new variable."""
        return self.square_feet

    @property
    def ft_2(self) -> 'FieldQnty':
        """Convert to ft_2 units (alias for square_feet), returning new variable."""
        return self.square_feet

    @property
    def sq_ft(self) -> 'FieldQnty':
        """Convert to sq_ft units (alias for square_feet), returning new variable."""
        return self.square_feet

    @property
    def square_meters(self) -> 'FieldQnty':
        """Convert to square meters units, returning new variable."""
        unit_const: Final = field_units.PermeabilityUnits.square_meters
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_m_2 units (alias for square_meters), returning new variable."""
        return self.square_meters


class AsUnitPhotonEmissionRateConverter(UnitConverter):
    """PhotonEmissionRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def rayleigh(self) -> 'FieldQnty':
        """Convert to rayleigh units, returning new variable."""
        unit_const: Final = field_units.PhotonEmissionRateUnits.rayleigh
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def R(self) -> 'FieldQnty':
        """Convert to R units (alias for rayleigh), returning new variable."""
        return self.rayleigh

    @property
    def reciprocal_square_meter_second(self) -> 'FieldQnty':
        """Convert to reciprocal square meter second units, returning new variable."""
        unit_const: Final = field_units.PhotonEmissionRateUnits.reciprocal_square_meter_second
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitPowerPerUnitMassConverter(UnitConverter):
    """PowerPerUnitMass-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_hour_per_pound_mass(self) -> 'FieldQnty':
        """Convert to British thermal unit per hour per pound mass units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.british_thermal_unit_per_hour_per_pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_h_lb_or_Btu_lb_hr(self) -> 'FieldQnty':
        """Convert to Btu_h_lb_or_Btu_lb_hr units (alias for british_thermal_unit_per_hour_per_pound_mass), returning new variable."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def Btu_h_lb(self) -> 'FieldQnty':
        """Convert to Btu_h_lb units (alias for british_thermal_unit_per_hour_per_pound_mass), returning new variable."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def Btu_lb_hr(self) -> 'FieldQnty':
        """Convert to Btu_lb_hr units (alias for british_thermal_unit_per_hour_per_pound_mass), returning new variable."""
        return self.british_thermal_unit_per_hour_per_pound_mass

    @property
    def calorie_per_second_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per second per gram units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.calorie_per_second_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_s_g_or_cal_g_sec(self) -> 'FieldQnty':
        """Convert to cal_s_g_or_cal_g_sec units (alias for calorie_per_second_per_gram), returning new variable."""
        return self.calorie_per_second_per_gram

    @property
    def cal_s_g(self) -> 'FieldQnty':
        """Convert to cal_s_g units (alias for calorie_per_second_per_gram), returning new variable."""
        return self.calorie_per_second_per_gram

    @property
    def cal_g_sec(self) -> 'FieldQnty':
        """Convert to cal_g_sec units (alias for calorie_per_second_per_gram), returning new variable."""
        return self.calorie_per_second_per_gram

    @property
    def kilocalorie_per_hour_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per kilogram units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.kilocalorie_per_hour_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kcal_h_kg_or_kcal_kg_hr(self) -> 'FieldQnty':
        """Convert to kcal_h_kg_or_kcal_kg_hr units (alias for kilocalorie_per_hour_per_kilogram), returning new variable."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def kcal_h_kg(self) -> 'FieldQnty':
        """Convert to kcal_h_kg units (alias for kilocalorie_per_hour_per_kilogram), returning new variable."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def kcal_kg_hr(self) -> 'FieldQnty':
        """Convert to kcal_kg_hr units (alias for kilocalorie_per_hour_per_kilogram), returning new variable."""
        return self.kilocalorie_per_hour_per_kilogram

    @property
    def watt_per_kilogram(self) -> 'FieldQnty':
        """Convert to watt per kilogram units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitMassUnits.watt_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def W_kg(self) -> 'FieldQnty':
        """Convert to W_kg units (alias for watt_per_kilogram), returning new variable."""
        return self.watt_per_kilogram


class AsUnitPowerPerUnitVolumeConverter(UnitConverter):
    """PowerPerUnitVolume-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per hour per cubic foot units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.british_thermal_unit_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_mathrm_h_mathrm_ft_3_or_mathrm_Btu_mathrm_hr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_h_mathrm_ft_3_or_mathrm_Btu_mathrm_hr_cft units (alias for british_thermal_unit_per_hour_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def Btu_h_ft_3(self) -> 'FieldQnty':
        """Convert to Btu_h_ft_3 units (alias for british_thermal_unit_per_hour_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def Btu_hr_cft(self) -> 'FieldQnty':
        """Convert to Btu_hr_cft units (alias for british_thermal_unit_per_hour_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_hour_per_cubic_foot

    @property
    def calorie_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to calorie per second per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.calorie_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_s_mathrm_cm_3_or_mathrm_cal_mathrm_s_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_s_mathrm_cm_3_or_mathrm_cal_mathrm_s_mathrm_cc units (alias for calorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def cal_s_cm_3(self) -> 'FieldQnty':
        """Convert to cal_s_cm_3 units (alias for calorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def cal_s_cc(self) -> 'FieldQnty':
        """Convert to cal_s_cc units (alias for calorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_second_per_cubic_centimeter

    @property
    def chu_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to Chu per hour per cubic foot units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.chu_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_h_ft3_or_Chu_hr_cft(self) -> 'FieldQnty':
        """Convert to Chu_h_ft3_or_Chu_hr_cft units (alias for chu_per_hour_per_cubic_foot), returning new variable."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def Chu_h_ft3(self) -> 'FieldQnty':
        """Convert to Chu_h_ft3 units (alias for chu_per_hour_per_cubic_foot), returning new variable."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def Chu_hr_cft(self) -> 'FieldQnty':
        """Convert to Chu_hr_cft units (alias for chu_per_hour_per_cubic_foot), returning new variable."""
        return self.chu_per_hour_per_cubic_foot

    @property
    def kilocalorie_per_hour_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_hour_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_mathrm_h_mathrm_cm_3_or_mathrm_kcal_hr_cc(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_h_mathrm_cm_3_or_mathrm_kcal_hr_cc units (alias for kilocalorie_per_hour_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kcal_h_cm_3(self) -> 'FieldQnty':
        """Convert to kcal_h_cm_3 units (alias for kilocalorie_per_hour_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kcal_hr_cc(self) -> 'FieldQnty':
        """Convert to kcal_hr_cc units (alias for kilocalorie_per_hour_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_centimeter

    @property
    def kilocalorie_per_hour_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to kilocalorie per hour per cubic foot units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_hour_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_mathrm_h_mathrm_ft_3_or_mathrm_kcal_mathrm_hr_cft(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_h_mathrm_ft_3_or_mathrm_kcal_mathrm_hr_cft units (alias for kilocalorie_per_hour_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kcal_h_ft_3(self) -> 'FieldQnty':
        """Convert to kcal_h_ft_3 units (alias for kilocalorie_per_hour_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kcal_hr_cft(self) -> 'FieldQnty':
        """Convert to kcal_hr_cft units (alias for kilocalorie_per_hour_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_hour_per_cubic_foot

    @property
    def kilocalorie_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to kilocalorie per second per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.kilocalorie_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kcal_s_cm_3_or_kcal_s_cc(self) -> 'FieldQnty':
        """Convert to kcal_s_cm_3_or_kcal_s_cc units (alias for kilocalorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def kcal_s_cm_3(self) -> 'FieldQnty':
        """Convert to kcal_s_cm_3 units (alias for kilocalorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def kcal_s_cc(self) -> 'FieldQnty':
        """Convert to kcal_s_cc units (alias for kilocalorie_per_second_per_cubic_centimeter), returning new variable."""
        return self.kilocalorie_per_second_per_cubic_centimeter

    @property
    def watt_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to watt per cubic meter units, returning new variable."""
        unit_const: Final = field_units.PowerPerUnitVolumeUnits.watt_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_W_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_W_mathrm_m_3 units (alias for watt_per_cubic_meter), returning new variable."""
        return self.watt_per_cubic_meter


class AsUnitPowerThermalDutyConverter(UnitConverter):
    """PowerThermalDuty-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def abwatt_emu_of_power(self) -> 'FieldQnty':
        """Convert to abwatt (emu of power) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.abwatt_emu_of_power
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def emu(self) -> 'FieldQnty':
        """Convert to emu units (alias for abwatt_emu_of_power), returning new variable."""
        return self.abwatt_emu_of_power

    @property
    def boiler_horsepower(self) -> 'FieldQnty':
        """Convert to boiler horsepower units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.boiler_horsepower
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP_boiler(self) -> 'FieldQnty':
        """Convert to HP_boiler units (alias for boiler_horsepower), returning new variable."""
        return self.boiler_horsepower

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_mean_hr_or_Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_mean_hr_or_Btu_hr units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def Btu_mean_hr(self) -> 'FieldQnty':
        """Convert to Btu_mean_hr units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_hr units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_thermochemical(self) -> 'FieldQnty':
        """Convert to British thermal unit (thermochemical) per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.british_thermal_unit_thermochemical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_therm_hr_or_Btu_hr(self) -> 'FieldQnty':
        """Convert to Btu_therm_hr_or_Btu_hr units (alias for british_thermal_unit_thermochemical), returning new variable."""
        return self.british_thermal_unit_thermochemical

    @property
    def Btu_therm_hr(self) -> 'FieldQnty':
        """Convert to Btu_therm_hr units (alias for british_thermal_unit_thermochemical), returning new variable."""
        return self.british_thermal_unit_thermochemical

    @property
    def calorie_mean(self) -> 'FieldQnty':
        """Convert to calorie (mean) per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.calorie_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_mean_hr(self) -> 'FieldQnty':
        """Convert to cal_mean_hr units (alias for calorie_mean), returning new variable."""
        return self.calorie_mean

    @property
    def calorie_thermochemical(self) -> 'FieldQnty':
        """Convert to calorie (thermochemical) per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.calorie_thermochemical
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_therm_hr(self) -> 'FieldQnty':
        """Convert to cal_therm_hr units (alias for calorie_thermochemical), returning new variable."""
        return self.calorie_thermochemical

    @property
    def donkey(self) -> 'FieldQnty':
        """Convert to donkey units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.donkey
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def erg_per_second(self) -> 'FieldQnty':
        """Convert to erg per second units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.erg_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def erg_s(self) -> 'FieldQnty':
        """Convert to erg_s units (alias for erg_per_second), returning new variable."""
        return self.erg_per_second

    @property
    def foot_pondal_per_second(self) -> 'FieldQnty':
        """Convert to foot pondal per second units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pondal_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_pdl_s(self) -> 'FieldQnty':
        """Convert to ft_pdl_s units (alias for foot_pondal_per_second), returning new variable."""
        return self.foot_pondal_per_second

    @property
    def foot_pound_force_per_hour(self) -> 'FieldQnty':
        """Convert to foot pound force per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_hr units (alias for foot_pound_force_per_hour), returning new variable."""
        return self.foot_pound_force_per_hour

    @property
    def foot_pound_force_per_minute(self) -> 'FieldQnty':
        """Convert to foot pound force per minute units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_min units (alias for foot_pound_force_per_minute), returning new variable."""
        return self.foot_pound_force_per_minute

    @property
    def foot_pound_force_per_second(self) -> 'FieldQnty':
        """Convert to foot pound force per second units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.foot_pound_force_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f_mathrm_s units (alias for foot_pound_force_per_second), returning new variable."""
        return self.foot_pound_force_per_second

    @property
    def horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms(self) -> 'FieldQnty':
        """Convert to horsepower ( $550 \\mathrm{ft} \\mathrm{lb}_{\\mathrm{f}} / \\mathrm{s}$ ) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP(self) -> 'FieldQnty':
        """Convert to HP units (alias for horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms), returning new variable."""
        return self.horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms

    @property
    def horsepower_electric(self) -> 'FieldQnty':
        """Convert to horsepower (electric) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_electric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP_elect(self) -> 'FieldQnty':
        """Convert to HP_elect units (alias for horsepower_electric), returning new variable."""
        return self.horsepower_electric

    @property
    def horsepower_uk(self) -> 'FieldQnty':
        """Convert to horsepower (UK) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.horsepower_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP_UK(self) -> 'FieldQnty':
        """Convert to HP_UK units (alias for horsepower_uk), returning new variable."""
        return self.horsepower_uk

    @property
    def kcal_per_hour(self) -> 'FieldQnty':
        """Convert to kcal per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kcal_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kcal_hr(self) -> 'FieldQnty':
        """Convert to kcal_hr units (alias for kcal_per_hour), returning new variable."""
        return self.kcal_per_hour

    @property
    def kilogram_force_meter_per_second(self) -> 'FieldQnty':
        """Convert to kilogram force meter per second units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kilogram_force_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_mathrm_s units (alias for kilogram_force_meter_per_second), returning new variable."""
        return self.kilogram_force_meter_per_second

    @property
    def kilowatt(self) -> 'FieldQnty':
        """Convert to kilowatt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.kilowatt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kW(self) -> 'FieldQnty':
        """Convert to kW units (alias for kilowatt), returning new variable."""
        return self.kilowatt

    @property
    def megawatt(self) -> 'FieldQnty':
        """Convert to megawatt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.megawatt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MW(self) -> 'FieldQnty':
        """Convert to MW units (alias for megawatt), returning new variable."""
        return self.megawatt

    @property
    def metric_horsepower(self) -> 'FieldQnty':
        """Convert to metric horsepower units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.metric_horsepower
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP_metric(self) -> 'FieldQnty':
        """Convert to HP_metric units (alias for metric_horsepower), returning new variable."""
        return self.metric_horsepower

    @property
    def million_british_thermal_units_per_hour_petroleum(self) -> 'FieldQnty':
        """Convert to million British thermal units per hour (petroleum) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.million_british_thermal_units_per_hour_petroleum
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MMBtu_hr(self) -> 'FieldQnty':
        """Convert to MMBtu_hr units (alias for million_british_thermal_units_per_hour_petroleum), returning new variable."""
        return self.million_british_thermal_units_per_hour_petroleum

    @property
    def million_kilocalorie_per_hour(self) -> 'FieldQnty':
        """Convert to million kilocalorie per hour units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.million_kilocalorie_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MM_kcal_hr(self) -> 'FieldQnty':
        """Convert to MM_kcal_hr units (alias for million_kilocalorie_per_hour), returning new variable."""
        return self.million_kilocalorie_per_hour

    @property
    def prony(self) -> 'FieldQnty':
        """Convert to prony units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.prony
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ton_of_refrigeration_us(self) -> 'FieldQnty':
        """Convert to ton of refrigeration (US) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.ton_of_refrigeration_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def CTR_US(self) -> 'FieldQnty':
        """Convert to CTR_US units (alias for ton_of_refrigeration_us), returning new variable."""
        return self.ton_of_refrigeration_us

    @property
    def ton_or_refrigeration_uk(self) -> 'FieldQnty':
        """Convert to ton or refrigeration (UK) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.ton_or_refrigeration_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def CTR_UK(self) -> 'FieldQnty':
        """Convert to CTR_UK units (alias for ton_or_refrigeration_uk), returning new variable."""
        return self.ton_or_refrigeration_uk

    @property
    def volt_ampere(self) -> 'FieldQnty':
        """Convert to volt-ampere units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.volt_ampere
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def VA(self) -> 'FieldQnty':
        """Convert to VA units (alias for volt_ampere), returning new variable."""
        return self.volt_ampere

    @property
    def water_horsepower(self) -> 'FieldQnty':
        """Convert to water horsepower units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.water_horsepower
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def HP_water(self) -> 'FieldQnty':
        """Convert to HP_water units (alias for water_horsepower), returning new variable."""
        return self.water_horsepower

    @property
    def watt(self) -> 'FieldQnty':
        """Convert to watt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def W(self) -> 'FieldQnty':
        """Convert to W units (alias for watt), returning new variable."""
        return self.watt

    @property
    def watt_international_mean(self) -> 'FieldQnty':
        """Convert to watt (international, mean) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt_international_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def W_int_mean(self) -> 'FieldQnty':
        """Convert to W_int_mean units (alias for watt_international_mean), returning new variable."""
        return self.watt_international_mean

    @property
    def watt_international_us(self) -> 'FieldQnty':
        """Convert to watt (international, US) units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.watt_international_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def watt_int_US(self) -> 'FieldQnty':
        """Convert to watt_int_US units (alias for watt_international_us), returning new variable."""
        return self.watt_international_us

    @property
    def gigawatt(self) -> 'FieldQnty':
        """Convert to gigawatt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.gigawatt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def GW(self) -> 'FieldQnty':
        """Convert to GW units (alias for gigawatt), returning new variable."""
        return self.gigawatt

    @property
    def milliwatt(self) -> 'FieldQnty':
        """Convert to milliwatt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.milliwatt
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mW(self) -> 'FieldQnty':
        """Convert to mW units (alias for milliwatt), returning new variable."""
        return self.milliwatt

    @property
    def microwatt(self) -> 'FieldQnty':
        """Convert to microwatt units, returning new variable."""
        unit_const: Final = field_units.PowerThermalDutyUnits.microwatt
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitPressureConverter(UnitConverter):
    """Pressure-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def atmosphere_standard(self) -> 'FieldQnty':
        """Convert to atmosphere, standard units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.atmosphere_standard
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def atm(self) -> 'FieldQnty':
        """Convert to atm units (alias for atmosphere_standard), returning new variable."""
        return self.atmosphere_standard

    @property
    def bar(self) -> 'FieldQnty':
        """Convert to bar units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.bar
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def barye(self) -> 'FieldQnty':
        """Convert to barye units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.barye
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter), returning new variable."""
        return self.dyne_per_square_centimeter

    @property
    def foot_of_mercury_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to foot of mercury ( $60{ }^{\\circ} \\mathrm{F}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.foot_of_mercury_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_Hg_60_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to ft_Hg_60_circ_mathrm_F units (alias for foot_of_mercury_60_circ_mathrmf), returning new variable."""
        return self.foot_of_mercury_60_circ_mathrmf

    @property
    def foot_of_water_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to foot of water ( $60{ }^{\\circ} \\mathrm{F}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.foot_of_water_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to ft_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right units (alias for foot_of_water_60_circ_mathrmf), returning new variable."""
        return self.foot_of_water_60_circ_mathrmf

    @property
    def gigapascal(self) -> 'FieldQnty':
        """Convert to gigapascal units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.gigapascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def GPa(self) -> 'FieldQnty':
        """Convert to GPa units (alias for gigapascal), returning new variable."""
        return self.gigapascal

    @property
    def hectopascal(self) -> 'FieldQnty':
        """Convert to hectopascal units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.hectopascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def hPa(self) -> 'FieldQnty':
        """Convert to hPa units (alias for hectopascal), returning new variable."""
        return self.hectopascal

    @property
    def inch_of_mercury_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to inch of mercury ( $60{ }^{\\circ} \\mathrm{F}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.inch_of_mercury_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_mathrm_Hg_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to in_mathrm_Hg_left_60_circ_mathrm_F_right units (alias for inch_of_mercury_60_circ_mathrmf), returning new variable."""
        return self.inch_of_mercury_60_circ_mathrmf

    @property
    def inch_of_water_60_circ_mathrmf(self) -> 'FieldQnty':
        """Convert to inch of water ( $60{ }^{\\circ} \\mathrm{F}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.inch_of_water_60_circ_mathrmf
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to in_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right units (alias for inch_of_water_60_circ_mathrmf), returning new variable."""
        return self.inch_of_water_60_circ_mathrmf

    @property
    def kilogram_force_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per square centimeter units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.kilogram_force_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to at_or_mathrm_kg_mathrm_f_mathrm_cm_2 units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def at(self) -> 'FieldQnty':
        """Convert to at units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kg_f_cm_2(self) -> 'FieldQnty':
        """Convert to kg_f_cm_2 units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kilogram_force_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per square meter units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.kilogram_force_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_2 units (alias for kilogram_force_per_square_meter), returning new variable."""
        return self.kilogram_force_per_square_meter

    @property
    def kip_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to kip force per square inch units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.kip_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to KSI_or_ksi_or_kip_f_mathrm_in_2 units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def KSI(self) -> 'FieldQnty':
        """Convert to KSI units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def ksi(self) -> 'FieldQnty':
        """Convert to ksi units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def kip_f_in_2(self) -> 'FieldQnty':
        """Convert to kip_f_in_2 units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def megapascal(self) -> 'FieldQnty':
        """Convert to megapascal units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.megapascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MPa(self) -> 'FieldQnty':
        """Convert to MPa units (alias for megapascal), returning new variable."""
        return self.megapascal

    @property
    def meter_of_water_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to meter of water ( $4^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.meter_of_water_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right units (alias for meter_of_water_4circ_mathrmc), returning new variable."""
        return self.meter_of_water_4circ_mathrmc

    @property
    def microbar(self) -> 'FieldQnty':
        """Convert to microbar units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.microbar
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_bar(self) -> 'FieldQnty':
        """Convert to mu_mathrm_bar units (alias for microbar), returning new variable."""
        return self.microbar

    @property
    def millibar(self) -> 'FieldQnty':
        """Convert to millibar units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.millibar
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mbar(self) -> 'FieldQnty':
        """Convert to mbar units (alias for millibar), returning new variable."""
        return self.millibar

    @property
    def millimeter_of_mercury_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to millimeter of mercury ( $4^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.millimeter_of_mercury_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mm_mathrm_Hg_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_mm_mathrm_Hg_left_4_circ_mathrm_C_right units (alias for millimeter_of_mercury_4circ_mathrmc), returning new variable."""
        return self.millimeter_of_mercury_4circ_mathrmc

    @property
    def millimeter_of_water_4circ_mathrmc(self) -> 'FieldQnty':
        """Convert to millimeter of water ( $4^{\\circ} \\mathrm{C}$ ) units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.millimeter_of_water_4circ_mathrmc
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mm_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to mathrm_mm_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right units (alias for millimeter_of_water_4circ_mathrmc), returning new variable."""
        return self.millimeter_of_water_4circ_mathrmc

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter), returning new variable."""
        return self.newton_per_square_meter

    @property
    def ounce_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to ounce force per square inch units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.ounce_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2 units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def OSI(self) -> 'FieldQnty':
        """Convert to OSI units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def osi(self) -> 'FieldQnty':
        """Convert to osi units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def pascal(self) -> 'FieldQnty':
        """Convert to pascal units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.pascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Pa(self) -> 'FieldQnty':
        """Convert to Pa units (alias for pascal), returning new variable."""
        return self.pascal

    @property
    def pi_ze(self) -> 'FieldQnty':
        """Convert to pièze units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.pi_ze
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pz(self) -> 'FieldQnty':
        """Convert to pz units (alias for pi_ze), returning new variable."""
        return self.pi_ze

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2 units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def psf(self) -> 'FieldQnty':
        """Convert to psf units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def pound_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to pound force per square inch units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.pound_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def psi(self) -> 'FieldQnty':
        """Convert to psi units (alias for pound_force_per_square_inch), returning new variable."""
        return self.pound_force_per_square_inch

    @property
    def torr(self) -> 'FieldQnty':
        """Convert to torr units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.torr
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def torr_or_mm_Hg_0_circ_C(self) -> 'FieldQnty':
        """Convert to torr_or_mm_Hg_0_circ_C units (alias for torr), returning new variable."""
        return self.torr

    @property
    def mm_Hg_0_circ_C(self) -> 'FieldQnty':
        """Convert to mm_Hg_0_circ_C units (alias for torr), returning new variable."""
        return self.torr

    @property
    def kilopascal(self) -> 'FieldQnty':
        """Convert to kilopascal units, returning new variable."""
        unit_const: Final = field_units.PressureUnits.kilopascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kPa(self) -> 'FieldQnty':
        """Convert to kPa units (alias for kilopascal), returning new variable."""
        return self.kilopascal


class AsUnitRadiationDoseEquivalentConverter(UnitConverter):
    """RadiationDoseEquivalent-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def rem(self) -> 'FieldQnty':
        """Convert to rem units, returning new variable."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.rem
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sievert(self) -> 'FieldQnty':
        """Convert to sievert units, returning new variable."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.sievert
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Sv(self) -> 'FieldQnty':
        """Convert to Sv units (alias for sievert), returning new variable."""
        return self.sievert

    @property
    def millisievert(self) -> 'FieldQnty':
        """Convert to millisievert units, returning new variable."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.millisievert
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mSv(self) -> 'FieldQnty':
        """Convert to mSv units (alias for millisievert), returning new variable."""
        return self.millisievert

    @property
    def microsievert(self) -> 'FieldQnty':
        """Convert to microsievert units, returning new variable."""
        unit_const: Final = field_units.RadiationDoseEquivalentUnits.microsievert
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitRadiationExposureConverter(UnitConverter):
    """RadiationExposure-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def coulomb_per_kilogram(self) -> 'FieldQnty':
        """Convert to coulomb per kilogram units, returning new variable."""
        unit_const: Final = field_units.RadiationExposureUnits.coulomb_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def C_kg(self) -> 'FieldQnty':
        """Convert to C_kg units (alias for coulomb_per_kilogram), returning new variable."""
        return self.coulomb_per_kilogram

    @property
    def d_unit(self) -> 'FieldQnty':
        """Convert to D unit units, returning new variable."""
        unit_const: Final = field_units.RadiationExposureUnits.d_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def D_unit(self) -> 'FieldQnty':
        """Convert to D_unit units (alias for d_unit), returning new variable."""
        return self.d_unit

    @property
    def pastille_dose_b_unit(self) -> 'FieldQnty':
        """Convert to pastille dose (B unit) units, returning new variable."""
        unit_const: Final = field_units.RadiationExposureUnits.pastille_dose_b_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def B_unit(self) -> 'FieldQnty':
        """Convert to B_unit units (alias for pastille_dose_b_unit), returning new variable."""
        return self.pastille_dose_b_unit

    @property
    def r_entgen(self) -> 'FieldQnty':
        """Convert to röentgen units, returning new variable."""
        unit_const: Final = field_units.RadiationExposureUnits.r_entgen
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def R(self) -> 'FieldQnty':
        """Convert to R units (alias for r_entgen), returning new variable."""
        return self.r_entgen


class AsUnitRadioactivityConverter(UnitConverter):
    """Radioactivity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def becquerel(self) -> 'FieldQnty':
        """Convert to becquerel units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.becquerel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Bq(self) -> 'FieldQnty':
        """Convert to Bq units (alias for becquerel), returning new variable."""
        return self.becquerel

    @property
    def curie(self) -> 'FieldQnty':
        """Convert to curie units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.curie
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Ci(self) -> 'FieldQnty':
        """Convert to Ci units (alias for curie), returning new variable."""
        return self.curie

    @property
    def mache_unit(self) -> 'FieldQnty':
        """Convert to Mache unit units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.mache_unit
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Mache(self) -> 'FieldQnty':
        """Convert to Mache units (alias for mache_unit), returning new variable."""
        return self.mache_unit

    @property
    def rutherford(self) -> 'FieldQnty':
        """Convert to rutherford units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.rutherford
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Rd(self) -> 'FieldQnty':
        """Convert to Rd units (alias for rutherford), returning new variable."""
        return self.rutherford

    @property
    def stat(self) -> 'FieldQnty':
        """Convert to stat units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.stat
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kilobecquerel(self) -> 'FieldQnty':
        """Convert to kilobecquerel units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.kilobecquerel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kBq(self) -> 'FieldQnty':
        """Convert to kBq units (alias for kilobecquerel), returning new variable."""
        return self.kilobecquerel

    @property
    def megabecquerel(self) -> 'FieldQnty':
        """Convert to megabecquerel units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.megabecquerel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MBq(self) -> 'FieldQnty':
        """Convert to MBq units (alias for megabecquerel), returning new variable."""
        return self.megabecquerel

    @property
    def gigabecquerel(self) -> 'FieldQnty':
        """Convert to gigabecquerel units, returning new variable."""
        unit_const: Final = field_units.RadioactivityUnits.gigabecquerel
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def GBq(self) -> 'FieldQnty':
        """Convert to GBq units (alias for gigabecquerel), returning new variable."""
        return self.gigabecquerel


class AsUnitSecondMomentOfAreaConverter(UnitConverter):
    """SecondMomentOfArea-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def inch_quadrupled(self) -> 'FieldQnty':
        """Convert to inch quadrupled units, returning new variable."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.inch_quadrupled
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_4(self) -> 'FieldQnty':
        """Convert to in_4 units (alias for inch_quadrupled), returning new variable."""
        return self.inch_quadrupled

    @property
    def centimeter_quadrupled(self) -> 'FieldQnty':
        """Convert to centimeter quadrupled units, returning new variable."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.centimeter_quadrupled
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_4(self) -> 'FieldQnty':
        """Convert to mathrm_cm_4 units (alias for centimeter_quadrupled), returning new variable."""
        return self.centimeter_quadrupled

    @property
    def foot_quadrupled(self) -> 'FieldQnty':
        """Convert to foot quadrupled units, returning new variable."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.foot_quadrupled
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_4(self) -> 'FieldQnty':
        """Convert to mathrm_ft_4 units (alias for foot_quadrupled), returning new variable."""
        return self.foot_quadrupled

    @property
    def meter_quadrupled(self) -> 'FieldQnty':
        """Convert to meter quadrupled units, returning new variable."""
        unit_const: Final = field_units.SecondMomentOfAreaUnits.meter_quadrupled
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_4(self) -> 'FieldQnty':
        """Convert to mathrm_m_4 units (alias for meter_quadrupled), returning new variable."""
        return self.meter_quadrupled


class AsUnitSecondRadiationConstantPlanckConverter(UnitConverter):
    """SecondRadiationConstantPlanck-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def meter_kelvin(self) -> 'FieldQnty':
        """Convert to meter kelvin units, returning new variable."""
        unit_const: Final = field_units.SecondRadiationConstantPlanckUnits.meter_kelvin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m_K(self) -> 'FieldQnty':
        """Convert to m_K units (alias for meter_kelvin), returning new variable."""
        return self.meter_kelvin


class AsUnitSpecificEnthalpyConverter(UnitConverter):
    """SpecificEnthalpy-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_mean(self) -> 'FieldQnty':
        """Convert to British thermal unit (mean) per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.british_thermal_unit_mean
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_mean_lb(self) -> 'FieldQnty':
        """Convert to Btu_mean_lb units (alias for british_thermal_unit_mean), returning new variable."""
        return self.british_thermal_unit_mean

    @property
    def british_thermal_unit_per_pound(self) -> 'FieldQnty':
        """Convert to British thermal unit per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.british_thermal_unit_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb(self) -> 'FieldQnty':
        """Convert to Btu_lb units (alias for british_thermal_unit_per_pound), returning new variable."""
        return self.british_thermal_unit_per_pound

    @property
    def calorie_per_gram(self) -> 'FieldQnty':
        """Convert to calorie per gram units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.calorie_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_g units (alias for calorie_per_gram), returning new variable."""
        return self.calorie_per_gram

    @property
    def chu_per_pound(self) -> 'FieldQnty':
        """Convert to Chu per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.chu_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Chu_lb(self) -> 'FieldQnty':
        """Convert to Chu_lb units (alias for chu_per_pound), returning new variable."""
        return self.chu_per_pound

    @property
    def joule_per_kilogram(self) -> 'FieldQnty':
        """Convert to joule per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.joule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kg(self) -> 'FieldQnty':
        """Convert to J_kg units (alias for joule_per_kilogram), returning new variable."""
        return self.joule_per_kilogram

    @property
    def kilojoule_per_kilogram(self) -> 'FieldQnty':
        """Convert to kilojoule per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificEnthalpyUnits.kilojoule_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kJ_kg(self) -> 'FieldQnty':
        """Convert to kJ_kg units (alias for kilojoule_per_kilogram), returning new variable."""
        return self.kilojoule_per_kilogram


class AsUnitSpecificGravityConverter(UnitConverter):
    """SpecificGravity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dimensionless(self) -> 'FieldQnty':
        """Convert to Dimensionless units, returning new variable."""
        unit_const: Final = field_units.SpecificGravityUnits.dimensionless
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Dmls(self) -> 'FieldQnty':
        """Convert to Dmls units (alias for dimensionless), returning new variable."""
        return self.dimensionless


class AsUnitSpecificHeatCapacityConstantPressureConverter(UnitConverter):
    """SpecificHeatCapacityConstantPressure-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_per_pound_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to Btu per pound per degree Fahrenheit (or degree Rankine) units, returning new variable."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.btu_per_pound_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_lb_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_lb_circ_mathrm_F units (alias for btu_per_pound_per_degree_fahrenheit_or_degree_rankine), returning new variable."""
        return self.btu_per_pound_per_degree_fahrenheit_or_degree_rankine

    @property
    def calories_per_gram_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to calories per gram per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.calories_per_gram_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cal_g_K(self) -> 'FieldQnty':
        """Convert to cal_g_K units (alias for calories_per_gram_per_kelvin_or_degree_celsius), returning new variable."""
        return self.calories_per_gram_per_kelvin_or_degree_celsius

    @property
    def joules_per_kilogram_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to joules per kilogram per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.SpecificHeatCapacityConstantPressureUnits.joules_per_kilogram_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_kg_K(self) -> 'FieldQnty':
        """Convert to J_kg_K units (alias for joules_per_kilogram_per_kelvin_or_degree_celsius), returning new variable."""
        return self.joules_per_kilogram_per_kelvin_or_degree_celsius


class AsUnitSpecificLengthConverter(UnitConverter):
    """SpecificLength-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to centimeter per gram units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cm_g(self) -> 'FieldQnty':
        """Convert to cm_g units (alias for centimeter_per_gram), returning new variable."""
        return self.centimeter_per_gram

    @property
    def cotton_count(self) -> 'FieldQnty':
        """Convert to cotton count units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.cotton_count
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for cotton_count), returning new variable."""
        return self.cotton_count

    @property
    def ft_per_pound(self) -> 'FieldQnty':
        """Convert to ft per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.ft_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_lb(self) -> 'FieldQnty':
        """Convert to ft_lb units (alias for ft_per_pound), returning new variable."""
        return self.ft_per_pound

    @property
    def meters_per_kilogram(self) -> 'FieldQnty':
        """Convert to meters per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.meters_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def m_kg(self) -> 'FieldQnty':
        """Convert to m_kg units (alias for meters_per_kilogram), returning new variable."""
        return self.meters_per_kilogram

    @property
    def newton_meter(self) -> 'FieldQnty':
        """Convert to newton meter units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.newton_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Nm(self) -> 'FieldQnty':
        """Convert to Nm units (alias for newton_meter), returning new variable."""
        return self.newton_meter

    @property
    def worsted(self) -> 'FieldQnty':
        """Convert to worsted units, returning new variable."""
        unit_const: Final = field_units.SpecificLengthUnits.worsted
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitSpecificSurfaceConverter(UnitConverter):
    """SpecificSurface-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def square_centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to square centimeter per gram units, returning new variable."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_2_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_g units (alias for square_centimeter_per_gram), returning new variable."""
        return self.square_centimeter_per_gram

    @property
    def square_foot_per_kilogram(self) -> 'FieldQnty':
        """Convert to square foot per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_foot_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_kg_or_sq_ft_kg(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_kg_or_sq_ft_kg units (alias for square_foot_per_kilogram), returning new variable."""
        return self.square_foot_per_kilogram

    @property
    def ft_2_kg(self) -> 'FieldQnty':
        """Convert to ft_2_kg units (alias for square_foot_per_kilogram), returning new variable."""
        return self.square_foot_per_kilogram

    @property
    def sq_ft_kg(self) -> 'FieldQnty':
        """Convert to sq_ft_kg units (alias for square_foot_per_kilogram), returning new variable."""
        return self.square_foot_per_kilogram

    @property
    def square_foot_per_pound(self) -> 'FieldQnty':
        """Convert to square foot per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_foot_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_lb_or_sq_ft_lb(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_lb_or_sq_ft_lb units (alias for square_foot_per_pound), returning new variable."""
        return self.square_foot_per_pound

    @property
    def ft_2_lb(self) -> 'FieldQnty':
        """Convert to ft_2_lb units (alias for square_foot_per_pound), returning new variable."""
        return self.square_foot_per_pound

    @property
    def sq_ft_lb(self) -> 'FieldQnty':
        """Convert to sq_ft_lb units (alias for square_foot_per_pound), returning new variable."""
        return self.square_foot_per_pound

    @property
    def square_meter_per_gram(self) -> 'FieldQnty':
        """Convert to square meter per gram units, returning new variable."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_meter_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_g units (alias for square_meter_per_gram), returning new variable."""
        return self.square_meter_per_gram

    @property
    def square_meter_per_kilogram(self) -> 'FieldQnty':
        """Convert to square meter per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificSurfaceUnits.square_meter_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_kg units (alias for square_meter_per_kilogram), returning new variable."""
        return self.square_meter_per_kilogram


class AsUnitSpecificVolumeConverter(UnitConverter):
    """SpecificVolume-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cubic_centimeter_per_gram(self) -> 'FieldQnty':
        """Convert to cubic centimeter per gram units, returning new variable."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_centimeter_per_gram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_3_mathrm_g_or_mathrm_cc_mathrm_g(self) -> 'FieldQnty':
        """Convert to mathrm_cm_3_mathrm_g_or_mathrm_cc_mathrm_g units (alias for cubic_centimeter_per_gram), returning new variable."""
        return self.cubic_centimeter_per_gram

    @property
    def cm_3_g(self) -> 'FieldQnty':
        """Convert to cm_3_g units (alias for cubic_centimeter_per_gram), returning new variable."""
        return self.cubic_centimeter_per_gram

    @property
    def cc_g(self) -> 'FieldQnty':
        """Convert to cc_g units (alias for cubic_centimeter_per_gram), returning new variable."""
        return self.cubic_centimeter_per_gram

    @property
    def cubic_foot_per_kilogram(self) -> 'FieldQnty':
        """Convert to cubic foot per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_foot_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_kg_or_mathrm_cft_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_kg_or_mathrm_cft_mathrm_kg units (alias for cubic_foot_per_kilogram), returning new variable."""
        return self.cubic_foot_per_kilogram

    @property
    def ft_3_kg(self) -> 'FieldQnty':
        """Convert to ft_3_kg units (alias for cubic_foot_per_kilogram), returning new variable."""
        return self.cubic_foot_per_kilogram

    @property
    def cft_kg(self) -> 'FieldQnty':
        """Convert to cft_kg units (alias for cubic_foot_per_kilogram), returning new variable."""
        return self.cubic_foot_per_kilogram

    @property
    def cubic_foot_per_pound(self) -> 'FieldQnty':
        """Convert to cubic foot per pound units, returning new variable."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_foot_per_pound
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_lb_or_mathrm_cft_mathrm_lb(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_lb_or_mathrm_cft_mathrm_lb units (alias for cubic_foot_per_pound), returning new variable."""
        return self.cubic_foot_per_pound

    @property
    def ft_3_lb(self) -> 'FieldQnty':
        """Convert to ft_3_lb units (alias for cubic_foot_per_pound), returning new variable."""
        return self.cubic_foot_per_pound

    @property
    def cft_lb(self) -> 'FieldQnty':
        """Convert to cft_lb units (alias for cubic_foot_per_pound), returning new variable."""
        return self.cubic_foot_per_pound

    @property
    def cubic_meter_per_kilogram(self) -> 'FieldQnty':
        """Convert to cubic meter per kilogram units, returning new variable."""
        unit_const: Final = field_units.SpecificVolumeUnits.cubic_meter_per_kilogram
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_mathrm_kg(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_kg units (alias for cubic_meter_per_kilogram), returning new variable."""
        return self.cubic_meter_per_kilogram


class AsUnitStressConverter(UnitConverter):
    """Stress-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dyne_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per square centimeter units, returning new variable."""
        unit_const: Final = field_units.StressUnits.dyne_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_mathrm_cm_2 units (alias for dyne_per_square_centimeter), returning new variable."""
        return self.dyne_per_square_centimeter

    @property
    def gigapascal(self) -> 'FieldQnty':
        """Convert to gigapascal units, returning new variable."""
        unit_const: Final = field_units.StressUnits.gigapascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def GPa(self) -> 'FieldQnty':
        """Convert to GPa units (alias for gigapascal), returning new variable."""
        return self.gigapascal

    @property
    def hectopascal(self) -> 'FieldQnty':
        """Convert to hectopascal units, returning new variable."""
        unit_const: Final = field_units.StressUnits.hectopascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def hPa(self) -> 'FieldQnty':
        """Convert to hPa units (alias for hectopascal), returning new variable."""
        return self.hectopascal

    @property
    def kilogram_force_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to kilogram force per square centimeter units, returning new variable."""
        unit_const: Final = field_units.StressUnits.kilogram_force_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to at_or_mathrm_kg_mathrm_f_mathrm_cm_2 units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def at(self) -> 'FieldQnty':
        """Convert to at units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kg_f_cm_2(self) -> 'FieldQnty':
        """Convert to kg_f_cm_2 units (alias for kilogram_force_per_square_centimeter), returning new variable."""
        return self.kilogram_force_per_square_centimeter

    @property
    def kilogram_force_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram force per square meter units, returning new variable."""
        unit_const: Final = field_units.StressUnits.kilogram_force_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_f_mathrm_m_2 units (alias for kilogram_force_per_square_meter), returning new variable."""
        return self.kilogram_force_per_square_meter

    @property
    def kip_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to kip force per square inch units, returning new variable."""
        unit_const: Final = field_units.StressUnits.kip_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to KSI_or_ksi_or_kip_f_mathrm_in_2 units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def KSI(self) -> 'FieldQnty':
        """Convert to KSI units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def ksi(self) -> 'FieldQnty':
        """Convert to ksi units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def kip_f_in_2(self) -> 'FieldQnty':
        """Convert to kip_f_in_2 units (alias for kip_force_per_square_inch), returning new variable."""
        return self.kip_force_per_square_inch

    @property
    def megapascal(self) -> 'FieldQnty':
        """Convert to megapascal units, returning new variable."""
        unit_const: Final = field_units.StressUnits.megapascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def MPa(self) -> 'FieldQnty':
        """Convert to MPa units (alias for megapascal), returning new variable."""
        return self.megapascal

    @property
    def newton_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton per square meter units, returning new variable."""
        unit_const: Final = field_units.StressUnits.newton_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_N_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_m_2 units (alias for newton_per_square_meter), returning new variable."""
        return self.newton_per_square_meter

    @property
    def ounce_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to ounce force per square inch units, returning new variable."""
        unit_const: Final = field_units.StressUnits.ounce_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> 'FieldQnty':
        """Convert to OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2 units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def OSI(self) -> 'FieldQnty':
        """Convert to OSI units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def osi(self) -> 'FieldQnty':
        """Convert to osi units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def oz_f_in_2(self) -> 'FieldQnty':
        """Convert to oz_f_in_2 units (alias for ounce_force_per_square_inch), returning new variable."""
        return self.ounce_force_per_square_inch

    @property
    def pascal(self) -> 'FieldQnty':
        """Convert to pascal units, returning new variable."""
        unit_const: Final = field_units.StressUnits.pascal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Pa(self) -> 'FieldQnty':
        """Convert to Pa units (alias for pascal), returning new variable."""
        return self.pascal

    @property
    def pound_force_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force per square foot units, returning new variable."""
        unit_const: Final = field_units.StressUnits.pound_force_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2 units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def PSF(self) -> 'FieldQnty':
        """Convert to PSF units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def psf(self) -> 'FieldQnty':
        """Convert to psf units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def lb_f_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_ft_2 units (alias for pound_force_per_square_foot), returning new variable."""
        return self.pound_force_per_square_foot

    @property
    def pound_force_per_square_inch(self) -> 'FieldQnty':
        """Convert to pound force per square inch units, returning new variable."""
        unit_const: Final = field_units.StressUnits.pound_force_per_square_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def psi(self) -> 'FieldQnty':
        """Convert to psi units (alias for pound_force_per_square_inch), returning new variable."""
        return self.pound_force_per_square_inch


class AsUnitSurfaceMassDensityConverter(UnitConverter):
    """SurfaceMassDensity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to gram per square centimeter units, returning new variable."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.gram_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_cm_2 units (alias for gram_per_square_centimeter), returning new variable."""
        return self.gram_per_square_centimeter

    @property
    def gram_per_square_meter(self) -> 'FieldQnty':
        """Convert to gram per square meter units, returning new variable."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.gram_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_m_2 units (alias for gram_per_square_meter), returning new variable."""
        return self.gram_per_square_meter

    @property
    def kilogram_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilogram per square meter units, returning new variable."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.kilogram_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_2 units (alias for kilogram_per_square_meter), returning new variable."""
        return self.kilogram_per_square_meter

    @property
    def pound_mass(self) -> 'FieldQnty':
        """Convert to pound (mass) per square foot units, returning new variable."""
        unit_const: Final = field_units.SurfaceMassDensityUnits.pound_mass
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_ft_2(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_2 units (alias for pound_mass), returning new variable."""
        return self.pound_mass


class AsUnitSurfaceTensionConverter(UnitConverter):
    """SurfaceTension-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def dyne_per_centimeter(self) -> 'FieldQnty':
        """Convert to dyne per centimeter units, returning new variable."""
        unit_const: Final = field_units.SurfaceTensionUnits.dyne_per_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_cm(self) -> 'FieldQnty':
        """Convert to dyn_cm units (alias for dyne_per_centimeter), returning new variable."""
        return self.dyne_per_centimeter

    @property
    def gram_force_per_centimeter(self) -> 'FieldQnty':
        """Convert to gram force per centimeter units, returning new variable."""
        unit_const: Final = field_units.SurfaceTensionUnits.gram_force_per_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_f_mathrm_cm(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_f_mathrm_cm units (alias for gram_force_per_centimeter), returning new variable."""
        return self.gram_force_per_centimeter

    @property
    def newton_per_meter(self) -> 'FieldQnty':
        """Convert to newton per meter units, returning new variable."""
        unit_const: Final = field_units.SurfaceTensionUnits.newton_per_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N_m(self) -> 'FieldQnty':
        """Convert to N_m units (alias for newton_per_meter), returning new variable."""
        return self.newton_per_meter

    @property
    def pound_force_per_foot(self) -> 'FieldQnty':
        """Convert to pound force per foot units, returning new variable."""
        unit_const: Final = field_units.SurfaceTensionUnits.pound_force_per_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_ft units (alias for pound_force_per_foot), returning new variable."""
        return self.pound_force_per_foot

    @property
    def pound_force_per_inch(self) -> 'FieldQnty':
        """Convert to pound force per inch units, returning new variable."""
        unit_const: Final = field_units.SurfaceTensionUnits.pound_force_per_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_in(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_in units (alias for pound_force_per_inch), returning new variable."""
        return self.pound_force_per_inch


class AsUnitTemperatureConverter(UnitConverter):
    """Temperature-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def degree_celsius_unit_size(self) -> 'FieldQnty':
        """Convert to degree Celsius (unit size) units, returning new variable."""
        unit_const: Final = field_units.TemperatureUnits.degree_celsius_unit_size
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_C_circ(self) -> 'FieldQnty':
        """Convert to mathrm_C_circ units (alias for degree_celsius_unit_size), returning new variable."""
        return self.degree_celsius_unit_size

    @property
    def degree_fahrenheit_unit_size(self) -> 'FieldQnty':
        """Convert to degree Fahrenheit (unit size) units, returning new variable."""
        unit_const: Final = field_units.TemperatureUnits.degree_fahrenheit_unit_size
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_F_circ(self) -> 'FieldQnty':
        """Convert to mathrm_F_circ units (alias for degree_fahrenheit_unit_size), returning new variable."""
        return self.degree_fahrenheit_unit_size

    @property
    def degree_r_aumur_unit_size(self) -> 'FieldQnty':
        """Convert to degree Réaumur (unit size) units, returning new variable."""
        unit_const: Final = field_units.TemperatureUnits.degree_r_aumur_unit_size
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def R_circ(self) -> 'FieldQnty':
        """Convert to R_circ units (alias for degree_r_aumur_unit_size), returning new variable."""
        return self.degree_r_aumur_unit_size

    @property
    def kelvin_absolute_scale(self) -> 'FieldQnty':
        """Convert to kelvin (absolute scale) units, returning new variable."""
        unit_const: Final = field_units.TemperatureUnits.kelvin_absolute_scale
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def K(self) -> 'FieldQnty':
        """Convert to K units (alias for kelvin_absolute_scale), returning new variable."""
        return self.kelvin_absolute_scale

    @property
    def rankine_absolute_scale(self) -> 'FieldQnty':
        """Convert to Rankine (absolute scale) units, returning new variable."""
        unit_const: Final = field_units.TemperatureUnits.rankine_absolute_scale
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def circ_mathrm_R(self) -> 'FieldQnty':
        """Convert to circ_mathrm_R units (alias for rankine_absolute_scale), returning new variable."""
        return self.rankine_absolute_scale


class AsUnitThermalConductivityConverter(UnitConverter):
    """ThermalConductivity-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def btu_it(self) -> 'FieldQnty':
        """Convert to Btu (IT) per inch per hour per degree Fahrenheit units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.btu_it
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_IT_in_hr_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to Btu_IT_in_hr_circ_mathrm_F units (alias for btu_it), returning new variable."""
        return self.btu_it

    @property
    def btu_therm(self) -> 'FieldQnty':
        """Convert to Btu (therm) per foot per hour per degree Fahrenheit units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.btu_therm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_left_mathrm_ft_mathrm_hr_circ_mathrm_F_right(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_left_mathrm_ft_mathrm_hr_circ_mathrm_F_right units (alias for btu_therm), returning new variable."""
        return self.btu_therm

    @property
    def calorie_therm(self) -> 'FieldQnty':
        """Convert to calorie (therm) per centimeter per second per degree Celsius units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.calorie_therm
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def operatorname_cal_mathrm_IT_left_mathrm_cm_mathrm_s_circ_mathrm_C_right(self) -> 'FieldQnty':
        """Convert to operatorname_cal_mathrm_IT_left_mathrm_cm_mathrm_s_circ_mathrm_C_right units (alias for calorie_therm), returning new variable."""
        return self.calorie_therm

    @property
    def joule_per_second_per_centimeter_per_kelvin(self) -> 'FieldQnty':
        """Convert to joule per second per centimeter per kelvin units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.joule_per_second_per_centimeter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def J_cm_s_K(self) -> 'FieldQnty':
        """Convert to J_cm_s_K units (alias for joule_per_second_per_centimeter_per_kelvin), returning new variable."""
        return self.joule_per_second_per_centimeter_per_kelvin

    @property
    def watt_per_centimeter_per_kelvin(self) -> 'FieldQnty':
        """Convert to watt per centimeter per kelvin units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.watt_per_centimeter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def W_cm_K(self) -> 'FieldQnty':
        """Convert to W_cm_K units (alias for watt_per_centimeter_per_kelvin), returning new variable."""
        return self.watt_per_centimeter_per_kelvin

    @property
    def watt_per_meter_per_kelvin(self) -> 'FieldQnty':
        """Convert to watt per meter per kelvin units, returning new variable."""
        unit_const: Final = field_units.ThermalConductivityUnits.watt_per_meter_per_kelvin
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def W_m_K(self) -> 'FieldQnty':
        """Convert to W_m_K units (alias for watt_per_meter_per_kelvin), returning new variable."""
        return self.watt_per_meter_per_kelvin


class AsUnitTimeConverter(UnitConverter):
    """Time-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def blink(self) -> 'FieldQnty':
        """Convert to blink units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.blink
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def century(self) -> 'FieldQnty':
        """Convert to century units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.century
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unnamed(self) -> 'FieldQnty':
        """Convert to unnamed units (alias for century), returning new variable."""
        return self.century

    @property
    def chronon_or_tempon(self) -> 'FieldQnty':
        """Convert to chronon or tempon units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.chronon_or_tempon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gigan_or_eon(self) -> 'FieldQnty':
        """Convert to gigan or eon units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.gigan_or_eon
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Ga_or_eon(self) -> 'FieldQnty':
        """Convert to Ga_or_eon units (alias for gigan_or_eon), returning new variable."""
        return self.gigan_or_eon

    @property
    def Ga(self) -> 'FieldQnty':
        """Convert to Ga units (alias for gigan_or_eon), returning new variable."""
        return self.gigan_or_eon

    @property
    def eon(self) -> 'FieldQnty':
        """Convert to eon units (alias for gigan_or_eon), returning new variable."""
        return self.gigan_or_eon

    @property
    def hour(self) -> 'FieldQnty':
        """Convert to hour units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def h_or_hr(self) -> 'FieldQnty':
        """Convert to h_or_hr units (alias for hour), returning new variable."""
        return self.hour

    @property
    def h(self) -> 'FieldQnty':
        """Convert to h units (alias for hour), returning new variable."""
        return self.hour

    @property
    def hr(self) -> 'FieldQnty':
        """Convert to hr units (alias for hour), returning new variable."""
        return self.hour

    @property
    def julian_year(self) -> 'FieldQnty':
        """Convert to Julian year units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.julian_year
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def a_jul_or_yr(self) -> 'FieldQnty':
        """Convert to a_jul_or_yr units (alias for julian_year), returning new variable."""
        return self.julian_year

    @property
    def a_jul(self) -> 'FieldQnty':
        """Convert to a_jul units (alias for julian_year), returning new variable."""
        return self.julian_year

    @property
    def yr(self) -> 'FieldQnty':
        """Convert to yr units (alias for julian_year), returning new variable."""
        return self.julian_year

    @property
    def mean_solar_day(self) -> 'FieldQnty':
        """Convert to mean solar day units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.mean_solar_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def da_or_d(self) -> 'FieldQnty':
        """Convert to da_or_d units (alias for mean_solar_day), returning new variable."""
        return self.mean_solar_day

    @property
    def da(self) -> 'FieldQnty':
        """Convert to da units (alias for mean_solar_day), returning new variable."""
        return self.mean_solar_day

    @property
    def d(self) -> 'FieldQnty':
        """Convert to d units (alias for mean_solar_day), returning new variable."""
        return self.mean_solar_day

    @property
    def millenium(self) -> 'FieldQnty':
        """Convert to millenium units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.millenium
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def minute(self) -> 'FieldQnty':
        """Convert to minute units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def min(self) -> 'FieldQnty':
        """Convert to min units (alias for minute), returning new variable."""
        return self.minute

    @property
    def second(self) -> 'FieldQnty':
        """Convert to second units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def s(self) -> 'FieldQnty':
        """Convert to s units (alias for second), returning new variable."""
        return self.second

    @property
    def shake(self) -> 'FieldQnty':
        """Convert to shake units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.shake
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def sidereal_year_1900_ad(self) -> 'FieldQnty':
        """Convert to sidereal year (1900 AD) units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.sidereal_year_1900_ad
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def a_sider_or_yr(self) -> 'FieldQnty':
        """Convert to a_sider_or_yr units (alias for sidereal_year_1900_ad), returning new variable."""
        return self.sidereal_year_1900_ad

    @property
    def a_sider(self) -> 'FieldQnty':
        """Convert to a_sider units (alias for sidereal_year_1900_ad), returning new variable."""
        return self.sidereal_year_1900_ad

    @property
    def tropical_year(self) -> 'FieldQnty':
        """Convert to tropical year units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.tropical_year
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def a_trop(self) -> 'FieldQnty':
        """Convert to a_trop units (alias for tropical_year), returning new variable."""
        return self.tropical_year

    @property
    def wink(self) -> 'FieldQnty':
        """Convert to wink units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.wink
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def year(self) -> 'FieldQnty':
        """Convert to year units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.year
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def a_or_y_or_yr(self) -> 'FieldQnty':
        """Convert to a_or_y_or_yr units (alias for year), returning new variable."""
        return self.year

    @property
    def a(self) -> 'FieldQnty':
        """Convert to a units (alias for year), returning new variable."""
        return self.year

    @property
    def y(self) -> 'FieldQnty':
        """Convert to y units (alias for year), returning new variable."""
        return self.year

    @property
    def millisecond(self) -> 'FieldQnty':
        """Convert to millisecond units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.millisecond
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ms(self) -> 'FieldQnty':
        """Convert to ms units (alias for millisecond), returning new variable."""
        return self.millisecond

    @property
    def microsecond(self) -> 'FieldQnty':
        """Convert to microsecond units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.microsecond
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def nanosecond(self) -> 'FieldQnty':
        """Convert to nanosecond units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.nanosecond
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ns(self) -> 'FieldQnty':
        """Convert to ns units (alias for nanosecond), returning new variable."""
        return self.nanosecond

    @property
    def picosecond(self) -> 'FieldQnty':
        """Convert to picosecond units, returning new variable."""
        unit_const: Final = field_units.TimeUnits.picosecond
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ps(self) -> 'FieldQnty':
        """Convert to ps units (alias for picosecond), returning new variable."""
        return self.picosecond


class AsUnitTorqueConverter(UnitConverter):
    """Torque-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def centimeter_kilogram_force(self) -> 'FieldQnty':
        """Convert to centimeter kilogram force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.centimeter_kilogram_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to cm_kg_mathrm_f units (alias for centimeter_kilogram_force), returning new variable."""
        return self.centimeter_kilogram_force

    @property
    def dyne_centimeter(self) -> 'FieldQnty':
        """Convert to dyne centimeter units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.dyne_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_cm(self) -> 'FieldQnty':
        """Convert to dyn_cm units (alias for dyne_centimeter), returning new variable."""
        return self.dyne_centimeter

    @property
    def foot_kilogram_force(self) -> 'FieldQnty':
        """Convert to foot kilogram force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.foot_kilogram_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_kg_mathrm_f units (alias for foot_kilogram_force), returning new variable."""
        return self.foot_kilogram_force

    @property
    def foot_pound_force(self) -> 'FieldQnty':
        """Convert to foot pound force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.foot_pound_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_lb_mathrm_f units (alias for foot_pound_force), returning new variable."""
        return self.foot_pound_force

    @property
    def foot_poundal(self) -> 'FieldQnty':
        """Convert to foot poundal units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.foot_poundal
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_pdl(self) -> 'FieldQnty':
        """Convert to ft_pdl units (alias for foot_poundal), returning new variable."""
        return self.foot_poundal

    @property
    def in_pound_force(self) -> 'FieldQnty':
        """Convert to in pound force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.in_pound_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_mathrm_lb_mathrm_f(self) -> 'FieldQnty':
        """Convert to in_mathrm_lb_mathrm_f units (alias for in_pound_force), returning new variable."""
        return self.in_pound_force

    @property
    def inch_ounce_force(self) -> 'FieldQnty':
        """Convert to inch ounce force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.inch_ounce_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_mathrm_OZ_mathrm_f(self) -> 'FieldQnty':
        """Convert to in_mathrm_OZ_mathrm_f units (alias for inch_ounce_force), returning new variable."""
        return self.inch_ounce_force

    @property
    def meter_kilogram_force(self) -> 'FieldQnty':
        """Convert to meter kilogram force units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.meter_kilogram_force
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mathrm_kg_mathrm_f(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_kg_mathrm_f units (alias for meter_kilogram_force), returning new variable."""
        return self.meter_kilogram_force

    @property
    def newton_centimeter(self) -> 'FieldQnty':
        """Convert to newton centimeter units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.newton_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N_cm(self) -> 'FieldQnty':
        """Convert to N_cm units (alias for newton_centimeter), returning new variable."""
        return self.newton_centimeter

    @property
    def newton_meter(self) -> 'FieldQnty':
        """Convert to newton meter units, returning new variable."""
        unit_const: Final = field_units.TorqueUnits.newton_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def N_m(self) -> 'FieldQnty':
        """Convert to N_m units (alias for newton_meter), returning new variable."""
        return self.newton_meter


class AsUnitTurbulenceEnergyDissipationRateConverter(UnitConverter):
    """TurbulenceEnergyDissipationRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def square_foot_per_cubic_second(self) -> 'FieldQnty':
        """Convert to square foot per cubic second units, returning new variable."""
        unit_const: Final = field_units.TurbulenceEnergyDissipationRateUnits.square_foot_per_cubic_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_s_3_or_sq_ft_sec_3(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s_3_or_sq_ft_sec_3 units (alias for square_foot_per_cubic_second), returning new variable."""
        return self.square_foot_per_cubic_second

    @property
    def ft_2_s_3(self) -> 'FieldQnty':
        """Convert to ft_2_s_3 units (alias for square_foot_per_cubic_second), returning new variable."""
        return self.square_foot_per_cubic_second

    @property
    def sq_ft_sec_3(self) -> 'FieldQnty':
        """Convert to sq_ft_sec_3 units (alias for square_foot_per_cubic_second), returning new variable."""
        return self.square_foot_per_cubic_second

    @property
    def square_meter_per_cubic_second(self) -> 'FieldQnty':
        """Convert to square meter per cubic second units, returning new variable."""
        unit_const: Final = field_units.TurbulenceEnergyDissipationRateUnits.square_meter_per_cubic_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_s_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s_3 units (alias for square_meter_per_cubic_second), returning new variable."""
        return self.square_meter_per_cubic_second


class AsUnitVelocityAngularConverter(UnitConverter):
    """VelocityAngular-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def degree_per_minute(self) -> 'FieldQnty':
        """Convert to degree per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.degree_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def deg_min_or_circ_mathrm_min(self) -> 'FieldQnty':
        """Convert to deg_min_or_circ_mathrm_min units (alias for degree_per_minute), returning new variable."""
        return self.degree_per_minute

    @property
    def deg_min(self) -> 'FieldQnty':
        """Convert to deg_min units (alias for degree_per_minute), returning new variable."""
        return self.degree_per_minute

    @property
    def circ_min(self) -> 'FieldQnty':
        """Convert to circ_min units (alias for degree_per_minute), returning new variable."""
        return self.degree_per_minute

    @property
    def degree_per_second(self) -> 'FieldQnty':
        """Convert to degree per second units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.degree_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def deg_s_or_circ_s(self) -> 'FieldQnty':
        """Convert to deg_s_or_circ_s units (alias for degree_per_second), returning new variable."""
        return self.degree_per_second

    @property
    def deg_s(self) -> 'FieldQnty':
        """Convert to deg_s units (alias for degree_per_second), returning new variable."""
        return self.degree_per_second

    @property
    def circ_s(self) -> 'FieldQnty':
        """Convert to circ_s units (alias for degree_per_second), returning new variable."""
        return self.degree_per_second

    @property
    def grade_per_minute(self) -> 'FieldQnty':
        """Convert to grade per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.grade_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gon_min_or_grad_min(self) -> 'FieldQnty':
        """Convert to gon_min_or_grad_min units (alias for grade_per_minute), returning new variable."""
        return self.grade_per_minute

    @property
    def gon_min(self) -> 'FieldQnty':
        """Convert to gon_min units (alias for grade_per_minute), returning new variable."""
        return self.grade_per_minute

    @property
    def grad_min(self) -> 'FieldQnty':
        """Convert to grad_min units (alias for grade_per_minute), returning new variable."""
        return self.grade_per_minute

    @property
    def radian_per_minute(self) -> 'FieldQnty':
        """Convert to radian per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.radian_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_rad_mathrm_min(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_min units (alias for radian_per_minute), returning new variable."""
        return self.radian_per_minute

    @property
    def radian_per_second(self) -> 'FieldQnty':
        """Convert to radian per second units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.radian_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_rad_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_rad_mathrm_s units (alias for radian_per_second), returning new variable."""
        return self.radian_per_second

    @property
    def revolution_per_minute(self) -> 'FieldQnty':
        """Convert to revolution per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.revolution_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def rev_m_or_rpm(self) -> 'FieldQnty':
        """Convert to rev_m_or_rpm units (alias for revolution_per_minute), returning new variable."""
        return self.revolution_per_minute

    @property
    def rev_m(self) -> 'FieldQnty':
        """Convert to rev_m units (alias for revolution_per_minute), returning new variable."""
        return self.revolution_per_minute

    @property
    def rpm(self) -> 'FieldQnty':
        """Convert to rpm units (alias for revolution_per_minute), returning new variable."""
        return self.revolution_per_minute

    @property
    def revolution_per_second(self) -> 'FieldQnty':
        """Convert to revolution per second units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.revolution_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def rev_s_or_rps(self) -> 'FieldQnty':
        """Convert to rev_s_or_rps units (alias for revolution_per_second), returning new variable."""
        return self.revolution_per_second

    @property
    def rev_s(self) -> 'FieldQnty':
        """Convert to rev_s units (alias for revolution_per_second), returning new variable."""
        return self.revolution_per_second

    @property
    def rps(self) -> 'FieldQnty':
        """Convert to rps units (alias for revolution_per_second), returning new variable."""
        return self.revolution_per_second

    @property
    def turn_per_minute(self) -> 'FieldQnty':
        """Convert to turn per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityAngularUnits.turn_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tr_min(self) -> 'FieldQnty':
        """Convert to tr_min units (alias for turn_per_minute), returning new variable."""
        return self.turn_per_minute


class AsUnitVelocityLinearConverter(UnitConverter):
    """VelocityLinear-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def foot_per_hour(self) -> 'FieldQnty':
        """Convert to foot per hour units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_h_or_ft_hr_or_fph(self) -> 'FieldQnty':
        """Convert to ft_h_or_ft_hr_or_fph units (alias for foot_per_hour), returning new variable."""
        return self.foot_per_hour

    @property
    def ft_h(self) -> 'FieldQnty':
        """Convert to ft_h units (alias for foot_per_hour), returning new variable."""
        return self.foot_per_hour

    @property
    def ft_hr(self) -> 'FieldQnty':
        """Convert to ft_hr units (alias for foot_per_hour), returning new variable."""
        return self.foot_per_hour

    @property
    def fph(self) -> 'FieldQnty':
        """Convert to fph units (alias for foot_per_hour), returning new variable."""
        return self.foot_per_hour

    @property
    def foot_per_minute(self) -> 'FieldQnty':
        """Convert to foot per minute units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_min_or_fpm(self) -> 'FieldQnty':
        """Convert to ft_min_or_fpm units (alias for foot_per_minute), returning new variable."""
        return self.foot_per_minute

    @property
    def ft_min(self) -> 'FieldQnty':
        """Convert to ft_min units (alias for foot_per_minute), returning new variable."""
        return self.foot_per_minute

    @property
    def fpm(self) -> 'FieldQnty':
        """Convert to fpm units (alias for foot_per_minute), returning new variable."""
        return self.foot_per_minute

    @property
    def foot_per_second(self) -> 'FieldQnty':
        """Convert to foot per second units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ft_s_or_fps(self) -> 'FieldQnty':
        """Convert to ft_s_or_fps units (alias for foot_per_second), returning new variable."""
        return self.foot_per_second

    @property
    def ft_s(self) -> 'FieldQnty':
        """Convert to ft_s units (alias for foot_per_second), returning new variable."""
        return self.foot_per_second

    @property
    def fps(self) -> 'FieldQnty':
        """Convert to fps units (alias for foot_per_second), returning new variable."""
        return self.foot_per_second

    @property
    def inch_per_second(self) -> 'FieldQnty':
        """Convert to inch per second units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.inch_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def in_s_or_ips(self) -> 'FieldQnty':
        """Convert to in_s_or_ips units (alias for inch_per_second), returning new variable."""
        return self.inch_per_second

    @property
    def in_s(self) -> 'FieldQnty':
        """Convert to in_s units (alias for inch_per_second), returning new variable."""
        return self.inch_per_second

    @property
    def ips(self) -> 'FieldQnty':
        """Convert to ips units (alias for inch_per_second), returning new variable."""
        return self.inch_per_second

    @property
    def international_knot(self) -> 'FieldQnty':
        """Convert to international knot units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.international_knot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def knot(self) -> 'FieldQnty':
        """Convert to knot units (alias for international_knot), returning new variable."""
        return self.international_knot

    @property
    def kilometer_per_hour(self) -> 'FieldQnty':
        """Convert to kilometer per hour units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.kilometer_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km_h_ot_kph(self) -> 'FieldQnty':
        """Convert to km_h_ot_kph units (alias for kilometer_per_hour), returning new variable."""
        return self.kilometer_per_hour

    @property
    def kilometer_per_second(self) -> 'FieldQnty':
        """Convert to kilometer per second units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.kilometer_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def km_s(self) -> 'FieldQnty':
        """Convert to km_s units (alias for kilometer_per_second), returning new variable."""
        return self.kilometer_per_second

    @property
    def meter_per_second(self) -> 'FieldQnty':
        """Convert to meter per second units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_s units (alias for meter_per_second), returning new variable."""
        return self.meter_per_second

    @property
    def mile_per_hour(self) -> 'FieldQnty':
        """Convert to mile per hour units, returning new variable."""
        unit_const: Final = field_units.VelocityLinearUnits.mile_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mi_mathrm_h_or_mathrm_mi_mathrm_hr_or_mph(self) -> 'FieldQnty':
        """Convert to mathrm_mi_mathrm_h_or_mathrm_mi_mathrm_hr_or_mph units (alias for mile_per_hour), returning new variable."""
        return self.mile_per_hour

    @property
    def mi_h(self) -> 'FieldQnty':
        """Convert to mi_h units (alias for mile_per_hour), returning new variable."""
        return self.mile_per_hour

    @property
    def mi_hr(self) -> 'FieldQnty':
        """Convert to mi_hr units (alias for mile_per_hour), returning new variable."""
        return self.mile_per_hour

    @property
    def mph(self) -> 'FieldQnty':
        """Convert to mph units (alias for mile_per_hour), returning new variable."""
        return self.mile_per_hour


class AsUnitViscosityDynamicConverter(UnitConverter):
    """ViscosityDynamic-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def centipoise(self) -> 'FieldQnty':
        """Convert to centipoise units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.centipoise
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cP_or_cPo(self) -> 'FieldQnty':
        """Convert to cP_or_cPo units (alias for centipoise), returning new variable."""
        return self.centipoise

    @property
    def cP(self) -> 'FieldQnty':
        """Convert to cP units (alias for centipoise), returning new variable."""
        return self.centipoise

    @property
    def cPo(self) -> 'FieldQnty':
        """Convert to cPo units (alias for centipoise), returning new variable."""
        return self.centipoise

    @property
    def dyne_second_per_square_centimeter(self) -> 'FieldQnty':
        """Convert to dyne second per square centimeter units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.dyne_second_per_square_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dyn_s_mathrm_cm_2(self) -> 'FieldQnty':
        """Convert to dyn_s_mathrm_cm_2 units (alias for dyne_second_per_square_centimeter), returning new variable."""
        return self.dyne_second_per_square_centimeter

    @property
    def kilopound_second_per_square_meter(self) -> 'FieldQnty':
        """Convert to kilopound second per square meter units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.kilopound_second_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def kip_mathrm_s_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to kip_mathrm_s_mathrm_m_2 units (alias for kilopound_second_per_square_meter), returning new variable."""
        return self.kilopound_second_per_square_meter

    @property
    def millipoise(self) -> 'FieldQnty':
        """Convert to millipoise units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.millipoise
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mP_or_mPo(self) -> 'FieldQnty':
        """Convert to mP_or_mPo units (alias for millipoise), returning new variable."""
        return self.millipoise

    @property
    def mP(self) -> 'FieldQnty':
        """Convert to mP units (alias for millipoise), returning new variable."""
        return self.millipoise

    @property
    def mPo(self) -> 'FieldQnty':
        """Convert to mPo units (alias for millipoise), returning new variable."""
        return self.millipoise

    @property
    def newton_second_per_square_meter(self) -> 'FieldQnty':
        """Convert to newton second per square meter units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.newton_second_per_square_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_N_mathrm_s_mathrm_m_2(self) -> 'FieldQnty':
        """Convert to mathrm_N_mathrm_s_mathrm_m_2 units (alias for newton_second_per_square_meter), returning new variable."""
        return self.newton_second_per_square_meter

    @property
    def pascal_second(self) -> 'FieldQnty':
        """Convert to pascal second units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pascal_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Pa_s_or_PI(self) -> 'FieldQnty':
        """Convert to Pa_s_or_PI units (alias for pascal_second), returning new variable."""
        return self.pascal_second

    @property
    def Pa_s(self) -> 'FieldQnty':
        """Convert to Pa_s units (alias for pascal_second), returning new variable."""
        return self.pascal_second

    @property
    def PI(self) -> 'FieldQnty':
        """Convert to PI units (alias for pascal_second), returning new variable."""
        return self.pascal_second

    @property
    def poise(self) -> 'FieldQnty':
        """Convert to poise units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.poise
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def P_or_Po(self) -> 'FieldQnty':
        """Convert to P_or_Po units (alias for poise), returning new variable."""
        return self.poise

    @property
    def P(self) -> 'FieldQnty':
        """Convert to P units (alias for poise), returning new variable."""
        return self.poise

    @property
    def Po(self) -> 'FieldQnty':
        """Convert to Po units (alias for poise), returning new variable."""
        return self.poise

    @property
    def pound_force_hour_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force hour per square foot units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pound_force_hour_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_h_mathrm_ft_2_or_mathrm_lb_mathrm_hr_mathrm_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_h_mathrm_ft_2_or_mathrm_lb_mathrm_hr_mathrm_sq_ft units (alias for pound_force_hour_per_square_foot), returning new variable."""
        return self.pound_force_hour_per_square_foot

    @property
    def lb_f_h_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_h_ft_2 units (alias for pound_force_hour_per_square_foot), returning new variable."""
        return self.pound_force_hour_per_square_foot

    @property
    def lb_hr_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_hr_sq_ft units (alias for pound_force_hour_per_square_foot), returning new variable."""
        return self.pound_force_hour_per_square_foot

    @property
    def pound_force_second_per_square_foot(self) -> 'FieldQnty':
        """Convert to pound force second per square foot units, returning new variable."""
        unit_const: Final = field_units.ViscosityDynamicUnits.pound_force_second_per_square_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_f_mathrm_s_mathrm_ft_2_or_mathrm_lb_mathrm_sec_mathrm_sq_ft(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_f_mathrm_s_mathrm_ft_2_or_mathrm_lb_mathrm_sec_mathrm_sq_ft units (alias for pound_force_second_per_square_foot), returning new variable."""
        return self.pound_force_second_per_square_foot

    @property
    def lb_f_s_ft_2(self) -> 'FieldQnty':
        """Convert to lb_f_s_ft_2 units (alias for pound_force_second_per_square_foot), returning new variable."""
        return self.pound_force_second_per_square_foot

    @property
    def lb_sec_sq_ft(self) -> 'FieldQnty':
        """Convert to lb_sec_sq_ft units (alias for pound_force_second_per_square_foot), returning new variable."""
        return self.pound_force_second_per_square_foot


class AsUnitViscosityKinematicConverter(UnitConverter):
    """ViscosityKinematic-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def centistokes(self) -> 'FieldQnty':
        """Convert to centistokes units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.centistokes
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cSt(self) -> 'FieldQnty':
        """Convert to cSt units (alias for centistokes), returning new variable."""
        return self.centistokes

    @property
    def millistokes(self) -> 'FieldQnty':
        """Convert to millistokes units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.millistokes
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mSt(self) -> 'FieldQnty':
        """Convert to mSt units (alias for millistokes), returning new variable."""
        return self.millistokes

    @property
    def square_centimeter_per_second(self) -> 'FieldQnty':
        """Convert to square centimeter per second units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_centimeter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_cm_2_mathrm_s units (alias for square_centimeter_per_second), returning new variable."""
        return self.square_centimeter_per_second

    @property
    def square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to square foot per hour units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_h_or_mathrm_ft_2_mathrm_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_h_or_mathrm_ft_2_mathrm_hr units (alias for square_foot_per_hour), returning new variable."""
        return self.square_foot_per_hour

    @property
    def ft_2_h(self) -> 'FieldQnty':
        """Convert to ft_2_h units (alias for square_foot_per_hour), returning new variable."""
        return self.square_foot_per_hour

    @property
    def ft_2_hr(self) -> 'FieldQnty':
        """Convert to ft_2_hr units (alias for square_foot_per_hour), returning new variable."""
        return self.square_foot_per_hour

    @property
    def square_foot_per_second(self) -> 'FieldQnty':
        """Convert to square foot per second units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_ft_2_mathrm_s units (alias for square_foot_per_second), returning new variable."""
        return self.square_foot_per_second

    @property
    def square_meters_per_second(self) -> 'FieldQnty':
        """Convert to square meters per second units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.square_meters_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_2_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_2_mathrm_s units (alias for square_meters_per_second), returning new variable."""
        return self.square_meters_per_second

    @property
    def stokes(self) -> 'FieldQnty':
        """Convert to stokes units, returning new variable."""
        unit_const: Final = field_units.ViscosityKinematicUnits.stokes
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def St(self) -> 'FieldQnty':
        """Convert to St units (alias for stokes), returning new variable."""
        return self.stokes


class AsUnitVolumeConverter(UnitConverter):
    """Volume-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def acre_foot(self) -> 'FieldQnty':
        """Convert to acre foot units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.acre_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ac_ft(self) -> 'FieldQnty':
        """Convert to ac_ft units (alias for acre_foot), returning new variable."""
        return self.acre_foot

    @property
    def acre_inch(self) -> 'FieldQnty':
        """Convert to acre inch units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.acre_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ac_in(self) -> 'FieldQnty':
        """Convert to ac_in units (alias for acre_inch), returning new variable."""
        return self.acre_inch

    @property
    def barrel_us_liquid(self) -> 'FieldQnty':
        """Convert to barrel (US Liquid) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.barrel_us_liquid
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def bbl_US_liq(self) -> 'FieldQnty':
        """Convert to bbl_US_liq units (alias for barrel_us_liquid), returning new variable."""
        return self.barrel_us_liquid

    @property
    def barrel_us_petro(self) -> 'FieldQnty':
        """Convert to barrel (US, Petro) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.barrel_us_petro
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def bbl(self) -> 'FieldQnty':
        """Convert to bbl units (alias for barrel_us_petro), returning new variable."""
        return self.barrel_us_petro

    @property
    def board_foot_measure(self) -> 'FieldQnty':
        """Convert to board foot measure units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.board_foot_measure
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def BM_or_fbm(self) -> 'FieldQnty':
        """Convert to BM_or_fbm units (alias for board_foot_measure), returning new variable."""
        return self.board_foot_measure

    @property
    def BM(self) -> 'FieldQnty':
        """Convert to BM units (alias for board_foot_measure), returning new variable."""
        return self.board_foot_measure

    @property
    def fbm(self) -> 'FieldQnty':
        """Convert to fbm units (alias for board_foot_measure), returning new variable."""
        return self.board_foot_measure

    @property
    def bushel_us_dry(self) -> 'FieldQnty':
        """Convert to bushel (US Dry) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.bushel_us_dry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def bu_US_dry(self) -> 'FieldQnty':
        """Convert to bu_US_dry units (alias for bushel_us_dry), returning new variable."""
        return self.bushel_us_dry

    @property
    def centiliter(self) -> 'FieldQnty':
        """Convert to centiliter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.centiliter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cl_or_cL(self) -> 'FieldQnty':
        """Convert to cl_or_cL units (alias for centiliter), returning new variable."""
        return self.centiliter

    @property
    def cl(self) -> 'FieldQnty':
        """Convert to cl units (alias for centiliter), returning new variable."""
        return self.centiliter

    @property
    def cL(self) -> 'FieldQnty':
        """Convert to cL units (alias for centiliter), returning new variable."""
        return self.centiliter

    @property
    def cord(self) -> 'FieldQnty':
        """Convert to cord units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cord
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cord_or_cd(self) -> 'FieldQnty':
        """Convert to cord_or_cd units (alias for cord), returning new variable."""
        return self.cord

    @property
    def cd(self) -> 'FieldQnty':
        """Convert to cd units (alias for cord), returning new variable."""
        return self.cord

    @property
    def cord_foot(self) -> 'FieldQnty':
        """Convert to cord foot units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cord_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cord_ft(self) -> 'FieldQnty':
        """Convert to cord_ft units (alias for cord_foot), returning new variable."""
        return self.cord_foot

    @property
    def cubic_centimeter(self) -> 'FieldQnty':
        """Convert to cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_3_or_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cm_3_or_cc units (alias for cubic_centimeter), returning new variable."""
        return self.cubic_centimeter

    @property
    def cm_3(self) -> 'FieldQnty':
        """Convert to cm_3 units (alias for cubic_centimeter), returning new variable."""
        return self.cubic_centimeter

    @property
    def cc(self) -> 'FieldQnty':
        """Convert to cc units (alias for cubic_centimeter), returning new variable."""
        return self.cubic_centimeter

    @property
    def cubic_decameter(self) -> 'FieldQnty':
        """Convert to cubic decameter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_decameter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dam_3(self) -> 'FieldQnty':
        """Convert to dam_3 units (alias for cubic_decameter), returning new variable."""
        return self.cubic_decameter

    @property
    def cubic_decimeter(self) -> 'FieldQnty':
        """Convert to cubic decimeter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_decimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_dm_3(self) -> 'FieldQnty':
        """Convert to mathrm_dm_3 units (alias for cubic_decimeter), returning new variable."""
        return self.cubic_decimeter

    @property
    def cubic_foot(self) -> 'FieldQnty':
        """Convert to cubic foot units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cu_ft_or_ft_3(self) -> 'FieldQnty':
        """Convert to cu_ft_or_ft_3 units (alias for cubic_foot), returning new variable."""
        return self.cubic_foot

    @property
    def cu_ft(self) -> 'FieldQnty':
        """Convert to cu_ft units (alias for cubic_foot), returning new variable."""
        return self.cubic_foot

    @property
    def ft_3(self) -> 'FieldQnty':
        """Convert to ft_3 units (alias for cubic_foot), returning new variable."""
        return self.cubic_foot

    @property
    def cubic_inch(self) -> 'FieldQnty':
        """Convert to cubic inch units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_inch
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cu_in_or_mathrm_in_3(self) -> 'FieldQnty':
        """Convert to cu_in_or_mathrm_in_3 units (alias for cubic_inch), returning new variable."""
        return self.cubic_inch

    @property
    def cu_in(self) -> 'FieldQnty':
        """Convert to cu_in units (alias for cubic_inch), returning new variable."""
        return self.cubic_inch

    @property
    def in_3(self) -> 'FieldQnty':
        """Convert to in_3 units (alias for cubic_inch), returning new variable."""
        return self.cubic_inch

    @property
    def cubic_kilometer(self) -> 'FieldQnty':
        """Convert to cubic kilometer units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_kilometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_km_3(self) -> 'FieldQnty':
        """Convert to mathrm_km_3 units (alias for cubic_kilometer), returning new variable."""
        return self.cubic_kilometer

    @property
    def cubic_meter(self) -> 'FieldQnty':
        """Convert to cubic meter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_3 units (alias for cubic_meter), returning new variable."""
        return self.cubic_meter

    @property
    def cubic_micrometer(self) -> 'FieldQnty':
        """Convert to cubic micrometer units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_micrometer
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mu_mathrm_m_3 units (alias for cubic_micrometer), returning new variable."""
        return self.cubic_micrometer

    @property
    def cubic_mile_us_intl(self) -> 'FieldQnty':
        """Convert to cubic mile (US, Intl) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_mile_us_intl
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cu_mi(self) -> 'FieldQnty':
        """Convert to cu_mi units (alias for cubic_mile_us_intl), returning new variable."""
        return self.cubic_mile_us_intl

    @property
    def cubic_millimeter(self) -> 'FieldQnty':
        """Convert to cubic millimeter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_millimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_mm_3(self) -> 'FieldQnty':
        """Convert to mathrm_mm_3 units (alias for cubic_millimeter), returning new variable."""
        return self.cubic_millimeter

    @property
    def cubic_yard(self) -> 'FieldQnty':
        """Convert to cubic yard units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.cubic_yard
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def cu_yd_or_mathrm_yd_3(self) -> 'FieldQnty':
        """Convert to cu_yd_or_mathrm_yd_3 units (alias for cubic_yard), returning new variable."""
        return self.cubic_yard

    @property
    def cu_yd(self) -> 'FieldQnty':
        """Convert to cu_yd units (alias for cubic_yard), returning new variable."""
        return self.cubic_yard

    @property
    def yd_3(self) -> 'FieldQnty':
        """Convert to yd_3 units (alias for cubic_yard), returning new variable."""
        return self.cubic_yard

    @property
    def decast_re(self) -> 'FieldQnty':
        """Convert to decastére units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.decast_re
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dast(self) -> 'FieldQnty':
        """Convert to dast units (alias for decast_re), returning new variable."""
        return self.decast_re

    @property
    def deciliter(self) -> 'FieldQnty':
        """Convert to deciliter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.deciliter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def dl_or_dL(self) -> 'FieldQnty':
        """Convert to dl_or_dL units (alias for deciliter), returning new variable."""
        return self.deciliter

    @property
    def dl(self) -> 'FieldQnty':
        """Convert to dl units (alias for deciliter), returning new variable."""
        return self.deciliter

    @property
    def dL(self) -> 'FieldQnty':
        """Convert to dL units (alias for deciliter), returning new variable."""
        return self.deciliter

    @property
    def fluid_drachm_uk(self) -> 'FieldQnty':
        """Convert to fluid drachm (UK) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.fluid_drachm_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fl_dr_UK(self) -> 'FieldQnty':
        """Convert to fl_dr_UK units (alias for fluid_drachm_uk), returning new variable."""
        return self.fluid_drachm_uk

    @property
    def fluid_dram_us(self) -> 'FieldQnty':
        """Convert to fluid dram (US) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.fluid_dram_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fl_dr_US_liq(self) -> 'FieldQnty':
        """Convert to fl_dr_US_liq units (alias for fluid_dram_us), returning new variable."""
        return self.fluid_dram_us

    @property
    def fluid_ounce_us(self) -> 'FieldQnty':
        """Convert to fluid ounce (US) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.fluid_ounce_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def fl_oz(self) -> 'FieldQnty':
        """Convert to fl_oz units (alias for fluid_ounce_us), returning new variable."""
        return self.fluid_ounce_us

    @property
    def gallon_imperial_uk(self) -> 'FieldQnty':
        """Convert to gallon (Imperial UK) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.gallon_imperial_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_UK_or_Imp_gal(self) -> 'FieldQnty':
        """Convert to gal_UK_or_Imp_gal units (alias for gallon_imperial_uk), returning new variable."""
        return self.gallon_imperial_uk

    @property
    def gal_UK(self) -> 'FieldQnty':
        """Convert to gal_UK units (alias for gallon_imperial_uk), returning new variable."""
        return self.gallon_imperial_uk

    @property
    def Imp_gal(self) -> 'FieldQnty':
        """Convert to Imp_gal units (alias for gallon_imperial_uk), returning new variable."""
        return self.gallon_imperial_uk

    @property
    def gallon_us_dry(self) -> 'FieldQnty':
        """Convert to gallon (US Dry) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.gallon_us_dry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_US_dry(self) -> 'FieldQnty':
        """Convert to gal_US_dry units (alias for gallon_us_dry), returning new variable."""
        return self.gallon_us_dry

    @property
    def gallon_us_liquid(self) -> 'FieldQnty':
        """Convert to gallon (US Liquid) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.gallon_us_liquid
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal(self) -> 'FieldQnty':
        """Convert to gal units (alias for gallon_us_liquid), returning new variable."""
        return self.gallon_us_liquid

    @property
    def last(self) -> 'FieldQnty':
        """Convert to last units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.last
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liter(self) -> 'FieldQnty':
        """Convert to liter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.liter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_or_L(self) -> 'FieldQnty':
        """Convert to unit_1_or_L units (alias for liter), returning new variable."""
        return self.liter

    @property
    def unit_1(self) -> 'FieldQnty':
        """Convert to unit_1 units (alias for liter), returning new variable."""
        return self.liter

    @property
    def L(self) -> 'FieldQnty':
        """Convert to L units (alias for liter), returning new variable."""
        return self.liter

    @property
    def microliter(self) -> 'FieldQnty':
        """Convert to microliter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.microliter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mu_mathrm_l_or_mu_mathrm_L(self) -> 'FieldQnty':
        """Convert to mu_mathrm_l_or_mu_mathrm_L units (alias for microliter), returning new variable."""
        return self.microliter

    @property
    def mu_l(self) -> 'FieldQnty':
        """Convert to mu_l units (alias for microliter), returning new variable."""
        return self.microliter

    @property
    def mu_L(self) -> 'FieldQnty':
        """Convert to mu_L units (alias for microliter), returning new variable."""
        return self.microliter

    @property
    def milliliter(self) -> 'FieldQnty':
        """Convert to milliliter units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.milliliter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def ml(self) -> 'FieldQnty':
        """Convert to ml units (alias for milliliter), returning new variable."""
        return self.milliliter

    @property
    def mohr_centicube(self) -> 'FieldQnty':
        """Convert to Mohr centicube units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.mohr_centicube
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pint_uk(self) -> 'FieldQnty':
        """Convert to pint (UK) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.pint_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pt_UK(self) -> 'FieldQnty':
        """Convert to pt_UK units (alias for pint_uk), returning new variable."""
        return self.pint_uk

    @property
    def pint_us_dry(self) -> 'FieldQnty':
        """Convert to pint (US Dry) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.pint_us_dry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pt_US_dry(self) -> 'FieldQnty':
        """Convert to pt_US_dry units (alias for pint_us_dry), returning new variable."""
        return self.pint_us_dry

    @property
    def pint_us_liquid(self) -> 'FieldQnty':
        """Convert to pint (US Liquid) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.pint_us_liquid
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def pt(self) -> 'FieldQnty':
        """Convert to pt units (alias for pint_us_liquid), returning new variable."""
        return self.pint_us_liquid

    @property
    def quart_us_dry(self) -> 'FieldQnty':
        """Convert to quart (US Dry) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.quart_us_dry
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def qt_US_dry(self) -> 'FieldQnty':
        """Convert to qt_US_dry units (alias for quart_us_dry), returning new variable."""
        return self.quart_us_dry

    @property
    def st_re(self) -> 'FieldQnty':
        """Convert to stére units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.st_re
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def st(self) -> 'FieldQnty':
        """Convert to st units (alias for st_re), returning new variable."""
        return self.st_re

    @property
    def tablespoon_metric(self) -> 'FieldQnty':
        """Convert to tablespoon (Metric) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.tablespoon_metric
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tbsp_Metric(self) -> 'FieldQnty':
        """Convert to tbsp_Metric units (alias for tablespoon_metric), returning new variable."""
        return self.tablespoon_metric

    @property
    def tablespoon_us(self) -> 'FieldQnty':
        """Convert to tablespoon (US) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.tablespoon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tbsp(self) -> 'FieldQnty':
        """Convert to tbsp units (alias for tablespoon_us), returning new variable."""
        return self.tablespoon_us

    @property
    def teaspoon_us(self) -> 'FieldQnty':
        """Convert to teaspoon (US) units, returning new variable."""
        unit_const: Final = field_units.VolumeUnits.teaspoon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def tsp(self) -> 'FieldQnty':
        """Convert to tsp units (alias for teaspoon_us), returning new variable."""
        return self.teaspoon_us


class AsUnitVolumeFractionOfIConverter(UnitConverter):
    """VolumeFractionOfI-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cubic_centimeters_of_i_per_cubic_meter_total(self) -> 'FieldQnty':
        """Convert to cubic centimeters of "i" per cubic meter total units, returning new variable."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_centimeters_of_i_per_cubic_meter_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cm_mathrm_i_3_mathrm_m_3_or_mathrm_cc_mathrm_i_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_cm_mathrm_i_3_mathrm_m_3_or_mathrm_cc_mathrm_i_mathrm_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total), returning new variable."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cm_i_3_m_3(self) -> 'FieldQnty':
        """Convert to cm_i_3_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total), returning new variable."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cc_i_m_3(self) -> 'FieldQnty':
        """Convert to cc_i_m_3 units (alias for cubic_centimeters_of_i_per_cubic_meter_total), returning new variable."""
        return self.cubic_centimeters_of_i_per_cubic_meter_total

    @property
    def cubic_foot_of_i_per_cubic_foot_total(self) -> 'FieldQnty':
        """Convert to cubic foot of "i" per cubic foot total units, returning new variable."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_foot_of_i_per_cubic_foot_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_mathrm_i_3_mathrm_ft_3_or_mathrm_cft_mathrm_i_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_ft_mathrm_i_3_mathrm_ft_3_or_mathrm_cft_mathrm_i_mathrm_cft units (alias for cubic_foot_of_i_per_cubic_foot_total), returning new variable."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def ft_i_3_ft_3(self) -> 'FieldQnty':
        """Convert to ft_i_3_ft_3 units (alias for cubic_foot_of_i_per_cubic_foot_total), returning new variable."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def cft_i_cft(self) -> 'FieldQnty':
        """Convert to cft_i_cft units (alias for cubic_foot_of_i_per_cubic_foot_total), returning new variable."""
        return self.cubic_foot_of_i_per_cubic_foot_total

    @property
    def cubic_meters_of_i_per_cubic_meter_total(self) -> 'FieldQnty':
        """Convert to cubic meters of " i " per cubic meter total units, returning new variable."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.cubic_meters_of_i_per_cubic_meter_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_mathrm_i_3_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_m_mathrm_i_3_mathrm_m_3 units (alias for cubic_meters_of_i_per_cubic_meter_total), returning new variable."""
        return self.cubic_meters_of_i_per_cubic_meter_total

    @property
    def gallons_of_i_per_gallon_total(self) -> 'FieldQnty':
        """Convert to gallons of "i" per gallon total units, returning new variable."""
        unit_const: Final = field_units.VolumeFractionOfIUnits.gallons_of_i_per_gallon_total
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gal_mathrm_i_mathrm_gal(self) -> 'FieldQnty':
        """Convert to mathrm_gal_mathrm_i_mathrm_gal units (alias for gallons_of_i_per_gallon_total), returning new variable."""
        return self.gallons_of_i_per_gallon_total


class AsUnitVolumetricCalorificHeatingValueConverter(UnitConverter):
    """VolumetricCalorificHeatingValue-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def british_thermal_unit_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to British thermal unit per cubic foot units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Btu_mathrm_ft_3_or_Btu_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Btu_mathrm_ft_3_or_Btu_cft units (alias for british_thermal_unit_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def Btu_ft_3(self) -> 'FieldQnty':
        """Convert to Btu_ft_3 units (alias for british_thermal_unit_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def Btu_cft(self) -> 'FieldQnty':
        """Convert to Btu_cft units (alias for british_thermal_unit_per_cubic_foot), returning new variable."""
        return self.british_thermal_unit_per_cubic_foot

    @property
    def british_thermal_unit_per_gallon_uk(self) -> 'FieldQnty':
        """Convert to British thermal unit per gallon (UK) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_gallon_uk
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_gal_UK(self) -> 'FieldQnty':
        """Convert to Btu_gal_UK units (alias for british_thermal_unit_per_gallon_uk), returning new variable."""
        return self.british_thermal_unit_per_gallon_uk

    @property
    def british_thermal_unit_per_gallon_us(self) -> 'FieldQnty':
        """Convert to British thermal unit per gallon (US) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.british_thermal_unit_per_gallon_us
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def Btu_gal_US(self) -> 'FieldQnty':
        """Convert to Btu_gal_US units (alias for british_thermal_unit_per_gallon_us), returning new variable."""
        return self.british_thermal_unit_per_gallon_us

    @property
    def calorie_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to calorie per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.calorie_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_cal_mathrm_cm_3_or_mathrm_cal_mathrm_cc(self) -> 'FieldQnty':
        """Convert to mathrm_cal_mathrm_cm_3_or_mathrm_cal_mathrm_cc units (alias for calorie_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_cubic_centimeter

    @property
    def cal_cm_3(self) -> 'FieldQnty':
        """Convert to cal_cm_3 units (alias for calorie_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_cubic_centimeter

    @property
    def cal_cc(self) -> 'FieldQnty':
        """Convert to cal_cc units (alias for calorie_per_cubic_centimeter), returning new variable."""
        return self.calorie_per_cubic_centimeter

    @property
    def chu_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to Chu per cubic foot units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.chu_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_Chu_mathrm_ft_3_or_mathrm_Chu_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_Chu_mathrm_ft_3_or_mathrm_Chu_mathrm_cft units (alias for chu_per_cubic_foot), returning new variable."""
        return self.chu_per_cubic_foot

    @property
    def Chu_ft_3(self) -> 'FieldQnty':
        """Convert to Chu_ft_3 units (alias for chu_per_cubic_foot), returning new variable."""
        return self.chu_per_cubic_foot

    @property
    def Chu_cft(self) -> 'FieldQnty':
        """Convert to Chu_cft units (alias for chu_per_cubic_foot), returning new variable."""
        return self.chu_per_cubic_foot

    @property
    def joule_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to joule per cubic meter units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.joule_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_J_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_J_mathrm_m_3 units (alias for joule_per_cubic_meter), returning new variable."""
        return self.joule_per_cubic_meter

    @property
    def kilocalorie_per_cubic_foot(self) -> 'FieldQnty':
        """Convert to kilocalorie per cubic foot units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.kilocalorie_per_cubic_foot
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_mathrm_ft_3_or_mathrm_kcal_mathrm_cft(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_ft_3_or_mathrm_kcal_mathrm_cft units (alias for kilocalorie_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kcal_ft_3(self) -> 'FieldQnty':
        """Convert to kcal_ft_3 units (alias for kilocalorie_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kcal_cft(self) -> 'FieldQnty':
        """Convert to kcal_cft units (alias for kilocalorie_per_cubic_foot), returning new variable."""
        return self.kilocalorie_per_cubic_foot

    @property
    def kilocalorie_per_cubic_meter(self) -> 'FieldQnty':
        """Convert to kilocalorie per cubic meter units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.kilocalorie_per_cubic_meter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kcal_mathrm_m_3(self) -> 'FieldQnty':
        """Convert to mathrm_kcal_mathrm_m_3 units (alias for kilocalorie_per_cubic_meter), returning new variable."""
        return self.kilocalorie_per_cubic_meter

    @property
    def therm_100_k_btu(self) -> 'FieldQnty':
        """Convert to therm ( 100 K Btu ) per cubic foot units, returning new variable."""
        unit_const: Final = field_units.VolumetricCalorificHeatingValueUnits.therm_100_k_btu
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def thm_cft(self) -> 'FieldQnty':
        """Convert to thm_cft units (alias for therm_100_k_btu), returning new variable."""
        return self.therm_100_k_btu


class AsUnitVolumetricCoefficientOfExpansionConverter(UnitConverter):
    """VolumetricCoefficientOfExpansion-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_per_cubic_centimeter_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to gram per cubic centimeter per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_mathrm_cm_3_mathrm_K_or_g_cc_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to mathrm_g_mathrm_cm_3_mathrm_K_or_g_cc_circ_mathrm_C units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def g_cm_3_K(self) -> 'FieldQnty':
        """Convert to g_cm_3_K units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def g_cc_circ_C(self) -> 'FieldQnty':
        """Convert to g_cc_circ_C units (alias for gram_per_cubic_centimeter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.gram_per_cubic_centimeter_per_kelvin_or_degree_celsius

    @property
    def kilogram_per_cubic_meter_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to kilogram per cubic meter per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_kg_mathrm_m_3_mathrm_K_or_mathrm_kg_mathrm_m_3_circ_C(self) -> 'FieldQnty':
        """Convert to mathrm_kg_mathrm_m_3_mathrm_K_or_mathrm_kg_mathrm_m_3_circ_C units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def kg_m_3_K(self) -> 'FieldQnty':
        """Convert to kg_m_3_K units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def kg_m_3_circ_C(self) -> 'FieldQnty':
        """Convert to kg_m_3_circ_C units (alias for kilogram_per_cubic_meter_per_kelvin_or_degree_celsius), returning new variable."""
        return self.kilogram_per_cubic_meter_per_kelvin_or_degree_celsius

    @property
    def pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine(self) -> 'FieldQnty':
        """Convert to pound per cubic foot per degree Fahrenheit (or degree Rankine) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_ft_3_circ_mathrm_R_or_mathrm_lb_mathrm_cft_circ_mathrm_F(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_3_circ_mathrm_R_or_mathrm_lb_mathrm_cft_circ_mathrm_F units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine), returning new variable."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def lb_ft_3_circ_R(self) -> 'FieldQnty':
        """Convert to lb_ft_3_circ_R units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine), returning new variable."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def lb_cft_circ_F(self) -> 'FieldQnty':
        """Convert to lb_cft_circ_F units (alias for pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine), returning new variable."""
        return self.pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine

    @property
    def pound_per_cubic_foot_per_kelvin_or_degree_celsius(self) -> 'FieldQnty':
        """Convert to pound per cubic foot per kelvin (or degree Celsius) units, returning new variable."""
        unit_const: Final = field_units.VolumetricCoefficientOfExpansionUnits.pound_per_cubic_foot_per_kelvin_or_degree_celsius
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_lb_mathrm_ft_3_mathrm_K_or_mathrm_lb_mathrm_cft_circ_mathrm_C(self) -> 'FieldQnty':
        """Convert to mathrm_lb_mathrm_ft_3_mathrm_K_or_mathrm_lb_mathrm_cft_circ_mathrm_C units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius), returning new variable."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius

    @property
    def lb_ft_3_K(self) -> 'FieldQnty':
        """Convert to lb_ft_3_K units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius), returning new variable."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius

    @property
    def lb_cft_circ_C(self) -> 'FieldQnty':
        """Convert to lb_cft_circ_C units (alias for pound_per_cubic_foot_per_kelvin_or_degree_celsius), returning new variable."""
        return self.pound_per_cubic_foot_per_kelvin_or_degree_celsius


class AsUnitVolumetricFlowRateConverter(UnitConverter):
    """VolumetricFlowRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cubic_feet_per_day(self) -> 'FieldQnty':
        """Convert to cubic feet per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_d_or_mathrm_cft_mathrm_da_or_cfd(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_d_or_mathrm_cft_mathrm_da_or_cfd units (alias for cubic_feet_per_day), returning new variable."""
        return self.cubic_feet_per_day

    @property
    def ft_3_d(self) -> 'FieldQnty':
        """Convert to ft_3_d units (alias for cubic_feet_per_day), returning new variable."""
        return self.cubic_feet_per_day

    @property
    def cft_da(self) -> 'FieldQnty':
        """Convert to cft_da units (alias for cubic_feet_per_day), returning new variable."""
        return self.cubic_feet_per_day

    @property
    def cfd(self) -> 'FieldQnty':
        """Convert to cfd units (alias for cubic_feet_per_day), returning new variable."""
        return self.cubic_feet_per_day

    @property
    def cubic_feet_per_hour(self) -> 'FieldQnty':
        """Convert to cubic feet per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_h_or_mathrm_cft_mathrm_hr_or_cfh(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_h_or_mathrm_cft_mathrm_hr_or_cfh units (alias for cubic_feet_per_hour), returning new variable."""
        return self.cubic_feet_per_hour

    @property
    def ft_3_h(self) -> 'FieldQnty':
        """Convert to ft_3_h units (alias for cubic_feet_per_hour), returning new variable."""
        return self.cubic_feet_per_hour

    @property
    def cft_hr(self) -> 'FieldQnty':
        """Convert to cft_hr units (alias for cubic_feet_per_hour), returning new variable."""
        return self.cubic_feet_per_hour

    @property
    def cfh(self) -> 'FieldQnty':
        """Convert to cfh units (alias for cubic_feet_per_hour), returning new variable."""
        return self.cubic_feet_per_hour

    @property
    def cubic_feet_per_minute(self) -> 'FieldQnty':
        """Convert to cubic feet per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_min_or_mathrm_cft_mathrm_min_or_cfm(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_min_or_mathrm_cft_mathrm_min_or_cfm units (alias for cubic_feet_per_minute), returning new variable."""
        return self.cubic_feet_per_minute

    @property
    def ft_3_min(self) -> 'FieldQnty':
        """Convert to ft_3_min units (alias for cubic_feet_per_minute), returning new variable."""
        return self.cubic_feet_per_minute

    @property
    def cft_min(self) -> 'FieldQnty':
        """Convert to cft_min units (alias for cubic_feet_per_minute), returning new variable."""
        return self.cubic_feet_per_minute

    @property
    def cfm(self) -> 'FieldQnty':
        """Convert to cfm units (alias for cubic_feet_per_minute), returning new variable."""
        return self.cubic_feet_per_minute

    @property
    def cubic_feet_per_second(self) -> 'FieldQnty':
        """Convert to cubic feet per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_feet_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_mathrm_s_or_cft_sec_or_cfs(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_mathrm_s_or_cft_sec_or_cfs units (alias for cubic_feet_per_second), returning new variable."""
        return self.cubic_feet_per_second

    @property
    def ft_3_s(self) -> 'FieldQnty':
        """Convert to ft_3_s units (alias for cubic_feet_per_second), returning new variable."""
        return self.cubic_feet_per_second

    @property
    def cft_sec(self) -> 'FieldQnty':
        """Convert to cft_sec units (alias for cubic_feet_per_second), returning new variable."""
        return self.cubic_feet_per_second

    @property
    def cfs(self) -> 'FieldQnty':
        """Convert to cfs units (alias for cubic_feet_per_second), returning new variable."""
        return self.cubic_feet_per_second

    @property
    def cubic_meters_per_day(self) -> 'FieldQnty':
        """Convert to cubic meters per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_mathrm_d(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_d units (alias for cubic_meters_per_day), returning new variable."""
        return self.cubic_meters_per_day

    @property
    def cubic_meters_per_hour(self) -> 'FieldQnty':
        """Convert to cubic meters per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_mathrm_h(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_h units (alias for cubic_meters_per_hour), returning new variable."""
        return self.cubic_meters_per_hour

    @property
    def cubic_meters_per_minute(self) -> 'FieldQnty':
        """Convert to cubic meters per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_min(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_min units (alias for cubic_meters_per_minute), returning new variable."""
        return self.cubic_meters_per_minute

    @property
    def cubic_meters_per_second(self) -> 'FieldQnty':
        """Convert to cubic meters per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.cubic_meters_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_mathrm_s(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_mathrm_s units (alias for cubic_meters_per_second), returning new variable."""
        return self.cubic_meters_per_second

    @property
    def gallons_per_day(self) -> 'FieldQnty':
        """Convert to gallons per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_d_or_gpd_or_gal_da(self) -> 'FieldQnty':
        """Convert to gal_d_or_gpd_or_gal_da units (alias for gallons_per_day), returning new variable."""
        return self.gallons_per_day

    @property
    def gal_d(self) -> 'FieldQnty':
        """Convert to gal_d units (alias for gallons_per_day), returning new variable."""
        return self.gallons_per_day

    @property
    def gpd(self) -> 'FieldQnty':
        """Convert to gpd units (alias for gallons_per_day), returning new variable."""
        return self.gallons_per_day

    @property
    def gal_da(self) -> 'FieldQnty':
        """Convert to gal_da units (alias for gallons_per_day), returning new variable."""
        return self.gallons_per_day

    @property
    def gallons_per_hour(self) -> 'FieldQnty':
        """Convert to gallons per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_h_or_gph_or_gal_hr(self) -> 'FieldQnty':
        """Convert to gal_h_or_gph_or_gal_hr units (alias for gallons_per_hour), returning new variable."""
        return self.gallons_per_hour

    @property
    def gal_h(self) -> 'FieldQnty':
        """Convert to gal_h units (alias for gallons_per_hour), returning new variable."""
        return self.gallons_per_hour

    @property
    def gph(self) -> 'FieldQnty':
        """Convert to gph units (alias for gallons_per_hour), returning new variable."""
        return self.gallons_per_hour

    @property
    def gal_hr(self) -> 'FieldQnty':
        """Convert to gal_hr units (alias for gallons_per_hour), returning new variable."""
        return self.gallons_per_hour

    @property
    def gallons_per_minute(self) -> 'FieldQnty':
        """Convert to gallons per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_min_or_gpm(self) -> 'FieldQnty':
        """Convert to gal_min_or_gpm units (alias for gallons_per_minute), returning new variable."""
        return self.gallons_per_minute

    @property
    def gal_min(self) -> 'FieldQnty':
        """Convert to gal_min units (alias for gallons_per_minute), returning new variable."""
        return self.gallons_per_minute

    @property
    def gpm(self) -> 'FieldQnty':
        """Convert to gpm units (alias for gallons_per_minute), returning new variable."""
        return self.gallons_per_minute

    @property
    def gallons_per_second(self) -> 'FieldQnty':
        """Convert to gallons per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.gallons_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def gal_s_or_gps_or_gal_sec(self) -> 'FieldQnty':
        """Convert to gal_s_or_gps_or_gal_sec units (alias for gallons_per_second), returning new variable."""
        return self.gallons_per_second

    @property
    def gal_s(self) -> 'FieldQnty':
        """Convert to gal_s units (alias for gallons_per_second), returning new variable."""
        return self.gallons_per_second

    @property
    def gps(self) -> 'FieldQnty':
        """Convert to gps units (alias for gallons_per_second), returning new variable."""
        return self.gallons_per_second

    @property
    def gal_sec(self) -> 'FieldQnty':
        """Convert to gal_sec units (alias for gallons_per_second), returning new variable."""
        return self.gallons_per_second

    @property
    def liters_per_day(self) -> 'FieldQnty':
        """Convert to liters per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_d(self) -> 'FieldQnty':
        """Convert to unit_1_d units (alias for liters_per_day), returning new variable."""
        return self.liters_per_day

    @property
    def liters_per_hour(self) -> 'FieldQnty':
        """Convert to liters per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_h(self) -> 'FieldQnty':
        """Convert to unit_1_h units (alias for liters_per_hour), returning new variable."""
        return self.liters_per_hour

    @property
    def liters_per_minute(self) -> 'FieldQnty':
        """Convert to liters per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liters_per_second(self) -> 'FieldQnty':
        """Convert to liters per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFlowRateUnits.liters_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def unit_1_s(self) -> 'FieldQnty':
        """Convert to unit_1_s units (alias for liters_per_second), returning new variable."""
        return self.liters_per_second


class AsUnitVolumetricFluxConverter(UnitConverter):
    """VolumetricFlux-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def cubic_feet_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_d_right_or_mathrm_cft_mathrm_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_d_right_or_mathrm_cft_mathrm_sqft_da units (alias for cubic_feet_per_square_foot_per_day), returning new variable."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def ft_3_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_dright units (alias for cubic_feet_per_square_foot_per_day), returning new variable."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def cft_sqft_da(self) -> 'FieldQnty':
        """Convert to cft_sqft_da units (alias for cubic_feet_per_square_foot_per_day), returning new variable."""
        return self.cubic_feet_per_square_foot_per_day

    @property
    def cubic_feet_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_h_right_or_mathrm_cft_mathrm_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_h_right_or_mathrm_cft_mathrm_sqft_hr units (alias for cubic_feet_per_square_foot_per_hour), returning new variable."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def ft_3_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_hright units (alias for cubic_feet_per_square_foot_per_hour), returning new variable."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def cft_sqft_hr(self) -> 'FieldQnty':
        """Convert to cft_sqft_hr units (alias for cubic_feet_per_square_foot_per_hour), returning new variable."""
        return self.cubic_feet_per_square_foot_per_hour

    @property
    def cubic_feet_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_min_right_or_mathrm_cft_sqft_min(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_min_right_or_mathrm_cft_sqft_min units (alias for cubic_feet_per_square_foot_per_minute), returning new variable."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def ft_3_left_ft_2_min_right(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_min_right units (alias for cubic_feet_per_square_foot_per_minute), returning new variable."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def cft_sqft_min(self) -> 'FieldQnty':
        """Convert to cft_sqft_min units (alias for cubic_feet_per_square_foot_per_minute), returning new variable."""
        return self.cubic_feet_per_square_foot_per_minute

    @property
    def cubic_feet_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to cubic feet per square foot per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_feet_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_s_right_or_cft_sqft_sec(self) -> 'FieldQnty':
        """Convert to mathrm_ft_3_left_mathrm_ft_2_mathrm_s_right_or_cft_sqft_sec units (alias for cubic_feet_per_square_foot_per_second), returning new variable."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def ft_3_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to ft_3_left_ft_2_sright units (alias for cubic_feet_per_square_foot_per_second), returning new variable."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def cft_sqft_sec(self) -> 'FieldQnty':
        """Convert to cft_sqft_sec units (alias for cubic_feet_per_square_foot_per_second), returning new variable."""
        return self.cubic_feet_per_square_foot_per_second

    @property
    def cubic_meters_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_d_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_d_right units (alias for cubic_meters_per_square_meter_per_day), returning new variable."""
        return self.cubic_meters_per_square_meter_per_day

    @property
    def cubic_meters_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_h_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_h_right units (alias for cubic_meters_per_square_meter_per_hour), returning new variable."""
        return self.cubic_meters_per_square_meter_per_hour

    @property
    def cubic_meters_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_min_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_min_right units (alias for cubic_meters_per_square_meter_per_minute), returning new variable."""
        return self.cubic_meters_per_square_meter_per_minute

    @property
    def cubic_meters_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to cubic meters per square meter per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.cubic_meters_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_s_right(self) -> 'FieldQnty':
        """Convert to mathrm_m_3_left_mathrm_m_2_mathrm_s_right units (alias for cubic_meters_per_square_meter_per_second), returning new variable."""
        return self.cubic_meters_per_square_meter_per_second

    @property
    def gallons_per_square_foot_per_day(self) -> 'FieldQnty':
        """Convert to gallons per square foot per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_d_right_or_gal_sqft_da(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_d_right_or_gal_sqft_da units (alias for gallons_per_square_foot_per_day), returning new variable."""
        return self.gallons_per_square_foot_per_day

    @property
    def gal_left_ft_2_dright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_dright units (alias for gallons_per_square_foot_per_day), returning new variable."""
        return self.gallons_per_square_foot_per_day

    @property
    def gal_sqft_da(self) -> 'FieldQnty':
        """Convert to gal_sqft_da units (alias for gallons_per_square_foot_per_day), returning new variable."""
        return self.gallons_per_square_foot_per_day

    @property
    def gallons_per_square_foot_per_hour(self) -> 'FieldQnty':
        """Convert to gallons per square foot per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_h_right_or_gal_sqft_hr(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_h_right_or_gal_sqft_hr units (alias for gallons_per_square_foot_per_hour), returning new variable."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gal_left_ft_2_hright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_hright units (alias for gallons_per_square_foot_per_hour), returning new variable."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gal_sqft_hr(self) -> 'FieldQnty':
        """Convert to gal_sqft_hr units (alias for gallons_per_square_foot_per_hour), returning new variable."""
        return self.gallons_per_square_foot_per_hour

    @property
    def gallons_per_square_foot_per_minute(self) -> 'FieldQnty':
        """Convert to gallons per square foot per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_min_right_or_gal_sqft_min_or_gpm_sqft(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_min_right_or_gal_sqft_min_or_gpm_sqft units (alias for gallons_per_square_foot_per_minute), returning new variable."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gal_left_ft_2_minright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_minright units (alias for gallons_per_square_foot_per_minute), returning new variable."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gal_sqft_min(self) -> 'FieldQnty':
        """Convert to gal_sqft_min units (alias for gallons_per_square_foot_per_minute), returning new variable."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gpm_sqft(self) -> 'FieldQnty':
        """Convert to gpm_sqft units (alias for gallons_per_square_foot_per_minute), returning new variable."""
        return self.gallons_per_square_foot_per_minute

    @property
    def gallons_per_square_foot_per_second(self) -> 'FieldQnty':
        """Convert to gallons per square foot per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.gallons_per_square_foot_per_second
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_s_right_or_gal_mathrm_sqft_mathrm_sec(self) -> 'FieldQnty':
        """Convert to mathrm_gal_left_mathrm_ft_2_mathrm_s_right_or_gal_mathrm_sqft_mathrm_sec units (alias for gallons_per_square_foot_per_second), returning new variable."""
        return self.gallons_per_square_foot_per_second

    @property
    def gal_left_ft_2_sright(self) -> 'FieldQnty':
        """Convert to gal_left_ft_2_sright units (alias for gallons_per_square_foot_per_second), returning new variable."""
        return self.gallons_per_square_foot_per_second

    @property
    def gal_sqft_sec(self) -> 'FieldQnty':
        """Convert to gal_sqft_sec units (alias for gallons_per_square_foot_per_second), returning new variable."""
        return self.gallons_per_square_foot_per_second

    @property
    def liters_per_square_meter_per_day(self) -> 'FieldQnty':
        """Convert to liters per square meter per day units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_day
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liters_per_square_meter_per_hour(self) -> 'FieldQnty':
        """Convert to liters per square meter per hour units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_hour
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liters_per_square_meter_per_minute(self) -> 'FieldQnty':
        """Convert to liters per square meter per minute units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_minute
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def liters_per_square_meter_per_second(self) -> 'FieldQnty':
        """Convert to liters per square meter per second units, returning new variable."""
        unit_const: Final = field_units.VolumetricFluxUnits.liters_per_square_meter_per_second
        return self._convert_quantity(unit_const, modify_original=False)


class AsUnitVolumetricMassFlowRateConverter(UnitConverter):
    """VolumetricMassFlowRate-specific AsUnit converter with optimized unit properties."""

    __slots__ = ()

    def __call__(self, unit_str: str) -> 'FieldQnty':
        """Convert to specified unit using string notation, returning new variable."""
        unit_constant = self._get_unit_constant(unit_str)
        return self._convert_quantity(unit_constant, modify_original=False)

    @property
    def gram_per_second_per_cubic_centimeter(self) -> 'FieldQnty':
        """Convert to gram per second per cubic centimeter units, returning new variable."""
        unit_const: Final = field_units.VolumetricMassFlowRateUnits.gram_per_second_per_cubic_centimeter
        return self._convert_quantity(unit_const, modify_original=False)

    @property
    def mathrm_g_left_mathrm_s_mathrm_cm_3_right_or_g_s_cc_or_mathrm_g_mathrm_cc_mathrm_sec(self) -> 'FieldQnty':
        """Convert to mathrm_g_left_mathrm_s_mathrm_cm_3_right_or_g_s_cc_or_mathrm_g_mathrm_cc_mathrm_sec units (alias for gram_per_second_per_cubic_centimeter), returning new variable."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def g_left_s_cm_3right(self) -> 'FieldQnty':
        """Convert to g_left_s_cm_3right units (alias for gram_per_second_per_cubic_centimeter), returning new variable."""
        return self.gram_per_second_per_cubic_centimeter

    @property
    def g_s_cc(self) -> 'FieldQnty':
        """Convert to g_s_cc units (alia