"""
Type stubs for setter classes - Complete Edition.

Provides complete type hints for IDE autocomplete and type checking
for setter classes and their unit properties.
Contains 107 setter types with 871 total unit properties.

Auto-generated by codegen/generators/field_setter.py
DO NOT EDIT MANUALLY - changes will be overwritten.
"""

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .base_qnty import TypeSafeSetter
    from .field_qnty import FieldQnty

# ===== SETTER CLASSES =====
# Type stubs for setter classes with unit properties

class AbsorbedDoseSetter(TypeSafeSetter):
    """AbsorbedDose-specific setter with unit properties."""

    __slots__ = ()

    @property
    def erg_per_gram(self) -> FieldQnty: ...

    @property
    def erg_g(self) -> FieldQnty: ...

    @property
    def erg_per_g(self) -> FieldQnty: ...

    @property
    def gram_rad(self) -> FieldQnty: ...

    @property
    def g_rad(self) -> FieldQnty: ...

    @property
    def gray(self) -> FieldQnty: ...

    @property
    def Gy(self) -> FieldQnty: ...

    @property
    def rad(self) -> FieldQnty: ...

    @property
    def milligray(self) -> FieldQnty: ...

    @property
    def mGy(self) -> FieldQnty: ...

    @property
    def microgray(self) -> FieldQnty: ...


class AccelerationSetter(TypeSafeSetter):
    """Acceleration-specific setter with unit properties."""

    __slots__ = ()

    @property
    def meter_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_m_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def m_per_s2(self) -> FieldQnty: ...

    @property
    def foot_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_s_2_or_mathrm_ft_mathrm_sec_2(self) -> FieldQnty: ...

    @property
    def ft_per_s2(self) -> FieldQnty: ...

    @property
    def fps2(self) -> FieldQnty: ...


class ActivationEnergySetter(TypeSafeSetter):
    """ActivationEnergy-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_per_pound_mole(self) -> FieldQnty: ...

    @property
    def Btu_lb_mol(self) -> FieldQnty: ...

    @property
    def btu_per_lbmol(self) -> FieldQnty: ...

    @property
    def calorie_mean_per_gram_mole(self) -> FieldQnty: ...

    @property
    def cal_mol(self) -> FieldQnty: ...

    @property
    def cal_mean_per_gmol(self) -> FieldQnty: ...

    @property
    def joule_per_gram_mole(self) -> FieldQnty: ...

    @property
    def J_mol(self) -> FieldQnty: ...

    @property
    def joule_per_kilogram_mole(self) -> FieldQnty: ...

    @property
    def J_kmol(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_kilogram_mole(self) -> FieldQnty: ...

    @property
    def kcal_kmol(self) -> FieldQnty: ...


class AmountOfSubstanceSetter(TypeSafeSetter):
    """AmountOfSubstance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def kilogram_mol(self) -> FieldQnty: ...

    @property
    def kmol(self) -> FieldQnty: ...

    @property
    def mole(self) -> FieldQnty: ...

    @property
    def mol(self) -> FieldQnty: ...

    @property
    def pound_mole(self) -> FieldQnty: ...

    @property
    def lb_mol_or_mole(self) -> FieldQnty: ...

    @property
    def lb_mol(self) -> FieldQnty: ...

    @property
    def millimole(self) -> FieldQnty: ...

    @property
    def mmol(self) -> FieldQnty: ...

    @property
    def micromole(self) -> FieldQnty: ...


class AnglePlaneSetter(TypeSafeSetter):
    """AnglePlane-specific setter with unit properties."""

    __slots__ = ()

    @property
    def degree(self) -> FieldQnty: ...

    @property
    def circ(self) -> FieldQnty: ...

    @property
    def gon(self) -> FieldQnty: ...

    @property
    def grade(self) -> FieldQnty: ...

    @property
    def minute_new(self) -> FieldQnty: ...

    @property
    def c(self) -> FieldQnty: ...

    @property
    def minute_of_angle(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...

    @property
    def percent(self) -> FieldQnty: ...

    @property
    def plane_angle(self) -> FieldQnty: ...

    @property
    def quadrant(self) -> FieldQnty: ...

    @property
    def quadr(self) -> FieldQnty: ...

    @property
    def radian(self) -> FieldQnty: ...

    @property
    def rad(self) -> FieldQnty: ...

    @property
    def right_angle(self) -> FieldQnty: ...

    @property
    def perp(self) -> FieldQnty: ...

    @property
    def round(self) -> FieldQnty: ...

    @property
    def tr_or_r(self) -> FieldQnty: ...

    @property
    def tr(self) -> FieldQnty: ...

    @property
    def r(self) -> FieldQnty: ...

    @property
    def second_new(self) -> FieldQnty: ...

    @property
    def cc(self) -> FieldQnty: ...

    @property
    def second_of_angle(self) -> FieldQnty: ...

    @property
    def thousandth_us(self) -> FieldQnty: ...

    @property
    def US(self) -> FieldQnty: ...

    @property
    def turn(self) -> FieldQnty: ...

    @property
    def turn_or_rev(self) -> FieldQnty: ...

    @property
    def rev(self) -> FieldQnty: ...


class AngleSolidSetter(TypeSafeSetter):
    """AngleSolid-specific setter with unit properties."""

    __slots__ = ()

    @property
    def spat(self) -> FieldQnty: ...

    @property
    def square_degree(self) -> FieldQnty: ...

    @property
    def left_circ_right_2(self) -> FieldQnty: ...

    @property
    def square_gon(self) -> FieldQnty: ...

    @property
    def g_2(self) -> FieldQnty: ...

    @property
    def steradian(self) -> FieldQnty: ...

    @property
    def sr(self) -> FieldQnty: ...


class AngularAccelerationSetter(TypeSafeSetter):
    """AngularAcceleration-specific setter with unit properties."""

    __slots__ = ()

    @property
    def radian_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_rad_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def revolution_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_rev_mathrm_sec_2(self) -> FieldQnty: ...

    @property
    def rpm_or_revolution_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_rev_mathrm_min_2_or_rpm_min(self) -> FieldQnty: ...

    @property
    def rev_min_2(self) -> FieldQnty: ...

    @property
    def rpm_min(self) -> FieldQnty: ...


class AngularMomentumSetter(TypeSafeSetter):
    """AngularMomentum-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_centimeter_squared_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def kilogram_meter_squared_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def pound_force_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def lb_ft_2_mathrm_sec(self) -> FieldQnty: ...


class AreaSetter(TypeSafeSetter):
    """Area-specific setter with unit properties."""

    __slots__ = ()

    @property
    def acre_general(self) -> FieldQnty: ...

    @property
    def ac(self) -> FieldQnty: ...

    @property
    def are(self) -> FieldQnty: ...

    @property
    def a(self) -> FieldQnty: ...

    @property
    def arpent_quebec(self) -> FieldQnty: ...

    @property
    def arp(self) -> FieldQnty: ...

    @property
    def barn(self) -> FieldQnty: ...

    @property
    def b(self) -> FieldQnty: ...

    @property
    def circular_inch(self) -> FieldQnty: ...

    @property
    def cin(self) -> FieldQnty: ...

    @property
    def circular_mil(self) -> FieldQnty: ...

    @property
    def cmil(self) -> FieldQnty: ...

    @property
    def hectare(self) -> FieldQnty: ...

    @property
    def ha(self) -> FieldQnty: ...

    @property
    def shed(self) -> FieldQnty: ...

    @property
    def square_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def square_chain_ramsden(self) -> FieldQnty: ...

    @property
    def sq_ch_Rams(self) -> FieldQnty: ...

    @property
    def square_chain_survey_gunters(self) -> FieldQnty: ...

    @property
    def sq_ch_surv(self) -> FieldQnty: ...

    @property
    def square_decimeter(self) -> FieldQnty: ...

    @property
    def mathrm_dm_2(self) -> FieldQnty: ...

    @property
    def square_fermi(self) -> FieldQnty: ...

    @property
    def mathrm_F_2(self) -> FieldQnty: ...

    @property
    def square_foot(self) -> FieldQnty: ...

    @property
    def sq_ft_or_ft_2(self) -> FieldQnty: ...

    @property
    def sq_ft(self) -> FieldQnty: ...

    @property
    def ft_2(self) -> FieldQnty: ...

    @property
    def square_hectometer(self) -> FieldQnty: ...

    @property
    def mathrm_hm_2(self) -> FieldQnty: ...

    @property
    def square_inch(self) -> FieldQnty: ...

    @property
    def sq_in_or_in_2(self) -> FieldQnty: ...

    @property
    def sq_in(self) -> FieldQnty: ...

    @property
    def in_2(self) -> FieldQnty: ...

    @property
    def square_kilometer(self) -> FieldQnty: ...

    @property
    def mathrm_km_2(self) -> FieldQnty: ...

    @property
    def square_league_statute(self) -> FieldQnty: ...

    @property
    def sq_lg_stat(self) -> FieldQnty: ...

    @property
    def square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_m_2(self) -> FieldQnty: ...

    @property
    def square_micron(self) -> FieldQnty: ...

    @property
    def mu_mathrm_m_2_or_mu_2(self) -> FieldQnty: ...

    @property
    def mu_m_2(self) -> FieldQnty: ...

    @property
    def mu_2(self) -> FieldQnty: ...

    @property
    def square_mile_statute(self) -> FieldQnty: ...

    @property
    def sq_mi_stat(self) -> FieldQnty: ...

    @property
    def square_mile_us_survey(self) -> FieldQnty: ...

    @property
    def sq_mi_US_Surv(self) -> FieldQnty: ...

    @property
    def square_millimeter(self) -> FieldQnty: ...

    @property
    def mathrm_mm_2(self) -> FieldQnty: ...

    @property
    def square_nanometer(self) -> FieldQnty: ...

    @property
    def mathrm_nm_2(self) -> FieldQnty: ...

    @property
    def square_yard(self) -> FieldQnty: ...

    @property
    def sq_yd(self) -> FieldQnty: ...

    @property
    def township_us(self) -> FieldQnty: ...

    @property
    def twshp(self) -> FieldQnty: ...


class AreaPerUnitVolumeSetter(TypeSafeSetter):
    """AreaPerUnitVolume-specific setter with unit properties."""

    __slots__ = ()

    @property
    def square_centimeter_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_cm_2_mathrm_cc(self) -> FieldQnty: ...

    @property
    def square_foot_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_ft_3_or_sqft_cft(self) -> FieldQnty: ...

    @property
    def ft_2_ft_3(self) -> FieldQnty: ...

    @property
    def sqft_cft(self) -> FieldQnty: ...

    @property
    def square_inch_per_cubic_inch(self) -> FieldQnty: ...

    @property
    def mathrm_in_2_mathrm_in_3_or_sq_in_cu_in(self) -> FieldQnty: ...

    @property
    def in_2_in_3(self) -> FieldQnty: ...

    @property
    def sq_in_cu_in(self) -> FieldQnty: ...

    @property
    def square_meter_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_m_3_or_1_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def m_2_m_3(self) -> FieldQnty: ...

    @property
    def unit_1_m_3(self) -> FieldQnty: ...


class AtomicWeightSetter(TypeSafeSetter):
    """AtomicWeight-specific setter with unit properties."""

    __slots__ = ()

    @property
    def atomic_mass_unit_12c(self) -> FieldQnty: ...

    @property
    def amu(self) -> FieldQnty: ...

    @property
    def grams_per_mole(self) -> FieldQnty: ...

    @property
    def g_mol(self) -> FieldQnty: ...

    @property
    def kilograms_per_kilomole(self) -> FieldQnty: ...

    @property
    def kg_kmol(self) -> FieldQnty: ...

    @property
    def pounds_per_pound_mole(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_lb_mol_or_mathrm_lb_mole(self) -> FieldQnty: ...

    @property
    def lb_lb_mol(self) -> FieldQnty: ...

    @property
    def lb_mole(self) -> FieldQnty: ...


class ConcentrationSetter(TypeSafeSetter):
    """Concentration-specific setter with unit properties."""

    __slots__ = ()

    @property
    def grains_of_i_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_gr_mathrm_ft_3_or_gr_cft(self) -> FieldQnty: ...

    @property
    def gr_ft_3(self) -> FieldQnty: ...

    @property
    def gr_cft(self) -> FieldQnty: ...

    @property
    def grains_of_i_per_gallon_us(self) -> FieldQnty: ...

    @property
    def gr_gal(self) -> FieldQnty: ...


class DimensionlessSetter(TypeSafeSetter):
    """Dimensionless-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dimensionless(self) -> FieldQnty: ...

    @property
    def ratio(self) -> FieldQnty: ...

    @property
    def parts_per_million(self) -> FieldQnty: ...

    @property
    def ppm(self) -> FieldQnty: ...

    @property
    def parts_per_billion(self) -> FieldQnty: ...

    @property
    def ppb(self) -> FieldQnty: ...


class DynamicFluiditySetter(TypeSafeSetter):
    """DynamicFluidity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def meter_seconds_per_kilogram(self) -> FieldQnty: ...

    @property
    def m_s_kg(self) -> FieldQnty: ...

    @property
    def rhe(self) -> FieldQnty: ...

    @property
    def square_foot_per_pound_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_lb_sec(self) -> FieldQnty: ...

    @property
    def square_meters_per_newton_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_N_mathrm_s(self) -> FieldQnty: ...


class ElectricCapacitanceSetter(TypeSafeSetter):
    """ElectricCapacitance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cm(self) -> FieldQnty: ...

    @property
    def abfarad(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def farad(self) -> FieldQnty: ...

    @property
    def F(self) -> FieldQnty: ...

    @property
    def farad_intl(self) -> FieldQnty: ...

    @property
    def F_int(self) -> FieldQnty: ...

    @property
    def jar(self) -> FieldQnty: ...

    @property
    def puff(self) -> FieldQnty: ...

    @property
    def statfarad(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def millifarad(self) -> FieldQnty: ...

    @property
    def mF(self) -> FieldQnty: ...

    @property
    def microfarad(self) -> FieldQnty: ...

    @property
    def nanofarad(self) -> FieldQnty: ...

    @property
    def nF(self) -> FieldQnty: ...

    @property
    def picofarad(self) -> FieldQnty: ...

    @property
    def pF(self) -> FieldQnty: ...


class ElectricChargeSetter(TypeSafeSetter):
    """ElectricCharge-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abcoulomb(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def ampere_hour(self) -> FieldQnty: ...

    @property
    def Ah(self) -> FieldQnty: ...

    @property
    def coulomb(self) -> FieldQnty: ...

    @property
    def C(self) -> FieldQnty: ...

    @property
    def faraday_c12(self) -> FieldQnty: ...

    @property
    def F(self) -> FieldQnty: ...

    @property
    def franklin(self) -> FieldQnty: ...

    @property
    def Fr(self) -> FieldQnty: ...

    @property
    def statcoulomb(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def u_a_charge(self) -> FieldQnty: ...

    @property
    def u_a(self) -> FieldQnty: ...

    @property
    def kilocoulomb(self) -> FieldQnty: ...

    @property
    def kC(self) -> FieldQnty: ...

    @property
    def millicoulomb(self) -> FieldQnty: ...

    @property
    def mC(self) -> FieldQnty: ...

    @property
    def microcoulomb(self) -> FieldQnty: ...

    @property
    def nanocoulomb(self) -> FieldQnty: ...

    @property
    def nC(self) -> FieldQnty: ...

    @property
    def picocoulomb(self) -> FieldQnty: ...

    @property
    def pC(self) -> FieldQnty: ...


class ElectricCurrentIntensitySetter(TypeSafeSetter):
    """ElectricCurrentIntensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abampere(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def ampere_intl_mean(self) -> FieldQnty: ...

    @property
    def A_int_mean(self) -> FieldQnty: ...

    @property
    def ampere_intl_us(self) -> FieldQnty: ...

    @property
    def A_int_US(self) -> FieldQnty: ...

    @property
    def ampere_or_amp(self) -> FieldQnty: ...

    @property
    def A(self) -> FieldQnty: ...

    @property
    def biot(self) -> FieldQnty: ...

    @property
    def statampere(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def u_a_or_current(self) -> FieldQnty: ...

    @property
    def u_a(self) -> FieldQnty: ...


class ElectricDipoleMomentSetter(TypeSafeSetter):
    """ElectricDipoleMoment-specific setter with unit properties."""

    __slots__ = ()

    @property
    def ampere_meter_second(self) -> FieldQnty: ...

    @property
    def A_m_s(self) -> FieldQnty: ...

    @property
    def coulomb_meter(self) -> FieldQnty: ...

    @property
    def C_m(self) -> FieldQnty: ...

    @property
    def debye(self) -> FieldQnty: ...

    @property
    def D(self) -> FieldQnty: ...

    @property
    def electron_meter(self) -> FieldQnty: ...

    @property
    def e_m(self) -> FieldQnty: ...


class ElectricFieldStrengthSetter(TypeSafeSetter):
    """ElectricFieldStrength-specific setter with unit properties."""

    __slots__ = ()

    @property
    def volt_per_centimeter(self) -> FieldQnty: ...

    @property
    def V_cm(self) -> FieldQnty: ...

    @property
    def volt_per_meter(self) -> FieldQnty: ...

    @property
    def V_m(self) -> FieldQnty: ...


class ElectricInductanceSetter(TypeSafeSetter):
    """ElectricInductance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abhenry(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def cm(self) -> FieldQnty: ...

    @property
    def henry(self) -> FieldQnty: ...

    @property
    def H(self) -> FieldQnty: ...

    @property
    def henry_intl_mean(self) -> FieldQnty: ...

    @property
    def H_int_mean(self) -> FieldQnty: ...

    @property
    def henry_intl_us(self) -> FieldQnty: ...

    @property
    def H_int_US(self) -> FieldQnty: ...

    @property
    def mic(self) -> FieldQnty: ...

    @property
    def stathenry(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def millihenry(self) -> FieldQnty: ...

    @property
    def mH(self) -> FieldQnty: ...

    @property
    def microhenry(self) -> FieldQnty: ...

    @property
    def nanohenry(self) -> FieldQnty: ...

    @property
    def nH(self) -> FieldQnty: ...


class ElectricPotentialSetter(TypeSafeSetter):
    """ElectricPotential-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abvolt(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def statvolt(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def u_a_potential(self) -> FieldQnty: ...

    @property
    def u_a(self) -> FieldQnty: ...

    @property
    def volt(self) -> FieldQnty: ...

    @property
    def V(self) -> FieldQnty: ...

    @property
    def volt_intl_mean(self) -> FieldQnty: ...

    @property
    def V_int_mean(self) -> FieldQnty: ...

    @property
    def volt_us(self) -> FieldQnty: ...

    @property
    def V_int_US(self) -> FieldQnty: ...

    @property
    def kilovolt(self) -> FieldQnty: ...

    @property
    def kV(self) -> FieldQnty: ...

    @property
    def millivolt(self) -> FieldQnty: ...

    @property
    def mV(self) -> FieldQnty: ...

    @property
    def microvolt(self) -> FieldQnty: ...

    @property
    def nanovolt(self) -> FieldQnty: ...

    @property
    def nV(self) -> FieldQnty: ...

    @property
    def picovolt(self) -> FieldQnty: ...

    @property
    def pV(self) -> FieldQnty: ...


class ElectricResistanceSetter(TypeSafeSetter):
    """ElectricResistance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abohm(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def jacobi(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...

    @property
    def lenz(self) -> FieldQnty: ...

    @property
    def Metric(self) -> FieldQnty: ...

    @property
    def ohm(self) -> FieldQnty: ...

    @property
    def Omega(self) -> FieldQnty: ...

    @property
    def ohm_intl_mean(self) -> FieldQnty: ...

    @property
    def Omega_int_mean(self) -> FieldQnty: ...

    @property
    def ohm_intl_us(self) -> FieldQnty: ...

    @property
    def Omega_int_US(self) -> FieldQnty: ...

    @property
    def ohm_legal(self) -> FieldQnty: ...

    @property
    def Omega_legal(self) -> FieldQnty: ...

    @property
    def preece(self) -> FieldQnty: ...

    @property
    def statohm(self) -> FieldQnty: ...

    @property
    def csu_cgs(self) -> FieldQnty: ...

    @property
    def wheatstone(self) -> FieldQnty: ...

    @property
    def kiloohm(self) -> FieldQnty: ...

    @property
    def k_Omega(self) -> FieldQnty: ...

    @property
    def megaohm(self) -> FieldQnty: ...

    @property
    def M_Omega(self) -> FieldQnty: ...

    @property
    def milliohm(self) -> FieldQnty: ...

    @property
    def m_Omega(self) -> FieldQnty: ...


class ElectricalConductanceSetter(TypeSafeSetter):
    """ElectricalConductance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def abmho(self) -> FieldQnty: ...

    @property
    def esu_cgs(self) -> FieldQnty: ...

    @property
    def statmho(self) -> FieldQnty: ...

    @property
    def mho(self) -> FieldQnty: ...

    @property
    def microsiemens(self) -> FieldQnty: ...

    @property
    def mu_mathrm_S(self) -> FieldQnty: ...

    @property
    def siemens(self) -> FieldQnty: ...

    @property
    def S(self) -> FieldQnty: ...

    @property
    def millisiemens(self) -> FieldQnty: ...

    @property
    def mS(self) -> FieldQnty: ...


class ElectricalPermittivitySetter(TypeSafeSetter):
    """ElectricalPermittivity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def farad_per_meter(self) -> FieldQnty: ...

    @property
    def F_m(self) -> FieldQnty: ...


class ElectricalResistivitySetter(TypeSafeSetter):
    """ElectricalResistivity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def circular_mil_ohm_per_foot(self) -> FieldQnty: ...

    @property
    def circmil_Omega_mathrm_ft(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def abohm_cm(self) -> FieldQnty: ...

    @property
    def microhm_inch(self) -> FieldQnty: ...

    @property
    def mu_Omega_in(self) -> FieldQnty: ...

    @property
    def ohm_centimeter(self) -> FieldQnty: ...

    @property
    def boldsymbol_Omega_mathbf_c_m(self) -> FieldQnty: ...

    @property
    def ohm_meter(self) -> FieldQnty: ...

    @property
    def Omega_mathrm_m(self) -> FieldQnty: ...


class EnergyFluxSetter(TypeSafeSetter):
    """EnergyFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_mathrm_ft_2_mathrm_hr(self) -> FieldQnty: ...

    @property
    def calorie_per_square_centimeter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_cm_2_mathrm_s_or_mathrm_cal_mathrm_cm_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def cal_cm_2_s(self) -> FieldQnty: ...

    @property
    def celsius_heat_units_chu(self) -> FieldQnty: ...

    @property
    def mathrm_Chu_mathrm_ft_2_mathrm_hr(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_left_mathrm_ft_2_mathrm_hr_right(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_square_meter_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_left_mathrm_m_2_mathrm_hr_right(self) -> FieldQnty: ...

    @property
    def watt_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_W_mathrm_m_2(self) -> FieldQnty: ...


class EnergyHeatWorkSetter(TypeSafeSetter):
    """EnergyHeatWork-specific setter with unit properties."""

    __slots__ = ()

    @property
    def barrel_oil_equivalent_or_equivalent_barrel(self) -> FieldQnty: ...

    @property
    def bboe_or_boe(self) -> FieldQnty: ...

    @property
    def bboe(self) -> FieldQnty: ...

    @property
    def boe(self) -> FieldQnty: ...

    @property
    def billion_electronvolt(self) -> FieldQnty: ...

    @property
    def BeV(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_4circ_mathrmc(self) -> FieldQnty: ...

    @property
    def Btu_39_2_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_60circ_mathrmf(self) -> FieldQnty: ...

    @property
    def Btu_60_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_international_steam_tables(self) -> FieldQnty: ...

    @property
    def Btu_IT(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_isotc_12(self) -> FieldQnty: ...

    @property
    def Btu_ISO(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_mean(self) -> FieldQnty: ...

    @property
    def Btu_mean_or_Btu(self) -> FieldQnty: ...

    @property
    def Btu_mean(self) -> FieldQnty: ...

    @property
    def Btu(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_thermochemical(self) -> FieldQnty: ...

    @property
    def Btu_therm(self) -> FieldQnty: ...

    @property
    def calorie_20circ_mathrmc(self) -> FieldQnty: ...

    @property
    def cal_20_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def calorie_4circ_mathrmc(self) -> FieldQnty: ...

    @property
    def cal_4_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def calorie_international_steam_tables(self) -> FieldQnty: ...

    @property
    def cal_IT(self) -> FieldQnty: ...

    @property
    def calorie_mean(self) -> FieldQnty: ...

    @property
    def cal_mean(self) -> FieldQnty: ...

    @property
    def calorie_nutritional(self) -> FieldQnty: ...

    @property
    def Cal_nutr(self) -> FieldQnty: ...

    @property
    def calorie_thermochemical(self) -> FieldQnty: ...

    @property
    def cal_therm(self) -> FieldQnty: ...

    @property
    def celsius_heat_unit(self) -> FieldQnty: ...

    @property
    def Chu(self) -> FieldQnty: ...

    @property
    def celsius_heat_unit_15_circ_mathrmc(self) -> FieldQnty: ...

    @property
    def Chu_15_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def electron_volt(self) -> FieldQnty: ...

    @property
    def eV(self) -> FieldQnty: ...

    @property
    def erg(self) -> FieldQnty: ...

    @property
    def foot_pound_force_duty(self) -> FieldQnty: ...

    @property
    def ft_mathrm_lb_mathrm_f(self) -> FieldQnty: ...

    @property
    def foot_poundal(self) -> FieldQnty: ...

    @property
    def ft_pdl(self) -> FieldQnty: ...

    @property
    def frigorie(self) -> FieldQnty: ...

    @property
    def fg(self) -> FieldQnty: ...

    @property
    def hartree_atomic_unit_of_energy(self) -> FieldQnty: ...

    @property
    def mathrm_E_mathrm_H_a_u(self) -> FieldQnty: ...

    @property
    def joule(self) -> FieldQnty: ...

    @property
    def J(self) -> FieldQnty: ...

    @property
    def joule_international(self) -> FieldQnty: ...

    @property
    def J_intl(self) -> FieldQnty: ...

    @property
    def kilocalorie_thermal(self) -> FieldQnty: ...

    @property
    def kcal_therm(self) -> FieldQnty: ...

    @property
    def kilogram_force_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_m(self) -> FieldQnty: ...

    @property
    def kiloton_tnt(self) -> FieldQnty: ...

    @property
    def kt_TNT(self) -> FieldQnty: ...

    @property
    def kilowatt_hour(self) -> FieldQnty: ...

    @property
    def kWh(self) -> FieldQnty: ...

    @property
    def liter_atmosphere(self) -> FieldQnty: ...

    @property
    def L_atm(self) -> FieldQnty: ...

    @property
    def megaton_tnt(self) -> FieldQnty: ...

    @property
    def Mt_TNT(self) -> FieldQnty: ...

    @property
    def pound_centigrade_unit_15circ_mathrmc(self) -> FieldQnty: ...

    @property
    def pcu_15_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def prout(self) -> FieldQnty: ...

    @property
    def q_unit(self) -> FieldQnty: ...

    @property
    def Q(self) -> FieldQnty: ...

    @property
    def quad_quadrillion_btu(self) -> FieldQnty: ...

    @property
    def quad(self) -> FieldQnty: ...

    @property
    def rydberg(self) -> FieldQnty: ...

    @property
    def Ry(self) -> FieldQnty: ...

    @property
    def therm_eeg(self) -> FieldQnty: ...

    @property
    def therm_EEG(self) -> FieldQnty: ...

    @property
    def therm_refineries(self) -> FieldQnty: ...

    @property
    def therm_refy_or_therm(self) -> FieldQnty: ...

    @property
    def therm_refy(self) -> FieldQnty: ...

    @property
    def therm(self) -> FieldQnty: ...

    @property
    def therm_us(self) -> FieldQnty: ...

    @property
    def therm_US_or_therm(self) -> FieldQnty: ...

    @property
    def ton_coal_equivalent(self) -> FieldQnty: ...

    @property
    def tce_tec(self) -> FieldQnty: ...

    @property
    def ton_oil_equivalent(self) -> FieldQnty: ...

    @property
    def toe_tep(self) -> FieldQnty: ...

    @property
    def kilojoule(self) -> FieldQnty: ...

    @property
    def kJ(self) -> FieldQnty: ...

    @property
    def megajoule(self) -> FieldQnty: ...

    @property
    def MJ(self) -> FieldQnty: ...

    @property
    def gigajoule(self) -> FieldQnty: ...

    @property
    def GJ(self) -> FieldQnty: ...


class EnergyPerUnitAreaSetter(TypeSafeSetter):
    """EnergyPerUnitArea-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_square_foot(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_mathrm_ft_2_or_Btu_sq_ft(self) -> FieldQnty: ...

    @property
    def Btu_ft_2(self) -> FieldQnty: ...

    @property
    def Btu_sq_ft(self) -> FieldQnty: ...

    @property
    def joule_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_J_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def langley(self) -> FieldQnty: ...

    @property
    def Ly(self) -> FieldQnty: ...


class ForceSetter(TypeSafeSetter):
    """Force-specific setter with unit properties."""

    __slots__ = ()

    @property
    def crinal(self) -> FieldQnty: ...

    @property
    def dyne(self) -> FieldQnty: ...

    @property
    def dyn(self) -> FieldQnty: ...

    @property
    def funal(self) -> FieldQnty: ...

    @property
    def kilogram_force(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f(self) -> FieldQnty: ...

    @property
    def kip_force(self) -> FieldQnty: ...

    @property
    def operatorname_kip_mathrm_f(self) -> FieldQnty: ...

    @property
    def newton(self) -> FieldQnty: ...

    @property
    def N(self) -> FieldQnty: ...

    @property
    def ounce_force(self) -> FieldQnty: ...

    @property
    def mathrm_oz_mathrm_f_or_oz(self) -> FieldQnty: ...

    @property
    def oz_f(self) -> FieldQnty: ...

    @property
    def oz(self) -> FieldQnty: ...

    @property
    def pond(self) -> FieldQnty: ...

    @property
    def p(self) -> FieldQnty: ...

    @property
    def pound_force(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_or_lb(self) -> FieldQnty: ...

    @property
    def lb_f(self) -> FieldQnty: ...

    @property
    def lb(self) -> FieldQnty: ...

    @property
    def poundal(self) -> FieldQnty: ...

    @property
    def pdl(self) -> FieldQnty: ...

    @property
    def slug_force(self) -> FieldQnty: ...

    @property
    def operatorname_slug_f(self) -> FieldQnty: ...

    @property
    def sth_ne(self) -> FieldQnty: ...

    @property
    def sn(self) -> FieldQnty: ...

    @property
    def ton_force_long(self) -> FieldQnty: ...

    @property
    def LT(self) -> FieldQnty: ...

    @property
    def ton_force_metric(self) -> FieldQnty: ...

    @property
    def MT(self) -> FieldQnty: ...

    @property
    def ton_force_short(self) -> FieldQnty: ...

    @property
    def T(self) -> FieldQnty: ...

    @property
    def kilonewton(self) -> FieldQnty: ...

    @property
    def kN(self) -> FieldQnty: ...

    @property
    def millinewton(self) -> FieldQnty: ...

    @property
    def mN(self) -> FieldQnty: ...


class ForceBodySetter(TypeSafeSetter):
    """ForceBody-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dyne_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_cc_or_dyn_mathrm_cm_3(self) -> FieldQnty: ...

    @property
    def dyn_cc(self) -> FieldQnty: ...

    @property
    def dyn_cm_3(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_3(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def newton_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_N_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def pound_force_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_cft(self) -> FieldQnty: ...

    @property
    def pound_force_per_cubic_inch(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_cu_mathrm_in(self) -> FieldQnty: ...

    @property
    def ton_force_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def ton_mathrm_f_mathrm_cft(self) -> FieldQnty: ...


class ForcePerUnitMassSetter(TypeSafeSetter):
    """ForcePerUnitMass-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dyne_per_gram(self) -> FieldQnty: ...

    @property
    def dyn_g(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_kg(self) -> FieldQnty: ...

    @property
    def newton_per_kilogram(self) -> FieldQnty: ...

    @property
    def N_kg(self) -> FieldQnty: ...

    @property
    def pound_force_per_pound_mass(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_lb_or_mathrm_lb_mathrm_f_mathrm_lb_mathrm_m(self) -> FieldQnty: ...

    @property
    def lb_f_lb(self) -> FieldQnty: ...

    @property
    def lb_f_lb_m(self) -> FieldQnty: ...

    @property
    def pound_force_per_slug(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_slug(self) -> FieldQnty: ...


class FrequencyVoltageRatioSetter(TypeSafeSetter):
    """FrequencyVoltageRatio-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cycles_per_second_per_volt(self) -> FieldQnty: ...

    @property
    def cycle_sec_V(self) -> FieldQnty: ...

    @property
    def hertz_per_volt(self) -> FieldQnty: ...

    @property
    def Hz_V(self) -> FieldQnty: ...

    @property
    def terahertz_per_volt(self) -> FieldQnty: ...

    @property
    def THz_V(self) -> FieldQnty: ...


class FuelConsumptionSetter(TypeSafeSetter):
    """FuelConsumption-specific setter with unit properties."""

    __slots__ = ()

    @property
    def unit_100_km_per_liter(self) -> FieldQnty: ...

    @property
    def gallons_uk(self) -> FieldQnty: ...

    @property
    def gal_UK_100_mi(self) -> FieldQnty: ...

    @property
    def gallons_us(self) -> FieldQnty: ...

    @property
    def gal_US_100_mi(self) -> FieldQnty: ...

    @property
    def kilometers_per_gallon_uk(self) -> FieldQnty: ...

    @property
    def km_gal_UK(self) -> FieldQnty: ...

    @property
    def kilometers_per_gallon_us(self) -> FieldQnty: ...

    @property
    def km_gal_US(self) -> FieldQnty: ...

    @property
    def kilometers_per_liter(self) -> FieldQnty: ...

    @property
    def km_l(self) -> FieldQnty: ...

    @property
    def liters_per_100_km(self) -> FieldQnty: ...

    @property
    def liters_per_kilometer(self) -> FieldQnty: ...

    @property
    def unit_1_km(self) -> FieldQnty: ...

    @property
    def meters_per_gallon_uk(self) -> FieldQnty: ...

    @property
    def m_gal_UK(self) -> FieldQnty: ...

    @property
    def meters_per_gallon_us(self) -> FieldQnty: ...

    @property
    def unit_1_gal_US(self) -> FieldQnty: ...

    @property
    def miles_per_gallon_uk(self) -> FieldQnty: ...

    @property
    def mi_gal_UK_or_mpg_UK(self) -> FieldQnty: ...

    @property
    def mi_gal_UK(self) -> FieldQnty: ...

    @property
    def mpg_UK(self) -> FieldQnty: ...

    @property
    def miles_per_gallon_us(self) -> FieldQnty: ...

    @property
    def mi_gal_US_or_mpg_US(self) -> FieldQnty: ...

    @property
    def mi_gal_US(self) -> FieldQnty: ...

    @property
    def mpg_US(self) -> FieldQnty: ...

    @property
    def miles_per_liter(self) -> FieldQnty: ...

    @property
    def mi_l(self) -> FieldQnty: ...


class HeatOfCombustionSetter(TypeSafeSetter):
    """HeatOfCombustion-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_pound(self) -> FieldQnty: ...

    @property
    def Btu_lb(self) -> FieldQnty: ...

    @property
    def calorie_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_g(self) -> FieldQnty: ...

    @property
    def chu_per_pound(self) -> FieldQnty: ...

    @property
    def Chu_lb(self) -> FieldQnty: ...

    @property
    def joule_per_kilogram(self) -> FieldQnty: ...

    @property
    def J_kg(self) -> FieldQnty: ...


class HeatOfFusionSetter(TypeSafeSetter):
    """HeatOfFusion-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_mean(self) -> FieldQnty: ...

    @property
    def Btu_mean_lb(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_per_pound(self) -> FieldQnty: ...

    @property
    def Btu_lb(self) -> FieldQnty: ...

    @property
    def calorie_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_g(self) -> FieldQnty: ...

    @property
    def chu_per_pound(self) -> FieldQnty: ...

    @property
    def Chu_lb(self) -> FieldQnty: ...

    @property
    def joule_per_kilogram(self) -> FieldQnty: ...

    @property
    def J_kg(self) -> FieldQnty: ...


class HeatOfVaporizationSetter(TypeSafeSetter):
    """HeatOfVaporization-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_pound(self) -> FieldQnty: ...

    @property
    def Btu_lb(self) -> FieldQnty: ...

    @property
    def calorie_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_g(self) -> FieldQnty: ...

    @property
    def chu_per_pound(self) -> FieldQnty: ...

    @property
    def Chu_lb(self) -> FieldQnty: ...

    @property
    def joule_per_kilogram(self) -> FieldQnty: ...

    @property
    def J_kg(self) -> FieldQnty: ...


class HeatTransferCoefficientSetter(TypeSafeSetter):
    """HeatTransferCoefficient-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_per_square_foot_per_hour_per_degree_fahrenheit_or_rankine(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_left_mathrm_ft_2_mathrm_h_circ_mathrm_F_right(self) -> FieldQnty: ...

    @property
    def watt_per_square_meter_per_degree_celsius_or_kelvin(self) -> FieldQnty: ...

    @property
    def mathrm_W_left_mathrm_m_2_circ_mathrm_C_right(self) -> FieldQnty: ...


class IlluminanceSetter(TypeSafeSetter):
    """Illuminance-specific setter with unit properties."""

    __slots__ = ()

    @property
    def foot_candle(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_C_or_mathrm_ft_mathrm_Cd(self) -> FieldQnty: ...

    @property
    def ft_C(self) -> FieldQnty: ...

    @property
    def ft_Cd(self) -> FieldQnty: ...

    @property
    def lux(self) -> FieldQnty: ...

    @property
    def lx(self) -> FieldQnty: ...

    @property
    def nox(self) -> FieldQnty: ...

    @property
    def phot(self) -> FieldQnty: ...

    @property
    def ph(self) -> FieldQnty: ...

    @property
    def skot(self) -> FieldQnty: ...


class KineticEnergyOfTurbulenceSetter(TypeSafeSetter):
    """KineticEnergyOfTurbulence-specific setter with unit properties."""

    __slots__ = ()

    @property
    def square_foot_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_s_2_or_sqft_sec_2(self) -> FieldQnty: ...

    @property
    def ft_2_s_2(self) -> FieldQnty: ...

    @property
    def sqft_sec_2(self) -> FieldQnty: ...

    @property
    def square_meters_per_second_squared(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_s_2(self) -> FieldQnty: ...


class LengthSetter(TypeSafeSetter):
    """Length-specific setter with unit properties."""

    __slots__ = ()

    @property
    def ngstr_m(self) -> FieldQnty: ...

    @property
    def AA(self) -> FieldQnty: ...

    @property
    def arpent_quebec(self) -> FieldQnty: ...

    @property
    def arp(self) -> FieldQnty: ...

    @property
    def astronomic_unit(self) -> FieldQnty: ...

    @property
    def AU(self) -> FieldQnty: ...

    @property
    def attometer(self) -> FieldQnty: ...

    @property
    def am(self) -> FieldQnty: ...

    @property
    def calibre_centinch(self) -> FieldQnty: ...

    @property
    def cin(self) -> FieldQnty: ...

    @property
    def centimeter(self) -> FieldQnty: ...

    @property
    def cm(self) -> FieldQnty: ...

    @property
    def chain_engrs_or_ramsden(self) -> FieldQnty: ...

    @property
    def ch_eng_or_Rams(self) -> FieldQnty: ...

    @property
    def ch_eng(self) -> FieldQnty: ...

    @property
    def Rams(self) -> FieldQnty: ...

    @property
    def chain_gunters(self) -> FieldQnty: ...

    @property
    def ch_Gunt(self) -> FieldQnty: ...

    @property
    def chain_surveyors(self) -> FieldQnty: ...

    @property
    def ch_surv(self) -> FieldQnty: ...

    @property
    def cubit_uk(self) -> FieldQnty: ...

    @property
    def cu_UK(self) -> FieldQnty: ...

    @property
    def ell(self) -> FieldQnty: ...

    @property
    def fathom(self) -> FieldQnty: ...

    @property
    def fath(self) -> FieldQnty: ...

    @property
    def femtometre(self) -> FieldQnty: ...

    @property
    def fm(self) -> FieldQnty: ...

    @property
    def fermi(self) -> FieldQnty: ...

    @property
    def F(self) -> FieldQnty: ...

    @property
    def foot(self) -> FieldQnty: ...

    @property
    def ft(self) -> FieldQnty: ...

    @property
    def furlong_uk_and_us(self) -> FieldQnty: ...

    @property
    def fur(self) -> FieldQnty: ...

    @property
    def inch(self) -> FieldQnty: ...

    @property
    def in_unit(self) -> FieldQnty: ...

    @property
    def kilometer(self) -> FieldQnty: ...

    @property
    def km(self) -> FieldQnty: ...

    @property
    def league_us_statute(self) -> FieldQnty: ...

    @property
    def lg_US_stat(self) -> FieldQnty: ...

    @property
    def lieue_metric(self) -> FieldQnty: ...

    @property
    def ligne_metric(self) -> FieldQnty: ...

    @property
    def line_us(self) -> FieldQnty: ...

    @property
    def li_US(self) -> FieldQnty: ...

    @property
    def link_surveyors(self) -> FieldQnty: ...

    @property
    def li_surv(self) -> FieldQnty: ...

    @property
    def meter(self) -> FieldQnty: ...

    @property
    def m(self) -> FieldQnty: ...

    @property
    def micrometer(self) -> FieldQnty: ...

    @property
    def mu_mathrm_m(self) -> FieldQnty: ...

    @property
    def micron(self) -> FieldQnty: ...

    @property
    def mu(self) -> FieldQnty: ...

    @property
    def mil(self) -> FieldQnty: ...

    @property
    def mile_geographical(self) -> FieldQnty: ...

    @property
    def mi(self) -> FieldQnty: ...

    @property
    def mile_us_nautical(self) -> FieldQnty: ...

    @property
    def mi_US_naut(self) -> FieldQnty: ...

    @property
    def mile_us_statute(self) -> FieldQnty: ...

    @property
    def mile_us_survey(self) -> FieldQnty: ...

    @property
    def mi_US_surv(self) -> FieldQnty: ...

    @property
    def millimeter(self) -> FieldQnty: ...

    @property
    def mm(self) -> FieldQnty: ...

    @property
    def millimicron(self) -> FieldQnty: ...

    @property
    def mathrm_m_mu(self) -> FieldQnty: ...

    @property
    def nanometer_or_nanon(self) -> FieldQnty: ...

    @property
    def nm(self) -> FieldQnty: ...

    @property
    def parsec(self) -> FieldQnty: ...

    @property
    def pc(self) -> FieldQnty: ...

    @property
    def perche(self) -> FieldQnty: ...

    @property
    def rod(self) -> FieldQnty: ...

    @property
    def pica(self) -> FieldQnty: ...

    @property
    def picometer(self) -> FieldQnty: ...

    @property
    def pm(self) -> FieldQnty: ...

    @property
    def point_didot(self) -> FieldQnty: ...

    @property
    def pt_Didot(self) -> FieldQnty: ...

    @property
    def point_us(self) -> FieldQnty: ...

    @property
    def pt_US(self) -> FieldQnty: ...

    @property
    def rod_or_pole(self) -> FieldQnty: ...

    @property
    def span(self) -> FieldQnty: ...

    @property
    def thou_millinch(self) -> FieldQnty: ...

    @property
    def thou(self) -> FieldQnty: ...

    @property
    def toise_metric(self) -> FieldQnty: ...

    @property
    def yard(self) -> FieldQnty: ...

    @property
    def yd(self) -> FieldQnty: ...

    @property
    def nanometer(self) -> FieldQnty: ...


class LinearMassDensitySetter(TypeSafeSetter):
    """LinearMassDensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def denier(self) -> FieldQnty: ...

    @property
    def kilogram_per_centimeter(self) -> FieldQnty: ...

    @property
    def kg_cm(self) -> FieldQnty: ...

    @property
    def kilogram_per_meter(self) -> FieldQnty: ...

    @property
    def kg_m(self) -> FieldQnty: ...

    @property
    def pound_per_foot(self) -> FieldQnty: ...

    @property
    def lb_ft(self) -> FieldQnty: ...

    @property
    def pound_per_inch(self) -> FieldQnty: ...

    @property
    def lb_in(self) -> FieldQnty: ...

    @property
    def pound_per_yard(self) -> FieldQnty: ...

    @property
    def lb_yd(self) -> FieldQnty: ...

    @property
    def ton_metric(self) -> FieldQnty: ...

    @property
    def t_km_or_MT_km(self) -> FieldQnty: ...

    @property
    def t_km(self) -> FieldQnty: ...

    @property
    def MT_km(self) -> FieldQnty: ...


class LinearMomentumSetter(TypeSafeSetter):
    """LinearMomentum-specific setter with unit properties."""

    __slots__ = ()

    @property
    def foot_pounds_force_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_h_or_mathrm_ft_mathrm_lb_mathrm_hr(self) -> FieldQnty: ...

    @property
    def ft_lb_f_h(self) -> FieldQnty: ...

    @property
    def ft_lb_hr(self) -> FieldQnty: ...

    @property
    def foot_pounds_force_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min_or_mathrm_ft_mathrm_lb_min(self) -> FieldQnty: ...

    @property
    def ft_lb_f_min(self) -> FieldQnty: ...

    @property
    def ft_lb_min(self) -> FieldQnty: ...

    @property
    def foot_pounds_force_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s_or_ft_lb_sec(self) -> FieldQnty: ...

    @property
    def ft_lb_f_s(self) -> FieldQnty: ...

    @property
    def ft_lb_sec(self) -> FieldQnty: ...

    @property
    def gram_centimeters_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_mathrm_s(self) -> FieldQnty: ...

    @property
    def kilogram_meters_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_mathrm_s(self) -> FieldQnty: ...


class LuminanceSelfSetter(TypeSafeSetter):
    """LuminanceSelf-specific setter with unit properties."""

    __slots__ = ()

    @property
    def apostilb(self) -> FieldQnty: ...

    @property
    def asb(self) -> FieldQnty: ...

    @property
    def blondel(self) -> FieldQnty: ...

    @property
    def B1(self) -> FieldQnty: ...

    @property
    def candela_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_cd_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def foot_lambert(self) -> FieldQnty: ...

    @property
    def ft_L(self) -> FieldQnty: ...

    @property
    def lambert(self) -> FieldQnty: ...

    @property
    def L(self) -> FieldQnty: ...

    @property
    def luxon(self) -> FieldQnty: ...

    @property
    def nit(self) -> FieldQnty: ...

    @property
    def stilb(self) -> FieldQnty: ...

    @property
    def sb(self) -> FieldQnty: ...

    @property
    def troland(self) -> FieldQnty: ...


class LuminousFluxSetter(TypeSafeSetter):
    """LuminousFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def candela_steradian(self) -> FieldQnty: ...

    @property
    def cd_sr(self) -> FieldQnty: ...

    @property
    def lumen(self) -> FieldQnty: ...


class LuminousIntensitySetter(TypeSafeSetter):
    """LuminousIntensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def candela(self) -> FieldQnty: ...

    @property
    def cd(self) -> FieldQnty: ...

    @property
    def candle_international(self) -> FieldQnty: ...

    @property
    def Cd_int(self) -> FieldQnty: ...

    @property
    def carcel(self) -> FieldQnty: ...

    @property
    def hefner_unit(self) -> FieldQnty: ...

    @property
    def HK(self) -> FieldQnty: ...


class MagneticFieldSetter(TypeSafeSetter):
    """MagneticField-specific setter with unit properties."""

    __slots__ = ()

    @property
    def ampere_per_meter(self) -> FieldQnty: ...

    @property
    def A_m(self) -> FieldQnty: ...

    @property
    def lenz(self) -> FieldQnty: ...

    @property
    def oersted(self) -> FieldQnty: ...

    @property
    def Oe(self) -> FieldQnty: ...

    @property
    def praoersted(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...


class MagneticFluxSetter(TypeSafeSetter):
    """MagneticFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def kapp_line(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...

    @property
    def line(self) -> FieldQnty: ...

    @property
    def maxwell(self) -> FieldQnty: ...

    @property
    def Mx(self) -> FieldQnty: ...

    @property
    def unit_pole(self) -> FieldQnty: ...

    @property
    def weber(self) -> FieldQnty: ...

    @property
    def Wb(self) -> FieldQnty: ...

    @property
    def milliweber(self) -> FieldQnty: ...

    @property
    def mWb(self) -> FieldQnty: ...

    @property
    def microweber(self) -> FieldQnty: ...


class MagneticInductionFieldStrengthSetter(TypeSafeSetter):
    """MagneticInductionFieldStrength-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gamma(self) -> FieldQnty: ...

    @property
    def gauss(self) -> FieldQnty: ...

    @property
    def G(self) -> FieldQnty: ...

    @property
    def line_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def line_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def maxwell_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_Mx_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def tesla(self) -> FieldQnty: ...

    @property
    def T(self) -> FieldQnty: ...

    @property
    def u_a(self) -> FieldQnty: ...

    @property
    def weber_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_Wb_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def millitesla(self) -> FieldQnty: ...

    @property
    def mT(self) -> FieldQnty: ...

    @property
    def microtesla(self) -> FieldQnty: ...

    @property
    def nanotesla(self) -> FieldQnty: ...

    @property
    def nT(self) -> FieldQnty: ...


class MagneticMomentSetter(TypeSafeSetter):
    """MagneticMoment-specific setter with unit properties."""

    __slots__ = ()

    @property
    def bohr_magneton(self) -> FieldQnty: ...

    @property
    def Bohr_magneton(self) -> FieldQnty: ...

    @property
    def joule_per_tesla(self) -> FieldQnty: ...

    @property
    def J_T(self) -> FieldQnty: ...

    @property
    def nuclear_magneton(self) -> FieldQnty: ...

    @property
    def nucl_Magneton(self) -> FieldQnty: ...


class MagneticPermeabilitySetter(TypeSafeSetter):
    """MagneticPermeability-specific setter with unit properties."""

    __slots__ = ()

    @property
    def henrys_per_meter(self) -> FieldQnty: ...

    @property
    def H_m(self) -> FieldQnty: ...

    @property
    def newton_per_square_ampere(self) -> FieldQnty: ...

    @property
    def N_A_2(self) -> FieldQnty: ...


class MagnetomotiveForceSetter(TypeSafeSetter):
    """MagnetomotiveForce-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abampere_turn(self) -> FieldQnty: ...

    @property
    def emu_cgs(self) -> FieldQnty: ...

    @property
    def ampere(self) -> FieldQnty: ...

    @property
    def A(self) -> FieldQnty: ...

    @property
    def ampere_turn(self) -> FieldQnty: ...

    @property
    def A_turn(self) -> FieldQnty: ...

    @property
    def gilbert(self) -> FieldQnty: ...

    @property
    def Gb(self) -> FieldQnty: ...

    @property
    def kiloampere(self) -> FieldQnty: ...

    @property
    def kA(self) -> FieldQnty: ...

    @property
    def milliampere(self) -> FieldQnty: ...

    @property
    def mA(self) -> FieldQnty: ...

    @property
    def microampere(self) -> FieldQnty: ...

    @property
    def nanoampere(self) -> FieldQnty: ...

    @property
    def nA(self) -> FieldQnty: ...

    @property
    def picoampere(self) -> FieldQnty: ...

    @property
    def pA(self) -> FieldQnty: ...


class MassSetter(TypeSafeSetter):
    """Mass-specific setter with unit properties."""

    __slots__ = ()

    @property
    def slug(self) -> FieldQnty: ...

    @property
    def sl(self) -> FieldQnty: ...

    @property
    def atomic_mass_unit_12_mathrmc(self) -> FieldQnty: ...

    @property
    def mathrm_u_left_12_mathrm_C_right_or_amu(self) -> FieldQnty: ...

    @property
    def uleft_12_Cright(self) -> FieldQnty: ...

    @property
    def amu(self) -> FieldQnty: ...

    @property
    def carat_metric(self) -> FieldQnty: ...

    @property
    def ct(self) -> FieldQnty: ...

    @property
    def cental(self) -> FieldQnty: ...

    @property
    def sh_cwt_cH(self) -> FieldQnty: ...

    @property
    def centigram(self) -> FieldQnty: ...

    @property
    def cg(self) -> FieldQnty: ...

    @property
    def clove_uk(self) -> FieldQnty: ...

    @property
    def cl(self) -> FieldQnty: ...

    @property
    def drachm_apothecary(self) -> FieldQnty: ...

    @property
    def dr_ap(self) -> FieldQnty: ...

    @property
    def dram_avoirdupois(self) -> FieldQnty: ...

    @property
    def dr_av(self) -> FieldQnty: ...

    @property
    def dram_troy(self) -> FieldQnty: ...

    @property
    def dr_troy(self) -> FieldQnty: ...

    @property
    def grain(self) -> FieldQnty: ...

    @property
    def gr(self) -> FieldQnty: ...

    @property
    def gram(self) -> FieldQnty: ...

    @property
    def g(self) -> FieldQnty: ...

    @property
    def hundredweight_long_or_gross(self) -> FieldQnty: ...

    @property
    def cwt_lg_cwt(self) -> FieldQnty: ...

    @property
    def hundredweight_short_or_net(self) -> FieldQnty: ...

    @property
    def sh_cwt(self) -> FieldQnty: ...

    @property
    def kilogram(self) -> FieldQnty: ...

    @property
    def kg(self) -> FieldQnty: ...

    @property
    def kip(self) -> FieldQnty: ...

    @property
    def microgram(self) -> FieldQnty: ...

    @property
    def mu_mathrm_g(self) -> FieldQnty: ...

    @property
    def milligram(self) -> FieldQnty: ...

    @property
    def mg(self) -> FieldQnty: ...

    @property
    def ounce_apothecary(self) -> FieldQnty: ...

    @property
    def oz_ap(self) -> FieldQnty: ...

    @property
    def ounce_avoirdupois(self) -> FieldQnty: ...

    @property
    def oz(self) -> FieldQnty: ...

    @property
    def ounce_troy(self) -> FieldQnty: ...

    @property
    def oz_troy(self) -> FieldQnty: ...

    @property
    def pennyweight_troy(self) -> FieldQnty: ...

    @property
    def dwt_troy(self) -> FieldQnty: ...

    @property
    def pood_russia(self) -> FieldQnty: ...

    @property
    def pood(self) -> FieldQnty: ...

    @property
    def pound_apothecary(self) -> FieldQnty: ...

    @property
    def lb_ap(self) -> FieldQnty: ...

    @property
    def pound_avoirdupois(self) -> FieldQnty: ...

    @property
    def lb_av(self) -> FieldQnty: ...

    @property
    def pound_troy(self) -> FieldQnty: ...

    @property
    def lb_troy(self) -> FieldQnty: ...

    @property
    def pound_mass(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_m(self) -> FieldQnty: ...

    @property
    def quarter_uk(self) -> FieldQnty: ...

    @property
    def qt(self) -> FieldQnty: ...

    @property
    def quintal_metric(self) -> FieldQnty: ...

    @property
    def q_dt(self) -> FieldQnty: ...

    @property
    def quital_us(self) -> FieldQnty: ...

    @property
    def quint_US(self) -> FieldQnty: ...

    @property
    def scruple_avoirdupois(self) -> FieldQnty: ...

    @property
    def scf(self) -> FieldQnty: ...

    @property
    def stone_uk(self) -> FieldQnty: ...

    @property
    def st(self) -> FieldQnty: ...

    @property
    def ton_metric(self) -> FieldQnty: ...

    @property
    def t(self) -> FieldQnty: ...

    @property
    def ton_us_long(self) -> FieldQnty: ...

    @property
    def lg_ton(self) -> FieldQnty: ...

    @property
    def ton_us_short(self) -> FieldQnty: ...

    @property
    def sh_ton(self) -> FieldQnty: ...


class MassDensitySetter(TypeSafeSetter):
    """MassDensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def g_cc_or_g_ml(self) -> FieldQnty: ...

    @property
    def g_cc(self) -> FieldQnty: ...

    @property
    def g_ml(self) -> FieldQnty: ...

    @property
    def gram_per_cubic_decimeter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_dm_3(self) -> FieldQnty: ...

    @property
    def gram_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def gram_per_liter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_l_or_g_L(self) -> FieldQnty: ...

    @property
    def g_l(self) -> FieldQnty: ...

    @property
    def g_L(self) -> FieldQnty: ...

    @property
    def kilogram_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def ounce_avdp(self) -> FieldQnty: ...

    @property
    def oz_gal(self) -> FieldQnty: ...

    @property
    def pound_avdp(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_cu_mathrm_ft_or_lb_ft_3(self) -> FieldQnty: ...

    @property
    def lb_cu_ft(self) -> FieldQnty: ...

    @property
    def lb_ft_3(self) -> FieldQnty: ...

    @property
    def pound_mass(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_cu_in_or_mathrm_lb_mathrm_in_3(self) -> FieldQnty: ...

    @property
    def lb_cu_in(self) -> FieldQnty: ...

    @property
    def lb_in_3(self) -> FieldQnty: ...

    @property
    def ton_metric(self) -> FieldQnty: ...

    @property
    def mathrm_t_mathrm_m_3_or_MT_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def t_m_3(self) -> FieldQnty: ...

    @property
    def MT_m_3(self) -> FieldQnty: ...


class MassFlowRateSetter(TypeSafeSetter):
    """MassFlowRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def kilograms_per_day(self) -> FieldQnty: ...

    @property
    def kg_d(self) -> FieldQnty: ...

    @property
    def kilograms_per_hour(self) -> FieldQnty: ...

    @property
    def kg_h(self) -> FieldQnty: ...

    @property
    def kilograms_per_minute(self) -> FieldQnty: ...

    @property
    def kg_min(self) -> FieldQnty: ...

    @property
    def kilograms_per_second(self) -> FieldQnty: ...

    @property
    def kg_s(self) -> FieldQnty: ...

    @property
    def metric_tons_per_day(self) -> FieldQnty: ...

    @property
    def MT_d_or_MTD(self) -> FieldQnty: ...

    @property
    def MT_d(self) -> FieldQnty: ...

    @property
    def MTD(self) -> FieldQnty: ...

    @property
    def metric_tons_per_hour(self) -> FieldQnty: ...

    @property
    def MT_h_or_MTD(self) -> FieldQnty: ...

    @property
    def MT_h(self) -> FieldQnty: ...

    @property
    def metric_tons_per_minute(self) -> FieldQnty: ...

    @property
    def metric_tons_per_second(self) -> FieldQnty: ...

    @property
    def MT_s(self) -> FieldQnty: ...

    @property
    def metric_tons_per_year_365_d(self) -> FieldQnty: ...

    @property
    def MT_yr_or_MTY(self) -> FieldQnty: ...

    @property
    def MT_yr(self) -> FieldQnty: ...

    @property
    def MTY(self) -> FieldQnty: ...

    @property
    def pounds_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_d_or_mathrm_lb_mathrm_da_or_PPD(self) -> FieldQnty: ...

    @property
    def lb_d(self) -> FieldQnty: ...

    @property
    def lb_da(self) -> FieldQnty: ...

    @property
    def PPD(self) -> FieldQnty: ...

    @property
    def pounds_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_h_or_lb_hr_or_PPH(self) -> FieldQnty: ...

    @property
    def lb_h(self) -> FieldQnty: ...

    @property
    def lb_hr(self) -> FieldQnty: ...

    @property
    def PPH(self) -> FieldQnty: ...

    @property
    def pounds_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_min_or_PPM(self) -> FieldQnty: ...

    @property
    def lb_min(self) -> FieldQnty: ...

    @property
    def PPM(self) -> FieldQnty: ...

    @property
    def pounds_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_s_or_lb_sec_or_PPS(self) -> FieldQnty: ...

    @property
    def lb_s(self) -> FieldQnty: ...

    @property
    def lb_sec(self) -> FieldQnty: ...

    @property
    def PPS(self) -> FieldQnty: ...


class MassFluxSetter(TypeSafeSetter):
    """MassFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def kilogram_per_square_meter_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_d_right(self) -> FieldQnty: ...

    @property
    def kilogram_per_square_meter_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_h_right(self) -> FieldQnty: ...

    @property
    def kilogram_per_square_meter_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_min_right(self) -> FieldQnty: ...

    @property
    def kilogram_per_square_meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_left_mathrm_m_2_mathrm_s_right(self) -> FieldQnty: ...

    @property
    def pound_per_square_foot_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_d_right_or_lb_sqft_da(self) -> FieldQnty: ...

    @property
    def lb_left_ft_2_dright(self) -> FieldQnty: ...

    @property
    def lb_sqft_da(self) -> FieldQnty: ...

    @property
    def pound_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_h_right_or_lb_sqft_hr(self) -> FieldQnty: ...

    @property
    def lb_left_ft_2_hright(self) -> FieldQnty: ...

    @property
    def lb_sqft_hr(self) -> FieldQnty: ...

    @property
    def pound_per_square_foot_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_ft_2_min_right_or_lb_sqft_min(self) -> FieldQnty: ...

    @property
    def lb_left_ft_2_min_right(self) -> FieldQnty: ...

    @property
    def lb_sqft_min(self) -> FieldQnty: ...

    @property
    def pound_per_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> FieldQnty: ...

    @property
    def lb_left_ft_2_sright(self) -> FieldQnty: ...

    @property
    def lb_sqft_sec(self) -> FieldQnty: ...


class MassFractionOfISetter(TypeSafeSetter):
    """MassFractionOfI-specific setter with unit properties."""

    __slots__ = ()

    @property
    def grains_of_i_per_pound_total(self) -> FieldQnty: ...

    @property
    def mathrm_gr_mathrm_i_mathrm_lb(self) -> FieldQnty: ...

    @property
    def gram_of_i_per_kilogram_total(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_i_mathrm_kg(self) -> FieldQnty: ...

    @property
    def kilogram_of_i_per_kilogram_total(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_i_mathrm_kg(self) -> FieldQnty: ...

    @property
    def pound_of_i_per_pound_total(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_i_mathrm_lb(self) -> FieldQnty: ...


class MassTransferCoefficientSetter(TypeSafeSetter):
    """MassTransferCoefficient-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_per_square_centimeter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def kilogram_per_square_meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def pounds_force_per_cubic_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_ft_3_mathrm_h_or_mathrm_lb_mathrm_f_mathrm_cft_mathrm_hr(self) -> FieldQnty: ...

    @property
    def lb_f_ft_3_h(self) -> FieldQnty: ...

    @property
    def lb_f_cft_hr(self) -> FieldQnty: ...

    @property
    def pounds_mass_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def lb_ft_2_mathrm_hr_or_lb_sqft_hr(self) -> FieldQnty: ...

    @property
    def lb_ft_2_hr(self) -> FieldQnty: ...

    @property
    def lb_sqft_hr(self) -> FieldQnty: ...

    @property
    def pounds_mass_per_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_ft_2_mathrm_s_right_or_lb_sqft_sec(self) -> FieldQnty: ...

    @property
    def lb_left_ft_2_sright(self) -> FieldQnty: ...

    @property
    def lb_sqft_sec(self) -> FieldQnty: ...


class MolalityOfSoluteISetter(TypeSafeSetter):
    """MolalityOfSoluteI-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_moles_of_i_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_mol_mathrm_i_mathrm_kg(self) -> FieldQnty: ...

    @property
    def kilogram_mols_of_i_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_mathrm_i_mathrm_kg(self) -> FieldQnty: ...

    @property
    def kmols_of_i_per_kilogram(self) -> FieldQnty: ...

    @property
    def mols_of_i_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_mol_mathrm_i_mathrm_g(self) -> FieldQnty: ...

    @property
    def pound_moles_of_i_per_pound_mass(self) -> FieldQnty: ...

    @property
    def mole_mathrm_i_mathrm_lb_mass(self) -> FieldQnty: ...


class MolarConcentrationByMassSetter(TypeSafeSetter):
    """MolarConcentrationByMass-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_mole_or_mole_per_gram(self) -> FieldQnty: ...

    @property
    def mol_g(self) -> FieldQnty: ...

    @property
    def gram_mole_or_mole_per_kilogram(self) -> FieldQnty: ...

    @property
    def mol_kg(self) -> FieldQnty: ...

    @property
    def kilogram_mole_or_kmol_per_kilogram(self) -> FieldQnty: ...

    @property
    def kmol_kg(self) -> FieldQnty: ...

    @property
    def micromole_per_gram(self) -> FieldQnty: ...

    @property
    def mu_mathrm_mol_mathrm_g(self) -> FieldQnty: ...

    @property
    def millimole_per_gram(self) -> FieldQnty: ...

    @property
    def mmol_g(self) -> FieldQnty: ...

    @property
    def picomole_per_gram(self) -> FieldQnty: ...

    @property
    def pmol_g(self) -> FieldQnty: ...

    @property
    def pound_mole_per_pound(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_mathrm_lb_or_mole_lb(self) -> FieldQnty: ...

    @property
    def lb_mol_lb(self) -> FieldQnty: ...

    @property
    def mole_lb(self) -> FieldQnty: ...


class MolarFlowRateSetter(TypeSafeSetter):
    """MolarFlowRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_mole_per_day(self) -> FieldQnty: ...

    @property
    def mol_d(self) -> FieldQnty: ...

    @property
    def gram_mole_per_hour(self) -> FieldQnty: ...

    @property
    def mol_h(self) -> FieldQnty: ...

    @property
    def gram_mole_per_minute(self) -> FieldQnty: ...

    @property
    def mol_min(self) -> FieldQnty: ...

    @property
    def gram_mole_per_second(self) -> FieldQnty: ...

    @property
    def mol_s(self) -> FieldQnty: ...

    @property
    def kilogram_mole_or_kmol_per_day(self) -> FieldQnty: ...

    @property
    def kmol_d(self) -> FieldQnty: ...

    @property
    def kilogram_mole_or_kmol_per_hour(self) -> FieldQnty: ...

    @property
    def kmol_h(self) -> FieldQnty: ...

    @property
    def kilogram_mole_or_kmol_per_minute(self) -> FieldQnty: ...

    @property
    def kmol_min(self) -> FieldQnty: ...

    @property
    def kilogram_mole_or_kmol_per_second(self) -> FieldQnty: ...

    @property
    def kmol_s(self) -> FieldQnty: ...

    @property
    def pound_mole_or_lb_mol_per_day(self) -> FieldQnty: ...

    @property
    def lb_mol_d_or_mole_da(self) -> FieldQnty: ...

    @property
    def lb_mol_d(self) -> FieldQnty: ...

    @property
    def mole_da(self) -> FieldQnty: ...

    @property
    def pound_mole_or_lb_mol_per_hour(self) -> FieldQnty: ...

    @property
    def lb_mol_h_or_mole_hr(self) -> FieldQnty: ...

    @property
    def lb_mol_h(self) -> FieldQnty: ...

    @property
    def mole_hr(self) -> FieldQnty: ...

    @property
    def pound_mole_or_lb_mol_per_minute(self) -> FieldQnty: ...

    @property
    def lb_mol_min_or_mole_min(self) -> FieldQnty: ...

    @property
    def lb_mol_min(self) -> FieldQnty: ...

    @property
    def mole_min(self) -> FieldQnty: ...

    @property
    def pound_mole_or_lb_mol_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_mathrm_s_or_mole_sec(self) -> FieldQnty: ...

    @property
    def lb_mol_s(self) -> FieldQnty: ...

    @property
    def mole_sec(self) -> FieldQnty: ...


class MolarFluxSetter(TypeSafeSetter):
    """MolarFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def kmol_per_square_meter_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_d_right(self) -> FieldQnty: ...

    @property
    def kmol_per_square_meter_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_h_right(self) -> FieldQnty: ...

    @property
    def kmol_per_square_meter_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_left_mathrm_m_2_right_amin(self) -> FieldQnty: ...

    @property
    def kmol_per_square_meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_left_mathrm_m_2_mathrm_s_right(self) -> FieldQnty: ...

    @property
    def pound_mole_per_square_foot_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_d_right_or_mole_sqft_da(self) -> FieldQnty: ...

    @property
    def lb_mol_left_ft_2_dright(self) -> FieldQnty: ...

    @property
    def mole_sqft_da(self) -> FieldQnty: ...

    @property
    def pound_mole_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_h_right_or_mole_sqft_hr(self) -> FieldQnty: ...

    @property
    def lb_mol_left_ft_2_hright(self) -> FieldQnty: ...

    @property
    def mole_sqft_hr(self) -> FieldQnty: ...

    @property
    def pound_mole_per_square_foot_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_min_right_or_mole_sqft_min(self) -> FieldQnty: ...

    @property
    def lb_mol_left_ft_2_minright(self) -> FieldQnty: ...

    @property
    def mole_sqft_min(self) -> FieldQnty: ...

    @property
    def pound_mole_per_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_mol_left_mathrm_ft_2_mathrm_s_right_or_mole_sqft_sec(self) -> FieldQnty: ...

    @property
    def lb_mol_left_ft_2_sright(self) -> FieldQnty: ...

    @property
    def mole_sqft_sec(self) -> FieldQnty: ...


class MolarHeatCapacitySetter(TypeSafeSetter):
    """MolarHeatCapacity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_per_pound_mole_per_degree_fahrenheit_or_degree_rankine(self) -> FieldQnty: ...

    @property
    def Btu_lb_mol_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def calories_per_gram_mole_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def cal_mol_K(self) -> FieldQnty: ...

    @property
    def joule_per_gram_mole_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def J_mol_K(self) -> FieldQnty: ...


class MolarityOfISetter(TypeSafeSetter):
    """MolarityOfI-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_moles_of_i_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_mol_mathrm_i_mathrm_m_3_or_mathrm_c_mathrm_i(self) -> FieldQnty: ...

    @property
    def mol_i_m_3(self) -> FieldQnty: ...

    @property
    def c_i(self) -> FieldQnty: ...

    @property
    def gram_moles_of_i_per_liter(self) -> FieldQnty: ...

    @property
    def mathrm_mol_mathrm_i_mathrm_l(self) -> FieldQnty: ...

    @property
    def kilogram_moles_of_i_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_mathrm_i_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def kilogram_moles_of_i_per_liter(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_mathrm_i_mathrm_l(self) -> FieldQnty: ...

    @property
    def pound_moles_of_i_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_ft_3_or_mathrm_mole_mathrm_i_cft(self) -> FieldQnty: ...

    @property
    def lb_mol_i_ft_3(self) -> FieldQnty: ...

    @property
    def mole_i_cft(self) -> FieldQnty: ...

    @property
    def pound_moles_of_i_per_gallon_us(self) -> FieldQnty: ...

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_gal_or_mathrm_mole_mathrm_i_gal(self) -> FieldQnty: ...

    @property
    def lb_mol_i_gal(self) -> FieldQnty: ...

    @property
    def mole_i_gal(self) -> FieldQnty: ...


class MoleFractionOfISetter(TypeSafeSetter):
    """MoleFractionOfI-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_mole_of_i_per_gram_mole_total(self) -> FieldQnty: ...

    @property
    def mathrm_mol_mathrm_i_mathrm_mol(self) -> FieldQnty: ...

    @property
    def kilogram_mole_of_i_per_kilogram_mole_total(self) -> FieldQnty: ...

    @property
    def mathrm_kmol_mathrm_i_mathrm_kmol(self) -> FieldQnty: ...

    @property
    def kilomole_of_i_per_kilomole_total(self) -> FieldQnty: ...

    @property
    def pound_mole_of_i_per_pound_mole_total(self) -> FieldQnty: ...

    @property
    def lb_mathrm_mol_mathrm_i_mathrm_lb_mathrm_mol(self) -> FieldQnty: ...


class MomentOfInertiaSetter(TypeSafeSetter):
    """MomentOfInertia-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_force_centimeter_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_f_mathrm_cm_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def gram_square_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def kilogram_force_centimeter_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_cm_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def kilogram_force_meter_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def kilogram_square_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def kilogram_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def ounce_force_inch_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_oz_mathrm_f_in_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def ounce_mass_square_inch(self) -> FieldQnty: ...

    @property
    def oz_in_2(self) -> FieldQnty: ...

    @property
    def pound_mass_square_foot(self) -> FieldQnty: ...

    @property
    def lb_ft_2_or_lb_sq_ft(self) -> FieldQnty: ...

    @property
    def lb_ft_2(self) -> FieldQnty: ...

    @property
    def lb_sq_ft(self) -> FieldQnty: ...

    @property
    def pound_mass_square_inch(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_in_2(self) -> FieldQnty: ...


class MomentumFlowRateSetter(TypeSafeSetter):
    """MomentumFlowRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def foot_pounds_per_square_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_h_2_or_mathrm_ft_mathrm_lb_mathrm_hr_2(self) -> FieldQnty: ...

    @property
    def ft_lb_h_2(self) -> FieldQnty: ...

    @property
    def ft_lb_hr_2(self) -> FieldQnty: ...

    @property
    def foot_pounds_per_square_minute(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_min_2(self) -> FieldQnty: ...

    @property
    def foot_pounds_per_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_s_2_or_ft_lb_sec_2(self) -> FieldQnty: ...

    @property
    def ft_lb_s_2(self) -> FieldQnty: ...

    @property
    def ft_lb_sec_2(self) -> FieldQnty: ...

    @property
    def gram_centimeters_per_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def kilogram_meters_per_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_mathrm_s_2(self) -> FieldQnty: ...


class MomentumFluxSetter(TypeSafeSetter):
    """MomentumFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dyne_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def gram_per_centimeter_per_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_mathrm_s_2(self) -> FieldQnty: ...

    @property
    def newton_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_N_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def pound_force_per_square_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_sq_mathrm_ft(self) -> FieldQnty: ...

    @property
    def pound_mass_per_foot_per_square_second(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_m_mathrm_ft_mathrm_s_2_or_mathrm_lb_mathrm_ft_mathrm_sec_2(self) -> FieldQnty: ...

    @property
    def lb_m_ft_s_2(self) -> FieldQnty: ...

    @property
    def lb_ft_sec_2(self) -> FieldQnty: ...


class NormalityOfSolutionSetter(TypeSafeSetter):
    """NormalityOfSolution-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_equivalents_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_eq_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def gram_equivalents_per_liter(self) -> FieldQnty: ...

    @property
    def eq_l(self) -> FieldQnty: ...

    @property
    def pound_equivalents_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_eq_mathrm_ft_3_or_lb_eq_cft(self) -> FieldQnty: ...

    @property
    def lb_eq_ft_3(self) -> FieldQnty: ...

    @property
    def lb_eq_cft(self) -> FieldQnty: ...

    @property
    def pound_equivalents_per_gallon(self) -> FieldQnty: ...

    @property
    def lb_eq_gal_US(self) -> FieldQnty: ...


class ParticleDensitySetter(TypeSafeSetter):
    """ParticleDensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def particles_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def part_cm_3_or_part_cc(self) -> FieldQnty: ...

    @property
    def part_cm_3(self) -> FieldQnty: ...

    @property
    def part_cc(self) -> FieldQnty: ...

    @property
    def particles_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def part_mathrm_ft_3_or_part_cft(self) -> FieldQnty: ...

    @property
    def part_ft_3(self) -> FieldQnty: ...

    @property
    def part_cft(self) -> FieldQnty: ...

    @property
    def particles_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def part_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def particles_per_gallon_us(self) -> FieldQnty: ...

    @property
    def part_gal(self) -> FieldQnty: ...

    @property
    def particles_per_liter(self) -> FieldQnty: ...

    @property
    def part_l(self) -> FieldQnty: ...

    @property
    def particles_per_milliliter(self) -> FieldQnty: ...

    @property
    def part_ml(self) -> FieldQnty: ...


class PercentSetter(TypeSafeSetter):
    """Percent-specific setter with unit properties."""

    __slots__ = ()

    @property
    def percent(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...

    @property
    def per_mille(self) -> FieldQnty: ...

    @property
    def basis_point(self) -> FieldQnty: ...

    @property
    def bp(self) -> FieldQnty: ...

    @property
    def bps(self) -> FieldQnty: ...


class PermeabilitySetter(TypeSafeSetter):
    """Permeability-specific setter with unit properties."""

    __slots__ = ()

    @property
    def darcy(self) -> FieldQnty: ...

    @property
    def square_feet(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_or_sq_ft(self) -> FieldQnty: ...

    @property
    def ft_2(self) -> FieldQnty: ...

    @property
    def sq_ft(self) -> FieldQnty: ...

    @property
    def square_meters(self) -> FieldQnty: ...

    @property
    def mathrm_m_2(self) -> FieldQnty: ...


class PhotonEmissionRateSetter(TypeSafeSetter):
    """PhotonEmissionRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def rayleigh(self) -> FieldQnty: ...

    @property
    def R(self) -> FieldQnty: ...

    @property
    def reciprocal_square_meter_second(self) -> FieldQnty: ...


class PowerPerUnitMassSetter(TypeSafeSetter):
    """PowerPerUnitMass-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_hour_per_pound_mass(self) -> FieldQnty: ...

    @property
    def Btu_h_lb_or_Btu_lb_hr(self) -> FieldQnty: ...

    @property
    def Btu_h_lb(self) -> FieldQnty: ...

    @property
    def Btu_lb_hr(self) -> FieldQnty: ...

    @property
    def calorie_per_second_per_gram(self) -> FieldQnty: ...

    @property
    def cal_s_g_or_cal_g_sec(self) -> FieldQnty: ...

    @property
    def cal_s_g(self) -> FieldQnty: ...

    @property
    def cal_g_sec(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_hour_per_kilogram(self) -> FieldQnty: ...

    @property
    def kcal_h_kg_or_kcal_kg_hr(self) -> FieldQnty: ...

    @property
    def kcal_h_kg(self) -> FieldQnty: ...

    @property
    def kcal_kg_hr(self) -> FieldQnty: ...

    @property
    def watt_per_kilogram(self) -> FieldQnty: ...

    @property
    def W_kg(self) -> FieldQnty: ...


class PowerPerUnitVolumeSetter(TypeSafeSetter):
    """PowerPerUnitVolume-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_hour_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_mathrm_h_mathrm_ft_3_or_mathrm_Btu_mathrm_hr_cft(self) -> FieldQnty: ...

    @property
    def Btu_h_ft_3(self) -> FieldQnty: ...

    @property
    def Btu_hr_cft(self) -> FieldQnty: ...

    @property
    def calorie_per_second_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_s_mathrm_cm_3_or_mathrm_cal_mathrm_s_mathrm_cc(self) -> FieldQnty: ...

    @property
    def cal_s_cm_3(self) -> FieldQnty: ...

    @property
    def cal_s_cc(self) -> FieldQnty: ...

    @property
    def chu_per_hour_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def Chu_h_ft3_or_Chu_hr_cft(self) -> FieldQnty: ...

    @property
    def Chu_h_ft3(self) -> FieldQnty: ...

    @property
    def Chu_hr_cft(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_hour_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_mathrm_h_mathrm_cm_3_or_mathrm_kcal_hr_cc(self) -> FieldQnty: ...

    @property
    def kcal_h_cm_3(self) -> FieldQnty: ...

    @property
    def kcal_hr_cc(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_hour_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_mathrm_h_mathrm_ft_3_or_mathrm_kcal_mathrm_hr_cft(self) -> FieldQnty: ...

    @property
    def kcal_h_ft_3(self) -> FieldQnty: ...

    @property
    def kcal_hr_cft(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_second_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def kcal_s_cm_3_or_kcal_s_cc(self) -> FieldQnty: ...

    @property
    def kcal_s_cm_3(self) -> FieldQnty: ...

    @property
    def kcal_s_cc(self) -> FieldQnty: ...

    @property
    def watt_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_W_mathrm_m_3(self) -> FieldQnty: ...


class PowerThermalDutySetter(TypeSafeSetter):
    """PowerThermalDuty-specific setter with unit properties."""

    __slots__ = ()

    @property
    def abwatt_emu_of_power(self) -> FieldQnty: ...

    @property
    def emu(self) -> FieldQnty: ...

    @property
    def boiler_horsepower(self) -> FieldQnty: ...

    @property
    def HP_boiler(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_mean(self) -> FieldQnty: ...

    @property
    def Btu_mean_hr_or_Btu_hr(self) -> FieldQnty: ...

    @property
    def Btu_mean_hr(self) -> FieldQnty: ...

    @property
    def Btu_hr(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_thermochemical(self) -> FieldQnty: ...

    @property
    def Btu_therm_hr_or_Btu_hr(self) -> FieldQnty: ...

    @property
    def Btu_therm_hr(self) -> FieldQnty: ...

    @property
    def calorie_mean(self) -> FieldQnty: ...

    @property
    def cal_mean_hr(self) -> FieldQnty: ...

    @property
    def calorie_thermochemical(self) -> FieldQnty: ...

    @property
    def cal_therm_hr(self) -> FieldQnty: ...

    @property
    def donkey(self) -> FieldQnty: ...

    @property
    def erg_per_second(self) -> FieldQnty: ...

    @property
    def erg_s(self) -> FieldQnty: ...

    @property
    def foot_pondal_per_second(self) -> FieldQnty: ...

    @property
    def ft_pdl_s(self) -> FieldQnty: ...

    @property
    def foot_pound_force_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_hr(self) -> FieldQnty: ...

    @property
    def foot_pound_force_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_min(self) -> FieldQnty: ...

    @property
    def foot_pound_force_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f_mathrm_s(self) -> FieldQnty: ...

    @property
    def horsepower_550_mathrmft_mathrmlb_mathrmf_mathrms(self) -> FieldQnty: ...

    @property
    def HP(self) -> FieldQnty: ...

    @property
    def horsepower_electric(self) -> FieldQnty: ...

    @property
    def HP_elect(self) -> FieldQnty: ...

    @property
    def horsepower_uk(self) -> FieldQnty: ...

    @property
    def HP_UK(self) -> FieldQnty: ...

    @property
    def kcal_per_hour(self) -> FieldQnty: ...

    @property
    def kcal_hr(self) -> FieldQnty: ...

    @property
    def kilogram_force_meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_m_mathrm_s(self) -> FieldQnty: ...

    @property
    def kilowatt(self) -> FieldQnty: ...

    @property
    def kW(self) -> FieldQnty: ...

    @property
    def megawatt(self) -> FieldQnty: ...

    @property
    def MW(self) -> FieldQnty: ...

    @property
    def metric_horsepower(self) -> FieldQnty: ...

    @property
    def HP_metric(self) -> FieldQnty: ...

    @property
    def million_british_thermal_units_per_hour_petroleum(self) -> FieldQnty: ...

    @property
    def MMBtu_hr(self) -> FieldQnty: ...

    @property
    def million_kilocalorie_per_hour(self) -> FieldQnty: ...

    @property
    def MM_kcal_hr(self) -> FieldQnty: ...

    @property
    def prony(self) -> FieldQnty: ...

    @property
    def ton_of_refrigeration_us(self) -> FieldQnty: ...

    @property
    def CTR_US(self) -> FieldQnty: ...

    @property
    def ton_or_refrigeration_uk(self) -> FieldQnty: ...

    @property
    def CTR_UK(self) -> FieldQnty: ...

    @property
    def volt_ampere(self) -> FieldQnty: ...

    @property
    def VA(self) -> FieldQnty: ...

    @property
    def water_horsepower(self) -> FieldQnty: ...

    @property
    def HP_water(self) -> FieldQnty: ...

    @property
    def watt(self) -> FieldQnty: ...

    @property
    def W(self) -> FieldQnty: ...

    @property
    def watt_international_mean(self) -> FieldQnty: ...

    @property
    def W_int_mean(self) -> FieldQnty: ...

    @property
    def watt_international_us(self) -> FieldQnty: ...

    @property
    def watt_int_US(self) -> FieldQnty: ...

    @property
    def gigawatt(self) -> FieldQnty: ...

    @property
    def GW(self) -> FieldQnty: ...

    @property
    def milliwatt(self) -> FieldQnty: ...

    @property
    def mW(self) -> FieldQnty: ...

    @property
    def microwatt(self) -> FieldQnty: ...


class PressureSetter(TypeSafeSetter):
    """Pressure-specific setter with unit properties."""

    __slots__ = ()

    @property
    def atmosphere_standard(self) -> FieldQnty: ...

    @property
    def atm(self) -> FieldQnty: ...

    @property
    def bar(self) -> FieldQnty: ...

    @property
    def barye(self) -> FieldQnty: ...

    @property
    def dyne_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def foot_of_mercury_60_circ_mathrmf(self) -> FieldQnty: ...

    @property
    def ft_Hg_60_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def foot_of_water_60_circ_mathrmf(self) -> FieldQnty: ...

    @property
    def ft_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> FieldQnty: ...

    @property
    def gigapascal(self) -> FieldQnty: ...

    @property
    def GPa(self) -> FieldQnty: ...

    @property
    def hectopascal(self) -> FieldQnty: ...

    @property
    def hPa(self) -> FieldQnty: ...

    @property
    def inch_of_mercury_60_circ_mathrmf(self) -> FieldQnty: ...

    @property
    def in_mathrm_Hg_left_60_circ_mathrm_F_right(self) -> FieldQnty: ...

    @property
    def inch_of_water_60_circ_mathrmf(self) -> FieldQnty: ...

    @property
    def in_mathrm_H_2_mathrm_O_left_60_circ_mathrm_F_right(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def at(self) -> FieldQnty: ...

    @property
    def kg_f_cm_2(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def kip_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> FieldQnty: ...

    @property
    def KSI(self) -> FieldQnty: ...

    @property
    def ksi(self) -> FieldQnty: ...

    @property
    def kip_f_in_2(self) -> FieldQnty: ...

    @property
    def megapascal(self) -> FieldQnty: ...

    @property
    def MPa(self) -> FieldQnty: ...

    @property
    def meter_of_water_4circ_mathrmc(self) -> FieldQnty: ...

    @property
    def mathrm_m_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> FieldQnty: ...

    @property
    def microbar(self) -> FieldQnty: ...

    @property
    def mu_mathrm_bar(self) -> FieldQnty: ...

    @property
    def millibar(self) -> FieldQnty: ...

    @property
    def mbar(self) -> FieldQnty: ...

    @property
    def millimeter_of_mercury_4circ_mathrmc(self) -> FieldQnty: ...

    @property
    def mathrm_mm_mathrm_Hg_left_4_circ_mathrm_C_right(self) -> FieldQnty: ...

    @property
    def millimeter_of_water_4circ_mathrmc(self) -> FieldQnty: ...

    @property
    def mathrm_mm_mathrm_H_2_mathrm_O_left_4_circ_mathrm_C_right(self) -> FieldQnty: ...

    @property
    def newton_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_N_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def ounce_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> FieldQnty: ...

    @property
    def OSI(self) -> FieldQnty: ...

    @property
    def osi(self) -> FieldQnty: ...

    @property
    def pascal(self) -> FieldQnty: ...

    @property
    def Pa(self) -> FieldQnty: ...

    @property
    def pi_ze(self) -> FieldQnty: ...

    @property
    def pz(self) -> FieldQnty: ...

    @property
    def pound_force_per_square_foot(self) -> FieldQnty: ...

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> FieldQnty: ...

    @property
    def psf(self) -> FieldQnty: ...

    @property
    def pound_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def psi(self) -> FieldQnty: ...

    @property
    def torr(self) -> FieldQnty: ...

    @property
    def torr_or_mm_Hg_0_circ_C(self) -> FieldQnty: ...

    @property
    def mm_Hg_0_circ_C(self) -> FieldQnty: ...

    @property
    def kilopascal(self) -> FieldQnty: ...

    @property
    def kPa(self) -> FieldQnty: ...


class RadiationDoseEquivalentSetter(TypeSafeSetter):
    """RadiationDoseEquivalent-specific setter with unit properties."""

    __slots__ = ()

    @property
    def rem(self) -> FieldQnty: ...

    @property
    def sievert(self) -> FieldQnty: ...

    @property
    def Sv(self) -> FieldQnty: ...

    @property
    def millisievert(self) -> FieldQnty: ...

    @property
    def mSv(self) -> FieldQnty: ...

    @property
    def microsievert(self) -> FieldQnty: ...


class RadiationExposureSetter(TypeSafeSetter):
    """RadiationExposure-specific setter with unit properties."""

    __slots__ = ()

    @property
    def coulomb_per_kilogram(self) -> FieldQnty: ...

    @property
    def C_kg(self) -> FieldQnty: ...

    @property
    def d_unit(self) -> FieldQnty: ...

    @property
    def D_unit(self) -> FieldQnty: ...

    @property
    def pastille_dose_b_unit(self) -> FieldQnty: ...

    @property
    def B_unit(self) -> FieldQnty: ...

    @property
    def r_entgen(self) -> FieldQnty: ...

    @property
    def R(self) -> FieldQnty: ...


class RadioactivitySetter(TypeSafeSetter):
    """Radioactivity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def becquerel(self) -> FieldQnty: ...

    @property
    def Bq(self) -> FieldQnty: ...

    @property
    def curie(self) -> FieldQnty: ...

    @property
    def Ci(self) -> FieldQnty: ...

    @property
    def mache_unit(self) -> FieldQnty: ...

    @property
    def Mache(self) -> FieldQnty: ...

    @property
    def rutherford(self) -> FieldQnty: ...

    @property
    def Rd(self) -> FieldQnty: ...

    @property
    def stat(self) -> FieldQnty: ...

    @property
    def kilobecquerel(self) -> FieldQnty: ...

    @property
    def kBq(self) -> FieldQnty: ...

    @property
    def megabecquerel(self) -> FieldQnty: ...

    @property
    def MBq(self) -> FieldQnty: ...

    @property
    def gigabecquerel(self) -> FieldQnty: ...

    @property
    def GBq(self) -> FieldQnty: ...


class SecondMomentOfAreaSetter(TypeSafeSetter):
    """SecondMomentOfArea-specific setter with unit properties."""

    __slots__ = ()

    @property
    def inch_quadrupled(self) -> FieldQnty: ...

    @property
    def in_4(self) -> FieldQnty: ...

    @property
    def centimeter_quadrupled(self) -> FieldQnty: ...

    @property
    def mathrm_cm_4(self) -> FieldQnty: ...

    @property
    def foot_quadrupled(self) -> FieldQnty: ...

    @property
    def mathrm_ft_4(self) -> FieldQnty: ...

    @property
    def meter_quadrupled(self) -> FieldQnty: ...

    @property
    def mathrm_m_4(self) -> FieldQnty: ...


class SecondRadiationConstantPlanckSetter(TypeSafeSetter):
    """SecondRadiationConstantPlanck-specific setter with unit properties."""

    __slots__ = ()

    @property
    def meter_kelvin(self) -> FieldQnty: ...

    @property
    def m_K(self) -> FieldQnty: ...


class SpecificEnthalpySetter(TypeSafeSetter):
    """SpecificEnthalpy-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_mean(self) -> FieldQnty: ...

    @property
    def Btu_mean_lb(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_per_pound(self) -> FieldQnty: ...

    @property
    def Btu_lb(self) -> FieldQnty: ...

    @property
    def calorie_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_g(self) -> FieldQnty: ...

    @property
    def chu_per_pound(self) -> FieldQnty: ...

    @property
    def Chu_lb(self) -> FieldQnty: ...

    @property
    def joule_per_kilogram(self) -> FieldQnty: ...

    @property
    def J_kg(self) -> FieldQnty: ...

    @property
    def kilojoule_per_kilogram(self) -> FieldQnty: ...

    @property
    def kJ_kg(self) -> FieldQnty: ...


class SpecificGravitySetter(TypeSafeSetter):
    """SpecificGravity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dimensionless(self) -> FieldQnty: ...

    @property
    def Dmls(self) -> FieldQnty: ...


class SpecificHeatCapacityConstantPressureSetter(TypeSafeSetter):
    """SpecificHeatCapacityConstantPressure-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_per_pound_per_degree_fahrenheit_or_degree_rankine(self) -> FieldQnty: ...

    @property
    def Btu_lb_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def calories_per_gram_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def cal_g_K(self) -> FieldQnty: ...

    @property
    def joules_per_kilogram_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def J_kg_K(self) -> FieldQnty: ...


class SpecificLengthSetter(TypeSafeSetter):
    """SpecificLength-specific setter with unit properties."""

    __slots__ = ()

    @property
    def centimeter_per_gram(self) -> FieldQnty: ...

    @property
    def cm_g(self) -> FieldQnty: ...

    @property
    def cotton_count(self) -> FieldQnty: ...

    @property
    def cc(self) -> FieldQnty: ...

    @property
    def ft_per_pound(self) -> FieldQnty: ...

    @property
    def ft_lb(self) -> FieldQnty: ...

    @property
    def meters_per_kilogram(self) -> FieldQnty: ...

    @property
    def m_kg(self) -> FieldQnty: ...

    @property
    def newton_meter(self) -> FieldQnty: ...

    @property
    def Nm(self) -> FieldQnty: ...

    @property
    def worsted(self) -> FieldQnty: ...


class SpecificSurfaceSetter(TypeSafeSetter):
    """SpecificSurface-specific setter with unit properties."""

    __slots__ = ()

    @property
    def square_centimeter_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cm_2_mathrm_g(self) -> FieldQnty: ...

    @property
    def square_foot_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_kg_or_sq_ft_kg(self) -> FieldQnty: ...

    @property
    def ft_2_kg(self) -> FieldQnty: ...

    @property
    def sq_ft_kg(self) -> FieldQnty: ...

    @property
    def square_foot_per_pound(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_lb_or_sq_ft_lb(self) -> FieldQnty: ...

    @property
    def ft_2_lb(self) -> FieldQnty: ...

    @property
    def sq_ft_lb(self) -> FieldQnty: ...

    @property
    def square_meter_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_g(self) -> FieldQnty: ...

    @property
    def square_meter_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_kg(self) -> FieldQnty: ...


class SpecificVolumeSetter(TypeSafeSetter):
    """SpecificVolume-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cubic_centimeter_per_gram(self) -> FieldQnty: ...

    @property
    def mathrm_cm_3_mathrm_g_or_mathrm_cc_mathrm_g(self) -> FieldQnty: ...

    @property
    def cm_3_g(self) -> FieldQnty: ...

    @property
    def cc_g(self) -> FieldQnty: ...

    @property
    def cubic_foot_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_kg_or_mathrm_cft_mathrm_kg(self) -> FieldQnty: ...

    @property
    def ft_3_kg(self) -> FieldQnty: ...

    @property
    def cft_kg(self) -> FieldQnty: ...

    @property
    def cubic_foot_per_pound(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_lb_or_mathrm_cft_mathrm_lb(self) -> FieldQnty: ...

    @property
    def ft_3_lb(self) -> FieldQnty: ...

    @property
    def cft_lb(self) -> FieldQnty: ...

    @property
    def cubic_meter_per_kilogram(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_mathrm_kg(self) -> FieldQnty: ...


class StressSetter(TypeSafeSetter):
    """Stress-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dyne_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def gigapascal(self) -> FieldQnty: ...

    @property
    def GPa(self) -> FieldQnty: ...

    @property
    def hectopascal(self) -> FieldQnty: ...

    @property
    def hPa(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def at_or_mathrm_kg_mathrm_f_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def at(self) -> FieldQnty: ...

    @property
    def kg_f_cm_2(self) -> FieldQnty: ...

    @property
    def kilogram_force_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_f_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def kip_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def KSI_or_ksi_or_kip_f_mathrm_in_2(self) -> FieldQnty: ...

    @property
    def KSI(self) -> FieldQnty: ...

    @property
    def ksi(self) -> FieldQnty: ...

    @property
    def kip_f_in_2(self) -> FieldQnty: ...

    @property
    def megapascal(self) -> FieldQnty: ...

    @property
    def MPa(self) -> FieldQnty: ...

    @property
    def newton_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_N_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def ounce_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def OSI_or_osi_or_mathrm_oz_mathrm_f_mathrm_in_2(self) -> FieldQnty: ...

    @property
    def OSI(self) -> FieldQnty: ...

    @property
    def osi(self) -> FieldQnty: ...

    @property
    def oz_f_in_2(self) -> FieldQnty: ...

    @property
    def pascal(self) -> FieldQnty: ...

    @property
    def Pa(self) -> FieldQnty: ...

    @property
    def pound_force_per_square_foot(self) -> FieldQnty: ...

    @property
    def PSF_or_psf_or_mathrm_lb_mathrm_f_mathrm_ft_2(self) -> FieldQnty: ...

    @property
    def PSF(self) -> FieldQnty: ...

    @property
    def psf(self) -> FieldQnty: ...

    @property
    def lb_f_ft_2(self) -> FieldQnty: ...

    @property
    def pound_force_per_square_inch(self) -> FieldQnty: ...

    @property
    def psi(self) -> FieldQnty: ...


class SurfaceMassDensitySetter(TypeSafeSetter):
    """SurfaceMassDensity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def gram_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def kilogram_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def pound_mass(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_ft_2(self) -> FieldQnty: ...


class SurfaceTensionSetter(TypeSafeSetter):
    """SurfaceTension-specific setter with unit properties."""

    __slots__ = ()

    @property
    def dyne_per_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_cm(self) -> FieldQnty: ...

    @property
    def gram_force_per_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_f_mathrm_cm(self) -> FieldQnty: ...

    @property
    def newton_per_meter(self) -> FieldQnty: ...

    @property
    def N_m(self) -> FieldQnty: ...

    @property
    def pound_force_per_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_ft(self) -> FieldQnty: ...

    @property
    def pound_force_per_inch(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_in(self) -> FieldQnty: ...


class TemperatureSetter(TypeSafeSetter):
    """Temperature-specific setter with unit properties."""

    __slots__ = ()

    @property
    def degree_celsius_unit_size(self) -> FieldQnty: ...

    @property
    def mathrm_C_circ(self) -> FieldQnty: ...

    @property
    def degree_fahrenheit_unit_size(self) -> FieldQnty: ...

    @property
    def mathrm_F_circ(self) -> FieldQnty: ...

    @property
    def degree_r_aumur_unit_size(self) -> FieldQnty: ...

    @property
    def R_circ(self) -> FieldQnty: ...

    @property
    def kelvin_absolute_scale(self) -> FieldQnty: ...

    @property
    def K(self) -> FieldQnty: ...

    @property
    def rankine_absolute_scale(self) -> FieldQnty: ...

    @property
    def circ_mathrm_R(self) -> FieldQnty: ...


class ThermalConductivitySetter(TypeSafeSetter):
    """ThermalConductivity-specific setter with unit properties."""

    __slots__ = ()

    @property
    def btu_it(self) -> FieldQnty: ...

    @property
    def Btu_IT_in_hr_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def btu_therm(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_left_mathrm_ft_mathrm_hr_circ_mathrm_F_right(self) -> FieldQnty: ...

    @property
    def calorie_therm(self) -> FieldQnty: ...

    @property
    def operatorname_cal_mathrm_IT_left_mathrm_cm_mathrm_s_circ_mathrm_C_right(self) -> FieldQnty: ...

    @property
    def joule_per_second_per_centimeter_per_kelvin(self) -> FieldQnty: ...

    @property
    def J_cm_s_K(self) -> FieldQnty: ...

    @property
    def watt_per_centimeter_per_kelvin(self) -> FieldQnty: ...

    @property
    def W_cm_K(self) -> FieldQnty: ...

    @property
    def watt_per_meter_per_kelvin(self) -> FieldQnty: ...

    @property
    def W_m_K(self) -> FieldQnty: ...


class TimeSetter(TypeSafeSetter):
    """Time-specific setter with unit properties."""

    __slots__ = ()

    @property
    def blink(self) -> FieldQnty: ...

    @property
    def century(self) -> FieldQnty: ...

    @property
    def unnamed(self) -> FieldQnty: ...

    @property
    def chronon_or_tempon(self) -> FieldQnty: ...

    @property
    def gigan_or_eon(self) -> FieldQnty: ...

    @property
    def Ga_or_eon(self) -> FieldQnty: ...

    @property
    def Ga(self) -> FieldQnty: ...

    @property
    def eon(self) -> FieldQnty: ...

    @property
    def hour(self) -> FieldQnty: ...

    @property
    def h_or_hr(self) -> FieldQnty: ...

    @property
    def h(self) -> FieldQnty: ...

    @property
    def hr(self) -> FieldQnty: ...

    @property
    def julian_year(self) -> FieldQnty: ...

    @property
    def a_jul_or_yr(self) -> FieldQnty: ...

    @property
    def a_jul(self) -> FieldQnty: ...

    @property
    def yr(self) -> FieldQnty: ...

    @property
    def mean_solar_day(self) -> FieldQnty: ...

    @property
    def da_or_d(self) -> FieldQnty: ...

    @property
    def da(self) -> FieldQnty: ...

    @property
    def d(self) -> FieldQnty: ...

    @property
    def millenium(self) -> FieldQnty: ...

    @property
    def minute(self) -> FieldQnty: ...

    @property
    def min(self) -> FieldQnty: ...

    @property
    def second(self) -> FieldQnty: ...

    @property
    def s(self) -> FieldQnty: ...

    @property
    def shake(self) -> FieldQnty: ...

    @property
    def sidereal_year_1900_ad(self) -> FieldQnty: ...

    @property
    def a_sider_or_yr(self) -> FieldQnty: ...

    @property
    def a_sider(self) -> FieldQnty: ...

    @property
    def tropical_year(self) -> FieldQnty: ...

    @property
    def a_trop(self) -> FieldQnty: ...

    @property
    def wink(self) -> FieldQnty: ...

    @property
    def year(self) -> FieldQnty: ...

    @property
    def a_or_y_or_yr(self) -> FieldQnty: ...

    @property
    def a(self) -> FieldQnty: ...

    @property
    def y(self) -> FieldQnty: ...

    @property
    def millisecond(self) -> FieldQnty: ...

    @property
    def ms(self) -> FieldQnty: ...

    @property
    def microsecond(self) -> FieldQnty: ...

    @property
    def nanosecond(self) -> FieldQnty: ...

    @property
    def ns(self) -> FieldQnty: ...

    @property
    def picosecond(self) -> FieldQnty: ...

    @property
    def ps(self) -> FieldQnty: ...


class TorqueSetter(TypeSafeSetter):
    """Torque-specific setter with unit properties."""

    __slots__ = ()

    @property
    def centimeter_kilogram_force(self) -> FieldQnty: ...

    @property
    def cm_kg_mathrm_f(self) -> FieldQnty: ...

    @property
    def dyne_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_cm(self) -> FieldQnty: ...

    @property
    def foot_kilogram_force(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_kg_mathrm_f(self) -> FieldQnty: ...

    @property
    def foot_pound_force(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_lb_mathrm_f(self) -> FieldQnty: ...

    @property
    def foot_poundal(self) -> FieldQnty: ...

    @property
    def ft_pdl(self) -> FieldQnty: ...

    @property
    def in_pound_force(self) -> FieldQnty: ...

    @property
    def in_mathrm_lb_mathrm_f(self) -> FieldQnty: ...

    @property
    def inch_ounce_force(self) -> FieldQnty: ...

    @property
    def in_mathrm_OZ_mathrm_f(self) -> FieldQnty: ...

    @property
    def meter_kilogram_force(self) -> FieldQnty: ...

    @property
    def mathrm_m_mathrm_kg_mathrm_f(self) -> FieldQnty: ...

    @property
    def newton_centimeter(self) -> FieldQnty: ...

    @property
    def N_cm(self) -> FieldQnty: ...

    @property
    def newton_meter(self) -> FieldQnty: ...

    @property
    def N_m(self) -> FieldQnty: ...


class TurbulenceEnergyDissipationRateSetter(TypeSafeSetter):
    """TurbulenceEnergyDissipationRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def square_foot_per_cubic_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_s_3_or_sq_ft_sec_3(self) -> FieldQnty: ...

    @property
    def ft_2_s_3(self) -> FieldQnty: ...

    @property
    def sq_ft_sec_3(self) -> FieldQnty: ...

    @property
    def square_meter_per_cubic_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_s_3(self) -> FieldQnty: ...


class VelocityAngularSetter(TypeSafeSetter):
    """VelocityAngular-specific setter with unit properties."""

    __slots__ = ()

    @property
    def degree_per_minute(self) -> FieldQnty: ...

    @property
    def deg_min_or_circ_mathrm_min(self) -> FieldQnty: ...

    @property
    def deg_min(self) -> FieldQnty: ...

    @property
    def circ_min(self) -> FieldQnty: ...

    @property
    def degree_per_second(self) -> FieldQnty: ...

    @property
    def deg_s_or_circ_s(self) -> FieldQnty: ...

    @property
    def deg_s(self) -> FieldQnty: ...

    @property
    def circ_s(self) -> FieldQnty: ...

    @property
    def grade_per_minute(self) -> FieldQnty: ...

    @property
    def gon_min_or_grad_min(self) -> FieldQnty: ...

    @property
    def gon_min(self) -> FieldQnty: ...

    @property
    def grad_min(self) -> FieldQnty: ...

    @property
    def radian_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_rad_mathrm_min(self) -> FieldQnty: ...

    @property
    def radian_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_rad_mathrm_s(self) -> FieldQnty: ...

    @property
    def revolution_per_minute(self) -> FieldQnty: ...

    @property
    def rev_m_or_rpm(self) -> FieldQnty: ...

    @property
    def rev_m(self) -> FieldQnty: ...

    @property
    def rpm(self) -> FieldQnty: ...

    @property
    def revolution_per_second(self) -> FieldQnty: ...

    @property
    def rev_s_or_rps(self) -> FieldQnty: ...

    @property
    def rev_s(self) -> FieldQnty: ...

    @property
    def rps(self) -> FieldQnty: ...

    @property
    def turn_per_minute(self) -> FieldQnty: ...

    @property
    def tr_min(self) -> FieldQnty: ...


class VelocityLinearSetter(TypeSafeSetter):
    """VelocityLinear-specific setter with unit properties."""

    __slots__ = ()

    @property
    def foot_per_hour(self) -> FieldQnty: ...

    @property
    def ft_h_or_ft_hr_or_fph(self) -> FieldQnty: ...

    @property
    def ft_h(self) -> FieldQnty: ...

    @property
    def ft_hr(self) -> FieldQnty: ...

    @property
    def fph(self) -> FieldQnty: ...

    @property
    def foot_per_minute(self) -> FieldQnty: ...

    @property
    def ft_min_or_fpm(self) -> FieldQnty: ...

    @property
    def ft_min(self) -> FieldQnty: ...

    @property
    def fpm(self) -> FieldQnty: ...

    @property
    def foot_per_second(self) -> FieldQnty: ...

    @property
    def ft_s_or_fps(self) -> FieldQnty: ...

    @property
    def ft_s(self) -> FieldQnty: ...

    @property
    def fps(self) -> FieldQnty: ...

    @property
    def inch_per_second(self) -> FieldQnty: ...

    @property
    def in_s_or_ips(self) -> FieldQnty: ...

    @property
    def in_s(self) -> FieldQnty: ...

    @property
    def ips(self) -> FieldQnty: ...

    @property
    def international_knot(self) -> FieldQnty: ...

    @property
    def knot(self) -> FieldQnty: ...

    @property
    def kilometer_per_hour(self) -> FieldQnty: ...

    @property
    def km_h_ot_kph(self) -> FieldQnty: ...

    @property
    def kilometer_per_second(self) -> FieldQnty: ...

    @property
    def km_s(self) -> FieldQnty: ...

    @property
    def meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_mathrm_s(self) -> FieldQnty: ...

    @property
    def mile_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_mi_mathrm_h_or_mathrm_mi_mathrm_hr_or_mph(self) -> FieldQnty: ...

    @property
    def mi_h(self) -> FieldQnty: ...

    @property
    def mi_hr(self) -> FieldQnty: ...

    @property
    def mph(self) -> FieldQnty: ...


class ViscosityDynamicSetter(TypeSafeSetter):
    """ViscosityDynamic-specific setter with unit properties."""

    __slots__ = ()

    @property
    def centipoise(self) -> FieldQnty: ...

    @property
    def cP_or_cPo(self) -> FieldQnty: ...

    @property
    def cP(self) -> FieldQnty: ...

    @property
    def cPo(self) -> FieldQnty: ...

    @property
    def dyne_second_per_square_centimeter(self) -> FieldQnty: ...

    @property
    def dyn_s_mathrm_cm_2(self) -> FieldQnty: ...

    @property
    def kilopound_second_per_square_meter(self) -> FieldQnty: ...

    @property
    def kip_mathrm_s_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def millipoise(self) -> FieldQnty: ...

    @property
    def mP_or_mPo(self) -> FieldQnty: ...

    @property
    def mP(self) -> FieldQnty: ...

    @property
    def mPo(self) -> FieldQnty: ...

    @property
    def newton_second_per_square_meter(self) -> FieldQnty: ...

    @property
    def mathrm_N_mathrm_s_mathrm_m_2(self) -> FieldQnty: ...

    @property
    def pascal_second(self) -> FieldQnty: ...

    @property
    def Pa_s_or_PI(self) -> FieldQnty: ...

    @property
    def Pa_s(self) -> FieldQnty: ...

    @property
    def PI(self) -> FieldQnty: ...

    @property
    def poise(self) -> FieldQnty: ...

    @property
    def P_or_Po(self) -> FieldQnty: ...

    @property
    def P(self) -> FieldQnty: ...

    @property
    def Po(self) -> FieldQnty: ...

    @property
    def pound_force_hour_per_square_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_h_mathrm_ft_2_or_mathrm_lb_mathrm_hr_mathrm_sq_ft(self) -> FieldQnty: ...

    @property
    def lb_f_h_ft_2(self) -> FieldQnty: ...

    @property
    def lb_hr_sq_ft(self) -> FieldQnty: ...

    @property
    def pound_force_second_per_square_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_f_mathrm_s_mathrm_ft_2_or_mathrm_lb_mathrm_sec_mathrm_sq_ft(self) -> FieldQnty: ...

    @property
    def lb_f_s_ft_2(self) -> FieldQnty: ...

    @property
    def lb_sec_sq_ft(self) -> FieldQnty: ...


class ViscosityKinematicSetter(TypeSafeSetter):
    """ViscosityKinematic-specific setter with unit properties."""

    __slots__ = ()

    @property
    def centistokes(self) -> FieldQnty: ...

    @property
    def cSt(self) -> FieldQnty: ...

    @property
    def millistokes(self) -> FieldQnty: ...

    @property
    def mSt(self) -> FieldQnty: ...

    @property
    def square_centimeter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_cm_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_h_or_mathrm_ft_2_mathrm_hr(self) -> FieldQnty: ...

    @property
    def ft_2_h(self) -> FieldQnty: ...

    @property
    def ft_2_hr(self) -> FieldQnty: ...

    @property
    def square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def square_meters_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_2_mathrm_s(self) -> FieldQnty: ...

    @property
    def stokes(self) -> FieldQnty: ...

    @property
    def St(self) -> FieldQnty: ...


class VolumeSetter(TypeSafeSetter):
    """Volume-specific setter with unit properties."""

    __slots__ = ()

    @property
    def acre_foot(self) -> FieldQnty: ...

    @property
    def ac_ft(self) -> FieldQnty: ...

    @property
    def acre_inch(self) -> FieldQnty: ...

    @property
    def ac_in(self) -> FieldQnty: ...

    @property
    def barrel_us_liquid(self) -> FieldQnty: ...

    @property
    def bbl_US_liq(self) -> FieldQnty: ...

    @property
    def barrel_us_petro(self) -> FieldQnty: ...

    @property
    def bbl(self) -> FieldQnty: ...

    @property
    def board_foot_measure(self) -> FieldQnty: ...

    @property
    def BM_or_fbm(self) -> FieldQnty: ...

    @property
    def BM(self) -> FieldQnty: ...

    @property
    def fbm(self) -> FieldQnty: ...

    @property
    def bushel_us_dry(self) -> FieldQnty: ...

    @property
    def bu_US_dry(self) -> FieldQnty: ...

    @property
    def centiliter(self) -> FieldQnty: ...

    @property
    def cl_or_cL(self) -> FieldQnty: ...

    @property
    def cl(self) -> FieldQnty: ...

    @property
    def cL(self) -> FieldQnty: ...

    @property
    def cord(self) -> FieldQnty: ...

    @property
    def cord_or_cd(self) -> FieldQnty: ...

    @property
    def cd(self) -> FieldQnty: ...

    @property
    def cord_foot(self) -> FieldQnty: ...

    @property
    def cord_ft(self) -> FieldQnty: ...

    @property
    def cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_cm_3_or_cc(self) -> FieldQnty: ...

    @property
    def cm_3(self) -> FieldQnty: ...

    @property
    def cc(self) -> FieldQnty: ...

    @property
    def cubic_decameter(self) -> FieldQnty: ...

    @property
    def dam_3(self) -> FieldQnty: ...

    @property
    def cubic_decimeter(self) -> FieldQnty: ...

    @property
    def mathrm_dm_3(self) -> FieldQnty: ...

    @property
    def cubic_foot(self) -> FieldQnty: ...

    @property
    def cu_ft_or_ft_3(self) -> FieldQnty: ...

    @property
    def cu_ft(self) -> FieldQnty: ...

    @property
    def ft_3(self) -> FieldQnty: ...

    @property
    def cubic_inch(self) -> FieldQnty: ...

    @property
    def cu_in_or_mathrm_in_3(self) -> FieldQnty: ...

    @property
    def cu_in(self) -> FieldQnty: ...

    @property
    def in_3(self) -> FieldQnty: ...

    @property
    def cubic_kilometer(self) -> FieldQnty: ...

    @property
    def mathrm_km_3(self) -> FieldQnty: ...

    @property
    def cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_m_3(self) -> FieldQnty: ...

    @property
    def cubic_micrometer(self) -> FieldQnty: ...

    @property
    def mu_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def cubic_mile_us_intl(self) -> FieldQnty: ...

    @property
    def cu_mi(self) -> FieldQnty: ...

    @property
    def cubic_millimeter(self) -> FieldQnty: ...

    @property
    def mathrm_mm_3(self) -> FieldQnty: ...

    @property
    def cubic_yard(self) -> FieldQnty: ...

    @property
    def cu_yd_or_mathrm_yd_3(self) -> FieldQnty: ...

    @property
    def cu_yd(self) -> FieldQnty: ...

    @property
    def yd_3(self) -> FieldQnty: ...

    @property
    def decast_re(self) -> FieldQnty: ...

    @property
    def dast(self) -> FieldQnty: ...

    @property
    def deciliter(self) -> FieldQnty: ...

    @property
    def dl_or_dL(self) -> FieldQnty: ...

    @property
    def dl(self) -> FieldQnty: ...

    @property
    def dL(self) -> FieldQnty: ...

    @property
    def fluid_drachm_uk(self) -> FieldQnty: ...

    @property
    def fl_dr_UK(self) -> FieldQnty: ...

    @property
    def fluid_dram_us(self) -> FieldQnty: ...

    @property
    def fl_dr_US_liq(self) -> FieldQnty: ...

    @property
    def fluid_ounce_us(self) -> FieldQnty: ...

    @property
    def fl_oz(self) -> FieldQnty: ...

    @property
    def gallon_imperial_uk(self) -> FieldQnty: ...

    @property
    def gal_UK_or_Imp_gal(self) -> FieldQnty: ...

    @property
    def gal_UK(self) -> FieldQnty: ...

    @property
    def Imp_gal(self) -> FieldQnty: ...

    @property
    def gallon_us_dry(self) -> FieldQnty: ...

    @property
    def gal_US_dry(self) -> FieldQnty: ...

    @property
    def gallon_us_liquid(self) -> FieldQnty: ...

    @property
    def gal(self) -> FieldQnty: ...

    @property
    def last(self) -> FieldQnty: ...

    @property
    def liter(self) -> FieldQnty: ...

    @property
    def unit_1_or_L(self) -> FieldQnty: ...

    @property
    def unit_1(self) -> FieldQnty: ...

    @property
    def L(self) -> FieldQnty: ...

    @property
    def microliter(self) -> FieldQnty: ...

    @property
    def mu_mathrm_l_or_mu_mathrm_L(self) -> FieldQnty: ...

    @property
    def mu_l(self) -> FieldQnty: ...

    @property
    def mu_L(self) -> FieldQnty: ...

    @property
    def milliliter(self) -> FieldQnty: ...

    @property
    def ml(self) -> FieldQnty: ...

    @property
    def mohr_centicube(self) -> FieldQnty: ...

    @property
    def pint_uk(self) -> FieldQnty: ...

    @property
    def pt_UK(self) -> FieldQnty: ...

    @property
    def pint_us_dry(self) -> FieldQnty: ...

    @property
    def pt_US_dry(self) -> FieldQnty: ...

    @property
    def pint_us_liquid(self) -> FieldQnty: ...

    @property
    def pt(self) -> FieldQnty: ...

    @property
    def quart_us_dry(self) -> FieldQnty: ...

    @property
    def qt_US_dry(self) -> FieldQnty: ...

    @property
    def st_re(self) -> FieldQnty: ...

    @property
    def st(self) -> FieldQnty: ...

    @property
    def tablespoon_metric(self) -> FieldQnty: ...

    @property
    def tbsp_Metric(self) -> FieldQnty: ...

    @property
    def tablespoon_us(self) -> FieldQnty: ...

    @property
    def tbsp(self) -> FieldQnty: ...

    @property
    def teaspoon_us(self) -> FieldQnty: ...

    @property
    def tsp(self) -> FieldQnty: ...


class VolumeFractionOfISetter(TypeSafeSetter):
    """VolumeFractionOfI-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cubic_centimeters_of_i_per_cubic_meter_total(self) -> FieldQnty: ...

    @property
    def mathrm_cm_mathrm_i_3_mathrm_m_3_or_mathrm_cc_mathrm_i_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def cm_i_3_m_3(self) -> FieldQnty: ...

    @property
    def cc_i_m_3(self) -> FieldQnty: ...

    @property
    def cubic_foot_of_i_per_cubic_foot_total(self) -> FieldQnty: ...

    @property
    def mathrm_ft_mathrm_i_3_mathrm_ft_3_or_mathrm_cft_mathrm_i_mathrm_cft(self) -> FieldQnty: ...

    @property
    def ft_i_3_ft_3(self) -> FieldQnty: ...

    @property
    def cft_i_cft(self) -> FieldQnty: ...

    @property
    def cubic_meters_of_i_per_cubic_meter_total(self) -> FieldQnty: ...

    @property
    def mathrm_m_mathrm_i_3_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def gallons_of_i_per_gallon_total(self) -> FieldQnty: ...

    @property
    def mathrm_gal_mathrm_i_mathrm_gal(self) -> FieldQnty: ...


class VolumetricCalorificHeatingValueSetter(TypeSafeSetter):
    """VolumetricCalorificHeatingValue-specific setter with unit properties."""

    __slots__ = ()

    @property
    def british_thermal_unit_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_Btu_mathrm_ft_3_or_Btu_cft(self) -> FieldQnty: ...

    @property
    def Btu_ft_3(self) -> FieldQnty: ...

    @property
    def Btu_cft(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_per_gallon_uk(self) -> FieldQnty: ...

    @property
    def Btu_gal_UK(self) -> FieldQnty: ...

    @property
    def british_thermal_unit_per_gallon_us(self) -> FieldQnty: ...

    @property
    def Btu_gal_US(self) -> FieldQnty: ...

    @property
    def calorie_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_cal_mathrm_cm_3_or_mathrm_cal_mathrm_cc(self) -> FieldQnty: ...

    @property
    def cal_cm_3(self) -> FieldQnty: ...

    @property
    def cal_cc(self) -> FieldQnty: ...

    @property
    def chu_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_Chu_mathrm_ft_3_or_mathrm_Chu_mathrm_cft(self) -> FieldQnty: ...

    @property
    def Chu_ft_3(self) -> FieldQnty: ...

    @property
    def Chu_cft(self) -> FieldQnty: ...

    @property
    def joule_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_J_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_mathrm_ft_3_or_mathrm_kcal_mathrm_cft(self) -> FieldQnty: ...

    @property
    def kcal_ft_3(self) -> FieldQnty: ...

    @property
    def kcal_cft(self) -> FieldQnty: ...

    @property
    def kilocalorie_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kcal_mathrm_m_3(self) -> FieldQnty: ...

    @property
    def therm_100_k_btu(self) -> FieldQnty: ...

    @property
    def thm_cft(self) -> FieldQnty: ...


class VolumetricCoefficientOfExpansionSetter(TypeSafeSetter):
    """VolumetricCoefficientOfExpansion-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_per_cubic_centimeter_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def mathrm_g_mathrm_cm_3_mathrm_K_or_g_cc_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def g_cm_3_K(self) -> FieldQnty: ...

    @property
    def g_cc_circ_C(self) -> FieldQnty: ...

    @property
    def kilogram_per_cubic_meter_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def mathrm_kg_mathrm_m_3_mathrm_K_or_mathrm_kg_mathrm_m_3_circ_C(self) -> FieldQnty: ...

    @property
    def kg_m_3_K(self) -> FieldQnty: ...

    @property
    def kg_m_3_circ_C(self) -> FieldQnty: ...

    @property
    def pound_per_cubic_foot_per_degree_fahrenheit_or_degree_rankine(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_ft_3_circ_mathrm_R_or_mathrm_lb_mathrm_cft_circ_mathrm_F(self) -> FieldQnty: ...

    @property
    def lb_ft_3_circ_R(self) -> FieldQnty: ...

    @property
    def lb_cft_circ_F(self) -> FieldQnty: ...

    @property
    def pound_per_cubic_foot_per_kelvin_or_degree_celsius(self) -> FieldQnty: ...

    @property
    def mathrm_lb_mathrm_ft_3_mathrm_K_or_mathrm_lb_mathrm_cft_circ_mathrm_C(self) -> FieldQnty: ...

    @property
    def lb_ft_3_K(self) -> FieldQnty: ...

    @property
    def lb_cft_circ_C(self) -> FieldQnty: ...


class VolumetricFlowRateSetter(TypeSafeSetter):
    """VolumetricFlowRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cubic_feet_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_d_or_mathrm_cft_mathrm_da_or_cfd(self) -> FieldQnty: ...

    @property
    def ft_3_d(self) -> FieldQnty: ...

    @property
    def cft_da(self) -> FieldQnty: ...

    @property
    def cfd(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_h_or_mathrm_cft_mathrm_hr_or_cfh(self) -> FieldQnty: ...

    @property
    def ft_3_h(self) -> FieldQnty: ...

    @property
    def cft_hr(self) -> FieldQnty: ...

    @property
    def cfh(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_min_or_mathrm_cft_mathrm_min_or_cfm(self) -> FieldQnty: ...

    @property
    def ft_3_min(self) -> FieldQnty: ...

    @property
    def cft_min(self) -> FieldQnty: ...

    @property
    def cfm(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_mathrm_s_or_cft_sec_or_cfs(self) -> FieldQnty: ...

    @property
    def ft_3_s(self) -> FieldQnty: ...

    @property
    def cft_sec(self) -> FieldQnty: ...

    @property
    def cfs(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_mathrm_d(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_mathrm_h(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_min(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_mathrm_s(self) -> FieldQnty: ...

    @property
    def gallons_per_day(self) -> FieldQnty: ...

    @property
    def gal_d_or_gpd_or_gal_da(self) -> FieldQnty: ...

    @property
    def gal_d(self) -> FieldQnty: ...

    @property
    def gpd(self) -> FieldQnty: ...

    @property
    def gal_da(self) -> FieldQnty: ...

    @property
    def gallons_per_hour(self) -> FieldQnty: ...

    @property
    def gal_h_or_gph_or_gal_hr(self) -> FieldQnty: ...

    @property
    def gal_h(self) -> FieldQnty: ...

    @property
    def gph(self) -> FieldQnty: ...

    @property
    def gal_hr(self) -> FieldQnty: ...

    @property
    def gallons_per_minute(self) -> FieldQnty: ...

    @property
    def gal_min_or_gpm(self) -> FieldQnty: ...

    @property
    def gal_min(self) -> FieldQnty: ...

    @property
    def gpm(self) -> FieldQnty: ...

    @property
    def gallons_per_second(self) -> FieldQnty: ...

    @property
    def gal_s_or_gps_or_gal_sec(self) -> FieldQnty: ...

    @property
    def gal_s(self) -> FieldQnty: ...

    @property
    def gps(self) -> FieldQnty: ...

    @property
    def gal_sec(self) -> FieldQnty: ...

    @property
    def liters_per_day(self) -> FieldQnty: ...

    @property
    def unit_1_d(self) -> FieldQnty: ...

    @property
    def liters_per_hour(self) -> FieldQnty: ...

    @property
    def unit_1_h(self) -> FieldQnty: ...

    @property
    def liters_per_minute(self) -> FieldQnty: ...

    @property
    def liters_per_second(self) -> FieldQnty: ...

    @property
    def unit_1_s(self) -> FieldQnty: ...


class VolumetricFluxSetter(TypeSafeSetter):
    """VolumetricFlux-specific setter with unit properties."""

    __slots__ = ()

    @property
    def cubic_feet_per_square_foot_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_d_right_or_mathrm_cft_mathrm_sqft_da(self) -> FieldQnty: ...

    @property
    def ft_3_left_ft_2_dright(self) -> FieldQnty: ...

    @property
    def cft_sqft_da(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_h_right_or_mathrm_cft_mathrm_sqft_hr(self) -> FieldQnty: ...

    @property
    def ft_3_left_ft_2_hright(self) -> FieldQnty: ...

    @property
    def cft_sqft_hr(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_square_foot_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_left_mathrm_ft_2_min_right_or_mathrm_cft_sqft_min(self) -> FieldQnty: ...

    @property
    def ft_3_left_ft_2_min_right(self) -> FieldQnty: ...

    @property
    def cft_sqft_min(self) -> FieldQnty: ...

    @property
    def cubic_feet_per_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_ft_3_left_mathrm_ft_2_mathrm_s_right_or_cft_sqft_sec(self) -> FieldQnty: ...

    @property
    def ft_3_left_ft_2_sright(self) -> FieldQnty: ...

    @property
    def cft_sqft_sec(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_square_meter_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_d_right(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_square_meter_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_h_right(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_square_meter_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_min_right(self) -> FieldQnty: ...

    @property
    def cubic_meters_per_square_meter_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_m_3_left_mathrm_m_2_mathrm_s_right(self) -> FieldQnty: ...

    @property
    def gallons_per_square_foot_per_day(self) -> FieldQnty: ...

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_d_right_or_gal_sqft_da(self) -> FieldQnty: ...

    @property
    def gal_left_ft_2_dright(self) -> FieldQnty: ...

    @property
    def gal_sqft_da(self) -> FieldQnty: ...

    @property
    def gallons_per_square_foot_per_hour(self) -> FieldQnty: ...

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_h_right_or_gal_sqft_hr(self) -> FieldQnty: ...

    @property
    def gal_left_ft_2_hright(self) -> FieldQnty: ...

    @property
    def gal_sqft_hr(self) -> FieldQnty: ...

    @property
    def gallons_per_square_foot_per_minute(self) -> FieldQnty: ...

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_min_right_or_gal_sqft_min_or_gpm_sqft(self) -> FieldQnty: ...

    @property
    def gal_left_ft_2_minright(self) -> FieldQnty: ...

    @property
    def gal_sqft_min(self) -> FieldQnty: ...

    @property
    def gpm_sqft(self) -> FieldQnty: ...

    @property
    def gallons_per_square_foot_per_second(self) -> FieldQnty: ...

    @property
    def mathrm_gal_left_mathrm_ft_2_mathrm_s_right_or_gal_mathrm_sqft_mathrm_sec(self) -> FieldQnty: ...

    @property
    def gal_left_ft_2_sright(self) -> FieldQnty: ...

    @property
    def gal_sqft_sec(self) -> FieldQnty: ...

    @property
    def liters_per_square_meter_per_day(self) -> FieldQnty: ...

    @property
    def liters_per_square_meter_per_hour(self) -> FieldQnty: ...

    @property
    def liters_per_square_meter_per_minute(self) -> FieldQnty: ...

    @property
    def liters_per_square_meter_per_second(self) -> FieldQnty: ...


class VolumetricMassFlowRateSetter(TypeSafeSetter):
    """VolumetricMassFlowRate-specific setter with unit properties."""

    __slots__ = ()

    @property
    def gram_per_second_per_cubic_centimeter(self) -> FieldQnty: ...

    @property
    def mathrm_g_left_mathrm_s_mathrm_cm_3_right_or_g_s_cc_or_mathrm_g_mathrm_cc_mathrm_sec(self) -> FieldQnty: ...

    @property
    def g_left_s_cm_3right(self) -> FieldQnty: ...

    @property
    def g_s_cc(self) -> FieldQnty: ...

    @property
    def g_cc_sec(self) -> FieldQnty: ...

    @property
    def kilogram_per_hour_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def kg_h_ft_3_or_kg_hr_cft(self) -> FieldQnty: ...

    @property
    def kg_h_ft_3(self) -> FieldQnty: ...

    @property
    def kg_hr_cft(self) -> FieldQnty: ...

    @property
    def kilogram_per_hour_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def kg_h_m3_or_kg_hr_cu_m(self) -> FieldQnty: ...

    @property
    def kg_h_m3(self) -> FieldQnty: ...

    @property
    def kg_hr_cu_m(self) -> FieldQnty: ...

    @property
    def kilogram_per_second_per_cubic_meter(self) -> FieldQnty: ...

    @property
    def mathrm_kg_left_mathrm_s_mathrm_m_3_right_or_kg_sec_cu_m(self) -> FieldQnty: ...

    @property
    def kg_left_s_m_3right(self) -> FieldQnty: ...

    @property
    def kg_sec_cu_m(self) -> FieldQnty: ...

    @property
    def pound_per_hour_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def mathrm_lb_left_mathrm_h_mathrm_ft_3_right_or_mathrm_lb_mathrm_hr_mathrm_cft_or_PPH_cft(self) -> FieldQnty: ...

    @property
    def lb_left_h_ft_3right(self) -> FieldQnty: ...

    @property
    def lb_hr_cft(self) -> FieldQnty: ...

    @property
    def PPH_cft(self) -> FieldQnty: ...

    @property
    def pound_per_minute_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def lb_min_mathrm_ft_3_or_lb_mathrm_min_mathrm_cft(self) -> FieldQnty: ...

    @property
    def lb_min_ft_3(self) -> FieldQnty: ...

    @property
    def lb_min_cft(self) -> FieldQnty: ...

    @property
    def pound_per_second_per_cubic_foot(self) -> FieldQnty: ...

    @property
    def b_s_ft_3_or_lb_sec_cft(self) -> FieldQnty: ...

    @property
    def b_s_ft_3(self) -> FieldQnty: ...

    @property
    def lb_sec_cft(self) -> FieldQnty: ...


class WavenumberSetter(TypeSafeSetter):
    """Wavenumber-specific setter with unit properties."""

    __slots__ = ()

    @property
    def diopter(self) -> FieldQnty: ...

    @property
    def D(self) -> FieldQnty: ...

    @property
    def kayser(self) -> FieldQnty: ...

    @property
    def K(self) -> FieldQnty: ...

    @property
    def reciprocal_meter(self) -> FieldQnty: ...

    @property
    def unit_1_m(self) -> FieldQnty: ...


