import typing

import Oanda.RestV20.Model
import System
import System.Collections.Generic
import System.ComponentModel.DataAnnotations

Oanda_RestV20_Model_InlineResponse20028 = typing.Any
Oanda_RestV20_Model_AccountID = typing.Any
Oanda_RestV20_Model_InlineResponse20029 = typing.Any
Oanda_RestV20_Model_LimitOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_OrderFillTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse20016 = typing.Any
Oanda_RestV20_Model_SetTradeClientExtensionsBody = typing.Any
Oanda_RestV20_Model_AccountChangesState = typing.Any
Oanda_RestV20_Model_OrderCancelRejectTransaction = typing.Any
Oanda_RestV20_Model_TakeProfitOrder = typing.Any
Oanda_RestV20_Model_OrderClientExtensionsModifyTransaction = typing.Any
Oanda_RestV20_Model_SetTradeDependentOrdersBody = typing.Any
Oanda_RestV20_Model_InlineResponse4005 = typing.Any
Oanda_RestV20_Model_LimitOrder = typing.Any
Oanda_RestV20_Model_StopLossOrderTransaction = typing.Any
Oanda_RestV20_Model_DelayedTradeClosureTransaction = typing.Any
Oanda_RestV20_Model_CandlestickData = typing.Any
Oanda_RestV20_Model_Position = typing.Any
Oanda_RestV20_Model_OrderRequest = typing.Any
Oanda_RestV20_Model_PriceValue = typing.Any
Oanda_RestV20_Model_ReplaceOrderBody = typing.Any
Oanda_RestV20_Model_InlineResponse4043 = typing.Any
Oanda_RestV20_Model_MarketIfTouchedOrderRequest = typing.Any
Oanda_RestV20_Model_UnitsAvailable = typing.Any
Oanda_RestV20_Model_OrderClientExtensionsModifyRejectTransaction = typing.Any
Oanda_RestV20_Model_TakeProfitOrderTransaction = typing.Any
Oanda_RestV20_Model_StopLossDetails = typing.Any
Oanda_RestV20_Model_InlineResponse20027 = typing.Any
Oanda_RestV20_Model_InlineResponse2008 = typing.Any
Oanda_RestV20_Model_RequestID = typing.Any
Oanda_RestV20_Model_Candlestick = typing.Any
Oanda_RestV20_Model_InlineResponse2007 = typing.Any
Oanda_RestV20_Model_TrailingStopLossOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_StopOrder = typing.Any
Oanda_RestV20_Model_MarketOrderRequest = typing.Any
Oanda_RestV20_Model_InlineResponse2005 = typing.Any
Oanda_RestV20_Model_Currency = typing.Any
Oanda_RestV20_Model_InlineResponse20018 = typing.Any
Oanda_RestV20_Model_InlineResponse20026 = typing.Any
Oanda_RestV20_Model_InlineResponse400 = typing.Any
Oanda_RestV20_Model_LimitOrderTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse2009 = typing.Any
Oanda_RestV20_Model_InlineResponse4007 = typing.Any
Oanda_RestV20_Model_OrderCancelTransaction = typing.Any
Oanda_RestV20_Model_InstrumentName = typing.Any
Oanda_RestV20_Model_OpenTradeFinancing = typing.Any
Oanda_RestV20_Model_InlineResponse4045 = typing.Any
Oanda_RestV20_Model_TakeProfitOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_StopLossOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_TradeSummary = typing.Any
Oanda_RestV20_Model_ReopenTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse2004 = typing.Any
Oanda_RestV20_Model_AccountUnits = typing.Any
Oanda_RestV20_Model_Account = typing.Any
Oanda_RestV20_Model_DynamicOrderState = typing.Any
Oanda_RestV20_Model_Transaction = typing.Any
Oanda_RestV20_Model_CalculatedPositionState = typing.Any
Oanda_RestV20_Model_MarketOrderTradeClose = typing.Any
Oanda_RestV20_Model_TransferFundsRejectTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse20023 = typing.Any
Oanda_RestV20_Model_InlineResponse20017 = typing.Any
Oanda_RestV20_Model_InlineResponse4046 = typing.Any
Oanda_RestV20_Model_LimitOrderRequest = typing.Any
Oanda_RestV20_Model_LiquidityRegenerationSchedule = typing.Any
Oanda_RestV20_Model_OrderIdentifier = typing.Any
Oanda_RestV20_Model_UnitsAvailableDetails = typing.Any
Oanda_RestV20_Model_UserSpecifier = typing.Any
Oanda_RestV20_Model_MarketIfTouchedOrderTransaction = typing.Any
Oanda_RestV20_Model_TradeID = typing.Any
Oanda_RestV20_Model_ClosePositionBody = typing.Any
Oanda_RestV20_Model_CreateOrderBody = typing.Any
Oanda_RestV20_Model_MarketIfTouchedOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_MarginCallExitTransaction = typing.Any
Oanda_RestV20_Model_StopOrderRequest = typing.Any
Oanda_RestV20_Model_TradeClientExtensionsModifyTransaction = typing.Any
Oanda_RestV20_Model_Trade = typing.Any
Oanda_RestV20_Model_ResetResettablePLTransaction = typing.Any
Oanda_RestV20_Model_ClientTag = typing.Any
Oanda_RestV20_Model_VWAPReceipt = typing.Any
Oanda_RestV20_Model_MarketOrderMarginCloseout = typing.Any
Oanda_RestV20_Model_PriceBucket = typing.Any
Oanda_RestV20_Model_InlineResponse20010 = typing.Any
Oanda_RestV20_Model_DecimalNumber = typing.Any
Oanda_RestV20_Model_TradeSpecifier = typing.Any
Oanda_RestV20_Model_ClientExtensions = typing.Any
Oanda_RestV20_Model_StopLossOrderRequest = typing.Any
Oanda_RestV20_Model_TakeProfitDetails = typing.Any
Oanda_RestV20_Model_InlineResponse4003 = typing.Any
Oanda_RestV20_Model_InlineResponse20024 = typing.Any
Oanda_RestV20_Model_TakeProfitOrderRequest = typing.Any
Oanda_RestV20_Model_InlineResponse201 = typing.Any
Oanda_RestV20_Model_InlineResponse4002 = typing.Any
Oanda_RestV20_Model_CloseTradeBody = typing.Any
Oanda_RestV20_Model_InlineResponse4004 = typing.Any
Oanda_RestV20_Model_DailyFinancingTransaction = typing.Any
Oanda_RestV20_Model_UserInfoExternal = typing.Any
Oanda_RestV20_Model_OrderID = typing.Any
Oanda_RestV20_Model_InlineResponse200 = typing.Any
Oanda_RestV20_Model_SetOrderClientExtensionsBody = typing.Any
Oanda_RestV20_Model_PositionFinancing = typing.Any
Oanda_RestV20_Model_DateTime = typing.Any
Oanda_RestV20_Model_MarketOrderDelayedTradeClose = typing.Any
Oanda_RestV20_Model_InlineResponse20022 = typing.Any
Oanda_RestV20_Model_Order = typing.Any
Oanda_RestV20_Model_ClientConfigureRejectTransaction = typing.Any
Oanda_RestV20_Model_ClientConfigureTransaction = typing.Any
Oanda_RestV20_Model_MarginCallEnterTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse20025 = typing.Any
Oanda_RestV20_Model_InlineResponse20021 = typing.Any
Oanda_RestV20_Model_TransactionHeartbeat = typing.Any
Oanda_RestV20_Model_InlineResponse4044 = typing.Any
Oanda_RestV20_Model_AccountSummary = typing.Any
Oanda_RestV20_Model_InlineResponse20012 = typing.Any
Oanda_RestV20_Model_InlineResponse4001 = typing.Any
Oanda_RestV20_Model_TradeReduce = typing.Any
Oanda_RestV20_Model_InlineResponse2011 = typing.Any
Oanda_RestV20_Model_InlineResponse4042 = typing.Any
Oanda_RestV20_Model_InlineResponse20013 = typing.Any
Oanda_RestV20_Model_InlineResponse2002 = typing.Any
Oanda_RestV20_Model_TrailingStopLossOrderRequest = typing.Any
Oanda_RestV20_Model_InlineResponse404 = typing.Any
Oanda_RestV20_Model_MarketOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_StopOrderRejectTransaction = typing.Any
Oanda_RestV20_Model_TradeClientExtensionsModifyRejectTransaction = typing.Any
Oanda_RestV20_Model_TransactionID = typing.Any
Oanda_RestV20_Model_InlineResponse20014 = typing.Any
Oanda_RestV20_Model_TransferFundsTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse2001 = typing.Any
Oanda_RestV20_Model_InlineResponse401 = typing.Any
Oanda_RestV20_Model_MarketOrder = typing.Any
Oanda_RestV20_Model_MarginCallExtendTransaction = typing.Any
Oanda_RestV20_Model_MarketIfTouchedOrder = typing.Any
Oanda_RestV20_Model_Instrument = typing.Any
Oanda_RestV20_Model_MarketOrderPositionCloseout = typing.Any
Oanda_RestV20_Model_QuoteHomeConversionFactors = typing.Any
Oanda_RestV20_Model_LiquidityRegenerationScheduleStep = typing.Any
Oanda_RestV20_Model_InlineResponse20019 = typing.Any
Oanda_RestV20_Model_InlineResponse2003 = typing.Any
Oanda_RestV20_Model_ClientComment = typing.Any
Oanda_RestV20_Model_CreateTransaction = typing.Any
Oanda_RestV20_Model_InlineResponse20015 = typing.Any
Oanda_RestV20_Model_UserInfo = typing.Any
Oanda_RestV20_Model_InlineResponse4006 = typing.Any
Oanda_RestV20_Model_AccountChanges = typing.Any
Oanda_RestV20_Model_ClientID = typing.Any
Oanda_RestV20_Model_ConfigureAccountBody = typing.Any
Oanda_RestV20_Model_TrailingStopLossOrderTransaction = typing.Any
Oanda_RestV20_Model_PricingHeartbeat = typing.Any
Oanda_RestV20_Model_StopLossOrder = typing.Any
Oanda_RestV20_Model_InlineResponse4041 = typing.Any
Oanda_RestV20_Model_TrailingStopLossOrder = typing.Any
Oanda_RestV20_Model_TradeOpen = typing.Any
Oanda_RestV20_Model_OrderSpecifier = typing.Any
Oanda_RestV20_Model_CalculatedTradeState = typing.Any
Oanda_RestV20_Model_PositionSide = typing.Any
Oanda_RestV20_Model_InlineResponse20020 = typing.Any
Oanda_RestV20_Model_StopOrderTransaction = typing.Any
Oanda_RestV20_Model_MarketOrderTransaction = typing.Any
Oanda_RestV20_Model_Price = typing.Any
Oanda_RestV20_Model_InlineResponse20011 = typing.Any
Oanda_RestV20_Model_AccountProperties = typing.Any
Oanda_RestV20_Model_InlineResponse2006 = typing.Any
Oanda_RestV20_Model_TrailingStopLossDetails = typing.Any
Oanda_RestV20_Model_CloseTransaction = typing.Any


class OrderCancelTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderCancelTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An OrderCancelTransaction represents the cancellation of an Order in the client's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL\\" for an OrderCancelTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class ReasonEnum(System.Enum):
        """The reason that the Order was cancelled."""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        ACCOUNTLOCKED = 1
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTNEWPOSITIONSLOCKED = 2
        """Enum ACCOUNTNEWPOSITIONSLOCKED for "ACCOUNT_NEW_POSITIONS_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 3
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTORDERFILLLOCKED = 4
        """Enum ACCOUNTORDERFILLLOCKED for "ACCOUNT_ORDER_FILL_LOCKED\""""

        CLIENTREQUEST = 5
        """Enum CLIENTREQUEST for "CLIENT_REQUEST\""""

        MIGRATION = 6
        """Enum MIGRATION for "MIGRATION\""""

        MARKETHALTED = 7
        """Enum MARKETHALTED for "MARKET_HALTED\""""

        LINKEDTRADECLOSED = 8
        """Enum LINKEDTRADECLOSED for "LINKED_TRADE_CLOSED\""""

        TIMEINFORCEEXPIRED = 9
        """Enum TIMEINFORCEEXPIRED for "TIME_IN_FORCE_EXPIRED\""""

        INSUFFICIENTMARGIN = 10
        """Enum INSUFFICIENTMARGIN for "INSUFFICIENT_MARGIN\""""

        FIFOVIOLATION = 11
        """Enum FIFOVIOLATION for "FIFO_VIOLATION\""""

        BOUNDSVIOLATION = 12
        """Enum BOUNDSVIOLATION for "BOUNDS_VIOLATION\""""

        CLIENTREQUESTREPLACED = 13
        """Enum CLIENTREQUESTREPLACED for "CLIENT_REQUEST_REPLACED\""""

        INSUFFICIENTLIQUIDITY = 14
        """Enum INSUFFICIENTLIQUIDITY for "INSUFFICIENT_LIQUIDITY\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 15
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLLOSS = 16
        """Enum TAKEPROFITONFILLLOSS for "TAKE_PROFIT_ON_FILL_LOSS\""""

        LOSINGTAKEPROFIT = 17
        """Enum LOSINGTAKEPROFIT for "LOSING_TAKE_PROFIT\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 18
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLLOSS = 19
        """Enum STOPLOSSONFILLLOSS for "STOP_LOSS_ON_FILL_LOSS\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 20
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        CLIENTTRADEIDALREADYEXISTS = 21
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        POSITIONCLOSEOUTFAILED = 22
        """Enum POSITIONCLOSEOUTFAILED for "POSITION_CLOSEOUT_FAILED\""""

        OPENTRADESALLOWEDEXCEEDED = 23
        """Enum OPENTRADESALLOWEDEXCEEDED for "OPEN_TRADES_ALLOWED_EXCEEDED\""""

        PENDINGORDERSALLOWEDEXCEEDED = 24
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS = 25
        """Enum TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS = 26
        """Enum STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS = 27
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        POSITIONSIZEEXCEEDED = 28
        """Enum POSITIONSIZEEXCEEDED for "POSITION_SIZE_EXCEEDED\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL\\" for an OrderCancelTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL\\" for an OrderCancelTransaction."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.ReasonEnum]:
        """The reason that the Order was cancelled."""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.ReasonEnum]):
        """The reason that the Order was cancelled."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def OrderID(self) -> str:
        """The ID of the Order cancelled"""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The ID of the Order cancelled"""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The client ID of the Order cancelled (only provided if the Order has a client Order ID)."""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The client ID of the Order cancelled (only provided if the Order has a client Order ID)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.TypeEnum] = ..., OrderID: str = ..., ClientOrderID: str = ..., Reason: typing.Optional[Oanda.RestV20.Model.OrderCancelTransaction.ReasonEnum] = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the OrderCancelTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"ORDER_CANCEL\\" for an OrderCancelTransaction..
        :param OrderID: The ID of the Order cancelled.
        :param ClientOrderID: The client ID of the Order cancelled (only provided if the Order has a client Order ID)..
        :param Reason: The reason that the Order was cancelled..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled for replacement)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderCancelTransaction) -> bool:
        """
        Returns true if OrderCancelTransaction instances are equal
        
        :param other: Instance of OrderCancelTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ClientExtensions(System.Object, System.IEquatable[Oanda_RestV20_Model_ClientExtensions], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A ClientExtensions object allows a client to attach a clientID, tag and comment to Orders and Trades in their Account.  Do not set, modify, or delete this field if your account is associated with MT4."""

    @property
    def Id(self) -> str:
        """The Client ID of the Order/Trade"""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Client ID of the Order/Trade"""
        ...

    @property
    def Tag(self) -> str:
        """A tag associated with the Order/Trade"""
        ...

    @Tag.setter
    def Tag(self, value: str):
        """A tag associated with the Order/Trade"""
        ...

    @property
    def Comment(self) -> str:
        """A comment associated with the Order/Trade"""
        ...

    @Comment.setter
    def Comment(self, value: str):
        """A comment associated with the Order/Trade"""
        ...

    def __init__(self, Id: str = ..., Tag: str = ..., Comment: str = ...) -> None:
        """
        Initializes a new instance of the ClientExtensions class.
        
        :param Id: The Client ID of the Order/Trade.
        :param Tag: A tag associated with the Order/Trade.
        :param Comment: A comment associated with the Order/Trade.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ClientExtensions) -> bool:
        """
        Returns true if ClientExtensions instances are equal
        
        :param other: Instance of ClientExtensions to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TakeProfitOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TakeProfitOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TakeProfitOrderTransaction represents the creation of a TakeProfit Order in the user's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER\\" in a TakeProfitOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Take Profit Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER\\" in a TakeProfitOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER\\" in a TakeProfitOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.ReasonEnum]:
        """The reason that the Take Profit Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.ReasonEnum]):
        """The reason that the Take Profit Order was initiated"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., ReplacesOrderID: str = ..., CancellingTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the TakeProfitOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER\\" in a TakeProfitOrderTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold..
        :param TimeInForce: The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders..
        :param GtdTime: The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Take Profit Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param ReplacesOrderID: The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)..
        :param CancellingTransactionID: The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TakeProfitOrderTransaction) -> bool:
        """
        Returns true if TakeProfitOrderTransaction instances are equal
        
        :param other: Instance of TakeProfitOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeOpen(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeOpen], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TradeOpen object represents a Trade for an instrument that was opened in an Account. It is found embedded in Transactions that affect the position of an instrument in the Account, specifically the OrderFill Transaction."""

    @property
    def TradeID(self) -> str:
        """The ID of the Trade that was opened"""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade that was opened"""
        ...

    @property
    def Units(self) -> str:
        """The number of units opened by the Trade"""
        ...

    @Units.setter
    def Units(self, value: str):
        """The number of units opened by the Trade"""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, TradeID: str = ..., Units: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the TradeOpen class.
        
        :param TradeID: The ID of the Trade that was opened.
        :param Units: The number of units opened by the Trade.
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeOpen) -> bool:
        """
        Returns true if TradeOpen instances are equal
        
        :param other: Instance of TradeOpen to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeReduce(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeReduce], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TradeReduce object represents a Trade for an instrument that was reduced (either partially or fully) in an Account. It is found embedded in Transactions that affect the position of an instrument in the account, specifically the OrderFill Transaction."""

    @property
    def TradeID(self) -> str:
        """The ID of the Trade that was reduced or closed"""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade that was reduced or closed"""
        ...

    @property
    def Units(self) -> str:
        """The number of units that the Trade was reduced by"""
        ...

    @Units.setter
    def Units(self, value: str):
        """The number of units that the Trade was reduced by"""
        ...

    @property
    def RealizedPL(self) -> str:
        """The PL realized when reducing the Trade"""
        ...

    @RealizedPL.setter
    def RealizedPL(self, value: str):
        """The PL realized when reducing the Trade"""
        ...

    @property
    def Financing(self) -> str:
        """The financing paid/collected when reducing the Trade"""
        ...

    @Financing.setter
    def Financing(self, value: str):
        """The financing paid/collected when reducing the Trade"""
        ...

    def __init__(self, TradeID: str = ..., Units: str = ..., RealizedPL: str = ..., Financing: str = ...) -> None:
        """
        Initializes a new instance of the TradeReduce class.
        
        :param TradeID: The ID of the Trade that was reduced or closed.
        :param Units: The number of units that the Trade was reduced by.
        :param RealizedPL: The PL realized when reducing the Trade.
        :param Financing: The financing paid/collected when reducing the Trade.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeReduce) -> bool:
        """
        Returns true if TradeReduce instances are equal
        
        :param other: Instance of TradeReduce to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderFillTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderFillTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An OrderFillTransaction represents the filling of an Order in the client's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"ORDER_FILL\\" for an OrderFillTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class ReasonEnum(System.Enum):
        """The reason that an Order was filled"""

        LIMITORDER = 0
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        STOPORDER = 1
        """Enum STOPORDER for "STOP_ORDER\""""

        MARKETIFTOUCHEDORDER = 2
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        TAKEPROFITORDER = 3
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        STOPLOSSORDER = 4
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDER = 5
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        MARKETORDER = 6
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERTRADECLOSE = 7
        """Enum MARKETORDERTRADECLOSE for "MARKET_ORDER_TRADE_CLOSE\""""

        MARKETORDERPOSITIONCLOSEOUT = 8
        """Enum MARKETORDERPOSITIONCLOSEOUT for "MARKET_ORDER_POSITION_CLOSEOUT\""""

        MARKETORDERMARGINCLOSEOUT = 9
        """Enum MARKETORDERMARGINCLOSEOUT for "MARKET_ORDER_MARGIN_CLOSEOUT\""""

        MARKETORDERDELAYEDTRADECLOSE = 10
        """Enum MARKETORDERDELAYEDTRADECLOSE for "MARKET_ORDER_DELAYED_TRADE_CLOSE\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"ORDER_FILL\\" for an OrderFillTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"ORDER_FILL\\" for an OrderFillTransaction."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.ReasonEnum]:
        """The reason that an Order was filled"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.ReasonEnum]):
        """The reason that an Order was filled"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def OrderID(self) -> str:
        """The ID of the Order filled."""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The ID of the Order filled."""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The client Order ID of the Order filled (only provided if the client has assigned one)."""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The client Order ID of the Order filled (only provided if the client has assigned one)."""
        ...

    @property
    def Instrument(self) -> str:
        """The name of the filled Order's instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The name of the filled Order's instrument."""
        ...

    @property
    def Units(self) -> str:
        """The number of units filled by the Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The number of units filled by the Order."""
        ...

    @property
    def Price(self) -> str:
        """The average market price that the Order was filled at."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The average market price that the Order was filled at."""
        ...

    @property
    def Pl(self) -> str:
        """The profit or loss incurred when the Order was filled."""
        ...

    @Pl.setter
    def Pl(self, value: str):
        """The profit or loss incurred when the Order was filled."""
        ...

    @property
    def Financing(self) -> str:
        """The financing paid or collected when the Order was filled."""
        ...

    @Financing.setter
    def Financing(self, value: str):
        """The financing paid or collected when the Order was filled."""
        ...

    @property
    def AccountBalance(self) -> str:
        """The Account's balance after the Order was filled."""
        ...

    @AccountBalance.setter
    def AccountBalance(self, value: str):
        """The Account's balance after the Order was filled."""
        ...

    @property
    def TradeOpened(self) -> Oanda.RestV20.Model.TradeOpen:
        """Gets or Sets TradeOpened"""
        ...

    @TradeOpened.setter
    def TradeOpened(self, value: Oanda.RestV20.Model.TradeOpen):
        """Gets or Sets TradeOpened"""
        ...

    @property
    def TradesClosed(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.TradeReduce]:
        """The Trades that were closed when the Order was filled (only provided if filling the Order resulted in a closing open Trades)."""
        ...

    @TradesClosed.setter
    def TradesClosed(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.TradeReduce]):
        """The Trades that were closed when the Order was filled (only provided if filling the Order resulted in a closing open Trades)."""
        ...

    @property
    def TradeReduced(self) -> Oanda.RestV20.Model.TradeReduce:
        """Gets or Sets TradeReduced"""
        ...

    @TradeReduced.setter
    def TradeReduced(self, value: Oanda.RestV20.Model.TradeReduce):
        """Gets or Sets TradeReduced"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.TypeEnum] = ..., OrderID: str = ..., ClientOrderID: str = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., Reason: typing.Optional[Oanda.RestV20.Model.OrderFillTransaction.ReasonEnum] = ..., Pl: str = ..., Financing: str = ..., AccountBalance: str = ..., TradeOpened: Oanda.RestV20.Model.TradeOpen = ..., TradesClosed: System.Collections.Generic.List[Oanda.RestV20.Model.TradeReduce] = ..., TradeReduced: Oanda.RestV20.Model.TradeReduce = ...) -> None:
        """
        Initializes a new instance of the OrderFillTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"ORDER_FILL\\" for an OrderFillTransaction..
        :param OrderID: The ID of the Order filled..
        :param ClientOrderID: The client Order ID of the Order filled (only provided if the client has assigned one)..
        :param Instrument: The name of the filled Order's instrument..
        :param Units: The number of units filled by the Order..
        :param Price: The average market price that the Order was filled at..
        :param Reason: The reason that an Order was filled.
        :param Pl: The profit or loss incurred when the Order was filled..
        :param Financing: The financing paid or collected when the Order was filled..
        :param AccountBalance: The Account's balance after the Order was filled..
        :param TradeOpened: TradeOpened.
        :param TradesClosed: The Trades that were closed when the Order was filled (only provided if filling the Order resulted in a closing open Trades)..
        :param TradeReduced: TradeReduced.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderFillTransaction) -> bool:
        """
        Returns true if OrderFillTransaction instances are equal
        
        :param other: Instance of OrderFillTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_StopLossOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopLossOrderTransaction represents the creation of a StopLoss Order in the user's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER\\" in a StopLossOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Stop Loss Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER\\" in a StopLossOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER\\" in a StopLossOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.ReasonEnum]:
        """The reason that the Stop Loss Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.ReasonEnum]):
        """The reason that the Stop Loss Order was initiated"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.StopLossOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., ReplacesOrderID: str = ..., CancellingTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the StopLossOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER\\" in a StopLossOrderTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold..
        :param TimeInForce: The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Stop Loss Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param ReplacesOrderID: The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)..
        :param CancellingTransactionID: The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopLossOrderTransaction) -> bool:
        """
        Returns true if StopLossOrderTransaction instances are equal
        
        :param other: Instance of StopLossOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TrailingStopLossOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TrailingStopLossOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TrailingStopLossOrderTransaction represents the creation of a TrailingStopLoss Order in the user's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER\\" in a TrailingStopLossOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Trailing Stop Loss Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER\\" in a TrailingStopLossOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER\\" in a TrailingStopLossOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.ReasonEnum]:
        """The reason that the Trailing Stop Loss Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.ReasonEnum]):
        """The reason that the Trailing Stop Loss Order was initiated"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Distance(self) -> str:
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @Distance.setter
    def Distance(self, value: str):
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Distance: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., ReplacesOrderID: str = ..., CancellingTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the TrailingStopLossOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER\\" in a TrailingStopLossOrderTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Distance: The price distance specified for the TrailingStopLoss Order..
        :param TimeInForce: The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Trailing Stop Loss Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param ReplacesOrderID: The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)..
        :param CancellingTransactionID: The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TrailingStopLossOrderTransaction) -> bool:
        """
        Returns true if TrailingStopLossOrderTransaction instances are equal
        
        :param other: Instance of TrailingStopLossOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20028(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20028], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20028"""

    @property
    def TakeProfitOrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets TakeProfitOrderCancelTransaction"""
        ...

    @TakeProfitOrderCancelTransaction.setter
    def TakeProfitOrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets TakeProfitOrderCancelTransaction"""
        ...

    @property
    def TakeProfitOrderTransaction(self) -> Oanda.RestV20.Model.TakeProfitOrderTransaction:
        """Gets or Sets TakeProfitOrderTransaction"""
        ...

    @TakeProfitOrderTransaction.setter
    def TakeProfitOrderTransaction(self, value: Oanda.RestV20.Model.TakeProfitOrderTransaction):
        """Gets or Sets TakeProfitOrderTransaction"""
        ...

    @property
    def TakeProfitOrderFillTransaction(self) -> Oanda.RestV20.Model.OrderFillTransaction:
        """Gets or Sets TakeProfitOrderFillTransaction"""
        ...

    @TakeProfitOrderFillTransaction.setter
    def TakeProfitOrderFillTransaction(self, value: Oanda.RestV20.Model.OrderFillTransaction):
        """Gets or Sets TakeProfitOrderFillTransaction"""
        ...

    @property
    def TakeProfitOrderCreatedCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets TakeProfitOrderCreatedCancelTransaction"""
        ...

    @TakeProfitOrderCreatedCancelTransaction.setter
    def TakeProfitOrderCreatedCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets TakeProfitOrderCreatedCancelTransaction"""
        ...

    @property
    def StopLossOrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets StopLossOrderCancelTransaction"""
        ...

    @StopLossOrderCancelTransaction.setter
    def StopLossOrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets StopLossOrderCancelTransaction"""
        ...

    @property
    def StopLossOrderTransaction(self) -> Oanda.RestV20.Model.StopLossOrderTransaction:
        """Gets or Sets StopLossOrderTransaction"""
        ...

    @StopLossOrderTransaction.setter
    def StopLossOrderTransaction(self, value: Oanda.RestV20.Model.StopLossOrderTransaction):
        """Gets or Sets StopLossOrderTransaction"""
        ...

    @property
    def StopLossOrderFillTransaction(self) -> Oanda.RestV20.Model.OrderFillTransaction:
        """Gets or Sets StopLossOrderFillTransaction"""
        ...

    @StopLossOrderFillTransaction.setter
    def StopLossOrderFillTransaction(self, value: Oanda.RestV20.Model.OrderFillTransaction):
        """Gets or Sets StopLossOrderFillTransaction"""
        ...

    @property
    def StopLossOrderCreatedCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets StopLossOrderCreatedCancelTransaction"""
        ...

    @StopLossOrderCreatedCancelTransaction.setter
    def StopLossOrderCreatedCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets StopLossOrderCreatedCancelTransaction"""
        ...

    @property
    def TrailingStopLossOrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets TrailingStopLossOrderCancelTransaction"""
        ...

    @TrailingStopLossOrderCancelTransaction.setter
    def TrailingStopLossOrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets TrailingStopLossOrderCancelTransaction"""
        ...

    @property
    def TrailingStopLossOrderTransaction(self) -> Oanda.RestV20.Model.TrailingStopLossOrderTransaction:
        """Gets or Sets TrailingStopLossOrderTransaction"""
        ...

    @TrailingStopLossOrderTransaction.setter
    def TrailingStopLossOrderTransaction(self, value: Oanda.RestV20.Model.TrailingStopLossOrderTransaction):
        """Gets or Sets TrailingStopLossOrderTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, TakeProfitOrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., TakeProfitOrderTransaction: Oanda.RestV20.Model.TakeProfitOrderTransaction = ..., TakeProfitOrderFillTransaction: Oanda.RestV20.Model.OrderFillTransaction = ..., TakeProfitOrderCreatedCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., StopLossOrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., StopLossOrderTransaction: Oanda.RestV20.Model.StopLossOrderTransaction = ..., StopLossOrderFillTransaction: Oanda.RestV20.Model.OrderFillTransaction = ..., StopLossOrderCreatedCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., TrailingStopLossOrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., TrailingStopLossOrderTransaction: Oanda.RestV20.Model.TrailingStopLossOrderTransaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20028 class.
        
        :param TakeProfitOrderCancelTransaction: TakeProfitOrderCancelTransaction.
        :param TakeProfitOrderTransaction: TakeProfitOrderTransaction.
        :param TakeProfitOrderFillTransaction: TakeProfitOrderFillTransaction.
        :param TakeProfitOrderCreatedCancelTransaction: TakeProfitOrderCreatedCancelTransaction.
        :param StopLossOrderCancelTransaction: StopLossOrderCancelTransaction.
        :param StopLossOrderTransaction: StopLossOrderTransaction.
        :param StopLossOrderFillTransaction: StopLossOrderFillTransaction.
        :param StopLossOrderCreatedCancelTransaction: StopLossOrderCreatedCancelTransaction.
        :param TrailingStopLossOrderCancelTransaction: TrailingStopLossOrderCancelTransaction.
        :param TrailingStopLossOrderTransaction: TrailingStopLossOrderTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20028) -> bool:
        """
        Returns true if InlineResponse20028 instances are equal
        
        :param other: Instance of InlineResponse20028 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class WeeklyAlignment(System.Enum):
    """The day of the week to use for candlestick granularities with weekly alignment."""

    Monday = 0
    """Enum Monday for "Monday\""""

    Tuesday = 1
    """Enum Tuesday for "Tuesday\""""

    Wednesday = 2
    """Enum Wednesday for "Wednesday\""""

    Thursday = 3
    """Enum Thursday for "Thursday\""""

    Friday = 4
    """Enum Friday for "Friday\""""

    Saturday = 5
    """Enum Saturday for "Saturday\""""

    Sunday = 6
    """Enum Sunday for "Sunday\""""


class AccountID(System.Object, System.IEquatable[Oanda_RestV20_Model_AccountID], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The string representation of an Account Identifier."""

    def __init__(self) -> None:
        """Initializes a new instance of the AccountID class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.AccountID) -> bool:
        """
        Returns true if AccountID instances are equal
        
        :param other: Instance of AccountID to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TransactionFilter(System.Enum):
    """A filter that can be used when fetching Transactions"""

    ORDER = 0
    """Enum ORDER for "ORDER\""""

    FUNDING = 1
    """Enum FUNDING for "FUNDING\""""

    ADMIN = 2
    """Enum ADMIN for "ADMIN\""""

    CREATE = 3
    """Enum CREATE for "CREATE\""""

    CLOSE = 4
    """Enum CLOSE for "CLOSE\""""

    REOPEN = 5
    """Enum REOPEN for "REOPEN\""""

    CLIENTCONFIGURE = 6
    """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

    CLIENTCONFIGUREREJECT = 7
    """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

    TRANSFERFUNDS = 8
    """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

    TRANSFERFUNDSREJECT = 9
    """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

    MARKETORDER = 10
    """Enum MARKETORDER for "MARKET_ORDER\""""

    MARKETORDERREJECT = 11
    """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

    LIMITORDER = 12
    """Enum LIMITORDER for "LIMIT_ORDER\""""

    LIMITORDERREJECT = 13
    """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

    STOPORDER = 14
    """Enum STOPORDER for "STOP_ORDER\""""

    STOPORDERREJECT = 15
    """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

    MARKETIFTOUCHEDORDER = 16
    """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

    MARKETIFTOUCHEDORDERREJECT = 17
    """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

    TAKEPROFITORDER = 18
    """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

    TAKEPROFITORDERREJECT = 19
    """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

    STOPLOSSORDER = 20
    """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

    STOPLOSSORDERREJECT = 21
    """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

    TRAILINGSTOPLOSSORDER = 22
    """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

    TRAILINGSTOPLOSSORDERREJECT = 23
    """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

    ONECANCELSALLORDER = 24
    """Enum ONECANCELSALLORDER for "ONE_CANCELS_ALL_ORDER\""""

    ONECANCELSALLORDERREJECT = 25
    """Enum ONECANCELSALLORDERREJECT for "ONE_CANCELS_ALL_ORDER_REJECT\""""

    ONECANCELSALLORDERTRIGGERED = 26
    """Enum ONECANCELSALLORDERTRIGGERED for "ONE_CANCELS_ALL_ORDER_TRIGGERED\""""

    ORDERFILL = 27
    """Enum ORDERFILL for "ORDER_FILL\""""

    ORDERCANCEL = 28
    """Enum ORDERCANCEL for "ORDER_CANCEL\""""

    ORDERCANCELREJECT = 29
    """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

    ORDERCLIENTEXTENSIONSMODIFY = 30
    """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

    ORDERCLIENTEXTENSIONSMODIFYREJECT = 31
    """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

    TRADECLIENTEXTENSIONSMODIFY = 32
    """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

    TRADECLIENTEXTENSIONSMODIFYREJECT = 33
    """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

    MARGINCALLENTER = 34
    """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

    MARGINCALLEXTEND = 35
    """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

    MARGINCALLEXIT = 36
    """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

    DELAYEDTRADECLOSURE = 37
    """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

    DAILYFINANCING = 38
    """Enum DAILYFINANCING for "DAILY_FINANCING\""""

    RESETRESETTABLEPL = 39
    """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""


class PriceStatus(System.Enum):
    """The status of the Price."""

    Tradeable = 0
    """Enum Tradeable for "tradeable\""""

    Nontradeable = 1
    """Enum Nontradeable for "non-tradeable\""""

    Invalid = 2
    """Enum Invalid for "invalid\""""


class CandlestickData(System.Object, System.IEquatable[Oanda_RestV20_Model_CandlestickData], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The price data (open, high, low, close) for the Candlestick representation."""

    @property
    def O(self) -> str:
        """The first (open) price in the time-range represented by the candlestick."""
        ...

    @O.setter
    def O(self, value: str):
        """The first (open) price in the time-range represented by the candlestick."""
        ...

    @property
    def H(self) -> str:
        """The highest price in the time-range represented by the candlestick."""
        ...

    @H.setter
    def H(self, value: str):
        """The highest price in the time-range represented by the candlestick."""
        ...

    @property
    def L(self) -> str:
        """The lowest price in the time-range represented by the candlestick."""
        ...

    @L.setter
    def L(self, value: str):
        """The lowest price in the time-range represented by the candlestick."""
        ...

    @property
    def C(self) -> str:
        """The last (closing) price in the time-range represented by the candlestick."""
        ...

    @C.setter
    def C(self, value: str):
        """The last (closing) price in the time-range represented by the candlestick."""
        ...

    def __init__(self, O: str = ..., H: str = ..., L: str = ..., C: str = ...) -> None:
        """
        Initializes a new instance of the CandlestickData class.
        
        :param O: The first (open) price in the time-range represented by the candlestick..
        :param H: The highest price in the time-range represented by the candlestick..
        :param L: The lowest price in the time-range represented by the candlestick..
        :param C: The last (closing) price in the time-range represented by the candlestick..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.CandlestickData) -> bool:
        """
        Returns true if CandlestickData instances are equal
        
        :param other: Instance of CandlestickData to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Candlestick(System.Object, System.IEquatable[Oanda_RestV20_Model_Candlestick], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The Candlestick representation"""

    @property
    def Time(self) -> str:
        """The start time of the candlestick"""
        ...

    @Time.setter
    def Time(self, value: str):
        """The start time of the candlestick"""
        ...

    @property
    def Bid(self) -> Oanda.RestV20.Model.CandlestickData:
        """Gets or Sets Bid"""
        ...

    @Bid.setter
    def Bid(self, value: Oanda.RestV20.Model.CandlestickData):
        """Gets or Sets Bid"""
        ...

    @property
    def Ask(self) -> Oanda.RestV20.Model.CandlestickData:
        """Gets or Sets Ask"""
        ...

    @Ask.setter
    def Ask(self, value: Oanda.RestV20.Model.CandlestickData):
        """Gets or Sets Ask"""
        ...

    @property
    def Mid(self) -> Oanda.RestV20.Model.CandlestickData:
        """Gets or Sets Mid"""
        ...

    @Mid.setter
    def Mid(self, value: Oanda.RestV20.Model.CandlestickData):
        """Gets or Sets Mid"""
        ...

    @property
    def Volume(self) -> typing.Optional[int]:
        """The number of prices created during the time-range represented by the candlestick."""
        ...

    @Volume.setter
    def Volume(self, value: typing.Optional[int]):
        """The number of prices created during the time-range represented by the candlestick."""
        ...

    @property
    def Complete(self) -> typing.Optional[bool]:
        """A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future."""
        ...

    @Complete.setter
    def Complete(self, value: typing.Optional[bool]):
        """A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future."""
        ...

    def __init__(self, Time: str = ..., Bid: Oanda.RestV20.Model.CandlestickData = ..., Ask: Oanda.RestV20.Model.CandlestickData = ..., Mid: Oanda.RestV20.Model.CandlestickData = ..., Volume: typing.Optional[int] = ..., Complete: typing.Optional[bool] = ...) -> None:
        """
        Initializes a new instance of the Candlestick class.
        
        :param Time: The start time of the candlestick.
        :param Bid: Bid.
        :param Ask: Ask.
        :param Mid: Mid.
        :param Volume: The number of prices created during the time-range represented by the candlestick..
        :param Complete: A flag indicating if the candlestick is complete. A complete candlestick is one whose ending time is not in the future..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Candlestick) -> bool:
        """
        Returns true if Candlestick instances are equal
        
        :param other: Instance of Candlestick to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20029(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20029], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20029"""

    class GranularityEnum(System.Enum):
        """The granularity of the candlesticks provided."""

        S5 = 0
        """Enum S5 for "S5\""""

        S10 = 1
        """Enum S10 for "S10\""""

        S15 = 2
        """Enum S15 for "S15\""""

        S30 = 3
        """Enum S30 for "S30\""""

        M1 = 4
        """Enum M1 for "M1\""""

        M2 = 5
        """Enum M2 for "M2\""""

        M4 = 6
        """Enum M4 for "M4\""""

        M5 = 7
        """Enum M5 for "M5\""""

        M10 = 8
        """Enum M10 for "M10\""""

        M15 = 9
        """Enum M15 for "M15\""""

        M30 = 10
        """Enum M30 for "M30\""""

        H1 = 11
        """Enum H1 for "H1\""""

        H2 = 12
        """Enum H2 for "H2\""""

        H3 = 13
        """Enum H3 for "H3\""""

        H4 = 14
        """Enum H4 for "H4\""""

        H6 = 15
        """Enum H6 for "H6\""""

        H8 = 16
        """Enum H8 for "H8\""""

        H12 = 17
        """Enum H12 for "H12\""""

        D = 18
        """Enum D for "D\""""

        W = 19
        """Enum W for "W\""""

        M = 20
        """Enum M for "M\""""

    @property
    def Granularity(self) -> typing.Optional[Oanda.RestV20.Model.InlineResponse20029.GranularityEnum]:
        """The granularity of the candlesticks provided."""
        ...

    @Granularity.setter
    def Granularity(self, value: typing.Optional[Oanda.RestV20.Model.InlineResponse20029.GranularityEnum]):
        """The granularity of the candlesticks provided."""
        ...

    @property
    def Instrument(self) -> str:
        """The instrument whose Prices are represented by the candlesticks."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The instrument whose Prices are represented by the candlesticks."""
        ...

    @property
    def Candles(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Candlestick]:
        """The list of candlesticks that satisfy the request."""
        ...

    @Candles.setter
    def Candles(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Candlestick]):
        """The list of candlesticks that satisfy the request."""
        ...

    def __init__(self, Instrument: str = ..., Granularity: typing.Optional[Oanda.RestV20.Model.InlineResponse20029.GranularityEnum] = ..., Candles: System.Collections.Generic.List[Oanda.RestV20.Model.Candlestick] = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20029 class.
        
        :param Instrument: The instrument whose Prices are represented by the candlesticks..
        :param Granularity: The granularity of the candlesticks provided..
        :param Candles: The list of candlesticks that satisfy the request..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20029) -> bool:
        """
        Returns true if InlineResponse20029 instances are equal
        
        :param other: Instance of InlineResponse20029 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TakeProfitDetails(System.Object, System.IEquatable[Oanda_RestV20_Model_TakeProfitDetails], System.ComponentModel.DataAnnotations.IValidatableObject):
    """TakeProfitDetails specifies the details of a Take Profit Order to be created on behalf of a client. This may happen when an Order is filled that opens a Trade requiring a Take Profit, or when a Trade's dependent Take Profit Order is modified directly through the Trade."""

    class TimeInForceEnum(System.Enum):
        """The time in force for the created Take Profit Order. This may only be GTC, GTD or GFD."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitDetails.TimeInForceEnum]:
        """The time in force for the created Take Profit Order. This may only be GTC, GTD or GFD."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitDetails.TimeInForceEnum]):
        """The time in force for the created Take Profit Order. This may only be GTC, GTD or GFD."""
        ...

    @property
    def Price(self) -> str:
        """The price that the Take Profit Order will be triggered at."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price that the Take Profit Order will be triggered at."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date when the Take Profit Order will be cancelled on if timeInForce is GTD."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date when the Take Profit Order will be cancelled on if timeInForce is GTD."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TakeProfitDetails.TimeInForceEnum] = ..., GtdTime: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the TakeProfitDetails class.
        
        :param Price: The price that the Take Profit Order will be triggered at..
        :param TimeInForce: The time in force for the created Take Profit Order. This may only be GTC, GTD or GFD..
        :param GtdTime: The date when the Take Profit Order will be cancelled on if timeInForce is GTD..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TakeProfitDetails) -> bool:
        """
        Returns true if TakeProfitDetails instances are equal
        
        :param other: Instance of TakeProfitDetails to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossDetails(System.Object, System.IEquatable[Oanda_RestV20_Model_StopLossDetails], System.ComponentModel.DataAnnotations.IValidatableObject):
    """StopLossDetails specifies the details of a Stop Loss Order to be created on behalf of a client. This may happen when an Order is filled that opens a Trade requiring a Stop Loss, or when a Trade's dependent Stop Loss Order is modified directly through the Trade."""

    class TimeInForceEnum(System.Enum):
        """The time in force for the created Stop Loss Order. This may only be GTC, GTD or GFD."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopLossDetails.TimeInForceEnum]:
        """The time in force for the created Stop Loss Order. This may only be GTC, GTD or GFD."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopLossDetails.TimeInForceEnum]):
        """The time in force for the created Stop Loss Order. This may only be GTC, GTD or GFD."""
        ...

    @property
    def Price(self) -> str:
        """The price that the Stop Loss Order will be triggered at."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price that the Stop Loss Order will be triggered at."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date when the Stop Loss Order will be cancelled on if timeInForce is GTD."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date when the Stop Loss Order will be cancelled on if timeInForce is GTD."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopLossDetails.TimeInForceEnum] = ..., GtdTime: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the StopLossDetails class.
        
        :param Price: The price that the Stop Loss Order will be triggered at..
        :param TimeInForce: The time in force for the created Stop Loss Order. This may only be GTC, GTD or GFD..
        :param GtdTime: The date when the Stop Loss Order will be cancelled on if timeInForce is GTD..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopLossDetails) -> bool:
        """
        Returns true if StopLossDetails instances are equal
        
        :param other: Instance of StopLossDetails to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TrailingStopLossDetails(System.Object, System.IEquatable[Oanda_RestV20_Model_TrailingStopLossDetails], System.ComponentModel.DataAnnotations.IValidatableObject):
    """TrailingStopLossDetails specifies the details of a Trailing Stop Loss Order to be created on behalf of a client. This may happen when an Order is filled that opens a Trade requiring a Trailing Stop Loss, or when a Trade's dependent Trailing Stop Loss Order is modified directly through the Trade."""

    class TimeInForceEnum(System.Enum):
        """The time in force for the created Trailing Stop Loss Order. This may only be GTC, GTD or GFD."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossDetails.TimeInForceEnum]:
        """The time in force for the created Trailing Stop Loss Order. This may only be GTC, GTD or GFD."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossDetails.TimeInForceEnum]):
        """The time in force for the created Trailing Stop Loss Order. This may only be GTC, GTD or GFD."""
        ...

    @property
    def Distance(self) -> str:
        """The distance (in price units) from the Trade's fill price that the Trailing Stop Loss Order will be triggered at."""
        ...

    @Distance.setter
    def Distance(self, value: str):
        """The distance (in price units) from the Trade's fill price that the Trailing Stop Loss Order will be triggered at."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date when the Trailing Stop Loss Order will be cancelled on if timeInForce is GTD."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date when the Trailing Stop Loss Order will be cancelled on if timeInForce is GTD."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Distance: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TrailingStopLossDetails.TimeInForceEnum] = ..., GtdTime: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the TrailingStopLossDetails class.
        
        :param Distance: The distance (in price units) from the Trade's fill price that the Trailing Stop Loss Order will be triggered at..
        :param TimeInForce: The time in force for the created Trailing Stop Loss Order. This may only be GTC, GTD or GFD..
        :param GtdTime: The date when the Trailing Stop Loss Order will be cancelled on if timeInForce is GTD..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TrailingStopLossDetails) -> bool:
        """
        Returns true if TrailingStopLossDetails instances are equal
        
        :param other: Instance of TrailingStopLossDetails to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class LimitOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_LimitOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A LimitOrderRejectTransaction represents the rejection of the creation of a Limit Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER_REJECT\\" in a LimitOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Limit Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Limit Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER_REJECT\\" in a LimitOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER_REJECT\\" in a LimitOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the Limit Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the Limit Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.ReasonEnum]:
        """The reason that the Limit Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.ReasonEnum]):
        """The reason that the Limit Order was initiated"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The Limit Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Limit Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def IntendedReplacesOrderID(self) -> str:
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    @IntendedReplacesOrderID.setter
    def IntendedReplacesOrderID(self, value: str):
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., IntendedReplacesOrderID: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.LimitOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the LimitOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"LIMIT_ORDER_REJECT\\" in a LimitOrderRejectTransaction..
        :param Instrument: The Limit Order's Instrument..
        :param Units: The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price..
        :param TimeInForce: The time-in-force requested for the Limit Order..
        :param GtdTime: The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Limit Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param IntendedReplacesOrderID: The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LimitOrderRejectTransaction) -> bool:
        """
        Returns true if LimitOrderRejectTransaction instances are equal
        
        :param other: Instance of LimitOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class UserInfoExternal(System.Object, System.IEquatable[Oanda_RestV20_Model_UserInfoExternal], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A representation of user information, as available to external (3rd party) clients."""

    @property
    def UserID(self) -> typing.Optional[int]:
        """The user's OANDA-assigned user ID."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The user's OANDA-assigned user ID."""
        ...

    @property
    def Country(self) -> str:
        """The country that the user is based in."""
        ...

    @Country.setter
    def Country(self, value: str):
        """The country that the user is based in."""
        ...

    @property
    def FIFO(self) -> typing.Optional[bool]:
        """Flag indicating if the the user's Accounts adhere to FIFO execution rules."""
        ...

    @FIFO.setter
    def FIFO(self, value: typing.Optional[bool]):
        """Flag indicating if the the user's Accounts adhere to FIFO execution rules."""
        ...

    def __init__(self, UserID: typing.Optional[int] = ..., Country: str = ..., FIFO: typing.Optional[bool] = ...) -> None:
        """
        Initializes a new instance of the UserInfoExternal class.
        
        :param UserID: The user's OANDA-assigned user ID..
        :param Country: The country that the user is based in..
        :param FIFO: Flag indicating if the the user's Accounts adhere to FIFO execution rules..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.UserInfoExternal) -> bool:
        """
        Returns true if UserInfoExternal instances are equal
        
        :param other: Instance of UserInfoExternal to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20016(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20016], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20016"""

    @property
    def UserInfo(self) -> Oanda.RestV20.Model.UserInfoExternal:
        """Gets or Sets UserInfo"""
        ...

    @UserInfo.setter
    def UserInfo(self, value: Oanda.RestV20.Model.UserInfoExternal):
        """Gets or Sets UserInfo"""
        ...

    def __init__(self, UserInfo: Oanda.RestV20.Model.UserInfoExternal = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20016 class.
        
        :param UserInfo: UserInfo.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20016) -> bool:
        """
        Returns true if InlineResponse20016 instances are equal
        
        :param other: Instance of InlineResponse20016 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class SetTradeClientExtensionsBody(System.Object, System.IEquatable[Oanda_RestV20_Model_SetTradeClientExtensionsBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """SetTradeClientExtensionsBody"""

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the SetTradeClientExtensionsBody class.
        
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.SetTradeClientExtensionsBody) -> bool:
        """
        Returns true if SetTradeClientExtensionsBody instances are equal
        
        :param other: Instance of SetTradeClientExtensionsBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossOrderReason(System.Enum):
    """The reason that the Stop Loss Order was initiated"""

    CLIENTORDER = 0
    """Enum CLIENTORDER for "CLIENT_ORDER\""""

    REPLACEMENT = 1
    """Enum REPLACEMENT for "REPLACEMENT\""""

    ONFILL = 2
    """Enum ONFILL for "ON_FILL\""""


class MarketOrderMarginCloseoutReason(System.Enum):
    """The reason that the Market Order was created to perform a margin closeout"""

    MARGINCHECKVIOLATION = 0
    """Enum MARGINCHECKVIOLATION for "MARGIN_CHECK_VIOLATION\""""

    REGULATORYMARGINCALLVIOLATION = 1
    """Enum REGULATORYMARGINCALLVIOLATION for "REGULATORY_MARGIN_CALL_VIOLATION\""""


class DynamicOrderState(System.Object, System.IEquatable[Oanda_RestV20_Model_DynamicOrderState], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The dynamic state of an Order. This is only relevant to TrailingStopLoss Orders, as no other Order type has dynamic state."""

    @property
    def Id(self) -> str:
        """The Order's ID."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's ID."""
        ...

    @property
    def TrailingStopValue(self) -> str:
        """The Order's calculated trailing stop value."""
        ...

    @TrailingStopValue.setter
    def TrailingStopValue(self, value: str):
        """The Order's calculated trailing stop value."""
        ...

    @property
    def TriggerDistance(self) -> str:
        """The distance between the Trailing Stop Loss Order's trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set."""
        ...

    @TriggerDistance.setter
    def TriggerDistance(self, value: str):
        """The distance between the Trailing Stop Loss Order's trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set."""
        ...

    @property
    def IsTriggerDistanceExact(self) -> typing.Optional[bool]:
        """True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set."""
        ...

    @IsTriggerDistanceExact.setter
    def IsTriggerDistanceExact(self, value: typing.Optional[bool]):
        """True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set."""
        ...

    def __init__(self, Id: str = ..., TrailingStopValue: str = ..., TriggerDistance: str = ..., IsTriggerDistanceExact: typing.Optional[bool] = ...) -> None:
        """
        Initializes a new instance of the DynamicOrderState class.
        
        :param Id: The Order's ID..
        :param TrailingStopValue: The Order's calculated trailing stop value..
        :param TriggerDistance: The distance between the Trailing Stop Loss Order's trailingStopValue and the current Market Price. This represents the distance (in price units) of the Order from a triggering price. If the distance could not be determined, this value will not be set..
        :param IsTriggerDistanceExact: True if an exact trigger distance could be calculated. If false, it means the provided trigger distance is a best estimate. If the distance could not be determined, this value will not be set..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.DynamicOrderState) -> bool:
        """
        Returns true if DynamicOrderState instances are equal
        
        :param other: Instance of DynamicOrderState to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class CalculatedTradeState(System.Object, System.IEquatable[Oanda_RestV20_Model_CalculatedTradeState], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The dynamic (calculated) state of an open Trade"""

    @property
    def Id(self) -> str:
        """The Trade's ID."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Trade's ID."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The Trade's unrealized profit/loss."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The Trade's unrealized profit/loss."""
        ...

    def __init__(self, Id: str = ..., UnrealizedPL: str = ...) -> None:
        """
        Initializes a new instance of the CalculatedTradeState class.
        
        :param Id: The Trade's ID..
        :param UnrealizedPL: The Trade's unrealized profit/loss..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.CalculatedTradeState) -> bool:
        """
        Returns true if CalculatedTradeState instances are equal
        
        :param other: Instance of CalculatedTradeState to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class CalculatedPositionState(System.Object, System.IEquatable[Oanda_RestV20_Model_CalculatedPositionState], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The dynamic (calculated) state of a Position"""

    @property
    def Instrument(self) -> str:
        """The Position's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Position's Instrument."""
        ...

    @property
    def NetUnrealizedPL(self) -> str:
        """The Position's net unrealized profit/loss"""
        ...

    @NetUnrealizedPL.setter
    def NetUnrealizedPL(self, value: str):
        """The Position's net unrealized profit/loss"""
        ...

    @property
    def LongUnrealizedPL(self) -> str:
        """The unrealized profit/loss of the Position's long open Trades"""
        ...

    @LongUnrealizedPL.setter
    def LongUnrealizedPL(self, value: str):
        """The unrealized profit/loss of the Position's long open Trades"""
        ...

    @property
    def ShortUnrealizedPL(self) -> str:
        """The unrealized profit/loss of the Position's short open Trades"""
        ...

    @ShortUnrealizedPL.setter
    def ShortUnrealizedPL(self, value: str):
        """The unrealized profit/loss of the Position's short open Trades"""
        ...

    def __init__(self, Instrument: str = ..., NetUnrealizedPL: str = ..., LongUnrealizedPL: str = ..., ShortUnrealizedPL: str = ...) -> None:
        """
        Initializes a new instance of the CalculatedPositionState class.
        
        :param Instrument: The Position's Instrument..
        :param NetUnrealizedPL: The Position's net unrealized profit/loss.
        :param LongUnrealizedPL: The unrealized profit/loss of the Position's long open Trades.
        :param ShortUnrealizedPL: The unrealized profit/loss of the Position's short open Trades.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.CalculatedPositionState) -> bool:
        """
        Returns true if CalculatedPositionState instances are equal
        
        :param other: Instance of CalculatedPositionState to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class AccountChangesState(System.Object, System.IEquatable[Oanda_RestV20_Model_AccountChangesState], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An AccountState Object is used to represent an Account's current price-dependent state. Price-dependent Account state is dependent on OANDA's current Prices, and includes things like unrealized PL, NAV and Trailing Stop Loss Order state."""

    @property
    def UnrealizedPL(self) -> str:
        """The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency."""
        ...

    @property
    def NAV(self) -> str:
        """The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency."""
        ...

    @NAV.setter
    def NAV(self, value: str):
        """The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency."""
        ...

    @property
    def MarginUsed(self) -> str:
        """Margin currently used for the Account. Represented in the Account's home currency."""
        ...

    @MarginUsed.setter
    def MarginUsed(self, value: str):
        """Margin currently used for the Account. Represented in the Account's home currency."""
        ...

    @property
    def MarginAvailable(self) -> str:
        """Margin available for Account. Represented in the Account's home currency."""
        ...

    @MarginAvailable.setter
    def MarginAvailable(self, value: str):
        """Margin available for Account. Represented in the Account's home currency."""
        ...

    @property
    def PositionValue(self) -> str:
        """The value of the Account's open positions represented in the Account's home currency."""
        ...

    @PositionValue.setter
    def PositionValue(self, value: str):
        """The value of the Account's open positions represented in the Account's home currency."""
        ...

    @property
    def MarginCloseoutUnrealizedPL(self) -> str:
        """The Account's margin closeout unrealized PL."""
        ...

    @MarginCloseoutUnrealizedPL.setter
    def MarginCloseoutUnrealizedPL(self, value: str):
        """The Account's margin closeout unrealized PL."""
        ...

    @property
    def MarginCloseoutNAV(self) -> str:
        """The Account's margin closeout NAV."""
        ...

    @MarginCloseoutNAV.setter
    def MarginCloseoutNAV(self, value: str):
        """The Account's margin closeout NAV."""
        ...

    @property
    def MarginCloseoutMarginUsed(self) -> str:
        """The Account's margin closeout margin used."""
        ...

    @MarginCloseoutMarginUsed.setter
    def MarginCloseoutMarginUsed(self, value: str):
        """The Account's margin closeout margin used."""
        ...

    @property
    def MarginCloseoutPercent(self) -> str:
        """The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation."""
        ...

    @MarginCloseoutPercent.setter
    def MarginCloseoutPercent(self, value: str):
        """The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation."""
        ...

    @property
    def MarginCloseoutPositionValue(self) -> str:
        """The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency."""
        ...

    @MarginCloseoutPositionValue.setter
    def MarginCloseoutPositionValue(self, value: str):
        """The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency."""
        ...

    @property
    def WithdrawalLimit(self) -> str:
        """The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account."""
        ...

    @WithdrawalLimit.setter
    def WithdrawalLimit(self, value: str):
        """The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account."""
        ...

    @property
    def MarginCallMarginUsed(self) -> str:
        """The Account's margin call margin used."""
        ...

    @MarginCallMarginUsed.setter
    def MarginCallMarginUsed(self, value: str):
        """The Account's margin call margin used."""
        ...

    @property
    def MarginCallPercent(self) -> str:
        """The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation."""
        ...

    @MarginCallPercent.setter
    def MarginCallPercent(self, value: str):
        """The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation."""
        ...

    @property
    def Orders(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.DynamicOrderState]:
        """The price-dependent state of each pending Order in the Account."""
        ...

    @Orders.setter
    def Orders(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.DynamicOrderState]):
        """The price-dependent state of each pending Order in the Account."""
        ...

    @property
    def Trades(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedTradeState]:
        """The price-dependent state for each open Trade in the Account."""
        ...

    @Trades.setter
    def Trades(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedTradeState]):
        """The price-dependent state for each open Trade in the Account."""
        ...

    @property
    def Positions(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedPositionState]:
        """The price-dependent state for each open Position in the Account."""
        ...

    @Positions.setter
    def Positions(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedPositionState]):
        """The price-dependent state for each open Position in the Account."""
        ...

    def __init__(self, UnrealizedPL: str = ..., NAV: str = ..., MarginUsed: str = ..., MarginAvailable: str = ..., PositionValue: str = ..., MarginCloseoutUnrealizedPL: str = ..., MarginCloseoutNAV: str = ..., MarginCloseoutMarginUsed: str = ..., MarginCloseoutPercent: str = ..., MarginCloseoutPositionValue: str = ..., WithdrawalLimit: str = ..., MarginCallMarginUsed: str = ..., MarginCallPercent: str = ..., Orders: System.Collections.Generic.List[Oanda.RestV20.Model.DynamicOrderState] = ..., Trades: System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedTradeState] = ..., Positions: System.Collections.Generic.List[Oanda.RestV20.Model.CalculatedPositionState] = ...) -> None:
        """
        Initializes a new instance of the AccountChangesState class.
        
        :param UnrealizedPL: The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency..
        :param NAV: The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency..
        :param MarginUsed: Margin currently used for the Account. Represented in the Account's home currency..
        :param MarginAvailable: Margin available for Account. Represented in the Account's home currency..
        :param PositionValue: The value of the Account's open positions represented in the Account's home currency..
        :param MarginCloseoutUnrealizedPL: The Account's margin closeout unrealized PL..
        :param MarginCloseoutNAV: The Account's margin closeout NAV..
        :param MarginCloseoutMarginUsed: The Account's margin closeout margin used..
        :param MarginCloseoutPercent: The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation..
        :param MarginCloseoutPositionValue: The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency..
        :param WithdrawalLimit: The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account..
        :param MarginCallMarginUsed: The Account's margin call margin used..
        :param MarginCallPercent: The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation..
        :param Orders: The price-dependent state of each pending Order in the Account..
        :param Trades: The price-dependent state for each open Trade in the Account..
        :param Positions: The price-dependent state for each open Position in the Account..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.AccountChangesState) -> bool:
        """
        Returns true if AccountChangesState instances are equal
        
        :param other: Instance of AccountChangesState to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderCancelRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderCancelRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An OrderCancelRejectTransaction represents the rejection of the cancellation of an Order in the client's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL_REJECT\\" for an OrderCancelRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class ReasonEnum(System.Enum):
        """The reason that the Order was to be cancelled."""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        ACCOUNTLOCKED = 1
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTNEWPOSITIONSLOCKED = 2
        """Enum ACCOUNTNEWPOSITIONSLOCKED for "ACCOUNT_NEW_POSITIONS_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 3
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTORDERFILLLOCKED = 4
        """Enum ACCOUNTORDERFILLLOCKED for "ACCOUNT_ORDER_FILL_LOCKED\""""

        CLIENTREQUEST = 5
        """Enum CLIENTREQUEST for "CLIENT_REQUEST\""""

        MIGRATION = 6
        """Enum MIGRATION for "MIGRATION\""""

        MARKETHALTED = 7
        """Enum MARKETHALTED for "MARKET_HALTED\""""

        LINKEDTRADECLOSED = 8
        """Enum LINKEDTRADECLOSED for "LINKED_TRADE_CLOSED\""""

        TIMEINFORCEEXPIRED = 9
        """Enum TIMEINFORCEEXPIRED for "TIME_IN_FORCE_EXPIRED\""""

        INSUFFICIENTMARGIN = 10
        """Enum INSUFFICIENTMARGIN for "INSUFFICIENT_MARGIN\""""

        FIFOVIOLATION = 11
        """Enum FIFOVIOLATION for "FIFO_VIOLATION\""""

        BOUNDSVIOLATION = 12
        """Enum BOUNDSVIOLATION for "BOUNDS_VIOLATION\""""

        CLIENTREQUESTREPLACED = 13
        """Enum CLIENTREQUESTREPLACED for "CLIENT_REQUEST_REPLACED\""""

        INSUFFICIENTLIQUIDITY = 14
        """Enum INSUFFICIENTLIQUIDITY for "INSUFFICIENT_LIQUIDITY\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 15
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLLOSS = 16
        """Enum TAKEPROFITONFILLLOSS for "TAKE_PROFIT_ON_FILL_LOSS\""""

        LOSINGTAKEPROFIT = 17
        """Enum LOSINGTAKEPROFIT for "LOSING_TAKE_PROFIT\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 18
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLLOSS = 19
        """Enum STOPLOSSONFILLLOSS for "STOP_LOSS_ON_FILL_LOSS\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 20
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        CLIENTTRADEIDALREADYEXISTS = 21
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        POSITIONCLOSEOUTFAILED = 22
        """Enum POSITIONCLOSEOUTFAILED for "POSITION_CLOSEOUT_FAILED\""""

        OPENTRADESALLOWEDEXCEEDED = 23
        """Enum OPENTRADESALLOWEDEXCEEDED for "OPEN_TRADES_ALLOWED_EXCEEDED\""""

        PENDINGORDERSALLOWEDEXCEEDED = 24
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS = 25
        """Enum TAKEPROFITONFILLCLIENTORDERIDALREADYEXISTS for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS = 26
        """Enum STOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS = 27
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDALREADYEXISTS for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        POSITIONSIZEEXCEEDED = 28
        """Enum POSITIONSIZEEXCEEDED for "POSITION_SIZE_EXCEEDED\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL_REJECT\\" for an OrderCancelRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"ORDER_CANCEL_REJECT\\" for an OrderCancelRejectTransaction."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.ReasonEnum]:
        """The reason that the Order was to be cancelled."""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.ReasonEnum]):
        """The reason that the Order was to be cancelled."""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def OrderID(self) -> str:
        """The ID of the Order intended to be cancelled"""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The ID of the Order intended to be cancelled"""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The client ID of the Order intended to be cancelled (only provided if the Order has a client Order ID)."""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The client ID of the Order intended to be cancelled (only provided if the Order has a client Order ID)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.TypeEnum] = ..., OrderID: str = ..., ClientOrderID: str = ..., Reason: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.ReasonEnum] = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.OrderCancelRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the OrderCancelRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"ORDER_CANCEL_REJECT\\" for an OrderCancelRejectTransaction..
        :param OrderID: The ID of the Order intended to be cancelled.
        :param ClientOrderID: The client ID of the Order intended to be cancelled (only provided if the Order has a client Order ID)..
        :param Reason: The reason that the Order was to be cancelled..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderCancelRejectTransaction) -> bool:
        """
        Returns true if OrderCancelRejectTransaction instances are equal
        
        :param other: Instance of OrderCancelRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TransactionRejectReason(System.Enum):
    """The reason that a Transaction was rejected."""

    INTERNALSERVERERROR = 0
    """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

    INSTRUMENTPRICEUNKNOWN = 1
    """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

    ACCOUNTNOTACTIVE = 2
    """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

    ACCOUNTLOCKED = 3
    """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

    ACCOUNTORDERCREATIONLOCKED = 4
    """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

    ACCOUNTCONFIGURATIONLOCKED = 5
    """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

    ACCOUNTDEPOSITLOCKED = 6
    """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

    ACCOUNTWITHDRAWALLOCKED = 7
    """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

    ACCOUNTORDERCANCELLOCKED = 8
    """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

    INSTRUMENTNOTTRADEABLE = 9
    """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

    PENDINGORDERSALLOWEDEXCEEDED = 10
    """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

    ORDERIDUNSPECIFIED = 11
    """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

    ORDERDOESNTEXIST = 12
    """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

    ORDERIDENTIFIERINCONSISTENCY = 13
    """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

    TRADEIDUNSPECIFIED = 14
    """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

    TRADEDOESNTEXIST = 15
    """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

    TRADEIDENTIFIERINCONSISTENCY = 16
    """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

    INSTRUMENTMISSING = 17
    """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

    INSTRUMENTUNKNOWN = 18
    """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

    UNITSMISSING = 19
    """Enum UNITSMISSING for "UNITS_MISSING\""""

    UNITSINVALID = 20
    """Enum UNITSINVALID for "UNITS_INVALID\""""

    UNITSPRECISIONEXCEEDED = 21
    """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

    UNITSLIMITEXCEEDED = 22
    """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

    UNITSMIMIMUMNOTMET = 23
    """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

    PRICEMISSING = 24
    """Enum PRICEMISSING for "PRICE_MISSING\""""

    PRICEINVALID = 25
    """Enum PRICEINVALID for "PRICE_INVALID\""""

    PRICEPRECISIONEXCEEDED = 26
    """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

    PRICEDISTANCEMISSING = 27
    """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

    PRICEDISTANCEINVALID = 28
    """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

    PRICEDISTANCEPRECISIONEXCEEDED = 29
    """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

    PRICEDISTANCEMAXIMUMEXCEEDED = 30
    """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

    PRICEDISTANCEMINIMUMNOTMET = 31
    """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

    TIMEINFORCEMISSING = 32
    """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

    TIMEINFORCEINVALID = 33
    """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

    TIMEINFORCEGTDTIMESTAMPMISSING = 34
    """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

    TIMEINFORCEGTDTIMESTAMPINPAST = 35
    """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

    PRICEBOUNDINVALID = 36
    """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

    PRICEBOUNDPRECISIONEXCEEDED = 37
    """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

    ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
    """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

    TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
    """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

    CLIENTORDERIDINVALID = 40
    """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

    CLIENTORDERIDALREADYEXISTS = 41
    """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

    CLIENTORDERTAGINVALID = 42
    """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

    CLIENTORDERCOMMENTINVALID = 43
    """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

    CLIENTTRADEIDINVALID = 44
    """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

    CLIENTTRADEIDALREADYEXISTS = 45
    """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

    CLIENTTRADETAGINVALID = 46
    """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

    CLIENTTRADECOMMENTINVALID = 47
    """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

    ORDERFILLPOSITIONACTIONMISSING = 48
    """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

    ORDERFILLPOSITIONACTIONINVALID = 49
    """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

    TRIGGERCONDITIONMISSING = 50
    """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

    TRIGGERCONDITIONINVALID = 51
    """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

    ORDERPARTIALFILLOPTIONMISSING = 52
    """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

    ORDERPARTIALFILLOPTIONINVALID = 53
    """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

    INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
    """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

    TAKEPROFITORDERALREADYEXISTS = 55
    """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

    TAKEPROFITONFILLPRICEMISSING = 56
    """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

    TAKEPROFITONFILLPRICEINVALID = 57
    """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

    TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
    """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

    TAKEPROFITONFILLTIMEINFORCEMISSING = 59
    """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

    TAKEPROFITONFILLTIMEINFORCEINVALID = 60
    """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

    TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
    """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

    TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
    """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

    TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
    """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

    TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
    """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

    TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
    """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

    TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
    """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

    TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
    """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

    STOPLOSSORDERALREADYEXISTS = 68
    """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

    STOPLOSSONFILLPRICEMISSING = 69
    """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

    STOPLOSSONFILLPRICEINVALID = 70
    """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

    STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
    """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

    STOPLOSSONFILLTIMEINFORCEMISSING = 72
    """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

    STOPLOSSONFILLTIMEINFORCEINVALID = 73
    """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

    STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
    """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

    STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
    """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

    STOPLOSSONFILLCLIENTORDERIDINVALID = 76
    """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

    STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
    """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

    STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
    """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

    STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
    """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

    STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
    """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

    TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
    """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

    TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
    """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

    TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
    """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

    TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
    """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

    TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
    """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

    TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
    """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

    TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
    """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

    TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
    """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

    TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
    """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

    TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
    """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

    TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
    """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

    TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
    """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

    TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
    """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

    TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
    """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

    TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
    """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

    TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
    """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

    CLOSETRADETYPEMISSING = 97
    """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

    CLOSETRADEPARTIALUNITSMISSING = 98
    """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

    CLOSETRADEUNITSEXCEEDTRADESIZE = 99
    """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

    CLOSEOUTPOSITIONDOESNTEXIST = 100
    """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

    CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
    """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

    CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
    """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

    CLOSEOUTPOSITIONREJECT = 103
    """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

    CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
    """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

    MARKUPGROUPIDINVALID = 105
    """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

    POSITIONAGGREGATIONMODEINVALID = 106
    """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

    ADMINCONFIGUREDATAMISSING = 107
    """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

    MARGINRATEINVALID = 108
    """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

    MARGINRATEWOULDTRIGGERCLOSEOUT = 109
    """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

    ALIASINVALID = 110
    """Enum ALIASINVALID for "ALIAS_INVALID\""""

    CLIENTCONFIGUREDATAMISSING = 111
    """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

    MARGINRATEWOULDTRIGGERMARGINCALL = 112
    """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

    AMOUNTINVALID = 113
    """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

    INSUFFICIENTFUNDS = 114
    """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

    AMOUNTMISSING = 115
    """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

    FUNDINGREASONMISSING = 116
    """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

    CLIENTEXTENSIONSDATAMISSING = 117
    """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

    REPLACINGORDERINVALID = 118
    """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

    REPLACINGTRADEIDINVALID = 119
    """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""


class TakeProfitOrder(System.Object, System.IEquatable[Oanda_RestV20_Model_TakeProfitOrder], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TakeProfitOrder is an order that is linked to an open Trade and created with a price threshold. The Order will be filled (closing the Trade) by the first price that is equal to or better than the threshold. A TakeProfitOrder cannot be used to open a new Position."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    class TypeEnum(System.Enum):
        """The type of the Order. Always set to \\"TAKE_PROFIT\\" for Take Profit Orders."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TypeEnum]:
        """The type of the Order. Always set to \\"TAKE_PROFIT\\" for Take Profit Orders."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TypeEnum]):
        """The type of the Order. Always set to \\"TAKE_PROFIT\\" for Take Profit Orders."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TimeInForceEnum]:
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TimeInForceEnum]):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def FillingTransactionID(self) -> str:
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @FillingTransactionID.setter
    def FillingTransactionID(self, value: str):
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @property
    def FilledTime(self) -> str:
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @FilledTime.setter
    def FilledTime(self, value: str):
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @property
    def TradeOpenedID(self) -> str:
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @TradeOpenedID.setter
    def TradeOpenedID(self, value: str):
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @property
    def TradeReducedID(self) -> str:
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @TradeReducedID.setter
    def TradeReducedID(self, value: str):
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @property
    def TradeClosedIDs(self) -> System.Collections.Generic.List[str]:
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @TradeClosedIDs.setter
    def TradeClosedIDs(self, value: System.Collections.Generic.List[str]):
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @property
    def CancelledTime(self) -> str:
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @CancelledTime.setter
    def CancelledTime(self, value: str):
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., Type: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TakeProfitOrder.TriggerConditionEnum] = ..., FillingTransactionID: str = ..., FilledTime: str = ..., TradeOpenedID: str = ..., TradeReducedID: str = ..., TradeClosedIDs: System.Collections.Generic.List[str] = ..., CancellingTransactionID: str = ..., CancelledTime: str = ..., ReplacesOrderID: str = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the TakeProfitOrder class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        :param Type: The type of the Order. Always set to \\"TAKE_PROFIT\\" for Take Profit Orders..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold..
        :param TimeInForce: The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders..
        :param GtdTime: The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param FillingTransactionID: ID of the Transaction that filled this Order (only provided when the Order's state is FILLED).
        :param FilledTime: Date/time when the Order was filled (only provided when the Order's state is FILLED).
        :param TradeOpenedID: Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill).
        :param TradeReducedID: Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill).
        :param TradeClosedIDs: Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill).
        :param CancellingTransactionID: ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED).
        :param CancelledTime: Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED).
        :param ReplacesOrderID: The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TakeProfitOrder) -> bool:
        """
        Returns true if TakeProfitOrder instances are equal
        
        :param other: Instance of TakeProfitOrder to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderClientExtensionsModifyTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderClientExtensionsModifyTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A OrderClientExtensionsModifyTransaction represents the modification of an Order's Client Extensions."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY\\" for a OrderClienteExtensionsModifyTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY\\" for a OrderClienteExtensionsModifyTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY\\" for a OrderClienteExtensionsModifyTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def OrderID(self) -> str:
        """The ID of the Order who's client extensions are to be modified."""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The ID of the Order who's client extensions are to be modified."""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The original Client ID of the Order who's client extensions are to be modified."""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The original Client ID of the Order who's client extensions are to be modified."""
        ...

    @property
    def ClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensionsModify"""
        ...

    @ClientExtensionsModify.setter
    def ClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensionsModify"""
        ...

    @property
    def TradeClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    @TradeClientExtensionsModify.setter
    def TradeClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction.TypeEnum] = ..., OrderID: str = ..., ClientOrderID: str = ..., ClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ..., TradeClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the OrderClientExtensionsModifyTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY\\" for a OrderClienteExtensionsModifyTransaction..
        :param OrderID: The ID of the Order who's client extensions are to be modified..
        :param ClientOrderID: The original Client ID of the Order who's client extensions are to be modified..
        :param ClientExtensionsModify: ClientExtensionsModify.
        :param TradeClientExtensionsModify: TradeClientExtensionsModify.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction) -> bool:
        """
        Returns true if OrderClientExtensionsModifyTransaction instances are equal
        
        :param other: Instance of OrderClientExtensionsModifyTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class SetTradeDependentOrdersBody(System.Object, System.IEquatable[Oanda_RestV20_Model_SetTradeDependentOrdersBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """SetTradeDependentOrdersBody"""

    @property
    def TakeProfit(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfit"""
        ...

    @TakeProfit.setter
    def TakeProfit(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfit"""
        ...

    @property
    def StopLoss(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLoss"""
        ...

    @StopLoss.setter
    def StopLoss(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLoss"""
        ...

    @property
    def TrailingStopLoss(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLoss"""
        ...

    @TrailingStopLoss.setter
    def TrailingStopLoss(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLoss"""
        ...

    def __init__(self, TakeProfit: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLoss: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLoss: Oanda.RestV20.Model.TrailingStopLossDetails = ...) -> None:
        """
        Initializes a new instance of the SetTradeDependentOrdersBody class.
        
        :param TakeProfit: TakeProfit.
        :param StopLoss: StopLoss.
        :param TrailingStopLoss: TrailingStopLoss.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.SetTradeDependentOrdersBody) -> bool:
        """
        Returns true if SetTradeDependentOrdersBody instances are equal
        
        :param other: Instance of SetTradeDependentOrdersBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderTradeClose(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderTradeClose], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketOrderTradeClose specifies the extensions to a Market Order that has been created specifically to close a Trade."""

    @property
    def TradeID(self) -> str:
        """The ID of the Trade requested to be closed"""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade requested to be closed"""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade requested to be closed"""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade requested to be closed"""
        ...

    @property
    def Units(self) -> str:
        """Indication of how much of the Trade to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade."""
        ...

    @Units.setter
    def Units(self, value: str):
        """Indication of how much of the Trade to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade."""
        ...

    def __init__(self, TradeID: str = ..., ClientTradeID: str = ..., Units: str = ...) -> None:
        """
        Initializes a new instance of the MarketOrderTradeClose class.
        
        :param TradeID: The ID of the Trade requested to be closed.
        :param ClientTradeID: The client ID of the Trade requested to be closed.
        :param Units: Indication of how much of the Trade to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderTradeClose) -> bool:
        """
        Returns true if MarketOrderTradeClose instances are equal
        
        :param other: Instance of MarketOrderTradeClose to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderPositionCloseout(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderPositionCloseout], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketOrderPositionCloseout specifies the extensions to a Market Order when it has been created to closeout a specific Position."""

    @property
    def Instrument(self) -> str:
        """The instrument of the Position being closed out."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The instrument of the Position being closed out."""
        ...

    @property
    def Units(self) -> str:
        """Indication of how much of the Position to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade. The DecimalNumber must always be positive, and represent a number that doesn't exceed the absolute size of the Position."""
        ...

    @Units.setter
    def Units(self, value: str):
        """Indication of how much of the Position to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade. The DecimalNumber must always be positive, and represent a number that doesn't exceed the absolute size of the Position."""
        ...

    def __init__(self, Instrument: str = ..., Units: str = ...) -> None:
        """
        Initializes a new instance of the MarketOrderPositionCloseout class.
        
        :param Instrument: The instrument of the Position being closed out..
        :param Units: Indication of how much of the Position to close. Either \\"ALL\\", or a DecimalNumber reflection a partial close of the Trade. The DecimalNumber must always be positive, and represent a number that doesn't exceed the absolute size of the Position..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderPositionCloseout) -> bool:
        """
        Returns true if MarketOrderPositionCloseout instances are equal
        
        :param other: Instance of MarketOrderPositionCloseout to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderMarginCloseout(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderMarginCloseout], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Details for the Market Order extensions specific to a Market Order placed that is part of a Market Order Margin Closeout in a client's account"""

    class ReasonEnum(System.Enum):
        """The reason the Market Order was created to perform a margin closeout"""

        MARGINCHECKVIOLATION = 0
        """Enum MARGINCHECKVIOLATION for "MARGIN_CHECK_VIOLATION\""""

        REGULATORYMARGINCALLVIOLATION = 1
        """Enum REGULATORYMARGINCALLVIOLATION for "REGULATORY_MARGIN_CALL_VIOLATION\""""

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderMarginCloseout.ReasonEnum]:
        """The reason the Market Order was created to perform a margin closeout"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderMarginCloseout.ReasonEnum]):
        """The reason the Market Order was created to perform a margin closeout"""
        ...

    def __init__(self, Reason: typing.Optional[Oanda.RestV20.Model.MarketOrderMarginCloseout.ReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the MarketOrderMarginCloseout class.
        
        :param Reason: The reason the Market Order was created to perform a margin closeout.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderMarginCloseout) -> bool:
        """
        Returns true if MarketOrderMarginCloseout instances are equal
        
        :param other: Instance of MarketOrderMarginCloseout to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderDelayedTradeClose(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderDelayedTradeClose], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Details for the Market Order extensions specific to a Market Order placed with the intent of fully closing a specific open trade that should have already been closed but wasn't due to halted market conditions"""

    @property
    def TradeID(self) -> str:
        """The ID of the Trade being closed"""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade being closed"""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The Client ID of the Trade being closed"""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The Client ID of the Trade being closed"""
        ...

    @property
    def SourceTransactionID(self) -> str:
        """The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to"""
        ...

    @SourceTransactionID.setter
    def SourceTransactionID(self, value: str):
        """The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to"""
        ...

    def __init__(self, TradeID: str = ..., ClientTradeID: str = ..., SourceTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the MarketOrderDelayedTradeClose class.
        
        :param TradeID: The ID of the Trade being closed.
        :param ClientTradeID: The Client ID of the Trade being closed.
        :param SourceTransactionID: The Transaction ID of the DelayedTradeClosure transaction to which this Delayed Trade Close belongs to.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderDelayedTradeClose) -> bool:
        """
        Returns true if MarketOrderDelayedTradeClose instances are equal
        
        :param other: Instance of MarketOrderDelayedTradeClose to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketOrderRejectTransaction represents the rejection of the creation of a Market Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"MARKET_ORDER_REJECT\\" in a MarketOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class ReasonEnum(System.Enum):
        """The reason that the Market Order was created"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        TRADECLOSE = 1
        """Enum TRADECLOSE for "TRADE_CLOSE\""""

        POSITIONCLOSEOUT = 2
        """Enum POSITIONCLOSEOUT for "POSITION_CLOSEOUT\""""

        MARGINCLOSEOUT = 3
        """Enum MARGINCLOSEOUT for "MARGIN_CLOSEOUT\""""

        DELAYEDTRADECLOSE = 4
        """Enum DELAYEDTRADECLOSE for "DELAYED_TRADE_CLOSE\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"MARKET_ORDER_REJECT\\" in a MarketOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"MARKET_ORDER_REJECT\\" in a MarketOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.ReasonEnum]:
        """The reason that the Market Order was created"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.ReasonEnum]):
        """The reason that the Market Order was created"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The Market Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Market Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @property
    def TradeClose(self) -> Oanda.RestV20.Model.MarketOrderTradeClose:
        """Gets or Sets TradeClose"""
        ...

    @TradeClose.setter
    def TradeClose(self, value: Oanda.RestV20.Model.MarketOrderTradeClose):
        """Gets or Sets TradeClose"""
        ...

    @property
    def LongPositionCloseout(self) -> Oanda.RestV20.Model.MarketOrderPositionCloseout:
        """Gets or Sets LongPositionCloseout"""
        ...

    @LongPositionCloseout.setter
    def LongPositionCloseout(self, value: Oanda.RestV20.Model.MarketOrderPositionCloseout):
        """Gets or Sets LongPositionCloseout"""
        ...

    @property
    def ShortPositionCloseout(self) -> Oanda.RestV20.Model.MarketOrderPositionCloseout:
        """Gets or Sets ShortPositionCloseout"""
        ...

    @ShortPositionCloseout.setter
    def ShortPositionCloseout(self, value: Oanda.RestV20.Model.MarketOrderPositionCloseout):
        """Gets or Sets ShortPositionCloseout"""
        ...

    @property
    def MarginCloseout(self) -> Oanda.RestV20.Model.MarketOrderMarginCloseout:
        """Gets or Sets MarginCloseout"""
        ...

    @MarginCloseout.setter
    def MarginCloseout(self, value: Oanda.RestV20.Model.MarketOrderMarginCloseout):
        """Gets or Sets MarginCloseout"""
        ...

    @property
    def DelayedTradeClose(self) -> Oanda.RestV20.Model.MarketOrderDelayedTradeClose:
        """Gets or Sets DelayedTradeClose"""
        ...

    @DelayedTradeClose.setter
    def DelayedTradeClose(self, value: Oanda.RestV20.Model.MarketOrderDelayedTradeClose):
        """Gets or Sets DelayedTradeClose"""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.TimeInForceEnum] = ..., PriceBound: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.PositionFillEnum] = ..., TradeClose: Oanda.RestV20.Model.MarketOrderTradeClose = ..., LongPositionCloseout: Oanda.RestV20.Model.MarketOrderPositionCloseout = ..., ShortPositionCloseout: Oanda.RestV20.Model.MarketOrderPositionCloseout = ..., MarginCloseout: Oanda.RestV20.Model.MarketOrderMarginCloseout = ..., DelayedTradeClose: Oanda.RestV20.Model.MarketOrderDelayedTradeClose = ..., Reason: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.MarketOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the MarketOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"MARKET_ORDER_REJECT\\" in a MarketOrderRejectTransaction..
        :param Instrument: The Market Order's Instrument..
        :param Units: The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param TimeInForce: The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder..
        :param PriceBound: The worst price that the client is willing to have the Market Order filled at..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TradeClose: TradeClose.
        :param LongPositionCloseout: LongPositionCloseout.
        :param ShortPositionCloseout: ShortPositionCloseout.
        :param MarginCloseout: MarginCloseout.
        :param DelayedTradeClose: DelayedTradeClose.
        :param Reason: The reason that the Market Order was created.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderRejectTransaction) -> bool:
        """
        Returns true if MarketOrderRejectTransaction instances are equal
        
        :param other: Instance of MarketOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4005(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4005], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4005"""

    @property
    def OrderRejectTransaction(self) -> Oanda.RestV20.Model.MarketOrderRejectTransaction:
        """Gets or Sets OrderRejectTransaction"""
        ...

    @OrderRejectTransaction.setter
    def OrderRejectTransaction(self, value: Oanda.RestV20.Model.MarketOrderRejectTransaction):
        """Gets or Sets OrderRejectTransaction"""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, OrderRejectTransaction: Oanda.RestV20.Model.MarketOrderRejectTransaction = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4005 class.
        
        :param OrderRejectTransaction: OrderRejectTransaction.
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4005) -> bool:
        """
        Returns true if InlineResponse4005 instances are equal
        
        :param other: Instance of InlineResponse4005 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class FundingReason(System.Enum):
    """The reason that an Account is being funded."""

    CLIENTFUNDING = 0
    """Enum CLIENTFUNDING for "CLIENT_FUNDING\""""

    ACCOUNTTRANSFER = 1
    """Enum ACCOUNTTRANSFER for "ACCOUNT_TRANSFER\""""

    DIVISIONMIGRATION = 2
    """Enum DIVISIONMIGRATION for "DIVISION_MIGRATION\""""

    SITEMIGRATION = 3
    """Enum SITEMIGRATION for "SITE_MIGRATION\""""

    ADJUSTMENT = 4
    """Enum ADJUSTMENT for "ADJUSTMENT\""""


class LimitOrder(System.Object, System.IEquatable[Oanda_RestV20_Model_LimitOrder], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A LimitOrder is an order that is created with a price threshold, and will only be filled by a price that is equal to or better than the threshold."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    class TypeEnum(System.Enum):
        """The type of the Order. Always set to \\"LIMIT\\" for Limit Orders."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Limit Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrder.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrder.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrder.TypeEnum]:
        """The type of the Order. Always set to \\"LIMIT\\" for Limit Orders."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrder.TypeEnum]):
        """The type of the Order. Always set to \\"LIMIT\\" for Limit Orders."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrder.TimeInForceEnum]:
        """The time-in-force requested for the Limit Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrder.TimeInForceEnum]):
        """The time-in-force requested for the Limit Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrder.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrder.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrder.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrder.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def Instrument(self) -> str:
        """The Limit Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Limit Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def FillingTransactionID(self) -> str:
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @FillingTransactionID.setter
    def FillingTransactionID(self, value: str):
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @property
    def FilledTime(self) -> str:
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @FilledTime.setter
    def FilledTime(self, value: str):
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @property
    def TradeOpenedID(self) -> str:
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @TradeOpenedID.setter
    def TradeOpenedID(self, value: str):
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @property
    def TradeReducedID(self) -> str:
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @TradeReducedID.setter
    def TradeReducedID(self, value: str):
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @property
    def TradeClosedIDs(self) -> System.Collections.Generic.List[str]:
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @TradeClosedIDs.setter
    def TradeClosedIDs(self, value: System.Collections.Generic.List[str]):
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @property
    def CancelledTime(self) -> str:
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @CancelledTime.setter
    def CancelledTime(self, value: str):
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.LimitOrder.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., Type: typing.Optional[Oanda.RestV20.Model.LimitOrder.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.LimitOrder.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.LimitOrder.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.LimitOrder.TriggerConditionEnum] = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., FillingTransactionID: str = ..., FilledTime: str = ..., TradeOpenedID: str = ..., TradeReducedID: str = ..., TradeClosedIDs: System.Collections.Generic.List[str] = ..., CancellingTransactionID: str = ..., CancelledTime: str = ..., ReplacesOrderID: str = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the LimitOrder class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        :param Type: The type of the Order. Always set to \\"LIMIT\\" for Limit Orders..
        :param Instrument: The Limit Order's Instrument..
        :param Units: The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price..
        :param TimeInForce: The time-in-force requested for the Limit Order..
        :param GtdTime: The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param FillingTransactionID: ID of the Transaction that filled this Order (only provided when the Order's state is FILLED).
        :param FilledTime: Date/time when the Order was filled (only provided when the Order's state is FILLED).
        :param TradeOpenedID: Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill).
        :param TradeReducedID: Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill).
        :param TradeClosedIDs: Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill).
        :param CancellingTransactionID: ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED).
        :param CancelledTime: Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED).
        :param ReplacesOrderID: The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LimitOrder) -> bool:
        """
        Returns true if LimitOrder instances are equal
        
        :param other: Instance of LimitOrder to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class DelayedTradeClosureTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_DelayedTradeClosureTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A DelayedTradeClosure Transaction is created administratively to indicate open trades that should have been closed but weren't because the open trades' instruments were untradeable at the time. Open trades listed in this transaction will be closed once their respective instruments become tradeable."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"DELAYED_TRADE_CLOSURE\\" for an DelayedTradeClosureTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class ReasonEnum(System.Enum):
        """The reason for the delayed trade closure"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        TRADECLOSE = 1
        """Enum TRADECLOSE for "TRADE_CLOSE\""""

        POSITIONCLOSEOUT = 2
        """Enum POSITIONCLOSEOUT for "POSITION_CLOSEOUT\""""

        MARGINCLOSEOUT = 3
        """Enum MARGINCLOSEOUT for "MARGIN_CLOSEOUT\""""

        DELAYEDTRADECLOSE = 4
        """Enum DELAYEDTRADECLOSE for "DELAYED_TRADE_CLOSE\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"DELAYED_TRADE_CLOSURE\\" for an DelayedTradeClosureTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"DELAYED_TRADE_CLOSURE\\" for an DelayedTradeClosureTransaction."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.ReasonEnum]:
        """The reason for the delayed trade closure"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.ReasonEnum]):
        """The reason for the delayed trade closure"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeIDs(self) -> str:
        """List of Trade ID's identifying the open trades that will be closed when their respective instruments become tradeable"""
        ...

    @TradeIDs.setter
    def TradeIDs(self, value: str):
        """List of Trade ID's identifying the open trades that will be closed when their respective instruments become tradeable"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.TypeEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.DelayedTradeClosureTransaction.ReasonEnum] = ..., TradeIDs: str = ...) -> None:
        """
        Initializes a new instance of the DelayedTradeClosureTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"DELAYED_TRADE_CLOSURE\\" for an DelayedTradeClosureTransaction..
        :param Reason: The reason for the delayed trade closure.
        :param TradeIDs: List of Trade ID's identifying the open trades that will be closed when their respective instruments become tradeable.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.DelayedTradeClosureTransaction) -> bool:
        """
        Returns true if DelayedTradeClosureTransaction instances are equal
        
        :param other: Instance of DelayedTradeClosureTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderType(System.Enum):
    """The type of the Order."""

    MARKET = 0
    """Enum MARKET for "MARKET\""""

    LIMIT = 1
    """Enum LIMIT for "LIMIT\""""

    STOP = 2
    """Enum STOP for "STOP\""""

    MARKETIFTOUCHED = 3
    """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

    TAKEPROFIT = 4
    """Enum TAKEPROFIT for "TAKE_PROFIT\""""

    STOPLOSS = 5
    """Enum STOPLOSS for "STOP_LOSS\""""

    TRAILINGSTOPLOSS = 6
    """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""


class PositionSide(System.Object, System.IEquatable[Oanda_RestV20_Model_PositionSide], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The representation of a Position for a single direction (long or short)."""

    @property
    def Units(self) -> str:
        """Number of units in the position (negative value indicates short position, positive indicates long position)."""
        ...

    @Units.setter
    def Units(self, value: str):
        """Number of units in the position (negative value indicates short position, positive indicates long position)."""
        ...

    @property
    def AveragePrice(self) -> str:
        """Volume-weighted average of the underlying Trade open prices for the Position."""
        ...

    @AveragePrice.setter
    def AveragePrice(self, value: str):
        """Volume-weighted average of the underlying Trade open prices for the Position."""
        ...

    @property
    def TradeIDs(self) -> System.Collections.Generic.List[str]:
        """List of the open Trade IDs which contribute to the open Position."""
        ...

    @TradeIDs.setter
    def TradeIDs(self, value: System.Collections.Generic.List[str]):
        """List of the open Trade IDs which contribute to the open Position."""
        ...

    @property
    def Pl(self) -> str:
        """Profit/loss realized by the PositionSide over the lifetime of the Account."""
        ...

    @Pl.setter
    def Pl(self, value: str):
        """Profit/loss realized by the PositionSide over the lifetime of the Account."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The unrealized profit/loss of all open Trades that contribute to this PositionSide."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The unrealized profit/loss of all open Trades that contribute to this PositionSide."""
        ...

    @property
    def ResettablePL(self) -> str:
        """Profit/loss realized by the PositionSide since the Account's resettablePL was last reset by the client."""
        ...

    @ResettablePL.setter
    def ResettablePL(self, value: str):
        """Profit/loss realized by the PositionSide since the Account's resettablePL was last reset by the client."""
        ...

    def __init__(self, Units: str = ..., AveragePrice: str = ..., TradeIDs: System.Collections.Generic.List[str] = ..., Pl: str = ..., UnrealizedPL: str = ..., ResettablePL: str = ...) -> None:
        """
        Initializes a new instance of the PositionSide class.
        
        :param Units: Number of units in the position (negative value indicates short position, positive indicates long position)..
        :param AveragePrice: Volume-weighted average of the underlying Trade open prices for the Position..
        :param TradeIDs: List of the open Trade IDs which contribute to the open Position..
        :param Pl: Profit/loss realized by the PositionSide over the lifetime of the Account..
        :param UnrealizedPL: The unrealized profit/loss of all open Trades that contribute to this PositionSide..
        :param ResettablePL: Profit/loss realized by the PositionSide since the Account's resettablePL was last reset by the client..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.PositionSide) -> bool:
        """
        Returns true if PositionSide instances are equal
        
        :param other: Instance of PositionSide to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Position(System.Object, System.IEquatable[Oanda_RestV20_Model_Position], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The specification of a Position within an Account."""

    @property
    def Instrument(self) -> str:
        """The Position's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Position's Instrument."""
        ...

    @property
    def Pl(self) -> str:
        """Profit/loss realized by the Position over the lifetime of the Account."""
        ...

    @Pl.setter
    def Pl(self, value: str):
        """Profit/loss realized by the Position over the lifetime of the Account."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The unrealized profit/loss of all open Trades that contribute to this Position."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The unrealized profit/loss of all open Trades that contribute to this Position."""
        ...

    @property
    def ResettablePL(self) -> str:
        """Profit/loss realized by the Position since the Account's resettablePL was last reset by the client."""
        ...

    @ResettablePL.setter
    def ResettablePL(self, value: str):
        """Profit/loss realized by the Position since the Account's resettablePL was last reset by the client."""
        ...

    @property
    def _Long(self) -> Oanda.RestV20.Model.PositionSide:
        """Gets or Sets _Long"""
        ...

    @_Long.setter
    def _Long(self, value: Oanda.RestV20.Model.PositionSide):
        """Gets or Sets _Long"""
        ...

    @property
    def _Short(self) -> Oanda.RestV20.Model.PositionSide:
        """Gets or Sets _Short"""
        ...

    @_Short.setter
    def _Short(self, value: Oanda.RestV20.Model.PositionSide):
        """Gets or Sets _Short"""
        ...

    def __init__(self, Instrument: str = ..., Pl: str = ..., UnrealizedPL: str = ..., ResettablePL: str = ..., _Long: Oanda.RestV20.Model.PositionSide = ..., _Short: Oanda.RestV20.Model.PositionSide = ...) -> None:
        """
        Initializes a new instance of the Position class.
        
        :param Instrument: The Position's Instrument..
        :param Pl: Profit/loss realized by the Position over the lifetime of the Account..
        :param UnrealizedPL: The unrealized profit/loss of all open Trades that contribute to this Position..
        :param ResettablePL: Profit/loss realized by the Position since the Account's resettablePL was last reset by the client..
        :param _Long: _Long.
        :param _Short: _Short.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Position) -> bool:
        """
        Returns true if Position instances are equal
        
        :param other: Instance of Position to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The base Order specification used when requesting that an Order be created. Each specific Order-type extends this definition."""

    def __init__(self) -> None:
        """Initializes a new instance of the OrderRequest class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderRequest) -> bool:
        """
        Returns true if OrderRequest instances are equal
        
        :param other: Instance of OrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class PriceValue(System.Object, System.IEquatable[Oanda_RestV20_Model_PriceValue], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The string representation of a Price for an Instrument."""

    def __init__(self) -> None:
        """Initializes a new instance of the PriceValue class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.PriceValue) -> bool:
        """
        Returns true if PriceValue instances are equal
        
        :param other: Instance of PriceValue to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ReplaceOrderBody(System.Object, System.IEquatable[Oanda_RestV20_Model_ReplaceOrderBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """ReplaceOrderBody"""

    @property
    def Order(self) -> Oanda.RestV20.Model.OrderRequest:
        """Gets or Sets Order"""
        ...

    @Order.setter
    def Order(self, value: Oanda.RestV20.Model.OrderRequest):
        """Gets or Sets Order"""
        ...

    def __init__(self, Order: Oanda.RestV20.Model.OrderRequest = ...) -> None:
        """
        Initializes a new instance of the ReplaceOrderBody class.
        
        :param Order: Order.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ReplaceOrderBody) -> bool:
        """
        Returns true if ReplaceOrderBody instances are equal
        
        :param other: Instance of ReplaceOrderBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderClientExtensionsModifyRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderClientExtensionsModifyRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A OrderClientExtensionsModifyRejectTransaction represents the rejection of the modification of an Order's Client Extensions."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a OrderClientExtensionsModifyRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a OrderClientExtensionsModifyRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a OrderClientExtensionsModifyRejectTransaction."""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def OrderID(self) -> str:
        """The ID of the Order who's client extensions are to be modified."""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The ID of the Order who's client extensions are to be modified."""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The original Client ID of the Order who's client extensions are to be modified."""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The original Client ID of the Order who's client extensions are to be modified."""
        ...

    @property
    def ClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensionsModify"""
        ...

    @ClientExtensionsModify.setter
    def ClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensionsModify"""
        ...

    @property
    def TradeClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    @TradeClientExtensionsModify.setter
    def TradeClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.TypeEnum] = ..., OrderID: str = ..., ClientOrderID: str = ..., ClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ..., TradeClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the OrderClientExtensionsModifyRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a OrderClientExtensionsModifyRejectTransaction..
        :param OrderID: The ID of the Order who's client extensions are to be modified..
        :param ClientOrderID: The original Client ID of the Order who's client extensions are to be modified..
        :param ClientExtensionsModify: ClientExtensionsModify.
        :param TradeClientExtensionsModify: TradeClientExtensionsModify.
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction) -> bool:
        """
        Returns true if OrderClientExtensionsModifyRejectTransaction instances are equal
        
        :param other: Instance of OrderClientExtensionsModifyRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4043(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4043], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4043"""

    @property
    def OrderClientExtensionsModifyRejectTransaction(self) -> Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction:
        """Gets or Sets OrderClientExtensionsModifyRejectTransaction"""
        ...

    @OrderClientExtensionsModifyRejectTransaction.setter
    def OrderClientExtensionsModifyRejectTransaction(self, value: Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction):
        """Gets or Sets OrderClientExtensionsModifyRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, OrderClientExtensionsModifyRejectTransaction: Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4043 class.
        
        :param OrderClientExtensionsModifyRejectTransaction: OrderClientExtensionsModifyRejectTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account. Only present if the Account exists..
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4043) -> bool:
        """
        Returns true if InlineResponse4043 instances are equal
        
        :param other: Instance of InlineResponse4043 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketIfTouchedOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketIfTouchedOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketIfTouchedOrderRequest specifies the parameters that may be set when creating a Market-if-Touched Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"MARKET_IF_TOUCHED\\" when creating a Market If Touched Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"MARKET_IF_TOUCHED\\" when creating a Market If Touched Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"MARKET_IF_TOUCHED\\" when creating a Market If Touched Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Instrument(self) -> str:
        """The MarketIfTouched Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The MarketIfTouched Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., PriceBound: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRequest.TriggerConditionEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the MarketIfTouchedOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"MARKET_IF_TOUCHED\\" when creating a Market If Touched Order..
        :param Instrument: The MarketIfTouched Order's Instrument..
        :param Units: The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order..
        :param PriceBound: The worst market price that may be used to fill this MarketIfTouched Order..
        :param TimeInForce: The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders..
        :param GtdTime: The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketIfTouchedOrderRequest) -> bool:
        """
        Returns true if MarketIfTouchedOrderRequest instances are equal
        
        :param other: Instance of MarketIfTouchedOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class UnitsAvailableDetails(System.Object, System.IEquatable[Oanda_RestV20_Model_UnitsAvailableDetails], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Representation of many units of an Instrument are available to be traded for both long and short Orders."""

    @property
    def _Long(self) -> str:
        """The units available for long Orders."""
        ...

    @_Long.setter
    def _Long(self, value: str):
        """The units available for long Orders."""
        ...

    @property
    def _Short(self) -> str:
        """The units available for short Orders."""
        ...

    @_Short.setter
    def _Short(self, value: str):
        """The units available for short Orders."""
        ...

    def __init__(self, _Long: str = ..., _Short: str = ...) -> None:
        """
        Initializes a new instance of the UnitsAvailableDetails class.
        
        :param _Long: The units available for long Orders..
        :param _Short: The units available for short Orders..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.UnitsAvailableDetails) -> bool:
        """
        Returns true if UnitsAvailableDetails instances are equal
        
        :param other: Instance of UnitsAvailableDetails to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class UnitsAvailable(System.Object, System.IEquatable[Oanda_RestV20_Model_UnitsAvailable], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Representation of how many units of an Instrument are available to be traded by an Order depending on its postionFill option."""

    @property
    def _Default(self) -> Oanda.RestV20.Model.UnitsAvailableDetails:
        """Gets or Sets _Default"""
        ...

    @_Default.setter
    def _Default(self, value: Oanda.RestV20.Model.UnitsAvailableDetails):
        """Gets or Sets _Default"""
        ...

    @property
    def ReduceFirst(self) -> Oanda.RestV20.Model.UnitsAvailableDetails:
        """Gets or Sets ReduceFirst"""
        ...

    @ReduceFirst.setter
    def ReduceFirst(self, value: Oanda.RestV20.Model.UnitsAvailableDetails):
        """Gets or Sets ReduceFirst"""
        ...

    @property
    def ReduceOnly(self) -> Oanda.RestV20.Model.UnitsAvailableDetails:
        """Gets or Sets ReduceOnly"""
        ...

    @ReduceOnly.setter
    def ReduceOnly(self, value: Oanda.RestV20.Model.UnitsAvailableDetails):
        """Gets or Sets ReduceOnly"""
        ...

    @property
    def OpenOnly(self) -> Oanda.RestV20.Model.UnitsAvailableDetails:
        """Gets or Sets OpenOnly"""
        ...

    @OpenOnly.setter
    def OpenOnly(self, value: Oanda.RestV20.Model.UnitsAvailableDetails):
        """Gets or Sets OpenOnly"""
        ...

    def __init__(self, _Default: Oanda.RestV20.Model.UnitsAvailableDetails = ..., ReduceFirst: Oanda.RestV20.Model.UnitsAvailableDetails = ..., ReduceOnly: Oanda.RestV20.Model.UnitsAvailableDetails = ..., OpenOnly: Oanda.RestV20.Model.UnitsAvailableDetails = ...) -> None:
        """
        Initializes a new instance of the UnitsAvailable class.
        
        :param _Default: _Default.
        :param ReduceFirst: ReduceFirst.
        :param ReduceOnly: ReduceOnly.
        :param OpenOnly: OpenOnly.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.UnitsAvailable) -> bool:
        """
        Returns true if UnitsAvailable instances are equal
        
        :param other: Instance of UnitsAvailable to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeClientExtensionsModifyTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeClientExtensionsModifyTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TradeClientExtensionsModifyTransaction represents the modification of a Trade's Client Extensions."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY\\" for a TradeClientExtensionsModifyTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY\\" for a TradeClientExtensionsModifyTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY\\" for a TradeClientExtensionsModifyTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade who's client extensions are to be modified."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade who's client extensions are to be modified."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The original Client ID of the Trade who's client extensions are to be modified."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The original Client ID of the Trade who's client extensions are to be modified."""
        ...

    @property
    def TradeClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    @TradeClientExtensionsModify.setter
    def TradeClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., TradeClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the TradeClientExtensionsModifyTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY\\" for a TradeClientExtensionsModifyTransaction..
        :param TradeID: The ID of the Trade who's client extensions are to be modified..
        :param ClientTradeID: The original Client ID of the Trade who's client extensions are to be modified..
        :param TradeClientExtensionsModify: TradeClientExtensionsModify.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction) -> bool:
        """
        Returns true if TradeClientExtensionsModifyTransaction instances are equal
        
        :param other: Instance of TradeClientExtensionsModifyTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20027(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20027], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20027"""

    @property
    def TradeClientExtensionsModifyTransaction(self) -> Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction:
        """Gets or Sets TradeClientExtensionsModifyTransaction"""
        ...

    @TradeClientExtensionsModifyTransaction.setter
    def TradeClientExtensionsModifyTransaction(self, value: Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction):
        """Gets or Sets TradeClientExtensionsModifyTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, TradeClientExtensionsModifyTransaction: Oanda.RestV20.Model.TradeClientExtensionsModifyTransaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20027 class.
        
        :param TradeClientExtensionsModifyTransaction: TradeClientExtensionsModifyTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20027) -> bool:
        """
        Returns true if InlineResponse20027 instances are equal
        
        :param other: Instance of InlineResponse20027 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Order(System.Object, System.IEquatable[Oanda_RestV20_Model_Order], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The base Order definition specifies the properties that are common to all Orders."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.Order.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.Order.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.Order.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the Order class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Order) -> bool:
        """
        Returns true if Order instances are equal
        
        :param other: Instance of Order to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse2008(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse2008], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse2008"""

    @property
    def Order(self) -> Oanda.RestV20.Model.Order:
        """Gets or Sets Order"""
        ...

    @Order.setter
    def Order(self, value: Oanda.RestV20.Model.Order):
        """Gets or Sets Order"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, Order: Oanda.RestV20.Model.Order = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse2008 class.
        
        :param Order: Order.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse2008) -> bool:
        """
        Returns true if InlineResponse2008 instances are equal
        
        :param other: Instance of InlineResponse2008 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class RequestID(System.Object, System.IEquatable[Oanda_RestV20_Model_RequestID], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The request identifier."""

    def __init__(self) -> None:
        """Initializes a new instance of the RequestID class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.RequestID) -> bool:
        """
        Returns true if RequestID instances are equal
        
        :param other: Instance of RequestID to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse2007(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse2007], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse2007"""

    @property
    def Orders(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The list of pending Order details"""
        ...

    @Orders.setter
    def Orders(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The list of pending Order details"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, Orders: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse2007 class.
        
        :param Orders: The list of pending Order details.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse2007) -> bool:
        """
        Returns true if InlineResponse2007 instances are equal
        
        :param other: Instance of InlineResponse2007 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TrailingStopLossOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TrailingStopLossOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TrailingStopLossOrderRejectTransaction represents the rejection of the creation of a TrailingStopLoss Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER_REJECT\\" in a TrailingStopLossOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Trailing Stop Loss Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER_REJECT\\" in a TrailingStopLossOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER_REJECT\\" in a TrailingStopLossOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.ReasonEnum]:
        """The reason that the Trailing Stop Loss Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.ReasonEnum]):
        """The reason that the Trailing Stop Loss Order was initiated"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Distance(self) -> str:
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @Distance.setter
    def Distance(self, value: str):
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def IntendedReplacesOrderID(self) -> str:
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    @IntendedReplacesOrderID.setter
    def IntendedReplacesOrderID(self, value: str):
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Distance: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., IntendedReplacesOrderID: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the TrailingStopLossOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TRAILING_STOP_LOSS_ORDER_REJECT\\" in a TrailingStopLossOrderRejectTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Distance: The price distance specified for the TrailingStopLoss Order..
        :param TimeInForce: The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Trailing Stop Loss Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param IntendedReplacesOrderID: The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction) -> bool:
        """
        Returns true if TrailingStopLossOrderRejectTransaction instances are equal
        
        :param other: Instance of TrailingStopLossOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeState(System.Enum):
    """The current state of the Trade."""

    OPEN = 0
    """Enum OPEN for "OPEN\""""

    CLOSED = 1
    """Enum CLOSED for "CLOSED\""""

    CLOSEWHENTRADEABLE = 2
    """Enum CLOSEWHENTRADEABLE for "CLOSE_WHEN_TRADEABLE\""""


class OrderState(System.Enum):
    """The current state of the Order."""

    PENDING = 0
    """Enum PENDING for "PENDING\""""

    FILLED = 1
    """Enum FILLED for "FILLED\""""

    TRIGGERED = 2
    """Enum TRIGGERED for "TRIGGERED\""""

    CANCELLED = 3
    """Enum CANCELLED for "CANCELLED\""""


class StopOrder(System.Object, System.IEquatable[Oanda_RestV20_Model_StopOrder], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopOrder is an order that is created with a price threshold, and will only be filled by a price that is equal to or worse than the threshold."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    class TypeEnum(System.Enum):
        """The type of the Order. Always set to \\"STOP\\" for Stop Orders."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Stop Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.StopOrder.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.StopOrder.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopOrder.TypeEnum]:
        """The type of the Order. Always set to \\"STOP\\" for Stop Orders."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopOrder.TypeEnum]):
        """The type of the Order. Always set to \\"STOP\\" for Stop Orders."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopOrder.TimeInForceEnum]:
        """The time-in-force requested for the Stop Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopOrder.TimeInForceEnum]):
        """The time-in-force requested for the Stop Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.StopOrder.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.StopOrder.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopOrder.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopOrder.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def Instrument(self) -> str:
        """The Stop Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Stop Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def FillingTransactionID(self) -> str:
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @FillingTransactionID.setter
    def FillingTransactionID(self, value: str):
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @property
    def FilledTime(self) -> str:
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @FilledTime.setter
    def FilledTime(self, value: str):
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @property
    def TradeOpenedID(self) -> str:
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @TradeOpenedID.setter
    def TradeOpenedID(self, value: str):
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @property
    def TradeReducedID(self) -> str:
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @TradeReducedID.setter
    def TradeReducedID(self, value: str):
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @property
    def TradeClosedIDs(self) -> System.Collections.Generic.List[str]:
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @TradeClosedIDs.setter
    def TradeClosedIDs(self, value: System.Collections.Generic.List[str]):
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @property
    def CancelledTime(self) -> str:
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @CancelledTime.setter
    def CancelledTime(self, value: str):
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.StopOrder.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., Type: typing.Optional[Oanda.RestV20.Model.StopOrder.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., PriceBound: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopOrder.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.StopOrder.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopOrder.TriggerConditionEnum] = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., FillingTransactionID: str = ..., FilledTime: str = ..., TradeOpenedID: str = ..., TradeReducedID: str = ..., TradeClosedIDs: System.Collections.Generic.List[str] = ..., CancellingTransactionID: str = ..., CancelledTime: str = ..., ReplacesOrderID: str = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the StopOrder class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        :param Type: The type of the Order. Always set to \\"STOP\\" for Stop Orders..
        :param Instrument: The Stop Order's Instrument..
        :param Units: The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price..
        :param PriceBound: The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled..
        :param TimeInForce: The time-in-force requested for the Stop Order..
        :param GtdTime: The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param FillingTransactionID: ID of the Transaction that filled this Order (only provided when the Order's state is FILLED).
        :param FilledTime: Date/time when the Order was filled (only provided when the Order's state is FILLED).
        :param TradeOpenedID: Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill).
        :param TradeReducedID: Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill).
        :param TradeClosedIDs: Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill).
        :param CancellingTransactionID: ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED).
        :param CancelledTime: Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED).
        :param ReplacesOrderID: The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopOrder) -> bool:
        """
        Returns true if StopOrder instances are equal
        
        :param other: Instance of StopOrder to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketOrderRequest specifies the parameters that may be set when creating a Market Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"MARKET\\" when creating a Market Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"MARKET\\" when creating a Market Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"MARKET\\" when creating a Market Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def Instrument(self) -> str:
        """The Market Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Market Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.TimeInForceEnum] = ..., PriceBound: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketOrderRequest.PositionFillEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the MarketOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"MARKET\\" when creating a Market Order..
        :param Instrument: The Market Order's Instrument..
        :param Units: The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param TimeInForce: The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder..
        :param PriceBound: The worst price that the client is willing to have the Market Order filled at..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderRequest) -> bool:
        """
        Returns true if MarketOrderRequest instances are equal
        
        :param other: Instance of MarketOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeSummary(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeSummary], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The summary of a Trade within an Account. This representation does not provide the full details of the Trade's dependent Orders."""

    class StateEnum(System.Enum):
        """The current state of the Trade."""

        OPEN = 0
        """Enum OPEN for "OPEN\""""

        CLOSED = 1
        """Enum CLOSED for "CLOSED\""""

        CLOSEWHENTRADEABLE = 2
        """Enum CLOSEWHENTRADEABLE for "CLOSE_WHEN_TRADEABLE\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.TradeSummary.StateEnum]:
        """The current state of the Trade."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.TradeSummary.StateEnum]):
        """The current state of the Trade."""
        ...

    @property
    def Id(self) -> str:
        """The Trade's identifier, unique within the Trade's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Trade's identifier, unique within the Trade's Account."""
        ...

    @property
    def Instrument(self) -> str:
        """The Trade's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Trade's Instrument."""
        ...

    @property
    def Price(self) -> str:
        """The execution price of the Trade."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The execution price of the Trade."""
        ...

    @property
    def OpenTime(self) -> str:
        """The date/time when the Trade was opened."""
        ...

    @OpenTime.setter
    def OpenTime(self, value: str):
        """The date/time when the Trade was opened."""
        ...

    @property
    def InitialUnits(self) -> str:
        """The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade."""
        ...

    @InitialUnits.setter
    def InitialUnits(self, value: str):
        """The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade."""
        ...

    @property
    def CurrentUnits(self) -> str:
        """The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed."""
        ...

    @CurrentUnits.setter
    def CurrentUnits(self, value: str):
        """The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed."""
        ...

    @property
    def RealizedPL(self) -> str:
        """The total profit/loss realized on the closed portion of the Trade."""
        ...

    @RealizedPL.setter
    def RealizedPL(self, value: str):
        """The total profit/loss realized on the closed portion of the Trade."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The unrealized profit/loss on the open portion of the Trade."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The unrealized profit/loss on the open portion of the Trade."""
        ...

    @property
    def AverageClosePrice(self) -> str:
        """The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once."""
        ...

    @AverageClosePrice.setter
    def AverageClosePrice(self, value: str):
        """The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once."""
        ...

    @property
    def ClosingTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of the Transactions that have closed portions of this Trade."""
        ...

    @ClosingTransactionIDs.setter
    def ClosingTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of the Transactions that have closed portions of this Trade."""
        ...

    @property
    def Financing(self) -> str:
        """The financing paid/collected for this Trade."""
        ...

    @Financing.setter
    def Financing(self, value: str):
        """The financing paid/collected for this Trade."""
        ...

    @property
    def CloseTime(self) -> str:
        """The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED."""
        ...

    @CloseTime.setter
    def CloseTime(self, value: str):
        """The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOrderID(self) -> str:
        """ID of the Trade's Take Profit Order, only provided if such an Order exists."""
        ...

    @TakeProfitOrderID.setter
    def TakeProfitOrderID(self, value: str):
        """ID of the Trade's Take Profit Order, only provided if such an Order exists."""
        ...

    @property
    def StopLossOrderID(self) -> str:
        """ID of the Trade's Stop Loss Order, only provided if such an Order exists."""
        ...

    @StopLossOrderID.setter
    def StopLossOrderID(self, value: str):
        """ID of the Trade's Stop Loss Order, only provided if such an Order exists."""
        ...

    @property
    def TrailingStopLossOrderID(self) -> str:
        """ID of the Trade's Trailing Stop Loss Order, only provided if such an Order exists."""
        ...

    @TrailingStopLossOrderID.setter
    def TrailingStopLossOrderID(self, value: str):
        """ID of the Trade's Trailing Stop Loss Order, only provided if such an Order exists."""
        ...

    def __init__(self, Id: str = ..., Instrument: str = ..., Price: str = ..., OpenTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.TradeSummary.StateEnum] = ..., InitialUnits: str = ..., CurrentUnits: str = ..., RealizedPL: str = ..., UnrealizedPL: str = ..., AverageClosePrice: str = ..., ClosingTransactionIDs: System.Collections.Generic.List[str] = ..., Financing: str = ..., CloseTime: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOrderID: str = ..., StopLossOrderID: str = ..., TrailingStopLossOrderID: str = ...) -> None:
        """
        Initializes a new instance of the TradeSummary class.
        
        :param Id: The Trade's identifier, unique within the Trade's Account..
        :param Instrument: The Trade's Instrument..
        :param Price: The execution price of the Trade..
        :param OpenTime: The date/time when the Trade was opened..
        :param State: The current state of the Trade..
        :param InitialUnits: The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade..
        :param CurrentUnits: The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed..
        :param RealizedPL: The total profit/loss realized on the closed portion of the Trade..
        :param UnrealizedPL: The unrealized profit/loss on the open portion of the Trade..
        :param AverageClosePrice: The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once..
        :param ClosingTransactionIDs: The IDs of the Transactions that have closed portions of this Trade..
        :param Financing: The financing paid/collected for this Trade..
        :param CloseTime: The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOrderID: ID of the Trade's Take Profit Order, only provided if such an Order exists..
        :param StopLossOrderID: ID of the Trade's Stop Loss Order, only provided if such an Order exists..
        :param TrailingStopLossOrderID: ID of the Trade's Trailing Stop Loss Order, only provided if such an Order exists..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeSummary) -> bool:
        """
        Returns true if TradeSummary instances are equal
        
        :param other: Instance of TradeSummary to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Transaction(System.Object, System.IEquatable[Oanda_RestV20_Model_Transaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The base Transaction specification. Specifies properties that are common between all Transaction."""

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ...) -> None:
        """
        Initializes a new instance of the Transaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Transaction) -> bool:
        """
        Returns true if Transaction instances are equal
        
        :param other: Instance of Transaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class AccountChanges(System.Object, System.IEquatable[Oanda_RestV20_Model_AccountChanges], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An AccountChanges Object is used to represent the changes to an Account's Orders, Trades and Positions since a specified Account TransactionID in the past."""

    @property
    def OrdersCreated(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The Orders created. These Orders may have been filled, cancelled or triggered in the same period."""
        ...

    @OrdersCreated.setter
    def OrdersCreated(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The Orders created. These Orders may have been filled, cancelled or triggered in the same period."""
        ...

    @property
    def OrdersCancelled(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The Orders cancelled."""
        ...

    @OrdersCancelled.setter
    def OrdersCancelled(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The Orders cancelled."""
        ...

    @property
    def OrdersFilled(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The Orders filled."""
        ...

    @OrdersFilled.setter
    def OrdersFilled(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The Orders filled."""
        ...

    @property
    def OrdersTriggered(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The Orders triggered."""
        ...

    @OrdersTriggered.setter
    def OrdersTriggered(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The Orders triggered."""
        ...

    @property
    def TradesOpened(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]:
        """The Trades opened."""
        ...

    @TradesOpened.setter
    def TradesOpened(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]):
        """The Trades opened."""
        ...

    @property
    def TradesReduced(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]:
        """The Trades reduced."""
        ...

    @TradesReduced.setter
    def TradesReduced(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]):
        """The Trades reduced."""
        ...

    @property
    def TradesClosed(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]:
        """The Trades closed."""
        ...

    @TradesClosed.setter
    def TradesClosed(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]):
        """The Trades closed."""
        ...

    @property
    def Positions(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Position]:
        """The Positions changed."""
        ...

    @Positions.setter
    def Positions(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Position]):
        """The Positions changed."""
        ...

    @property
    def Transactions(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Transaction]:
        """The Transactions that have been generated."""
        ...

    @Transactions.setter
    def Transactions(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Transaction]):
        """The Transactions that have been generated."""
        ...

    def __init__(self, OrdersCreated: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ..., OrdersCancelled: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ..., OrdersFilled: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ..., OrdersTriggered: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ..., TradesOpened: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary] = ..., TradesReduced: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary] = ..., TradesClosed: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary] = ..., Positions: System.Collections.Generic.List[Oanda.RestV20.Model.Position] = ..., Transactions: System.Collections.Generic.List[Oanda.RestV20.Model.Transaction] = ...) -> None:
        """
        Initializes a new instance of the AccountChanges class.
        
        :param OrdersCreated: The Orders created. These Orders may have been filled, cancelled or triggered in the same period..
        :param OrdersCancelled: The Orders cancelled..
        :param OrdersFilled: The Orders filled..
        :param OrdersTriggered: The Orders triggered..
        :param TradesOpened: The Trades opened..
        :param TradesReduced: The Trades reduced..
        :param TradesClosed: The Trades closed..
        :param Positions: The Positions changed..
        :param Transactions: The Transactions that have been generated..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.AccountChanges) -> bool:
        """
        Returns true if AccountChanges instances are equal
        
        :param other: Instance of AccountChanges to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse2005(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse2005], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse2005"""

    @property
    def Changes(self) -> Oanda.RestV20.Model.AccountChanges:
        """Gets or Sets Changes"""
        ...

    @Changes.setter
    def Changes(self, value: Oanda.RestV20.Model.AccountChanges):
        """Gets or Sets Changes"""
        ...

    @property
    def State(self) -> Oanda.RestV20.Model.AccountChangesState:
        """Gets or Sets State"""
        ...

    @State.setter
    def State(self, value: Oanda.RestV20.Model.AccountChangesState):
        """Gets or Sets State"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the last Transaction created for the Account.  This Transaction ID should be used for future poll requests, as the client has already observed all changes up to and including it."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the last Transaction created for the Account.  This Transaction ID should be used for future poll requests, as the client has already observed all changes up to and including it."""
        ...

    def __init__(self, Changes: Oanda.RestV20.Model.AccountChanges = ..., State: Oanda.RestV20.Model.AccountChangesState = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse2005 class.
        
        :param Changes: Changes.
        :param State: State.
        :param LastTransactionID: The ID of the last Transaction created for the Account.  This Transaction ID should be used for future poll requests, as the client has already observed all changes up to and including it..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse2005) -> bool:
        """
        Returns true if InlineResponse2005 instances are equal
        
        :param other: Instance of InlineResponse2005 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderTriggerCondition(System.Enum):
    """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

    DEFAULT = 0
    """Enum DEFAULT for "DEFAULT\""""

    TRIGGERDEFAULT = 1
    """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

    INVERSE = 2
    """Enum INVERSE for "INVERSE\""""

    BID = 3
    """Enum BID for "BID\""""

    ASK = 4
    """Enum ASK for "ASK\""""

    MID = 5
    """Enum MID for "MID\""""


class Currency(System.Object, System.IEquatable[Oanda_RestV20_Model_Currency], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Currency name identifier. Used by clients to refer to currencies."""

    def __init__(self) -> None:
        """Initializes a new instance of the Currency class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Currency) -> bool:
        """
        Returns true if Currency instances are equal
        
        :param other: Instance of Currency to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20018(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20018], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20018"""

    @property
    def Transaction(self) -> Oanda.RestV20.Model.Transaction:
        """Gets or Sets Transaction"""
        ...

    @Transaction.setter
    def Transaction(self, value: Oanda.RestV20.Model.Transaction):
        """Gets or Sets Transaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, Transaction: Oanda.RestV20.Model.Transaction = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20018 class.
        
        :param Transaction: Transaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20018) -> bool:
        """
        Returns true if InlineResponse20018 instances are equal
        
        :param other: Instance of InlineResponse20018 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketOrderTransaction represents the creation of a Market Order in the user's account. A Market Order is an Order that is filled immediately at the current market price. Market Orders can be specialized when they are created to accomplish a specific task: to close a Trade, to closeout a Position or to particiate in in a Margin closeout."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"MARKET_ORDER\\" in a MarketOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class ReasonEnum(System.Enum):
        """The reason that the Market Order was created"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        TRADECLOSE = 1
        """Enum TRADECLOSE for "TRADE_CLOSE\""""

        POSITIONCLOSEOUT = 2
        """Enum POSITIONCLOSEOUT for "POSITION_CLOSEOUT\""""

        MARGINCLOSEOUT = 3
        """Enum MARGINCLOSEOUT for "MARGIN_CLOSEOUT\""""

        DELAYEDTRADECLOSE = 4
        """Enum DELAYEDTRADECLOSE for "DELAYED_TRADE_CLOSE\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"MARKET_ORDER\\" in a MarketOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"MARKET_ORDER\\" in a MarketOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.ReasonEnum]:
        """The reason that the Market Order was created"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.ReasonEnum]):
        """The reason that the Market Order was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The Market Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Market Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst price that the client is willing to have the Market Order filled at."""
        ...

    @property
    def TradeClose(self) -> Oanda.RestV20.Model.MarketOrderTradeClose:
        """Gets or Sets TradeClose"""
        ...

    @TradeClose.setter
    def TradeClose(self, value: Oanda.RestV20.Model.MarketOrderTradeClose):
        """Gets or Sets TradeClose"""
        ...

    @property
    def LongPositionCloseout(self) -> Oanda.RestV20.Model.MarketOrderPositionCloseout:
        """Gets or Sets LongPositionCloseout"""
        ...

    @LongPositionCloseout.setter
    def LongPositionCloseout(self, value: Oanda.RestV20.Model.MarketOrderPositionCloseout):
        """Gets or Sets LongPositionCloseout"""
        ...

    @property
    def ShortPositionCloseout(self) -> Oanda.RestV20.Model.MarketOrderPositionCloseout:
        """Gets or Sets ShortPositionCloseout"""
        ...

    @ShortPositionCloseout.setter
    def ShortPositionCloseout(self, value: Oanda.RestV20.Model.MarketOrderPositionCloseout):
        """Gets or Sets ShortPositionCloseout"""
        ...

    @property
    def MarginCloseout(self) -> Oanda.RestV20.Model.MarketOrderMarginCloseout:
        """Gets or Sets MarginCloseout"""
        ...

    @MarginCloseout.setter
    def MarginCloseout(self, value: Oanda.RestV20.Model.MarketOrderMarginCloseout):
        """Gets or Sets MarginCloseout"""
        ...

    @property
    def DelayedTradeClose(self) -> Oanda.RestV20.Model.MarketOrderDelayedTradeClose:
        """Gets or Sets DelayedTradeClose"""
        ...

    @DelayedTradeClose.setter
    def DelayedTradeClose(self, value: Oanda.RestV20.Model.MarketOrderDelayedTradeClose):
        """Gets or Sets DelayedTradeClose"""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.TimeInForceEnum] = ..., PriceBound: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.PositionFillEnum] = ..., TradeClose: Oanda.RestV20.Model.MarketOrderTradeClose = ..., LongPositionCloseout: Oanda.RestV20.Model.MarketOrderPositionCloseout = ..., ShortPositionCloseout: Oanda.RestV20.Model.MarketOrderPositionCloseout = ..., MarginCloseout: Oanda.RestV20.Model.MarketOrderMarginCloseout = ..., DelayedTradeClose: Oanda.RestV20.Model.MarketOrderDelayedTradeClose = ..., Reason: typing.Optional[Oanda.RestV20.Model.MarketOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the MarketOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"MARKET_ORDER\\" in a MarketOrderTransaction..
        :param Instrument: The Market Order's Instrument..
        :param Units: The quantity requested to be filled by the Market Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param TimeInForce: The time-in-force requested for the Market Order. Restricted to FOK or IOC for a MarketOrder..
        :param PriceBound: The worst price that the client is willing to have the Market Order filled at..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TradeClose: TradeClose.
        :param LongPositionCloseout: LongPositionCloseout.
        :param ShortPositionCloseout: ShortPositionCloseout.
        :param MarginCloseout: MarginCloseout.
        :param DelayedTradeClose: DelayedTradeClose.
        :param Reason: The reason that the Market Order was created.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketOrderTransaction) -> bool:
        """
        Returns true if MarketOrderTransaction instances are equal
        
        :param other: Instance of MarketOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20026(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20026], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20026"""

    @property
    def OrderCreateTransaction(self) -> Oanda.RestV20.Model.MarketOrderTransaction:
        """Gets or Sets OrderCreateTransaction"""
        ...

    @OrderCreateTransaction.setter
    def OrderCreateTransaction(self, value: Oanda.RestV20.Model.MarketOrderTransaction):
        """Gets or Sets OrderCreateTransaction"""
        ...

    @property
    def OrderFillTransaction(self) -> Oanda.RestV20.Model.OrderFillTransaction:
        """Gets or Sets OrderFillTransaction"""
        ...

    @OrderFillTransaction.setter
    def OrderFillTransaction(self, value: Oanda.RestV20.Model.OrderFillTransaction):
        """Gets or Sets OrderFillTransaction"""
        ...

    @property
    def OrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets OrderCancelTransaction"""
        ...

    @OrderCancelTransaction.setter
    def OrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets OrderCancelTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, OrderCreateTransaction: Oanda.RestV20.Model.MarketOrderTransaction = ..., OrderFillTransaction: Oanda.RestV20.Model.OrderFillTransaction = ..., OrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20026 class.
        
        :param OrderCreateTransaction: OrderCreateTransaction.
        :param OrderFillTransaction: OrderFillTransaction.
        :param OrderCancelTransaction: OrderCancelTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20026) -> bool:
        """
        Returns true if InlineResponse20026 instances are equal
        
        :param other: Instance of InlineResponse20026 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ClientConfigureRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_ClientConfigureRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A ClientConfigureRejectTransaction represents the reject of configuration of an Account by a client."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE_REJECT\\" in a ClientConfigureRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE_REJECT\\" in a ClientConfigureRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE_REJECT\\" in a ClientConfigureRejectTransaction."""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Alias(self) -> str:
        """The client-provided alias for the Account."""
        ...

    @Alias.setter
    def Alias(self, value: str):
        """The client-provided alias for the Account."""
        ...

    @property
    def MarginRate(self) -> str:
        """The margin rate override for the Account."""
        ...

    @MarginRate.setter
    def MarginRate(self, value: str):
        """The margin rate override for the Account."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.TypeEnum] = ..., Alias: str = ..., MarginRate: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.ClientConfigureRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the ClientConfigureRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE_REJECT\\" in a ClientConfigureRejectTransaction..
        :param Alias: The client-provided alias for the Account..
        :param MarginRate: The margin rate override for the Account..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ClientConfigureRejectTransaction) -> bool:
        """
        Returns true if ClientConfigureRejectTransaction instances are equal
        
        :param other: Instance of ClientConfigureRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse400(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse400], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse400"""

    @property
    def ClientConfigureRejectTransaction(self) -> Oanda.RestV20.Model.ClientConfigureRejectTransaction:
        """Gets or Sets ClientConfigureRejectTransaction"""
        ...

    @ClientConfigureRejectTransaction.setter
    def ClientConfigureRejectTransaction(self, value: Oanda.RestV20.Model.ClientConfigureRejectTransaction):
        """Gets or Sets ClientConfigureRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the last Transaction created for the Account."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the last Transaction created for the Account."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, ClientConfigureRejectTransaction: Oanda.RestV20.Model.ClientConfigureRejectTransaction = ..., LastTransactionID: str = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse400 class.
        
        :param ClientConfigureRejectTransaction: ClientConfigureRejectTransaction.
        :param LastTransactionID: The ID of the last Transaction created for the Account..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse400) -> bool:
        """
        Returns true if InlineResponse400 instances are equal
        
        :param other: Instance of InlineResponse400 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class LimitOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_LimitOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A LimitOrderTransaction represents the creation of a Limit Order in the user's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER\\" in a LimitOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Limit Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Limit Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER\\" in a LimitOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"LIMIT_ORDER\\" in a LimitOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the Limit Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the Limit Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.ReasonEnum]:
        """The reason that the Limit Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.ReasonEnum]):
        """The reason that the Limit Order was initiated"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The Limit Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Limit Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.LimitOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., ReplacesOrderID: str = ..., CancellingTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the LimitOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"LIMIT_ORDER\\" in a LimitOrderTransaction..
        :param Instrument: The Limit Order's Instrument..
        :param Units: The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price..
        :param TimeInForce: The time-in-force requested for the Limit Order..
        :param GtdTime: The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Limit Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param ReplacesOrderID: The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)..
        :param CancellingTransactionID: The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LimitOrderTransaction) -> bool:
        """
        Returns true if LimitOrderTransaction instances are equal
        
        :param other: Instance of LimitOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse2009(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse2009], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse2009"""

    @property
    def OrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets OrderCancelTransaction"""
        ...

    @OrderCancelTransaction.setter
    def OrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets OrderCancelTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, OrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse2009 class.
        
        :param OrderCancelTransaction: OrderCancelTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse2009) -> bool:
        """
        Returns true if InlineResponse2009 instances are equal
        
        :param other: Instance of InlineResponse2009 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TakeProfitOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TakeProfitOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TakeProfitOrderRejectTransaction represents the rejection of the creation of a TakeProfit Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER_REJECT\\" in a TakeProfitOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Take Profit Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER_REJECT\\" in a TakeProfitOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER_REJECT\\" in a TakeProfitOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.ReasonEnum]:
        """The reason that the Take Profit Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.ReasonEnum]):
        """The reason that the Take Profit Order was initiated"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def IntendedReplacesOrderID(self) -> str:
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    @IntendedReplacesOrderID.setter
    def IntendedReplacesOrderID(self, value: str):
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., IntendedReplacesOrderID: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the TakeProfitOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TAKE_PROFIT_ORDER_REJECT\\" in a TakeProfitOrderRejectTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold..
        :param TimeInForce: The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders..
        :param GtdTime: The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Take Profit Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param IntendedReplacesOrderID: The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TakeProfitOrderRejectTransaction) -> bool:
        """
        Returns true if TakeProfitOrderRejectTransaction instances are equal
        
        :param other: Instance of TakeProfitOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_StopLossOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopLossOrderRejectTransaction represents the rejection of the creation of a StopLoss Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER_REJECT\\" in a StopLossOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Stop Loss Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

        ONFILL = 2
        """Enum ONFILL for "ON_FILL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER_REJECT\\" in a StopLossOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER_REJECT\\" in a StopLossOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.ReasonEnum]:
        """The reason that the Stop Loss Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.ReasonEnum]):
        """The reason that the Stop Loss Order was initiated"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def OrderFillTransactionID(self) -> str:
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @OrderFillTransactionID.setter
    def OrderFillTransactionID(self, value: str):
        """The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)."""
        ...

    @property
    def IntendedReplacesOrderID(self) -> str:
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    @IntendedReplacesOrderID.setter
    def IntendedReplacesOrderID(self, value: str):
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., OrderFillTransactionID: str = ..., IntendedReplacesOrderID: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.StopLossOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the StopLossOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"STOP_LOSS_ORDER_REJECT\\" in a StopLossOrderRejectTransaction..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold..
        :param TimeInForce: The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Stop Loss Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param OrderFillTransactionID: The ID of the OrderFill Transaction that caused this Order to be created (only provided if this Order was created automatically when another Order was filled)..
        :param IntendedReplacesOrderID: The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopLossOrderRejectTransaction) -> bool:
        """
        Returns true if StopLossOrderRejectTransaction instances are equal
        
        :param other: Instance of StopLossOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4007(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4007], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4007"""

    @property
    def TakeProfitOrderCancelRejectTransaction(self) -> Oanda.RestV20.Model.OrderCancelRejectTransaction:
        """Gets or Sets TakeProfitOrderCancelRejectTransaction"""
        ...

    @TakeProfitOrderCancelRejectTransaction.setter
    def TakeProfitOrderCancelRejectTransaction(self, value: Oanda.RestV20.Model.OrderCancelRejectTransaction):
        """Gets or Sets TakeProfitOrderCancelRejectTransaction"""
        ...

    @property
    def TakeProfitOrderRejectTransaction(self) -> Oanda.RestV20.Model.TakeProfitOrderRejectTransaction:
        """Gets or Sets TakeProfitOrderRejectTransaction"""
        ...

    @TakeProfitOrderRejectTransaction.setter
    def TakeProfitOrderRejectTransaction(self, value: Oanda.RestV20.Model.TakeProfitOrderRejectTransaction):
        """Gets or Sets TakeProfitOrderRejectTransaction"""
        ...

    @property
    def StopLossOrderCancelRejectTransaction(self) -> Oanda.RestV20.Model.OrderCancelRejectTransaction:
        """Gets or Sets StopLossOrderCancelRejectTransaction"""
        ...

    @StopLossOrderCancelRejectTransaction.setter
    def StopLossOrderCancelRejectTransaction(self, value: Oanda.RestV20.Model.OrderCancelRejectTransaction):
        """Gets or Sets StopLossOrderCancelRejectTransaction"""
        ...

    @property
    def StopLossOrderRejectTransaction(self) -> Oanda.RestV20.Model.StopLossOrderRejectTransaction:
        """Gets or Sets StopLossOrderRejectTransaction"""
        ...

    @StopLossOrderRejectTransaction.setter
    def StopLossOrderRejectTransaction(self, value: Oanda.RestV20.Model.StopLossOrderRejectTransaction):
        """Gets or Sets StopLossOrderRejectTransaction"""
        ...

    @property
    def TrailingStopLossOrderCancelRejectTransaction(self) -> Oanda.RestV20.Model.OrderCancelRejectTransaction:
        """Gets or Sets TrailingStopLossOrderCancelRejectTransaction"""
        ...

    @TrailingStopLossOrderCancelRejectTransaction.setter
    def TrailingStopLossOrderCancelRejectTransaction(self, value: Oanda.RestV20.Model.OrderCancelRejectTransaction):
        """Gets or Sets TrailingStopLossOrderCancelRejectTransaction"""
        ...

    @property
    def TrailingStopLossOrderRejectTransaction(self) -> Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction:
        """Gets or Sets TrailingStopLossOrderRejectTransaction"""
        ...

    @TrailingStopLossOrderRejectTransaction.setter
    def TrailingStopLossOrderRejectTransaction(self, value: Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction):
        """Gets or Sets TrailingStopLossOrderRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account."""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, TakeProfitOrderCancelRejectTransaction: Oanda.RestV20.Model.OrderCancelRejectTransaction = ..., TakeProfitOrderRejectTransaction: Oanda.RestV20.Model.TakeProfitOrderRejectTransaction = ..., StopLossOrderCancelRejectTransaction: Oanda.RestV20.Model.OrderCancelRejectTransaction = ..., StopLossOrderRejectTransaction: Oanda.RestV20.Model.StopLossOrderRejectTransaction = ..., TrailingStopLossOrderCancelRejectTransaction: Oanda.RestV20.Model.OrderCancelRejectTransaction = ..., TrailingStopLossOrderRejectTransaction: Oanda.RestV20.Model.TrailingStopLossOrderRejectTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4007 class.
        
        :param TakeProfitOrderCancelRejectTransaction: TakeProfitOrderCancelRejectTransaction.
        :param TakeProfitOrderRejectTransaction: TakeProfitOrderRejectTransaction.
        :param StopLossOrderCancelRejectTransaction: StopLossOrderCancelRejectTransaction.
        :param StopLossOrderRejectTransaction: StopLossOrderRejectTransaction.
        :param TrailingStopLossOrderCancelRejectTransaction: TrailingStopLossOrderCancelRejectTransaction.
        :param TrailingStopLossOrderRejectTransaction: TrailingStopLossOrderRejectTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account..
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4007) -> bool:
        """
        Returns true if InlineResponse4007 instances are equal
        
        :param other: Instance of InlineResponse4007 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TrailingStopLossOrderReason(System.Enum):
    """The reason that the Trailing Stop Loss Order was initiated"""

    CLIENTORDER = 0
    """Enum CLIENTORDER for "CLIENT_ORDER\""""

    REPLACEMENT = 1
    """Enum REPLACEMENT for "REPLACEMENT\""""

    ONFILL = 2
    """Enum ONFILL for "ON_FILL\""""


class InstrumentName(System.Object, System.IEquatable[Oanda_RestV20_Model_InstrumentName], System.ComponentModel.DataAnnotations.IValidatableObject):
    """Instrument name identifier. Used by clients to refer to an Instrument."""

    def __init__(self) -> None:
        """Initializes a new instance of the InstrumentName class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InstrumentName) -> bool:
        """
        Returns true if InstrumentName instances are equal
        
        :param other: Instance of InstrumentName to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OpenTradeFinancing(System.Object, System.IEquatable[Oanda_RestV20_Model_OpenTradeFinancing], System.ComponentModel.DataAnnotations.IValidatableObject):
    """OpenTradeFinancing is used to pay/collect daily financing charge for an open Trade within an Account"""

    @property
    def TradeID(self) -> str:
        """The ID of the Trade that financing is being paid/collected for."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade that financing is being paid/collected for."""
        ...

    @property
    def Financing(self) -> str:
        """The amount of financing paid/collected for the Trade."""
        ...

    @Financing.setter
    def Financing(self, value: str):
        """The amount of financing paid/collected for the Trade."""
        ...

    def __init__(self, TradeID: str = ..., Financing: str = ...) -> None:
        """
        Initializes a new instance of the OpenTradeFinancing class.
        
        :param TradeID: The ID of the Trade that financing is being paid/collected for..
        :param Financing: The amount of financing paid/collected for the Trade..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OpenTradeFinancing) -> bool:
        """
        Returns true if OpenTradeFinancing instances are equal
        
        :param other: Instance of OpenTradeFinancing to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class CandlestickGranularity(System.Enum):
    """The granularity of a candlestick"""

    S5 = 0
    """Enum S5 for "S5\""""

    S10 = 1
    """Enum S10 for "S10\""""

    S15 = 2
    """Enum S15 for "S15\""""

    S30 = 3
    """Enum S30 for "S30\""""

    M1 = 4
    """Enum M1 for "M1\""""

    M2 = 5
    """Enum M2 for "M2\""""

    M4 = 6
    """Enum M4 for "M4\""""

    M5 = 7
    """Enum M5 for "M5\""""

    M10 = 8
    """Enum M10 for "M10\""""

    M15 = 9
    """Enum M15 for "M15\""""

    M30 = 10
    """Enum M30 for "M30\""""

    H1 = 11
    """Enum H1 for "H1\""""

    H2 = 12
    """Enum H2 for "H2\""""

    H3 = 13
    """Enum H3 for "H3\""""

    H4 = 14
    """Enum H4 for "H4\""""

    H6 = 15
    """Enum H6 for "H6\""""

    H8 = 16
    """Enum H8 for "H8\""""

    H12 = 17
    """Enum H12 for "H12\""""

    D = 18
    """Enum D for "D\""""

    W = 19
    """Enum W for "W\""""

    M = 20
    """Enum M for "M\""""


class InlineResponse4045(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4045], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4045"""

    @property
    def OrderRejectTransaction(self) -> Oanda.RestV20.Model.MarketOrderRejectTransaction:
        """Gets or Sets OrderRejectTransaction"""
        ...

    @OrderRejectTransaction.setter
    def OrderRejectTransaction(self, value: Oanda.RestV20.Model.MarketOrderRejectTransaction):
        """Gets or Sets OrderRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, OrderRejectTransaction: Oanda.RestV20.Model.MarketOrderRejectTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4045 class.
        
        :param OrderRejectTransaction: OrderRejectTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account. Only present if the Account exists..
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4045) -> bool:
        """
        Returns true if InlineResponse4045 instances are equal
        
        :param other: Instance of InlineResponse4045 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ReopenTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_ReopenTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A ReopenTransaction represents the re-opening of a closed Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"REOPEN\\" in a ReopenTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.ReopenTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"REOPEN\\" in a ReopenTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.ReopenTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"REOPEN\\" in a ReopenTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.ReopenTransaction.TypeEnum] = ...) -> None:
        """
        Initializes a new instance of the ReopenTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"REOPEN\\" in a ReopenTransaction..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ReopenTransaction) -> bool:
        """
        Returns true if ReopenTransaction instances are equal
        
        :param other: Instance of ReopenTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ClientConfigureTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_ClientConfigureTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A ClientConfigureTransaction represents the configuration of an Account by a client."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE\\" in a ClientConfigureTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.ClientConfigureTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE\\" in a ClientConfigureTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.ClientConfigureTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE\\" in a ClientConfigureTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Alias(self) -> str:
        """The client-provided alias for the Account."""
        ...

    @Alias.setter
    def Alias(self, value: str):
        """The client-provided alias for the Account."""
        ...

    @property
    def MarginRate(self) -> str:
        """The margin rate override for the Account."""
        ...

    @MarginRate.setter
    def MarginRate(self, value: str):
        """The margin rate override for the Account."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.ClientConfigureTransaction.TypeEnum] = ..., Alias: str = ..., MarginRate: str = ...) -> None:
        """
        Initializes a new instance of the ClientConfigureTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"CLIENT_CONFIGURE\\" in a ClientConfigureTransaction..
        :param Alias: The client-provided alias for the Account..
        :param MarginRate: The margin rate override for the Account..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ClientConfigureTransaction) -> bool:
        """
        Returns true if ClientConfigureTransaction instances are equal
        
        :param other: Instance of ClientConfigureTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse2004(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse2004], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse2004"""

    @property
    def ClientConfigureTransaction(self) -> Oanda.RestV20.Model.ClientConfigureTransaction:
        """Gets or Sets ClientConfigureTransaction"""
        ...

    @ClientConfigureTransaction.setter
    def ClientConfigureTransaction(self, value: Oanda.RestV20.Model.ClientConfigureTransaction):
        """Gets or Sets ClientConfigureTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the last Transaction created for the Account."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the last Transaction created for the Account."""
        ...

    def __init__(self, ClientConfigureTransaction: Oanda.RestV20.Model.ClientConfigureTransaction = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse2004 class.
        
        :param ClientConfigureTransaction: ClientConfigureTransaction.
        :param LastTransactionID: The ID of the last Transaction created for the Account..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse2004) -> bool:
        """
        Returns true if InlineResponse2004 instances are equal
        
        :param other: Instance of InlineResponse2004 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class AccountUnits(System.Object, System.IEquatable[Oanda_RestV20_Model_AccountUnits], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The string representation of a quantity of an Account's home currency."""

    def __init__(self) -> None:
        """Initializes a new instance of the AccountUnits class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.AccountUnits) -> bool:
        """
        Returns true if AccountUnits instances are equal
        
        :param other: Instance of AccountUnits to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Account(System.Object, System.IEquatable[Oanda_RestV20_Model_Account], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The full details of a client's Account. This includes full open Trade, open Position and pending Order representation."""

    @property
    def Id(self) -> str:
        """The Account's identifier"""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Account's identifier"""
        ...

    @property
    def Alias(self) -> str:
        """Client-assigned alias for the Account. Only provided if the Account has an alias set"""
        ...

    @Alias.setter
    def Alias(self, value: str):
        """Client-assigned alias for the Account. Only provided if the Account has an alias set"""
        ...

    @property
    def Currency(self) -> str:
        """The home currency of the Account"""
        ...

    @Currency.setter
    def Currency(self, value: str):
        """The home currency of the Account"""
        ...

    @property
    def Balance(self) -> str:
        """The current balance of the Account. Represented in the Account's home currency."""
        ...

    @Balance.setter
    def Balance(self, value: str):
        """The current balance of the Account. Represented in the Account's home currency."""
        ...

    @property
    def CreatedByUserID(self) -> typing.Optional[int]:
        """ID of the user that created the Account."""
        ...

    @CreatedByUserID.setter
    def CreatedByUserID(self, value: typing.Optional[int]):
        """ID of the user that created the Account."""
        ...

    @property
    def CreatedTime(self) -> str:
        """The date/time when the Account was created."""
        ...

    @CreatedTime.setter
    def CreatedTime(self, value: str):
        """The date/time when the Account was created."""
        ...

    @property
    def Pl(self) -> str:
        """The total profit/loss realized over the lifetime of the Account. Represented in the Account's home currency."""
        ...

    @Pl.setter
    def Pl(self, value: str):
        """The total profit/loss realized over the lifetime of the Account. Represented in the Account's home currency."""
        ...

    @property
    def ResettablePL(self) -> str:
        """The total realized profit/loss for the Account since it was last reset by the client. Represented in the Account's home currency."""
        ...

    @ResettablePL.setter
    def ResettablePL(self, value: str):
        """The total realized profit/loss for the Account since it was last reset by the client. Represented in the Account's home currency."""
        ...

    @property
    def ResettabledPLTime(self) -> str:
        """The date/time that the Account's resettablePL was last reset."""
        ...

    @ResettabledPLTime.setter
    def ResettabledPLTime(self, value: str):
        """The date/time that the Account's resettablePL was last reset."""
        ...

    @property
    def MarginRate(self) -> str:
        """Client-provided margin rate override for the Account. The effective margin rate of the Account is the lesser of this value and the OANDA margin rate for the Account's division. This value is only provided if a margin rate override exists for the Account."""
        ...

    @MarginRate.setter
    def MarginRate(self, value: str):
        """Client-provided margin rate override for the Account. The effective margin rate of the Account is the lesser of this value and the OANDA margin rate for the Account's division. This value is only provided if a margin rate override exists for the Account."""
        ...

    @property
    def MarginCallEnterTime(self) -> str:
        """The date/time when the Account entered a margin call state. Only provided if the Account is in a margin call."""
        ...

    @MarginCallEnterTime.setter
    def MarginCallEnterTime(self, value: str):
        """The date/time when the Account entered a margin call state. Only provided if the Account is in a margin call."""
        ...

    @property
    def MarginCallExtensionCount(self) -> typing.Optional[int]:
        """The number of times that the Account's current margin call was extended."""
        ...

    @MarginCallExtensionCount.setter
    def MarginCallExtensionCount(self, value: typing.Optional[int]):
        """The number of times that the Account's current margin call was extended."""
        ...

    @property
    def LastMarginCallExtensionTime(self) -> str:
        """The date/time of the Account's last margin call extension."""
        ...

    @LastMarginCallExtensionTime.setter
    def LastMarginCallExtensionTime(self, value: str):
        """The date/time of the Account's last margin call extension."""
        ...

    @property
    def OpenTradeCount(self) -> typing.Optional[int]:
        """The number of Trades currently open in the Account."""
        ...

    @OpenTradeCount.setter
    def OpenTradeCount(self, value: typing.Optional[int]):
        """The number of Trades currently open in the Account."""
        ...

    @property
    def OpenPositionCount(self) -> typing.Optional[int]:
        """The number of Positions currently open in the Account."""
        ...

    @OpenPositionCount.setter
    def OpenPositionCount(self, value: typing.Optional[int]):
        """The number of Positions currently open in the Account."""
        ...

    @property
    def PendingOrderCount(self) -> typing.Optional[int]:
        """The number of Orders currently pending in the Account."""
        ...

    @PendingOrderCount.setter
    def PendingOrderCount(self, value: typing.Optional[int]):
        """The number of Orders currently pending in the Account."""
        ...

    @property
    def HedgingEnabled(self) -> typing.Optional[bool]:
        """Flag indicating that the Account has hedging enabled."""
        ...

    @HedgingEnabled.setter
    def HedgingEnabled(self, value: typing.Optional[bool]):
        """Flag indicating that the Account has hedging enabled."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency."""
        ...

    @property
    def NAV(self) -> str:
        """The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency."""
        ...

    @NAV.setter
    def NAV(self, value: str):
        """The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency."""
        ...

    @property
    def MarginUsed(self) -> str:
        """Margin currently used for the Account. Represented in the Account's home currency."""
        ...

    @MarginUsed.setter
    def MarginUsed(self, value: str):
        """Margin currently used for the Account. Represented in the Account's home currency."""
        ...

    @property
    def MarginAvailable(self) -> str:
        """Margin available for Account. Represented in the Account's home currency."""
        ...

    @MarginAvailable.setter
    def MarginAvailable(self, value: str):
        """Margin available for Account. Represented in the Account's home currency."""
        ...

    @property
    def PositionValue(self) -> str:
        """The value of the Account's open positions represented in the Account's home currency."""
        ...

    @PositionValue.setter
    def PositionValue(self, value: str):
        """The value of the Account's open positions represented in the Account's home currency."""
        ...

    @property
    def MarginCloseoutUnrealizedPL(self) -> str:
        """The Account's margin closeout unrealized PL."""
        ...

    @MarginCloseoutUnrealizedPL.setter
    def MarginCloseoutUnrealizedPL(self, value: str):
        """The Account's margin closeout unrealized PL."""
        ...

    @property
    def MarginCloseoutNAV(self) -> str:
        """The Account's margin closeout NAV."""
        ...

    @MarginCloseoutNAV.setter
    def MarginCloseoutNAV(self, value: str):
        """The Account's margin closeout NAV."""
        ...

    @property
    def MarginCloseoutMarginUsed(self) -> str:
        """The Account's margin closeout margin used."""
        ...

    @MarginCloseoutMarginUsed.setter
    def MarginCloseoutMarginUsed(self, value: str):
        """The Account's margin closeout margin used."""
        ...

    @property
    def MarginCloseoutPercent(self) -> str:
        """The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation."""
        ...

    @MarginCloseoutPercent.setter
    def MarginCloseoutPercent(self, value: str):
        """The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation."""
        ...

    @property
    def MarginCloseoutPositionValue(self) -> str:
        """The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency."""
        ...

    @MarginCloseoutPositionValue.setter
    def MarginCloseoutPositionValue(self, value: str):
        """The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency."""
        ...

    @property
    def WithdrawalLimit(self) -> str:
        """The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account."""
        ...

    @WithdrawalLimit.setter
    def WithdrawalLimit(self, value: str):
        """The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account."""
        ...

    @property
    def MarginCallMarginUsed(self) -> str:
        """The Account's margin call margin used."""
        ...

    @MarginCallMarginUsed.setter
    def MarginCallMarginUsed(self, value: str):
        """The Account's margin call margin used."""
        ...

    @property
    def MarginCallPercent(self) -> str:
        """The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation."""
        ...

    @MarginCallPercent.setter
    def MarginCallPercent(self, value: str):
        """The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the last Transaction created for the Account."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the last Transaction created for the Account."""
        ...

    @property
    def Trades(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]:
        """The details of the Trades currently open in the Account."""
        ...

    @Trades.setter
    def Trades(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary]):
        """The details of the Trades currently open in the Account."""
        ...

    @property
    def Positions(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Position]:
        """The details all Account Positions."""
        ...

    @Positions.setter
    def Positions(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Position]):
        """The details all Account Positions."""
        ...

    @property
    def Orders(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Order]:
        """The details of the Orders currently pending in the Account."""
        ...

    @Orders.setter
    def Orders(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Order]):
        """The details of the Orders currently pending in the Account."""
        ...

    def __init__(self, Id: str = ..., Alias: str = ..., Currency: str = ..., Balance: str = ..., CreatedByUserID: typing.Optional[int] = ..., CreatedTime: str = ..., Pl: str = ..., ResettablePL: str = ..., ResettabledPLTime: str = ..., MarginRate: str = ..., MarginCallEnterTime: str = ..., MarginCallExtensionCount: typing.Optional[int] = ..., LastMarginCallExtensionTime: str = ..., OpenTradeCount: typing.Optional[int] = ..., OpenPositionCount: typing.Optional[int] = ..., PendingOrderCount: typing.Optional[int] = ..., HedgingEnabled: typing.Optional[bool] = ..., UnrealizedPL: str = ..., NAV: str = ..., MarginUsed: str = ..., MarginAvailable: str = ..., PositionValue: str = ..., MarginCloseoutUnrealizedPL: str = ..., MarginCloseoutNAV: str = ..., MarginCloseoutMarginUsed: str = ..., MarginCloseoutPercent: str = ..., MarginCloseoutPositionValue: str = ..., WithdrawalLimit: str = ..., MarginCallMarginUsed: str = ..., MarginCallPercent: str = ..., LastTransactionID: str = ..., Trades: System.Collections.Generic.List[Oanda.RestV20.Model.TradeSummary] = ..., Positions: System.Collections.Generic.List[Oanda.RestV20.Model.Position] = ..., Orders: System.Collections.Generic.List[Oanda.RestV20.Model.Order] = ...) -> None:
        """
        Initializes a new instance of the Account class.
        
        :param Id: The Account's identifier.
        :param Alias: Client-assigned alias for the Account. Only provided if the Account has an alias set.
        :param Currency: The home currency of the Account.
        :param Balance: The current balance of the Account. Represented in the Account's home currency..
        :param CreatedByUserID: ID of the user that created the Account..
        :param CreatedTime: The date/time when the Account was created..
        :param Pl: The total profit/loss realized over the lifetime of the Account. Represented in the Account's home currency..
        :param ResettablePL: The total realized profit/loss for the Account since it was last reset by the client. Represented in the Account's home currency..
        :param ResettabledPLTime: The date/time that the Account's resettablePL was last reset..
        :param MarginRate: Client-provided margin rate override for the Account. The effective margin rate of the Account is the lesser of this value and the OANDA margin rate for the Account's division. This value is only provided if a margin rate override exists for the Account..
        :param MarginCallEnterTime: The date/time when the Account entered a margin call state. Only provided if the Account is in a margin call..
        :param MarginCallExtensionCount: The number of times that the Account's current margin call was extended..
        :param LastMarginCallExtensionTime: The date/time of the Account's last margin call extension..
        :param OpenTradeCount: The number of Trades currently open in the Account..
        :param OpenPositionCount: The number of Positions currently open in the Account..
        :param PendingOrderCount: The number of Orders currently pending in the Account..
        :param HedgingEnabled: Flag indicating that the Account has hedging enabled..
        :param UnrealizedPL: The total unrealized profit/loss for all Trades currently open in the Account. Represented in the Account's home currency..
        :param NAV: The net asset value of the Account. Equal to Account balance + unrealizedPL. Represented in the Account's home currency..
        :param MarginUsed: Margin currently used for the Account. Represented in the Account's home currency..
        :param MarginAvailable: Margin available for Account. Represented in the Account's home currency..
        :param PositionValue: The value of the Account's open positions represented in the Account's home currency..
        :param MarginCloseoutUnrealizedPL: The Account's margin closeout unrealized PL..
        :param MarginCloseoutNAV: The Account's margin closeout NAV..
        :param MarginCloseoutMarginUsed: The Account's margin closeout margin used..
        :param MarginCloseoutPercent: The Account's margin closeout percentage. When this value is 1.0 or above the Account is in a margin closeout situation..
        :param MarginCloseoutPositionValue: The value of the Account's open positions as used for margin closeout calculations represented in the Account's home currency..
        :param WithdrawalLimit: The current WithdrawalLimit for the account which will be zero or a positive value indicating how much can be withdrawn from the account..
        :param MarginCallMarginUsed: The Account's margin call margin used..
        :param MarginCallPercent: The Account's margin call percentage. When this value is 1.0 or above the Account is in a margin call situation..
        :param LastTransactionID: The ID of the last Transaction created for the Account..
        :param Trades: The details of the Trades currently open in the Account..
        :param Positions: The details all Account Positions..
        :param Orders: The details of the Orders currently pending in the Account..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Account) -> bool:
        """
        Returns true if Account instances are equal
        
        :param other: Instance of Account to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TransferFundsRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TransferFundsRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TransferFundsRejectTransaction represents the rejection of the transfer of funds in/out of an Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TRANSFER_FUNDS_REJECT\\" in a TransferFundsRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class FundingReasonEnum(System.Enum):
        """The reason that an Account is being funded."""

        CLIENTFUNDING = 0
        """Enum CLIENTFUNDING for "CLIENT_FUNDING\""""

        ACCOUNTTRANSFER = 1
        """Enum ACCOUNTTRANSFER for "ACCOUNT_TRANSFER\""""

        DIVISIONMIGRATION = 2
        """Enum DIVISIONMIGRATION for "DIVISION_MIGRATION\""""

        SITEMIGRATION = 3
        """Enum SITEMIGRATION for "SITE_MIGRATION\""""

        ADJUSTMENT = 4
        """Enum ADJUSTMENT for "ADJUSTMENT\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TRANSFER_FUNDS_REJECT\\" in a TransferFundsRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TRANSFER_FUNDS_REJECT\\" in a TransferFundsRejectTransaction."""
        ...

    @property
    def FundingReason(self) -> typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.FundingReasonEnum]:
        """The reason that an Account is being funded."""
        ...

    @FundingReason.setter
    def FundingReason(self, value: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.FundingReasonEnum]):
        """The reason that an Account is being funded."""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Amount(self) -> str:
        """The amount to deposit/withdraw from the Account in the Account's home currency. A positive value indicates a deposit, a negative value indicates a withdrawal."""
        ...

    @Amount.setter
    def Amount(self, value: str):
        """The amount to deposit/withdraw from the Account in the Account's home currency. A positive value indicates a deposit, a negative value indicates a withdrawal."""
        ...

    @property
    def Comment(self) -> str:
        """An optional comment that may be attached to a fund transfer for audit purposes"""
        ...

    @Comment.setter
    def Comment(self, value: str):
        """An optional comment that may be attached to a fund transfer for audit purposes"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.TypeEnum] = ..., Amount: str = ..., FundingReason: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.FundingReasonEnum] = ..., Comment: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.TransferFundsRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the TransferFundsRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TRANSFER_FUNDS_REJECT\\" in a TransferFundsRejectTransaction..
        :param Amount: The amount to deposit/withdraw from the Account in the Account's home currency. A positive value indicates a deposit, a negative value indicates a withdrawal..
        :param FundingReason: The reason that an Account is being funded..
        :param Comment: An optional comment that may be attached to a fund transfer for audit purposes.
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TransferFundsRejectTransaction) -> bool:
        """
        Returns true if TransferFundsRejectTransaction instances are equal
        
        :param other: Instance of TransferFundsRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossOrder(System.Object, System.IEquatable[Oanda_RestV20_Model_StopLossOrder], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopLossOrder is an order that is linked to an open Trade and created with a price threshold. The Order will be filled (closing the Trade) by the first price that is equal to or worse than the threshold. A StopLossOrder cannot be used to open a new Position."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    class TypeEnum(System.Enum):
        """The type of the Order. Always set to \\"STOP_LOSS\\" for Stop Loss Orders."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrder.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrder.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrder.TypeEnum]:
        """The type of the Order. Always set to \\"STOP_LOSS\\" for Stop Loss Orders."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TypeEnum]):
        """The type of the Order. Always set to \\"STOP_LOSS\\" for Stop Loss Orders."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrder.TimeInForceEnum]:
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TimeInForceEnum]):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrder.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def FillingTransactionID(self) -> str:
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @FillingTransactionID.setter
    def FillingTransactionID(self, value: str):
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @property
    def FilledTime(self) -> str:
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @FilledTime.setter
    def FilledTime(self, value: str):
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @property
    def TradeOpenedID(self) -> str:
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @TradeOpenedID.setter
    def TradeOpenedID(self, value: str):
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @property
    def TradeReducedID(self) -> str:
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @TradeReducedID.setter
    def TradeReducedID(self, value: str):
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @property
    def TradeClosedIDs(self) -> System.Collections.Generic.List[str]:
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @TradeClosedIDs.setter
    def TradeClosedIDs(self, value: System.Collections.Generic.List[str]):
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @property
    def CancelledTime(self) -> str:
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @CancelledTime.setter
    def CancelledTime(self, value: str):
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.StopLossOrder.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., Type: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopLossOrder.TriggerConditionEnum] = ..., FillingTransactionID: str = ..., FilledTime: str = ..., TradeOpenedID: str = ..., TradeReducedID: str = ..., TradeClosedIDs: System.Collections.Generic.List[str] = ..., CancellingTransactionID: str = ..., CancelledTime: str = ..., ReplacesOrderID: str = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the StopLossOrder class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        :param Type: The type of the Order. Always set to \\"STOP_LOSS\\" for Stop Loss Orders..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold..
        :param TimeInForce: The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param FillingTransactionID: ID of the Transaction that filled this Order (only provided when the Order's state is FILLED).
        :param FilledTime: Date/time when the Order was filled (only provided when the Order's state is FILLED).
        :param TradeOpenedID: Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill).
        :param TradeReducedID: Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill).
        :param TradeClosedIDs: Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill).
        :param CancellingTransactionID: ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED).
        :param CancelledTime: Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED).
        :param ReplacesOrderID: The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopLossOrder) -> bool:
        """
        Returns true if StopLossOrder instances are equal
        
        :param other: Instance of StopLossOrder to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TrailingStopLossOrder(System.Object, System.IEquatable[Oanda_RestV20_Model_TrailingStopLossOrder], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TrailingStopLossOrder is an order that is linked to an open Trade and created with a price distance. The price distance is used to calculate a trailing stop value for the order that is in the losing direction from the market price at the time of the order's creation. The trailing stop value will follow the market price as it moves in the winning direction, and the order will filled (closing the Trade) by the first price that is equal to or worse than the trailing stop value. A TrailingStopLossOrder cannot be used to open a new Position."""

    class StateEnum(System.Enum):
        """The current state of the Order."""

        PENDING = 0
        """Enum PENDING for "PENDING\""""

        FILLED = 1
        """Enum FILLED for "FILLED\""""

        TRIGGERED = 2
        """Enum TRIGGERED for "TRIGGERED\""""

        CANCELLED = 3
        """Enum CANCELLED for "CANCELLED\""""

    class TypeEnum(System.Enum):
        """The type of the Order. Always set to \\"TRAILING_STOP_LOSS\\" for Trailing Stop Loss Orders."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.StateEnum]:
        """The current state of the Order."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.StateEnum]):
        """The current state of the Order."""
        ...

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TypeEnum]:
        """The type of the Order. Always set to \\"TRAILING_STOP_LOSS\\" for Trailing Stop Loss Orders."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TypeEnum]):
        """The type of the Order. Always set to \\"TRAILING_STOP_LOSS\\" for Trailing Stop Loss Orders."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TimeInForceEnum]:
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TimeInForceEnum]):
        """The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Id(self) -> str:
        """The Order's identifier, unique within the Order's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Order's identifier, unique within the Order's Account."""
        ...

    @property
    def CreateTime(self) -> str:
        """The time when the Order was created."""
        ...

    @CreateTime.setter
    def CreateTime(self, value: str):
        """The time when the Order was created."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Distance(self) -> str:
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @Distance.setter
    def Distance(self, value: str):
        """The price distance specified for the TrailingStopLoss Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def TrailingStopValue(self) -> str:
        """The trigger price for the Trailing Stop Loss Order. The trailing stop value will trail (follow) the market price by the TSL order's configured \\"distance\\" as the market price moves in the winning direction. If the market price moves to a level that is equal to or worse than the trailing stop value, the order will be filled and the Trade will be closed."""
        ...

    @TrailingStopValue.setter
    def TrailingStopValue(self, value: str):
        """The trigger price for the Trailing Stop Loss Order. The trailing stop value will trail (follow) the market price by the TSL order's configured \\"distance\\" as the market price moves in the winning direction. If the market price moves to a level that is equal to or worse than the trailing stop value, the order will be filled and the Trade will be closed."""
        ...

    @property
    def FillingTransactionID(self) -> str:
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @FillingTransactionID.setter
    def FillingTransactionID(self, value: str):
        """ID of the Transaction that filled this Order (only provided when the Order's state is FILLED)"""
        ...

    @property
    def FilledTime(self) -> str:
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @FilledTime.setter
    def FilledTime(self, value: str):
        """Date/time when the Order was filled (only provided when the Order's state is FILLED)"""
        ...

    @property
    def TradeOpenedID(self) -> str:
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @TradeOpenedID.setter
    def TradeOpenedID(self, value: str):
        """Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill)"""
        ...

    @property
    def TradeReducedID(self) -> str:
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @TradeReducedID.setter
    def TradeReducedID(self, value: str):
        """Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill)"""
        ...

    @property
    def TradeClosedIDs(self) -> System.Collections.Generic.List[str]:
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @TradeClosedIDs.setter
    def TradeClosedIDs(self, value: System.Collections.Generic.List[str]):
        """Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill)"""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED)"""
        ...

    @property
    def CancelledTime(self) -> str:
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @CancelledTime.setter
    def CancelledTime(self, value: str):
        """Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED)"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)."""
        ...

    @property
    def ReplacedByOrderID(self) -> str:
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    @ReplacedByOrderID.setter
    def ReplacedByOrderID(self, value: str):
        """The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)."""
        ...

    def __init__(self, Id: str = ..., CreateTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.StateEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., Type: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Distance: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TrailingStopLossOrder.TriggerConditionEnum] = ..., TrailingStopValue: str = ..., FillingTransactionID: str = ..., FilledTime: str = ..., TradeOpenedID: str = ..., TradeReducedID: str = ..., TradeClosedIDs: System.Collections.Generic.List[str] = ..., CancellingTransactionID: str = ..., CancelledTime: str = ..., ReplacesOrderID: str = ..., ReplacedByOrderID: str = ...) -> None:
        """
        Initializes a new instance of the TrailingStopLossOrder class.
        
        :param Id: The Order's identifier, unique within the Order's Account..
        :param CreateTime: The time when the Order was created..
        :param State: The current state of the Order..
        :param ClientExtensions: ClientExtensions.
        :param Type: The type of the Order. Always set to \\"TRAILING_STOP_LOSS\\" for Trailing Stop Loss Orders..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Distance: The price distance specified for the TrailingStopLoss Order..
        :param TimeInForce: The time-in-force requested for the TrailingStopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TrailingStopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param TrailingStopValue: The trigger price for the Trailing Stop Loss Order. The trailing stop value will trail (follow) the market price by the TSL order's configured \\"distance\\" as the market price moves in the winning direction. If the market price moves to a level that is equal to or worse than the trailing stop value, the order will be filled and the Trade will be closed..
        :param FillingTransactionID: ID of the Transaction that filled this Order (only provided when the Order's state is FILLED).
        :param FilledTime: Date/time when the Order was filled (only provided when the Order's state is FILLED).
        :param TradeOpenedID: Trade ID of Trade opened when the Order was filled (only provided when the Order's state is FILLED and a Trade was opened as a result of the fill).
        :param TradeReducedID: Trade ID of Trade reduced when the Order was filled (only provided when the Order's state is FILLED and a Trade was reduced as a result of the fill).
        :param TradeClosedIDs: Trade IDs of Trades closed when the Order was filled (only provided when the Order's state is FILLED and one or more Trades were closed as a result of the fill).
        :param CancellingTransactionID: ID of the Transaction that cancelled the Order (only provided when the Order's state is CANCELLED).
        :param CancelledTime: Date/time when the Order was cancelled (only provided when the state of the Order is CANCELLED).
        :param ReplacesOrderID: The ID of the Order that was replaced by this Order (only provided if this Order was created as part of a cancel/replace)..
        :param ReplacedByOrderID: The ID of the Order that replaced this Order (only provided if this Order was cancelled as part of a cancel/replace)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TrailingStopLossOrder) -> bool:
        """
        Returns true if TrailingStopLossOrder instances are equal
        
        :param other: Instance of TrailingStopLossOrder to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class Trade(System.Object, System.IEquatable[Oanda_RestV20_Model_Trade], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The specification of a Trade within an Account. This includes the full representation of the Trade's dependent Orders in addition to the IDs of those Orders."""

    class StateEnum(System.Enum):
        """The current state of the Trade."""

        OPEN = 0
        """Enum OPEN for "OPEN\""""

        CLOSED = 1
        """Enum CLOSED for "CLOSED\""""

        CLOSEWHENTRADEABLE = 2
        """Enum CLOSEWHENTRADEABLE for "CLOSE_WHEN_TRADEABLE\""""

    @property
    def State(self) -> typing.Optional[Oanda.RestV20.Model.Trade.StateEnum]:
        """The current state of the Trade."""
        ...

    @State.setter
    def State(self, value: typing.Optional[Oanda.RestV20.Model.Trade.StateEnum]):
        """The current state of the Trade."""
        ...

    @property
    def Id(self) -> str:
        """The Trade's identifier, unique within the Trade's Account."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Trade's identifier, unique within the Trade's Account."""
        ...

    @property
    def Instrument(self) -> str:
        """The Trade's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Trade's Instrument."""
        ...

    @property
    def Price(self) -> str:
        """The execution price of the Trade."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The execution price of the Trade."""
        ...

    @property
    def OpenTime(self) -> str:
        """The date/time when the Trade was opened."""
        ...

    @OpenTime.setter
    def OpenTime(self, value: str):
        """The date/time when the Trade was opened."""
        ...

    @property
    def InitialUnits(self) -> str:
        """The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade."""
        ...

    @InitialUnits.setter
    def InitialUnits(self, value: str):
        """The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade."""
        ...

    @property
    def CurrentUnits(self) -> str:
        """The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed."""
        ...

    @CurrentUnits.setter
    def CurrentUnits(self, value: str):
        """The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed."""
        ...

    @property
    def RealizedPL(self) -> str:
        """The total profit/loss realized on the closed portion of the Trade."""
        ...

    @RealizedPL.setter
    def RealizedPL(self, value: str):
        """The total profit/loss realized on the closed portion of the Trade."""
        ...

    @property
    def UnrealizedPL(self) -> str:
        """The unrealized profit/loss on the open portion of the Trade."""
        ...

    @UnrealizedPL.setter
    def UnrealizedPL(self, value: str):
        """The unrealized profit/loss on the open portion of the Trade."""
        ...

    @property
    def AverageClosePrice(self) -> str:
        """The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once."""
        ...

    @AverageClosePrice.setter
    def AverageClosePrice(self, value: str):
        """The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once."""
        ...

    @property
    def ClosingTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of the Transactions that have closed portions of this Trade."""
        ...

    @ClosingTransactionIDs.setter
    def ClosingTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of the Transactions that have closed portions of this Trade."""
        ...

    @property
    def Financing(self) -> str:
        """The financing paid/collected for this Trade."""
        ...

    @Financing.setter
    def Financing(self, value: str):
        """The financing paid/collected for this Trade."""
        ...

    @property
    def CloseTime(self) -> str:
        """The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED."""
        ...

    @CloseTime.setter
    def CloseTime(self, value: str):
        """The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOrder(self) -> Oanda.RestV20.Model.TakeProfitOrder:
        """Gets or Sets TakeProfitOrder"""
        ...

    @TakeProfitOrder.setter
    def TakeProfitOrder(self, value: Oanda.RestV20.Model.TakeProfitOrder):
        """Gets or Sets TakeProfitOrder"""
        ...

    @property
    def StopLossOrder(self) -> Oanda.RestV20.Model.StopLossOrder:
        """Gets or Sets StopLossOrder"""
        ...

    @StopLossOrder.setter
    def StopLossOrder(self, value: Oanda.RestV20.Model.StopLossOrder):
        """Gets or Sets StopLossOrder"""
        ...

    @property
    def TrailingStopLossOrder(self) -> Oanda.RestV20.Model.TrailingStopLossOrder:
        """Gets or Sets TrailingStopLossOrder"""
        ...

    @TrailingStopLossOrder.setter
    def TrailingStopLossOrder(self, value: Oanda.RestV20.Model.TrailingStopLossOrder):
        """Gets or Sets TrailingStopLossOrder"""
        ...

    def __init__(self, Id: str = ..., Instrument: str = ..., Price: str = ..., OpenTime: str = ..., State: typing.Optional[Oanda.RestV20.Model.Trade.StateEnum] = ..., InitialUnits: str = ..., CurrentUnits: str = ..., RealizedPL: str = ..., UnrealizedPL: str = ..., AverageClosePrice: str = ..., ClosingTransactionIDs: System.Collections.Generic.List[str] = ..., Financing: str = ..., CloseTime: str = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOrder: Oanda.RestV20.Model.TakeProfitOrder = ..., StopLossOrder: Oanda.RestV20.Model.StopLossOrder = ..., TrailingStopLossOrder: Oanda.RestV20.Model.TrailingStopLossOrder = ...) -> None:
        """
        Initializes a new instance of the Trade class.
        
        :param Id: The Trade's identifier, unique within the Trade's Account..
        :param Instrument: The Trade's Instrument..
        :param Price: The execution price of the Trade..
        :param OpenTime: The date/time when the Trade was opened..
        :param State: The current state of the Trade..
        :param InitialUnits: The initial size of the Trade. Negative values indicate a short Trade, and positive values indicate a long Trade..
        :param CurrentUnits: The number of units currently open for the Trade. This value is reduced to 0.0 as the Trade is closed..
        :param RealizedPL: The total profit/loss realized on the closed portion of the Trade..
        :param UnrealizedPL: The unrealized profit/loss on the open portion of the Trade..
        :param AverageClosePrice: The average closing price of the Trade. Only present if the Trade has been closed or reduced at least once..
        :param ClosingTransactionIDs: The IDs of the Transactions that have closed portions of this Trade..
        :param Financing: The financing paid/collected for this Trade..
        :param CloseTime: The date/time when the Trade was fully closed. Only provided for Trades whose state is CLOSED..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOrder: TakeProfitOrder.
        :param StopLossOrder: StopLossOrder.
        :param TrailingStopLossOrder: TrailingStopLossOrder.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.Trade) -> bool:
        """
        Returns true if Trade instances are equal
        
        :param other: Instance of Trade to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20023(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20023], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20023"""

    @property
    def Trades(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Trade]:
        """The list of Trade detail objects"""
        ...

    @Trades.setter
    def Trades(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Trade]):
        """The list of Trade detail objects"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, Trades: System.Collections.Generic.List[Oanda.RestV20.Model.Trade] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20023 class.
        
        :param Trades: The list of Trade detail objects.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20023) -> bool:
        """
        Returns true if InlineResponse20023 instances are equal
        
        :param other: Instance of InlineResponse20023 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20017(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20017], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20017"""

    class TypeEnum(System.Enum):
        """A filter that can be used when fetching Transactions"""

        ORDER = 0
        """Enum ORDER for "ORDER\""""

        FUNDING = 1
        """Enum FUNDING for "FUNDING\""""

        ADMIN = 2
        """Enum ADMIN for "ADMIN\""""

        CREATE = 3
        """Enum CREATE for "CREATE\""""

        CLOSE = 4
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 5
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 6
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 7
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 8
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 9
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 10
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 11
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 12
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 13
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 14
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 15
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 16
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 17
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 18
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 19
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 20
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 21
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 22
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 23
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ONECANCELSALLORDER = 24
        """Enum ONECANCELSALLORDER for "ONE_CANCELS_ALL_ORDER\""""

        ONECANCELSALLORDERREJECT = 25
        """Enum ONECANCELSALLORDERREJECT for "ONE_CANCELS_ALL_ORDER_REJECT\""""

        ONECANCELSALLORDERTRIGGERED = 26
        """Enum ONECANCELSALLORDERTRIGGERED for "ONE_CANCELS_ALL_ORDER_TRIGGERED\""""

        ORDERFILL = 27
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 28
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 29
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 30
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 31
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 32
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 33
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 34
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 35
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 36
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 37
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 38
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 39
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.InlineResponse20017.TypeEnum]:
        """The Transaction-type filter provided in the request"""
        ...

    @Type.setter
    def Type(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.InlineResponse20017.TypeEnum]):
        """The Transaction-type filter provided in the request"""
        ...

    @property
    def From(self) -> str:
        """The starting time provided in the request."""
        ...

    @From.setter
    def From(self, value: str):
        """The starting time provided in the request."""
        ...

    @property
    def To(self) -> str:
        """The ending time provided in the request."""
        ...

    @To.setter
    def To(self, value: str):
        """The ending time provided in the request."""
        ...

    @property
    def PageSize(self) -> typing.Optional[int]:
        """The pageSize provided in the request"""
        ...

    @PageSize.setter
    def PageSize(self, value: typing.Optional[int]):
        """The pageSize provided in the request"""
        ...

    @property
    def Count(self) -> typing.Optional[int]:
        """The number of Transactions that are contained in the pages returned"""
        ...

    @Count.setter
    def Count(self, value: typing.Optional[int]):
        """The number of Transactions that are contained in the pages returned"""
        ...

    @property
    def Pages(self) -> System.Collections.Generic.List[str]:
        """The list of URLs that represent idrange queries providing the data for each page in the query results"""
        ...

    @Pages.setter
    def Pages(self, value: System.Collections.Generic.List[str]):
        """The list of URLs that represent idrange queries providing the data for each page in the query results"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, From: str = ..., To: str = ..., PageSize: typing.Optional[int] = ..., Type: System.Collections.Generic.List[Oanda.RestV20.Model.InlineResponse20017.TypeEnum] = ..., Count: typing.Optional[int] = ..., Pages: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20017 class.
        
        :param From: The starting time provided in the request..
        :param To: The ending time provided in the request..
        :param PageSize: The pageSize provided in the request.
        :param Type: The Transaction-type filter provided in the request.
        :param Count: The number of Transactions that are contained in the pages returned.
        :param Pages: The list of URLs that represent idrange queries providing the data for each page in the query results.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20017) -> bool:
        """
        Returns true if InlineResponse20017 instances are equal
        
        :param other: Instance of InlineResponse20017 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeClientExtensionsModifyRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeClientExtensionsModifyRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TradeClientExtensionsModifyRejectTransaction represents the rejection of the modification of a Trade's Client Extensions."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a TradeClientExtensionsModifyRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a TradeClientExtensionsModifyRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a TradeClientExtensionsModifyRejectTransaction."""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade who's client extensions are to be modified."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade who's client extensions are to be modified."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The original Client ID of the Trade who's client extensions are to be modified."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The original Client ID of the Trade who's client extensions are to be modified."""
        ...

    @property
    def TradeClientExtensionsModify(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    @TradeClientExtensionsModify.setter
    def TradeClientExtensionsModify(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensionsModify"""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., TradeClientExtensionsModify: Oanda.RestV20.Model.ClientExtensions = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the TradeClientExtensionsModifyRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\\" for a TradeClientExtensionsModifyRejectTransaction..
        :param TradeID: The ID of the Trade who's client extensions are to be modified..
        :param ClientTradeID: The original Client ID of the Trade who's client extensions are to be modified..
        :param TradeClientExtensionsModify: TradeClientExtensionsModify.
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction) -> bool:
        """
        Returns true if TradeClientExtensionsModifyRejectTransaction instances are equal
        
        :param other: Instance of TradeClientExtensionsModifyRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4046(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4046], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4046"""

    @property
    def TradeClientExtensionsModifyRejectTransaction(self) -> Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction:
        """Gets or Sets TradeClientExtensionsModifyRejectTransaction"""
        ...

    @TradeClientExtensionsModifyRejectTransaction.setter
    def TradeClientExtensionsModifyRejectTransaction(self, value: Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction):
        """Gets or Sets TradeClientExtensionsModifyRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account. Only present if the Account exists."""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, TradeClientExtensionsModifyRejectTransaction: Oanda.RestV20.Model.TradeClientExtensionsModifyRejectTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4046 class.
        
        :param TradeClientExtensionsModifyRejectTransaction: TradeClientExtensionsModifyRejectTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account. Only present if the Account exists..
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request. Only present if the Account exists..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4046) -> bool:
        """
        Returns true if InlineResponse4046 instances are equal
        
        :param other: Instance of InlineResponse4046 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class LimitOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_LimitOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A LimitOrderRequest specifies the parameters that may be set when creating a Limit Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"LIMIT\\" when creating a Market Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Limit Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"LIMIT\\" when creating a Market Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"LIMIT\\" when creating a Market Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the Limit Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the Limit Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Instrument(self) -> str:
        """The Limit Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Limit Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.LimitOrderRequest.TriggerConditionEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the LimitOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"LIMIT\\" when creating a Market Order..
        :param Instrument: The Limit Order's Instrument..
        :param Units: The quantity requested to be filled by the Limit Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Limit Order. The Limit Order will only be filled by a market price that is equal to or better than this price..
        :param TimeInForce: The time-in-force requested for the Limit Order..
        :param GtdTime: The date/time when the Limit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LimitOrderRequest) -> bool:
        """
        Returns true if LimitOrderRequest instances are equal
        
        :param other: Instance of LimitOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class LiquidityRegenerationScheduleStep(System.Object, System.IEquatable[Oanda_RestV20_Model_LiquidityRegenerationScheduleStep], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A liquidity regeneration schedule Step indicates the amount of bid and ask liquidity that is used by the Account at a certain time. These amounts will only change at the timestamp of the following step."""

    @property
    def Timestamp(self) -> str:
        """The timestamp of the schedule step."""
        ...

    @Timestamp.setter
    def Timestamp(self, value: str):
        """The timestamp of the schedule step."""
        ...

    @property
    def BidLiquidityUsed(self) -> str:
        """The amount of bid liquidity used at this step in the schedule."""
        ...

    @BidLiquidityUsed.setter
    def BidLiquidityUsed(self, value: str):
        """The amount of bid liquidity used at this step in the schedule."""
        ...

    @property
    def AskLiquidityUsed(self) -> str:
        """The amount of ask liquidity used at this step in the schedule."""
        ...

    @AskLiquidityUsed.setter
    def AskLiquidityUsed(self, value: str):
        """The amount of ask liquidity used at this step in the schedule."""
        ...

    def __init__(self, Timestamp: str = ..., BidLiquidityUsed: str = ..., AskLiquidityUsed: str = ...) -> None:
        """
        Initializes a new instance of the LiquidityRegenerationScheduleStep class.
        
        :param Timestamp: The timestamp of the schedule step..
        :param BidLiquidityUsed: The amount of bid liquidity used at this step in the schedule..
        :param AskLiquidityUsed: The amount of ask liquidity used at this step in the schedule..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LiquidityRegenerationScheduleStep) -> bool:
        """
        Returns true if LiquidityRegenerationScheduleStep instances are equal
        
        :param other: Instance of LiquidityRegenerationScheduleStep to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class LiquidityRegenerationSchedule(System.Object, System.IEquatable[Oanda_RestV20_Model_LiquidityRegenerationSchedule], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A LiquidityRegenerationSchedule indicates how liquidity that is used when filling an Order for an instrument is regenerated following the fill.  A liquidity regeneration schedule will be in effect until the timestamp of its final step, but may be replaced by a schedule created for an Order of the same instrument that is filled while it is still in effect."""

    @property
    def Steps(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.LiquidityRegenerationScheduleStep]:
        """The steps in the Liquidity Regeneration Schedule"""
        ...

    @Steps.setter
    def Steps(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.LiquidityRegenerationScheduleStep]):
        """The steps in the Liquidity Regeneration Schedule"""
        ...

    def __init__(self, Steps: System.Collections.Generic.List[Oanda.RestV20.Model.LiquidityRegenerationScheduleStep] = ...) -> None:
        """
        Initializes a new instance of the LiquidityRegenerationSchedule class.
        
        :param Steps: The steps in the Liquidity Regeneration Schedule.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.LiquidityRegenerationSchedule) -> bool:
        """
        Returns true if LiquidityRegenerationSchedule instances are equal
        
        :param other: Instance of LiquidityRegenerationSchedule to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class OrderIdentifier(System.Object, System.IEquatable[Oanda_RestV20_Model_OrderIdentifier], System.ComponentModel.DataAnnotations.IValidatableObject):
    """An OrderIdentifier is used to refer to an Order, and contains both the OrderID and the ClientOrderID."""

    @property
    def OrderID(self) -> str:
        """The OANDA-assigned Order ID"""
        ...

    @OrderID.setter
    def OrderID(self, value: str):
        """The OANDA-assigned Order ID"""
        ...

    @property
    def ClientOrderID(self) -> str:
        """The client-provided client Order ID"""
        ...

    @ClientOrderID.setter
    def ClientOrderID(self, value: str):
        """The client-provided client Order ID"""
        ...

    def __init__(self, OrderID: str = ..., ClientOrderID: str = ...) -> None:
        """
        Initializes a new instance of the OrderIdentifier class.
        
        :param OrderID: The OANDA-assigned Order ID.
        :param ClientOrderID: The client-provided client Order ID.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.OrderIdentifier) -> bool:
        """
        Returns true if OrderIdentifier instances are equal
        
        :param other: Instance of OrderIdentifier to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class UserSpecifier(System.Object, System.IEquatable[Oanda_RestV20_Model_UserSpecifier], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The specifier that refers to a User"""

    def __init__(self) -> None:
        """Initializes a new instance of the UserSpecifier class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.UserSpecifier) -> bool:
        """
        Returns true if UserSpecifier instances are equal
        
        :param other: Instance of UserSpecifier to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketIfTouchedOrderTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketIfTouchedOrderTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketIfTouchedOrderTransaction represents the creation of a MarketIfTouched Order in the user's Account."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER\\" in a MarketIfTouchedOrderTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Market-if-touched Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER\\" in a MarketIfTouchedOrderTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER\\" in a MarketIfTouchedOrderTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TimeInForceEnum]:
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TimeInForceEnum]):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.ReasonEnum]:
        """The reason that the Market-if-touched Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.ReasonEnum]):
        """The reason that the Market-if-touched Order was initiated"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The MarketIfTouched Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The MarketIfTouched Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def ReplacesOrderID(self) -> str:
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @ReplacesOrderID.setter
    def ReplacesOrderID(self, value: str):
        """The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)."""
        ...

    @property
    def CancellingTransactionID(self) -> str:
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    @CancellingTransactionID.setter
    def CancellingTransactionID(self, value: str):
        """The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., PriceBound: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., ReplacesOrderID: str = ..., CancellingTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the MarketIfTouchedOrderTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER\\" in a MarketIfTouchedOrderTransaction..
        :param Instrument: The MarketIfTouched Order's Instrument..
        :param Units: The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order..
        :param PriceBound: The worst market price that may be used to fill this MarketIfTouched Order..
        :param TimeInForce: The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders..
        :param GtdTime: The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Market-if-touched Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param ReplacesOrderID: The ID of the Order that this Order replaces (only provided if this Order replaces an existing Order)..
        :param CancellingTransactionID: The ID of the Transaction that cancels the replaced Order (only provided if this Order replaces an existing Order)..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketIfTouchedOrderTransaction) -> bool:
        """
        Returns true if MarketIfTouchedOrderTransaction instances are equal
        
        :param other: Instance of MarketIfTouchedOrderTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketIfTouchedOrderReason(System.Enum):
    """The reason that the Market-if-touched Order was initiated"""

    CLIENTORDER = 0
    """Enum CLIENTORDER for "CLIENT_ORDER\""""

    REPLACEMENT = 1
    """Enum REPLACEMENT for "REPLACEMENT\""""


class LimitOrderReason(System.Enum):
    """The reason that the Limit Order was initiated"""

    CLIENTORDER = 0
    """Enum CLIENTORDER for "CLIENT_ORDER\""""

    REPLACEMENT = 1
    """Enum REPLACEMENT for "REPLACEMENT\""""


class TradeID(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeID], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The Trade's identifier, unique within the Trade's Account."""

    def __init__(self) -> None:
        """Initializes a new instance of the TradeID class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeID) -> bool:
        """
        Returns true if TradeID instances are equal
        
        :param other: Instance of TradeID to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ClosePositionBody(System.Object, System.IEquatable[Oanda_RestV20_Model_ClosePositionBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """ClosePositionBody"""

    @property
    def LongUnits(self) -> str:
        """Indication of how much of the long Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive."""
        ...

    @LongUnits.setter
    def LongUnits(self, value: str):
        """Indication of how much of the long Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive."""
        ...

    @property
    def LongClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets LongClientExtensions"""
        ...

    @LongClientExtensions.setter
    def LongClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets LongClientExtensions"""
        ...

    @property
    def ShortUnits(self) -> str:
        """Indication of how much of the short Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive."""
        ...

    @ShortUnits.setter
    def ShortUnits(self, value: str):
        """Indication of how much of the short Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive."""
        ...

    @property
    def ShortClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ShortClientExtensions"""
        ...

    @ShortClientExtensions.setter
    def ShortClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ShortClientExtensions"""
        ...

    def __init__(self, LongUnits: str = ..., LongClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., ShortUnits: str = ..., ShortClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the ClosePositionBody class.
        
        :param LongUnits: Indication of how much of the long Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the long position to close using a PositionCloseout MarketOrder. The units specified must always be positive..
        :param LongClientExtensions: LongClientExtensions.
        :param ShortUnits: Indication of how much of the short Position to closeout. Either the string \\"ALL\\", the string \\"NONE\\", or a DecimalNumber representing how many units of the short position to close using a PositionCloseout MarketOrder. The units specified must always be positive..
        :param ShortClientExtensions: ShortClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ClosePositionBody) -> bool:
        """
        Returns true if ClosePositionBody instances are equal
        
        :param other: Instance of ClosePositionBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class CreateOrderBody(System.Object, System.IEquatable[Oanda_RestV20_Model_CreateOrderBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """CreateOrderBody"""

    @property
    def Order(self) -> Oanda.RestV20.Model.OrderRequest:
        """Gets or Sets Order"""
        ...

    @Order.setter
    def Order(self, value: Oanda.RestV20.Model.OrderRequest):
        """Gets or Sets Order"""
        ...

    def __init__(self, Order: Oanda.RestV20.Model.OrderRequest = ...) -> None:
        """
        Initializes a new instance of the CreateOrderBody class.
        
        :param Order: Order.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.CreateOrderBody) -> bool:
        """
        Returns true if CreateOrderBody instances are equal
        
        :param other: Instance of CreateOrderBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarketIfTouchedOrderRejectTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_MarketIfTouchedOrderRejectTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarketIfTouchedOrderRejectTransaction represents the rejection of the creation of a MarketIfTouched Order."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER_REJECT\\" in a MarketIfTouchedOrderRejectTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    class ReasonEnum(System.Enum):
        """The reason that the Market-if-touched Order was initiated"""

        CLIENTORDER = 0
        """Enum CLIENTORDER for "CLIENT_ORDER\""""

        REPLACEMENT = 1
        """Enum REPLACEMENT for "REPLACEMENT\""""

    class RejectReasonEnum(System.Enum):
        """The reason that the Reject Transaction was created"""

        INTERNALSERVERERROR = 0
        """Enum INTERNALSERVERERROR for "INTERNAL_SERVER_ERROR\""""

        INSTRUMENTPRICEUNKNOWN = 1
        """Enum INSTRUMENTPRICEUNKNOWN for "INSTRUMENT_PRICE_UNKNOWN\""""

        ACCOUNTNOTACTIVE = 2
        """Enum ACCOUNTNOTACTIVE for "ACCOUNT_NOT_ACTIVE\""""

        ACCOUNTLOCKED = 3
        """Enum ACCOUNTLOCKED for "ACCOUNT_LOCKED\""""

        ACCOUNTORDERCREATIONLOCKED = 4
        """Enum ACCOUNTORDERCREATIONLOCKED for "ACCOUNT_ORDER_CREATION_LOCKED\""""

        ACCOUNTCONFIGURATIONLOCKED = 5
        """Enum ACCOUNTCONFIGURATIONLOCKED for "ACCOUNT_CONFIGURATION_LOCKED\""""

        ACCOUNTDEPOSITLOCKED = 6
        """Enum ACCOUNTDEPOSITLOCKED for "ACCOUNT_DEPOSIT_LOCKED\""""

        ACCOUNTWITHDRAWALLOCKED = 7
        """Enum ACCOUNTWITHDRAWALLOCKED for "ACCOUNT_WITHDRAWAL_LOCKED\""""

        ACCOUNTORDERCANCELLOCKED = 8
        """Enum ACCOUNTORDERCANCELLOCKED for "ACCOUNT_ORDER_CANCEL_LOCKED\""""

        INSTRUMENTNOTTRADEABLE = 9
        """Enum INSTRUMENTNOTTRADEABLE for "INSTRUMENT_NOT_TRADEABLE\""""

        PENDINGORDERSALLOWEDEXCEEDED = 10
        """Enum PENDINGORDERSALLOWEDEXCEEDED for "PENDING_ORDERS_ALLOWED_EXCEEDED\""""

        ORDERIDUNSPECIFIED = 11
        """Enum ORDERIDUNSPECIFIED for "ORDER_ID_UNSPECIFIED\""""

        ORDERDOESNTEXIST = 12
        """Enum ORDERDOESNTEXIST for "ORDER_DOESNT_EXIST\""""

        ORDERIDENTIFIERINCONSISTENCY = 13
        """Enum ORDERIDENTIFIERINCONSISTENCY for "ORDER_IDENTIFIER_INCONSISTENCY\""""

        TRADEIDUNSPECIFIED = 14
        """Enum TRADEIDUNSPECIFIED for "TRADE_ID_UNSPECIFIED\""""

        TRADEDOESNTEXIST = 15
        """Enum TRADEDOESNTEXIST for "TRADE_DOESNT_EXIST\""""

        TRADEIDENTIFIERINCONSISTENCY = 16
        """Enum TRADEIDENTIFIERINCONSISTENCY for "TRADE_IDENTIFIER_INCONSISTENCY\""""

        INSTRUMENTMISSING = 17
        """Enum INSTRUMENTMISSING for "INSTRUMENT_MISSING\""""

        INSTRUMENTUNKNOWN = 18
        """Enum INSTRUMENTUNKNOWN for "INSTRUMENT_UNKNOWN\""""

        UNITSMISSING = 19
        """Enum UNITSMISSING for "UNITS_MISSING\""""

        UNITSINVALID = 20
        """Enum UNITSINVALID for "UNITS_INVALID\""""

        UNITSPRECISIONEXCEEDED = 21
        """Enum UNITSPRECISIONEXCEEDED for "UNITS_PRECISION_EXCEEDED\""""

        UNITSLIMITEXCEEDED = 22
        """Enum UNITSLIMITEXCEEDED for "UNITS_LIMIT_EXCEEDED\""""

        UNITSMIMIMUMNOTMET = 23
        """Enum UNITSMIMIMUMNOTMET for "UNITS_MIMIMUM_NOT_MET\""""

        PRICEMISSING = 24
        """Enum PRICEMISSING for "PRICE_MISSING\""""

        PRICEINVALID = 25
        """Enum PRICEINVALID for "PRICE_INVALID\""""

        PRICEPRECISIONEXCEEDED = 26
        """Enum PRICEPRECISIONEXCEEDED for "PRICE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMISSING = 27
        """Enum PRICEDISTANCEMISSING for "PRICE_DISTANCE_MISSING\""""

        PRICEDISTANCEINVALID = 28
        """Enum PRICEDISTANCEINVALID for "PRICE_DISTANCE_INVALID\""""

        PRICEDISTANCEPRECISIONEXCEEDED = 29
        """Enum PRICEDISTANCEPRECISIONEXCEEDED for "PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        PRICEDISTANCEMAXIMUMEXCEEDED = 30
        """Enum PRICEDISTANCEMAXIMUMEXCEEDED for "PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        PRICEDISTANCEMINIMUMNOTMET = 31
        """Enum PRICEDISTANCEMINIMUMNOTMET for "PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TIMEINFORCEMISSING = 32
        """Enum TIMEINFORCEMISSING for "TIME_IN_FORCE_MISSING\""""

        TIMEINFORCEINVALID = 33
        """Enum TIMEINFORCEINVALID for "TIME_IN_FORCE_INVALID\""""

        TIMEINFORCEGTDTIMESTAMPMISSING = 34
        """Enum TIMEINFORCEGTDTIMESTAMPMISSING for "TIME_IN_FORCE_GTD_TIMESTAMP_MISSING\""""

        TIMEINFORCEGTDTIMESTAMPINPAST = 35
        """Enum TIMEINFORCEGTDTIMESTAMPINPAST for "TIME_IN_FORCE_GTD_TIMESTAMP_IN_PAST\""""

        PRICEBOUNDINVALID = 36
        """Enum PRICEBOUNDINVALID for "PRICE_BOUND_INVALID\""""

        PRICEBOUNDPRECISIONEXCEEDED = 37
        """Enum PRICEBOUNDPRECISIONEXCEEDED for "PRICE_BOUND_PRECISION_EXCEEDED\""""

        ORDERSONFILLDUPLICATECLIENTORDERIDS = 38
        """Enum ORDERSONFILLDUPLICATECLIENTORDERIDS for "ORDERS_ON_FILL_DUPLICATE_CLIENT_ORDER_IDS\""""

        TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED = 39
        """Enum TRADEONFILLCLIENTEXTENSIONSNOTSUPPORTED for "TRADE_ON_FILL_CLIENT_EXTENSIONS_NOT_SUPPORTED\""""

        CLIENTORDERIDINVALID = 40
        """Enum CLIENTORDERIDINVALID for "CLIENT_ORDER_ID_INVALID\""""

        CLIENTORDERIDALREADYEXISTS = 41
        """Enum CLIENTORDERIDALREADYEXISTS for "CLIENT_ORDER_ID_ALREADY_EXISTS\""""

        CLIENTORDERTAGINVALID = 42
        """Enum CLIENTORDERTAGINVALID for "CLIENT_ORDER_TAG_INVALID\""""

        CLIENTORDERCOMMENTINVALID = 43
        """Enum CLIENTORDERCOMMENTINVALID for "CLIENT_ORDER_COMMENT_INVALID\""""

        CLIENTTRADEIDINVALID = 44
        """Enum CLIENTTRADEIDINVALID for "CLIENT_TRADE_ID_INVALID\""""

        CLIENTTRADEIDALREADYEXISTS = 45
        """Enum CLIENTTRADEIDALREADYEXISTS for "CLIENT_TRADE_ID_ALREADY_EXISTS\""""

        CLIENTTRADETAGINVALID = 46
        """Enum CLIENTTRADETAGINVALID for "CLIENT_TRADE_TAG_INVALID\""""

        CLIENTTRADECOMMENTINVALID = 47
        """Enum CLIENTTRADECOMMENTINVALID for "CLIENT_TRADE_COMMENT_INVALID\""""

        ORDERFILLPOSITIONACTIONMISSING = 48
        """Enum ORDERFILLPOSITIONACTIONMISSING for "ORDER_FILL_POSITION_ACTION_MISSING\""""

        ORDERFILLPOSITIONACTIONINVALID = 49
        """Enum ORDERFILLPOSITIONACTIONINVALID for "ORDER_FILL_POSITION_ACTION_INVALID\""""

        TRIGGERCONDITIONMISSING = 50
        """Enum TRIGGERCONDITIONMISSING for "TRIGGER_CONDITION_MISSING\""""

        TRIGGERCONDITIONINVALID = 51
        """Enum TRIGGERCONDITIONINVALID for "TRIGGER_CONDITION_INVALID\""""

        ORDERPARTIALFILLOPTIONMISSING = 52
        """Enum ORDERPARTIALFILLOPTIONMISSING for "ORDER_PARTIAL_FILL_OPTION_MISSING\""""

        ORDERPARTIALFILLOPTIONINVALID = 53
        """Enum ORDERPARTIALFILLOPTIONINVALID for "ORDER_PARTIAL_FILL_OPTION_INVALID\""""

        INVALIDREISSUEIMMEDIATEPARTIALFILL = 54
        """Enum INVALIDREISSUEIMMEDIATEPARTIALFILL for "INVALID_REISSUE_IMMEDIATE_PARTIAL_FILL\""""

        TAKEPROFITORDERALREADYEXISTS = 55
        """Enum TAKEPROFITORDERALREADYEXISTS for "TAKE_PROFIT_ORDER_ALREADY_EXISTS\""""

        TAKEPROFITONFILLPRICEMISSING = 56
        """Enum TAKEPROFITONFILLPRICEMISSING for "TAKE_PROFIT_ON_FILL_PRICE_MISSING\""""

        TAKEPROFITONFILLPRICEINVALID = 57
        """Enum TAKEPROFITONFILLPRICEINVALID for "TAKE_PROFIT_ON_FILL_PRICE_INVALID\""""

        TAKEPROFITONFILLPRICEPRECISIONEXCEEDED = 58
        """Enum TAKEPROFITONFILLPRICEPRECISIONEXCEEDED for "TAKE_PROFIT_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        TAKEPROFITONFILLTIMEINFORCEMISSING = 59
        """Enum TAKEPROFITONFILLTIMEINFORCEMISSING for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TAKEPROFITONFILLTIMEINFORCEINVALID = 60
        """Enum TAKEPROFITONFILLTIMEINFORCEINVALID for "TAKE_PROFIT_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TAKEPROFITONFILLGTDTIMESTAMPMISSING = 61
        """Enum TAKEPROFITONFILLGTDTIMESTAMPMISSING for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TAKEPROFITONFILLGTDTIMESTAMPINPAST = 62
        """Enum TAKEPROFITONFILLGTDTIMESTAMPINPAST for "TAKE_PROFIT_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TAKEPROFITONFILLCLIENTORDERIDINVALID = 63
        """Enum TAKEPROFITONFILLCLIENTORDERIDINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERTAGINVALID = 64
        """Enum TAKEPROFITONFILLCLIENTORDERTAGINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID = 65
        """Enum TAKEPROFITONFILLCLIENTORDERCOMMENTINVALID for "TAKE_PROFIT_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TAKEPROFITONFILLTRIGGERCONDITIONMISSING = 66
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONMISSING for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TAKEPROFITONFILLTRIGGERCONDITIONINVALID = 67
        """Enum TAKEPROFITONFILLTRIGGERCONDITIONINVALID for "TAKE_PROFIT_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        STOPLOSSORDERALREADYEXISTS = 68
        """Enum STOPLOSSORDERALREADYEXISTS for "STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        STOPLOSSONFILLPRICEMISSING = 69
        """Enum STOPLOSSONFILLPRICEMISSING for "STOP_LOSS_ON_FILL_PRICE_MISSING\""""

        STOPLOSSONFILLPRICEINVALID = 70
        """Enum STOPLOSSONFILLPRICEINVALID for "STOP_LOSS_ON_FILL_PRICE_INVALID\""""

        STOPLOSSONFILLPRICEPRECISIONEXCEEDED = 71
        """Enum STOPLOSSONFILLPRICEPRECISIONEXCEEDED for "STOP_LOSS_ON_FILL_PRICE_PRECISION_EXCEEDED\""""

        STOPLOSSONFILLTIMEINFORCEMISSING = 72
        """Enum STOPLOSSONFILLTIMEINFORCEMISSING for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        STOPLOSSONFILLTIMEINFORCEINVALID = 73
        """Enum STOPLOSSONFILLTIMEINFORCEINVALID for "STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        STOPLOSSONFILLGTDTIMESTAMPMISSING = 74
        """Enum STOPLOSSONFILLGTDTIMESTAMPMISSING for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        STOPLOSSONFILLGTDTIMESTAMPINPAST = 75
        """Enum STOPLOSSONFILLGTDTIMESTAMPINPAST for "STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        STOPLOSSONFILLCLIENTORDERIDINVALID = 76
        """Enum STOPLOSSONFILLCLIENTORDERIDINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        STOPLOSSONFILLCLIENTORDERTAGINVALID = 77
        """Enum STOPLOSSONFILLCLIENTORDERTAGINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        STOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 78
        """Enum STOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        STOPLOSSONFILLTRIGGERCONDITIONMISSING = 79
        """Enum STOPLOSSONFILLTRIGGERCONDITIONMISSING for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        STOPLOSSONFILLTRIGGERCONDITIONINVALID = 80
        """Enum STOPLOSSONFILLTRIGGERCONDITIONINVALID for "STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        TRAILINGSTOPLOSSORDERALREADYEXISTS = 81
        """Enum TRAILINGSTOPLOSSORDERALREADYEXISTS for "TRAILING_STOP_LOSS_ORDER_ALREADY_EXISTS\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING = 82
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID = 83
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED = 84
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEPRECISIONEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_PRECISION_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED = 85
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMAXIMUMEXCEEDED for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MAXIMUM_EXCEEDED\""""

        TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET = 86
        """Enum TRAILINGSTOPLOSSONFILLPRICEDISTANCEMINIMUMNOTMET for "TRAILING_STOP_LOSS_ON_FILL_PRICE_DISTANCE_MINIMUM_NOT_MET\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING = 87
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEMISSING for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_MISSING\""""

        TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID = 88
        """Enum TRAILINGSTOPLOSSONFILLTIMEINFORCEINVALID for "TRAILING_STOP_LOSS_ON_FILL_TIME_IN_FORCE_INVALID\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING = 89
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPMISSING for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_MISSING\""""

        TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST = 90
        """Enum TRAILINGSTOPLOSSONFILLGTDTIMESTAMPINPAST for "TRAILING_STOP_LOSS_ON_FILL_GTD_TIMESTAMP_IN_PAST\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID = 91
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERIDINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_ID_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID = 92
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERTAGINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_TAG_INVALID\""""

        TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID = 93
        """Enum TRAILINGSTOPLOSSONFILLCLIENTORDERCOMMENTINVALID for "TRAILING_STOP_LOSS_ON_FILL_CLIENT_ORDER_COMMENT_INVALID\""""

        TRAILINGSTOPLOSSORDERSNOTSUPPORTED = 94
        """Enum TRAILINGSTOPLOSSORDERSNOTSUPPORTED for "TRAILING_STOP_LOSS_ORDERS_NOT_SUPPORTED\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING = 95
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONMISSING for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_MISSING\""""

        TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID = 96
        """Enum TRAILINGSTOPLOSSONFILLTRIGGERCONDITIONINVALID for "TRAILING_STOP_LOSS_ON_FILL_TRIGGER_CONDITION_INVALID\""""

        CLOSETRADETYPEMISSING = 97
        """Enum CLOSETRADETYPEMISSING for "CLOSE_TRADE_TYPE_MISSING\""""

        CLOSETRADEPARTIALUNITSMISSING = 98
        """Enum CLOSETRADEPARTIALUNITSMISSING for "CLOSE_TRADE_PARTIAL_UNITS_MISSING\""""

        CLOSETRADEUNITSEXCEEDTRADESIZE = 99
        """Enum CLOSETRADEUNITSEXCEEDTRADESIZE for "CLOSE_TRADE_UNITS_EXCEED_TRADE_SIZE\""""

        CLOSEOUTPOSITIONDOESNTEXIST = 100
        """Enum CLOSEOUTPOSITIONDOESNTEXIST for "CLOSEOUT_POSITION_DOESNT_EXIST\""""

        CLOSEOUTPOSITIONINCOMPLETESPECIFICATION = 101
        """Enum CLOSEOUTPOSITIONINCOMPLETESPECIFICATION for "CLOSEOUT_POSITION_INCOMPLETE_SPECIFICATION\""""

        CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE = 102
        """Enum CLOSEOUTPOSITIONUNITSEXCEEDPOSITIONSIZE for "CLOSEOUT_POSITION_UNITS_EXCEED_POSITION_SIZE\""""

        CLOSEOUTPOSITIONREJECT = 103
        """Enum CLOSEOUTPOSITIONREJECT for "CLOSEOUT_POSITION_REJECT\""""

        CLOSEOUTPOSITIONPARTIALUNITSMISSING = 104
        """Enum CLOSEOUTPOSITIONPARTIALUNITSMISSING for "CLOSEOUT_POSITION_PARTIAL_UNITS_MISSING\""""

        MARKUPGROUPIDINVALID = 105
        """Enum MARKUPGROUPIDINVALID for "MARKUP_GROUP_ID_INVALID\""""

        POSITIONAGGREGATIONMODEINVALID = 106
        """Enum POSITIONAGGREGATIONMODEINVALID for "POSITION_AGGREGATION_MODE_INVALID\""""

        ADMINCONFIGUREDATAMISSING = 107
        """Enum ADMINCONFIGUREDATAMISSING for "ADMIN_CONFIGURE_DATA_MISSING\""""

        MARGINRATEINVALID = 108
        """Enum MARGINRATEINVALID for "MARGIN_RATE_INVALID\""""

        MARGINRATEWOULDTRIGGERCLOSEOUT = 109
        """Enum MARGINRATEWOULDTRIGGERCLOSEOUT for "MARGIN_RATE_WOULD_TRIGGER_CLOSEOUT\""""

        ALIASINVALID = 110
        """Enum ALIASINVALID for "ALIAS_INVALID\""""

        CLIENTCONFIGUREDATAMISSING = 111
        """Enum CLIENTCONFIGUREDATAMISSING for "CLIENT_CONFIGURE_DATA_MISSING\""""

        MARGINRATEWOULDTRIGGERMARGINCALL = 112
        """Enum MARGINRATEWOULDTRIGGERMARGINCALL for "MARGIN_RATE_WOULD_TRIGGER_MARGIN_CALL\""""

        AMOUNTINVALID = 113
        """Enum AMOUNTINVALID for "AMOUNT_INVALID\""""

        INSUFFICIENTFUNDS = 114
        """Enum INSUFFICIENTFUNDS for "INSUFFICIENT_FUNDS\""""

        AMOUNTMISSING = 115
        """Enum AMOUNTMISSING for "AMOUNT_MISSING\""""

        FUNDINGREASONMISSING = 116
        """Enum FUNDINGREASONMISSING for "FUNDING_REASON_MISSING\""""

        CLIENTEXTENSIONSDATAMISSING = 117
        """Enum CLIENTEXTENSIONSDATAMISSING for "CLIENT_EXTENSIONS_DATA_MISSING\""""

        REPLACINGORDERINVALID = 118
        """Enum REPLACINGORDERINVALID for "REPLACING_ORDER_INVALID\""""

        REPLACINGTRADEIDINVALID = 119
        """Enum REPLACINGTRADEIDINVALID for "REPLACING_TRADE_ID_INVALID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER_REJECT\\" in a MarketIfTouchedOrderRejectTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER_REJECT\\" in a MarketIfTouchedOrderRejectTransaction."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TimeInForceEnum]:
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TimeInForceEnum]):
        """The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Reason(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.ReasonEnum]:
        """The reason that the Market-if-touched Order was initiated"""
        ...

    @Reason.setter
    def Reason(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.ReasonEnum]):
        """The reason that the Market-if-touched Order was initiated"""
        ...

    @property
    def RejectReason(self) -> typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.RejectReasonEnum]:
        """The reason that the Reject Transaction was created"""
        ...

    @RejectReason.setter
    def RejectReason(self, value: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.RejectReasonEnum]):
        """The reason that the Reject Transaction was created"""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    @property
    def Instrument(self) -> str:
        """The MarketIfTouched Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The MarketIfTouched Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst market price that may be used to fill this MarketIfTouched Order."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    @property
    def IntendedReplacesOrderID(self) -> str:
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    @IntendedReplacesOrderID.setter
    def IntendedReplacesOrderID(self, value: str):
        """The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., PriceBound: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.TriggerConditionEnum] = ..., Reason: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.ReasonEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., IntendedReplacesOrderID: str = ..., RejectReason: typing.Optional[Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction.RejectReasonEnum] = ...) -> None:
        """
        Initializes a new instance of the MarketIfTouchedOrderRejectTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"MARKET_IF_TOUCHED_ORDER_REJECT\\" in a MarketIfTouchedOrderRejectTransaction..
        :param Instrument: The MarketIfTouched Order's Instrument..
        :param Units: The quantity requested to be filled by the MarketIfTouched Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the MarketIfTouched Order. The MarketIfTouched Order will only be filled by a market price that crosses this price from the direction of the market price at the time when the Order was created (the initialMarketPrice). Depending on the value of the Order's price and initialMarketPrice, the MarketIfTouchedOrder will behave like a Limit or a Stop Order..
        :param PriceBound: The worst market price that may be used to fill this MarketIfTouched Order..
        :param TimeInForce: The time-in-force requested for the MarketIfTouched Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for MarketIfTouched Orders..
        :param GtdTime: The date/time when the MarketIfTouched Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param Reason: The reason that the Market-if-touched Order was initiated.
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        :param IntendedReplacesOrderID: The ID of the Order that this Order was intended to replace (only provided if this Order was intended to replace an existing Order)..
        :param RejectReason: The reason that the Reject Transaction was created.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarketIfTouchedOrderRejectTransaction) -> bool:
        """
        Returns true if MarketIfTouchedOrderRejectTransaction instances are equal
        
        :param other: Instance of MarketIfTouchedOrderRejectTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class MarginCallExitTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_MarginCallExitTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A MarginCallExitnterTransaction is created when an Account leaves the margin call state."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"MARGIN_CALL_EXIT\\" for an MarginCallExitTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.MarginCallExitTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"MARGIN_CALL_EXIT\\" for an MarginCallExitTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.MarginCallExitTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"MARGIN_CALL_EXIT\\" for an MarginCallExitTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.MarginCallExitTransaction.TypeEnum] = ...) -> None:
        """
        Initializes a new instance of the MarginCallExitTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"MARGIN_CALL_EXIT\\" for an MarginCallExitTransaction..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.MarginCallExitTransaction) -> bool:
        """
        Returns true if MarginCallExitTransaction instances are equal
        
        :param other: Instance of MarginCallExitTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_StopOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopOrderRequest specifies the parameters that may be set when creating a Stop Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"STOP\\" when creating a Stop Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the Stop Order."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class PositionFillEnum(System.Enum):
        """Specification of how Positions in the Account are modified when the Order is filled."""

        OPENONLY = 0
        """Enum OPENONLY for "OPEN_ONLY\""""

        REDUCEFIRST = 1
        """Enum REDUCEFIRST for "REDUCE_FIRST\""""

        REDUCEONLY = 2
        """Enum REDUCEONLY for "REDUCE_ONLY\""""

        DEFAULT = 3
        """Enum DEFAULT for "DEFAULT\""""

        POSITIONDEFAULT = 4
        """Enum POSITIONDEFAULT for "POSITION_DEFAULT\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"STOP\\" when creating a Stop Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"STOP\\" when creating a Stop Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the Stop Order."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the Stop Order."""
        ...

    @property
    def PositionFill(self) -> typing.Optional[Oanda.RestV20.Model.StopOrderRequest.PositionFillEnum]:
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @PositionFill.setter
    def PositionFill(self, value: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.PositionFillEnum]):
        """Specification of how Positions in the Account are modified when the Order is filled."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def Instrument(self) -> str:
        """The Stop Order's Instrument."""
        ...

    @Instrument.setter
    def Instrument(self, value: str):
        """The Stop Order's Instrument."""
        ...

    @property
    def Units(self) -> str:
        """The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @Units.setter
    def Units(self, value: str):
        """The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price."""
        ...

    @property
    def PriceBound(self) -> str:
        """The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled."""
        ...

    @PriceBound.setter
    def PriceBound(self, value: str):
        """The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    @property
    def TakeProfitOnFill(self) -> Oanda.RestV20.Model.TakeProfitDetails:
        """Gets or Sets TakeProfitOnFill"""
        ...

    @TakeProfitOnFill.setter
    def TakeProfitOnFill(self, value: Oanda.RestV20.Model.TakeProfitDetails):
        """Gets or Sets TakeProfitOnFill"""
        ...

    @property
    def StopLossOnFill(self) -> Oanda.RestV20.Model.StopLossDetails:
        """Gets or Sets StopLossOnFill"""
        ...

    @StopLossOnFill.setter
    def StopLossOnFill(self, value: Oanda.RestV20.Model.StopLossDetails):
        """Gets or Sets StopLossOnFill"""
        ...

    @property
    def TrailingStopLossOnFill(self) -> Oanda.RestV20.Model.TrailingStopLossDetails:
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @TrailingStopLossOnFill.setter
    def TrailingStopLossOnFill(self, value: Oanda.RestV20.Model.TrailingStopLossDetails):
        """Gets or Sets TrailingStopLossOnFill"""
        ...

    @property
    def TradeClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets TradeClientExtensions"""
        ...

    @TradeClientExtensions.setter
    def TradeClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets TradeClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TypeEnum] = ..., Instrument: str = ..., Units: str = ..., Price: str = ..., PriceBound: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TimeInForceEnum] = ..., GtdTime: str = ..., PositionFill: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.PositionFillEnum] = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopOrderRequest.TriggerConditionEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ..., TakeProfitOnFill: Oanda.RestV20.Model.TakeProfitDetails = ..., StopLossOnFill: Oanda.RestV20.Model.StopLossDetails = ..., TrailingStopLossOnFill: Oanda.RestV20.Model.TrailingStopLossDetails = ..., TradeClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the StopOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"STOP\\" when creating a Stop Order..
        :param Instrument: The Stop Order's Instrument..
        :param Units: The quantity requested to be filled by the Stop Order. A posititive number of units results in a long Order, and a negative number of units results in a short Order..
        :param Price: The price threshold specified for the Stop Order. The Stop Order will only be filled by a market price that is equal to or worse than this price..
        :param PriceBound: The worst market price that may be used to fill this Stop Order. If the market gaps and crosses through both the price and the priceBound, the Stop Order will be cancelled instead of being filled..
        :param TimeInForce: The time-in-force requested for the Stop Order..
        :param GtdTime: The date/time when the Stop Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param PositionFill: Specification of how Positions in the Account are modified when the Order is filled..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param ClientExtensions: ClientExtensions.
        :param TakeProfitOnFill: TakeProfitOnFill.
        :param StopLossOnFill: StopLossOnFill.
        :param TrailingStopLossOnFill: TrailingStopLossOnFill.
        :param TradeClientExtensions: TradeClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopOrderRequest) -> bool:
        """
        Returns true if StopOrderRequest instances are equal
        
        :param other: Instance of StopOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ResetResettablePLTransaction(System.Object, System.IEquatable[Oanda_RestV20_Model_ResetResettablePLTransaction], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A ResetResettablePLTransaction represents the resetting of the Account's resettable PL counters."""

    class TypeEnum(System.Enum):
        """The Type of the Transaction. Always set to \\"RESET_RESETTABLE_PL\\" for a ResetResettablePLTransaction."""

        CREATE = 0
        """Enum CREATE for "CREATE\""""

        CLOSE = 1
        """Enum CLOSE for "CLOSE\""""

        REOPEN = 2
        """Enum REOPEN for "REOPEN\""""

        CLIENTCONFIGURE = 3
        """Enum CLIENTCONFIGURE for "CLIENT_CONFIGURE\""""

        CLIENTCONFIGUREREJECT = 4
        """Enum CLIENTCONFIGUREREJECT for "CLIENT_CONFIGURE_REJECT\""""

        TRANSFERFUNDS = 5
        """Enum TRANSFERFUNDS for "TRANSFER_FUNDS\""""

        TRANSFERFUNDSREJECT = 6
        """Enum TRANSFERFUNDSREJECT for "TRANSFER_FUNDS_REJECT\""""

        MARKETORDER = 7
        """Enum MARKETORDER for "MARKET_ORDER\""""

        MARKETORDERREJECT = 8
        """Enum MARKETORDERREJECT for "MARKET_ORDER_REJECT\""""

        LIMITORDER = 9
        """Enum LIMITORDER for "LIMIT_ORDER\""""

        LIMITORDERREJECT = 10
        """Enum LIMITORDERREJECT for "LIMIT_ORDER_REJECT\""""

        STOPORDER = 11
        """Enum STOPORDER for "STOP_ORDER\""""

        STOPORDERREJECT = 12
        """Enum STOPORDERREJECT for "STOP_ORDER_REJECT\""""

        MARKETIFTOUCHEDORDER = 13
        """Enum MARKETIFTOUCHEDORDER for "MARKET_IF_TOUCHED_ORDER\""""

        MARKETIFTOUCHEDORDERREJECT = 14
        """Enum MARKETIFTOUCHEDORDERREJECT for "MARKET_IF_TOUCHED_ORDER_REJECT\""""

        TAKEPROFITORDER = 15
        """Enum TAKEPROFITORDER for "TAKE_PROFIT_ORDER\""""

        TAKEPROFITORDERREJECT = 16
        """Enum TAKEPROFITORDERREJECT for "TAKE_PROFIT_ORDER_REJECT\""""

        STOPLOSSORDER = 17
        """Enum STOPLOSSORDER for "STOP_LOSS_ORDER\""""

        STOPLOSSORDERREJECT = 18
        """Enum STOPLOSSORDERREJECT for "STOP_LOSS_ORDER_REJECT\""""

        TRAILINGSTOPLOSSORDER = 19
        """Enum TRAILINGSTOPLOSSORDER for "TRAILING_STOP_LOSS_ORDER\""""

        TRAILINGSTOPLOSSORDERREJECT = 20
        """Enum TRAILINGSTOPLOSSORDERREJECT for "TRAILING_STOP_LOSS_ORDER_REJECT\""""

        ORDERFILL = 21
        """Enum ORDERFILL for "ORDER_FILL\""""

        ORDERCANCEL = 22
        """Enum ORDERCANCEL for "ORDER_CANCEL\""""

        ORDERCANCELREJECT = 23
        """Enum ORDERCANCELREJECT for "ORDER_CANCEL_REJECT\""""

        ORDERCLIENTEXTENSIONSMODIFY = 24
        """Enum ORDERCLIENTEXTENSIONSMODIFY for "ORDER_CLIENT_EXTENSIONS_MODIFY\""""

        ORDERCLIENTEXTENSIONSMODIFYREJECT = 25
        """Enum ORDERCLIENTEXTENSIONSMODIFYREJECT for "ORDER_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        TRADECLIENTEXTENSIONSMODIFY = 26
        """Enum TRADECLIENTEXTENSIONSMODIFY for "TRADE_CLIENT_EXTENSIONS_MODIFY\""""

        TRADECLIENTEXTENSIONSMODIFYREJECT = 27
        """Enum TRADECLIENTEXTENSIONSMODIFYREJECT for "TRADE_CLIENT_EXTENSIONS_MODIFY_REJECT\""""

        MARGINCALLENTER = 28
        """Enum MARGINCALLENTER for "MARGIN_CALL_ENTER\""""

        MARGINCALLEXTEND = 29
        """Enum MARGINCALLEXTEND for "MARGIN_CALL_EXTEND\""""

        MARGINCALLEXIT = 30
        """Enum MARGINCALLEXIT for "MARGIN_CALL_EXIT\""""

        DELAYEDTRADECLOSURE = 31
        """Enum DELAYEDTRADECLOSURE for "DELAYED_TRADE_CLOSURE\""""

        DAILYFINANCING = 32
        """Enum DAILYFINANCING for "DAILY_FINANCING\""""

        RESETRESETTABLEPL = 33
        """Enum RESETRESETTABLEPL for "RESET_RESETTABLE_PL\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.ResetResettablePLTransaction.TypeEnum]:
        """The Type of the Transaction. Always set to \\"RESET_RESETTABLE_PL\\" for a ResetResettablePLTransaction."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.ResetResettablePLTransaction.TypeEnum]):
        """The Type of the Transaction. Always set to \\"RESET_RESETTABLE_PL\\" for a ResetResettablePLTransaction."""
        ...

    @property
    def Id(self) -> str:
        """The Transaction's Identifier."""
        ...

    @Id.setter
    def Id(self, value: str):
        """The Transaction's Identifier."""
        ...

    @property
    def Time(self) -> str:
        """The date/time when the Transaction was created."""
        ...

    @Time.setter
    def Time(self, value: str):
        """The date/time when the Transaction was created."""
        ...

    @property
    def UserID(self) -> typing.Optional[int]:
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @UserID.setter
    def UserID(self, value: typing.Optional[int]):
        """The ID of the user that initiated the creation of the Transaction."""
        ...

    @property
    def AccountID(self) -> str:
        """The ID of the Account the Transaction was created for."""
        ...

    @AccountID.setter
    def AccountID(self, value: str):
        """The ID of the Account the Transaction was created for."""
        ...

    @property
    def BatchID(self) -> str:
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @BatchID.setter
    def BatchID(self, value: str):
        """The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously."""
        ...

    @property
    def RequestID(self) -> str:
        """The Request ID of the request which generated the transaction."""
        ...

    @RequestID.setter
    def RequestID(self, value: str):
        """The Request ID of the request which generated the transaction."""
        ...

    def __init__(self, Id: str = ..., Time: str = ..., UserID: typing.Optional[int] = ..., AccountID: str = ..., BatchID: str = ..., RequestID: str = ..., Type: typing.Optional[Oanda.RestV20.Model.ResetResettablePLTransaction.TypeEnum] = ...) -> None:
        """
        Initializes a new instance of the ResetResettablePLTransaction class.
        
        :param Id: The Transaction's Identifier..
        :param Time: The date/time when the Transaction was created..
        :param UserID: The ID of the user that initiated the creation of the Transaction..
        :param AccountID: The ID of the Account the Transaction was created for..
        :param BatchID: The ID of the \\"batch\\" that the Transaction belongs to. Transactions in the same batch are applied to the Account simultaneously..
        :param RequestID: The Request ID of the request which generated the transaction..
        :param Type: The Type of the Transaction. Always set to \\"RESET_RESETTABLE_PL\\" for a ResetResettablePLTransaction..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ResetResettablePLTransaction) -> bool:
        """
        Returns true if ResetResettablePLTransaction instances are equal
        
        :param other: Instance of ResetResettablePLTransaction to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class ClientTag(System.Object, System.IEquatable[Oanda_RestV20_Model_ClientTag], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A client-provided tag that can contain any data and may be assigned to their Orders or Trades. Tags are typically used to associate groups of Trades and/or Orders together."""

    def __init__(self) -> None:
        """Initializes a new instance of the ClientTag class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.ClientTag) -> bool:
        """
        Returns true if ClientTag instances are equal
        
        :param other: Instance of ClientTag to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class VWAPReceipt(System.Object, System.IEquatable[Oanda_RestV20_Model_VWAPReceipt], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A VWAP Receipt provides a record of how the price for an Order fill is constructed. If the Order is filled with multiple buckets in a depth of market, each bucket will be represented with a VWAP Receipt."""

    @property
    def Units(self) -> str:
        """The number of units filled"""
        ...

    @Units.setter
    def Units(self, value: str):
        """The number of units filled"""
        ...

    @property
    def Price(self) -> str:
        """The price at which the units were filled"""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price at which the units were filled"""
        ...

    def __init__(self, Units: str = ..., Price: str = ...) -> None:
        """
        Initializes a new instance of the VWAPReceipt class.
        
        :param Units: The number of units filled.
        :param Price: The price at which the units were filled.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.VWAPReceipt) -> bool:
        """
        Returns true if VWAPReceipt instances are equal
        
        :param other: Instance of VWAPReceipt to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class PriceBucket(System.Object, System.IEquatable[Oanda_RestV20_Model_PriceBucket], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A Price Bucket represents a price available for an amount of liquidity"""

    @property
    def Price(self) -> str:
        """The Price offered by the PriceBucket"""
        ...

    @Price.setter
    def Price(self, value: str):
        """The Price offered by the PriceBucket"""
        ...

    @property
    def Liquidity(self) -> typing.Optional[int]:
        """The amount of liquidity offered by the PriceBucket"""
        ...

    @Liquidity.setter
    def Liquidity(self, value: typing.Optional[int]):
        """The amount of liquidity offered by the PriceBucket"""
        ...

    def __init__(self, Price: str = ..., Liquidity: typing.Optional[int] = ...) -> None:
        """
        Initializes a new instance of the PriceBucket class.
        
        :param Price: The Price offered by the PriceBucket.
        :param Liquidity: The amount of liquidity offered by the PriceBucket.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.PriceBucket) -> bool:
        """
        Returns true if PriceBucket instances are equal
        
        :param other: Instance of PriceBucket to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20010(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20010], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20010"""

    @property
    def OrderClientExtensionsModifyTransaction(self) -> Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction:
        """Gets or Sets OrderClientExtensionsModifyTransaction"""
        ...

    @OrderClientExtensionsModifyTransaction.setter
    def OrderClientExtensionsModifyTransaction(self, value: Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction):
        """Gets or Sets OrderClientExtensionsModifyTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    def __init__(self, OrderClientExtensionsModifyTransaction: Oanda.RestV20.Model.OrderClientExtensionsModifyTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20010 class.
        
        :param OrderClientExtensionsModifyTransaction: OrderClientExtensionsModifyTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20010) -> bool:
        """
        Returns true if InlineResponse20010 instances are equal
        
        :param other: Instance of InlineResponse20010 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class DecimalNumber(System.Object, System.IEquatable[Oanda_RestV20_Model_DecimalNumber], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The string representation of a decimal number."""

    def __init__(self) -> None:
        """Initializes a new instance of the DecimalNumber class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.DecimalNumber) -> bool:
        """
        Returns true if DecimalNumber instances are equal
        
        :param other: Instance of DecimalNumber to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TradeSpecifier(System.Object, System.IEquatable[Oanda_RestV20_Model_TradeSpecifier], System.ComponentModel.DataAnnotations.IValidatableObject):
    """The identification of a Trade as referred to by clients"""

    def __init__(self) -> None:
        """Initializes a new instance of the TradeSpecifier class."""
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TradeSpecifier) -> bool:
        """
        Returns true if TradeSpecifier instances are equal
        
        :param other: Instance of TradeSpecifier to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class StopLossOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_StopLossOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A StopLossOrderRequest specifies the parameters that may be set when creating a Stop Loss Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"STOP_LOSS\\" when creating a Stop Loss Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"STOP_LOSS\\" when creating a Stop Loss Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"STOP_LOSS\\" when creating a Stop Loss Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.StopLossOrderRequest.TriggerConditionEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the StopLossOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"STOP_LOSS\\" when creating a Stop Loss Order..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the StopLoss Order. The associated Trade will be closed by a market price that is equal to or worse than this threshold..
        :param TimeInForce: The time-in-force requested for the StopLoss Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for StopLoss Orders..
        :param GtdTime: The date/time when the StopLoss Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.StopLossOrderRequest) -> bool:
        """
        Returns true if StopLossOrderRequest instances are equal
        
        :param other: Instance of StopLossOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4003(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4003], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4003"""

    @property
    def OrderClientExtensionsModifyRejectTransaction(self) -> Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction:
        """Gets or Sets OrderClientExtensionsModifyRejectTransaction"""
        ...

    @OrderClientExtensionsModifyRejectTransaction.setter
    def OrderClientExtensionsModifyRejectTransaction(self, value: Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction):
        """Gets or Sets OrderClientExtensionsModifyRejectTransaction"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, OrderClientExtensionsModifyRejectTransaction: Oanda.RestV20.Model.OrderClientExtensionsModifyRejectTransaction = ..., LastTransactionID: str = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4003 class.
        
        :param OrderClientExtensionsModifyRejectTransaction: OrderClientExtensionsModifyRejectTransaction.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4003) -> bool:
        """
        Returns true if InlineResponse4003 instances are equal
        
        :param other: Instance of InlineResponse4003 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse20024(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse20024], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse20024"""

    @property
    def Trades(self) -> System.Collections.Generic.List[Oanda.RestV20.Model.Trade]:
        """The Account's list of open Trades"""
        ...

    @Trades.setter
    def Trades(self, value: System.Collections.Generic.List[Oanda.RestV20.Model.Trade]):
        """The Account's list of open Trades"""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, Trades: System.Collections.Generic.List[Oanda.RestV20.Model.Trade] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse20024 class.
        
        :param Trades: The Account's list of open Trades.
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse20024) -> bool:
        """
        Returns true if InlineResponse20024 instances are equal
        
        :param other: Instance of InlineResponse20024 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class TakeProfitOrderRequest(System.Object, System.IEquatable[Oanda_RestV20_Model_TakeProfitOrderRequest], System.ComponentModel.DataAnnotations.IValidatableObject):
    """A TakeProfitOrderRequest specifies the parameters that may be set when creating a Take Profit Order."""

    class TypeEnum(System.Enum):
        """The type of the Order to Create. Must be set to \\"TAKE_PROFIT\\" when creating a Take Profit Order."""

        MARKET = 0
        """Enum MARKET for "MARKET\""""

        LIMIT = 1
        """Enum LIMIT for "LIMIT\""""

        STOP = 2
        """Enum STOP for "STOP\""""

        MARKETIFTOUCHED = 3
        """Enum MARKETIFTOUCHED for "MARKET_IF_TOUCHED\""""

        TAKEPROFIT = 4
        """Enum TAKEPROFIT for "TAKE_PROFIT\""""

        STOPLOSS = 5
        """Enum STOPLOSS for "STOP_LOSS\""""

        TRAILINGSTOPLOSS = 6
        """Enum TRAILINGSTOPLOSS for "TRAILING_STOP_LOSS\""""

    class TimeInForceEnum(System.Enum):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""

        GTC = 0
        """Enum GTC for "GTC\""""

        GTD = 1
        """Enum GTD for "GTD\""""

        GFD = 2
        """Enum GFD for "GFD\""""

        FOK = 3
        """Enum FOK for "FOK\""""

        IOC = 4
        """Enum IOC for "IOC\""""

    class TriggerConditionEnum(System.Enum):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""

        DEFAULT = 0
        """Enum DEFAULT for "DEFAULT\""""

        TRIGGERDEFAULT = 1
        """Enum TRIGGERDEFAULT for "TRIGGER_DEFAULT\""""

        INVERSE = 2
        """Enum INVERSE for "INVERSE\""""

        BID = 3
        """Enum BID for "BID\""""

        ASK = 4
        """Enum ASK for "ASK\""""

        MID = 5
        """Enum MID for "MID\""""

    @property
    def Type(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TypeEnum]:
        """The type of the Order to Create. Must be set to \\"TAKE_PROFIT\\" when creating a Take Profit Order."""
        ...

    @Type.setter
    def Type(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TypeEnum]):
        """The type of the Order to Create. Must be set to \\"TAKE_PROFIT\\" when creating a Take Profit Order."""
        ...

    @property
    def TimeInForce(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TimeInForceEnum]:
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @TimeInForce.setter
    def TimeInForce(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TimeInForceEnum]):
        """The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders."""
        ...

    @property
    def TriggerCondition(self) -> typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TriggerConditionEnum]:
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @TriggerCondition.setter
    def TriggerCondition(self, value: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TriggerConditionEnum]):
        """Specification of what component of a price should be used for comparison when determining if the Order should be filled."""
        ...

    @property
    def TradeID(self) -> str:
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @TradeID.setter
    def TradeID(self, value: str):
        """The ID of the Trade to close when the price threshold is breached."""
        ...

    @property
    def ClientTradeID(self) -> str:
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @ClientTradeID.setter
    def ClientTradeID(self, value: str):
        """The client ID of the Trade to be closed when the price threshold is breached."""
        ...

    @property
    def Price(self) -> str:
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @Price.setter
    def Price(self, value: str):
        """The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold."""
        ...

    @property
    def GtdTime(self) -> str:
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @GtdTime.setter
    def GtdTime(self, value: str):
        """The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"."""
        ...

    @property
    def ClientExtensions(self) -> Oanda.RestV20.Model.ClientExtensions:
        """Gets or Sets ClientExtensions"""
        ...

    @ClientExtensions.setter
    def ClientExtensions(self, value: Oanda.RestV20.Model.ClientExtensions):
        """Gets or Sets ClientExtensions"""
        ...

    def __init__(self, Type: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TypeEnum] = ..., TradeID: str = ..., ClientTradeID: str = ..., Price: str = ..., TimeInForce: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TimeInForceEnum] = ..., GtdTime: str = ..., TriggerCondition: typing.Optional[Oanda.RestV20.Model.TakeProfitOrderRequest.TriggerConditionEnum] = ..., ClientExtensions: Oanda.RestV20.Model.ClientExtensions = ...) -> None:
        """
        Initializes a new instance of the TakeProfitOrderRequest class.
        
        :param Type: The type of the Order to Create. Must be set to \\"TAKE_PROFIT\\" when creating a Take Profit Order..
        :param TradeID: The ID of the Trade to close when the price threshold is breached..
        :param ClientTradeID: The client ID of the Trade to be closed when the price threshold is breached..
        :param Price: The price threshold specified for the TakeProfit Order. The associated Trade will be closed by a market price that is equal to or better than this threshold..
        :param TimeInForce: The time-in-force requested for the TakeProfit Order. Restricted to \\"GTC\\", \\"GFD\\" and \\"GTD\\" for TakeProfit Orders..
        :param GtdTime: The date/time when the TakeProfit Order will be cancelled if its timeInForce is \\"GTD\\"..
        :param TriggerCondition: Specification of what component of a price should be used for comparison when determining if the Order should be filled..
        :param ClientExtensions: ClientExtensions.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.TakeProfitOrderRequest) -> bool:
        """
        Returns true if TakeProfitOrderRequest instances are equal
        
        :param other: Instance of TakeProfitOrderRequest to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse201(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse201], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse201"""

    @property
    def OrderCreateTransaction(self) -> Oanda.RestV20.Model.Transaction:
        """Gets or Sets OrderCreateTransaction"""
        ...

    @OrderCreateTransaction.setter
    def OrderCreateTransaction(self, value: Oanda.RestV20.Model.Transaction):
        """Gets or Sets OrderCreateTransaction"""
        ...

    @property
    def OrderFillTransaction(self) -> Oanda.RestV20.Model.OrderFillTransaction:
        """Gets or Sets OrderFillTransaction"""
        ...

    @OrderFillTransaction.setter
    def OrderFillTransaction(self, value: Oanda.RestV20.Model.OrderFillTransaction):
        """Gets or Sets OrderFillTransaction"""
        ...

    @property
    def OrderCancelTransaction(self) -> Oanda.RestV20.Model.OrderCancelTransaction:
        """Gets or Sets OrderCancelTransaction"""
        ...

    @OrderCancelTransaction.setter
    def OrderCancelTransaction(self, value: Oanda.RestV20.Model.OrderCancelTransaction):
        """Gets or Sets OrderCancelTransaction"""
        ...

    @property
    def OrderReissueTransaction(self) -> Oanda.RestV20.Model.Transaction:
        """Gets or Sets OrderReissueTransaction"""
        ...

    @OrderReissueTransaction.setter
    def OrderReissueTransaction(self, value: Oanda.RestV20.Model.Transaction):
        """Gets or Sets OrderReissueTransaction"""
        ...

    @property
    def OrderReissueRejectTransaction(self) -> Oanda.RestV20.Model.Transaction:
        """Gets or Sets OrderReissueRejectTransaction"""
        ...

    @OrderReissueRejectTransaction.setter
    def OrderReissueRejectTransaction(self, value: Oanda.RestV20.Model.Transaction):
        """Gets or Sets OrderReissueRejectTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    def __init__(self, OrderCreateTransaction: Oanda.RestV20.Model.Transaction = ..., OrderFillTransaction: Oanda.RestV20.Model.OrderFillTransaction = ..., OrderCancelTransaction: Oanda.RestV20.Model.OrderCancelTransaction = ..., OrderReissueTransaction: Oanda.RestV20.Model.Transaction = ..., OrderReissueRejectTransaction: Oanda.RestV20.Model.Transaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse201 class.
        
        :param OrderCreateTransaction: OrderCreateTransaction.
        :param OrderFillTransaction: OrderFillTransaction.
        :param OrderCancelTransaction: OrderCancelTransaction.
        :param OrderReissueTransaction: OrderReissueTransaction.
        :param OrderReissueRejectTransaction: OrderReissueRejectTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse201) -> bool:
        """
        Returns true if InlineResponse201 instances are equal
        
        :param other: Instance of InlineResponse201 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4002(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4002], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4002"""

    @property
    def OrderRejectTransaction(self) -> Oanda.RestV20.Model.Transaction:
        """Gets or Sets OrderRejectTransaction"""
        ...

    @OrderRejectTransaction.setter
    def OrderRejectTransaction(self, value: Oanda.RestV20.Model.Transaction):
        """Gets or Sets OrderRejectTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account."""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account."""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, OrderRejectTransaction: Oanda.RestV20.Model.Transaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4002 class.
        
        :param OrderRejectTransaction: OrderRejectTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account..
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4002) -> bool:
        """
        Returns true if InlineResponse4002 instances are equal
        
        :param other: Instance of InlineResponse4002 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class CloseTradeBody(System.Object, System.IEquatable[Oanda_RestV20_Model_CloseTradeBody], System.ComponentModel.DataAnnotations.IValidatableObject):
    """CloseTradeBody"""

    @property
    def Units(self) -> str:
        """Indication of how much of the Trade to close. Either the string \\"ALL\\" (indicating that all of the Trade should be closed), or a DecimalNumber representing the number of units of the open Trade to Close using a TradeClose MarketOrder. The units specified must always be positive, and the magnitude of the value cannot exceed the magnitude of the Trade's open units."""
        ...

    @Units.setter
    def Units(self, value: str):
        """Indication of how much of the Trade to close. Either the string \\"ALL\\" (indicating that all of the Trade should be closed), or a DecimalNumber representing the number of units of the open Trade to Close using a TradeClose MarketOrder. The units specified must always be positive, and the magnitude of the value cannot exceed the magnitude of the Trade's open units."""
        ...

    def __init__(self, Units: str = ...) -> None:
        """
        Initializes a new instance of the CloseTradeBody class.
        
        :param Units: Indication of how much of the Trade to close. Either the string \\"ALL\\" (indicating that all of the Trade should be closed), or a DecimalNumber representing the number of units of the open Trade to Close using a TradeClose MarketOrder. The units specified must always be positive, and the magnitude of the value cannot exceed the magnitude of the Trade's open units..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.CloseTradeBody) -> bool:
        """
        Returns true if CloseTradeBody instances are equal
        
        :param other: Instance of CloseTradeBody to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
        """
        To validate all properties of the instance
        
        :param validationContext: Validation context
        :returns: Validation Result.
        """
        ...


class InlineResponse4004(System.Object, System.IEquatable[Oanda_RestV20_Model_InlineResponse4004], System.ComponentModel.DataAnnotations.IValidatableObject):
    """InlineResponse4004"""

    @property
    def LongOrderRejectTransaction(self) -> Oanda.RestV20.Model.MarketOrderRejectTransaction:
        """Gets or Sets LongOrderRejectTransaction"""
        ...

    @LongOrderRejectTransaction.setter
    def LongOrderRejectTransaction(self, value: Oanda.RestV20.Model.MarketOrderRejectTransaction):
        """Gets or Sets LongOrderRejectTransaction"""
        ...

    @property
    def ShortOrderRejectTransaction(self) -> Oanda.RestV20.Model.MarketOrderRejectTransaction:
        """Gets or Sets ShortOrderRejectTransaction"""
        ...

    @ShortOrderRejectTransaction.setter
    def ShortOrderRejectTransaction(self, value: Oanda.RestV20.Model.MarketOrderRejectTransaction):
        """Gets or Sets ShortOrderRejectTransaction"""
        ...

    @property
    def RelatedTransactionIDs(self) -> System.Collections.Generic.List[str]:
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @RelatedTransactionIDs.setter
    def RelatedTransactionIDs(self, value: System.Collections.Generic.List[str]):
        """The IDs of all Transactions that were created while satisfying the request."""
        ...

    @property
    def LastTransactionID(self) -> str:
        """The ID of the most recent Transaction created for the Account"""
        ...

    @LastTransactionID.setter
    def LastTransactionID(self, value: str):
        """The ID of the most recent Transaction created for the Account"""
        ...

    @property
    def ErrorCode(self) -> str:
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @ErrorCode.setter
    def ErrorCode(self, value: str):
        """The code of the error that has occurred. This field may not be returned for some errors."""
        ...

    @property
    def ErrorMessage(self) -> str:
        """The human-readable description of the error that has occurred."""
        ...

    @ErrorMessage.setter
    def ErrorMessage(self, value: str):
        """The human-readable description of the error that has occurred."""
        ...

    def __init__(self, LongOrderRejectTransaction: Oanda.RestV20.Model.MarketOrderRejectTransaction = ..., ShortOrderRejectTransaction: Oanda.RestV20.Model.MarketOrderRejectTransaction = ..., RelatedTransactionIDs: System.Collections.Generic.List[str] = ..., LastTransactionID: str = ..., ErrorCode: str = ..., ErrorMessage: str = ...) -> None:
        """
        Initializes a new instance of the InlineResponse4004 class.
        
        :param LongOrderRejectTransaction: LongOrderRejectTransaction.
        :param ShortOrderRejectTransaction: ShortOrderRejectTransaction.
        :param RelatedTransactionIDs: The IDs of all Transactions that were created while satisfying the request..
        :param LastTransactionID: The ID of the most recent Transaction created for the Account.
        :param ErrorCode: The code of the error that has occurred. This field may not be returned for some errors..
        :param ErrorMessage: The human-readable description of the error that has occurred..
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Returns true if objects are equal
        
        :param obj: Object to be compared
        :returns: Boolean.
        """
        ...

    @typing.overload
    def Equals(self, other: Oanda.RestV20.Model.InlineResponse4004) -> bool:
        """
        Returns true if InlineResponse4004 instances are equal
        
        :param other: Instance of InlineResponse4004 to be compared
        :returns: Boolean.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Gets the hash code
        
        :returns: Hash code.
        """
        ...

    def ToJson(self) -> str:
        """
        Returns the JSON string presentation of the object
        
        :returns: JSON string presentation of the object.
        """
        ...

    def ToString(self) -> str:
        """
        Returns the string presentation of the object
        
        :returns: String presentation of the object.
        """
        ...

    def Validate(self, validationContext: System.ComponentModel.DataAnnotations.ValidationContext) -> System.Collections.Generic.IEnumerable[System.ComponentModel.DataAnnotations.ValidationResult]:
     