# generated by datamodel-codegen:
#   filename:  plato.yaml
#   timestamp: 2025-10-27T02:40:30+00:00

from __future__ import annotations

from enum import Enum

from pydantic import BaseModel


class SimConfigCompute(BaseModel):
    cpus: int
    memory: int
    disk: int
    app_port: int
    plato_messaging_port: int


class Variable(BaseModel):
    name: str
    value: str


class SimConfigMetadata(BaseModel):
    favicon: str | None = None
    name: str
    description: str | None = None
    source_code_url: str | None = None
    start_url: str | None = None
    license: str | None = None
    variables: list[Variable] | None = None
    flows_path: str | None = None


class SimConfigService(BaseModel):
    type: str
    file: str | None = None
    required_healthy_containers: list[str] | None = None
    healthy_wait_timeout: int | None = None


class Type(Enum):
    db = "db"
    file = "file"
    proxy = "proxy"


class SimConfigListener(BaseModel):
    type: Type
    db_type: str | None = None
    db_host: str | None = None
    db_port: int | None = None
    db_user: str | None = None
    db_password: str | None = None
    db_database: str | None = None
    target_dir: str | None = None
    watch_enabled: bool | None = None
    watch_patterns: list[str] | None = None
    ignore_patterns: list[str] | None = None
    seed_data_path: str | None = None
    seed_data_paths: list[str] | None = None
    volumes: list[str] | None = None


class SimConfigDataset(BaseModel):
    compute: SimConfigCompute
    metadata: SimConfigMetadata
    services: dict[str, SimConfigService] | None = None
    listeners: dict[str, SimConfigListener] | None = None


class PlatoConfig(BaseModel):
    service: str | None = None
    datasets: dict[str, SimConfigDataset] | None = None


class Sandbox(BaseModel):
    job_id: str
    public_id: str
    job_group_id: str
    url: str | None = None
    status: str | None = None
    correlation_id: str | None = None


class Environment(BaseModel):
    job_id: str
    alias: str | None = None
    status: str | None = None


class SimulatorListItem(BaseModel):
    name: str
    description: str | None = None
    artifact_id: str | None = None


class DBConfig(BaseModel):
    """Database configuration for pre-snapshot cleanup"""

    db_type: str  # "postgresql" or "mysql"
    user: str
    password: str
    dest_port: int
    databases: list[str]


class CreateSnapshotRequest(BaseModel):
    service: str | None = None
    git_hash: str | None = None
    dataset: str | None = None


class CreateSnapshotResponse(BaseModel):
    artifact_id: str
    status: str
    timestamp: str
    correlation_id: str
    s3_uri: str
    git_hash: str | None = None


class StartWorkerRequest(BaseModel):
    service: str | None = None
    dataset: str
    plato_dataset_config: SimConfigDataset
    timeout: int | None = None


class StartWorkerResponse(BaseModel):
    status: str
    timestamp: str
    correlation_id: str


class SSHInfo(BaseModel):
    """SSH connection information for a sandbox"""

    ssh_command: str
    ssh_host: str
    ssh_config_path: str
    public_id: str
