# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *
import pulumi_aws

__all__ = [
    'NatGatewayConfigurationArgs',
    'NatGatewayConfigurationArgsDict',
    'SubnetSpecArgs',
    'SubnetSpecArgsDict',
    'VpcEndpointSpecArgs',
    'VpcEndpointSpecArgsDict',
]

MYPY = False

if not MYPY:
    class NatGatewayConfigurationArgsDict(TypedDict):
        """
        Configuration for NAT Gateways.
        """
        strategy: 'NatGatewayStrategy'
        """
        The strategy for deploying NAT Gateways.
        """
        elastic_ip_allocation_ids: NotRequired[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of EIP allocation IDs to assign to the NAT Gateways. Optional. If specified, the number of supplied values must match the chosen strategy (either one, or the number of availability zones).
        """
elif False:
    NatGatewayConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NatGatewayConfigurationArgs:
    def __init__(__self__, *,
                 strategy: 'NatGatewayStrategy',
                 elastic_ip_allocation_ids: Optional[Sequence[pulumi.Input[_builtins.str]]] = None):
        """
        Configuration for NAT Gateways.
        :param 'NatGatewayStrategy' strategy: The strategy for deploying NAT Gateways.
        :param Sequence[pulumi.Input[_builtins.str]] elastic_ip_allocation_ids: A list of EIP allocation IDs to assign to the NAT Gateways. Optional. If specified, the number of supplied values must match the chosen strategy (either one, or the number of availability zones).
        """
        pulumi.set(__self__, "strategy", strategy)
        if elastic_ip_allocation_ids is not None:
            pulumi.set(__self__, "elastic_ip_allocation_ids", elastic_ip_allocation_ids)

    @_builtins.property
    @pulumi.getter
    def strategy(self) -> 'NatGatewayStrategy':
        """
        The strategy for deploying NAT Gateways.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: 'NatGatewayStrategy'):
        pulumi.set(self, "strategy", value)

    @_builtins.property
    @pulumi.getter(name="elasticIpAllocationIds")
    def elastic_ip_allocation_ids(self) -> Optional[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of EIP allocation IDs to assign to the NAT Gateways. Optional. If specified, the number of supplied values must match the chosen strategy (either one, or the number of availability zones).
        """
        return pulumi.get(self, "elastic_ip_allocation_ids")

    @elastic_ip_allocation_ids.setter
    def elastic_ip_allocation_ids(self, value: Optional[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "elastic_ip_allocation_ids", value)


if not MYPY:
    class SubnetSpecArgsDict(TypedDict):
        """
        Configuration for a VPC subnet.
        """
        type: 'SubnetType'
        """
        The type of subnet.
        """
        cidr_blocks: NotRequired[Sequence[_builtins.str]]
        """
        An optional list of CIDR blocks to assign to the subnet spec for each AZ. If specified, the count must match the number of AZs being used for the VPC, and must also be specified for all other subnet specs.
        """
        cidr_mask: NotRequired[_builtins.int]
        """
        The netmask for the subnet's CIDR block. This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        name: NotRequired[_builtins.str]
        """
        The subnet's name. Will be templated upon creation.
        """
        size: NotRequired[_builtins.int]
        """
        Optional size of the subnet's CIDR block - the number of hosts. This value must be a power of 2 (e.g. 256, 512, 1024, etc.). This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of tags to assign to the resource.
        """
elif False:
    SubnetSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SubnetSpecArgs:
    def __init__(__self__, *,
                 type: 'SubnetType',
                 cidr_blocks: Optional[Sequence[_builtins.str]] = None,
                 cidr_mask: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Configuration for a VPC subnet.
        :param 'SubnetType' type: The type of subnet.
        :param Sequence[_builtins.str] cidr_blocks: An optional list of CIDR blocks to assign to the subnet spec for each AZ. If specified, the count must match the number of AZs being used for the VPC, and must also be specified for all other subnet specs.
        :param _builtins.int cidr_mask: The netmask for the subnet's CIDR block. This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        :param _builtins.str name: The subnet's name. Will be templated upon creation.
        :param _builtins.int size: Optional size of the subnet's CIDR block - the number of hosts. This value must be a power of 2 (e.g. 256, 512, 1024, etc.). This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource.
        """
        pulumi.set(__self__, "type", type)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if cidr_mask is not None:
            pulumi.set(__self__, "cidr_mask", cidr_mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def type(self) -> 'SubnetType':
        """
        The type of subnet.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: 'SubnetType'):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional list of CIDR blocks to assign to the subnet spec for each AZ. If specified, the count must match the number of AZs being used for the VPC, and must also be specified for all other subnet specs.
        """
        return pulumi.get(self, "cidr_blocks")

    @cidr_blocks.setter
    def cidr_blocks(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "cidr_blocks", value)

    @_builtins.property
    @pulumi.getter(name="cidrMask")
    def cidr_mask(self) -> Optional[_builtins.int]:
        """
        The netmask for the subnet's CIDR block. This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        return pulumi.get(self, "cidr_mask")

    @cidr_mask.setter
    def cidr_mask(self, value: Optional[_builtins.int]):
        pulumi.set(self, "cidr_mask", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The subnet's name. Will be templated upon creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Optional size of the subnet's CIDR block - the number of hosts. This value must be a power of 2 (e.g. 256, 512, 1024, etc.). This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class VpcEndpointSpecArgsDict(TypedDict):
        """
        Provides a VPC Endpoint resource.

        > **NOTE on VPC Endpoints and VPC Endpoint Associations:** The provider provides both standalone VPC Endpoint Associations for
        Route Tables - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`routeTableId`" pulumi-lang-dotnet="`RouteTableId`" pulumi-lang-go="`routeTableId`" pulumi-lang-python="`route_table_id`" pulumi-lang-yaml="`routeTableId`" pulumi-lang-java="`routeTableId`">`route_table_id`</span>),
        Security Groups - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`securityGroupId`" pulumi-lang-dotnet="`SecurityGroupId`" pulumi-lang-go="`securityGroupId`" pulumi-lang-python="`security_group_id`" pulumi-lang-yaml="`securityGroupId`" pulumi-lang-java="`securityGroupId`">`security_group_id`</span>),
        and Subnets - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`subnetId`" pulumi-lang-dotnet="`SubnetId`" pulumi-lang-go="`subnetId`" pulumi-lang-python="`subnet_id`" pulumi-lang-yaml="`subnetId`" pulumi-lang-java="`subnetId`">`subnet_id`</span>) and
        a VPC Endpoint resource with <span pulumi-lang-nodejs="`routeTableIds`" pulumi-lang-dotnet="`RouteTableIds`" pulumi-lang-go="`routeTableIds`" pulumi-lang-python="`route_table_ids`" pulumi-lang-yaml="`routeTableIds`" pulumi-lang-java="`routeTableIds`">`route_table_ids`</span> and <span pulumi-lang-nodejs="`subnetIds`" pulumi-lang-dotnet="`SubnetIds`" pulumi-lang-go="`subnetIds`" pulumi-lang-python="`subnet_ids`" pulumi-lang-yaml="`subnetIds`" pulumi-lang-java="`subnetIds`">`subnet_ids`</span> attributes.
        Do not use the same resource ID in both a VPC Endpoint resource and a VPC Endpoint Association resource.
        Doing so will cause a conflict of associations and will overwrite the association.

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const s3 = new aws.ec2.VpcEndpoint("s3", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.s3",
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.ec2.VpcEndpoint("s3",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.s3")
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.s3",
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
        			VpcId:       pulumi.Any(main.Id),
        			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.s3")
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          s3:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.s3
        ```
        <!--End PulumiCodeChooser -->

        ### Basic w/ Tags

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const s3 = new aws.ec2.VpcEndpoint("s3", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.s3",
            tags: {
                Environment: "test",
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.ec2.VpcEndpoint("s3",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.s3",
            tags={
                "Environment": "test",
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.s3",
                Tags = 
                {
                    { "Environment", "test" },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
        			VpcId:       pulumi.Any(main.Id),
        			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
        			Tags: pulumi.StringMap{
        				"Environment": pulumi.String("test"),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.s3")
                    .tags(Map.of("Environment", "test"))
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          s3:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.s3
              tags:
                Environment: test
        ```
        <!--End PulumiCodeChooser -->

        ### Interface Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const ec2 = new aws.ec2.VpcEndpoint("ec2", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.ec2",
            vpcEndpointType: "Interface",
            securityGroupIds: [sg1.id],
            privateDnsEnabled: true,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.ec2.VpcEndpoint("ec2",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.ec2",
            vpc_endpoint_type="Interface",
            security_group_ids=[sg1["id"]],
            private_dns_enabled=True)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.ec2",
                VpcEndpointType = "Interface",
                SecurityGroupIds = new[]
                {
                    sg1.Id,
                },
                PrivateDnsEnabled = true,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
        			VpcId:           pulumi.Any(main.Id),
        			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
        			VpcEndpointType: pulumi.String("Interface"),
        			SecurityGroupIds: pulumi.StringArray{
        				sg1.Id,
        			},
        			PrivateDnsEnabled: pulumi.Bool(true),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.ec2")
                    .vpcEndpointType("Interface")
                    .securityGroupIds(sg1.id())
                    .privateDnsEnabled(true)
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ec2:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.ec2
              vpcEndpointType: Interface
              securityGroupIds:
                - ${sg1.id}
              privateDnsEnabled: true
        ```
        <!--End PulumiCodeChooser -->

        ### Interface Endpoint Type with User-Defined IP Address

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const ec2 = new aws.ec2.VpcEndpoint("ec2", {
            vpcId: example.id,
            serviceName: "com.amazonaws.us-west-2.ec2",
            vpcEndpointType: "Interface",
            subnetConfigurations: [
                {
                    ipv4: "10.0.1.10",
                    subnetId: example1.id,
                },
                {
                    ipv4: "10.0.2.10",
                    subnetId: example2.id,
                },
            ],
            subnetIds: [
                example1.id,
                example2.id,
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.ec2.VpcEndpoint("ec2",
            vpc_id=example["id"],
            service_name="com.amazonaws.us-west-2.ec2",
            vpc_endpoint_type="Interface",
            subnet_configurations=[
                {
                    "ipv4": "10.0.1.10",
                    "subnet_id": example1["id"],
                },
                {
                    "ipv4": "10.0.2.10",
                    "subnet_id": example2["id"],
                },
            ],
            subnet_ids=[
                example1["id"],
                example2["id"],
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
            {
                VpcId = example.Id,
                ServiceName = "com.amazonaws.us-west-2.ec2",
                VpcEndpointType = "Interface",
                SubnetConfigurations = new[]
                {
                    new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
                    {
                        Ipv4 = "10.0.1.10",
                        SubnetId = example1.Id,
                    },
                    new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
                    {
                        Ipv4 = "10.0.2.10",
                        SubnetId = example2.Id,
                    },
                },
                SubnetIds = new[]
                {
                    example1.Id,
                    example2.Id,
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
        			VpcId:           pulumi.Any(example.Id),
        			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
        			VpcEndpointType: pulumi.String("Interface"),
        			SubnetConfigurations: ec2.VpcEndpointSubnetConfigurationArray{
        				&ec2.VpcEndpointSubnetConfigurationArgs{
        					Ipv4:     pulumi.String("10.0.1.10"),
        					SubnetId: pulumi.Any(example1.Id),
        				},
        				&ec2.VpcEndpointSubnetConfigurationArgs{
        					Ipv4:     pulumi.String("10.0.2.10"),
        					SubnetId: pulumi.Any(example2.Id),
        				},
        			},
        			SubnetIds: pulumi.StringArray{
        				example1.Id,
        				example2.Id,
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
                    .vpcId(example.id())
                    .serviceName("com.amazonaws.us-west-2.ec2")
                    .vpcEndpointType("Interface")
                    .subnetConfigurations(            
                        VpcEndpointSubnetConfigurationArgs.builder()
                            .ipv4("10.0.1.10")
                            .subnetId(example1.id())
                            .build(),
                        VpcEndpointSubnetConfigurationArgs.builder()
                            .ipv4("10.0.2.10")
                            .subnetId(example2.id())
                            .build())
                    .subnetIds(            
                        example1.id(),
                        example2.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ec2:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${example.id}
              serviceName: com.amazonaws.us-west-2.ec2
              vpcEndpointType: Interface
              subnetConfigurations:
                - ipv4: 10.0.1.10
                  subnetId: ${example1.id}
                - ipv4: 10.0.2.10
                  subnetId: ${example2.id}
              subnetIds:
                - ${example1.id}
                - ${example2.id}
        ```
        <!--End PulumiCodeChooser -->

        ### Gateway Load Balancer Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const current = aws.getCallerIdentity({});
        const example = new aws.ec2.VpcEndpointService("example", {
            acceptanceRequired: false,
            allowedPrincipals: [current.then(current => current.arn)],
            gatewayLoadBalancerArns: [exampleAwsLb.arn],
        });
        const exampleVpcEndpoint = new aws.ec2.VpcEndpoint("example", {
            serviceName: example.serviceName,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: example.serviceType,
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.ec2.VpcEndpointService("example",
            acceptance_required=False,
            allowed_principals=[current.arn],
            gateway_load_balancer_arns=[example_aws_lb["arn"]])
        example_vpc_endpoint = aws.ec2.VpcEndpoint("example",
            service_name=example.service_name,
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type=example.service_type,
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var current = Aws.GetCallerIdentity.Invoke();

            var example = new Aws.Ec2.VpcEndpointService("example", new()
            {
                AcceptanceRequired = false,
                AllowedPrincipals = new[]
                {
                    current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
                },
                GatewayLoadBalancerArns = new[]
                {
                    exampleAwsLb.Arn,
                },
            });

            var exampleVpcEndpoint = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ServiceName = example.ServiceName,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = example.ServiceType,
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		current, err := aws.GetCallerIdentity(ctx, &aws.GetCallerIdentityArgs{}, nil)
        		if err != nil {
        			return err
        		}
        		example, err := ec2.NewVpcEndpointService(ctx, "example", &ec2.VpcEndpointServiceArgs{
        			AcceptanceRequired: pulumi.Bool(false),
        			AllowedPrincipals: pulumi.StringArray{
        				pulumi.String(current.Arn),
        			},
        			GatewayLoadBalancerArns: pulumi.StringArray{
        				exampleAwsLb.Arn,
        			},
        		})
        		if err != nil {
        			return err
        		}
        		_, err = ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ServiceName: example.ServiceName,
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: example.ServiceType,
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.AwsFunctions;
        import com.pulumi.aws.inputs.GetCallerIdentityArgs;
        import com.pulumi.aws.ec2.VpcEndpointService;
        import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                final var current = AwsFunctions.getCallerIdentity(GetCallerIdentityArgs.builder()
                    .build());

                var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
                    .acceptanceRequired(false)
                    .allowedPrincipals(current.arn())
                    .gatewayLoadBalancerArns(exampleAwsLb.arn())
                    .build());

                var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
                    .serviceName(example.serviceName())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType(example.serviceType())
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpointService
            properties:
              acceptanceRequired: false
              allowedPrincipals:
                - ${current.arn}
              gatewayLoadBalancerArns:
                - ${exampleAwsLb.arn}
          exampleVpcEndpoint:
            type: aws:ec2:VpcEndpoint
            name: example
            properties:
              serviceName: ${example.serviceName}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: ${example.serviceType}
              vpcId: ${exampleAwsVpc.id}
        variables:
          current:
            fn::invoke:
              function: aws:getCallerIdentity
              arguments: {}
        ```
        <!--End PulumiCodeChooser -->

        ### VPC Lattice Resource Configuration Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.ec2.VpcEndpoint("example", {
            resourceConfigurationArn: exampleAwsVpclatticeResourceConfiguration.arn,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: "Resource",
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcEndpoint("example",
            resource_configuration_arn=example_aws_vpclattice_resource_configuration["arn"],
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type="Resource",
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ResourceConfigurationArn = exampleAwsVpclatticeResourceConfiguration.Arn,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = "Resource",
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ResourceConfigurationArn: pulumi.Any(exampleAwsVpclatticeResourceConfiguration.Arn),
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: pulumi.String("Resource"),
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new VpcEndpoint("example", VpcEndpointArgs.builder()
                    .resourceConfigurationArn(exampleAwsVpclatticeResourceConfiguration.arn())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType("Resource")
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpoint
            properties:
              resourceConfigurationArn: ${exampleAwsVpclatticeResourceConfiguration.arn}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: Resource
              vpcId: ${exampleAwsVpc.id}
        ```
        <!--End PulumiCodeChooser -->

        ### VPC Lattice Service Network Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.ec2.VpcEndpoint("example", {
            serviceNetworkArn: exampleAwsVpclatticeServiceNetwork.arn,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: "ServiceNetwork",
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcEndpoint("example",
            service_network_arn=example_aws_vpclattice_service_network["arn"],
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type="ServiceNetwork",
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ServiceNetworkArn = exampleAwsVpclatticeServiceNetwork.Arn,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = "ServiceNetwork",
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ServiceNetworkArn: pulumi.Any(exampleAwsVpclatticeServiceNetwork.Arn),
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: pulumi.String("ServiceNetwork"),
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new VpcEndpoint("example", VpcEndpointArgs.builder()
                    .serviceNetworkArn(exampleAwsVpclatticeServiceNetwork.arn())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType("ServiceNetwork")
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpoint
            properties:
              serviceNetworkArn: ${exampleAwsVpclatticeServiceNetwork.arn}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: ServiceNetwork
              vpcId: ${exampleAwsVpc.id}
        ```
        <!--End PulumiCodeChooser -->
        """
        service_name: _builtins.str
        """
        The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
        """
        auto_accept: NotRequired[_builtins.bool]
        """
        Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
        """
        dns_options: NotRequired[pulumi.Input['pulumi_aws.ec2.VpcEndpointDnsOptionsArgsDict']]
        """
        The DNS options for the endpoint. See<span pulumi-lang-nodejs=" dnsOptions " pulumi-lang-dotnet=" DnsOptions " pulumi-lang-go=" dnsOptions " pulumi-lang-python=" dns_options " pulumi-lang-yaml=" dnsOptions " pulumi-lang-java=" dnsOptions "> dns_options </span>below.
        """
        ip_address_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address type for the endpoint. Valid values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span>, <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span>, and <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        """
        policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
        """
        private_dns_enabled: NotRequired[_builtins.bool]
        """
        Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type Interface. Defaults to `false`.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        resource_configuration_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of a Resource Configuration to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        """
        route_table_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        One or more route table IDs. Applicable for endpoints of type `Gateway`.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
        If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
        """
        service_network_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ARN of a Service Network to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        """
        service_region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The AWS region of the VPC Endpoint Service. If specified, the VPC endpoint will connect to the service in the provided region. Applicable for endpoints of type `Interface`.
        """
        subnet_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.VpcEndpointSubnetConfigurationArgsDict']]]]
        """
        Subnet configuration for the endpoint, used to select specific IPv4 and/or IPv6 addresses to the endpoint. See<span pulumi-lang-nodejs=" subnetConfiguration " pulumi-lang-dotnet=" SubnetConfiguration " pulumi-lang-go=" subnetConfiguration " pulumi-lang-python=" subnet_configuration " pulumi-lang-yaml=" subnetConfiguration " pulumi-lang-java=" subnetConfiguration "> subnet_configuration </span>below.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        vpc_endpoint_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`,`Interface`, `Resource` or `ServiceNetwork`. Defaults to `Gateway`.
        """
elif False:
    VpcEndpointSpecArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VpcEndpointSpecArgs:
    def __init__(__self__, *,
                 service_name: _builtins.str,
                 auto_accept: Optional[_builtins.bool] = None,
                 dns_options: Optional[pulumi.Input['pulumi_aws.ec2.VpcEndpointDnsOptionsArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_enabled: Optional[_builtins.bool] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_configuration_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 service_network_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 service_region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.VpcEndpointSubnetConfigurationArgs']]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_endpoint_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Provides a VPC Endpoint resource.

        > **NOTE on VPC Endpoints and VPC Endpoint Associations:** The provider provides both standalone VPC Endpoint Associations for
        Route Tables - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`routeTableId`" pulumi-lang-dotnet="`RouteTableId`" pulumi-lang-go="`routeTableId`" pulumi-lang-python="`route_table_id`" pulumi-lang-yaml="`routeTableId`" pulumi-lang-java="`routeTableId`">`route_table_id`</span>),
        Security Groups - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`securityGroupId`" pulumi-lang-dotnet="`SecurityGroupId`" pulumi-lang-go="`securityGroupId`" pulumi-lang-python="`security_group_id`" pulumi-lang-yaml="`securityGroupId`" pulumi-lang-java="`securityGroupId`">`security_group_id`</span>),
        and Subnets - (an association between a VPC endpoint and a single <span pulumi-lang-nodejs="`subnetId`" pulumi-lang-dotnet="`SubnetId`" pulumi-lang-go="`subnetId`" pulumi-lang-python="`subnet_id`" pulumi-lang-yaml="`subnetId`" pulumi-lang-java="`subnetId`">`subnet_id`</span>) and
        a VPC Endpoint resource with <span pulumi-lang-nodejs="`routeTableIds`" pulumi-lang-dotnet="`RouteTableIds`" pulumi-lang-go="`routeTableIds`" pulumi-lang-python="`route_table_ids`" pulumi-lang-yaml="`routeTableIds`" pulumi-lang-java="`routeTableIds`">`route_table_ids`</span> and <span pulumi-lang-nodejs="`subnetIds`" pulumi-lang-dotnet="`SubnetIds`" pulumi-lang-go="`subnetIds`" pulumi-lang-python="`subnet_ids`" pulumi-lang-yaml="`subnetIds`" pulumi-lang-java="`subnetIds`">`subnet_ids`</span> attributes.
        Do not use the same resource ID in both a VPC Endpoint resource and a VPC Endpoint Association resource.
        Doing so will cause a conflict of associations and will overwrite the association.

        ## Example Usage

        ### Basic

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const s3 = new aws.ec2.VpcEndpoint("s3", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.s3",
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.ec2.VpcEndpoint("s3",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.s3")
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.s3",
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
        			VpcId:       pulumi.Any(main.Id),
        			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.s3")
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          s3:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.s3
        ```
        <!--End PulumiCodeChooser -->

        ### Basic w/ Tags

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const s3 = new aws.ec2.VpcEndpoint("s3", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.s3",
            tags: {
                Environment: "test",
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        s3 = aws.ec2.VpcEndpoint("s3",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.s3",
            tags={
                "Environment": "test",
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var s3 = new Aws.Ec2.VpcEndpoint("s3", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.s3",
                Tags = 
                {
                    { "Environment", "test" },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "s3", &ec2.VpcEndpointArgs{
        			VpcId:       pulumi.Any(main.Id),
        			ServiceName: pulumi.String("com.amazonaws.us-west-2.s3"),
        			Tags: pulumi.StringMap{
        				"Environment": pulumi.String("test"),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var s3 = new VpcEndpoint("s3", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.s3")
                    .tags(Map.of("Environment", "test"))
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          s3:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.s3
              tags:
                Environment: test
        ```
        <!--End PulumiCodeChooser -->

        ### Interface Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const ec2 = new aws.ec2.VpcEndpoint("ec2", {
            vpcId: main.id,
            serviceName: "com.amazonaws.us-west-2.ec2",
            vpcEndpointType: "Interface",
            securityGroupIds: [sg1.id],
            privateDnsEnabled: true,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.ec2.VpcEndpoint("ec2",
            vpc_id=main["id"],
            service_name="com.amazonaws.us-west-2.ec2",
            vpc_endpoint_type="Interface",
            security_group_ids=[sg1["id"]],
            private_dns_enabled=True)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
            {
                VpcId = main.Id,
                ServiceName = "com.amazonaws.us-west-2.ec2",
                VpcEndpointType = "Interface",
                SecurityGroupIds = new[]
                {
                    sg1.Id,
                },
                PrivateDnsEnabled = true,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
        			VpcId:           pulumi.Any(main.Id),
        			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
        			VpcEndpointType: pulumi.String("Interface"),
        			SecurityGroupIds: pulumi.StringArray{
        				sg1.Id,
        			},
        			PrivateDnsEnabled: pulumi.Bool(true),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
                    .vpcId(main.id())
                    .serviceName("com.amazonaws.us-west-2.ec2")
                    .vpcEndpointType("Interface")
                    .securityGroupIds(sg1.id())
                    .privateDnsEnabled(true)
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ec2:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${main.id}
              serviceName: com.amazonaws.us-west-2.ec2
              vpcEndpointType: Interface
              securityGroupIds:
                - ${sg1.id}
              privateDnsEnabled: true
        ```
        <!--End PulumiCodeChooser -->

        ### Interface Endpoint Type with User-Defined IP Address

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const ec2 = new aws.ec2.VpcEndpoint("ec2", {
            vpcId: example.id,
            serviceName: "com.amazonaws.us-west-2.ec2",
            vpcEndpointType: "Interface",
            subnetConfigurations: [
                {
                    ipv4: "10.0.1.10",
                    subnetId: example1.id,
                },
                {
                    ipv4: "10.0.2.10",
                    subnetId: example2.id,
                },
            ],
            subnetIds: [
                example1.id,
                example2.id,
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        ec2 = aws.ec2.VpcEndpoint("ec2",
            vpc_id=example["id"],
            service_name="com.amazonaws.us-west-2.ec2",
            vpc_endpoint_type="Interface",
            subnet_configurations=[
                {
                    "ipv4": "10.0.1.10",
                    "subnet_id": example1["id"],
                },
                {
                    "ipv4": "10.0.2.10",
                    "subnet_id": example2["id"],
                },
            ],
            subnet_ids=[
                example1["id"],
                example2["id"],
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var ec2 = new Aws.Ec2.VpcEndpoint("ec2", new()
            {
                VpcId = example.Id,
                ServiceName = "com.amazonaws.us-west-2.ec2",
                VpcEndpointType = "Interface",
                SubnetConfigurations = new[]
                {
                    new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
                    {
                        Ipv4 = "10.0.1.10",
                        SubnetId = example1.Id,
                    },
                    new Aws.Ec2.Inputs.VpcEndpointSubnetConfigurationArgs
                    {
                        Ipv4 = "10.0.2.10",
                        SubnetId = example2.Id,
                    },
                },
                SubnetIds = new[]
                {
                    example1.Id,
                    example2.Id,
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "ec2", &ec2.VpcEndpointArgs{
        			VpcId:           pulumi.Any(example.Id),
        			ServiceName:     pulumi.String("com.amazonaws.us-west-2.ec2"),
        			VpcEndpointType: pulumi.String("Interface"),
        			SubnetConfigurations: ec2.VpcEndpointSubnetConfigurationArray{
        				&ec2.VpcEndpointSubnetConfigurationArgs{
        					Ipv4:     pulumi.String("10.0.1.10"),
        					SubnetId: pulumi.Any(example1.Id),
        				},
        				&ec2.VpcEndpointSubnetConfigurationArgs{
        					Ipv4:     pulumi.String("10.0.2.10"),
        					SubnetId: pulumi.Any(example2.Id),
        				},
        			},
        			SubnetIds: pulumi.StringArray{
        				example1.Id,
        				example2.Id,
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import com.pulumi.aws.ec2.inputs.VpcEndpointSubnetConfigurationArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var ec2 = new VpcEndpoint("ec2", VpcEndpointArgs.builder()
                    .vpcId(example.id())
                    .serviceName("com.amazonaws.us-west-2.ec2")
                    .vpcEndpointType("Interface")
                    .subnetConfigurations(            
                        VpcEndpointSubnetConfigurationArgs.builder()
                            .ipv4("10.0.1.10")
                            .subnetId(example1.id())
                            .build(),
                        VpcEndpointSubnetConfigurationArgs.builder()
                            .ipv4("10.0.2.10")
                            .subnetId(example2.id())
                            .build())
                    .subnetIds(            
                        example1.id(),
                        example2.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ec2:
            type: aws:ec2:VpcEndpoint
            properties:
              vpcId: ${example.id}
              serviceName: com.amazonaws.us-west-2.ec2
              vpcEndpointType: Interface
              subnetConfigurations:
                - ipv4: 10.0.1.10
                  subnetId: ${example1.id}
                - ipv4: 10.0.2.10
                  subnetId: ${example2.id}
              subnetIds:
                - ${example1.id}
                - ${example2.id}
        ```
        <!--End PulumiCodeChooser -->

        ### Gateway Load Balancer Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const current = aws.getCallerIdentity({});
        const example = new aws.ec2.VpcEndpointService("example", {
            acceptanceRequired: false,
            allowedPrincipals: [current.then(current => current.arn)],
            gatewayLoadBalancerArns: [exampleAwsLb.arn],
        });
        const exampleVpcEndpoint = new aws.ec2.VpcEndpoint("example", {
            serviceName: example.serviceName,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: example.serviceType,
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.ec2.VpcEndpointService("example",
            acceptance_required=False,
            allowed_principals=[current.arn],
            gateway_load_balancer_arns=[example_aws_lb["arn"]])
        example_vpc_endpoint = aws.ec2.VpcEndpoint("example",
            service_name=example.service_name,
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type=example.service_type,
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var current = Aws.GetCallerIdentity.Invoke();

            var example = new Aws.Ec2.VpcEndpointService("example", new()
            {
                AcceptanceRequired = false,
                AllowedPrincipals = new[]
                {
                    current.Apply(getCallerIdentityResult => getCallerIdentityResult.Arn),
                },
                GatewayLoadBalancerArns = new[]
                {
                    exampleAwsLb.Arn,
                },
            });

            var exampleVpcEndpoint = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ServiceName = example.ServiceName,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = example.ServiceType,
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		current, err := aws.GetCallerIdentity(ctx, &aws.GetCallerIdentityArgs{}, nil)
        		if err != nil {
        			return err
        		}
        		example, err := ec2.NewVpcEndpointService(ctx, "example", &ec2.VpcEndpointServiceArgs{
        			AcceptanceRequired: pulumi.Bool(false),
        			AllowedPrincipals: pulumi.StringArray{
        				pulumi.String(current.Arn),
        			},
        			GatewayLoadBalancerArns: pulumi.StringArray{
        				exampleAwsLb.Arn,
        			},
        		})
        		if err != nil {
        			return err
        		}
        		_, err = ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ServiceName: example.ServiceName,
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: example.ServiceType,
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.AwsFunctions;
        import com.pulumi.aws.inputs.GetCallerIdentityArgs;
        import com.pulumi.aws.ec2.VpcEndpointService;
        import com.pulumi.aws.ec2.VpcEndpointServiceArgs;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                final var current = AwsFunctions.getCallerIdentity(GetCallerIdentityArgs.builder()
                    .build());

                var example = new VpcEndpointService("example", VpcEndpointServiceArgs.builder()
                    .acceptanceRequired(false)
                    .allowedPrincipals(current.arn())
                    .gatewayLoadBalancerArns(exampleAwsLb.arn())
                    .build());

                var exampleVpcEndpoint = new VpcEndpoint("exampleVpcEndpoint", VpcEndpointArgs.builder()
                    .serviceName(example.serviceName())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType(example.serviceType())
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpointService
            properties:
              acceptanceRequired: false
              allowedPrincipals:
                - ${current.arn}
              gatewayLoadBalancerArns:
                - ${exampleAwsLb.arn}
          exampleVpcEndpoint:
            type: aws:ec2:VpcEndpoint
            name: example
            properties:
              serviceName: ${example.serviceName}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: ${example.serviceType}
              vpcId: ${exampleAwsVpc.id}
        variables:
          current:
            fn::invoke:
              function: aws:getCallerIdentity
              arguments: {}
        ```
        <!--End PulumiCodeChooser -->

        ### VPC Lattice Resource Configuration Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.ec2.VpcEndpoint("example", {
            resourceConfigurationArn: exampleAwsVpclatticeResourceConfiguration.arn,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: "Resource",
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcEndpoint("example",
            resource_configuration_arn=example_aws_vpclattice_resource_configuration["arn"],
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type="Resource",
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ResourceConfigurationArn = exampleAwsVpclatticeResourceConfiguration.Arn,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = "Resource",
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ResourceConfigurationArn: pulumi.Any(exampleAwsVpclatticeResourceConfiguration.Arn),
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: pulumi.String("Resource"),
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new VpcEndpoint("example", VpcEndpointArgs.builder()
                    .resourceConfigurationArn(exampleAwsVpclatticeResourceConfiguration.arn())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType("Resource")
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpoint
            properties:
              resourceConfigurationArn: ${exampleAwsVpclatticeResourceConfiguration.arn}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: Resource
              vpcId: ${exampleAwsVpc.id}
        ```
        <!--End PulumiCodeChooser -->

        ### VPC Lattice Service Network Endpoint Type

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.ec2.VpcEndpoint("example", {
            serviceNetworkArn: exampleAwsVpclatticeServiceNetwork.arn,
            subnetIds: [exampleAwsSubnet.id],
            vpcEndpointType: "ServiceNetwork",
            vpcId: exampleAwsVpc.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.ec2.VpcEndpoint("example",
            service_network_arn=example_aws_vpclattice_service_network["arn"],
            subnet_ids=[example_aws_subnet["id"]],
            vpc_endpoint_type="ServiceNetwork",
            vpc_id=example_aws_vpc["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.Ec2.VpcEndpoint("example", new()
            {
                ServiceNetworkArn = exampleAwsVpclatticeServiceNetwork.Arn,
                SubnetIds = new[]
                {
                    exampleAwsSubnet.Id,
                },
                VpcEndpointType = "ServiceNetwork",
                VpcId = exampleAwsVpc.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := ec2.NewVpcEndpoint(ctx, "example", &ec2.VpcEndpointArgs{
        			ServiceNetworkArn: pulumi.Any(exampleAwsVpclatticeServiceNetwork.Arn),
        			SubnetIds: pulumi.StringArray{
        				exampleAwsSubnet.Id,
        			},
        			VpcEndpointType: pulumi.String("ServiceNetwork"),
        			VpcId:           pulumi.Any(exampleAwsVpc.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.VpcEndpoint;
        import com.pulumi.aws.ec2.VpcEndpointArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new VpcEndpoint("example", VpcEndpointArgs.builder()
                    .serviceNetworkArn(exampleAwsVpclatticeServiceNetwork.arn())
                    .subnetIds(exampleAwsSubnet.id())
                    .vpcEndpointType("ServiceNetwork")
                    .vpcId(exampleAwsVpc.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:ec2:VpcEndpoint
            properties:
              serviceNetworkArn: ${exampleAwsVpclatticeServiceNetwork.arn}
              subnetIds:
                - ${exampleAwsSubnet.id}
              vpcEndpointType: ServiceNetwork
              vpcId: ${exampleAwsVpc.id}
        ```
        <!--End PulumiCodeChooser -->


        :param _builtins.str service_name: The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
        :param _builtins.bool auto_accept: Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
        :param pulumi.Input['pulumi_aws.ec2.VpcEndpointDnsOptionsArgs'] dns_options: The DNS options for the endpoint. See<span pulumi-lang-nodejs=" dnsOptions " pulumi-lang-dotnet=" DnsOptions " pulumi-lang-go=" dnsOptions " pulumi-lang-python=" dns_options " pulumi-lang-yaml=" dnsOptions " pulumi-lang-java=" dnsOptions "> dns_options </span>below.
        :param pulumi.Input[_builtins.str] ip_address_type: The IP address type for the endpoint. Valid values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span>, <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span>, and <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        :param pulumi.Input[_builtins.str] policy: A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
        :param _builtins.bool private_dns_enabled: Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type Interface. Defaults to `false`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_configuration_arn: The ARN of a Resource Configuration to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] route_table_ids: One or more route table IDs. Applicable for endpoints of type `Gateway`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
               If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
        :param pulumi.Input[_builtins.str] service_network_arn: The ARN of a Service Network to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        :param pulumi.Input[_builtins.str] service_region: The AWS region of the VPC Endpoint Service. If specified, the VPC endpoint will connect to the service in the provided region. Applicable for endpoints of type `Interface`.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.VpcEndpointSubnetConfigurationArgs']]] subnet_configurations: Subnet configuration for the endpoint, used to select specific IPv4 and/or IPv6 addresses to the endpoint. See<span pulumi-lang-nodejs=" subnetConfiguration " pulumi-lang-dotnet=" SubnetConfiguration " pulumi-lang-go=" subnetConfiguration " pulumi-lang-python=" subnet_configuration " pulumi-lang-yaml=" subnetConfiguration " pulumi-lang-java=" subnetConfiguration "> subnet_configuration </span>below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] vpc_endpoint_type: The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`,`Interface`, `Resource` or `ServiceNetwork`. Defaults to `Gateway`.
        """
        pulumi.set(__self__, "service_name", service_name)
        if auto_accept is not None:
            pulumi.set(__self__, "auto_accept", auto_accept)
        if dns_options is not None:
            pulumi.set(__self__, "dns_options", dns_options)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if private_dns_enabled is not None:
            pulumi.set(__self__, "private_dns_enabled", private_dns_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_configuration_arn is not None:
            pulumi.set(__self__, "resource_configuration_arn", resource_configuration_arn)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_network_arn is not None:
            pulumi.set(__self__, "service_network_arn", service_network_arn)
        if service_region is not None:
            pulumi.set(__self__, "service_region", service_region)
        if subnet_configurations is not None:
            pulumi.set(__self__, "subnet_configurations", subnet_configurations)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_type is not None:
            pulumi.set(__self__, "vpc_endpoint_type", vpc_endpoint_type)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The service name. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: _builtins.str):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="autoAccept")
    def auto_accept(self) -> Optional[_builtins.bool]:
        """
        Accept the VPC endpoint (the VPC endpoint and service need to be in the same AWS account).
        """
        return pulumi.get(self, "auto_accept")

    @auto_accept.setter
    def auto_accept(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "auto_accept", value)

    @_builtins.property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Optional[pulumi.Input['pulumi_aws.ec2.VpcEndpointDnsOptionsArgs']]:
        """
        The DNS options for the endpoint. See<span pulumi-lang-nodejs=" dnsOptions " pulumi-lang-dotnet=" DnsOptions " pulumi-lang-go=" dnsOptions " pulumi-lang-python=" dns_options " pulumi-lang-yaml=" dnsOptions " pulumi-lang-java=" dnsOptions "> dns_options </span>below.
        """
        return pulumi.get(self, "dns_options")

    @dns_options.setter
    def dns_options(self, value: Optional[pulumi.Input['pulumi_aws.ec2.VpcEndpointDnsOptionsArgs']]):
        pulumi.set(self, "dns_options", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address type for the endpoint. Valid values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span>, <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span>, and <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A policy to attach to the endpoint that controls access to the service. This is a JSON formatted string. Defaults to full access. All `Gateway` and some `Interface` endpoints support policies - see the [relevant AWS documentation](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints-access.html) for more details.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether or not to associate a private hosted zone with the specified VPC. Applicable for endpoints of type Interface. Defaults to `false`.
        """
        return pulumi.get(self, "private_dns_enabled")

    @private_dns_enabled.setter
    def private_dns_enabled(self, value: Optional[_builtins.bool]):
        pulumi.set(self, "private_dns_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationArn")
    def resource_configuration_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of a Resource Configuration to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        """
        return pulumi.get(self, "resource_configuration_arn")

    @resource_configuration_arn.setter
    def resource_configuration_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_configuration_arn", value)

    @_builtins.property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more route table IDs. Applicable for endpoints of type `Gateway`.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of one or more security groups to associate with the network interface. Applicable for endpoints of type `Interface`.
        If no security groups are specified, the VPC's [default security group](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#DefaultSecurityGroup) is associated with the endpoint.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of a Service Network to connect this VPC Endpoint to. Exactly one of <span pulumi-lang-nodejs="`resourceConfigurationArn`" pulumi-lang-dotnet="`ResourceConfigurationArn`" pulumi-lang-go="`resourceConfigurationArn`" pulumi-lang-python="`resource_configuration_arn`" pulumi-lang-yaml="`resourceConfigurationArn`" pulumi-lang-java="`resourceConfigurationArn`">`resource_configuration_arn`</span>, <span pulumi-lang-nodejs="`serviceName`" pulumi-lang-dotnet="`ServiceName`" pulumi-lang-go="`serviceName`" pulumi-lang-python="`service_name`" pulumi-lang-yaml="`serviceName`" pulumi-lang-java="`serviceName`">`service_name`</span> or <span pulumi-lang-nodejs="`serviceNetworkArn`" pulumi-lang-dotnet="`ServiceNetworkArn`" pulumi-lang-go="`serviceNetworkArn`" pulumi-lang-python="`service_network_arn`" pulumi-lang-yaml="`serviceNetworkArn`" pulumi-lang-java="`serviceNetworkArn`">`service_network_arn`</span> is required.
        """
        return pulumi.get(self, "service_network_arn")

    @service_network_arn.setter
    def service_network_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_network_arn", value)

    @_builtins.property
    @pulumi.getter(name="serviceRegion")
    def service_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region of the VPC Endpoint Service. If specified, the VPC endpoint will connect to the service in the provided region. Applicable for endpoints of type `Interface`.
        """
        return pulumi.get(self, "service_region")

    @service_region.setter
    def service_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_region", value)

    @_builtins.property
    @pulumi.getter(name="subnetConfigurations")
    def subnet_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.VpcEndpointSubnetConfigurationArgs']]]]:
        """
        Subnet configuration for the endpoint, used to select specific IPv4 and/or IPv6 addresses to the endpoint. See<span pulumi-lang-nodejs=" subnetConfiguration " pulumi-lang-dotnet=" SubnetConfiguration " pulumi-lang-go=" subnetConfiguration " pulumi-lang-python=" subnet_configuration " pulumi-lang-yaml=" subnetConfiguration " pulumi-lang-java=" subnetConfiguration "> subnet_configuration </span>below.
        """
        return pulumi.get(self, "subnet_configurations")

    @subnet_configurations.setter
    def subnet_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.VpcEndpointSubnetConfigurationArgs']]]]):
        pulumi.set(self, "subnet_configurations", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The ID of one or more subnets in which to create a network interface for the endpoint. Applicable for endpoints of type `GatewayLoadBalancer` and `Interface`. Interface type endpoints cannot function without being assigned to a subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointType")
    def vpc_endpoint_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC endpoint type, `Gateway`, `GatewayLoadBalancer`,`Interface`, `Resource` or `ServiceNetwork`. Defaults to `Gateway`.
        """
        return pulumi.get(self, "vpc_endpoint_type")

    @vpc_endpoint_type.setter
    def vpc_endpoint_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_endpoint_type", value)


