# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ResolvedSubnetSpec',
]

@pulumi.output_type
class ResolvedSubnetSpec(dict):
    """
    Configuration for a VPC subnet spec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlocks":
            suggest = "cidr_blocks"
        elif key == "cidrMask":
            suggest = "cidr_mask"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolvedSubnetSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolvedSubnetSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolvedSubnetSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'SubnetType',
                 cidr_blocks: Optional[Sequence[_builtins.str]] = None,
                 cidr_mask: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        Configuration for a VPC subnet spec.
        :param 'SubnetType' type: The type of subnet.
        :param Sequence[_builtins.str] cidr_blocks: An optional list of CIDR blocks to assign to the subnet spec for each AZ. If specified, the count must match the number of AZs being used for the VPC, and must also be specified for all other subnet specs.
        :param _builtins.int cidr_mask: The netmask for the subnet's CIDR block. This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        :param _builtins.str name: The subnet's name. Will be templated upon creation.
        :param _builtins.int size: Optional size of the subnet's CIDR block - the number of hosts. This value must be a power of 2 (e.g. 256, 512, 1024, etc.). This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        pulumi.set(__self__, "type", type)
        if cidr_blocks is not None:
            pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        if cidr_mask is not None:
            pulumi.set(__self__, "cidr_mask", cidr_mask)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter
    def type(self) -> 'SubnetType':
        """
        The type of subnet.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Optional[Sequence[_builtins.str]]:
        """
        An optional list of CIDR blocks to assign to the subnet spec for each AZ. If specified, the count must match the number of AZs being used for the VPC, and must also be specified for all other subnet specs.
        """
        return pulumi.get(self, "cidr_blocks")

    @_builtins.property
    @pulumi.getter(name="cidrMask")
    def cidr_mask(self) -> Optional[_builtins.int]:
        """
        The netmask for the subnet's CIDR block. This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        return pulumi.get(self, "cidr_mask")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The subnet's name. Will be templated upon creation.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Optional size of the subnet's CIDR block - the number of hosts. This value must be a power of 2 (e.g. 256, 512, 1024, etc.). This is optional, the default value is inferred from the `cidrMask`, `cidrBlocks` or based on an even distribution of available space from the VPC's CIDR block after being divided evenly by availability zone.
        """
        return pulumi.get(self, "size")


