# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *
import pulumi_aws

__all__ = ['VpcArgs', 'Vpc']

@pulumi.input_type
class VpcArgs:
    def __init__(__self__, *,
                 assign_generated_ipv6_cidr_block: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_cidr_mask: Optional[_builtins.int] = None,
                 availability_zone_names: Optional[Sequence[_builtins.str]] = None,
                 cidr_block: Optional[_builtins.str] = None,
                 enable_dns_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dns_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_network_address_usage_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block_network_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 nat_gateways: Optional['NatGatewayConfigurationArgs'] = None,
                 number_of_availability_zones: Optional[_builtins.int] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_specs: Optional[Sequence['SubnetSpecArgs']] = None,
                 subnet_strategy: Optional['SubnetAllocationStrategy'] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_endpoint_specs: Optional[Sequence['VpcEndpointSpecArgs']] = None):
        """
        The set of arguments for constructing a Vpc resource.
        :param pulumi.Input[_builtins.bool] assign_generated_ipv6_cidr_block: Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>. Conflicts with <span pulumi-lang-nodejs="`ipv6IpamPoolId`" pulumi-lang-dotnet="`Ipv6IpamPoolId`" pulumi-lang-go="`ipv6IpamPoolId`" pulumi-lang-python="`ipv6_ipam_pool_id`" pulumi-lang-yaml="`ipv6IpamPoolId`" pulumi-lang-java="`ipv6IpamPoolId`">`ipv6_ipam_pool_id`</span>
        :param _builtins.int availability_zone_cidr_mask: The netmask for each available zone to be aligned to. This is optional, the default value is inferred based on an even distribution of available space from the VPC's CIDR block after being divided evenly by the number of availability zones.
        :param Sequence[_builtins.str] availability_zone_names: A list of availability zone names to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        :param _builtins.str cidr_block: The CIDR block for the VPC. Optional. Defaults to 10.0.0.0/16.
        :param pulumi.Input[_builtins.bool] enable_dns_hostnames: A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
        :param pulumi.Input[_builtins.bool] enable_dns_support: A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
        :param pulumi.Input[_builtins.bool] enable_network_address_usage_metrics: Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
        :param pulumi.Input[_builtins.str] instance_tenancy: A tenancy option for instances launched into the VPC. Default is <span pulumi-lang-nodejs="`default`" pulumi-lang-dotnet="`Default`" pulumi-lang-go="`default`" pulumi-lang-python="`default`" pulumi-lang-yaml="`default`" pulumi-lang-java="`default`">`default`</span>, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is <span pulumi-lang-nodejs="`dedicated`" pulumi-lang-dotnet="`Dedicated`" pulumi-lang-go="`dedicated`" pulumi-lang-python="`dedicated`" pulumi-lang-yaml="`dedicated`" pulumi-lang-java="`dedicated`">`dedicated`</span>, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
        :param pulumi.Input[_builtins.int] ipv4_netmask_length: The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a <span pulumi-lang-nodejs="`ipv4IpamPoolId`" pulumi-lang-dotnet="`Ipv4IpamPoolId`" pulumi-lang-go="`ipv4IpamPoolId`" pulumi-lang-python="`ipv4_ipam_pool_id`" pulumi-lang-yaml="`ipv4IpamPoolId`" pulumi-lang-java="`ipv4IpamPoolId`">`ipv4_ipam_pool_id`</span>.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using <span pulumi-lang-nodejs="`ipv6NetmaskLength`" pulumi-lang-dotnet="`Ipv6NetmaskLength`" pulumi-lang-go="`ipv6NetmaskLength`" pulumi-lang-python="`ipv6_netmask_length`" pulumi-lang-yaml="`ipv6NetmaskLength`" pulumi-lang-java="`ipv6NetmaskLength`">`ipv6_netmask_length`</span>.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block_network_border_group: By default when an IPv6 CIDR is assigned to a VPC a default<span pulumi-lang-nodejs=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-dotnet=" Ipv6CidrBlockNetworkBorderGroup " pulumi-lang-go=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-python=" ipv6_cidr_block_network_border_group " pulumi-lang-yaml=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-java=" ipv6CidrBlockNetworkBorderGroup "> ipv6_cidr_block_network_border_group </span>will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
        :param pulumi.Input[_builtins.str] ipv6_ipam_pool_id: IPAM Pool ID for a IPv6 pool. Conflicts with <span pulumi-lang-nodejs="`assignGeneratedIpv6CidrBlock`" pulumi-lang-dotnet="`AssignGeneratedIpv6CidrBlock`" pulumi-lang-go="`assignGeneratedIpv6CidrBlock`" pulumi-lang-python="`assign_generated_ipv6_cidr_block`" pulumi-lang-yaml="`assignGeneratedIpv6CidrBlock`" pulumi-lang-java="`assignGeneratedIpv6CidrBlock`">`assign_generated_ipv6_cidr_block`</span>.
        :param pulumi.Input[_builtins.int] ipv6_netmask_length: Netmask length to request from IPAM Pool. Conflicts with <span pulumi-lang-nodejs="`ipv6CidrBlock`" pulumi-lang-dotnet="`Ipv6CidrBlock`" pulumi-lang-go="`ipv6CidrBlock`" pulumi-lang-python="`ipv6_cidr_block`" pulumi-lang-yaml="`ipv6CidrBlock`" pulumi-lang-java="`ipv6CidrBlock`">`ipv6_cidr_block`</span>. This can be omitted if IPAM pool as a <span pulumi-lang-nodejs="`allocationDefaultNetmaskLength`" pulumi-lang-dotnet="`AllocationDefaultNetmaskLength`" pulumi-lang-go="`allocationDefaultNetmaskLength`" pulumi-lang-python="`allocation_default_netmask_length`" pulumi-lang-yaml="`allocationDefaultNetmaskLength`" pulumi-lang-java="`allocationDefaultNetmaskLength`">`allocation_default_netmask_length`</span> set. Valid values are from <span pulumi-lang-nodejs="`44`" pulumi-lang-dotnet="`44`" pulumi-lang-go="`44`" pulumi-lang-python="`44`" pulumi-lang-yaml="`44`" pulumi-lang-java="`44`">`44`</span> to <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> in increments of 4.
        :param 'NatGatewayConfigurationArgs' nat_gateways: Configuration for NAT Gateways. Optional. If private and public subnets are both specified, defaults to one gateway per availability zone. Otherwise, no gateways will be created.
        :param _builtins.int number_of_availability_zones: A number of availability zones to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param Sequence['SubnetSpecArgs'] subnet_specs: A list of subnet specs that should be deployed to each AZ specified in availabilityZoneNames. Optional. Defaults to a (smaller) public subnet and a (larger) private subnet based on the size of the CIDR block for the VPC. Private subnets are allocated CIDR block ranges first, followed by Public subnets, and Isolated subnets are allocated last.
        :param 'SubnetAllocationStrategy' subnet_strategy: The strategy to use when allocating subnets for the VPC. Optional. Defaults to `Legacy`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param Sequence['VpcEndpointSpecArgs'] vpc_endpoint_specs: A list of VPC Endpoints specs to be deployed as part of the VPC
        """
        if assign_generated_ipv6_cidr_block is not None:
            pulumi.set(__self__, "assign_generated_ipv6_cidr_block", assign_generated_ipv6_cidr_block)
        if availability_zone_cidr_mask is not None:
            pulumi.set(__self__, "availability_zone_cidr_mask", availability_zone_cidr_mask)
        if availability_zone_names is not None:
            pulumi.set(__self__, "availability_zone_names", availability_zone_names)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if enable_dns_hostnames is not None:
            pulumi.set(__self__, "enable_dns_hostnames", enable_dns_hostnames)
        if enable_dns_support is not None:
            pulumi.set(__self__, "enable_dns_support", enable_dns_support)
        if enable_network_address_usage_metrics is not None:
            pulumi.set(__self__, "enable_network_address_usage_metrics", enable_network_address_usage_metrics)
        if instance_tenancy is not None:
            pulumi.set(__self__, "instance_tenancy", instance_tenancy)
        if ipv4_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if ipv4_netmask_length is not None:
            pulumi.set(__self__, "ipv4_netmask_length", ipv4_netmask_length)
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_cidr_block_network_border_group is not None:
            pulumi.set(__self__, "ipv6_cidr_block_network_border_group", ipv6_cidr_block_network_border_group)
        if ipv6_ipam_pool_id is not None:
            pulumi.set(__self__, "ipv6_ipam_pool_id", ipv6_ipam_pool_id)
        if ipv6_netmask_length is not None:
            pulumi.set(__self__, "ipv6_netmask_length", ipv6_netmask_length)
        if nat_gateways is not None:
            pulumi.set(__self__, "nat_gateways", nat_gateways)
        if number_of_availability_zones is not None:
            pulumi.set(__self__, "number_of_availability_zones", number_of_availability_zones)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_specs is not None:
            pulumi.set(__self__, "subnet_specs", subnet_specs)
        if subnet_strategy is not None:
            pulumi.set(__self__, "subnet_strategy", subnet_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_specs is not None:
            pulumi.set(__self__, "vpc_endpoint_specs", vpc_endpoint_specs)

    @_builtins.property
    @pulumi.getter(name="assignGeneratedIpv6CidrBlock")
    def assign_generated_ipv6_cidr_block(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>. Conflicts with <span pulumi-lang-nodejs="`ipv6IpamPoolId`" pulumi-lang-dotnet="`Ipv6IpamPoolId`" pulumi-lang-go="`ipv6IpamPoolId`" pulumi-lang-python="`ipv6_ipam_pool_id`" pulumi-lang-yaml="`ipv6IpamPoolId`" pulumi-lang-java="`ipv6IpamPoolId`">`ipv6_ipam_pool_id`</span>
        """
        return pulumi.get(self, "assign_generated_ipv6_cidr_block")

    @assign_generated_ipv6_cidr_block.setter
    def assign_generated_ipv6_cidr_block(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assign_generated_ipv6_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneCidrMask")
    def availability_zone_cidr_mask(self) -> Optional[_builtins.int]:
        """
        The netmask for each available zone to be aligned to. This is optional, the default value is inferred based on an even distribution of available space from the VPC's CIDR block after being divided evenly by the number of availability zones.
        """
        return pulumi.get(self, "availability_zone_cidr_mask")

    @availability_zone_cidr_mask.setter
    def availability_zone_cidr_mask(self, value: Optional[_builtins.int]):
        pulumi.set(self, "availability_zone_cidr_mask", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZoneNames")
    def availability_zone_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of availability zone names to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        """
        return pulumi.get(self, "availability_zone_names")

    @availability_zone_names.setter
    def availability_zone_names(self, value: Optional[Sequence[_builtins.str]]):
        pulumi.set(self, "availability_zone_names", value)

    @_builtins.property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[_builtins.str]:
        """
        The CIDR block for the VPC. Optional. Defaults to 10.0.0.0/16.
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[_builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="enableDnsHostnames")
    def enable_dns_hostnames(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
        """
        return pulumi.get(self, "enable_dns_hostnames")

    @enable_dns_hostnames.setter
    def enable_dns_hostnames(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dns_hostnames", value)

    @_builtins.property
    @pulumi.getter(name="enableDnsSupport")
    def enable_dns_support(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
        """
        return pulumi.get(self, "enable_dns_support")

    @enable_dns_support.setter
    def enable_dns_support(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_dns_support", value)

    @_builtins.property
    @pulumi.getter(name="enableNetworkAddressUsageMetrics")
    def enable_network_address_usage_metrics(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
        """
        return pulumi.get(self, "enable_network_address_usage_metrics")

    @enable_network_address_usage_metrics.setter
    def enable_network_address_usage_metrics(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_network_address_usage_metrics", value)

    @_builtins.property
    @pulumi.getter(name="instanceTenancy")
    def instance_tenancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A tenancy option for instances launched into the VPC. Default is <span pulumi-lang-nodejs="`default`" pulumi-lang-dotnet="`Default`" pulumi-lang-go="`default`" pulumi-lang-python="`default`" pulumi-lang-yaml="`default`" pulumi-lang-java="`default`">`default`</span>, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is <span pulumi-lang-nodejs="`dedicated`" pulumi-lang-dotnet="`Dedicated`" pulumi-lang-go="`dedicated`" pulumi-lang-python="`dedicated`" pulumi-lang-yaml="`dedicated`" pulumi-lang-java="`dedicated`">`dedicated`</span>, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
        """
        return pulumi.get(self, "instance_tenancy")

    @instance_tenancy.setter
    def instance_tenancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_tenancy", value)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @ipv4_ipam_pool_id.setter
    def ipv4_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4NetmaskLength")
    def ipv4_netmask_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a <span pulumi-lang-nodejs="`ipv4IpamPoolId`" pulumi-lang-dotnet="`Ipv4IpamPoolId`" pulumi-lang-go="`ipv4IpamPoolId`" pulumi-lang-python="`ipv4_ipam_pool_id`" pulumi-lang-yaml="`ipv4IpamPoolId`" pulumi-lang-java="`ipv4IpamPoolId`">`ipv4_ipam_pool_id`</span>.
        """
        return pulumi.get(self, "ipv4_netmask_length")

    @ipv4_netmask_length.setter
    def ipv4_netmask_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv4_netmask_length", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using <span pulumi-lang-nodejs="`ipv6NetmaskLength`" pulumi-lang-dotnet="`Ipv6NetmaskLength`" pulumi-lang-go="`ipv6NetmaskLength`" pulumi-lang-python="`ipv6_netmask_length`" pulumi-lang-yaml="`ipv6NetmaskLength`" pulumi-lang-java="`ipv6NetmaskLength`">`ipv6_netmask_length`</span>.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @_builtins.property
    @pulumi.getter(name="ipv6CidrBlockNetworkBorderGroup")
    def ipv6_cidr_block_network_border_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        By default when an IPv6 CIDR is assigned to a VPC a default<span pulumi-lang-nodejs=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-dotnet=" Ipv6CidrBlockNetworkBorderGroup " pulumi-lang-go=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-python=" ipv6_cidr_block_network_border_group " pulumi-lang-yaml=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-java=" ipv6CidrBlockNetworkBorderGroup "> ipv6_cidr_block_network_border_group </span>will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
        """
        return pulumi.get(self, "ipv6_cidr_block_network_border_group")

    @ipv6_cidr_block_network_border_group.setter
    def ipv6_cidr_block_network_border_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_cidr_block_network_border_group", value)

    @_builtins.property
    @pulumi.getter(name="ipv6IpamPoolId")
    def ipv6_ipam_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPAM Pool ID for a IPv6 pool. Conflicts with <span pulumi-lang-nodejs="`assignGeneratedIpv6CidrBlock`" pulumi-lang-dotnet="`AssignGeneratedIpv6CidrBlock`" pulumi-lang-go="`assignGeneratedIpv6CidrBlock`" pulumi-lang-python="`assign_generated_ipv6_cidr_block`" pulumi-lang-yaml="`assignGeneratedIpv6CidrBlock`" pulumi-lang-java="`assignGeneratedIpv6CidrBlock`">`assign_generated_ipv6_cidr_block`</span>.
        """
        return pulumi.get(self, "ipv6_ipam_pool_id")

    @ipv6_ipam_pool_id.setter
    def ipv6_ipam_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_ipam_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6NetmaskLength")
    def ipv6_netmask_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Netmask length to request from IPAM Pool. Conflicts with <span pulumi-lang-nodejs="`ipv6CidrBlock`" pulumi-lang-dotnet="`Ipv6CidrBlock`" pulumi-lang-go="`ipv6CidrBlock`" pulumi-lang-python="`ipv6_cidr_block`" pulumi-lang-yaml="`ipv6CidrBlock`" pulumi-lang-java="`ipv6CidrBlock`">`ipv6_cidr_block`</span>. This can be omitted if IPAM pool as a <span pulumi-lang-nodejs="`allocationDefaultNetmaskLength`" pulumi-lang-dotnet="`AllocationDefaultNetmaskLength`" pulumi-lang-go="`allocationDefaultNetmaskLength`" pulumi-lang-python="`allocation_default_netmask_length`" pulumi-lang-yaml="`allocationDefaultNetmaskLength`" pulumi-lang-java="`allocationDefaultNetmaskLength`">`allocation_default_netmask_length`</span> set. Valid values are from <span pulumi-lang-nodejs="`44`" pulumi-lang-dotnet="`44`" pulumi-lang-go="`44`" pulumi-lang-python="`44`" pulumi-lang-yaml="`44`" pulumi-lang-java="`44`">`44`</span> to <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> in increments of 4.
        """
        return pulumi.get(self, "ipv6_netmask_length")

    @ipv6_netmask_length.setter
    def ipv6_netmask_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_netmask_length", value)

    @_builtins.property
    @pulumi.getter(name="natGateways")
    def nat_gateways(self) -> Optional['NatGatewayConfigurationArgs']:
        """
        Configuration for NAT Gateways. Optional. If private and public subnets are both specified, defaults to one gateway per availability zone. Otherwise, no gateways will be created.
        """
        return pulumi.get(self, "nat_gateways")

    @nat_gateways.setter
    def nat_gateways(self, value: Optional['NatGatewayConfigurationArgs']):
        pulumi.set(self, "nat_gateways", value)

    @_builtins.property
    @pulumi.getter(name="numberOfAvailabilityZones")
    def number_of_availability_zones(self) -> Optional[_builtins.int]:
        """
        A number of availability zones to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        """
        return pulumi.get(self, "number_of_availability_zones")

    @number_of_availability_zones.setter
    def number_of_availability_zones(self, value: Optional[_builtins.int]):
        pulumi.set(self, "number_of_availability_zones", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetSpecs")
    def subnet_specs(self) -> Optional[Sequence['SubnetSpecArgs']]:
        """
        A list of subnet specs that should be deployed to each AZ specified in availabilityZoneNames. Optional. Defaults to a (smaller) public subnet and a (larger) private subnet based on the size of the CIDR block for the VPC. Private subnets are allocated CIDR block ranges first, followed by Public subnets, and Isolated subnets are allocated last.
        """
        return pulumi.get(self, "subnet_specs")

    @subnet_specs.setter
    def subnet_specs(self, value: Optional[Sequence['SubnetSpecArgs']]):
        pulumi.set(self, "subnet_specs", value)

    @_builtins.property
    @pulumi.getter(name="subnetStrategy")
    def subnet_strategy(self) -> Optional['SubnetAllocationStrategy']:
        """
        The strategy to use when allocating subnets for the VPC. Optional. Defaults to `Legacy`.
        """
        return pulumi.get(self, "subnet_strategy")

    @subnet_strategy.setter
    def subnet_strategy(self, value: Optional['SubnetAllocationStrategy']):
        pulumi.set(self, "subnet_strategy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcEndpointSpecs")
    def vpc_endpoint_specs(self) -> Optional[Sequence['VpcEndpointSpecArgs']]:
        """
        A list of VPC Endpoints specs to be deployed as part of the VPC
        """
        return pulumi.get(self, "vpc_endpoint_specs")

    @vpc_endpoint_specs.setter
    def vpc_endpoint_specs(self, value: Optional[Sequence['VpcEndpointSpecArgs']]):
        pulumi.set(self, "vpc_endpoint_specs", value)


@pulumi.type_token("awsx:ec2:Vpc")
class Vpc(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_generated_ipv6_cidr_block: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_cidr_mask: Optional[_builtins.int] = None,
                 availability_zone_names: Optional[Sequence[_builtins.str]] = None,
                 cidr_block: Optional[_builtins.str] = None,
                 enable_dns_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dns_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_network_address_usage_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block_network_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 nat_gateways: Optional[Union['NatGatewayConfigurationArgs', 'NatGatewayConfigurationArgsDict']] = None,
                 number_of_availability_zones: Optional[_builtins.int] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_specs: Optional[Sequence[Union['SubnetSpecArgs', 'SubnetSpecArgsDict']]] = None,
                 subnet_strategy: Optional['SubnetAllocationStrategy'] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_endpoint_specs: Optional[Sequence[Union['VpcEndpointSpecArgs', 'VpcEndpointSpecArgsDict']]] = None,
                 __props__=None):
        """
        The VPC component provides a VPC with configured subnets and NAT gateways.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_awsx as awsx

        vpc = awsx.ec2.Vpc("vpc")
        pulumi.export("vpcId", vpc.vpc_id)
        pulumi.export("vpcPrivateSubnetIds", vpc.private_subnet_ids)
        pulumi.export("vpcPublicSubnetIds", vpc.public_subnet_ids)
        ```

        ## Subnet Layout Strategies

        If no subnet arguments are passed, then a public and private subnet will be created in each AZ with default sizing. The layout of these subnets can be customised by specifying additional arguments.

        All strategies are designed to help build a uniform layout of subnets each each availability zone.

        If no strategy is specified, "Legacy" will be used for backward compatibility reasons. In the next major version this will change to defaulting to "Auto".

        ### Auto

        The "Auto" strategy divides the VPC space evenly between the availability zones. Within each availability zone it allocates each subnet in the order they were specified. If a CIDR mask or size was not specified it will default to an even division of the availability zone range. If subnets have different sizes, spaces will be automatically added to ensure subnets don't overlap (e.g. where a previous subnet is smaller than the next).

        ### Exact

        The "Exact" strategy is the same as "Auto" with the additional requirement to explicitly specify what the whole of each zone's range will be used for. Where you expect to have a gap between or after subnets, these must be passed using the subnet specification type "Unused" to show all space has been properly accounted for.

        ### Explicit CIDR Blocks

        If you prefer to do your CIDR block calculations yourself, you can specify a list of CIDR blocks for each subnet spec which it will be allocated for in each availability zone. If using explicit layouts, all subnet specs must be declared with explicit CIDR blocks. Each list of CIDR blocks must have the same length as the number of availability zones for the VPC.

        ### Legacy

        The "Legacy" works similarly to the "Auto" strategy except that within each availability zone it allocates the private subnet first, followed by the public subnets, and lastly the isolated subnets. The order of subnet specifications of the same type can be changed, but the ordering of private, public, isolated is not overridable. For more flexibility we recommend moving to the "Auto" strategy. The output property `subnetLayout` shows the configuration required if specifying the "Auto" strategy to maintain the current layout.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] assign_generated_ipv6_cidr_block: Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the CIDR block. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>. Conflicts with <span pulumi-lang-nodejs="`ipv6IpamPoolId`" pulumi-lang-dotnet="`Ipv6IpamPoolId`" pulumi-lang-go="`ipv6IpamPoolId`" pulumi-lang-python="`ipv6_ipam_pool_id`" pulumi-lang-yaml="`ipv6IpamPoolId`" pulumi-lang-java="`ipv6IpamPoolId`">`ipv6_ipam_pool_id`</span>
        :param _builtins.int availability_zone_cidr_mask: The netmask for each available zone to be aligned to. This is optional, the default value is inferred based on an even distribution of available space from the VPC's CIDR block after being divided evenly by the number of availability zones.
        :param Sequence[_builtins.str] availability_zone_names: A list of availability zone names to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        :param _builtins.str cidr_block: The CIDR block for the VPC. Optional. Defaults to 10.0.0.0/16.
        :param pulumi.Input[_builtins.bool] enable_dns_hostnames: A boolean flag to enable/disable DNS hostnames in the VPC. Defaults false.
        :param pulumi.Input[_builtins.bool] enable_dns_support: A boolean flag to enable/disable DNS support in the VPC. Defaults to true.
        :param pulumi.Input[_builtins.bool] enable_network_address_usage_metrics: Indicates whether Network Address Usage metrics are enabled for your VPC. Defaults to false.
        :param pulumi.Input[_builtins.str] instance_tenancy: A tenancy option for instances launched into the VPC. Default is <span pulumi-lang-nodejs="`default`" pulumi-lang-dotnet="`Default`" pulumi-lang-go="`default`" pulumi-lang-python="`default`" pulumi-lang-yaml="`default`" pulumi-lang-java="`default`">`default`</span>, which ensures that EC2 instances launched in this VPC use the EC2 instance tenancy attribute specified when the EC2 instance is launched. The only other option is <span pulumi-lang-nodejs="`dedicated`" pulumi-lang-dotnet="`Dedicated`" pulumi-lang-go="`dedicated`" pulumi-lang-python="`dedicated`" pulumi-lang-yaml="`dedicated`" pulumi-lang-java="`dedicated`">`dedicated`</span>, which ensures that EC2 instances launched in this VPC are run on dedicated tenancy instances regardless of the tenancy attribute specified at launch. This has a dedicated per region fee of $2 per hour, plus an hourly per instance usage fee.
        :param pulumi.Input[_builtins.str] ipv4_ipam_pool_id: The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across AWS Regions and accounts. Using IPAM you can monitor IP address usage throughout your AWS Organization.
        :param pulumi.Input[_builtins.int] ipv4_netmask_length: The netmask length of the IPv4 CIDR you want to allocate to this VPC. Requires specifying a <span pulumi-lang-nodejs="`ipv4IpamPoolId`" pulumi-lang-dotnet="`Ipv4IpamPoolId`" pulumi-lang-go="`ipv4IpamPoolId`" pulumi-lang-python="`ipv4_ipam_pool_id`" pulumi-lang-yaml="`ipv4IpamPoolId`" pulumi-lang-java="`ipv4IpamPoolId`">`ipv4_ipam_pool_id`</span>.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block: IPv6 CIDR block to request from an IPAM Pool. Can be set explicitly or derived from IPAM using <span pulumi-lang-nodejs="`ipv6NetmaskLength`" pulumi-lang-dotnet="`Ipv6NetmaskLength`" pulumi-lang-go="`ipv6NetmaskLength`" pulumi-lang-python="`ipv6_netmask_length`" pulumi-lang-yaml="`ipv6NetmaskLength`" pulumi-lang-java="`ipv6NetmaskLength`">`ipv6_netmask_length`</span>.
        :param pulumi.Input[_builtins.str] ipv6_cidr_block_network_border_group: By default when an IPv6 CIDR is assigned to a VPC a default<span pulumi-lang-nodejs=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-dotnet=" Ipv6CidrBlockNetworkBorderGroup " pulumi-lang-go=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-python=" ipv6_cidr_block_network_border_group " pulumi-lang-yaml=" ipv6CidrBlockNetworkBorderGroup " pulumi-lang-java=" ipv6CidrBlockNetworkBorderGroup "> ipv6_cidr_block_network_border_group </span>will be set to the region of the VPC. This can be changed to restrict advertisement of public addresses to specific Network Border Groups such as LocalZones.
        :param pulumi.Input[_builtins.str] ipv6_ipam_pool_id: IPAM Pool ID for a IPv6 pool. Conflicts with <span pulumi-lang-nodejs="`assignGeneratedIpv6CidrBlock`" pulumi-lang-dotnet="`AssignGeneratedIpv6CidrBlock`" pulumi-lang-go="`assignGeneratedIpv6CidrBlock`" pulumi-lang-python="`assign_generated_ipv6_cidr_block`" pulumi-lang-yaml="`assignGeneratedIpv6CidrBlock`" pulumi-lang-java="`assignGeneratedIpv6CidrBlock`">`assign_generated_ipv6_cidr_block`</span>.
        :param pulumi.Input[_builtins.int] ipv6_netmask_length: Netmask length to request from IPAM Pool. Conflicts with <span pulumi-lang-nodejs="`ipv6CidrBlock`" pulumi-lang-dotnet="`Ipv6CidrBlock`" pulumi-lang-go="`ipv6CidrBlock`" pulumi-lang-python="`ipv6_cidr_block`" pulumi-lang-yaml="`ipv6CidrBlock`" pulumi-lang-java="`ipv6CidrBlock`">`ipv6_cidr_block`</span>. This can be omitted if IPAM pool as a <span pulumi-lang-nodejs="`allocationDefaultNetmaskLength`" pulumi-lang-dotnet="`AllocationDefaultNetmaskLength`" pulumi-lang-go="`allocationDefaultNetmaskLength`" pulumi-lang-python="`allocation_default_netmask_length`" pulumi-lang-yaml="`allocationDefaultNetmaskLength`" pulumi-lang-java="`allocationDefaultNetmaskLength`">`allocation_default_netmask_length`</span> set. Valid values are from <span pulumi-lang-nodejs="`44`" pulumi-lang-dotnet="`44`" pulumi-lang-go="`44`" pulumi-lang-python="`44`" pulumi-lang-yaml="`44`" pulumi-lang-java="`44`">`44`</span> to <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> in increments of 4.
        :param Union['NatGatewayConfigurationArgs', 'NatGatewayConfigurationArgsDict'] nat_gateways: Configuration for NAT Gateways. Optional. If private and public subnets are both specified, defaults to one gateway per availability zone. Otherwise, no gateways will be created.
        :param _builtins.int number_of_availability_zones: A number of availability zones to which the subnets defined in subnetSpecs will be deployed. Optional, defaults to the first 3 AZs in the current region.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param Sequence[Union['SubnetSpecArgs', 'SubnetSpecArgsDict']] subnet_specs: A list of subnet specs that should be deployed to each AZ specified in availabilityZoneNames. Optional. Defaults to a (smaller) public subnet and a (larger) private subnet based on the size of the CIDR block for the VPC. Private subnets are allocated CIDR block ranges first, followed by Public subnets, and Isolated subnets are allocated last.
        :param 'SubnetAllocationStrategy' subnet_strategy: The strategy to use when allocating subnets for the VPC. Optional. Defaults to `Legacy`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param Sequence[Union['VpcEndpointSpecArgs', 'VpcEndpointSpecArgsDict']] vpc_endpoint_specs: A list of VPC Endpoints specs to be deployed as part of the VPC
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The VPC component provides a VPC with configured subnets and NAT gateways.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_awsx as awsx

        vpc = awsx.ec2.Vpc("vpc")
        pulumi.export("vpcId", vpc.vpc_id)
        pulumi.export("vpcPrivateSubnetIds", vpc.private_subnet_ids)
        pulumi.export("vpcPublicSubnetIds", vpc.public_subnet_ids)
        ```

        ## Subnet Layout Strategies

        If no subnet arguments are passed, then a public and private subnet will be created in each AZ with default sizing. The layout of these subnets can be customised by specifying additional arguments.

        All strategies are designed to help build a uniform layout of subnets each each availability zone.

        If no strategy is specified, "Legacy" will be used for backward compatibility reasons. In the next major version this will change to defaulting to "Auto".

        ### Auto

        The "Auto" strategy divides the VPC space evenly between the availability zones. Within each availability zone it allocates each subnet in the order they were specified. If a CIDR mask or size was not specified it will default to an even division of the availability zone range. If subnets have different sizes, spaces will be automatically added to ensure subnets don't overlap (e.g. where a previous subnet is smaller than the next).

        ### Exact

        The "Exact" strategy is the same as "Auto" with the additional requirement to explicitly specify what the whole of each zone's range will be used for. Where you expect to have a gap between or after subnets, these must be passed using the subnet specification type "Unused" to show all space has been properly accounted for.

        ### Explicit CIDR Blocks

        If you prefer to do your CIDR block calculations yourself, you can specify a list of CIDR blocks for each subnet spec which it will be allocated for in each availability zone. If using explicit layouts, all subnet specs must be declared with explicit CIDR blocks. Each list of CIDR blocks must have the same length as the number of availability zones for the VPC.

        ### Legacy

        The "Legacy" works similarly to the "Auto" strategy except that within each availability zone it allocates the private subnet first, followed by the public subnets, and lastly the isolated subnets. The order of subnet specifications of the same type can be changed, but the ordering of private, public, isolated is not overridable. For more flexibility we recommend moving to the "Auto" strategy. The output property `subnetLayout` shows the configuration required if specifying the "Auto" strategy to maintain the current layout.

        :param str resource_name: The name of the resource.
        :param VpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_generated_ipv6_cidr_block: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zone_cidr_mask: Optional[_builtins.int] = None,
                 availability_zone_names: Optional[Sequence[_builtins.str]] = None,
                 cidr_block: Optional[_builtins.str] = None,
                 enable_dns_hostnames: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_dns_support: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_network_address_usage_metrics: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_tenancy: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_cidr_block: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_cidr_block_network_border_group: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_ipam_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_netmask_length: Optional[pulumi.Input[_builtins.int]] = None,
                 nat_gateways: Optional[Union['NatGatewayConfigurationArgs', 'NatGatewayConfigurationArgsDict']] = None,
                 number_of_availability_zones: Optional[_builtins.int] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_specs: Optional[Sequence[Union['SubnetSpecArgs', 'SubnetSpecArgsDict']]] = None,
                 subnet_strategy: Optional['SubnetAllocationStrategy'] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_endpoint_specs: Optional[Sequence[Union['VpcEndpointSpecArgs', 'VpcEndpointSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcArgs.__new__(VpcArgs)

            __props__.__dict__["assign_generated_ipv6_cidr_block"] = assign_generated_ipv6_cidr_block
            __props__.__dict__["availability_zone_cidr_mask"] = availability_zone_cidr_mask
            __props__.__dict__["availability_zone_names"] = availability_zone_names
            __props__.__dict__["cidr_block"] = cidr_block
            __props__.__dict__["enable_dns_hostnames"] = enable_dns_hostnames
            __props__.__dict__["enable_dns_support"] = enable_dns_support
            __props__.__dict__["enable_network_address_usage_metrics"] = enable_network_address_usage_metrics
            __props__.__dict__["instance_tenancy"] = instance_tenancy
            __props__.__dict__["ipv4_ipam_pool_id"] = ipv4_ipam_pool_id
            __props__.__dict__["ipv4_netmask_length"] = ipv4_netmask_length
            __props__.__dict__["ipv6_cidr_block"] = ipv6_cidr_block
            __props__.__dict__["ipv6_cidr_block_network_border_group"] = ipv6_cidr_block_network_border_group
            __props__.__dict__["ipv6_ipam_pool_id"] = ipv6_ipam_pool_id
            __props__.__dict__["ipv6_netmask_length"] = ipv6_netmask_length
            __props__.__dict__["nat_gateways"] = nat_gateways
            __props__.__dict__["number_of_availability_zones"] = number_of_availability_zones
            __props__.__dict__["region"] = region
            __props__.__dict__["subnet_specs"] = subnet_specs
            __props__.__dict__["subnet_strategy"] = subnet_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_endpoint_specs"] = vpc_endpoint_specs
            __props__.__dict__["eips"] = None
            __props__.__dict__["internet_gateway"] = None
            __props__.__dict__["isolated_subnet_ids"] = None
            __props__.__dict__["private_subnet_ids"] = None
            __props__.__dict__["public_subnet_ids"] = None
            __props__.__dict__["route_table_associations"] = None
            __props__.__dict__["route_tables"] = None
            __props__.__dict__["routes"] = None
            __props__.__dict__["subnet_layout"] = None
            __props__.__dict__["subnets"] = None
            __props__.__dict__["vpc"] = None
            __props__.__dict__["vpc_endpoints"] = None
            __props__.__dict__["vpc_id"] = None
        super(Vpc, __self__).__init__(
            'awsx:ec2:Vpc',
            resource_name,
            __props__,
            opts,
            remote=True)

    @_builtins.property
    @pulumi.getter
    def eips(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.Eip']]:
        """
        The EIPs for any NAT Gateways for the VPC. If no NAT Gateways are specified, this will be an empty list.
        """
        return pulumi.get(self, "eips")

    @_builtins.property
    @pulumi.getter(name="internetGateway")
    def internet_gateway(self) -> pulumi.Output['pulumi_aws.ec2.InternetGateway']:
        """
        The Internet Gateway for the VPC.
        """
        return pulumi.get(self, "internet_gateway")

    @_builtins.property
    @pulumi.getter(name="isolatedSubnetIds")
    def isolated_subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "isolated_subnet_ids")

    @_builtins.property
    @pulumi.getter(name="natGateways")
    def nat_gateways(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.NatGateway']]:
        """
        The NAT Gateways for the VPC. If no NAT Gateways are specified, this will be an empty list.
        """
        return pulumi.get(self, "nat_gateways")

    @_builtins.property
    @pulumi.getter(name="privateSubnetIds")
    def private_subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "private_subnet_ids")

    @_builtins.property
    @pulumi.getter(name="publicSubnetIds")
    def public_subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "public_subnet_ids")

    @_builtins.property
    @pulumi.getter(name="routeTableAssociations")
    def route_table_associations(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.RouteTableAssociation']]:
        """
        The Route Table Associations for the VPC.
        """
        return pulumi.get(self, "route_table_associations")

    @_builtins.property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.RouteTable']]:
        """
        The Route Tables for the VPC.
        """
        return pulumi.get(self, "route_tables")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.Route']]:
        """
        The Routes for the VPC.
        """
        return pulumi.get(self, "routes")

    @_builtins.property
    @pulumi.getter(name="subnetLayout")
    def subnet_layout(self) -> pulumi.Output[Sequence['outputs.ResolvedSubnetSpec']]:
        """
        The resolved subnet specs layout deployed to each availability zone.
        """
        return pulumi.get(self, "subnet_layout")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.Subnet']]:
        """
        The VPC's subnets.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def vpc(self) -> pulumi.Output['pulumi_aws.ec2.Vpc']:
        """
        The VPC.
        """
        return pulumi.get(self, "vpc")

    @_builtins.property
    @pulumi.getter(name="vpcEndpoints")
    def vpc_endpoints(self) -> pulumi.Output[Sequence['pulumi_aws.ec2.VpcEndpoint']]:
        """
        The VPC Endpoints that are enabled
        """
        return pulumi.get(self, "vpc_endpoints")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "vpc_id")

