# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
import pulumi_aws

__all__ = [
    'ListenerArgs',
    'ListenerArgsDict',
    'TargetGroupArgs',
    'TargetGroupArgsDict',
]

MYPY = False

if not MYPY:
    class ListenerArgsDict(TypedDict):
        """
        Provides a Load Balancer Listener resource.

        > **Note:** <span pulumi-lang-nodejs="`aws.alb.Listener`" pulumi-lang-dotnet="`aws.alb.Listener`" pulumi-lang-go="`alb.Listener`" pulumi-lang-python="`alb.Listener`" pulumi-lang-yaml="`aws.alb.Listener`" pulumi-lang-java="`aws.alb.Listener`">`aws.alb.Listener`</span> is known as <span pulumi-lang-nodejs="`aws.lb.Listener`" pulumi-lang-dotnet="`aws.lb.Listener`" pulumi-lang-go="`lb.Listener`" pulumi-lang-python="`lb.Listener`" pulumi-lang-yaml="`aws.lb.Listener`" pulumi-lang-java="`aws.lb.Listener`">`aws.lb.Listener`</span>. The functionality is identical.

        ## Example Usage

        ### Forward Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 443,
            protocol: "HTTPS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            defaultActions: [{
                type: "forward",
                targetGroupArn: frontEndTargetGroup.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_target_group.arn,
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 443,
                Protocol = "HTTPS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("HTTPS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(443)
                    .protocol("HTTPS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .targetGroupArn(frontEndTargetGroup.arn())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '443'
              protocol: HTTPS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              defaultActions:
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        With weighted target groups:

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndBlue = new aws.lb.TargetGroup("front_end_blue", {});
        const frontEndGreen = new aws.lb.TargetGroup("front_end_green", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 443,
            protocol: "HTTPS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            defaultActions: [{
                type: "forward",
                forward: {
                    targetGroups: [
                        {
                            arn: frontEndBlue.arn,
                            weight: 100,
                        },
                        {
                            arn: frontEndGreen.arn,
                            weight: 0,
                        },
                    ],
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_blue = aws.lb.TargetGroup("front_end_blue")
        front_end_green = aws.lb.TargetGroup("front_end_green")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "forward": {
                    "target_groups": [
                        {
                            "arn": front_end_blue.arn,
                            "weight": 100,
                        },
                        {
                            "arn": front_end_green.arn,
                            "weight": 0,
                        },
                    ],
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndBlue = new Aws.LB.TargetGroup("front_end_blue");

            var frontEndGreen = new Aws.LB.TargetGroup("front_end_green");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 443,
                Protocol = "HTTPS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        Forward = new Aws.LB.Inputs.ListenerDefaultActionForwardArgs
                        {
                            TargetGroups = new[]
                            {
                                new Aws.LB.Inputs.ListenerDefaultActionForwardTargetGroupArgs
                                {
                                    Arn = frontEndBlue.Arn,
                                    Weight = 100,
                                },
                                new Aws.LB.Inputs.ListenerDefaultActionForwardTargetGroupArgs
                                {
                                    Arn = frontEndGreen.Arn,
                                    Weight = 0,
                                },
                            },
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndBlue, err := lb.NewTargetGroup(ctx, "front_end_blue", nil)
        		if err != nil {
        			return err
        		}
        		frontEndGreen, err := lb.NewTargetGroup(ctx, "front_end_green", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("HTTPS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("forward"),
        					Forward: &lb.ListenerDefaultActionForwardArgs{
        						TargetGroups: lb.ListenerDefaultActionForwardTargetGroupArray{
        							&lb.ListenerDefaultActionForwardTargetGroupArgs{
        								Arn:    frontEndBlue.Arn,
        								Weight: pulumi.Int(100),
        							},
        							&lb.ListenerDefaultActionForwardTargetGroupArgs{
        								Arn:    frontEndGreen.Arn,
        								Weight: pulumi.Int(0),
        							},
        						},
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndBlue = new TargetGroup("frontEndBlue");

                var frontEndGreen = new TargetGroup("frontEndGreen");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(443)
                    .protocol("HTTPS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .forward(ListenerDefaultActionForwardArgs.builder()
                            .targetGroups(                    
                                ListenerDefaultActionForwardTargetGroupArgs.builder()
                                    .arn(frontEndBlue.arn())
                                    .weight(100)
                                    .build(),
                                ListenerDefaultActionForwardTargetGroupArgs.builder()
                                    .arn(frontEndGreen.arn())
                                    .weight(0)
                                    .build())
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndBlue:
            type: aws:lb:TargetGroup
            name: front_end_blue
          frontEndGreen:
            type: aws:lb:TargetGroup
            name: front_end_green
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '443'
              protocol: HTTPS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              defaultActions:
                - type: forward
                  forward:
                    targetGroups:
                      - arn: ${frontEndBlue.arn}
                        weight: 100
                      - arn: ${frontEndGreen.arn}
                        weight: 0
        ```
        <!--End PulumiCodeChooser -->

        To a NLB:

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEndAwsLb.arn,
            port: 443,
            protocol: "TLS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpnPolicy: "HTTP2Preferred",
            defaultActions: [{
                type: "forward",
                targetGroupArn: frontEndAwsLbTargetGroup.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.Listener("front_end",
            load_balancer_arn=front_end_aws_lb["arn"],
            port=443,
            protocol="TLS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpn_policy="HTTP2Preferred",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_aws_lb_target_group["arn"],
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEndAwsLb.Arn,
                Port = 443,
                Protocol = "TLS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                AlpnPolicy = "HTTP2Preferred",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndAwsLbTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: pulumi.Any(frontEndAwsLb.Arn),
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("TLS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			AlpnPolicy:      pulumi.String("HTTP2Preferred"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: pulumi.Any(frontEndAwsLbTargetGroup.Arn),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new Listener("frontEnd", ListenerArgs.builder()
                    .loadBalancerArn(frontEndAwsLb.arn())
                    .port(443)
                    .protocol("TLS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .alpnPolicy("HTTP2Preferred")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .targetGroupArn(frontEndAwsLbTargetGroup.arn())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEndAwsLb.arn}
              port: '443'
              protocol: TLS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              alpnPolicy: HTTP2Preferred
              defaultActions:
                - type: forward
                  targetGroupArn: ${frontEndAwsLbTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Redirect Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "redirect",
                redirect: {
                    port: "443",
                    protocol: "HTTPS",
                    statusCode: "HTTP_301",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "redirect",
                        Redirect = new Aws.LB.Inputs.ListenerDefaultActionRedirectArgs
                        {
                            Port = "443",
                            Protocol = "HTTPS",
                            StatusCode = "HTTP_301",
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("redirect"),
        					Redirect: &lb.ListenerDefaultActionRedirectArgs{
        						Port:       pulumi.String("443"),
        						Protocol:   pulumi.String("HTTPS"),
        						StatusCode: pulumi.String("HTTP_301"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionRedirectArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("redirect")
                        .redirect(ListenerDefaultActionRedirectArgs.builder()
                            .port("443")
                            .protocol("HTTPS")
                            .statusCode("HTTP_301")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: redirect
                  redirect:
                    port: '443'
                    protocol: HTTPS
                    statusCode: HTTP_301
        ```
        <!--End PulumiCodeChooser -->

        ### Fixed-response Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "fixed-response",
                fixedResponse: {
                    contentType: "text/plain",
                    messageBody: "Fixed response content",
                    statusCode: "200",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "Fixed response content",
                    "status_code": "200",
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "fixed-response",
                        FixedResponse = new Aws.LB.Inputs.ListenerDefaultActionFixedResponseArgs
                        {
                            ContentType = "text/plain",
                            MessageBody = "Fixed response content",
                            StatusCode = "200",
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("fixed-response"),
        					FixedResponse: &lb.ListenerDefaultActionFixedResponseArgs{
        						ContentType: pulumi.String("text/plain"),
        						MessageBody: pulumi.String("Fixed response content"),
        						StatusCode:  pulumi.String("200"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionFixedResponseArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("fixed-response")
                        .fixedResponse(ListenerDefaultActionFixedResponseArgs.builder()
                            .contentType("text/plain")
                            .messageBody("Fixed response content")
                            .statusCode("200")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: fixed-response
                  fixedResponse:
                    contentType: text/plain
                    messageBody: Fixed response content
                    statusCode: '200'
        ```
        <!--End PulumiCodeChooser -->

        ### Authenticate-cognito Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const pool = new aws.cognito.UserPool("pool", {});
        const client = new aws.cognito.UserPoolClient("client", {});
        const domain = new aws.cognito.UserPoolDomain("domain", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-cognito",
                    authenticateCognito: {
                        userPoolArn: pool.arn,
                        userPoolClientId: client.id,
                        userPoolDomain: domain.domain,
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var pool = new Aws.Cognito.UserPool("pool");

            var client = new Aws.Cognito.UserPoolClient("client");

            var domain = new Aws.Cognito.UserPoolDomain("domain");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "authenticate-cognito",
                        AuthenticateCognito = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateCognitoArgs
                        {
                            UserPoolArn = pool.Arn,
                            UserPoolClientId = client.Id,
                            UserPoolDomain = domain.Domain,
                        },
                    },
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/cognito"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		pool, err := cognito.NewUserPool(ctx, "pool", nil)
        		if err != nil {
        			return err
        		}
        		client, err := cognito.NewUserPoolClient(ctx, "client", nil)
        		if err != nil {
        			return err
        		}
        		domain, err := cognito.NewUserPoolDomain(ctx, "domain", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-cognito"),
        					AuthenticateCognito: &lb.ListenerDefaultActionAuthenticateCognitoArgs{
        						UserPoolArn:      pool.Arn,
        						UserPoolClientId: client.ID(),
        						UserPoolDomain:   domain.Domain,
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.cognito.UserPool;
        import com.pulumi.aws.cognito.UserPoolClient;
        import com.pulumi.aws.cognito.UserPoolDomain;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateCognitoArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var pool = new UserPool("pool");

                var client = new UserPoolClient("client");

                var domain = new UserPoolDomain("domain");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultActionArgs.builder()
                            .type("authenticate-cognito")
                            .authenticateCognito(ListenerDefaultActionAuthenticateCognitoArgs.builder()
                                .userPoolArn(pool.arn())
                                .userPoolClientId(client.id())
                                .userPoolDomain(domain.domain())
                                .build())
                            .build(),
                        ListenerDefaultActionArgs.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.arn())
                            .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          pool:
            type: aws:cognito:UserPool
          client:
            type: aws:cognito:UserPoolClient
          domain:
            type: aws:cognito:UserPoolDomain
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: authenticate-cognito
                  authenticateCognito:
                    userPoolArn: ${pool.arn}
                    userPoolClientId: ${client.id}
                    userPoolDomain: ${domain.domain}
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Authenticate-OIDC Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-oidc",
                    authenticateOidc: {
                        authorizationEndpoint: "https://example.com/authorization_endpoint",
                        clientId: "client_id",
                        clientSecret: "client_secret",
                        issuer: "https://example.com",
                        tokenEndpoint: "https://example.com/token_endpoint",
                        userInfoEndpoint: "https://example.com/user_info_endpoint",
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "authenticate-oidc",
                        AuthenticateOidc = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateOidcArgs
                        {
                            AuthorizationEndpoint = "https://example.com/authorization_endpoint",
                            ClientId = "client_id",
                            ClientSecret = "client_secret",
                            Issuer = "https://example.com",
                            TokenEndpoint = "https://example.com/token_endpoint",
                            UserInfoEndpoint = "https://example.com/user_info_endpoint",
                        },
                    },
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-oidc"),
        					AuthenticateOidc: &lb.ListenerDefaultActionAuthenticateOidcArgs{
        						AuthorizationEndpoint: pulumi.String("https://example.com/authorization_endpoint"),
        						ClientId:              pulumi.String("client_id"),
        						ClientSecret:          pulumi.String("client_secret"),
        						Issuer:                pulumi.String("https://example.com"),
        						TokenEndpoint:         pulumi.String("https://example.com/token_endpoint"),
        						UserInfoEndpoint:      pulumi.String("https://example.com/user_info_endpoint"),
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultActionArgs.builder()
                            .type("authenticate-oidc")
                            .authenticateOidc(ListenerDefaultActionAuthenticateOidcArgs.builder()
                                .authorizationEndpoint("https://example.com/authorization_endpoint")
                                .clientId("client_id")
                                .clientSecret("client_secret")
                                .issuer("https://example.com")
                                .tokenEndpoint("https://example.com/token_endpoint")
                                .userInfoEndpoint("https://example.com/user_info_endpoint")
                                .build())
                            .build(),
                        ListenerDefaultActionArgs.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.arn())
                            .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: authenticate-oidc
                  authenticateOidc:
                    authorizationEndpoint: https://example.com/authorization_endpoint
                    clientId: client_id
                    clientSecret: client_secret
                    issuer: https://example.com
                    tokenEndpoint: https://example.com/token_endpoint
                    userInfoEndpoint: https://example.com/user_info_endpoint
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Gateway Load Balancer Listener

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.lb.LoadBalancer("example", {
            loadBalancerType: "gateway",
            name: "example",
            subnetMappings: [{
                subnetId: exampleAwsSubnet.id,
            }],
        });
        const exampleTargetGroup = new aws.lb.TargetGroup("example", {
            name: "example",
            port: 6081,
            protocol: "GENEVE",
            vpcId: exampleAwsVpc.id,
            healthCheck: {
                port: "80",
                protocol: "HTTP",
            },
        });
        const exampleListener = new aws.lb.Listener("example", {
            loadBalancerArn: example.id,
            defaultActions: [{
                targetGroupArn: exampleTargetGroup.id,
                type: "forward",
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            load_balancer_type="gateway",
            name="example",
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }])
        example_target_group = aws.lb.TargetGroup("example",
            name="example",
            port=6081,
            protocol="GENEVE",
            vpc_id=example_aws_vpc["id"],
            health_check={
                "port": "80",
                "protocol": "HTTP",
            })
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.LB.LoadBalancer("example", new()
            {
                LoadBalancerType = "gateway",
                Name = "example",
                SubnetMappings = new[]
                {
                    new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
                    {
                        SubnetId = exampleAwsSubnet.Id,
                    },
                },
            });

            var exampleTargetGroup = new Aws.LB.TargetGroup("example", new()
            {
                Name = "example",
                Port = 6081,
                Protocol = "GENEVE",
                VpcId = exampleAwsVpc.Id,
                HealthCheck = new Aws.LB.Inputs.TargetGroupHealthCheckArgs
                {
                    Port = "80",
                    Protocol = "HTTP",
                },
            });

            var exampleListener = new Aws.LB.Listener("example", new()
            {
                LoadBalancerArn = example.Id,
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        TargetGroupArn = exampleTargetGroup.Id,
                        Type = "forward",
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		example, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
        			LoadBalancerType: pulumi.String("gateway"),
        			Name:             pulumi.String("example"),
        			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
        				&lb.LoadBalancerSubnetMappingArgs{
        					SubnetId: pulumi.Any(exampleAwsSubnet.Id),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		exampleTargetGroup, err := lb.NewTargetGroup(ctx, "example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("example"),
        			Port:     pulumi.Int(6081),
        			Protocol: pulumi.String("GENEVE"),
        			VpcId:    pulumi.Any(exampleAwsVpc.Id),
        			HealthCheck: &lb.TargetGroupHealthCheckArgs{
        				Port:     pulumi.String("80"),
        				Protocol: pulumi.String("HTTP"),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "example", &lb.ListenerArgs{
        			LoadBalancerArn: example.ID(),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					TargetGroupArn: exampleTargetGroup.ID(),
        					Type:           pulumi.String("forward"),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.LoadBalancerArgs;
        import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new LoadBalancer("example", LoadBalancerArgs.builder()
                    .loadBalancerType("gateway")
                    .name("example")
                    .subnetMappings(LoadBalancerSubnetMappingArgs.builder()
                        .subnetId(exampleAwsSubnet.id())
                        .build())
                    .build());

                var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
                    .name("example")
                    .port(6081)
                    .protocol("GENEVE")
                    .vpcId(exampleAwsVpc.id())
                    .healthCheck(TargetGroupHealthCheckArgs.builder()
                        .port("80")
                        .protocol("HTTP")
                        .build())
                    .build());

                var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
                    .loadBalancerArn(example.id())
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .targetGroupArn(exampleTargetGroup.id())
                        .type("forward")
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:lb:LoadBalancer
            properties:
              loadBalancerType: gateway
              name: example
              subnetMappings:
                - subnetId: ${exampleAwsSubnet.id}
          exampleTargetGroup:
            type: aws:lb:TargetGroup
            name: example
            properties:
              name: example
              port: 6081
              protocol: GENEVE
              vpcId: ${exampleAwsVpc.id}
              healthCheck:
                port: 80
                protocol: HTTP
          exampleListener:
            type: aws:lb:Listener
            name: example
            properties:
              loadBalancerArn: ${example.id}
              defaultActions:
                - targetGroupArn: ${exampleTargetGroup.id}
                  type: forward
        ```
        <!--End PulumiCodeChooser -->

        ### Mutual TLS Authentication

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.lb.LoadBalancer("example", {loadBalancerType: "application"});
        const exampleTargetGroup = new aws.lb.TargetGroup("example", {});
        const exampleListener = new aws.lb.Listener("example", {
            loadBalancerArn: example.id,
            defaultActions: [{
                targetGroupArn: exampleTargetGroup.id,
                type: "forward",
            }],
            mutualAuthentication: {
                mode: "verify",
                trustStoreArn: "...",
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example", load_balancer_type="application")
        example_target_group = aws.lb.TargetGroup("example")
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }],
            mutual_authentication={
                "mode": "verify",
                "trust_store_arn": "...",
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.LB.LoadBalancer("example", new()
            {
                LoadBalancerType = "application",
            });

            var exampleTargetGroup = new Aws.LB.TargetGroup("example");

            var exampleListener = new Aws.LB.Listener("example", new()
            {
                LoadBalancerArn = example.Id,
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        TargetGroupArn = exampleTargetGroup.Id,
                        Type = "forward",
                    },
                },
                MutualAuthentication = new Aws.LB.Inputs.ListenerMutualAuthenticationArgs
                {
                    Mode = "verify",
                    TrustStoreArn = "...",
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		example, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
        			LoadBalancerType: pulumi.String("application"),
        		})
        		if err != nil {
        			return err
        		}
        		exampleTargetGroup, err := lb.NewTargetGroup(ctx, "example", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "example", &lb.ListenerArgs{
        			LoadBalancerArn: example.ID(),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					TargetGroupArn: exampleTargetGroup.ID(),
        					Type:           pulumi.String("forward"),
        				},
        			},
        			MutualAuthentication: &lb.ListenerMutualAuthenticationArgs{
        				Mode:          pulumi.String("verify"),
        				TrustStoreArn: pulumi.String("..."),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.LoadBalancerArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new LoadBalancer("example", LoadBalancerArgs.builder()
                    .loadBalancerType("application")
                    .build());

                var exampleTargetGroup = new TargetGroup("exampleTargetGroup");

                var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
                    .loadBalancerArn(example.id())
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .targetGroupArn(exampleTargetGroup.id())
                        .type("forward")
                        .build())
                    .mutualAuthentication(ListenerMutualAuthenticationArgs.builder()
                        .mode("verify")
                        .trustStoreArn("...")
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:lb:LoadBalancer
            properties:
              loadBalancerType: application
          exampleTargetGroup:
            type: aws:lb:TargetGroup
            name: example
          exampleListener:
            type: aws:lb:Listener
            name: example
            properties:
              loadBalancerArn: ${example.id}
              defaultActions:
                - targetGroupArn: ${exampleTargetGroup.id}
                  type: forward
              mutualAuthentication:
                mode: verify
                trustStoreArn: '...'
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the load balancer listener.

        Using `pulumi import`, import listeners using their ARN. For example:

        console

        % pulumi import aws_lb_listener.front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96
        """
        alpn_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        certificate_arn: NotRequired[pulumi.Input[_builtins.str]]
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the <span pulumi-lang-nodejs="`aws.lb.ListenerCertificate`" pulumi-lang-dotnet="`aws.lb.ListenerCertificate`" pulumi-lang-go="`lb.ListenerCertificate`" pulumi-lang-python="`lb.ListenerCertificate`" pulumi-lang-yaml="`aws.lb.ListenerCertificate`" pulumi-lang-java="`aws.lb.ListenerCertificate`">`aws.lb.ListenerCertificate`</span> resource.
        """
        default_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgsDict']]]]
        """
        Configuration block for default actions. See below.
        """
        mutual_authentication: NotRequired[pulumi.Input['pulumi_aws.lb.ListenerMutualAuthenticationArgsDict']]
        """
        The mutual authentication configuration information. See below.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        routing_http_request_x_amzn_mtls_clientcert_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_mtls_clientcert_subject_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_mtls_clientcert_validity_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_tls_cipher_suite_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_request_x_amzn_tls_version_header_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        routing_http_response_access_control_allow_credentials_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        """
        routing_http_response_access_control_allow_headers_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        """
        routing_http_response_access_control_allow_methods_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        """
        routing_http_response_access_control_allow_origin_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        """
        routing_http_response_access_control_expose_headers_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        """
        routing_http_response_access_control_max_age_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span> and <span pulumi-lang-nodejs="`86400`" pulumi-lang-dotnet="`86400`" pulumi-lang-go="`86400`" pulumi-lang-python="`86400`" pulumi-lang-yaml="`86400`" pulumi-lang-java="`86400`">`86400`</span>. This value is browser specific, consult the Access-Control-Max-Age documentation.
        """
        routing_http_response_content_security_policy_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        """
        routing_http_response_server_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span> or <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        routing_http_response_strict_transport_security_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        """
        routing_http_response_x_content_type_options_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`nosniff`" pulumi-lang-dotnet="`Nosniff`" pulumi-lang-go="`nosniff`" pulumi-lang-python="`nosniff`" pulumi-lang-yaml="`nosniff`" pulumi-lang-java="`nosniff`">`nosniff`</span>.
        """
        routing_http_response_x_frame_options_header_value: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        """
        ssl_policy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the SSL Policy for the listener. Required if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        A map of tags to assign to the resource. .If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        """
        tcp_idle_timeout_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> and <span pulumi-lang-nodejs="`6000`" pulumi-lang-dotnet="`6000`" pulumi-lang-go="`6000`" pulumi-lang-python="`6000`" pulumi-lang-yaml="`6000`" pulumi-lang-java="`6000`">`6000`</span> inclusive. Default: <span pulumi-lang-nodejs="`350`" pulumi-lang-dotnet="`350`" pulumi-lang-go="`350`" pulumi-lang-python="`350`" pulumi-lang-yaml="`350`" pulumi-lang-java="`350`">`350`</span>.
        """
elif False:
    ListenerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 alpn_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]] = None,
                 mutual_authentication: Optional[pulumi.Input['pulumi_aws.lb.ListenerMutualAuthenticationArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_tls_cipher_suite_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_request_x_amzn_tls_version_header_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_allow_credentials_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_allow_headers_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_allow_methods_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_allow_origin_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_expose_headers_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_access_control_max_age_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_content_security_policy_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_server_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_http_response_strict_transport_security_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_x_content_type_options_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_http_response_x_frame_options_header_value: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tcp_idle_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Provides a Load Balancer Listener resource.

        > **Note:** <span pulumi-lang-nodejs="`aws.alb.Listener`" pulumi-lang-dotnet="`aws.alb.Listener`" pulumi-lang-go="`alb.Listener`" pulumi-lang-python="`alb.Listener`" pulumi-lang-yaml="`aws.alb.Listener`" pulumi-lang-java="`aws.alb.Listener`">`aws.alb.Listener`</span> is known as <span pulumi-lang-nodejs="`aws.lb.Listener`" pulumi-lang-dotnet="`aws.lb.Listener`" pulumi-lang-go="`lb.Listener`" pulumi-lang-python="`lb.Listener`" pulumi-lang-yaml="`aws.lb.Listener`" pulumi-lang-java="`aws.lb.Listener`">`aws.lb.Listener`</span>. The functionality is identical.

        ## Example Usage

        ### Forward Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 443,
            protocol: "HTTPS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            defaultActions: [{
                type: "forward",
                targetGroupArn: frontEndTargetGroup.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_target_group.arn,
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 443,
                Protocol = "HTTPS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("HTTPS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(443)
                    .protocol("HTTPS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .targetGroupArn(frontEndTargetGroup.arn())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '443'
              protocol: HTTPS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              defaultActions:
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        With weighted target groups:

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndBlue = new aws.lb.TargetGroup("front_end_blue", {});
        const frontEndGreen = new aws.lb.TargetGroup("front_end_green", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 443,
            protocol: "HTTPS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            defaultActions: [{
                type: "forward",
                forward: {
                    targetGroups: [
                        {
                            arn: frontEndBlue.arn,
                            weight: 100,
                        },
                        {
                            arn: frontEndGreen.arn,
                            weight: 0,
                        },
                    ],
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_blue = aws.lb.TargetGroup("front_end_blue")
        front_end_green = aws.lb.TargetGroup("front_end_green")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=443,
            protocol="HTTPS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            default_actions=[{
                "type": "forward",
                "forward": {
                    "target_groups": [
                        {
                            "arn": front_end_blue.arn,
                            "weight": 100,
                        },
                        {
                            "arn": front_end_green.arn,
                            "weight": 0,
                        },
                    ],
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndBlue = new Aws.LB.TargetGroup("front_end_blue");

            var frontEndGreen = new Aws.LB.TargetGroup("front_end_green");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 443,
                Protocol = "HTTPS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        Forward = new Aws.LB.Inputs.ListenerDefaultActionForwardArgs
                        {
                            TargetGroups = new[]
                            {
                                new Aws.LB.Inputs.ListenerDefaultActionForwardTargetGroupArgs
                                {
                                    Arn = frontEndBlue.Arn,
                                    Weight = 100,
                                },
                                new Aws.LB.Inputs.ListenerDefaultActionForwardTargetGroupArgs
                                {
                                    Arn = frontEndGreen.Arn,
                                    Weight = 0,
                                },
                            },
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndBlue, err := lb.NewTargetGroup(ctx, "front_end_blue", nil)
        		if err != nil {
        			return err
        		}
        		frontEndGreen, err := lb.NewTargetGroup(ctx, "front_end_green", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("HTTPS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("forward"),
        					Forward: &lb.ListenerDefaultActionForwardArgs{
        						TargetGroups: lb.ListenerDefaultActionForwardTargetGroupArray{
        							&lb.ListenerDefaultActionForwardTargetGroupArgs{
        								Arn:    frontEndBlue.Arn,
        								Weight: pulumi.Int(100),
        							},
        							&lb.ListenerDefaultActionForwardTargetGroupArgs{
        								Arn:    frontEndGreen.Arn,
        								Weight: pulumi.Int(0),
        							},
        						},
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionForwardArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndBlue = new TargetGroup("frontEndBlue");

                var frontEndGreen = new TargetGroup("frontEndGreen");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(443)
                    .protocol("HTTPS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .forward(ListenerDefaultActionForwardArgs.builder()
                            .targetGroups(                    
                                ListenerDefaultActionForwardTargetGroupArgs.builder()
                                    .arn(frontEndBlue.arn())
                                    .weight(100)
                                    .build(),
                                ListenerDefaultActionForwardTargetGroupArgs.builder()
                                    .arn(frontEndGreen.arn())
                                    .weight(0)
                                    .build())
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndBlue:
            type: aws:lb:TargetGroup
            name: front_end_blue
          frontEndGreen:
            type: aws:lb:TargetGroup
            name: front_end_green
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '443'
              protocol: HTTPS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              defaultActions:
                - type: forward
                  forward:
                    targetGroups:
                      - arn: ${frontEndBlue.arn}
                        weight: 100
                      - arn: ${frontEndGreen.arn}
                        weight: 0
        ```
        <!--End PulumiCodeChooser -->

        To a NLB:

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEndAwsLb.arn,
            port: 443,
            protocol: "TLS",
            sslPolicy: "ELBSecurityPolicy-2016-08",
            certificateArn: "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpnPolicy: "HTTP2Preferred",
            defaultActions: [{
                type: "forward",
                targetGroupArn: frontEndAwsLbTargetGroup.arn,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.Listener("front_end",
            load_balancer_arn=front_end_aws_lb["arn"],
            port=443,
            protocol="TLS",
            ssl_policy="ELBSecurityPolicy-2016-08",
            certificate_arn="arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
            alpn_policy="HTTP2Preferred",
            default_actions=[{
                "type": "forward",
                "target_group_arn": front_end_aws_lb_target_group["arn"],
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEndAwsLb.Arn,
                Port = 443,
                Protocol = "TLS",
                SslPolicy = "ELBSecurityPolicy-2016-08",
                CertificateArn = "arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4",
                AlpnPolicy = "HTTP2Preferred",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndAwsLbTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: pulumi.Any(frontEndAwsLb.Arn),
        			Port:            pulumi.Int(443),
        			Protocol:        pulumi.String("TLS"),
        			SslPolicy:       pulumi.String("ELBSecurityPolicy-2016-08"),
        			CertificateArn:  pulumi.String("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4"),
        			AlpnPolicy:      pulumi.String("HTTP2Preferred"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: pulumi.Any(frontEndAwsLbTargetGroup.Arn),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new Listener("frontEnd", ListenerArgs.builder()
                    .loadBalancerArn(frontEndAwsLb.arn())
                    .port(443)
                    .protocol("TLS")
                    .sslPolicy("ELBSecurityPolicy-2016-08")
                    .certificateArn("arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4")
                    .alpnPolicy("HTTP2Preferred")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("forward")
                        .targetGroupArn(frontEndAwsLbTargetGroup.arn())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEndAwsLb.arn}
              port: '443'
              protocol: TLS
              sslPolicy: ELBSecurityPolicy-2016-08
              certificateArn: arn:aws:iam::187416307283:server-certificate/test_cert_rab3wuqwgja25ct3n4jdj2tzu4
              alpnPolicy: HTTP2Preferred
              defaultActions:
                - type: forward
                  targetGroupArn: ${frontEndAwsLbTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Redirect Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "redirect",
                redirect: {
                    port: "443",
                    protocol: "HTTPS",
                    statusCode: "HTTP_301",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "redirect",
                "redirect": {
                    "port": "443",
                    "protocol": "HTTPS",
                    "status_code": "HTTP_301",
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "redirect",
                        Redirect = new Aws.LB.Inputs.ListenerDefaultActionRedirectArgs
                        {
                            Port = "443",
                            Protocol = "HTTPS",
                            StatusCode = "HTTP_301",
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("redirect"),
        					Redirect: &lb.ListenerDefaultActionRedirectArgs{
        						Port:       pulumi.String("443"),
        						Protocol:   pulumi.String("HTTPS"),
        						StatusCode: pulumi.String("HTTP_301"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionRedirectArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("redirect")
                        .redirect(ListenerDefaultActionRedirectArgs.builder()
                            .port("443")
                            .protocol("HTTPS")
                            .statusCode("HTTP_301")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: redirect
                  redirect:
                    port: '443'
                    protocol: HTTPS
                    statusCode: HTTP_301
        ```
        <!--End PulumiCodeChooser -->

        ### Fixed-response Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [{
                type: "fixed-response",
                fixedResponse: {
                    contentType: "text/plain",
                    messageBody: "Fixed response content",
                    statusCode: "200",
                },
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[{
                "type": "fixed-response",
                "fixed_response": {
                    "content_type": "text/plain",
                    "message_body": "Fixed response content",
                    "status_code": "200",
                },
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "fixed-response",
                        FixedResponse = new Aws.LB.Inputs.ListenerDefaultActionFixedResponseArgs
                        {
                            ContentType = "text/plain",
                            MessageBody = "Fixed response content",
                            StatusCode = "200",
                        },
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("fixed-response"),
        					FixedResponse: &lb.ListenerDefaultActionFixedResponseArgs{
        						ContentType: pulumi.String("text/plain"),
        						MessageBody: pulumi.String("Fixed response content"),
        						StatusCode:  pulumi.String("200"),
        					},
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionFixedResponseArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .type("fixed-response")
                        .fixedResponse(ListenerDefaultActionFixedResponseArgs.builder()
                            .contentType("text/plain")
                            .messageBody("Fixed response content")
                            .statusCode("200")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: fixed-response
                  fixedResponse:
                    contentType: text/plain
                    messageBody: Fixed response content
                    statusCode: '200'
        ```
        <!--End PulumiCodeChooser -->

        ### Authenticate-cognito Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const pool = new aws.cognito.UserPool("pool", {});
        const client = new aws.cognito.UserPoolClient("client", {});
        const domain = new aws.cognito.UserPoolDomain("domain", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-cognito",
                    authenticateCognito: {
                        userPoolArn: pool.arn,
                        userPoolClientId: client.id,
                        userPoolDomain: domain.domain,
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        pool = aws.cognito.UserPool("pool")
        client = aws.cognito.UserPoolClient("client")
        domain = aws.cognito.UserPoolDomain("domain")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-cognito",
                    "authenticate_cognito": {
                        "user_pool_arn": pool.arn,
                        "user_pool_client_id": client.id,
                        "user_pool_domain": domain.domain,
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var pool = new Aws.Cognito.UserPool("pool");

            var client = new Aws.Cognito.UserPoolClient("client");

            var domain = new Aws.Cognito.UserPoolDomain("domain");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "authenticate-cognito",
                        AuthenticateCognito = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateCognitoArgs
                        {
                            UserPoolArn = pool.Arn,
                            UserPoolClientId = client.Id,
                            UserPoolDomain = domain.Domain,
                        },
                    },
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/cognito"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		pool, err := cognito.NewUserPool(ctx, "pool", nil)
        		if err != nil {
        			return err
        		}
        		client, err := cognito.NewUserPoolClient(ctx, "client", nil)
        		if err != nil {
        			return err
        		}
        		domain, err := cognito.NewUserPoolDomain(ctx, "domain", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-cognito"),
        					AuthenticateCognito: &lb.ListenerDefaultActionAuthenticateCognitoArgs{
        						UserPoolArn:      pool.Arn,
        						UserPoolClientId: client.ID(),
        						UserPoolDomain:   domain.Domain,
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.cognito.UserPool;
        import com.pulumi.aws.cognito.UserPoolClient;
        import com.pulumi.aws.cognito.UserPoolDomain;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateCognitoArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var pool = new UserPool("pool");

                var client = new UserPoolClient("client");

                var domain = new UserPoolDomain("domain");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultActionArgs.builder()
                            .type("authenticate-cognito")
                            .authenticateCognito(ListenerDefaultActionAuthenticateCognitoArgs.builder()
                                .userPoolArn(pool.arn())
                                .userPoolClientId(client.id())
                                .userPoolDomain(domain.domain())
                                .build())
                            .build(),
                        ListenerDefaultActionArgs.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.arn())
                            .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          pool:
            type: aws:cognito:UserPool
          client:
            type: aws:cognito:UserPoolClient
          domain:
            type: aws:cognito:UserPoolDomain
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: authenticate-cognito
                  authenticateCognito:
                    userPoolArn: ${pool.arn}
                    userPoolClientId: ${client.id}
                    userPoolDomain: ${domain.domain}
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Authenticate-OIDC Action

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const frontEnd = new aws.lb.LoadBalancer("front_end", {});
        const frontEndTargetGroup = new aws.lb.TargetGroup("front_end", {});
        const frontEndListener = new aws.lb.Listener("front_end", {
            loadBalancerArn: frontEnd.arn,
            port: 80,
            protocol: "HTTP",
            defaultActions: [
                {
                    type: "authenticate-oidc",
                    authenticateOidc: {
                        authorizationEndpoint: "https://example.com/authorization_endpoint",
                        clientId: "client_id",
                        clientSecret: "client_secret",
                        issuer: "https://example.com",
                        tokenEndpoint: "https://example.com/token_endpoint",
                        userInfoEndpoint: "https://example.com/user_info_endpoint",
                    },
                },
                {
                    type: "forward",
                    targetGroupArn: frontEndTargetGroup.arn,
                },
            ],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        front_end = aws.lb.LoadBalancer("front_end")
        front_end_target_group = aws.lb.TargetGroup("front_end")
        front_end_listener = aws.lb.Listener("front_end",
            load_balancer_arn=front_end.arn,
            port=80,
            protocol="HTTP",
            default_actions=[
                {
                    "type": "authenticate-oidc",
                    "authenticate_oidc": {
                        "authorization_endpoint": "https://example.com/authorization_endpoint",
                        "client_id": "client_id",
                        "client_secret": "client_secret",
                        "issuer": "https://example.com",
                        "token_endpoint": "https://example.com/token_endpoint",
                        "user_info_endpoint": "https://example.com/user_info_endpoint",
                    },
                },
                {
                    "type": "forward",
                    "target_group_arn": front_end_target_group.arn,
                },
            ])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var frontEnd = new Aws.LB.LoadBalancer("front_end");

            var frontEndTargetGroup = new Aws.LB.TargetGroup("front_end");

            var frontEndListener = new Aws.LB.Listener("front_end", new()
            {
                LoadBalancerArn = frontEnd.Arn,
                Port = 80,
                Protocol = "HTTP",
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "authenticate-oidc",
                        AuthenticateOidc = new Aws.LB.Inputs.ListenerDefaultActionAuthenticateOidcArgs
                        {
                            AuthorizationEndpoint = "https://example.com/authorization_endpoint",
                            ClientId = "client_id",
                            ClientSecret = "client_secret",
                            Issuer = "https://example.com",
                            TokenEndpoint = "https://example.com/token_endpoint",
                            UserInfoEndpoint = "https://example.com/user_info_endpoint",
                        },
                    },
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        Type = "forward",
                        TargetGroupArn = frontEndTargetGroup.Arn,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		frontEnd, err := lb.NewLoadBalancer(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		frontEndTargetGroup, err := lb.NewTargetGroup(ctx, "front_end", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "front_end", &lb.ListenerArgs{
        			LoadBalancerArn: frontEnd.Arn,
        			Port:            pulumi.Int(80),
        			Protocol:        pulumi.String("HTTP"),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					Type: pulumi.String("authenticate-oidc"),
        					AuthenticateOidc: &lb.ListenerDefaultActionAuthenticateOidcArgs{
        						AuthorizationEndpoint: pulumi.String("https://example.com/authorization_endpoint"),
        						ClientId:              pulumi.String("client_id"),
        						ClientSecret:          pulumi.String("client_secret"),
        						Issuer:                pulumi.String("https://example.com"),
        						TokenEndpoint:         pulumi.String("https://example.com/token_endpoint"),
        						UserInfoEndpoint:      pulumi.String("https://example.com/user_info_endpoint"),
        					},
        				},
        				&lb.ListenerDefaultActionArgs{
        					Type:           pulumi.String("forward"),
        					TargetGroupArn: frontEndTargetGroup.Arn,
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionAuthenticateOidcArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var frontEnd = new LoadBalancer("frontEnd");

                var frontEndTargetGroup = new TargetGroup("frontEndTargetGroup");

                var frontEndListener = new Listener("frontEndListener", ListenerArgs.builder()
                    .loadBalancerArn(frontEnd.arn())
                    .port(80)
                    .protocol("HTTP")
                    .defaultActions(            
                        ListenerDefaultActionArgs.builder()
                            .type("authenticate-oidc")
                            .authenticateOidc(ListenerDefaultActionAuthenticateOidcArgs.builder()
                                .authorizationEndpoint("https://example.com/authorization_endpoint")
                                .clientId("client_id")
                                .clientSecret("client_secret")
                                .issuer("https://example.com")
                                .tokenEndpoint("https://example.com/token_endpoint")
                                .userInfoEndpoint("https://example.com/user_info_endpoint")
                                .build())
                            .build(),
                        ListenerDefaultActionArgs.builder()
                            .type("forward")
                            .targetGroupArn(frontEndTargetGroup.arn())
                            .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          frontEnd:
            type: aws:lb:LoadBalancer
            name: front_end
          frontEndTargetGroup:
            type: aws:lb:TargetGroup
            name: front_end
          frontEndListener:
            type: aws:lb:Listener
            name: front_end
            properties:
              loadBalancerArn: ${frontEnd.arn}
              port: '80'
              protocol: HTTP
              defaultActions:
                - type: authenticate-oidc
                  authenticateOidc:
                    authorizationEndpoint: https://example.com/authorization_endpoint
                    clientId: client_id
                    clientSecret: client_secret
                    issuer: https://example.com
                    tokenEndpoint: https://example.com/token_endpoint
                    userInfoEndpoint: https://example.com/user_info_endpoint
                - type: forward
                  targetGroupArn: ${frontEndTargetGroup.arn}
        ```
        <!--End PulumiCodeChooser -->

        ### Gateway Load Balancer Listener

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.lb.LoadBalancer("example", {
            loadBalancerType: "gateway",
            name: "example",
            subnetMappings: [{
                subnetId: exampleAwsSubnet.id,
            }],
        });
        const exampleTargetGroup = new aws.lb.TargetGroup("example", {
            name: "example",
            port: 6081,
            protocol: "GENEVE",
            vpcId: exampleAwsVpc.id,
            healthCheck: {
                port: "80",
                protocol: "HTTP",
            },
        });
        const exampleListener = new aws.lb.Listener("example", {
            loadBalancerArn: example.id,
            defaultActions: [{
                targetGroupArn: exampleTargetGroup.id,
                type: "forward",
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example",
            load_balancer_type="gateway",
            name="example",
            subnet_mappings=[{
                "subnet_id": example_aws_subnet["id"],
            }])
        example_target_group = aws.lb.TargetGroup("example",
            name="example",
            port=6081,
            protocol="GENEVE",
            vpc_id=example_aws_vpc["id"],
            health_check={
                "port": "80",
                "protocol": "HTTP",
            })
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.LB.LoadBalancer("example", new()
            {
                LoadBalancerType = "gateway",
                Name = "example",
                SubnetMappings = new[]
                {
                    new Aws.LB.Inputs.LoadBalancerSubnetMappingArgs
                    {
                        SubnetId = exampleAwsSubnet.Id,
                    },
                },
            });

            var exampleTargetGroup = new Aws.LB.TargetGroup("example", new()
            {
                Name = "example",
                Port = 6081,
                Protocol = "GENEVE",
                VpcId = exampleAwsVpc.Id,
                HealthCheck = new Aws.LB.Inputs.TargetGroupHealthCheckArgs
                {
                    Port = "80",
                    Protocol = "HTTP",
                },
            });

            var exampleListener = new Aws.LB.Listener("example", new()
            {
                LoadBalancerArn = example.Id,
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        TargetGroupArn = exampleTargetGroup.Id,
                        Type = "forward",
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		example, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
        			LoadBalancerType: pulumi.String("gateway"),
        			Name:             pulumi.String("example"),
        			SubnetMappings: lb.LoadBalancerSubnetMappingArray{
        				&lb.LoadBalancerSubnetMappingArgs{
        					SubnetId: pulumi.Any(exampleAwsSubnet.Id),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		exampleTargetGroup, err := lb.NewTargetGroup(ctx, "example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("example"),
        			Port:     pulumi.Int(6081),
        			Protocol: pulumi.String("GENEVE"),
        			VpcId:    pulumi.Any(exampleAwsVpc.Id),
        			HealthCheck: &lb.TargetGroupHealthCheckArgs{
        				Port:     pulumi.String("80"),
        				Protocol: pulumi.String("HTTP"),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "example", &lb.ListenerArgs{
        			LoadBalancerArn: example.ID(),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					TargetGroupArn: exampleTargetGroup.ID(),
        					Type:           pulumi.String("forward"),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.LoadBalancerArgs;
        import com.pulumi.aws.lb.inputs.LoadBalancerSubnetMappingArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupHealthCheckArgs;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new LoadBalancer("example", LoadBalancerArgs.builder()
                    .loadBalancerType("gateway")
                    .name("example")
                    .subnetMappings(LoadBalancerSubnetMappingArgs.builder()
                        .subnetId(exampleAwsSubnet.id())
                        .build())
                    .build());

                var exampleTargetGroup = new TargetGroup("exampleTargetGroup", TargetGroupArgs.builder()
                    .name("example")
                    .port(6081)
                    .protocol("GENEVE")
                    .vpcId(exampleAwsVpc.id())
                    .healthCheck(TargetGroupHealthCheckArgs.builder()
                        .port("80")
                        .protocol("HTTP")
                        .build())
                    .build());

                var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
                    .loadBalancerArn(example.id())
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .targetGroupArn(exampleTargetGroup.id())
                        .type("forward")
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:lb:LoadBalancer
            properties:
              loadBalancerType: gateway
              name: example
              subnetMappings:
                - subnetId: ${exampleAwsSubnet.id}
          exampleTargetGroup:
            type: aws:lb:TargetGroup
            name: example
            properties:
              name: example
              port: 6081
              protocol: GENEVE
              vpcId: ${exampleAwsVpc.id}
              healthCheck:
                port: 80
                protocol: HTTP
          exampleListener:
            type: aws:lb:Listener
            name: example
            properties:
              loadBalancerArn: ${example.id}
              defaultActions:
                - targetGroupArn: ${exampleTargetGroup.id}
                  type: forward
        ```
        <!--End PulumiCodeChooser -->

        ### Mutual TLS Authentication

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const example = new aws.lb.LoadBalancer("example", {loadBalancerType: "application"});
        const exampleTargetGroup = new aws.lb.TargetGroup("example", {});
        const exampleListener = new aws.lb.Listener("example", {
            loadBalancerArn: example.id,
            defaultActions: [{
                targetGroupArn: exampleTargetGroup.id,
                type: "forward",
            }],
            mutualAuthentication: {
                mode: "verify",
                trustStoreArn: "...",
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.lb.LoadBalancer("example", load_balancer_type="application")
        example_target_group = aws.lb.TargetGroup("example")
        example_listener = aws.lb.Listener("example",
            load_balancer_arn=example.id,
            default_actions=[{
                "target_group_arn": example_target_group.id,
                "type": "forward",
            }],
            mutual_authentication={
                "mode": "verify",
                "trust_store_arn": "...",
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var example = new Aws.LB.LoadBalancer("example", new()
            {
                LoadBalancerType = "application",
            });

            var exampleTargetGroup = new Aws.LB.TargetGroup("example");

            var exampleListener = new Aws.LB.Listener("example", new()
            {
                LoadBalancerArn = example.Id,
                DefaultActions = new[]
                {
                    new Aws.LB.Inputs.ListenerDefaultActionArgs
                    {
                        TargetGroupArn = exampleTargetGroup.Id,
                        Type = "forward",
                    },
                },
                MutualAuthentication = new Aws.LB.Inputs.ListenerMutualAuthenticationArgs
                {
                    Mode = "verify",
                    TrustStoreArn = "...",
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		example, err := lb.NewLoadBalancer(ctx, "example", &lb.LoadBalancerArgs{
        			LoadBalancerType: pulumi.String("application"),
        		})
        		if err != nil {
        			return err
        		}
        		exampleTargetGroup, err := lb.NewTargetGroup(ctx, "example", nil)
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewListener(ctx, "example", &lb.ListenerArgs{
        			LoadBalancerArn: example.ID(),
        			DefaultActions: lb.ListenerDefaultActionArray{
        				&lb.ListenerDefaultActionArgs{
        					TargetGroupArn: exampleTargetGroup.ID(),
        					Type:           pulumi.String("forward"),
        				},
        			},
        			MutualAuthentication: &lb.ListenerMutualAuthenticationArgs{
        				Mode:          pulumi.String("verify"),
        				TrustStoreArn: pulumi.String("..."),
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.LoadBalancer;
        import com.pulumi.aws.lb.LoadBalancerArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.Listener;
        import com.pulumi.aws.lb.ListenerArgs;
        import com.pulumi.aws.lb.inputs.ListenerDefaultActionArgs;
        import com.pulumi.aws.lb.inputs.ListenerMutualAuthenticationArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var example = new LoadBalancer("example", LoadBalancerArgs.builder()
                    .loadBalancerType("application")
                    .build());

                var exampleTargetGroup = new TargetGroup("exampleTargetGroup");

                var exampleListener = new Listener("exampleListener", ListenerArgs.builder()
                    .loadBalancerArn(example.id())
                    .defaultActions(ListenerDefaultActionArgs.builder()
                        .targetGroupArn(exampleTargetGroup.id())
                        .type("forward")
                        .build())
                    .mutualAuthentication(ListenerMutualAuthenticationArgs.builder()
                        .mode("verify")
                        .trustStoreArn("...")
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          example:
            type: aws:lb:LoadBalancer
            properties:
              loadBalancerType: application
          exampleTargetGroup:
            type: aws:lb:TargetGroup
            name: example
          exampleListener:
            type: aws:lb:Listener
            name: example
            properties:
              loadBalancerArn: ${example.id}
              defaultActions:
                - targetGroupArn: ${exampleTargetGroup.id}
                  type: forward
              mutualAuthentication:
                mode: verify
                trustStoreArn: '...'
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the load balancer listener.

        Using `pulumi import`, import listeners using their ARN. For example:

        console

        % pulumi import aws_lb_listener.front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:listener/app/front-end-alb/8e4497da625e2d8a/9ab28ade35828f96


        :param pulumi.Input[_builtins.str] alpn_policy: Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        :param pulumi.Input[_builtins.str] certificate_arn: ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the <span pulumi-lang-nodejs="`aws.lb.ListenerCertificate`" pulumi-lang-dotnet="`aws.lb.ListenerCertificate`" pulumi-lang-go="`lb.ListenerCertificate`" pulumi-lang-python="`lb.ListenerCertificate`" pulumi-lang-yaml="`aws.lb.ListenerCertificate`" pulumi-lang-java="`aws.lb.ListenerCertificate`">`aws.lb.ListenerCertificate`</span> resource.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]] default_actions: Configuration block for default actions. See below.
        :param pulumi.Input['pulumi_aws.lb.ListenerMutualAuthenticationArgs'] mutual_authentication: The mutual authentication configuration information. See below.
        :param pulumi.Input[_builtins.int] port: Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        :param pulumi.Input[_builtins.str] protocol: Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_issuer_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_leaf_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_subject_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_mtls_clientcert_validity_header_name: Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_tls_cipher_suite_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_request_x_amzn_tls_version_header_name: Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_allow_credentials_header_value: Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_allow_headers_header_value: Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_allow_methods_header_value: Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_allow_origin_header_value: Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_expose_headers_header_value: Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        :param pulumi.Input[_builtins.str] routing_http_response_access_control_max_age_header_value: Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span> and <span pulumi-lang-nodejs="`86400`" pulumi-lang-dotnet="`86400`" pulumi-lang-go="`86400`" pulumi-lang-python="`86400`" pulumi-lang-yaml="`86400`" pulumi-lang-java="`86400`">`86400`</span>. This value is browser specific, consult the Access-Control-Max-Age documentation.
        :param pulumi.Input[_builtins.str] routing_http_response_content_security_policy_header_value: Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        :param pulumi.Input[_builtins.bool] routing_http_response_server_enabled: Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span> or <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] routing_http_response_strict_transport_security_header_value: Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        :param pulumi.Input[_builtins.str] routing_http_response_x_content_type_options_header_value: Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`nosniff`" pulumi-lang-dotnet="`Nosniff`" pulumi-lang-go="`nosniff`" pulumi-lang-python="`nosniff`" pulumi-lang-yaml="`nosniff`" pulumi-lang-java="`nosniff`">`nosniff`</span>.
        :param pulumi.Input[_builtins.str] routing_http_response_x_frame_options_header_value: Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        :param pulumi.Input[_builtins.str] ssl_policy: Name of the SSL Policy for the listener. Required if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. .If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
               
               > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        :param pulumi.Input[_builtins.int] tcp_idle_timeout_seconds: TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> and <span pulumi-lang-nodejs="`6000`" pulumi-lang-dotnet="`6000`" pulumi-lang-go="`6000`" pulumi-lang-python="`6000`" pulumi-lang-yaml="`6000`" pulumi-lang-java="`6000`">`6000`</span> inclusive. Default: <span pulumi-lang-nodejs="`350`" pulumi-lang-dotnet="`350`" pulumi-lang-go="`350`" pulumi-lang-python="`350`" pulumi-lang-yaml="`350`" pulumi-lang-java="`350`">`350`</span>.
        """
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if default_actions is not None:
            pulumi.set(__self__, "default_actions", default_actions)
        if mutual_authentication is not None:
            pulumi.set(__self__, "mutual_authentication", mutual_authentication)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_http_request_x_amzn_mtls_clientcert_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_header_name", routing_http_request_x_amzn_mtls_clientcert_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_issuer_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", routing_http_request_x_amzn_mtls_clientcert_issuer_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_leaf_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", routing_http_request_x_amzn_mtls_clientcert_leaf_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_subject_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", routing_http_request_x_amzn_mtls_clientcert_subject_header_name)
        if routing_http_request_x_amzn_mtls_clientcert_validity_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", routing_http_request_x_amzn_mtls_clientcert_validity_header_name)
        if routing_http_request_x_amzn_tls_cipher_suite_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_cipher_suite_header_name", routing_http_request_x_amzn_tls_cipher_suite_header_name)
        if routing_http_request_x_amzn_tls_version_header_name is not None:
            pulumi.set(__self__, "routing_http_request_x_amzn_tls_version_header_name", routing_http_request_x_amzn_tls_version_header_name)
        if routing_http_response_access_control_allow_credentials_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_credentials_header_value", routing_http_response_access_control_allow_credentials_header_value)
        if routing_http_response_access_control_allow_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_headers_header_value", routing_http_response_access_control_allow_headers_header_value)
        if routing_http_response_access_control_allow_methods_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_methods_header_value", routing_http_response_access_control_allow_methods_header_value)
        if routing_http_response_access_control_allow_origin_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_allow_origin_header_value", routing_http_response_access_control_allow_origin_header_value)
        if routing_http_response_access_control_expose_headers_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_expose_headers_header_value", routing_http_response_access_control_expose_headers_header_value)
        if routing_http_response_access_control_max_age_header_value is not None:
            pulumi.set(__self__, "routing_http_response_access_control_max_age_header_value", routing_http_response_access_control_max_age_header_value)
        if routing_http_response_content_security_policy_header_value is not None:
            pulumi.set(__self__, "routing_http_response_content_security_policy_header_value", routing_http_response_content_security_policy_header_value)
        if routing_http_response_server_enabled is not None:
            pulumi.set(__self__, "routing_http_response_server_enabled", routing_http_response_server_enabled)
        if routing_http_response_strict_transport_security_header_value is not None:
            pulumi.set(__self__, "routing_http_response_strict_transport_security_header_value", routing_http_response_strict_transport_security_header_value)
        if routing_http_response_x_content_type_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_content_type_options_header_value", routing_http_response_x_content_type_options_header_value)
        if routing_http_response_x_frame_options_header_value is not None:
            pulumi.set(__self__, "routing_http_response_x_frame_options_header_value", routing_http_response_x_frame_options_header_value)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tcp_idle_timeout_seconds is not None:
            pulumi.set(__self__, "tcp_idle_timeout_seconds", tcp_idle_timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Application-Layer Protocol Negotiation (ALPN) policy. Can be set if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TLS`. Valid values are `HTTP1Only`, `HTTP2Only`, `HTTP2Optional`, `HTTP2Preferred`, and `None`.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alpn_policy", value)

    @_builtins.property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the default SSL server certificate. Exactly one certificate is required if the protocol is HTTPS. For adding additional SSL certificates, see the <span pulumi-lang-nodejs="`aws.lb.ListenerCertificate`" pulumi-lang-dotnet="`aws.lb.ListenerCertificate`" pulumi-lang-go="`lb.ListenerCertificate`" pulumi-lang-python="`lb.ListenerCertificate`" pulumi-lang-yaml="`aws.lb.ListenerCertificate`" pulumi-lang-java="`aws.lb.ListenerCertificate`">`aws.lb.ListenerCertificate`</span> resource.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_arn", value)

    @_builtins.property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]]:
        """
        Configuration block for default actions. See below.
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.ListenerDefaultActionArgs']]]]):
        pulumi.set(self, "default_actions", value)

    @_builtins.property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> Optional[pulumi.Input['pulumi_aws.lb.ListenerMutualAuthenticationArgs']]:
        """
        The mutual authentication configuration information. See below.
        """
        return pulumi.get(self, "mutual_authentication")

    @mutual_authentication.setter
    def mutual_authentication(self, value: Optional[pulumi.Input['pulumi_aws.lb.ListenerMutualAuthenticationArgs']]):
        pulumi.set(self, "mutual_authentication", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port on which the load balancer is listening. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol for connections from clients to the load balancer. For Application Load Balancers, valid values are `HTTP` and `HTTPS`, with a default of `HTTP`. For Network Load Balancers, valid values are `TCP`, `TLS`, `UDP`, and `TCP_UDP`. Not valid to use `UDP` or `TCP_UDP` if dual-stack mode is enabled. Not valid for Gateway Load Balancers.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertIssuerHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Issuer` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_issuer_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_issuer_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_issuer_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertLeafHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Leaf` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_leaf_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_leaf_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_leaf_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSerialNumberHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Serial-Number` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_serial_number_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertSubjectHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Subject` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_subject_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_subject_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_subject_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznMtlsClientcertValidityHeaderName")
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Mtls-Clientcert-Validity` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name")

    @routing_http_request_x_amzn_mtls_clientcert_validity_header_name.setter
    def routing_http_request_x_amzn_mtls_clientcert_validity_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_mtls_clientcert_validity_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznTlsCipherSuiteHeaderName")
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Cipher-Suite` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name")

    @routing_http_request_x_amzn_tls_cipher_suite_header_name.setter
    def routing_http_request_x_amzn_tls_cipher_suite_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_cipher_suite_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpRequestXAmznTlsVersionHeaderName")
    def routing_http_request_x_amzn_tls_version_header_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables you to modify the header name of the `X-Amzn-Tls-Version` HTTP request header. Can only be set if protocol is `HTTPS` for Application Load Balancers.
        """
        return pulumi.get(self, "routing_http_request_x_amzn_tls_version_header_name")

    @routing_http_request_x_amzn_tls_version_header_name.setter
    def routing_http_request_x_amzn_tls_version_header_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_request_x_amzn_tls_version_header_name", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowCredentialsHeaderValue")
    def routing_http_response_access_control_allow_credentials_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which headers the browser can expose to the requesting client. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_credentials_header_value")

    @routing_http_response_access_control_allow_credentials_header_value.setter
    def routing_http_response_access_control_allow_credentials_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_credentials_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowHeadersHeaderValue")
    def routing_http_response_access_control_allow_headers_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which headers can be used during the request. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Accept`, `Accept-Language`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, `Pragma`. Dependent on your use-case other headers can be exposed and then set as a value consult the Access-Control-Allow-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_headers_header_value")

    @routing_http_response_access_control_allow_headers_header_value.setter
    def routing_http_response_access_control_allow_headers_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_headers_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowMethodsHeaderValue")
    def routing_http_response_access_control_allow_methods_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set which HTTP methods are allowed when accessing the server from a different origin. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `GET`, `HEAD`, `POST`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE` or `PATCH`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_methods_header_value")

    @routing_http_response_access_control_allow_methods_header_value.setter
    def routing_http_response_access_control_allow_methods_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_methods_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlAllowOriginHeaderValue")
    def routing_http_response_access_control_allow_origin_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies which origins are allowed to access the server. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. A valid value is a URI, eg: `https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_access_control_allow_origin_header_value")

    @routing_http_response_access_control_allow_origin_header_value.setter
    def routing_http_response_access_control_allow_origin_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_allow_origin_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlExposeHeadersHeaderValue")
    def routing_http_response_access_control_expose_headers_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether the browser should include credentials such as cookies or authentication when making requests. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are `*`, `Cache-Control`, `Content-Language`, `Content-Length`, `Content-Type`, `Expires`, `Last-Modified`, or `Pragma`. Dependent on your use-case other headers can be exposed, consult the Access-Control-Expose-Headers documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_expose_headers_header_value")

    @routing_http_response_access_control_expose_headers_header_value.setter
    def routing_http_response_access_control_expose_headers_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_expose_headers_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseAccessControlMaxAgeHeaderValue")
    def routing_http_response_access_control_max_age_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies how long the results of a preflight request can be cached, in seconds. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are between <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span> and <span pulumi-lang-nodejs="`86400`" pulumi-lang-dotnet="`86400`" pulumi-lang-go="`86400`" pulumi-lang-python="`86400`" pulumi-lang-yaml="`86400`" pulumi-lang-java="`86400`">`86400`</span>. This value is browser specific, consult the Access-Control-Max-Age documentation.
        """
        return pulumi.get(self, "routing_http_response_access_control_max_age_header_value")

    @routing_http_response_access_control_max_age_header_value.setter
    def routing_http_response_access_control_max_age_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_access_control_max_age_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseContentSecurityPolicyHeaderValue")
    def routing_http_response_content_security_policy_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Values for this are extensive, and can be impactful when set, consult Content-Security-Policy documentation.
        """
        return pulumi.get(self, "routing_http_response_content_security_policy_header_value")

    @routing_http_response_content_security_policy_header_value.setter
    def routing_http_response_content_security_policy_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_content_security_policy_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseServerEnabled")
    def routing_http_response_server_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables you to allow or remove the HTTP response server header. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. Valid values are <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span> or <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "routing_http_response_server_enabled")

    @routing_http_response_server_enabled.setter
    def routing_http_response_server_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "routing_http_response_server_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseStrictTransportSecurityHeaderValue")
    def routing_http_response_strict_transport_security_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS. Default values are `max-age=31536000; includeSubDomains; preload` consult the Strict-Transport-Security documentation for further details.
        """
        return pulumi.get(self, "routing_http_response_strict_transport_security_header_value")

    @routing_http_response_strict_transport_security_header_value.setter
    def routing_http_response_strict_transport_security_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_strict_transport_security_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseXContentTypeOptionsHeaderValue")
    def routing_http_response_x_content_type_options_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the MIME types advertised in the Content-Type headers should be followed and not be changed. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid value is <span pulumi-lang-nodejs="`nosniff`" pulumi-lang-dotnet="`Nosniff`" pulumi-lang-go="`nosniff`" pulumi-lang-python="`nosniff`" pulumi-lang-yaml="`nosniff`" pulumi-lang-java="`nosniff`">`nosniff`</span>.
        """
        return pulumi.get(self, "routing_http_response_x_content_type_options_header_value")

    @routing_http_response_x_content_type_options_header_value.setter
    def routing_http_response_x_content_type_options_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_x_content_type_options_header_value", value)

    @_builtins.property
    @pulumi.getter(name="routingHttpResponseXFrameOptionsHeaderValue")
    def routing_http_response_x_frame_options_header_value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether the browser is allowed to render a page in a frame, iframe, embed or object. Can only be set if protocol is `HTTP` or `HTTPS` for Application Load Balancers. Not supported for Network Load Balancer, or with a Gateway Load Balancer. The only valid values are `DENY`, `SAMEORIGIN`, or `ALLOW-FROM https://example.com`.
        """
        return pulumi.get(self, "routing_http_response_x_frame_options_header_value")

    @routing_http_response_x_frame_options_header_value.setter
    def routing_http_response_x_frame_options_header_value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_http_response_x_frame_options_header_value", value)

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the SSL Policy for the listener. Required if <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTPS` or `TLS`. Default is `ELBSecurityPolicy-2016-08`.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_policy", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. .If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.

        > **Note::** When a `Name` key is specified in the map, the AWS Console maps the value to the `Name Tag` column value inside the `Listener Rules` table within a specific load balancer listener page. Otherwise, the value resolves to `Default`.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tcpIdleTimeoutSeconds")
    def tcp_idle_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP idle timeout value in seconds. Can only be set if protocol is `TCP` on Network Load Balancer, or with a Gateway Load Balancer. Not supported for Application Load Balancers. Valid values are between <span pulumi-lang-nodejs="`60`" pulumi-lang-dotnet="`60`" pulumi-lang-go="`60`" pulumi-lang-python="`60`" pulumi-lang-yaml="`60`" pulumi-lang-java="`60`">`60`</span> and <span pulumi-lang-nodejs="`6000`" pulumi-lang-dotnet="`6000`" pulumi-lang-go="`6000`" pulumi-lang-python="`6000`" pulumi-lang-yaml="`6000`" pulumi-lang-java="`6000`">`6000`</span> inclusive. Default: <span pulumi-lang-nodejs="`350`" pulumi-lang-dotnet="`350`" pulumi-lang-go="`350`" pulumi-lang-python="`350`" pulumi-lang-yaml="`350`" pulumi-lang-java="`350`">`350`</span>.
        """
        return pulumi.get(self, "tcp_idle_timeout_seconds")

    @tcp_idle_timeout_seconds.setter
    def tcp_idle_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_idle_timeout_seconds", value)


if not MYPY:
    class TargetGroupArgsDict(TypedDict):
        """
        Provides a Target Group resource for use with Load Balancer resources.

        > **Note:** <span pulumi-lang-nodejs="`aws.alb.TargetGroup`" pulumi-lang-dotnet="`aws.alb.TargetGroup`" pulumi-lang-go="`alb.TargetGroup`" pulumi-lang-python="`alb.TargetGroup`" pulumi-lang-yaml="`aws.alb.TargetGroup`" pulumi-lang-java="`aws.alb.TargetGroup`">`aws.alb.TargetGroup`</span> is known as <span pulumi-lang-nodejs="`aws.lb.TargetGroup`" pulumi-lang-dotnet="`aws.lb.TargetGroup`" pulumi-lang-go="`lb.TargetGroup`" pulumi-lang-python="`lb.TargetGroup`" pulumi-lang-yaml="`aws.lb.TargetGroup`" pulumi-lang-java="`aws.lb.TargetGroup`">`aws.lb.TargetGroup`</span>. The functionality is identical.

        ## Example Usage

        ### Instance Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const test = new aws.lb.TargetGroup("test", {
            name: "tf-example-lb-tg",
            port: 80,
            protocol: "HTTP",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        test = aws.lb.TargetGroup("test",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            vpc_id=main.id)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var main = new Aws.Ec2.Vpc("main", new()
            {
                CidrBlock = "10.0.0.0/16",
            });

            var test = new Aws.LB.TargetGroup("test", new()
            {
                Name = "tf-example-lb-tg",
                Port = 80,
                Protocol = "HTTP",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "test", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-tg"),
        			Port:     pulumi.Int(80),
        			Protocol: pulumi.String("HTTP"),
        			VpcId:    main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.Vpc;
        import com.pulumi.aws.ec2.VpcArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var test = new TargetGroup("test", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .port(80)
                    .protocol("HTTP")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          test:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              port: 80
              protocol: HTTP
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        <!--End PulumiCodeChooser -->

        ### IP Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const ip_example = new aws.lb.TargetGroup("ip-example", {
            name: "tf-example-lb-tg",
            port: 80,
            protocol: "HTTP",
            targetType: "ip",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        ip_example = aws.lb.TargetGroup("ip-example",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            target_type="ip",
            vpc_id=main.id)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var main = new Aws.Ec2.Vpc("main", new()
            {
                CidrBlock = "10.0.0.0/16",
            });

            var ip_example = new Aws.LB.TargetGroup("ip-example", new()
            {
                Name = "tf-example-lb-tg",
                Port = 80,
                Protocol = "HTTP",
                TargetType = "ip",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "ip-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-tg"),
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("HTTP"),
        			TargetType: pulumi.String("ip"),
        			VpcId:      main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.Vpc;
        import com.pulumi.aws.ec2.VpcArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var ip_example = new TargetGroup("ip-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .port(80)
                    .protocol("HTTP")
                    .targetType("ip")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ip-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              port: 80
              protocol: HTTP
              targetType: ip
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const lambda_example = new aws.lb.TargetGroup("lambda-example", {
            name: "tf-example-lb-tg",
            targetType: "lambda",
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example",
            name="tf-example-lb-tg",
            target_type="lambda")
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var lambda_example = new Aws.LB.TargetGroup("lambda-example", new()
            {
                Name = "tf-example-lb-tg",
                TargetType = "lambda",
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "lambda-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-tg"),
        			TargetType: pulumi.String("lambda"),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .targetType("lambda")
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          lambda-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              targetType: lambda
        ```
        <!--End PulumiCodeChooser -->

        ### ALB Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const alb_example = new aws.lb.TargetGroup("alb-example", {
            name: "tf-example-lb-alb-tg",
            targetType: "alb",
            port: 80,
            protocol: "TCP",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        alb_example = aws.lb.TargetGroup("alb-example",
            name="tf-example-lb-alb-tg",
            target_type="alb",
            port=80,
            protocol="TCP",
            vpc_id=main["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var alb_example = new Aws.LB.TargetGroup("alb-example", new()
            {
                Name = "tf-example-lb-alb-tg",
                TargetType = "alb",
                Port = 80,
                Protocol = "TCP",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "alb-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-alb-tg"),
        			TargetType: pulumi.String("alb"),
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("TCP"),
        			VpcId:      pulumi.Any(main.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var alb_example = new TargetGroup("alb-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-alb-tg")
                    .targetType("alb")
                    .port(80)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          alb-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-alb-tg
              targetType: alb
              port: 80
              protocol: TCP
              vpcId: ${main.id}
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with unhealthy connection termination disabled

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const tcp_example = new aws.lb.TargetGroup("tcp-example", {
            name: "tf-example-lb-nlb-tg",
            port: 25,
            protocol: "TCP",
            vpcId: main.id,
            targetHealthStates: [{
                enableUnhealthyConnectionTermination: false,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=25,
            protocol="TCP",
            vpc_id=main["id"],
            target_health_states=[{
                "enable_unhealthy_connection_termination": False,
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
            {
                Name = "tf-example-lb-nlb-tg",
                Port = 25,
                Protocol = "TCP",
                VpcId = main.Id,
                TargetHealthStates = new[]
                {
                    new Aws.LB.Inputs.TargetGroupTargetHealthStateArgs
                    {
                        EnableUnhealthyConnectionTermination = false,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-nlb-tg"),
        			Port:     pulumi.Int(25),
        			Protocol: pulumi.String("TCP"),
        			VpcId:    pulumi.Any(main.Id),
        			TargetHealthStates: lb.TargetGroupTargetHealthStateArray{
        				&lb.TargetGroupTargetHealthStateArgs{
        					EnableUnhealthyConnectionTermination: pulumi.Bool(false),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-nlb-tg")
                    .port(25)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .targetHealthStates(TargetGroupTargetHealthStateArgs.builder()
                        .enableUnhealthyConnectionTermination(false)
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          tcp-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-nlb-tg
              port: 25
              protocol: TCP
              vpcId: ${main.id}
              targetHealthStates:
                - enableUnhealthyConnectionTermination: false
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with health requirements

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const tcp_example = new aws.lb.TargetGroup("tcp-example", {
            name: "tf-example-lb-nlb-tg",
            port: 80,
            protocol: "TCP",
            vpcId: main.id,
            targetGroupHealth: {
                dnsFailover: {
                    minimumHealthyTargetsCount: "1",
                    minimumHealthyTargetsPercentage: "off",
                },
                unhealthyStateRouting: {
                    minimumHealthyTargetsCount: 1,
                    minimumHealthyTargetsPercentage: "off",
                },
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=80,
            protocol="TCP",
            vpc_id=main["id"],
            target_group_health={
                "dns_failover": {
                    "minimum_healthy_targets_count": "1",
                    "minimum_healthy_targets_percentage": "off",
                },
                "unhealthy_state_routing": {
                    "minimum_healthy_targets_count": 1,
                    "minimum_healthy_targets_percentage": "off",
                },
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
            {
                Name = "tf-example-lb-nlb-tg",
                Port = 80,
                Protocol = "TCP",
                VpcId = main.Id,
                TargetGroupHealth = new Aws.LB.Inputs.TargetGroupTargetGroupHealthArgs
                {
                    DnsFailover = new Aws.LB.Inputs.TargetGroupTargetGroupHealthDnsFailoverArgs
                    {
                        MinimumHealthyTargetsCount = "1",
                        MinimumHealthyTargetsPercentage = "off",
                    },
                    UnhealthyStateRouting = new Aws.LB.Inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs
                    {
                        MinimumHealthyTargetsCount = 1,
                        MinimumHealthyTargetsPercentage = "off",
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-nlb-tg"),
        			Port:     pulumi.Int(80),
        			Protocol: pulumi.String("TCP"),
        			VpcId:    pulumi.Any(main.Id),
        			TargetGroupHealth: &lb.TargetGroupTargetGroupHealthArgs{
        				DnsFailover: &lb.TargetGroupTargetGroupHealthDnsFailoverArgs{
        					MinimumHealthyTargetsCount:      pulumi.String("1"),
        					MinimumHealthyTargetsPercentage: pulumi.String("off"),
        				},
        				UnhealthyStateRouting: &lb.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs{
        					MinimumHealthyTargetsCount:      pulumi.Int(1),
        					MinimumHealthyTargetsPercentage: pulumi.String("off"),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-nlb-tg")
                    .port(80)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .targetGroupHealth(TargetGroupTargetGroupHealthArgs.builder()
                        .dnsFailover(TargetGroupTargetGroupHealthDnsFailoverArgs.builder()
                            .minimumHealthyTargetsCount("1")
                            .minimumHealthyTargetsPercentage("off")
                            .build())
                        .unhealthyStateRouting(TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs.builder()
                            .minimumHealthyTargetsCount(1)
                            .minimumHealthyTargetsPercentage("off")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          tcp-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-nlb-tg
              port: 80
              protocol: TCP
              vpcId: ${main.id}
              targetGroupHealth:
                dnsFailover:
                  minimumHealthyTargetsCount: '1'
                  minimumHealthyTargetsPercentage: off
                unhealthyStateRouting:
                  minimumHealthyTargetsCount: '1'
                  minimumHealthyTargetsPercentage: off
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the target group.

        Using `pulumi import`, import Target Groups using their ARN. For example:

        console

        % pulumi import aws_lb_target_group.app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314
        """
        connection_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        deregistration_delay: NotRequired[pulumi.Input[_builtins.int]]
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        health_check: NotRequired[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgsDict']]
        """
        Health Check configuration block. Detailed below.
        """
        ip_address_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of IP addresses used by the target group, only supported when target type is set to <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>. Possible values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> or <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        """
        lambda_multi_value_headers_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        load_balancing_algorithm_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>, <span pulumi-lang-nodejs="`leastOutstandingRequests`" pulumi-lang-dotnet="`LeastOutstandingRequests`" pulumi-lang-go="`leastOutstandingRequests`" pulumi-lang-python="`least_outstanding_requests`" pulumi-lang-yaml="`leastOutstandingRequests`" pulumi-lang-java="`leastOutstandingRequests`">`least_outstanding_requests`</span>, or <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span>. The default is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>.
        """
        load_balancing_anomaly_mitigation: NotRequired[pulumi.Input[_builtins.str]]
        """
        Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span> load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        """
        load_balancing_cross_zone_enabled: NotRequired[pulumi.Input[_builtins.str]]
        """
        Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`. The default is `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        """
        name_prefix: NotRequired[pulumi.Input[_builtins.str]]
        """
        Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>. Cannot be longer than 6 characters.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Port on which targets receive traffic, unless overridden when registering a specific target. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        preserve_client_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Protocol to use for routing traffic to the targets.
        Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
        Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>.
        Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        protocol_version: NotRequired[pulumi.Input[_builtins.str]]
        """
        Only applicable when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        """
        proxy_protocol_v2: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        slow_start: NotRequired[pulumi.Input[_builtins.int]]
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        stickiness: NotRequired[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgsDict']]
        """
        Stickiness configuration block. Detailed below.
        """
        tags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        target_failovers: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetFailoverArgsDict']]]]
        """
        Target failover block. Only applicable for Gateway Load Balancer target groups. See<span pulumi-lang-nodejs=" targetFailover " pulumi-lang-dotnet=" TargetFailover " pulumi-lang-go=" targetFailover " pulumi-lang-python=" target_failover " pulumi-lang-yaml=" targetFailover " pulumi-lang-java=" targetFailover "> target_failover </span>for more information.
        """
        target_group_health: NotRequired[pulumi.Input['pulumi_aws.lb.TargetGroupTargetGroupHealthArgsDict']]
        """
        Target health requirements block. See<span pulumi-lang-nodejs=" targetGroupHealth " pulumi-lang-dotnet=" TargetGroupHealth " pulumi-lang-go=" targetGroupHealth " pulumi-lang-python=" target_group_health " pulumi-lang-yaml=" targetGroupHealth " pulumi-lang-java=" targetGroupHealth "> target_group_health </span>for more information.
        """
        target_health_states: NotRequired[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetHealthStateArgsDict']]]]
        """
        Target health state block. Only applicable for Network Load Balancer target groups when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TCP` or `TLS`. See<span pulumi-lang-nodejs=" targetHealthState " pulumi-lang-dotnet=" TargetHealthState " pulumi-lang-go=" targetHealthState " pulumi-lang-python=" target_health_state " pulumi-lang-yaml=" targetHealthState " pulumi-lang-java=" targetHealthState "> target_health_state </span>for more information.
        """
        target_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of target that you must specify when registering targets with this target group.
        See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
        The default is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>.

        Note that you can't specify targets for a target group using both instance IDs and IP addresses.

        If the target type is <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.

        Network Load Balancers do not support the <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span> target type.

        Application Load Balancers do not support the <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span> target type.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Identifier of the VPC in which to create the target group. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
elif False:
    TargetGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupArgs:
    def __init__(__self__, *,
                 connection_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 deregistration_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_multi_value_headers_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_balancing_algorithm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_anomaly_mitigation: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancing_cross_zone_enabled: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 preserve_client_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol_version: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_protocol_v2: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_start: Optional[pulumi.Input[_builtins.int]] = None,
                 stickiness: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_failovers: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetFailoverArgs']]]] = None,
                 target_group_health: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupTargetGroupHealthArgs']] = None,
                 target_health_states: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetHealthStateArgs']]]] = None,
                 target_type: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Provides a Target Group resource for use with Load Balancer resources.

        > **Note:** <span pulumi-lang-nodejs="`aws.alb.TargetGroup`" pulumi-lang-dotnet="`aws.alb.TargetGroup`" pulumi-lang-go="`alb.TargetGroup`" pulumi-lang-python="`alb.TargetGroup`" pulumi-lang-yaml="`aws.alb.TargetGroup`" pulumi-lang-java="`aws.alb.TargetGroup`">`aws.alb.TargetGroup`</span> is known as <span pulumi-lang-nodejs="`aws.lb.TargetGroup`" pulumi-lang-dotnet="`aws.lb.TargetGroup`" pulumi-lang-go="`lb.TargetGroup`" pulumi-lang-python="`lb.TargetGroup`" pulumi-lang-yaml="`aws.lb.TargetGroup`" pulumi-lang-java="`aws.lb.TargetGroup`">`aws.lb.TargetGroup`</span>. The functionality is identical.

        ## Example Usage

        ### Instance Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const test = new aws.lb.TargetGroup("test", {
            name: "tf-example-lb-tg",
            port: 80,
            protocol: "HTTP",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        test = aws.lb.TargetGroup("test",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            vpc_id=main.id)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var main = new Aws.Ec2.Vpc("main", new()
            {
                CidrBlock = "10.0.0.0/16",
            });

            var test = new Aws.LB.TargetGroup("test", new()
            {
                Name = "tf-example-lb-tg",
                Port = 80,
                Protocol = "HTTP",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "test", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-tg"),
        			Port:     pulumi.Int(80),
        			Protocol: pulumi.String("HTTP"),
        			VpcId:    main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.Vpc;
        import com.pulumi.aws.ec2.VpcArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var test = new TargetGroup("test", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .port(80)
                    .protocol("HTTP")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          test:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              port: 80
              protocol: HTTP
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        <!--End PulumiCodeChooser -->

        ### IP Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const main = new aws.ec2.Vpc("main", {cidrBlock: "10.0.0.0/16"});
        const ip_example = new aws.lb.TargetGroup("ip-example", {
            name: "tf-example-lb-tg",
            port: 80,
            protocol: "HTTP",
            targetType: "ip",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.ec2.Vpc("main", cidr_block="10.0.0.0/16")
        ip_example = aws.lb.TargetGroup("ip-example",
            name="tf-example-lb-tg",
            port=80,
            protocol="HTTP",
            target_type="ip",
            vpc_id=main.id)
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var main = new Aws.Ec2.Vpc("main", new()
            {
                CidrBlock = "10.0.0.0/16",
            });

            var ip_example = new Aws.LB.TargetGroup("ip-example", new()
            {
                Name = "tf-example-lb-tg",
                Port = 80,
                Protocol = "HTTP",
                TargetType = "ip",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/ec2"
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		main, err := ec2.NewVpc(ctx, "main", &ec2.VpcArgs{
        			CidrBlock: pulumi.String("10.0.0.0/16"),
        		})
        		if err != nil {
        			return err
        		}
        		_, err = lb.NewTargetGroup(ctx, "ip-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-tg"),
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("HTTP"),
        			TargetType: pulumi.String("ip"),
        			VpcId:      main.ID(),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.ec2.Vpc;
        import com.pulumi.aws.ec2.VpcArgs;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var main = new Vpc("main", VpcArgs.builder()
                    .cidrBlock("10.0.0.0/16")
                    .build());

                var ip_example = new TargetGroup("ip-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .port(80)
                    .protocol("HTTP")
                    .targetType("ip")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          ip-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              port: 80
              protocol: HTTP
              targetType: ip
              vpcId: ${main.id}
          main:
            type: aws:ec2:Vpc
            properties:
              cidrBlock: 10.0.0.0/16
        ```
        <!--End PulumiCodeChooser -->

        ### Lambda Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const lambda_example = new aws.lb.TargetGroup("lambda-example", {
            name: "tf-example-lb-tg",
            targetType: "lambda",
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        lambda_example = aws.lb.TargetGroup("lambda-example",
            name="tf-example-lb-tg",
            target_type="lambda")
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var lambda_example = new Aws.LB.TargetGroup("lambda-example", new()
            {
                Name = "tf-example-lb-tg",
                TargetType = "lambda",
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "lambda-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-tg"),
        			TargetType: pulumi.String("lambda"),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var lambda_example = new TargetGroup("lambda-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-tg")
                    .targetType("lambda")
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          lambda-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-tg
              targetType: lambda
        ```
        <!--End PulumiCodeChooser -->

        ### ALB Target Group

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const alb_example = new aws.lb.TargetGroup("alb-example", {
            name: "tf-example-lb-alb-tg",
            targetType: "alb",
            port: 80,
            protocol: "TCP",
            vpcId: main.id,
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        alb_example = aws.lb.TargetGroup("alb-example",
            name="tf-example-lb-alb-tg",
            target_type="alb",
            port=80,
            protocol="TCP",
            vpc_id=main["id"])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var alb_example = new Aws.LB.TargetGroup("alb-example", new()
            {
                Name = "tf-example-lb-alb-tg",
                TargetType = "alb",
                Port = 80,
                Protocol = "TCP",
                VpcId = main.Id,
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "alb-example", &lb.TargetGroupArgs{
        			Name:       pulumi.String("tf-example-lb-alb-tg"),
        			TargetType: pulumi.String("alb"),
        			Port:       pulumi.Int(80),
        			Protocol:   pulumi.String("TCP"),
        			VpcId:      pulumi.Any(main.Id),
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var alb_example = new TargetGroup("alb-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-alb-tg")
                    .targetType("alb")
                    .port(80)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          alb-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-alb-tg
              targetType: alb
              port: 80
              protocol: TCP
              vpcId: ${main.id}
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with unhealthy connection termination disabled

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const tcp_example = new aws.lb.TargetGroup("tcp-example", {
            name: "tf-example-lb-nlb-tg",
            port: 25,
            protocol: "TCP",
            vpcId: main.id,
            targetHealthStates: [{
                enableUnhealthyConnectionTermination: false,
            }],
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=25,
            protocol="TCP",
            vpc_id=main["id"],
            target_health_states=[{
                "enable_unhealthy_connection_termination": False,
            }])
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
            {
                Name = "tf-example-lb-nlb-tg",
                Port = 25,
                Protocol = "TCP",
                VpcId = main.Id,
                TargetHealthStates = new[]
                {
                    new Aws.LB.Inputs.TargetGroupTargetHealthStateArgs
                    {
                        EnableUnhealthyConnectionTermination = false,
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-nlb-tg"),
        			Port:     pulumi.Int(25),
        			Protocol: pulumi.String("TCP"),
        			VpcId:    pulumi.Any(main.Id),
        			TargetHealthStates: lb.TargetGroupTargetHealthStateArray{
        				&lb.TargetGroupTargetHealthStateArgs{
        					EnableUnhealthyConnectionTermination: pulumi.Bool(false),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetHealthStateArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-nlb-tg")
                    .port(25)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .targetHealthStates(TargetGroupTargetHealthStateArgs.builder()
                        .enableUnhealthyConnectionTermination(false)
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          tcp-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-nlb-tg
              port: 25
              protocol: TCP
              vpcId: ${main.id}
              targetHealthStates:
                - enableUnhealthyConnectionTermination: false
        ```
        <!--End PulumiCodeChooser -->

        ### Target group with health requirements

        <!--Start PulumiCodeChooser -->
        ```typescript
        import * as pulumi from "@pulumi/pulumi";
        import * as aws from "@pulumi/aws";

        const tcp_example = new aws.lb.TargetGroup("tcp-example", {
            name: "tf-example-lb-nlb-tg",
            port: 80,
            protocol: "TCP",
            vpcId: main.id,
            targetGroupHealth: {
                dnsFailover: {
                    minimumHealthyTargetsCount: "1",
                    minimumHealthyTargetsPercentage: "off",
                },
                unhealthyStateRouting: {
                    minimumHealthyTargetsCount: 1,
                    minimumHealthyTargetsPercentage: "off",
                },
            },
        });
        ```
        ```python
        import pulumi
        import pulumi_aws as aws

        tcp_example = aws.lb.TargetGroup("tcp-example",
            name="tf-example-lb-nlb-tg",
            port=80,
            protocol="TCP",
            vpc_id=main["id"],
            target_group_health={
                "dns_failover": {
                    "minimum_healthy_targets_count": "1",
                    "minimum_healthy_targets_percentage": "off",
                },
                "unhealthy_state_routing": {
                    "minimum_healthy_targets_count": 1,
                    "minimum_healthy_targets_percentage": "off",
                },
            })
        ```
        ```csharp
        using System.Collections.Generic;
        using System.Linq;
        using Pulumi;
        using Aws = Pulumi.Aws;

        return await Deployment.RunAsync(() => 
        {
            var tcp_example = new Aws.LB.TargetGroup("tcp-example", new()
            {
                Name = "tf-example-lb-nlb-tg",
                Port = 80,
                Protocol = "TCP",
                VpcId = main.Id,
                TargetGroupHealth = new Aws.LB.Inputs.TargetGroupTargetGroupHealthArgs
                {
                    DnsFailover = new Aws.LB.Inputs.TargetGroupTargetGroupHealthDnsFailoverArgs
                    {
                        MinimumHealthyTargetsCount = "1",
                        MinimumHealthyTargetsPercentage = "off",
                    },
                    UnhealthyStateRouting = new Aws.LB.Inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs
                    {
                        MinimumHealthyTargetsCount = 1,
                        MinimumHealthyTargetsPercentage = "off",
                    },
                },
            });

        });
        ```
        ```go
        package main

        import (
        	"github.com/pulumi/pulumi-aws/sdk/v7/go/aws/lb"
        	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
        )

        func main() {
        	pulumi.Run(func(ctx *pulumi.Context) error {
        		_, err := lb.NewTargetGroup(ctx, "tcp-example", &lb.TargetGroupArgs{
        			Name:     pulumi.String("tf-example-lb-nlb-tg"),
        			Port:     pulumi.Int(80),
        			Protocol: pulumi.String("TCP"),
        			VpcId:    pulumi.Any(main.Id),
        			TargetGroupHealth: &lb.TargetGroupTargetGroupHealthArgs{
        				DnsFailover: &lb.TargetGroupTargetGroupHealthDnsFailoverArgs{
        					MinimumHealthyTargetsCount:      pulumi.String("1"),
        					MinimumHealthyTargetsPercentage: pulumi.String("off"),
        				},
        				UnhealthyStateRouting: &lb.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs{
        					MinimumHealthyTargetsCount:      pulumi.Int(1),
        					MinimumHealthyTargetsPercentage: pulumi.String("off"),
        				},
        			},
        		})
        		if err != nil {
        			return err
        		}
        		return nil
        	})
        }
        ```
        ```java
        package generated_program;

        import com.pulumi.Context;
        import com.pulumi.Pulumi;
        import com.pulumi.core.Output;
        import com.pulumi.aws.lb.TargetGroup;
        import com.pulumi.aws.lb.TargetGroupArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthDnsFailoverArgs;
        import com.pulumi.aws.lb.inputs.TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs;
        import java.util.List;
        import java.util.ArrayList;
        import java.util.Map;
        import java.io.File;
        import java.nio.file.Files;
        import java.nio.file.Paths;

        public class App {
            public static void main(String[] args) {
                Pulumi.run(App::stack);
            }

            public static void stack(Context ctx) {
                var tcp_example = new TargetGroup("tcp-example", TargetGroupArgs.builder()
                    .name("tf-example-lb-nlb-tg")
                    .port(80)
                    .protocol("TCP")
                    .vpcId(main.id())
                    .targetGroupHealth(TargetGroupTargetGroupHealthArgs.builder()
                        .dnsFailover(TargetGroupTargetGroupHealthDnsFailoverArgs.builder()
                            .minimumHealthyTargetsCount("1")
                            .minimumHealthyTargetsPercentage("off")
                            .build())
                        .unhealthyStateRouting(TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs.builder()
                            .minimumHealthyTargetsCount(1)
                            .minimumHealthyTargetsPercentage("off")
                            .build())
                        .build())
                    .build());

            }
        }
        ```
        ```yaml
        resources:
          tcp-example:
            type: aws:lb:TargetGroup
            properties:
              name: tf-example-lb-nlb-tg
              port: 80
              protocol: TCP
              vpcId: ${main.id}
              targetGroupHealth:
                dnsFailover:
                  minimumHealthyTargetsCount: '1'
                  minimumHealthyTargetsPercentage: off
                unhealthyStateRouting:
                  minimumHealthyTargetsCount: '1'
                  minimumHealthyTargetsPercentage: off
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ### Identity Schema

        #### Required

        - `arn` (String) Amazon Resource Name (ARN) of the target group.

        Using `pulumi import`, import Target Groups using their ARN. For example:

        console

        % pulumi import aws_lb_target_group.app_front_end arn:aws:elasticloadbalancing:us-west-2:187416307283:targetgroup/app-front-end/20cfe21448b66314


        :param pulumi.Input[_builtins.bool] connection_termination: Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.int] deregistration_delay: Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        :param pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs'] health_check: Health Check configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] ip_address_type: The type of IP addresses used by the target group, only supported when target type is set to <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>. Possible values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> or <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        :param pulumi.Input[_builtins.bool] lambda_multi_value_headers_enabled: Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] load_balancing_algorithm_type: Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>, <span pulumi-lang-nodejs="`leastOutstandingRequests`" pulumi-lang-dotnet="`LeastOutstandingRequests`" pulumi-lang-go="`leastOutstandingRequests`" pulumi-lang-python="`least_outstanding_requests`" pulumi-lang-yaml="`leastOutstandingRequests`" pulumi-lang-java="`leastOutstandingRequests`">`least_outstanding_requests`</span>, or <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span>. The default is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>.
        :param pulumi.Input[_builtins.str] load_balancing_anomaly_mitigation: Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span> load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        :param pulumi.Input[_builtins.str] load_balancing_cross_zone_enabled: Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`. The default is `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`.
        :param pulumi.Input[_builtins.str] name: Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>. Cannot be longer than 6 characters.
        :param pulumi.Input[_builtins.int] port: Port on which targets receive traffic, unless overridden when registering a specific target. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        :param pulumi.Input[_builtins.str] preserve_client_ip: Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        :param pulumi.Input[_builtins.str] protocol: Protocol to use for routing traffic to the targets.
               Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
               Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>.
               Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        :param pulumi.Input[_builtins.str] protocol_version: Only applicable when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        :param pulumi.Input[_builtins.bool] proxy_protocol_v2: Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] slow_start: Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        :param pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs'] stickiness: Stickiness configuration block. Detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetFailoverArgs']]] target_failovers: Target failover block. Only applicable for Gateway Load Balancer target groups. See<span pulumi-lang-nodejs=" targetFailover " pulumi-lang-dotnet=" TargetFailover " pulumi-lang-go=" targetFailover " pulumi-lang-python=" target_failover " pulumi-lang-yaml=" targetFailover " pulumi-lang-java=" targetFailover "> target_failover </span>for more information.
        :param pulumi.Input['pulumi_aws.lb.TargetGroupTargetGroupHealthArgs'] target_group_health: Target health requirements block. See<span pulumi-lang-nodejs=" targetGroupHealth " pulumi-lang-dotnet=" TargetGroupHealth " pulumi-lang-go=" targetGroupHealth " pulumi-lang-python=" target_group_health " pulumi-lang-yaml=" targetGroupHealth " pulumi-lang-java=" targetGroupHealth "> target_group_health </span>for more information.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetHealthStateArgs']]] target_health_states: Target health state block. Only applicable for Network Load Balancer target groups when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TCP` or `TLS`. See<span pulumi-lang-nodejs=" targetHealthState " pulumi-lang-dotnet=" TargetHealthState " pulumi-lang-go=" targetHealthState " pulumi-lang-python=" target_health_state " pulumi-lang-yaml=" targetHealthState " pulumi-lang-java=" targetHealthState "> target_health_state </span>for more information.
        :param pulumi.Input[_builtins.str] target_type: Type of target that you must specify when registering targets with this target group.
               See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
               The default is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>.
               
               Note that you can't specify targets for a target group using both instance IDs and IP addresses.
               
               If the target type is <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
               
               Network Load Balancers do not support the <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span> target type.
               
               Application Load Balancers do not support the <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span> target type.
        :param pulumi.Input[_builtins.str] vpc_id: Identifier of the VPC in which to create the target group. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        if connection_termination is not None:
            pulumi.set(__self__, "connection_termination", connection_termination)
        if deregistration_delay is not None:
            pulumi.set(__self__, "deregistration_delay", deregistration_delay)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_multi_value_headers_enabled is not None:
            pulumi.set(__self__, "lambda_multi_value_headers_enabled", lambda_multi_value_headers_enabled)
        if load_balancing_algorithm_type is not None:
            pulumi.set(__self__, "load_balancing_algorithm_type", load_balancing_algorithm_type)
        if load_balancing_anomaly_mitigation is not None:
            pulumi.set(__self__, "load_balancing_anomaly_mitigation", load_balancing_anomaly_mitigation)
        if load_balancing_cross_zone_enabled is not None:
            pulumi.set(__self__, "load_balancing_cross_zone_enabled", load_balancing_cross_zone_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preserve_client_ip is not None:
            pulumi.set(__self__, "preserve_client_ip", preserve_client_ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if proxy_protocol_v2 is not None:
            pulumi.set(__self__, "proxy_protocol_v2", proxy_protocol_v2)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if slow_start is not None:
            pulumi.set(__self__, "slow_start", slow_start)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_failovers is not None:
            pulumi.set(__self__, "target_failovers", target_failovers)
        if target_group_health is not None:
            pulumi.set(__self__, "target_group_health", target_group_health)
        if target_health_states is not None:
            pulumi.set(__self__, "target_health_states", target_health_states)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="connectionTermination")
    def connection_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to terminate connections at the end of the deregistration timeout on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "connection_termination")

    @connection_termination.setter
    def connection_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "connection_termination", value)

    @_builtins.property
    @pulumi.getter(name="deregistrationDelay")
    def deregistration_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount time for Elastic Load Balancing to wait before changing the state of a deregistering target from draining to unused. The range is 0-3600 seconds. The default value is 300 seconds.
        """
        return pulumi.get(self, "deregistration_delay")

    @deregistration_delay.setter
    def deregistration_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "deregistration_delay", value)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']]:
        """
        Health Check configuration block. Detailed below.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupHealthCheckArgs']]):
        pulumi.set(self, "health_check", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of IP addresses used by the target group, only supported when target type is set to <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>. Possible values are <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> or <span pulumi-lang-nodejs="`ipv6`" pulumi-lang-dotnet="`Ipv6`" pulumi-lang-go="`ipv6`" pulumi-lang-python="`ipv6`" pulumi-lang-yaml="`ipv6`" pulumi-lang-java="`ipv6`">`ipv6`</span>.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the request and response headers exchanged between the load balancer and the Lambda function include arrays of values or strings. Only applies when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "lambda_multi_value_headers_enabled")

    @lambda_multi_value_headers_enabled.setter
    def lambda_multi_value_headers_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lambda_multi_value_headers_enabled", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how the load balancer selects targets when routing requests. Only applicable for Application Load Balancer Target Groups. The value is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>, <span pulumi-lang-nodejs="`leastOutstandingRequests`" pulumi-lang-dotnet="`LeastOutstandingRequests`" pulumi-lang-go="`leastOutstandingRequests`" pulumi-lang-python="`least_outstanding_requests`" pulumi-lang-yaml="`leastOutstandingRequests`" pulumi-lang-java="`leastOutstandingRequests`">`least_outstanding_requests`</span>, or <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span>. The default is <span pulumi-lang-nodejs="`roundRobin`" pulumi-lang-dotnet="`RoundRobin`" pulumi-lang-go="`roundRobin`" pulumi-lang-python="`round_robin`" pulumi-lang-yaml="`roundRobin`" pulumi-lang-java="`roundRobin`">`round_robin`</span>.
        """
        return pulumi.get(self, "load_balancing_algorithm_type")

    @load_balancing_algorithm_type.setter
    def load_balancing_algorithm_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_algorithm_type", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingAnomalyMitigation")
    def load_balancing_anomaly_mitigation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines whether to enable target anomaly mitigation.  Target anomaly mitigation is only supported by the <span pulumi-lang-nodejs="`weightedRandom`" pulumi-lang-dotnet="`WeightedRandom`" pulumi-lang-go="`weightedRandom`" pulumi-lang-python="`weighted_random`" pulumi-lang-yaml="`weightedRandom`" pulumi-lang-java="`weightedRandom`">`weighted_random`</span> load balancing algorithm type.  See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#automatic-target-weights) for more information.  The value is `"on"` or `"off"`. The default is `"off"`.
        """
        return pulumi.get(self, "load_balancing_anomaly_mitigation")

    @load_balancing_anomaly_mitigation.setter
    def load_balancing_anomaly_mitigation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_anomaly_mitigation", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancingCrossZoneEnabled")
    def load_balancing_cross_zone_enabled(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether cross zone load balancing is enabled. The value is `"true"`, `"false"` or `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`. The default is `<span pulumi-lang-nodejs=""useLoadBalancerConfiguration"" pulumi-lang-dotnet=""UseLoadBalancerConfiguration"" pulumi-lang-go=""useLoadBalancerConfiguration"" pulumi-lang-python=""use_load_balancer_configuration"" pulumi-lang-yaml=""useLoadBalancerConfiguration"" pulumi-lang-java=""useLoadBalancerConfiguration"">"use_load_balancer_configuration"</span>`.
        """
        return pulumi.get(self, "load_balancing_cross_zone_enabled")

    @load_balancing_cross_zone_enabled.setter
    def load_balancing_cross_zone_enabled(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancing_cross_zone_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the target group. If omitted, this provider will assign a random, unique name. This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>. Cannot be longer than 6 characters.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port on which targets receive traffic, unless overridden when registering a specific target. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="preserveClientIp")
    def preserve_client_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether client IP preservation is enabled. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#client-ip-preservation) for more information.
        """
        return pulumi.get(self, "preserve_client_ip")

    @preserve_client_ip.setter
    def preserve_client_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preserve_client_ip", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol to use for routing traffic to the targets.
        Should be one of `GENEVE`, `HTTP`, `HTTPS`, `TCP`, `TCP_UDP`, `TLS`, or `UDP`.
        Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>.
        Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only applicable when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `HTTP` or `HTTPS`. The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1
        """
        return pulumi.get(self, "protocol_version")

    @protocol_version.setter
    def protocol_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol_version", value)

    @_builtins.property
    @pulumi.getter(name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable support for proxy protocol v2 on Network Load Balancers. See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#proxy-protocol) for more information. Default is <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "proxy_protocol_v2")

    @proxy_protocol_v2.setter
    def proxy_protocol_v2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "proxy_protocol_v2", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="slowStart")
    def slow_start(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount time for targets to warm up before the load balancer sends them a full share of requests. The range is 30-900 seconds or 0 to disable. The default value is 0 seconds.
        """
        return pulumi.get(self, "slow_start")

    @slow_start.setter
    def slow_start(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slow_start", value)

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']]:
        """
        Stickiness configuration block. Detailed below.
        """
        return pulumi.get(self, "stickiness")

    @stickiness.setter
    def stickiness(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupStickinessArgs']]):
        pulumi.set(self, "stickiness", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetFailovers")
    def target_failovers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetFailoverArgs']]]]:
        """
        Target failover block. Only applicable for Gateway Load Balancer target groups. See<span pulumi-lang-nodejs=" targetFailover " pulumi-lang-dotnet=" TargetFailover " pulumi-lang-go=" targetFailover " pulumi-lang-python=" target_failover " pulumi-lang-yaml=" targetFailover " pulumi-lang-java=" targetFailover "> target_failover </span>for more information.
        """
        return pulumi.get(self, "target_failovers")

    @target_failovers.setter
    def target_failovers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetFailoverArgs']]]]):
        pulumi.set(self, "target_failovers", value)

    @_builtins.property
    @pulumi.getter(name="targetGroupHealth")
    def target_group_health(self) -> Optional[pulumi.Input['pulumi_aws.lb.TargetGroupTargetGroupHealthArgs']]:
        """
        Target health requirements block. See<span pulumi-lang-nodejs=" targetGroupHealth " pulumi-lang-dotnet=" TargetGroupHealth " pulumi-lang-go=" targetGroupHealth " pulumi-lang-python=" target_group_health " pulumi-lang-yaml=" targetGroupHealth " pulumi-lang-java=" targetGroupHealth "> target_group_health </span>for more information.
        """
        return pulumi.get(self, "target_group_health")

    @target_group_health.setter
    def target_group_health(self, value: Optional[pulumi.Input['pulumi_aws.lb.TargetGroupTargetGroupHealthArgs']]):
        pulumi.set(self, "target_group_health", value)

    @_builtins.property
    @pulumi.getter(name="targetHealthStates")
    def target_health_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetHealthStateArgs']]]]:
        """
        Target health state block. Only applicable for Network Load Balancer target groups when <span pulumi-lang-nodejs="`protocol`" pulumi-lang-dotnet="`Protocol`" pulumi-lang-go="`protocol`" pulumi-lang-python="`protocol`" pulumi-lang-yaml="`protocol`" pulumi-lang-java="`protocol`">`protocol`</span> is `TCP` or `TLS`. See<span pulumi-lang-nodejs=" targetHealthState " pulumi-lang-dotnet=" TargetHealthState " pulumi-lang-go=" targetHealthState " pulumi-lang-python=" target_health_state " pulumi-lang-yaml=" targetHealthState " pulumi-lang-java=" targetHealthState "> target_health_state </span>for more information.
        """
        return pulumi.get(self, "target_health_states")

    @target_health_states.setter
    def target_health_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.TargetGroupTargetHealthStateArgs']]]]):
        pulumi.set(self, "target_health_states", value)

    @_builtins.property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of target that you must specify when registering targets with this target group.
        See [doc](https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_CreateTargetGroup.html) for supported values.
        The default is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>.

        Note that you can't specify targets for a target group using both instance IDs and IP addresses.

        If the target type is <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span>, specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.

        Network Load Balancers do not support the <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span> target type.

        Application Load Balancers do not support the <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span> target type.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_type", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the VPC in which to create the target group. Required when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`instance`" pulumi-lang-dotnet="`Instance`" pulumi-lang-go="`instance`" pulumi-lang-python="`instance`" pulumi-lang-yaml="`instance`" pulumi-lang-java="`instance`">`instance`</span>, <span pulumi-lang-nodejs="`ip`" pulumi-lang-dotnet="`Ip`" pulumi-lang-go="`ip`" pulumi-lang-python="`ip`" pulumi-lang-yaml="`ip`" pulumi-lang-java="`ip`">`ip`</span> or <span pulumi-lang-nodejs="`alb`" pulumi-lang-dotnet="`Alb`" pulumi-lang-go="`alb`" pulumi-lang-python="`alb`" pulumi-lang-yaml="`alb`" pulumi-lang-java="`alb`">`alb`</span>. Does not apply when <span pulumi-lang-nodejs="`targetType`" pulumi-lang-dotnet="`TargetType`" pulumi-lang-go="`targetType`" pulumi-lang-python="`target_type`" pulumi-lang-yaml="`targetType`" pulumi-lang-java="`targetType`">`target_type`</span> is <span pulumi-lang-nodejs="`lambda`" pulumi-lang-dotnet="`Lambda`" pulumi-lang-go="`lambda`" pulumi-lang-python="`lambda`" pulumi-lang-yaml="`lambda`" pulumi-lang-java="`lambda`">`lambda`</span>.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


