# coding=utf-8
# *** WARNING: this file was generated by pulumi-gen-awsx. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import awsx as _awsx
from ._inputs import *
import pulumi_aws

__all__ = ['ApplicationLoadBalancerArgs', 'ApplicationLoadBalancer']

@pulumi.input_type
class ApplicationLoadBalancerArgs:
    def __init__(__self__, *,
                 access_logs: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerAccessLogsArgs']] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 default_security_group: Optional['_awsx.DefaultSecurityGroupArgs'] = None,
                 default_target_group: Optional['TargetGroupArgs'] = None,
                 default_target_group_port: Optional[pulumi.Input[_builtins.int]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']] = None,
                 listener: Optional['ListenerArgs'] = None,
                 listeners: Optional[Sequence['ListenerArgs']] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApplicationLoadBalancer resource.
        :param pulumi.Input['pulumi_aws.lb.LoadBalancerAccessLogsArgs'] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input['pulumi_aws.lb.LoadBalancerConnectionLogsArgs'] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param '_awsx.DefaultSecurityGroupArgs' default_security_group: Options for creating a default security group if [securityGroups] not specified.
        :param 'TargetGroupArgs' default_target_group: Options creating a default target group.
        :param pulumi.Input[_builtins.int] default_target_group_port: Port to use to connect with the target. Valid values are ports 1-65535. Defaults to 80.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are <span pulumi-lang-nodejs="`monitor`" pulumi-lang-dotnet="`Monitor`" pulumi-lang-go="`monitor`" pulumi-lang-python="`monitor`" pulumi-lang-yaml="`monitor`" pulumi-lang-java="`monitor`">`monitor`</span>, <span pulumi-lang-nodejs="`defensive`" pulumi-lang-dotnet="`Defensive`" pulumi-lang-go="`defensive`" pulumi-lang-python="`defensive`" pulumi-lang-yaml="`defensive`" pulumi-lang-java="`defensive`">`defensive`</span> (default), <span pulumi-lang-nodejs="`strictest`" pulumi-lang-dotnet="`Strictest`" pulumi-lang-go="`strictest`" pulumi-lang-python="`strictest`" pulumi-lang-yaml="`strictest`" pulumi-lang-java="`strictest`">`strictest`</span>.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are <span pulumi-lang-nodejs="`anyAvailabilityZone`" pulumi-lang-dotnet="`AnyAvailabilityZone`" pulumi-lang-go="`anyAvailabilityZone`" pulumi-lang-python="`any_availability_zone`" pulumi-lang-yaml="`anyAvailabilityZone`" pulumi-lang-java="`anyAvailabilityZone`">`any_availability_zone`</span> (default), <span pulumi-lang-nodejs="`availabilityZoneAffinity`" pulumi-lang-dotnet="`AvailabilityZoneAffinity`" pulumi-lang-go="`availabilityZoneAffinity`" pulumi-lang-python="`availability_zone_affinity`" pulumi-lang-yaml="`availabilityZoneAffinity`" pulumi-lang-java="`availabilityZoneAffinity`">`availability_zone_affinity`</span>, or <span pulumi-lang-nodejs="`partialAvailabilityZoneAffinity`" pulumi-lang-dotnet="`PartialAvailabilityZoneAffinity`" pulumi-lang-go="`partialAvailabilityZoneAffinity`" pulumi-lang-python="`partial_availability_zone_affinity`" pulumi-lang-yaml="`partialAvailabilityZoneAffinity`" pulumi-lang-java="`partialAvailabilityZoneAffinity`">`partial_availability_zone_affinity`</span>. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The possible values are <span pulumi-lang-nodejs="`on`" pulumi-lang-dotnet="`On`" pulumi-lang-go="`on`" pulumi-lang-python="`on`" pulumi-lang-yaml="`on`" pulumi-lang-java="`on`">`on`</span> and <span pulumi-lang-nodejs="`off`" pulumi-lang-dotnet="`Off`" pulumi-lang-go="`off`" pulumi-lang-python="`off`" pulumi-lang-yaml="`off`" pulumi-lang-java="`off`">`off`</span>.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> (all load balancer types), <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> (all load balancer types), and `dualstack-without-public-ipv4` (type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> only).
        :param pulumi.Input['pulumi_aws.lb.LoadBalancerIpamPoolsArgs'] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. See<span pulumi-lang-nodejs=" ipamPools " pulumi-lang-dotnet=" IpamPools " pulumi-lang-go=" ipamPools " pulumi-lang-python=" ipam_pools " pulumi-lang-yaml=" ipamPools " pulumi-lang-java=" ipamPools "> ipam_pools </span>for more information.
        :param 'ListenerArgs' listener: A listener to create. Only one of [listener] and [listeners] can be specified.
        :param Sequence['ListenerArgs'] listeners: List of listeners to create. Only one of [listener] and [listeners] can be specified.
        :param pulumi.Input['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs'] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. For load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: List of subnet IDs to attach to the LB. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]] subnets: A list of subnets to attach to the LB. Only one of [subnets], [subnetIds] or [subnetMappings] can be specified
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>, <span pulumi-lang-nodejs="`preserve`" pulumi-lang-dotnet="`Preserve`" pulumi-lang-go="`preserve`" pulumi-lang-python="`preserve`" pulumi-lang-yaml="`preserve`" pulumi-lang-java="`preserve`">`preserve`</span>, and <span pulumi-lang-nodejs="`remove`" pulumi-lang-dotnet="`Remove`" pulumi-lang-go="`remove`" pulumi-lang-python="`remove`" pulumi-lang-yaml="`remove`" pulumi-lang-java="`remove`">`remove`</span>. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. The default is <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>.
               
               > **NOTE:** Please note that internal LBs can only use <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> as the <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span>. You can only change to <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span> if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either <span pulumi-lang-nodejs="`subnets`" pulumi-lang-dotnet="`Subnets`" pulumi-lang-go="`subnets`" pulumi-lang-python="`subnets`" pulumi-lang-yaml="`subnets`" pulumi-lang-java="`subnets`">`subnets`</span> or <span pulumi-lang-nodejs="`subnetMapping`" pulumi-lang-dotnet="`SubnetMapping`" pulumi-lang-go="`subnetMapping`" pulumi-lang-python="`subnet_mapping`" pulumi-lang-yaml="`subnetMapping`" pulumi-lang-java="`subnetMapping`">`subnet_mapping`</span> is required.
        """
        if access_logs is not None:
            pulumi.set(__self__, "access_logs", access_logs)
        if client_keep_alive is not None:
            pulumi.set(__self__, "client_keep_alive", client_keep_alive)
        if connection_logs is not None:
            pulumi.set(__self__, "connection_logs", connection_logs)
        if customer_owned_ipv4_pool is not None:
            pulumi.set(__self__, "customer_owned_ipv4_pool", customer_owned_ipv4_pool)
        if default_security_group is not None:
            pulumi.set(__self__, "default_security_group", default_security_group)
        if default_target_group is not None:
            pulumi.set(__self__, "default_target_group", default_target_group)
        if default_target_group_port is not None:
            pulumi.set(__self__, "default_target_group_port", default_target_group_port)
        if desync_mitigation_mode is not None:
            pulumi.set(__self__, "desync_mitigation_mode", desync_mitigation_mode)
        if dns_record_client_routing_policy is not None:
            pulumi.set(__self__, "dns_record_client_routing_policy", dns_record_client_routing_policy)
        if drop_invalid_header_fields is not None:
            pulumi.set(__self__, "drop_invalid_header_fields", drop_invalid_header_fields)
        if enable_deletion_protection is not None:
            pulumi.set(__self__, "enable_deletion_protection", enable_deletion_protection)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if enable_tls_version_and_cipher_suite_headers is not None:
            pulumi.set(__self__, "enable_tls_version_and_cipher_suite_headers", enable_tls_version_and_cipher_suite_headers)
        if enable_waf_fail_open is not None:
            pulumi.set(__self__, "enable_waf_fail_open", enable_waf_fail_open)
        if enable_xff_client_port is not None:
            pulumi.set(__self__, "enable_xff_client_port", enable_xff_client_port)
        if enable_zonal_shift is not None:
            pulumi.set(__self__, "enable_zonal_shift", enable_zonal_shift)
        if enforce_security_group_inbound_rules_on_private_link_traffic is not None:
            pulumi.set(__self__, "enforce_security_group_inbound_rules_on_private_link_traffic", enforce_security_group_inbound_rules_on_private_link_traffic)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)
        if internal is not None:
            pulumi.set(__self__, "internal", internal)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipam_pools is not None:
            pulumi.set(__self__, "ipam_pools", ipam_pools)
        if listener is not None:
            pulumi.set(__self__, "listener", listener)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if minimum_load_balancer_capacity is not None:
            pulumi.set(__self__, "minimum_load_balancer_capacity", minimum_load_balancer_capacity)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if preserve_host_header is not None:
            pulumi.set(__self__, "preserve_host_header", preserve_host_header)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secondary_ips_auto_assigned_per_subnet is not None:
            pulumi.set(__self__, "secondary_ips_auto_assigned_per_subnet", secondary_ips_auto_assigned_per_subnet)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if subnet_mappings is not None:
            pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if xff_header_processing_mode is not None:
            pulumi.set(__self__, "xff_header_processing_mode", xff_header_processing_mode)

    @_builtins.property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerAccessLogsArgs']]:
        """
        Access Logs block. See below.
        """
        return pulumi.get(self, "access_logs")

    @access_logs.setter
    def access_logs(self, value: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerAccessLogsArgs']]):
        pulumi.set(self, "access_logs", value)

    @_builtins.property
    @pulumi.getter(name="clientKeepAlive")
    def client_keep_alive(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        """
        return pulumi.get(self, "client_keep_alive")

    @client_keep_alive.setter
    def client_keep_alive(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "client_keep_alive", value)

    @_builtins.property
    @pulumi.getter(name="connectionLogs")
    def connection_logs(self) -> Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']]:
        """
        Connection Logs block. See below. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        """
        return pulumi.get(self, "connection_logs")

    @connection_logs.setter
    def connection_logs(self, value: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']]):
        pulumi.set(self, "connection_logs", value)

    @_builtins.property
    @pulumi.getter(name="customerOwnedIpv4Pool")
    def customer_owned_ipv4_pool(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the customer owned ipv4 pool to use for this load balancer.
        """
        return pulumi.get(self, "customer_owned_ipv4_pool")

    @customer_owned_ipv4_pool.setter
    def customer_owned_ipv4_pool(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_owned_ipv4_pool", value)

    @_builtins.property
    @pulumi.getter(name="defaultSecurityGroup")
    def default_security_group(self) -> Optional['_awsx.DefaultSecurityGroupArgs']:
        """
        Options for creating a default security group if [securityGroups] not specified.
        """
        return pulumi.get(self, "default_security_group")

    @default_security_group.setter
    def default_security_group(self, value: Optional['_awsx.DefaultSecurityGroupArgs']):
        pulumi.set(self, "default_security_group", value)

    @_builtins.property
    @pulumi.getter(name="defaultTargetGroup")
    def default_target_group(self) -> Optional['TargetGroupArgs']:
        """
        Options creating a default target group.
        """
        return pulumi.get(self, "default_target_group")

    @default_target_group.setter
    def default_target_group(self, value: Optional['TargetGroupArgs']):
        pulumi.set(self, "default_target_group", value)

    @_builtins.property
    @pulumi.getter(name="defaultTargetGroupPort")
    def default_target_group_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port to use to connect with the target. Valid values are ports 1-65535. Defaults to 80.
        """
        return pulumi.get(self, "default_target_group_port")

    @default_target_group_port.setter
    def default_target_group_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "default_target_group_port", value)

    @_builtins.property
    @pulumi.getter(name="desyncMitigationMode")
    def desync_mitigation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are <span pulumi-lang-nodejs="`monitor`" pulumi-lang-dotnet="`Monitor`" pulumi-lang-go="`monitor`" pulumi-lang-python="`monitor`" pulumi-lang-yaml="`monitor`" pulumi-lang-java="`monitor`">`monitor`</span>, <span pulumi-lang-nodejs="`defensive`" pulumi-lang-dotnet="`Defensive`" pulumi-lang-go="`defensive`" pulumi-lang-python="`defensive`" pulumi-lang-yaml="`defensive`" pulumi-lang-java="`defensive`">`defensive`</span> (default), <span pulumi-lang-nodejs="`strictest`" pulumi-lang-dotnet="`Strictest`" pulumi-lang-go="`strictest`" pulumi-lang-python="`strictest`" pulumi-lang-yaml="`strictest`" pulumi-lang-java="`strictest`">`strictest`</span>.
        """
        return pulumi.get(self, "desync_mitigation_mode")

    @desync_mitigation_mode.setter
    def desync_mitigation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desync_mitigation_mode", value)

    @_builtins.property
    @pulumi.getter(name="dnsRecordClientRoutingPolicy")
    def dns_record_client_routing_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How traffic is distributed among the load balancer Availability Zones. Possible values are <span pulumi-lang-nodejs="`anyAvailabilityZone`" pulumi-lang-dotnet="`AnyAvailabilityZone`" pulumi-lang-go="`anyAvailabilityZone`" pulumi-lang-python="`any_availability_zone`" pulumi-lang-yaml="`anyAvailabilityZone`" pulumi-lang-java="`anyAvailabilityZone`">`any_availability_zone`</span> (default), <span pulumi-lang-nodejs="`availabilityZoneAffinity`" pulumi-lang-dotnet="`AvailabilityZoneAffinity`" pulumi-lang-go="`availabilityZoneAffinity`" pulumi-lang-python="`availability_zone_affinity`" pulumi-lang-yaml="`availabilityZoneAffinity`" pulumi-lang-java="`availabilityZoneAffinity`">`availability_zone_affinity`</span>, or <span pulumi-lang-nodejs="`partialAvailabilityZoneAffinity`" pulumi-lang-dotnet="`PartialAvailabilityZoneAffinity`" pulumi-lang-go="`partialAvailabilityZoneAffinity`" pulumi-lang-python="`partial_availability_zone_affinity`" pulumi-lang-yaml="`partialAvailabilityZoneAffinity`" pulumi-lang-java="`partialAvailabilityZoneAffinity`">`partial_availability_zone_affinity`</span>. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> type load balancers.
        """
        return pulumi.get(self, "dns_record_client_routing_policy")

    @dns_record_client_routing_policy.setter
    def dns_record_client_routing_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_record_client_routing_policy", value)

    @_builtins.property
    @pulumi.getter(name="dropInvalidHeaderFields")
    def drop_invalid_header_fields(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        """
        return pulumi.get(self, "drop_invalid_header_fields")

    @drop_invalid_header_fields.setter
    def drop_invalid_header_fields(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "drop_invalid_header_fields", value)

    @_builtins.property
    @pulumi.getter(name="enableDeletionProtection")
    def enable_deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "enable_deletion_protection")

    @enable_deletion_protection.setter
    def enable_deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_deletion_protection", value)

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether HTTP/2 is enabled in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_http2", value)

    @_builtins.property
    @pulumi.getter(name="enableTlsVersionAndCipherSuiteHeaders")
    def enable_tls_version_and_cipher_suite_headers(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>
        """
        return pulumi.get(self, "enable_tls_version_and_cipher_suite_headers")

    @enable_tls_version_and_cipher_suite_headers.setter
    def enable_tls_version_and_cipher_suite_headers(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tls_version_and_cipher_suite_headers", value)

    @_builtins.property
    @pulumi.getter(name="enableWafFailOpen")
    def enable_waf_fail_open(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "enable_waf_fail_open")

    @enable_waf_fail_open.setter
    def enable_waf_fail_open(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_waf_fail_open", value)

    @_builtins.property
    @pulumi.getter(name="enableXffClientPort")
    def enable_xff_client_port(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "enable_xff_client_port")

    @enable_xff_client_port.setter
    def enable_xff_client_port(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_xff_client_port", value)

    @_builtins.property
    @pulumi.getter(name="enableZonalShift")
    def enable_zonal_shift(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether zonal shift is enabled. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "enable_zonal_shift")

    @enable_zonal_shift.setter
    def enable_zonal_shift(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_zonal_shift", value)

    @_builtins.property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The possible values are <span pulumi-lang-nodejs="`on`" pulumi-lang-dotnet="`On`" pulumi-lang-go="`on`" pulumi-lang-python="`on`" pulumi-lang-yaml="`on`" pulumi-lang-java="`on`">`on`</span> and <span pulumi-lang-nodejs="`off`" pulumi-lang-dotnet="`Off`" pulumi-lang-go="`off`" pulumi-lang-python="`off`" pulumi-lang-yaml="`off`" pulumi-lang-java="`off`">`off`</span>.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @enforce_security_group_inbound_rules_on_private_link_traffic.setter
    def enforce_security_group_inbound_rules_on_private_link_traffic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enforce_security_group_inbound_rules_on_private_link_traffic", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Default: 60.
        """
        return pulumi.get(self, "idle_timeout")

    @idle_timeout.setter
    def idle_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout", value)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the LB will be internal. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "internal")

    @internal.setter
    def internal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internal", value)

    @_builtins.property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> (all load balancer types), <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> (all load balancer types), and `dualstack-without-public-ipv4` (type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> only).
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @_builtins.property
    @pulumi.getter(name="ipamPools")
    def ipam_pools(self) -> Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']]:
        """
        . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. See<span pulumi-lang-nodejs=" ipamPools " pulumi-lang-dotnet=" IpamPools " pulumi-lang-go=" ipamPools " pulumi-lang-python=" ipam_pools " pulumi-lang-yaml=" ipamPools " pulumi-lang-java=" ipamPools "> ipam_pools </span>for more information.
        """
        return pulumi.get(self, "ipam_pools")

    @ipam_pools.setter
    def ipam_pools(self, value: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']]):
        pulumi.set(self, "ipam_pools", value)

    @_builtins.property
    @pulumi.getter
    def listener(self) -> Optional['ListenerArgs']:
        """
        A listener to create. Only one of [listener] and [listeners] can be specified.
        """
        return pulumi.get(self, "listener")

    @listener.setter
    def listener(self, value: Optional['ListenerArgs']):
        pulumi.set(self, "listener", value)

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> Optional[Sequence['ListenerArgs']]:
        """
        List of listeners to create. Only one of [listener] and [listeners] can be specified.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[Sequence['ListenerArgs']]):
        pulumi.set(self, "listeners", value)

    @_builtins.property
    @pulumi.getter(name="minimumLoadBalancerCapacity")
    def minimum_load_balancer_capacity(self) -> Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']]:
        """
        Minimum capacity for a load balancer. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>.
        """
        return pulumi.get(self, "minimum_load_balancer_capacity")

    @minimum_load_balancer_capacity.setter
    def minimum_load_balancer_capacity(self, value: Optional[pulumi.Input['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']]):
        pulumi.set(self, "minimum_load_balancer_capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="preserveHostHeader")
    def preserve_host_header(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        """
        return pulumi.get(self, "preserve_host_header")

    @preserve_host_header.setter
    def preserve_host_header(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "preserve_host_header", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpsAutoAssignedPerSubnet")
    def secondary_ips_auto_assigned_per_subnet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span>.
        """
        return pulumi.get(self, "secondary_ips_auto_assigned_per_subnet")

    @secondary_ips_auto_assigned_per_subnet.setter
    def secondary_ips_auto_assigned_per_subnet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "secondary_ips_auto_assigned_per_subnet", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of security group IDs to assign to the LB. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. For load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of subnet IDs to attach to the LB. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> will force a recreation of the resource.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]]:
        """
        Subnet mapping block. See below. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnet mappings can only be added.
        """
        return pulumi.get(self, "subnet_mappings")

    @subnet_mappings.setter
    def subnet_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]]):
        pulumi.set(self, "subnet_mappings", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]]]:
        """
        A list of subnets to attach to the LB. Only one of [subnets], [subnetIds] or [subnetMappings] can be specified
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="xffHeaderProcessingMode")
    def xff_header_processing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>, <span pulumi-lang-nodejs="`preserve`" pulumi-lang-dotnet="`Preserve`" pulumi-lang-go="`preserve`" pulumi-lang-python="`preserve`" pulumi-lang-yaml="`preserve`" pulumi-lang-java="`preserve`">`preserve`</span>, and <span pulumi-lang-nodejs="`remove`" pulumi-lang-dotnet="`Remove`" pulumi-lang-go="`remove`" pulumi-lang-python="`remove`" pulumi-lang-yaml="`remove`" pulumi-lang-java="`remove`">`remove`</span>. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. The default is <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>.

        > **NOTE:** Please note that internal LBs can only use <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> as the <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span>. You can only change to <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span> if the selected subnets are IPv6 enabled.

        > **NOTE:** Please note that one of either <span pulumi-lang-nodejs="`subnets`" pulumi-lang-dotnet="`Subnets`" pulumi-lang-go="`subnets`" pulumi-lang-python="`subnets`" pulumi-lang-yaml="`subnets`" pulumi-lang-java="`subnets`">`subnets`</span> or <span pulumi-lang-nodejs="`subnetMapping`" pulumi-lang-dotnet="`SubnetMapping`" pulumi-lang-go="`subnetMapping`" pulumi-lang-python="`subnet_mapping`" pulumi-lang-yaml="`subnetMapping`" pulumi-lang-java="`subnetMapping`">`subnet_mapping`</span> is required.
        """
        return pulumi.get(self, "xff_header_processing_mode")

    @xff_header_processing_mode.setter
    def xff_header_processing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "xff_header_processing_mode", value)


@pulumi.type_token("awsx:lb:ApplicationLoadBalancer")
class ApplicationLoadBalancer(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerAccessLogsArgs']]] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 default_security_group: Optional[Union['_awsx.DefaultSecurityGroupArgs', '_awsx.DefaultSecurityGroupArgsDict']] = None,
                 default_target_group: Optional[Union['TargetGroupArgs', 'TargetGroupArgsDict']] = None,
                 default_target_group_port: Optional[pulumi.Input[_builtins.int]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']]] = None,
                 listener: Optional[Union['ListenerArgs', 'ListenerArgsDict']] = None,
                 listeners: Optional[Sequence[Union['ListenerArgs', 'ListenerArgsDict']]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an Application Load Balancer resource with listeners, default target group and default security group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerAccessLogsArgs']] access_logs: Access Logs block. See below.
        :param pulumi.Input[_builtins.int] client_keep_alive: Client keep alive value in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']] connection_logs: Connection Logs block. See below. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        :param pulumi.Input[_builtins.str] customer_owned_ipv4_pool: ID of the customer owned ipv4 pool to use for this load balancer.
        :param Union['_awsx.DefaultSecurityGroupArgs', '_awsx.DefaultSecurityGroupArgsDict'] default_security_group: Options for creating a default security group if [securityGroups] not specified.
        :param Union['TargetGroupArgs', 'TargetGroupArgsDict'] default_target_group: Options creating a default target group.
        :param pulumi.Input[_builtins.int] default_target_group_port: Port to use to connect with the target. Valid values are ports 1-65535. Defaults to 80.
        :param pulumi.Input[_builtins.str] desync_mitigation_mode: How the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are <span pulumi-lang-nodejs="`monitor`" pulumi-lang-dotnet="`Monitor`" pulumi-lang-go="`monitor`" pulumi-lang-python="`monitor`" pulumi-lang-yaml="`monitor`" pulumi-lang-java="`monitor`">`monitor`</span>, <span pulumi-lang-nodejs="`defensive`" pulumi-lang-dotnet="`Defensive`" pulumi-lang-go="`defensive`" pulumi-lang-python="`defensive`" pulumi-lang-yaml="`defensive`" pulumi-lang-java="`defensive`">`defensive`</span> (default), <span pulumi-lang-nodejs="`strictest`" pulumi-lang-dotnet="`Strictest`" pulumi-lang-go="`strictest`" pulumi-lang-python="`strictest`" pulumi-lang-yaml="`strictest`" pulumi-lang-java="`strictest`">`strictest`</span>.
        :param pulumi.Input[_builtins.str] dns_record_client_routing_policy: How traffic is distributed among the load balancer Availability Zones. Possible values are <span pulumi-lang-nodejs="`anyAvailabilityZone`" pulumi-lang-dotnet="`AnyAvailabilityZone`" pulumi-lang-go="`anyAvailabilityZone`" pulumi-lang-python="`any_availability_zone`" pulumi-lang-yaml="`anyAvailabilityZone`" pulumi-lang-java="`anyAvailabilityZone`">`any_availability_zone`</span> (default), <span pulumi-lang-nodejs="`availabilityZoneAffinity`" pulumi-lang-dotnet="`AvailabilityZoneAffinity`" pulumi-lang-go="`availabilityZoneAffinity`" pulumi-lang-python="`availability_zone_affinity`" pulumi-lang-yaml="`availabilityZoneAffinity`" pulumi-lang-java="`availabilityZoneAffinity`">`availability_zone_affinity`</span>, or <span pulumi-lang-nodejs="`partialAvailabilityZoneAffinity`" pulumi-lang-dotnet="`PartialAvailabilityZoneAffinity`" pulumi-lang-go="`partialAvailabilityZoneAffinity`" pulumi-lang-python="`partial_availability_zone_affinity`" pulumi-lang-yaml="`partialAvailabilityZoneAffinity`" pulumi-lang-java="`partialAvailabilityZoneAffinity`">`partial_availability_zone_affinity`</span>. See   [Availability Zone DNS affinity](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#zonal-dns-affinity) for additional details. Only valid for <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> type load balancers.
        :param pulumi.Input[_builtins.bool] drop_invalid_header_fields: Whether HTTP headers with header fields that are not valid are removed by the load balancer (true) or routed to targets (false). The default is false. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>.
        :param pulumi.Input[_builtins.bool] enable_deletion_protection: If true, deletion of the load balancer will be disabled via the AWS API. This will prevent this provider from deleting the load balancer. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_http2: Whether HTTP/2 is enabled in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`true`" pulumi-lang-dotnet="`True`" pulumi-lang-go="`true`" pulumi-lang-python="`true`" pulumi-lang-yaml="`true`" pulumi-lang-java="`true`">`true`</span>.
        :param pulumi.Input[_builtins.bool] enable_tls_version_and_cipher_suite_headers: Whether the two headers (`x-amzn-tls-version` and `x-amzn-tls-cipher-suite`), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>
        :param pulumi.Input[_builtins.bool] enable_waf_fail_open: Whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_xff_client_port: Whether the X-Forwarded-For header should preserve the source port that the client used to connect to the load balancer in <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> load balancers. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.bool] enable_zonal_shift: Whether zonal shift is enabled. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] enforce_security_group_inbound_rules_on_private_link_traffic: Whether inbound security group rules are enforced for traffic originating from a PrivateLink. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The possible values are <span pulumi-lang-nodejs="`on`" pulumi-lang-dotnet="`On`" pulumi-lang-go="`on`" pulumi-lang-python="`on`" pulumi-lang-yaml="`on`" pulumi-lang-java="`on`">`on`</span> and <span pulumi-lang-nodejs="`off`" pulumi-lang-dotnet="`Off`" pulumi-lang-go="`off`" pulumi-lang-python="`off`" pulumi-lang-yaml="`off`" pulumi-lang-java="`off`">`off`</span>.
        :param pulumi.Input[_builtins.int] idle_timeout: Time in seconds that the connection is allowed to be idle. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. Default: 60.
        :param pulumi.Input[_builtins.bool] internal: If true, the LB will be internal. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] ip_address_type: Type of IP addresses used by the subnets for your load balancer. The possible values depend upon the load balancer type: <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> (all load balancer types), <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> (all load balancer types), and `dualstack-without-public-ipv4` (type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> only).
        :param pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']] ipam_pools: . The IPAM pools to use with the load balancer.  Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. See<span pulumi-lang-nodejs=" ipamPools " pulumi-lang-dotnet=" IpamPools " pulumi-lang-go=" ipamPools " pulumi-lang-python=" ipam_pools " pulumi-lang-yaml=" ipamPools " pulumi-lang-java=" ipamPools "> ipam_pools </span>for more information.
        :param Union['ListenerArgs', 'ListenerArgsDict'] listener: A listener to create. Only one of [listener] and [listeners] can be specified.
        :param Sequence[Union['ListenerArgs', 'ListenerArgsDict']] listeners: List of listeners to create. Only one of [listener] and [listeners] can be specified.
        :param pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']] minimum_load_balancer_capacity: Minimum capacity for a load balancer. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>.
        :param pulumi.Input[_builtins.str] name: Name of the LB. This name must be unique within your AWS account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen. If not specified, this provider will autogenerate a name beginning with `tf-lb`.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the specified prefix. Conflicts with <span pulumi-lang-nodejs="`name`" pulumi-lang-dotnet="`Name`" pulumi-lang-go="`name`" pulumi-lang-python="`name`" pulumi-lang-yaml="`name`" pulumi-lang-java="`name`">`name`</span>.
        :param pulumi.Input[_builtins.bool] preserve_host_header: Whether the Application Load Balancer should preserve the Host header in the HTTP request and send it to the target without any change. Defaults to <span pulumi-lang-nodejs="`false`" pulumi-lang-dotnet="`False`" pulumi-lang-go="`false`" pulumi-lang-python="`false`" pulumi-lang-yaml="`false`" pulumi-lang-java="`false`">`false`</span>.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] secondary_ips_auto_assigned_per_subnet: The number of secondary IP addresses to configure for your load balancer nodes. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. The valid range is 0-7. When decreased, this will force a recreation of the resource. Default: <span pulumi-lang-nodejs="`0`" pulumi-lang-dotnet="`0`" pulumi-lang-go="`0`" pulumi-lang-python="`0`" pulumi-lang-yaml="`0`" pulumi-lang-java="`0`">`0`</span>.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: List of security group IDs to assign to the LB. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span> or <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span>. For load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> security groups cannot be added if none are currently present, and cannot all be removed once added. If either of these conditions are met, this will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: List of subnet IDs to attach to the LB. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnets can only be added (see [Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#availability-zones)), deleting a subnet for load balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> will force a recreation of the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]] subnet_mappings: Subnet mapping block. See below. For Load Balancers of type <span pulumi-lang-nodejs="`network`" pulumi-lang-dotnet="`Network`" pulumi-lang-go="`network`" pulumi-lang-python="`network`" pulumi-lang-yaml="`network`" pulumi-lang-java="`network`">`network`</span> subnet mappings can only be added.
        :param pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]] subnets: A list of subnets to attach to the LB. Only one of [subnets], [subnetIds] or [subnetMappings] can be specified
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider <span pulumi-lang-nodejs="`defaultTags`" pulumi-lang-dotnet="`DefaultTags`" pulumi-lang-go="`defaultTags`" pulumi-lang-python="`default_tags`" pulumi-lang-yaml="`defaultTags`" pulumi-lang-java="`defaultTags`">`default_tags`</span> configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] xff_header_processing_mode: Determines how the load balancer modifies the `X-Forwarded-For` header in the HTTP request before sending the request to the target. The possible values are <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>, <span pulumi-lang-nodejs="`preserve`" pulumi-lang-dotnet="`Preserve`" pulumi-lang-go="`preserve`" pulumi-lang-python="`preserve`" pulumi-lang-yaml="`preserve`" pulumi-lang-java="`preserve`">`preserve`</span>, and <span pulumi-lang-nodejs="`remove`" pulumi-lang-dotnet="`Remove`" pulumi-lang-go="`remove`" pulumi-lang-python="`remove`" pulumi-lang-yaml="`remove`" pulumi-lang-java="`remove`">`remove`</span>. Only valid for Load Balancers of type <span pulumi-lang-nodejs="`application`" pulumi-lang-dotnet="`Application`" pulumi-lang-go="`application`" pulumi-lang-python="`application`" pulumi-lang-yaml="`application`" pulumi-lang-java="`application`">`application`</span>. The default is <span pulumi-lang-nodejs="`append`" pulumi-lang-dotnet="`Append`" pulumi-lang-go="`append`" pulumi-lang-python="`append`" pulumi-lang-yaml="`append`" pulumi-lang-java="`append`">`append`</span>.
               
               > **NOTE:** Please note that internal LBs can only use <span pulumi-lang-nodejs="`ipv4`" pulumi-lang-dotnet="`Ipv4`" pulumi-lang-go="`ipv4`" pulumi-lang-python="`ipv4`" pulumi-lang-yaml="`ipv4`" pulumi-lang-java="`ipv4`">`ipv4`</span> as the <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span>. You can only change to <span pulumi-lang-nodejs="`dualstack`" pulumi-lang-dotnet="`Dualstack`" pulumi-lang-go="`dualstack`" pulumi-lang-python="`dualstack`" pulumi-lang-yaml="`dualstack`" pulumi-lang-java="`dualstack`">`dualstack`</span> <span pulumi-lang-nodejs="`ipAddressType`" pulumi-lang-dotnet="`IpAddressType`" pulumi-lang-go="`ipAddressType`" pulumi-lang-python="`ip_address_type`" pulumi-lang-yaml="`ipAddressType`" pulumi-lang-java="`ipAddressType`">`ip_address_type`</span> if the selected subnets are IPv6 enabled.
               
               > **NOTE:** Please note that one of either <span pulumi-lang-nodejs="`subnets`" pulumi-lang-dotnet="`Subnets`" pulumi-lang-go="`subnets`" pulumi-lang-python="`subnets`" pulumi-lang-yaml="`subnets`" pulumi-lang-java="`subnets`">`subnets`</span> or <span pulumi-lang-nodejs="`subnetMapping`" pulumi-lang-dotnet="`SubnetMapping`" pulumi-lang-go="`subnetMapping`" pulumi-lang-python="`subnet_mapping`" pulumi-lang-yaml="`subnetMapping`" pulumi-lang-java="`subnetMapping`">`subnet_mapping`</span> is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApplicationLoadBalancerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Application Load Balancer resource with listeners, default target group and default security group.

        :param str resource_name: The name of the resource.
        :param ApplicationLoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationLoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_logs: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerAccessLogsArgs']]] = None,
                 client_keep_alive: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_logs: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerConnectionLogsArgs']]] = None,
                 customer_owned_ipv4_pool: Optional[pulumi.Input[_builtins.str]] = None,
                 default_security_group: Optional[Union['_awsx.DefaultSecurityGroupArgs', '_awsx.DefaultSecurityGroupArgsDict']] = None,
                 default_target_group: Optional[Union['TargetGroupArgs', 'TargetGroupArgsDict']] = None,
                 default_target_group_port: Optional[pulumi.Input[_builtins.int]] = None,
                 desync_mitigation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_record_client_routing_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 drop_invalid_header_fields: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_tls_version_and_cipher_suite_headers: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_waf_fail_open: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_xff_client_port: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_zonal_shift: Optional[pulumi.Input[_builtins.bool]] = None,
                 enforce_security_group_inbound_rules_on_private_link_traffic: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 internal: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_pools: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerIpamPoolsArgs']]] = None,
                 listener: Optional[Union['ListenerArgs', 'ListenerArgsDict']] = None,
                 listeners: Optional[Sequence[Union['ListenerArgs', 'ListenerArgsDict']]] = None,
                 minimum_load_balancer_capacity: Optional[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerMinimumLoadBalancerCapacityArgs']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 preserve_host_header: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ips_auto_assigned_per_subnet: Optional[pulumi.Input[_builtins.int]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subnet_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['pulumi_aws.lb.LoadBalancerSubnetMappingArgs']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['pulumi_aws.ec2.Subnet']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 xff_header_processing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationLoadBalancerArgs.__new__(ApplicationLoadBalancerArgs)

            __props__.__dict__["access_logs"] = access_logs
            __props__.__dict__["client_keep_alive"] = client_keep_alive
            __props__.__dict__["connection_logs"] = connection_logs
            __props__.__dict__["customer_owned_ipv4_pool"] = customer_owned_ipv4_pool
            __props__.__dict__["default_security_group"] = default_security_group
            __props__.__dict__["default_target_group"] = default_target_group
            __props__.__dict__["default_target_group_port"] = default_target_group_port
            __props__.__dict__["desync_mitigation_mode"] = desync_mitigation_mode
            __props__.__dict__["dns_record_client_routing_policy"] = dns_record_client_routing_policy
            __props__.__dict__["drop_invalid_header_fields"] = drop_invalid_header_fields
            __props__.__dict__["enable_deletion_protection"] = enable_deletion_protection
            __props__.__dict__["enable_http2"] = enable_http2
            __props__.__dict__["enable_tls_version_and_cipher_suite_headers"] = enable_tls_version_and_cipher_suite_headers
            __props__.__dict__["enable_waf_fail_open"] = enable_waf_fail_open
            __props__.__dict__["enable_xff_client_port"] = enable_xff_client_port
            __props__.__dict__["enable_zonal_shift"] = enable_zonal_shift
            __props__.__dict__["enforce_security_group_inbound_rules_on_private_link_traffic"] = enforce_security_group_inbound_rules_on_private_link_traffic
            __props__.__dict__["idle_timeout"] = idle_timeout
            __props__.__dict__["internal"] = internal
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["ipam_pools"] = ipam_pools
            __props__.__dict__["listener"] = listener
            __props__.__dict__["listeners"] = listeners
            __props__.__dict__["minimum_load_balancer_capacity"] = minimum_load_balancer_capacity
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["preserve_host_header"] = preserve_host_header
            __props__.__dict__["region"] = region
            __props__.__dict__["secondary_ips_auto_assigned_per_subnet"] = secondary_ips_auto_assigned_per_subnet
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["subnet_mappings"] = subnet_mappings
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["xff_header_processing_mode"] = xff_header_processing_mode
            __props__.__dict__["load_balancer"] = None
            __props__.__dict__["vpc_id"] = None
        super(ApplicationLoadBalancer, __self__).__init__(
            'awsx:lb:ApplicationLoadBalancer',
            resource_name,
            __props__,
            opts,
            remote=True)

    @_builtins.property
    @pulumi.getter(name="defaultSecurityGroup")
    def default_security_group(self) -> pulumi.Output[Optional['pulumi_aws.ec2.SecurityGroup']]:
        """
        Default security group, if auto-created
        """
        return pulumi.get(self, "default_security_group")

    @_builtins.property
    @pulumi.getter(name="defaultTargetGroup")
    def default_target_group(self) -> pulumi.Output['pulumi_aws.lb.TargetGroup']:
        """
        Default target group, if auto-created
        """
        return pulumi.get(self, "default_target_group")

    @_builtins.property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Optional[Sequence['pulumi_aws.lb.Listener']]]:
        """
        Listeners created as part of this load balancer
        """
        return pulumi.get(self, "listeners")

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output['pulumi_aws.lb.LoadBalancer']:
        """
        Underlying Load Balancer resource
        """
        return pulumi.get(self, "load_balancer")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Id of the VPC in which this load balancer is operating
        """
        return pulumi.get(self, "vpc_id")

