"""update tables

Revision ID: 0.3.0
Revises:
Create Date: 2023-02-08 14:35:52.386481

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0.3.0"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "facet",
        sa.Column("name", sa.String(length=64), nullable=False),
        sa.Column("value", sa.String(length=255), nullable=False),
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint("sha"),
    )
    op.create_table(
        "file",
        sa.Column("file_id", sa.String(length=255), nullable=False),
        sa.Column("dataset_id", sa.String(length=255), nullable=False),
        sa.Column("master_id", sa.String(length=255), nullable=False),
        sa.Column("url", sa.String(length=255), nullable=False),
        sa.Column("version", sa.String(length=16), nullable=False),
        sa.Column("filename", sa.String(length=255), nullable=False),
        sa.Column("local_path", sa.String(length=255), nullable=False),
        sa.Column("data_node", sa.String(length=40), nullable=False),
        sa.Column("checksum", sa.String(length=64), nullable=False),
        sa.Column("checksum_type", sa.String(length=16), nullable=False),
        sa.Column("size", sa.Integer(), nullable=False),
        sa.Column(
            "status",
            sa.Enum(
                "New",
                "Queued",
                "Starting",
                "Started",
                "Pausing",
                "Paused",
                "Error",
                "Cancelled",
                "Done",
                name="filestatus",
            ),
            nullable=False,
        ),
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint("sha"),
        sa.UniqueConstraint("file_id"),
    )
    op.create_table(
        "options",
        sa.Column(
            "distrib",
            sa.Enum("false", "true", "none", "notset", name="option"),
            nullable=False,
        ),
        sa.Column(
            "latest",
            sa.Enum("false", "true", "none", "notset", name="option"),
            nullable=False,
        ),
        sa.Column(
            "replica",
            sa.Enum("false", "true", "none", "notset", name="option"),
            nullable=False,
        ),
        sa.Column(
            "retracted",
            sa.Enum("false", "true", "none", "notset", name="option"),
            nullable=False,
        ),
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint("sha"),
    )
    op.create_table(
        "selection",
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint("sha"),
    )
    op.create_table(
        "tag",
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.PrimaryKeyConstraint("sha"),
    )
    op.create_table(
        "query",
        sa.Column("tracked", sa.Boolean(), nullable=False),
        sa.Column("require", sa.String(length=40), nullable=True),
        sa.Column("options_sha", sa.String(length=40), nullable=False),
        sa.Column("selection_sha", sa.String(length=40), nullable=False),
        sa.Column("sha", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["options_sha"],
            ["options.sha"],
        ),
        sa.ForeignKeyConstraint(
            ["selection_sha"],
            ["selection.sha"],
        ),
        sa.PrimaryKeyConstraint("sha"),
    )
    op.create_table(
        "selection_facet",
        sa.Column("selection_sha", sa.String(length=40), nullable=False),
        sa.Column("facet_sha", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["facet_sha"],
            ["facet.sha"],
        ),
        sa.ForeignKeyConstraint(
            ["selection_sha"],
            ["selection.sha"],
        ),
        sa.PrimaryKeyConstraint("selection_sha", "facet_sha"),
    )
    op.create_table(
        "query_file",
        sa.Column("query_sha", sa.String(length=40), nullable=False),
        sa.Column("file_sha", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["file_sha"],
            ["file.sha"],
        ),
        sa.ForeignKeyConstraint(
            ["query_sha"],
            ["query.sha"],
        ),
        sa.PrimaryKeyConstraint("query_sha", "file_sha"),
    )
    op.create_table(
        "query_tag",
        sa.Column("query_sha", sa.String(length=40), nullable=False),
        sa.Column("tag_sha", sa.String(length=40), nullable=False),
        sa.ForeignKeyConstraint(
            ["query_sha"],
            ["query.sha"],
        ),
        sa.ForeignKeyConstraint(
            ["tag_sha"],
            ["tag.sha"],
        ),
        sa.PrimaryKeyConstraint("query_sha", "tag_sha"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("query_tag")
    op.drop_table("query_file")
    op.drop_table("selection_facet")
    op.drop_table("query")
    op.drop_table("tag")
    op.drop_table("selection")
    op.drop_table("options")
    op.drop_table("file")
    op.drop_table("facet")
    # ### end Alembic commands ###
