"""query_add_column_updated_at

Revision ID: 14c72daea083
Revises: c7c8541fa741
Create Date: 2025-05-07 14:49:43.993125

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '14c72daea083'
down_revision = 'c7c8541fa741'
branch_labels = None
depends_on = None


def upgrade() -> None:
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.add_column(sa.Column('updated_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True))

    # Backfill nulls
    op.execute('UPDATE query SET updated_at = CURRENT_TIMESTAMP WHERE updated_at IS NULL')

    # Make non-nullable
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.alter_column('updated_at', nullable=False)


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.drop_column('updated_at')

    # ### end Alembic commands ###
