"""query_add_column_added_at

Revision ID: c7c8541fa741
Revises: 0.7.3
Create Date: 2025-05-05 16:14:57.140262

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c7c8541fa741'
down_revision = '0.7.3'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # Add as nullable first
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.add_column(sa.Column('added_at', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True))

    # Backfill nulls
    op.execute('UPDATE query SET added_at = CURRENT_TIMESTAMP WHERE added_at IS NULL')

    # Make non-nullable
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.alter_column('added_at', nullable=False)


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('query', schema=None) as batch_op:
        batch_op.drop_column('added_at')

    # ### end Alembic commands ###
