# Fitting strategy

> [!NOTE]
> The page is being edited. 

The full fitting pipeline of S<sup>3</sup>Fit is shown in the following flowchart. 
<p align="center"> <img src="/manuals/Flowcharts.png" width="1200">

The core processes of S<sup>3</sup>Fit are <ins>**Create model spectra**</ins> and <ins>**Fit models to data**</ins> in the flowchart. 
The code separate the values related to the normalization factors of models (i.e., flux or luminosity of each model component)
from the other parameters that control shapes of models (e.g., line width, stellar population age), 
and hereafter the word "parameters" only denote the later type variables. 

For a given group of parameters, the normalization factors of models are obtained by solving the linear least-square problem, with the function `scipy.optimize.lsq_linear`. 
The corresponding model spectra and the $\chi^2$ value are then calculated with the normalization factors.
The best-fit parameters are obtained by solving the non-linear least-square problem to minimize $\chi^2$, with the function `scipy.optimize.least_squares`
and the Trust Region Reflective algorithm (read [the page](https://docs.scipy.org/doc/scipy/reference/generated/scipy.optimize.least_squares.html) 
for details of the algorithm). 
The strategy, which combines the solvers of linear and non-linear least-square problem, 
runs faster than the method to only solve non-linear least-square problem for all variables (i.e., both of normalization factors and shape-controlled parameters); 
and also runs faster than the method 
that calculate $\chi^2$ for all combinations of parameters in the model parameter grids, especially when the number of parameters is huge. 

The solution of `scipy.optimize.least_squares` is indeed the values for the local minimum $\chi^2$, which could be sensitive to the initial values pf parameters. 
In order to reduce the effect, the full fitting pipeline can be iterated with multiple loops (adjusted with `num_mock_loops` in the input).
In each loop, the initial parameters are randomly generated.
A mocked data, which is generated by adding random noise (scaled with the measurement errors) to the observed data, 
is used in each iteration. 
The results from all iterations can be used to estimate the uncertainty of each parameters, 
and to examine if there is a secondary solution in the parameter space. 

Since there could be several tens of parameters, it can be hard for the algorithm to find the 
best-fit values for all models with randomly initialized input parameters. 
In order to address the issue, the pipeline is performed in three (only spectrum) or four cycles (spectrum and photometric SED). 

- In the initial cycle, 
the fitting for continuum models are firstly performed using the data spectrum with
the wavelength range of emission lines masked out.
The emission lines are then fit with the continuum subtracted spectrum.
- In the 1st main cycle,
the continuum fitting is firstly performed after subtracting the best-fit emission line models (from the initial cycle) from the data spectrum.
The emission lines are then fit with the continuum (from the 1st cycle) subtracted spectrum.
Randomly initialized parameters are used in the two fitting.
The best-fit parameters from the pure continuum or emission line fitting
are used as the initial parameters of the joint fitting of continuum and emission lines.
- After the 1st main cycle, an examination of each model component is performed with the peak S/N of each component.
Components with a low S/N (e.g., faint broad line component) are disabled in later fitting.
The component configuration of each model is introduced in the [basic usage](../manuals/basic_usage.md) manual.
- The 2nd main cycle is a repeat of the 1st main cycle with updated model configuration.
If a pure spectral fitting is required, the best-fit parameters and model spectra are the final output.
- If photometric SED data is input, the 3rd fitting cycle is performed.
The pipeline of the 3rd cycle is a repeat of the 2nd cycle,
while the model spectra are created in the wavelength range that covers all of the data points,
and the fitting is run simultaneously for the spectrum and photometric data points. 

An example of the fitting result is provided in the following plots. 
The best-fit model spectra for all mocked data are shown in the plot, which represent the uncertainty range of each models. 
<p align="center"> <img src="https://github.com/user-attachments/assets/683f5837-d364-4a53-8113-a05d56f9ef5b" width="600" height="600">
