# Using DirFileSystem with fsspec-utils

This example demonstrates how to use DirFileSystem with fsspec-utils to work with directory-based file systems.

## Overview

The example shows:
1. Creating DirFileSystem instances for S3 and local paths
2. Demonstrating usage with and without `storage_options`
3. Performing simple operations with each filesystem
4. Demonstrating configuration for different storage systems

## Prerequisites

- Python 3.8+
- fsspec-utils installed

## Running the Example

Run the example script:

```bash
python dir_file_system_example.py
```

Or run the Jupyter notebook:

```bash
jupyter notebook dir_file_system_example.ipynb
```

Or run the Marimo notebook:

```bash
marimo run dir_file_system_example_mamo.py
```

## Files in This Example

- `dir_file_system_example.py`: Python script demonstrating the functionality
- `dir_file_system_example.ipynb`: Jupyter notebook version of the example
- `dir_file_system_example_mamo.py`: Marimo notebook version of the example
- `README.md`: This file