# Generated by Django 4.2.15 on 2024-09-25 15:27

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import swapper
from django.conf import settings
from django.db import migrations, models

import baseapp_core.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        swapper.dependency("baseapp_profiles", "Profile"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        swapper.dependency("baseapp_chats", "ChatRoom"),
        swapper.dependency("baseapp_chats", "ChatRoomParticipant"),
        swapper.dependency("baseapp_chats", "Message"),
        swapper.dependency("baseapp_chats", "MessageStatus"),
        swapper.dependency("baseapp_chats", "UnreadMessageCount"),
    ]

    operations = [
        migrations.CreateModel(
            name="ChatRoom",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "image",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to=baseapp_core.models.random_name_in("chat_room_images"),
                        verbose_name="image",
                    ),
                ),
                (
                    "last_message_time",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True),
                ),
                ("participants_count", models.IntegerField(default=0)),
                ("messages_count", models.IntegerField(default=0)),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="created_rooms",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-last_message_time", "-created"],
                "abstract": False,
                "swappable": swapper.swappable_setting("baseapp_chats", "ChatRoom"),
            },
        ),
        migrations.CreateModel(
            name="Message",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("content", models.TextField(blank=True, null=True)),
                (
                    "verb",
                    models.IntegerField(
                        choices=[(100, "sent a message")], db_index=True, default=100
                    ),
                ),
                (
                    "action_object_object_id",
                    models.IntegerField(blank=True, db_index=True, null=True),
                ),
                ("extra_data", models.JSONField(blank=True, null=True)),
                (
                    "action_object_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="action_object",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "in_reply_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="replies",
                        to=swapper.get_model_name("baseapp_chats", "Message"),
                    ),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name("baseapp_profiles", "Profile"),
                    ),
                ),
                (
                    "room",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="messages",
                        to=swapper.get_model_name("baseapp_chats", "ChatRoom"),
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-created"],
                "abstract": False,
                "swappable": swapper.swappable_setting("baseapp_chats", "Message"),
            },
        ),
        migrations.CreateModel(
            name="ChatRoomParticipant",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("role", models.IntegerField(choices=[(1, "member"), (2, "admin")], default=1)),
                ("accepted_at", models.DateTimeField(blank=True, null=True)),
                (
                    "profile",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name("baseapp_profiles", "Profile"),
                    ),
                ),
                (
                    "room",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="participants",
                        to=swapper.get_model_name("baseapp_chats", "ChatRoom"),
                    ),
                ),
            ],
            options={
                "ordering": ["created"],
                "abstract": False,
                "swappable": swapper.swappable_setting("baseapp_chats", "ChatRoomParticipant"),
            },
        ),
        migrations.AddField(
            model_name="chatroom",
            name="last_message",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to=swapper.get_model_name("baseapp_chats", "Message"),
            ),
        ),
        migrations.CreateModel(
            name="UnreadMessageCount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("count", models.IntegerField(default=0)),
                (
                    "profile",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name("baseapp_profiles", "Profile"),
                    ),
                ),
                (
                    "room",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name("baseapp_chats", "ChatRoom"),
                    ),
                ),
            ],
            options={
                "ordering": ["id"],
                "abstract": False,
                "swappable": swapper.swappable_setting("baseapp_chats", "UnreadMessageCount"),
                "unique_together": {("room_id", "profile_id")},
            },
        ),
        migrations.CreateModel(
            name="MessageStatus",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("is_read", models.BooleanField(default=False)),
                ("read_at", models.DateTimeField(blank=True, null=True)),
                (
                    "message",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="statuses",
                        to=swapper.get_model_name("baseapp_chats", "Message"),
                    ),
                ),
                (
                    "profile",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name("baseapp_profiles", "Profile"),
                    ),
                ),
            ],
            options={
                "abstract": False,
                "swappable": swapper.swappable_setting("baseapp_chats", "MessageStatus"),
                "unique_together": {("message_id", "profile_id")},
            },
        ),
    ]
