# Generated by Django 4.2.11 on 2024-03-18 16:58

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import swapper
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        swapper.dependency("baseapp_reports", "Report"),
    ]

    operations = [
        migrations.CreateModel(
            name="Report",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "report_type",
                    models.IntegerField(
                        blank=True,
                        choices=[(1, "Spam"), (2, "Inappropriate"), (3, "Fake")],
                        null=True,
                    ),
                ),
                ("report_subject", models.TextField(blank=True, null=True)),
                (
                    "target_object_id",
                    models.PositiveIntegerField(blank=True, db_index=True, null=True),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reports",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "swappable": swapper.swappable_setting("baseapp_reports", "Report"),
                "unique_together": {("user", "target_content_type", "target_object_id")},
            },
        ),
    ]
