# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['MaintenanceWindowArgs', 'MaintenanceWindow']

@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 end_time_in_seconds: pulumi.Input[_builtins.int],
                 reason: pulumi.Input[_builtins.str],
                 start_time_in_seconds: pulumi.Input[_builtins.int],
                 title: pulumi.Input[_builtins.str],
                 host_tag_group_host_names_group_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 relevant_customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags_anded: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a MaintenanceWindow resource.
        :param pulumi.Input[_builtins.int] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.str] reason: The reason for the maintenance window.
        :param pulumi.Input[_builtins.int] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.str] title: The title of the maintenance window.
        :param pulumi.Input[_builtins.bool] host_tag_group_host_names_group_anded: If `true`, a source/host must be in `relevant_host_names`
               and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
               order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
               or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because
               of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this
               maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance
               because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
               `relevant_host_names` is required.
        :param pulumi.Input[_builtins.bool] relevant_host_tags_anded: Whether to AND source/host tags listed in `relevant_host_tags`.
               If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
               the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        """
        pulumi.set(__self__, "end_time_in_seconds", end_time_in_seconds)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "start_time_in_seconds", start_time_in_seconds)
        pulumi.set(__self__, "title", title)
        if host_tag_group_host_names_group_anded is not None:
            pulumi.set(__self__, "host_tag_group_host_names_group_anded", host_tag_group_host_names_group_anded)
        if relevant_customer_tags is not None:
            pulumi.set(__self__, "relevant_customer_tags", relevant_customer_tags)
        if relevant_host_names is not None:
            pulumi.set(__self__, "relevant_host_names", relevant_host_names)
        if relevant_host_tags is not None:
            pulumi.set(__self__, "relevant_host_tags", relevant_host_tags)
        if relevant_host_tags_anded is not None:
            pulumi.set(__self__, "relevant_host_tags_anded", relevant_host_tags_anded)

    @_builtins.property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        end time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "end_time_in_seconds")

    @end_time_in_seconds.setter
    def end_time_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "end_time_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def reason(self) -> pulumi.Input[_builtins.str]:
        """
        The reason for the maintenance window.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reason", value)

    @_builtins.property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        start time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "start_time_in_seconds")

    @start_time_in_seconds.setter
    def start_time_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "start_time_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        """
        The title of the maintenance window.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, a source/host must be in `relevant_host_names`
        and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
        order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
        or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        """
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @host_tag_group_host_names_group_anded.setter
    def host_tag_group_host_names_group_anded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "host_tag_group_host_names_group_anded", value)

    @_builtins.property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alert tags whose matching alerts will be put into maintenance because
        of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_customer_tags")

    @relevant_customer_tags.setter
    def relevant_customer_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_customer_tags", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source/host names that will be put into maintenance because of this
        maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_host_names")

    @relevant_host_names.setter
    def relevant_host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_host_names", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source/host tags whose matching sources/hosts will be put into maintenance
        because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
        `relevant_host_names` is required.
        """
        return pulumi.get(self, "relevant_host_tags")

    @relevant_host_tags.setter
    def relevant_host_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_host_tags", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to AND source/host tags listed in `relevant_host_tags`.
        If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
        the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        """
        return pulumi.get(self, "relevant_host_tags_anded")

    @relevant_host_tags_anded.setter
    def relevant_host_tags_anded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "relevant_host_tags_anded", value)


@pulumi.input_type
class _MaintenanceWindowState:
    def __init__(__self__, *,
                 end_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 host_tag_group_host_names_group_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 relevant_customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaintenanceWindow resources.
        :param pulumi.Input[_builtins.int] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.bool] host_tag_group_host_names_group_anded: If `true`, a source/host must be in `relevant_host_names`
               and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
               order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
               or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        :param pulumi.Input[_builtins.str] reason: The reason for the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because
               of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this
               maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance
               because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
               `relevant_host_names` is required.
        :param pulumi.Input[_builtins.bool] relevant_host_tags_anded: Whether to AND source/host tags listed in `relevant_host_tags`.
               If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
               the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        :param pulumi.Input[_builtins.int] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.str] title: The title of the maintenance window.
        """
        if end_time_in_seconds is not None:
            pulumi.set(__self__, "end_time_in_seconds", end_time_in_seconds)
        if host_tag_group_host_names_group_anded is not None:
            pulumi.set(__self__, "host_tag_group_host_names_group_anded", host_tag_group_host_names_group_anded)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if relevant_customer_tags is not None:
            pulumi.set(__self__, "relevant_customer_tags", relevant_customer_tags)
        if relevant_host_names is not None:
            pulumi.set(__self__, "relevant_host_names", relevant_host_names)
        if relevant_host_tags is not None:
            pulumi.set(__self__, "relevant_host_tags", relevant_host_tags)
        if relevant_host_tags_anded is not None:
            pulumi.set(__self__, "relevant_host_tags_anded", relevant_host_tags_anded)
        if start_time_in_seconds is not None:
            pulumi.set(__self__, "start_time_in_seconds", start_time_in_seconds)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        end time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "end_time_in_seconds")

    @end_time_in_seconds.setter
    def end_time_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "end_time_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, a source/host must be in `relevant_host_names`
        and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
        order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
        or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        """
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @host_tag_group_host_names_group_anded.setter
    def host_tag_group_host_names_group_anded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "host_tag_group_host_names_group_anded", value)

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The reason for the maintenance window.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reason", value)

    @_builtins.property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of alert tags whose matching alerts will be put into maintenance because
        of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_customer_tags")

    @relevant_customer_tags.setter
    def relevant_customer_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_customer_tags", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source/host names that will be put into maintenance because of this
        maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_host_names")

    @relevant_host_names.setter
    def relevant_host_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_host_names", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of source/host tags whose matching sources/hosts will be put into maintenance
        because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
        `relevant_host_names` is required.
        """
        return pulumi.get(self, "relevant_host_tags")

    @relevant_host_tags.setter
    def relevant_host_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "relevant_host_tags", value)

    @_builtins.property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to AND source/host tags listed in `relevant_host_tags`.
        If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
        the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        """
        return pulumi.get(self, "relevant_host_tags_anded")

    @relevant_host_tags_anded.setter
    def relevant_host_tags_anded(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "relevant_host_tags_anded", value)

    @_builtins.property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        start time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "start_time_in_seconds")

    @start_time_in_seconds.setter
    def start_time_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_time_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The title of the maintenance window.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("wavefront:index/maintenanceWindow:MaintenanceWindow")
class MaintenanceWindow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 host_tag_group_host_names_group_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 relevant_customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Wavefront Maintenance Window Resource. This allows maintenance windows to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.MaintenanceWindow("basic",
            reason="Routine maintenance for 2020",
            title="Routine maintenance",
            start_time_in_seconds=1600123456,
            end_time_in_seconds=1601123456,
            relevant_host_names=[
                "my_hostname",
                "my_other_hostname",
            ])
        ```

        ## Import

        Maintenance windows can be imported using the `id`, e.g.

        ```sh
        $ pulumi import wavefront:index/maintenanceWindow:MaintenanceWindow basic 1600383357095
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.bool] host_tag_group_host_names_group_anded: If `true`, a source/host must be in `relevant_host_names`
               and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
               order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
               or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        :param pulumi.Input[_builtins.str] reason: The reason for the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because
               of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this
               maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance
               because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
               `relevant_host_names` is required.
        :param pulumi.Input[_builtins.bool] relevant_host_tags_anded: Whether to AND source/host tags listed in `relevant_host_tags`.
               If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
               the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        :param pulumi.Input[_builtins.int] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.str] title: The title of the maintenance window.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MaintenanceWindowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Maintenance Window Resource. This allows maintenance windows to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.MaintenanceWindow("basic",
            reason="Routine maintenance for 2020",
            title="Routine maintenance",
            start_time_in_seconds=1600123456,
            end_time_in_seconds=1601123456,
            relevant_host_names=[
                "my_hostname",
                "my_other_hostname",
            ])
        ```

        ## Import

        Maintenance windows can be imported using the `id`, e.g.

        ```sh
        $ pulumi import wavefront:index/maintenanceWindow:MaintenanceWindow basic 1600383357095
        ```

        :param str resource_name: The name of the resource.
        :param MaintenanceWindowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaintenanceWindowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 end_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 host_tag_group_host_names_group_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 reason: Optional[pulumi.Input[_builtins.str]] = None,
                 relevant_customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 relevant_host_tags_anded: Optional[pulumi.Input[_builtins.bool]] = None,
                 start_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaintenanceWindowArgs.__new__(MaintenanceWindowArgs)

            if end_time_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'end_time_in_seconds'")
            __props__.__dict__["end_time_in_seconds"] = end_time_in_seconds
            __props__.__dict__["host_tag_group_host_names_group_anded"] = host_tag_group_host_names_group_anded
            if reason is None and not opts.urn:
                raise TypeError("Missing required property 'reason'")
            __props__.__dict__["reason"] = reason
            __props__.__dict__["relevant_customer_tags"] = relevant_customer_tags
            __props__.__dict__["relevant_host_names"] = relevant_host_names
            __props__.__dict__["relevant_host_tags"] = relevant_host_tags
            __props__.__dict__["relevant_host_tags_anded"] = relevant_host_tags_anded
            if start_time_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'start_time_in_seconds'")
            __props__.__dict__["start_time_in_seconds"] = start_time_in_seconds
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
        super(MaintenanceWindow, __self__).__init__(
            'wavefront:index/maintenanceWindow:MaintenanceWindow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            end_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            host_tag_group_host_names_group_anded: Optional[pulumi.Input[_builtins.bool]] = None,
            reason: Optional[pulumi.Input[_builtins.str]] = None,
            relevant_customer_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            relevant_host_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            relevant_host_tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            relevant_host_tags_anded: Optional[pulumi.Input[_builtins.bool]] = None,
            start_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None) -> 'MaintenanceWindow':
        """
        Get an existing MaintenanceWindow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] end_time_in_seconds: end time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.bool] host_tag_group_host_names_group_anded: If `true`, a source/host must be in `relevant_host_names`
               and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
               order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
               or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        :param pulumi.Input[_builtins.str] reason: The reason for the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_customer_tags: List of alert tags whose matching alerts will be put into maintenance because
               of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_names: List of source/host names that will be put into maintenance because of this
               maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
               is required.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] relevant_host_tags: List of source/host tags whose matching sources/hosts will be put into maintenance
               because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
               `relevant_host_names` is required.
        :param pulumi.Input[_builtins.bool] relevant_host_tags_anded: Whether to AND source/host tags listed in `relevant_host_tags`.
               If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
               the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        :param pulumi.Input[_builtins.int] start_time_in_seconds: start time in seconds after 1 Jan 1970 GMT.
        :param pulumi.Input[_builtins.str] title: The title of the maintenance window.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaintenanceWindowState.__new__(_MaintenanceWindowState)

        __props__.__dict__["end_time_in_seconds"] = end_time_in_seconds
        __props__.__dict__["host_tag_group_host_names_group_anded"] = host_tag_group_host_names_group_anded
        __props__.__dict__["reason"] = reason
        __props__.__dict__["relevant_customer_tags"] = relevant_customer_tags
        __props__.__dict__["relevant_host_names"] = relevant_host_names
        __props__.__dict__["relevant_host_tags"] = relevant_host_tags
        __props__.__dict__["relevant_host_tags_anded"] = relevant_host_tags_anded
        __props__.__dict__["start_time_in_seconds"] = start_time_in_seconds
        __props__.__dict__["title"] = title
        return MaintenanceWindow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="endTimeInSeconds")
    def end_time_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        end time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "end_time_in_seconds")

    @_builtins.property
    @pulumi.getter(name="hostTagGroupHostNamesGroupAnded")
    def host_tag_group_host_names_group_anded(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, a source/host must be in `relevant_host_names`
        and have tags matching the specification formed by `relevant_host_tags` and `relevant_host_tags_anded` in
        order for this maintenance window to apply. If `false`, a source/host must either be in `relevant_host_names`
        or match `relevant_host_tags` and `relevant_host_tags_anded`. Default: `false`.
        """
        return pulumi.get(self, "host_tag_group_host_names_group_anded")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> pulumi.Output[_builtins.str]:
        """
        The reason for the maintenance window.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="relevantCustomerTags")
    def relevant_customer_tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of alert tags whose matching alerts will be put into maintenance because
        of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_customer_tags")

    @_builtins.property
    @pulumi.getter(name="relevantHostNames")
    def relevant_host_names(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of source/host names that will be put into maintenance because of this
        maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or `relevant_host_names`
        is required.
        """
        return pulumi.get(self, "relevant_host_names")

    @_builtins.property
    @pulumi.getter(name="relevantHostTags")
    def relevant_host_tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of source/host tags whose matching sources/hosts will be put into maintenance
        because of this maintenance window. At least one of `relevant_customer_tags`, `relevant_host_tags`, or
        `relevant_host_names` is required.
        """
        return pulumi.get(self, "relevant_host_tags")

    @_builtins.property
    @pulumi.getter(name="relevantHostTagsAnded")
    def relevant_host_tags_anded(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to AND source/host tags listed in `relevant_host_tags`.
        If `true`, a source/host must contain all tags in order for the maintenance window to apply. If `false`,
        the tags are OR'ed, and a source/host must contain one of the tags. Default: `false`.
        """
        return pulumi.get(self, "relevant_host_tags_anded")

    @_builtins.property
    @pulumi.getter(name="startTimeInSeconds")
    def start_time_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        start time in seconds after 1 Jan 1970 GMT.
        """
        return pulumi.get(self, "start_time_in_seconds")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[_builtins.str]:
        """
        The title of the maintenance window.
        """
        return pulumi.get(self, "title")

