# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['previewer', 'previewer.commands']

package_data = \
{'': ['*']}

install_requires = \
['Wand>=0.6.10,<0.7.0', 'colorama>=0.4.5,<0.5.0', 'python-magic>=0.4.27,<0.5.0']

entry_points = \
{'console_scripts': ['previewer = previewer.cli:run']}

setup_kwargs = {
    'name': 'previewer',
    'version': '0.4.0',
    'description': 'Video or Folder preview generator',
    'long_description': '![Github](https://img.shields.io/github/tag/essembeh/previewer.svg)\n![PyPi](https://img.shields.io/pypi/v/previewer.svg)\n![Python](https://img.shields.io/pypi/pyversions/previewer.svg)\n![CI](https://github.com/essembeh/previewer/actions/workflows/poetry.yml/badge.svg)\n\n# Previewer\n\nCommand line tool to generate montages/sequences from video clips or folders containing images.\n\n_previewer_ is a collection of tools:\n\n- `previewer montage`: to generate a single image with thumbnails (a _montage_) from a folder containing images or a video\n- `previewer gif`: to generate a Gif (or mp4/webp/webm) with thumbnails from a folder containing images or a video\n- `previewer video-thumbnailer`: to extract a given number of thumbnails from a video clip\n- `previewer resize`: to change geometry (resize, crop, fit, fill) of images\n\n# Install\n\nInstall dependencies\n\n```sh\n$ sudo apt update\n$ sudo apt install imagemagick ffmpeg\n```\n\nInstall the latest release of _previewer_ from [PyPI](https://pypi.org/project/previewer/)\n\n```sh\n$ pip3 install previewer\n$ previewer-montage --help\n```\n\nOr install _previewer_ from the sources\n\n```sh\n$ pip3 install poetry\n$ pip3 install git+https://github.com/essembeh/previewer\n$ previewer --help\n```\n\n# Montage\n\n`previewer montage` can create _preview_ image from a folder containing images or a video.\n\nYou can customize the generated image:\n\n- change the background color\n- change geometry (width, height, crop, fit or fill) of the thumbnails\n- show or hide the a title\n- show or hide image filenames\n- adjust the space between thumbnails\n- add a border, a shadow to thumbnails\n\nExample:\n\n```sh\n$ previewer montage --size 120x120 --crop --fill --background SlateGray1 "Rick Astley - Never Gonna Give You Up (Official Music Video).mp4"\n🎬 Generate montage from video ./Rick Astley - Never Gonna Give You Up (Official Music Video).mp4 using 36 thumbnails\n🍺 Montage generated ./Rick Astley - Never Gonna Give You Up (Official Music Video).jpg\n```\n\n![Example of montage](images/montage.jpg)\n\n# Sequence\n\n`previewer gif` can generate sequences with images in a folder or extracted from a video.\n\nYou can customize the sequence:\n\n- choose the format between _gif_, _mp4_, _webp_ or _webm_\n- adjust _fps_ (frames per seconds), _delay_ between 2 frames ...\n- when extrating frames from a video, you can either use a fixed number of frames to extract or compute it given a given _speed_\n- change geometry (width, height, crop, fit or fill) of the frames\n\nExample:\n\n```sh\n$ previewer gif --size 320x240 --crop --fill -n 20 "Rick Astley - Never Gonna Give You Up (Official Music Video).mp4"\n🎬 Generate gif from video ./Rick Astley - Never Gonna Give You Up (Official Music Video).mp4 using 20 thumbnails\n🍺 Sequence generated ./Rick Astley - Never Gonna Give You Up (Official Music Video).gif\n```\n\n![Example of sequence](images/sequence.gif)\n\n```sh\n$ previewer gif --start 3 --end 4 --fps 10 --aba --size 320x240 --crop --fill "Rick Astley - Never Gonna Give You Up (Official Music Video).mp4"\n🎬 Generate gif from video ./Rick Astley - Never Gonna Give You Up (Official Music Video).mp4 using 10 thumbnails\n🍺 Sequence generated ./Rick Astley - Never Gonna Give You Up (Official Music Video).gif\n```\n\n![Example of sequence with A-B-A loop](images/sequence-aba.gif)\n\n# Thumbnailer\n\n`previewer video-thumbnailer` can extract and resize/crop frames from a video\n\nYou can also:\n\n- choose the frame count to extract\n- select a start position and/or a end position in the video\n- change geometry (width, height, crop, fit or fill) of the frames\n\nExample:\n\n```sh\n$ previewer video-thumbnailer -n 20 "Rick Astley - Never Gonna Give You Up (Official Music Video).mp4"\nExtract 20 thumbnails from ./Rick Astley - Never Gonna Give You Up (Official Music Video).mp4\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 01 (0:00:05).jpg (1920x1080) at position 0:00:05\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 02 (0:00:15).jpg (1920x1080) at position 0:00:15\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 03 (0:00:26).jpg (1920x1080) at position 0:00:26\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 04 (0:00:37).jpg (1920x1080) at position 0:00:37\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 05 (0:00:47).jpg (1920x1080) at position 0:00:47\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 06 (0:00:58).jpg (1920x1080) at position 0:00:58\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 07 (0:01:08).jpg (1920x1080) at position 0:01:08\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 08 (0:01:19).jpg (1920x1080) at position 0:01:19\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 09 (0:01:30).jpg (1920x1080) at position 0:01:30\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 10 (0:01:40).jpg (1920x1080) at position 0:01:40\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 11 (0:01:51).jpg (1920x1080) at position 0:01:51\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 12 (0:02:01).jpg (1920x1080) at position 0:02:01\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 13 (0:02:12).jpg (1920x1080) at position 0:02:12\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 14 (0:02:23).jpg (1920x1080) at position 0:02:23\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 15 (0:02:33).jpg (1920x1080) at position 0:02:33\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 16 (0:02:44).jpg (1920x1080) at position 0:02:44\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 17 (0:02:54).jpg (1920x1080) at position 0:02:54\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 18 (0:03:05).jpg (1920x1080) at position 0:03:05\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 19 (0:03:16).jpg (1920x1080) at position 0:03:16\n  Rick Astley - Never Gonna Give You Up (Official Music Video)/frame 20 (0:03:26).jpg (1920x1080) at position 0:03:26\n🍺 20 thumbnails extracted in Rick Astley - Never Gonna Give You Up (Official Music Video)/\n\n```\n\n![Example of thumbnailer](images/frames.png)\n',
    'author': 'Sébastien MB',
    'author_email': 'seb@essembeh.org',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/essembeh/previewer',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
