"""Contains all the data models used in inputs/outputs"""

from .attachment import Attachment
from .attachment_create_from_url import AttachmentCreateFromUrl
from .comment import Comment
from .comment_create import CommentCreate
from .concise_doc import ConciseDoc
from .concise_task import ConciseTask
from .custom_properties import CustomProperties
from .dartboard import Dartboard
from .doc import Doc
from .doc_create import DocCreate
from .doc_update import DocUpdate
from .folder import Folder
from .list_comments_o_item import ListCommentsOItem
from .list_docs_o_item import ListDocsOItem
from .paginated_comment_list import PaginatedCommentList
from .paginated_concise_doc_list import PaginatedConciseDocList
from .paginated_concise_task_list import PaginatedConciseTaskList
from .priority import Priority
from .skill import Skill
from .task import Task
from .task_create import TaskCreate
from .task_relationships_type_0 import TaskRelationshipsType0
from .task_update import TaskUpdate
from .time_tracking_entry import TimeTrackingEntry
from .user import User
from .user_space_configuration import UserSpaceConfiguration
from .user_space_configuration_custom_property_checkbox_type_def import (
    UserSpaceConfigurationCustomPropertyCheckboxTypeDef,
)
from .user_space_configuration_custom_property_dates_type_def import (
    UserSpaceConfigurationCustomPropertyDatesTypeDef,
)
from .user_space_configuration_custom_property_multiselect_type_def import (
    UserSpaceConfigurationCustomPropertyMultiselectTypeDef,
)
from .user_space_configuration_custom_property_number_type_def import (
    UserSpaceConfigurationCustomPropertyNumberTypeDef,
)
from .user_space_configuration_custom_property_number_type_def_custom_property_number_format_type_def import (
    UserSpaceConfigurationCustomPropertyNumberTypeDefCustomPropertyNumberFormatTypeDef,
)
from .user_space_configuration_custom_property_select_type_def import (
    UserSpaceConfigurationCustomPropertySelectTypeDef,
)
from .user_space_configuration_custom_property_status_type_def import (
    UserSpaceConfigurationCustomPropertyStatusTypeDef,
)
from .user_space_configuration_custom_property_text_type_def import (
    UserSpaceConfigurationCustomPropertyTextTypeDef,
)
from .user_space_configuration_custom_property_time_tracking_type_def import (
    UserSpaceConfigurationCustomPropertyTimeTrackingTypeDef,
)
from .user_space_configuration_custom_property_user_type_def import (
    UserSpaceConfigurationCustomPropertyUserTypeDef,
)
from .view import View
from .wrapped_comment import WrappedComment
from .wrapped_comment_create import WrappedCommentCreate
from .wrapped_dartboard import WrappedDartboard
from .wrapped_doc import WrappedDoc
from .wrapped_doc_create import WrappedDocCreate
from .wrapped_doc_update import WrappedDocUpdate
from .wrapped_folder import WrappedFolder
from .wrapped_help_center_articles import WrappedHelpCenterArticles
from .wrapped_skill import WrappedSkill
from .wrapped_task import WrappedTask
from .wrapped_task_create import WrappedTaskCreate
from .wrapped_task_update import WrappedTaskUpdate
from .wrapped_view import WrappedView

__all__ = (
    "Attachment",
    "AttachmentCreateFromUrl",
    "Comment",
    "CommentCreate",
    "ConciseDoc",
    "ConciseTask",
    "CustomProperties",
    "Dartboard",
    "Doc",
    "DocCreate",
    "DocUpdate",
    "Folder",
    "ListCommentsOItem",
    "ListDocsOItem",
    "PaginatedCommentList",
    "PaginatedConciseDocList",
    "PaginatedConciseTaskList",
    "Priority",
    "Skill",
    "Task",
    "TaskCreate",
    "TaskRelationshipsType0",
    "TaskUpdate",
    "TimeTrackingEntry",
    "User",
    "UserSpaceConfiguration",
    "UserSpaceConfigurationCustomPropertyCheckboxTypeDef",
    "UserSpaceConfigurationCustomPropertyDatesTypeDef",
    "UserSpaceConfigurationCustomPropertyMultiselectTypeDef",
    "UserSpaceConfigurationCustomPropertyNumberTypeDef",
    "UserSpaceConfigurationCustomPropertyNumberTypeDefCustomPropertyNumberFormatTypeDef",
    "UserSpaceConfigurationCustomPropertySelectTypeDef",
    "UserSpaceConfigurationCustomPropertyStatusTypeDef",
    "UserSpaceConfigurationCustomPropertyTextTypeDef",
    "UserSpaceConfigurationCustomPropertyTimeTrackingTypeDef",
    "UserSpaceConfigurationCustomPropertyUserTypeDef",
    "View",
    "WrappedComment",
    "WrappedCommentCreate",
    "WrappedDartboard",
    "WrappedDoc",
    "WrappedDocCreate",
    "WrappedDocUpdate",
    "WrappedFolder",
    "WrappedHelpCenterArticles",
    "WrappedSkill",
    "WrappedTask",
    "WrappedTaskCreate",
    "WrappedTaskUpdate",
    "WrappedView",
)
