from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Iterable as _Iterable, Mapping as _Mapping, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class Material(_message.Message):
    __slots__ = ("no", "material_type", "material_model", "application_context", "diagram_type", "user_defined_name_enabled", "name", "user_defined", "definition_type", "stress_failure_hypothesis", "is_temperature_dependent", "is_dynamic_increase_factor", "has_cost_estimation", "optimization", "has_emissions_estimation", "reference_temperature", "temperature_properties_sorted", "temperature", "stiffness_modification", "stiffness_modification_type", "has_linear_elastic_with_nonlinear_criteria", "comment", "is_generated", "generating_object_info", "members_weight_active", "members_weight_unit_cost", "members_weight_unit", "members_weight_quantity", "members_weight_cost", "members_volume_active", "members_volume_unit_cost", "members_volume_unit", "members_volume_quantity", "members_volume_cost", "members_surface_active", "members_surface_unit_cost", "members_surface_unit", "members_surface_quantity", "members_surface_cost", "surfaces_weight_active", "surfaces_weight_unit_cost", "surfaces_weight_unit", "surfaces_weight_quantity", "surfaces_weight_cost", "surfaces_volume_active", "surfaces_volume_unit_cost", "surfaces_volume_unit", "surfaces_volume_quantity", "surfaces_volume_cost", "surfaces_top_face_active", "surfaces_top_face_unit_cost", "surfaces_top_face_unit", "surfaces_top_face_quantity", "surfaces_top_face_cost", "surfaces_area_active", "surfaces_area_unit_cost", "surfaces_area_unit", "surfaces_area_quantity", "surfaces_area_cost", "surfaces_bottom_face_active", "surfaces_bottom_face_unit_cost", "surfaces_bottom_face_unit", "surfaces_bottom_face_quantity", "surfaces_bottom_face_cost", "solids_weight_active", "solids_weight_unit_cost", "solids_weight_unit", "solids_weight_quantity", "solids_weight_cost", "solids_volume_active", "solids_volume_unit_cost", "solids_volume_unit", "solids_volume_quantity", "solids_volume_cost", "solids_area_active", "solids_area_unit_cost", "solids_area_unit", "solids_area_quantity", "solids_area_cost", "sum_weight", "weight_percentage", "cost_percentage", "sum_cost", "total_cost", "emissions_members_weight_active", "emissions_members_weight_unit_emission", "emissions_members_weight_unit", "emissions_members_weight_quantity", "emissions_members_weight_emission", "emissions_members_volume_active", "emissions_members_volume_unit_emission", "emissions_members_volume_unit", "emissions_members_volume_quantity", "emissions_members_volume_emission", "emissions_members_surface_active", "emissions_members_surface_unit_emission", "emissions_members_surface_unit", "emissions_members_surface_quantity", "emissions_members_surface_emission", "emissions_surfaces_weight_active", "emissions_surfaces_weight_unit_emission", "emissions_surfaces_weight_unit", "emissions_surfaces_weight_quantity", "emissions_surfaces_weight_emission", "emissions_surfaces_volume_active", "emissions_surfaces_volume_unit_emission", "emissions_surfaces_volume_unit", "emissions_surfaces_volume_quantity", "emissions_surfaces_volume_emission", "emissions_surfaces_top_face_active", "emissions_surfaces_top_face_unit_emission", "emissions_surfaces_top_face_unit", "emissions_surfaces_top_face_quantity", "emissions_surfaces_top_face_emission", "emissions_surfaces_area_active", "emissions_surfaces_area_unit_emission", "emissions_surfaces_area_unit", "emissions_surfaces_area_quantity", "emissions_surfaces_area_emission", "emissions_surfaces_bottom_face_active", "emissions_surfaces_bottom_face_unit_emission", "emissions_surfaces_bottom_face_unit", "emissions_surfaces_bottom_face_quantity", "emissions_surfaces_bottom_face_emission", "emissions_solids_weight_active", "emissions_solids_weight_unit_emission", "emissions_solids_weight_unit", "emissions_solids_weight_quantity", "emissions_solids_weight_emission", "emissions_solids_volume_active", "emissions_solids_volume_unit_emission", "emissions_solids_volume_unit", "emissions_solids_volume_quantity", "emissions_solids_volume_emission", "emissions_solids_area_active", "emissions_solids_area_unit_emission", "emissions_solids_area_unit", "emissions_solids_area_quantity", "emissions_solids_area_emission", "emissions_percentage", "emissions_sum", "emissions_total", "use_of_material_model_orientation", "use_of_material_model_alignment", "id_for_export_import", "metadata_for_export_import")
    class MaterialType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MATERIAL_TYPE_BASIC: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_ALUMINUM: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_CONCRETE: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_FABRIC: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_FIBER_CONCRETE: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_FOIL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_GAS: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_GLASS: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_GYPSUM: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_MASONRY: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_METAL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_PLASTICS: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_PRESTRESSING_STEEL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_REINFORCING_STEEL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_SOIL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_STEEL: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_TIMBER: _ClassVar[Material.MaterialType]
        MATERIAL_TYPE_VIRTUAL_JOIST_GIRDER: _ClassVar[Material.MaterialType]
    MATERIAL_TYPE_BASIC: Material.MaterialType
    MATERIAL_TYPE_ALUMINUM: Material.MaterialType
    MATERIAL_TYPE_CONCRETE: Material.MaterialType
    MATERIAL_TYPE_FABRIC: Material.MaterialType
    MATERIAL_TYPE_FIBER_CONCRETE: Material.MaterialType
    MATERIAL_TYPE_FOIL: Material.MaterialType
    MATERIAL_TYPE_GAS: Material.MaterialType
    MATERIAL_TYPE_GLASS: Material.MaterialType
    MATERIAL_TYPE_GYPSUM: Material.MaterialType
    MATERIAL_TYPE_MASONRY: Material.MaterialType
    MATERIAL_TYPE_METAL: Material.MaterialType
    MATERIAL_TYPE_PLASTICS: Material.MaterialType
    MATERIAL_TYPE_PRESTRESSING_STEEL: Material.MaterialType
    MATERIAL_TYPE_REINFORCING_STEEL: Material.MaterialType
    MATERIAL_TYPE_SOIL: Material.MaterialType
    MATERIAL_TYPE_STEEL: Material.MaterialType
    MATERIAL_TYPE_TIMBER: Material.MaterialType
    MATERIAL_TYPE_VIRTUAL_JOIST_GIRDER: Material.MaterialType
    class MaterialModel(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MATERIAL_MODEL_ISOTROPIC_LINEAR_ELASTIC: _ClassVar[Material.MaterialModel]
        MATERIAL_E_MATERIAL_MODEL_ISOTROPIC_SOIL_PLASTIC_MODIFIED_HARDENING_SOIL_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ANISOTROPIC_DAMAGE: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_DAMAGE_2D_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_MASONRY_PLASTIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_NONLINEAR_ELASTIC_1D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_NONLINEAR_ELASTIC_2D_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_PLASTIC_1D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_PLASTIC_2D_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_ROCK_PLASTIC_HOEK_BROWN_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_SOIL_NONLINEAR_ELASTIC_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_SOIL_PLASTIC_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ISOTROPIC_TIMBER_LINEAR_ELASTIC_1D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_ANISOTROPIC_DAMAGE: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_FABRIC_NONLINEAR_ELASTIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_MASONRY_PLASTIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_PLASTIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_PLASTIC_3D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_TIMBER_LINEAR_ELASTIC_2D: _ClassVar[Material.MaterialModel]
        MATERIAL_MODEL_ORTHOTROPIC_WELD_PLASTIC_2D: _ClassVar[Material.MaterialModel]
    MATERIAL_MODEL_ISOTROPIC_LINEAR_ELASTIC: Material.MaterialModel
    MATERIAL_E_MATERIAL_MODEL_ISOTROPIC_SOIL_PLASTIC_MODIFIED_HARDENING_SOIL_3D: Material.MaterialModel
    MATERIAL_MODEL_ANISOTROPIC_DAMAGE: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_DAMAGE_2D_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_MASONRY_PLASTIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_NONLINEAR_ELASTIC_1D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_NONLINEAR_ELASTIC_2D_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_PLASTIC_1D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_PLASTIC_2D_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_ROCK_PLASTIC_HOEK_BROWN_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_SOIL_NONLINEAR_ELASTIC_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_SOIL_PLASTIC_3D: Material.MaterialModel
    MATERIAL_MODEL_ISOTROPIC_TIMBER_LINEAR_ELASTIC_1D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_3D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_ANISOTROPIC_DAMAGE: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_FABRIC_NONLINEAR_ELASTIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_MASONRY_PLASTIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_PLASTIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_PLASTIC_3D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_TIMBER_LINEAR_ELASTIC_2D: Material.MaterialModel
    MATERIAL_MODEL_ORTHOTROPIC_WELD_PLASTIC_2D: Material.MaterialModel
    class ApplicationContext(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        APPLICATION_CONTEXT_INVALID: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_ALUMINUM_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_COMBINATION_WIZARD: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_CONCRETE_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_CONCRETE_FOUNDATION_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_CRANEWAY_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_DYNAMIC_ANALYSIS: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_GEOTECHNICAL_ANALYSIS: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_GLASS_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_LOAD_WIZARD: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_MASONRY_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_PIPING_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_STEEL_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_STEEL_DESIGN_COLD_FORMED: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_STEEL_JOINT_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_TIMBER_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_TIMBER_JOINT_DESIGN: _ClassVar[Material.ApplicationContext]
        APPLICATION_CONTEXT_TOWER_DESIGN: _ClassVar[Material.ApplicationContext]
    APPLICATION_CONTEXT_INVALID: Material.ApplicationContext
    APPLICATION_CONTEXT_ALUMINUM_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_COMBINATION_WIZARD: Material.ApplicationContext
    APPLICATION_CONTEXT_CONCRETE_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_CONCRETE_FOUNDATION_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_CRANEWAY_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_DYNAMIC_ANALYSIS: Material.ApplicationContext
    APPLICATION_CONTEXT_GEOTECHNICAL_ANALYSIS: Material.ApplicationContext
    APPLICATION_CONTEXT_GLASS_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_LOAD_WIZARD: Material.ApplicationContext
    APPLICATION_CONTEXT_MASONRY_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_PIPING_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_STEEL_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_STEEL_DESIGN_COLD_FORMED: Material.ApplicationContext
    APPLICATION_CONTEXT_STEEL_JOINT_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_TIMBER_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_TIMBER_JOINT_DESIGN: Material.ApplicationContext
    APPLICATION_CONTEXT_TOWER_DESIGN: Material.ApplicationContext
    class DiagramType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DIAGRAM_TYPE_BASIC: _ClassVar[Material.DiagramType]
        DIAGRAM_TYPE_BILINEAR: _ClassVar[Material.DiagramType]
        DIAGRAM_TYPE_STRESS_STRAIN_DIAGRAM: _ClassVar[Material.DiagramType]
    DIAGRAM_TYPE_BASIC: Material.DiagramType
    DIAGRAM_TYPE_BILINEAR: Material.DiagramType
    DIAGRAM_TYPE_STRESS_STRAIN_DIAGRAM: Material.DiagramType
    class DefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        DEFINITION_TYPE_DERIVED_NU: _ClassVar[Material.DefinitionType]
        DEFINITION_TYPE_DERIVED_G: _ClassVar[Material.DefinitionType]
        DEFINITION_TYPE_E_G_NO_NU: _ClassVar[Material.DefinitionType]
        DEFINITION_TYPE_E_G_NU: _ClassVar[Material.DefinitionType]
        DEFINITION_TYPE_NONE: _ClassVar[Material.DefinitionType]
    DEFINITION_TYPE_DERIVED_NU: Material.DefinitionType
    DEFINITION_TYPE_DERIVED_G: Material.DefinitionType
    DEFINITION_TYPE_E_G_NO_NU: Material.DefinitionType
    DEFINITION_TYPE_E_G_NU: Material.DefinitionType
    DEFINITION_TYPE_NONE: Material.DefinitionType
    class StressFailureHypothesis(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STRESS_FAILURE_HYPOTHESIS_VON_MISES: _ClassVar[Material.StressFailureHypothesis]
        STRESS_FAILURE_HYPOTHESIS_DRUCKER_PRAGER: _ClassVar[Material.StressFailureHypothesis]
        STRESS_FAILURE_HYPOTHESIS_MOHR_COULOMB: _ClassVar[Material.StressFailureHypothesis]
        STRESS_FAILURE_HYPOTHESIS_OEDOMETRIC_CONDITIONS: _ClassVar[Material.StressFailureHypothesis]
        STRESS_FAILURE_HYPOTHESIS_OEDOMETRIC_CONDITIONS_WITH_SMALL_STRAIN_STIFFNESS: _ClassVar[Material.StressFailureHypothesis]
        STRESS_FAILURE_HYPOTHESIS_TRESCA: _ClassVar[Material.StressFailureHypothesis]
    STRESS_FAILURE_HYPOTHESIS_VON_MISES: Material.StressFailureHypothesis
    STRESS_FAILURE_HYPOTHESIS_DRUCKER_PRAGER: Material.StressFailureHypothesis
    STRESS_FAILURE_HYPOTHESIS_MOHR_COULOMB: Material.StressFailureHypothesis
    STRESS_FAILURE_HYPOTHESIS_OEDOMETRIC_CONDITIONS: Material.StressFailureHypothesis
    STRESS_FAILURE_HYPOTHESIS_OEDOMETRIC_CONDITIONS_WITH_SMALL_STRAIN_STIFFNESS: Material.StressFailureHypothesis
    STRESS_FAILURE_HYPOTHESIS_TRESCA: Material.StressFailureHypothesis
    class StiffnessModificationType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STIFFNESS_MODIFICATION_TYPE_DIVISION: _ClassVar[Material.StiffnessModificationType]
        STIFFNESS_MODIFICATION_TYPE_MULTIPLICATION: _ClassVar[Material.StiffnessModificationType]
    STIFFNESS_MODIFICATION_TYPE_DIVISION: Material.StiffnessModificationType
    STIFFNESS_MODIFICATION_TYPE_MULTIPLICATION: Material.StiffnessModificationType
    class MembersWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBERS_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_GRAM: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_OUNCE: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_POUND: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.MembersWeightUnit]
        MEMBERS_WEIGHT_UNIT_SLUG: _ClassVar[Material.MembersWeightUnit]
    MEMBERS_WEIGHT_UNIT_UNKNOWN: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_GRAM: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_HUNDREDWEIGHT: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_KILOGRAM: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_METRIC_TON: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_OUNCE: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_POUND: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_SHORT_TON: Material.MembersWeightUnit
    MEMBERS_WEIGHT_UNIT_SLUG: Material.MembersWeightUnit
    class MembersVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBERS_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_LITER: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_PINT: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_QUART: _ClassVar[Material.MembersVolumeUnit]
        MEMBERS_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.MembersVolumeUnit]
    MEMBERS_VOLUME_UNIT_UNKNOWN: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_CENTIMETER: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_FOOT: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_INCH: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_METER: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_MILIMETER: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_CUBIC_YARD: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_FLUID_OUNCE: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_IMPERIAL_GALLON: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_LITER: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_PINT: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_QUART: Material.MembersVolumeUnit
    MEMBERS_VOLUME_UNIT_US_LIQUID_GALLON: Material.MembersVolumeUnit
    class MembersSurfaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        MEMBERS_SURFACE_UNIT_UNKNOWN: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_FOOT: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_INCH: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_METER: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.MembersSurfaceUnit]
        MEMBERS_SURFACE_UNIT_SQUARED_YARD: _ClassVar[Material.MembersSurfaceUnit]
    MEMBERS_SURFACE_UNIT_UNKNOWN: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_CENTIMETER: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_FOOT: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_INCH: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_METER: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_MILIMETER: Material.MembersSurfaceUnit
    MEMBERS_SURFACE_UNIT_SQUARED_YARD: Material.MembersSurfaceUnit
    class SurfacesWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SURFACES_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_GRAM: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_OUNCE: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_POUND: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.SurfacesWeightUnit]
        SURFACES_WEIGHT_UNIT_SLUG: _ClassVar[Material.SurfacesWeightUnit]
    SURFACES_WEIGHT_UNIT_UNKNOWN: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_GRAM: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_HUNDREDWEIGHT: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_KILOGRAM: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_METRIC_TON: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_OUNCE: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_POUND: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_SHORT_TON: Material.SurfacesWeightUnit
    SURFACES_WEIGHT_UNIT_SLUG: Material.SurfacesWeightUnit
    class SurfacesVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SURFACES_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_LITER: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_PINT: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_QUART: _ClassVar[Material.SurfacesVolumeUnit]
        SURFACES_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.SurfacesVolumeUnit]
    SURFACES_VOLUME_UNIT_UNKNOWN: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_CENTIMETER: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_FOOT: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_INCH: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_METER: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_MILIMETER: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_CUBIC_YARD: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_FLUID_OUNCE: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_IMPERIAL_GALLON: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_LITER: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_PINT: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_QUART: Material.SurfacesVolumeUnit
    SURFACES_VOLUME_UNIT_US_LIQUID_GALLON: Material.SurfacesVolumeUnit
    class SurfacesTopFaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SURFACES_TOP_FACE_UNIT_UNKNOWN: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_FOOT: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_INCH: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_METER: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.SurfacesTopFaceUnit]
        SURFACES_TOP_FACE_UNIT_SQUARED_YARD: _ClassVar[Material.SurfacesTopFaceUnit]
    SURFACES_TOP_FACE_UNIT_UNKNOWN: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_CENTIMETER: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_FOOT: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_INCH: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_METER: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_MILIMETER: Material.SurfacesTopFaceUnit
    SURFACES_TOP_FACE_UNIT_SQUARED_YARD: Material.SurfacesTopFaceUnit
    class SurfacesAreaUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SURFACES_AREA_UNIT_UNKNOWN: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_FOOT: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_INCH: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_METER: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_MILIMETER: _ClassVar[Material.SurfacesAreaUnit]
        SURFACES_AREA_UNIT_SQUARED_YARD: _ClassVar[Material.SurfacesAreaUnit]
    SURFACES_AREA_UNIT_UNKNOWN: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_CENTIMETER: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_FOOT: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_INCH: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_METER: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_MILIMETER: Material.SurfacesAreaUnit
    SURFACES_AREA_UNIT_SQUARED_YARD: Material.SurfacesAreaUnit
    class SurfacesBottomFaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SURFACES_BOTTOM_FACE_UNIT_UNKNOWN: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_FOOT: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_INCH: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_METER: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.SurfacesBottomFaceUnit]
        SURFACES_BOTTOM_FACE_UNIT_SQUARED_YARD: _ClassVar[Material.SurfacesBottomFaceUnit]
    SURFACES_BOTTOM_FACE_UNIT_UNKNOWN: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_CENTIMETER: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_FOOT: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_INCH: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_METER: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_MILIMETER: Material.SurfacesBottomFaceUnit
    SURFACES_BOTTOM_FACE_UNIT_SQUARED_YARD: Material.SurfacesBottomFaceUnit
    class SolidsWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SOLIDS_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_GRAM: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_OUNCE: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_POUND: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.SolidsWeightUnit]
        SOLIDS_WEIGHT_UNIT_SLUG: _ClassVar[Material.SolidsWeightUnit]
    SOLIDS_WEIGHT_UNIT_UNKNOWN: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_GRAM: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_HUNDREDWEIGHT: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_KILOGRAM: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_METRIC_TON: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_OUNCE: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_POUND: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_SHORT_TON: Material.SolidsWeightUnit
    SOLIDS_WEIGHT_UNIT_SLUG: Material.SolidsWeightUnit
    class SolidsVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SOLIDS_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_LITER: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_PINT: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_QUART: _ClassVar[Material.SolidsVolumeUnit]
        SOLIDS_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.SolidsVolumeUnit]
    SOLIDS_VOLUME_UNIT_UNKNOWN: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_CENTIMETER: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_FOOT: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_INCH: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_METER: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_MILIMETER: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_CUBIC_YARD: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_FLUID_OUNCE: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_IMPERIAL_GALLON: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_LITER: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_PINT: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_QUART: Material.SolidsVolumeUnit
    SOLIDS_VOLUME_UNIT_US_LIQUID_GALLON: Material.SolidsVolumeUnit
    class SolidsAreaUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        SOLIDS_AREA_UNIT_UNKNOWN: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_FOOT: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_INCH: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_METER: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_MILIMETER: _ClassVar[Material.SolidsAreaUnit]
        SOLIDS_AREA_UNIT_SQUARED_YARD: _ClassVar[Material.SolidsAreaUnit]
    SOLIDS_AREA_UNIT_UNKNOWN: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_CENTIMETER: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_FOOT: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_INCH: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_METER: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_MILIMETER: Material.SolidsAreaUnit
    SOLIDS_AREA_UNIT_SQUARED_YARD: Material.SolidsAreaUnit
    class EmissionsMembersWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_MEMBERS_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_GRAM: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_OUNCE: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_POUND: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.EmissionsMembersWeightUnit]
        EMISSIONS_MEMBERS_WEIGHT_UNIT_SLUG: _ClassVar[Material.EmissionsMembersWeightUnit]
    EMISSIONS_MEMBERS_WEIGHT_UNIT_UNKNOWN: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_GRAM: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_HUNDREDWEIGHT: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_KILOGRAM: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_METRIC_TON: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_OUNCE: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_POUND: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_SHORT_TON: Material.EmissionsMembersWeightUnit
    EMISSIONS_MEMBERS_WEIGHT_UNIT_SLUG: Material.EmissionsMembersWeightUnit
    class EmissionsMembersVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_MEMBERS_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_LITER: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_PINT: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_QUART: _ClassVar[Material.EmissionsMembersVolumeUnit]
        EMISSIONS_MEMBERS_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.EmissionsMembersVolumeUnit]
    EMISSIONS_MEMBERS_VOLUME_UNIT_UNKNOWN: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_CENTIMETER: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_FOOT: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_INCH: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_METER: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_MILIMETER: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_CUBIC_YARD: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_FLUID_OUNCE: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_IMPERIAL_GALLON: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_LITER: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_PINT: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_QUART: Material.EmissionsMembersVolumeUnit
    EMISSIONS_MEMBERS_VOLUME_UNIT_US_LIQUID_GALLON: Material.EmissionsMembersVolumeUnit
    class EmissionsMembersSurfaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_MEMBERS_SURFACE_UNIT_UNKNOWN: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_FOOT: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_INCH: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_METER: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.EmissionsMembersSurfaceUnit]
        EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_YARD: _ClassVar[Material.EmissionsMembersSurfaceUnit]
    EMISSIONS_MEMBERS_SURFACE_UNIT_UNKNOWN: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_CENTIMETER: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_FOOT: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_INCH: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_METER: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_MILIMETER: Material.EmissionsMembersSurfaceUnit
    EMISSIONS_MEMBERS_SURFACE_UNIT_SQUARED_YARD: Material.EmissionsMembersSurfaceUnit
    class EmissionsSurfacesWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SURFACES_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_GRAM: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_OUNCE: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_POUND: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.EmissionsSurfacesWeightUnit]
        EMISSIONS_SURFACES_WEIGHT_UNIT_SLUG: _ClassVar[Material.EmissionsSurfacesWeightUnit]
    EMISSIONS_SURFACES_WEIGHT_UNIT_UNKNOWN: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_GRAM: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_HUNDREDWEIGHT: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_KILOGRAM: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_METRIC_TON: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_OUNCE: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_POUND: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_SHORT_TON: Material.EmissionsSurfacesWeightUnit
    EMISSIONS_SURFACES_WEIGHT_UNIT_SLUG: Material.EmissionsSurfacesWeightUnit
    class EmissionsSurfacesVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SURFACES_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_LITER: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_PINT: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_QUART: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
        EMISSIONS_SURFACES_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.EmissionsSurfacesVolumeUnit]
    EMISSIONS_SURFACES_VOLUME_UNIT_UNKNOWN: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_CENTIMETER: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_FOOT: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_INCH: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_METER: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_MILIMETER: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_CUBIC_YARD: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_FLUID_OUNCE: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_IMPERIAL_GALLON: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_LITER: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_PINT: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_QUART: Material.EmissionsSurfacesVolumeUnit
    EMISSIONS_SURFACES_VOLUME_UNIT_US_LIQUID_GALLON: Material.EmissionsSurfacesVolumeUnit
    class EmissionsSurfacesTopFaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SURFACES_TOP_FACE_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_FOOT: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_INCH: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_METER: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
        EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_YARD: _ClassVar[Material.EmissionsSurfacesTopFaceUnit]
    EMISSIONS_SURFACES_TOP_FACE_UNIT_UNKNOWN: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_CENTIMETER: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_FOOT: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_INCH: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_METER: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_MILIMETER: Material.EmissionsSurfacesTopFaceUnit
    EMISSIONS_SURFACES_TOP_FACE_UNIT_SQUARED_YARD: Material.EmissionsSurfacesTopFaceUnit
    class EmissionsSurfacesAreaUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SURFACES_AREA_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_FOOT: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_INCH: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_METER: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_MILIMETER: _ClassVar[Material.EmissionsSurfacesAreaUnit]
        EMISSIONS_SURFACES_AREA_UNIT_SQUARED_YARD: _ClassVar[Material.EmissionsSurfacesAreaUnit]
    EMISSIONS_SURFACES_AREA_UNIT_UNKNOWN: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_CENTIMETER: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_FOOT: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_INCH: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_METER: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_MILIMETER: Material.EmissionsSurfacesAreaUnit
    EMISSIONS_SURFACES_AREA_UNIT_SQUARED_YARD: Material.EmissionsSurfacesAreaUnit
    class EmissionsSurfacesBottomFaceUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_FOOT: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_INCH: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_METER: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_MILIMETER: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
        EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_YARD: _ClassVar[Material.EmissionsSurfacesBottomFaceUnit]
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_UNKNOWN: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_CENTIMETER: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_FOOT: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_INCH: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_METER: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_MILIMETER: Material.EmissionsSurfacesBottomFaceUnit
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_SQUARED_YARD: Material.EmissionsSurfacesBottomFaceUnit
    class EmissionsSolidsWeightUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SOLIDS_WEIGHT_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_GRAM: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_HUNDREDWEIGHT: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_KILOGRAM: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_METRIC_TON: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_OUNCE: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_POUND: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_SHORT_TON: _ClassVar[Material.EmissionsSolidsWeightUnit]
        EMISSIONS_SOLIDS_WEIGHT_UNIT_SLUG: _ClassVar[Material.EmissionsSolidsWeightUnit]
    EMISSIONS_SOLIDS_WEIGHT_UNIT_UNKNOWN: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_GRAM: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_HUNDREDWEIGHT: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_KILOGRAM: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_METRIC_TON: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_OUNCE: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_POUND: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_SHORT_TON: Material.EmissionsSolidsWeightUnit
    EMISSIONS_SOLIDS_WEIGHT_UNIT_SLUG: Material.EmissionsSolidsWeightUnit
    class EmissionsSolidsVolumeUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SOLIDS_VOLUME_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_CENTIMETER: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_FOOT: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_INCH: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_METER: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_MILIMETER: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_YARD: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_FLUID_OUNCE: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_IMPERIAL_GALLON: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_LITER: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_PINT: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_QUART: _ClassVar[Material.EmissionsSolidsVolumeUnit]
        EMISSIONS_SOLIDS_VOLUME_UNIT_US_LIQUID_GALLON: _ClassVar[Material.EmissionsSolidsVolumeUnit]
    EMISSIONS_SOLIDS_VOLUME_UNIT_UNKNOWN: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_CENTIMETER: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_FOOT: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_INCH: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_METER: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_MILIMETER: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_CUBIC_YARD: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_FLUID_OUNCE: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_IMPERIAL_GALLON: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_LITER: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_PINT: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_QUART: Material.EmissionsSolidsVolumeUnit
    EMISSIONS_SOLIDS_VOLUME_UNIT_US_LIQUID_GALLON: Material.EmissionsSolidsVolumeUnit
    class EmissionsSolidsAreaUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        EMISSIONS_SOLIDS_AREA_UNIT_UNKNOWN: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_CENTIMETER: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_FOOT: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_INCH: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_METER: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_MILIMETER: _ClassVar[Material.EmissionsSolidsAreaUnit]
        EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_YARD: _ClassVar[Material.EmissionsSolidsAreaUnit]
    EMISSIONS_SOLIDS_AREA_UNIT_UNKNOWN: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_CENTIMETER: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_FOOT: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_INCH: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_METER: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_MILIMETER: Material.EmissionsSolidsAreaUnit
    EMISSIONS_SOLIDS_AREA_UNIT_SQUARED_YARD: Material.EmissionsSolidsAreaUnit
    class UseOfMaterialModelOrientation(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        USE_OF_MATERIAL_MODEL_ORIENTATION_PARALLEL: _ClassVar[Material.UseOfMaterialModelOrientation]
        USE_OF_MATERIAL_MODEL_ORIENTATION_PERPENDICULAR: _ClassVar[Material.UseOfMaterialModelOrientation]
    USE_OF_MATERIAL_MODEL_ORIENTATION_PARALLEL: Material.UseOfMaterialModelOrientation
    USE_OF_MATERIAL_MODEL_ORIENTATION_PERPENDICULAR: Material.UseOfMaterialModelOrientation
    class UseOfMaterialModelAlignment(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        USE_OF_MATERIAL_MODEL_ALIGNMENT_EDGEWISE: _ClassVar[Material.UseOfMaterialModelAlignment]
        USE_OF_MATERIAL_MODEL_ALIGNMENT_FLATWISE: _ClassVar[Material.UseOfMaterialModelAlignment]
    USE_OF_MATERIAL_MODEL_ALIGNMENT_EDGEWISE: Material.UseOfMaterialModelAlignment
    USE_OF_MATERIAL_MODEL_ALIGNMENT_FLATWISE: Material.UseOfMaterialModelAlignment
    class TemperatureTable(_message.Message):
        __slots__ = ("rows",)
        ROWS_FIELD_NUMBER: _ClassVar[int]
        rows: _containers.RepeatedCompositeFieldContainer[Material.TemperatureRow]
        def __init__(self, rows: _Optional[_Iterable[_Union[Material.TemperatureRow, _Mapping]]] = ...) -> None: ...
    class TemperatureRow(_message.Message):
        __slots__ = ("no", "description", "poisson_ratio_editable_group", "poisson_ratio_editable_group_wall", "poisson_ratio_editable_group_platte", "stress_strain_diagram_symmetric", "stress_strain_diagram_symmetry_factor", "stress_strain_diagram_has_parameters_sorted", "stress_strain_diagram_type_start", "stress_strain_diagram_type_end", "dynamic_increase_factor_diagram_symmetric", "dynamic_increase_factor_diagram_sort", "temperature", "note", "maximum_thickness", "elasticity_modulus_global", "elasticity_modulus_x", "elasticity_modulus_y", "elasticity_modulus_z", "shear_modulus_global", "shear_modulus_yz", "shear_modulus_xz", "shear_modulus_xy", "poisson_ratio_global", "poisson_ratio_yz", "poisson_ratio_xz", "poisson_ratio_xy", "poisson_ratio_zy", "poisson_ratio_zx", "poisson_ratio_yx", "mass_density", "specific_weight", "thermal_expansion_coefficient_global", "thermal_expansion_coefficient_x", "thermal_expansion_coefficient_y", "thermal_expansion_coefficient_z", "division_multiplication_factor", "yield_strength_for_thickness", "ultimate_strength_for_thickness", "saturated_specific_weight", "masonry_compressive_strength", "masonry_stone_length", "masonry_stone_height", "masonry_stone_thickness", "masonry_brickwork_unit", "masonry_brickwork_configuration", "masonry_brickwork_grouping", "masonry_mortar_class", "masonry_head_joints_filled", "masonry_mortar_joint_parallel_to_wall_face", "yield_strength", "yield_strength_for_compression", "yield_strength_for_tension", "hardening_modulus_x", "hardening_modulus_y", "hardening_modulus_z", "ultimate_compressive_strength_x", "ultimate_compressive_strength_y", "ultimate_compressive_strength_z", "ultimate_tensile_strength_x", "ultimate_tensile_strength_y", "ultimate_tensile_strength_z", "ultimate_shear_strength_yz", "ultimate_shear_strength_xz", "ultimate_shear_strength_xy", "thickness_range_size", "timber_elasticity_modulus_x_wall", "timber_elasticity_modulus_y_wall", "timber_elasticity_modulus_x_plate", "timber_elasticity_modulus_y_plate", "timber_poisson_ratio_xy_wall", "timber_poisson_ratio_yx_wall", "timber_poisson_ratio_xy_plate", "timber_poisson_ratio_yx_plate", "timber_shear_modulus_yz", "timber_shear_modulus_xz", "timber_shear_modulus_xy", "soil_cohesive_strength", "soil_angle_of_internal_friction", "soil_angle_of_dilation", "masonry_partial_factor", "soil_reference_tangential_stiffness_for_primary_oedometer_loading", "soil_reference_stress_for_stiffness", "soil_exponent_for_stress_level_dependency_of_stiffness", "hoek_brown_soil_uniaxial_compressive_strength_of_intact_rock", "hoek_brown_soil_intact_rock_parameter", "hoek_brown_soil_disturbance_factor", "hoek_brown_soil_geological_strength_index", "yield_strength_equivalent", "yield_strength_x", "shear_modulus_x", "shear_modulus_y", "shear_modulus_z", "modified_hardening_soil_shear_hardening_definition_type", "modified_hardening_soil_shear_hardening_parameter", "modified_hardening_soil_stiffness_at_reference_stress", "modified_hardening_soil_poissons_ratio", "modified_hardening_soil_preconsolidation_definition_type", "modified_hardening_soil_pre_overburden_presure", "modified_hardening_soil_overconsolidation_ratio", "representative_volume_element_ratio_of_height_to_length", "internal_material_structure", "hoek_brown_soil_definition_type", "hoek_brown_soil_strength_parameter_m_b", "hoek_brown_soil_strength_parameter_s", "hoek_brown_soil_strength_parameter_a", "hoek_brown_soil_strength_parameter_m_g", "hoek_brown_soil_strength_parameter_s_g", "hoek_brown_soil_strength_parameter_a_g", "hoek_brown_soil_elastic_stiffness_matrix", "hoek_brown_soil_user_defined", "nonlinear_concrete_diagram_definition", "nonlinear_concrete_mean_secant_modulus_of_elasticity", "nonlinear_concrete_tangent_modulus_of_elasticity_in_origin", "nonlinear_concrete_tension_stiffening", "nonlinear_concrete_tension_stiffening_method", "nonlinear_concrete_reduction_factor_for_tensile_strength", "nonlinear_concrete_axial_tensile_strength", "nonlinear_concrete_strain_at_peak_compression_stress", "nonlinear_concrete_tensile_strength_at_first_crack", "nonlinear_concrete_exponent_of_stress_strain_parabola_until_first_crack", "nonlinear_concrete_calculational_crack_strain", "nonlinear_concrete_exponent_of_reduction_factor_parabola_after_first_crack", "nonlinear_concrete_exponent_of_function_after_first_crack", "nonlinear_concrete_tensile_strain", "nonlinear_concrete_consider_safety_factors", "nonlinear_concrete_design_situation", "nonlinear_concrete_partial_factors_compressive_strength", "nonlinear_concrete_partial_factors_compressive_strength_uneditable", "nonlinear_concrete_partial_factors_modulus_of_elasticity", "nonlinear_concrete_partial_factors_modulus_of_elasticity_uneditable", "nonlinear_concrete_long_term_actions_compressive_strength", "nonlinear_concrete_long_term_actions_tensile_strength", "nonlinear_concrete_design_secant_modulus_of_elasticity", "nonlinear_concrete_design_tangent_modulus_of_elasticity_in_origin", "nonlinear_concrete_compressive_strength_type", "nonlinear_concrete_compressive_strength", "nonlinear_concrete_compressive_strength_uneditable", "nonlinear_concrete_design_compressive_strength", "nonlinear_concrete_compression_diagram_type", "nonlinear_concrete_parabola_exponent", "nonlinear_concrete_ultimate_strain_for_maximum_compression_c1", "nonlinear_concrete_ultimate_strain_at_failure_cu1", "nonlinear_concrete_ultimate_strain_for_maximum_compression_c2", "nonlinear_concrete_ultimate_strain_at_failure_cu2", "nonlinear_concrete_relative_accuracy_of_generated_diagram", "nonlinear_concrete_axial_tensile_strength_type", "nonlinear_concrete_axial_tensile_strength_uneditable", "nonlinear_concrete_design_value_of_axial_tensile_strength", "nonlinear_concrete_tension_diagram_type", "nonlinear_concrete_coefficient_at_micro_crack_initiation", "nonlinear_concrete_coefficient_at_micro_crack_initiation_uneditable", "nonlinear_concrete_ultimate_tensile_strain_at_failure", "nonlinear_concrete_ultimate_tensile_strain_at_failure_uneditable", "nonlinear_concrete_partial_factors_tensile_strength_uneditable", "nonlinear_concrete_partial_factors_tensile_strength", "soil_non_regularized_yield_surface", "strain_hardening_modulus", "hardening_factor", "limit_stresses_for_tension_x", "limit_stresses_for_tension_y", "reference_element_size", "strain_at_peak_compression_stress", "fracture_energy_ft_x", "fracture_energy_ft_y", "fracture_energy_fc_x", "fracture_energy_fc_y", "masonry_alpha", "masonry_beta", "masonry_gamma", "masonry_compressive_strength_horizontal", "masonry_compressive_strength_according_to_approval", "yielding_acc_to", "parameter_x", "parameter_xz", "parameter_xy", "parameter_x_xz", "parameter_EN", "parameter_ANSI_AISC")
        class PoissonRatioEditableGroup(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            POISSON_RATIO_EDITABLE_GROUP_MAJOR_2D: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroup]
            POISSON_RATIO_EDITABLE_GROUP_MAJOR_3D: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroup]
            POISSON_RATIO_EDITABLE_GROUP_MINOR_2D: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroup]
            POISSON_RATIO_EDITABLE_GROUP_MINOR_3D: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroup]
        POISSON_RATIO_EDITABLE_GROUP_MAJOR_2D: Material.TemperatureRow.PoissonRatioEditableGroup
        POISSON_RATIO_EDITABLE_GROUP_MAJOR_3D: Material.TemperatureRow.PoissonRatioEditableGroup
        POISSON_RATIO_EDITABLE_GROUP_MINOR_2D: Material.TemperatureRow.PoissonRatioEditableGroup
        POISSON_RATIO_EDITABLE_GROUP_MINOR_3D: Material.TemperatureRow.PoissonRatioEditableGroup
        class PoissonRatioEditableGroupWall(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            POISSON_RATIO_EDITABLE_GROUP_WALL_XY: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroupWall]
            POISSON_RATIO_EDITABLE_GROUP_WALL_YX: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroupWall]
        POISSON_RATIO_EDITABLE_GROUP_WALL_XY: Material.TemperatureRow.PoissonRatioEditableGroupWall
        POISSON_RATIO_EDITABLE_GROUP_WALL_YX: Material.TemperatureRow.PoissonRatioEditableGroupWall
        class PoissonRatioEditableGroupPlatte(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            POISSON_RATIO_EDITABLE_GROUP_PLATTE_XY: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroupPlatte]
            POISSON_RATIO_EDITABLE_GROUP_PLATTE_YX: _ClassVar[Material.TemperatureRow.PoissonRatioEditableGroupPlatte]
        POISSON_RATIO_EDITABLE_GROUP_PLATTE_XY: Material.TemperatureRow.PoissonRatioEditableGroupPlatte
        POISSON_RATIO_EDITABLE_GROUP_PLATTE_YX: Material.TemperatureRow.PoissonRatioEditableGroupPlatte
        class StressStrainDiagramTypeStart(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STRESS_STRAIN_DIAGRAM_TYPE_START_FAILURE: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeStart]
            STRESS_STRAIN_DIAGRAM_TYPE_START_CONTINUOUS: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeStart]
            STRESS_STRAIN_DIAGRAM_TYPE_START_YIELDING: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeStart]
        STRESS_STRAIN_DIAGRAM_TYPE_START_FAILURE: Material.TemperatureRow.StressStrainDiagramTypeStart
        STRESS_STRAIN_DIAGRAM_TYPE_START_CONTINUOUS: Material.TemperatureRow.StressStrainDiagramTypeStart
        STRESS_STRAIN_DIAGRAM_TYPE_START_YIELDING: Material.TemperatureRow.StressStrainDiagramTypeStart
        class StressStrainDiagramTypeEnd(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            STRESS_STRAIN_DIAGRAM_TYPE_END_FAILURE: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeEnd]
            STRESS_STRAIN_DIAGRAM_TYPE_END_CONTINUOUS: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeEnd]
            STRESS_STRAIN_DIAGRAM_TYPE_END_YIELDING: _ClassVar[Material.TemperatureRow.StressStrainDiagramTypeEnd]
        STRESS_STRAIN_DIAGRAM_TYPE_END_FAILURE: Material.TemperatureRow.StressStrainDiagramTypeEnd
        STRESS_STRAIN_DIAGRAM_TYPE_END_CONTINUOUS: Material.TemperatureRow.StressStrainDiagramTypeEnd
        STRESS_STRAIN_DIAGRAM_TYPE_END_YIELDING: Material.TemperatureRow.StressStrainDiagramTypeEnd
        class MasonryBrickworkUnit(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MASONRY_BRICKWORK_UNIT_CLAY: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
            MASONRY_BRICKWORK_UNIT_AGGREGATE_CONCRETE: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
            MASONRY_BRICKWORK_UNIT_AUTOCLAVED_AERATED_CONCRETE: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
            MASONRY_BRICKWORK_UNIT_CALCIUM_SILICATE: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
            MASONRY_BRICKWORK_UNIT_DIMENSIONED_NATURAL_STONE: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
            MASONRY_BRICKWORK_UNIT_MANUFACTURED_STONE: _ClassVar[Material.TemperatureRow.MasonryBrickworkUnit]
        MASONRY_BRICKWORK_UNIT_CLAY: Material.TemperatureRow.MasonryBrickworkUnit
        MASONRY_BRICKWORK_UNIT_AGGREGATE_CONCRETE: Material.TemperatureRow.MasonryBrickworkUnit
        MASONRY_BRICKWORK_UNIT_AUTOCLAVED_AERATED_CONCRETE: Material.TemperatureRow.MasonryBrickworkUnit
        MASONRY_BRICKWORK_UNIT_CALCIUM_SILICATE: Material.TemperatureRow.MasonryBrickworkUnit
        MASONRY_BRICKWORK_UNIT_DIMENSIONED_NATURAL_STONE: Material.TemperatureRow.MasonryBrickworkUnit
        MASONRY_BRICKWORK_UNIT_MANUFACTURED_STONE: Material.TemperatureRow.MasonryBrickworkUnit
        class MasonryBrickworkConfiguration(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MASONRY_BRICKWORK_CONFIGURATION_HOLLOW_BLOCK: _ClassVar[Material.TemperatureRow.MasonryBrickworkConfiguration]
            MASONRY_BRICKWORK_CONFIGURATION_AUTOCLAVED_AERATED_CONCRETE: _ClassVar[Material.TemperatureRow.MasonryBrickworkConfiguration]
            MASONRY_BRICKWORK_CONFIGURATION_HOLLOW_CLAY_BLOCK_WITH_GRIPHOLES: _ClassVar[Material.TemperatureRow.MasonryBrickworkConfiguration]
            MASONRY_BRICKWORK_CONFIGURATION_SOLID_BLOCK: _ClassVar[Material.TemperatureRow.MasonryBrickworkConfiguration]
            MASONRY_BRICKWORK_CONFIGURATION_UNIT_FOR_CONCRETE_OR_MORTAR_INFILL: _ClassVar[Material.TemperatureRow.MasonryBrickworkConfiguration]
        MASONRY_BRICKWORK_CONFIGURATION_HOLLOW_BLOCK: Material.TemperatureRow.MasonryBrickworkConfiguration
        MASONRY_BRICKWORK_CONFIGURATION_AUTOCLAVED_AERATED_CONCRETE: Material.TemperatureRow.MasonryBrickworkConfiguration
        MASONRY_BRICKWORK_CONFIGURATION_HOLLOW_CLAY_BLOCK_WITH_GRIPHOLES: Material.TemperatureRow.MasonryBrickworkConfiguration
        MASONRY_BRICKWORK_CONFIGURATION_SOLID_BLOCK: Material.TemperatureRow.MasonryBrickworkConfiguration
        MASONRY_BRICKWORK_CONFIGURATION_UNIT_FOR_CONCRETE_OR_MORTAR_INFILL: Material.TemperatureRow.MasonryBrickworkConfiguration
        class MasonryBrickworkGrouping(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MASONRY_BRICKWORK_GROUPING_GROUP_1: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
            MASONRY_BRICKWORK_GROUPING_GROUP_1S: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
            MASONRY_BRICKWORK_GROUPING_GROUP_2: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
            MASONRY_BRICKWORK_GROUPING_GROUP_3: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
            MASONRY_BRICKWORK_GROUPING_GROUP_4: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
            MASONRY_BRICKWORK_GROUPING_GROUP_NONE: _ClassVar[Material.TemperatureRow.MasonryBrickworkGrouping]
        MASONRY_BRICKWORK_GROUPING_GROUP_1: Material.TemperatureRow.MasonryBrickworkGrouping
        MASONRY_BRICKWORK_GROUPING_GROUP_1S: Material.TemperatureRow.MasonryBrickworkGrouping
        MASONRY_BRICKWORK_GROUPING_GROUP_2: Material.TemperatureRow.MasonryBrickworkGrouping
        MASONRY_BRICKWORK_GROUPING_GROUP_3: Material.TemperatureRow.MasonryBrickworkGrouping
        MASONRY_BRICKWORK_GROUPING_GROUP_4: Material.TemperatureRow.MasonryBrickworkGrouping
        MASONRY_BRICKWORK_GROUPING_GROUP_NONE: Material.TemperatureRow.MasonryBrickworkGrouping
        class MasonryMortarClass(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M2_5: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M10: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M20: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M5: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_LIGHTWEIGHT_MORTAR_600: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_LIGHTWEIGHT_MORTAR_800: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_MASONRY_GLUE: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
            MASONRY_MORTAR_CLASS_THIN_LAYER_MORTAR: _ClassVar[Material.TemperatureRow.MasonryMortarClass]
        MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M2_5: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M10: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M20: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_GENERAL_PURPOSE_MORTAR_M5: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_LIGHTWEIGHT_MORTAR_600: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_LIGHTWEIGHT_MORTAR_800: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_MASONRY_GLUE: Material.TemperatureRow.MasonryMortarClass
        MASONRY_MORTAR_CLASS_THIN_LAYER_MORTAR: Material.TemperatureRow.MasonryMortarClass
        class ModifiedHardeningSoilShearHardeningDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MODIFIED_HARDENING_SOIL_SHEAR_HARDENING_DEFINITION_TYPE_SHEAR_HARDENING_PARAMETER: _ClassVar[Material.TemperatureRow.ModifiedHardeningSoilShearHardeningDefinitionType]
        MODIFIED_HARDENING_SOIL_SHEAR_HARDENING_DEFINITION_TYPE_SHEAR_HARDENING_PARAMETER: Material.TemperatureRow.ModifiedHardeningSoilShearHardeningDefinitionType
        class ModifiedHardeningSoilPreconsolidationDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            MODIFIED_HARDENING_SOIL_PRECONSOLIDATION_DEFINITION_TYPE_PRE_OVERBURDEN_PRESURE: _ClassVar[Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType]
            MODIFIED_HARDENING_SOIL_PRECONSOLIDATION_DEFINITION_TYPE_OVERCONSOLIDATION_RATIO: _ClassVar[Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType]
        MODIFIED_HARDENING_SOIL_PRECONSOLIDATION_DEFINITION_TYPE_PRE_OVERBURDEN_PRESURE: Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType
        MODIFIED_HARDENING_SOIL_PRECONSOLIDATION_DEFINITION_TYPE_OVERCONSOLIDATION_RATIO: Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType
        class InternalMaterialStructure(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            INTERNAL_MATERIAL_STRUCTURE_PLAIN_WEAVE: _ClassVar[Material.TemperatureRow.InternalMaterialStructure]
            INTERNAL_MATERIAL_STRUCTURE_BASKET_WEAVE: _ClassVar[Material.TemperatureRow.InternalMaterialStructure]
        INTERNAL_MATERIAL_STRUCTURE_PLAIN_WEAVE: Material.TemperatureRow.InternalMaterialStructure
        INTERNAL_MATERIAL_STRUCTURE_BASKET_WEAVE: Material.TemperatureRow.InternalMaterialStructure
        class HoekBrownSoilDefinitionType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            HOEK_BROWN_SOIL_DEFINITION_TYPE_E_HOEK_BROWN_SOIL_DEFINITION_TYPE_ROCK_MASS_PARAMETERS: _ClassVar[Material.TemperatureRow.HoekBrownSoilDefinitionType]
            HOEK_BROWN_SOIL_DEFINITION_TYPE_E_HOEK_BROWN_SOIL_DEFINITION_TYPE_GSI_CLASSIFICATION: _ClassVar[Material.TemperatureRow.HoekBrownSoilDefinitionType]
        HOEK_BROWN_SOIL_DEFINITION_TYPE_E_HOEK_BROWN_SOIL_DEFINITION_TYPE_ROCK_MASS_PARAMETERS: Material.TemperatureRow.HoekBrownSoilDefinitionType
        HOEK_BROWN_SOIL_DEFINITION_TYPE_E_HOEK_BROWN_SOIL_DEFINITION_TYPE_GSI_CLASSIFICATION: Material.TemperatureRow.HoekBrownSoilDefinitionType
        class NonlinearConcreteDiagramDefinition(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_PARAMETRIC: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_24_1: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_3_14: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_9_8: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_STRESS_STRAIN_DIAGRAM: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_ULS_ACC: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
            NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_ULS_P_T: _ClassVar[Material.TemperatureRow.NonlinearConcreteDiagramDefinition]
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_PARAMETRIC: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_24_1: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_3_14: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_SLS_9_8: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_STRESS_STRAIN_DIAGRAM: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_ULS_ACC: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_ULS_P_T: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        class NonlinearConcreteTensionStiffeningMethod(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_QUAST: _ClassVar[Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod]
            NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_HSU_AND_MO: _ClassVar[Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod]
            NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_MODIFIED_QUAST: _ClassVar[Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod]
        NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_QUAST: Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod
        NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_HSU_AND_MO: Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod
        NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_MODIFIED_QUAST: Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod
        class NonlinearConcreteDesignSituation(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_DESIGN_SITUATION_NONE: _ClassVar[Material.TemperatureRow.NonlinearConcreteDesignSituation]
            NONLINEAR_CONCRETE_DESIGN_SITUATION_ULS_ACCIDENTAL: _ClassVar[Material.TemperatureRow.NonlinearConcreteDesignSituation]
            NONLINEAR_CONCRETE_DESIGN_SITUATION_ULS_PERMANENT_TRANSIENT: _ClassVar[Material.TemperatureRow.NonlinearConcreteDesignSituation]
        NONLINEAR_CONCRETE_DESIGN_SITUATION_NONE: Material.TemperatureRow.NonlinearConcreteDesignSituation
        NONLINEAR_CONCRETE_DESIGN_SITUATION_ULS_ACCIDENTAL: Material.TemperatureRow.NonlinearConcreteDesignSituation
        NONLINEAR_CONCRETE_DESIGN_SITUATION_ULS_PERMANENT_TRANSIENT: Material.TemperatureRow.NonlinearConcreteDesignSituation
        class NonlinearConcreteCompressiveStrengthType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_NONE: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_085_F_C_ACI_CSA: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_09_F_C_ACI_CSA: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_ALPHA1_F_C_ACI_CSA: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_CHARACTERISTIC_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_F_C_ACI_CSA: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
            NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_MEAN_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType]
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_NONE: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_085_F_C_ACI_CSA: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_09_F_C_ACI_CSA: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_ALPHA1_F_C_ACI_CSA: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_CHARACTERISTIC_STRENGTH: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_F_C_ACI_CSA: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_MEAN_STRENGTH: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        class NonlinearConcreteCompressionDiagramType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_COMPRESSION_DIAGRAM_TYPE_PARABOLA: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressionDiagramType]
            NONLINEAR_CONCRETE_COMPRESSION_DIAGRAM_TYPE_PARABOLA_RECTANGLE: _ClassVar[Material.TemperatureRow.NonlinearConcreteCompressionDiagramType]
        NONLINEAR_CONCRETE_COMPRESSION_DIAGRAM_TYPE_PARABOLA: Material.TemperatureRow.NonlinearConcreteCompressionDiagramType
        NONLINEAR_CONCRETE_COMPRESSION_DIAGRAM_TYPE_PARABOLA_RECTANGLE: Material.TemperatureRow.NonlinearConcreteCompressionDiagramType
        class NonlinearConcreteAxialTensileStrengthType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_NONE: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_5_PERC_FRACTILE_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_95_PERC_FRACTILE_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_MEAN_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_REDUCED_STRENGTH_05_FR: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_REDUCED_STRENGTH_2_3_FR: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_STRENGTH_FR: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
            NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_WITHOUT_TENSILE_STRENGTH: _ClassVar[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType]
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_NONE: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_5_PERC_FRACTILE_STRENGTH: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_95_PERC_FRACTILE_STRENGTH: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_MEAN_STRENGTH: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_REDUCED_STRENGTH_05_FR: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_REDUCED_STRENGTH_2_3_FR: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_STRENGTH_FR: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_WITHOUT_TENSILE_STRENGTH: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        class NonlinearConcreteTensionDiagramType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            NONLINEAR_CONCRETE_TENSION_DIAGRAM_TYPE_LINEAR: _ClassVar[Material.TemperatureRow.NonlinearConcreteTensionDiagramType]
            NONLINEAR_CONCRETE_TENSION_DIAGRAM_TYPE_BILINEAR: _ClassVar[Material.TemperatureRow.NonlinearConcreteTensionDiagramType]
        NONLINEAR_CONCRETE_TENSION_DIAGRAM_TYPE_LINEAR: Material.TemperatureRow.NonlinearConcreteTensionDiagramType
        NONLINEAR_CONCRETE_TENSION_DIAGRAM_TYPE_BILINEAR: Material.TemperatureRow.NonlinearConcreteTensionDiagramType
        class YieldingAccTo(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
            __slots__ = ()
            YIELDING_ACC_TO_VON_MISES: _ClassVar[Material.TemperatureRow.YieldingAccTo]
            YIELDING_ACC_TO_ANSI_AISC_360: _ClassVar[Material.TemperatureRow.YieldingAccTo]
            YIELDING_ACC_TO_EN_1993_1_8: _ClassVar[Material.TemperatureRow.YieldingAccTo]
        YIELDING_ACC_TO_VON_MISES: Material.TemperatureRow.YieldingAccTo
        YIELDING_ACC_TO_ANSI_AISC_360: Material.TemperatureRow.YieldingAccTo
        YIELDING_ACC_TO_EN_1993_1_8: Material.TemperatureRow.YieldingAccTo
        NO_FIELD_NUMBER: _ClassVar[int]
        DESCRIPTION_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_EDITABLE_GROUP_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_EDITABLE_GROUP_WALL_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_EDITABLE_GROUP_PLATTE_FIELD_NUMBER: _ClassVar[int]
        STRESS_STRAIN_DIAGRAM_SYMMETRIC_FIELD_NUMBER: _ClassVar[int]
        STRESS_STRAIN_DIAGRAM_SYMMETRY_FACTOR_FIELD_NUMBER: _ClassVar[int]
        STRESS_STRAIN_DIAGRAM_HAS_PARAMETERS_SORTED_FIELD_NUMBER: _ClassVar[int]
        STRESS_STRAIN_DIAGRAM_TYPE_START_FIELD_NUMBER: _ClassVar[int]
        STRESS_STRAIN_DIAGRAM_TYPE_END_FIELD_NUMBER: _ClassVar[int]
        DYNAMIC_INCREASE_FACTOR_DIAGRAM_SYMMETRIC_FIELD_NUMBER: _ClassVar[int]
        DYNAMIC_INCREASE_FACTOR_DIAGRAM_SORT_FIELD_NUMBER: _ClassVar[int]
        TEMPERATURE_FIELD_NUMBER: _ClassVar[int]
        NOTE_FIELD_NUMBER: _ClassVar[int]
        MAXIMUM_THICKNESS_FIELD_NUMBER: _ClassVar[int]
        ELASTICITY_MODULUS_GLOBAL_FIELD_NUMBER: _ClassVar[int]
        ELASTICITY_MODULUS_X_FIELD_NUMBER: _ClassVar[int]
        ELASTICITY_MODULUS_Y_FIELD_NUMBER: _ClassVar[int]
        ELASTICITY_MODULUS_Z_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_GLOBAL_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_YZ_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_XZ_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_XY_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_GLOBAL_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_YZ_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_XZ_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_XY_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_ZY_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_ZX_FIELD_NUMBER: _ClassVar[int]
        POISSON_RATIO_YX_FIELD_NUMBER: _ClassVar[int]
        MASS_DENSITY_FIELD_NUMBER: _ClassVar[int]
        SPECIFIC_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        THERMAL_EXPANSION_COEFFICIENT_GLOBAL_FIELD_NUMBER: _ClassVar[int]
        THERMAL_EXPANSION_COEFFICIENT_X_FIELD_NUMBER: _ClassVar[int]
        THERMAL_EXPANSION_COEFFICIENT_Y_FIELD_NUMBER: _ClassVar[int]
        THERMAL_EXPANSION_COEFFICIENT_Z_FIELD_NUMBER: _ClassVar[int]
        DIVISION_MULTIPLICATION_FACTOR_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_FOR_THICKNESS_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_STRENGTH_FOR_THICKNESS_FIELD_NUMBER: _ClassVar[int]
        SATURATED_SPECIFIC_WEIGHT_FIELD_NUMBER: _ClassVar[int]
        MASONRY_COMPRESSIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        MASONRY_STONE_LENGTH_FIELD_NUMBER: _ClassVar[int]
        MASONRY_STONE_HEIGHT_FIELD_NUMBER: _ClassVar[int]
        MASONRY_STONE_THICKNESS_FIELD_NUMBER: _ClassVar[int]
        MASONRY_BRICKWORK_UNIT_FIELD_NUMBER: _ClassVar[int]
        MASONRY_BRICKWORK_CONFIGURATION_FIELD_NUMBER: _ClassVar[int]
        MASONRY_BRICKWORK_GROUPING_FIELD_NUMBER: _ClassVar[int]
        MASONRY_MORTAR_CLASS_FIELD_NUMBER: _ClassVar[int]
        MASONRY_HEAD_JOINTS_FILLED_FIELD_NUMBER: _ClassVar[int]
        MASONRY_MORTAR_JOINT_PARALLEL_TO_WALL_FACE_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_FOR_COMPRESSION_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_FOR_TENSION_FIELD_NUMBER: _ClassVar[int]
        HARDENING_MODULUS_X_FIELD_NUMBER: _ClassVar[int]
        HARDENING_MODULUS_Y_FIELD_NUMBER: _ClassVar[int]
        HARDENING_MODULUS_Z_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_COMPRESSIVE_STRENGTH_X_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_COMPRESSIVE_STRENGTH_Y_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_COMPRESSIVE_STRENGTH_Z_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_TENSILE_STRENGTH_X_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_TENSILE_STRENGTH_Y_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_TENSILE_STRENGTH_Z_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_SHEAR_STRENGTH_YZ_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_SHEAR_STRENGTH_XZ_FIELD_NUMBER: _ClassVar[int]
        ULTIMATE_SHEAR_STRENGTH_XY_FIELD_NUMBER: _ClassVar[int]
        THICKNESS_RANGE_SIZE_FIELD_NUMBER: _ClassVar[int]
        TIMBER_ELASTICITY_MODULUS_X_WALL_FIELD_NUMBER: _ClassVar[int]
        TIMBER_ELASTICITY_MODULUS_Y_WALL_FIELD_NUMBER: _ClassVar[int]
        TIMBER_ELASTICITY_MODULUS_X_PLATE_FIELD_NUMBER: _ClassVar[int]
        TIMBER_ELASTICITY_MODULUS_Y_PLATE_FIELD_NUMBER: _ClassVar[int]
        TIMBER_POISSON_RATIO_XY_WALL_FIELD_NUMBER: _ClassVar[int]
        TIMBER_POISSON_RATIO_YX_WALL_FIELD_NUMBER: _ClassVar[int]
        TIMBER_POISSON_RATIO_XY_PLATE_FIELD_NUMBER: _ClassVar[int]
        TIMBER_POISSON_RATIO_YX_PLATE_FIELD_NUMBER: _ClassVar[int]
        TIMBER_SHEAR_MODULUS_YZ_FIELD_NUMBER: _ClassVar[int]
        TIMBER_SHEAR_MODULUS_XZ_FIELD_NUMBER: _ClassVar[int]
        TIMBER_SHEAR_MODULUS_XY_FIELD_NUMBER: _ClassVar[int]
        SOIL_COHESIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        SOIL_ANGLE_OF_INTERNAL_FRICTION_FIELD_NUMBER: _ClassVar[int]
        SOIL_ANGLE_OF_DILATION_FIELD_NUMBER: _ClassVar[int]
        MASONRY_PARTIAL_FACTOR_FIELD_NUMBER: _ClassVar[int]
        SOIL_REFERENCE_TANGENTIAL_STIFFNESS_FOR_PRIMARY_OEDOMETER_LOADING_FIELD_NUMBER: _ClassVar[int]
        SOIL_REFERENCE_STRESS_FOR_STIFFNESS_FIELD_NUMBER: _ClassVar[int]
        SOIL_EXPONENT_FOR_STRESS_LEVEL_DEPENDENCY_OF_STIFFNESS_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_UNIAXIAL_COMPRESSIVE_STRENGTH_OF_INTACT_ROCK_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_INTACT_ROCK_PARAMETER_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_DISTURBANCE_FACTOR_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_GEOLOGICAL_STRENGTH_INDEX_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_EQUIVALENT_FIELD_NUMBER: _ClassVar[int]
        YIELD_STRENGTH_X_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_X_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_Y_FIELD_NUMBER: _ClassVar[int]
        SHEAR_MODULUS_Z_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_SHEAR_HARDENING_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_SHEAR_HARDENING_PARAMETER_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_STIFFNESS_AT_REFERENCE_STRESS_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_POISSONS_RATIO_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_PRECONSOLIDATION_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_PRE_OVERBURDEN_PRESURE_FIELD_NUMBER: _ClassVar[int]
        MODIFIED_HARDENING_SOIL_OVERCONSOLIDATION_RATIO_FIELD_NUMBER: _ClassVar[int]
        REPRESENTATIVE_VOLUME_ELEMENT_RATIO_OF_HEIGHT_TO_LENGTH_FIELD_NUMBER: _ClassVar[int]
        INTERNAL_MATERIAL_STRUCTURE_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_M_B_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_S_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_A_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_M_G_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_S_G_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_STRENGTH_PARAMETER_A_G_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_ELASTIC_STIFFNESS_MATRIX_FIELD_NUMBER: _ClassVar[int]
        HOEK_BROWN_SOIL_USER_DEFINED_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DIAGRAM_DEFINITION_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_MEAN_SECANT_MODULUS_OF_ELASTICITY_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TANGENT_MODULUS_OF_ELASTICITY_IN_ORIGIN_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TENSION_STIFFENING_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TENSION_STIFFENING_METHOD_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_REDUCTION_FACTOR_FOR_TENSILE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_STRAIN_AT_PEAK_COMPRESSION_STRESS_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TENSILE_STRENGTH_AT_FIRST_CRACK_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_EXPONENT_OF_STRESS_STRAIN_PARABOLA_UNTIL_FIRST_CRACK_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_CALCULATIONAL_CRACK_STRAIN_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_EXPONENT_OF_REDUCTION_FACTOR_PARABOLA_AFTER_FIRST_CRACK_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_EXPONENT_OF_FUNCTION_AFTER_FIRST_CRACK_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TENSILE_STRAIN_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_CONSIDER_SAFETY_FACTORS_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DESIGN_SITUATION_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_COMPRESSIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_COMPRESSIVE_STRENGTH_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_MODULUS_OF_ELASTICITY_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_MODULUS_OF_ELASTICITY_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_LONG_TERM_ACTIONS_COMPRESSIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_LONG_TERM_ACTIONS_TENSILE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DESIGN_SECANT_MODULUS_OF_ELASTICITY_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DESIGN_TANGENT_MODULUS_OF_ELASTICITY_IN_ORIGIN_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_TYPE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COMPRESSIVE_STRENGTH_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DESIGN_COMPRESSIVE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COMPRESSION_DIAGRAM_TYPE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARABOLA_EXPONENT_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_STRAIN_FOR_MAXIMUM_COMPRESSION_C1_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_STRAIN_AT_FAILURE_CU1_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_STRAIN_FOR_MAXIMUM_COMPRESSION_C2_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_STRAIN_AT_FAILURE_CU2_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_RELATIVE_ACCURACY_OF_GENERATED_DIAGRAM_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_TYPE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_AXIAL_TENSILE_STRENGTH_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_DESIGN_VALUE_OF_AXIAL_TENSILE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_TENSION_DIAGRAM_TYPE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COEFFICIENT_AT_MICRO_CRACK_INITIATION_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_COEFFICIENT_AT_MICRO_CRACK_INITIATION_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_TENSILE_STRAIN_AT_FAILURE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_ULTIMATE_TENSILE_STRAIN_AT_FAILURE_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_TENSILE_STRENGTH_UNEDITABLE_FIELD_NUMBER: _ClassVar[int]
        NONLINEAR_CONCRETE_PARTIAL_FACTORS_TENSILE_STRENGTH_FIELD_NUMBER: _ClassVar[int]
        SOIL_NON_REGULARIZED_YIELD_SURFACE_FIELD_NUMBER: _ClassVar[int]
        STRAIN_HARDENING_MODULUS_FIELD_NUMBER: _ClassVar[int]
        HARDENING_FACTOR_FIELD_NUMBER: _ClassVar[int]
        LIMIT_STRESSES_FOR_TENSION_X_FIELD_NUMBER: _ClassVar[int]
        LIMIT_STRESSES_FOR_TENSION_Y_FIELD_NUMBER: _ClassVar[int]
        REFERENCE_ELEMENT_SIZE_FIELD_NUMBER: _ClassVar[int]
        STRAIN_AT_PEAK_COMPRESSION_STRESS_FIELD_NUMBER: _ClassVar[int]
        FRACTURE_ENERGY_FT_X_FIELD_NUMBER: _ClassVar[int]
        FRACTURE_ENERGY_FT_Y_FIELD_NUMBER: _ClassVar[int]
        FRACTURE_ENERGY_FC_X_FIELD_NUMBER: _ClassVar[int]
        FRACTURE_ENERGY_FC_Y_FIELD_NUMBER: _ClassVar[int]
        MASONRY_ALPHA_FIELD_NUMBER: _ClassVar[int]
        MASONRY_BETA_FIELD_NUMBER: _ClassVar[int]
        MASONRY_GAMMA_FIELD_NUMBER: _ClassVar[int]
        MASONRY_COMPRESSIVE_STRENGTH_HORIZONTAL_FIELD_NUMBER: _ClassVar[int]
        MASONRY_COMPRESSIVE_STRENGTH_ACCORDING_TO_APPROVAL_FIELD_NUMBER: _ClassVar[int]
        YIELDING_ACC_TO_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_X_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_XZ_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_XY_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_X_XZ_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_EN_FIELD_NUMBER: _ClassVar[int]
        PARAMETER_ANSI_AISC_FIELD_NUMBER: _ClassVar[int]
        no: int
        description: str
        poisson_ratio_editable_group: Material.TemperatureRow.PoissonRatioEditableGroup
        poisson_ratio_editable_group_wall: Material.TemperatureRow.PoissonRatioEditableGroupWall
        poisson_ratio_editable_group_platte: Material.TemperatureRow.PoissonRatioEditableGroupPlatte
        stress_strain_diagram_symmetric: bool
        stress_strain_diagram_symmetry_factor: float
        stress_strain_diagram_has_parameters_sorted: bool
        stress_strain_diagram_type_start: Material.TemperatureRow.StressStrainDiagramTypeStart
        stress_strain_diagram_type_end: Material.TemperatureRow.StressStrainDiagramTypeEnd
        dynamic_increase_factor_diagram_symmetric: bool
        dynamic_increase_factor_diagram_sort: bool
        temperature: float
        note: str
        maximum_thickness: float
        elasticity_modulus_global: float
        elasticity_modulus_x: float
        elasticity_modulus_y: float
        elasticity_modulus_z: float
        shear_modulus_global: float
        shear_modulus_yz: float
        shear_modulus_xz: float
        shear_modulus_xy: float
        poisson_ratio_global: float
        poisson_ratio_yz: float
        poisson_ratio_xz: float
        poisson_ratio_xy: float
        poisson_ratio_zy: float
        poisson_ratio_zx: float
        poisson_ratio_yx: float
        mass_density: float
        specific_weight: float
        thermal_expansion_coefficient_global: float
        thermal_expansion_coefficient_x: float
        thermal_expansion_coefficient_y: float
        thermal_expansion_coefficient_z: float
        division_multiplication_factor: float
        yield_strength_for_thickness: float
        ultimate_strength_for_thickness: float
        saturated_specific_weight: float
        masonry_compressive_strength: float
        masonry_stone_length: float
        masonry_stone_height: float
        masonry_stone_thickness: float
        masonry_brickwork_unit: Material.TemperatureRow.MasonryBrickworkUnit
        masonry_brickwork_configuration: Material.TemperatureRow.MasonryBrickworkConfiguration
        masonry_brickwork_grouping: Material.TemperatureRow.MasonryBrickworkGrouping
        masonry_mortar_class: Material.TemperatureRow.MasonryMortarClass
        masonry_head_joints_filled: bool
        masonry_mortar_joint_parallel_to_wall_face: bool
        yield_strength: float
        yield_strength_for_compression: float
        yield_strength_for_tension: float
        hardening_modulus_x: float
        hardening_modulus_y: float
        hardening_modulus_z: float
        ultimate_compressive_strength_x: float
        ultimate_compressive_strength_y: float
        ultimate_compressive_strength_z: float
        ultimate_tensile_strength_x: float
        ultimate_tensile_strength_y: float
        ultimate_tensile_strength_z: float
        ultimate_shear_strength_yz: float
        ultimate_shear_strength_xz: float
        ultimate_shear_strength_xy: float
        thickness_range_size: int
        timber_elasticity_modulus_x_wall: float
        timber_elasticity_modulus_y_wall: float
        timber_elasticity_modulus_x_plate: float
        timber_elasticity_modulus_y_plate: float
        timber_poisson_ratio_xy_wall: float
        timber_poisson_ratio_yx_wall: float
        timber_poisson_ratio_xy_plate: float
        timber_poisson_ratio_yx_plate: float
        timber_shear_modulus_yz: float
        timber_shear_modulus_xz: float
        timber_shear_modulus_xy: float
        soil_cohesive_strength: float
        soil_angle_of_internal_friction: float
        soil_angle_of_dilation: float
        masonry_partial_factor: float
        soil_reference_tangential_stiffness_for_primary_oedometer_loading: float
        soil_reference_stress_for_stiffness: float
        soil_exponent_for_stress_level_dependency_of_stiffness: float
        hoek_brown_soil_uniaxial_compressive_strength_of_intact_rock: float
        hoek_brown_soil_intact_rock_parameter: float
        hoek_brown_soil_disturbance_factor: float
        hoek_brown_soil_geological_strength_index: float
        yield_strength_equivalent: float
        yield_strength_x: float
        shear_modulus_x: float
        shear_modulus_y: float
        shear_modulus_z: float
        modified_hardening_soil_shear_hardening_definition_type: Material.TemperatureRow.ModifiedHardeningSoilShearHardeningDefinitionType
        modified_hardening_soil_shear_hardening_parameter: float
        modified_hardening_soil_stiffness_at_reference_stress: float
        modified_hardening_soil_poissons_ratio: float
        modified_hardening_soil_preconsolidation_definition_type: Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType
        modified_hardening_soil_pre_overburden_presure: float
        modified_hardening_soil_overconsolidation_ratio: float
        representative_volume_element_ratio_of_height_to_length: float
        internal_material_structure: Material.TemperatureRow.InternalMaterialStructure
        hoek_brown_soil_definition_type: Material.TemperatureRow.HoekBrownSoilDefinitionType
        hoek_brown_soil_strength_parameter_m_b: float
        hoek_brown_soil_strength_parameter_s: float
        hoek_brown_soil_strength_parameter_a: float
        hoek_brown_soil_strength_parameter_m_g: float
        hoek_brown_soil_strength_parameter_s_g: float
        hoek_brown_soil_strength_parameter_a_g: float
        hoek_brown_soil_elastic_stiffness_matrix: bool
        hoek_brown_soil_user_defined: bool
        nonlinear_concrete_diagram_definition: Material.TemperatureRow.NonlinearConcreteDiagramDefinition
        nonlinear_concrete_mean_secant_modulus_of_elasticity: float
        nonlinear_concrete_tangent_modulus_of_elasticity_in_origin: float
        nonlinear_concrete_tension_stiffening: bool
        nonlinear_concrete_tension_stiffening_method: Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod
        nonlinear_concrete_reduction_factor_for_tensile_strength: float
        nonlinear_concrete_axial_tensile_strength: float
        nonlinear_concrete_strain_at_peak_compression_stress: float
        nonlinear_concrete_tensile_strength_at_first_crack: float
        nonlinear_concrete_exponent_of_stress_strain_parabola_until_first_crack: float
        nonlinear_concrete_calculational_crack_strain: float
        nonlinear_concrete_exponent_of_reduction_factor_parabola_after_first_crack: float
        nonlinear_concrete_exponent_of_function_after_first_crack: float
        nonlinear_concrete_tensile_strain: float
        nonlinear_concrete_consider_safety_factors: bool
        nonlinear_concrete_design_situation: Material.TemperatureRow.NonlinearConcreteDesignSituation
        nonlinear_concrete_partial_factors_compressive_strength: float
        nonlinear_concrete_partial_factors_compressive_strength_uneditable: float
        nonlinear_concrete_partial_factors_modulus_of_elasticity: float
        nonlinear_concrete_partial_factors_modulus_of_elasticity_uneditable: float
        nonlinear_concrete_long_term_actions_compressive_strength: float
        nonlinear_concrete_long_term_actions_tensile_strength: float
        nonlinear_concrete_design_secant_modulus_of_elasticity: float
        nonlinear_concrete_design_tangent_modulus_of_elasticity_in_origin: float
        nonlinear_concrete_compressive_strength_type: Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType
        nonlinear_concrete_compressive_strength: float
        nonlinear_concrete_compressive_strength_uneditable: float
        nonlinear_concrete_design_compressive_strength: float
        nonlinear_concrete_compression_diagram_type: Material.TemperatureRow.NonlinearConcreteCompressionDiagramType
        nonlinear_concrete_parabola_exponent: float
        nonlinear_concrete_ultimate_strain_for_maximum_compression_c1: float
        nonlinear_concrete_ultimate_strain_at_failure_cu1: float
        nonlinear_concrete_ultimate_strain_for_maximum_compression_c2: float
        nonlinear_concrete_ultimate_strain_at_failure_cu2: float
        nonlinear_concrete_relative_accuracy_of_generated_diagram: float
        nonlinear_concrete_axial_tensile_strength_type: Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType
        nonlinear_concrete_axial_tensile_strength_uneditable: float
        nonlinear_concrete_design_value_of_axial_tensile_strength: float
        nonlinear_concrete_tension_diagram_type: Material.TemperatureRow.NonlinearConcreteTensionDiagramType
        nonlinear_concrete_coefficient_at_micro_crack_initiation: float
        nonlinear_concrete_coefficient_at_micro_crack_initiation_uneditable: float
        nonlinear_concrete_ultimate_tensile_strain_at_failure: float
        nonlinear_concrete_ultimate_tensile_strain_at_failure_uneditable: float
        nonlinear_concrete_partial_factors_tensile_strength_uneditable: float
        nonlinear_concrete_partial_factors_tensile_strength: float
        soil_non_regularized_yield_surface: bool
        strain_hardening_modulus: float
        hardening_factor: float
        limit_stresses_for_tension_x: float
        limit_stresses_for_tension_y: float
        reference_element_size: float
        strain_at_peak_compression_stress: float
        fracture_energy_ft_x: float
        fracture_energy_ft_y: float
        fracture_energy_fc_x: float
        fracture_energy_fc_y: float
        masonry_alpha: float
        masonry_beta: float
        masonry_gamma: float
        masonry_compressive_strength_horizontal: float
        masonry_compressive_strength_according_to_approval: float
        yielding_acc_to: Material.TemperatureRow.YieldingAccTo
        parameter_x: float
        parameter_xz: float
        parameter_xy: float
        parameter_x_xz: float
        parameter_EN: float
        parameter_ANSI_AISC: float
        def __init__(self, no: _Optional[int] = ..., description: _Optional[str] = ..., poisson_ratio_editable_group: _Optional[_Union[Material.TemperatureRow.PoissonRatioEditableGroup, str]] = ..., poisson_ratio_editable_group_wall: _Optional[_Union[Material.TemperatureRow.PoissonRatioEditableGroupWall, str]] = ..., poisson_ratio_editable_group_platte: _Optional[_Union[Material.TemperatureRow.PoissonRatioEditableGroupPlatte, str]] = ..., stress_strain_diagram_symmetric: bool = ..., stress_strain_diagram_symmetry_factor: _Optional[float] = ..., stress_strain_diagram_has_parameters_sorted: bool = ..., stress_strain_diagram_type_start: _Optional[_Union[Material.TemperatureRow.StressStrainDiagramTypeStart, str]] = ..., stress_strain_diagram_type_end: _Optional[_Union[Material.TemperatureRow.StressStrainDiagramTypeEnd, str]] = ..., dynamic_increase_factor_diagram_symmetric: bool = ..., dynamic_increase_factor_diagram_sort: bool = ..., temperature: _Optional[float] = ..., note: _Optional[str] = ..., maximum_thickness: _Optional[float] = ..., elasticity_modulus_global: _Optional[float] = ..., elasticity_modulus_x: _Optional[float] = ..., elasticity_modulus_y: _Optional[float] = ..., elasticity_modulus_z: _Optional[float] = ..., shear_modulus_global: _Optional[float] = ..., shear_modulus_yz: _Optional[float] = ..., shear_modulus_xz: _Optional[float] = ..., shear_modulus_xy: _Optional[float] = ..., poisson_ratio_global: _Optional[float] = ..., poisson_ratio_yz: _Optional[float] = ..., poisson_ratio_xz: _Optional[float] = ..., poisson_ratio_xy: _Optional[float] = ..., poisson_ratio_zy: _Optional[float] = ..., poisson_ratio_zx: _Optional[float] = ..., poisson_ratio_yx: _Optional[float] = ..., mass_density: _Optional[float] = ..., specific_weight: _Optional[float] = ..., thermal_expansion_coefficient_global: _Optional[float] = ..., thermal_expansion_coefficient_x: _Optional[float] = ..., thermal_expansion_coefficient_y: _Optional[float] = ..., thermal_expansion_coefficient_z: _Optional[float] = ..., division_multiplication_factor: _Optional[float] = ..., yield_strength_for_thickness: _Optional[float] = ..., ultimate_strength_for_thickness: _Optional[float] = ..., saturated_specific_weight: _Optional[float] = ..., masonry_compressive_strength: _Optional[float] = ..., masonry_stone_length: _Optional[float] = ..., masonry_stone_height: _Optional[float] = ..., masonry_stone_thickness: _Optional[float] = ..., masonry_brickwork_unit: _Optional[_Union[Material.TemperatureRow.MasonryBrickworkUnit, str]] = ..., masonry_brickwork_configuration: _Optional[_Union[Material.TemperatureRow.MasonryBrickworkConfiguration, str]] = ..., masonry_brickwork_grouping: _Optional[_Union[Material.TemperatureRow.MasonryBrickworkGrouping, str]] = ..., masonry_mortar_class: _Optional[_Union[Material.TemperatureRow.MasonryMortarClass, str]] = ..., masonry_head_joints_filled: bool = ..., masonry_mortar_joint_parallel_to_wall_face: bool = ..., yield_strength: _Optional[float] = ..., yield_strength_for_compression: _Optional[float] = ..., yield_strength_for_tension: _Optional[float] = ..., hardening_modulus_x: _Optional[float] = ..., hardening_modulus_y: _Optional[float] = ..., hardening_modulus_z: _Optional[float] = ..., ultimate_compressive_strength_x: _Optional[float] = ..., ultimate_compressive_strength_y: _Optional[float] = ..., ultimate_compressive_strength_z: _Optional[float] = ..., ultimate_tensile_strength_x: _Optional[float] = ..., ultimate_tensile_strength_y: _Optional[float] = ..., ultimate_tensile_strength_z: _Optional[float] = ..., ultimate_shear_strength_yz: _Optional[float] = ..., ultimate_shear_strength_xz: _Optional[float] = ..., ultimate_shear_strength_xy: _Optional[float] = ..., thickness_range_size: _Optional[int] = ..., timber_elasticity_modulus_x_wall: _Optional[float] = ..., timber_elasticity_modulus_y_wall: _Optional[float] = ..., timber_elasticity_modulus_x_plate: _Optional[float] = ..., timber_elasticity_modulus_y_plate: _Optional[float] = ..., timber_poisson_ratio_xy_wall: _Optional[float] = ..., timber_poisson_ratio_yx_wall: _Optional[float] = ..., timber_poisson_ratio_xy_plate: _Optional[float] = ..., timber_poisson_ratio_yx_plate: _Optional[float] = ..., timber_shear_modulus_yz: _Optional[float] = ..., timber_shear_modulus_xz: _Optional[float] = ..., timber_shear_modulus_xy: _Optional[float] = ..., soil_cohesive_strength: _Optional[float] = ..., soil_angle_of_internal_friction: _Optional[float] = ..., soil_angle_of_dilation: _Optional[float] = ..., masonry_partial_factor: _Optional[float] = ..., soil_reference_tangential_stiffness_for_primary_oedometer_loading: _Optional[float] = ..., soil_reference_stress_for_stiffness: _Optional[float] = ..., soil_exponent_for_stress_level_dependency_of_stiffness: _Optional[float] = ..., hoek_brown_soil_uniaxial_compressive_strength_of_intact_rock: _Optional[float] = ..., hoek_brown_soil_intact_rock_parameter: _Optional[float] = ..., hoek_brown_soil_disturbance_factor: _Optional[float] = ..., hoek_brown_soil_geological_strength_index: _Optional[float] = ..., yield_strength_equivalent: _Optional[float] = ..., yield_strength_x: _Optional[float] = ..., shear_modulus_x: _Optional[float] = ..., shear_modulus_y: _Optional[float] = ..., shear_modulus_z: _Optional[float] = ..., modified_hardening_soil_shear_hardening_definition_type: _Optional[_Union[Material.TemperatureRow.ModifiedHardeningSoilShearHardeningDefinitionType, str]] = ..., modified_hardening_soil_shear_hardening_parameter: _Optional[float] = ..., modified_hardening_soil_stiffness_at_reference_stress: _Optional[float] = ..., modified_hardening_soil_poissons_ratio: _Optional[float] = ..., modified_hardening_soil_preconsolidation_definition_type: _Optional[_Union[Material.TemperatureRow.ModifiedHardeningSoilPreconsolidationDefinitionType, str]] = ..., modified_hardening_soil_pre_overburden_presure: _Optional[float] = ..., modified_hardening_soil_overconsolidation_ratio: _Optional[float] = ..., representative_volume_element_ratio_of_height_to_length: _Optional[float] = ..., internal_material_structure: _Optional[_Union[Material.TemperatureRow.InternalMaterialStructure, str]] = ..., hoek_brown_soil_definition_type: _Optional[_Union[Material.TemperatureRow.HoekBrownSoilDefinitionType, str]] = ..., hoek_brown_soil_strength_parameter_m_b: _Optional[float] = ..., hoek_brown_soil_strength_parameter_s: _Optional[float] = ..., hoek_brown_soil_strength_parameter_a: _Optional[float] = ..., hoek_brown_soil_strength_parameter_m_g: _Optional[float] = ..., hoek_brown_soil_strength_parameter_s_g: _Optional[float] = ..., hoek_brown_soil_strength_parameter_a_g: _Optional[float] = ..., hoek_brown_soil_elastic_stiffness_matrix: bool = ..., hoek_brown_soil_user_defined: bool = ..., nonlinear_concrete_diagram_definition: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteDiagramDefinition, str]] = ..., nonlinear_concrete_mean_secant_modulus_of_elasticity: _Optional[float] = ..., nonlinear_concrete_tangent_modulus_of_elasticity_in_origin: _Optional[float] = ..., nonlinear_concrete_tension_stiffening: bool = ..., nonlinear_concrete_tension_stiffening_method: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteTensionStiffeningMethod, str]] = ..., nonlinear_concrete_reduction_factor_for_tensile_strength: _Optional[float] = ..., nonlinear_concrete_axial_tensile_strength: _Optional[float] = ..., nonlinear_concrete_strain_at_peak_compression_stress: _Optional[float] = ..., nonlinear_concrete_tensile_strength_at_first_crack: _Optional[float] = ..., nonlinear_concrete_exponent_of_stress_strain_parabola_until_first_crack: _Optional[float] = ..., nonlinear_concrete_calculational_crack_strain: _Optional[float] = ..., nonlinear_concrete_exponent_of_reduction_factor_parabola_after_first_crack: _Optional[float] = ..., nonlinear_concrete_exponent_of_function_after_first_crack: _Optional[float] = ..., nonlinear_concrete_tensile_strain: _Optional[float] = ..., nonlinear_concrete_consider_safety_factors: bool = ..., nonlinear_concrete_design_situation: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteDesignSituation, str]] = ..., nonlinear_concrete_partial_factors_compressive_strength: _Optional[float] = ..., nonlinear_concrete_partial_factors_compressive_strength_uneditable: _Optional[float] = ..., nonlinear_concrete_partial_factors_modulus_of_elasticity: _Optional[float] = ..., nonlinear_concrete_partial_factors_modulus_of_elasticity_uneditable: _Optional[float] = ..., nonlinear_concrete_long_term_actions_compressive_strength: _Optional[float] = ..., nonlinear_concrete_long_term_actions_tensile_strength: _Optional[float] = ..., nonlinear_concrete_design_secant_modulus_of_elasticity: _Optional[float] = ..., nonlinear_concrete_design_tangent_modulus_of_elasticity_in_origin: _Optional[float] = ..., nonlinear_concrete_compressive_strength_type: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteCompressiveStrengthType, str]] = ..., nonlinear_concrete_compressive_strength: _Optional[float] = ..., nonlinear_concrete_compressive_strength_uneditable: _Optional[float] = ..., nonlinear_concrete_design_compressive_strength: _Optional[float] = ..., nonlinear_concrete_compression_diagram_type: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteCompressionDiagramType, str]] = ..., nonlinear_concrete_parabola_exponent: _Optional[float] = ..., nonlinear_concrete_ultimate_strain_for_maximum_compression_c1: _Optional[float] = ..., nonlinear_concrete_ultimate_strain_at_failure_cu1: _Optional[float] = ..., nonlinear_concrete_ultimate_strain_for_maximum_compression_c2: _Optional[float] = ..., nonlinear_concrete_ultimate_strain_at_failure_cu2: _Optional[float] = ..., nonlinear_concrete_relative_accuracy_of_generated_diagram: _Optional[float] = ..., nonlinear_concrete_axial_tensile_strength_type: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteAxialTensileStrengthType, str]] = ..., nonlinear_concrete_axial_tensile_strength_uneditable: _Optional[float] = ..., nonlinear_concrete_design_value_of_axial_tensile_strength: _Optional[float] = ..., nonlinear_concrete_tension_diagram_type: _Optional[_Union[Material.TemperatureRow.NonlinearConcreteTensionDiagramType, str]] = ..., nonlinear_concrete_coefficient_at_micro_crack_initiation: _Optional[float] = ..., nonlinear_concrete_coefficient_at_micro_crack_initiation_uneditable: _Optional[float] = ..., nonlinear_concrete_ultimate_tensile_strain_at_failure: _Optional[float] = ..., nonlinear_concrete_ultimate_tensile_strain_at_failure_uneditable: _Optional[float] = ..., nonlinear_concrete_partial_factors_tensile_strength_uneditable: _Optional[float] = ..., nonlinear_concrete_partial_factors_tensile_strength: _Optional[float] = ..., soil_non_regularized_yield_surface: bool = ..., strain_hardening_modulus: _Optional[float] = ..., hardening_factor: _Optional[float] = ..., limit_stresses_for_tension_x: _Optional[float] = ..., limit_stresses_for_tension_y: _Optional[float] = ..., reference_element_size: _Optional[float] = ..., strain_at_peak_compression_stress: _Optional[float] = ..., fracture_energy_ft_x: _Optional[float] = ..., fracture_energy_ft_y: _Optional[float] = ..., fracture_energy_fc_x: _Optional[float] = ..., fracture_energy_fc_y: _Optional[float] = ..., masonry_alpha: _Optional[float] = ..., masonry_beta: _Optional[float] = ..., masonry_gamma: _Optional[float] = ..., masonry_compressive_strength_horizontal: _Optional[float] = ..., masonry_compressive_strength_according_to_approval: _Optional[float] = ..., yielding_acc_to: _Optional[_Union[Material.TemperatureRow.YieldingAccTo, str]] = ..., parameter_x: _Optional[float] = ..., parameter_xz: _Optional[float] = ..., parameter_xy: _Optional[float] = ..., parameter_x_xz: _Optional[float] = ..., parameter_EN: _Optional[float] = ..., parameter_ANSI_AISC: _Optional[float] = ...) -> None: ...
    NO_FIELD_NUMBER: _ClassVar[int]
    MATERIAL_TYPE_FIELD_NUMBER: _ClassVar[int]
    MATERIAL_MODEL_FIELD_NUMBER: _ClassVar[int]
    APPLICATION_CONTEXT_FIELD_NUMBER: _ClassVar[int]
    DIAGRAM_TYPE_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_NAME_ENABLED_FIELD_NUMBER: _ClassVar[int]
    NAME_FIELD_NUMBER: _ClassVar[int]
    USER_DEFINED_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_TYPE_FIELD_NUMBER: _ClassVar[int]
    STRESS_FAILURE_HYPOTHESIS_FIELD_NUMBER: _ClassVar[int]
    IS_TEMPERATURE_DEPENDENT_FIELD_NUMBER: _ClassVar[int]
    IS_DYNAMIC_INCREASE_FACTOR_FIELD_NUMBER: _ClassVar[int]
    HAS_COST_ESTIMATION_FIELD_NUMBER: _ClassVar[int]
    OPTIMIZATION_FIELD_NUMBER: _ClassVar[int]
    HAS_EMISSIONS_ESTIMATION_FIELD_NUMBER: _ClassVar[int]
    REFERENCE_TEMPERATURE_FIELD_NUMBER: _ClassVar[int]
    TEMPERATURE_PROPERTIES_SORTED_FIELD_NUMBER: _ClassVar[int]
    TEMPERATURE_FIELD_NUMBER: _ClassVar[int]
    STIFFNESS_MODIFICATION_FIELD_NUMBER: _ClassVar[int]
    STIFFNESS_MODIFICATION_TYPE_FIELD_NUMBER: _ClassVar[int]
    HAS_LINEAR_ELASTIC_WITH_NONLINEAR_CRITERIA_FIELD_NUMBER: _ClassVar[int]
    COMMENT_FIELD_NUMBER: _ClassVar[int]
    IS_GENERATED_FIELD_NUMBER: _ClassVar[int]
    GENERATING_OBJECT_INFO_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_WEIGHT_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_WEIGHT_COST_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_VOLUME_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_VOLUME_COST_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_SURFACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_SURFACE_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_SURFACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_SURFACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    MEMBERS_SURFACE_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SURFACES_WEIGHT_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    SURFACES_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SURFACES_WEIGHT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SURFACES_VOLUME_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    SURFACES_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SURFACES_VOLUME_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_TOP_FACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SURFACES_TOP_FACE_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_TOP_FACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    SURFACES_TOP_FACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SURFACES_TOP_FACE_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_AREA_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SURFACES_AREA_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_AREA_UNIT_FIELD_NUMBER: _ClassVar[int]
    SURFACES_AREA_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SURFACES_AREA_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_BOTTOM_FACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SURFACES_BOTTOM_FACE_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SURFACES_BOTTOM_FACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    SURFACES_BOTTOM_FACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SURFACES_BOTTOM_FACE_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_WEIGHT_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_WEIGHT_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_VOLUME_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_VOLUME_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_AREA_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_AREA_UNIT_COST_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_AREA_UNIT_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_AREA_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    SOLIDS_AREA_COST_FIELD_NUMBER: _ClassVar[int]
    SUM_WEIGHT_FIELD_NUMBER: _ClassVar[int]
    WEIGHT_PERCENTAGE_FIELD_NUMBER: _ClassVar[int]
    COST_PERCENTAGE_FIELD_NUMBER: _ClassVar[int]
    SUM_COST_FIELD_NUMBER: _ClassVar[int]
    TOTAL_COST_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_WEIGHT_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_WEIGHT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_VOLUME_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_VOLUME_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_SURFACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_SURFACE_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_SURFACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_SURFACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_MEMBERS_SURFACE_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_WEIGHT_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_WEIGHT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_VOLUME_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_VOLUME_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_TOP_FACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_TOP_FACE_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_TOP_FACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_TOP_FACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_TOP_FACE_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_AREA_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_AREA_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_AREA_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_AREA_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_AREA_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_BOTTOM_FACE_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_BOTTOM_FACE_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_BOTTOM_FACE_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SURFACES_BOTTOM_FACE_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_WEIGHT_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_WEIGHT_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_WEIGHT_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_WEIGHT_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_WEIGHT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_VOLUME_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_VOLUME_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_VOLUME_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_VOLUME_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_VOLUME_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_AREA_ACTIVE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_AREA_UNIT_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_AREA_UNIT_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_AREA_QUANTITY_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SOLIDS_AREA_EMISSION_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_PERCENTAGE_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_SUM_FIELD_NUMBER: _ClassVar[int]
    EMISSIONS_TOTAL_FIELD_NUMBER: _ClassVar[int]
    USE_OF_MATERIAL_MODEL_ORIENTATION_FIELD_NUMBER: _ClassVar[int]
    USE_OF_MATERIAL_MODEL_ALIGNMENT_FIELD_NUMBER: _ClassVar[int]
    ID_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FOR_EXPORT_IMPORT_FIELD_NUMBER: _ClassVar[int]
    no: int
    material_type: Material.MaterialType
    material_model: Material.MaterialModel
    application_context: Material.ApplicationContext
    diagram_type: Material.DiagramType
    user_defined_name_enabled: bool
    name: str
    user_defined: bool
    definition_type: Material.DefinitionType
    stress_failure_hypothesis: Material.StressFailureHypothesis
    is_temperature_dependent: bool
    is_dynamic_increase_factor: bool
    has_cost_estimation: bool
    optimization: bool
    has_emissions_estimation: bool
    reference_temperature: float
    temperature_properties_sorted: bool
    temperature: Material.TemperatureTable
    stiffness_modification: bool
    stiffness_modification_type: Material.StiffnessModificationType
    has_linear_elastic_with_nonlinear_criteria: bool
    comment: str
    is_generated: bool
    generating_object_info: str
    members_weight_active: bool
    members_weight_unit_cost: float
    members_weight_unit: Material.MembersWeightUnit
    members_weight_quantity: float
    members_weight_cost: float
    members_volume_active: bool
    members_volume_unit_cost: float
    members_volume_unit: Material.MembersVolumeUnit
    members_volume_quantity: float
    members_volume_cost: float
    members_surface_active: bool
    members_surface_unit_cost: float
    members_surface_unit: Material.MembersSurfaceUnit
    members_surface_quantity: float
    members_surface_cost: float
    surfaces_weight_active: bool
    surfaces_weight_unit_cost: float
    surfaces_weight_unit: Material.SurfacesWeightUnit
    surfaces_weight_quantity: float
    surfaces_weight_cost: float
    surfaces_volume_active: bool
    surfaces_volume_unit_cost: float
    surfaces_volume_unit: Material.SurfacesVolumeUnit
    surfaces_volume_quantity: float
    surfaces_volume_cost: float
    surfaces_top_face_active: bool
    surfaces_top_face_unit_cost: float
    surfaces_top_face_unit: Material.SurfacesTopFaceUnit
    surfaces_top_face_quantity: float
    surfaces_top_face_cost: float
    surfaces_area_active: bool
    surfaces_area_unit_cost: float
    surfaces_area_unit: Material.SurfacesAreaUnit
    surfaces_area_quantity: float
    surfaces_area_cost: float
    surfaces_bottom_face_active: bool
    surfaces_bottom_face_unit_cost: float
    surfaces_bottom_face_unit: Material.SurfacesBottomFaceUnit
    surfaces_bottom_face_quantity: float
    surfaces_bottom_face_cost: float
    solids_weight_active: bool
    solids_weight_unit_cost: float
    solids_weight_unit: Material.SolidsWeightUnit
    solids_weight_quantity: float
    solids_weight_cost: float
    solids_volume_active: bool
    solids_volume_unit_cost: float
    solids_volume_unit: Material.SolidsVolumeUnit
    solids_volume_quantity: float
    solids_volume_cost: float
    solids_area_active: bool
    solids_area_unit_cost: float
    solids_area_unit: Material.SolidsAreaUnit
    solids_area_quantity: float
    solids_area_cost: float
    sum_weight: float
    weight_percentage: float
    cost_percentage: float
    sum_cost: float
    total_cost: float
    emissions_members_weight_active: bool
    emissions_members_weight_unit_emission: float
    emissions_members_weight_unit: Material.EmissionsMembersWeightUnit
    emissions_members_weight_quantity: float
    emissions_members_weight_emission: float
    emissions_members_volume_active: bool
    emissions_members_volume_unit_emission: float
    emissions_members_volume_unit: Material.EmissionsMembersVolumeUnit
    emissions_members_volume_quantity: float
    emissions_members_volume_emission: float
    emissions_members_surface_active: bool
    emissions_members_surface_unit_emission: float
    emissions_members_surface_unit: Material.EmissionsMembersSurfaceUnit
    emissions_members_surface_quantity: float
    emissions_members_surface_emission: float
    emissions_surfaces_weight_active: bool
    emissions_surfaces_weight_unit_emission: float
    emissions_surfaces_weight_unit: Material.EmissionsSurfacesWeightUnit
    emissions_surfaces_weight_quantity: float
    emissions_surfaces_weight_emission: float
    emissions_surfaces_volume_active: bool
    emissions_surfaces_volume_unit_emission: float
    emissions_surfaces_volume_unit: Material.EmissionsSurfacesVolumeUnit
    emissions_surfaces_volume_quantity: float
    emissions_surfaces_volume_emission: float
    emissions_surfaces_top_face_active: bool
    emissions_surfaces_top_face_unit_emission: float
    emissions_surfaces_top_face_unit: Material.EmissionsSurfacesTopFaceUnit
    emissions_surfaces_top_face_quantity: float
    emissions_surfaces_top_face_emission: float
    emissions_surfaces_area_active: bool
    emissions_surfaces_area_unit_emission: float
    emissions_surfaces_area_unit: Material.EmissionsSurfacesAreaUnit
    emissions_surfaces_area_quantity: float
    emissions_surfaces_area_emission: float
    emissions_surfaces_bottom_face_active: bool
    emissions_surfaces_bottom_face_unit_emission: float
    emissions_surfaces_bottom_face_unit: Material.EmissionsSurfacesBottomFaceUnit
    emissions_surfaces_bottom_face_quantity: float
    emissions_surfaces_bottom_face_emission: float
    emissions_solids_weight_active: bool
    emissions_solids_weight_unit_emission: float
    emissions_solids_weight_unit: Material.EmissionsSolidsWeightUnit
    emissions_solids_weight_quantity: float
    emissions_solids_weight_emission: float
    emissions_solids_volume_active: bool
    emissions_solids_volume_unit_emission: float
    emissions_solids_volume_unit: Material.EmissionsSolidsVolumeUnit
    emissions_solids_volume_quantity: float
    emissions_solids_volume_emission: float
    emissions_solids_area_active: bool
    emissions_solids_area_unit_emission: float
    emissions_solids_area_unit: Material.EmissionsSolidsAreaUnit
    emissions_solids_area_quantity: float
    emissions_solids_area_emission: float
    emissions_percentage: float
    emissions_sum: float
    emissions_total: float
    use_of_material_model_orientation: Material.UseOfMaterialModelOrientation
    use_of_material_model_alignment: Material.UseOfMaterialModelAlignment
    id_for_export_import: str
    metadata_for_export_import: str
    def __init__(self, no: _Optional[int] = ..., material_type: _Optional[_Union[Material.MaterialType, str]] = ..., material_model: _Optional[_Union[Material.MaterialModel, str]] = ..., application_context: _Optional[_Union[Material.ApplicationContext, str]] = ..., diagram_type: _Optional[_Union[Material.DiagramType, str]] = ..., user_defined_name_enabled: bool = ..., name: _Optional[str] = ..., user_defined: bool = ..., definition_type: _Optional[_Union[Material.DefinitionType, str]] = ..., stress_failure_hypothesis: _Optional[_Union[Material.StressFailureHypothesis, str]] = ..., is_temperature_dependent: bool = ..., is_dynamic_increase_factor: bool = ..., has_cost_estimation: bool = ..., optimization: bool = ..., has_emissions_estimation: bool = ..., reference_temperature: _Optional[float] = ..., temperature_properties_sorted: bool = ..., temperature: _Optional[_Union[Material.TemperatureTable, _Mapping]] = ..., stiffness_modification: bool = ..., stiffness_modification_type: _Optional[_Union[Material.StiffnessModificationType, str]] = ..., has_linear_elastic_with_nonlinear_criteria: bool = ..., comment: _Optional[str] = ..., is_generated: bool = ..., generating_object_info: _Optional[str] = ..., members_weight_active: bool = ..., members_weight_unit_cost: _Optional[float] = ..., members_weight_unit: _Optional[_Union[Material.MembersWeightUnit, str]] = ..., members_weight_quantity: _Optional[float] = ..., members_weight_cost: _Optional[float] = ..., members_volume_active: bool = ..., members_volume_unit_cost: _Optional[float] = ..., members_volume_unit: _Optional[_Union[Material.MembersVolumeUnit, str]] = ..., members_volume_quantity: _Optional[float] = ..., members_volume_cost: _Optional[float] = ..., members_surface_active: bool = ..., members_surface_unit_cost: _Optional[float] = ..., members_surface_unit: _Optional[_Union[Material.MembersSurfaceUnit, str]] = ..., members_surface_quantity: _Optional[float] = ..., members_surface_cost: _Optional[float] = ..., surfaces_weight_active: bool = ..., surfaces_weight_unit_cost: _Optional[float] = ..., surfaces_weight_unit: _Optional[_Union[Material.SurfacesWeightUnit, str]] = ..., surfaces_weight_quantity: _Optional[float] = ..., surfaces_weight_cost: _Optional[float] = ..., surfaces_volume_active: bool = ..., surfaces_volume_unit_cost: _Optional[float] = ..., surfaces_volume_unit: _Optional[_Union[Material.SurfacesVolumeUnit, str]] = ..., surfaces_volume_quantity: _Optional[float] = ..., surfaces_volume_cost: _Optional[float] = ..., surfaces_top_face_active: bool = ..., surfaces_top_face_unit_cost: _Optional[float] = ..., surfaces_top_face_unit: _Optional[_Union[Material.SurfacesTopFaceUnit, str]] = ..., surfaces_top_face_quantity: _Optional[float] = ..., surfaces_top_face_cost: _Optional[float] = ..., surfaces_area_active: bool = ..., surfaces_area_unit_cost: _Optional[float] = ..., surfaces_area_unit: _Optional[_Union[Material.SurfacesAreaUnit, str]] = ..., surfaces_area_quantity: _Optional[float] = ..., surfaces_area_cost: _Optional[float] = ..., surfaces_bottom_face_active: bool = ..., surfaces_bottom_face_unit_cost: _Optional[float] = ..., surfaces_bottom_face_unit: _Optional[_Union[Material.SurfacesBottomFaceUnit, str]] = ..., surfaces_bottom_face_quantity: _Optional[float] = ..., surfaces_bottom_face_cost: _Optional[float] = ..., solids_weight_active: bool = ..., solids_weight_unit_cost: _Optional[float] = ..., solids_weight_unit: _Optional[_Union[Material.SolidsWeightUnit, str]] = ..., solids_weight_quantity: _Optional[float] = ..., solids_weight_cost: _Optional[float] = ..., solids_volume_active: bool = ..., solids_volume_unit_cost: _Optional[float] = ..., solids_volume_unit: _Optional[_Union[Material.SolidsVolumeUnit, str]] = ..., solids_volume_quantity: _Optional[float] = ..., solids_volume_cost: _Optional[float] = ..., solids_area_active: bool = ..., solids_area_unit_cost: _Optional[float] = ..., solids_area_unit: _Optional[_Union[Material.SolidsAreaUnit, str]] = ..., solids_area_quantity: _Optional[float] = ..., solids_area_cost: _Optional[float] = ..., sum_weight: _Optional[float] = ..., weight_percentage: _Optional[float] = ..., cost_percentage: _Optional[float] = ..., sum_cost: _Optional[float] = ..., total_cost: _Optional[float] = ..., emissions_members_weight_active: bool = ..., emissions_members_weight_unit_emission: _Optional[float] = ..., emissions_members_weight_unit: _Optional[_Union[Material.EmissionsMembersWeightUnit, str]] = ..., emissions_members_weight_quantity: _Optional[float] = ..., emissions_members_weight_emission: _Optional[float] = ..., emissions_members_volume_active: bool = ..., emissions_members_volume_unit_emission: _Optional[float] = ..., emissions_members_volume_unit: _Optional[_Union[Material.EmissionsMembersVolumeUnit, str]] = ..., emissions_members_volume_quantity: _Optional[float] = ..., emissions_members_volume_emission: _Optional[float] = ..., emissions_members_surface_active: bool = ..., emissions_members_surface_unit_emission: _Optional[float] = ..., emissions_members_surface_unit: _Optional[_Union[Material.EmissionsMembersSurfaceUnit, str]] = ..., emissions_members_surface_quantity: _Optional[float] = ..., emissions_members_surface_emission: _Optional[float] = ..., emissions_surfaces_weight_active: bool = ..., emissions_surfaces_weight_unit_emission: _Optional[float] = ..., emissions_surfaces_weight_unit: _Optional[_Union[Material.EmissionsSurfacesWeightUnit, str]] = ..., emissions_surfaces_weight_quantity: _Optional[float] = ..., emissions_surfaces_weight_emission: _Optional[float] = ..., emissions_surfaces_volume_active: bool = ..., emissions_surfaces_volume_unit_emission: _Optional[float] = ..., emissions_surfaces_volume_unit: _Optional[_Union[Material.EmissionsSurfacesVolumeUnit, str]] = ..., emissions_surfaces_volume_quantity: _Optional[float] = ..., emissions_surfaces_volume_emission: _Optional[float] = ..., emissions_surfaces_top_face_active: bool = ..., emissions_surfaces_top_face_unit_emission: _Optional[float] = ..., emissions_surfaces_top_face_unit: _Optional[_Union[Material.EmissionsSurfacesTopFaceUnit, str]] = ..., emissions_surfaces_top_face_quantity: _Optional[float] = ..., emissions_surfaces_top_face_emission: _Optional[float] = ..., emissions_surfaces_area_active: bool = ..., emissions_surfaces_area_unit_emission: _Optional[float] = ..., emissions_surfaces_area_unit: _Optional[_Union[Material.EmissionsSurfacesAreaUnit, str]] = ..., emissions_surfaces_area_quantity: _Optional[float] = ..., emissions_surfaces_area_emission: _Optional[float] = ..., emissions_surfaces_bottom_face_active: bool = ..., emissions_surfaces_bottom_face_unit_emission: _Optional[float] = ..., emissions_surfaces_bottom_face_unit: _Optional[_Union[Material.EmissionsSurfacesBottomFaceUnit, str]] = ..., emissions_surfaces_bottom_face_quantity: _Optional[float] = ..., emissions_surfaces_bottom_face_emission: _Optional[float] = ..., emissions_solids_weight_active: bool = ..., emissions_solids_weight_unit_emission: _Optional[float] = ..., emissions_solids_weight_unit: _Optional[_Union[Material.EmissionsSolidsWeightUnit, str]] = ..., emissions_solids_weight_quantity: _Optional[float] = ..., emissions_solids_weight_emission: _Optional[float] = ..., emissions_solids_volume_active: bool = ..., emissions_solids_volume_unit_emission: _Optional[float] = ..., emissions_solids_volume_unit: _Optional[_Union[Material.EmissionsSolidsVolumeUnit, str]] = ..., emissions_solids_volume_quantity: _Optional[float] = ..., emissions_solids_volume_emission: _Optional[float] = ..., emissions_solids_area_active: bool = ..., emissions_solids_area_unit_emission: _Optional[float] = ..., emissions_solids_area_unit: _Optional[_Union[Material.EmissionsSolidsAreaUnit, str]] = ..., emissions_solids_area_quantity: _Optional[float] = ..., emissions_solids_area_emission: _Optional[float] = ..., emissions_percentage: _Optional[float] = ..., emissions_sum: _Optional[float] = ..., emissions_total: _Optional[float] = ..., use_of_material_model_orientation: _Optional[_Union[Material.UseOfMaterialModelOrientation, str]] = ..., use_of_material_model_alignment: _Optional[_Union[Material.UseOfMaterialModelAlignment, str]] = ..., id_for_export_import: _Optional[str] = ..., metadata_for_export_import: _Optional[str] = ...) -> None: ...
