import pandas as pd
import importlib.resources
from functools import reduce

data = [
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/NeonSNQ043_iR532_Probe_5msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'Neon'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/NeonSNQ043_iR532_Probe_100msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'Neon'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/PST10_iR532_Probe_100_3000msx7.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'PST'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/S0B10_iR532_Probe_100_60000msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'S0B'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/S0N10_iR532_Probe_100_30000msx3.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'S0N'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/S0P10_iR532_Probe_100_60000msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'S0P'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/S1N10_iR532_Probe_100_22000msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'S1N'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/Sil10_iR532_Probe_100_60000msx2.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'Sil_'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/nCAL10_iR532_Probe_100_2500msx3.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'nCAL'},
    {'OP': '01', 'device': 'BWtek', 'filename': './FMNT-M_BW532/sCAL10_iR532_Probe_100_3200msx4.txt',
        'laser_wl': '532', 'provider': 'FNMT', 'sample': 'sCAL'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/NeonSNQ043_iR785_OP01.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Neon'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/PST10_iR785_OP01_40000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'PST'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0B10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0B'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0N10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0N'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0P10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0P'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S1N10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S1N'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/Sil10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Sil'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/nCAL10_iR785_OP01_6000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'nCAL'},
    {'OP': '01', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/sCAL10_iR785_OP01_4000msx4.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'sCAL'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/NeonSNQ043_iR785_OP02.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Neon'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/PST10_iR785_OP02_50000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'PST'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0B10_iR785_OP02_25000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0B'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0N10_iR785_OP02_25000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0N'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0P10_iR785_OP02_25000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0P'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S1N10_iR785_OP02_25000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S1N'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/Sil10_iR785_OP02_25000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Sil'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/nCAL10_iR785_OP02_20000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'nCAL'},
    {'OP': '02', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/sCAL10_iR785_OP02_15000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'sCAL'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/NeonSNQ043_iR785_OP03.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Neon'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/PST10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'PST'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0B10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0B'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0N10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0N'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S0P10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S0P'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/S1N10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'S1N'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/Sil10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'Sil'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/nCAL10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'nCAL'},
    {'OP': '03', 'device': 'Horiba', 'filename': './FMNT-M_Ho785/sCAL10_iR785_OP03_8000msx2.txt',
        'laser_wl': '785', 'provider': 'FNMT', 'sample': 'sCAL'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/Ne_532nm_x50_800ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'Neon'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/Ne_532nm_x50_25ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'Neon'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/PST02_iRPlus532_Z050_100_2500msx5.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'PST'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/S0B02_iRPlus532_Z050_100_30000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/S0N02_iRPlus532_Z050_100_40000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0N'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/S0P02_iRPlus532_Z050_100_30000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0P'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/S1N02_iRPlus532_Z050_100_12000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S1N'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/nCAL02_iRPlus532_Z050_100_9000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'nCAL'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW532/sCAL02_iRPlus532_Z050_100_20000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'sCAL'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/Ne_532nm_x100_2000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'Neon'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/Ne_532nm_x100_110ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'Neon'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/PST02_iRPlus532_Z100_100_50000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'PST'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/S0B02_iRPlus532_Z100_100_22000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/S0N02_iRPlus532_Z100_100_28000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0N'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/S0P02_iRPlus532_Z100_100_20000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S0P'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/S1N02_iRPlus532_Z100_100_6500ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'S1N'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/nCAL02_iRPlus532_Z100_100_30000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'nCAL'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW532/sCAL02_iRPlus532_Z100_100_65000ms.txt',
        'laser_wl': '532', 'provider': 'ICV', 'sample': 'sCAL'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/PST02_iRPlus785_Z020_100_1300ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'PST'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/S0B02_iRPlus785_Z020_100_full.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/S0B02_iRPlus785_Z020_100_12000ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/S0N02_iRPlus785_Z020_100_3800ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0N'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/S0P02_iRPlus785_Z020_100_12000ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0P'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/S1N02_iRPlus785_Z020_100_3800ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S1N'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/nCAL02_iRPlus785_Z020_100_1100ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'nCAL'},
    {'OP': '020', 'device': 'BWtek', 'filename': './ICV_BW785/sCAL02_iRPlus785_Z020_100_2400ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'sCAL'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/PST02_iRPlus785_Z050_100_3200ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'PST'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/S0B02_iRPlus785_Z050_100_5500ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/S0N02_iRPlus785_Z050_100_3200ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0N'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/S0P02_iRPlus785_Z050_100_5700ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0P'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/S1N02_iRPlus785_Z050_100_2100ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S1N'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/nCAL02_iRPlus785_Z050_100_2100ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'nCAL'},
    {'OP': '050', 'device': 'BWtek', 'filename': './ICV_BW785/sCAL02_iRPlus785_Z050_100_3800ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'sCAL'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/PST02_iRPlus785_Z100_100_9000ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'PST'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/S0B02_iRPlus785_Z100_100_4700ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0B'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/S0N02_iRPlus785_Z100_100_3100ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0N'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/S0P02_iRPlus785_Z100_100_4800ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S0P'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/S1N02_iRPlus785_Z100_100_2000ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'S1N'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/nCAL02_iRPlus785_Z100_100_6000ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'nCAL'},
    {'OP': '100', 'device': 'BWtek', 'filename': './ICV_BW785/sCAL02_iRPlus785_Z100_100_9500ms.txt',
        'laser_wl': '785', 'provider': 'ICV', 'sample': 'sCAL'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/neon_new2_Z010.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'Neon'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/Pol_HLR633_Z010_100_15sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'PST'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/S0B_HLR633_Z010_100_40sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'S0B'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/S0N_HLR633_Z010_100_15sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'S0N'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/S0P_HLR633_Z010_100_40sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'S0P'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/S1N_HLR633_Z010_100_10sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'S1N'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/Si_HLR633_Z010_100_40sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'Sil'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/nCAL_HLR633_Z010_100_5sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'nCAL'},
    {'OP': '010', 'device': 'Horiba', 'filename': './TOP_Ho633/sCAL_HLR633_Z010_100_15sx5.txt',
        'laser_wl': '633', 'provider': 'TOP', 'sample': 'sCAL'},
]


df = pd.DataFrame.from_dict(data)
loc = importlib.resources.files(__name__)


def filtered_df(**kwargs):
    filters = [reduce(lambda a, b: a | b, [df[k] == i for i in v]) for k, v in kwargs.items() if v]
    if filters:
        return df[reduce(lambda a, b: a & b, filters)]
    else:
        return df


def get_filters(**kwargs):
    df_tmp = filtered_df(**kwargs)
    return {c: df_tmp[c].unique() for c in df_tmp.columns if c != 'filename'}


def get_filenames(**kwargs):
    df_tmp = filtered_df(**kwargs)
    return df_tmp['filename']


def prepend_prefix(filenames):
    return [str(loc.joinpath(fn)) for fn in filenames]
