# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SuspensionArgs', 'Suspension']

@pulumi.input_type
class SuspensionArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 suspensions: pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]):
        """
        The set of arguments for constructing a Suspension resource.
        :param pulumi.Input[_builtins.str] group_id: Elastigroup ID to apply the suspensions on.
        :param pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]] suspensions: block of single process to suspend.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "suspensions", suspensions)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Elastigroup ID to apply the suspensions on.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def suspensions(self) -> pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]:
        """
        block of single process to suspend.
        """
        return pulumi.get(self, "suspensions")

    @suspensions.setter
    def suspensions(self, value: pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]):
        pulumi.set(self, "suspensions", value)


@pulumi.input_type
class _SuspensionState:
    def __init__(__self__, *,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 suspensions: Optional[pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]] = None):
        """
        Input properties used for looking up and filtering Suspension resources.
        :param pulumi.Input[_builtins.str] group_id: Elastigroup ID to apply the suspensions on.
        :param pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]] suspensions: block of single process to suspend.
        """
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if suspensions is not None:
            pulumi.set(__self__, "suspensions", suspensions)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Elastigroup ID to apply the suspensions on.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter
    def suspensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]]:
        """
        block of single process to suspend.
        """
        return pulumi.get(self, "suspensions")

    @suspensions.setter
    def suspensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SuspensionSuspensionArgs']]]]):
        pulumi.set(self, "suspensions", value)


@pulumi.type_token("spotinst:aws/suspension:Suspension")
class Suspension(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 suspensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SuspensionSuspensionArgs', 'SuspensionSuspensionArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # Create a suspension for Elastigroup
        resource_name = spotinst.aws.Suspension("resource_name",
            group_id="sig-12345678",
            suspensions=[
                {
                    "name": "OUT_OF_STRATEGY",
                },
                {
                    "name": "REVERT_PREFERRED",
                },
                {
                    "name": "PREVENTIVE_REPLACEMENT",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: Elastigroup ID to apply the suspensions on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SuspensionSuspensionArgs', 'SuspensionSuspensionArgsDict']]]] suspensions: block of single process to suspend.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SuspensionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        # Create a suspension for Elastigroup
        resource_name = spotinst.aws.Suspension("resource_name",
            group_id="sig-12345678",
            suspensions=[
                {
                    "name": "OUT_OF_STRATEGY",
                },
                {
                    "name": "REVERT_PREFERRED",
                },
                {
                    "name": "PREVENTIVE_REPLACEMENT",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param SuspensionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SuspensionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 suspensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SuspensionSuspensionArgs', 'SuspensionSuspensionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SuspensionArgs.__new__(SuspensionArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if suspensions is None and not opts.urn:
                raise TypeError("Missing required property 'suspensions'")
            __props__.__dict__["suspensions"] = suspensions
        super(Suspension, __self__).__init__(
            'spotinst:aws/suspension:Suspension',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            suspensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SuspensionSuspensionArgs', 'SuspensionSuspensionArgsDict']]]]] = None) -> 'Suspension':
        """
        Get an existing Suspension resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: Elastigroup ID to apply the suspensions on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SuspensionSuspensionArgs', 'SuspensionSuspensionArgsDict']]]] suspensions: block of single process to suspend.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SuspensionState.__new__(_SuspensionState)

        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["suspensions"] = suspensions
        return Suspension(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Elastigroup ID to apply the suspensions on.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def suspensions(self) -> pulumi.Output[Sequence['outputs.SuspensionSuspension']]:
        """
        block of single process to suspend.
        """
        return pulumi.get(self, "suspensions")

