# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'OceanAutoscalerArgs',
    'OceanAutoscalerArgsDict',
    'OceanAutoscalerDownArgs',
    'OceanAutoscalerDownArgsDict',
    'OceanAutoscalerHeadroomArgs',
    'OceanAutoscalerHeadroomArgsDict',
    'OceanAutoscalerResourceLimitsArgs',
    'OceanAutoscalerResourceLimitsArgsDict',
    'OceanBlockDeviceMappingArgs',
    'OceanBlockDeviceMappingArgsDict',
    'OceanBlockDeviceMappingEbsArgs',
    'OceanBlockDeviceMappingEbsArgsDict',
    'OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs',
    'OceanBlockDeviceMappingEbsDynamicVolumeSizeArgsDict',
    'OceanClusterOrientationArgs',
    'OceanClusterOrientationArgsDict',
    'OceanFiltersArgs',
    'OceanFiltersArgsDict',
    'OceanInstanceMetadataOptionsArgs',
    'OceanInstanceMetadataOptionsArgsDict',
    'OceanLaunchSpecAttributeArgs',
    'OceanLaunchSpecAttributeArgsDict',
    'OceanLaunchSpecAutoscaleHeadroomArgs',
    'OceanLaunchSpecAutoscaleHeadroomArgsDict',
    'OceanLaunchSpecBlockDeviceMappingArgs',
    'OceanLaunchSpecBlockDeviceMappingArgsDict',
    'OceanLaunchSpecBlockDeviceMappingEbsArgs',
    'OceanLaunchSpecBlockDeviceMappingEbsArgsDict',
    'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs',
    'OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgsDict',
    'OceanLaunchSpecImageArgs',
    'OceanLaunchSpecImageArgsDict',
    'OceanLaunchSpecInstanceMetadataOptionsArgs',
    'OceanLaunchSpecInstanceMetadataOptionsArgsDict',
    'OceanLaunchSpecSchedulingTaskArgs',
    'OceanLaunchSpecSchedulingTaskArgsDict',
    'OceanLaunchSpecSchedulingTaskTaskHeadroomArgs',
    'OceanLaunchSpecSchedulingTaskTaskHeadroomArgsDict',
    'OceanLaunchSpecStrategyArgs',
    'OceanLaunchSpecStrategyArgsDict',
    'OceanLaunchSpecTagArgs',
    'OceanLaunchSpecTagArgsDict',
    'OceanLoggingArgs',
    'OceanLoggingArgsDict',
    'OceanLoggingExportArgs',
    'OceanLoggingExportArgsDict',
    'OceanLoggingExportS3Args',
    'OceanLoggingExportS3ArgsDict',
    'OceanOptimizeImagesArgs',
    'OceanOptimizeImagesArgsDict',
    'OceanScheduledTaskArgs',
    'OceanScheduledTaskArgsDict',
    'OceanScheduledTaskShutdownHoursArgs',
    'OceanScheduledTaskShutdownHoursArgsDict',
    'OceanScheduledTaskTaskArgs',
    'OceanScheduledTaskTaskArgsDict',
    'OceanTagArgs',
    'OceanTagArgsDict',
    'OceanUpdatePolicyArgs',
    'OceanUpdatePolicyArgsDict',
    'OceanUpdatePolicyRollConfigArgs',
    'OceanUpdatePolicyRollConfigArgsDict',
]

MYPY = False

if not MYPY:
    class OceanAutoscalerArgsDict(TypedDict):
        auto_headroom_percentage: NotRequired[pulumi.Input[_builtins.int]]
        """
        The auto-headroom percentage. Set a number between 0-200 to control the headroom % of the cluster. Relevant when `isAutoConfig`= true.
        """
        cooldown: NotRequired[pulumi.Input[_builtins.int]]
        """
        Cooldown period between scaling actions.
        """
        down: NotRequired[pulumi.Input['OceanAutoscalerDownArgsDict']]
        """
        Auto Scaling scale down operations.
        """
        enable_automatic_and_manual_headroom: NotRequired[pulumi.Input[_builtins.bool]]
        """
        When set to true, both automatic and per custom launch specification manual headroom to be saved concurrently and independently in the cluster. prerequisite: isAutoConfig must be true
        """
        headroom: NotRequired[pulumi.Input['OceanAutoscalerHeadroomArgsDict']]
        """
        Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        """
        is_auto_config: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Automatically configure and optimize headroom resources.
        """
        is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Enable the Ocean ECS autoscaler.
        """
        resource_limits: NotRequired[pulumi.Input['OceanAutoscalerResourceLimitsArgsDict']]
        """
        Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        should_scale_down_non_service_tasks: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Option to scale down non-service tasks. If not set, Ocean does not scale down standalone tasks.
        """
elif False:
    OceanAutoscalerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanAutoscalerArgs:
    def __init__(__self__, *,
                 auto_headroom_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 down: Optional[pulumi.Input['OceanAutoscalerDownArgs']] = None,
                 enable_automatic_and_manual_headroom: Optional[pulumi.Input[_builtins.bool]] = None,
                 headroom: Optional[pulumi.Input['OceanAutoscalerHeadroomArgs']] = None,
                 is_auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_limits: Optional[pulumi.Input['OceanAutoscalerResourceLimitsArgs']] = None,
                 should_scale_down_non_service_tasks: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.int] auto_headroom_percentage: The auto-headroom percentage. Set a number between 0-200 to control the headroom % of the cluster. Relevant when `isAutoConfig`= true.
        :param pulumi.Input[_builtins.int] cooldown: Cooldown period between scaling actions.
        :param pulumi.Input['OceanAutoscalerDownArgs'] down: Auto Scaling scale down operations.
        :param pulumi.Input[_builtins.bool] enable_automatic_and_manual_headroom: When set to true, both automatic and per custom launch specification manual headroom to be saved concurrently and independently in the cluster. prerequisite: isAutoConfig must be true
        :param pulumi.Input['OceanAutoscalerHeadroomArgs'] headroom: Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        :param pulumi.Input[_builtins.bool] is_auto_config: Automatically configure and optimize headroom resources.
        :param pulumi.Input[_builtins.bool] is_enabled: Enable the Ocean ECS autoscaler.
        :param pulumi.Input['OceanAutoscalerResourceLimitsArgs'] resource_limits: Optionally set upper and lower bounds on the resource usage of the cluster.
        :param pulumi.Input[_builtins.bool] should_scale_down_non_service_tasks: Option to scale down non-service tasks. If not set, Ocean does not scale down standalone tasks.
        """
        if auto_headroom_percentage is not None:
            pulumi.set(__self__, "auto_headroom_percentage", auto_headroom_percentage)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if down is not None:
            pulumi.set(__self__, "down", down)
        if enable_automatic_and_manual_headroom is not None:
            pulumi.set(__self__, "enable_automatic_and_manual_headroom", enable_automatic_and_manual_headroom)
        if headroom is not None:
            pulumi.set(__self__, "headroom", headroom)
        if is_auto_config is not None:
            pulumi.set(__self__, "is_auto_config", is_auto_config)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if resource_limits is not None:
            pulumi.set(__self__, "resource_limits", resource_limits)
        if should_scale_down_non_service_tasks is not None:
            pulumi.set(__self__, "should_scale_down_non_service_tasks", should_scale_down_non_service_tasks)

    @_builtins.property
    @pulumi.getter(name="autoHeadroomPercentage")
    def auto_headroom_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The auto-headroom percentage. Set a number between 0-200 to control the headroom % of the cluster. Relevant when `isAutoConfig`= true.
        """
        return pulumi.get(self, "auto_headroom_percentage")

    @auto_headroom_percentage.setter
    def auto_headroom_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_headroom_percentage", value)

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Cooldown period between scaling actions.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooldown", value)

    @_builtins.property
    @pulumi.getter
    def down(self) -> Optional[pulumi.Input['OceanAutoscalerDownArgs']]:
        """
        Auto Scaling scale down operations.
        """
        return pulumi.get(self, "down")

    @down.setter
    def down(self, value: Optional[pulumi.Input['OceanAutoscalerDownArgs']]):
        pulumi.set(self, "down", value)

    @_builtins.property
    @pulumi.getter(name="enableAutomaticAndManualHeadroom")
    def enable_automatic_and_manual_headroom(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, both automatic and per custom launch specification manual headroom to be saved concurrently and independently in the cluster. prerequisite: isAutoConfig must be true
        """
        return pulumi.get(self, "enable_automatic_and_manual_headroom")

    @enable_automatic_and_manual_headroom.setter
    def enable_automatic_and_manual_headroom(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_automatic_and_manual_headroom", value)

    @_builtins.property
    @pulumi.getter
    def headroom(self) -> Optional[pulumi.Input['OceanAutoscalerHeadroomArgs']]:
        """
        Spare resource capacity management enabling fast assignment of tasks without waiting for new resources to launch.
        """
        return pulumi.get(self, "headroom")

    @headroom.setter
    def headroom(self, value: Optional[pulumi.Input['OceanAutoscalerHeadroomArgs']]):
        pulumi.set(self, "headroom", value)

    @_builtins.property
    @pulumi.getter(name="isAutoConfig")
    def is_auto_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically configure and optimize headroom resources.
        """
        return pulumi.get(self, "is_auto_config")

    @is_auto_config.setter
    def is_auto_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_auto_config", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the Ocean ECS autoscaler.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Optional[pulumi.Input['OceanAutoscalerResourceLimitsArgs']]:
        """
        Optionally set upper and lower bounds on the resource usage of the cluster.
        """
        return pulumi.get(self, "resource_limits")

    @resource_limits.setter
    def resource_limits(self, value: Optional[pulumi.Input['OceanAutoscalerResourceLimitsArgs']]):
        pulumi.set(self, "resource_limits", value)

    @_builtins.property
    @pulumi.getter(name="shouldScaleDownNonServiceTasks")
    def should_scale_down_non_service_tasks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Option to scale down non-service tasks. If not set, Ocean does not scale down standalone tasks.
        """
        return pulumi.get(self, "should_scale_down_non_service_tasks")

    @should_scale_down_non_service_tasks.setter
    def should_scale_down_non_service_tasks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_scale_down_non_service_tasks", value)


if not MYPY:
    class OceanAutoscalerDownArgsDict(TypedDict):
        max_scale_down_percentage: NotRequired[pulumi.Input[_builtins.float]]
        """
        Would represent the maximum % to scale-down. Number between 1-100.
        """
elif False:
    OceanAutoscalerDownArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanAutoscalerDownArgs:
    def __init__(__self__, *,
                 max_scale_down_percentage: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.float] max_scale_down_percentage: Would represent the maximum % to scale-down. Number between 1-100.
        """
        if max_scale_down_percentage is not None:
            pulumi.set(__self__, "max_scale_down_percentage", max_scale_down_percentage)

    @_builtins.property
    @pulumi.getter(name="maxScaleDownPercentage")
    def max_scale_down_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Would represent the maximum % to scale-down. Number between 1-100.
        """
        return pulumi.get(self, "max_scale_down_percentage")

    @max_scale_down_percentage.setter
    def max_scale_down_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_scale_down_percentage", value)


if not MYPY:
    class OceanAutoscalerHeadroomArgsDict(TypedDict):
        cpu_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        memory_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the amount of memory (MB) to allocate the headroom.
        """
        num_of_units: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
elif False:
    OceanAutoscalerHeadroomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanAutoscalerHeadroomArgs:
    def __init__(__self__, *,
                 cpu_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 num_of_units: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] cpu_per_unit: Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param pulumi.Input[_builtins.int] memory_per_unit: Optionally configure the amount of memory (MB) to allocate the headroom.
        :param pulumi.Input[_builtins.int] num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @_builtins.property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the number of CPUs to allocate the headroom. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the amount of memory (MB) to allocate the headroom.
        """
        return pulumi.get(self, "memory_per_unit")

    @memory_per_unit.setter
    def memory_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")

    @num_of_units.setter
    def num_of_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_of_units", value)


if not MYPY:
    class OceanAutoscalerResourceLimitsArgsDict(TypedDict):
        max_memory_gib: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum memory in GiB units that can be allocated to the cluster.
        """
        max_vcpu: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum cpu in vCPU units that can be allocated to the cluster.
        """
elif False:
    OceanAutoscalerResourceLimitsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanAutoscalerResourceLimitsArgs:
    def __init__(__self__, *,
                 max_memory_gib: Optional[pulumi.Input[_builtins.int]] = None,
                 max_vcpu: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] max_memory_gib: The maximum memory in GiB units that can be allocated to the cluster.
        :param pulumi.Input[_builtins.int] max_vcpu: The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)

    @_builtins.property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum memory in GiB units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_memory_gib")

    @max_memory_gib.setter
    def max_memory_gib(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_memory_gib", value)

    @_builtins.property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum cpu in vCPU units that can be allocated to the cluster.
        """
        return pulumi.get(self, "max_vcpu")

    @max_vcpu.setter
    def max_vcpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_vcpu", value)


if not MYPY:
    class OceanBlockDeviceMappingArgsDict(TypedDict):
        device_name: pulumi.Input[_builtins.str]
        """
        String. Set device name. Example: `/dev/xvda1`.
        """
        ebs: NotRequired[pulumi.Input['OceanBlockDeviceMappingEbsArgsDict']]
        """
        Object. Set Elastic Block Store properties.
        """
        no_device: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        virtual_name: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    OceanBlockDeviceMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[_builtins.str],
                 ebs: Optional[pulumi.Input['OceanBlockDeviceMappingEbsArgs']] = None,
                 no_device: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] device_name: String. Set device name. Example: `/dev/xvda1`.
        :param pulumi.Input['OceanBlockDeviceMappingEbsArgs'] ebs: Object. Set Elastic Block Store properties.
        :param pulumi.Input[_builtins.str] no_device: String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[_builtins.str]:
        """
        String. Set device name. Example: `/dev/xvda1`.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "device_name", value)

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['OceanBlockDeviceMappingEbsArgs']]:
        """
        Object. Set Elastic Block Store properties.
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['OceanBlockDeviceMappingEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @_builtins.property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. Suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_device", value)

    @_builtins.property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_name", value)


if not MYPY:
    class OceanBlockDeviceMappingEbsArgsDict(TypedDict):
        delete_on_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean. Toggles EBS deletion upon instance termination.
        """
        dynamic_volume_size: NotRequired[pulumi.Input['OceanBlockDeviceMappingEbsDynamicVolumeSizeArgsDict']]
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        snapshot_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional) String. The snapshot ID to mount by.
        """
        throughput: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Int. The size (in GB) of the volume.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. The type of the volume. Example: `gp2`.
        """
elif False:
    OceanBlockDeviceMappingEbsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanBlockDeviceMappingEbsArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_volume_size: Optional[pulumi.Input['OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs']] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] delete_on_termination: Boolean. Toggles EBS deletion upon instance termination.
        :param pulumi.Input['OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs'] dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param pulumi.Input[_builtins.bool] encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param pulumi.Input[_builtins.int] iops: Int. The number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[_builtins.str] kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param pulumi.Input[_builtins.str] snapshot_id: (Optional) String. The snapshot ID to mount by.
        :param pulumi.Input[_builtins.int] throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        :param pulumi.Input[_builtins.int] volume_size: Int. The size (in GB) of the volume.
        :param pulumi.Input[_builtins.str] volume_type: String. The type of the volume. Example: `gp2`.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. Toggles EBS deletion upon instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @_builtins.property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional[pulumi.Input['OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs']]:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @dynamic_volume_size.setter
    def dynamic_volume_size(self, value: Optional[pulumi.Input['OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs']]):
        pulumi.set(self, "dynamic_volume_size", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional) String. The snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Int. The size (in GB) of the volume.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. The type of the volume. Example: `gp2`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class OceanBlockDeviceMappingEbsDynamicVolumeSizeArgsDict(TypedDict):
        base_size: pulumi.Input[_builtins.int]
        """
        Int. Initial size for volume. Example: `50`.
        """
        resource: pulumi.Input[_builtins.str]
        """
        String. Resource type to increase volume size dynamically by. Valid values: `CPU`.
        """
        size_per_resource_unit: pulumi.Input[_builtins.int]
        """
        Int. Additional size (in GB) per resource unit. Example: When the `baseSize=50`, `sizePerResourceUnit=20`, and instance with two CPUs is launched, its total disk size will be: 90GB.
        """
elif False:
    OceanBlockDeviceMappingEbsDynamicVolumeSizeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanBlockDeviceMappingEbsDynamicVolumeSizeArgs:
    def __init__(__self__, *,
                 base_size: pulumi.Input[_builtins.int],
                 resource: pulumi.Input[_builtins.str],
                 size_per_resource_unit: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] base_size: Int. Initial size for volume. Example: `50`.
        :param pulumi.Input[_builtins.str] resource: String. Resource type to increase volume size dynamically by. Valid values: `CPU`.
        :param pulumi.Input[_builtins.int] size_per_resource_unit: Int. Additional size (in GB) per resource unit. Example: When the `baseSize=50`, `sizePerResourceUnit=20`, and instance with two CPUs is launched, its total disk size will be: 90GB.
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @_builtins.property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> pulumi.Input[_builtins.int]:
        """
        Int. Initial size for volume. Example: `50`.
        """
        return pulumi.get(self, "base_size")

    @base_size.setter
    def base_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "base_size", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Input[_builtins.str]:
        """
        String. Resource type to increase volume size dynamically by. Valid values: `CPU`.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> pulumi.Input[_builtins.int]:
        """
        Int. Additional size (in GB) per resource unit. Example: When the `baseSize=50`, `sizePerResourceUnit=20`, and instance with two CPUs is launched, its total disk size will be: 90GB.
        """
        return pulumi.get(self, "size_per_resource_unit")

    @size_per_resource_unit.setter
    def size_per_resource_unit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_per_resource_unit", value)


if not MYPY:
    class OceanClusterOrientationArgsDict(TypedDict):
        availability_vs_cost: NotRequired[pulumi.Input[_builtins.str]]
        """
        You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
elif False:
    OceanClusterOrientationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanClusterOrientationArgs:
    def __init__(__self__, *,
                 availability_vs_cost: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] availability_vs_cost: You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        if availability_vs_cost is not None:
            pulumi.set(__self__, "availability_vs_cost", availability_vs_cost)

    @_builtins.property
    @pulumi.getter(name="availabilityVsCost")
    def availability_vs_cost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        You can control the approach that Ocean takes while launching nodes by configuring this value. Possible values: `costOriented`,`balanced`,`cheapest`.
        """
        return pulumi.get(self, "availability_vs_cost")

    @availability_vs_cost.setter
    def availability_vs_cost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_vs_cost", value)


if not MYPY:
    class OceanFiltersArgsDict(TypedDict):
        architectures: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will support at least one of the architectures from this list.
        """
        categories: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will belong to one of the categories types from this list.
        """
        disk_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will have one of the disk type from this list.
        """
        exclude_families: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        """
        exclude_metal: NotRequired[pulumi.Input[_builtins.bool]]
        """
        In case excludeMetal is set to true, metal types will not be available for scaling.
        """
        hypervisors: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will have a hypervisor type from this list.
        """
        include_families: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        """
        is_ena_supported: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ena is supported or not.
        """
        max_gpu: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum total number of GPUs.
        """
        max_memory_gib: NotRequired[pulumi.Input[_builtins.float]]
        max_network_performance: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum Bandwidth in Gib/s of network performance.
        """
        max_vcpu: NotRequired[pulumi.Input[_builtins.int]]
        min_enis: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of network interfaces (ENIs).
        """
        min_gpu: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum total number of GPUs.
        """
        min_memory_gib: NotRequired[pulumi.Input[_builtins.float]]
        """
        Minimum amount of Memory (GiB).
        """
        min_network_performance: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum Bandwidth in Gib/s of network performance.
        """
        min_vcpu: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum number of vcpus available.
        """
        root_device_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will have a root device types from this list.
        """
        virtualization_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The filtered instance types will support at least one of the virtualization types from this list.
        """
elif False:
    OceanFiltersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanFiltersArgs:
    def __init__(__self__, *,
                 architectures: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 disk_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_families: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 exclude_metal: Optional[pulumi.Input[_builtins.bool]] = None,
                 hypervisors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 include_families: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_ena_supported: Optional[pulumi.Input[_builtins.str]] = None,
                 max_gpu: Optional[pulumi.Input[_builtins.int]] = None,
                 max_memory_gib: Optional[pulumi.Input[_builtins.float]] = None,
                 max_network_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 max_vcpu: Optional[pulumi.Input[_builtins.int]] = None,
                 min_enis: Optional[pulumi.Input[_builtins.int]] = None,
                 min_gpu: Optional[pulumi.Input[_builtins.int]] = None,
                 min_memory_gib: Optional[pulumi.Input[_builtins.float]] = None,
                 min_network_performance: Optional[pulumi.Input[_builtins.int]] = None,
                 min_vcpu: Optional[pulumi.Input[_builtins.int]] = None,
                 root_device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtualization_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] architectures: The filtered instance types will support at least one of the architectures from this list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] categories: The filtered instance types will belong to one of the categories types from this list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_types: The filtered instance types will have one of the disk type from this list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_families: Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        :param pulumi.Input[_builtins.bool] exclude_metal: In case excludeMetal is set to true, metal types will not be available for scaling.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] hypervisors: The filtered instance types will have a hypervisor type from this list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] include_families: Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        :param pulumi.Input[_builtins.str] is_ena_supported: Ena is supported or not.
        :param pulumi.Input[_builtins.int] max_gpu: Maximum total number of GPUs.
        :param pulumi.Input[_builtins.int] max_network_performance: Maximum Bandwidth in Gib/s of network performance.
        :param pulumi.Input[_builtins.int] min_enis: Minimum number of network interfaces (ENIs).
        :param pulumi.Input[_builtins.int] min_gpu: Minimum total number of GPUs.
        :param pulumi.Input[_builtins.float] min_memory_gib: Minimum amount of Memory (GiB).
        :param pulumi.Input[_builtins.int] min_network_performance: Minimum Bandwidth in Gib/s of network performance.
        :param pulumi.Input[_builtins.int] min_vcpu: Minimum number of vcpus available.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] root_device_types: The filtered instance types will have a root device types from this list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] virtualization_types: The filtered instance types will support at least one of the virtualization types from this list.
        """
        if architectures is not None:
            pulumi.set(__self__, "architectures", architectures)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if disk_types is not None:
            pulumi.set(__self__, "disk_types", disk_types)
        if exclude_families is not None:
            pulumi.set(__self__, "exclude_families", exclude_families)
        if exclude_metal is not None:
            pulumi.set(__self__, "exclude_metal", exclude_metal)
        if hypervisors is not None:
            pulumi.set(__self__, "hypervisors", hypervisors)
        if include_families is not None:
            pulumi.set(__self__, "include_families", include_families)
        if is_ena_supported is not None:
            pulumi.set(__self__, "is_ena_supported", is_ena_supported)
        if max_gpu is not None:
            pulumi.set(__self__, "max_gpu", max_gpu)
        if max_memory_gib is not None:
            pulumi.set(__self__, "max_memory_gib", max_memory_gib)
        if max_network_performance is not None:
            pulumi.set(__self__, "max_network_performance", max_network_performance)
        if max_vcpu is not None:
            pulumi.set(__self__, "max_vcpu", max_vcpu)
        if min_enis is not None:
            pulumi.set(__self__, "min_enis", min_enis)
        if min_gpu is not None:
            pulumi.set(__self__, "min_gpu", min_gpu)
        if min_memory_gib is not None:
            pulumi.set(__self__, "min_memory_gib", min_memory_gib)
        if min_network_performance is not None:
            pulumi.set(__self__, "min_network_performance", min_network_performance)
        if min_vcpu is not None:
            pulumi.set(__self__, "min_vcpu", min_vcpu)
        if root_device_types is not None:
            pulumi.set(__self__, "root_device_types", root_device_types)
        if virtualization_types is not None:
            pulumi.set(__self__, "virtualization_types", virtualization_types)

    @_builtins.property
    @pulumi.getter
    def architectures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will support at least one of the architectures from this list.
        """
        return pulumi.get(self, "architectures")

    @architectures.setter
    def architectures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "architectures", value)

    @_builtins.property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will belong to one of the categories types from this list.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "categories", value)

    @_builtins.property
    @pulumi.getter(name="diskTypes")
    def disk_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will have one of the disk type from this list.
        """
        return pulumi.get(self, "disk_types")

    @disk_types.setter
    def disk_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_types", value)

    @_builtins.property
    @pulumi.getter(name="excludeFamilies")
    def exclude_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Types belonging to a family from the ExcludeFamilies will not be available for scaling (asterisk wildcard is also supported). For example, C* will exclude instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "exclude_families")

    @exclude_families.setter
    def exclude_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_families", value)

    @_builtins.property
    @pulumi.getter(name="excludeMetal")
    def exclude_metal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        In case excludeMetal is set to true, metal types will not be available for scaling.
        """
        return pulumi.get(self, "exclude_metal")

    @exclude_metal.setter
    def exclude_metal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "exclude_metal", value)

    @_builtins.property
    @pulumi.getter
    def hypervisors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will have a hypervisor type from this list.
        """
        return pulumi.get(self, "hypervisors")

    @hypervisors.setter
    def hypervisors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hypervisors", value)

    @_builtins.property
    @pulumi.getter(name="includeFamilies")
    def include_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Types belonging to a family from the IncludeFamilies will be available for scaling (asterisk wildcard is also supported). For example, C* will include instance types from these families: c5, c4, c4a, etc.
        """
        return pulumi.get(self, "include_families")

    @include_families.setter
    def include_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "include_families", value)

    @_builtins.property
    @pulumi.getter(name="isEnaSupported")
    def is_ena_supported(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ena is supported or not.
        """
        return pulumi.get(self, "is_ena_supported")

    @is_ena_supported.setter
    def is_ena_supported(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "is_ena_supported", value)

    @_builtins.property
    @pulumi.getter(name="maxGpu")
    def max_gpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum total number of GPUs.
        """
        return pulumi.get(self, "max_gpu")

    @max_gpu.setter
    def max_gpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_gpu", value)

    @_builtins.property
    @pulumi.getter(name="maxMemoryGib")
    def max_memory_gib(self) -> Optional[pulumi.Input[_builtins.float]]:
        return pulumi.get(self, "max_memory_gib")

    @max_memory_gib.setter
    def max_memory_gib(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_memory_gib", value)

    @_builtins.property
    @pulumi.getter(name="maxNetworkPerformance")
    def max_network_performance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "max_network_performance")

    @max_network_performance.setter
    def max_network_performance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_network_performance", value)

    @_builtins.property
    @pulumi.getter(name="maxVcpu")
    def max_vcpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "max_vcpu")

    @max_vcpu.setter
    def max_vcpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_vcpu", value)

    @_builtins.property
    @pulumi.getter(name="minEnis")
    def min_enis(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of network interfaces (ENIs).
        """
        return pulumi.get(self, "min_enis")

    @min_enis.setter
    def min_enis(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_enis", value)

    @_builtins.property
    @pulumi.getter(name="minGpu")
    def min_gpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum total number of GPUs.
        """
        return pulumi.get(self, "min_gpu")

    @min_gpu.setter
    def min_gpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_gpu", value)

    @_builtins.property
    @pulumi.getter(name="minMemoryGib")
    def min_memory_gib(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Minimum amount of Memory (GiB).
        """
        return pulumi.get(self, "min_memory_gib")

    @min_memory_gib.setter
    def min_memory_gib(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "min_memory_gib", value)

    @_builtins.property
    @pulumi.getter(name="minNetworkPerformance")
    def min_network_performance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum Bandwidth in Gib/s of network performance.
        """
        return pulumi.get(self, "min_network_performance")

    @min_network_performance.setter
    def min_network_performance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_network_performance", value)

    @_builtins.property
    @pulumi.getter(name="minVcpu")
    def min_vcpu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of vcpus available.
        """
        return pulumi.get(self, "min_vcpu")

    @min_vcpu.setter
    def min_vcpu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_vcpu", value)

    @_builtins.property
    @pulumi.getter(name="rootDeviceTypes")
    def root_device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will have a root device types from this list.
        """
        return pulumi.get(self, "root_device_types")

    @root_device_types.setter
    def root_device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "root_device_types", value)

    @_builtins.property
    @pulumi.getter(name="virtualizationTypes")
    def virtualization_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The filtered instance types will support at least one of the virtualization types from this list.
        """
        return pulumi.get(self, "virtualization_types")

    @virtualization_types.setter
    def virtualization_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtualization_types", value)


if not MYPY:
    class OceanInstanceMetadataOptionsArgsDict(TypedDict):
        http_tokens: pulumi.Input[_builtins.str]
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        http_put_response_hop_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
elif False:
    OceanInstanceMetadataOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanInstanceMetadataOptionsArgs:
    def __init__(__self__, *,
                 http_tokens: pulumi.Input[_builtins.str],
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> pulumi.Input[_builtins.str]:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)


if not MYPY:
    class OceanLaunchSpecAttributeArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The label key.
        """
        value: pulumi.Input[_builtins.str]
        """
        The label value.
        """
elif False:
    OceanLaunchSpecAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecAttributeArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: The label key.
        :param pulumi.Input[_builtins.str] value: The label value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class OceanLaunchSpecAutoscaleHeadroomArgsDict(TypedDict):
        num_of_units: pulumi.Input[_builtins.int]
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        cpu_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
        """
        memory_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
elif False:
    OceanLaunchSpecAutoscaleHeadroomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecAutoscaleHeadroomArgs:
    def __init__(__self__, *,
                 num_of_units: pulumi.Input[_builtins.int],
                 cpu_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_per_unit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        :param pulumi.Input[_builtins.int] cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
        :param pulumi.Input[_builtins.int] memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @_builtins.property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> pulumi.Input[_builtins.int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU and memory.
        """
        return pulumi.get(self, "num_of_units")

    @num_of_units.setter
    def num_of_units(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_of_units", value)

    @_builtins.property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in CPU units, where 1024 units = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")

    @memory_per_unit.setter
    def memory_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_per_unit", value)


if not MYPY:
    class OceanLaunchSpecBlockDeviceMappingArgsDict(TypedDict):
        device_name: pulumi.Input[_builtins.str]
        """
        String. Set device name. (Example: "/dev/xvda1").
        """
        ebs: NotRequired[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsArgsDict']]
        """
        Object. Set Elastic Block Store properties .
        """
        no_device: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. suppresses the specified device included in the block device mapping of the AMI.
        """
        virtual_name: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    OceanLaunchSpecBlockDeviceMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecBlockDeviceMappingArgs:
    def __init__(__self__, *,
                 device_name: pulumi.Input[_builtins.str],
                 ebs: Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsArgs']] = None,
                 no_device: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] device_name: String. Set device name. (Example: "/dev/xvda1").
        :param pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsArgs'] ebs: Object. Set Elastic Block Store properties .
        :param pulumi.Input[_builtins.str] no_device: String. suppresses the specified device included in the block device mapping of the AMI.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> pulumi.Input[_builtins.str]:
        """
        String. Set device name. (Example: "/dev/xvda1").
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "device_name", value)

    @_builtins.property
    @pulumi.getter
    def ebs(self) -> Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsArgs']]:
        """
        Object. Set Elastic Block Store properties .
        """
        return pulumi.get(self, "ebs")

    @ebs.setter
    def ebs(self, value: Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsArgs']]):
        pulumi.set(self, "ebs", value)

    @_builtins.property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @no_device.setter
    def no_device(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_device", value)

    @_builtins.property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_name")

    @virtual_name.setter
    def virtual_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_name", value)


if not MYPY:
    class OceanLaunchSpecBlockDeviceMappingEbsArgsDict(TypedDict):
        delete_on_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean. Flag to delete the EBS on instance termination.
        """
        dynamic_volume_size: NotRequired[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgsDict']]
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        encrypted: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        snapshot_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional) String. The Snapshot ID to mount by.
        """
        throughput: NotRequired[pulumi.Input[_builtins.int]]
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        volume_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Int. The size, in GB of the volume.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        String. The type of the volume (example: "gp2").
        """
elif False:
    OceanLaunchSpecBlockDeviceMappingEbsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecBlockDeviceMappingEbsArgs:
    def __init__(__self__, *,
                 delete_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 dynamic_volume_size: Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs']] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_size: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] delete_on_termination: Boolean. Flag to delete the EBS on instance termination.
        :param pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs'] dynamic_volume_size: Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        :param pulumi.Input[_builtins.bool] encrypted: Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        :param pulumi.Input[_builtins.int] iops: Int. The number of I/O operations per second (IOPS) that the volume supports.
        :param pulumi.Input[_builtins.str] kms_key_id: String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        :param pulumi.Input[_builtins.str] snapshot_id: (Optional) String. The Snapshot ID to mount by.
        :param pulumi.Input[_builtins.int] throughput: The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        :param pulumi.Input[_builtins.int] volume_size: Int. The size, in GB of the volume.
        :param pulumi.Input[_builtins.str] volume_type: String. The type of the volume (example: "gp2").
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if dynamic_volume_size is not None:
            pulumi.set(__self__, "dynamic_volume_size", dynamic_volume_size)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. Flag to delete the EBS on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @_builtins.property
    @pulumi.getter(name="dynamicVolumeSize")
    def dynamic_volume_size(self) -> Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs']]:
        """
        Object. Set dynamic volume size properties. When using this object, you cannot use volumeSize. You must use one or the other.
        """
        return pulumi.get(self, "dynamic_volume_size")

    @dynamic_volume_size.setter
    def dynamic_volume_size(self, value: Optional[pulumi.Input['OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs']]):
        pulumi.set(self, "dynamic_volume_size", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean. Enables [EBS encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) on the volume.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Int. The number of I/O operations per second (IOPS) that the volume supports.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. Identifier (key ID, key alias, ID ARN, or alias ARN) for a customer managed CMK under which the EBS volume is encrypted.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional) String. The Snapshot ID to mount by.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of data transferred to or from a storage device per second, you can use this param just in a case that `volume_type` = gp3.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)

    @_builtins.property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Int. The size, in GB of the volume.
        """
        return pulumi.get(self, "volume_size")

    @volume_size.setter
    def volume_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "volume_size", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String. The type of the volume (example: "gp2").
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgsDict(TypedDict):
        base_size: pulumi.Input[_builtins.int]
        """
        Int. Initial size for volume. (Example: 50)
        """
        resource: pulumi.Input[_builtins.str]
        """
        String. Resource type to increase volume size dynamically by. (valid values: "CPU")
        """
        size_per_resource_unit: pulumi.Input[_builtins.int]
        """
        Int. Additional size (in GB) per resource unit. (Example: baseSize= 50, sizePerResourceUnit=20, and instance with 2 CPU is launched - its total disk size will be: 90GB)
        """
elif False:
    OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecBlockDeviceMappingEbsDynamicVolumeSizeArgs:
    def __init__(__self__, *,
                 base_size: pulumi.Input[_builtins.int],
                 resource: pulumi.Input[_builtins.str],
                 size_per_resource_unit: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] base_size: Int. Initial size for volume. (Example: 50)
        :param pulumi.Input[_builtins.str] resource: String. Resource type to increase volume size dynamically by. (valid values: "CPU")
        :param pulumi.Input[_builtins.int] size_per_resource_unit: Int. Additional size (in GB) per resource unit. (Example: baseSize= 50, sizePerResourceUnit=20, and instance with 2 CPU is launched - its total disk size will be: 90GB)
        """
        pulumi.set(__self__, "base_size", base_size)
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "size_per_resource_unit", size_per_resource_unit)

    @_builtins.property
    @pulumi.getter(name="baseSize")
    def base_size(self) -> pulumi.Input[_builtins.int]:
        """
        Int. Initial size for volume. (Example: 50)
        """
        return pulumi.get(self, "base_size")

    @base_size.setter
    def base_size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "base_size", value)

    @_builtins.property
    @pulumi.getter
    def resource(self) -> pulumi.Input[_builtins.str]:
        """
        String. Resource type to increase volume size dynamically by. (valid values: "CPU")
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource", value)

    @_builtins.property
    @pulumi.getter(name="sizePerResourceUnit")
    def size_per_resource_unit(self) -> pulumi.Input[_builtins.int]:
        """
        Int. Additional size (in GB) per resource unit. (Example: baseSize= 50, sizePerResourceUnit=20, and instance with 2 CPU is launched - its total disk size will be: 90GB)
        """
        return pulumi.get(self, "size_per_resource_unit")

    @size_per_resource_unit.setter
    def size_per_resource_unit(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_per_resource_unit", value)


if not MYPY:
    class OceanLaunchSpecImageArgsDict(TypedDict):
        image_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
elif False:
    OceanLaunchSpecImageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecImageArgs:
    def __init__(__self__, *,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] image_id: Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the image in AWS. Valid values: any string which is not empty or null.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)


if not MYPY:
    class OceanLaunchSpecInstanceMetadataOptionsArgsDict(TypedDict):
        http_tokens: pulumi.Input[_builtins.str]
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        http_put_response_hop_limit: NotRequired[pulumi.Input[_builtins.int]]
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
elif False:
    OceanLaunchSpecInstanceMetadataOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecInstanceMetadataOptionsArgs:
    def __init__(__self__, *,
                 http_tokens: pulumi.Input[_builtins.str],
                 http_put_response_hop_limit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] http_tokens: Determines if a signed token is required or not. Valid values: `optional` or `required`.
        :param pulumi.Input[_builtins.int] http_put_response_hop_limit: An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        pulumi.set(__self__, "http_tokens", http_tokens)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)

    @_builtins.property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> pulumi.Input[_builtins.str]:
        """
        Determines if a signed token is required or not. Valid values: `optional` or `required`.
        """
        return pulumi.get(self, "http_tokens")

    @http_tokens.setter
    def http_tokens(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "http_tokens", value)

    @_builtins.property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer from 1 through 64. The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further the instance metadata requests can travel.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @http_put_response_hop_limit.setter
    def http_put_response_hop_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "http_put_response_hop_limit", value)


if not MYPY:
    class OceanLaunchSpecSchedulingTaskArgsDict(TypedDict):
        cron_expression: pulumi.Input[_builtins.str]
        """
        A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        """
        is_enabled: pulumi.Input[_builtins.bool]
        """
        Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        """
        task_type: pulumi.Input[_builtins.str]
        """
        The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        """
        task_headrooms: NotRequired[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskTaskHeadroomArgsDict']]]]
        """
        The config of this scheduled task. Depends on the value of taskType.
        """
elif False:
    OceanLaunchSpecSchedulingTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecSchedulingTaskArgs:
    def __init__(__self__, *,
                 cron_expression: pulumi.Input[_builtins.str],
                 is_enabled: pulumi.Input[_builtins.bool],
                 task_type: pulumi.Input[_builtins.str],
                 task_headrooms: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] cron_expression: A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        :param pulumi.Input[_builtins.bool] is_enabled: Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        :param pulumi.Input[_builtins.str] task_type: The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        :param pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs']]] task_headrooms: The config of this scheduled task. Depends on the value of taskType.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)
        if task_headrooms is not None:
            pulumi.set(__self__, "task_headrooms", task_headrooms)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> pulumi.Input[_builtins.str]:
        """
        A valid cron expression. For example : " * * * * * ". The cron job runs in UTC time and is in Unix cron format.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Describes whether the task is enabled. When `true`, the task runs. When `false`, it does not run.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        The activity that you are scheduling. Valid values: "manualHeadroomUpdate".
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="taskHeadrooms")
    def task_headrooms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs']]]]:
        """
        The config of this scheduled task. Depends on the value of taskType.
        """
        return pulumi.get(self, "task_headrooms")

    @task_headrooms.setter
    def task_headrooms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLaunchSpecSchedulingTaskTaskHeadroomArgs']]]]):
        pulumi.set(self, "task_headrooms", value)


if not MYPY:
    class OceanLaunchSpecSchedulingTaskTaskHeadroomArgsDict(TypedDict):
        num_of_units: pulumi.Input[_builtins.int]
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        """
        cpu_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        memory_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
elif False:
    OceanLaunchSpecSchedulingTaskTaskHeadroomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecSchedulingTaskTaskHeadroomArgs:
    def __init__(__self__, *,
                 num_of_units: pulumi.Input[_builtins.int],
                 cpu_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_per_unit: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] num_of_units: The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        :param pulumi.Input[_builtins.int] cpu_per_unit: Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        :param pulumi.Input[_builtins.int] memory_per_unit: Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        pulumi.set(__self__, "num_of_units", num_of_units)
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)

    @_builtins.property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> pulumi.Input[_builtins.int]:
        """
        The number of units to retain as headroom, where each unit has the defined headroom CPU, memory and GPU.
        """
        return pulumi.get(self, "num_of_units")

    @num_of_units.setter
    def num_of_units(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "num_of_units", value)

    @_builtins.property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the number of CPUs to allocate for each headroom unit. CPUs are denoted in millicores, where 1000 millicores = 1 vCPU.
        """
        return pulumi.get(self, "cpu_per_unit")

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optionally configure the amount of memory (MiB) to allocate for each headroom unit.
        """
        return pulumi.get(self, "memory_per_unit")

    @memory_per_unit.setter
    def memory_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_per_unit", value)


if not MYPY:
    class OceanLaunchSpecStrategyArgsDict(TypedDict):
        spot_percentage: NotRequired[pulumi.Input[_builtins.int]]
        """
        When set, Ocean will proactively try to maintain as close as possible to the percentage of Spot instances out of all the Virtual Node Group instances.
        """
elif False:
    OceanLaunchSpecStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecStrategyArgs:
    def __init__(__self__, *,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] spot_percentage: When set, Ocean will proactively try to maintain as close as possible to the percentage of Spot instances out of all the Virtual Node Group instances.
        """
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When set, Ocean will proactively try to maintain as close as possible to the percentage of Spot instances out of all the Virtual Node Group instances.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_percentage", value)


if not MYPY:
    class OceanLaunchSpecTagArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The label key.
        """
        value: pulumi.Input[_builtins.str]
        """
        The label value.
        """
elif False:
    OceanLaunchSpecTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLaunchSpecTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: The label key.
        :param pulumi.Input[_builtins.str] value: The label value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The label value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class OceanLoggingArgsDict(TypedDict):
        export: NotRequired[pulumi.Input['OceanLoggingExportArgsDict']]
        """
        Logging Export configuration.
        """
elif False:
    OceanLoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLoggingArgs:
    def __init__(__self__, *,
                 export: Optional[pulumi.Input['OceanLoggingExportArgs']] = None):
        """
        :param pulumi.Input['OceanLoggingExportArgs'] export: Logging Export configuration.
        """
        if export is not None:
            pulumi.set(__self__, "export", export)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input['OceanLoggingExportArgs']]:
        """
        Logging Export configuration.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input['OceanLoggingExportArgs']]):
        pulumi.set(self, "export", value)


if not MYPY:
    class OceanLoggingExportArgsDict(TypedDict):
        s3s: NotRequired[pulumi.Input[Sequence[pulumi.Input['OceanLoggingExportS3ArgsDict']]]]
        """
        Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
elif False:
    OceanLoggingExportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLoggingExportArgs:
    def __init__(__self__, *,
                 s3s: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoggingExportS3Args']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['OceanLoggingExportS3Args']]] s3s: Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        if s3s is not None:
            pulumi.set(__self__, "s3s", s3s)

    @_builtins.property
    @pulumi.getter
    def s3s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoggingExportS3Args']]]]:
        """
        Exports your cluster's logs to the S3 bucket and subdir configured on the S3 data integration given.
        """
        return pulumi.get(self, "s3s")

    @s3s.setter
    def s3s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanLoggingExportS3Args']]]]):
        pulumi.set(self, "s3s", value)


if not MYPY:
    class OceanLoggingExportS3ArgsDict(TypedDict):
        id: pulumi.Input[_builtins.str]
        """
        The identifier of The S3 data integration to export the logs to.
        """
elif False:
    OceanLoggingExportS3ArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanLoggingExportS3Args:
    def __init__(__self__, *,
                 id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] id: The identifier of The S3 data integration to export the logs to.
        """
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of The S3 data integration to export the logs to.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)


if not MYPY:
    class OceanOptimizeImagesArgsDict(TypedDict):
        perform_at: pulumi.Input[_builtins.str]
        """
        String. Valid values: "always" "never" "timeWindow".
        """
        should_optimize_ecs_ami: pulumi.Input[_builtins.bool]
        """
        Boolean. Enable auto image (AMI) update for the ECS container instances. The auto update applies for ECS-Optimized AMIs.
        """
        time_windows: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Array of strings. Set time windows for image update, at least one time window. Each string is in the format of ddd:hh:mm-ddd:hh:mm ddd. Time windows should not overlap.
        """
elif False:
    OceanOptimizeImagesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanOptimizeImagesArgs:
    def __init__(__self__, *,
                 perform_at: pulumi.Input[_builtins.str],
                 should_optimize_ecs_ami: pulumi.Input[_builtins.bool],
                 time_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] perform_at: String. Valid values: "always" "never" "timeWindow".
        :param pulumi.Input[_builtins.bool] should_optimize_ecs_ami: Boolean. Enable auto image (AMI) update for the ECS container instances. The auto update applies for ECS-Optimized AMIs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_windows: Array of strings. Set time windows for image update, at least one time window. Each string is in the format of ddd:hh:mm-ddd:hh:mm ddd. Time windows should not overlap.
        """
        pulumi.set(__self__, "perform_at", perform_at)
        pulumi.set(__self__, "should_optimize_ecs_ami", should_optimize_ecs_ami)
        if time_windows is not None:
            pulumi.set(__self__, "time_windows", time_windows)

    @_builtins.property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> pulumi.Input[_builtins.str]:
        """
        String. Valid values: "always" "never" "timeWindow".
        """
        return pulumi.get(self, "perform_at")

    @perform_at.setter
    def perform_at(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "perform_at", value)

    @_builtins.property
    @pulumi.getter(name="shouldOptimizeEcsAmi")
    def should_optimize_ecs_ami(self) -> pulumi.Input[_builtins.bool]:
        """
        Boolean. Enable auto image (AMI) update for the ECS container instances. The auto update applies for ECS-Optimized AMIs.
        """
        return pulumi.get(self, "should_optimize_ecs_ami")

    @should_optimize_ecs_ami.setter
    def should_optimize_ecs_ami(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "should_optimize_ecs_ami", value)

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Array of strings. Set time windows for image update, at least one time window. Each string is in the format of ddd:hh:mm-ddd:hh:mm ddd. Time windows should not overlap.
        """
        return pulumi.get(self, "time_windows")

    @time_windows.setter
    def time_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "time_windows", value)


if not MYPY:
    class OceanScheduledTaskArgsDict(TypedDict):
        shutdown_hours: NotRequired[pulumi.Input['OceanScheduledTaskShutdownHoursArgsDict']]
        """
        Set shutdown hours for cluster object.
        """
        tasks: NotRequired[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskTaskArgsDict']]]]
        """
        The scheduling tasks for the cluster.
        """
elif False:
    OceanScheduledTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanScheduledTaskArgs:
    def __init__(__self__, *,
                 shutdown_hours: Optional[pulumi.Input['OceanScheduledTaskShutdownHoursArgs']] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskTaskArgs']]]] = None):
        """
        :param pulumi.Input['OceanScheduledTaskShutdownHoursArgs'] shutdown_hours: Set shutdown hours for cluster object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskTaskArgs']]] tasks: The scheduling tasks for the cluster.
        """
        if shutdown_hours is not None:
            pulumi.set(__self__, "shutdown_hours", shutdown_hours)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)

    @_builtins.property
    @pulumi.getter(name="shutdownHours")
    def shutdown_hours(self) -> Optional[pulumi.Input['OceanScheduledTaskShutdownHoursArgs']]:
        """
        Set shutdown hours for cluster object.
        """
        return pulumi.get(self, "shutdown_hours")

    @shutdown_hours.setter
    def shutdown_hours(self, value: Optional[pulumi.Input['OceanScheduledTaskShutdownHoursArgs']]):
        pulumi.set(self, "shutdown_hours", value)

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskTaskArgs']]]]:
        """
        The scheduling tasks for the cluster.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskTaskArgs']]]]):
        pulumi.set(self, "tasks", value)


if not MYPY:
    class OceanScheduledTaskShutdownHoursArgsDict(TypedDict):
        time_windows: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of `ddd:hh:mm-ddd:hh:mm` (ddd = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat hh = hour 24 = 0 -23 mm = minute = 0 - 59). Time windows should not overlap. Required when `cluster.scheduling.isEnabled` is true. API Times are in UTC. Example: `Fri:15:30-Wed:14:30`.
        """
        is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Flag to enable / disable the shutdown hours.
        """
elif False:
    OceanScheduledTaskShutdownHoursArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanScheduledTaskShutdownHoursArgs:
    def __init__(__self__, *,
                 time_windows: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] time_windows: Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of `ddd:hh:mm-ddd:hh:mm` (ddd = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat hh = hour 24 = 0 -23 mm = minute = 0 - 59). Time windows should not overlap. Required when `cluster.scheduling.isEnabled` is true. API Times are in UTC. Example: `Fri:15:30-Wed:14:30`.
        :param pulumi.Input[_builtins.bool] is_enabled: Flag to enable / disable the shutdown hours.
        """
        pulumi.set(__self__, "time_windows", time_windows)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)

    @_builtins.property
    @pulumi.getter(name="timeWindows")
    def time_windows(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set time windows for shutdown hours. Specify a list of `timeWindows` with at least one time window Each string is in the format of `ddd:hh:mm-ddd:hh:mm` (ddd = day of week = Sun | Mon | Tue | Wed | Thu | Fri | Sat hh = hour 24 = 0 -23 mm = minute = 0 - 59). Time windows should not overlap. Required when `cluster.scheduling.isEnabled` is true. API Times are in UTC. Example: `Fri:15:30-Wed:14:30`.
        """
        return pulumi.get(self, "time_windows")

    @time_windows.setter
    def time_windows(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "time_windows", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to enable / disable the shutdown hours.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)


if not MYPY:
    class OceanScheduledTaskTaskArgsDict(TypedDict):
        cron_expression: pulumi.Input[_builtins.str]
        """
        A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. Example: `0 1 * * *`.
        """
        is_enabled: pulumi.Input[_builtins.bool]
        """
        Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        """
        task_type: pulumi.Input[_builtins.str]
        """
        Valid values: "clusterRoll". Required for `cluster.scheduling.tasks object`. Example: `clusterRoll`.
        """
elif False:
    OceanScheduledTaskTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanScheduledTaskTaskArgs:
    def __init__(__self__, *,
                 cron_expression: pulumi.Input[_builtins.str],
                 is_enabled: pulumi.Input[_builtins.bool],
                 task_type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] cron_expression: A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. Example: `0 1 * * *`.
        :param pulumi.Input[_builtins.bool] is_enabled: Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        :param pulumi.Input[_builtins.str] task_type: Valid values: "clusterRoll". Required for `cluster.scheduling.tasks object`. Example: `clusterRoll`.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "task_type", task_type)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> pulumi.Input[_builtins.str]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in Unix cron format Cron Expression Validator Script. Only one of `frequency` or `cronExpression` should be used at a time. Required for `cluster.scheduling.tasks` object. Example: `0 1 * * *`.
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Describes whether the task is enabled. When true the task should run when false it should not run. Required for `cluster.scheduling.tasks` object.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        Valid values: "clusterRoll". Required for `cluster.scheduling.tasks object`. Example: `clusterRoll`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)


if not MYPY:
    class OceanTagArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The tag key.
        """
        value: pulumi.Input[_builtins.str]
        """
        The tag value.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
elif False:
    OceanTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: The tag key.
        :param pulumi.Input[_builtins.str] value: The tag value.
               * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The tag key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The tag value.
        * `instanceTypes` - (Optional) The type of instances that may or may not be a part of the Ocean cluster.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class OceanUpdatePolicyArgsDict(TypedDict):
        should_roll: pulumi.Input[_builtins.bool]
        """
        Enables the roll.
        """
        auto_apply_tags: NotRequired[pulumi.Input[_builtins.bool]]
        """
        will update instance tags on the fly without rolling the cluster.
        """
        conditioned_roll: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        roll_config: NotRequired[pulumi.Input['OceanUpdatePolicyRollConfigArgsDict']]
elif False:
    OceanUpdatePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanUpdatePolicyArgs:
    def __init__(__self__, *,
                 should_roll: pulumi.Input[_builtins.bool],
                 auto_apply_tags: Optional[pulumi.Input[_builtins.bool]] = None,
                 conditioned_roll: Optional[pulumi.Input[_builtins.bool]] = None,
                 roll_config: Optional[pulumi.Input['OceanUpdatePolicyRollConfigArgs']] = None):
        """
        :param pulumi.Input[_builtins.bool] should_roll: Enables the roll.
        :param pulumi.Input[_builtins.bool] auto_apply_tags: will update instance tags on the fly without rolling the cluster.
        :param pulumi.Input[_builtins.bool] conditioned_roll: Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        pulumi.set(__self__, "should_roll", should_roll)
        if auto_apply_tags is not None:
            pulumi.set(__self__, "auto_apply_tags", auto_apply_tags)
        if conditioned_roll is not None:
            pulumi.set(__self__, "conditioned_roll", conditioned_roll)
        if roll_config is not None:
            pulumi.set(__self__, "roll_config", roll_config)

    @_builtins.property
    @pulumi.getter(name="shouldRoll")
    def should_roll(self) -> pulumi.Input[_builtins.bool]:
        """
        Enables the roll.
        """
        return pulumi.get(self, "should_roll")

    @should_roll.setter
    def should_roll(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "should_roll", value)

    @_builtins.property
    @pulumi.getter(name="autoApplyTags")
    def auto_apply_tags(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        will update instance tags on the fly without rolling the cluster.
        """
        return pulumi.get(self, "auto_apply_tags")

    @auto_apply_tags.setter
    def auto_apply_tags(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_apply_tags", value)

    @_builtins.property
    @pulumi.getter(name="conditionedRoll")
    def conditioned_roll(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Spot will perform a cluster Roll in accordance with a relevant modification of the cluster’s settings. When set to true , only specific changes in the cluster’s configuration will trigger a cluster roll (such as AMI, Key Pair, user data, instance types, load balancers, etc).
        """
        return pulumi.get(self, "conditioned_roll")

    @conditioned_roll.setter
    def conditioned_roll(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "conditioned_roll", value)

    @_builtins.property
    @pulumi.getter(name="rollConfig")
    def roll_config(self) -> Optional[pulumi.Input['OceanUpdatePolicyRollConfigArgs']]:
        return pulumi.get(self, "roll_config")

    @roll_config.setter
    def roll_config(self, value: Optional[pulumi.Input['OceanUpdatePolicyRollConfigArgs']]):
        pulumi.set(self, "roll_config", value)


if not MYPY:
    class OceanUpdatePolicyRollConfigArgsDict(TypedDict):
        batch_size_percentage: pulumi.Input[_builtins.int]
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        batch_min_healthy_percentage: NotRequired[pulumi.Input[_builtins.int]]
        """
        Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
elif False:
    OceanUpdatePolicyRollConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OceanUpdatePolicyRollConfigArgs:
    def __init__(__self__, *,
                 batch_size_percentage: pulumi.Input[_builtins.int],
                 batch_min_healthy_percentage: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] batch_size_percentage: Sets the percentage of the instances to deploy in each batch.
        :param pulumi.Input[_builtins.int] batch_min_healthy_percentage: Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        pulumi.set(__self__, "batch_size_percentage", batch_size_percentage)
        if batch_min_healthy_percentage is not None:
            pulumi.set(__self__, "batch_min_healthy_percentage", batch_min_healthy_percentage)

    @_builtins.property
    @pulumi.getter(name="batchSizePercentage")
    def batch_size_percentage(self) -> pulumi.Input[_builtins.int]:
        """
        Sets the percentage of the instances to deploy in each batch.
        """
        return pulumi.get(self, "batch_size_percentage")

    @batch_size_percentage.setter
    def batch_size_percentage(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "batch_size_percentage", value)

    @_builtins.property
    @pulumi.getter(name="batchMinHealthyPercentage")
    def batch_min_healthy_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default: 50. Indicates the threshold of minimum healthy instances in single batch. If the amount of healthy instances in single batch is under the threshold, the cluster roll will fail. If exists, the parameter value will be in range of 1-100. In case of null as value, the default value in the backend will be 50%. Value of param should represent the number in percentage (%) of the batch.
        """
        return pulumi.get(self, "batch_min_healthy_percentage")

    @batch_min_healthy_percentage.setter
    def batch_min_healthy_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_min_healthy_percentage", value)


