# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ElastigroupBackendServiceArgs',
    'ElastigroupBackendServiceArgsDict',
    'ElastigroupBackendServiceBackendBalancingArgs',
    'ElastigroupBackendServiceBackendBalancingArgsDict',
    'ElastigroupBackendServiceNamedPortArgs',
    'ElastigroupBackendServiceNamedPortArgsDict',
    'ElastigroupDiskArgs',
    'ElastigroupDiskArgsDict',
    'ElastigroupDiskInitializeParamArgs',
    'ElastigroupDiskInitializeParamArgsDict',
    'ElastigroupGpuArgs',
    'ElastigroupGpuArgsDict',
    'ElastigroupInstanceTypesCustomArgs',
    'ElastigroupInstanceTypesCustomArgsDict',
    'ElastigroupIntegrationDockerSwarmArgs',
    'ElastigroupIntegrationDockerSwarmArgsDict',
    'ElastigroupIntegrationGkeArgs',
    'ElastigroupIntegrationGkeArgsDict',
    'ElastigroupIntegrationGkeAutoscaleDownArgs',
    'ElastigroupIntegrationGkeAutoscaleDownArgsDict',
    'ElastigroupIntegrationGkeAutoscaleHeadroomArgs',
    'ElastigroupIntegrationGkeAutoscaleHeadroomArgsDict',
    'ElastigroupIntegrationGkeAutoscaleLabelArgs',
    'ElastigroupIntegrationGkeAutoscaleLabelArgsDict',
    'ElastigroupLabelArgs',
    'ElastigroupLabelArgsDict',
    'ElastigroupMetadataArgs',
    'ElastigroupMetadataArgsDict',
    'ElastigroupNetworkInterfaceArgs',
    'ElastigroupNetworkInterfaceArgsDict',
    'ElastigroupNetworkInterfaceAccessConfigArgs',
    'ElastigroupNetworkInterfaceAccessConfigArgsDict',
    'ElastigroupNetworkInterfaceAliasIpRangeArgs',
    'ElastigroupNetworkInterfaceAliasIpRangeArgsDict',
    'ElastigroupRevertToPreemptibleArgs',
    'ElastigroupRevertToPreemptibleArgsDict',
    'ElastigroupScalingDownPolicyArgs',
    'ElastigroupScalingDownPolicyArgsDict',
    'ElastigroupScalingDownPolicyDimensionArgs',
    'ElastigroupScalingDownPolicyDimensionArgsDict',
    'ElastigroupScalingUpPolicyArgs',
    'ElastigroupScalingUpPolicyArgsDict',
    'ElastigroupScalingUpPolicyDimensionArgs',
    'ElastigroupScalingUpPolicyDimensionArgsDict',
    'ElastigroupScheduledTaskArgs',
    'ElastigroupScheduledTaskArgsDict',
    'ElastigroupShieldedInstanceConfigArgs',
    'ElastigroupShieldedInstanceConfigArgsDict',
    'ElastigroupSubnetArgs',
    'ElastigroupSubnetArgsDict',
]

MYPY = False

if not MYPY:
    class ElastigroupBackendServiceArgsDict(TypedDict):
        service_name: pulumi.Input[_builtins.str]
        """
        The name of the backend service.
        """
        backend_balancing: NotRequired[pulumi.Input['ElastigroupBackendServiceBackendBalancingArgsDict']]
        """
        Configure how traffic is distributed across instance groups.
        """
        location_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Sets which location the backend services will be active. Valid values: `regional`, `global`.
        """
        named_ports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceNamedPortArgsDict']]]]
        """
        Describes a named port and a list of ports.
        """
        scheme: NotRequired[pulumi.Input[_builtins.str]]
        """
        Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
elif False:
    ElastigroupBackendServiceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupBackendServiceArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[_builtins.str],
                 backend_balancing: Optional[pulumi.Input['ElastigroupBackendServiceBackendBalancingArgs']] = None,
                 location_type: Optional[pulumi.Input[_builtins.str]] = None,
                 named_ports: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceNamedPortArgs']]]] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] service_name: The name of the backend service.
        :param pulumi.Input['ElastigroupBackendServiceBackendBalancingArgs'] backend_balancing: Configure how traffic is distributed across instance groups.
        :param pulumi.Input[_builtins.str] location_type: Sets which location the backend services will be active. Valid values: `regional`, `global`.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceNamedPortArgs']]] named_ports: Describes a named port and a list of ports.
        :param pulumi.Input[_builtins.str] scheme: Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        pulumi.set(__self__, "service_name", service_name)
        if backend_balancing is not None:
            pulumi.set(__self__, "backend_balancing", backend_balancing)
        if location_type is not None:
            pulumi.set(__self__, "location_type", location_type)
        if named_ports is not None:
            pulumi.set(__self__, "named_ports", named_ports)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the backend service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="backendBalancing")
    def backend_balancing(self) -> Optional[pulumi.Input['ElastigroupBackendServiceBackendBalancingArgs']]:
        """
        Configure how traffic is distributed across instance groups.
        """
        return pulumi.get(self, "backend_balancing")

    @backend_balancing.setter
    def backend_balancing(self, value: Optional[pulumi.Input['ElastigroupBackendServiceBackendBalancingArgs']]):
        pulumi.set(self, "backend_balancing", value)

    @_builtins.property
    @pulumi.getter(name="locationType")
    def location_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets which location the backend services will be active. Valid values: `regional`, `global`.
        """
        return pulumi.get(self, "location_type")

    @location_type.setter
    def location_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_type", value)

    @_builtins.property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceNamedPortArgs']]]]:
        """
        Describes a named port and a list of ports.
        """
        return pulumi.get(self, "named_ports")

    @named_ports.setter
    def named_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceNamedPortArgs']]]]):
        pulumi.set(self, "named_ports", value)

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Use when `location_type` is "regional". Set the traffic for the backend service to either between the instances in the vpc or to traffic from the internet. Valid values: `INTERNAL`, `EXTERNAL`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheme", value)


if not MYPY:
    class ElastigroupBackendServiceBackendBalancingArgsDict(TypedDict):
        backend_balancing_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The backend balancing mode. Valid values: `RATE`, `UTILIZATION`.
        """
        max_rate_per_instance: NotRequired[pulumi.Input[_builtins.int]]
        """
        If the backendBalancingMode is set to RATE, this field is required.

        Usage:
        """
elif False:
    ElastigroupBackendServiceBackendBalancingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupBackendServiceBackendBalancingArgs:
    def __init__(__self__, *,
                 backend_balancing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_rate_per_instance: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] backend_balancing_mode: The backend balancing mode. Valid values: `RATE`, `UTILIZATION`.
        :param pulumi.Input[_builtins.int] max_rate_per_instance: If the backendBalancingMode is set to RATE, this field is required.
               
               Usage:
        """
        if backend_balancing_mode is not None:
            pulumi.set(__self__, "backend_balancing_mode", backend_balancing_mode)
        if max_rate_per_instance is not None:
            pulumi.set(__self__, "max_rate_per_instance", max_rate_per_instance)

    @_builtins.property
    @pulumi.getter(name="backendBalancingMode")
    def backend_balancing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend balancing mode. Valid values: `RATE`, `UTILIZATION`.
        """
        return pulumi.get(self, "backend_balancing_mode")

    @backend_balancing_mode.setter
    def backend_balancing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_balancing_mode", value)

    @_builtins.property
    @pulumi.getter(name="maxRatePerInstance")
    def max_rate_per_instance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        If the backendBalancingMode is set to RATE, this field is required.

        Usage:
        """
        return pulumi.get(self, "max_rate_per_instance")

    @max_rate_per_instance.setter
    def max_rate_per_instance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_rate_per_instance", value)


if not MYPY:
    class ElastigroupBackendServiceNamedPortArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the port.
        """
        ports: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of ports.
        """
elif False:
    ElastigroupBackendServiceNamedPortArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupBackendServiceNamedPortArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 ports: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[_builtins.str] name: The name of the port.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ports: A list of ports.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of ports.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "ports", value)


if not MYPY:
    class ElastigroupDiskArgsDict(TypedDict):
        auto_delete: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted.
        """
        boot: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        device_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a unique device name of your choice.
        """
        initialize_params: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskInitializeParamArgsDict']]]]
        """
        Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        """
        interface: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        """
        mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
elif False:
    ElastigroupDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupDiskArgs:
    def __init__(__self__, *,
                 auto_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_name: Optional[pulumi.Input[_builtins.str]] = None,
                 initialize_params: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskInitializeParamArgs']]]] = None,
                 interface: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] auto_delete: Specifies whether the disk will be auto-deleted when the instance is deleted.
        :param pulumi.Input[_builtins.bool] boot: Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        :param pulumi.Input[_builtins.str] device_name: Specifies a unique device name of your choice.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskInitializeParamArgs']]] initialize_params: Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        :param pulumi.Input[_builtins.str] interface: Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        :param pulumi.Input[_builtins.str] mode: The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        :param pulumi.Input[_builtins.str] source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param pulumi.Input[_builtins.str] type: Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        if auto_delete is not None:
            pulumi.set(__self__, "auto_delete", auto_delete)
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if initialize_params is not None:
            pulumi.set(__self__, "initialize_params", initialize_params)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autoDelete")
    def auto_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the disk will be auto-deleted when the instance is deleted.
        """
        return pulumi.get(self, "auto_delete")

    @auto_delete.setter
    def auto_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_delete", value)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
        """
        return pulumi.get(self, "boot")

    @boot.setter
    def boot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "boot", value)

    @_builtins.property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique device name of your choice.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "device_name", value)

    @_builtins.property
    @pulumi.getter(name="initializeParams")
    def initialize_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskInitializeParamArgs']]]]:
        """
        Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
        """
        return pulumi.get(self, "initialize_params")

    @initialize_params.setter
    def initialize_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskInitializeParamArgs']]]]):
        pulumi.set(self, "initialize_params", value)

    @_builtins.property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode in which to attach this disk, either READ_WRITE or READ_ONLY.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of disk, either SCRATCH or PERSISTENT.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ElastigroupDiskInitializeParamArgsDict(TypedDict):
        source_image: pulumi.Input[_builtins.str]
        """
        A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.

        Usage:
        """
        disk_size_gb: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies disk size in gigabytes. Must be in increments of 2.
        """
        disk_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
elif False:
    ElastigroupDiskInitializeParamArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupDiskInitializeParamArgs:
    def __init__(__self__, *,
                 source_image: pulumi.Input[_builtins.str],
                 disk_size_gb: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] source_image: A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.
               
               Usage:
        :param pulumi.Input[_builtins.str] disk_size_gb: Specifies disk size in gigabytes. Must be in increments of 2.
        :param pulumi.Input[_builtins.str] disk_type: Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        pulumi.set(__self__, "source_image", source_image)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Input[_builtins.str]:
        """
        A source image used to create the disk. You can provide a private (custom) image, and Compute Engine will use the corresponding image from your project.

        Usage:
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies disk size in gigabytes. Must be in increments of 2.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk type to use to create the instance. Valid values: pd-ssd, local-ssd.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_type", value)


if not MYPY:
    class ElastigroupGpuArgsDict(TypedDict):
        count: pulumi.Input[_builtins.int]
        """
        The number of GPUs. Must be 0, 2, 4, 6, 8.

        Usage:
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
elif False:
    ElastigroupGpuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupGpuArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] count: The number of GPUs. Must be 0, 2, 4, 6, 8.
               
               Usage:
        :param pulumi.Input[_builtins.str] type: The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> pulumi.Input[_builtins.int]:
        """
        The number of GPUs. Must be 0, 2, 4, 6, 8.

        Usage:
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "count", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of GPU instance. Valid values: `nvidia-tesla-v100`, `nvidia-tesla-p100`, `nvidia-tesla-k80`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ElastigroupInstanceTypesCustomArgsDict(TypedDict):
        memory_gib: pulumi.Input[_builtins.int]
        """
        The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        vcpu: pulumi.Input[_builtins.int]
elif False:
    ElastigroupInstanceTypesCustomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupInstanceTypesCustomArgs:
    def __init__(__self__, *,
                 memory_gib: pulumi.Input[_builtins.int],
                 vcpu: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.int] memory_gib: The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        pulumi.set(__self__, "memory_gib", memory_gib)
        pulumi.set(__self__, "vcpu", vcpu)

    @_builtins.property
    @pulumi.getter(name="memoryGib")
    def memory_gib(self) -> pulumi.Input[_builtins.int]:
        """
        The memory (in GiB) in the custom instance types. GCP has a number of limitations on accepted memory values.For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "memory_gib")

    @memory_gib.setter
    def memory_gib(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory_gib", value)

    @_builtins.property
    @pulumi.getter
    def vcpu(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "vcpu")

    @vcpu.setter
    def vcpu(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "vcpu", value)


if not MYPY:
    class ElastigroupIntegrationDockerSwarmArgsDict(TypedDict):
        master_host: pulumi.Input[_builtins.str]
        """
        IP or FQDN of one of your swarm managers.
        """
        master_port: pulumi.Input[_builtins.int]
        """
        Network port used by your swarm.

        Usage:
        """
elif False:
    ElastigroupIntegrationDockerSwarmArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupIntegrationDockerSwarmArgs:
    def __init__(__self__, *,
                 master_host: pulumi.Input[_builtins.str],
                 master_port: pulumi.Input[_builtins.int]):
        """
        :param pulumi.Input[_builtins.str] master_host: IP or FQDN of one of your swarm managers.
        :param pulumi.Input[_builtins.int] master_port: Network port used by your swarm.
               
               Usage:
        """
        pulumi.set(__self__, "master_host", master_host)
        pulumi.set(__self__, "master_port", master_port)

    @_builtins.property
    @pulumi.getter(name="masterHost")
    def master_host(self) -> pulumi.Input[_builtins.str]:
        """
        IP or FQDN of one of your swarm managers.
        """
        return pulumi.get(self, "master_host")

    @master_host.setter
    def master_host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "master_host", value)

    @_builtins.property
    @pulumi.getter(name="masterPort")
    def master_port(self) -> pulumi.Input[_builtins.int]:
        """
        Network port used by your swarm.

        Usage:
        """
        return pulumi.get(self, "master_port")

    @master_port.setter
    def master_port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "master_port", value)


if not MYPY:
    class ElastigroupIntegrationGkeArgsDict(TypedDict):
        auto_update: NotRequired[pulumi.Input[_builtins.bool]]
        autoscale_cooldown: NotRequired[pulumi.Input[_builtins.int]]
        autoscale_down: NotRequired[pulumi.Input['ElastigroupIntegrationGkeAutoscaleDownArgsDict']]
        autoscale_headroom: NotRequired[pulumi.Input['ElastigroupIntegrationGkeAutoscaleHeadroomArgsDict']]
        autoscale_is_auto_config: NotRequired[pulumi.Input[_builtins.bool]]
        autoscale_is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        autoscale_labels: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupIntegrationGkeAutoscaleLabelArgsDict']]]]
        cluster_id: NotRequired[pulumi.Input[_builtins.str]]
        location: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ElastigroupIntegrationGkeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupIntegrationGkeArgs:
    def __init__(__self__, *,
                 auto_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale_cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 autoscale_down: Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleDownArgs']] = None,
                 autoscale_headroom: Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleHeadroomArgs']] = None,
                 autoscale_is_auto_config: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale_is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscale_labels: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupIntegrationGkeAutoscaleLabelArgs']]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None):
        if auto_update is not None:
            pulumi.set(__self__, "auto_update", auto_update)
        if autoscale_cooldown is not None:
            pulumi.set(__self__, "autoscale_cooldown", autoscale_cooldown)
        if autoscale_down is not None:
            pulumi.set(__self__, "autoscale_down", autoscale_down)
        if autoscale_headroom is not None:
            pulumi.set(__self__, "autoscale_headroom", autoscale_headroom)
        if autoscale_is_auto_config is not None:
            pulumi.set(__self__, "autoscale_is_auto_config", autoscale_is_auto_config)
        if autoscale_is_enabled is not None:
            pulumi.set(__self__, "autoscale_is_enabled", autoscale_is_enabled)
        if autoscale_labels is not None:
            pulumi.set(__self__, "autoscale_labels", autoscale_labels)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if location is not None:
            pulumi.set(__self__, "location", location)

    @_builtins.property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_update")

    @auto_update.setter
    def auto_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_update", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleCooldown")
    def autoscale_cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "autoscale_cooldown")

    @autoscale_cooldown.setter
    def autoscale_cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "autoscale_cooldown", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleDown")
    def autoscale_down(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleDownArgs']]:
        return pulumi.get(self, "autoscale_down")

    @autoscale_down.setter
    def autoscale_down(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleDownArgs']]):
        pulumi.set(self, "autoscale_down", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleHeadroom")
    def autoscale_headroom(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleHeadroomArgs']]:
        return pulumi.get(self, "autoscale_headroom")

    @autoscale_headroom.setter
    def autoscale_headroom(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeAutoscaleHeadroomArgs']]):
        pulumi.set(self, "autoscale_headroom", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleIsAutoConfig")
    def autoscale_is_auto_config(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "autoscale_is_auto_config")

    @autoscale_is_auto_config.setter
    def autoscale_is_auto_config(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscale_is_auto_config", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleIsEnabled")
    def autoscale_is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "autoscale_is_enabled")

    @autoscale_is_enabled.setter
    def autoscale_is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "autoscale_is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleLabels")
    def autoscale_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupIntegrationGkeAutoscaleLabelArgs']]]]:
        return pulumi.get(self, "autoscale_labels")

    @autoscale_labels.setter
    def autoscale_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupIntegrationGkeAutoscaleLabelArgs']]]]):
        pulumi.set(self, "autoscale_labels", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)


if not MYPY:
    class ElastigroupIntegrationGkeAutoscaleDownArgsDict(TypedDict):
        evaluation_periods: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
elif False:
    ElastigroupIntegrationGkeAutoscaleDownArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupIntegrationGkeAutoscaleDownArgs:
    def __init__(__self__, *,
                 evaluation_periods: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)


if not MYPY:
    class ElastigroupIntegrationGkeAutoscaleHeadroomArgsDict(TypedDict):
        cpu_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        memory_per_unit: NotRequired[pulumi.Input[_builtins.int]]
        num_of_units: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    ElastigroupIntegrationGkeAutoscaleHeadroomArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupIntegrationGkeAutoscaleHeadroomArgs:
    def __init__(__self__, *,
                 cpu_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_per_unit: Optional[pulumi.Input[_builtins.int]] = None,
                 num_of_units: Optional[pulumi.Input[_builtins.int]] = None):
        if cpu_per_unit is not None:
            pulumi.set(__self__, "cpu_per_unit", cpu_per_unit)
        if memory_per_unit is not None:
            pulumi.set(__self__, "memory_per_unit", memory_per_unit)
        if num_of_units is not None:
            pulumi.set(__self__, "num_of_units", num_of_units)

    @_builtins.property
    @pulumi.getter(name="cpuPerUnit")
    def cpu_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "cpu_per_unit")

    @cpu_per_unit.setter
    def cpu_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="memoryPerUnit")
    def memory_per_unit(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "memory_per_unit")

    @memory_per_unit.setter
    def memory_per_unit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_per_unit", value)

    @_builtins.property
    @pulumi.getter(name="numOfUnits")
    def num_of_units(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "num_of_units")

    @num_of_units.setter
    def num_of_units(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "num_of_units", value)


if not MYPY:
    class ElastigroupIntegrationGkeAutoscaleLabelArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        value: pulumi.Input[_builtins.str]
elif False:
    ElastigroupIntegrationGkeAutoscaleLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupIntegrationGkeAutoscaleLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ElastigroupLabelArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        Labels key.
        """
        value: pulumi.Input[_builtins.str]
        """
        Labels value.
        """
elif False:
    ElastigroupLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: Labels key.
        :param pulumi.Input[_builtins.str] value: Labels value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Labels key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Labels value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ElastigroupMetadataArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        Metadata key.
        """
        value: pulumi.Input[_builtins.str]
        """
        Metadata value.
        """
elif False:
    ElastigroupMetadataArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupMetadataArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: Metadata key.
        :param pulumi.Input[_builtins.str] value: Metadata value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Metadata key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        Metadata value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ElastigroupNetworkInterfaceArgsDict(TypedDict):
        network: pulumi.Input[_builtins.str]
        """
        Network resource for this group.
        """
        access_configs: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAccessConfigArgsDict']]]]
        """
        Array of configurations.
        """
        alias_ip_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAliasIpRangeArgsDict']]]]
elif False:
    ElastigroupNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupNetworkInterfaceArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[_builtins.str],
                 access_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAccessConfigArgs']]]] = None,
                 alias_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAliasIpRangeArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] network: Network resource for this group.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAccessConfigArgs']]] access_configs: Array of configurations.
        """
        pulumi.set(__self__, "network", network)
        if access_configs is not None:
            pulumi.set(__self__, "access_configs", access_configs)
        if alias_ip_ranges is not None:
            pulumi.set(__self__, "alias_ip_ranges", alias_ip_ranges)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        Network resource for this group.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="accessConfigs")
    def access_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAccessConfigArgs']]]]:
        """
        Array of configurations.
        """
        return pulumi.get(self, "access_configs")

    @access_configs.setter
    def access_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAccessConfigArgs']]]]):
        pulumi.set(self, "access_configs", value)

    @_builtins.property
    @pulumi.getter(name="aliasIpRanges")
    def alias_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAliasIpRangeArgs']]]]:
        return pulumi.get(self, "alias_ip_ranges")

    @alias_ip_ranges.setter
    def alias_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceAliasIpRangeArgs']]]]):
        pulumi.set(self, "alias_ip_ranges", value)


if not MYPY:
    class ElastigroupNetworkInterfaceAccessConfigArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The group name.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ElastigroupNetworkInterfaceAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupNetworkInterfaceAccessConfigArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The group name.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ElastigroupNetworkInterfaceAliasIpRangeArgsDict(TypedDict):
        ip_cidr_range: pulumi.Input[_builtins.str]
        subnetwork_range_name: pulumi.Input[_builtins.str]
elif False:
    ElastigroupNetworkInterfaceAliasIpRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupNetworkInterfaceAliasIpRangeArgs:
    def __init__(__self__, *,
                 ip_cidr_range: pulumi.Input[_builtins.str],
                 subnetwork_range_name: pulumi.Input[_builtins.str]):
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "subnetwork_range_name", subnetwork_range_name)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="subnetworkRangeName")
    def subnetwork_range_name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "subnetwork_range_name")

    @subnetwork_range_name.setter
    def subnetwork_range_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnetwork_range_name", value)


if not MYPY:
    class ElastigroupRevertToPreemptibleArgsDict(TypedDict):
        perform_at: pulumi.Input[_builtins.str]
        """
        Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
elif False:
    ElastigroupRevertToPreemptibleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupRevertToPreemptibleArgs:
    def __init__(__self__, *,
                 perform_at: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] perform_at: Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        pulumi.set(__self__, "perform_at", perform_at)

    @_builtins.property
    @pulumi.getter(name="performAt")
    def perform_at(self) -> pulumi.Input[_builtins.str]:
        """
        Valid values: "always", "never", "timeWindow". Required on strategy.revertToPreemptible object.
        """
        return pulumi.get(self, "perform_at")

    @perform_at.setter
    def perform_at(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "perform_at", value)


if not MYPY:
    class ElastigroupScalingDownPolicyArgsDict(TypedDict):
        metric_name: pulumi.Input[_builtins.str]
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        namespace: pulumi.Input[_builtins.str]
        policy_name: pulumi.Input[_builtins.str]
        """
        Name of scaling policy.
        """
        threshold: pulumi.Input[_builtins.float]
        """
        The value at which the scaling action is triggered.
        """
        unit: pulumi.Input[_builtins.str]
        action_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        adjustment: NotRequired[pulumi.Input[_builtins.int]]
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        cooldown: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyDimensionArgsDict']]]]
        """
        A list of dimensions describing qualities of the metric.
        """
        evaluation_periods: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        operator: NotRequired[pulumi.Input[_builtins.str]]
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        statistic: NotRequired[pulumi.Input[_builtins.str]]
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
elif False:
    ElastigroupScalingDownPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupScalingDownPolicyArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 threshold: pulumi.Input[_builtins.float],
                 unit: pulumi.Input[_builtins.str],
                 action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment: Optional[pulumi.Input[_builtins.int]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyDimensionArgs']]]] = None,
                 evaluation_periods: Optional[pulumi.Input[_builtins.int]] = None,
                 operator: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 statistic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param pulumi.Input[_builtins.str] policy_name: Name of scaling policy.
        :param pulumi.Input[_builtins.float] threshold: The value at which the scaling action is triggered.
        :param pulumi.Input[_builtins.str] action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param pulumi.Input[_builtins.int] adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param pulumi.Input[_builtins.int] cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyDimensionArgs']]] dimensions: A list of dimensions describing qualities of the metric.
        :param pulumi.Input[_builtins.int] evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param pulumi.Input[_builtins.str] operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param pulumi.Input[_builtins.int] period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param pulumi.Input[_builtins.str] source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param pulumi.Input[_builtins.str] statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[_builtins.float]:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit", value)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_type", value)

    @_builtins.property
    @pulumi.getter
    def adjustment(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @adjustment.setter
    def adjustment(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adjustment", value)

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooldown", value)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyDimensionArgs']]]]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statistic", value)


if not MYPY:
    class ElastigroupScalingDownPolicyDimensionArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The group name.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    ElastigroupScalingDownPolicyDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupScalingDownPolicyDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The group name.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ElastigroupScalingUpPolicyArgsDict(TypedDict):
        metric_name: pulumi.Input[_builtins.str]
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        namespace: pulumi.Input[_builtins.str]
        policy_name: pulumi.Input[_builtins.str]
        """
        Name of scaling policy.
        """
        threshold: pulumi.Input[_builtins.float]
        """
        The value at which the scaling action is triggered.
        """
        unit: pulumi.Input[_builtins.str]
        action_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        adjustment: NotRequired[pulumi.Input[_builtins.int]]
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        cooldown: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        dimensions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyDimensionArgsDict']]]]
        """
        A list of dimensions describing qualities of the metric.
        """
        evaluation_periods: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        operator: NotRequired[pulumi.Input[_builtins.str]]
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        period: NotRequired[pulumi.Input[_builtins.int]]
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        statistic: NotRequired[pulumi.Input[_builtins.str]]
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
elif False:
    ElastigroupScalingUpPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupScalingUpPolicyArgs:
    def __init__(__self__, *,
                 metric_name: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 policy_name: pulumi.Input[_builtins.str],
                 threshold: pulumi.Input[_builtins.float],
                 unit: pulumi.Input[_builtins.str],
                 action_type: Optional[pulumi.Input[_builtins.str]] = None,
                 adjustment: Optional[pulumi.Input[_builtins.int]] = None,
                 cooldown: Optional[pulumi.Input[_builtins.int]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyDimensionArgs']]]] = None,
                 evaluation_periods: Optional[pulumi.Input[_builtins.int]] = None,
                 operator: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None,
                 statistic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] metric_name: Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        :param pulumi.Input[_builtins.str] policy_name: Name of scaling policy.
        :param pulumi.Input[_builtins.float] threshold: The value at which the scaling action is triggered.
        :param pulumi.Input[_builtins.str] action_type: Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        :param pulumi.Input[_builtins.int] adjustment: Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        :param pulumi.Input[_builtins.int] cooldown: Time (seconds) to wait after a scaling action before resuming monitoring.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyDimensionArgs']]] dimensions: A list of dimensions describing qualities of the metric.
        :param pulumi.Input[_builtins.int] evaluation_periods: Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        :param pulumi.Input[_builtins.str] operator: The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        :param pulumi.Input[_builtins.int] period: Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        :param pulumi.Input[_builtins.str] source: Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        :param pulumi.Input[_builtins.str] statistic: Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "policy_name", policy_name)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if adjustment is not None:
            pulumi.set(__self__, "adjustment", adjustment)
        if cooldown is not None:
            pulumi.set(__self__, "cooldown", cooldown)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[_builtins.str]:
        """
        Metric to monitor. Valid values: "Percentage CPU", "Network In", "Network Out", "Disk Read Bytes", "Disk Write Bytes", "Disk Write Operations/Sec", "Disk Read Operations/Sec".
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "metric_name", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of scaling policy.
        """
        return pulumi.get(self, "policy_name")

    @policy_name.setter
    def policy_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_name", value)

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[_builtins.float]:
        """
        The value at which the scaling action is triggered.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "threshold", value)

    @_builtins.property
    @pulumi.getter
    def unit(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "unit", value)

    @_builtins.property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of scaling action to take when the scaling policy is triggered. Valid values: "adjustment", "setMinTarget", "updateCapacity", "percentageAdjustment"
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action_type", value)

    @_builtins.property
    @pulumi.getter
    def adjustment(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Value to which the action type will be adjusted. Required if using "numeric" or "percentageAdjustment" action types.
        """
        return pulumi.get(self, "adjustment")

    @adjustment.setter
    def adjustment(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "adjustment", value)

    @_builtins.property
    @pulumi.getter
    def cooldown(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (seconds) to wait after a scaling action before resuming monitoring.
        """
        return pulumi.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cooldown", value)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyDimensionArgs']]]]:
        """
        A list of dimensions describing qualities of the metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @_builtins.property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of consecutive periods in which the threshold must be met in order to trigger a scaling action.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "evaluation_periods", value)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operator used to evaluate the threshold against the current metric value. Valid values: "gt" (greater than), "get" (greater-than or equal), "lt" (less than), "lte" (less than or equal).
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operator", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time (seconds) for which the threshold must be met in order to trigger the scaling action.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a valid partial or full URL to an existing Persistent Disk resource. This field is only applicable for persistent disks.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Statistic by which to evaluate the selected metric. Valid values: "AVERAGE", "SAMPLE_COUNT", "SUM", "MINIMUM", "MAXIMUM", "PERCENTILE", "COUNT".
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "statistic", value)


if not MYPY:
    class ElastigroupScalingUpPolicyDimensionArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The dimension name.
        """
        value: NotRequired[pulumi.Input[_builtins.str]]
        """
        The dimension value.

        Usage:
        """
elif False:
    ElastigroupScalingUpPolicyDimensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupScalingUpPolicyDimensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The dimension name.
        :param pulumi.Input[_builtins.str] value: The dimension value.
               
               Usage:
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The dimension name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The dimension value.

        Usage:
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ElastigroupScheduledTaskArgsDict(TypedDict):
        task_type: pulumi.Input[_builtins.str]
        """
        The task type to run. Valid values: `"setCapacity"`.
        """
        cron_expression: NotRequired[pulumi.Input[_builtins.str]]
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        is_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Setting the task to being enabled or disabled.
        """
        max_capacity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The maximum number of instances the group should have.

        Usage:
        """
        min_capacity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The minimum number of instances the group should have.
        """
        target_capacity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The desired number of instances the group should have.
        """
elif False:
    ElastigroupScheduledTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupScheduledTaskArgs:
    def __init__(__self__, *,
                 task_type: pulumi.Input[_builtins.str],
                 cron_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 max_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 min_capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 target_capacity: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] task_type: The task type to run. Valid values: `"setCapacity"`.
        :param pulumi.Input[_builtins.str] cron_expression: A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        :param pulumi.Input[_builtins.bool] is_enabled: Setting the task to being enabled or disabled.
        :param pulumi.Input[_builtins.str] max_capacity: The maximum number of instances the group should have.
               
               Usage:
        :param pulumi.Input[_builtins.str] min_capacity: The minimum number of instances the group should have.
        :param pulumi.Input[_builtins.str] target_capacity: The desired number of instances the group should have.
        """
        pulumi.set(__self__, "task_type", task_type)
        if cron_expression is not None:
            pulumi.set(__self__, "cron_expression", cron_expression)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if max_capacity is not None:
            pulumi.set(__self__, "max_capacity", max_capacity)
        if min_capacity is not None:
            pulumi.set(__self__, "min_capacity", min_capacity)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @_builtins.property
    @pulumi.getter(name="taskType")
    def task_type(self) -> pulumi.Input[_builtins.str]:
        """
        The task type to run. Valid values: `"setCapacity"`.
        """
        return pulumi.get(self, "task_type")

    @task_type.setter
    def task_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "task_type", value)

    @_builtins.property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid cron expression. The cron is running in UTC time zone and is in [Unix cron format](https://en.wikipedia.org/wiki/Cron).
        """
        return pulumi.get(self, "cron_expression")

    @cron_expression.setter
    def cron_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cron_expression", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Setting the task to being enabled or disabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The maximum number of instances the group should have.

        Usage:
        """
        return pulumi.get(self, "max_capacity")

    @max_capacity.setter
    def max_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_capacity", value)

    @_builtins.property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum number of instances the group should have.
        """
        return pulumi.get(self, "min_capacity")

    @min_capacity.setter
    def min_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_capacity", value)

    @_builtins.property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired number of instances the group should have.
        """
        return pulumi.get(self, "target_capacity")

    @target_capacity.setter
    def target_capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_capacity", value)


if not MYPY:
    class ElastigroupShieldedInstanceConfigArgsDict(TypedDict):
        enable_integrity_monitoring: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Default: false
        """
        enable_secure_boot: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Default: false
        """
elif False:
    ElastigroupShieldedInstanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupShieldedInstanceConfigArgs:
    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_secure_boot: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] enable_integrity_monitoring: Default: false
        :param pulumi.Input[_builtins.bool] enable_secure_boot: Default: false
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default: false
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @enable_integrity_monitoring.setter
    def enable_integrity_monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_integrity_monitoring", value)

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Default: false
        """
        return pulumi.get(self, "enable_secure_boot")

    @enable_secure_boot.setter
    def enable_secure_boot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_secure_boot", value)


if not MYPY:
    class ElastigroupSubnetArgsDict(TypedDict):
        region: pulumi.Input[_builtins.str]
        """
        The region for the group of subnets.
        """
        subnet_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The names of the subnets in the region.
        """
elif False:
    ElastigroupSubnetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ElastigroupSubnetArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[_builtins.str],
                 subnet_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[_builtins.str] region: The region for the group of subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_names: The names of the subnets in the region.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "subnet_names", subnet_names)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region for the group of subnets.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subnetNames")
    def subnet_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The names of the subnets in the region.
        """
        return pulumi.get(self, "subnet_names")

    @subnet_names.setter
    def subnet_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subnet_names", value)


