# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ElastigroupArgs', 'Elastigroup']

@pulumi.input_type
class ElastigroupArgs:
    def __init__(__self__, *,
                 desired_capacity: pulumi.Input[_builtins.int],
                 auto_healing: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]] = None,
                 health_check_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_gke: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']] = None,
                 ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 ondemand_count: Optional[pulumi.Input[_builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provisioning_model: Optional[pulumi.Input[_builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']] = None,
                 should_utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_duration: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a Elastigroup resource.
        :param pulumi.Input[_builtins.int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: List of availability zones for the group.
        :param pulumi.Input[_builtins.str] description: The region your GCP group will be created in.
        :param pulumi.Input[_builtins.int] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[_builtins.str] instance_name_prefix: Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
               * A maximal length of 25 characters.
               * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
               * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        :param pulumi.Input[_builtins.str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]] labels: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Select a minimum CPU platform for the compute instance.
        :param pulumi.Input[_builtins.int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optimization_windows: Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        :param pulumi.Input[_builtins.int] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        :param pulumi.Input[_builtins.str] provisioning_model: Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]] revert_to_preemptibles: Setting for revert to preemptible option.
        :param pulumi.Input[_builtins.str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input['ElastigroupShieldedInstanceConfigArgs'] shielded_instance_config: You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        :param pulumi.Input[_builtins.bool] should_utilize_commitments: Enable committed use discounts utilization.
        :param pulumi.Input[_builtins.str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[_builtins.str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]] subnets: A list of regions and subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to mark created instances.
        """
        pulumi.set(__self__, "desired_capacity", desired_capacity)
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if availability_zones is not None:
            warnings.warn("""This field will soon be handled by Region in Subnets""", DeprecationWarning)
            pulumi.log.warn("""availability_zones is deprecated: This field will soon be handled by Region in Subnets""")
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if instance_name_prefix is not None:
            pulumi.set(__self__, "instance_name_prefix", instance_name_prefix)
        if instance_types_customs is not None:
            pulumi.set(__self__, "instance_types_customs", instance_types_customs)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preemptibles is not None:
            pulumi.set(__self__, "instance_types_preemptibles", instance_types_preemptibles)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_gke is not None:
            pulumi.set(__self__, "integration_gke", integration_gke)
        if ip_forwarding is not None:
            pulumi.set(__self__, "ip_forwarding", ip_forwarding)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if optimization_windows is not None:
            pulumi.set(__self__, "optimization_windows", optimization_windows)
        if preemptible_percentage is not None:
            pulumi.set(__self__, "preemptible_percentage", preemptible_percentage)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)
        if revert_to_preemptibles is not None:
            pulumi.set(__self__, "revert_to_preemptibles", revert_to_preemptibles)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if should_utilize_commitments is not None:
            pulumi.set(__self__, "should_utilize_commitments", should_utilize_commitments)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unhealthy_duration is not None:
            pulumi.set(__self__, "unhealthy_duration", unhealthy_duration)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_healing", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    @_utilities.deprecated("""This field will soon be handled by Region in Subnets""")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of availability zones for the group.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]:
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region your GCP group will be created in.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]:
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]):
        pulumi.set(self, "gpu", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
        * A maximal length of 25 characters.
        * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        """
        return pulumi.get(self, "instance_name_prefix")

    @instance_name_prefix.setter
    def instance_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]:
        """
        Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
        * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "instance_types_customs")

    @instance_types_customs.setter
    def instance_types_customs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]):
        pulumi.set(self, "instance_types_customs", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        """
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        """
        return pulumi.get(self, "instance_types_preemptibles")

    @instance_types_preemptibles.setter
    def instance_types_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types_preemptibles", value)

    @_builtins.property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @_builtins.property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]:
        return pulumi.get(self, "integration_gke")

    @integration_gke.setter
    def integration_gke(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]):
        pulumi.set(self, "integration_gke", value)

    @_builtins.property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @ip_forwarding.setter
    def ip_forwarding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_forwarding", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select a minimum CPU platform for the compute instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ondemand_count", value)

    @_builtins.property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        """
        return pulumi.get(self, "optimization_windows")

    @optimization_windows.setter
    def optimization_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "optimization_windows", value)

    @_builtins.property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Percentage of Preemptible VMs to spin up from the "desired_capacity".
        """
        return pulumi.get(self, "preemptible_percentage")

    @preemptible_percentage.setter
    def preemptible_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "preemptible_percentage", value)

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        """
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_model", value)

    @_builtins.property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]:
        """
        Setting for revert to preemptible option.
        """
        return pulumi.get(self, "revert_to_preemptibles")

    @revert_to_preemptibles.setter
    def revert_to_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]):
        pulumi.set(self, "revert_to_preemptibles", value)

    @_builtins.property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @_builtins.property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]:
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the service account in which the group instances will be launched.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]:
        """
        You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable committed use discounts utilization.
        """
        return pulumi.get(self, "should_utilize_commitments")

    @should_utilize_commitments.setter
    def should_utilize_commitments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_utilize_commitments", value)

    @_builtins.property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shutdown_script", value)

    @_builtins.property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        """
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "startup_script", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]]:
        """
        A list of regions and subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to mark created instances.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyDuration")
    def unhealthy_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "unhealthy_duration")

    @unhealthy_duration.setter
    def unhealthy_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_duration", value)


@pulumi.input_type
class _ElastigroupState:
    def __init__(__self__, *,
                 auto_healing: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]] = None,
                 health_check_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']] = None,
                 integration_gke: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']] = None,
                 ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]] = None,
                 ondemand_count: Optional[pulumi.Input[_builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provisioning_model: Optional[pulumi.Input[_builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']] = None,
                 should_utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_duration: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Elastigroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: List of availability zones for the group.
        :param pulumi.Input[_builtins.str] description: The region your GCP group will be created in.
        :param pulumi.Input[_builtins.int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[_builtins.int] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[_builtins.str] instance_name_prefix: Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
               * A maximal length of 25 characters.
               * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
               * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        :param pulumi.Input[_builtins.str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]] labels: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Select a minimum CPU platform for the compute instance.
        :param pulumi.Input[_builtins.int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optimization_windows: Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        :param pulumi.Input[_builtins.int] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        :param pulumi.Input[_builtins.str] provisioning_model: Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]] revert_to_preemptibles: Setting for revert to preemptible option.
        :param pulumi.Input[_builtins.str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input['ElastigroupShieldedInstanceConfigArgs'] shielded_instance_config: You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        :param pulumi.Input[_builtins.bool] should_utilize_commitments: Enable committed use discounts utilization.
        :param pulumi.Input[_builtins.str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[_builtins.str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]] subnets: A list of regions and subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to mark created instances.
        """
        if auto_healing is not None:
            pulumi.set(__self__, "auto_healing", auto_healing)
        if availability_zones is not None:
            warnings.warn("""This field will soon be handled by Region in Subnets""", DeprecationWarning)
            pulumi.log.warn("""availability_zones is deprecated: This field will soon be handled by Region in Subnets""")
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if health_check_grace_period is not None:
            pulumi.set(__self__, "health_check_grace_period", health_check_grace_period)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if instance_name_prefix is not None:
            pulumi.set(__self__, "instance_name_prefix", instance_name_prefix)
        if instance_types_customs is not None:
            pulumi.set(__self__, "instance_types_customs", instance_types_customs)
        if instance_types_ondemand is not None:
            pulumi.set(__self__, "instance_types_ondemand", instance_types_ondemand)
        if instance_types_preemptibles is not None:
            pulumi.set(__self__, "instance_types_preemptibles", instance_types_preemptibles)
        if integration_docker_swarm is not None:
            pulumi.set(__self__, "integration_docker_swarm", integration_docker_swarm)
        if integration_gke is not None:
            pulumi.set(__self__, "integration_gke", integration_gke)
        if ip_forwarding is not None:
            pulumi.set(__self__, "ip_forwarding", ip_forwarding)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if ondemand_count is not None:
            pulumi.set(__self__, "ondemand_count", ondemand_count)
        if optimization_windows is not None:
            pulumi.set(__self__, "optimization_windows", optimization_windows)
        if preemptible_percentage is not None:
            pulumi.set(__self__, "preemptible_percentage", preemptible_percentage)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)
        if revert_to_preemptibles is not None:
            pulumi.set(__self__, "revert_to_preemptibles", revert_to_preemptibles)
        if scaling_down_policies is not None:
            pulumi.set(__self__, "scaling_down_policies", scaling_down_policies)
        if scaling_up_policies is not None:
            pulumi.set(__self__, "scaling_up_policies", scaling_up_policies)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if should_utilize_commitments is not None:
            pulumi.set(__self__, "should_utilize_commitments", should_utilize_commitments)
        if shutdown_script is not None:
            pulumi.set(__self__, "shutdown_script", shutdown_script)
        if startup_script is not None:
            pulumi.set(__self__, "startup_script", startup_script)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unhealthy_duration is not None:
            pulumi.set(__self__, "unhealthy_duration", unhealthy_duration)

    @_builtins.property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "auto_healing")

    @auto_healing.setter
    def auto_healing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_healing", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    @_utilities.deprecated("""This field will soon be handled by Region in Subnets""")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of availability zones for the group.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]:
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region your GCP group will be created in.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]:
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]:
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupGpuArgs']]]]):
        pulumi.set(self, "gpu", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "health_check_grace_period")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "health_check_grace_period", value)

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_check_type", value)

    @_builtins.property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
        * A maximal length of 25 characters.
        * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        """
        return pulumi.get(self, "instance_name_prefix")

    @instance_name_prefix.setter
    def instance_name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]:
        """
        Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
        * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "instance_types_customs")

    @instance_types_customs.setter
    def instance_types_customs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupInstanceTypesCustomArgs']]]]):
        pulumi.set(self, "instance_types_customs", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        """
        return pulumi.get(self, "instance_types_ondemand")

    @instance_types_ondemand.setter
    def instance_types_ondemand(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_types_ondemand", value)

    @_builtins.property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        """
        return pulumi.get(self, "instance_types_preemptibles")

    @instance_types_preemptibles.setter
    def instance_types_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_types_preemptibles", value)

    @_builtins.property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]:
        return pulumi.get(self, "integration_docker_swarm")

    @integration_docker_swarm.setter
    def integration_docker_swarm(self, value: Optional[pulumi.Input['ElastigroupIntegrationDockerSwarmArgs']]):
        pulumi.set(self, "integration_docker_swarm", value)

    @_builtins.property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]:
        return pulumi.get(self, "integration_gke")

    @integration_gke.setter
    def integration_gke(self, value: Optional[pulumi.Input['ElastigroupIntegrationGkeArgs']]):
        pulumi.set(self, "integration_gke", value)

    @_builtins.property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @ip_forwarding.setter
    def ip_forwarding(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_forwarding", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Select a minimum CPU platform for the compute instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]:
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @ondemand_count.setter
    def ondemand_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ondemand_count", value)

    @_builtins.property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        """
        return pulumi.get(self, "optimization_windows")

    @optimization_windows.setter
    def optimization_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "optimization_windows", value)

    @_builtins.property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Percentage of Preemptible VMs to spin up from the "desired_capacity".
        """
        return pulumi.get(self, "preemptible_percentage")

    @preemptible_percentage.setter
    def preemptible_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "preemptible_percentage", value)

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @preferred_availability_zones.setter
    def preferred_availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "preferred_availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        """
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_model", value)

    @_builtins.property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]:
        """
        Setting for revert to preemptible option.
        """
        return pulumi.get(self, "revert_to_preemptibles")

    @revert_to_preemptibles.setter
    def revert_to_preemptibles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupRevertToPreemptibleArgs']]]]):
        pulumi.set(self, "revert_to_preemptibles", value)

    @_builtins.property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]:
        return pulumi.get(self, "scaling_down_policies")

    @scaling_down_policies.setter
    def scaling_down_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingDownPolicyArgs']]]]):
        pulumi.set(self, "scaling_down_policies", value)

    @_builtins.property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]:
        return pulumi.get(self, "scaling_up_policies")

    @scaling_up_policies.setter
    def scaling_up_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScalingUpPolicyArgs']]]]):
        pulumi.set(self, "scaling_up_policies", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]:
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the service account in which the group instances will be launched.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]:
        """
        You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['ElastigroupShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable committed use discounts utilization.
        """
        return pulumi.get(self, "should_utilize_commitments")

    @should_utilize_commitments.setter
    def should_utilize_commitments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_utilize_commitments", value)

    @_builtins.property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @shutdown_script.setter
    def shutdown_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shutdown_script", value)

    @_builtins.property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        """
        return pulumi.get(self, "startup_script")

    @startup_script.setter
    def startup_script(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "startup_script", value)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]]:
        """
        A list of regions and subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ElastigroupSubnetArgs']]]]):
        pulumi.set(self, "subnets", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Tags to mark created instances.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="unhealthyDuration")
    def unhealthy_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "unhealthy_duration")

    @unhealthy_duration.setter
    def unhealthy_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "unhealthy_duration", value)


@pulumi.type_token("spotinst:gcp/elastigroup:Elastigroup")
class Elastigroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_healing: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
                 health_check_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
                 ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 ondemand_count: Optional[pulumi.Input[_builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provisioning_model: Optional[pulumi.Input[_builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
                 should_utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSubnetArgs', 'ElastigroupSubnetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Spotinst elastigroup GCP resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gcp.Elastigroup("example",
            name="example-gcp",
            description="spotinst gcp group",
            service_account="example@myProject.iam.gservicecct.com",
            startup_script="",
            instance_name_prefix="test-123a",
            min_cpu_platform="Intel Sandy Bridge",
            min_size=0,
            max_size=1,
            desired_capacity=1,
            availability_zones=[
                "asia-east1-c",
                "us-central1-a",
            ],
            preferred_availability_zones=["us-central1-a"],
            preemptible_percentage=50,
            revert_to_preemptibles=[{
                "perform_at": "timeWindow",
            }],
            optimization_windows=["Mon:01:00-Mon:03:00"],
            fallback_to_ondemand=True,
            draining_timeout=180,
            provisioning_model="SPOT",
            should_utilize_commitments=True,
            labels=[{
                "key": "test_key",
                "value": "test_value",
            }],
            tags=[
                "http",
                "https",
            ],
            backend_services=[{
                "service_name": "spotinst-elb-backend-service",
                "location_type": "regional",
                "scheme": "INTERNAL",
                "named_ports": [{
                    "name": "port-name",
                    "ports": [
                        "8000",
                        "6000",
                    ],
                }],
                "backend_balancing": {
                    "backend_balancing_mode": "RATE",
                    "max_rate_per_instance": 500,
                },
            }],
            disks=[{
                "device_name": "device",
                "mode": "READ_WRITE",
                "type": "PERSISTENT",
                "auto_delete": True,
                "boot": True,
                "interface": "SCSI",
                "initialize_params": [{
                    "disk_size_gb": "10",
                    "disk_type": "pd-standard",
                    "source_image": "",
                }],
            }],
            shielded_instance_config={
                "enable_secure_boot": True,
                "enable_integrity_monitoring": False,
            },
            network_interfaces=[{
                "network": "spot-network",
            }],
            instance_types_ondemand="n1-standard-1",
            instance_types_preemptibles=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            instance_types_customs=[{
                "vcpu": 2,
                "memory_gib": 7,
            }],
            subnets=[{
                "region": "asia-east1",
                "subnet_names": ["default"],
            }],
            scaling_up_policies=[{
                "policy_name": "scale_up_1",
                "source": "stackdriver",
                "metric_name": "instance/disk/read_ops_count",
                "namespace": "compute",
                "statistic": "average",
                "unit": "percent",
                "threshold": 10000,
                "period": 300,
                "cooldown": 300,
                "operator": "gte",
                "evaluation_periods": 1,
                "action_type": "adjustment",
                "adjustment": 1,
                "dimensions": [{
                    "name": "storage_type",
                    "value": "pd-ssd",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: List of availability zones for the group.
        :param pulumi.Input[_builtins.str] description: The region your GCP group will be created in.
        :param pulumi.Input[_builtins.int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[_builtins.int] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[_builtins.str] instance_name_prefix: Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
               * A maximal length of 25 characters.
               * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
               * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        :param pulumi.Input[_builtins.str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]] labels: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Select a minimum CPU platform for the compute instance.
        :param pulumi.Input[_builtins.int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optimization_windows: Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        :param pulumi.Input[_builtins.int] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        :param pulumi.Input[_builtins.str] provisioning_model: Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]] revert_to_preemptibles: Setting for revert to preemptible option.
        :param pulumi.Input[_builtins.str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']] shielded_instance_config: You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        :param pulumi.Input[_builtins.bool] should_utilize_commitments: Enable committed use discounts utilization.
        :param pulumi.Input[_builtins.str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[_builtins.str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSubnetArgs', 'ElastigroupSubnetArgsDict']]]] subnets: A list of regions and subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to mark created instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElastigroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Spotinst elastigroup GCP resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gcp.Elastigroup("example",
            name="example-gcp",
            description="spotinst gcp group",
            service_account="example@myProject.iam.gservicecct.com",
            startup_script="",
            instance_name_prefix="test-123a",
            min_cpu_platform="Intel Sandy Bridge",
            min_size=0,
            max_size=1,
            desired_capacity=1,
            availability_zones=[
                "asia-east1-c",
                "us-central1-a",
            ],
            preferred_availability_zones=["us-central1-a"],
            preemptible_percentage=50,
            revert_to_preemptibles=[{
                "perform_at": "timeWindow",
            }],
            optimization_windows=["Mon:01:00-Mon:03:00"],
            fallback_to_ondemand=True,
            draining_timeout=180,
            provisioning_model="SPOT",
            should_utilize_commitments=True,
            labels=[{
                "key": "test_key",
                "value": "test_value",
            }],
            tags=[
                "http",
                "https",
            ],
            backend_services=[{
                "service_name": "spotinst-elb-backend-service",
                "location_type": "regional",
                "scheme": "INTERNAL",
                "named_ports": [{
                    "name": "port-name",
                    "ports": [
                        "8000",
                        "6000",
                    ],
                }],
                "backend_balancing": {
                    "backend_balancing_mode": "RATE",
                    "max_rate_per_instance": 500,
                },
            }],
            disks=[{
                "device_name": "device",
                "mode": "READ_WRITE",
                "type": "PERSISTENT",
                "auto_delete": True,
                "boot": True,
                "interface": "SCSI",
                "initialize_params": [{
                    "disk_size_gb": "10",
                    "disk_type": "pd-standard",
                    "source_image": "",
                }],
            }],
            shielded_instance_config={
                "enable_secure_boot": True,
                "enable_integrity_monitoring": False,
            },
            network_interfaces=[{
                "network": "spot-network",
            }],
            instance_types_ondemand="n1-standard-1",
            instance_types_preemptibles=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            instance_types_customs=[{
                "vcpu": 2,
                "memory_gib": 7,
            }],
            subnets=[{
                "region": "asia-east1",
                "subnet_names": ["default"],
            }],
            scaling_up_policies=[{
                "policy_name": "scale_up_1",
                "source": "stackdriver",
                "metric_name": "instance/disk/read_ops_count",
                "namespace": "compute",
                "statistic": "average",
                "unit": "percent",
                "threshold": 10000,
                "period": 300,
                "cooldown": 300,
                "operator": "gte",
                "evaluation_periods": 1,
                "action_type": "adjustment",
                "adjustment": 1,
                "dimensions": [{
                    "name": "storage_type",
                    "value": "pd-ssd",
                }],
            }])
        ```

        :param str resource_name: The name of the resource.
        :param ElastigroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElastigroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_healing: Optional[pulumi.Input[_builtins.bool]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
                 health_check_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
                 health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
                 instance_types_ondemand: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
                 integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
                 ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
                 min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
                 ondemand_count: Optional[pulumi.Input[_builtins.int]] = None,
                 optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preemptible_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 provisioning_model: Optional[pulumi.Input[_builtins.str]] = None,
                 revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
                 scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
                 scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
                 should_utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_script: Optional[pulumi.Input[_builtins.str]] = None,
                 startup_script: Optional[pulumi.Input[_builtins.str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSubnetArgs', 'ElastigroupSubnetArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 unhealthy_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElastigroupArgs.__new__(ElastigroupArgs)

            __props__.__dict__["auto_healing"] = auto_healing
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["backend_services"] = backend_services
            __props__.__dict__["description"] = description
            if desired_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'desired_capacity'")
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["disks"] = disks
            __props__.__dict__["draining_timeout"] = draining_timeout
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["gpu"] = gpu
            __props__.__dict__["health_check_grace_period"] = health_check_grace_period
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["instance_name_prefix"] = instance_name_prefix
            __props__.__dict__["instance_types_customs"] = instance_types_customs
            __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
            __props__.__dict__["instance_types_preemptibles"] = instance_types_preemptibles
            __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
            __props__.__dict__["integration_gke"] = integration_gke
            __props__.__dict__["ip_forwarding"] = ip_forwarding
            __props__.__dict__["labels"] = labels
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["metadatas"] = metadatas
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["ondemand_count"] = ondemand_count
            __props__.__dict__["optimization_windows"] = optimization_windows
            __props__.__dict__["preemptible_percentage"] = preemptible_percentage
            __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
            __props__.__dict__["provisioning_model"] = provisioning_model
            __props__.__dict__["revert_to_preemptibles"] = revert_to_preemptibles
            __props__.__dict__["scaling_down_policies"] = scaling_down_policies
            __props__.__dict__["scaling_up_policies"] = scaling_up_policies
            __props__.__dict__["scheduled_tasks"] = scheduled_tasks
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["should_utilize_commitments"] = should_utilize_commitments
            __props__.__dict__["shutdown_script"] = shutdown_script
            __props__.__dict__["startup_script"] = startup_script
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unhealthy_duration"] = unhealthy_duration
        super(Elastigroup, __self__).__init__(
            'spotinst:gcp/elastigroup:Elastigroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_healing: Optional[pulumi.Input[_builtins.bool]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupBackendServiceArgs', 'ElastigroupBackendServiceArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupDiskArgs', 'ElastigroupDiskArgsDict']]]]] = None,
            draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
            gpu: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupGpuArgs', 'ElastigroupGpuArgsDict']]]]] = None,
            health_check_grace_period: Optional[pulumi.Input[_builtins.int]] = None,
            health_check_type: Optional[pulumi.Input[_builtins.str]] = None,
            instance_name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            instance_types_customs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]]] = None,
            instance_types_ondemand: Optional[pulumi.Input[_builtins.str]] = None,
            instance_types_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            integration_docker_swarm: Optional[pulumi.Input[Union['ElastigroupIntegrationDockerSwarmArgs', 'ElastigroupIntegrationDockerSwarmArgsDict']]] = None,
            integration_gke: Optional[pulumi.Input[Union['ElastigroupIntegrationGkeArgs', 'ElastigroupIntegrationGkeArgsDict']]] = None,
            ip_forwarding: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]]] = None,
            max_size: Optional[pulumi.Input[_builtins.int]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]]] = None,
            min_cpu_platform: Optional[pulumi.Input[_builtins.str]] = None,
            min_size: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupNetworkInterfaceArgs', 'ElastigroupNetworkInterfaceArgsDict']]]]] = None,
            ondemand_count: Optional[pulumi.Input[_builtins.int]] = None,
            optimization_windows: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preemptible_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            preferred_availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            provisioning_model: Optional[pulumi.Input[_builtins.str]] = None,
            revert_to_preemptibles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]]] = None,
            scaling_down_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingDownPolicyArgs', 'ElastigroupScalingDownPolicyArgsDict']]]]] = None,
            scaling_up_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScalingUpPolicyArgs', 'ElastigroupScalingUpPolicyArgsDict']]]]] = None,
            scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupScheduledTaskArgs', 'ElastigroupScheduledTaskArgsDict']]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']]] = None,
            should_utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
            shutdown_script: Optional[pulumi.Input[_builtins.str]] = None,
            startup_script: Optional[pulumi.Input[_builtins.str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSubnetArgs', 'ElastigroupSubnetArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            unhealthy_duration: Optional[pulumi.Input[_builtins.int]] = None) -> 'Elastigroup':
        """
        Get an existing Elastigroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: List of availability zones for the group.
        :param pulumi.Input[_builtins.str] description: The region your GCP group will be created in.
        :param pulumi.Input[_builtins.int] desired_capacity: The desired number of instances the group should have at any time.
        :param pulumi.Input[_builtins.int] draining_timeout: Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        :param pulumi.Input[_builtins.str] instance_name_prefix: Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
               * A maximal length of 25 characters.
               * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupInstanceTypesCustomArgs', 'ElastigroupInstanceTypesCustomArgsDict']]]] instance_types_customs: Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
               * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        :param pulumi.Input[_builtins.str] instance_types_ondemand: The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_types_preemptibles: The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupLabelArgs', 'ElastigroupLabelArgsDict']]]] labels: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.int] max_size: The maximum number of instances the group should have at any time.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupMetadataArgs', 'ElastigroupMetadataArgsDict']]]] metadatas: Array of objects with key-value pairs.
        :param pulumi.Input[_builtins.str] min_cpu_platform: Select a minimum CPU platform for the compute instance.
        :param pulumi.Input[_builtins.int] min_size: The minimum number of instances the group should have at any time.
        :param pulumi.Input[_builtins.str] name: The group name.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] optimization_windows: Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        :param pulumi.Input[_builtins.int] preemptible_percentage: Percentage of Preemptible VMs to spin up from the "desired_capacity".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] preferred_availability_zones: prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        :param pulumi.Input[_builtins.str] provisioning_model: Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupRevertToPreemptibleArgs', 'ElastigroupRevertToPreemptibleArgsDict']]]] revert_to_preemptibles: Setting for revert to preemptible option.
        :param pulumi.Input[_builtins.str] service_account: The email of the service account in which the group instances will be launched.
        :param pulumi.Input[Union['ElastigroupShieldedInstanceConfigArgs', 'ElastigroupShieldedInstanceConfigArgsDict']] shielded_instance_config: You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        :param pulumi.Input[_builtins.bool] should_utilize_commitments: Enable committed use discounts utilization.
        :param pulumi.Input[_builtins.str] shutdown_script: The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        :param pulumi.Input[_builtins.str] startup_script: Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ElastigroupSubnetArgs', 'ElastigroupSubnetArgsDict']]]] subnets: A list of regions and subnets.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: Tags to mark created instances.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElastigroupState.__new__(_ElastigroupState)

        __props__.__dict__["auto_healing"] = auto_healing
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["backend_services"] = backend_services
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["disks"] = disks
        __props__.__dict__["draining_timeout"] = draining_timeout
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["gpu"] = gpu
        __props__.__dict__["health_check_grace_period"] = health_check_grace_period
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["instance_name_prefix"] = instance_name_prefix
        __props__.__dict__["instance_types_customs"] = instance_types_customs
        __props__.__dict__["instance_types_ondemand"] = instance_types_ondemand
        __props__.__dict__["instance_types_preemptibles"] = instance_types_preemptibles
        __props__.__dict__["integration_docker_swarm"] = integration_docker_swarm
        __props__.__dict__["integration_gke"] = integration_gke
        __props__.__dict__["ip_forwarding"] = ip_forwarding
        __props__.__dict__["labels"] = labels
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["ondemand_count"] = ondemand_count
        __props__.__dict__["optimization_windows"] = optimization_windows
        __props__.__dict__["preemptible_percentage"] = preemptible_percentage
        __props__.__dict__["preferred_availability_zones"] = preferred_availability_zones
        __props__.__dict__["provisioning_model"] = provisioning_model
        __props__.__dict__["revert_to_preemptibles"] = revert_to_preemptibles
        __props__.__dict__["scaling_down_policies"] = scaling_down_policies
        __props__.__dict__["scaling_up_policies"] = scaling_up_policies
        __props__.__dict__["scheduled_tasks"] = scheduled_tasks
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["should_utilize_commitments"] = should_utilize_commitments
        __props__.__dict__["shutdown_script"] = shutdown_script
        __props__.__dict__["startup_script"] = startup_script
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unhealthy_duration"] = unhealthy_duration
        return Elastigroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoHealing")
    def auto_healing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "auto_healing")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    @_utilities.deprecated("""This field will soon be handled by Region in Subnets""")
    def availability_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of availability zones for the group.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupBackendService']]]:
        return pulumi.get(self, "backend_services")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region your GCP group will be created in.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The desired number of instances the group should have at any time.
        """
        return pulumi.get(self, "desired_capacity")

    @_builtins.property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupDisk']]]:
        return pulumi.get(self, "disks")

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time (seconds) the instance is allowed to run after it is detached from the group. This is to allow the instance time to drain all the current TCP connections before terminating it.
        """
        return pulumi.get(self, "draining_timeout")

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Activate fallback-to-on-demand. When provisioning an instance, if no Preemptible market is available, fallback-to-on-demand will provision an On-Demand instance to maintain the group capacity.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @_builtins.property
    @pulumi.getter
    def gpu(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupGpu']]]:
        return pulumi.get(self, "gpu")

    @_builtins.property
    @pulumi.getter(name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "health_check_grace_period")

    @_builtins.property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "health_check_type")

    @_builtins.property
    @pulumi.getter(name="instanceNamePrefix")
    def instance_name_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set an instance name prefix to be used for all launched instances and their boot disk. The prefix value should comply with the following limitations: 
        * A maximal length of 25 characters.
        * The first character must be a lowercase letter, and all the following characters must be hyphens, lowercase letters, or digits, except the last character, which cannot be a hyphen.
        """
        return pulumi.get(self, "instance_name_prefix")

    @_builtins.property
    @pulumi.getter(name="instanceTypesCustoms")
    def instance_types_customs(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupInstanceTypesCustom']]]:
        """
        Defines a set of custom instance types. Required if instance_types_preemptible and instance_types_ondemand are not set.
        * `vCPU` - (Optional) The number of vCPUs in the custom instance type. GCP has a number of limitations on accepted vCPU values. For more information, see the GCP documentation (here.)[https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#specifications]
        """
        return pulumi.get(self, "instance_types_customs")

    @_builtins.property
    @pulumi.getter(name="instanceTypesOndemand")
    def instance_types_ondemand(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The regular VM instance type to use for mixed-type groups and when falling back to on-demand. Required if instance_types_preemptible is not set.
        """
        return pulumi.get(self, "instance_types_ondemand")

    @_builtins.property
    @pulumi.getter(name="instanceTypesPreemptibles")
    def instance_types_preemptibles(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The preemptible VMs instance type. To maximize cost savings and market availability, select as many types as possible. Required if instance_types_ondemand is not set.
        """
        return pulumi.get(self, "instance_types_preemptibles")

    @_builtins.property
    @pulumi.getter(name="integrationDockerSwarm")
    def integration_docker_swarm(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationDockerSwarm']]:
        return pulumi.get(self, "integration_docker_swarm")

    @_builtins.property
    @pulumi.getter(name="integrationGke")
    def integration_gke(self) -> pulumi.Output[Optional['outputs.ElastigroupIntegrationGke']]:
        return pulumi.get(self, "integration_gke")

    @_builtins.property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "ip_forwarding")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupLabel']]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of instances the group should have at any time.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupMetadata']]]:
        """
        Array of objects with key-value pairs.
        """
        return pulumi.get(self, "metadatas")

    @_builtins.property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Select a minimum CPU platform for the compute instance.
        """
        return pulumi.get(self, "min_cpu_platform")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[_builtins.int]:
        """
        The minimum number of instances the group should have at any time.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupNetworkInterface']]]:
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="ondemandCount")
    def ondemand_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "ondemand_count")

    @_builtins.property
    @pulumi.getter(name="optimizationWindows")
    def optimization_windows(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set time window to perform the revert to preemptible. Time windows must be at least 120 minutes. Format: DayInWeek:HH-DayInWeek:HH. Required when strategy.revertToPreemptible.performAt is 'timeWindow'.
        """
        return pulumi.get(self, "optimization_windows")

    @_builtins.property
    @pulumi.getter(name="preemptiblePercentage")
    def preemptible_percentage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Percentage of Preemptible VMs to spin up from the "desired_capacity".
        """
        return pulumi.get(self, "preemptible_percentage")

    @_builtins.property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        prioritize availability zones when launching instances for the group. Must be a sublist of `availability_zones`.
        """
        return pulumi.get(self, "preferred_availability_zones")

    @_builtins.property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Valid values: "SPOT", "PREEMPTIBLE". Define the provisioning model of the launched instances. Default value is "PREEMPTIBLE".
        """
        return pulumi.get(self, "provisioning_model")

    @_builtins.property
    @pulumi.getter(name="revertToPreemptibles")
    def revert_to_preemptibles(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupRevertToPreemptible']]]:
        """
        Setting for revert to preemptible option.
        """
        return pulumi.get(self, "revert_to_preemptibles")

    @_builtins.property
    @pulumi.getter(name="scalingDownPolicies")
    def scaling_down_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingDownPolicy']]]:
        return pulumi.get(self, "scaling_down_policies")

    @_builtins.property
    @pulumi.getter(name="scalingUpPolicies")
    def scaling_up_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScalingUpPolicy']]]:
        return pulumi.get(self, "scaling_up_policies")

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupScheduledTask']]]:
        return pulumi.get(self, "scheduled_tasks")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The email of the service account in which the group instances will be launched.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output[Optional['outputs.ElastigroupShieldedInstanceConfig']]:
        """
        You can use secure boot when you launch VMs using Elastigroup. This helps you comply with your security policies. In the instance configuration, use ‘secureBootEnabled’ set to True to enforce UEFI with secure boot. Elastigroup provisions VMs with secure boot, as long as the images supports UEFI.
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter(name="shouldUtilizeCommitments")
    def should_utilize_commitments(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable committed use discounts utilization.
        """
        return pulumi.get(self, "should_utilize_commitments")

    @_builtins.property
    @pulumi.getter(name="shutdownScript")
    def shutdown_script(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Base64-encoded shutdown script that executes prior to instance termination, for more information please see: [Shutdown Script](https://api.spotinst.com/integration-docs/elastigroup/concepts/compute-concepts/shutdown-scripts/)
        """
        return pulumi.get(self, "shutdown_script")

    @_builtins.property
    @pulumi.getter(name="startupScript")
    def startup_script(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Create and run your own startup scripts on your virtual machines to perform automated tasks every time your instance boots up.
        """
        return pulumi.get(self, "startup_script")

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence['outputs.ElastigroupSubnet']]]:
        """
        A list of regions and subnets.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Tags to mark created instances.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="unhealthyDuration")
    def unhealthy_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "unhealthy_duration")

