# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VerificationProviderArgs', 'VerificationProvider']

@pulumi.input_type
class VerificationProviderArgs:
    def __init__(__self__, *,
                 cluster_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cloud_watch: Optional[pulumi.Input['VerificationProviderCloudWatchArgs']] = None,
                 datadog: Optional[pulumi.Input['VerificationProviderDatadogArgs']] = None,
                 jenkins: Optional[pulumi.Input['VerificationProviderJenkinsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_relic: Optional[pulumi.Input['VerificationProviderNewRelicArgs']] = None,
                 prometheus: Optional[pulumi.Input['VerificationProviderPrometheusArgs']] = None):
        """
        The set of arguments for constructing a VerificationProvider resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_ids: List of cluster IDs that this Verification Provider will be applied to.
        :param pulumi.Input['VerificationProviderCloudWatchArgs'] cloud_watch: Specify the credentials for CloudWatch verification provider.
        :param pulumi.Input['VerificationProviderDatadogArgs'] datadog: Specify the credentials for datadog verification provider.
        :param pulumi.Input['VerificationProviderJenkinsArgs'] jenkins: Specify the credentials for Jenkins verification provider.
        :param pulumi.Input[_builtins.str] name: Identifier name for Ocean CD Verification Provider. Must be unique.
        :param pulumi.Input['VerificationProviderNewRelicArgs'] new_relic: Specify the credentials for New Relic verification provider.
        :param pulumi.Input['VerificationProviderPrometheusArgs'] prometheus: Specify the credentials for prometheus verification provider.
        """
        pulumi.set(__self__, "cluster_ids", cluster_ids)
        if cloud_watch is not None:
            pulumi.set(__self__, "cloud_watch", cloud_watch)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if jenkins is not None:
            pulumi.set(__self__, "jenkins", jenkins)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_relic is not None:
            pulumi.set(__self__, "new_relic", new_relic)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)

    @_builtins.property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of cluster IDs that this Verification Provider will be applied to.
        """
        return pulumi.get(self, "cluster_ids")

    @cluster_ids.setter
    def cluster_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "cluster_ids", value)

    @_builtins.property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> Optional[pulumi.Input['VerificationProviderCloudWatchArgs']]:
        """
        Specify the credentials for CloudWatch verification provider.
        """
        return pulumi.get(self, "cloud_watch")

    @cloud_watch.setter
    def cloud_watch(self, value: Optional[pulumi.Input['VerificationProviderCloudWatchArgs']]):
        pulumi.set(self, "cloud_watch", value)

    @_builtins.property
    @pulumi.getter
    def datadog(self) -> Optional[pulumi.Input['VerificationProviderDatadogArgs']]:
        """
        Specify the credentials for datadog verification provider.
        """
        return pulumi.get(self, "datadog")

    @datadog.setter
    def datadog(self, value: Optional[pulumi.Input['VerificationProviderDatadogArgs']]):
        pulumi.set(self, "datadog", value)

    @_builtins.property
    @pulumi.getter
    def jenkins(self) -> Optional[pulumi.Input['VerificationProviderJenkinsArgs']]:
        """
        Specify the credentials for Jenkins verification provider.
        """
        return pulumi.get(self, "jenkins")

    @jenkins.setter
    def jenkins(self, value: Optional[pulumi.Input['VerificationProviderJenkinsArgs']]):
        pulumi.set(self, "jenkins", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier name for Ocean CD Verification Provider. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newRelic")
    def new_relic(self) -> Optional[pulumi.Input['VerificationProviderNewRelicArgs']]:
        """
        Specify the credentials for New Relic verification provider.
        """
        return pulumi.get(self, "new_relic")

    @new_relic.setter
    def new_relic(self, value: Optional[pulumi.Input['VerificationProviderNewRelicArgs']]):
        pulumi.set(self, "new_relic", value)

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> Optional[pulumi.Input['VerificationProviderPrometheusArgs']]:
        """
        Specify the credentials for prometheus verification provider.
        """
        return pulumi.get(self, "prometheus")

    @prometheus.setter
    def prometheus(self, value: Optional[pulumi.Input['VerificationProviderPrometheusArgs']]):
        pulumi.set(self, "prometheus", value)


@pulumi.input_type
class _VerificationProviderState:
    def __init__(__self__, *,
                 cloud_watch: Optional[pulumi.Input['VerificationProviderCloudWatchArgs']] = None,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 datadog: Optional[pulumi.Input['VerificationProviderDatadogArgs']] = None,
                 jenkins: Optional[pulumi.Input['VerificationProviderJenkinsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_relic: Optional[pulumi.Input['VerificationProviderNewRelicArgs']] = None,
                 prometheus: Optional[pulumi.Input['VerificationProviderPrometheusArgs']] = None):
        """
        Input properties used for looking up and filtering VerificationProvider resources.
        :param pulumi.Input['VerificationProviderCloudWatchArgs'] cloud_watch: Specify the credentials for CloudWatch verification provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_ids: List of cluster IDs that this Verification Provider will be applied to.
        :param pulumi.Input['VerificationProviderDatadogArgs'] datadog: Specify the credentials for datadog verification provider.
        :param pulumi.Input['VerificationProviderJenkinsArgs'] jenkins: Specify the credentials for Jenkins verification provider.
        :param pulumi.Input[_builtins.str] name: Identifier name for Ocean CD Verification Provider. Must be unique.
        :param pulumi.Input['VerificationProviderNewRelicArgs'] new_relic: Specify the credentials for New Relic verification provider.
        :param pulumi.Input['VerificationProviderPrometheusArgs'] prometheus: Specify the credentials for prometheus verification provider.
        """
        if cloud_watch is not None:
            pulumi.set(__self__, "cloud_watch", cloud_watch)
        if cluster_ids is not None:
            pulumi.set(__self__, "cluster_ids", cluster_ids)
        if datadog is not None:
            pulumi.set(__self__, "datadog", datadog)
        if jenkins is not None:
            pulumi.set(__self__, "jenkins", jenkins)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_relic is not None:
            pulumi.set(__self__, "new_relic", new_relic)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)

    @_builtins.property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> Optional[pulumi.Input['VerificationProviderCloudWatchArgs']]:
        """
        Specify the credentials for CloudWatch verification provider.
        """
        return pulumi.get(self, "cloud_watch")

    @cloud_watch.setter
    def cloud_watch(self, value: Optional[pulumi.Input['VerificationProviderCloudWatchArgs']]):
        pulumi.set(self, "cloud_watch", value)

    @_builtins.property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of cluster IDs that this Verification Provider will be applied to.
        """
        return pulumi.get(self, "cluster_ids")

    @cluster_ids.setter
    def cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cluster_ids", value)

    @_builtins.property
    @pulumi.getter
    def datadog(self) -> Optional[pulumi.Input['VerificationProviderDatadogArgs']]:
        """
        Specify the credentials for datadog verification provider.
        """
        return pulumi.get(self, "datadog")

    @datadog.setter
    def datadog(self, value: Optional[pulumi.Input['VerificationProviderDatadogArgs']]):
        pulumi.set(self, "datadog", value)

    @_builtins.property
    @pulumi.getter
    def jenkins(self) -> Optional[pulumi.Input['VerificationProviderJenkinsArgs']]:
        """
        Specify the credentials for Jenkins verification provider.
        """
        return pulumi.get(self, "jenkins")

    @jenkins.setter
    def jenkins(self, value: Optional[pulumi.Input['VerificationProviderJenkinsArgs']]):
        pulumi.set(self, "jenkins", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier name for Ocean CD Verification Provider. Must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newRelic")
    def new_relic(self) -> Optional[pulumi.Input['VerificationProviderNewRelicArgs']]:
        """
        Specify the credentials for New Relic verification provider.
        """
        return pulumi.get(self, "new_relic")

    @new_relic.setter
    def new_relic(self, value: Optional[pulumi.Input['VerificationProviderNewRelicArgs']]):
        pulumi.set(self, "new_relic", value)

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> Optional[pulumi.Input['VerificationProviderPrometheusArgs']]:
        """
        Specify the credentials for prometheus verification provider.
        """
        return pulumi.get(self, "prometheus")

    @prometheus.setter
    def prometheus(self, value: Optional[pulumi.Input['VerificationProviderPrometheusArgs']]):
        pulumi.set(self, "prometheus", value)


@pulumi.type_token("spotinst:oceancd/verificationProvider:VerificationProvider")
class VerificationProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch: Optional[pulumi.Input[Union['VerificationProviderCloudWatchArgs', 'VerificationProviderCloudWatchArgsDict']]] = None,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 datadog: Optional[pulumi.Input[Union['VerificationProviderDatadogArgs', 'VerificationProviderDatadogArgsDict']]] = None,
                 jenkins: Optional[pulumi.Input[Union['VerificationProviderJenkinsArgs', 'VerificationProviderJenkinsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_relic: Optional[pulumi.Input[Union['VerificationProviderNewRelicArgs', 'VerificationProviderNewRelicArgsDict']]] = None,
                 prometheus: Optional[pulumi.Input[Union['VerificationProviderPrometheusArgs', 'VerificationProviderPrometheusArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Spotinst OceanCD Verfification Provider resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.oceancd.VerificationProvider("example",
            name="test-verification-provider",
            cluster_ids=[
                "Example-Cluster-Id-1",
                "Example-Cluster-Id-2",
                "Example-Cluster-Id-3",
            ],
            datadog={
                "address": "1024",
                "api_key": "512",
                "app_key": "0",
            },
            cloud_watch={
                "iam_arn": "arn:aws:iam::123456789012:role/GetMetricData",
            },
            prometheus={
                "address": "http://localhost:9090",
            },
            new_relic={
                "personal_api_key": "AUO32RN20oUMD-40283",
                "account_id": "account-0189718",
                "region": "eu",
                "base_url_rest": "https://rest.api.newrelic.eu",
                "base_url_nerd_graph": "https://nerdgraph.api.newrelic.eu",
            },
            jenkins={
                "base_url": "http://localhost:9090",
                "username": "test-user",
                "api_token": "AbCDeeFFGG",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VerificationProviderCloudWatchArgs', 'VerificationProviderCloudWatchArgsDict']] cloud_watch: Specify the credentials for CloudWatch verification provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_ids: List of cluster IDs that this Verification Provider will be applied to.
        :param pulumi.Input[Union['VerificationProviderDatadogArgs', 'VerificationProviderDatadogArgsDict']] datadog: Specify the credentials for datadog verification provider.
        :param pulumi.Input[Union['VerificationProviderJenkinsArgs', 'VerificationProviderJenkinsArgsDict']] jenkins: Specify the credentials for Jenkins verification provider.
        :param pulumi.Input[_builtins.str] name: Identifier name for Ocean CD Verification Provider. Must be unique.
        :param pulumi.Input[Union['VerificationProviderNewRelicArgs', 'VerificationProviderNewRelicArgsDict']] new_relic: Specify the credentials for New Relic verification provider.
        :param pulumi.Input[Union['VerificationProviderPrometheusArgs', 'VerificationProviderPrometheusArgsDict']] prometheus: Specify the credentials for prometheus verification provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VerificationProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spotinst OceanCD Verfification Provider resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.oceancd.VerificationProvider("example",
            name="test-verification-provider",
            cluster_ids=[
                "Example-Cluster-Id-1",
                "Example-Cluster-Id-2",
                "Example-Cluster-Id-3",
            ],
            datadog={
                "address": "1024",
                "api_key": "512",
                "app_key": "0",
            },
            cloud_watch={
                "iam_arn": "arn:aws:iam::123456789012:role/GetMetricData",
            },
            prometheus={
                "address": "http://localhost:9090",
            },
            new_relic={
                "personal_api_key": "AUO32RN20oUMD-40283",
                "account_id": "account-0189718",
                "region": "eu",
                "base_url_rest": "https://rest.api.newrelic.eu",
                "base_url_nerd_graph": "https://nerdgraph.api.newrelic.eu",
            },
            jenkins={
                "base_url": "http://localhost:9090",
                "username": "test-user",
                "api_token": "AbCDeeFFGG",
            })
        ```

        :param str resource_name: The name of the resource.
        :param VerificationProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VerificationProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_watch: Optional[pulumi.Input[Union['VerificationProviderCloudWatchArgs', 'VerificationProviderCloudWatchArgsDict']]] = None,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 datadog: Optional[pulumi.Input[Union['VerificationProviderDatadogArgs', 'VerificationProviderDatadogArgsDict']]] = None,
                 jenkins: Optional[pulumi.Input[Union['VerificationProviderJenkinsArgs', 'VerificationProviderJenkinsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_relic: Optional[pulumi.Input[Union['VerificationProviderNewRelicArgs', 'VerificationProviderNewRelicArgsDict']]] = None,
                 prometheus: Optional[pulumi.Input[Union['VerificationProviderPrometheusArgs', 'VerificationProviderPrometheusArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VerificationProviderArgs.__new__(VerificationProviderArgs)

            __props__.__dict__["cloud_watch"] = cloud_watch
            if cluster_ids is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_ids'")
            __props__.__dict__["cluster_ids"] = cluster_ids
            __props__.__dict__["datadog"] = datadog
            __props__.__dict__["jenkins"] = jenkins
            __props__.__dict__["name"] = name
            __props__.__dict__["new_relic"] = new_relic
            __props__.__dict__["prometheus"] = prometheus
        super(VerificationProvider, __self__).__init__(
            'spotinst:oceancd/verificationProvider:VerificationProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_watch: Optional[pulumi.Input[Union['VerificationProviderCloudWatchArgs', 'VerificationProviderCloudWatchArgsDict']]] = None,
            cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            datadog: Optional[pulumi.Input[Union['VerificationProviderDatadogArgs', 'VerificationProviderDatadogArgsDict']]] = None,
            jenkins: Optional[pulumi.Input[Union['VerificationProviderJenkinsArgs', 'VerificationProviderJenkinsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_relic: Optional[pulumi.Input[Union['VerificationProviderNewRelicArgs', 'VerificationProviderNewRelicArgsDict']]] = None,
            prometheus: Optional[pulumi.Input[Union['VerificationProviderPrometheusArgs', 'VerificationProviderPrometheusArgsDict']]] = None) -> 'VerificationProvider':
        """
        Get an existing VerificationProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VerificationProviderCloudWatchArgs', 'VerificationProviderCloudWatchArgsDict']] cloud_watch: Specify the credentials for CloudWatch verification provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cluster_ids: List of cluster IDs that this Verification Provider will be applied to.
        :param pulumi.Input[Union['VerificationProviderDatadogArgs', 'VerificationProviderDatadogArgsDict']] datadog: Specify the credentials for datadog verification provider.
        :param pulumi.Input[Union['VerificationProviderJenkinsArgs', 'VerificationProviderJenkinsArgsDict']] jenkins: Specify the credentials for Jenkins verification provider.
        :param pulumi.Input[_builtins.str] name: Identifier name for Ocean CD Verification Provider. Must be unique.
        :param pulumi.Input[Union['VerificationProviderNewRelicArgs', 'VerificationProviderNewRelicArgsDict']] new_relic: Specify the credentials for New Relic verification provider.
        :param pulumi.Input[Union['VerificationProviderPrometheusArgs', 'VerificationProviderPrometheusArgsDict']] prometheus: Specify the credentials for prometheus verification provider.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VerificationProviderState.__new__(_VerificationProviderState)

        __props__.__dict__["cloud_watch"] = cloud_watch
        __props__.__dict__["cluster_ids"] = cluster_ids
        __props__.__dict__["datadog"] = datadog
        __props__.__dict__["jenkins"] = jenkins
        __props__.__dict__["name"] = name
        __props__.__dict__["new_relic"] = new_relic
        __props__.__dict__["prometheus"] = prometheus
        return VerificationProvider(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudWatch")
    def cloud_watch(self) -> pulumi.Output[Optional['outputs.VerificationProviderCloudWatch']]:
        """
        Specify the credentials for CloudWatch verification provider.
        """
        return pulumi.get(self, "cloud_watch")

    @_builtins.property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of cluster IDs that this Verification Provider will be applied to.
        """
        return pulumi.get(self, "cluster_ids")

    @_builtins.property
    @pulumi.getter
    def datadog(self) -> pulumi.Output[Optional['outputs.VerificationProviderDatadog']]:
        """
        Specify the credentials for datadog verification provider.
        """
        return pulumi.get(self, "datadog")

    @_builtins.property
    @pulumi.getter
    def jenkins(self) -> pulumi.Output[Optional['outputs.VerificationProviderJenkins']]:
        """
        Specify the credentials for Jenkins verification provider.
        """
        return pulumi.get(self, "jenkins")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier name for Ocean CD Verification Provider. Must be unique.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newRelic")
    def new_relic(self) -> pulumi.Output[Optional['outputs.VerificationProviderNewRelic']]:
        """
        Specify the credentials for New Relic verification provider.
        """
        return pulumi.get(self, "new_relic")

    @_builtins.property
    @pulumi.getter
    def prometheus(self) -> pulumi.Output[Optional['outputs.VerificationProviderPrometheus']]:
        """
        Specify the credentials for prometheus verification provider.
        """
        return pulumi.get(self, "prometheus")

