# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyPolicyContentArgs',
    'PolicyPolicyContentArgsDict',
    'PolicyPolicyContentStatementArgs',
    'PolicyPolicyContentStatementArgsDict',
    'ProgrammaticUserAccountArgs',
    'ProgrammaticUserAccountArgsDict',
    'ProgrammaticUserPolicyArgs',
    'ProgrammaticUserPolicyArgsDict',
    'UserGroupPolicyArgs',
    'UserGroupPolicyArgsDict',
    'UserPolicyArgs',
    'UserPolicyArgsDict',
]

MYPY = False

if not MYPY:
    class PolicyPolicyContentArgsDict(TypedDict):
        statements: pulumi.Input[Sequence[pulumi.Input['PolicyPolicyContentStatementArgsDict']]]
        """
        List of permissions statements.
        """
elif False:
    PolicyPolicyContentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyPolicyContentArgs:
    def __init__(__self__, *,
                 statements: pulumi.Input[Sequence[pulumi.Input['PolicyPolicyContentStatementArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['PolicyPolicyContentStatementArgs']]] statements: List of permissions statements.
        """
        pulumi.set(__self__, "statements", statements)

    @_builtins.property
    @pulumi.getter
    def statements(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyPolicyContentStatementArgs']]]:
        """
        List of permissions statements.
        """
        return pulumi.get(self, "statements")

    @statements.setter
    def statements(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyPolicyContentStatementArgs']]]):
        pulumi.set(self, "statements", value)


if not MYPY:
    class PolicyPolicyContentStatementArgsDict(TypedDict):
        actions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Set a list of required actions for this permissions statement.
        Full list of actions can be found in [https://docs.spot.io/account-user-management/user-management/access-policies-actions/](https://docs.spot.io/account-user-management/user-management/access-policies-actions/).
        """
        effect: pulumi.Input[_builtins.str]
        """
        Valid values "ALLOW", "DENY".
        """
        resources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Set a list of resources IDs. In order to include all resources in this statement - use "*".
        """
elif False:
    PolicyPolicyContentStatementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyPolicyContentStatementArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 effect: pulumi.Input[_builtins.str],
                 resources: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: Set a list of required actions for this permissions statement.
               Full list of actions can be found in [https://docs.spot.io/account-user-management/user-management/access-policies-actions/](https://docs.spot.io/account-user-management/user-management/access-policies-actions/).
        :param pulumi.Input[_builtins.str] effect: Valid values "ALLOW", "DENY".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] resources: Set a list of resources IDs. In order to include all resources in this statement - use "*".
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "resources", resources)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set a list of required actions for this permissions statement.
        Full list of actions can be found in [https://docs.spot.io/account-user-management/user-management/access-policies-actions/](https://docs.spot.io/account-user-management/user-management/access-policies-actions/).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def effect(self) -> pulumi.Input[_builtins.str]:
        """
        Valid values "ALLOW", "DENY".
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "effect", value)

    @_builtins.property
    @pulumi.getter
    def resources(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Set a list of resources IDs. In order to include all resources in this statement - use "*".
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "resources", value)


if not MYPY:
    class ProgrammaticUserAccountArgsDict(TypedDict):
        account_id: pulumi.Input[_builtins.str]
        """
        Account ID the programmatic user will have access to.
        """
        account_role: pulumi.Input[_builtins.str]
        """
        (Enum: `"viewer", "editor") Role to be associated with the
        programmatic user for this account.
        """
elif False:
    ProgrammaticUserAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProgrammaticUserAccountArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 account_role: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] account_id: Account ID the programmatic user will have access to.
        :param pulumi.Input[_builtins.str] account_role: (Enum: `"viewer", "editor") Role to be associated with the
               programmatic user for this account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "account_role", account_role)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID the programmatic user will have access to.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="accountRole")
    def account_role(self) -> pulumi.Input[_builtins.str]:
        """
        (Enum: `"viewer", "editor") Role to be associated with the
        programmatic user for this account.
        """
        return pulumi.get(self, "account_role")

    @account_role.setter
    def account_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_role", value)


if not MYPY:
    class ProgrammaticUserPolicyArgsDict(TypedDict):
        policy_id: pulumi.Input[_builtins.str]
        """
        Policy ID the programmatic user will have access to.
        """
        policy_account_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of the accounts that the policy should be
        enforced for the user.
        """
elif False:
    ProgrammaticUserPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProgrammaticUserPolicyArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[_builtins.str],
                 policy_account_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] policy_id: Policy ID the programmatic user will have access to.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_account_ids: A list of the accounts that the policy should be
               enforced for the user.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        if policy_account_ids is not None:
            pulumi.set(__self__, "policy_account_ids", policy_account_ids)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Policy ID the programmatic user will have access to.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter(name="policyAccountIds")
    def policy_account_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the accounts that the policy should be
        enforced for the user.
        """
        return pulumi.get(self, "policy_account_ids")

    @policy_account_ids.setter
    def policy_account_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_account_ids", value)


if not MYPY:
    class UserGroupPolicyArgsDict(TypedDict):
        account_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of accounts to register with the assigned under the
        given group (should be existing accounts only).
        """
        policy_id: pulumi.Input[_builtins.str]
        """
        A policy to register under the given group
        (should be existing policy only).
        """
elif False:
    UserGroupPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserGroupPolicyArgs:
    def __init__(__self__, *,
                 account_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 policy_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_ids: A list of accounts to register with the assigned under the
               given group (should be existing accounts only).
        :param pulumi.Input[_builtins.str] policy_id: A policy to register under the given group
               (should be existing policy only).
        """
        pulumi.set(__self__, "account_ids", account_ids)
        pulumi.set(__self__, "policy_id", policy_id)

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of accounts to register with the assigned under the
        given group (should be existing accounts only).
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "account_ids", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        A policy to register under the given group
        (should be existing policy only).
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)


if not MYPY:
    class UserPolicyArgsDict(TypedDict):
        policy_account_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        policy_id: pulumi.Input[_builtins.str]
        """
        A policy to register under the given group
        (should be existing policy only).
        """
elif False:
    UserPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPolicyArgs:
    def __init__(__self__, *,
                 policy_account_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 policy_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] policy_id: A policy to register under the given group
               (should be existing policy only).
        """
        pulumi.set(__self__, "policy_account_ids", policy_account_ids)
        pulumi.set(__self__, "policy_id", policy_id)

    @_builtins.property
    @pulumi.getter(name="policyAccountIds")
    def policy_account_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        return pulumi.get(self, "policy_account_ids")

    @policy_account_ids.setter
    def policy_account_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "policy_account_ids", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        A policy to register under the given group
        (should be existing policy only).
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)


