# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyzerArgs', 'Analyzer']

@pulumi.input_type
class AnalyzerArgs:
    def __init__(__self__, *,
                 analyzer_name: pulumi.Input[_builtins.str],
                 configuration: Optional[pulumi.Input['AnalyzerConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Analyzer resource.
        :param pulumi.Input[_builtins.str] analyzer_name: Name of the Analyzer.
               
               The following arguments are optional:
        :param pulumi.Input['AnalyzerConfigurationArgs'] configuration: A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        pulumi.set(__self__, "analyzer_name", analyzer_name)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="analyzerName")
    def analyzer_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the Analyzer.

        The following arguments are optional:
        """
        return pulumi.get(self, "analyzer_name")

    @analyzer_name.setter
    def analyzer_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "analyzer_name", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AnalyzerConfigurationArgs']]:
        """
        A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AnalyzerConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AnalyzerState:
    def __init__(__self__, *,
                 analyzer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input['AnalyzerConfigurationArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Analyzer resources.
        :param pulumi.Input[_builtins.str] analyzer_name: Name of the Analyzer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] arn: ARN of the Analyzer.
        :param pulumi.Input['AnalyzerConfigurationArgs'] configuration: A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        if analyzer_name is not None:
            pulumi.set(__self__, "analyzer_name", analyzer_name)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="analyzerName")
    def analyzer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Analyzer.

        The following arguments are optional:
        """
        return pulumi.get(self, "analyzer_name")

    @analyzer_name.setter
    def analyzer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "analyzer_name", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Analyzer.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input['AnalyzerConfigurationArgs']]:
        """
        A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input['AnalyzerConfigurationArgs']]):
        pulumi.set(self, "configuration", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:accessanalyzer/analyzer:Analyzer")
class Analyzer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyzer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AnalyzerConfigurationArgs', 'AnalyzerConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Access Analyzer Analyzer. More information can be found in the [Access Analyzer User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html).

        ## Example Usage

        ### Account Analyzer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.accessanalyzer.Analyzer("example", analyzer_name="example")
        ```

        ### Organization Analyzer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.organizations.Organization("example", aws_service_access_principals=["access-analyzer.amazonaws.com"])
        example_analyzer = aws.accessanalyzer.Analyzer("example",
            analyzer_name="example",
            type="ORGANIZATION",
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Organization Unused Access Analyzer With Analysis Rule

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.accessanalyzer.Analyzer("example",
            analyzer_name="example",
            type="ORGANIZATION_UNUSED_ACCESS",
            configuration={
                "unused_access": {
                    "unused_access_age": 180,
                    "analysis_rule": {
                        "exclusions": [
                            {
                                "account_ids": [
                                    "123456789012",
                                    "234567890123",
                                ],
                            },
                            {
                                "resource_tags": [
                                    {
                                        "key1": "value1",
                                    },
                                    {
                                        "key2": "value2",
                                    },
                                ],
                            },
                        ],
                    },
                },
            })
        ```

        ### Account Internal Access Analyzer by Resource Types

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.accessanalyzer.Analyzer("test",
            analyzer_name="example",
            type="ORGANIZATION_INTERNAL_ACCESS",
            configuration={
                "internal_access": {
                    "analysis_rule": {
                        "inclusions": [{
                            "resource_types": [
                                "AWS::S3::Bucket",
                                "AWS::RDS::DBSnapshot",
                                "AWS::DynamoDB::Table",
                            ],
                        }],
                    },
                },
            })
        ```

        ### Organization Internal Access Analyzer by Account ID and Resource ARN

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.accessanalyzer.Analyzer("test",
            analyzer_name="example",
            type="ORGANIZATION_INTERNAL_ACCESS",
            configuration={
                "internal_access": {
                    "analysis_rule": {
                        "inclusions": [{
                            "account_ids": ["123456789012"],
                            "resource_arns": ["arn:aws:s3:::my-example-bucket"],
                        }],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Access Analyzer Analyzers using the `analyzer_name`. For example:

        ```sh
        $ pulumi import aws:accessanalyzer/analyzer:Analyzer example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] analyzer_name: Name of the Analyzer.
               
               The following arguments are optional:
        :param pulumi.Input[Union['AnalyzerConfigurationArgs', 'AnalyzerConfigurationArgsDict']] configuration: A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyzerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Access Analyzer Analyzer. More information can be found in the [Access Analyzer User Guide](https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html).

        ## Example Usage

        ### Account Analyzer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.accessanalyzer.Analyzer("example", analyzer_name="example")
        ```

        ### Organization Analyzer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.organizations.Organization("example", aws_service_access_principals=["access-analyzer.amazonaws.com"])
        example_analyzer = aws.accessanalyzer.Analyzer("example",
            analyzer_name="example",
            type="ORGANIZATION",
            opts = pulumi.ResourceOptions(depends_on=[example]))
        ```

        ### Organization Unused Access Analyzer With Analysis Rule

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.accessanalyzer.Analyzer("example",
            analyzer_name="example",
            type="ORGANIZATION_UNUSED_ACCESS",
            configuration={
                "unused_access": {
                    "unused_access_age": 180,
                    "analysis_rule": {
                        "exclusions": [
                            {
                                "account_ids": [
                                    "123456789012",
                                    "234567890123",
                                ],
                            },
                            {
                                "resource_tags": [
                                    {
                                        "key1": "value1",
                                    },
                                    {
                                        "key2": "value2",
                                    },
                                ],
                            },
                        ],
                    },
                },
            })
        ```

        ### Account Internal Access Analyzer by Resource Types

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.accessanalyzer.Analyzer("test",
            analyzer_name="example",
            type="ORGANIZATION_INTERNAL_ACCESS",
            configuration={
                "internal_access": {
                    "analysis_rule": {
                        "inclusions": [{
                            "resource_types": [
                                "AWS::S3::Bucket",
                                "AWS::RDS::DBSnapshot",
                                "AWS::DynamoDB::Table",
                            ],
                        }],
                    },
                },
            })
        ```

        ### Organization Internal Access Analyzer by Account ID and Resource ARN

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.accessanalyzer.Analyzer("test",
            analyzer_name="example",
            type="ORGANIZATION_INTERNAL_ACCESS",
            configuration={
                "internal_access": {
                    "analysis_rule": {
                        "inclusions": [{
                            "account_ids": ["123456789012"],
                            "resource_arns": ["arn:aws:s3:::my-example-bucket"],
                        }],
                    },
                },
            })
        ```

        ## Import

        Using `pulumi import`, import Access Analyzer Analyzers using the `analyzer_name`. For example:

        ```sh
        $ pulumi import aws:accessanalyzer/analyzer:Analyzer example example
        ```

        :param str resource_name: The name of the resource.
        :param AnalyzerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyzerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyzer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union['AnalyzerConfigurationArgs', 'AnalyzerConfigurationArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyzerArgs.__new__(AnalyzerArgs)

            if analyzer_name is None and not opts.urn:
                raise TypeError("Missing required property 'analyzer_name'")
            __props__.__dict__["analyzer_name"] = analyzer_name
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(Analyzer, __self__).__init__(
            'aws:accessanalyzer/analyzer:Analyzer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analyzer_name: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            configuration: Optional[pulumi.Input[Union['AnalyzerConfigurationArgs', 'AnalyzerConfigurationArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Analyzer':
        """
        Get an existing Analyzer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] analyzer_name: Name of the Analyzer.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] arn: ARN of the Analyzer.
        :param pulumi.Input[Union['AnalyzerConfigurationArgs', 'AnalyzerConfigurationArgsDict']] configuration: A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyzerState.__new__(_AnalyzerState)

        __props__.__dict__["analyzer_name"] = analyzer_name
        __props__.__dict__["arn"] = arn
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return Analyzer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="analyzerName")
    def analyzer_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Analyzer.

        The following arguments are optional:
        """
        return pulumi.get(self, "analyzer_name")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Analyzer.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional['outputs.AnalyzerConfiguration']]:
        """
        A block that specifies the configuration of the analyzer. See `configuration` Block for details.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Type that represents the zone of trust or scope for the analyzer. Valid values are `ACCOUNT`, `ACCOUNT_INTERNAL_ACCESS`, `ACCOUNT_UNUSED_ACCESS`, `ORGANIZATION`, `ORGANIZATION_INTERNAL_ACCESS`, `ORGANIZATION_UNUSED_ACCESS`. Defaults to `ACCOUNT`.
        """
        return pulumi.get(self, "type")

