# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ListenerDefaultAction',
    'ListenerDefaultActionAuthenticateCognito',
    'ListenerDefaultActionAuthenticateOidc',
    'ListenerDefaultActionFixedResponse',
    'ListenerDefaultActionForward',
    'ListenerDefaultActionForwardStickiness',
    'ListenerDefaultActionForwardTargetGroup',
    'ListenerDefaultActionRedirect',
    'ListenerMutualAuthentication',
    'ListenerRuleAction',
    'ListenerRuleActionAuthenticateCognito',
    'ListenerRuleActionAuthenticateOidc',
    'ListenerRuleActionFixedResponse',
    'ListenerRuleActionForward',
    'ListenerRuleActionForwardStickiness',
    'ListenerRuleActionForwardTargetGroup',
    'ListenerRuleActionRedirect',
    'ListenerRuleCondition',
    'ListenerRuleConditionHostHeader',
    'ListenerRuleConditionHttpHeader',
    'ListenerRuleConditionHttpRequestMethod',
    'ListenerRuleConditionPathPattern',
    'ListenerRuleConditionQueryString',
    'ListenerRuleConditionSourceIp',
    'LoadBalancerAccessLogs',
    'LoadBalancerConnectionLogs',
    'LoadBalancerIpamPools',
    'LoadBalancerMinimumLoadBalancerCapacity',
    'LoadBalancerSubnetMapping',
    'TargetGroupHealthCheck',
    'TargetGroupStickiness',
    'TargetGroupTargetFailover',
    'TargetGroupTargetGroupHealth',
    'TargetGroupTargetGroupHealthDnsFailover',
    'TargetGroupTargetGroupHealthUnhealthyStateRouting',
    'TargetGroupTargetHealthState',
    'GetListenerDefaultActionResult',
    'GetListenerDefaultActionAuthenticateCognitoResult',
    'GetListenerDefaultActionAuthenticateOidcResult',
    'GetListenerDefaultActionFixedResponseResult',
    'GetListenerDefaultActionForwardResult',
    'GetListenerDefaultActionForwardStickinessResult',
    'GetListenerDefaultActionForwardTargetGroupResult',
    'GetListenerDefaultActionRedirectResult',
    'GetListenerMutualAuthenticationResult',
    'GetLoadBalancerAccessLogsResult',
    'GetLoadBalancerConnectionLogResult',
    'GetLoadBalancerIpamPoolResult',
    'GetLoadBalancerSubnetMappingResult',
    'GetTargetGroupHealthCheckResult',
    'GetTargetGroupStickinessResult',
]

@pulumi.output_type
class ListenerDefaultAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticateCognito":
            suggest = "authenticate_cognito"
        elif key == "authenticateOidc":
            suggest = "authenticate_oidc"
        elif key == "fixedResponse":
            suggest = "fixed_response"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 authenticate_cognito: Optional['outputs.ListenerDefaultActionAuthenticateCognito'] = None,
                 authenticate_oidc: Optional['outputs.ListenerDefaultActionAuthenticateOidc'] = None,
                 fixed_response: Optional['outputs.ListenerDefaultActionFixedResponse'] = None,
                 forward: Optional['outputs.ListenerDefaultActionForward'] = None,
                 order: Optional[_builtins.int] = None,
                 redirect: Optional['outputs.ListenerDefaultActionRedirect'] = None,
                 target_group_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
               
               The following arguments are optional:
        :param 'ListenerDefaultActionAuthenticateCognitoArgs' authenticate_cognito: Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        :param 'ListenerDefaultActionAuthenticateOidcArgs' authenticate_oidc: Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        :param 'ListenerDefaultActionFixedResponseArgs' fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param 'ListenerDefaultActionForwardArgs' forward: Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        :param _builtins.int order: Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        :param 'ListenerDefaultActionRedirectArgs' redirect: Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        :param _builtins.str target_group_arn: ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.

        The following arguments are optional:
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional['outputs.ListenerDefaultActionAuthenticateCognito']:
        """
        Configuration block for using Amazon Cognito to authenticate users. Specify only when `type` is `authenticate-cognito`. See below.
        """
        return pulumi.get(self, "authenticate_cognito")

    @_builtins.property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional['outputs.ListenerDefaultActionAuthenticateOidc']:
        """
        Configuration block for an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `type` is `authenticate-oidc`. See below.
        """
        return pulumi.get(self, "authenticate_oidc")

    @_builtins.property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerDefaultActionFixedResponse']:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @_builtins.property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerDefaultActionForward']:
        """
        Configuration block for creating an action that distributes requests among one or more target groups. Specify only if `type` is `forward`. See below.
        """
        return pulumi.get(self, "forward")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order for the action. The action with the lowest value for order is performed first. Valid values are between `1` and `50000`. Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.ListenerDefaultActionRedirect']:
        """
        Configuration block for creating a redirect action. Required if `type` is `redirect`. See below.
        """
        return pulumi.get(self, "redirect")

    @_builtins.property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the Target Group to which to route traffic. Specify only if `type` is `forward` and you want to route to a single target group. To route to one or more target groups, use a `forward` block instead. Can be specified with `forward` but ARNs must match.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ListenerDefaultActionAuthenticateCognito(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolArn":
            suggest = "user_pool_arn"
        elif key == "userPoolClientId":
            suggest = "user_pool_client_id"
        elif key == "userPoolDomain":
            suggest = "user_pool_domain"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionAuthenticateCognito. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionAuthenticateCognito.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionAuthenticateCognito.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_arn: _builtins.str,
                 user_pool_client_id: _builtins.str,
                 user_pool_domain: _builtins.str,
                 authentication_request_extra_params: Optional[Mapping[str, _builtins.str]] = None,
                 on_unauthenticated_request: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 session_cookie_name: Optional[_builtins.str] = None,
                 session_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str user_pool_arn: ARN of the Cognito user pool.
        :param _builtins.str user_pool_client_id: ID of the Cognito user pool client.
        :param _builtins.str user_pool_domain: Domain prefix or fully-qualified domain name of the Cognito user pool.
               
               The following arguments are optional:
        :param Mapping[str, _builtins.str] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        :param _builtins.str on_unauthenticated_request: Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        :param _builtins.str scope: Set of user claims to be requested from the IdP.
        :param _builtins.str session_cookie_name: Name of the cookie used to maintain session information.
        :param _builtins.int session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @_builtins.property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> _builtins.str:
        """
        ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> _builtins.str:
        """
        ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @_builtins.property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> _builtins.str:
        """
        Domain prefix or fully-qualified domain name of the Cognito user pool.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_domain")

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10. See below.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[_builtins.str]:
        """
        Behavior if the user is not authenticated. Valid values are `deny`, `allow` and `authenticate`.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[_builtins.str]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[_builtins.int]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerDefaultActionAuthenticateOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionAuthenticateOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionAuthenticateOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionAuthenticateOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: _builtins.str,
                 client_id: _builtins.str,
                 client_secret: _builtins.str,
                 issuer: _builtins.str,
                 token_endpoint: _builtins.str,
                 user_info_endpoint: _builtins.str,
                 authentication_request_extra_params: Optional[Mapping[str, _builtins.str]] = None,
                 on_unauthenticated_request: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 session_cookie_name: Optional[_builtins.str] = None,
                 session_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str authorization_endpoint: Authorization endpoint of the IdP.
        :param _builtins.str client_id: OAuth 2.0 client identifier.
        :param _builtins.str client_secret: OAuth 2.0 client secret.
        :param _builtins.str issuer: OIDC issuer identifier of the IdP.
        :param _builtins.str token_endpoint: Token endpoint of the IdP.
        :param _builtins.str user_info_endpoint: User info endpoint of the IdP.
               
               The following arguments are optional:
        :param Mapping[str, _builtins.str] authentication_request_extra_params: Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param _builtins.str on_unauthenticated_request: Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param _builtins.str scope: Set of user claims to be requested from the IdP.
        :param _builtins.str session_cookie_name: Name of the cookie used to maintain session information.
        :param _builtins.int session_timeout: Maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> _builtins.str:
        """
        Authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> _builtins.str:
        """
        Token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @_builtins.property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> _builtins.str:
        """
        User info endpoint of the IdP.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_info_endpoint")

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[_builtins.str]:
        """
        Behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[_builtins.str]:
        """
        Name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[_builtins.int]:
        """
        Maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerDefaultActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "messageBody":
            suggest = "message_body"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str,
                 message_body: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_type: Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
               
               The following arguments are optional:
        :param _builtins.str message_body: Message body.
        :param _builtins.str status_code: HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        Content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.

        The following arguments are optional:
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[_builtins.str]:
        """
        Message body.
        """
        return pulumi.get(self, "message_body")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.str]:
        """
        HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerDefaultActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerDefaultActionForwardTargetGroup'],
                 stickiness: Optional['outputs.ListenerDefaultActionForwardStickiness'] = None):
        """
        :param Sequence['ListenerDefaultActionForwardTargetGroupArgs'] target_groups: Set of 1-5 target group blocks. See below.
               
               The following arguments are optional:
        :param 'ListenerDefaultActionForwardStickinessArgs' stickiness: Configuration block for target group stickiness for the rule. See below.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerDefaultActionForwardTargetGroup']:
        """
        Set of 1-5 target group blocks. See below.

        The following arguments are optional:
        """
        return pulumi.get(self, "target_groups")

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> Optional['outputs.ListenerDefaultActionForwardStickiness']:
        """
        Configuration block for target group stickiness for the rule. See below.
        """
        return pulumi.get(self, "stickiness")


@pulumi.output_type
class ListenerDefaultActionForwardStickiness(dict):
    def __init__(__self__, *,
                 duration: _builtins.int,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int duration: Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
               
               The following arguments are optional:
        :param _builtins.bool enabled: Whether target group stickiness is enabled. Default is `false`.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        Time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).

        The following arguments are optional:
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether target group stickiness is enabled. Default is `false`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ListenerDefaultActionForwardTargetGroup(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str arn: ARN of the target group.
               
               The following arguments are optional:
        :param _builtins.int weight: Weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the target group.

        The following arguments are optional:
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        Weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerDefaultActionRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultActionRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultActionRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultActionRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: _builtins.str,
                 host: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 query: Optional[_builtins.str] = None):
        """
        :param _builtins.str status_code: HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
               
               The following arguments are optional:
        :param _builtins.str host: Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param _builtins.str path: Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param _builtins.str port: Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param _builtins.str protocol: Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param _builtins.str query: Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.str:
        """
        HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).

        The following arguments are optional:
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        Port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[_builtins.str]:
        """
        Query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ListenerMutualAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertiseTrustStoreCaNames":
            suggest = "advertise_trust_store_ca_names"
        elif key == "ignoreClientCertificateExpiry":
            suggest = "ignore_client_certificate_expiry"
        elif key == "trustStoreArn":
            suggest = "trust_store_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerMutualAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerMutualAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerMutualAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 advertise_trust_store_ca_names: Optional[_builtins.str] = None,
                 ignore_client_certificate_expiry: Optional[_builtins.bool] = None,
                 trust_store_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: Valid values are `off`, `passthrough`, and `verify`.
        :param _builtins.str advertise_trust_store_ca_names: Valid values are `off` and `on`.
        :param _builtins.bool ignore_client_certificate_expiry: Whether client certificate expiry is ignored.
               Default is `false`.
        :param _builtins.str trust_store_arn: ARN of the elbv2 Trust Store.
        """
        pulumi.set(__self__, "mode", mode)
        if advertise_trust_store_ca_names is not None:
            pulumi.set(__self__, "advertise_trust_store_ca_names", advertise_trust_store_ca_names)
        if ignore_client_certificate_expiry is not None:
            pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Valid values are `off`, `passthrough`, and `verify`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="advertiseTrustStoreCaNames")
    def advertise_trust_store_ca_names(self) -> Optional[_builtins.str]:
        """
        Valid values are `off` and `on`.
        """
        return pulumi.get(self, "advertise_trust_store_ca_names")

    @_builtins.property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> Optional[_builtins.bool]:
        """
        Whether client certificate expiry is ignored.
        Default is `false`.
        """
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the elbv2 Trust Store.
        """
        return pulumi.get(self, "trust_store_arn")


@pulumi.output_type
class ListenerRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticateCognito":
            suggest = "authenticate_cognito"
        elif key == "authenticateOidc":
            suggest = "authenticate_oidc"
        elif key == "fixedResponse":
            suggest = "fixed_response"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 authenticate_cognito: Optional['outputs.ListenerRuleActionAuthenticateCognito'] = None,
                 authenticate_oidc: Optional['outputs.ListenerRuleActionAuthenticateOidc'] = None,
                 fixed_response: Optional['outputs.ListenerRuleActionFixedResponse'] = None,
                 forward: Optional['outputs.ListenerRuleActionForward'] = None,
                 order: Optional[_builtins.int] = None,
                 redirect: Optional['outputs.ListenerRuleActionRedirect'] = None,
                 target_group_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        :param 'ListenerRuleActionAuthenticateCognitoArgs' authenticate_cognito: Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        :param 'ListenerRuleActionAuthenticateOidcArgs' authenticate_oidc: Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        :param 'ListenerRuleActionFixedResponseArgs' fixed_response: Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        :param 'ListenerRuleActionForwardArgs' forward: Configuration block for creating an action that distributes requests among one or more target groups.
               Specify only if `type` is `forward`.
               Cannot be specified with `target_group_arn`.
        :param _builtins.int order: Order for the action.
               The action with the lowest value for order is performed first.
               Valid values are between `1` and `50000`.
               Defaults to the position in the list of actions.
        :param 'ListenerRuleActionRedirectArgs' redirect: Information for creating a redirect action. Required if `type` is `redirect`.
        :param _builtins.str target_group_arn: ARN of the Target Group to which to route traffic.
               Specify only if `type` is `forward` and you want to route to a single target group.
               To route to one or more target groups, use a `forward` block instead.
               Cannot be specified with `forward`.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito is not None:
            pulumi.set(__self__, "authenticate_cognito", authenticate_cognito)
        if authenticate_oidc is not None:
            pulumi.set(__self__, "authenticate_oidc", authenticate_oidc)
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect is not None:
            pulumi.set(__self__, "redirect", redirect)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of routing action. Valid values are `forward`, `redirect`, `fixed-response`, `authenticate-cognito` and `authenticate-oidc`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="authenticateCognito")
    def authenticate_cognito(self) -> Optional['outputs.ListenerRuleActionAuthenticateCognito']:
        """
        Information for creating an authenticate action using Cognito. Required if `type` is `authenticate-cognito`.
        """
        return pulumi.get(self, "authenticate_cognito")

    @_builtins.property
    @pulumi.getter(name="authenticateOidc")
    def authenticate_oidc(self) -> Optional['outputs.ListenerRuleActionAuthenticateOidc']:
        """
        Information for creating an authenticate action using OIDC. Required if `type` is `authenticate-oidc`.
        """
        return pulumi.get(self, "authenticate_oidc")

    @_builtins.property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerRuleActionFixedResponse']:
        """
        Information for creating an action that returns a custom HTTP response. Required if `type` is `fixed-response`.
        """
        return pulumi.get(self, "fixed_response")

    @_builtins.property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerRuleActionForward']:
        """
        Configuration block for creating an action that distributes requests among one or more target groups.
        Specify only if `type` is `forward`.
        Cannot be specified with `target_group_arn`.
        """
        return pulumi.get(self, "forward")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Order for the action.
        The action with the lowest value for order is performed first.
        Valid values are between `1` and `50000`.
        Defaults to the position in the list of actions.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def redirect(self) -> Optional['outputs.ListenerRuleActionRedirect']:
        """
        Information for creating a redirect action. Required if `type` is `redirect`.
        """
        return pulumi.get(self, "redirect")

    @_builtins.property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[_builtins.str]:
        """
        ARN of the Target Group to which to route traffic.
        Specify only if `type` is `forward` and you want to route to a single target group.
        To route to one or more target groups, use a `forward` block instead.
        Cannot be specified with `forward`.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ListenerRuleActionAuthenticateCognito(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolArn":
            suggest = "user_pool_arn"
        elif key == "userPoolClientId":
            suggest = "user_pool_client_id"
        elif key == "userPoolDomain":
            suggest = "user_pool_domain"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionAuthenticateCognito. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionAuthenticateCognito.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionAuthenticateCognito.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_arn: _builtins.str,
                 user_pool_client_id: _builtins.str,
                 user_pool_domain: _builtins.str,
                 authentication_request_extra_params: Optional[Mapping[str, _builtins.str]] = None,
                 on_unauthenticated_request: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 session_cookie_name: Optional[_builtins.str] = None,
                 session_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str user_pool_arn: The ARN of the Cognito user pool.
        :param _builtins.str user_pool_client_id: The ID of the Cognito user pool client.
        :param _builtins.str user_pool_domain: The domain prefix or fully-qualified domain name of the Cognito user pool.
        :param Mapping[str, _builtins.str] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param _builtins.str on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param _builtins.str scope: The set of user claims to be requested from the IdP.
        :param _builtins.str session_cookie_name: The name of the cookie used to maintain session information.
        :param _builtins.int session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @_builtins.property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> _builtins.str:
        """
        The ARN of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> _builtins.str:
        """
        The ID of the Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @_builtins.property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> _builtins.str:
        """
        The domain prefix or fully-qualified domain name of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[_builtins.str]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[_builtins.str]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[_builtins.int]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerRuleActionAuthenticateOidc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "tokenEndpoint":
            suggest = "token_endpoint"
        elif key == "userInfoEndpoint":
            suggest = "user_info_endpoint"
        elif key == "authenticationRequestExtraParams":
            suggest = "authentication_request_extra_params"
        elif key == "onUnauthenticatedRequest":
            suggest = "on_unauthenticated_request"
        elif key == "sessionCookieName":
            suggest = "session_cookie_name"
        elif key == "sessionTimeout":
            suggest = "session_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionAuthenticateOidc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionAuthenticateOidc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionAuthenticateOidc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: _builtins.str,
                 client_id: _builtins.str,
                 client_secret: _builtins.str,
                 issuer: _builtins.str,
                 token_endpoint: _builtins.str,
                 user_info_endpoint: _builtins.str,
                 authentication_request_extra_params: Optional[Mapping[str, _builtins.str]] = None,
                 on_unauthenticated_request: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 session_cookie_name: Optional[_builtins.str] = None,
                 session_timeout: Optional[_builtins.int] = None):
        """
        :param _builtins.str authorization_endpoint: The authorization endpoint of the IdP.
        :param _builtins.str client_id: The OAuth 2.0 client identifier.
        :param _builtins.str client_secret: The OAuth 2.0 client secret.
        :param _builtins.str issuer: The OIDC issuer identifier of the IdP.
        :param _builtins.str token_endpoint: The token endpoint of the IdP.
        :param _builtins.str user_info_endpoint: The user info endpoint of the IdP.
        :param Mapping[str, _builtins.str] authentication_request_extra_params: The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        :param _builtins.str on_unauthenticated_request: The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        :param _builtins.str scope: The set of user claims to be requested from the IdP.
        :param _builtins.str session_cookie_name: The name of the cookie used to maintain session information.
        :param _builtins.int session_timeout: The maximum duration of the authentication session, in seconds.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> _builtins.str:
        """
        The authorization endpoint of the IdP.
        """
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        The OAuth 2.0 client secret.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        The OIDC issuer identifier of the IdP.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> _builtins.str:
        """
        The token endpoint of the IdP.
        """
        return pulumi.get(self, "token_endpoint")

    @_builtins.property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> _builtins.str:
        """
        The user info endpoint of the IdP.
        """
        return pulumi.get(self, "user_info_endpoint")

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The query parameters to include in the redirect request to the authorization endpoint. Max: 10.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[_builtins.str]:
        """
        The behavior if the user is not authenticated. Valid values: `deny`, `allow` and `authenticate`
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The set of user claims to be requested from the IdP.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[_builtins.str]:
        """
        The name of the cookie used to maintain session information.
        """
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[_builtins.int]:
        """
        The maximum duration of the authentication session, in seconds.
        """
        return pulumi.get(self, "session_timeout")


@pulumi.output_type
class ListenerRuleActionFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "messageBody":
            suggest = "message_body"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: _builtins.str,
                 message_body: Optional[_builtins.str] = None,
                 status_code: Optional[_builtins.str] = None):
        """
        :param _builtins.str content_type: The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        :param _builtins.str message_body: The message body.
        :param _builtins.str status_code: The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        The content type. Valid values are `text/plain`, `text/css`, `text/html`, `application/javascript` and `application/json`.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[_builtins.str]:
        """
        The message body.
        """
        return pulumi.get(self, "message_body")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[_builtins.str]:
        """
        The HTTP response code. Valid values are `2XX`, `4XX`, or `5XX`.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerRuleActionForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerRuleActionForwardTargetGroup'],
                 stickiness: Optional['outputs.ListenerRuleActionForwardStickiness'] = None):
        """
        :param Sequence['ListenerRuleActionForwardTargetGroupArgs'] target_groups: One or more target group blocks.
        :param 'ListenerRuleActionForwardStickinessArgs' stickiness: The target group stickiness for the rule.
        """
        pulumi.set(__self__, "target_groups", target_groups)
        if stickiness is not None:
            pulumi.set(__self__, "stickiness", stickiness)

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerRuleActionForwardTargetGroup']:
        """
        One or more target group blocks.
        """
        return pulumi.get(self, "target_groups")

    @_builtins.property
    @pulumi.getter
    def stickiness(self) -> Optional['outputs.ListenerRuleActionForwardStickiness']:
        """
        The target group stickiness for the rule.
        """
        return pulumi.get(self, "stickiness")


@pulumi.output_type
class ListenerRuleActionForwardStickiness(dict):
    def __init__(__self__, *,
                 duration: _builtins.int,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int duration: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param _builtins.bool enabled: Indicates whether target group stickiness is enabled.
        """
        pulumi.set(__self__, "duration", duration)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ListenerRuleActionForwardTargetGroup(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str arn: The Amazon Resource Name (ARN) of the target group.
        :param _builtins.int weight: The weight. The range is 0 to 999.
        """
        pulumi.set(__self__, "arn", arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ListenerRuleActionRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleActionRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleActionRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleActionRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: _builtins.str,
                 host: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 query: Optional[_builtins.str] = None):
        """
        :param _builtins.str status_code: The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        :param _builtins.str host: The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        :param _builtins.str path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        :param _builtins.str port: The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        :param _builtins.str protocol: The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        :param _builtins.str query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.str:
        """
        The HTTP redirect code. The redirect is either permanent (`HTTP_301`) or temporary (`HTTP_302`).
        """
        return pulumi.get(self, "status_code")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain `#{host}`. Defaults to `#{host}`.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}. Defaults to `/#{path}`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port. Specify a value from `1` to `65535` or `#{port}`. Defaults to `#{port}`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        The protocol. Valid values are `HTTP`, `HTTPS`, or `#{protocol}`. Defaults to `#{protocol}`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[_builtins.str]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?". Defaults to `#{query}`.
        """
        return pulumi.get(self, "query")


@pulumi.output_type
class ListenerRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostHeader":
            suggest = "host_header"
        elif key == "httpHeader":
            suggest = "http_header"
        elif key == "httpRequestMethod":
            suggest = "http_request_method"
        elif key == "pathPattern":
            suggest = "path_pattern"
        elif key == "queryStrings":
            suggest = "query_strings"
        elif key == "sourceIp":
            suggest = "source_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_header: Optional['outputs.ListenerRuleConditionHostHeader'] = None,
                 http_header: Optional['outputs.ListenerRuleConditionHttpHeader'] = None,
                 http_request_method: Optional['outputs.ListenerRuleConditionHttpRequestMethod'] = None,
                 path_pattern: Optional['outputs.ListenerRuleConditionPathPattern'] = None,
                 query_strings: Optional[Sequence['outputs.ListenerRuleConditionQueryString']] = None,
                 source_ip: Optional['outputs.ListenerRuleConditionSourceIp'] = None):
        """
        :param 'ListenerRuleConditionHostHeaderArgs' host_header: Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        :param 'ListenerRuleConditionHttpHeaderArgs' http_header: HTTP headers to match. HTTP Header block fields documented below.
        :param 'ListenerRuleConditionHttpRequestMethodArgs' http_request_method: Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        :param 'ListenerRuleConditionPathPatternArgs' path_pattern: Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        :param Sequence['ListenerRuleConditionQueryStringArgs'] query_strings: Query strings to match. Query String block fields documented below.
        :param 'ListenerRuleConditionSourceIpArgs' source_ip: Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.
               
               > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        if host_header is not None:
            pulumi.set(__self__, "host_header", host_header)
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if http_request_method is not None:
            pulumi.set(__self__, "http_request_method", http_request_method)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)
        if source_ip is not None:
            pulumi.set(__self__, "source_ip", source_ip)

    @_builtins.property
    @pulumi.getter(name="hostHeader")
    def host_header(self) -> Optional['outputs.ListenerRuleConditionHostHeader']:
        """
        Contains a single `values` item which is a list of host header patterns to match. The maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied.
        """
        return pulumi.get(self, "host_header")

    @_builtins.property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional['outputs.ListenerRuleConditionHttpHeader']:
        """
        HTTP headers to match. HTTP Header block fields documented below.
        """
        return pulumi.get(self, "http_header")

    @_builtins.property
    @pulumi.getter(name="httpRequestMethod")
    def http_request_method(self) -> Optional['outputs.ListenerRuleConditionHttpRequestMethod']:
        """
        Contains a single `values` item which is a list of HTTP request methods or verbs to match. Maximum size is 40 characters. Only allowed characters are A-Z, hyphen (-) and underscore (\\_). Comparison is case sensitive. Wildcards are not supported. Only one needs to match for the condition to be satisfied. AWS recommends that GET and HEAD requests are routed in the same way because the response to a HEAD request may be cached.
        """
        return pulumi.get(self, "http_request_method")

    @_builtins.property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional['outputs.ListenerRuleConditionPathPattern']:
        """
        Contains a single `values` item which is a list of path patterns to match against the request URL. Maximum size of each pattern is 128 characters. Comparison is case sensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). Only one pattern needs to match for the condition to be satisfied. Path pattern is compared only to the path of the URL, not to its query string. To compare against the query string, use a `query_string` condition.
        """
        return pulumi.get(self, "path_pattern")

    @_builtins.property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence['outputs.ListenerRuleConditionQueryString']]:
        """
        Query strings to match. Query String block fields documented below.
        """
        return pulumi.get(self, "query_strings")

    @_builtins.property
    @pulumi.getter(name="sourceIp")
    def source_ip(self) -> Optional['outputs.ListenerRuleConditionSourceIp']:
        """
        Contains a single `values` item which is a list of source IP CIDR notations to match. You can use both IPv4 and IPv6 addresses. Wildcards are not supported. Condition is satisfied if the source IP address of the request matches one of the CIDR blocks. Condition is not satisfied by the addresses in the `X-Forwarded-For` header, use `http_header` condition instead.

        > **NOTE::** Exactly one of `host_header`, `http_header`, `http_request_method`, `path_pattern`, `query_string` or `source_ip` must be set per condition.
        """
        return pulumi.get(self, "source_ip")


@pulumi.output_type
class ListenerRuleConditionHostHeader(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionHttpHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaderName":
            suggest = "http_header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerRuleConditionHttpHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerRuleConditionHttpHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerRuleConditionHttpHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_header_name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str http_header_name: Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        :param Sequence[_builtins.str] values: List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        pulumi.set(__self__, "http_header_name", http_header_name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> _builtins.str:
        """
        Name of HTTP header to search. The maximum size is 40 characters. Comparison is case insensitive. Only RFC7240 characters are supported. Wildcards are not supported. You cannot use HTTP header condition to specify the host header, use a `host-header` condition instead.
        """
        return pulumi.get(self, "http_header_name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        List of header value patterns to match. Maximum size of each pattern is 128 characters. Comparison is case insensitive. Wildcard characters supported: * (matches 0 or more characters) and ? (matches exactly 1 character). If the same header appears multiple times in the request they will be searched in order until a match is found. Only one pattern needs to match for the condition to be satisfied. To require that all of the strings are a match, create one condition block per string.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionHttpRequestMethod(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionPathPattern(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class ListenerRuleConditionQueryString(dict):
    def __init__(__self__, *,
                 value: _builtins.str,
                 key: Optional[_builtins.str] = None):
        """
        :param _builtins.str value: Query string value pattern to match.
        :param _builtins.str key: Query string key pattern to match.
        """
        pulumi.set(__self__, "value", value)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Query string value pattern to match.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Query string key pattern to match.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ListenerRuleConditionSourceIp(dict):
    def __init__(__self__, *,
                 values: Sequence[_builtins.str]):
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")


@pulumi.output_type
class LoadBalancerAccessLogs(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: S3 bucket name to store the logs in.
        :param _builtins.bool enabled: Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        :param _builtins.str prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean to enable / disable `access_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class LoadBalancerConnectionLogs(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: S3 bucket name to store the logs in.
        :param _builtins.bool enabled: Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        :param _builtins.str prefix: S3 bucket prefix. Logs are stored in the root if not configured.
        """
        pulumi.set(__self__, "bucket", bucket)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        S3 bucket name to store the logs in.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean to enable / disable `connection_logs`. Defaults to `false`, even when `bucket` is specified.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        S3 bucket prefix. Logs are stored in the root if not configured.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class LoadBalancerIpamPools(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4IpamPoolId":
            suggest = "ipv4_ipam_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerIpamPools. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerIpamPools.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerIpamPools.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv4_ipam_pool_id: _builtins.str):
        """
        :param _builtins.str ipv4_ipam_pool_id: The ID of the IPv4 IPAM pool.
        """
        pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> _builtins.str:
        """
        The ID of the IPv4 IPAM pool.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")


@pulumi.output_type
class LoadBalancerMinimumLoadBalancerCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityUnits":
            suggest = "capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerMinimumLoadBalancerCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerMinimumLoadBalancerCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerMinimumLoadBalancerCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_units: _builtins.int):
        """
        :param _builtins.int capacity_units: The number of capacity units.
        """
        pulumi.set(__self__, "capacity_units", capacity_units)

    @_builtins.property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> _builtins.int:
        """
        The number of capacity units.
        """
        return pulumi.get(self, "capacity_units")


@pulumi.output_type
class LoadBalancerSubnetMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "allocationId":
            suggest = "allocation_id"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "outpostId":
            suggest = "outpost_id"
        elif key == "privateIpv4Address":
            suggest = "private_ipv4_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerSubnetMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerSubnetMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerSubnetMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: _builtins.str,
                 allocation_id: Optional[_builtins.str] = None,
                 ipv6_address: Optional[_builtins.str] = None,
                 outpost_id: Optional[_builtins.str] = None,
                 private_ipv4_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str subnet_id: ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        :param _builtins.str allocation_id: Allocation ID of the Elastic IP address for an internet-facing load balancer.
        :param _builtins.str ipv6_address: IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        :param _builtins.str private_ipv4_address: Private IPv4 address for an internal load balancer.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if outpost_id is not None:
            pulumi.set(__self__, "outpost_id", outpost_id)
        if private_ipv4_address is not None:
            pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        ID of the subnet of which to attach to the load balancer. You can specify only one subnet per Availability Zone.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[_builtins.str]:
        """
        Allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[_builtins.str]:
        """
        IPv6 address. You associate IPv6 CIDR blocks with your VPC and choose the subnets where you launch both internet-facing and internal Application Load Balancers or Network Load Balancers.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "outpost_id")

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> Optional[_builtins.str]:
        """
        Private IPv4 address for an internal load balancer.
        """
        return pulumi.get(self, "private_ipv4_address")


@pulumi.output_type
class TargetGroupHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 healthy_threshold: Optional[_builtins.int] = None,
                 interval: Optional[_builtins.int] = None,
                 matcher: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.int] = None,
                 unhealthy_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enabled: Whether health checks are enabled. Defaults to `true`.
        :param _builtins.int healthy_threshold: Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        :param _builtins.int interval: Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        :param _builtins.str matcher: The HTTP or gRPC codes to use when checking for a successful response from a target.
               The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
               Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
               * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
               * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
               * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
               * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        :param _builtins.str path: Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
               * For HTTP and HTTPS health checks, the default is `/`.
               * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        :param _builtins.str port: The port the load balancer uses when performing health checks on targets.
               Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
               Default is `traffic-port`.
        :param _builtins.str protocol: Protocol the load balancer uses when performing health checks on targets.
               Must be one of `TCP`, `HTTP`, or `HTTPS`.
               The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
               Default is `HTTP`.
               Cannot be specified when the `target_type` is `lambda`.
        :param _builtins.int timeout: Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        :param _builtins.int unhealthy_threshold: Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether health checks are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of consecutive health check successes required before considering a target healthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        Approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. For `lambda` target groups, it needs to be greater than the timeout of the underlying `lambda`. Defaults to 30.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def matcher(self) -> Optional[_builtins.str]:
        """
        The HTTP or gRPC codes to use when checking for a successful response from a target.
        The `health_check.protocol` must be one of `HTTP` or `HTTPS` or the `target_type` must be `lambda`.
        Values can be comma-separated individual values (e.g., "200,202") or a range of values (e.g., "200-299").
        * For gRPC-based target groups (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is `GRPC`), values can be between `0` and `99`. The default is `12`.
        * When used with an Application Load Balancer (i.e., the `protocol` is one of `HTTP` or `HTTPS` and the `protocol_version` is not `GRPC`), values can be between `200` and `499`. The default is `200`.
        * When used with a Network Load Balancer (i.e., the `protocol` is one of `TCP`, `TCP_UDP`, `UDP`, or `TLS`), values can be between `200` and `599`. The default is `200-399`.
        * When the `target_type` is `lambda`, values can be between `200` and `499`. The default is `200`.
        """
        return pulumi.get(self, "matcher")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Destination for the health check request. Required for HTTP/HTTPS ALB and HTTP NLB. Only applies to HTTP/HTTPS.
        * For HTTP and HTTPS health checks, the default is `/`.
        * For gRPC health checks, the default is `/AWS.ALB/healthcheck`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port the load balancer uses when performing health checks on targets.
        Valid values are either `traffic-port`, to use the same port as the target group, or a valid port number between `1` and `65536`.
        Default is `traffic-port`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol the load balancer uses when performing health checks on targets.
        Must be one of `TCP`, `HTTP`, or `HTTPS`.
        The `TCP` protocol is not supported for health checks if the protocol of the target group is `HTTP` or `HTTPS`.
        Default is `HTTP`.
        Cannot be specified when the `target_type` is `lambda`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.int]:
        """
        Amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is lambda, the default is 30 seconds.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[_builtins.int]:
        """
        Number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. Defaults to 3.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class TargetGroupStickiness(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieDuration":
            suggest = "cookie_duration"
        elif key == "cookieName":
            suggest = "cookie_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupStickiness. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupStickiness.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupStickiness.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 cookie_duration: Optional[_builtins.int] = None,
                 cookie_name: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        :param _builtins.int cookie_duration: Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        :param _builtins.str cookie_name: Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        :param _builtins.bool enabled: Boolean to enable / disable `stickiness`. Default is `true`.
        """
        pulumi.set(__self__, "type", type)
        if cookie_duration is not None:
            pulumi.set(__self__, "cookie_duration", cookie_duration)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of sticky sessions. The only current possible values are `lb_cookie`, `app_cookie` for ALBs, `source_ip` for NLBs, and `source_ip_dest_ip`, `source_ip_dest_ip_proto` for GWLBs.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> Optional[_builtins.int]:
        """
        Only used when the type is `lb_cookie`. The time period, in seconds, during which requests from a client should be routed to the same target. After this time period expires, the load balancer-generated cookie is considered stale. The range is 1 second to 1 week (604800 seconds). The default value is 1 day (86400 seconds).
        """
        return pulumi.get(self, "cookie_duration")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[_builtins.str]:
        """
        Name of the application based cookie. AWSALB, AWSALBAPP, and AWSALBTG prefixes are reserved and cannot be used. Only needed when type is `app_cookie`.
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Boolean to enable / disable `stickiness`. Default is `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TargetGroupTargetFailover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDeregistration":
            suggest = "on_deregistration"
        elif key == "onUnhealthy":
            suggest = "on_unhealthy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetFailover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetFailover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetFailover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_deregistration: _builtins.str,
                 on_unhealthy: _builtins.str):
        """
        :param _builtins.str on_deregistration: Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        :param _builtins.str on_unhealthy: Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        pulumi.set(__self__, "on_deregistration", on_deregistration)
        pulumi.set(__self__, "on_unhealthy", on_unhealthy)

    @_builtins.property
    @pulumi.getter(name="onDeregistration")
    def on_deregistration(self) -> _builtins.str:
        """
        Indicates how the GWLB handles existing flows when a target is deregistered. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_unhealthy`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_deregistration")

    @_builtins.property
    @pulumi.getter(name="onUnhealthy")
    def on_unhealthy(self) -> _builtins.str:
        """
        Indicates how the GWLB handles existing flows when a target is unhealthy. Possible values are `rebalance` and `no_rebalance`. Must match the attribute value set for `on_deregistration`. Default: `no_rebalance`.
        """
        return pulumi.get(self, "on_unhealthy")


@pulumi.output_type
class TargetGroupTargetGroupHealth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsFailover":
            suggest = "dns_failover"
        elif key == "unhealthyStateRouting":
            suggest = "unhealthy_state_routing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_failover: Optional['outputs.TargetGroupTargetGroupHealthDnsFailover'] = None,
                 unhealthy_state_routing: Optional['outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting'] = None):
        """
        :param 'TargetGroupTargetGroupHealthDnsFailoverArgs' dns_failover: Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        :param 'TargetGroupTargetGroupHealthUnhealthyStateRoutingArgs' unhealthy_state_routing: Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        if dns_failover is not None:
            pulumi.set(__self__, "dns_failover", dns_failover)
        if unhealthy_state_routing is not None:
            pulumi.set(__self__, "unhealthy_state_routing", unhealthy_state_routing)

    @_builtins.property
    @pulumi.getter(name="dnsFailover")
    def dns_failover(self) -> Optional['outputs.TargetGroupTargetGroupHealthDnsFailover']:
        """
        Block to configure DNS Failover requirements. See DNS Failover below for details on attributes.
        """
        return pulumi.get(self, "dns_failover")

    @_builtins.property
    @pulumi.getter(name="unhealthyStateRouting")
    def unhealthy_state_routing(self) -> Optional['outputs.TargetGroupTargetGroupHealthUnhealthyStateRouting']:
        """
        Block to configure Unhealthy State Routing requirements. See Unhealthy State Routing below for details on attributes.
        """
        return pulumi.get(self, "unhealthy_state_routing")


@pulumi.output_type
class TargetGroupTargetGroupHealthDnsFailover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumHealthyTargetsCount":
            suggest = "minimum_healthy_targets_count"
        elif key == "minimumHealthyTargetsPercentage":
            suggest = "minimum_healthy_targets_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealthDnsFailover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealthDnsFailover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealthDnsFailover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[_builtins.str] = None,
                 minimum_healthy_targets_percentage: Optional[_builtins.str] = None):
        """
        :param _builtins.str minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        :param _builtins.str minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @_builtins.property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[_builtins.str]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to the maximum number of targets. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @_builtins.property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[_builtins.str]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, mark the zone as unhealthy in DNS, so that traffic is routed only to healthy zones. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")


@pulumi.output_type
class TargetGroupTargetGroupHealthUnhealthyStateRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minimumHealthyTargetsCount":
            suggest = "minimum_healthy_targets_count"
        elif key == "minimumHealthyTargetsPercentage":
            suggest = "minimum_healthy_targets_percentage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetGroupHealthUnhealthyStateRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetGroupHealthUnhealthyStateRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetGroupHealthUnhealthyStateRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 minimum_healthy_targets_count: Optional[_builtins.int] = None,
                 minimum_healthy_targets_percentage: Optional[_builtins.str] = None):
        """
        :param _builtins.int minimum_healthy_targets_count: The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        :param _builtins.str minimum_healthy_targets_percentage: The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        if minimum_healthy_targets_count is not None:
            pulumi.set(__self__, "minimum_healthy_targets_count", minimum_healthy_targets_count)
        if minimum_healthy_targets_percentage is not None:
            pulumi.set(__self__, "minimum_healthy_targets_percentage", minimum_healthy_targets_percentage)

    @_builtins.property
    @pulumi.getter(name="minimumHealthyTargetsCount")
    def minimum_healthy_targets_count(self) -> Optional[_builtins.int]:
        """
        The minimum number of targets that must be healthy. If the number of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `1` to the maximum number of targets. The default is `1`.
        """
        return pulumi.get(self, "minimum_healthy_targets_count")

    @_builtins.property
    @pulumi.getter(name="minimumHealthyTargetsPercentage")
    def minimum_healthy_targets_percentage(self) -> Optional[_builtins.str]:
        """
        The minimum percentage of targets that must be healthy. If the percentage of healthy targets is below this value, send traffic to all targets, including unhealthy targets. The possible values are `off` or an integer from `1` to `100`. The default is `off`.
        """
        return pulumi.get(self, "minimum_healthy_targets_percentage")


@pulumi.output_type
class TargetGroupTargetHealthState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableUnhealthyConnectionTermination":
            suggest = "enable_unhealthy_connection_termination"
        elif key == "unhealthyDrainingInterval":
            suggest = "unhealthy_draining_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupTargetHealthState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupTargetHealthState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupTargetHealthState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_unhealthy_connection_termination: _builtins.bool,
                 unhealthy_draining_interval: Optional[_builtins.int] = None):
        """
        :param _builtins.bool enable_unhealthy_connection_termination: Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        :param _builtins.int unhealthy_draining_interval: Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        pulumi.set(__self__, "enable_unhealthy_connection_termination", enable_unhealthy_connection_termination)
        if unhealthy_draining_interval is not None:
            pulumi.set(__self__, "unhealthy_draining_interval", unhealthy_draining_interval)

    @_builtins.property
    @pulumi.getter(name="enableUnhealthyConnectionTermination")
    def enable_unhealthy_connection_termination(self) -> _builtins.bool:
        """
        Indicates whether the load balancer terminates connections to unhealthy targets. Possible values are `true` or `false`. Default: `true`.
        """
        return pulumi.get(self, "enable_unhealthy_connection_termination")

    @_builtins.property
    @pulumi.getter(name="unhealthyDrainingInterval")
    def unhealthy_draining_interval(self) -> Optional[_builtins.int]:
        """
        Indicates the time to wait for in-flight requests to complete when a target becomes unhealthy. The range is `0-360000`. This value has to be set only if `enable_unhealthy_connection_termination` is set to false. Default: `0`.
        """
        return pulumi.get(self, "unhealthy_draining_interval")


@pulumi.output_type
class GetListenerDefaultActionResult(dict):
    def __init__(__self__, *,
                 authenticate_cognitos: Sequence['outputs.GetListenerDefaultActionAuthenticateCognitoResult'],
                 authenticate_oidcs: Sequence['outputs.GetListenerDefaultActionAuthenticateOidcResult'],
                 fixed_responses: Sequence['outputs.GetListenerDefaultActionFixedResponseResult'],
                 forwards: Sequence['outputs.GetListenerDefaultActionForwardResult'],
                 order: _builtins.int,
                 redirects: Sequence['outputs.GetListenerDefaultActionRedirectResult'],
                 target_group_arn: _builtins.str,
                 type: _builtins.str):
        pulumi.set(__self__, "authenticate_cognitos", authenticate_cognitos)
        pulumi.set(__self__, "authenticate_oidcs", authenticate_oidcs)
        pulumi.set(__self__, "fixed_responses", fixed_responses)
        pulumi.set(__self__, "forwards", forwards)
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "target_group_arn", target_group_arn)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="authenticateCognitos")
    def authenticate_cognitos(self) -> Sequence['outputs.GetListenerDefaultActionAuthenticateCognitoResult']:
        return pulumi.get(self, "authenticate_cognitos")

    @_builtins.property
    @pulumi.getter(name="authenticateOidcs")
    def authenticate_oidcs(self) -> Sequence['outputs.GetListenerDefaultActionAuthenticateOidcResult']:
        return pulumi.get(self, "authenticate_oidcs")

    @_builtins.property
    @pulumi.getter(name="fixedResponses")
    def fixed_responses(self) -> Sequence['outputs.GetListenerDefaultActionFixedResponseResult']:
        return pulumi.get(self, "fixed_responses")

    @_builtins.property
    @pulumi.getter
    def forwards(self) -> Sequence['outputs.GetListenerDefaultActionForwardResult']:
        return pulumi.get(self, "forwards")

    @_builtins.property
    @pulumi.getter
    def order(self) -> _builtins.int:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetListenerDefaultActionRedirectResult']:
        return pulumi.get(self, "redirects")

    @_builtins.property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> _builtins.str:
        return pulumi.get(self, "target_group_arn")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetListenerDefaultActionAuthenticateCognitoResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, _builtins.str],
                 on_unauthenticated_request: _builtins.str,
                 scope: _builtins.str,
                 session_cookie_name: _builtins.str,
                 session_timeout: _builtins.int,
                 user_pool_arn: _builtins.str,
                 user_pool_client_id: _builtins.str,
                 user_pool_domain: _builtins.str):
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> _builtins.str:
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> _builtins.int:
        return pulumi.get(self, "session_timeout")

    @_builtins.property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_arn")

    @_builtins.property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_client_id")

    @_builtins.property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_domain")


@pulumi.output_type
class GetListenerDefaultActionAuthenticateOidcResult(dict):
    def __init__(__self__, *,
                 authentication_request_extra_params: Mapping[str, _builtins.str],
                 authorization_endpoint: _builtins.str,
                 client_id: _builtins.str,
                 client_secret: _builtins.str,
                 issuer: _builtins.str,
                 on_unauthenticated_request: _builtins.str,
                 scope: _builtins.str,
                 session_cookie_name: _builtins.str,
                 session_timeout: _builtins.int,
                 token_endpoint: _builtins.str,
                 user_info_endpoint: _builtins.str):
        pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        pulumi.set(__self__, "session_timeout", session_timeout)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)

    @_builtins.property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "authentication_request_extra_params")

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> _builtins.str:
        return pulumi.get(self, "on_unauthenticated_request")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "session_cookie_name")

    @_builtins.property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> _builtins.int:
        return pulumi.get(self, "session_timeout")

    @_builtins.property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "token_endpoint")

    @_builtins.property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> _builtins.str:
        return pulumi.get(self, "user_info_endpoint")


@pulumi.output_type
class GetListenerDefaultActionFixedResponseResult(dict):
    def __init__(__self__, *,
                 content_type: _builtins.str,
                 message_body: _builtins.str,
                 status_code: _builtins.str):
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "message_body", message_body)
        pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> _builtins.str:
        return pulumi.get(self, "message_body")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.str:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerDefaultActionForwardResult(dict):
    def __init__(__self__, *,
                 stickinesses: Sequence['outputs.GetListenerDefaultActionForwardStickinessResult'],
                 target_groups: Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']):
        pulumi.set(__self__, "stickinesses", stickinesses)
        pulumi.set(__self__, "target_groups", target_groups)

    @_builtins.property
    @pulumi.getter
    def stickinesses(self) -> Sequence['outputs.GetListenerDefaultActionForwardStickinessResult']:
        return pulumi.get(self, "stickinesses")

    @_builtins.property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.GetListenerDefaultActionForwardTargetGroupResult']:
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class GetListenerDefaultActionForwardStickinessResult(dict):
    def __init__(__self__, *,
                 duration: _builtins.int,
                 enabled: _builtins.bool):
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> _builtins.int:
        return pulumi.get(self, "duration")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetListenerDefaultActionForwardTargetGroupResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 weight: _builtins.int):
        """
        :param _builtins.str arn: ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        ARN of the listener. Required if `load_balancer_arn` and `port` is not set.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> _builtins.int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetListenerDefaultActionRedirectResult(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.str,
                 query: _builtins.str,
                 status_code: _builtins.str):
        """
        :param _builtins.str port: Port of the listener. Required if `arn` is not set.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        Port of the listener. Required if `arn` is not set.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def query(self) -> _builtins.str:
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> _builtins.str:
        return pulumi.get(self, "status_code")


@pulumi.output_type
class GetListenerMutualAuthenticationResult(dict):
    def __init__(__self__, *,
                 advertise_trust_store_ca_names: _builtins.str,
                 ignore_client_certificate_expiry: _builtins.bool,
                 mode: _builtins.str,
                 trust_store_arn: _builtins.str):
        pulumi.set(__self__, "advertise_trust_store_ca_names", advertise_trust_store_ca_names)
        pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @_builtins.property
    @pulumi.getter(name="advertiseTrustStoreCaNames")
    def advertise_trust_store_ca_names(self) -> _builtins.str:
        return pulumi.get(self, "advertise_trust_store_ca_names")

    @_builtins.property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> _builtins.bool:
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> _builtins.str:
        return pulumi.get(self, "trust_store_arn")


@pulumi.output_type
class GetLoadBalancerAccessLogsResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 enabled: _builtins.bool,
                 prefix: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetLoadBalancerConnectionLogResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 enabled: _builtins.bool,
                 prefix: _builtins.str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        return pulumi.get(self, "prefix")


@pulumi.output_type
class GetLoadBalancerIpamPoolResult(dict):
    def __init__(__self__, *,
                 ipv4_ipam_pool_id: _builtins.str):
        pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)

    @_builtins.property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> _builtins.str:
        return pulumi.get(self, "ipv4_ipam_pool_id")


@pulumi.output_type
class GetLoadBalancerSubnetMappingResult(dict):
    def __init__(__self__, *,
                 allocation_id: _builtins.str,
                 ipv6_address: _builtins.str,
                 outpost_id: _builtins.str,
                 private_ipv4_address: _builtins.str,
                 subnet_id: _builtins.str):
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "outpost_id", outpost_id)
        pulumi.set(__self__, "private_ipv4_address", private_ipv4_address)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> _builtins.str:
        return pulumi.get(self, "allocation_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> _builtins.str:
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="outpostId")
    def outpost_id(self) -> _builtins.str:
        return pulumi.get(self, "outpost_id")

    @_builtins.property
    @pulumi.getter(name="privateIpv4Address")
    def private_ipv4_address(self) -> _builtins.str:
        return pulumi.get(self, "private_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetTargetGroupHealthCheckResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 healthy_threshold: _builtins.int,
                 interval: _builtins.int,
                 matcher: _builtins.str,
                 path: _builtins.str,
                 port: _builtins.str,
                 protocol: _builtins.str,
                 timeout: _builtins.int,
                 unhealthy_threshold: _builtins.int):
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "matcher", matcher)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> _builtins.int:
        return pulumi.get(self, "healthy_threshold")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def matcher(self) -> _builtins.str:
        return pulumi.get(self, "matcher")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> _builtins.int:
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetTargetGroupStickinessResult(dict):
    def __init__(__self__, *,
                 cookie_duration: _builtins.int,
                 cookie_name: _builtins.str,
                 enabled: _builtins.bool,
                 type: _builtins.str):
        pulumi.set(__self__, "cookie_duration", cookie_duration)
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="cookieDuration")
    def cookie_duration(self) -> _builtins.int:
        return pulumi.get(self, "cookie_duration")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> _builtins.str:
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        return pulumi.get(self, "type")


