# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueryLoggingConfigurationArgs', 'QueryLoggingConfiguration']

@pulumi.input_type
class QueryLoggingConfigurationArgs:
    def __init__(__self__, *,
                 workspace_id: pulumi.Input[_builtins.str],
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a QueryLoggingConfiguration resource.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the AMP workspace for which to configure query logging.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]] destinations: Configuration block for the logging destinations. See `destinations`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the AMP workspace for which to configure query logging.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]]:
        """
        Configuration block for the logging destinations. See `destinations`.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _QueryLoggingConfigurationState:
    def __init__(__self__, *,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering QueryLoggingConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]] destinations: Configuration block for the logging destinations. See `destinations`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the AMP workspace for which to configure query logging.
               
               The following arguments are optional:
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]]:
        """
        Configuration block for the logging destinations. See `destinations`.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueryLoggingConfigurationDestinationArgs']]]]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['QueryLoggingConfigurationTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the AMP workspace for which to configure query logging.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("aws:amp/queryLoggingConfiguration:QueryLoggingConfiguration")
class QueryLoggingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryLoggingConfigurationDestinationArgs', 'QueryLoggingConfigurationDestinationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['QueryLoggingConfigurationTimeoutsArgs', 'QueryLoggingConfigurationTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Amazon Managed Service for Prometheus (AMP) Query Logging Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="/aws/prometheus/query-logs/example")
        example_query_logging_configuration = aws.amp.QueryLoggingConfiguration("example",
            workspace_id=example.id,
            destinations=[{
                "cloudwatch_logs": {
                    "log_group_arn": example_log_group.arn.apply(lambda arn: f"{arn}:*"),
                },
                "filters": {
                    "qsp_threshold": 1000,
                },
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QueryLoggingConfigurationDestinationArgs', 'QueryLoggingConfigurationDestinationArgsDict']]]] destinations: Configuration block for the logging destinations. See `destinations`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the AMP workspace for which to configure query logging.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryLoggingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Amazon Managed Service for Prometheus (AMP) Query Logging Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.amp.Workspace("example", alias="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="/aws/prometheus/query-logs/example")
        example_query_logging_configuration = aws.amp.QueryLoggingConfiguration("example",
            workspace_id=example.id,
            destinations=[{
                "cloudwatch_logs": {
                    "log_group_arn": example_log_group.arn.apply(lambda arn: f"{arn}:*"),
                },
                "filters": {
                    "qsp_threshold": 1000,
                },
            }])
        ```

        :param str resource_name: The name of the resource.
        :param QueryLoggingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryLoggingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryLoggingConfigurationDestinationArgs', 'QueryLoggingConfigurationDestinationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['QueryLoggingConfigurationTimeoutsArgs', 'QueryLoggingConfigurationTimeoutsArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryLoggingConfigurationArgs.__new__(QueryLoggingConfigurationArgs)

            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["region"] = region
            __props__.__dict__["timeouts"] = timeouts
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(QueryLoggingConfiguration, __self__).__init__(
            'aws:amp/queryLoggingConfiguration:QueryLoggingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueryLoggingConfigurationDestinationArgs', 'QueryLoggingConfigurationDestinationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['QueryLoggingConfigurationTimeoutsArgs', 'QueryLoggingConfigurationTimeoutsArgsDict']]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'QueryLoggingConfiguration':
        """
        Get an existing QueryLoggingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QueryLoggingConfigurationDestinationArgs', 'QueryLoggingConfigurationDestinationArgsDict']]]] destinations: Configuration block for the logging destinations. See `destinations`.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the AMP workspace for which to configure query logging.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueryLoggingConfigurationState.__new__(_QueryLoggingConfigurationState)

        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["region"] = region
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["workspace_id"] = workspace_id
        return QueryLoggingConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Optional[Sequence['outputs.QueryLoggingConfigurationDestination']]]:
        """
        Configuration block for the logging destinations. See `destinations`.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.QueryLoggingConfigurationTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the AMP workspace for which to configure query logging.

        The following arguments are optional:
        """
        return pulumi.get(self, "workspace_id")

