# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourceResult',
    'AwaitableGetResourceResult',
    'get_resource',
    'get_resource_output',
]

@pulumi.output_type
class GetResourceResult:
    """
    A collection of values returned by getResource.
    """
    def __init__(__self__, id=None, parent_id=None, path=None, path_part=None, region=None, rest_api_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if path_part and not isinstance(path_part, str):
            raise TypeError("Expected argument 'path_part' to be a str")
        pulumi.set(__self__, "path_part", path_part)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> _builtins.str:
        """
        Set to the ID of the parent Resource.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="pathPart")
    def path_part(self) -> _builtins.str:
        """
        Set to the path relative to the parent Resource.
        """
        return pulumi.get(self, "path_part")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> _builtins.str:
        return pulumi.get(self, "rest_api_id")


class AwaitableGetResourceResult(GetResourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceResult(
            id=self.id,
            parent_id=self.parent_id,
            path=self.path,
            path_part=self.path_part,
            region=self.region,
            rest_api_id=self.rest_api_id)


def get_resource(path: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 rest_api_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceResult:
    """
    Use this data source to get the id of a Resource in API Gateway.
    To fetch the Resource, you must provide the REST API id as well as the full path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    my_rest_api = aws.apigateway.get_rest_api(name="my-rest-api")
    my_resource = aws.apigateway.get_resource(rest_api_id=my_rest_api.id,
        path="/endpoint/path")
    ```


    :param _builtins.str path: Full path of the resource.  If no path is found, an error will be returned.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: REST API id that owns the resource. If no REST API is found, an error will be returned.
    """
    __args__ = dict()
    __args__['path'] = path
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getResource:getResource', __args__, opts=opts, typ=GetResourceResult).value

    return AwaitableGetResourceResult(
        id=pulumi.get(__ret__, 'id'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        path=pulumi.get(__ret__, 'path'),
        path_part=pulumi.get(__ret__, 'path_part'),
        region=pulumi.get(__ret__, 'region'),
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'))
def get_resource_output(path: Optional[pulumi.Input[_builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceResult]:
    """
    Use this data source to get the id of a Resource in API Gateway.
    To fetch the Resource, you must provide the REST API id as well as the full path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    my_rest_api = aws.apigateway.get_rest_api(name="my-rest-api")
    my_resource = aws.apigateway.get_resource(rest_api_id=my_rest_api.id,
        path="/endpoint/path")
    ```


    :param _builtins.str path: Full path of the resource.  If no path is found, an error will be returned.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: REST API id that owns the resource. If no REST API is found, an error will be returned.
    """
    __args__ = dict()
    __args__['path'] = path
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:apigateway/getResource:getResource', __args__, opts=opts, typ=GetResourceResult)
    return __ret__.apply(lambda __response__: GetResourceResult(
        id=pulumi.get(__response__, 'id'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        path=pulumi.get(__response__, 'path'),
        path_part=pulumi.get(__response__, 'path_part'),
        region=pulumi.get(__response__, 'region'),
        rest_api_id=pulumi.get(__response__, 'rest_api_id')))
