# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ResponseArgs', 'Response']

@pulumi.input_type
class ResponseArgs:
    def __init__(__self__, *,
                 response_type: pulumi.Input[_builtins.str],
                 rest_api_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Response resource.
        :param pulumi.Input[_builtins.str] response_type: Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        :param pulumi.Input[_builtins.str] rest_api_id: String identifier of the associated REST API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_parameters: Map of parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_templates: Map of templates used to transform the response body.
        :param pulumi.Input[_builtins.str] status_code: HTTP status code of the Gateway Response.
        """
        pulumi.set(__self__, "response_type", response_type)
        pulumi.set(__self__, "rest_api_id", rest_api_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter(name="responseType")
    def response_type(self) -> pulumi.Input[_builtins.str]:
        """
        Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        """
        return pulumi.get(self, "response_type")

    @response_type.setter
    def response_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "response_type", value)

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Input[_builtins.str]:
        """
        String identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rest_api_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_parameters", value)

    @_builtins.property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @response_templates.setter
    def response_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_templates", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class _ResponseState:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Response resources.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_parameters: Map of parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_templates: Map of templates used to transform the response body.
        :param pulumi.Input[_builtins.str] response_type: Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        :param pulumi.Input[_builtins.str] rest_api_id: String identifier of the associated REST API.
        :param pulumi.Input[_builtins.str] status_code: HTTP status code of the Gateway Response.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_parameters is not None:
            pulumi.set(__self__, "response_parameters", response_parameters)
        if response_templates is not None:
            pulumi.set(__self__, "response_templates", response_templates)
        if response_type is not None:
            pulumi.set(__self__, "response_type", response_type)
        if rest_api_id is not None:
            pulumi.set(__self__, "rest_api_id", rest_api_id)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @response_parameters.setter
    def response_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_parameters", value)

    @_builtins.property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @response_templates.setter
    def response_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "response_templates", value)

    @_builtins.property
    @pulumi.getter(name="responseType")
    def response_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        """
        return pulumi.get(self, "response_type")

    @response_type.setter
    def response_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_type", value)

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        String identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @rest_api_id.setter
    def rest_api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_api_id", value)

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status_code", value)


@pulumi.type_token("aws:apigateway/response:Response")
class Response(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an API Gateway Gateway Response for a REST API Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.apigateway.RestApi("main", name="MyDemoAPI")
        test = aws.apigateway.Response("test",
            rest_api_id=main.id,
            status_code="401",
            response_type="UNAUTHORIZED",
            response_templates={
                "application/json": "{\\"message\\":$context.error.messageString}",
            },
            response_parameters={
                "gatewayresponse.header.Authorization": "'Basic'",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_gateway_response` using `REST-API-ID/RESPONSE-TYPE`. For example:

        ```sh
        $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_parameters: Map of parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_templates: Map of templates used to transform the response body.
        :param pulumi.Input[_builtins.str] response_type: Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        :param pulumi.Input[_builtins.str] rest_api_id: String identifier of the associated REST API.
        :param pulumi.Input[_builtins.str] status_code: HTTP status code of the Gateway Response.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResponseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an API Gateway Gateway Response for a REST API Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        main = aws.apigateway.RestApi("main", name="MyDemoAPI")
        test = aws.apigateway.Response("test",
            rest_api_id=main.id,
            status_code="401",
            response_type="UNAUTHORIZED",
            response_templates={
                "application/json": "{\\"message\\":$context.error.messageString}",
            },
            response_parameters={
                "gatewayresponse.header.Authorization": "'Basic'",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_gateway_response` using `REST-API-ID/RESPONSE-TYPE`. For example:

        ```sh
        $ pulumi import aws:apigateway/response:Response example 12345abcde/UNAUTHORIZED
        ```

        :param str resource_name: The name of the resource.
        :param ResponseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResponseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 response_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResponseArgs.__new__(ResponseArgs)

            __props__.__dict__["region"] = region
            __props__.__dict__["response_parameters"] = response_parameters
            __props__.__dict__["response_templates"] = response_templates
            if response_type is None and not opts.urn:
                raise TypeError("Missing required property 'response_type'")
            __props__.__dict__["response_type"] = response_type
            if rest_api_id is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api_id'")
            __props__.__dict__["rest_api_id"] = rest_api_id
            __props__.__dict__["status_code"] = status_code
        super(Response, __self__).__init__(
            'aws:apigateway/response:Response',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            response_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            response_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            response_type: Optional[pulumi.Input[_builtins.str]] = None,
            rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
            status_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'Response':
        """
        Get an existing Response resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_parameters: Map of parameters (paths, query strings and headers) of the Gateway Response.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] response_templates: Map of templates used to transform the response body.
        :param pulumi.Input[_builtins.str] response_type: Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        :param pulumi.Input[_builtins.str] rest_api_id: String identifier of the associated REST API.
        :param pulumi.Input[_builtins.str] status_code: HTTP status code of the Gateway Response.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResponseState.__new__(_ResponseState)

        __props__.__dict__["region"] = region
        __props__.__dict__["response_parameters"] = response_parameters
        __props__.__dict__["response_templates"] = response_templates
        __props__.__dict__["response_type"] = response_type
        __props__.__dict__["rest_api_id"] = rest_api_id
        __props__.__dict__["status_code"] = status_code
        return Response(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be managed. See the [AWS Documentation](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) for supported values. Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="responseParameters")
    def response_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of parameters (paths, query strings and headers) of the Gateway Response.
        """
        return pulumi.get(self, "response_parameters")

    @_builtins.property
    @pulumi.getter(name="responseTemplates")
    def response_templates(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of templates used to transform the response body.
        """
        return pulumi.get(self, "response_templates")

    @_builtins.property
    @pulumi.getter(name="responseType")
    def response_type(self) -> pulumi.Output[_builtins.str]:
        """
        Response type of the associated GatewayResponse. See the [AWS Documentation](https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html) for supported values.
        """
        return pulumi.get(self, "response_type")

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> pulumi.Output[_builtins.str]:
        """
        String identifier of the associated REST API.
        """
        return pulumi.get(self, "rest_api_id")

    @_builtins.property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        HTTP status code of the Gateway Response.
        """
        return pulumi.get(self, "status_code")

