# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppAuthorizationConnectionAuthRequest',
    'AppAuthorizationConnectionTenant',
    'AppAuthorizationConnectionTimeouts',
    'AppAuthorizationCredential',
    'AppAuthorizationCredentialApiKeyCredential',
    'AppAuthorizationCredentialOauth2Credential',
    'AppAuthorizationTenant',
    'AppAuthorizationTimeouts',
    'IngestionDestinationDestinationConfiguration',
    'IngestionDestinationDestinationConfigurationAuditLog',
    'IngestionDestinationDestinationConfigurationAuditLogDestination',
    'IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream',
    'IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket',
    'IngestionDestinationProcessingConfiguration',
    'IngestionDestinationProcessingConfigurationAuditLog',
    'IngestionDestinationTimeouts',
]

@pulumi.output_type
class AppAuthorizationConnectionAuthRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redirectUri":
            suggest = "redirect_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationConnectionAuthRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationConnectionAuthRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationConnectionAuthRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: _builtins.str,
                 redirect_uri: _builtins.str):
        """
        :param _builtins.str code: The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
        :param _builtins.str redirect_uri: The redirect URL that is specified in the AuthURL and the application client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "redirect_uri", redirect_uri)

    @_builtins.property
    @pulumi.getter
    def code(self) -> _builtins.str:
        """
        The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> _builtins.str:
        """
        The redirect URL that is specified in the AuthURL and the application client.
        """
        return pulumi.get(self, "redirect_uri")


@pulumi.output_type
class AppAuthorizationConnectionTenant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tenantDisplayName":
            suggest = "tenant_display_name"
        elif key == "tenantIdentifier":
            suggest = "tenant_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationConnectionTenant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationConnectionTenant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationConnectionTenant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tenant_display_name: _builtins.str,
                 tenant_identifier: _builtins.str):
        pulumi.set(__self__, "tenant_display_name", tenant_display_name)
        pulumi.set(__self__, "tenant_identifier", tenant_identifier)

    @_builtins.property
    @pulumi.getter(name="tenantDisplayName")
    def tenant_display_name(self) -> _builtins.str:
        return pulumi.get(self, "tenant_display_name")

    @_builtins.property
    @pulumi.getter(name="tenantIdentifier")
    def tenant_identifier(self) -> _builtins.str:
        return pulumi.get(self, "tenant_identifier")


@pulumi.output_type
class AppAuthorizationConnectionTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")


@pulumi.output_type
class AppAuthorizationCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyCredentials":
            suggest = "api_key_credentials"
        elif key == "oauth2Credential":
            suggest = "oauth2_credential"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_credentials: Optional[Sequence['outputs.AppAuthorizationCredentialApiKeyCredential']] = None,
                 oauth2_credential: Optional['outputs.AppAuthorizationCredentialOauth2Credential'] = None):
        """
        :param Sequence['AppAuthorizationCredentialApiKeyCredentialArgs'] api_key_credentials: Contains API key credential information.
        :param 'AppAuthorizationCredentialOauth2CredentialArgs' oauth2_credential: Contains OAuth2 client credential information.
        """
        if api_key_credentials is not None:
            pulumi.set(__self__, "api_key_credentials", api_key_credentials)
        if oauth2_credential is not None:
            pulumi.set(__self__, "oauth2_credential", oauth2_credential)

    @_builtins.property
    @pulumi.getter(name="apiKeyCredentials")
    def api_key_credentials(self) -> Optional[Sequence['outputs.AppAuthorizationCredentialApiKeyCredential']]:
        """
        Contains API key credential information.
        """
        return pulumi.get(self, "api_key_credentials")

    @_builtins.property
    @pulumi.getter(name="oauth2Credential")
    def oauth2_credential(self) -> Optional['outputs.AppAuthorizationCredentialOauth2Credential']:
        """
        Contains OAuth2 client credential information.
        """
        return pulumi.get(self, "oauth2_credential")


@pulumi.output_type
class AppAuthorizationCredentialApiKeyCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationCredentialApiKeyCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationCredentialApiKeyCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationCredentialApiKeyCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: _builtins.str):
        """
        :param _builtins.str api_key: Contains API key credential information.
        """
        pulumi.set(__self__, "api_key", api_key)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> _builtins.str:
        """
        Contains API key credential information.
        """
        return pulumi.get(self, "api_key")


@pulumi.output_type
class AppAuthorizationCredentialOauth2Credential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationCredentialOauth2Credential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationCredentialOauth2Credential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationCredentialOauth2Credential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret: _builtins.str):
        """
        :param _builtins.str client_id: The client ID of the client application.
        :param _builtins.str client_secret: The client secret of the client application.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID of the client application.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        The client secret of the client application.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class AppAuthorizationTenant(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tenantDisplayName":
            suggest = "tenant_display_name"
        elif key == "tenantIdentifier":
            suggest = "tenant_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppAuthorizationTenant. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppAuthorizationTenant.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppAuthorizationTenant.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tenant_display_name: _builtins.str,
                 tenant_identifier: _builtins.str):
        """
        :param _builtins.str tenant_display_name: The display name of the tenant.
        :param _builtins.str tenant_identifier: The ID of the application tenant.
        """
        pulumi.set(__self__, "tenant_display_name", tenant_display_name)
        pulumi.set(__self__, "tenant_identifier", tenant_identifier)

    @_builtins.property
    @pulumi.getter(name="tenantDisplayName")
    def tenant_display_name(self) -> _builtins.str:
        """
        The display name of the tenant.
        """
        return pulumi.get(self, "tenant_display_name")

    @_builtins.property
    @pulumi.getter(name="tenantIdentifier")
    def tenant_identifier(self) -> _builtins.str:
        """
        The ID of the application tenant.
        """
        return pulumi.get(self, "tenant_identifier")


@pulumi.output_type
class AppAuthorizationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class IngestionDestinationDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLog":
            suggest = "audit_log"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestionDestinationDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestionDestinationDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestionDestinationDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log: Optional['outputs.IngestionDestinationDestinationConfigurationAuditLog'] = None):
        """
        :param 'IngestionDestinationDestinationConfigurationAuditLogArgs' audit_log: Contains information about an audit log processing configuration.
        """
        if audit_log is not None:
            pulumi.set(__self__, "audit_log", audit_log)

    @_builtins.property
    @pulumi.getter(name="auditLog")
    def audit_log(self) -> Optional['outputs.IngestionDestinationDestinationConfigurationAuditLog']:
        """
        Contains information about an audit log processing configuration.
        """
        return pulumi.get(self, "audit_log")


@pulumi.output_type
class IngestionDestinationDestinationConfigurationAuditLog(dict):
    def __init__(__self__, *,
                 destination: Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestination'] = None):
        """
        :param 'IngestionDestinationDestinationConfigurationAuditLogDestinationArgs' destination: Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestination']:
        """
        Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class IngestionDestinationDestinationConfigurationAuditLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "firehoseStream":
            suggest = "firehose_stream"
        elif key == "s3Bucket":
            suggest = "s3_bucket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestionDestinationDestinationConfigurationAuditLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 firehose_stream: Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream'] = None,
                 s3_bucket: Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket'] = None):
        """
        :param 'IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgs' firehose_stream: Contains information about an Amazon Data Firehose delivery stream.
        :param 'IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs' s3_bucket: Contains information about an Amazon S3 bucket.
        """
        if firehose_stream is not None:
            pulumi.set(__self__, "firehose_stream", firehose_stream)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)

    @_builtins.property
    @pulumi.getter(name="firehoseStream")
    def firehose_stream(self) -> Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream']:
        """
        Contains information about an Amazon Data Firehose delivery stream.
        """
        return pulumi.get(self, "firehose_stream")

    @_builtins.property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional['outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket']:
        """
        Contains information about an Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket")


@pulumi.output_type
class IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamName":
            suggest = "stream_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_name: _builtins.str):
        pulumi.set(__self__, "stream_name", stream_name)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> _builtins.str:
        return pulumi.get(self, "stream_name")


@pulumi.output_type
class IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str prefix: The object key to use.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[_builtins.str]:
        """
        The object key to use.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class IngestionDestinationProcessingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLog":
            suggest = "audit_log"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IngestionDestinationProcessingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IngestionDestinationProcessingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IngestionDestinationProcessingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log: Optional['outputs.IngestionDestinationProcessingConfigurationAuditLog'] = None):
        """
        :param 'IngestionDestinationProcessingConfigurationAuditLogArgs' audit_log: Contains information about an audit log processing configuration.
        """
        if audit_log is not None:
            pulumi.set(__self__, "audit_log", audit_log)

    @_builtins.property
    @pulumi.getter(name="auditLog")
    def audit_log(self) -> Optional['outputs.IngestionDestinationProcessingConfigurationAuditLog']:
        """
        Contains information about an audit log processing configuration.
        """
        return pulumi.get(self, "audit_log")


@pulumi.output_type
class IngestionDestinationProcessingConfigurationAuditLog(dict):
    def __init__(__self__, *,
                 format: _builtins.str,
                 schema: _builtins.str):
        """
        :param _builtins.str format: The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
        :param _builtins.str schema: The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class IngestionDestinationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


