# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 compute_capacity: pulumi.Input['FleetComputeCapacityArgs'],
                 instance_type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input['FleetDomainJoinInfoArgs']] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sessions_per_instance: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_view: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['FleetVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input['FleetComputeCapacityArgs'] compute_capacity: Configuration block for the desired capacity of the fleet. See below.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching fleet instances.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.int] disconnect_timeout_in_seconds: Amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream fleet.
        :param pulumi.Input['FleetDomainJoinInfoArgs'] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the fleet.
        :param pulumi.Input[_builtins.str] fleet_type: Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the fleet.
        :param pulumi.Input[_builtins.int] idle_disconnect_timeout_in_seconds: Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the fleet.
        :param pulumi.Input[_builtins.int] max_sessions_per_instance: The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        :param pulumi.Input[_builtins.int] max_user_duration_in_seconds: Maximum amount of time that a streaming session can remain active, in seconds.
        :param pulumi.Input[_builtins.str] name: Unique name for the fleet.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] stream_view: AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to attach to AppStream instances.
        :param pulumi.Input['FleetVpcConfigArgs'] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        pulumi.set(__self__, "compute_capacity", compute_capacity)
        pulumi.set(__self__, "instance_type", instance_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disconnect_timeout_in_seconds is not None:
            pulumi.set(__self__, "disconnect_timeout_in_seconds", disconnect_timeout_in_seconds)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_join_info is not None:
            pulumi.set(__self__, "domain_join_info", domain_join_info)
        if enable_default_internet_access is not None:
            pulumi.set(__self__, "enable_default_internet_access", enable_default_internet_access)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if idle_disconnect_timeout_in_seconds is not None:
            pulumi.set(__self__, "idle_disconnect_timeout_in_seconds", idle_disconnect_timeout_in_seconds)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if max_sessions_per_instance is not None:
            pulumi.set(__self__, "max_sessions_per_instance", max_sessions_per_instance)
        if max_user_duration_in_seconds is not None:
            pulumi.set(__self__, "max_user_duration_in_seconds", max_user_duration_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stream_view is not None:
            pulumi.set(__self__, "stream_view", stream_view)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter(name="computeCapacity")
    def compute_capacity(self) -> pulumi.Input['FleetComputeCapacityArgs']:
        """
        Configuration block for the desired capacity of the fleet. See below.
        """
        return pulumi.get(self, "compute_capacity")

    @compute_capacity.setter
    def compute_capacity(self, value: pulumi.Input['FleetComputeCapacityArgs']):
        pulumi.set(self, "compute_capacity", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        Instance type to use when launching fleet instances.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disconnectTimeoutInSeconds")
    def disconnect_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time that a streaming session remains active after users disconnect.
        """
        return pulumi.get(self, "disconnect_timeout_in_seconds")

    @disconnect_timeout_in_seconds.setter
    def disconnect_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disconnect_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable friendly name for the AppStream fleet.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> Optional[pulumi.Input['FleetDomainJoinInfoArgs']]:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @domain_join_info.setter
    def domain_join_info(self, value: Optional[pulumi.Input['FleetDomainJoinInfoArgs']]):
        pulumi.set(self, "domain_join_info", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables default internet access for the fleet.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @enable_default_internet_access.setter
    def enable_default_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to apply to the fleet.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="idleDisconnectTimeoutInSeconds")
    def idle_disconnect_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_seconds")

    @idle_disconnect_timeout_in_seconds.setter
    def idle_disconnect_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_disconnect_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image used to create the fleet.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="maxSessionsPerInstance")
    def max_sessions_per_instance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        """
        return pulumi.get(self, "max_sessions_per_instance")

    @max_sessions_per_instance.setter
    def max_sessions_per_instance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_sessions_per_instance", value)

    @_builtins.property
    @pulumi.getter(name="maxUserDurationInSeconds")
    def max_user_duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount of time that a streaming session can remain active, in seconds.
        """
        return pulumi.get(self, "max_user_duration_in_seconds")

    @max_user_duration_in_seconds.setter
    def max_user_duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_user_duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the fleet.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="streamView")
    def stream_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        """
        return pulumi.get(self, "stream_view")

    @stream_view.setter
    def stream_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_view", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to attach to AppStream instances.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FleetVpcConfigArgs']]:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FleetVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_capacity: Optional[pulumi.Input['FleetComputeCapacityArgs']] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input['FleetDomainJoinInfoArgs']] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sessions_per_instance: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_view: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['FleetVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream fleet.
        :param pulumi.Input['FleetComputeCapacityArgs'] compute_capacity: Configuration block for the desired capacity of the fleet. See below.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the fleet was created.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.int] disconnect_timeout_in_seconds: Amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream fleet.
        :param pulumi.Input['FleetDomainJoinInfoArgs'] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the fleet.
        :param pulumi.Input[_builtins.str] fleet_type: Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the fleet.
        :param pulumi.Input[_builtins.int] idle_disconnect_timeout_in_seconds: Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the fleet.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching fleet instances.
        :param pulumi.Input[_builtins.int] max_sessions_per_instance: The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        :param pulumi.Input[_builtins.int] max_user_duration_in_seconds: Maximum amount of time that a streaming session can remain active, in seconds.
        :param pulumi.Input[_builtins.str] name: Unique name for the fleet.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] state: State of the fleet. Can be `STARTING`, `RUNNING`, `STOPPING` or `STOPPED`
        :param pulumi.Input[_builtins.str] stream_view: AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to attach to AppStream instances.
        :param pulumi.Input['FleetVpcConfigArgs'] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if compute_capacity is not None:
            pulumi.set(__self__, "compute_capacity", compute_capacity)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disconnect_timeout_in_seconds is not None:
            pulumi.set(__self__, "disconnect_timeout_in_seconds", disconnect_timeout_in_seconds)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_join_info is not None:
            pulumi.set(__self__, "domain_join_info", domain_join_info)
        if enable_default_internet_access is not None:
            pulumi.set(__self__, "enable_default_internet_access", enable_default_internet_access)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if iam_role_arn is not None:
            pulumi.set(__self__, "iam_role_arn", iam_role_arn)
        if idle_disconnect_timeout_in_seconds is not None:
            pulumi.set(__self__, "idle_disconnect_timeout_in_seconds", idle_disconnect_timeout_in_seconds)
        if image_arn is not None:
            pulumi.set(__self__, "image_arn", image_arn)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if max_sessions_per_instance is not None:
            pulumi.set(__self__, "max_sessions_per_instance", max_sessions_per_instance)
        if max_user_duration_in_seconds is not None:
            pulumi.set(__self__, "max_user_duration_in_seconds", max_user_duration_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_view is not None:
            pulumi.set(__self__, "stream_view", stream_view)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the appstream fleet.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="computeCapacity")
    def compute_capacity(self) -> Optional[pulumi.Input['FleetComputeCapacityArgs']]:
        """
        Configuration block for the desired capacity of the fleet. See below.
        """
        return pulumi.get(self, "compute_capacity")

    @compute_capacity.setter
    def compute_capacity(self, value: Optional[pulumi.Input['FleetComputeCapacityArgs']]):
        pulumi.set(self, "compute_capacity", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the fleet was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="disconnectTimeoutInSeconds")
    def disconnect_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time that a streaming session remains active after users disconnect.
        """
        return pulumi.get(self, "disconnect_timeout_in_seconds")

    @disconnect_timeout_in_seconds.setter
    def disconnect_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disconnect_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable friendly name for the AppStream fleet.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> Optional[pulumi.Input['FleetDomainJoinInfoArgs']]:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @domain_join_info.setter
    def domain_join_info(self, value: Optional[pulumi.Input['FleetDomainJoinInfoArgs']]):
        pulumi.set(self, "domain_join_info", value)

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables default internet access for the fleet.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @enable_default_internet_access.setter
    def enable_default_internet_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_default_internet_access", value)

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the IAM role to apply to the fleet.
        """
        return pulumi.get(self, "iam_role_arn")

    @iam_role_arn.setter
    def iam_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_role_arn", value)

    @_builtins.property
    @pulumi.getter(name="idleDisconnectTimeoutInSeconds")
    def idle_disconnect_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_seconds")

    @idle_disconnect_timeout_in_seconds.setter
    def idle_disconnect_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_disconnect_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @image_arn.setter
    def image_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_arn", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the image used to create the fleet.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance type to use when launching fleet instances.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="maxSessionsPerInstance")
    def max_sessions_per_instance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        """
        return pulumi.get(self, "max_sessions_per_instance")

    @max_sessions_per_instance.setter
    def max_sessions_per_instance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_sessions_per_instance", value)

    @_builtins.property
    @pulumi.getter(name="maxUserDurationInSeconds")
    def max_user_duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum amount of time that a streaming session can remain active, in seconds.
        """
        return pulumi.get(self, "max_user_duration_in_seconds")

    @max_user_duration_in_seconds.setter
    def max_user_duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_user_duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the fleet.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the fleet. Can be `STARTING`, `RUNNING`, `STOPPING` or `STOPPED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="streamView")
    def stream_view(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        """
        return pulumi.get(self, "stream_view")

    @stream_view.setter
    def stream_view(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_view", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to attach to AppStream instances.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['FleetVpcConfigArgs']]:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['FleetVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("aws:appstream/fleet:Fleet")
class Fleet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_capacity: Optional[pulumi.Input[Union['FleetComputeCapacityArgs', 'FleetComputeCapacityArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['FleetDomainJoinInfoArgs', 'FleetDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sessions_per_instance: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_view: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides an AppStream fleet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_fleet = aws.appstream.Fleet("test_fleet",
            name="test-fleet",
            compute_capacity={
                "desired_instances": 1,
            },
            description="test fleet",
            idle_disconnect_timeout_in_seconds=60,
            display_name="test-fleet",
            enable_default_internet_access=False,
            fleet_type="ON_DEMAND",
            image_name="Amazon-AppStream2-Sample-Image-03-11-2023",
            instance_type="stream.standard.large",
            max_user_duration_in_seconds=600,
            vpc_config={
                "subnet_ids": ["subnet-06e9b13400c225127"],
            },
            tags={
                "TagName": "tag-value",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_fleet` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/fleet:Fleet example fleetNameExample
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FleetComputeCapacityArgs', 'FleetComputeCapacityArgsDict']] compute_capacity: Configuration block for the desired capacity of the fleet. See below.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.int] disconnect_timeout_in_seconds: Amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream fleet.
        :param pulumi.Input[Union['FleetDomainJoinInfoArgs', 'FleetDomainJoinInfoArgsDict']] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the fleet.
        :param pulumi.Input[_builtins.str] fleet_type: Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the fleet.
        :param pulumi.Input[_builtins.int] idle_disconnect_timeout_in_seconds: Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the fleet.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching fleet instances.
        :param pulumi.Input[_builtins.int] max_sessions_per_instance: The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        :param pulumi.Input[_builtins.int] max_user_duration_in_seconds: Maximum amount of time that a streaming session can remain active, in seconds.
        :param pulumi.Input[_builtins.str] name: Unique name for the fleet.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] stream_view: AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to attach to AppStream instances.
        :param pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream fleet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test_fleet = aws.appstream.Fleet("test_fleet",
            name="test-fleet",
            compute_capacity={
                "desired_instances": 1,
            },
            description="test fleet",
            idle_disconnect_timeout_in_seconds=60,
            display_name="test-fleet",
            enable_default_internet_access=False,
            fleet_type="ON_DEMAND",
            image_name="Amazon-AppStream2-Sample-Image-03-11-2023",
            instance_type="stream.standard.large",
            max_user_duration_in_seconds=600,
            vpc_config={
                "subnet_ids": ["subnet-06e9b13400c225127"],
            },
            tags={
                "TagName": "tag-value",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_fleet` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/fleet:Fleet example fleetNameExample
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_capacity: Optional[pulumi.Input[Union['FleetComputeCapacityArgs', 'FleetComputeCapacityArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_join_info: Optional[pulumi.Input[Union['FleetDomainJoinInfoArgs', 'FleetDomainJoinInfoArgsDict']]] = None,
                 enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
                 iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 idle_disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 image_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_sessions_per_instance: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_view: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            if compute_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'compute_capacity'")
            __props__.__dict__["compute_capacity"] = compute_capacity
            __props__.__dict__["description"] = description
            __props__.__dict__["disconnect_timeout_in_seconds"] = disconnect_timeout_in_seconds
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["domain_join_info"] = domain_join_info
            __props__.__dict__["enable_default_internet_access"] = enable_default_internet_access
            __props__.__dict__["fleet_type"] = fleet_type
            __props__.__dict__["iam_role_arn"] = iam_role_arn
            __props__.__dict__["idle_disconnect_timeout_in_seconds"] = idle_disconnect_timeout_in_seconds
            __props__.__dict__["image_arn"] = image_arn
            __props__.__dict__["image_name"] = image_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["max_sessions_per_instance"] = max_sessions_per_instance
            __props__.__dict__["max_user_duration_in_seconds"] = max_user_duration_in_seconds
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["stream_view"] = stream_view
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tags_all"] = None
        super(Fleet, __self__).__init__(
            'aws:appstream/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            compute_capacity: Optional[pulumi.Input[Union['FleetComputeCapacityArgs', 'FleetComputeCapacityArgsDict']]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_join_info: Optional[pulumi.Input[Union['FleetDomainJoinInfoArgs', 'FleetDomainJoinInfoArgsDict']]] = None,
            enable_default_internet_access: Optional[pulumi.Input[_builtins.bool]] = None,
            fleet_type: Optional[pulumi.Input[_builtins.str]] = None,
            iam_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            idle_disconnect_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            image_arn: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            max_sessions_per_instance: Optional[pulumi.Input[_builtins.int]] = None,
            max_user_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            stream_view: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_config: Optional[pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream fleet.
        :param pulumi.Input[Union['FleetComputeCapacityArgs', 'FleetComputeCapacityArgsDict']] compute_capacity: Configuration block for the desired capacity of the fleet. See below.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the fleet was created.
        :param pulumi.Input[_builtins.str] description: Description to display.
        :param pulumi.Input[_builtins.int] disconnect_timeout_in_seconds: Amount of time that a streaming session remains active after users disconnect.
        :param pulumi.Input[_builtins.str] display_name: Human-readable friendly name for the AppStream fleet.
        :param pulumi.Input[Union['FleetDomainJoinInfoArgs', 'FleetDomainJoinInfoArgsDict']] domain_join_info: Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        :param pulumi.Input[_builtins.bool] enable_default_internet_access: Enables or disables default internet access for the fleet.
        :param pulumi.Input[_builtins.str] fleet_type: Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        :param pulumi.Input[_builtins.str] iam_role_arn: ARN of the IAM role to apply to the fleet.
        :param pulumi.Input[_builtins.int] idle_disconnect_timeout_in_seconds: Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        :param pulumi.Input[_builtins.str] image_arn: ARN of the public, private, or shared image to use.
        :param pulumi.Input[_builtins.str] image_name: Name of the image used to create the fleet.
        :param pulumi.Input[_builtins.str] instance_type: Instance type to use when launching fleet instances.
        :param pulumi.Input[_builtins.int] max_sessions_per_instance: The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        :param pulumi.Input[_builtins.int] max_user_duration_in_seconds: Maximum amount of time that a streaming session can remain active, in seconds.
        :param pulumi.Input[_builtins.str] name: Unique name for the fleet.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] state: State of the fleet. Can be `STARTING`, `RUNNING`, `STOPPING` or `STOPPED`
        :param pulumi.Input[_builtins.str] stream_view: AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to attach to AppStream instances.
        :param pulumi.Input[Union['FleetVpcConfigArgs', 'FleetVpcConfigArgsDict']] vpc_config: Configuration block for the VPC configuration for the image builder. See below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["compute_capacity"] = compute_capacity
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["disconnect_timeout_in_seconds"] = disconnect_timeout_in_seconds
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_join_info"] = domain_join_info
        __props__.__dict__["enable_default_internet_access"] = enable_default_internet_access
        __props__.__dict__["fleet_type"] = fleet_type
        __props__.__dict__["iam_role_arn"] = iam_role_arn
        __props__.__dict__["idle_disconnect_timeout_in_seconds"] = idle_disconnect_timeout_in_seconds
        __props__.__dict__["image_arn"] = image_arn
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["max_sessions_per_instance"] = max_sessions_per_instance
        __props__.__dict__["max_user_duration_in_seconds"] = max_user_duration_in_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_view"] = stream_view
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_config"] = vpc_config
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the appstream fleet.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="computeCapacity")
    def compute_capacity(self) -> pulumi.Output['outputs.FleetComputeCapacity']:
        """
        Configuration block for the desired capacity of the fleet. See below.
        """
        return pulumi.get(self, "compute_capacity")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the fleet was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description to display.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="disconnectTimeoutInSeconds")
    def disconnect_timeout_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Amount of time that a streaming session remains active after users disconnect.
        """
        return pulumi.get(self, "disconnect_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Human-readable friendly name for the AppStream fleet.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="domainJoinInfo")
    def domain_join_info(self) -> pulumi.Output['outputs.FleetDomainJoinInfo']:
        """
        Configuration block for the name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory domain. See below.
        """
        return pulumi.get(self, "domain_join_info")

    @_builtins.property
    @pulumi.getter(name="enableDefaultInternetAccess")
    def enable_default_internet_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables or disables default internet access for the fleet.
        """
        return pulumi.get(self, "enable_default_internet_access")

    @_builtins.property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Output[_builtins.str]:
        """
        Fleet type. Valid values are: `ON_DEMAND`, `ALWAYS_ON`
        """
        return pulumi.get(self, "fleet_type")

    @_builtins.property
    @pulumi.getter(name="iamRoleArn")
    def iam_role_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the IAM role to apply to the fleet.
        """
        return pulumi.get(self, "iam_role_arn")

    @_builtins.property
    @pulumi.getter(name="idleDisconnectTimeoutInSeconds")
    def idle_disconnect_timeout_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Amount of time that users can be idle (inactive) before they are disconnected from their streaming session and the `disconnect_timeout_in_seconds` time interval begins. Defaults to `0`. Valid value is between `60` and `3600 `seconds.
        """
        return pulumi.get(self, "idle_disconnect_timeout_in_seconds")

    @_builtins.property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the public, private, or shared image to use.
        """
        return pulumi.get(self, "image_arn")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the image used to create the fleet.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        Instance type to use when launching fleet instances.
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="maxSessionsPerInstance")
    def max_sessions_per_instance(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of user sessions on an instance. This only applies to multi-session fleets.
        """
        return pulumi.get(self, "max_sessions_per_instance")

    @_builtins.property
    @pulumi.getter(name="maxUserDurationInSeconds")
    def max_user_duration_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum amount of time that a streaming session can remain active, in seconds.
        """
        return pulumi.get(self, "max_user_duration_in_seconds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name for the fleet.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the fleet. Can be `STARTING`, `RUNNING`, `STOPPING` or `STOPPED`
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamView")
    def stream_view(self) -> pulumi.Output[_builtins.str]:
        """
        AppStream 2.0 view that is displayed to your users when they stream from the fleet. When `APP` is specified, only the windows of applications opened by users display. When `DESKTOP` is specified, the standard desktop that is provided by the operating system displays. If not specified, defaults to `APP`.
        """
        return pulumi.get(self, "stream_view")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to attach to AppStream instances.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output['outputs.FleetVpcConfig']:
        """
        Configuration block for the VPC configuration for the image builder. See below.
        """
        return pulumi.get(self, "vpc_config")

