# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StackArgs', 'Stack']

@pulumi.input_type
class StackArgs:
    def __init__(__self__, *,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]] = None,
                 application_settings: Optional[pulumi.Input['StackApplicationSettingsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feedback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]] = None,
                 streaming_experience_settings: Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]] = None):
        """
        The set of arguments for constructing a Stack resource.
        :param pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]] access_endpoints: Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
               See `access_endpoints` below.
        :param pulumi.Input['StackApplicationSettingsArgs'] application_settings: Settings for application settings persistence.
               See `application_settings` below.
        :param pulumi.Input[_builtins.str] description: Description for the AppStream stack.
        :param pulumi.Input[_builtins.str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[_builtins.str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[_builtins.str] name: Unique name for the AppStream stack.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]] storage_connectors: Configuration block for the storage connectors to enable.
               See `storage_connectors` below.
        :param pulumi.Input['StackStreamingExperienceSettingsArgs'] streaming_experience_settings: The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
               See `streaming_experience_settings` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
               See `user_settings` below.
        """
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if embed_host_domains is not None:
            pulumi.set(__self__, "embed_host_domains", embed_host_domains)
        if feedback_url is not None:
            pulumi.set(__self__, "feedback_url", feedback_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_connectors is not None:
            pulumi.set(__self__, "storage_connectors", storage_connectors)
        if streaming_experience_settings is not None:
            pulumi.set(__self__, "streaming_experience_settings", streaming_experience_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_settings is not None:
            pulumi.set(__self__, "user_settings", user_settings)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]:
        """
        Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
        See `access_endpoints` below.
        """
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['StackApplicationSettingsArgs']]:
        """
        Settings for application settings persistence.
        See `application_settings` below.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['StackApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @embed_host_domains.setter
    def embed_host_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "embed_host_domains", value)

    @_builtins.property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @feedback_url.setter
    def feedback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feedback_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the AppStream stack.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]:
        """
        Configuration block for the storage connectors to enable.
        See `storage_connectors` below.
        """
        return pulumi.get(self, "storage_connectors")

    @storage_connectors.setter
    def storage_connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]):
        pulumi.set(self, "storage_connectors", value)

    @_builtins.property
    @pulumi.getter(name="streamingExperienceSettings")
    def streaming_experience_settings(self) -> Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']]:
        """
        The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
        See `streaming_experience_settings` below.
        """
        return pulumi.get(self, "streaming_experience_settings")

    @streaming_experience_settings.setter
    def streaming_experience_settings(self, value: Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']]):
        pulumi.set(self, "streaming_experience_settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
        See `user_settings` below.
        """
        return pulumi.get(self, "user_settings")

    @user_settings.setter
    def user_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]):
        pulumi.set(self, "user_settings", value)


@pulumi.input_type
class _StackState:
    def __init__(__self__, *,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]] = None,
                 application_settings: Optional[pulumi.Input['StackApplicationSettingsArgs']] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feedback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]] = None,
                 streaming_experience_settings: Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]] = None):
        """
        Input properties used for looking up and filtering Stack resources.
        :param pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]] access_endpoints: Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
               See `access_endpoints` below.
        :param pulumi.Input['StackApplicationSettingsArgs'] application_settings: Settings for application settings persistence.
               See `application_settings` below.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream stack.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        :param pulumi.Input[_builtins.str] description: Description for the AppStream stack.
        :param pulumi.Input[_builtins.str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[_builtins.str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[_builtins.str] name: Unique name for the AppStream stack.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]] storage_connectors: Configuration block for the storage connectors to enable.
               See `storage_connectors` below.
        :param pulumi.Input['StackStreamingExperienceSettingsArgs'] streaming_experience_settings: The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
               See `streaming_experience_settings` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
               See `user_settings` below.
        """
        if access_endpoints is not None:
            pulumi.set(__self__, "access_endpoints", access_endpoints)
        if application_settings is not None:
            pulumi.set(__self__, "application_settings", application_settings)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_time is not None:
            pulumi.set(__self__, "created_time", created_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if embed_host_domains is not None:
            pulumi.set(__self__, "embed_host_domains", embed_host_domains)
        if feedback_url is not None:
            pulumi.set(__self__, "feedback_url", feedback_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_connectors is not None:
            pulumi.set(__self__, "storage_connectors", storage_connectors)
        if streaming_experience_settings is not None:
            pulumi.set(__self__, "streaming_experience_settings", streaming_experience_settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if user_settings is not None:
            pulumi.set(__self__, "user_settings", user_settings)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]:
        """
        Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
        See `access_endpoints` below.
        """
        return pulumi.get(self, "access_endpoints")

    @access_endpoints.setter
    def access_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackAccessEndpointArgs']]]]):
        pulumi.set(self, "access_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> Optional[pulumi.Input['StackApplicationSettingsArgs']]:
        """
        Settings for application settings persistence.
        See `application_settings` below.
        """
        return pulumi.get(self, "application_settings")

    @application_settings.setter
    def application_settings(self, value: Optional[pulumi.Input['StackApplicationSettingsArgs']]):
        pulumi.set(self, "application_settings", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the appstream stack.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        """
        return pulumi.get(self, "created_time")

    @created_time.setter
    def created_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @embed_host_domains.setter
    def embed_host_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "embed_host_domains", value)

    @_builtins.property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @feedback_url.setter
    def feedback_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feedback_url", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique name for the AppStream stack.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]:
        """
        Configuration block for the storage connectors to enable.
        See `storage_connectors` below.
        """
        return pulumi.get(self, "storage_connectors")

    @storage_connectors.setter
    def storage_connectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackStorageConnectorArgs']]]]):
        pulumi.set(self, "storage_connectors", value)

    @_builtins.property
    @pulumi.getter(name="streamingExperienceSettings")
    def streaming_experience_settings(self) -> Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']]:
        """
        The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
        See `streaming_experience_settings` below.
        """
        return pulumi.get(self, "streaming_experience_settings")

    @streaming_experience_settings.setter
    def streaming_experience_settings(self, value: Optional[pulumi.Input['StackStreamingExperienceSettingsArgs']]):
        pulumi.set(self, "streaming_experience_settings", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
        See `user_settings` below.
        """
        return pulumi.get(self, "user_settings")

    @user_settings.setter
    def user_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StackUserSettingArgs']]]]):
        pulumi.set(self, "user_settings", value)


@pulumi.type_token("aws:appstream/stack:Stack")
class Stack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackAccessEndpointArgs', 'StackAccessEndpointArgsDict']]]]] = None,
                 application_settings: Optional[pulumi.Input[Union['StackApplicationSettingsArgs', 'StackApplicationSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feedback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackStorageConnectorArgs', 'StackStorageConnectorArgsDict']]]]] = None,
                 streaming_experience_settings: Optional[pulumi.Input[Union['StackStreamingExperienceSettingsArgs', 'StackStreamingExperienceSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackUserSettingArgs', 'StackUserSettingArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides an AppStream stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Stack("example",
            name="stack name",
            description="stack description",
            display_name="stack display name",
            feedback_url="http://your-domain/feedback",
            redirect_url="http://your-domain/redirect",
            storage_connectors=[{
                "connector_type": "HOMEFOLDERS",
            }],
            user_settings=[
                {
                    "action": "AUTO_TIME_ZONE_REDIRECTION",
                    "permission": "DISABLED",
                },
                {
                    "action": "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
                {
                    "action": "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
                {
                    "action": "DOMAIN_PASSWORD_SIGNIN",
                    "permission": "ENABLED",
                },
                {
                    "action": "DOMAIN_SMART_CARD_SIGNIN",
                    "permission": "DISABLED",
                },
                {
                    "action": "FILE_DOWNLOAD",
                    "permission": "ENABLED",
                },
                {
                    "action": "FILE_UPLOAD",
                    "permission": "ENABLED",
                },
                {
                    "action": "PRINTING_TO_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
            ],
            application_settings={
                "enabled": True,
                "settings_group": "SettingsGroup",
            },
            tags={
                "TagName": "TagValue",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_stack` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/stack:Stack example stackID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackAccessEndpointArgs', 'StackAccessEndpointArgsDict']]]] access_endpoints: Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
               See `access_endpoints` below.
        :param pulumi.Input[Union['StackApplicationSettingsArgs', 'StackApplicationSettingsArgsDict']] application_settings: Settings for application settings persistence.
               See `application_settings` below.
        :param pulumi.Input[_builtins.str] description: Description for the AppStream stack.
        :param pulumi.Input[_builtins.str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[_builtins.str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[_builtins.str] name: Unique name for the AppStream stack.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackStorageConnectorArgs', 'StackStorageConnectorArgsDict']]]] storage_connectors: Configuration block for the storage connectors to enable.
               See `storage_connectors` below.
        :param pulumi.Input[Union['StackStreamingExperienceSettingsArgs', 'StackStreamingExperienceSettingsArgsDict']] streaming_experience_settings: The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
               See `streaming_experience_settings` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackUserSettingArgs', 'StackUserSettingArgsDict']]]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
               See `user_settings` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StackArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppStream stack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appstream.Stack("example",
            name="stack name",
            description="stack description",
            display_name="stack display name",
            feedback_url="http://your-domain/feedback",
            redirect_url="http://your-domain/redirect",
            storage_connectors=[{
                "connector_type": "HOMEFOLDERS",
            }],
            user_settings=[
                {
                    "action": "AUTO_TIME_ZONE_REDIRECTION",
                    "permission": "DISABLED",
                },
                {
                    "action": "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
                {
                    "action": "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
                {
                    "action": "DOMAIN_PASSWORD_SIGNIN",
                    "permission": "ENABLED",
                },
                {
                    "action": "DOMAIN_SMART_CARD_SIGNIN",
                    "permission": "DISABLED",
                },
                {
                    "action": "FILE_DOWNLOAD",
                    "permission": "ENABLED",
                },
                {
                    "action": "FILE_UPLOAD",
                    "permission": "ENABLED",
                },
                {
                    "action": "PRINTING_TO_LOCAL_DEVICE",
                    "permission": "ENABLED",
                },
            ],
            application_settings={
                "enabled": True,
                "settings_group": "SettingsGroup",
            },
            tags={
                "TagName": "TagValue",
            })
        ```

        ## Import

        Using `pulumi import`, import `aws_appstream_stack` using the id. For example:

        ```sh
        $ pulumi import aws:appstream/stack:Stack example stackID
        ```

        :param str resource_name: The name of the resource.
        :param StackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackAccessEndpointArgs', 'StackAccessEndpointArgsDict']]]]] = None,
                 application_settings: Optional[pulumi.Input[Union['StackApplicationSettingsArgs', 'StackApplicationSettingsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feedback_url: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackStorageConnectorArgs', 'StackStorageConnectorArgsDict']]]]] = None,
                 streaming_experience_settings: Optional[pulumi.Input[Union['StackStreamingExperienceSettingsArgs', 'StackStreamingExperienceSettingsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackUserSettingArgs', 'StackUserSettingArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StackArgs.__new__(StackArgs)

            __props__.__dict__["access_endpoints"] = access_endpoints
            __props__.__dict__["application_settings"] = application_settings
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["embed_host_domains"] = embed_host_domains
            __props__.__dict__["feedback_url"] = feedback_url
            __props__.__dict__["name"] = name
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["region"] = region
            __props__.__dict__["storage_connectors"] = storage_connectors
            __props__.__dict__["streaming_experience_settings"] = streaming_experience_settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_settings"] = user_settings
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["tags_all"] = None
        super(Stack, __self__).__init__(
            'aws:appstream/stack:Stack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackAccessEndpointArgs', 'StackAccessEndpointArgsDict']]]]] = None,
            application_settings: Optional[pulumi.Input[Union['StackApplicationSettingsArgs', 'StackApplicationSettingsArgsDict']]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            embed_host_domains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            feedback_url: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            storage_connectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackStorageConnectorArgs', 'StackStorageConnectorArgsDict']]]]] = None,
            streaming_experience_settings: Optional[pulumi.Input[Union['StackStreamingExperienceSettingsArgs', 'StackStreamingExperienceSettingsArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StackUserSettingArgs', 'StackUserSettingArgsDict']]]]] = None) -> 'Stack':
        """
        Get an existing Stack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackAccessEndpointArgs', 'StackAccessEndpointArgsDict']]]] access_endpoints: Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
               See `access_endpoints` below.
        :param pulumi.Input[Union['StackApplicationSettingsArgs', 'StackApplicationSettingsArgsDict']] application_settings: Settings for application settings persistence.
               See `application_settings` below.
        :param pulumi.Input[_builtins.str] arn: ARN of the appstream stack.
        :param pulumi.Input[_builtins.str] created_time: Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        :param pulumi.Input[_builtins.str] description: Description for the AppStream stack.
        :param pulumi.Input[_builtins.str] display_name: Stack name to display.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] embed_host_domains: Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        :param pulumi.Input[_builtins.str] feedback_url: URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        :param pulumi.Input[_builtins.str] name: Unique name for the AppStream stack.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] redirect_url: URL that users are redirected to after their streaming session ends.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackStorageConnectorArgs', 'StackStorageConnectorArgsDict']]]] storage_connectors: Configuration block for the storage connectors to enable.
               See `storage_connectors` below.
        :param pulumi.Input[Union['StackStreamingExperienceSettingsArgs', 'StackStreamingExperienceSettingsArgsDict']] streaming_experience_settings: The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
               See `streaming_experience_settings` below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StackUserSettingArgs', 'StackUserSettingArgsDict']]]] user_settings: Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
               See `user_settings` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StackState.__new__(_StackState)

        __props__.__dict__["access_endpoints"] = access_endpoints
        __props__.__dict__["application_settings"] = application_settings
        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_time"] = created_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["embed_host_domains"] = embed_host_domains
        __props__.__dict__["feedback_url"] = feedback_url
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_connectors"] = storage_connectors
        __props__.__dict__["streaming_experience_settings"] = streaming_experience_settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["user_settings"] = user_settings
        return Stack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessEndpoints")
    def access_endpoints(self) -> pulumi.Output[Sequence['outputs.StackAccessEndpoint']]:
        """
        Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
        See `access_endpoints` below.
        """
        return pulumi.get(self, "access_endpoints")

    @_builtins.property
    @pulumi.getter(name="applicationSettings")
    def application_settings(self) -> pulumi.Output['outputs.StackApplicationSettings']:
        """
        Settings for application settings persistence.
        See `application_settings` below.
        """
        return pulumi.get(self, "application_settings")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the appstream stack.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time, in UTC and extended RFC 3339 format, when the stack was created.
        """
        return pulumi.get(self, "created_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description for the AppStream stack.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Stack name to display.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="embedHostDomains")
    def embed_host_domains(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
        """
        return pulumi.get(self, "embed_host_domains")

    @_builtins.property
    @pulumi.getter(name="feedbackUrl")
    def feedback_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
        """
        return pulumi.get(self, "feedback_url")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Unique name for the AppStream stack.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL that users are redirected to after their streaming session ends.
        """
        return pulumi.get(self, "redirect_url")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageConnectors")
    def storage_connectors(self) -> pulumi.Output[Sequence['outputs.StackStorageConnector']]:
        """
        Configuration block for the storage connectors to enable.
        See `storage_connectors` below.
        """
        return pulumi.get(self, "storage_connectors")

    @_builtins.property
    @pulumi.getter(name="streamingExperienceSettings")
    def streaming_experience_settings(self) -> pulumi.Output['outputs.StackStreamingExperienceSettings']:
        """
        The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
        See `streaming_experience_settings` below.
        """
        return pulumi.get(self, "streaming_experience_settings")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="userSettings")
    def user_settings(self) -> pulumi.Output[Sequence['outputs.StackUserSetting']]:
        """
        Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
        See `user_settings` below.
        """
        return pulumi.get(self, "user_settings")

