# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ChannelNamespaceArgs', 'ChannelNamespace']

@pulumi.input_type
class ChannelNamespaceArgs:
    def __init__(__self__, *,
                 api_id: pulumi.Input[_builtins.str],
                 code_handlers: Optional[pulumi.Input[_builtins.str]] = None,
                 handler_configs: Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscribe_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ChannelNamespace resource.
        :param pulumi.Input[_builtins.str] api_id: Event API ID.
        :param pulumi.Input[_builtins.str] code_handlers: Event handler functions that run custom business logic to process published events and subscribe requests.
        :param pulumi.Input['ChannelNamespaceHandlerConfigsArgs'] handler_configs: Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        :param pulumi.Input[_builtins.str] name: Name of the channel namespace.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]] publish_auth_modes: Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]] subscribe_auth_modes: Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "api_id", api_id)
        if code_handlers is not None:
            pulumi.set(__self__, "code_handlers", code_handlers)
        if handler_configs is not None:
            pulumi.set(__self__, "handler_configs", handler_configs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_auth_modes is not None:
            pulumi.set(__self__, "publish_auth_modes", publish_auth_modes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subscribe_auth_modes is not None:
            pulumi.set(__self__, "subscribe_auth_modes", subscribe_auth_modes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[_builtins.str]:
        """
        Event API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_id", value)

    @_builtins.property
    @pulumi.getter(name="codeHandlers")
    def code_handlers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event handler functions that run custom business logic to process published events and subscribe requests.
        """
        return pulumi.get(self, "code_handlers")

    @code_handlers.setter
    def code_handlers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_handlers", value)

    @_builtins.property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']]:
        """
        Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        """
        return pulumi.get(self, "handler_configs")

    @handler_configs.setter
    def handler_configs(self, value: Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']]):
        pulumi.set(self, "handler_configs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the channel namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publishAuthModes")
    def publish_auth_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]]:
        """
        Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "publish_auth_modes")

    @publish_auth_modes.setter
    def publish_auth_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]]):
        pulumi.set(self, "publish_auth_modes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subscribeAuthModes")
    def subscribe_auth_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]]:
        """
        Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "subscribe_auth_modes")

    @subscribe_auth_modes.setter
    def subscribe_auth_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]]):
        pulumi.set(self, "subscribe_auth_modes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ChannelNamespaceState:
    def __init__(__self__, *,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 channel_namespace_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 code_handlers: Optional[pulumi.Input[_builtins.str]] = None,
                 handler_configs: Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscribe_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ChannelNamespace resources.
        :param pulumi.Input[_builtins.str] api_id: Event API ID.
        :param pulumi.Input[_builtins.str] channel_namespace_arn: ARN of the channel namespace.
        :param pulumi.Input[_builtins.str] code_handlers: Event handler functions that run custom business logic to process published events and subscribe requests.
        :param pulumi.Input['ChannelNamespaceHandlerConfigsArgs'] handler_configs: Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        :param pulumi.Input[_builtins.str] name: Name of the channel namespace.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]] publish_auth_modes: Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]] subscribe_auth_modes: Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if channel_namespace_arn is not None:
            pulumi.set(__self__, "channel_namespace_arn", channel_namespace_arn)
        if code_handlers is not None:
            pulumi.set(__self__, "code_handlers", code_handlers)
        if handler_configs is not None:
            pulumi.set(__self__, "handler_configs", handler_configs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_auth_modes is not None:
            pulumi.set(__self__, "publish_auth_modes", publish_auth_modes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subscribe_auth_modes is not None:
            pulumi.set(__self__, "subscribe_auth_modes", subscribe_auth_modes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_id", value)

    @_builtins.property
    @pulumi.getter(name="channelNamespaceArn")
    def channel_namespace_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the channel namespace.
        """
        return pulumi.get(self, "channel_namespace_arn")

    @channel_namespace_arn.setter
    def channel_namespace_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "channel_namespace_arn", value)

    @_builtins.property
    @pulumi.getter(name="codeHandlers")
    def code_handlers(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Event handler functions that run custom business logic to process published events and subscribe requests.
        """
        return pulumi.get(self, "code_handlers")

    @code_handlers.setter
    def code_handlers(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "code_handlers", value)

    @_builtins.property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']]:
        """
        Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        """
        return pulumi.get(self, "handler_configs")

    @handler_configs.setter
    def handler_configs(self, value: Optional[pulumi.Input['ChannelNamespaceHandlerConfigsArgs']]):
        pulumi.set(self, "handler_configs", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the channel namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publishAuthModes")
    def publish_auth_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]]:
        """
        Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "publish_auth_modes")

    @publish_auth_modes.setter
    def publish_auth_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespacePublishAuthModeArgs']]]]):
        pulumi.set(self, "publish_auth_modes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subscribeAuthModes")
    def subscribe_auth_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]]:
        """
        Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "subscribe_auth_modes")

    @subscribe_auth_modes.setter
    def subscribe_auth_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ChannelNamespaceSubscribeAuthModeArgs']]]]):
        pulumi.set(self, "subscribe_auth_modes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:appsync/channelNamespace:ChannelNamespace")
class ChannelNamespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_handlers: Optional[pulumi.Input[_builtins.str]] = None,
                 handler_configs: Optional[pulumi.Input[Union['ChannelNamespaceHandlerConfigsArgs', 'ChannelNamespaceHandlerConfigsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespacePublishAuthModeArgs', 'ChannelNamespacePublishAuthModeArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscribe_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespaceSubscribeAuthModeArgs', 'ChannelNamespaceSubscribeAuthModeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an [AWS AppSync Channel Namespace](https://docs.aws.amazon.com/appsync/latest/eventapi/event-api-concepts.html#namespace).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.ChannelNamespace("example",
            name="example-channel-namespace",
            api_id=example_aws_appsync_api["apiId"])
        ```

        ## Import

        Using `pulumi import`, import AppSync Channel Namespace using the `api_id` and `name` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:appsync/channelNamespace:ChannelNamespace example example-api-id,example-channel-namespace
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_id: Event API ID.
        :param pulumi.Input[_builtins.str] code_handlers: Event handler functions that run custom business logic to process published events and subscribe requests.
        :param pulumi.Input[Union['ChannelNamespaceHandlerConfigsArgs', 'ChannelNamespaceHandlerConfigsArgsDict']] handler_configs: Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        :param pulumi.Input[_builtins.str] name: Name of the channel namespace.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespacePublishAuthModeArgs', 'ChannelNamespacePublishAuthModeArgsDict']]]] publish_auth_modes: Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespaceSubscribeAuthModeArgs', 'ChannelNamespaceSubscribeAuthModeArgsDict']]]] subscribe_auth_modes: Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelNamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an [AWS AppSync Channel Namespace](https://docs.aws.amazon.com/appsync/latest/eventapi/event-api-concepts.html#namespace).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.ChannelNamespace("example",
            name="example-channel-namespace",
            api_id=example_aws_appsync_api["apiId"])
        ```

        ## Import

        Using `pulumi import`, import AppSync Channel Namespace using the `api_id` and `name` separated by a comma (`,`). For example:

        ```sh
        $ pulumi import aws:appsync/channelNamespace:ChannelNamespace example example-api-id,example-channel-namespace
        ```

        :param str resource_name: The name of the resource.
        :param ChannelNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 code_handlers: Optional[pulumi.Input[_builtins.str]] = None,
                 handler_configs: Optional[pulumi.Input[Union['ChannelNamespaceHandlerConfigsArgs', 'ChannelNamespaceHandlerConfigsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 publish_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespacePublishAuthModeArgs', 'ChannelNamespacePublishAuthModeArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscribe_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespaceSubscribeAuthModeArgs', 'ChannelNamespaceSubscribeAuthModeArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelNamespaceArgs.__new__(ChannelNamespaceArgs)

            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["code_handlers"] = code_handlers
            __props__.__dict__["handler_configs"] = handler_configs
            __props__.__dict__["name"] = name
            __props__.__dict__["publish_auth_modes"] = publish_auth_modes
            __props__.__dict__["region"] = region
            __props__.__dict__["subscribe_auth_modes"] = subscribe_auth_modes
            __props__.__dict__["tags"] = tags
            __props__.__dict__["channel_namespace_arn"] = None
            __props__.__dict__["tags_all"] = None
        super(ChannelNamespace, __self__).__init__(
            'aws:appsync/channelNamespace:ChannelNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_id: Optional[pulumi.Input[_builtins.str]] = None,
            channel_namespace_arn: Optional[pulumi.Input[_builtins.str]] = None,
            code_handlers: Optional[pulumi.Input[_builtins.str]] = None,
            handler_configs: Optional[pulumi.Input[Union['ChannelNamespaceHandlerConfigsArgs', 'ChannelNamespaceHandlerConfigsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            publish_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespacePublishAuthModeArgs', 'ChannelNamespacePublishAuthModeArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            subscribe_auth_modes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespaceSubscribeAuthModeArgs', 'ChannelNamespaceSubscribeAuthModeArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ChannelNamespace':
        """
        Get an existing ChannelNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_id: Event API ID.
        :param pulumi.Input[_builtins.str] channel_namespace_arn: ARN of the channel namespace.
        :param pulumi.Input[_builtins.str] code_handlers: Event handler functions that run custom business logic to process published events and subscribe requests.
        :param pulumi.Input[Union['ChannelNamespaceHandlerConfigsArgs', 'ChannelNamespaceHandlerConfigsArgsDict']] handler_configs: Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        :param pulumi.Input[_builtins.str] name: Name of the channel namespace.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespacePublishAuthModeArgs', 'ChannelNamespacePublishAuthModeArgsDict']]]] publish_auth_modes: Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ChannelNamespaceSubscribeAuthModeArgs', 'ChannelNamespaceSubscribeAuthModeArgsDict']]]] subscribe_auth_modes: Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelNamespaceState.__new__(_ChannelNamespaceState)

        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["channel_namespace_arn"] = channel_namespace_arn
        __props__.__dict__["code_handlers"] = code_handlers
        __props__.__dict__["handler_configs"] = handler_configs
        __props__.__dict__["name"] = name
        __props__.__dict__["publish_auth_modes"] = publish_auth_modes
        __props__.__dict__["region"] = region
        __props__.__dict__["subscribe_auth_modes"] = subscribe_auth_modes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return ChannelNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[_builtins.str]:
        """
        Event API ID.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter(name="channelNamespaceArn")
    def channel_namespace_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the channel namespace.
        """
        return pulumi.get(self, "channel_namespace_arn")

    @_builtins.property
    @pulumi.getter(name="codeHandlers")
    def code_handlers(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Event handler functions that run custom business logic to process published events and subscribe requests.
        """
        return pulumi.get(self, "code_handlers")

    @_builtins.property
    @pulumi.getter(name="handlerConfigs")
    def handler_configs(self) -> pulumi.Output[Optional['outputs.ChannelNamespaceHandlerConfigs']]:
        """
        Configuration for the `on_publish` and `on_subscribe` handlers. See Handler Configs below.
        """
        return pulumi.get(self, "handler_configs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the channel namespace.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publishAuthModes")
    def publish_auth_modes(self) -> pulumi.Output[Optional[Sequence['outputs.ChannelNamespacePublishAuthMode']]]:
        """
        Authorization modes to use for publishing messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "publish_auth_modes")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="subscribeAuthModes")
    def subscribe_auth_modes(self) -> pulumi.Output[Optional[Sequence['outputs.ChannelNamespaceSubscribeAuthMode']]]:
        """
        Authorization modes to use for subscribing to messages on the channel namespace. This configuration overrides the default API authorization configuration. See Auth Modes below.
        """
        return pulumi.get(self, "subscribe_auth_modes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

